// Part of the bug5.exe build.  

#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#include <dos.h>
#include <math.h>
#include <malloc.h>
#pragma hdrstop
#include "random.h"
//-------------------Flags-----------
#define CA_BUG_BLT 1
#define CALEAKER 1 
#define LAMBDA16 1
//#define GRAYMENU 1
//-------------------Constants-----
#define CATYPES 7

#define EIGHTMASK 0xFF
#define FIVEMASK 0x1F
#define FOURMASK 0x0F
#define TWOMASK 0x03
#define ONEMASK 1
#define NOMASK 0
#define CELLS_PER_SLICE 2000
#define MIN_CA_CX 16
#define MIN_CA_CY 16
#ifdef SMALL_CA
	#define START_CA_CX 64
	#define START_CA_CY 64
	#define MAX_CA_CX 240U
	#define MAX_CA_CY 240U // These MUST have a product strictly < 64K.
	//so that CALand_SIZEOF doesn't haver to be long.
	// These also must be multiples of sixteen, or the blts won't
	// work right.
	unsigned short MAX_CALand_SIZEOF = MAX_CA_CX * MAX_CA_CY;
	unsigned char FAR *CAbuffer0;
	unsigned char FAR *CAbuffer1;
	unsigned char FAR *Read_buffer;
	unsigned char FAR *Write_buffer;
#else // not SMALL_CA
	#define START_CA_CX 120
	#define START_CA_CY 80
	short MAX_CA_CX;
	short MAX_CA_CY;
	long MAX_CALand_SIZEOF;
	unsigned char huge *CAbuffer0;
	unsigned char huge *CAbuffer1;
	unsigned char huge *Read_buffer;
	unsigned char huge *Write_buffer;
#endif // not SMALL_CA
//----Load/Save Configuration Data------------------
short CALand_CX = START_CA_CX,  CALand_CY = START_CA_CY; 
unsigned char CAflag = START_CAFLAG;
extern unsigned char CAwaitcounter;
extern unsigned char CAwaitalarm;
unsigned char CAwrapflag = 1;
unsigned char CAstretchflag = 0;
unsigned char CAtype = 0;
unsigned char CApalette_type = 0;
DWORD CA_Rop = SRCCOPY;
//----------Tweak and Support DATA------------------
	unsigned char newlambda = 1;
	float lambda = START_LAMBDA;
	unsigned char lambdalevel = START_LAMBDALEVEL;
	unsigned short lambdaseed;
	unsigned char speedlevel = HIGH;
	short CALand_MAXX = START_CA_CX - 1, CALand_MAXY = START_CA_CY - 1;
#ifndef SMALL_CA
	long CALand_SIZEOF = START_CA_CX * START_CA_CY;
#else
	unsigned short CALand_SIZEOF =  START_CA_CX * START_CA_CY;
#endif

	HRGN hRgnClip; // for clipping CAlandBlt against lens.

	unsigned short CA_Z = 0;
#ifdef CALEAKER
	extern unsigned char CAloaded;
#endif

// I need to re-create hBitmapCALand every time I use it because
// with the LOCK and UNLOCK, the CAbuffer pointers change
// between hits.  (In practice, omitting this gives blank refresh.)
// Use the CAbuffer0 and CAbuffer1 as the bits for the
// HBITMAP hBitmapCALand which gets recreated in 
// CALandBlt.  I keep the CA as a DIBitmap because
// then I don't need to use SetPixel calls to set each of pixels
// before the CALandBlt or the CALandStretchBlt.

HBITMAP hBitmapCALand;
HDC hdcCALand;
HBITMAP hBitmapCALandOld;
LPBITMAPINFO lpbmiCALand;


unsigned char CARuleMask = EIGHTMASK;
unsigned char CAPutMask = NOMASK;
unsigned char CAparity = 0;
unsigned char slicecount = 1;
unsigned char slice = 0; // range 0 to slicecount - 1
COLORREF CApalette[256];
//-------------Extern Data------
extern RECT lensrect, clientrect;
extern short lens_dy, lens_dx, prelensx, prelensy,lensx, lensy; 
extern COLORREF blankcolor, wallcolor, foodcolor, poisoncolor, headcolor;
extern unsigned char lensflag;
extern COLORREF bugpalette[BUG_PAL_COUNT];
extern short BugLand_CX, BugLand_CY, BugLand_MAXX, BugLand_MAXY;
	// macros XWRAP, YWRAP use BugLand_MAXX, BugLandMAXY.
extern long BugLand_SIZEOF;
extern short cxClient, cyClient;
extern short WinOrgX, WinOrgY;
extern short stretchfactor;
extern HDC hdcBugLand;
extern HWND hwnd; // The master window, used by fixcachecks

//-------------Own Functions------
unsigned char near RugRule(unsigned short, unsigned char);
unsigned char near LifeRule(unsigned short, unsigned char);
unsigned char near BrainRule(unsigned short, unsigned char);
unsigned char near FadersRule(unsigned short, unsigned char);
unsigned char near HodgeRule( unsigned short, unsigned char);
unsigned char near DiffuseRule( unsigned short, unsigned char);
unsigned char near RanchRule( unsigned short, unsigned char);
unsigned char near VoteRule( unsigned short, unsigned char);
unsigned char near LambdaRule( unsigned short, unsigned char);
void FixCAChecks(void);
void FixSpeedChecks(void); // used by bug.cpp, keep here to save space
unsigned char near (*CARule)(unsigned short, unsigned char) = RugRule;
void GrowCA(HWND);
// It seems to me these next  3 guys should be near, as once GrowCA is
// called, I'm over in this codeseg, but if I make them near I crash.
void near LoadhdcCALand(HDC hdc); // gets called by CALandBlt  , stretch
void near CALandStretchBlt(HDC, DWORD); //gets called from growca
void near CALandBlt(HDC, DWORD);// called from growca

void resizeCA(HDC, float);
void resizeCAxy(HDC, short, short);
void installCAtype(HDC);
void fillCA(unsigned char);
void set_slice_info(void);
void bump_CA_Rop(void);
void bump_CApalette(HDC);
void set_CApalette(HDC, unsigned char);
void colorCAedges(unsigned char);
//--------------Lens Functions-----------
void LensBlt(HDC,short); //stretch.  Used by ca.cpp, grow.cpp, bug.cpp
//-----------------------Primary Function----------
void GrowCA(HWND hwnd)
{
	HDC hdc;
	short i,j;
	unsigned char E, NE, N, NW, W, SW, S, SE, C, NewC;
	unsigned short LeftColSum, MidColSum, RightColSum;
#ifdef SMALL_CA
	static unsigned short Cindex;
#else
	static long Cindex;
#endif // not SMALL_CA
	static short lowj, highj;

	hdc = GetDC(hwnd);

	if (!slice)
	{
		if (!CAwrapflag)
		// Start in col 1 of row 1 (skip 0s).
			Cindex = CALand_CX + 1;
		else
		// Start in col 0 of row 0.
			Cindex = 0;
		lowj = 1;
		highj = CALand_MAXY / slicecount;
	}
	if (!CAwrapflag)
	{
		//We'll step Cindex as CALand_CX * j + i
		// stay off edge rows and cols.
		for(j=lowj; j<highj; j++)
		{
		// Treat the i = 1 case special.
			C = CARuleMask & Read_buffer[Cindex];
			E = CARuleMask & Read_buffer[Cindex + 1];
			NE = CARuleMask & Read_buffer[Cindex - (CALand_MAXX)];
			N = CARuleMask & Read_buffer[Cindex - (CALand_CX)];
			NW = CARuleMask & Read_buffer[Cindex - (CALand_CX + 1)];
			W = CARuleMask & Read_buffer[Cindex - 1];
			SW = CARuleMask & Read_buffer[Cindex + (CALand_MAXX)];
			S = CARuleMask & Read_buffer[Cindex + (CALand_CX)];
			SE = CARuleMask & Read_buffer[Cindex + (CALand_CX + 1)];
			LeftColSum = NW + W + SW;
			MidColSum = N + C + S;
			RightColSum = NE + E + SE;
		// Do the CA rule
			NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
				Read_buffer[Cindex]);
		// Put the result in the write buffer (next cycle's read buffer)
			Write_buffer[Cindex] = NewC;
		// Put the pixel in the bitmap
			Cindex++;

			for (i=2; i<CALand_MAXX; i++)
			{
				C = E;
				LeftColSum = MidColSum;
				MidColSum = RightColSum;
				NE = CARuleMask & Read_buffer[Cindex - (CALand_MAXX)];
				E = CARuleMask & Read_buffer[Cindex + 1];
				SE = CARuleMask & Read_buffer[Cindex +
					(CALand_CX + 1)];
				RightColSum = NE + E + SE;
			// Do the CA rule
				NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
					Read_buffer[Cindex]);
			// Put the result in the write buffer (next cycle's read)
				Write_buffer[Cindex] = NewC;
			// Put the pixel in the bitmap
				Cindex++;
			}

			Cindex += 2; // skip last and first column.
		} //end i loop
	} // end !CAwrapflag

	else // CAwrapflag
	{
	// We'll handle the first and last row as special cases
		if (slice == 0)
		{
		// Treat j = 0 special.
		// Treat the i = 0 case special.
			C = CARuleMask & Read_buffer[0];
			E = CARuleMask & Read_buffer[1];
			NE = CARuleMask & Read_buffer[CALand_SIZEOF - CALand_MAXX];
			N = CARuleMask & Read_buffer[CALand_SIZEOF - CALand_CX];
			NW = CARuleMask & Read_buffer[CALand_SIZEOF - 1];
			W = CARuleMask & Read_buffer[CALand_MAXX];// wrap
			SW = CARuleMask & Read_buffer[CALand_CX + CALand_MAXX];
			S = CARuleMask & Read_buffer[CALand_CX];
			SE = CARuleMask & Read_buffer[CALand_CX + 1];

			LeftColSum = NW + W + SW;
			MidColSum = N + C + S;
			RightColSum = NE + E + SE;
		// Do the CA rule
			NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
				Read_buffer[Cindex]);
		// Put the result in the write buffer (next cycle's read buffer)
			Write_buffer[Cindex] = NewC;
		// Put the pixel in the bitmap
			Cindex++;

			for (i=1; i<CALand_MAXX; i++)
			{
				C = E;
				LeftColSum = MidColSum;
				MidColSum = RightColSum;
				NE = CARuleMask & Read_buffer[Cindex + (CALand_SIZEOF -
					CALand_MAXX)];
				E = CARuleMask & Read_buffer[Cindex + 1];
				SE = CARuleMask & Read_buffer[Cindex +
					(CALand_CX + 1)];
				RightColSum = NE + E + SE;
			// Do the CA rule
				NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
					Read_buffer[Cindex]);
			// Put the result in the write buffer (next cycle's read)
				Write_buffer[Cindex] = NewC;
			// Put the pixel in the bitmap
				Cindex++;
			}
		// Do i = CALand_MAXX special
				C = E;
				LeftColSum = MidColSum;
				MidColSum = RightColSum;
				NE = CARuleMask &
					Read_buffer[CALand_SIZEOF - CALand_CX];
				E = CARuleMask & Read_buffer[0];
				SE = CARuleMask & Read_buffer[CALand_CX];
				RightColSum = NE + E + SE;
			// Do the CA rule
				NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
					Read_buffer[Cindex]);
			// Put the result in the write buffer (next cycle's read)
				Write_buffer[Cindex] = NewC;
			// Put the pixel in the bitmap
				Cindex++;
		} // Done with the first row
		for(j=lowj; j<highj; j++)
		{
		// Treat the i = 0 case special.
			C = CARuleMask & Read_buffer[Cindex];
			E = CARuleMask & Read_buffer[Cindex + 1];
			NE = CARuleMask & Read_buffer[Cindex - CALand_MAXX];
			N = CARuleMask & Read_buffer[Cindex - CALand_CX];
			NW = CARuleMask & Read_buffer[Cindex - 1];	//wrap
			W = CARuleMask & Read_buffer[Cindex + CALand_MAXX];// wrap
			SW = CARuleMask & Read_buffer[Cindex + CALand_CX +
				 + CALand_MAXX]; //wrap
			S = CARuleMask & Read_buffer[Cindex + CALand_CX];
			SE = CARuleMask & Read_buffer[Cindex + CALand_CX + 1];

			LeftColSum = NW + W + SW;
			MidColSum = N + C + S;
			RightColSum = NE + E + SE;
		// Do the CA rule
			NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
				Read_buffer[Cindex]);
		// Put the result in the write buffer (next cycle's read buffer)
			Write_buffer[Cindex] = NewC;
		// Put the pixel in the bitmap
			Cindex++;

			for (i=1; i<CALand_MAXX; i++)
			{
				C = E;
				LeftColSum = MidColSum;
				MidColSum = RightColSum;
				NE = CARuleMask & Read_buffer[Cindex - CALand_MAXX];
				E = CARuleMask & Read_buffer[Cindex + 1];
				SE = CARuleMask &
					Read_buffer[Cindex + (CALand_CX + 1)];
				RightColSum = NE + E + SE;
			// Do the CA rule
				NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
					Read_buffer[Cindex]);
			// Put the result in the write buffer (next cycle's read)
				Write_buffer[Cindex] = NewC;
			// Put the pixel in the bitmap
				Cindex++;
			}
		// Do i = CALand_MAXX special
				C = E;
				LeftColSum = MidColSum;
				MidColSum = RightColSum;
				NE = CARuleMask &
					Read_buffer[Cindex - CALand_CX - CALand_MAXX];
				E = CARuleMask & Read_buffer[Cindex - CALand_MAXX];
				SE = CARuleMask & Read_buffer[Cindex + 1];
				RightColSum = NE + E + SE;
			// Do the CA rule
				NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
					Read_buffer[Cindex]);
			// Put the result in the write buffer (next cycle's read)
				Write_buffer[Cindex] = NewC;
			// Put the pixel in the bitmap
				Cindex++;
		}
		if (slice ==  slicecount - 1)
		{
		// Treat j=CALand_MAXY special
		// Treat the i = 0 case special.
			C = CARuleMask & Read_buffer[Cindex];
			E = CARuleMask & Read_buffer[Cindex + 1];
			NE = CARuleMask & Read_buffer[Cindex - CALand_MAXX];
			N = CARuleMask & Read_buffer[Cindex - CALand_CX];
			NW = CARuleMask & Read_buffer[Cindex - 1];//wrap
			W = CARuleMask & Read_buffer[Cindex + CALand_MAXX];// wrap
			SW = CARuleMask & Read_buffer[CALand_MAXX]; //wrap
			S = CARuleMask & Read_buffer[0];
			SE = CARuleMask & Read_buffer[1];

			LeftColSum = NW + W + SW;
			MidColSum = N + C + S;
			RightColSum = NE + E + SE;
		// Do the CA rule
			NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
				Read_buffer[Cindex]);
		// Put the result in the write buffer (next cycle's read buffer)
			Write_buffer[Cindex] = NewC;
		// Put the pixel in the bitmap
			Cindex++;

			for (i=1; i<CALand_MAXX; i++)
			{
				C = E;
				LeftColSum = MidColSum;
				MidColSum = RightColSum;
				NE = CARuleMask & Read_buffer[Cindex - (CALand_MAXX)];
				E = CARuleMask & Read_buffer[Cindex + 1];
				SE = CARuleMask & Read_buffer[i + 1];
				RightColSum = NE + E + SE;
			// Do the CA rule
				NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
					Read_buffer[Cindex]);
			// Put the result in the write buffer (next cycle's read)
				Write_buffer[Cindex] = NewC;
			// Put the pixel in the bitmap
				Cindex++;
			}
		// Do i = CALand_MAXX special
				C = E;
				LeftColSum = MidColSum;
				MidColSum = RightColSum;
				NE = CARuleMask &
					Read_buffer[Cindex - CALand_CX - CALand_MAXX];
				E = CARuleMask & Read_buffer[Cindex - CALand_MAXX];
				SE = CARuleMask & Read_buffer[0];
				RightColSum = NE + E + SE;
			// Do the CA rule
				NewC = CARule(LeftColSum+MidColSum+RightColSum-C,
					Read_buffer[Cindex]);
			// Put the result in the write buffer (next cycle's read)
				Write_buffer[Cindex] = NewC;
			// Put the pixel in the bitmap
				Cindex++;
		} // End the last row
	} // end CAwrapflag

	slice++;
	if (slice == slicecount) // done updating patch
	{
		slice = 0;
		if (CAflag == 1 && CAstretchflag)
			CALandStretchBlt(hdc, CA_Rop);
		else
		{
//bookmark
			if (lensflag)
			{
				ExcludeClipRect(hdc,lensrect.left, lensrect.top,
					lensrect.right, lensrect.bottom);
			}
			CALandBlt(hdc, CA_Rop);
			if (lensflag)
			{
				hRgnClip = CreateRectRgnIndirect(&clientrect);
				SelectClipRgn(hdc,hRgnClip);
				DeleteObject(hRgnClip);
			}
		}
		// Change the CAparity.
			CAparity ^= 1;
	}
	else // Not done updating patch
	{
		lowj = highj;
		if (slice < slicecount - 1)
		{
			highj = lowj + CALand_MAXY / slicecount;
			if (highj > CALand_MAXY)
				highj = CALand_MAXY; // Just to be careful.
		}
		else
			highj = CALand_MAXY;
	}
	LensBlt(hdc, stretchfactor); // Draw lens if desired.
	ReleaseDC(hwnd, hdc);
}

//-------------------Near Functions----



void near LoadhdcCALand(HDC hdc)
{
#ifndef CALEAKER

	lpbmiCALand->bmiHeader.biWidth = CALand_CX;
	lpbmiCALand->bmiHeader.biHeight = CALand_CY;
	hBitmapCALand = CreateDIBitmap(hdc,
		(LPBITMAPINFOHEADER)&(lpbmiCALand->bmiHeader),
		CBM_INIT, (LPSTR)(Read_buffer),
		lpbmiCALand, DIB_RGB_COLORS);
// Selecting this bitmap returns the previous one, 
// which you delete.
	DeleteObject( SelectObject(hdcCALand,hBitmapCALand) );
#else

	lpbmiCALand->bmiHeader.biWidth = CALand_CX;
	lpbmiCALand->bmiHeader.biHeight = CALand_CY;
	hBitmapCALand = CreateDIBitmap(hdc,
		(LPBITMAPINFOHEADER)&(lpbmiCALand->bmiHeader),
		CBM_INIT, (LPSTR)(Read_buffer),
		lpbmiCALand, DIB_RGB_COLORS);
// First time save the old bitmap as "Old" for WM_DESTROY. Later,
// selecting this bitmap returns the previous one, which you delete.
	if (CAloaded)
		DeleteObject( SelectObject(hdcCALand,hBitmapCALand) );
	else
	{
		hBitmapCALandOld = SelectObject(hdcCALand,hBitmapCALand);
		CAloaded = 1;
	}
#endif //CALEAKER
}


void near CALandBlt(HDC hdc, DWORD dwRop)
{
	short TargetTX, TargetTY, inx, outx, iny, outy;
	unsigned char overlap = 0;

	// Set a clip rect for the lens like with the bugbodyblt
	// if lensflag. TODO

	LoadhdcCALand(hdc);

	BitBlt(hdcBugLand, 0, 0, CALand_CX, CALand_CY,
		hdcCALand, 0, 0, dwRop);
	if (!WinOrgX && !WinOrgY)
	{
		BitBlt(hdc, 0, 0, CALand_CX, CALand_CY,
			hdcBugLand, 0, 0, dwRop);
		return;
	}

	if (WinOrgX < CALand_CX)
	{
		inx = WinOrgX;
		outx = CALand_CX - inx;
		overlap = 1;
	}
	if (WinOrgY < CALand_CY)
	{
		iny = WinOrgY;
		outy = CALand_CY - iny;
		overlap |= 2;
	}

	TargetTX = XWRAP(BugLand_CX - WinOrgX);
	TargetTY = YWRAP(BugLand_CY - WinOrgY);

	switch (overlap)
	{
		case 0: // no overlap
			BitBlt(hdc, TargetTX, TargetTY, CALand_CX, CALand_CY,
				hdcBugLand, 0, 0, dwRop);
			break;
		case 1: // x overlap
			BitBlt(hdc, TargetTX, TargetTY, inx, CALand_CY,
				hdcBugLand, 0, 0, dwRop);
			BitBlt(hdc, 0, TargetTY, outx, CALand_CY,
				hdcBugLand, inx, 0, dwRop);
			break;
		case 2: // y overlap
			BitBlt(hdc, TargetTX, TargetTY, CALand_CX, iny,
				hdcBugLand, 0, 0, dwRop);
			BitBlt(hdc, TargetTX, 0, CALand_CX, outy,
				hdcBugLand, 0, iny, dwRop);
			break;
		case 3: // x and y overlap
			BitBlt(hdc, TargetTX, TargetTY, inx, iny,
				hdcBugLand, 0, 0, dwRop);
			BitBlt(hdc, 0, TargetTY, outx, iny,
				hdcBugLand, inx, 0, dwRop);
			BitBlt(hdc, TargetTX, 0, inx, outy,
				hdcBugLand, 0, iny, dwRop);
			BitBlt(hdc, 0, 0, outx, outy,
				hdcBugLand, inx, iny, dwRop);
			break;
	}
}

void near CALandStretchBlt(HDC hdc, DWORD dwRop)
{
	short SourceTX, SourceTY, TargetTX, TargetTY;
	short i, cxFitClient, cyFitClient;

	for (i=2; i<1000; i++)
	{
		if (i * CALand_CX > cxClient)
		{
			cxFitClient = (i-1) * CALand_CX;
			break;
		}
		
	}
	for (i=2; i<1000; i++)
	{
		if (i * CALand_CY > cyClient)
		{
			cyFitClient = (i-1) * CALand_CY;
			break;
		}
	}

	// Stretch it to BugLand straight or
	LoadhdcCALand(hdc);
	if ( (WinOrgX == 0) && (WinOrgY == 0) )
		StretchBlt(hdcBugLand, 0, 0, cxFitClient, cyFitClient,
			hdcCALand, 0, 0, CALand_CX, CALand_CY, SRCCOPY);

	else // Break in four and reassemble.
	{
	// (WinOrgX, WinOrgY) is the corner where the window looks into
	// Bugland.  View CALand as this corner of Bugland.

	//  Think of SOURCE		and				TARGET
	//		(1)   |(2) 					(4) |(3)   
	//		      |    					----T------
	//		------T----					(2) |(1)   
	//		(3)   |(4) 					    |      
	//	T at (SourceTX,				T at (TargetTX,
	//		SourceTY)						TargetTY)
	// If Source is (0,0), then there shouldn't even be a target,
	// it's all region (4), so that means target should be
	// BugLand_CX,BugLand_CY in this case.

		SourceTX = ((long)WinOrgX * (long)CALand_CX) / BugLand_CX;
		SourceTY = ((long)WinOrgY * (long)CALand_CY) / BugLand_CY;
		TargetTX = ((long)(BugLand_CX - WinOrgX) * (long)cxFitClient) /
			BugLand_CX;
		TargetTY = ((long)(BugLand_CY - WinOrgY) * (long)cyFitClient) /
			BugLand_CY;

		StretchBlt(hdcBugLand, 0, 0, TargetTX,
			TargetTY, hdcCALand, SourceTX, SourceTY,
			CALand_CX - SourceTX, CALand_CY - SourceTY, SRCCOPY);//(4)
		StretchBlt(hdcBugLand, TargetTX, 0, cxFitClient-TargetTX,
			TargetTY, hdcCALand, 0, SourceTY,
			SourceTX, CALand_CY - SourceTY, SRCCOPY);	//(3)
		StretchBlt(hdcBugLand, 0, TargetTY, TargetTX,
			cyFitClient-TargetTY, hdcCALand, SourceTX, 0,
			CALand_CX - SourceTX, SourceTY, SRCCOPY);	//(2)
		StretchBlt(hdcBugLand, TargetTX, TargetTY, cxFitClient-TargetTX,
			cyFitClient-TargetTY, hdcCALand, 0, 0,
			SourceTX, SourceTY, SRCCOPY);	//(1)
	}
	//Then blast it to the screen.
	BitBlt(hdc, 0, 0, cxFitClient, cyFitClient,
		hdcBugLand, 0, 0, dwRop);
}

//---------------Far Functions-------------------


void installCAtype(HDC hdc)
{
	switch (CAtype)
	{
		case RUG_TYPE:
			CARule = RugRule;
			CARuleMask = EIGHTMASK;
			CAPutMask = NOMASK;
			set_CApalette(hdc, 0); //boppers palette
			break;
		case LIFE_TYPE:
			CARule = LifeRule;
			CARuleMask = ONEMASK;
			CAPutMask = NOMASK;
			set_CApalette(hdc, 0); //boppers palette
			break;
		case BRAIN_TYPE:
			CARule = BrainRule;
			CARuleMask = ONEMASK;
			CAPutMask = NOMASK;
			set_CApalette(hdc, 0); //boppers palette
			break;
		case FADERS_TYPE:
			CARule = FadersRule;
			CARuleMask = ONEMASK;
			CAPutMask = FIVEMASK;
			set_CApalette(hdc, 2); //faders palette
			break;
		case HODGE_TYPE:
			CARule = HodgeRule;
			CARuleMask = EIGHTMASK;
			CAPutMask = NOMASK;
			set_CApalette(hdc, 2); //faders palette
			break;
		case DIFFUSE_TYPE:
			CARule = DiffuseRule;
			CARuleMask = EIGHTMASK;
			CAPutMask = FOURMASK;
			set_CApalette(hdc, 3); //melty palette
			break;
		case RANCH_TYPE:
			CARule = RanchRule;
			CARuleMask = ONEMASK;
			CAPutMask = NOMASK;
			set_CApalette(hdc, 0); //boppers palette
			break;
		case VOTE_TYPE:
			CARule = VoteRule;
			CARuleMask = ONEMASK;
			CAPutMask = NOMASK;
			set_CApalette(hdc, 0); //boppers palette
			break;
		case LAMBDA_TYPE:
			CARule = LambdaRule;
#ifndef RUGLAM
			CARuleMask = ONEMASK;
			CAPutMask = NOMASK;
#else
			CARuleMask = TWOMASK;
			CAPutMask = FOURMASK;
#endif //RUGLAM
			set_CApalette(hdc, 0); //boppers palette
			break;
	}
	newlambda = 1;
}

void resizeCA(HDC hdc, float r)
{
	short old_CALand_CX, old_CALand_CY;
	short i, j;
#ifndef SMALL_CA
	long Sindex, Tindex;
#else
	unsigned short Sindex, Tindex;
#endif //SMALL_CA

	old_CALand_CX = CALand_CX;
	old_CALand_CY = CALand_CY;
	if (r < 0.0)
		r = -r;
	CALand_CX *= r;
	CALand_CY *= r;
	CALand_CX = (CALand_CX / DIBROUND) * DIBROUND;
	CALand_CY = (CALand_CY / DIBROUND) * DIBROUND;
	if (CALand_CX > (BugLand_CX / DIBROUND)*DIBROUND )
		CALand_CX = (BugLand_CX / DIBROUND)*DIBROUND;
	if (CALand_CY > (BugLand_CY / DIBROUND)*DIBROUND )
		CALand_CY = (BugLand_CY / DIBROUND)*DIBROUND;
	if ( (long)CALand_CX * (long)CALand_CY > (long)MAX_CALand_SIZEOF)
	{
		if (CALand_CX > MAX_CA_CX)
			CALand_CX = MAX_CA_CX;
		if (CALand_CY> MAX_CA_CY)
			CALand_CY = MAX_CA_CY;
	}
	if (CALand_CX < MIN_CA_CX)
		CALand_CX = MIN_CA_CX;
	if (CALand_CY < MIN_CA_CY)
		CALand_CY = MIN_CA_CY;
	CALand_MAXX = CALand_CX-1;
	CALand_MAXY = CALand_CY-1;
#ifndef SMALL_CA
	CALand_SIZEOF = (long)CALand_CX * (long)CALand_CY;
#else
	CALand_SIZEOF = CALand_CX * CALand_CY;
#endif
	set_slice_info();

	// Copy a resized version of Write_buffer to Read_buffer.
	Sindex = Tindex = 0;
	if (r > 1.0)
	{
		for (j=0; j < old_CALand_CY; j++)
		{
			for (i=0; i < old_CALand_CX; i++)
			{
				Read_buffer[Tindex] = Write_buffer[Sindex];
				Tindex++;
				Sindex++;
			}
			Tindex += CALand_CX - old_CALand_CX;
		}
	}
	else if (r < 1.0)
	{
		for (j=0; j < CALand_CY; j++)
		{
			for (i=0; i < CALand_CX; i++)
			{
				Read_buffer[Tindex] = Write_buffer[Sindex];
				Sindex++;
				Tindex++;
			}
			Sindex += old_CALand_CX - CALand_CX;
		}
	}
	
}


void resizeCAxy(HDC hdc, short x, short y)
{
	short old_CALand_CX, old_CALand_CY;
	short i, j;
#ifndef SMALL_CA
	long Sindex, Tindex;
#else
	unsigned short Sindex, Tindex;
#endif

	old_CALand_CX = CALand_CX;
	old_CALand_CY = CALand_CY;
	CALand_CX = (x / DIBROUND) * DIBROUND;
	CALand_CY = (y / DIBROUND) * DIBROUND;
	if ( (long)CALand_CX * (long)CALand_CY > (long)MAX_CALand_SIZEOF)
	{
		if (CALand_CX > MAX_CA_CX)
			CALand_CX = MAX_CA_CX;
		if (CALand_CY> MAX_CA_CY)
			CALand_CY = MAX_CA_CY;
	}
	if (CALand_CX < MIN_CA_CX)
		CALand_CX = MIN_CA_CX;
	if (CALand_CY < MIN_CA_CY)
		CALand_CY = MIN_CA_CY;
	CALand_MAXX = CALand_CX-1;
	CALand_MAXY = CALand_CY-1;
#ifndef SMALL_CA
	CALand_SIZEOF = (long)CALand_CX * (long)CALand_CY;
#else
	CALand_SIZEOF = CALand_CX * CALand_CY;
#endif
	set_slice_info();

	// Copy a resized version of Write_buffer to Read_buffer.
	Sindex = Tindex = 0;
	if (x > old_CALand_CX && y > old_CALand_CY)
	{
		for (j=0; j < old_CALand_CY; j++)
		{
			for (i=0; i < old_CALand_CX; i++)
			{
				Read_buffer[Tindex] = Write_buffer[Sindex];
				Tindex++;
				Sindex++;
			}
			Tindex += CALand_CX - old_CALand_CX;
		}
	}
	else if (x <= old_CALand_CX && y <= old_CALand_CY)
	{
		for (j=0; j < CALand_CY; j++)
		{
			for (i=0; i < CALand_CX; i++)
			{
				Read_buffer[Tindex] = Write_buffer[Sindex];
				Sindex++;
				Tindex++;
			}
			Sindex += old_CALand_CX - CALand_CX;
		}
	}
	
}

void fillCA(unsigned char filltype)
{
#ifndef SMALL_CA
	long n;
#else
	unsigned short n;
#endif

	switch (filltype)
	{
		case 0: // Blank the whole thing
		// Do Write_buffer too in case wrap is off.
			for (n=0; n < CALand_SIZEOF; n++)
				Write_buffer[n] = Read_buffer[n] = 0;
			slice = 0;
			break;
		case 1:
			if (CAtype == BRAIN_TYPE || CAtype == FADERS_TYPE )
				for (n=0; n < CALand_SIZEOF; n++)
					Read_buffer[n] = Random(3);
			else if (CAtype == LIFE_TYPE || CAtype == VOTE_TYPE)
				for (n=0; n < CALand_SIZEOF; n++)
					Read_buffer[n] = Random(2);
			else if (CAtype == RANCH_TYPE)
				for (n=0; n < CALand_SIZEOF; n++)
                {
					Read_buffer[n] =   Random(4) & 3;
					Read_buffer[n] |= (Read_buffer[n] & 1) << 3;
	            }
// The ranch startup sets all starting bit 7s set to 0 (for synchronized
// cycles), and we random seed Planes #0 and #1 to start Vote and firing
// and set the Vote slot to match.
			else
				for (n=0; n < CALand_SIZEOF; n++)
					Read_buffer[n] = Random(256);
			slice = 0;
			break;
	}
}
void colorCAedges(unsigned char col)
{
	short i;
#ifndef SMALL_CA
	long n;
#else
	unsigned short n;
#endif //SMALL_CA

	for (i=0; i < CALand_CX; i++)
	{
		Write_buffer[i] = Read_buffer[i] = col; // row 0
		Write_buffer[CALand_SIZEOF - 1 - i] =
			Read_buffer[CALand_SIZEOF - 1 - i] = col; // row CALand_MAXY
	}
	n = CALand_CX;
	for (i=1; i < CALand_MAXY; i++)
	{
		Write_buffer[n] = Read_buffer[n] = col; // column 0
		n += CALand_MAXX;
		Write_buffer[n] = Read_buffer[n] = col; // column CALand_MAXX
		n++;
	}
}

void set_slice_info(void)
{
	slice = 0;
	slicecount = (CALand_SIZEOF / CELLS_PER_SLICE) + 1;
	switch (slicecount)
	{
		case 1:
			CAwaitalarm = 3;
			break;
		case 2:
			CAwaitalarm = 2;
			break;
		default:
			CAwaitalarm = 1; // means no wait
			break;
	}
}

void bump_CA_Rop(void)
{
	switch(CA_Rop)
	{
		case SRCCOPY:
			CA_Rop = SRCERASE;
			break;
		default:
			CA_Rop = SRCCOPY;
			break;
	}
}

void bump_CApalette(HDC hdc)
{
	unsigned char palnum;

	palnum = CApalette_type+1;
	if (palnum == CAPALETTE_COUNT)
		palnum = 0;
	set_CApalette(hdc, palnum);
}


void set_CApalette(HDC hdc, unsigned char palnum)
{
	short n;

	CApalette_type = palnum;
	if (CApalette_type >= CAPALETTE_COUNT)
		CApalette_type = 0;
	switch(CApalette_type)
	{
		case 0: //boppers palette
			for (n=0; n < BUG_PAL_COUNT; n++)
				CApalette[n] = bugpalette[ n];
			CApalette[HEAD_PAL_INDEX]=foodcolor;
			CApalette[WALL_PAL_INDEX]=poisoncolor;
			for (n= BUG_PAL_COUNT; n < 256; n++)
				CApalette[n] = CApalette[ MOD(n,BUG_PAL_COUNT-1) + 1];
			break;
		case 1: //random palette
			for (n=0; n < 256; n++)
				CApalette[n] = GetNearestColor(hdc,
				RGB(Random(255),Random(255),Random(255)) );
			CApalette[0] = blankcolor;
			break;
		case 2: //faders palette
			for (n=0; n < BUG_PAL_COUNT; n++)
				CApalette[n] = bugpalette[n];
			CApalette[0] = blankcolor;
			CApalette[HEAD_PAL_INDEX]=foodcolor;
			CApalette[WALL_PAL_INDEX]=poisoncolor;
			for (n=BUG_PAL_COUNT; n < 24; n++)
				CApalette[n] = bugpalette[6];
			for (n=24; n < 32; n++)
				CApalette[n] =  bugpalette[5];
			for (n=32; n < 40; n++)
				CApalette[n] =  bugpalette[4];
			for (n=40; n < 48; n++)
				CApalette[n] =  bugpalette[3];
			for (n=48; n < 54; n++)
				CApalette[n] =  bugpalette[8];
			for (n=54; n < 64; n++)
				CApalette[n] =  bugpalette[7];
			for (n=64; n < 256; n++)
				CApalette[n] = CApalette[n/BUG_PAL_COUNT];
			break;
		case 3: //melty
			for (n=0; n < BUG_PAL_COUNT; n++)
				CApalette[n] = bugpalette[n];
			CApalette[0] = blankcolor;
			CApalette[HEAD_PAL_INDEX]=foodcolor;
			CApalette[WALL_PAL_INDEX]=poisoncolor;
			for (n=BUG_PAL_COUNT; n < 256; n++)
				CApalette[n] = CApalette[n/BUG_PAL_COUNT];
			break;
	}
	if (CAtype == FADERS_TYPE)
	{
			CApalette[0] = blankcolor;
			CApalette[1] = foodcolor;
	}
	if (CAtype == RANCH_TYPE)
		for (n=0; n < 256; n++)
			CApalette[n] = CApalette[n & 0xE];
	//The Ranch palette looks only at bits 3,2, & 1.
	for (n=0; n<256; n++)
	{
		lpbmiCALand->bmiColors[n].rgbBlue =
			GetBValue(CApalette[n]);
		lpbmiCALand->bmiColors[n].rgbGreen =
			GetGValue(CApalette[n]);
		lpbmiCALand->bmiColors[n].rgbRed =
			GetRValue(CApalette[n]);
	}
}

//--------------CA Rules-------

unsigned char near RugRule(unsigned short Sum, unsigned char C)
{
	return (unsigned char) ( ( ( Sum >> 3 ) + 1 ) & 255);
}

unsigned char near LifeRule(unsigned short Sum, unsigned char C)
{
	static unsigned char lifetable[18] =
		{0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0};
    
	return lifetable[9 * (C&1) + Sum];
}

unsigned char near BrainRule(unsigned short Sum, unsigned char C)
{
	static unsigned char braintable[27] =
		{0,0,1,0,0,0,0,0,0,
		 2,2,2,2,2,2,2,2,2,
         0,0,0,0,0,0,0,0,0};

	return braintable[9 * (C&3) + Sum];
}


unsigned char near FadersRule(unsigned short Sum, unsigned char C)
{
	switch (C)
	{
		case 0:
			if (Sum == 2)
				return 1;
			else
				return 0;
		case 1:
			if (Sum == 2)
				return 1;
			else
				return 4;
		default:
			if (C >= 64)
				return 0;
			else
				return C + 2;
	}
}

unsigned char near HodgeRule(unsigned short Sum, unsigned char C)
{
	unsigned char NewC;

	if (!C)
	{
		if (Sum < 5)
			NewC = 0;
		else if (Sum < 100)
			NewC = 2;
		else
			NewC = 3;
	}
	else if (C < 31)
	{
		NewC = ((Sum >> 3) + 5) & 255;
		if (NewC >= 31)
			NewC = 31;
	}
	else // act as if C == 31
		NewC = 0;
	return NewC;
}

unsigned char near DiffuseRule(unsigned short Sum, unsigned char C)
{
//	if (Sum & 7)
//		Sum += 8; // Round it up.
	return (unsigned char) ( ( ( Sum >> 3 ) ) & 255);
}


unsigned char near RanchRule( unsigned short EightSum,
	 unsigned char OldState)

{
// We use the eight bits of state as follows:
// Bit #0 is used to show either the firing or the vote bit to neighbors;
// Bit #1 is the firing bit, Bit #2 is the refractory bit, Bit #3 is the
// Vote bit, Bit #4 is the vote memory bit, and Bit #7 is the cycle bit.
	unsigned char Cycle,M,V,R,F,NewCycle,NewM,NewV,NewF, NewC;
	static unsigned char votetable[10] = {0,0,0,0,1,0,1,1,1,1};
	static unsigned char edgelifetable[9] = {0,1,0,0,1,0,0,0,0};
	static unsigned char lifetable[18] =
		{0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0};
	static unsigned char braintable[36] =  //paranoia
		{0,0,1,0,0,0,0,0,0,
         2,2,2,2,2,2,2,2,2,
		 0,0,0,0,0,0,0,0,0,
		 0,0,0,0,0,0,0,0,0};

	Cycle =(OldState >> 7) & 1;
	M = (OldState >> 4) & 1;
	V = (OldState >> 3) & 1;
	R = (OldState >> 2) & 1;
	F = (OldState >> 1) & 1;
	if (!Cycle)
	{	//This is the update Vote cycle
		NewV = votetable[EightSum + V];
		NewM = V;
		NewCycle = 1;
		NewC = (NewCycle << 7) | (NewM << 4) | (NewV << 3) |
			(R << 2) | (F << 1) | F;
	}
	else
	{ 	//This is the update Firing cycle
		if (!V)	//Use Brain rule at sea
			NewF = braintable[18*R + 9*F + EightSum];
		else if (M == 1) // V ==  1 as well. Use Life rule inland
			NewF = lifetable[9*F + EightSum];
		else	//V == 1 and M == 0 : Use EdgeLife on new land
			NewF = edgelifetable[EightSum];
		NewCycle = 0;
		NewC  = (NewCycle << 7) | (M << 4) | (V << 3) |
			(NewF << 1) | V;
	}
	return NewC;
}
/* The Ranch palette looks only at bits 3,2, & 1.  Pattern meanings:
   ----001- is firing at sea
   ----010- is refractory at sea
   ----1-0- is dead on land
   ----1-1- is live on land
   & others are dead at sea

*/

unsigned char near VoteRule( unsigned short eightsum, unsigned char self)
{
	static unsigned char votelookup[10] = {0,0,0,0,1,0,1,1,1,1};

	return votelookup[eightsum + (self & 1)];
}


unsigned char near LambdaRule( unsigned short eightsum, unsigned char self)
{
#ifndef LAMBDA16

	static unsigned char lookup[9 * 256];
	int i;
	unsigned char cutoff;

	if (newlambda)
	{
		cutoff = lambda * 256;
		lookup[0] = 0; // blank with no neighbors stays blank
		for (i=1; i< 9*256; i++)
			lookup[i] = (Randombyte() < cutoff)?Random(255)+1:0;
		newlambda = 0;
	}

	return lookup[(9 * self) + eightsum];
#else

	static unsigned char lookup[9 * 16];
	int i;
	unsigned char cutoff;

	if (newlambda)
	{
		cutoff = lambda * 256.0;
		lookup[0] = 0; // blank with no neighbors stays blank
		for (i=1; i< 9*16; i++)
			lookup[i] = (Randombyte() < cutoff)?Random(15)+1:0;
		newlambda = 0;
	}

	if (self > 15)
		return (self & 15);
	else
		return lookup[(9 * self) + eightsum];
#endif //LAMBDA16
}

void FixCAChecks(void)
{
	short n;
	HMENU hmenu;

	hmenu = GetMenu(hwnd);

	CheckMenuItem( hmenu,CA_OFF,
		MF_BYCOMMAND | (CAflag ?MF_UNCHECKED:MF_CHECKED));
	CheckMenuItem( hmenu,CA_ON,
		MF_BYCOMMAND | (CAflag ?MF_CHECKED:MF_UNCHECKED));
	CheckMenuItem( hmenu,START_CUR,MF_BYCOMMAND | MF_CHECKED);
	CheckMenuItem( hmenu,CA_TOGGLECAWRAP,
		MF_BYCOMMAND | (CAwrapflag ?MF_CHECKED:MF_UNCHECKED));
	CheckMenuItem( hmenu,CA_TOGGLEBUGS,
		MF_BYCOMMAND | ((CAflag==0 || CAflag==2) ?MF_CHECKED:MF_UNCHECKED));
	CheckMenuItem( hmenu,CA_TOGGLEFULL,
		MF_BYCOMMAND | (CAstretchflag ?MF_CHECKED:MF_UNCHECKED));
	for (n=CA_RULE_RUG; n<= CA_RULE_RANCH; n++)
		CheckMenuItem( hmenu, (WORD)n,
			MF_BYCOMMAND | MF_UNCHECKED);
	CheckMenuItem( hmenu, CA_RULE_RUG + CAtype,
		MF_BYCOMMAND | MF_CHECKED);
	for (n=CA_LAMBDA_LOW; n<= CA_LAMBDA_HIGH; n++)
		CheckMenuItem( hmenu, (WORD)n,
			MF_BYCOMMAND | MF_UNCHECKED);
	CheckMenuItem( hmenu, CA_LAMBDA_LOW + lambdalevel - 1,
		MF_BYCOMMAND | MF_CHECKED);
	for (n=CA_PALETTE_STANDARD; n<= CA_PALETTE_MELT; n++)
		CheckMenuItem( hmenu, (WORD)n,
			MF_BYCOMMAND | MF_UNCHECKED);
	CheckMenuItem( hmenu, CA_PALETTE_STANDARD + CApalette_type,
		MF_BYCOMMAND | MF_CHECKED);
	

#ifdef GRAYMENU
	if (CAflag) //Enable the menu
		for (n=CA_CHANGERULE; n <= CA_BIGGER; n++)
			EnableMenuItem( hmenu, (WORD)n, MF_BYCOMMAND|MF_ENABLED);
	else	//Disable the menu and make it gray.
		for (n=CA_CHANGERULE; n <= CA_BIGGER; n++)
			EnableMenuItem( hmenu, (WORD)n, MF_BYCOMMAND|MF_GRAYED);
#endif GRAYMENU
	
}

void FixSpeedChecks(void)
{
	short n;
	HMENU hmenu;

	hmenu = GetMenu(hwnd);

	for (n=SPEED_STEP; n<= SPEED_FAST; n++)
		CheckMenuItem( hmenu, (WORD)n,
			MF_BYCOMMAND | MF_UNCHECKED);
	switch (speedlevel)
	{
		case NONE:
			CheckMenuItem( hmenu, SPEED_STEP, MF_BYCOMMAND | MF_CHECKED);
			break;
		case LOW:
			CheckMenuItem( hmenu, SPEED_SLOW, MF_BYCOMMAND | MF_CHECKED);
			break;
		case HIGH:
			CheckMenuItem( hmenu, SPEED_FAST, MF_BYCOMMAND | MF_CHECKED);
			break;
	}
}

void LensBlt(HDC hdc, short stretch)
{ //Called by grow.cpp, ca.cpp and bug.cpp
	short x,y, prex,prey,prexplus,preyplus,predx,predy,
		inx,iny,outx,outy,overlap;

	HPEN wallpen, oldpen;

	if (!lensflag)
		return;
	
	predx = lens_dx / stretch;
	predy = lens_dy / stretch;
	prex = XWRAP( prelensx - (predx/2) );
	prey = YWRAP( prelensy - (predy/2) );
	prexplus = prex + predx;
	preyplus = prey + predy;
	overlap = 0;
	if (prexplus > BugLand_MAXX)
	{
		inx = BugLand_CX - prex;
		outx = prexplus - BugLand_CX;
		overlap = 1;
	}
	if (preyplus > BugLand_MAXY)
	{
		iny = BugLand_CY - prey;
		outy = preyplus - BugLand_CY;
		overlap |= 2;
	}
	x = XWRAP(lensx - (lens_dx/2) );
	y = YWRAP(lensy - (lens_dy/2) );

	switch (overlap) 
	{
		case 0: // no overlap
			StretchBlt(hdc, x, y, lens_dx, lens_dy, hdcBugLand,
			prex, prey, predx, predy, SRCCOPY);
			break;
		case 1: // x overlap
			StretchBlt(hdc, x, y, inx*stretch, lens_dy, hdcBugLand,
				prex, prey, inx, predy, SRCCOPY);
			StretchBlt(hdc, x + inx*stretch, y, outx*stretch, lens_dy,
				hdcBugLand, 0, prey, outx, predy,
				SRCCOPY);
			break;
		case 2: // y overlap
			StretchBlt(hdc, x, y, lens_dx, iny*stretch, hdcBugLand,
				prex, prey, predx, iny, SRCCOPY);
			StretchBlt(hdc, x, y + iny*stretch, lens_dx, outy*stretch,
				hdcBugLand, prex, 0, predx, outy, SRCCOPY);
			break;
		case 3: // x and y overlap
			StretchBlt(hdc, x, y, inx*stretch, iny*stretch,
				hdcBugLand,prex, prey, inx, iny, SRCCOPY);
			StretchBlt(hdc, x + inx*stretch, y,
				outx*stretch, iny*stretch,
				hdcBugLand, 0, prey, outx, iny, SRCCOPY);
			StretchBlt(hdc, x, y + iny*stretch,
				inx*stretch, outy*stretch,
				hdcBugLand, prex, 0, inx, outy, SRCCOPY);
			StretchBlt(hdc, x + inx*stretch, y + iny*stretch,
				outx*stretch, outy*stretch,
				hdcBugLand, 0, 0, outx, outy, SRCCOPY);
			break;
	}

	// Now put a frame around the lens.
	wallpen = CreatePen(PS_SOLID, 1, wallcolor);
	oldpen = SelectObject(hdc, wallpen);
	MoveTo(hdc, x-1,       y-1);
	LineTo(hdc, x+lens_dx, y-1);
	LineTo(hdc, x+lens_dx, y+lens_dy);
	LineTo(hdc, x-1,       y+lens_dy);
	LineTo(hdc, x-1,       y-1);
	DeleteObject(SelectObject(hdc,oldpen));
}

