#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#pragma hdrstop
#include "colony.h"
//#define BOIDGENE

extern char szAppName[];
extern HWND hDlgColony, hwnd;
extern unsigned char editcolonyid;
extern struct colony Colony[];
extern struct bug *Bug[];
extern unsigned char colonycount;
void showcurrparams(HWND);

extern void label(HWND, int, char *, short);
extern void numlabel( HWND , int , short );

static unsigned char
	currexogamyflag,
	currendogamyflag,
	currrecruitpreyflag,
	currbreedflag;
static unsigned short
	currbreedtime,
	currmetazapcode,
	currdeathlevel,
	currsexlevel,
	currmutationlevel,
	currzaplevel,
	currtranspositionlevel;
static short
	currhitradius,
	currlowmotionvalue,
	currmintotalmotion,
	currtargetentropy,
	currgoodentropyvalue;

#ifdef CYBER
extern "C" BOOL FAR PASCAL ColonyProc( HWND hDlg, WORD message, WORD wParam, LONG lParam )
#else
BOOL FAR PASCAL ColonyProc( HWND hDlg, WORD message, WORD wParam, LONG lParam )
#endif //CYBER
{
	RECT rect;
	char buf[32];
	unsigned char i;
 	HWND hCntl;

	switch( message )
	{
		case WM_INITDIALOG:
			CheckMenuItem( GetMenu(hwnd),IDM_COLONY,
				MF_BYCOMMAND | MF_CHECKED);
			if (editcolonyid >= colonycount)
				editcolonyid = 0;

	// Fix DeathLevel Combo Box
			hCntl = GetDlgItem( hDlg, CO_MULTIPLICATIONCOMBO);
			SendMessage( hCntl, CB_ADDSTRING, LOW, (LONG)"Low");
			SendMessage( hCntl, CB_ADDSTRING, MEDIUM, (LONG)"Medium");
			SendMessage( hCntl, CB_ADDSTRING, HIGH, (LONG)"High");
			SendMessage( hCntl, CB_ADDSTRING, VERY_HIGH, (LONG)"Very High");

	// Fix SexLevel Combo Box
			hCntl = GetDlgItem( hDlg, CO_SEXCOMBO);
			SendMessage( hCntl, CB_ADDSTRING, NONE, (LONG)"None");
			SendMessage( hCntl, CB_ADDSTRING, LOW, (LONG)"Low");
			SendMessage( hCntl, CB_ADDSTRING, MEDIUM, (LONG)"Medium");
			SendMessage( hCntl, CB_ADDSTRING, HIGH, (LONG)"High");
			SendMessage( hCntl, CB_ADDSTRING, VERY_HIGH, (LONG)"Very High");

	// Fix MutationLevel Combo Box
			hCntl = GetDlgItem( hDlg, CO_MUTATINGCOMBO);
			SendMessage( hCntl, CB_ADDSTRING, NONE, (LONG)"None");
			SendMessage( hCntl, CB_ADDSTRING, LOW, (LONG)"Low");
			SendMessage( hCntl, CB_ADDSTRING, MEDIUM, (LONG)"Medium");
			SendMessage( hCntl, CB_ADDSTRING, HIGH, (LONG)"High");
			SendMessage( hCntl, CB_ADDSTRING, VERY_HIGH, (LONG)"Very High");

	// Fix ZapLevel Combo Box
			hCntl = GetDlgItem( hDlg, CO_ZAPPINGCOMBO);
			SendMessage( hCntl, CB_ADDSTRING, NONE, (LONG)"None");
			SendMessage( hCntl, CB_ADDSTRING, LOW, (LONG)"Low");
			SendMessage( hCntl, CB_ADDSTRING, MEDIUM, (LONG)"Medium");
			SendMessage( hCntl, CB_ADDSTRING, HIGH, (LONG)"High");

	// Fix TranspositionLevel Combo Box
			hCntl = GetDlgItem( hDlg, CO_TRANSPOSINGCOMBO);
			SendMessage( hCntl, CB_ADDSTRING, NONE, (LONG)"None");
			SendMessage( hCntl, CB_ADDSTRING, LOW, (LONG)"Low");
			SendMessage( hCntl, CB_ADDSTRING, MEDIUM, (LONG)"Medium");
			SendMessage( hCntl, CB_ADDSTRING, HIGH, (LONG)"High");

			showcurrparams(hDlg);

			return TRUE;

		case WM_RBUTTONDOWN:
		case WM_CLOSE:
			DestroyWindow( hDlg );
			return TRUE;

		case WM_DESTROY:
			CheckMenuItem( GetMenu(hwnd),IDM_COLONY,
			MF_BYCOMMAND | MF_UNCHECKED);
			hDlgColony = 0; // Turn off modeless handle
			InvalidateRect (hwnd, NULL, TRUE); // Clear whole screen
				// else see persistence of old crud from underneath
			return TRUE;

		case WM_MOVE:
			GetWindowRect(hDlg, &rect);
			wsprintf((LPSTR)buf,"%i",rect.left);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"ColonyX",(LPSTR)buf);
			wsprintf((LPSTR)buf,"%i",rect.top);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"ColonyY",(LPSTR)buf);
			return TRUE;

		case WM_COMMAND:
			switch ( wParam )
			{
				case CO_MULTIPLICATIONCOMBO:
					currdeathlevel = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case CO_SEXCOMBO:
					currsexlevel = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case CO_MUTATINGCOMBO:
					currmutationlevel = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case CO_ZAPPINGCOMBO:
					currzaplevel = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case CO_TRANSPOSINGCOMBO:
					currtranspositionlevel = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case CO_EXOGAMY:
					currexogamyflag ^= 1;
					CheckDlgButton( hDlg, CO_EXOGAMY,
						(currexogamyflag) ?
						MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_ENDOGAMY:
					currendogamyflag ^= 1;
					CheckDlgButton( hDlg, CO_ENDOGAMY,
						(currendogamyflag) ?
						MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_ONECOLONY:
					// Changing individual colony edit number
					editcolonyid++;
					if (editcolonyid >= colonycount)
						editcolonyid = 0;  // Always do for safety.
					showcurrparams(hDlg);
					break;

				case CO_HITMINUS:
					if (--currhitradius < 1)
						currhitradius = 1;
					label( hDlg, CO_HIT, "Radius",
						currhitradius );
					break;

				case CO_HITPLUS:
					currhitradius++;
					if (currhitradius > MAX_HITRADIUS)
						currhitradius = MAX_HITRADIUS;
					label( hDlg, CO_HIT, "Radius",
						currhitradius );
					break;

				case CO_RECRUIT:
					currrecruitpreyflag ^= 1;
					CheckDlgButton( hDlg, CO_RECRUIT,
						(currrecruitpreyflag) ?
						MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_MINMOTIONMINUS:
					if (currmintotalmotion - 20 < 1)
						currmintotalmotion = 1;
					else
						currmintotalmotion -= 20;
					label( hDlg, CO_MINMOTION, "Minimum Motion",
						currmintotalmotion );
					break;

				case CO_MINMOTIONPLUS:
					currmintotalmotion += 20;
					label( hDlg, CO_MINMOTION, "Minimum Motion",
						currmintotalmotion );
					break;

				case CO_LOWMOTIONMINUS:
					currlowmotionvalue -= 10;
					label( hDlg, CO_LOWMOTION, "Penalty",
						currlowmotionvalue );
					break;

				case CO_LOWMOTIONPLUS:
					currlowmotionvalue += 10;
					if (currlowmotionvalue > 0)
						currlowmotionvalue = 0;
					label( hDlg, CO_LOWMOTION, "Penalty",
						currlowmotionvalue );
					break;

				case CO_ENTROPYMINUS:
					if (currtargetentropy - 10 < 0)
						currtargetentropy = 0;
					else
						currtargetentropy -= 10;
					label( hDlg, CO_ENTROPY, "Target Entropy",
						currtargetentropy );
					break;

				case CO_ENTROPYPLUS:
					if (currtargetentropy + 10 > 100)
						currtargetentropy = 100;
					else
						currtargetentropy += 10;
					label( hDlg, CO_ENTROPY, "Target Entropy",
						currtargetentropy );
					break;

				case CO_GOODENTROPYMINUS:
					currgoodentropyvalue -= 10;
					if (currgoodentropyvalue < 0)
						currgoodentropyvalue = 0;
					label( hDlg, CO_GOODENTROPYVALUE,
						"Maximum Bonus",
						currgoodentropyvalue );
					break;

				case CO_GOODENTROPYPLUS:
					currgoodentropyvalue += 10;
					label( hDlg, CO_GOODENTROPYVALUE,
						"Maximum Bonus",
						currgoodentropyvalue );
					break;

				case CO_TURGENE:
					currmetazapcode ^= MZ_TURMITE;
					CheckDlgButton( hDlg, CO_TURGENE,
						(currmetazapcode & MZ_TURMITE)
						?MF_CHECKED:MF_UNCHECKED);
					break;

#ifdef BOIDGENE
				case CO_BOIDGENE:
					currmetazapcode ^= MZ_BOID;
					CheckDlgButton( hDlg, CO_BOIDGENE,
						(currmetazapcode & MZ_BOID)
						?MF_CHECKED:MF_UNCHECKED);
					break;
#endif //BOIDGENE

				case CO_MOTION:
					currmetazapcode ^= MZ_MOTION;
					CheckDlgButton( hDlg, CO_MOTION,
						(currmetazapcode & MZ_MOTION )
						?MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_BASESPEED:
					currmetazapcode ^= MZ_BASESPEED;
					CheckDlgButton( hDlg, CO_BASESPEED,
						(currmetazapcode & MZ_BASESPEED)?
						MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_RADIUS:
					currmetazapcode ^= MZ_RADIUS;
					CheckDlgButton( hDlg, CO_RADIUS,
						(currmetazapcode & MZ_RADIUS)?
						MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_LINES:
					currmetazapcode ^= MZ_LINES;
					CheckDlgButton( hDlg, CO_LINES,
						(currmetazapcode & MZ_LINES )?
						MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_DIRECTIONS:
					currmetazapcode ^= MZ_DIRECTIONS;
					CheckDlgButton( hDlg, CO_DIRECTIONS,
						(currmetazapcode & MZ_DIRECTIONS )
						?MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_STATES:
					currmetazapcode ^= MZ_STATES;
					CheckDlgButton( hDlg, CO_STATES,
						(currmetazapcode & MZ_STATES)?
						MF_CHECKED:MF_UNCHECKED);
					break;

				case CO_BREEDMINUS:
					if (currbreedtime > MAXBREEDTIME)
					{
						currbreedtime = MAXBREEDTIME;
						currbreedflag = 1;
					}
					else if (currbreedtime/2 >= MINBREEDTIME)
						currbreedtime /= 2;
					else
						currbreedtime = MINBREEDTIME;
					if (!currbreedflag)
						SetWindowText( GetDlgItem( hDlg,
						CO_BREED) , (LPSTR)
						"No Breeding");
					else
						numlabel( hDlg, CO_BREED,
							currbreedtime );
					break;


				case CO_BREEDPLUS:
					if (currbreedtime < MAXBREEDTIME)
						currbreedtime *= 2;
					if (currbreedtime >= MAXBREEDTIME)
					{
						currbreedtime = MAXBREEDTIME + 1;
						currbreedflag = 0;
					}
					if (!currbreedflag)
						SetWindowText( GetDlgItem( hDlg,
						CO_BREED) , (LPSTR)
						"No Breeding");
					else
						numlabel( hDlg, CO_BREED,
							currbreedtime );
					break;

				case CO_APPLY:
					Colony[editcolonyid].hitradius = currhitradius;
					Colony[editcolonyid].deathlevel = currdeathlevel;
					Colony[editcolonyid].sexlevel = currsexlevel;
					Colony[editcolonyid].mutationlevel = currmutationlevel;
					Colony[editcolonyid].zaplevel = currzaplevel;
					Colony[editcolonyid].transpositionlevel =
						currtranspositionlevel;
					Colony[editcolonyid].metazapcode =
						currmetazapcode;
					Colony[editcolonyid].breedtime = currbreedtime;
					Colony[editcolonyid].breedflag = currbreedflag;
					Colony[editcolonyid].exogamyflag = currexogamyflag;
					Colony[editcolonyid].endogamyflag = currendogamyflag;
					Colony[editcolonyid].recruitpreyflag =
						currrecruitpreyflag;
					Colony[editcolonyid].lowmotionvalue =
						currlowmotionvalue;
					Colony[editcolonyid].mintotalmotion =
						currmintotalmotion;
					Colony[editcolonyid].targetentropy =
						currtargetentropy;
					Colony[editcolonyid].goodentropyvalue =
						currgoodentropyvalue;
					break;


				case CO_APPLY_ALL:
					// Now put all the new values into Colonys
					for (i = 0; i< MAXCOLONIES; i++)
					{
							
						Colony[i].hitradius = currhitradius;
						Colony[i].deathlevel = currdeathlevel;
						Colony[i].sexlevel = currsexlevel;
						Colony[i].mutationlevel = currmutationlevel;
						Colony[i].zaplevel = currzaplevel;
						Colony[i].transpositionlevel =
							currtranspositionlevel;
						Colony[i].metazapcode =
							currmetazapcode;
						Colony[i].breedtime = currbreedtime;
						Colony[i].breedflag = currbreedflag;
						Colony[i].exogamyflag = currexogamyflag;
						Colony[i].endogamyflag = currendogamyflag;
						Colony[i].recruitpreyflag =
							currrecruitpreyflag;
						Colony[i].lowmotionvalue =
							currlowmotionvalue;
						Colony[i].mintotalmotion =
							currmintotalmotion;
						Colony[i].targetentropy =
							currtargetentropy;
						Colony[i].goodentropyvalue =
							currgoodentropyvalue;
					}
					break;

				case CO_CANCEL:
					DestroyWindow(hDlg);
					//EndDialog( hDlg, TRUE );
					break;

				default:
					break;
			}
			return TRUE; // End of WM_COMMAND case in main switch.

		default:
			return FALSE; // Case where message means nothing to me.
	}
}

void showcurrparams(HWND hDlg)
{
			SetWindowText( GetDlgItem( hDlg, CO_ONECOLONY),
				(LPSTR)((editcolonyid==0)?"Green Colony":
				((editcolonyid==1)?"Red Colony":"Blue Colony")));
			SetWindowText( GetDlgItem( hDlg, CO_APPLY),
				(LPSTR)((editcolonyid==0)?"&DO IT TO GREEN!":
				((editcolonyid==1)?"&DO IT TO RED!":
				"DO IT TO BLUE!")));
			currhitradius = Colony[editcolonyid].hitradius;
			currdeathlevel = Colony[editcolonyid].deathlevel;
			currsexlevel = Colony[editcolonyid].sexlevel;
			currmutationlevel = Colony[editcolonyid].mutationlevel;
			currzaplevel = Colony[editcolonyid].zaplevel;
			currtranspositionlevel = Colony[editcolonyid].transpositionlevel;
			currmetazapcode = Colony[editcolonyid].metazapcode;
			currbreedtime = Colony[editcolonyid].breedtime;
			currbreedflag = Colony[editcolonyid].breedflag;
			currexogamyflag = Colony[editcolonyid].exogamyflag;
			currendogamyflag = Colony[editcolonyid].endogamyflag;
			currrecruitpreyflag = Colony[editcolonyid].recruitpreyflag;
			currlowmotionvalue = Colony[editcolonyid].lowmotionvalue;
			currmintotalmotion = Colony[editcolonyid].mintotalmotion;
			currtargetentropy =
				Colony[editcolonyid].targetentropy;
			currgoodentropyvalue =
				Colony[editcolonyid].goodentropyvalue;

			SendMessage(GetDlgItem( hDlg, CO_MULTIPLICATIONCOMBO),
				CB_SETCURSEL, (WORD)currdeathlevel, 0);
			SendMessage( GetDlgItem( hDlg, CO_SEXCOMBO), CB_SETCURSEL,
				(WORD)currsexlevel, 0);
			SendMessage(GetDlgItem( hDlg, CO_MUTATINGCOMBO),
				CB_SETCURSEL, (WORD)currmutationlevel, 0);
			SendMessage( GetDlgItem( hDlg, CO_ZAPPINGCOMBO),
				CB_SETCURSEL, (WORD)currzaplevel, 0);
			SendMessage(GetDlgItem( hDlg, CO_TRANSPOSINGCOMBO) ,
				CB_SETCURSEL, (WORD)currtranspositionlevel, 0);
			CheckDlgButton( hDlg, CO_EXOGAMY,
				(currexogamyflag) ?
				MF_CHECKED:MF_UNCHECKED);
			CheckDlgButton( hDlg, CO_ENDOGAMY,
				(currendogamyflag) ?
				MF_CHECKED:MF_UNCHECKED);

			CheckDlgButton( hDlg, CO_TURGENE,
				(currmetazapcode & MZ_TURMITE) ?
				MF_CHECKED:MF_UNCHECKED);
#ifdef BOIDGENE
			CheckDlgButton( hDlg, CO_BOIDGENE,
				(currmetazapcode & MZ_BOID) ?
				MF_CHECKED:MF_UNCHECKED);
#endif //BOIDGENE
            CheckDlgButton( hDlg, CO_MOTION,
				(currmetazapcode & MZ_MOTION ) ?
				MF_CHECKED:MF_UNCHECKED);
			CheckDlgButton( hDlg, CO_BASESPEED,
				(currmetazapcode & MZ_BASESPEED)?
				MF_CHECKED:MF_UNCHECKED);
			CheckDlgButton( hDlg, CO_RADIUS,
				(currmetazapcode & MZ_RADIUS) ?
				MF_CHECKED:MF_UNCHECKED);
			CheckDlgButton( hDlg, CO_LINES,
				(currmetazapcode & MZ_LINES) ?
				MF_CHECKED:MF_UNCHECKED);
			CheckDlgButton( hDlg, CO_DIRECTIONS,
				(currmetazapcode & MZ_DIRECTIONS ) ?
				MF_CHECKED:MF_UNCHECKED);
			CheckDlgButton( hDlg, CO_STATES,
				(currmetazapcode & MZ_STATES )?
				MF_CHECKED:MF_UNCHECKED);

			if (!currbreedflag)
				SetWindowText( GetDlgItem( hDlg,
					CO_BREED) , (LPSTR)
					"No Breeding");
			else
				numlabel( hDlg, CO_BREED, currbreedtime );

			CheckDlgButton( hDlg, CO_RECRUIT,
				(currrecruitpreyflag) ?
				MF_CHECKED:MF_UNCHECKED);
			label( hDlg, CO_HIT, "Radius", currhitradius );
			label( hDlg, CO_MINMOTION, "Minimum Motion",
				currmintotalmotion );
			label( hDlg, CO_LOWMOTION, "Penalty",
				currlowmotionvalue );
			label( hDlg, CO_ENTROPY, "Target Entropy",
				currtargetentropy );
			label( hDlg, CO_GOODENTROPYVALUE, "Maximum Bonus",
				currgoodentropyvalue );

			CheckRadioButton( hDlg, CO_ONECOLONY, CO_ONECOLONY,
				CO_ONECOLONY);


}