/*
bmlib.h BITMAP FUNCTION DLL for Windows 3
  Schlocked together 7/91 John Castellucci

LoadDIB Loads a bitmap into memory from disk (load it into a global handle
             so you can unload it properly to free up memory
        Returnx POINT with x width, y height
DrawDIB Draws a bitmap from handle to HDC - at x, y
UnloadDIB Removes Bitmap from memory

Import functions explicity in .DEF file (example)

IMPORTS
    DIBLIB.LoadDIB
    DIBLIB.UnLoadDIB
    DIBLIB.DrawDIB
    DIBLIB.StretchDIB
*/

HBITMAP FAR PASCAL LoadDIB(HWND hWnd, char *bitmapfilename, BOOL showerror);
POINT FAR PASCAL DrawDIB( HDC, HBITMAP, short xorigin, short yorigin);
POINT FAR PASCAL StretchDIB( HDC, HBITMAP, short xorigin, short yorigin, double stretchfactor);
BOOL FAR PASCAL UnloadDIB(HBITMAP hBM);

#define BLOCK_SIZE 32000

