#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#pragma hdrsstop
#include "ecology.h"

extern char szAppName[];
extern unsigned char ecology;
extern short bugeatvalue[MAXCOLONIES][MAXCOLONIES];
extern struct bug *Bug[];
extern struct colony Colony[];
extern unsigned char editcolony, colonycount;
extern void numlabel( HWND hwnd, int button, short d );
//void label( HWND, int, char *, short );
//extern void numlabel( HWND , int , short );
void standardfood(HWND);

static short idarray[MAXCOLONIES][MAXCOLONIES] = {{EC_00,EC_01,EC_02},{EC_10,EC_11,EC_12},{EC_20,EC_21,EC_22}};
static short editbutton = EC_00;

extern void installbugeatvalue(void);
extern HWND hDlgEcology, hwnd;

static short newfoodvalue[MAXCOLONIES];
static short newpoisonvalue[MAXCOLONIES];
static short newwallvalue[MAXCOLONIES];
static short newhitpreyvalue[MAXCOLONIES];
static short newothervalue[MAXCOLONIES];


#ifdef CYBER
extern "C" BOOL FAR PASCAL EcologyProc( HWND hDlg, WORD message, WORD wParam, LONG lParam )
#else
BOOL FAR PASCAL EcologyProc( HWND hDlg, WORD message, WORD wParam, LONG lParam )
#endif // CYBER
{
	unsigned char i, j;
	short inc;
	// Make working copies of the params.
	static short newecology;
	static short newbugeatvalue[MAXCOLONIES][MAXCOLONIES];
	// To save the position
	RECT rect;
	char buf[32];

	switch( message )
	{
		case WM_DESTROY:
			CheckMenuItem( GetMenu(hwnd),IDM_ECOLOGY,MF_BYCOMMAND |
				MF_UNCHECKED);
			hDlgEcology=0;
			InvalidateRect (hwnd, NULL, TRUE); // Clear whole screen
				// else see persistence of old crud from underneath
			return TRUE;

			case WM_RBUTTONDOWN:
			case WM_CLOSE:
				DestroyWindow( hDlg );
			return TRUE;

		case WM_INITDIALOG:
			CheckMenuItem( GetMenu(hwnd),IDM_ECOLOGY,MF_BYCOMMAND |
				MF_CHECKED);
			newecology = ecology;
			for (i = 0; i< MAXCOLONIES; i++)
			{
				for (j = 0; j< MAXCOLONIES; j++)
				{
					newbugeatvalue[i][j] = bugeatvalue[i][j];
					numlabel(hDlg, idarray[i][j],
						newbugeatvalue[i][j]);
				}
				newfoodvalue[i] = Colony[i].foodvalue;
				newpoisonvalue[i] = Colony[i].poisonvalue;
				newwallvalue[i] = Colony[i].wallvalue;
				newhitpreyvalue[i] = Colony[i].hitpreyvalue;
				newothervalue[i] = Colony[i].othervalue;
				numlabel( hDlg, EC_0F + i, newfoodvalue[i]);
				numlabel( hDlg, EC_0P + i, newpoisonvalue[i]);
				numlabel( hDlg, EC_0W + i, newwallvalue[i]);
				numlabel( hDlg, EC_0H + i, newhitpreyvalue[i]);
				numlabel( hDlg, EC_0X + i, newothervalue[i]);
			}
			newecology = ecology;
			CheckRadioButton( hDlg, EC_FREEFORALL, EC_USER,
				EC_FREEFORALL + newecology );
			CheckRadioButton( hDlg, EC_00, EC_2X, editbutton);
			return TRUE;

		case WM_MOVE:
			GetWindowRect(hDlg, &rect);
			wsprintf((LPSTR)buf,"%i",rect.left);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"EcologyX",(LPSTR)buf);
			wsprintf((LPSTR)buf,"%i",rect.top);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"EcologyY",(LPSTR)buf);
			return TRUE;

		case WM_COMMAND:
			switch ( wParam )
			{
				case EC_00:
				case EC_10:
				case EC_20:
				case EC_01:
				case EC_11:
				case EC_21:
				case EC_02:
				case EC_12:
				case EC_22:
				case EC_0F:
				case EC_1F:
				case EC_2F:
				case EC_0P:
				case EC_1P:
				case EC_2P:
				case EC_0W:
				case EC_1W:
				case EC_2W:
				case EC_0H:
				case EC_1H:
				case EC_2H:
				case EC_0X:
				case EC_1X:
				case EC_2X:
					editbutton = wParam;
					CheckRadioButton( hDlg, EC_00, EC_2X, editbutton);
					break;

				case EC_MINUS:
				case EC_PLUS:
					inc = (wParam == EC_MINUS)?-1:1;
					switch (editbutton)
					{
						case EC_00:
							newbugeatvalue[0][0] += inc;
							numlabel(hDlg, EC_00, newbugeatvalue[0][0]);
							break;
						case EC_10:
							newbugeatvalue[1][0] += inc;
							numlabel(hDlg, EC_10, newbugeatvalue[1][0]);
							break;
						case EC_20:
							newbugeatvalue[2][0] += inc;
							numlabel(hDlg, EC_20, newbugeatvalue[2][0]);
							break;
						case EC_01:
							newbugeatvalue[0][1] += inc;
							numlabel(hDlg, EC_01, newbugeatvalue[0][1]);
							break;
						case EC_11:
							newbugeatvalue[1][1] += inc;
							numlabel(hDlg, EC_11, newbugeatvalue[1][1]);
							break;
						case EC_21:
							newbugeatvalue[2][1] += inc;
							numlabel(hDlg, EC_21, newbugeatvalue[2][1]);
							break;
						case EC_02:
							newbugeatvalue[0][2] += inc;
							numlabel(hDlg, EC_02, newbugeatvalue[0][2]);
							break;
						case EC_12:
							newbugeatvalue[1][2] += inc;
							numlabel(hDlg, EC_12, newbugeatvalue[1][2]);
							break;
						case EC_22:
							newbugeatvalue[2][2] += inc;
							numlabel(hDlg, EC_22, newbugeatvalue[2][2]);
							break;
						case EC_0F:
							newfoodvalue[0] += inc;
							numlabel(hDlg, EC_0F, newfoodvalue[0]);
							break;
						case EC_1F:
							newfoodvalue[1] += inc;
							numlabel(hDlg, EC_1F, newfoodvalue[1]);
							break;
						case EC_2F:
							newfoodvalue[2] += inc;
							numlabel(hDlg, EC_2F, newfoodvalue[2]);
							break;
						case EC_0P:
							newpoisonvalue[0] += inc;
							numlabel(hDlg, EC_0P, newpoisonvalue[0]);
							break;
						case EC_1P:
							newpoisonvalue[1] += inc;
							numlabel(hDlg, EC_1P, newpoisonvalue[1]);
							break;
						case EC_2P:
							newpoisonvalue[2] += inc;
							numlabel(hDlg, EC_2P, newpoisonvalue[2]);
							break;
						case EC_0W:
							newwallvalue[0] += inc;
							numlabel(hDlg, EC_0W, newwallvalue[0]);
							break;
						case EC_1W:
							newwallvalue[1] += inc;
							numlabel(hDlg, EC_1W, newwallvalue[1]);
							break;
						case EC_2W:
							newwallvalue[2] += inc;
							numlabel(hDlg, EC_2W, newwallvalue[2]);
							break;
						case EC_0H:
							newhitpreyvalue[0] += inc * 20;
							numlabel(hDlg, EC_0H, newhitpreyvalue[0]);
							break;
						case EC_1H:
							newhitpreyvalue[1] += inc * 20;
							numlabel(hDlg, EC_1H, newhitpreyvalue[1]);
							break;
						case EC_2H:
							newhitpreyvalue[2] += inc * 20;
							numlabel(hDlg, EC_2H, newhitpreyvalue[2]);
							break;
						case EC_0X:
							newothervalue[0] += inc;
							numlabel(hDlg, EC_0X, newothervalue[0]);
							break;
						case EC_1X:
							newothervalue[1] += inc;
							numlabel(hDlg, EC_1X, newothervalue[1]);
							break;
						case EC_2X:
							newothervalue[2] += inc;
							numlabel(hDlg, EC_2X, newothervalue[2]);
							break;
					}
					newecology = USER;
					CheckRadioButton( hDlg, EC_FREEFORALL, EC_USER,
						EC_USER );
					break;

				case EC_FREEFORALL:
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
						{
							newbugeatvalue[i][j] = (i!=j)?1:0;
							numlabel( hDlg, idarray[i][j],
								newbugeatvalue[i][j]);
						}
					standardfood(hDlg);
					newecology = FREE_FOR_ALL; // 0
					CheckRadioButton( hDlg, EC_FREEFORALL,
						EC_USER, EC_FREEFORALL + newecology );
					break;

				case EC_FOOD_LOOP:
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
						{
							newbugeatvalue[i][j] = (j==i-1)?2:
								((j==i+1)?-1:0);
						}
					newbugeatvalue[0][2] = 2;
					newbugeatvalue[2][0] = -1;
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
							numlabel( hDlg, idarray[i][j],
								newbugeatvalue[i][j]);
					standardfood(hDlg);
					newecology = PREDATION_LOOP; // 1
					CheckRadioButton( hDlg, EC_FREEFORALL,
						EC_USER, EC_FREEFORALL + newecology );
					break;

				case EC_FOOD_CHAIN:
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
						{
							newbugeatvalue[i][j] = (j==i-1)?2:
								((j==i+1)?-1:0);
							numlabel( hDlg, idarray[i][j],
								newbugeatvalue[i][j]);
						}
					newecology = PREDATION_CHAIN; // 2
					standardfood(hDlg);
					CheckRadioButton( hDlg, EC_FREEFORALL,
						EC_USER, EC_FREEFORALL + newecology );
					break;

				case EC_MELLOW: // Actually two grazers on
					// spreading species 0.
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
						{
							newbugeatvalue[i][j] = 0;
						}
					newbugeatvalue[0][1] = 1;
					newbugeatvalue[0][2] = 2;
					newbugeatvalue[1][0] = 2;
					newbugeatvalue[1][2] = -1;
					newbugeatvalue[2][1] = 2;
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
							numlabel( hDlg, idarray[i][j],
								newbugeatvalue[i][j]);
					standardfood(hDlg);
					newecology = MELLOW; // 3
					CheckRadioButton( hDlg, EC_FREEFORALL,
						EC_USER, EC_FREEFORALL + newecology );
					break;

				case EC_TWO_PREY:
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
						{
							newbugeatvalue[i][j] = 0;
						}
					newbugeatvalue[2][1] = 2;
					newbugeatvalue[1][2] = -1;
					newbugeatvalue[2][0] = 2;
					newbugeatvalue[0][2] = -1;
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
							numlabel( hDlg, idarray[i][j],
								newbugeatvalue[i][j]);
					standardfood(hDlg);
					newecology = TWO_PREY; // 4
					CheckRadioButton( hDlg, EC_FREEFORALL,
						EC_USER, EC_FREEFORALL + newecology );
					break;

				case EC_TWO_PRED:
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
						{
							newbugeatvalue[i][j] = 0;
						}
					standardfood(hDlg);
					newbugeatvalue[2][0] = 2;
					newbugeatvalue[0][2] = -1;
					newbugeatvalue[1][0] = 2;
					newbugeatvalue[0][1] = -1;
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
							numlabel( hDlg, idarray[i][j],
								newbugeatvalue[i][j]);
					newecology = TWO_PRED; // 5
					CheckRadioButton( hDlg, EC_FREEFORALL,
						EC_USER, EC_FREEFORALL + newecology );
					break;

				case EC_NO_EAT:
					for (i = 0; i< MAXCOLONIES; i++)
						for (j = 0; j< MAXCOLONIES; j++)
						{
							newbugeatvalue[i][j] = 0;
							numlabel( hDlg, idarray[i][j],
								newbugeatvalue[i][j]);
						}
					standardfood(hDlg);
					newecology = NO_EAT; // 6
					CheckRadioButton( hDlg, EC_FREEFORALL,
						EC_USER, EC_FREEFORALL + newecology );
					break;

				case EC_USER:
					break; //7

				case EC_APPLY:
					for (i = 0; i< MAXCOLONIES; i++)
					{
						for (j = 0; j< MAXCOLONIES; j++)
							bugeatvalue[i][j] =
								 newbugeatvalue[i][j];
						Colony[i].foodvalue = newfoodvalue[i];
						Colony[i].poisonvalue = newpoisonvalue[i];
						Colony[i].wallvalue = newwallvalue[i];
						Colony[i].hitpreyvalue = newhitpreyvalue[i];
						Colony[i].othervalue = newothervalue[i];
					}
					ecology = newecology;
					installbugeatvalue();
					// Put values into self, jabber, wocky of cols.
					break;

				case EC_CANCEL:
					DestroyWindow( hDlg );
					return TRUE;
			}
			return TRUE; // End of WM_COMMAND case in main switch.

		default:
			return FALSE; // Case where message means nothing to me.
	}
}

void standardfood(HWND hDlg)
{
	unsigned char i;

	for (i = 0; i< MAXCOLONIES; i++)
	{
		newfoodvalue[i] = 3;
		numlabel( hDlg, EC_0F + i, 3);
		newpoisonvalue[i] = -2;
		numlabel( hDlg, EC_0P + i,-2);
		newwallvalue[i] = 0;
		numlabel( hDlg, EC_0W + i, 0);
		newhitpreyvalue[i] = 100;
		numlabel( hDlg, EC_0X + i, 100);
		newothervalue[i] = 0;
		numlabel( hDlg, EC_0X + i, 0);
	}
}
