
#include "bug.h"
#include "bugmenu.h"
#include "random.h"
#include <windows.h>
#pragma hdrstop
#include "gene.h"
#define MOTHER_X 6
#define MOTHER_Y 65
#define FATHER_X 102
#define FATHER_Y 65
#define CHILD_X 207
#define CHILD_Y 65
#define MOTHER 0
#define FATHER 1
#define CHILD 2

// These hold the actual size of the gene bitmap. The CX gets reset
// inside the drawgenes function calls to match the dna legnth of the bug.
int mothergene_CX, mothergene_CY = 1, fathergene_CX, fathergene_CY=1,
	childgene_CX, childgene_CY=1;
 unsigned char childcolonyid, mothercolonyid, fathercolonyid;

extern float mutationlevellookup[];
extern HDC hdcBugLand;
extern COLORREF bugpalette[];
extern unsigned char weak_pal_index[];
extern unsigned char strong_pal_index[];

extern COLORREF poisoncolor, foodcolor, blankcolor;
extern unsigned char editbugid, colonycount, livebugcount;
extern struct colony Colony[];
extern struct bug *Bug[];
extern unsigned char bugnum[];
extern HWND hDlgGene, hwnd;
extern char szAppName[];
extern HBITMAP hBitmapBugBody_2D[];
extern HDC hdcBugBody_2D[];
extern short	BugBody_2D_CX[],BugBody_2D_CY[];

extern void randomizegenes(struct bug *);
extern void DNAcross_at(struct bug *, struct bug *, struct bug *,
	short , unsigned char );
extern void DNAmutate(struct bug* p, Real mr);
extern void DNAtranspose(struct bug*);
extern void DNA_to_RNA(struct bug*);
extern void bugclone(struct bug*, struct bug*);
extern void label( HWND, int, char *, short );
extern void numlabel( HWND hwnd, int button, short d );
extern void DNAcross(struct bug *, struct bug *, struct bug *);


void near drawgenes(HDC, struct bug *, unsigned char);

#ifdef CYBER
extern "C" BOOL FAR PASCAL GeneProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#else
BOOL FAR PASCAL GeneProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#endif //CYBER
{
	unsigned char i;
	PAINTSTRUCT ps;
	HDC hdcGene;
	RECT rect;
	char buf[32];
	// Max size of a gene bitmap, given that I code 3 bytes per pixel
	static int gene_CX = DNALENGTH / 3, gene_CY = 1;
	static HDC hdcMothergenes, hdcFathergenes, hdcChildgenes;
	static HBITMAP hBitmapMothergenes, hBitmapMothergenesOld,
		hBitmapFathergenes, hBitmapFathergenesOld,
		hBitmapChildgenes, hBitmapChildgenesOld;
	
	static unsigned char childrank, motherrank, fatherrank;
	static short breedmethod = GE_MUTATE;
	static unsigned char childbugid, motherbugid, fatherbugid;
	unsigned char bodynumber; //Temp variable used for body images.
	static short dlgbasex, dlgbasey; //dialog box base units
	// positions of the bodyicon bitmaps
	static short mother_x, mother_y, father_x,
		father_y, child_x, child_y;
	// size and position of the geneimage bitmaps
	static short geneimage_CX, geneimage_CY = 30, mothergene_x = 3,
		mothergene_y = 3, fathergene_x = 3, fathergene_y = 38,
		childgene_x = 3, childgene_y = 73;

	switch( message )
	{
		case WM_INITDIALOG:
			GetWindowRect(hDlg, &rect);
			geneimage_CX = rect.right - rect.left - 7; //  for the frame
// The dialog control positions are given in integer values that
// have a pixel meaning dependent on the font.  See the GetDlgBaseUnits
// Windows API reference.  Yes, you divide by 4 for x, and by 8 for y.
// The CHILD_X, CHILD_Y and so on are gotten from the position of
// the controls as specified in CONTROL statements in gene.dlg.
			dlgbasex = LOWORD(GetDialogBaseUnits());
			dlgbasey = HIWORD(GetDialogBaseUnits());
			mother_x = (MOTHER_X * dlgbasex) / 4;
			mother_y = (MOTHER_Y * dlgbasey) / 8;
			father_x = (FATHER_X * dlgbasex) / 4;
			father_y = (FATHER_Y * dlgbasey) / 8;
			child_x = (CHILD_X * dlgbasex) / 4;
			child_y = (CHILD_Y * dlgbasey) / 8;
#define BASEUNIT_PROB
#ifdef BASEUNIT_PROB
			father_x -= 20;
			child_x -= 50;
#endif //BASEUNIT_PROB

			motherbugid = editbugid;
				
			mothercolonyid = Bug[motherbugid]->colonyid;
			for (i=0; i<Colony[mothercolonyid].pop; i++)
				if (Colony[mothercolonyid].rank[i] == motherbugid)
				{
					motherrank = i;
					break;
				}
			if (Colony[mothercolonyid].pop > 1)
				for (i=0; i<Colony[mothercolonyid].pop; i++)
					if (Colony[mothercolonyid].rank[i] != motherbugid)
					{
						fatherbugid = Colony[mothercolonyid].rank[i];
						break;
					}
			else
				fatherbugid = motherbugid;

			fathercolonyid = Bug[fatherbugid]->colonyid;
			for (i=0; i<Colony[fathercolonyid].pop; i++)
				if (Colony[fathercolonyid].rank[i] == fatherbugid)
				{
					fatherrank =i;
					break;
				}

			if (Colony[mothercolonyid].pop > 2)
				for (i=0; i<Colony[mothercolonyid].pop; i++)
					if (Colony[mothercolonyid].rank[i] != motherbugid &&
						Colony[mothercolonyid].rank[i] != fatherbugid)
					{
						childbugid = Colony[mothercolonyid].rank[i];
						break;
					}
			else
				childbugid = fatherbugid;

			childcolonyid = Bug[childbugid]->colonyid;
			for (i=0; i<Colony[childcolonyid].pop; i++)
				if (Colony[childcolonyid].rank[i] == childbugid)
				{
					childrank =i;
					break;
				}
			

			hdcMothergenes = CreateCompatibleDC(hdcBugLand);
			hBitmapMothergenes = CreateCompatibleBitmap(hdcBugLand,
				gene_CX, gene_CY);
			hBitmapMothergenesOld = SelectObject(hdcMothergenes,
				hBitmapMothergenes);
			SelectObject(hdcMothergenes, GetStockObject(WHITE_BRUSH));
			PatBlt(hdcMothergenes, 0, 0, gene_CX, gene_CY, PATCOPY);
			drawgenes(hdcMothergenes, Bug[motherbugid], MOTHER);
			
			hdcFathergenes = CreateCompatibleDC(hdcBugLand);
			hBitmapFathergenes = CreateCompatibleBitmap(hdcBugLand,
				gene_CX, gene_CY);
			hBitmapFathergenesOld = SelectObject(hdcFathergenes,
				hBitmapFathergenes);
			SelectObject(hdcFathergenes, GetStockObject(WHITE_BRUSH));
			PatBlt(hdcFathergenes, 0, 0, gene_CX, gene_CY, PATCOPY);
			drawgenes(hdcFathergenes, Bug[fatherbugid], FATHER);
			
			hdcChildgenes = CreateCompatibleDC(hdcBugLand);
			hBitmapChildgenes = CreateCompatibleBitmap(hdcBugLand,
				gene_CX, gene_CY);
			hBitmapChildgenesOld = SelectObject(hdcChildgenes,
				hBitmapChildgenes);
			SelectObject(hdcChildgenes, GetStockObject(WHITE_BRUSH));
			PatBlt(hdcChildgenes, 0, 0, gene_CX, gene_CY, PATCOPY);
			drawgenes(hdcChildgenes, Bug[childbugid], CHILD);

//			label( hDlg, GE_COLONYCHILD, "Colony",
//				(short)(childcolonyid + 1) );
			SetWindowText( GetDlgItem( hDlg, GE_COLONYCHILD),
				(LPSTR)((childcolonyid==0)?"Green Colony":
				((childcolonyid==1)?"Red Colony":"Blue Colony")));

			label( hDlg, GE_RANKCHILD, "Rank",
				(short)(childrank + 1) );
			label( hDlg, GE_CHILD, "Bug",
				(short)(childbugid + 1) );
			
//			label( hDlg, GE_COLONYMOTHER, "Colony",
//				(shor)(mothercolonyid + 1) );
			SetWindowText( GetDlgItem( hDlg, GE_COLONYMOTHER),
				(LPSTR)((mothercolonyid==0)?"Green Colony":
				((mothercolonyid==1)?"Red Colony":"Blue Colony")));
			label( hDlg, GE_RANKMOTHER, "Rank",
				(short)(motherrank + 1) );
			label( hDlg, GE_MOTHER, "Bug",
				(short)(motherbugid + 1) );

//			label( hDlg, GE_COLONYFATHER, "Colony",
//				(short)(fathercolonyid + 1) );
			SetWindowText( GetDlgItem( hDlg, GE_COLONYFATHER),
				(LPSTR)((fathercolonyid==0)?"Green Colony":
				((fathercolonyid==1)?"Red Colony":"Blue Colony")));
			label( hDlg, GE_RANKFATHER, "Rank",
				(short)(fatherrank + 1) );
			label( hDlg, GE_FATHER, "Bug",
				(short)(fatherbugid + 1) );

			CheckRadioButton( hDlg, GE_ZAP, GE_CLONE,
				breedmethod );

			CheckMenuItem( GetMenu(hwnd),
				IDM_GENE,MF_BYCOMMAND | MF_CHECKED);
			// To indicate that this dialog box is open.

			return TRUE;

		case WM_PAINT:
			hdcGene = BeginPaint( hDlg, &ps );

	//Erase with the WHITE_BRUSH in case new icon smaller than old one.
			SelectObject(hdcGene, GetStockObject(WHITE_BRUSH));
			PatBlt(hdcGene, mother_x, mother_y,
				BODYPATCH_X, BODYPATCH_Y, PATCOPY);
			bodynumber=Bug[motherbugid]->bodyid;
			// Draw the body
			StretchBlt(hdcGene, mother_x, mother_y, 2 * BugBody_2D_CX[bodynumber],
				2 * BugBody_2D_CY[bodynumber],
				hdcBugBody_2D[bodynumber], 0, 0,
				BugBody_2D_CX[bodynumber], BugBody_2D_CY[bodynumber],
				SRCCOPY);

			bodynumber=Bug[fatherbugid]->bodyid;
			// Draw the body
			StretchBlt(hdcGene, father_x, father_y, 2 * BugBody_2D_CX[bodynumber],
				2 * BugBody_2D_CY[bodynumber],
				hdcBugBody_2D[bodynumber], 0, 0,
				BugBody_2D_CX[bodynumber], BugBody_2D_CY[bodynumber],
				SRCCOPY);

			bodynumber=Bug[childbugid]->bodyid;
	// Draw the body
			StretchBlt(hdcGene, child_x, child_y, 2 * BugBody_2D_CX[bodynumber],
				2 * BugBody_2D_CY[bodynumber],
				hdcBugBody_2D[bodynumber], 0, 0,
				BugBody_2D_CX[bodynumber], BugBody_2D_CY[bodynumber],
				SRCCOPY);

	// Erase the old genemap
			PatBlt(hdcGene, mothergene_x, mothergene_y,
				geneimage_CX, geneimage_CY, PATCOPY);
	// Display the new genemap
			StretchBlt(hdcGene, mothergene_x, mothergene_y, geneimage_CX,
				geneimage_CY, hdcMothergenes, 0, 0,
				mothergene_CX, mothergene_CY, SRCCOPY);

	// Erase the old genemap
			PatBlt(hdcGene, fathergene_x, fathergene_y,
				geneimage_CX, geneimage_CY, PATCOPY);
	// Display the new genemap
			StretchBlt(hdcGene, fathergene_x, fathergene_y, geneimage_CX,
				geneimage_CY, hdcFathergenes, 0, 0,
				fathergene_CX, fathergene_CY, SRCCOPY);

	// Erase the old genemap
			PatBlt(hdcGene, childgene_x, childgene_y,
				geneimage_CX, geneimage_CY, PATCOPY);
	// Display the new genemap
			StretchBlt(hdcGene, childgene_x, childgene_y, geneimage_CX,
				geneimage_CY, hdcChildgenes, 0, 0,
				childgene_CX, childgene_CY, SRCCOPY);
			
			EndPaint( hDlg, &ps );
			return TRUE;

		case WM_MOVE:
			GetWindowRect(hDlg, &rect);
			wsprintf((LPSTR)buf,"%i",rect.left);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"GeneX",
				(LPSTR)buf);
			wsprintf((LPSTR)buf,"%i",rect.top);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"GeneY",
				(LPSTR)buf);
			return TRUE;

		case WM_COMMAND:
			switch ( wParam )
			{
				case GE_RANKMOTHER:
					if (++motherrank >= Colony[mothercolonyid].pop)
						motherrank = 0;
					motherbugid = Colony[mothercolonyid].rank[
						motherrank];
					label( hDlg, GE_RANKMOTHER, "Rank",
						(short)(motherrank + 1) );
					label( hDlg, GE_MOTHER, "Bug",
						(short)(motherbugid + 1) );
	//Now invalidate the old icon rect to be redrawn by WM_PAINT
					rect.left = mother_x;
					rect.top = mother_y;
					rect.right = rect.left + BODYPATCH_X;
					rect.bottom = rect.top+ BODYPATCH_Y;
					InvalidateRect(hDlg, &rect, TRUE);
	// Now fix the new gene bitmap
					PatBlt(hdcMothergenes, 0, 0, gene_CX, gene_CY,
						PATCOPY);
					drawgenes(hdcMothergenes, Bug[motherbugid],
						MOTHER);
	//Now invalidate the old gene rect to be redrawn by WM_PAINT
					rect.left = mothergene_x;
					rect.top = mothergene_y;
					rect.right = rect.left + geneimage_CX;
					rect.bottom = rect.top + geneimage_CY;
					InvalidateRect(hDlg, &rect, TRUE);
					break;

				case GE_COLONYMOTHER:
					if (++mothercolonyid >= MAXCOLONIES)
						mothercolonyid = 0;
					// If you hit an empty pop, keep bumping.
					while (!Colony[mothercolonyid].pop)
						if (++mothercolonyid >= MAXCOLONIES)
							mothercolonyid = 0;
					motherbugid = Colony[mothercolonyid].rank[0];
					motherrank = 0;
//					label( hDlg, GE_COLONYMOTHER, "Colony",
//						(short)(mothercolonyid + 1) );
			SetWindowText( GetDlgItem( hDlg, GE_COLONYMOTHER),
				(LPSTR)((mothercolonyid==0)?"Green Colony":
				((mothercolonyid==1)?"Red Colony":"Blue Colony")));
					label( hDlg, GE_RANKMOTHER, "Rank",
						(short)(motherrank + 1) );
					label( hDlg, GE_MOTHER, "Bug",
						(short)(motherbugid + 1) );
	//Now invalidate the old icon rect to be redrawn by WM_PAINT
					rect.left = mother_x;
					rect.top = mother_y;
					rect.right = rect.left + BODYPATCH_X;
					rect.bottom = rect.top+ BODYPATCH_Y;
					InvalidateRect(hDlg, &rect, TRUE);
	// Now fix the new gene bitmap
					PatBlt(hdcMothergenes, 0, 0, gene_CX, gene_CY,
						PATCOPY);
					drawgenes(hdcMothergenes, Bug[motherbugid],
						MOTHER);
	//Now invalidate the old gene rect to be redrawn by WM_PAINT
					rect.left = mothergene_x;
					rect.top = mothergene_y;
					rect.right = rect.left + geneimage_CX;
					rect.bottom = rect.top + geneimage_CY;
					InvalidateRect(hDlg, &rect, TRUE);
					break;


				case GE_RANKFATHER:
					if (++fatherrank >= Colony[fathercolonyid].pop)
						fatherrank = 0;
					fatherbugid = Colony[fathercolonyid].rank[
						fatherrank];
					label( hDlg, GE_RANKFATHER, "Rank",
						(short)(fatherrank + 1) );
					label( hDlg, GE_FATHER, "Bug",
						(short)(fatherbugid + 1) );
	//Now invalidate the old icon rect to be redrawn by WM_PAINT
					rect.left = father_x;
					rect.top = father_y;
					rect.right = rect.left + BODYPATCH_X;
					rect.bottom = rect.top+ BODYPATCH_Y;
					InvalidateRect(hDlg, &rect, TRUE);
	// Now fix the new gene bitmap
					PatBlt(hdcFathergenes, 0, 0, gene_CX, gene_CY,
						PATCOPY);
					drawgenes(hdcFathergenes, Bug[fatherbugid]
						, FATHER);
	//Now invalidate the old gene rect to be redrawn by WM_PAINT
					rect.left = fathergene_x;
					rect.top = fathergene_y;
					rect.right = rect.left + geneimage_CX;
					rect.bottom = rect.top + geneimage_CY;
					InvalidateRect(hDlg, &rect, TRUE);
					break;

				case GE_COLONYFATHER:
					if (++fathercolonyid >= MAXCOLONIES)
						fathercolonyid = 0;
					// If you hit an empty pop, keep bumping.
					while (!Colony[fathercolonyid].pop)
						if (++fathercolonyid >= MAXCOLONIES)
							fathercolonyid = 0;
					fatherbugid = Colony[fathercolonyid].rank[0];
					fatherrank = 0;
//					label( hDlg, GE_COLONYFATHER, "Colony",
//						(short)(fathercolonyid + 1) );
			SetWindowText( GetDlgItem( hDlg, GE_COLONYFATHER),
				(LPSTR)((fathercolonyid==0)?"Green Colony":
				((fathercolonyid==1)?"Red Colony":"Blue Colony")));					label( hDlg, GE_RANKFATHER, "Rank",
						(short)(fatherrank + 1) );
					label( hDlg, GE_FATHER, "Bug",
						(short)(fatherbugid + 1) );
	//Now invalidate the old icon rect to be redrawn by WM_PAINT
					rect.left = father_x;
					rect.top = father_y;
					rect.right = rect.left + BODYPATCH_X;
					rect.bottom = rect.top+ BODYPATCH_Y;
					InvalidateRect(hDlg, &rect, TRUE);
	// Now fix the new gene bitmap
					PatBlt(hdcFathergenes, 0, 0, gene_CX, gene_CY,
						PATCOPY);
					drawgenes(hdcFathergenes, Bug[fatherbugid]
						, FATHER);
	//Now invalidate the old gene rect to be redrawn by WM_PAINT
					rect.left = fathergene_x;
					rect.top = fathergene_y;
					rect.right = rect.left + geneimage_CX;
					rect.bottom = rect.top + geneimage_CY;
					InvalidateRect(hDlg, &rect, TRUE);
					break;


				case GE_RANKCHILD:
					if (++childrank >= Colony[childcolonyid].pop)
						childrank = 0;
					childbugid = Colony[childcolonyid].rank[
						childrank];
					label( hDlg, GE_RANKCHILD, "Rank",
						(short)(childrank + 1) );
					label( hDlg, GE_CHILD, "Bug",
						(short)(childbugid + 1) );
	//Now invalidate the old icon rect to be redrawn by WM_PAINT
					rect.left = child_x;
					rect.top = child_y;
					rect.right = rect.left + BODYPATCH_X;
					rect.bottom = rect.top+ BODYPATCH_Y;
					InvalidateRect(hDlg, &rect, TRUE);
	// Now fix the new gene bitmap
					PatBlt(hdcChildgenes, 0, 0, gene_CX, gene_CY,
						PATCOPY);
					drawgenes(hdcChildgenes, Bug[childbugid],
						CHILD);
	//Now invalidate the old gene rect to be redrawn by WM_PAINT
					rect.left = childgene_x;
					rect.top = childgene_y;
					rect.right = rect.left + geneimage_CX;
					rect.bottom = rect.top + geneimage_CY;
					InvalidateRect(hDlg, &rect, TRUE);
					break;

				case GE_COLONYCHILD:
					if (++childcolonyid >= MAXCOLONIES)
						childcolonyid = 0;
					// If you hit an empty pop, keep bumping.
					while (!Colony[childcolonyid].pop)
						if (++childcolonyid >= MAXCOLONIES)
							childcolonyid = 0;
					childbugid = Colony[childcolonyid].rank[0];
					childrank = 0;
//					label( hDlg, GE_COLONYCHILD, "Colony",
//						(short)(childcolonyid + 1) );
			SetWindowText( GetDlgItem( hDlg, GE_COLONYCHILD),
				(LPSTR)((childcolonyid==0)?"Green Colony":
				((childcolonyid==1)?"Red Colony":"Blue Colony")));
					label( hDlg, GE_RANKCHILD, "Rank",
						(short)(childrank + 1) );
					label( hDlg, GE_CHILD, "Bug",
						(short)(childbugid + 1) );
	//Now invalidate the old icon rect to be redrawn by WM_PAINT
					rect.left = child_x;
					rect.top = child_y;
					rect.right = rect.left + BODYPATCH_X;
					rect.bottom = rect.top+ BODYPATCH_Y;
					InvalidateRect(hDlg, &rect, TRUE);
	// Now fix the new gene bitmap
					PatBlt(hdcChildgenes, 0, 0, gene_CX, gene_CY,
						PATCOPY);
					drawgenes(hdcChildgenes, Bug[childbugid],
						CHILD);
	//Now invalidate the old gene rect to be redrawn by WM_PAINT
					rect.left = childgene_x;
					rect.top = childgene_y;
					rect.right = rect.left + geneimage_CX;
					rect.bottom = rect.top + geneimage_CY;
					InvalidateRect(hDlg, &rect, TRUE);
					break;

				case GE_ZAP:
				case GE_CROSSOVER:
				case GE_MUTATE:
				case GE_TRANSPOSE:
				case GE_CLONE:
					breedmethod = wParam;
					break;

				case GE_APPLY:
					switch (breedmethod)
					{
						case GE_ZAP:
							randomizegenes(Bug[childbugid]);
							break;
						case GE_CROSSOVER:
							DNAcross(Bug[motherbugid], Bug[
								fatherbugid], Bug[childbugid]);
							break;
						case GE_MUTATE:
							DNAmutate(Bug[childbugid],
								mutationlevellookup[Colony[
								childcolonyid].mutationlevel]);
							DNA_to_RNA(Bug[childbugid]);
							break;
						case GE_TRANSPOSE:
							DNAtranspose(Bug[childbugid]);
							DNA_to_RNA(Bug[childbugid]);
							break;
						case GE_CLONE:
							bugclone(Bug[motherbugid],
								Bug[childbugid]);
							break;
					}
			// Now fix the new gene bitmap
					PatBlt(hdcChildgenes, 0, 0, gene_CX,
						gene_CY, PATCOPY);
					drawgenes(hdcChildgenes,
						Bug[childbugid], CHILD);
			//Now invalidate the old gene rect to be redrawn by WM_PAINT
					rect.left = childgene_x;
					rect.top = childgene_y;
					rect.right = rect.left + geneimage_CX;
					rect.bottom = rect.top + geneimage_CY;
					InvalidateRect(hDlg, &rect, TRUE);
			// In case the father or mother is the same bug, then
            // this gene image needs to be chagned as well.
					if (fatherbugid == childbugid)
                    {
						PatBlt(hdcFathergenes, 0, 0, gene_CX,
							gene_CY, PATCOPY);
						drawgenes(hdcFathergenes,
							Bug[fatherbugid], FATHER);
						rect.left = fathergene_x;
						rect.top = fathergene_y;
						rect.right = rect.left + geneimage_CX;
						rect.bottom = rect.top + geneimage_CY;
						InvalidateRect(hDlg, &rect, TRUE);
                    }

					if (motherbugid == childbugid)
                    {
						PatBlt(hdcMothergenes, 0, 0, gene_CX,
							gene_CY, PATCOPY);
						drawgenes(hdcMothergenes,
							Bug[motherbugid], MOTHER);
						rect.left = mothergene_x;
						rect.top = mothergene_y;
						rect.right = rect.left + geneimage_CX;
						rect.bottom = rect.top + geneimage_CY;
						InvalidateRect(hDlg, &rect, TRUE);
                    }

					break;

				case GE_OK:
					DestroyWindow( hDlg );
					break;

				default:
					break;
			}
			return TRUE; // End of WM_COMMAND case in main switch.

		case WM_RBUTTONDOWN:
		case WM_CLOSE:
			DestroyWindow(hDlg);
			return TRUE;

		case WM_DESTROY:
			CheckMenuItem( GetMenu(hwnd),
				IDM_GENE,MF_BYCOMMAND | MF_UNCHECKED);
			hDlgGene = 0; // Turn off modeless handle
			SelectObject(hdcMothergenes, hBitmapMothergenesOld);
			DeleteDC(hdcMothergenes);
			DeleteObject(hBitmapMothergenes);
			SelectObject(hdcFathergenes, hBitmapFathergenesOld);
			DeleteDC(hdcFathergenes);
			DeleteObject(hBitmapFathergenes);
			SelectObject(hdcChildgenes, hBitmapChildgenesOld);
			DeleteDC(hdcChildgenes);
			DeleteObject(hBitmapChildgenes);
			InvalidateRect (hwnd, NULL, TRUE); // Clear whole screen
				// else see persistence of old crud from underneath
			return TRUE;

		default:
			return FALSE; // Case where message means nothing to me.
	}
}

void near drawgenes(HDC hdc, struct bug *bug, unsigned char role)
{
	COLORREF col;
	short gene_site, x;

	for (gene_site=0; gene_site < bug->DNA_length-2; gene_site += 3)
		{
			col = RGB(bug->DNA[gene_site], bug->DNA[gene_site+1],
				bug->DNA[gene_site+2]);
	// Use three bytes for a COLORREF, draw a pixel, all in a line.
			x = (gene_site/3); // Actual writing position
			SetPixel(hdc, x , 0, col);
		}
	// Find the rectangle that encloses the gene picture.
	switch (role)
	{
		case MOTHER:
			mothergene_CX = x + 1;
			break;
		case FATHER:
			fathergene_CX = x + 1;
			break;
		case CHILD:
			childgene_CX = x + 1;
			break;
	}
}
