#include "bug.h"
#include "sound.h"
#include "bugmenu.h"
#include <windows.h>
#pragma hdrstop
#include "shape.h"
//#define EXTRA 1

extern HWND hwnd; // master window
extern void  BugBodyErase(HDC, short, short);
extern unsigned char editmode, editcolonyid, editbugid,
	 colonycount, livebugcount, three_d_flag, soundflag, wrapflag;
	// editmode 0 is all bugs, 1 is bugs in editcolony, 2 is editbug
	// in editcolony.
extern struct colony Colony[];
extern struct bug *Bug[];
extern unsigned char bugnum[];
extern HWND hDlgShape, hwnd;
extern unsigned char livebugcount;
extern char szAppName[];
extern unsigned char newlambda;
extern float lambda;
extern unsigned char CAflag;
#ifdef STEREO
extern float EyePix, NosePix;
extern unsigned char stereoflag;
extern float LeftEye, RightEye;
extern short BugLand_CX;
#endif //STEREO
#ifdef GROWBUGS_STEPS
extern unsigned char GrowBugs_steps;
#endif //GROWBUGS_STEPS
extern void fillCA(unsigned char);
extern void changestates(struct bug *, unsigned char);
extern void installdirectiontype(struct bug *);
extern void DNA_to_RNA(struct bug *);
extern void installmotiontype(struct bug *);
extern void label( HWND, int, char *, short );
extern void numlabel( HWND hwnd, int button, short d );
extern void DNA_to_RNA(struct bug*);

void interpretkey(HWND, WORD);
	// The WORD is the ascii

#define UNUSED 255
unsigned char hotbugbodyflag = UNUSED; //B
unsigned char hotlineflag = UNUSED; //L
unsigned char hotradius = UNUSED; //N
unsigned char hotsoundflag = UNUSED; //S
unsigned char hotmotiontype = UNUSED; //T

void interpretkey(HWND hwnd, WORD key)
{
	unsigned char i;
	HDC hdc; // Use in 'B'
 
	switch (key)
	{
		case 'B':
			if (hotbugbodyflag == UNUSED)
				hotbugbodyflag = 0;
			else
			{
				hotbugbodyflag++;
				if (hotbugbodyflag > 1)
					hotbugbodyflag = 0;
			}
			hdc = GetDC(hwnd);
			for (i=0; i< livebugcount;i++)
			{
				if (Bug[bugnum[i]]-> bugbodyflag == 1 &&
					hotbugbodyflag == 2)
					BugBodyErase(hdc, Bug[bugnum[i]]->oldx,
						Bug[bugnum[i]]->oldy);
				Bug[bugnum[i]]->bugbodyflag= hotbugbodyflag;
			}
			ReleaseDC(hwnd, hdc);
			break;
		case 'D':
			SendMessage(hwnd, WM_COMMAND, CA_RULE_LAMBDA, 0L);
			SendMessage(hwnd, WM_COMMAND, CA_SEED, 0L);
			break;
		case 'G':
			SendMessage(hwnd, WM_COMMAND, RAN_GENES, 0L);
			break;
		case 'L': //Lines
			if (hotlineflag == UNUSED)
				hotlineflag = 0;
			else
			{
				if (!three_d_flag)
				{
					if (!hotlineflag)
						hotlineflag = 1;
					else
						hotlineflag = 0;
				}
				else //three_d
				{
					if (++hotlineflag > 4)
						hotlineflag = 0;
				}
			}
			for (i=0; i< livebugcount; i++)
				Bug[bugnum[i]]->lineflag = hotlineflag;
			break;
		case 'N': //Nodes
			if (hotradius == UNUSED)
				hotradius = 0;
			else
			{
				hotradius++;
				if (hotradius >= 3)
					hotradius = 0;
			}
			for (i=0; i < livebugcount; i++)
				Bug[bugnum[i]]->radius = hotradius;
			break;
#ifdef STEREO
		case 'O':
			if (three_d_flag)
			{
				stereoflag ^= 1;
				if (stereoflag)
					wrapflag = 0;
				SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
			}
			break;
#endif //STEREO
		case 'S': //Sound
			if (hotsoundflag == UNUSED)
				hotsoundflag = soundflag = 0;
			else
				soundflag = hotsoundflag = hotsoundflag ^ 
					(SOUNDFLAG_EAT | SOUNDFLAG_BREED);
			break;
		case 'T': //Turboid Type
			if (hotmotiontype == UNUSED)
				hotmotiontype = MOTION_TURMITE;
			else
			{
				hotmotiontype++;
				if (hotmotiontype >= MOTION_COUNT)
					hotmotiontype = MOTION_TURMITE;
			}
			for (i=0; i< livebugcount;i++)
				if (Bug[bugnum[i]]->motiontype != hotmotiontype)
				{
					Bug[bugnum[i]]->motiontype = hotmotiontype;
					installmotiontype(Bug[bugnum[i]]);
					DNA_to_RNA(Bug[bugnum[i]]);
				}
			break;
		case 'V':
			SendMessage(hwnd, WM_COMMAND, RAN_BIOSPHERE, 0L);
			break;
#ifdef EXTRA
#ifdef STEREO
		case 'I':
			EyePix = ((float)EyePix / STEREO_ADJUST);
			LeftEye = (BugLand_CX / 2) - EyePix;
			RightEye = (BugLand_CX / 2) + EyePix;
			break;
		case 'P':
			EyePix =  ((float)EyePix * STEREO_ADJUST);
			LeftEye = (BugLand_CX / 2) - EyePix;
			RightEye = (BugLand_CX / 2) + EyePix;
			break;
		case 'Y':
			NosePix = ((float)NosePix / STEREO_ADJUST);
			break;
		case 'U':
			NosePix = ((float)NosePix * STEREO_ADJUST);
			break;
#endif //STEREO

		case 'W': //wide angle boid view to promote helices
			for (i=0; i< livebugcount;i++)
			{
				Bug[bugnum[i]]->DNA[4] = 255;
				Bug[bugnum[i]]->DNA[5] = 255;
				// DNA 4 and 5 control the visionagle cosine
				Bug[bugnum[i]]->visionanglecosine =
				cos(M_PI - MIN_VISIONANGLE); // Big angle
			}
			break;
#endif //EXTRA
		case 'Z':  //Clear
			SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
			break;
	}
}

#ifdef OLDHOT
		case 'V':
			for (i=0; i < livebugcount; i++)
			{
				if (--(Bug[bugnum[i]]->basespeed) < 1)
					Bug[bugnum[i]]->basespeed = 1;
				Bug[bugnum[i]]->basespeed = Bug[bugnum[i]]->basespeed;
			}
			break;
		case 'W':
			for (i=0; i < livebugcount; i++)
			{
				if (++(Bug[bugnum[i]]->basespeed) > MAX_SPEED)
					Bug[bugnum[i]]->basespeed = MAX_SPEED;
				Bug[bugnum[i]]->basespeed = Bug[bugnum[i]]->basespeed;
			}
			break;
		case 'v':
			for (i=0; i < livebugcount; i++)
			{
				Bug[bugnum[i]]->veerweight -= 0.5;
				if (Bug[bugnum[i]]->veerweight < 0.0)
					Bug[bugnum[i]]->veerweight = 0.0;
			}
			break;
		case 'V':
			for (i=0; i < livebugcount; i++)
			{
				Bug[bugnum[i]]->veerweight += 0.5;
				if (Bug[bugnum[i]]->veerweight > 3.0)
					Bug[bugnum[i]]->veerweight = 3.0;
			}
			break;
		case 'a':
			if (stretchfactor > 2) // Minimum is 2
				stretchfactor/= 2;
			InvalidateRect (hwnd, NULL, TRUE);
			// Clear the screen, but not the bitmap
			break;
		case 'A' :
			if (stretchfactor < 16) // Maximum is 16
				stretchfactor *= 2;
			InvalidateRect (hwnd, NULL, TRUE);
			// Clear the screen, but not the bitmap
			break;

		case 'h':
			for (i=0; i< livebugcount; i++)
				Bug[bugnum[i]]->bugbodyflag = 0;
			break;
		case 'H':
			for (i=0; i< livebugcount; i++)
				Bug[bugnum[i]]->bugbodyflag = 1;
			break;
		case 'i':
			for (i=0; i< livebugcount; i++)
				Bug[bugnum[i]]->lineflag = 0;
			break;
		case 'K':
           	hdc = GetDC(hwnd);
			for (i=0; i< livebugcount; i++)
               {
				if (Bug[bugnum[i]]->bugbodyflag == 1)
					BugBodyErase(hdc,Bug[bugnum[i]]->oldx,
					Bug[bugnum[i]]->oldy); //Erase the existing
				// body if you are coming from bugbodyflag == 1.
                   Bug[bugnum[i]]->bugbodyflag = 2;
			}
			ReleaseDC(hwnd, hdc);
			break;

		case 'y':
			lens_dx -= 40;
			lens_dy -= 40;
			if (lensflag)
				clearflag = 1;
			lensflag = 0;
			break;
		case 'Y':
			lens_dx += 40;
			if (lens_dx > cxClient)
				lens_dx = cxClient;
			lens_dy += 40;
			if (lens_dy > cyClient)
				lens_dy = cyClient;
			if (lensflag)
				clearflag = 1;
			lensflag = 0;
			break;		case 'c': // Decrease the vision angle
			for (i=0; i< livebugcount; i++)
			{
			Bug[bugnum[i]]->visionanglecosine += 0.2;
			if (Bug[bugnum[i]]->visionanglecosine > 1.0)
				Bug[bugnum[i]]->visionanglecosine = 1.0;
			break;
//really old
		case 'C': // Increase the visionangle
			Bug[bugnum[i]]->visionanglecosine -= 0.2;
			if (Bug[bugnum[i]]->visionanglecosine < -1.0)
				Bug[bugnum[i]]->visionanglecosine = -1.0;
			break;
		case 'F':
			Bug[bugnum[i]]->visionanglecosine = cos((M_PI) * 0.5);
			break;
		case 'g':
			CAwaitcounter = 0;
			if (CAwaitalarm > 1)
				CAwaitalarm /= 2;
			break;
		case 'G':
			CAwaitalarm *= 2;
			break;

		case 'j':
			bug->copyweight -= 0.2;
			if (bug->copyweight < 0.0)
				bug->copyweight = 0.0;
			break;
		case 'J':
			bug->copyweight += 0.2;
			if (bug->copyweight > 2.0)
				bug->copyweight = 2.0;
			break;
		case 'k':
			bug->centerweight -= 0.2;
			if (bug->centerweight < 0.0)
				bug->centerweight = 0.0;
			break;
		case 'K':
			bug->centerweight += 0.2;
			if (bug->centerweight > 2.0)
				bug->centerweight = 2.0;
			break;
		case 'l':
			bug->attackweight -= 0.2;
			if (bug->attackweight < 0.0)
				bug->attackweight = 0.0;
			break;
		case 'L':
			bug->attackweight += 0.2;
			if (bug->attackweight > 2.0)
				bug->attackweight = 2.0;
			break;
		case 'm':
			bug->fleeweight -= 0.2;
			if (bug->fleeweight < 0.0)
				bug->fleeweight = 0.0;
			break;
		case 'M':
			bug->fleeweight += 0.2;
			if (bug->fleeweight > 2.0)
				bug->fleeweight = 2.0;
			break;
		case 'p':
			bump_CA_Rop();
			break;
		case 'P':
			hdc = GetDC(hwnd);
			bump_CApalette(hdc);
			ReleaseDC(hwnd, hdc);
			break;
		case 'q':
			CAPutMask >>= 1;
			break;		case 'f':
			Bug[bugnum[i]]->visionanglecosine = VISIONANGLECOSINE;
			break;
		case 'v':
			for (i=0; i < livebugcount; i++)
			{
				Bug[bugnum[i]]->veerweight -= 0.5;
				if (Bug[bugnum[i]]->veerweight < 0.0)
					Bug[bugnum[i]]->veerweight = 0.0;
			}
			break;
		case 'M':
			for (i=0; i < livebugcount; i++)
				Bug[bugnum[i]]->mossflag = 0;
			break;

		case 'N':
			for (i=0; i < livebugcount; i++)
				Bug[bugnum[i]]->mossflag = 1;
			break;
		case 'V':
			for (i=0; i < livebugcount; i++)
			{
				Bug[bugnum[i]]->veerweight += 0.5;
				if (Bug[bugnum[i]]->veerweight > 3.0)
					Bug[bugnum[i]]->veerweight = 3.0;
			}
			break;
#endif //OLDHOT
