#include <windows.h>
#include "bug.h"
#pragma hdrstop
#include <string.h>
#include <stdlib.h>
#include <dos.h> //for gettime

extern short score_history_index;  //for graphcaption
extern short score_history_rollover;

void label(HWND, int, char *, short);
void ulabel( HWND hwnd, int button, char *, unsigned short );
void numlabel( HWND , int , short );
void filecaption(HWND , char *);
void graphcaption(HWND, short);
//----------------------CODE--------------------
void label( HWND hwnd, int button, char title[10], short d )
{
	char labeltext[20], numberstring[10];

	itoa( (int)d, numberstring, (int)10);
	wsprintf( (LPSTR)labeltext, "%s = %s",
		(LPSTR)title, (LPSTR)numberstring );
	SetWindowText( GetDlgItem( hwnd, button ), (LPSTR)labeltext );
}

void ulabel( HWND hwnd, int button, char title[10], unsigned short d )
{
	char labeltext[20], numberstring[10];
	long ld;

	ld = d;
	ltoa( ld, numberstring, (int)10);
	wsprintf( (LPSTR)labeltext, "%s = %s",
		(LPSTR)title, (LPSTR)numberstring );
	SetWindowText( GetDlgItem( hwnd, button ), (LPSTR)labeltext );
}

void numlabel( HWND hwnd, int button, short d )
{
	char numberstring[10];

	itoa( (int)d, numberstring, (int)10);
	SetWindowText( GetDlgItem( hwnd, button ), (LPSTR)numberstring );
}

void filecaption(HWND hwnd, char *filename)
{ //CAPTION is in bug.h  Use this to tell most recent filename.
	char labeltext[120];

	wsprintf( (LPSTR)labeltext, "%s   Last File: %s",
		(LPSTR)CAPTION, (LPSTR)filename );
	SetWindowText( hwnd, (LPSTR)labeltext );
}




void graphcaption(HWND hwnd, short graph_scale, short graph_winorgX,
	short graph_winCX)
{ //CAPTION is in bug.h  Use this to tell most recent filename.
	char nstring[10], lstring[10], rstring[10];
	char labeltext[120];
	int n,l,r,s;
	
	n = MAX_ENERGY / graph_scale;
	l = graph_winorgX;
	r = l+graph_winCX;
#ifdef BAR
	if (score_history_rollover)
	{
		if (l < score_history_index)
			l += SCORE_HISTORY_LENGTH*score_history_rollover;
		else
			l +=SCORE_HISTORY_LENGTH*(score_history_rollover-1);
		if (r < score_history_index)
			r += SCORE_HISTORY_LENGTH*score_history_rollover;
		else
			r +=SCORE_HISTORY_LENGTH*(score_history_rollover-1);
	}
	else
	{
		if (l<score_history_index && r>score_history_index)
			r = score_history_index;
	}
#else
	l += SCORE_HISTORY_LENGTH*score_history_rollover;
	r += SCORE_HISTORY_LENGTH*score_history_rollover;
	s = score_history_index+(SCORE_HISTORY_LENGTH*score_history_rollover);
	if (l<s && r>s)
		r = s;
#endif //BAR
	itoa( (int)n, nstring, (int)10);
	itoa( (int)l, lstring, (int)10);
	itoa( (int)r, rstring, (int)10);
	wsprintf( (LPSTR)labeltext,
		"%s  Generation: %s to %s.  Score: - %s to %s",
		(LPSTR)GRAPH_CAPTION , (LPSTR)lstring, (LPSTR)rstring,
		(LPSTR)nstring, (LPSTR)nstring);
	SetWindowText( hwnd, (LPSTR)labeltext );
}
