
/*********************************************************************
*  (C) Copyright 1991-1992 by Rudy Rucker for Autodesk, Inc.         *
**********************************************************************
* The information contained herein is confidential, proprietary      *
* to Autodesk,Inc., and considered a trade secret as defined in      *
* section 499C of the penal code of the State of California.  Use of *
* this information by anyone other than authorized employees of      *
* Autodesk, Inc.is grbuged only under a written non-disclosure       *
* agreement, expressly prescribing the scope and manner of such use. *
**********************************************************************/
//---Includes-----------------------------------
#define LESSCALC 1

#include "bug.h"
#include <windows.h>
#include <dos.h>
#include <math.h>
#include <malloc.h>
#pragma hdrstop
//#include "random.h"

//------Other Data-----
extern short BugLand_MIDX, BugLand_MIDY, BugLand_MIDZ,
	BugLand_CX, BugLand_CY, BugLand_CZ;
extern struct bug *Bug[];
extern unsigned char bugnum[];
extern unsigned char livebugcount, three_d_flag, wrapflag;
//------Own Data---------


//---------Far Functions-----------------
void update_metric(void);

//------------------------Metric-------------

void update_metric(void)
{
	unsigned char i,j;
	CyVector3 position;
	Real weightsum, invdist;
	unsigned int worldcase = 0;

	
	worldcase = wrapflag | (three_d_flag << 1);
	// 0 is no wrap & no 3d, 1 is wrap & no 3d, 2 is no wrap & 3D,
    // 3 is wrap and 3d.
// First the to_x, to_y, to_z, and metric arrays are filled; break
// this into four cases based on wrapflag and three_d_flag
//1
	switch(worldcase)
	{

	case 0: // no wrap, no 3D
#ifndef LESSCALC
		for (i=0; i < livebugcount; i++)
			for (j=i+1; j<livebugcount; j++)
#else //LESSCALC
		for (i=0; i < livebugcount; i++)
		if (Bug[bugnum[i]]->metric_flag)
			 //Only fill rows of motion bugs
			for (j=0; j<livebugcount; j++)
			if (!Bug[bugnum[j]]->metric_flag || j>i)
	// Need to fill the whole row, but don't compute motion-to-motion 2ce
#endif //LESSCALC
			{
				Bug[bugnum[i]]->to[j][X] = Bug[bugnum[j]]->x - Bug[bugnum[i]]->x;
		
				Bug[bugnum[i]]->to[j][Y] = Bug[bugnum[j]]->y - Bug[bugnum[i]]->y;

				Bug[bugnum[i]]->to[j][Z] = 0.0;

				Bug[bugnum[j]]->metricsquared[i] = Bug[bugnum[i]]->metricsquared[j] =
					Bug[bugnum[i]]->to[j][X] * Bug[bugnum[i]]->to[j][X] +
					Bug[bugnum[i]]->to[j][Y] * Bug[bugnum[i]]->to[j][Y];
				Bug[bugnum[j]]->metric[i] = Bug[bugnum[i]]->metric[j] =
					sqrt(Bug[bugnum[i]]->metricsquared[j]);

				// normalize
				if (Bug[bugnum[i]]->metric[j] > EPSI)
					Bug[bugnum[i]]->to[j] = Bug[bugnum[i]]->to[j] /
						Bug[bugnum[i]]->metric[j];
				else
					Bug[bugnum[i]]->to[j].Set(0.0,0.0,0.0);

				// Now that Bug[bugnum[i]]->to[j][Y] is correct,
				// store the reverse vector.
				Bug[bugnum[j]]->to[i] = -1.0 * Bug[bugnum[i]]->to[j];
			}
	break;	

    	case 1 : //wrap and no 3D
#ifndef LESSCALC
		for (i=0; i < livebugcount; i++)
			for (j=i+1; j<livebugcount; j++)
#else //LESSCALC
		for (i=0; i < livebugcount; i++)
		if (Bug[bugnum[i]]->metric_flag)
			 //Only fill rows of motion bugs
			for (j=0; j<livebugcount; j++)
			if (!Bug[bugnum[j]]->metric_flag || j>i)
	// Need to fill the whole row, but don't compute motion-to-motion 2ce
#endif //LESSCALC
			{
				Bug[bugnum[i]]->to[j][X] = Bug[bugnum[j]]->x - Bug[bugnum[i]]->x;
				Bug[bugnum[i]]->to[j][Y] = Bug[bugnum[j]]->y - Bug[bugnum[i]]->y;
				Bug[bugnum[i]]->to[j][Z] = 0.0;

				// Do x
				if (Bug[bugnum[i]]->to[j][X] < -BugLand_MIDX)
					// Here the target j is so far to the
					// left of source i that i does better
					// to travel off the East and wrap.
					Bug[bugnum[i]]->to[j][X] = BugLand_CX + Bug[bugnum[i]]->to[j][X];
				else if (Bug[bugnum[i]]->to[j][X] > BugLand_MIDX)
					// Here target j is far to right of source i
					// i does better to travel off West and wrap.
					Bug[bugnum[i]]->to[j][X] = Bug[bugnum[i]]->to[j][X] - BugLand_CX;
				
				// Now do y
				if (Bug[bugnum[i]]->to[j][Y] < -BugLand_MIDY)
					// j - i negative means i bigger than j, so j
					// north of i (since top of screen is 0), so i
					// goes off south.
					Bug[bugnum[i]]->to[j][Y] = BugLand_CY + Bug[bugnum[i]]->to[j][Y];
				else if (Bug[bugnum[i]]->to[j][Y] > BugLand_MIDY)
					// j is below i, i goes off top or North.
					Bug[bugnum[i]]->to[j][Y] = Bug[bugnum[i]]->to[j][Y] - BugLand_CY;

				Bug[bugnum[j]]->metricsquared[i] = Bug[bugnum[i]]->metricsquared[j] =
					Bug[bugnum[i]]->to[j][X] * Bug[bugnum[i]]->to[j][X] +
					Bug[bugnum[i]]->to[j][Y] * Bug[bugnum[i]]->to[j][Y];
				Bug[bugnum[j]]->metric[i] = Bug[bugnum[i]]->metric[j] =
					sqrt(Bug[bugnum[i]]->metricsquared[j]);

				// normalize
				if (Bug[bugnum[i]]->metric[j] > EPSI)
					Bug[bugnum[i]]->to[j] = Bug[bugnum[i]]->to[j] /
						Bug[bugnum[i]]->metric[j];

				// Now that Bug[bugnum[i]]->to[j][Y] is correct,
				// store the reverse vector.
				Bug[bugnum[j]]->to[i] = -1.0 * Bug[bugnum[i]]->to[j];
			}
	
    break;


	case 2: // no wrapflag and 3D
#ifndef LESSCALC
		for (i=0; i < livebugcount; i++)
			for (j=i+1; j<livebugcount; j++)
#else //LESSCALC
		for (i=0; i < livebugcount; i++)
		if (Bug[bugnum[i]]->metric_flag)
			 //Only fill rows of motion bugs
			for (j=0; j<livebugcount; j++)
			if (!Bug[bugnum[j]]->metric_flag || j>i)
	// Need to fill the whole row, but don't compute motion-to-motion 2ce
#endif //LESSCALC
			{
				Bug[bugnum[i]]->to[j][X] = Bug[bugnum[j]]->x - Bug[bugnum[i]]->x;

				Bug[bugnum[i]]->to[j][Y] = Bug[bugnum[j]]->y - Bug[bugnum[i]]->y;

				Bug[bugnum[i]]->to[j][Z] = Bug[bugnum[j]]->z - Bug[bugnum[i]]->z;

				Bug[bugnum[j]]->metricsquared[i] = Bug[bugnum[i]]->metricsquared[j] =
					Bug[bugnum[i]]->to[j][X] * Bug[bugnum[i]]->to[j][X] +
					Bug[bugnum[i]]->to[j][Y] * Bug[bugnum[i]]->to[j][Y] +
					Bug[bugnum[i]]->to[j][Z] * Bug[bugnum[i]]->to[j][Z];
				Bug[bugnum[j]]->metric[i] = Bug[bugnum[i]]->metric[j] =
					sqrt(Bug[bugnum[i]]->metricsquared[j]);

				// normalize
				if (Bug[bugnum[i]]->metric[j] > EPSI)
					Bug[bugnum[i]]->to[j] = Bug[bugnum[i]]->to[j] /
						Bug[bugnum[i]]->metric[j];

				// Now that Bug[bugnum[i]]->to[j][Y] is correct,
				// store the reverse vector.
				Bug[bugnum[j]]->to[i] = -1.0 * Bug[bugnum[i]]->to[j];
			}
	 break;
	case 3: // wrap and 3d
#ifndef LESSCALC
		for (i=0; i < livebugcount; i++)
			for (j=i+1; j<livebugcount; j++)
#else //LESSCALC
		for (i=0; i < livebugcount; i++)
		if (Bug[bugnum[i]]->metric_flag)
			 //Only fill rows of motion bugs
			for (j=0; j<livebugcount; j++)
			if (!Bug[bugnum[j]]->metric_flag || j>i)
	// Need to fill the whole row, but don't compute motion-to-motion 2ce
#endif //LESSCALC
			{
				// Do x
				Bug[bugnum[i]]->to[j][X] = Bug[bugnum[j]]->x - Bug[bugnum[i]]->x;
				Bug[bugnum[i]]->to[j][Y] = Bug[bugnum[j]]->y - Bug[bugnum[i]]->y;
				Bug[bugnum[i]]->to[j][Z] = Bug[bugnum[j]]->z - Bug[bugnum[i]]->z;

				if (Bug[bugnum[i]]->to[j][X] < -BugLand_MIDX)
					Bug[bugnum[i]]->to[j][X] = BugLand_CX + Bug[bugnum[i]]->to[j][X];
				else if (Bug[bugnum[i]]->to[j][X] > BugLand_MIDX)
					Bug[bugnum[i]]->to[j][X] = Bug[bugnum[i]]->to[j][X] - BugLand_CX;

				// Now do y
				if (Bug[bugnum[i]]->to[j][Y] < -BugLand_MIDY)
					Bug[bugnum[i]]->to[j][Y] = BugLand_CY + Bug[bugnum[i]]->to[j][Y];
				else if (Bug[bugnum[i]]->to[j][Y] > BugLand_MIDY)
					Bug[bugnum[i]]->to[j][Y] = Bug[bugnum[i]]->to[j][Y] - BugLand_CY;

				// Now for Z
				if (Bug[bugnum[i]]->to[j][Z] < -BugLand_MIDZ)
					// i bigger than j, i is far and j near.i go far.
					Bug[bugnum[i]]->to[j][Z] = BugLand_CZ + Bug[bugnum[i]]->to[j][Z];
				else if (Bug[bugnum[i]]->to[j][Z] > BugLand_MIDZ)
					// i is near, i wraps near.
					Bug[bugnum[i]]->to[j][Z] = Bug[bugnum[i]]->to[j][Z] - BugLand_CZ;

				Bug[bugnum[j]]->metricsquared[i] = Bug[bugnum[i]]->metricsquared[j] =
					Bug[bugnum[i]]->to[j][X] * Bug[bugnum[i]]->to[j][X] +
					Bug[bugnum[i]]->to[j][Y] * Bug[bugnum[i]]->to[j][Y] +
					Bug[bugnum[i]]->to[j][Z] * Bug[bugnum[i]]->to[j][Z];
				Bug[bugnum[j]]->metric[i] = Bug[bugnum[i]]->metric[j] =
					sqrt(Bug[bugnum[i]]->metricsquared[j]);

				// normalize
				if (Bug[bugnum[i]]->metric[j] > EPSI)
					Bug[bugnum[i]]->to[j] = Bug[bugnum[i]]->to[j] /
						Bug[bugnum[i]]->metric[j];

				// Now that Bug[bugnum[i]]->to[j][Y] is correct,
				// store the reverse vector.
				Bug[bugnum[j]]->to[i] = -1.0 * Bug[bugnum[i]]->to[j];

			}
    break;

     } // end of switch on worldcase
	// Now the to, metricsquared, and metric arrays are all filled.	

	// Next I fix the nearest_bug, nearest_distance fields of the bugs
	for (i=0; i < livebugcount; i++)
#ifdef LESSCALC
	if (Bug[bugnum[i]]->metric_flag)
#endif //LESSCALC
	{
		weightsum = 0.0;
		Bug[bugnum[i]]->tocentroid.Set(0.0, 0.0, 0.0);
		Bug[bugnum[i]]->nearest_distance = 1000000.0; //big double
		// In case no bug is visible, set nearest_bug default self.
		Bug[bugnum[i]]->nearest_bug = Bug[bugnum[i]];
		if (Bug[bugnum[i]]->watch_two)
		{
			Bug[bugnum[i]]->second_nearest_distance =  1000000.0; //big double
			Bug[bugnum[i]]->second_nearest_bug = Bug[bugnum[i]];
			for (j=0; j<livebugcount; j++)
			{
				if (j==i)
					continue;
			// Compare the nearest_bug and nearest_distance values
			// to find the nearest visible bug.
			//  % means dot product, so (to % bug->tan) is angle cosine.
			// Can bug see nearest_bug?
			// As vision angle goes from 0 to PI, cos goes 1 to -1, so
			// being smaller than an angle means being bigger than the cosine.
				if (Bug[bugnum[i]]->metric[j] <
					Bug[bugnum[i]]->second_nearest_distance &&
					Bug[bugnum[i]]->to[j] % Bug[bugnum[i]]->tan >=
					Bug[bugnum[i]]->visionanglecosine)
				{
					if (Bug[bugnum[i]]->metric[j] < Bug[bugnum[i]]->nearest_distance)
					{
						Bug[bugnum[i]]->second_nearest_bug =
							Bug[bugnum[i]]->nearest_bug;
						Bug[bugnum[i]]->second_nearest_distance =
							Bug[bugnum[i]]->nearest_distance;
						Bug[bugnum[i]]->nearest_bug = Bug[bugnum[j]];
						Bug[bugnum[i]]->nearest_distance = Bug[bugnum[i]]->metric[j];
					}
					else
					{ 
						Bug[bugnum[i]]->second_nearest_bug = Bug[bugnum[j]];
						Bug[bugnum[i]]->second_nearest_distance = Bug[bugnum[i]]->metric[j];
					}
				}
			}
		}
		else // ! bug->watch_two
		{
			for (j=0; j<livebugcount; j++)
			{
				if (j==i)
					continue;
			// Compare the nearest_bug and nearest_distance values
			// to find the nearest visible bug.
		//  % means dot product, so (to % bug->tan) is angle cosine.
		// Can bug see nearest_bug?
		// As vision angle goes from 0 to PI, cos goes 1 to -1, so
		// being smaller than an angle means being bigger than the cosine.
				if (Bug[bugnum[i]]->metric[j] < Bug[bugnum[i]]->nearest_distance &&
					Bug[bugnum[i]]->to[j] % Bug[bugnum[i]]->tan >= Bug[bugnum[i]]->visionanglecosine)
				{
					Bug[bugnum[i]]->nearest_bug = Bug[bugnum[j]];
					Bug[bugnum[i]]->nearest_distance = Bug[bugnum[i]]->metric[j];
				}
			}
		}

	// Could set the nearcolonycode field here,
	// and then be able to use it with boid and the turboids,
	// and have flock be a switch on bug->nearcolonycode.


		// Accumulate the tocentroid array value.
		for (j=0; j<livebugcount; j++)
		{
			if (Bug[bugnum[i]]->metricsquared[j]>EPSI &&
				Bug[bugnum[j]]->colonyid == Bug[bugnum[i]]->colonyid)
			{
				invdist = 1.0 / Bug[bugnum[i]]->metricsquared[j];
				// metric is in pixel units so can never be
				// less than one if it is non-zero.
				weightsum += invdist;
				// if wrapflag, this next sets the position of
				// the virtual alternate screen j which is
				// closest, else it's just the nearbug.
				position.Set( Bug[bugnum[i]]->to[j][X], Bug[bugnum[i]]->to[j][Y], Bug[bugnum[i]]->to[j][Z] );
				Bug[bugnum[i]]->tocentroid = Bug[bugnum[i]]->tocentroid + invdist * position;
			}
		}

		if (weightsum > EPSI)
			Bug[bugnum[i]]->tocentroid =  Bug[bugnum[i]]->tocentroid / weightsum;
		else
			Bug[bugnum[i]]->tocentroid.Set(0.0, 0.0, 0.0);
		Bug[bugnum[i]]->tocentroid.Unify();
	}
}
