/* This code is Copyright (C) Autodesk 1990 */
#define RANDOM_VECTOR
#define PERMUTE

#pragma hdrstop
#include <stdlib.h>
#include <time.h>
#ifdef RANDOM_VECTOR
#include "grtypes.h"
#include "linalg.hpp"
#endif // RANDOM_VECTOR

#define MYROTR(x) ( ( (x) >> 1 ) |  ( (x) << 15 ) )
#define MYROTL(x) ( ( (x) << 1 ) |  ( (x) >> 15 ) )

unsigned short shiftregister = 1946; // a number
unsigned short count = 0;
// Keep these statics up here

unsigned short sixteenbits(unsigned short seed)
{
/*  This function uses macros MYROTR and MYROTL for "rotate
 right" and "rotate left".  In use, we call sixteenbits(seed) once
 with some nonzero seed, and from then on call it
 with seed value zero to get the next random value.  It also works fine
 if you don't seed it it all, but for short runs you may want to start
 from different seeds. Using the same seed twice produces the same
 sequence of numbers.*/

	register unsigned short l,c,r;

	if (seed)
	{
		shiftregister = seed;
		count = 0;
		return seed;
	}
	l = r = c = shiftregister;
	l = MYROTR(l);/* bit i of l equals bit just left of bit i in c */
	r = MYROTL(r);/* bit i of r euqals bit just right of bit i in c */
	c |= r;
	c ^= l;		/* c = l xor (c or r), aka rule 30, named by wolfram */
	c ^= count;	/* rucker's trick to  make reaction self-sustaining */
	count++;
	// Add the next line as this seems to make repeated randomize
	// worlds regress reliably.  Could be a false fix.
	if (count > 60000U)
		count = 0;
	shiftregister = c;
	return c;
}


void rseed(unsigned short n)
{
/* This installs a specific seed, so randomizers will repeat. */

	sixteenbits(n);
}


unsigned short Randomize()
{
/* This uses the time to install a random seed */
/* Return the seed in case you want it for a regression test.*/
	long timeslot;
	unsigned short seed;

	time(&timeslot);	/* unix time function is seconds since 1970*/
	seed = (unsigned short) (timeslot & 0x0000FFFFL); 
	rseed( seed );
	return seed;
}

unsigned short Random(unsigned short n)
{
/* This returns a random integer from 0 to n - 1. */
/* Bail 0 if n <= 1 to avoid weirdness with modulo operator.*/
	if (n <= 0)
		return 0;
	return ( sixteenbits(0) % n );
}

unsigned char Randombyte(void)
{
	return (unsigned char)( sixteenbits(0) & 0x00FF );
}

Real Randomreal()
{
/* This returns a random real between 0 and 1. */
	Real caste;

	caste = (Real) sixteenbits(0);
	caste /= 0x10000L;
	return caste;

//	return (Real) sixteenbits(0) / 0x10000L;
}

Real Randomsignreal(void)
{
/* This returns a random real between -1 and 1. */

	return ( 1.0 - 2.0 * Randomreal() );
}

Real Randomsign(void)
{
	if (sixteenbits(0) & 1)
		return 1.0;
	else
		return -1.0;
}

Real chaoticize(Real a, Real *xp)
{
	*xp = a * *xp * (1 - *xp);
	return *xp;
}


#ifdef RANDOM_VECTOR

CyVector3 Randomunitvector(void) //random vector, length 1
{
	Real x, y, z, rr;

	do {
		x = Randomsignreal();
		y = Randomsignreal();
		z = Randomsignreal();
		rr = x * x + y * y + z * z;
	} while (rr > 1.0 || rr < 0.015);
	rr = sqrt(rr);
	return CyVector3(x / rr, y / rr, z / rr);
}

CyVector3 Randomvector(Real e)	// random vector, length <= e
{
	return e * Randomreal() * Randomunitvector();
}

#endif //RANDOM_VECTOR
//--------------------------------
#ifdef PERMUTE

#define MAX_PERMUTE 128

unsigned char permute_buffer[MAX_PERMUTE];

void jolt_permute_buffer(unsigned char n)
{
	// This is really a method of permute_buffer.
	// point is to set first n entries of permute_buffer to 
	// a permutation of 0,...,n-1.  If n is over the
	// original allocation for permute_buffer the program
	// crashes.

	unsigned char i, j, pick;
	unsigned char available[MAX_PERMUTE];

	if (n>MAX_PERMUTE)
    	return; //Should return an error signal.

	for (i=0; i<n; i++)
		available[i] = i;
	for (i=0; i<n; i++)
	{
		j = Random(n-i);
		permute_buffer[i] = available[j];
		for (; j<n-i-1; j++)
			available[j] = available[j+1]; // slide down.
	}
}

#endif //PERMUTE
