#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#pragma hdrstop
#include "shape.h"

extern HWND hwnd; // master window
extern HWND hDlgGene;
extern short MAX_BugBody_2D_CX,  MAX_BugBody_2D_CY;
extern short MAX_BugBody_3D_CX,  MAX_BugBody_3D_CY;
extern short BugLand_MAXX, BugLand_MAXY, BugLand_CX, BugLand_CY,
	WinOrgX, WinOrgY;
extern RECT lensrect;
extern unsigned char lensflag;
extern HDC hdcBugLand;

HDC hdc;
void BugBodyErase(HDC, short, short);

unsigned char editbugnum, tempid;
int editparam = SH_Speed;
extern unsigned char editmode, editcolonyid, editbugid,
	 colonycount, livebugcount, three_d_flag;
	// editmode 0 is all bugs, 1 is bugs in editcolony, 2 is editbug
	// in editcolony.
extern struct colony Colony[];
extern struct bug *Bug[];
extern unsigned char bugnum[];
extern HWND hDlgShape, hwnd;
extern unsigned char livebugcount;
extern char szAppName[];

extern void changestates(struct bug *, unsigned char);
extern void installdirectiontype(struct bug *);
extern void DNA_to_RNA(struct bug *);
extern void installmotiontype(struct bug *);
extern void label( HWND, int, char *, short );
extern void numlabel( HWND hwnd, int button, short d );
extern void DNA_to_RNA(struct bug*);

struct bug *findbug(short , short , short );


#ifdef CYBER
extern "C" BOOL FAR PASCAL ShapeProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#else
BOOL FAR PASCAL ShapeProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#endif //CYBER
{
	static unsigned short temp;
	static unsigned char 
		currbugbodyflag,
		currradius,
		currlineflag,
		currdirectiontype,
		currstates,
#ifdef MOSS
		currmossflag,
#endif //MOSS
		currbasespeed,
		currmotiontype;
	unsigned char i,j;
	RECT rect;
	char buf[32];
	HWND hCntl;

	switch( message )
	{
		case WM_DESTROY:
			CheckMenuItem( GetMenu(hwnd),
				IDM_SHAPE,MF_BYCOMMAND | MF_UNCHECKED);
			hDlgShape = 0; // Turn off modeless handle
			InvalidateRect (hwnd, NULL, TRUE); // Clear whole screen
				// else see persistence of old crud from underneath
			return TRUE;

		case WM_RBUTTONDOWN:
		case WM_CLOSE:
			DestroyWindow(hDlg);
			return TRUE;

		case WM_INITDIALOG:
			// single out the bugnum index of editbugid
			for (i=0; i<livebugcount; i++)
				if (bugnum[i] == editbugid)
					editbugnum = i;
			currbugbodyflag = Bug[editbugid]->bugbodyflag;
			currradius = Bug[editbugid]->radius;
			currlineflag = Bug[editbugid]->lineflag;
			currdirectiontype = Bug[editbugid]->directiontype;
			currstates = Bug[editbugid]->states;
#ifdef MOSS
			currmossflag = Bug[editbugid]->mossflag;
#endif //MOSS
			currbasespeed = Bug[editbugid]->basespeed;
			currmotiontype = Bug[editbugid]->motiontype;
	// Fix Icon Combo Box
			hCntl = GetDlgItem( hDlg, SH_BUGICON);
			SendMessage( hCntl, CB_ADDSTRING, 0, (LONG)"No Body");
			SendMessage( hCntl, CB_ADDSTRING, 1, (LONG)"Single Body");
			SendMessage( hCntl, CB_ADDSTRING, 2, (LONG)"Body Trail");
			SendMessage( hCntl, CB_SETCURSEL, (WORD)currbugbodyflag, 0);

	// Fix Motion Combo Box
			hCntl = GetDlgItem( hDlg, SH_MOTIONCOMBO);
			SendMessage( hCntl, CB_ADDSTRING, MOTION_TURMITE, (LONG)"Turmite");
			SendMessage( hCntl, CB_ADDSTRING, MOTION_BOID, (LONG)"Boid");
			SendMessage( hCntl, CB_ADDSTRING, MOTION_WOLF, (LONG)"Wolf");
			SendMessage( hCntl, CB_ADDSTRING, MOTION_BEAVER, (LONG)"Beaver");
			SendMessage( hCntl, CB_ADDSTRING, MOTION_DOG,(LONG)"Dog");
			SendMessage( hCntl, CB_ADDSTRING, MOTION_OWL,(LONG)"Owl");
			SendMessage( hCntl, CB_SETCURSEL, (WORD)currmotiontype, 0);

	// Fix Windrose Combo Box

			hCntl = GetDlgItem( hDlg, SH_WINDCOMBO);
			if (!three_d_flag)
			{
				SendMessage( hCntl, CB_ADDSTRING, 0, (LONG)"4");
				SendMessage( hCntl, CB_ADDSTRING, 1, (LONG)"6");
				SendMessage( hCntl, CB_ADDSTRING, 2, (LONG)"8");
				SendMessage( hCntl, CB_ADDSTRING, 3, (LONG)"12");
				SendMessage( hCntl, CB_ADDSTRING, 4, (LONG)"16");
				SendMessage( hCntl, CB_ADDSTRING, 5, (LONG)"24");
				SendMessage( hCntl, CB_ADDSTRING, 6, (LONG)"32");
				SendMessage( hCntl, CB_ADDSTRING, 7, (LONG)"64");
				SendMessage( hCntl, CB_ADDSTRING, 8, (LONG)"128");
			}
			else
			{
				SendMessage( hCntl, CB_ADDSTRING, 0, (LONG)"Corner Cube");
				SendMessage( hCntl, CB_ADDSTRING, 1, (LONG)"Edge Cube");
				SendMessage( hCntl, CB_ADDSTRING, 2, (LONG)"Lattice");
			}
			SendMessage( hCntl, CB_SETCURSEL,
						(WORD)( !(three_d_flag &&
						currdirectiontype >= DIRECTIONTYPES_3D)?
						currdirectiontype:0), 0 );

	// Fix Trail Line Combo Box
			hCntl = GetDlgItem( hDlg, SH_LINECOMBO);
			if (!three_d_flag)
			{
				SendMessage( hCntl, CB_ADDSTRING, 0, (LONG)"No Lines");
				SendMessage( hCntl, CB_ADDSTRING, 1, (LONG)"Thin Lines");
				SendMessage( hCntl, CB_SETCURSEL,
					(WORD) (currlineflag?1:0), 0);
				// Treat all non-zero line types as 1 in 2D for now.
			}
			else
			{
				SendMessage( hCntl, CB_ADDSTRING, 0, (LONG)"No Lines");
				SendMessage( hCntl, CB_ADDSTRING, 1, (LONG)"Thin Lines");
				SendMessage( hCntl, CB_ADDSTRING, 2,
					(LONG)"Edged Thin Lines");
				SendMessage( hCntl, CB_ADDSTRING, 3,
					(LONG)"Thick Lines");
				SendMessage( hCntl, CB_ADDSTRING, 4,
					(LONG)"Depth-Scaled Lines");
				SendMessage( hCntl, CB_SETCURSEL,
					(WORD) currlineflag, 0);
			}

	// Fix Trail Node Combo Box
			hCntl = GetDlgItem( hDlg, SH_NODECOMBO);
			SendMessage( hCntl, CB_ADDSTRING, 0, (LONG)"Dot");
			SendMessage( hCntl, CB_ADDSTRING, 1,
				(LONG)"Small Squares");
			SendMessage( hCntl, CB_ADDSTRING, 2,
				(LONG)"Medium Squares");
			SendMessage( hCntl, CB_ADDSTRING, 3,
				(LONG)"Large Squares");
			hCntl = GetDlgItem( hDlg, SH_NODECOMBO);
			SendMessage( hCntl, CB_SETCURSEL,
				(WORD) currradius, 0);

			SetWindowText( GetDlgItem( hDlg, SH_COLONYBUGS),
				(LPSTR)((editcolonyid==0)?"Green Colony":
				((editcolonyid==1)?"Red Colony":"Blue Colony")));
//			label( hDlg, SH_COLONYBUGS, "Colony",
//				(short)(editcolonyid + 1) );
			label( hDlg, SH_SINGLEBUG, "Bopper",
				(short)(editbugid+1) );

//			CheckDlgButton( hDlg, SH_BUGICON,
//				currbugbodyflag?MF_CHECKED:MF_UNCHECKED);
			numlabel( hDlg, SH_STATES,
				(short)currstates );
			numlabel( hDlg, SH_BASESPEED,
				(short)currbasespeed );
#ifdef MOSS
			CheckDlgButton( hDlg, SH_MOSSBOX,
				(currmossflag) ? MF_CHECKED:MF_UNCHECKED);
#endif //MOSS
			CheckMenuItem( GetMenu(hwnd),
				IDM_SHAPE,MF_BYCOMMAND | MF_CHECKED);
			// To indicate that this dialog box is open.
			CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
				editparam );
			CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
				SH_ALLBUGS + editmode );

			return TRUE;

		case WM_MOVE:
			GetWindowRect(hDlg, &rect);
			wsprintf((LPSTR)buf,"%i",rect.left);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"ShapeX",
				(LPSTR)buf);
			wsprintf((LPSTR)buf,"%i",rect.top);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"ShapeY",
				(LPSTR)buf);
			return TRUE;

		case WM_COMMAND:
			switch ( wParam )
			{
				case SH_BodyIcon:
					editparam = SH_BodyIcon;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					// I shouldn't need this next line but without
					// it the highlight on the scope radio buttons
					// goes away.  Copy it into the next six or seven.
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS + editmode );
					break;

				case SH_TrailNodes:
					editparam = SH_TrailNodes;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS + editmode );
					break;

				case SH_TrailLines:
					editparam = SH_TrailLines;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS + editmode );
					break;

				case SH_Speed:
					editparam = SH_Speed;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS + editmode );
					break;

				case SH_AntGnat:
					editparam = SH_AntGnat;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS + editmode );
					break;

				case SH_AntDir:
					editparam = SH_AntDir;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS + editmode );
					break;
#ifdef MOSS

				case SH_AntMoss:
					editparam = SH_AntMoss;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS + editmode );
					break;
#endif //MOSS

				case SH_AntIQ:
					editparam = SH_AntIQ;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS + editmode );
					break;

				case SH_ALLBUGS:
					editmode = 0;
					CheckRadioButton( hDlg, SH_ALLBUGS, SH_SINGLEBUG,
						SH_ALLBUGS);
					break;

				case SH_COLONYBUGS:
					if (editmode == 1)
					{
						if (++editcolonyid >= colonycount)
							editcolonyid = 0;
					}
					else 
					{
						editmode = 1;
						CheckRadioButton( hDlg, SH_ALLBUGS,
							SH_SINGLEBUG, SH_COLONYBUGS );
					}
			SetWindowText( GetDlgItem( hDlg, SH_COLONYBUGS),
				(LPSTR)((editcolonyid==0)?"Green Colony":
				((editcolonyid==1)?"Red Colony":"Blue Colony")));
//					label( hDlg, SH_COLONYBUGS, "Colony",
//						(short)(editcolonyid + 1) );
					editbugid = Colony[editcolonyid].rank[0];
					label( hDlg, SH_SINGLEBUG, "Bopper",
						(short)(editbugid+1));
					currradius = Bug[editbugid]->radius;
					currbugbodyflag = Bug[editbugid]->bugbodyflag;
					currlineflag = Bug[editbugid]->lineflag;
					currdirectiontype = Bug[editbugid]->directiontype;
#ifdef MOSS
					currmossflag = Bug[editbugid]->mossflag;
#endif //MOSS
					currstates = Bug[editbugid]->states;
					currbasespeed = Bug[editbugid]->basespeed;
					currmotiontype = Bug[editbugid]->motiontype;
					hCntl = GetDlgItem( hDlg, SH_BUGICON);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD) currbugbodyflag, 0);
					hCntl = GetDlgItem( hDlg, SH_MOTIONCOMBO);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD) currmotiontype, 0);
					hCntl = GetDlgItem( hDlg, SH_WINDCOMBO);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD)( !(three_d_flag &&
						currdirectiontype >= DIRECTIONTYPES_3D)?
						currdirectiontype:0), 0 );
					hCntl = GetDlgItem( hDlg, SH_LINECOMBO);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD) currlineflag, 0);
					hCntl = GetDlgItem( hDlg, SH_NODECOMBO);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD) currradius, 0);
					numlabel( hDlg, SH_STATES,
						(short)currstates );
					numlabel( hDlg, SH_BASESPEED,
						(short)currbasespeed );
#ifdef MOSS
			CheckDlgButton( hDlg, SH_MOSSBOX,
				(currmossflag) ? MF_CHECKED:MF_UNCHECKED);
#endif //MOSS
					break;

				case SH_SINGLEBUG:
					if (editmode != 2)
					{
						editmode = 2;
						for (i=0; i< livebugcount; i++)
						// single out the bugnum index of editbugid
							if (bugnum[i] == editbugid)
								editbugnum = i;
					}
					else //if (editmode == 2)
					{ // and bump the editbugnum and fetch the colonyid
						if (++editbugnum >= livebugcount)
							editbugnum = 0;
						editbugid = bugnum[editbugnum];
						editcolonyid = Bug[editbugid]->colonyid;
					}
					label( hDlg, SH_SINGLEBUG, "Bopper",
						(short)(editbugid + 1) );
			SetWindowText( GetDlgItem( hDlg, SH_COLONYBUGS),
				(LPSTR)((editcolonyid==0)?"Green Colony":
				((editcolonyid==1)?"Red Colony":"Blue Colony")));
//					label( hDlg, SH_COLONYBUGS, "Colony",
//						(short)(editcolonyid + 1) );
					currbugbodyflag = Bug[editbugid]->bugbodyflag;
					currradius = Bug[editbugid]->radius;
					currlineflag = Bug[editbugid]->lineflag;
					currdirectiontype = Bug[editbugid]->directiontype;
#ifdef MOSS
					currmossflag = Bug[editbugid]->mossflag;
#endif //MOSS
					currstates = Bug[editbugid]->states;
					currbasespeed = Bug[editbugid]->basespeed;
					currmotiontype = Bug[editbugid]->motiontype;
					hCntl = GetDlgItem( hDlg, SH_BUGICON);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD) currbugbodyflag, 0);
					hCntl = GetDlgItem( hDlg, SH_MOTIONCOMBO);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD) currmotiontype, 0);
					hCntl = GetDlgItem( hDlg, SH_WINDCOMBO);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD)( !(three_d_flag &&
						currdirectiontype >= DIRECTIONTYPES_3D)?
						currdirectiontype:0), 0 );
					hCntl = GetDlgItem( hDlg, SH_LINECOMBO);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD) currlineflag, 0);
					hCntl = GetDlgItem( hDlg, SH_NODECOMBO);
					SendMessage( hCntl, CB_SETCURSEL,
						(WORD) currradius, 0);
					numlabel( hDlg,SH_STATES,
							(short)currstates );
					numlabel( hDlg, SH_BASESPEED,
							(short)currbasespeed );
#ifdef MOSS
			CheckDlgButton( hDlg, SH_MOSSBOX,
				(currmossflag) ? MF_CHECKED:MF_UNCHECKED);
						CheckRadioButton( hDlg, SH_ALLBUGS,
							SH_SINGLEBUG, SH_SINGLEBUG );
#endif //MOSS
					break;

				case SH_BUGICON:
					editparam = SH_BodyIcon;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					currbugbodyflag = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case SH_WINDCOMBO:
					editparam = SH_AntDir;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					currdirectiontype = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case SH_MOTIONCOMBO:
					editparam = SH_AntGnat;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					currmotiontype = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case SH_LINECOMBO:
					editparam = SH_TrailLines;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					currlineflag = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case SH_NODECOMBO:
					editparam = SH_TrailNodes;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					currradius = SendMessage( lParam,
						CB_GETCURSEL, 0, 0L);
					break;

				case SH_STATESMINUS:
					editparam = SH_AntIQ;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
						editparam );
					if (currstates > 1)
						currstates /= 2;
					numlabel( hDlg, SH_STATES,
							(short)currstates );
					break;

#ifdef MOSS
				case SH_MOSSBOX:
					editparam = SH_AntMoss;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
						editparam );
					currmossflag ^= 1;
					CheckDlgButton( hDlg, SH_MOSSBOX,
						(currmossflag) ?
						MF_CHECKED:MF_UNCHECKED);
					break;
#endif //MOSS


				case SH_STATESPLUS:
					editparam = SH_AntIQ;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					temp = currstates;
					currstates *= 2;
					if (!currstates)
						currstates = 1;
					if (currstates >= MAXSTATES ||
						currstates < temp)
		// if 2*currstates < currstates, then you overflowed
		// past 255.  Recall that for unsigned byte 256=0.
						currstates = MAXSTATES;
					numlabel( hDlg, SH_STATES,
							(short)currstates );
					break;

				case SH_BASESPEEDMINUS:
					editparam = SH_Speed;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					if (currbasespeed > 1)
						currbasespeed--;
					numlabel( hDlg, SH_BASESPEED,
							(short)currbasespeed );
					break;

				case SH_BASESPEEDPLUS:
					editparam = SH_Speed;
					CheckRadioButton( hDlg, SH_BodyIcon, SH_AntIQ,
					editparam );
					if (currbasespeed < MAX_SPEED)
						currbasespeed++;
					numlabel( hDlg, SH_BASESPEED,
							(short)currbasespeed );
					break;

				case SH_APPLY:
					switch (editparam)
					{
						case SH_BodyIcon:
                        	hdc = GetDC(hwnd);
							switch (editmode)
							{
								case 0:// all bugs
									for (i=0; i< livebugcount;i++)
									{
										if (Bug[bugnum[i]]->
											bugbodyflag == 1 &&
											currbugbodyflag == 2)
												BugBodyErase(hdc,
													Bug[bugnum[i]]->oldx,
													Bug[bugnum[i]]->oldy);
										Bug[bugnum[i]]->bugbodyflag=
											currbugbodyflag;
                                    }
									break;
								case 1:// one colony
									for (i=0; i< Colony[
										editcolonyid].pop; i++)
                                        {
					if (Bug[Colony[editcolonyid].rank[i]]->
											bugbodyflag == 1 &&
											currbugbodyflag == 2)
												BugBodyErase(hdc,
													Bug[Colony[editcolonyid].rank[i]]->oldx,
													Bug[Colony[editcolonyid].rank[i]]->oldy);
										Bug[Colony[editcolonyid].rank[i]]->
											bugbodyflag=
											currbugbodyflag;
                                        }
									break;
								case 2:// one bug
										if (Bug[editbugid]->
											bugbodyflag == 1 &&
											currbugbodyflag == 2)
												BugBodyErase(hdc,
													Bug[editbugid]->oldx,
													Bug[editbugid]->oldy);
									Bug[editbugid]->bugbodyflag =
											currbugbodyflag;
									break;
							}
                            ReleaseDC(hwnd,hdc);
							break;
						case SH_TrailNodes:
							switch (editmode)
							{
								case 0:// all bugs
									for (i=0; i< livebugcount;i++)
									{
										Bug[bugnum[i]]->radius=
											currradius;
									}
									break;
								case 1:// one colony
									for (i=0; i< Colony[
										editcolonyid].pop; i++)
									{
										Bug[Colony[editcolonyid].
											rank[i]]->
											radius=
											currradius;
									}
									break;
								case 2:// one bug
									Bug[editbugid]->radius =
											currradius;
									break;
							}
							break;
						case SH_TrailLines:
							switch (editmode)
							{
								case 0:// all bugs
									for (i=0; i< livebugcount;i++)
										Bug[bugnum[i]]->lineflag=
											currlineflag;
									break;
								case 1:// one colony
									for (i=0; i< Colony[
										editcolonyid].pop; i++)
										Bug[Colony[editcolonyid].
											rank[i]]->
											lineflag=
											currlineflag;
									break;
								case 2:// one bug
									Bug[editbugid]->lineflag =
											currlineflag;
									break;
							}
							break;
						case SH_Speed:
							switch (editmode)
							{
								case 0:// all bugs
									for (i=0; i< livebugcount;i++)
										if (Bug[bugnum[i]]->
											basespeed !=
											currbasespeed)
											Bug[bugnum[i]]->
												basespeed =
												currbasespeed;
									break;
								case 1:// one colony
									for (i=0; i< Colony[
										editcolonyid].pop; i++)
										if (Bug[Colony[
											editcolonyid].
											rank[i]]->
											basespeed !=
											currbasespeed)
											Bug[Colony[
												editcolonyid].
												rank[i]]->
												basespeed =
												currbasespeed;
									break;
								case 2:// one bug
									if (Bug[editbugid]->basespeed !=
										currbasespeed)
										Bug[editbugid]->
											basespeed =
											currbasespeed;
									break;
							}
							break;
//Oh, FUCK the indents!
case SH_AntGnat:
	switch (editmode)
		{
		case 0:// all bugs
			for (i=0; i< livebugcount;i++)
						if (Bug[bugnum[i]]->motiontype !=
							currmotiontype)
						{
							Bug[bugnum[i]]->motiontype =
								currmotiontype;
							installmotiontype(Bug[bugnum[i]]);
// Need to call DNA_to_RNA after installmotintype, as boids and
// turmites set different DNA_length, also to install boid params.
							DNA_to_RNA(Bug[bugnum[i]]);
						}
			break;
		case 1:// one colony
			for (i=0; i< Colony[
				editcolonyid].pop; i++)
						if (Bug[Colony[editcolonyid].rank[i]]->motiontype !=
							currmotiontype)
						{
							Bug[Colony[editcolonyid].rank[i]]->motiontype =
								currmotiontype;
							installmotiontype(Bug[Colony[editcolonyid].rank[i]]);
							DNA_to_RNA(Bug[Colony[editcolonyid].rank[i]]);
						}
			break;
		case 2:// one bug
						if (Bug[editbugid]->motiontype !=
							currmotiontype)
						{
							Bug[editbugid]->motiontype =
								currmotiontype;
							installmotiontype(Bug[editbugid]);
							DNA_to_RNA(Bug[editbugid]);
						}
			break;
	}
	if (hDlgGene)
	{  // DNA_length changes with switch between turmite & boid
		DestroyWindow(hDlgGene);
		SendMessage(hwnd, WM_COMMAND, IDM_GENE,
			0L);
	}
	break;
case SH_AntDir:
	switch (editmode)
	{
		case 0:// all bugs
			for (i=0; i< livebugcount;i++)
						if (Bug[bugnum[i]]->directiontype !=
							currdirectiontype)
						{
							Bug[bugnum[i]]->directiontype =
								currdirectiontype;
							installdirectiontype(Bug[bugnum[i]]);
							DNA_to_RNA(Bug[bugnum[i]]);
						}
			break;
		case 1:// one colony
			for (i=0; i< Colony[
				editcolonyid].pop; i++)
				if (Bug[Colony[editcolonyid].rank[i]]->directiontype !=
					currdirectiontype)
				{
					Bug[Colony[editcolonyid].rank[i]]->directiontype =
						currdirectiontype;
					installdirectiontype(Bug[Colony[editcolonyid].rank[i]]);
					DNA_to_RNA(Bug[Colony[editcolonyid].rank[i]]);
				}
			break;
		case 2:// one bug
						if (Bug[editbugid]->directiontype !=
							currdirectiontype)
						{
							Bug[editbugid]->directiontype =
								currdirectiontype;
							installdirectiontype(Bug[editbugid]);
							DNA_to_RNA(Bug[editbugid]);
						}
			break;
	}
	break;
#ifdef MOSS
case SH_AntMoss:
	switch (editmode)
	{
		case 0:// all bugs
			for (i=0; i< livebugcount;i++)
				Bug[bugnum[i]]->mossflag = currmossflag;
			break;
		case 1:// one colony
			for (i=0; i< Colony[editcolonyid].pop; i++)
				Bug[Colony[editcolonyid].rank[i]]->mossflag =
					currmossflag;
			break;
		case 2:// one bug
				Bug[editbugid]->mossflag = currmossflag;
			break;
	}
	break;
#endif //MOSS
case SH_AntIQ:
	switch (editmode)
	{
		case 0:// all bugs
			for (i=0; i< livebugcount;i++)
				if (Bug[bugnum[i]]->states != currstates)
				{
					changestates(Bug[bugnum[i]], currstates);
					DNA_to_RNA(Bug[bugnum[i]]);
				}
			break;
		case 1:// one colony
			for (i=0; i< Colony[
				editcolonyid].pop; i++)
				if (Bug[Colony[editcolonyid].rank[i]]->states != currstates)
				{
					changestates(Bug[Colony[editcolonyid].rank[i]], currstates);
					DNA_to_RNA(Bug[Colony[editcolonyid].rank[i]]);
				}
				Bug[Colony[editcolonyid].
					rank[i]]->
					bugbodyflag=
					currbugbodyflag;
			break;
		case 2:// one bug
				if (Bug[editbugid]->states != currstates)
				{
					changestates(Bug[editbugid], currstates);
					DNA_to_RNA(Bug[editbugid]);
				}
			break;
	}
	if (hDlgGene)
	{  // DNA_length changes with IQ
		DestroyWindow(hDlgGene);
		SendMessage(hwnd, WM_COMMAND, IDM_GENE,
			0L);
	}
	break;
}
					break;

				case SH_OK:
					DestroyWindow( hDlg );
					break;

				default:
					break;
			}
			return TRUE; // End of WM_COMMAND case in main switch.

		default:
			return FALSE; // Case where message means nothing to me.
	}
}

//------------------
void BugBodyErase(HDC hdc, short ex, short ey)
{	// Erase a body at ex,ey. Is called by shape.cpp and hotkey.cpp,
	short x,y,prex,prey,prexplus,preyplus,
		inx,iny,outx,outy,overlap, BugBody_CX, BugBody_CY;

	if (!three_d_flag)
	{
		BugBody_CX = MAX_BugBody_2D_CX;
		BugBody_CY = MAX_BugBody_2D_CY;
	}
	else
	{
		BugBody_CX = MAX_BugBody_3D_CX;
		BugBody_CY = MAX_BugBody_3D_CY;
	}
	prex = XWRAP( ex - (BugBody_CX/2) );
	prey = YWRAP( ey - (BugBody_CY/2) );
	prexplus = prex + BugBody_CX;
	preyplus = prey + BugBody_CY;
	overlap = 0;
	if (prexplus > BugLand_MAXX)
	{
		inx = BugLand_CX - prex;
		outx = prexplus - BugLand_CX;
		overlap = 1;
	}
	if (preyplus > BugLand_MAXY)
	{
		iny = BugLand_CY - prey;
		outy = preyplus - BugLand_CY;
		overlap |= 2;
	}
	x = XWRAP(prex - WinOrgX);
	y = YWRAP(prey - WinOrgY);

	if (!( lensflag &&
		( lensrect.left<(x+BugBody_CX) ) && ( x<lensrect.right ) &&
		( lensrect.top<(y+BugBody_CY) ) && ( y<lensrect.bottom ) ) )
		// You need to check this "again" here since you
		// don't wbug to restore if the lens just got turned on.
		switch (overlap) 	// Restore underbody square
		{
			case 0: // no overlap
				BitBlt(hdc, x, y, BugBody_CX, BugBody_CY,
					hdcBugLand, prex, prey, SRCCOPY);
				break;
			case 1: // x overlap
				BitBlt(hdc, x, y, inx, BugBody_CY,
					hdcBugLand, prex, prey, SRCCOPY);
				BitBlt(hdc, x + inx, y, outx, BugBody_CY,
					hdcBugLand, 0, prey, SRCCOPY);
				break;
			case 2: // y overlap
				BitBlt(hdc, x, y, BugBody_CX, iny,
					hdcBugLand, prex, prey, SRCCOPY);
				BitBlt(hdc, x, y + iny, BugBody_CX, outy,
					hdcBugLand, prex, 0, SRCCOPY);
				break;
			case 3: // x and y overlap
				BitBlt(hdc, x, y, inx, iny,
					hdcBugLand, prex, prey, SRCCOPY);
				BitBlt(hdc, x+inx, y, outx, iny,
					hdcBugLand, 0, prey, SRCCOPY);
				BitBlt(hdc, x, y+iny, inx, outy,
					hdcBugLand, prex, 0, SRCCOPY);
				BitBlt(hdc, x + inx, y + iny, outx, outy,
					hdcBugLand, 0, 0, SRCCOPY);
				break;
		}
	// The lens is fresh from BugLand each update, so we don't 
	// need to erase anything for the on-lens case.
}

struct bug *findbug(short x, short y, short rad)
{ //bug.cpp
	unsigned char i, neari;
	short bx, by;
	float dx, dy, dist, neardist;

	// Get the bugland position represented by this screen position.
	// The screen window is the viewport into the bugland world.
	bx = XWRAP(x + WinOrgX);  // NOte that this is inverse to 
	by = YWRAP(y + WinOrgY);	// what is done in the putpixel function.
    neardist = rad;
	for (i=0; i<livebugcount; i++)
	{
		dx = Bug[bugnum[i]]->x - bx;
		dy = Bug[bugnum[i]]->y - by;
		dist = sqrt(dx*dx + dy*dy);
		if (dist < neardist)
		{
			neari = i;
			neardist = dist;
		}
	}
	if ( neari < MAXBUGS)
	{
		MessageBeep(0);
		return Bug[bugnum[neari]];
	}
	else
		return NULL;
}
