/* griff.c
	This rule is David Griffeath's cyclic appetite rule,
	described in Notices of the AMS, December, 1988, p. 1474.  At each
	update, each cell looks at a single randomly selected neighbor.  If
	the neighbor's state is one greater than the cell's state mod STATE_COUNT,
	then the cell takes on the neighbor's state, otherwise it stays the
	same.
	The naber.jco rule loads the first argument of jcrule with 16 bits of
	which the high eight	bits are the state of a randomly chosen neighbor
	cell, and of which the low eight bits are the state of the cell.  Naber
	includes its own randomizer, which is based on a 16 bit shift-register
	realization of Wolfram's 1D CA rule with code 30.  This specific
	radomizer was invented and patented by Wolfram, and incorporates an
	enhancement introduced by Rucker.
*/

#define STATE_COUNT 12  //You can set this to any value up to 256.

#include "jcrule.h"

int jcrule(int nabe_and_me,
           int dummy1, int dummy2, int dummy3, int dummy4, int dummy5,
           int dummy6, int dummy7, int dummy8, int dummy9, int dummy10)
 /* After naber.jco, nabe_and_me's hi byte holds a random neighbor, and its
 low byte holds the cell's own eight bits.  The dummy?? variables are
 simply placeholders as jcrule expects eleven int integer parameters*/
{
	int mystate, nabestate, mynextstate;
	static int firsttime = 1;

	if (firsttime)
	{
		rseedb = 0; //Seed each cell with random bits, starting at bit 0,
		rseedn = 8; //and going up to bit 7
		strcpy(palreq, "autocad");
		strcpy(ocodereq, "naber");
		worldtype = 13;  //User owncode world
		firsttime = 0;
	}

	mystate = (nabe_and_me & 0xFF) % STATE_COUNT;
	//The low byte of nabe_and_me, modulo STATE_COUNT.
	nabestate = ((nabe_and_me >> 8) & 0xFF) % STATE_COUNT;
	//The high byte of nabe_and_me, modulo STATE_COUNT.
	mynextstate = (mystate + 1) % STATE_COUNT;
	//The next state higher than mystate, modulo STATE_COUNT.
  if (nabestate == mynextstate)
		return mynextstate;
  else
		return mystate;
}

