#include "game.h"
#include <stdio.h>
/* Taken from FERN.ifs */
mapper FERN_ifs[] = {
	{0.000, 0.000, 0.000, 0.160, 0.000, 0.000, 0.010},
	{0.850, 0.040, -0.040, 0.850, 0.000, 1.600, 0.850},
	{0.200, -0.260, 0.230, 0.220, 0.000, 1.600, 0.070},
	{-0.150, 0.280, 0.260, 0.240, 0.000, 0.440, 0.070},
};

barnmap_set FERN_ifs_set = {
	4,
	FERN_ifs,
	"Fern",
	-4.432, -1.0, 6.5, 11.025
};

/* Taken from ZIGZAG.ifs */
mapper ZIGZAG_ifs[] = {
	{0.788, -0.552, -0.352, -0.791, 2.730, 6.483, 0.890},
	{-0.149, -0.403, -0.191, 0.164, -4.914, 5.243, 0.110},
};

barnmap_set ZIGZAG_ifs_set = {
	2,
	ZIGZAG_ifs,
	"Zigzag",
	-9.020, -5.174, 11.367, 11.621
};

/* Taken from TWIGS.ifs */
mapper TWIGS_ifs[] = {
	{0.424, -0.652, -0.485, -0.345, 3.443, 2.894, 0.622},
	{0.030, -0.439, -0.636, -0.023, -1.428, 6.438, 0.378},
};

barnmap_set TWIGS_ifs_set = {
	2,
	TWIGS_ifs,
	"Twigs",
	-7.020, -4.174, 7.367, 11.621
};

/* Taken from SPIRALS.ifs */
mapper SPIRALS_ifs[] = {
	{0.788, -0.424, 0.242, 0.860, 1.722, 1.402, 0.896},
	{-0.121, 0.258, 0.152, 0.053, -6.727, 1.300, 0.052},
	{0.182, -0.136, 0.091, 0.182, 6.072, 1.501, 0.052},
};

barnmap_set SPIRALS_ifs_set = {
	3,
	SPIRALS_ifs,
	"Spirals",
	-9.020, -1.174, 7.367, 9.621
};

/* Taken from PINCHER.ifs */
mapper PINCHER_ifs[] = {
	{0.771, -0.485, -0.419, -0.724, 2.131, 7.559, 0.869},
	{-0.259, -0.109, -0.136, 0.171, 5.852, 0.807, 0.068},
	{0.309, 0.125, 0.265, -0.074, -5.632, 8.252, 0.064},
};

barnmap_set PINCHER_ifs_set = {
	3,
	PINCHER_ifs,
	"Pincher",
	-9.020, -2.174, 9.367, 10.621
};

/* Taken from NOOKS.ifs */
mapper NOOKS_ifs[] = {
	{0.286, 0.000, 0.000, 0.250, -3.130, -0.001, 0.105},
	{0.286, 0.000, 0.000, 0.250, -0.630, -0.001, 0.105},
	{0.429, 0.000, 0.000, 0.250, 2.497, -0.001, 0.158},
	{0.000, -0.250, 0.286, 0.000, 4.369, 3.752, 0.105},
	{0.000, -0.250, 0.286, 0.000, 4.369, 6.252, 0.105},
	{0.000, -0.250, 0.286, 0.000, 4.369, 8.753, 0.105},
	{-0.286, 0.000, 0.000, -0.250, 0.617, 10.001, 0.105},
	{-0.286, 0.000, 0.000, -0.250, -1.884, 10.001, 0.105},
	{0.286, 0.000, 0.000, 0.250, -3.130, 2.500, 0.106},
};

barnmap_set NOOKS_ifs_set = {
	9,
	NOOKS_ifs,
	"Nooks",
	-6.020, -0.174, 5.367, 10.621
};

/* Taken from KOCH3.ifs */
mapper KOCH_ifs[] = {
	{0.308, -0.000, 0.000, 0.294, 4.128, 1.587, 0.152},
	{0.192, -0.206, 0.654, 0.088, -0.674, 5.935, 0.254},
	{0.192, 0.206, -0.654, 0.088, 0.690, 5.948, 0.254},
	{0.308, -0.000, 0.000, 0.294, -4.115, 1.587, 0.152},
	{0.385, -0.000, 0.000, -0.294, 0.006, 2.909, 0.189},
};

barnmap_set KOCH_ifs_set = {
	5,
	KOCH_ifs,
	"Koch",
	-7.020, -2.174, 7.367, 11.621
};

/* Modelled on DUG.ifs */
mapper chaos_ifs[] = {
	{0, 0.053, -0.429, 0, -7.083, 5.43, 0.095},
	{0.143, 0, 0, -0.053, -5.619, 8.513, 0.032},
	{0.143, -0, 0, 0.083, -5.619, 2.057, 0.032},
	{0, 0.053, 0.429, 0, -3.952, 5.43, 0.095},
	{0.119, -0, 0, 0.053, -2.555, 4.536, 0.026},
	{-0.0123806, -0.0649723, 0.423819, 0.00189797, -1.226, 5.235, 0.09},
	{0.0852291, 0.0506328, 0.420449, 0.0156626, -0.421, 4.569, 0.095},
	{0.104432, 0.00529117, 0.0570516, 0.0527352, 0.976, 8.113, 0.026},
	{-0.00814186, -0.0417935, 0.423922, 0.00415972, 1.934, 5.37, 0.085},
	{0.093, -0, 0, 0.053, 0.861, 4.536, 0.032},
	{0, 0.053, -0.429, 0, 2.447, 5.43, 0.095},
	{0.119, 0, 0, -0.053, 3.363, 8.513, 0.026},
	{0.119, 0, 0, 0.053, 3.363, 1.487, 0.026},
	{0, 0.053, 0.429, 0, 3.972, 4.569, 0.095},
	{0.123998, -0.00183957, 0.000691208, 0.0629731, 6.275, 7.716, 0.026},
	{0, 0.053, 0.167, 0, 5.215, 6.483, 0.037},
	{0.071, -0, 0, 0.053, 6.279, 5.298, 0.016},
	{0, -0.053, -0.238, 0, 6.805, 3.714, 0.053},
	{-0.121, 0, 0, 0.053, 5.941, 1.487, 0.016},
};

barnmap_set chaos_ifs_set = {
	19,
	chaos_ifs,
	"Chaos",
	-8.16602, -2.95703, 7.83008, 13.0312
};

/* Taken from DIAMOND.ifs */
mapper DIAMOND_ifs[] = {
	{0.733, 0.000, 0.000, 0.267, 1.642, -0.002, 0.229},
	{0.000, -0.328, 0.595, 0.000, 6.158, 6.333, 0.229},
	{-0.733, 0.000, 0.000, -0.267, -1.645, 10.000, 0.229},
	{0.000, 0.328, -0.595, 0.000, -6.161, 3.665, 0.229},
	{-0.267, 0.246, -0.217, -0.067, -1.233, 5.332, 0.083},
};

barnmap_set DIAMOND_ifs_set = {
	5,
	DIAMOND_ifs,
	"Diamond",
	-8.1, -0.3, 8.3, 10.4
};

/* Taken from BROACH.ifs */
mapper BROACH_ifs[] = {
	{0.788, -0.549, 0.576, 0.527, 2.816, 3.517, 0.791},
	{-0.333, -0.417, 0.394, -0.087, 2.601, 2.124, 0.209},
};

barnmap_set BROACH_ifs_set = {
	2,
	BROACH_ifs,
	"Brooch",
	-7.020, -1.174, 8.367, 11.621
};

/* Taken from BOX.ifs */
mapper BOX_ifs[] = {
	{0.500, 0.000, 0.000, 0.500, -1, 1, 0.333},
	{-0.500, 0.000, 0.000, 0.500, 1, 1, 0.333},
	{-0.500, 0.000, 0.000, -0.500, 1, -1, 0.0},
	{0.500, 0.000, 0.000, -0.500, -1, -1, 0.334},
};

barnmap_set BOX_ifs_set = {
	4,
	BOX_ifs,
	"Box",
	-2.0, -2.0, 2.0, 2.0
};

/* Taken from needle.ifs */
mapper needle_ifs[] = {
	{0.636, -0.727, -0.515, -0.405, 3.306, 4.954, 0.727},
	{0.152, -0.322, 0.485, -0.155, -3.653, 5.784, 0.143},
	{0.0570167, 0.261081, 0.410815, -0.232405, -2.70303, 9.85344, 0.13},
};

barnmap_set needle_ifs_set = {
	3,
	needle_ifs,
	"Needle",
	-8.000, -0.000, 8.000, 12.000
};

/* Taken from wood.ifs */
mapper wood_ifs[] = {
	{-0.250, 0.750, 0.250, 0.250, -3.471, 5.811, 0.48},
	{-0.250, 0.750, 0.250, 0.250, -6.996, 2.286, 0.05},
	{-0.250, 0.750, 0.250, 0.250, 0.055, 2.286, 0.05},
	{-0.489319, -0.22848, 0.202374, -0.552442, 5.7893, 2.46183, 0.42}
};

barnmap_set wood_ifs_set = {
	4,
	wood_ifs,
	"Wood",
	-8.5, -5.0, 8.5, 11.000
};

mapper sierpinski_ifs[] = {
	{0.5, 0, 0, 0.5, -1, 1, 0.333},
	{0.5, 0, 0, 0.5, 1, 1, 0.333},
	{0.5, 0, 0, 0.5, 0, -1, 0.333},
};

barnmap_set sierpinski_ifs_set = {
	3,
	sierpinski_ifs,
	"Sierpinski",
	-2.3, -2.1, 2.3, 2.3
};

mapper cloud_ifs[] = {
	{0.5, 0.0993347, 0, 0.490033, -0.7, 0.4, 0.0498047},
	{-0.490033, 0, 0.0993347, 0.5, 0.6, 0.7, 0.174805},
	{0.5, 0.14776, 0, 0.477668, 0.7, -0.8, 0.237305},
	{-0.490033, 0, 0.0993347, 0.5, -0.9, -0.8, 0.487305},
	{0.3, 0, 0, 0.3, -0.348671, -0.0640183, 0.0507812}
};

barnmap_set cloud_ifs_set = {
	5,
	cloud_ifs,
	"Cloud",
	-2.3, -2.4, 2.3, 1.9
};

mapper dragon_ifs[] = {
	{0.5, 0, 0, -0.5, -1, -1, 0.25},
	{-0.7863, 0.1562, -0.1562, -0.7863, 0.4, 0.4, 0.75}
};

barnmap_set dragon_ifs_set = {
	2,
	dragon_ifs,
	"Dragon",
	-2.0, -2.0, 2.0, 2
};

mapper manyleg_ifs[] = {
	{-0.5, 0, 0, -0.5, 1, -1, 0.375},
	{0.8863, -0.1562, 0.1562, 0.8863, 0.3, -0.3, 0.625}
};

/*
*/
barnmap_set manyleg_ifs_set = {
	2,
	manyleg_ifs,
	"Manyleg",
	-0.582031, -2.82812, 3.41797, 1.16406
};

mapper peitgen_tree_ifs[] = {
	{0.195, -0.488, 0.344, 0.443, 0.722, 0.536, 0.4},
	{0.462, 0.414, -0.252, 0.361, 0.538, 1.167, 0.4},
	{-0.058, -0.070, 0.453, -0.111, 1.125, 0.185, 0.1},
	{-0.045, 0.091, -0.469, -0.022, 0.863, 0.871, 0.1}
};

barnmap_set peitgen_tree_ifs_set = {
	4,
	peitgen_tree_ifs,
	"Peitgen tree",
	-0.2, -0.3, 2.2, 2
};


/* This is the big mother nautilus from Barn20. */

mapper nautilus_ifs[] = {
	{0.5, 0, 0, -0.5, -0.3, -0.3, 0.125},
	{0.2, 0, 0, 0.2, 0, -1.5, 0.125},
	{0.85, 0.3, -0.3, 0.85, -0.3, 0.2, 0.750},
	{0.8863, -0.1562, 0.1562, 0.8863, 0.3, -0.3, 0.0},
	{0.8863, -0.1562, 0.1562, 0.8863, 0, 0, 0.0},
	{0.4, -0.52, 0.23, 0.22, -0.3, 0, 0.0}
};

barnmap_set nautilus_ifs_set = {
	6,
	nautilus_ifs,
	"Nautilus",
	-2, -1.8, 2, 2.2
};


/* Taken from surf.ifs */
mapper surf_ifs[] = {
	{0.366313, -0.32953, 0.340636, 0.376045, 0.27336, -0.170977, 0.333},
	{0.353571, -0.210804, 0.425489, 0.453389, -0.785071, -0.792724, 0.333},
	{0.5, 0, 0, 0.5, 0, -1, 0.333},
};

barnmap_set surf_ifs_set = {
	3,
	surf_ifs,
	"Surf",
	-1.0996, -1.99478, 1.2004, 0.205217
};

mapper mud_ifs[] = {
	0.366313, -0.32953, 0.340636, 0.376045, 0.27336, -0.170977, 0.295898,
	0.353571, -0.210804, 0.425489, 0.453389, -0.03658, -0.895974, 0.295898,
	0.5, 0, 0, 0.5, 0, -1, 0.233398,
	0.3, 0, 0, 0.3, -0.723226, -1.19069, 0.125,
	0.438283, 0, 0, 0.43913, -0.243246, -0.339247, 0.0498047
};

barnmap_set mud_ifs_set = {
	5,
	mud_ifs,
	"Mud",
	-1.06257, -1.99478, 1.23743, 0.205217
};


barnmap_set *barnmap_table[] = {
	&nautilus_ifs_set,
	&FERN_ifs_set,
	&sierpinski_ifs_set,
	&cloud_ifs_set,
	&dragon_ifs_set,
	&manyleg_ifs_set,
	&peitgen_tree_ifs_set,
	&ZIGZAG_ifs_set,
	&SPIRALS_ifs_set,
	&NOOKS_ifs_set,
	&KOCH_ifs_set,
	&chaos_ifs_set,
	&surf_ifs_set,
	&PINCHER_ifs_set,
	&DIAMOND_ifs_set,
	&BROACH_ifs_set,
	&BOX_ifs_set,
	&TWIGS_ifs_set,
	&wood_ifs_set,
	&needle_ifs_set,
	&mud_ifs_set,
	NULL
};
