PROGRAM Spiro3;
USES
    Graph, Drivers, Fonts, CRT;
CONST
     DS = 0.25;
     YOVERX = 0.7;

VAR
   GDriver, GMode, MaxX, MaxY, MaxColor, px, py, color : integer;
   halfx,lox,hix,loy,hiy,x,y :real;
   TriangleFlag,RandomizeFlag, MonoFlag, PauseFlag, ExitFlag, SoundFlag:Boolean;
   outside, t,dt,a,b,k : real;
   olderpx, olderpy, oldpx, oldpy: integer;
   counter, length, metacounter, metalength : word;
   triangle : ARRAY[1..8] OF integer;
PROCEDURE Inform;
VAR
   Key: char;
BEGIN
Writeln('Spiro2. Epitrochoid/Hypotrochoid Program by Rudy Rucker, February 5, 1991. ');
Writeln('A circle of radius b rolls around the outside or inside of a  ');
Writeln('circle of radius a.  A radial stick of length k projects from the ');
Writeln('rolling circle and we draw lines connecting the successive ');
Writeln('positions of the tip of the stick, or we fill triangles of successive');
Writeln('triples of points.  Bars representing a,b, and k appear on left.');
Writeln('a,A : Decrease and increase the fixed circle radius a.');
Writeln('b,B : Decrease and increase the rolling circle radius b.');
Writeln('k,K : Decrease and increase the stick-length k.');
Writeln('f   : Toggle fill of triangles.  h   : Show this screen.');
Writeln('i   : Toggle between rolling outside/inside the fixed circle.');
Writeln('l,L : Decrease and increase the wait between color changes.');
Writeln('m,M : Decrease and increase the wait between randomization.');
Writeln('r   : Randomize once.  R: Toggle automatic randomization.');
Writeln('p   : Change Palette.  P: Toggle Mono.      q: QUIT.');
Writeln('t,T : Decrease and increase the size of the steps between points.');
Writeln('v   : Toggle on/off sound with pitch proportional to distance from center.');
Writeln('x   : Clear Screen.    Spacebar : Toggle pause.');
Writeln('z,Z : Zoom in or out.');
Writeln;
Write('a = ');Write(a:3:2);
Write('  b = ');Write(Abs(b):3:2);
Write('  k = ');Write(k:3:2);
Write('  dt = ');Writeln(dt:3:4);
Write('Color changes after each ', length, ' steps.');
IF (RandomizeFlag) THEN
   Write('  Parameters change after each ',metalength,' colors.');
Writeln;
Write('Rolling circle is ');
IF (outside<0) THEN
   Write('inside ')
   ELSE
   Write('outside ');
Write('fixed circle.');
Writeln;
Writeln('Press any key to continue.');
WHILE (NOT KeyPressed) DO
      {Nothing};
Key := ReadKey;
END;

PROCEDURE StartGraphics;
BEGIN
     DetectGraph(GDriver,GMode);
     IF (GDriver < 0) THEN
        BEGIN
             writeln('No graphics hardware detected.');
             Halt;
        END;
     IF (RegisterBGIdriver(@EGAVGADriverProc) < 0) THEN
             writeln('No EGAVGA driver found.');
     IF (RegisterBGIdriver(@CGADriverProc) < 0) THEN
             writeln('No CGA driver found.');
     { IF (GDriver = VGA)_ THEN
        GMode := VGAMed;
     Put this in if you want to use SetActivePage and SetVisualPage.}
     IF (GDriver = CGA) THEN
        GMode := CGAC0;
     {Put this in if you want color instad of high resolution for the CGA}
     InitGraph(GDriver,GMode,'');  {Path doesn't work?}
     {Get cga.bgi and egavga.bgi files and put on your disk.  Copy them
      up into E: when using the lab machines.}
     MaxX := GetMaxX;
     MaxY := GetMaxY;
     MaxColor := GetMaxColor;
END;

PROCEDURE ChangePalette;
VAR
	pal: PaletteType;
	i: integer;
        startr,endr,dr,startg,endg,dg,startb,endb,db :integer;
BEGIN
	IF (GDriver = VGA) THEN
	BEGIN
		GetPalette(pal);
                startr := Random(256) OR 4;
                endr := Random(256) OR 4;
                dr := (endr - startr) DIV 15;
                startg := Random(256) OR 4;
                endg := Random(256) OR 4;
                dg := (endg - startg) DIV 15;
                startb := Random(256) OR 4;
                endb := Random(256) OR 4;
                db := (endb - startb) DIV 15;
		FOR I:=1 TO 15 DO
		SetRGBPalette( pal.colors[i],
                     startr + I * dr, startg + I * dg, startb + I * db );
	END
	ELSE IF (GDriver = EGA) THEN
		FOR I:=1 TO 15 DO
			SetPalette(i, random(64));
END;

PROCEDURE SetBounds;
BEGIN
     hix := halfx;
     hiy := YOVERX * hix;
     lox := -hix;
     loy := -hiy;
END;

PROCEDURE Convert(x,y:real;VAR px, py:integer);
BEGIN
     px := trunc( ((x - lox) * MaxX)/(hix - lox));
     py := trunc( ((hiy - y) * MaxY)/(hiy - loy));
END;

PROCEDURE ShowParams;
VAR
   ya,yb,d,x :integer;
   dp : real;
BEGIN
     SetLineStyle(0,0,3);
     dp := MaxY / (2 * YOVERX * HalfX);
     IF (NOT MonoFlag) THEN SetColor(1);
     d := trunc( a * dp );
     ya := (MaxY DIV 2 ) + d;
     yb := (MaxY DIV 2 ) - d;
     x := 6;
     Line(x,ya,x,yb);
     IF (NOT MonoFlag) THEN      SetColor(7);
     ya := yb;
     d :=  trunc( outside * b * dp );
     yb := ya - 2 * d;
     x := 12;
     Line(x,ya,x,yb);
     IF (NOT MonoFlag) THEN      SetColor(15);
     ya := ya - d;
     d := trunc( k * dp );
     yb := ya + d;
     ya := ya - d;
     x := 18;
     Line(x,ya,x,yb);
     SetColor(Color);
     SetLineStyle(0,0,1);
END;


PROCEDURE ReadKeyboard(PassChar:char);
VAR
   Key : char;
BEGIN

     IF ( (KeyPressed) OR (PassChar <> #0) ) THEN
     BEGIN
        IF (KeyPressed) THEN
          Key := ReadKey;
        IF (PassChar <> #0) THEN
          Key := PassChar;
        CASE (Key) OF
          'a':  IF (abs(a) > DS) THEN a := (a/Abs(a)) * (Abs(a) - DS);
          'A':  a := (a/Abs(a)) * (Abs(a) + DS);
          'b':  IF (abs(b) > DS) THEN b := (b/Abs(b)) * (Abs(b) - DS);
          'B':  b := (b/Abs(b)) * (Abs(b) + DS);
          'f':  TRiangleFlag := NOT TriangleFlag;
          'h':  BEGIN
                NoSound;
                RestoreCRTMode;
                Inform;
                SetGraphMode(GMode);
                END;
          'i':   outside := -outside;
          'k':  IF (abs(k) > DS) THEN k := (k/Abs(k)) * (Abs(k) - DS);
          'K':  k := (k/Abs(k)) * (Abs(k) + DS);
          'l':  IF (length > 1000) THEN length := length - 1000
                                   ELSE length := (length DIV 2) + 10;
          'L':  IF (length < 500) THEN length := 2 * length
                                  ELSE length := length + 1000;
          'm':  IF (metalength > 60) THEN metalength := metalength - 60
                                   ELSE metalength := (metalength DIV 2) + 1;
          'M':  IF (metalength < 60) THEN metalength := 2 * metalength
                                  ELSE metalength := metalength + 60;
          't':  dt := dt / 2;
          'T':  dt := dt * 2;
          'p':  ChangePalette;
          'P':  BEGIN
                 MonoFlag := NOT MonoFlag;
                 IF (MonoFlag) THEN
                    BEGIN
                    SetColor(MaxColor);
                    Color := MaxColor;
                    END;
                 END;
          'q','Q': ExitFlag := True;
          'r': BEGIN
               a := (3.0 * Random + 0.2);
               b := (2.0 * Random + 0.2);
               k := (3.0 * Random + 0.2);
               if (Random(2) = 1) THEN
                  dt := 0.2
                  ELSE
                  dt := Random * 4.0;
               IF (Random(2) = 1)
                  THEN outside := -outside;
               END;
          'R': RandomizeFlag := NOT RandomizeFlag;
          'v': BEGIN
                    SoundFlag := NOT SoundFlag;
                    IF (NOT SoundFlag) THEN
                       NoSound;
               END;
          'x': BEGIN ClearDevice; ShowParams; END;
          'z': BEGIN
                    HalfX := HalfX * 0.666;
                    SetBounds;
                END;
          'Z': BEGIN
                    HalfX := HalfX * 1.5;
                    SetBounds;
                END;
          ' ': PauseFlag := NOT PauseFlag;
        END;
        IF ( (Key <> 'v') AND (Key <> 'p') AND (Key <> ' ') AND
           (Key <> 'x') AND NOT PauseFlag ) THEN
           BEGIN
                ClearDevice;
                t := 0;
                x := a + outside * b - outside * k;
                y := 0;
                convert(x,y,px,py);
                oldpx := px;
                olderpx := px;
                oldpy := py;
                olderpy := py;
                ShowParams;
           END;
     END;
END;


BEGIN {Main}
      Randomize;
      HalfX := 7.0;
      SetBounds;
      StartGraphics;
      t := 0;
      length := 50;
      metalength := 16;
      outside := 1.0;
      RandomizeFlag := True;
      counter := 1;
      metacounter := 1;
      ExitFlag := False;
      SoundFlag := False;
      PauseFlag := False;
      MonoFlag := False;
      TriangleFlag := True;
      ReadKeyBoard('r');
      RestoreCRTMode;
      Inform;
      SetGraphMode(Gmode);
      ChangePalette;
      color := 1;
      SetColor(1);
      SetFillStyle(1,8);
      ShowParams;
      WHILE (NOT ExitFlag) DO
            BEGIN
                 t := t + dt;
                 x := (a+outside*b)*cos(t) - outside*k*cos(((a+outside*b)/b)*t);
                 y := (a+outside*b)*sin(t) - k*sin(((a+outside*b)/b)*t);
                 Convert(x,y,px,py);
                 IF (NOT TriangleFlag) THEN
                    Line(oldpx,oldpy,px,py)
                 ELSE
                    BEGIN
                         Triangle[1] := px;
                         Triangle[2] := py;
                         Triangle[3] := oldpx;
                         Triangle[4] := oldpy;
                         Triangle[5] := olderpx;
                         Triangle[6] := olderpy;
                         Triangle[7] := px;
                         Triangle[8] := py;
                         FillPoly(4, Triangle);
                    END;
                 olderpx := oldpx;
                 olderpy := oldpy;
                 oldpx := px;
                 oldpy := py;
                 IF (SoundFlag) THEN
                    Sound(trunc((1000/(hix - lox)) * Sqrt( x*x + y*y)));
                 counter := counter + 1;
                 IF ( (counter > length) AND (NOT MonoFlag) ) THEN
                    BEGIN
                         SetFillStyle(1,((color+ 7) MOD (MaxColor))+1 );
                         color := ( (color + 1) MOD (MaxColor) ) + 1;
                         SetColor(color);
                         counter := 1;
                         metacounter := metacounter+1;
                    END;
                 IF ( RandomizeFlag AND ( ( metacounter > metalength ) OR
                      ( MonoFlag AND (counter > length * metalength) ) ) )
                       THEN
                   BEGIN
                      ChangePalette;
                      ReadKeyBoard('r');
                      metacounter := 1;
                      counter := 1;
                   END;
                 ReadKeyBoard(#0);
                 WHILE (PauseFlag) DO
                       ReadKeyBoard(#0);
            END;
      NoSound;
      CloseGraph;
END.
