#ifndef BUTTON_HPP
#define BUTTON_HPP
#include <stdlib.h>
#include <conio.h>
#include <graphics.h>
#include <stdio.h>
#include "display.hpp"
#include "cursor.hpp"

enum {QUIT,HELP,RANDOM,LOAD,SAVE,ALL,ONE};

enum {DEGREE,FLOCKCOUNT,STEPSIZE,CRE,CIM,KRE,KIM,QRE,QIM};

enum {INC_DEGREE=7,INC_FLOCKCOUNT,INC_STEPSIZE,INC_CRE,INC_CIM,INC_KRE,
		INC_KIM,INC_QRE,INC_QIM,DEC_DEGREE,DEC_FLOCKCOUNT,DEC_STEPSIZE,
		DEC_CRE,DEC_CIM,DEC_KRE,DEC_KIM,DEC_QRE,DEC_QIM};

#define REGBUTTONS 7
#define VALBUTTONS 9
#define NUMBUTTONS (REGBUTTONS + VALBUTTONS)

#define TEXTHEIGHT textheight("Testy TESTY")
#define BUTTONFRAME 4 //Use for slack space around buttons on screen.
#define LABELFRAME 2//Use for slack space around label in button.
#define BUTTON_HEIGHT (TEXTHEIGHT + 2 * LABELFRAME);
#define BUTTON_WITH_VALUE_HEIGHT (2 * textheight("Testy TESTY") + 3 * LABELFRAME);

//-----------------Base class-Button-------------
class Button
{
protected:
	char *label;
	int left, top, right, bottom, labelx, labely;
	int fontsize;
	int edgecolor;
	int backgroundcolor;
public:
	Button(int ix, int iy, char *ilabel, int iedgecolor = WHITE,
		int ibackgroundcolor = BLUE);
	//BLUE is default value if background color not specified in constructor.
	void Show();
	int Hit(Cursor &cur);
	int Left(){return left;}
	int Top(){return top;}
	int Right(){return right;}
	int Bottom(){return bottom;}
	int Width(){return right - left + 1;}
	int Height(){return bottom - top + 1;}
	~Button(){delete label;}
};
//------------------Derived Class---Button_with_value------
class Button_with_value:public Button
{
private:
	char *valuelabel;
	int valuelabelx, valuelabely;
	Real real_val;
	int int_val;
public:
	Button_with_value(int ix, int iy, char *ilabel,int iedgecolor = WHITE,
		int ibackgroundcolor = BLUE);
	void Show(int int_val);
	void Show();
	void Show(char *stringval);
	~Button_with_value(){delete valuelabel;}
	void Set_realval(Real realval){ real_val = realval;}
	Real Get_realval(){return real_val;}
	void Set_intval(int intval){ int_val = intval;}
	int Get_intval(){return int_val;}
};

class ButtonBox
{
private:
	int left,top,right,bottom,midx;
	int oneflag;
public:
	Button *ButtonArray[7];   // I would like to have these two arrays
	Button_with_value *ValButtonArray[9];  // combined into one array!
	ButtonBox(BGIdisplay disp);
	~ButtonBox();
	void Show();
	int Hit(int cursorcode,Cursor *cur);
	void Set_oneflag(int flag){ oneflag = flag;}
	void ShowCKQButtons(Real cre,Real cim,Real kre,Real kim,Real qre,Real qim);
	void ShowValButtons();
};

#endif


