#include "cursor.hpp"
#include "keycode.hpp"
#include <stdio.h>
#include <conio.h>
#include <time.h>

#define DARROW 5 //Size of arrow step
#define DCUR 10 //Size of crosshair radius
#define BUTTONWAIT 0.4 /*Number of seconds to wait between sending buttons
	press messages; this is to prevent unwanted repeated click messages*/

void Cursor::mouse(unsigned int a, unsigned int b, unsigned int c,
		unsigned int d)
{
	regs.r_ax = a;
	regs.r_bx = b;
	regs.r_cx = c;
	regs.r_dx = d;
	intr(0x33, &regs);
}

Cursor::Cursor(Display &d)
{
	display_pointer = &d;
	mouse(0,0,0,0);
	if (!regs.r_ax)
	{
		printf("\nNo mouse detected.  Use arrow keys instead.");
		printf("\nPress any key to continue.");
		getch();
		mouseflag = 0;
		key_cursorflag = 1;
		cursorx = display_pointer->readmaxx()/2;
		cursory = display_pointer->readmaxy()/2;
	}
	else
	{
		mouseflag = 1;
		key_cursorflag = 0;
	}
	xorvisible = FALSE;
	Showcursor();
}

int Cursor::Update(int keycode)
{
	int oldcursorx, oldcursory;
	static unsigned char buttons = 0;
	static clock_t start, now;

	oldcursorx = cursorx;
	oldcursory = cursory;
	if (!key_cursorflag)
	{
		mouse(3,0,0,0);//Get info
		buttons = regs.r_bx & 3;
		if (!strcmp(display_pointer->Name(), "Text"))
		{
			cursorx = regs.r_cx *
				((float)display_pointer->readmaxx()/ 640.0);
			cursory = regs.r_dx *
				((float)display_pointer->readmaxy()/ 200.0);
	/* This is because in text mode the mouse regards the screen as
	having virtual coords 640 by 200.  See p.84 of MS mouse manual.*/
		}
		else if (!strcmp(display_pointer->Name(), "BGI"))
		//In VGA or EGA graphics, the virtual coords match screen.
		{
				cursorx = regs.r_cx;
				cursory = regs.r_dx;
		}
		else if (!strcmp(display_pointer->Name(), "V13"))
		//In V13 graphics, coords are off by factor of two.
		{
				cursorx = regs.r_cx / 2;
				cursory = regs.r_dx;
		}
	}
	else switch(keycode)
	{
		case LEFT_ARROW:
			Displace(-DARROW, 0);
			return (CURSOR_MOVE);
		case RIGHT_ARROW:
			Displace(DARROW, 0);
			return (CURSOR_MOVE);
		case UP_ARROW:
			Displace(0, -DARROW);
			return (CURSOR_MOVE);
		case DOWN_ARROW:
			Displace(0, DARROW);
			return (CURSOR_MOVE);
		case 'm':
			if (!mouseflag)
				break;//If there is no mouse.
			Hidecursor();
			key_cursorflag ^= 1;
			Showcursor();
			break;
	}
	if (buttons)
	{
		now = clock();
//#define DONTWAIT
#ifndef DONTWAIT
		if ( (float)( clock() - start ) / CLK_TCK < BUTTONWAIT )
			return 0;
		else
#endif //DONTWAIT
			start = now;
		switch(buttons)
		{
			case 0:
				return 0;
			case 1:
				return LEFT_BUTTON;
			case 2:
				return RIGHT_BUTTON;
			case 3:
				return BOTH_BUTTONS;
		}
	}
	else if (cursorx != oldcursorx || cursory != oldcursory)
		return CURSOR_MOVE;
	else
		return 0;
	return 0; //To make compiler happy.
}

void Cursor::Displace(int dx, int dy)
{
	if (!dx && !dy)
		return;
	Hidecursor();
	cursorx += dx;
	cursory += dy;
	if (cursorx > display_pointer->readmaxx())
		cursorx = display_pointer->readmaxx();
	if (cursorx < display_pointer->readminx())
		cursorx = display_pointer->readminx();
	if (cursory > display_pointer->readmaxy())
		cursory = display_pointer->readmaxy();
	if (cursory < display_pointer->readminy())
		cursory = display_pointer->readminy();
	if (mouseflag)
		mouse(4, 0, cursorx, cursory); //mouse call to move cursor.
	Showcursor();
}


void Cursor::Moveto(int x, int y)
{
	if(cursorvisible)
	  Hidecursor();
	cursorx = x;
	cursory = y;
	if (cursorx > display_pointer->readmaxx())
		cursorx = display_pointer->readmaxx();
	if (cursorx < display_pointer->readminx()-100)
		cursorx = display_pointer->readminx();
	if (cursory > display_pointer->readmaxy())
		cursory = display_pointer->readmaxy();
	if (cursory < display_pointer->readminy())
		cursory = display_pointer->readminy();
	if (mouseflag)
		mouse(4, 0, cursorx, cursory); //mouse call to move cursor.
	Showcursor();
}

void Cursor::Showcursor()
{
	if (!key_cursorflag)
	{
		mouse(1,0,0,0);
		cursorvisible=1;
		return;
	}
	if (!strcmp(display_pointer->Name(),"Text"))
	{
		gettext(cursorx, cursory, cursorx, cursory, &undercursor);
		display_pointer->pixel(cursorx, cursory, 15);
		key_cursorflag = 1;
	}
	else if (!xorvisible)//BGI display
	{
		setcolor(YELLOW);
		setlinestyle(0,0,3);
		setwritemode(XOR_PUT);
		moveto(cursorx - DCUR, cursory);
		lineto(cursorx + DCUR, cursory);
		moveto(cursorx, cursory + DCUR);
		lineto(cursorx, cursory - DCUR);
		setlinestyle(0,0,1);
		xorvisible = TRUE;
	}
}

void Cursor::Hidecursor()
{
	if (!key_cursorflag)
	{
		mouse(2,0,0,0);
		cursorvisible=0;
		return;
	}
	if (!strcmp(display_pointer->Name(),"Text"))
		puttext(cursorx, cursory, cursorx, cursory, &undercursor);
	else if (xorvisible)
	{
		setcolor(YELLOW);
		setlinestyle(0,0,3);
		setwritemode(XOR_PUT);
		moveto(cursorx - DCUR, cursory);
		lineto(cursorx + DCUR, cursory);
		moveto(cursorx, cursory + DCUR);
		lineto(cursorx, cursory - DCUR);
		setlinestyle(0,0,1);
		xorvisible = FALSE;
	}
}

int Cursor::MouseMoved(void)
{
	int oldcursorx, oldcursory;
	static unsigned char buttons = 0;
	oldcursorx = cursorx;
	oldcursory = cursory;
	mouse(3,0,0,0);//Get info
	buttons = regs.r_bx & 3;
	cursorx = regs.r_cx;
	cursory = regs.r_dx;
	if ((oldcursorx!=cursorx) || (oldcursory!=cursory))
	  return 1;
	return 0;
}


