#ifndef CURSOR_HPP
#define CURSOR_HPP
#include <dos.h>
#include "display.hpp"
#include "types.h"

class Cursor
{

private:
	int cursorx, cursory;
	class Display *display_pointer;
	//Arrow cursor things.
	unsigned char key_cursorflag;
	unsigned int undercursor;
	unsigned char xorvisible;
	//Mouse cursor things
	unsigned char mouseflag;
	unsigned int cursorvisible;
	struct REGPACK regs;
	void mouse(unsigned int a, unsigned int b, unsigned int c,
		unsigned int d);
public:
	Cursor(){};
	Cursor(Display &d);
	int Update(int keycode);
	int Getx(){return cursorx;}
	int Gety(){return cursory;}
	void Showcursor();
	void Hidecursor();
	void Displace(int dx, int dy);
	void Moveto(int x, int y);
	int MouseMoved(void);
	unsigned int CursorVisible(void){return cursorvisible;}
};
#endif //CURSOR_HPP