//----------------------------DISPLAY.HPP-----------------
#ifndef DISP_HPP
#define DISP_HPP
#include "types.h" //For defines.
#include <graphics.h> //For the Borland Graphic BGI function calls.
#include <string.h> //For the strcpy function.
#include <conio.h> //For the kbhit function.
#include <dos.h> //For the intr function.
#include <iostream.h> //For the overloaded << operator.
#include <stdlib.h> //For the exit() function and the random function.

class Display
{
protected:
	char name[20];
	int minx, miny, maxx, maxy, midx, midy;
	unsigned char maxcolor;
public:
	Display(){}; //default constructor
	char* Name(){return name;}
	int readminx(){return minx;}
	int readminy(){return miny;}
	int readmaxx(){return maxx;}
	int readmaxy(){return maxy;}
	int readmidx(){return midx;}
	int readmidy(){return midy;}
	unsigned char readmaxcolor(){return maxcolor;}
	int randx(){return (minx + random(maxx-minx+1));}
	int randy(){return (miny + random(maxy-miny+1));}
	int randcolor(){return random(maxcolor + 1);}
	void framebox(){box(minx-1, miny-1, maxx+1, maxy+1, 15);}
	virtual void open(){};
	virtual void clear(){};
	virtual void pixel(int, int, unsigned char){};
	virtual unsigned char readpixel(int, int){return 0;}
	virtual void box(int left, int top, int right, int bottom, int color){};
	virtual void textmode(){};
	virtual void graphicsmode(){};
	virtual void close(){};
};

class BGIdisplay : public Display
{
private:
	int gdriver, gmode;
public:
	BGIdisplay():Display(){gdriver = DETECT;}; //default constructor
	void open();
	void clear();
	void pixel(int, int, unsigned char);
	unsigned char readpixel(int, int);
	void box(int,int,int,int,int);
	void textmode();
	void graphicsmode();
	void close();
};

class V13display : public Display
{
private:
	struct REGPACK regs;
	void setmode(int mode);
	unsigned char far *baseptr;
	unsigned int screencount;
public:
	V13display():Display(){}; //default constructor
	void open();
	void clear();
	void pixel(int, int, unsigned char);
	unsigned char readpixel(int, int);
	void box(int,int,int,int,int);
	void textmode();
	void graphicsmode();
	void close();
};

#endif //DISP_HPP

