#include "frame.hpp"

//-------------------frame.cpp
unsigned char Frame::RealToPixel(Real rx, Real ry, int &pixelx, int &pixely)
{
/* Assume that midx = (maxx - minx)/2, midy = (maxy - miny) / 2,
halfx = midx - minx, and halfy = midy - miny.  We also assume that the
the y axis of the Real world shown by the Frame runs from
-range to +range.  In order that the Real window have the same proportions
as the frame window, we should assume that the Real window's x axis runs
from -rangex to rangex, where
(1)rangex = range*(halfx/halfy).
Then we can map (rx,ry) to (pixelx, pixely) by
(2)pixelx = midx + (halfx)*(rx/rangex) and
(3)pixely = midy - (halfy)*(ry/range).
Combining the formulas (1) and (2) gives
(4)pixelx = midx + (halfy)*(rx/range)
If we assume that scale is midy/range, we can rewrite (3) and (4) as
(5) pixelx = midx + rx * scale
(6) pixely = midy - ry * scale.
*/
	Real tempx, tempy; //Use these to prevent integer overflow

	tempx = midx + ((rx-cx) * scale);
	tempy = midy - ((ry-cy) * scale);
	if (tempx < -32000.0 || 32000.0 < tempx || tempy < -32000.0 ||
		 32000.0 < tempy)  //Values too big for integers.
	{
		pixelx = pixely = 0; //Better than garbage values
		return FALSE;
	}
	pixelx = tempx;
	pixely = tempy;
	if ( pixelx < minx || pixelx > maxx ||
		pixely < miny || pixely > maxy )
		return FALSE; //FALSE means out of the frame's display window.
	return TRUE; //Pixel is withing the frame's display window.
}

void Frame::RealToBasePixel(Real rx, Real ry, int &pixelx, int &pixely)
{
/* Same, without the zoom */

	Real basescale = scale * zoomfactor;
	Real tempx, tempy;

	tempx = midx + ((rx-cx) * basescale);
	tempy = midy - ((ry-cy) * basescale);
	if (tempx < -32000.0 || 32000.0 < tempx || tempy < -32000.0 ||
		 32000.0 < tempy)  //Values too big for integers.
	{
		pixelx = pixely = 0; //Better than garbage values
		return;
	}
	pixelx = tempx;
	pixely = tempy;
}

void Frame::InstallDisplay(Display *dp)
{
	disp = dp;
	minx = dp->readminx();
	miny = dp->readminy();
	maxx = dp->readmaxx();
	maxy = dp->readmaxy();
	midx = (maxx + minx)/2;
	midy = (maxy + miny)/2;
	halfx = midx - minx;
	halfy = midy - miny;
	cx = 0.0;
	cy = 0.0;
	range = 2.0;
	zoomfactor = 1.0;
	scale = halfy / (zoomfactor * range);
}

void Frame::Set(int left, int top, int right, int bottom)
{
	minx = left;
	miny = top;
	maxx = right;
	maxy = bottom;
	midx = (maxx + minx)/2;
	midy = (maxy + miny)/2;
	halfx = midx - minx;
	halfy = midy - miny;
	cx = 0.0;
	cy = 0.0;
	range = 2.0;
	zoomfactor = 1.0;
	scale = halfy / (zoomfactor * range);
}



