// julgnarl by Mark Jahn and Rudy Rucker
// Written for CS 151
// 11-9-94
#include "julia.hpp"
#include "keycode.hpp"
#include "files.h"
#include "cursor.hpp"
#include "button.hpp"
#define NORM 50
#define STEP_MULT 1.5
#define FLOCK_MULT 1.5
#define ZOOM_MULT 0.9
#define PAN_STEP 0.25
#define XJUL 3
#define YJUL 3
#define JULCOUNT (XJUL*YJUL)

void main()
{
	BGIdisplay disp;
	JuliaArray jularray(JULCOUNT);
	unsigned char quitflag = FALSE;
	int key,keycode,cursorcode;

	clrscr();
  printf("\n\n\n         JULGNARL     (Version built for Seek Ye The Gnarl, 12/7/94.)");
  printf("\n\n\nQuadratic, Cubic, and *Quartic* Julia sets computed by the inverse");
  printf("\niteration method.  The quartics have never before been seen by human eye!");
  printf("\n\n\nJulgnarl was written with Rudy Rucker's OOP students in the Math & CS Dept.,");
  printf("\nat San Jose State University.  SJSU MATH&CS Rules!  Special thanks to Mark Jahn.");
  printf("\n\n\nThis executable and source are shareware which can be freely copied.");
  printf("\nAny commercial use must be approved by Rudy Rucker: rucker@jupiter.sjsu.edu.");
  printf("\nCopyright (C) Rudy Rucker 1994.");
  printf("\n\n\nPRESS ENTER TO BEGIN!");
  while (!kbhit())
	;
  getch();
	randomize(); //Seed the random number generator with the time.
	disp.open();
	Cursor cur(disp);
	jularray.InstallDisplay(&disp);
	ButtonBox Buttons(disp);
	jularray.Set_buttons(&Buttons);
	jularray.Set_cursor(&cur);
	jularray.Locate(XJUL, YJUL);
	jularray.Randomize(); //This calls jularray.Reset()
	//jularray.Reset();
	Buttons.Show();
	cur.Hidecursor();
	while (!quitflag)
	{
		key = readkey();
		switch(key)
		{
		  case ESC:
		  case 'q':
		  case 'Q':
			  quitflag = 1;
			  break;
		  case LEFT_ARROW:
			  jularray.Pan(-PAN_STEP, 0.0);
			  break;
		  case RIGHT_ARROW:
			  jularray.Pan(PAN_STEP, 0.0);
			  break;
		  case UP_ARROW:
			  jularray.Pan(0.0, PAN_STEP);
			  break;
		  case DOWN_ARROW:
			  jularray.Pan(0.0, -PAN_STEP);
			  break;
		  case INSERT:
			  jularray.Zoom(ZOOM_MULT);
			  break;
		  case DELETE:
			  jularray.Zoom(1.0/ZOOM_MULT);
			  break;
		  case 'h':
					cur.Hidecursor();
					disp.textmode();
					inform("julgnarl.hlp");
					disp.graphicsmode();
					jularray.Draw_boxes();
					Buttons.Show();
					cur.Showcursor();
					break;
			case 'l':
					cur.Hidecursor();
					disp.textmode();
					jularray.Load();
					disp.graphicsmode();
					jularray.Draw_boxes();
					Buttons.Show();
					cur.Showcursor();
					break;
        case 's':
					cur.Hidecursor();
					disp.textmode();
					jularray.Save();
					disp.graphicsmode();
					jularray.Draw_boxes();
					Buttons.Show();
					cur.Showcursor();
					break;
  	  	case 'z':
				  disp.clear();
				  jularray.Draw_boxes();
				  Buttons.Show();
				  break;
			case END:
				if(jularray.Get_oneflag())
				  jularray.Set_count(9);
				else
				  jularray.Set_count(1);
				break;
		}
		if(!quitflag)
		{
		  cursorcode=jularray.Update();
		  if (cursorcode>=0)
		  {
			 switch(cursorcode)
			 {
/* jularray owns a Real step variable that specifies how big
the Bump_? steps should be.  The arguments to these calls simply
specify which of the re and im fields of the Complex to bump, and
in which direction, so the arguments are normall -1.0, 0.0, or 1.0*/
				case DEC_CRE:
					jularray.Bump_c(-1.0, 0.0);
					break;
				case INC_CRE:
					jularray.Bump_c(1.0, 0.0);
					break;
				case DEC_CIM:
					jularray.Bump_c(0.0, -1.0);
					break;
				case INC_CIM:
					jularray.Bump_c(0.0, 1.0);
					break;
				case DEC_KRE:
					jularray.Bump_k(-1.0, 0.0);
					break;
				case INC_KRE:
					jularray.Bump_k(1.0, 0.0);
					break;
				case DEC_KIM:
					jularray.Bump_k(0.0, -1.0);
					break;
				case INC_KIM:
					jularray.Bump_k(0.0, 1.0);
					break;
				case DEC_QRE:
					jularray.Bump_q(-1.0, 0.0);
					break;
				case INC_QRE:
					jularray.Bump_q(1.0, 0.0);
					break;
				case DEC_QIM:
					jularray.Bump_q(0.0, -1.0);
					break;
				case INC_QIM:
					jularray.Bump_q(0.0, 1.0);
					break;
				case HELP:
					cur.Hidecursor();
					disp.textmode();
					inform("julgnarl.hlp");
					disp.graphicsmode();
					jularray.Draw_boxes();
					Buttons.Show();
					cur.Showcursor();
					break;
				case DEC_FLOCKCOUNT:
					jularray.Mult_flockcount(1.0/FLOCK_MULT);
					jularray.Reset();
					break;
				case INC_FLOCKCOUNT:
					jularray.Mult_flockcount(FLOCK_MULT);
					jularray.Reset();
					break;
				case INC_STEPSIZE:
					jularray.Mult_step(STEP_MULT);
					if(!jularray.Get_oneflag())
					  jularray.Normalize();
					jularray.Reset();
					break;
				case DEC_STEPSIZE:
					jularray.Mult_step(1.0/STEP_MULT);
					if(!jularray.Get_oneflag())
					  jularray.Normalize();
					jularray.Reset();
					break;
				case DEC_DEGREE:
					jularray.Set_degree(jularray.Get_degree()-1);
					break;
				case INC_DEGREE:
					jularray.Set_degree(jularray.Get_degree()+1);
					break;
				case RANDOM:
					jularray.Randomize();
					break;
				case QUIT:
					quitflag = 1;
					break;
				case ONE:
				case ALL:
					if(jularray.Get_oneflag())
					  jularray.Set_count(9);
					else
					  jularray.Set_count(1);
					break;
				case NORM:
					jularray.Use_focus();
					break;
				case LOAD:
					cur.Hidecursor();
					disp.textmode();
					jularray.Load();
					disp.graphicsmode();
					jularray.Draw_boxes();
					Buttons.Show();
					cur.Showcursor();
					break;
				case SAVE:
					cur.Hidecursor();
					disp.textmode();
					jularray.Save();
					disp.graphicsmode();
					jularray.Draw_boxes();
					Buttons.Show();
					cur.Showcursor();
					break;
			 }
		  }
		}
	}
	disp.close();
}
