(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Helv", 18, L0, center, nohscroll, bold;
	fontset = subtitle, "Helv", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Helv", 12, L0, center, nohscroll, bold;
	fontset = section, "Helv", 12, L0, bold, grayBox;
	fontset = subsection, "Helv", 12, L0, bold, blackBox;
	fontset = subsubsection, "Helv", 10, L0, bold, whiteBox;
	fontset = text, "Helv", 12, L0;
	fontset = smalltext, "Helv", 10, L0;
	fontset = input, "Courier", 12, L0, nowordwrap;
	fontset = output, "Courier", 12, L0, nowordwrap;
	fontset = message, "Courier", 10, L0, nowordwrap, R65280;
	fontset = print, "Courier", 10, L0, nowordwrap;
	fontset = info, "Courier", 10, L0, nowordwrap;
	fontset = postscript, "Courier", 10, L0, nowordwrap;
	fontset = name, "Helv", 10, L0, nohscroll, italic, B65280;
	fontset = header, "Helv", 18, L0, nohscroll, bold;
	fontset = footer, "Helv", 18, L0, center, nohscroll, bold;
	fontset = help, "Helv", 10, L0, nohscroll;
	fontset = clipboard, "Helv", 12, L0, nohscroll;
	fontset = completions, "Helv", 12, L0, nowordwrap, nohscroll;
	fontset = graphics, "Courier", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Helv", 12, L0, nowordwrap, nohscroll;
	fontset = special2, "Helv", 12, L0, center, nowordwrap, nohscroll;
	fontset = special3, "Helv", 12, L0, right, nowordwrap, nohscroll;
	fontset = special4, "Helv", 12, L0, nowordwrap, nohscroll;
	fontset = special5, "Helv", 12, L0, nowordwrap, nohscroll;
	fontset = leftheader, "Helv", 12, L0, nowordwrap, nohscroll;
	fontset = leftfooter, "Helv", 12, L0, nowordwrap, nohscroll;
	fontset = reserved1, "Courier", 10, L0, nowordwrap, nohscroll;]
:[font = title; inactive; nohscroll; center; ]
KAPPA TAU CURVES
:[font = subtitle; inactive; nohscroll; center; ]
by Rudy Rucker
Copyright (C) 1994
:[font = subsection; inactive; startGroup; ]
Mathematical Background
:[font = text; inactive; endGroup; ]
	One can associate a trihedron of unit vectors with each point of a 
space curve.  The tangent vector lies on the striaght  line that best 
matches the curve and can be thought of as determined by two 
"consecutive" points of the curve.  The normal vector points in the 
direction in which the tip of the tangent vector is moving,  If one 
takes three "consecutive" points of the curve one gets a plane, known as 
the osculating or "kissing" plane which best fits the curve at that 
point.  The tangent and the normal vectors lie in the osculating plane 
and the binormal vector is perpendicular to the osculating plane. 
	For each point of a space curve one can also define the quantities 
known as curvature and torsion.  The curve's curvature measures its 
tendency to bendaway from its tangent line, and the curve's torsion 
measures the tendency of the curve  to twist  out of the osculating 
plane.  A theorem of differential geometry states that  a space curve's 
shape  is uniquely characterized  by the functions kappa and tau which 
give the curves curvature and torsion as functions of the arclength 
along the curve. 
	In this notebook, I state and use an algorithm for "kappa tau 
curves," which are space curves defined in terms of functions for 
curvature and torsion.  The algorithm is based on a set of three 
formulas known as "Frenet's formlas for the moving trihedron of a space 
curve."  These formulas were published by the French mathematicians 
Serret and Frenet in 1852. 
	Suppose that s parametrizes the arclength along a space curve, and 
that kappa and tau are functions of s which give the curvature and the 
torsion of the curve.  Suppose also that T, N,and B are vector functions 
giving the tangent, normal, and binormal as functions of s.  Then the 
Frenet formulas are as follows: 
 
dT/ds =			kappa * N 
dN/ds = -kappa * T			+ tau * B 
dB/ds = 			-tau * N 
  
	You can get an intuitive feel for the truth of the Frenet formulas 
by trying to "fly" your hand around as if it were the moving trihedron 
of a space curve.  Make a fist with your right hand and then extend your 
index finger, middle finger, and thumb so that they are at right angles 
to each other.  These fingers play the role of tangent, normal, and 
binormal. 
	There seem to be three intrinsic ways your hand can rotate: around 
your thumb, your middle finger, or your index finger.  To cystallize 
what is meant, try grabbing these with your left hand and performing an 
"unscrewing" motion on each.  These produce motions that are also called 
yaw, pitch, and roll. 
	If your hand moves along an imaginary space curve so that your 
index is always pointing in the direction of motion and your middle 
finger is always pointing in the direction in which the index finger is 
turning, then there will not actually be any "pitch" or "middle finger 
unscrewing" motion.  The reason is that all the turning of the index 
finger or tangent vector is in the direction of the middle finger or 
normal.  This is all "thumb unscrewing" motion.  The only other motion 
allowed is motion which does not move the index finger: this is the 
"index finger unscrewing" motion. 
	The "thumb unscrewing" motion is summarized in the first of the 
Frenet formulae: the change of the tangent is in the direction of the 
normal with a magnitude corresponding to the curvature.  The "index 
finger unscrewing" motion appears in the third Frenet formula: the 
change of the binormal is in the reverse direction of the normal and 
with a magnitude corresponding to the torsion.  The second of the Frenet 
formulas captures the "back effects" of the first and third formulas: As 
the tangent turns towards the normal, the normal turns away from the 
tangent; and as the binormal turns away from the normal, the normal
turns towards the binormal.
	Our algorithm performs a simple "Euler-style" numerical integration
to compute the successive points and trihedra of a space curve given by
a kappa and a tau function.  The curve is displayed as a ribbon by 
letting rungs stick out along the normal vectors and by connecting these
rungs to make paved tiles. 
	
	
:[font = subsection; inactive; startGroup; Cclosed; ]
Usage and Limitations
:[font = text; inactive; endGroup; ]
First select and evaluate the cell containing the Algorithm.  Then 
create and evaluate a cell of this form: 
 
clear; 
top = <Integer constant.  This measures the number of steps the 
computation goes through.  Values larger than 200 are likely to cause 
Mathematica to run out of memory and crash by locking up and destroying 
the active notebook.>; 
kappa[s_] = <Real number expression in s.>; 
tau[s_] = <Real number expression in s.>; 
width = <Real number measuring the width of the ribbon.  Mathematica 
scales the curve to fit in a fixed box, so if you have a large curve 
length you may want a larger width, and conversely.>; 
ds = <Real number for the step size.  The total arclength will be top 
times ds.>; 
pribbonfrenet 
 
The most significant limitation is that when Mathematica runs out of 
memory it does not issue a warning, instead it crashes by locking up the 
machine and commonly destroying the active notebook.  Values of top over 
300 reliably crash a machine with 12 Meg of RAM.  It is good practice to 
save a backup copy of this notebook under a different name from the 
working copy. 
 
A second limitation is that we are using the crude "Euler style" method 
of numerical integration instead of a more accurate "Runge Kutte" style 
method.  This can in priciple be changed if there is sufficient need.

:[font = subsection; inactive; startGroup; ]
Algorithm to Display a Kappa-Tau Space Curve as a Ribbon
:[font = input; startGroup; startGroup; startGroup; nowordwrap; ]
clear:=Clear[ds,width,kappa,tau,top,point,tangent,normal,
	binormal,curve,ncurve,tiles];
normalize[vector_]:=(1/Sqrt[vector.vector])vector;
cross[u_,v_]:={u[[2]]v[[3]]-u[[3]]v[[2]],
	u[[3]]v[[1]]-u[[1]]v[[3]],
	u[[1]]v[[2]]-u[[2]]v[[1]]};
pribbonfrenet:=
(
	point = {0.,0.,0.};
	edgepoint = {0.,width,0.};
	tangent= If[kappa[0] != 0. || tau[0] != 0,
		normalize[{kappa[0],0.,tau[0]}],
		{1.,0.,0.}];
	normal={0.,1.,0.};
	binormal=cross[tangent,normal];
 	curve=List[point];
	edgecurve=List[edgepoint];
	tiles=List[];
	rungs=List[Line[{point,edgepoint}]]; 
	Do
	[
		newpoint=point+ds tangent;
		newtangent= normalize[tangent+
			kappa[n ds]normal ds];
		newnormal= normalize[normal+
			(tau[n ds]binormal-
			kappa[n ds]tangent)ds];
		newedgepoint=newpoint+width newnormal;
		AppendTo[curve,newpoint];
		AppendTo[edgecurve,newedgepoint];
		AppendTo[tiles,Polygon[{point,edgepoint,
			newedgepoint,newpoint}]];
		AppendTo[rungs,Line[{newpoint,newedgepoint}]];
		tangent=newtangent;
		normal=newnormal;
		binormal=cross[tangent,normal];
		point=newpoint;
		edgepoint=newedgepoint;
		,
		{n,1,top,1}
	];
	Show
	[
		Graphics3D[{Thickness[.006],Line[curve]}],
		Graphics3D[{Thickness[.003],RGBColor[1,0,0],
			Line[edgecurve]}],
		Graphics3D[{RGBColor[1,1,0],EdgeForm[],tiles}],
		Graphics3D[{GrayLevel[0.25],rungs}],
		BoxRatios->{1,1,1}
	]
)   
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell



;[o]
General::spell1: 
   Possible spelling error: new symbol name "clear"
     is similar to existing symbol "Clear".
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell



;[o]
General::spell1: 
   Possible spelling error: new symbol name "top"
     is similar to existing symbol "Top".
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell



;[o]
General::spell1: 
   Possible spelling error: new symbol name "point"
     is similar to existing symbol "Point".
:[font = message; inactive; formatted; output; endGroup; nowordwrap; ]
Can't Format Cell



;[o]
General::stop: 
   Further output of General::spell1
     will be suppressed during this calculation.
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell









;[o]
General::spell1: 
   Possible spelling error: new symbol name "point"
     is similar to existing symbol "Point".
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell









;[o]
General::spell1: 
   Possible spelling error: new symbol name "normal"
     is similar to existing symbol "Normal".
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell









;[o]
General::spell1: 
   Possible spelling error: new symbol name "ncurve"
     is similar to existing symbol "curve".
:[font = message; inactive; formatted; output; endGroup; nowordwrap; ]
Can't Format Cell









;[o]
General::stop: 
   Further output of General::spell1
     will be suppressed during this calculation.
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell














;[o]
General::spell1: 
   Possible spelling error: new symbol name "clear"
     is similar to existing symbol "Clear".
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell














;[o]
General::spell1: 
   Possible spelling error: new symbol name "top"
     is similar to existing symbol "Top".
:[font = message; inactive; formatted; output; nowordwrap; ]
Can't Format Cell














;[o]
General::spell1: 
   Possible spelling error: new symbol name "point"
     is similar to existing symbol "Point".
:[font = message; inactive; formatted; output; endGroup; endGroup; nowordwrap; ]
Can't Format Cell














;[o]
General::stop: 
   Further output of General::spell1
     will be suppressed during this calculation.
:[font = subsection; inactive; ]
Examples
:[font = subsubsection; inactive; startGroup; ]
Helix: Kappa constant, Tau constant.
:[font = input; startGroup; nowordwrap; ]
clear;top=60;kappa[s_]=1.;tau[s_]=1.;width=.3;ds=.1;
pribbonfrenet
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 278; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.08079 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0260524 1.10184 0.0275459 1.10184 [
[ 0 0 0 0 ]
[ 1 1.08079 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 1.08079 lineto
0 1.08079 lineto
closepath
clip
newpath
gsave
0.002 setlinewidth
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
0.42251 0.57709 moveto
0.11113 0.25957 lineto
stroke
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
0.42251 0.57709 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
grestore
gsave
0.55084 0.70685 moveto 0.54312 0.63143 lineto 0.51422 0.71588 lineto 0.726 0.83 0.929 setrgbcolor
fill
grestore
gsave
0.55084 0.70685 moveto 0.5587 0.62119 lineto 0.54312 0.63143 lineto 0.824 0.893 0.891 setrgbcolor
fill
grestore
gsave
0.58711 0.69511 moveto 0.5587 0.62119 lineto 0.55084 0.70685 lineto 0.732 0.818 0.918 setrgbcolor
fill
grestore
gsave
0.58711 0.69511 moveto 0.57379 0.60974 lineto 0.5587 0.62119 lineto 0.824 0.861 0.874 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55084 0.70685 moveto
0.5587 0.62119 lineto
stroke
grestore
gsave
0.62252 0.68069 moveto 0.57379 0.60974 lineto 0.58711 0.69511 lineto 0.735 0.806 0.908 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.55084 0.70685 moveto
0.58711 0.69511 lineto
stroke
grestore
gsave
0.51422 0.71588 moveto 0.52733 0.64045 lineto 0.47777 0.72225 lineto 0.717 0.84 0.94 setrgbcolor
fill
grestore
gsave
0.51422 0.71588 moveto 0.54312 0.63143 lineto 0.52733 0.64045 lineto 0.814 0.924 0.908 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.51422 0.71588 moveto
0.55084 0.70685 lineto
stroke
grestore
gsave
0.62252 0.68069 moveto 0.58812 0.59711 lineto 0.57379 0.60974 lineto 0.819 0.831 0.858 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57379 0.60974 moveto
0.58711 0.69511 lineto
stroke
grestore
gsave
0.65652 0.6636 moveto 0.58812 0.59711 lineto 0.62252 0.68069 lineto 0.737 0.793 0.898 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.58711 0.69511 moveto
0.62252 0.68069 lineto
stroke
grestore
gsave
0.47777 0.72225 moveto 0.51161 0.64825 lineto 0.44202 0.72599 lineto 0.705 0.848 0.951 setrgbcolor
fill
grestore
gsave
0.47777 0.72225 moveto 0.52733 0.64045 lineto 0.51161 0.64825 lineto 0.792 0.951 0.923 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.47777 0.72225 moveto
0.51422 0.71588 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47777 0.72225 moveto
0.47931 0.7197 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51422 0.71588 moveto
0.54231 0.63379 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54231 0.63379 moveto
0.54312 0.63143 lineto
stroke
grestore
gsave
0.65652 0.6636 moveto 0.60141 0.58335 lineto 0.58812 0.59711 lineto 0.811 0.802 0.843 setrgbcolor
fill
grestore
gsave
0.68859 0.6439 moveto 0.60141 0.58335 lineto 0.65652 0.6636 lineto 0.736 0.78 0.888 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62144 0.67808 moveto
0.62252 0.68069 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.62252 0.68069 moveto
0.65652 0.6636 lineto
stroke
grestore
gsave
0.44202 0.72599 moveto 0.49624 0.65485 lineto 0.4075 0.72717 lineto 0.69 0.854 0.961 setrgbcolor
fill
grestore
gsave
0.44202 0.72599 moveto 0.51161 0.64825 lineto 0.49624 0.65485 lineto 0.752 0.969 0.93 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52595 0.64273 moveto
0.52733 0.64045 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.44202 0.72599 moveto
0.47777 0.72225 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44202 0.72599 moveto
0.4442 0.72356 lineto
stroke
grestore
gsave
0.68859 0.6439 moveto 0.61342 0.56854 lineto 0.60141 0.58335 lineto 0.8 0.776 0.831 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60141 0.58335 moveto
0.60294 0.58558 lineto
stroke
grestore
gsave
0.71819 0.62169 moveto 0.61342 0.56854 lineto 0.68859 0.6439 lineto 0.734 0.768 0.88 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62144 0.67807 moveto
0.62144 0.67808 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65479 0.66109 moveto
0.65652 0.6636 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.65652 0.6636 moveto
0.68859 0.6439 lineto
stroke
grestore
gsave
0.4075 0.72717 moveto 0.48151 0.66031 lineto 0.37474 0.72589 lineto 0.671 0.858 0.971 setrgbcolor
fill
grestore
gsave
0.4075 0.72717 moveto 0.49624 0.65485 lineto 0.48151 0.66031 lineto 0.688 0.97 0.926 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52489 0.64447 moveto
0.52595 0.64273 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50968 0.65041 moveto
0.51161 0.64825 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.4075 0.72717 moveto
0.44202 0.72599 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4075 0.72717 moveto
0.4103 0.72489 lineto
stroke
grestore
gsave
0.71819 0.62169 moveto 0.62391 0.55277 lineto 0.61342 0.56854 lineto 0.788 0.752 0.82 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61342 0.56854 moveto
0.61709 0.57222 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58812 0.59711 moveto
0.62144 0.67807 lineto
stroke
grestore
gsave
0.7448 0.59709 moveto 0.62391 0.55277 lineto 0.71819 0.62169 lineto 0.73 0.756 0.873 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65478 0.66108 moveto
0.65479 0.66109 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68623 0.64154 moveto
0.68859 0.6439 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68859 0.6439 moveto
0.71819 0.62169 lineto
stroke
grestore
gsave
0.37474 0.72589 moveto 0.46769 0.66467 lineto 0.34428 0.72226 lineto 0.65 0.858 0.979 setrgbcolor
fill
grestore
gsave
0.37474 0.72589 moveto 0.48151 0.66031 lineto 0.46769 0.66467 lineto 0.6 0.949 0.906 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5082 0.65206 moveto
0.50968 0.65041 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49379 0.65685 moveto
0.49624 0.65485 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37474 0.72589 moveto
0.4075 0.72717 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37701 0.7245 moveto
0.37812 0.72381 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37474 0.72589 moveto
0.37701 0.7245 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47931 0.7197 moveto
0.52358 0.64664 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52358 0.64664 moveto
0.52489 0.64447 lineto
stroke
grestore
gsave
0.7448 0.59709 moveto 0.63267 0.53615 lineto 0.62391 0.55277 lineto 0.775 0.73 0.811 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62391 0.55277 moveto
0.62849 0.55612 lineto
stroke
grestore
gsave
0.76789 0.57027 moveto 0.63267 0.53615 lineto 0.7448 0.59709 lineto 0.726 0.744 0.866 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60294 0.58558 moveto
0.65478 0.66108 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61709 0.57222 moveto
0.68621 0.64152 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68621 0.64152 moveto
0.68623 0.64154 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71522 0.61951 moveto
0.71819 0.62169 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71819 0.62169 moveto
0.7448 0.59709 lineto
stroke
grestore
gsave
0.34428 0.72226 moveto 0.45505 0.66803 lineto 0.31668 0.71644 lineto 0.628 0.855 0.985 setrgbcolor
fill
grestore
gsave
0.34428 0.72226 moveto 0.46769 0.66467 lineto 0.45505 0.66803 lineto 0.492 0.904 0.87 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50635 0.65412 moveto
0.5082 0.65206 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49191 0.65838 moveto
0.49379 0.65685 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47857 0.66211 moveto
0.48151 0.66031 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.34428 0.72226 moveto
0.37474 0.72589 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34692 0.72103 moveto
0.34822 0.72043 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34428 0.72226 moveto
0.34692 0.72103 lineto
stroke
grestore
gsave
0.76789 0.57027 moveto 0.63949 0.51882 lineto 0.63267 0.53615 lineto 0.762 0.711 0.804 setrgbcolor
fill
grestore
gsave
0.78692 0.54146 moveto 0.63949 0.51882 lineto 0.76789 0.57027 lineto 0.72 0.733 0.861 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62849 0.55612 moveto
0.7152 0.6195 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7152 0.6195 moveto
0.71522 0.61951 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74124 0.59515 moveto
0.7448 0.59709 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7448 0.59709 moveto
0.76789 0.57027 lineto
stroke
grestore
gsave
0.78692 0.54146 moveto 0.64422 0.50093 lineto 0.63949 0.51882 lineto 0.748 0.693 0.799 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63267 0.53615 moveto
0.64102 0.54069 lineto
stroke
grestore
gsave
0.80143 0.51094 moveto 0.64422 0.50093 lineto 0.78692 0.54146 lineto 0.714 0.723 0.856 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64102 0.54069 moveto
0.74123 0.59514 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74123 0.59514 moveto
0.74124 0.59515 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.649 0.52263 moveto
0.76379 0.56863 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76379 0.56863 moveto
0.76789 0.57027 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63949 0.51882 moveto
0.649 0.52263 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.76789 0.57027 moveto
0.78692 0.54146 lineto
stroke
grestore
gsave
0.31668 0.71644 moveto 0.44384 0.67047 lineto 0.29247 0.70859 lineto 0.604 0.849 0.99 setrgbcolor
fill
grestore
gsave
0.31668 0.71644 moveto 0.45505 0.66803 lineto 0.44384 0.67047 lineto 0.372 0.839 0.824 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48956 0.66029 moveto
0.49191 0.65838 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47632 0.66349 moveto
0.47857 0.66211 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46431 0.66625 moveto
0.46769 0.66467 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.31668 0.71644 moveto
0.34428 0.72226 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31965 0.71539 moveto
0.32112 0.71488 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31668 0.71644 moveto
0.31965 0.71539 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4442 0.72356 moveto
0.50411 0.65663 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50411 0.65663 moveto
0.50635 0.65412 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5587 0.62119 moveto
0.57379 0.60974 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57379 0.60974 moveto
0.58812 0.59711 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54312 0.63143 moveto
0.5587 0.62119 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58812 0.59711 moveto
0.60141 0.58335 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52733 0.64045 moveto
0.54312 0.63143 lineto
stroke
grestore
gsave
0.80143 0.51094 moveto 0.64672 0.48266 lineto 0.64422 0.50093 lineto 0.734 0.677 0.795 setrgbcolor
fill
grestore
gsave
0.81095 0.47904 moveto 0.64672 0.48266 lineto 0.80143 0.51094 lineto 0.708 0.713 0.853 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65102 0.50287 moveto
0.78233 0.54016 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78233 0.54016 moveto
0.78692 0.54146 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64422 0.50093 moveto
0.65102 0.50287 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.78692 0.54146 moveto
0.80143 0.51094 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65087 0.48341 moveto
0.80143 0.51094 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60141 0.58335 moveto
0.61342 0.56854 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51161 0.64825 moveto
0.52733 0.64045 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61342 0.56854 moveto
0.62391 0.55277 lineto
stroke
grestore
gsave
0.29247 0.70859 moveto 0.4343 0.67211 lineto 0.27221 0.69895 lineto 0.58 0.839 0.994 setrgbcolor
fill
grestore
gsave
0.29247 0.70859 moveto 0.44384 0.67047 lineto 0.4343 0.67211 lineto 0.255 0.765 0.776 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4103 0.72489 moveto
0.48671 0.66262 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48671 0.66262 moveto
0.48956 0.66029 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37812 0.72381 moveto
0.47351 0.66522 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47351 0.66522 moveto
0.47632 0.66349 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34822 0.72043 moveto
0.46173 0.66746 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46173 0.66746 moveto
0.46431 0.66625 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45128 0.66935 moveto
0.45505 0.66803 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.29247 0.70859 moveto
0.31668 0.71644 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29575 0.70777 moveto
0.29736 0.70736 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29247 0.70859 moveto
0.29575 0.70777 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44351 0.67055 moveto
0.44384 0.67047 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49624 0.65485 moveto
0.51161 0.64825 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62391 0.55277 moveto
0.63267 0.53615 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63267 0.53615 moveto
0.63949 0.51882 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48151 0.66031 moveto
0.49624 0.65485 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63949 0.51882 moveto
0.64422 0.50093 lineto
stroke
grestore
gsave
0.81095 0.47904 moveto 0.64691 0.46418 lineto 0.64672 0.48266 lineto 0.72 0.662 0.792 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64672 0.48266 moveto
0.65087 0.48341 lineto
stroke
grestore
gsave
0.81508 0.44615 moveto 0.64691 0.46418 lineto 0.81095 0.47904 lineto 0.7 0.704 0.85 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.80143 0.51094 moveto
0.81095 0.47904 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46769 0.66467 moveto
0.48151 0.66031 lineto
stroke
grestore
gsave
0.3532 0.18153 moveto 0.44014 0.28769 lineto 0.45334 0.28828 lineto 0.408 0.613 0.933 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64422 0.50093 moveto
0.64672 0.48266 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45505 0.66803 moveto
0.46769 0.66467 lineto
stroke
grestore
gsave
0.27221 0.69895 moveto 0.42665 0.67309 lineto 0.25643 0.68778 lineto 0.557 0.828 0.996 setrgbcolor
fill
grestore
gsave
0.27221 0.69895 moveto 0.4343 0.67211 lineto 0.42665 0.67309 lineto 0.15 0.692 0.735 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32112 0.71488 moveto
0.4484 0.67035 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4484 0.67035 moveto
0.45128 0.66935 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29736 0.70736 moveto
0.43975 0.6715 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43975 0.6715 moveto
0.44351 0.67055 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.27221 0.69895 moveto
0.29247 0.70859 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27221 0.69895 moveto
0.27749 0.69808 lineto
stroke
grestore
gsave
0.38928 0.17355 moveto 0.45334 0.28828 lineto 0.46806 0.29016 lineto 0.435 0.601 0.915 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43798 0.28504 moveto
0.44014 0.28769 lineto
stroke
grestore
gsave
0.3532 0.18153 moveto 0.45334 0.28828 lineto 0.38928 0.17355 lineto 0.589 0.688 0.91 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44014 0.28769 moveto
0.45334 0.28828 lineto
stroke
grestore
gsave
0.81508 0.44615 moveto 0.64474 0.4457 lineto 0.64691 0.46418 lineto 0.706 0.649 0.791 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64672 0.48266 moveto
0.64691 0.46418 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64691 0.46418 moveto
0.81095 0.47904 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44384 0.67047 moveto
0.45505 0.66803 lineto
stroke
grestore
gsave
0.81353 0.41275 moveto 0.64474 0.4457 lineto 0.81508 0.44615 lineto 0.693 0.696 0.849 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.81095 0.47904 moveto
0.81508 0.44615 lineto
stroke
grestore
gsave
0.42892 0.16927 moveto 0.46806 0.29016 lineto 0.484 0.29347 lineto 0.462 0.593 0.897 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45175 0.28543 moveto
0.45334 0.28828 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43631 0.28301 moveto
0.43798 0.28504 lineto
stroke
grestore
gsave
0.38928 0.17355 moveto 0.46806 0.29016 lineto 0.42892 0.16927 lineto 0.594 0.681 0.902 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45334 0.28828 moveto
0.46806 0.29016 lineto
stroke
grestore
gsave
0.81353 0.41275 moveto 0.6402 0.42743 lineto 0.64474 0.4457 lineto 0.691 0.637 0.791 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64474 0.4457 moveto
0.64691 0.46418 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64474 0.4457 moveto
0.81508 0.44615 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4343 0.67211 moveto
0.44384 0.67047 lineto
stroke
grestore
gsave
0.80607 0.37934 moveto 0.6402 0.42743 lineto 0.81353 0.41275 lineto 0.685 0.689 0.848 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.81353 0.41275 moveto
0.81508 0.44615 lineto
stroke
grestore
gsave
0.80607 0.37934 moveto 0.63335 0.40958 lineto 0.6402 0.42743 lineto 0.676 0.627 0.792 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6402 0.42743 moveto
0.64474 0.4457 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6402 0.42743 moveto
0.81353 0.41275 lineto
stroke
grestore
gsave
0.47116 0.16906 moveto 0.484 0.29347 lineto 0.50085 0.29831 lineto 0.488 0.588 0.88 setrgbcolor
fill
grestore
gsave
0.42892 0.16927 moveto 0.484 0.29347 lineto 0.47116 0.16906 lineto 0.599 0.675 0.894 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46806 0.29016 moveto
0.484 0.29347 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42892 0.16927 moveto
0.43029 0.17351 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43029 0.17351 moveto
0.46806 0.29016 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38928 0.17355 moveto
0.45175 0.28543 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3532 0.18153 moveto
0.43631 0.28301 lineto
stroke
grestore
gsave
0.79264 0.34649 moveto 0.63335 0.40958 lineto 0.80607 0.37934 lineto 0.677 0.683 0.848 setrgbcolor
fill
grestore
gsave
0.79264 0.34649 moveto 0.6243 0.39236 lineto 0.63335 0.40958 lineto 0.661 0.617 0.794 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63335 0.40958 moveto
0.6402 0.42743 lineto
stroke
grestore
gsave
0.25643 0.68778 moveto 0.42109 0.67354 lineto 0.24564 0.67537 lineto 0.537 0.815 0.997 setrgbcolor
fill
grestore
gsave
0.25643 0.68778 moveto 0.42665 0.67309 lineto 0.42109 0.67354 lineto 0.065 0.628 0.709 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27749 0.69808 moveto
0.42995 0.67283 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42995 0.67283 moveto
0.4343 0.67211 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.25643 0.68778 moveto
0.27221 0.69895 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26199 0.6873 moveto
0.42665 0.67309 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25643 0.68778 moveto
0.26199 0.6873 lineto
stroke
grestore
gsave
0.51498 0.17317 moveto 0.50085 0.29831 lineto 0.51824 0.30475 lineto 0.512 0.584 0.864 setrgbcolor
fill
grestore
gsave
0.47116 0.16906 moveto 0.50085 0.29831 lineto 0.51498 0.17317 lineto 0.605 0.671 0.886 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.484 0.29347 moveto
0.50085 0.29831 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47116 0.16906 moveto
0.484 0.29347 lineto
stroke
grestore
gsave
0.77329 0.31481 moveto 0.6243 0.39236 lineto 0.79264 0.34649 lineto 0.669 0.677 0.849 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80029 0.38035 moveto
0.80607 0.37934 lineto
stroke
grestore
gsave
0.77329 0.31481 moveto 0.6132 0.37599 lineto 0.6243 0.39236 lineto 0.645 0.609 0.798 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63335 0.40958 moveto
0.80029 0.38035 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6243 0.39236 moveto
0.63335 0.40958 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6243 0.39236 moveto
0.62862 0.39119 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.80607 0.37934 moveto
0.81353 0.41275 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42665 0.67309 moveto
0.4343 0.67211 lineto
stroke
grestore
gsave
0.55922 0.1817 moveto 0.51824 0.30475 lineto 0.5358 0.31282 lineto 0.535 0.583 0.85 setrgbcolor
fill
grestore
gsave
0.51498 0.17317 moveto 0.51824 0.30475 lineto 0.55922 0.1817 lineto 0.612 0.668 0.879 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50085 0.29831 moveto
0.51824 0.30475 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50085 0.29831 moveto
0.51498 0.17317 lineto
stroke
grestore
gsave
0.74828 0.2849 moveto 0.6132 0.37599 lineto 0.77329 0.31481 lineto 0.66 0.673 0.851 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78695 0.34804 moveto
0.79264 0.34649 lineto
stroke
grestore
gsave
0.74828 0.2849 moveto 0.60025 0.36066 lineto 0.6132 0.37599 lineto 0.629 0.601 0.803 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6132 0.37599 moveto
0.6243 0.39236 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6132 0.37599 moveto
0.61727 0.37444 lineto
stroke
grestore
gsave
0.60273 0.19463 moveto 0.5358 0.31282 lineto 0.55315 0.32252 lineto 0.556 0.584 0.837 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51824 0.30475 moveto
0.51925 0.30171 lineto
stroke
grestore
gsave
0.55922 0.1817 moveto 0.5358 0.31282 lineto 0.60273 0.19463 lineto 0.62 0.666 0.873 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51824 0.30475 moveto
0.5358 0.31282 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5358 0.31282 moveto
0.54229 0.30136 lineto
stroke
grestore
gsave
0.71802 0.25739 moveto 0.60025 0.36066 lineto 0.74828 0.2849 lineto 0.652 0.669 0.854 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76784 0.31689 moveto
0.77329 0.31481 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78692 0.34805 moveto
0.78695 0.34804 lineto
stroke
grestore
gsave
0.71802 0.25739 moveto 0.58572 0.34654 lineto 0.60025 0.36066 lineto 0.612 0.595 0.809 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62862 0.39119 moveto
0.78692 0.34805 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60025 0.36066 moveto
0.6132 0.37599 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60025 0.36066 moveto
0.60687 0.35727 lineto
stroke
grestore
gsave
0.64439 0.21178 moveto 0.55315 0.32252 lineto 0.56991 0.33379 lineto 0.576 0.586 0.826 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51925 0.30171 moveto
0.52003 0.29937 lineto
stroke
grestore
gsave
0.60273 0.19463 moveto 0.55315 0.32252 lineto 0.64439 0.21178 lineto 0.627 0.665 0.867 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52003 0.29937 moveto
0.55922 0.1817 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5358 0.31282 moveto
0.55315 0.32252 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74485 0.28666 moveto
0.74828 0.2849 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55315 0.32252 moveto
0.56203 0.31174 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60039 0.19877 moveto
0.60273 0.19463 lineto
stroke
grestore
gsave
0.68313 0.23284 moveto 0.58572 0.34654 lineto 0.71802 0.25739 lineto 0.644 0.667 0.857 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71494 0.25947 moveto
0.71802 0.25739 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71343 0.26049 moveto
0.71494 0.25947 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7432 0.2875 moveto
0.74485 0.28666 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76781 0.3169 moveto
0.76784 0.31689 lineto
stroke
grestore
gsave
0.68313 0.23284 moveto 0.56991 0.33379 lineto 0.58572 0.34654 lineto 0.594 0.59 0.817 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58572 0.34654 moveto
0.60025 0.36066 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58572 0.34654 moveto
0.5948 0.34042 lineto
stroke
grestore
gsave
0.64439 0.21178 moveto 0.56991 0.33379 lineto 0.68313 0.23284 lineto 0.635 0.665 0.862 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56991 0.33379 moveto
0.57764 0.3269 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67918 0.23637 moveto
0.68313 0.23284 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57764 0.3269 moveto
0.67918 0.23637 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.56991 0.33379 moveto
0.58572 0.34654 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55315 0.32252 moveto
0.56991 0.33379 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5948 0.34042 moveto
0.71343 0.26049 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56203 0.31174 moveto
0.6412 0.21565 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60687 0.35727 moveto
0.74317 0.28752 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74317 0.28752 moveto
0.7432 0.2875 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54229 0.30136 moveto
0.60039 0.19877 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61727 0.37444 moveto
0.76781 0.3169 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6412 0.21565 moveto
0.64439 0.21178 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.79264 0.34649 moveto
0.80607 0.37934 lineto
stroke
grestore
gsave
0.24564 0.67537 moveto 0.42109 0.67354 lineto 0.41779 0.67362 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.24564 0.67537 moveto 0.41779 0.67362 lineto 0.24029 0.66208 lineto 0.52 0.801 0.997 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41716 0.67358 moveto
0.42109 0.67354 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.24564 0.67537 moveto
0.25643 0.68778 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42109 0.67354 moveto
0.42665 0.67309 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.77329 0.31481 moveto
0.79264 0.34649 lineto
stroke
grestore
gsave
0.24029 0.66208 moveto 0.41779 0.67362 lineto 0.41686 0.6735 lineto 0 0.544 0.712 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41779 0.67362 moveto
0.42109 0.67354 lineto
stroke
grestore
gsave
0.24029 0.66208 moveto 0.41686 0.6735 lineto 0.2408 0.64831 lineto 0.508 0.786 0.995 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.24029 0.66208 moveto
0.24564 0.67537 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24029 0.66208 moveto
0.41779 0.67362 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.3532 0.18153 moveto
0.38928 0.17355 lineto
stroke
grestore
gsave
0.2408 0.64831 moveto 0.41686 0.6735 lineto 0.4184 0.67338 lineto 0 0.526 0.741 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41686 0.6735 moveto
0.41779 0.67362 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.74828 0.2849 moveto
0.77329 0.31481 lineto
stroke
grestore
gsave
0.24748 0.63452 moveto 0.4184 0.67338 lineto 0.42244 0.67342 lineto 0 0.52 0.783 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4123 0.67285 moveto
0.41686 0.6735 lineto
stroke
grestore
gsave
0.2408 0.64831 moveto 0.4184 0.67338 lineto 0.24748 0.63452 lineto 0.499 0.772 0.993 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2408 0.64831 moveto
0.4123 0.67285 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41686 0.6735 moveto
0.4184 0.67338 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.24029 0.66208 moveto
0.2408 0.64831 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.38928 0.17355 moveto
0.42892 0.16927 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71802 0.25739 moveto
0.74828 0.2849 lineto
stroke
grestore
gsave
0.2605 0.62118 moveto 0.42244 0.67342 lineto 0.42899 0.67383 lineto 0 0.525 0.831 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41401 0.67238 moveto
0.4184 0.67338 lineto
stroke
grestore
gsave
0.24748 0.63452 moveto 0.42244 0.67342 lineto 0.2605 0.62118 lineto 0.495 0.757 0.989 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4184 0.67338 moveto
0.42244 0.67342 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2408 0.64831 moveto
0.24748 0.63452 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24748 0.63452 moveto
0.25326 0.63583 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42892 0.16927 moveto
0.47116 0.16906 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68313 0.23284 moveto
0.71802 0.25739 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.64439 0.21178 moveto
0.68313 0.23284 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47116 0.16906 moveto
0.51498 0.17317 lineto
stroke
grestore
gsave
0.27993 0.60882 moveto 0.42899 0.67383 lineto 0.43797 0.67479 lineto 0.033 0.534 0.876 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41832 0.67209 moveto
0.42244 0.67342 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41064 0.67161 moveto
0.41401 0.67238 lineto
stroke
grestore
gsave
0.2605 0.62118 moveto 0.42899 0.67383 lineto 0.27993 0.60882 lineto 0.494 0.744 0.984 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25326 0.63583 moveto
0.41064 0.67161 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42244 0.67342 moveto
0.42899 0.67383 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2605 0.62118 moveto
0.26603 0.62296 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60273 0.19463 moveto
0.64439 0.21178 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51498 0.17317 moveto
0.55922 0.1817 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55922 0.1817 moveto
0.60273 0.19463 lineto
stroke
grestore
gsave
0.30564 0.59798 moveto 0.43797 0.67479 lineto 0.44927 0.67649 lineto 0.097 0.545 0.91 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42523 0.67219 moveto
0.42899 0.67383 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41516 0.67107 moveto
0.41832 0.67209 lineto
stroke
grestore
gsave
0.27993 0.60882 moveto 0.43797 0.67479 lineto 0.30564 0.59798 lineto 0.497 0.732 0.977 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42899 0.67383 moveto
0.43797 0.67479 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27993 0.60882 moveto
0.28509 0.61107 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.24748 0.63452 moveto
0.2605 0.62118 lineto
stroke
grestore
gsave
0.33729 0.5892 moveto 0.44927 0.67649 lineto 0.46269 0.6791 lineto 0.166 0.554 0.93 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43466 0.67287 moveto
0.43797 0.67479 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42234 0.67093 moveto
0.42523 0.67219 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41119 0.66979 moveto
0.41516 0.67107 lineto
stroke
grestore
gsave
0.30564 0.59798 moveto 0.44927 0.67649 lineto 0.33729 0.5892 lineto 0.503 0.721 0.97 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43797 0.67479 moveto
0.44927 0.67649 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30564 0.59798 moveto
0.30873 0.59978 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30873 0.59978 moveto
0.31025 0.60066 lineto
stroke
grestore
gsave
0.37436 0.58298 moveto 0.46269 0.6791 lineto 0.478 0.68277 lineto 0.234 0.56 0.935 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44648 0.67432 moveto
0.44927 0.67649 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43211 0.67139 moveto
0.43466 0.67287 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41872 0.66935 moveto
0.42234 0.67093 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40634 0.66823 moveto
0.41119 0.66979 lineto
stroke
grestore
gsave
0.33729 0.5892 moveto 0.46269 0.6791 lineto 0.37436 0.58298 lineto 0.511 0.711 0.962 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26603 0.62296 moveto
0.40634 0.66823 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44927 0.67649 moveto
0.46269 0.6791 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33729 0.5892 moveto
0.33993 0.59125 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33993 0.59125 moveto
0.34122 0.59226 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2605 0.62118 moveto
0.27993 0.60882 lineto
stroke
grestore
gsave
0.87487 0.83673 moveto 0.68675 0.86451 lineto 0.87381 0.86792 lineto 0.684 0.728 0.883 setrgbcolor
fill
grestore
gsave
0.41611 0.5798 moveto 0.478 0.68277 lineto 0.49492 0.68764 lineto 0.298 0.563 0.93 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4605 0.67672 moveto
0.46269 0.6791 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44434 0.67265 moveto
0.44648 0.67432 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42892 0.66954 moveto
0.43211 0.67139 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41428 0.66741 moveto
0.41872 0.66935 lineto
stroke
grestore
gsave
0.37436 0.58298 moveto 0.478 0.68277 lineto 0.41611 0.5798 lineto 0.521 0.703 0.953 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28509 0.61107 moveto
0.41428 0.66741 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46269 0.6791 moveto
0.478 0.68277 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37436 0.58298 moveto
0.37646 0.58526 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37646 0.58526 moveto
0.37748 0.58637 lineto
stroke
grestore
gsave
0.87487 0.83673 moveto 0.68268 0.84584 lineto 0.68675 0.86451 lineto 0.692 0.653 0.807 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68675 0.86451 moveto
0.87381 0.86792 lineto
stroke
grestore
gsave
0.46158 0.58004 moveto 0.49492 0.68764 lineto 0.51309 0.69381 lineto 0.354 0.566 0.918 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47648 0.68023 moveto
0.478 0.68277 lineto
stroke
grestore
gsave
0.41611 0.5798 moveto 0.49492 0.68764 lineto 0.46158 0.58004 lineto 0.532 0.696 0.944 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.478 0.68277 moveto
0.49492 0.68764 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41611 0.5798 moveto
0.41758 0.58225 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41758 0.58225 moveto
0.4183 0.58344 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37748 0.58637 moveto
0.4605 0.67672 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34122 0.59226 moveto
0.44434 0.67265 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31025 0.60066 moveto
0.42892 0.66954 lineto
stroke
grestore
gsave
0.86943 0.80523 moveto 0.68268 0.84584 lineto 0.87487 0.83673 lineto 0.675 0.718 0.882 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.87381 0.86792 moveto
0.87487 0.83673 lineto
stroke
grestore
gsave
0.86943 0.80523 moveto 0.676 0.82744 lineto 0.68268 0.84584 lineto 0.674 0.639 0.808 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68268 0.84584 moveto
0.68675 0.86451 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68268 0.84584 moveto
0.87487 0.83673 lineto
stroke
grestore
gsave
0.50967 0.58399 moveto 0.51309 0.69381 lineto 0.53214 0.70137 lineto 0.403 0.568 0.903 setrgbcolor
fill
grestore
gsave
0.46158 0.58004 moveto 0.51309 0.69381 lineto 0.50967 0.58399 lineto 0.544 0.69 0.934 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49492 0.68764 moveto
0.51309 0.69381 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46158 0.58004 moveto
0.46277 0.58386 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46277 0.58386 moveto
0.49492 0.68764 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4183 0.58344 moveto
0.47648 0.68023 lineto
stroke
grestore
gsave
0.85729 0.7739 moveto 0.676 0.82744 lineto 0.86943 0.80523 lineto 0.664 0.71 0.882 setrgbcolor
fill
grestore
gsave
0.85729 0.7739 moveto 0.66681 0.80949 lineto 0.676 0.82744 lineto 0.655 0.627 0.81 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.676 0.82744 moveto
0.68268 0.84584 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.86943 0.80523 moveto
0.87487 0.83673 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.27993 0.60882 moveto
0.30564 0.59798 lineto
stroke
grestore
gsave
0.83843 0.74325 moveto 0.66681 0.80949 lineto 0.85729 0.7739 lineto 0.654 0.702 0.882 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86295 0.80597 moveto
0.86943 0.80523 lineto
stroke
grestore
gsave
0.83843 0.74325 moveto 0.65525 0.79218 lineto 0.66681 0.80949 lineto 0.636 0.616 0.814 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.676 0.82744 moveto
0.86295 0.80597 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66681 0.80949 moveto
0.676 0.82744 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66681 0.80949 moveto
0.6717 0.80858 lineto
stroke
grestore
gsave
0.55912 0.59184 moveto 0.53214 0.70137 lineto 0.55165 0.71035 lineto 0.445 0.571 0.887 setrgbcolor
fill
grestore
gsave
0.50967 0.58399 moveto 0.53214 0.70137 lineto 0.55912 0.59184 lineto 0.557 0.686 0.926 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51309 0.69381 moveto
0.53214 0.70137 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50967 0.58399 moveto
0.51309 0.69381 lineto
stroke
grestore
gsave
0.81303 0.71383 moveto 0.65525 0.79218 lineto 0.83843 0.74325 lineto 0.643 0.696 0.884 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.85085 0.7751 moveto
0.85729 0.7739 lineto
stroke
grestore
gsave
0.81303 0.71383 moveto 0.64154 0.77567 lineto 0.65525 0.79218 lineto 0.615 0.607 0.819 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65525 0.79218 moveto
0.66681 0.80949 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65525 0.79218 moveto
0.65991 0.79093 lineto
stroke
grestore
gsave
0.60861 0.6036 moveto 0.55165 0.71035 lineto 0.57122 0.72076 lineto 0.482 0.574 0.871 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53214 0.70137 moveto
0.5328 0.69868 lineto
stroke
grestore
gsave
0.55912 0.59184 moveto 0.55165 0.71035 lineto 0.60861 0.6036 lineto 0.57 0.684 0.917 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5328 0.69868 moveto
0.55912 0.59184 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.53214 0.70137 moveto
0.55165 0.71035 lineto
stroke
grestore
gsave
0.78147 0.6862 moveto 0.64154 0.77567 lineto 0.81303 0.71383 lineto 0.631 0.691 0.887 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83218 0.74492 moveto
0.83843 0.74325 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.85082 0.77511 moveto
0.85085 0.7751 lineto
stroke
grestore
gsave
0.78147 0.6862 moveto 0.62593 0.76014 lineto 0.64154 0.77567 lineto 0.593 0.598 0.826 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6717 0.80858 moveto
0.85082 0.77511 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64154 0.77567 moveto
0.65525 0.79218 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64154 0.77567 moveto
0.64919 0.77291 lineto
stroke
grestore
gsave
0.65682 0.61921 moveto 0.57122 0.72076 lineto 0.59039 0.73258 lineto 0.515 0.579 0.857 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55165 0.71035 moveto
0.55305 0.70773 lineto
stroke
grestore
gsave
0.60861 0.6036 moveto 0.57122 0.72076 lineto 0.65682 0.61921 lineto 0.582 0.682 0.909 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55165 0.71035 moveto
0.57122 0.72076 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57122 0.72076 moveto
0.57948 0.71096 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6066 0.60738 moveto
0.60861 0.6036 lineto
stroke
grestore
gsave
0.74433 0.66089 moveto 0.62593 0.76014 lineto 0.78147 0.6862 lineto 0.619 0.687 0.891 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77783 0.68793 moveto
0.78147 0.6862 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80713 0.71596 moveto
0.81303 0.71383 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83215 0.74493 moveto
0.83218 0.74492 lineto
stroke
grestore
gsave
0.74433 0.66089 moveto 0.60877 0.74574 lineto 0.62593 0.76014 lineto 0.57 0.591 0.835 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62593 0.76014 moveto
0.64154 0.77567 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62593 0.76014 moveto
0.63282 0.75687 lineto
stroke
grestore
gsave
0.70245 0.63841 moveto 0.59039 0.73258 lineto 0.60877 0.74574 lineto 0.544 0.584 0.845 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55305 0.70773 moveto
0.55413 0.70571 lineto
stroke
grestore
gsave
0.65682 0.61921 moveto 0.59039 0.73258 lineto 0.70245 0.63841 lineto 0.595 0.683 0.903 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55413 0.70571 moveto
0.6066 0.60738 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57122 0.72076 moveto
0.59039 0.73258 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77605 0.68877 moveto
0.77783 0.68793 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59039 0.73258 moveto
0.59797 0.72621 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6538 0.62279 moveto
0.65682 0.61921 lineto
stroke
grestore
gsave
0.70245 0.63841 moveto 0.60877 0.74574 lineto 0.74433 0.66089 lineto 0.607 0.684 0.896 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60877 0.74574 moveto
0.61798 0.73997 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73958 0.66387 moveto
0.74433 0.66089 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61798 0.73997 moveto
0.73958 0.66387 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59039 0.73258 moveto
0.60877 0.74574 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6985 0.64174 moveto
0.70245 0.63841 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59797 0.72621 moveto
0.6985 0.64174 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63282 0.75687 moveto
0.77605 0.68877 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57948 0.71096 moveto
0.6538 0.62279 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64919 0.77291 moveto
0.8071 0.71597 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8071 0.71597 moveto
0.80713 0.71596 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65991 0.79093 moveto
0.83215 0.74493 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60877 0.74574 moveto
0.62593 0.76014 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.85729 0.7739 moveto
0.86943 0.80523 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.30564 0.59798 moveto
0.33729 0.5892 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.83843 0.74325 moveto
0.85729 0.7739 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33729 0.5892 moveto
0.37436 0.58298 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81303 0.71383 moveto
0.83843 0.74325 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37436 0.58298 moveto
0.41611 0.5798 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.78147 0.6862 moveto
0.81303 0.71383 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.41611 0.5798 moveto
0.46158 0.58004 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.74433 0.66089 moveto
0.78147 0.6862 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46158 0.58004 moveto
0.50967 0.58399 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70245 0.63841 moveto
0.74433 0.66089 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.50967 0.58399 moveto
0.55912 0.59184 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.65682 0.61921 moveto
0.70245 0.63841 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55912 0.59184 moveto
0.60861 0.6036 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60861 0.6036 moveto
0.65682 0.61921 lineto
stroke
grestore
gsave
0.002 setlinewidth
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
grestore
gsave
grestore
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; endGroup; nowordwrap; ]
No Input Form was saved for this expression.


















;[o]
-Graphics3D-
:[font = subsubsection; inactive; startGroup; ]
Baseball Stitch: Kappa constant, Tau periodic.
:[font = text; inactive; ]
You get a perfect baseball stitch if tau is Sin and kappa is 1.
:[font = input; startGroup; nowordwrap; ]
clear;top=125;kappa[s_]=1;tau[s_]:=Sin[s];width=.3;ds=.1;
pribbonfrenet
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 277; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.08079 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0260524 1.10184 0.0275459 1.10184 [
[ 0 0 0 0 ]
[ 1 1.08079 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 1.08079 lineto
0 1.08079 lineto
closepath
clip
newpath
gsave
0.002 setlinewidth
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
0.42251 0.57709 moveto
0.11113 0.25957 lineto
stroke
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
0.42251 0.57709 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
grestore
gsave
0.42999 0.61635 moveto 0.42594 0.60189 lineto 0.42053 0.59506 lineto 0 0 0.37 setrgbcolor
fill
grestore
gsave
0.42999 0.61635 moveto 0.42629 0.6202 lineto 0.42594 0.60189 lineto 0.835 0.672 0.13 setrgbcolor
fill
grestore
gsave
0.4391 0.63776 moveto 0.42629 0.6202 lineto 0.42999 0.61635 lineto 0.811 0.442 0 setrgbcolor
fill
grestore
gsave
0.42053 0.59506 moveto 0.42559 0.58352 lineto 0.41096 0.57394 lineto 0 0.02 0.593 setrgbcolor
fill
grestore
gsave
0.42053 0.59506 moveto 0.42594 0.60189 lineto 0.42559 0.58352 lineto 0 0 0.213 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.42053 0.59506 moveto
0.42605 0.60748 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42053 0.59506 moveto
0.42594 0.60189 lineto
stroke
grestore
gsave
0.4391 0.63776 moveto 0.42657 0.63842 lineto 0.42629 0.6202 lineto 0.984 0.792 0.389 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42629 0.6202 moveto
0.42999 0.61635 lineto
stroke
grestore
gsave
0.44759 0.65922 moveto 0.42657 0.63842 lineto 0.4391 0.63776 lineto 0.931 0.569 0.152 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.42999 0.61635 moveto
0.4391 0.63776 lineto
stroke
grestore
gsave
0.41096 0.57394 moveto 0.4253 0.56517 lineto 0.40157 0.55304 lineto 0.015 0.207 0.717 setrgbcolor
fill
grestore
gsave
0.41096 0.57394 moveto 0.42559 0.58352 lineto 0.4253 0.56517 lineto 0 0 0.466 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.41096 0.57394 moveto
0.42053 0.59506 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41096 0.57394 moveto
0.42559 0.58352 lineto
stroke
grestore
gsave
0.44759 0.65922 moveto 0.42671 0.65649 lineto 0.42657 0.63842 lineto 0.996 0.798 0.519 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42657 0.63842 moveto
0.4391 0.63776 lineto
stroke
grestore
gsave
0.45523 0.68066 moveto 0.42671 0.65649 lineto 0.44759 0.65922 lineto 0.959 0.621 0.308 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.4391 0.63776 moveto
0.44759 0.65922 lineto
stroke
grestore
gsave
0.40157 0.55304 moveto 0.42512 0.54689 lineto 0.39264 0.53241 lineto 0.195 0.332 0.776 setrgbcolor
fill
grestore
gsave
0.40157 0.55304 moveto 0.4253 0.56517 lineto 0.42512 0.54689 lineto 0.148 0.145 0.597 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40157 0.55304 moveto
0.41096 0.57394 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40157 0.55304 moveto
0.4253 0.56517 lineto
stroke
grestore
gsave
0.45523 0.68066 moveto 0.42664 0.67434 lineto 0.42671 0.65649 lineto 0.97 0.77 0.579 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42671 0.65649 moveto
0.44759 0.65922 lineto
stroke
grestore
gsave
0.4618 0.702 moveto 0.42664 0.67434 lineto 0.45523 0.68066 lineto 0.95 0.635 0.401 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.44759 0.65922 moveto
0.45523 0.68066 lineto
stroke
grestore
gsave
0.39264 0.53241 moveto 0.42512 0.52872 lineto 0.38443 0.51209 lineto 0.316 0.416 0.806 setrgbcolor
fill
grestore
gsave
0.39264 0.53241 moveto 0.42512 0.54689 lineto 0.42512 0.52872 lineto 0.305 0.28 0.665 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.39264 0.53241 moveto
0.40157 0.55304 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39264 0.53241 moveto
0.42512 0.54689 lineto
stroke
grestore
gsave
0.4618 0.702 moveto 0.42628 0.6919 lineto 0.42664 0.67434 lineto 0.938 0.737 0.605 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42664 0.67434 moveto
0.45523 0.68066 lineto
stroke
grestore
gsave
0.46711 0.72316 moveto 0.42628 0.6919 lineto 0.4618 0.702 lineto 0.931 0.634 0.457 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.45523 0.68066 moveto
0.4618 0.702 lineto
stroke
grestore
gsave
0.38443 0.51209 moveto 0.4254 0.51073 lineto 0.37724 0.49211 lineto 0.399 0.475 0.822 setrgbcolor
fill
grestore
gsave
0.38443 0.51209 moveto 0.42512 0.52872 lineto 0.4254 0.51073 lineto 0.407 0.369 0.704 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.38443 0.51209 moveto
0.39264 0.53241 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38443 0.51209 moveto
0.42512 0.52872 lineto
stroke
grestore
gsave
0.46711 0.72316 moveto 0.42551 0.70909 lineto 0.42628 0.6919 lineto 0.91 0.707 0.615 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42628 0.6919 moveto
0.4618 0.702 lineto
stroke
grestore
gsave
0.47098 0.74404 moveto 0.42551 0.70909 lineto 0.46711 0.72316 lineto 0.91 0.626 0.491 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.4618 0.702 moveto
0.46711 0.72316 lineto
stroke
grestore
gsave
0.37724 0.49211 moveto 0.42605 0.49299 lineto 0.37132 0.47253 lineto 0.46 0.519 0.832 setrgbcolor
fill
grestore
gsave
0.37724 0.49211 moveto 0.4254 0.51073 lineto 0.42605 0.49299 lineto 0.476 0.432 0.729 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.37724 0.49211 moveto
0.38443 0.51209 lineto
stroke
grestore
gsave
0.47098 0.74404 moveto 0.42424 0.72581 lineto 0.42551 0.70909 lineto 0.887 0.679 0.616 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42551 0.70909 moveto
0.46711 0.72316 lineto
stroke
grestore
gsave
0.47325 0.76452 moveto 0.42424 0.72581 lineto 0.47098 0.74404 lineto 0.892 0.615 0.511 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.46711 0.72316 moveto
0.47098 0.74404 lineto
stroke
grestore
gsave
0.37132 0.47253 moveto 0.42718 0.47556 lineto 0.36692 0.45338 lineto 0.505 0.554 0.84 setrgbcolor
fill
grestore
gsave
0.37132 0.47253 moveto 0.42605 0.49299 lineto 0.42718 0.47556 lineto 0.526 0.481 0.748 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.37132 0.47253 moveto
0.37724 0.49211 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37132 0.47253 moveto
0.37314 0.47321 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42285 0.50974 moveto
0.4254 0.51073 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37724 0.49211 moveto
0.42285 0.50974 lineto
stroke
grestore
gsave
0.47325 0.76452 moveto 0.42236 0.74196 lineto 0.42424 0.72581 lineto 0.869 0.655 0.611 setrgbcolor
fill
grestore
gsave
0.4738 0.78449 moveto 0.42236 0.74196 lineto 0.47325 0.76452 lineto 0.877 0.605 0.524 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46971 0.74354 moveto
0.47098 0.74404 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47098 0.74404 moveto
0.47325 0.76452 lineto
stroke
grestore
gsave
0.36692 0.45338 moveto 0.42895 0.45854 lineto 0.36429 0.4347 lineto 0.54 0.583 0.847 setrgbcolor
fill
grestore
gsave
0.36692 0.45338 moveto 0.42718 0.47556 lineto 0.42895 0.45854 lineto 0.564 0.52 0.764 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36692 0.45338 moveto
0.37132 0.47253 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36692 0.45338 moveto
0.36896 0.45413 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42271 0.49174 moveto
0.42605 0.49299 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37314 0.47321 moveto
0.42271 0.49174 lineto
stroke
grestore
gsave
0.4738 0.78449 moveto 0.41977 0.75742 lineto 0.42236 0.74196 lineto 0.855 0.634 0.602 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42424 0.72581 moveto
0.42711 0.72693 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42711 0.72693 moveto
0.46971 0.74354 lineto
stroke
grestore
gsave
0.47251 0.8038 moveto 0.41977 0.75742 lineto 0.4738 0.78449 lineto 0.864 0.595 0.53 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47193 0.76394 moveto
0.47325 0.76452 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47325 0.76452 moveto
0.4738 0.78449 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42594 0.60189 moveto
0.42629 0.6202 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42629 0.6202 moveto
0.42657 0.63842 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42559 0.58352 moveto
0.42594 0.60189 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42657 0.63842 moveto
0.42671 0.65649 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4253 0.56517 moveto
0.42559 0.58352 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42664 0.67434 moveto
0.42671 0.65649 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42512 0.54689 moveto
0.4253 0.56517 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42628 0.6919 moveto
0.42664 0.67434 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42512 0.54689 moveto
0.42512 0.52872 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42551 0.70909 moveto
0.42628 0.6919 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42512 0.52872 moveto
0.4254 0.51073 lineto
stroke
grestore
gsave
0.36429 0.4347 moveto 0.43148 0.442 lineto 0.36363 0.41654 lineto 0.567 0.608 0.854 setrgbcolor
fill
grestore
gsave
0.36429 0.4347 moveto 0.42895 0.45854 lineto 0.43148 0.442 lineto 0.594 0.553 0.778 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36429 0.4347 moveto
0.36692 0.45338 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36429 0.4347 moveto
0.36651 0.43552 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42298 0.47401 moveto
0.42718 0.47556 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36896 0.45413 moveto
0.42298 0.47401 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4254 0.51073 moveto
0.42605 0.49299 lineto
stroke
grestore
gsave
0.47251 0.8038 moveto 0.41639 0.77207 lineto 0.41977 0.75742 lineto 0.845 0.615 0.591 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42236 0.74196 moveto
0.42644 0.74377 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42644 0.74377 moveto
0.47193 0.76394 lineto
stroke
grestore
gsave
0.46932 0.8223 moveto 0.41639 0.77207 lineto 0.47251 0.8038 lineto 0.854 0.587 0.533 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4725 0.78383 moveto
0.4738 0.78449 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47251 0.8038 moveto
0.4738 0.78449 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42424 0.72581 moveto
0.42551 0.70909 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42605 0.49299 moveto
0.42718 0.47556 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42236 0.74196 moveto
0.42424 0.72581 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42718 0.47556 moveto
0.42895 0.45854 lineto
stroke
grestore
gsave
0.36363 0.41654 moveto 0.43494 0.42604 lineto 0.36511 0.39894 lineto 0.588 0.63 0.861 setrgbcolor
fill
grestore
gsave
0.36363 0.41654 moveto 0.43148 0.442 lineto 0.43494 0.42604 lineto 0.617 0.582 0.791 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36363 0.41654 moveto
0.36429 0.4347 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36363 0.41654 moveto
0.36599 0.41742 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36599 0.41742 moveto
0.43148 0.442 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4238 0.45664 moveto
0.42895 0.45854 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36651 0.43552 moveto
0.4238 0.45664 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41977 0.75742 moveto
0.42236 0.74196 lineto
stroke
grestore
gsave
0.46932 0.8223 moveto 0.41215 0.78575 lineto 0.41639 0.77207 lineto 0.839 0.599 0.577 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41977 0.75742 moveto
0.4257 0.7604 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4257 0.7604 moveto
0.4725 0.78383 lineto
stroke
grestore
gsave
0.46418 0.83985 moveto 0.41215 0.78575 lineto 0.46932 0.8223 lineto 0.847 0.58 0.534 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41639 0.77207 moveto
0.47134 0.80313 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47134 0.80313 moveto
0.47251 0.8038 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46932 0.8223 moveto
0.47251 0.8038 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42895 0.45854 moveto
0.43148 0.442 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41639 0.77207 moveto
0.41977 0.75742 lineto
stroke
grestore
gsave
0.36511 0.39894 moveto 0.43946 0.41076 lineto 0.36889 0.38197 lineto 0.605 0.649 0.867 setrgbcolor
fill
grestore
gsave
0.36511 0.39894 moveto 0.43494 0.42604 lineto 0.43946 0.41076 lineto 0.636 0.608 0.804 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36363 0.41654 moveto
0.36511 0.39894 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36511 0.39894 moveto
0.43494 0.42604 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43148 0.442 moveto
0.43494 0.42604 lineto
stroke
grestore
gsave
0.46418 0.83985 moveto 0.40701 0.79835 lineto 0.41215 0.78575 lineto 0.836 0.587 0.561 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41215 0.78575 moveto
0.41639 0.77207 lineto
stroke
grestore
gsave
0.45706 0.85625 moveto 0.40701 0.79835 lineto 0.46418 0.83985 lineto 0.843 0.575 0.533 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41215 0.78575 moveto
0.46852 0.82179 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46852 0.82179 moveto
0.46932 0.8223 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46418 0.83985 moveto
0.46932 0.8223 lineto
stroke
grestore
gsave
0.36889 0.38197 moveto 0.43946 0.41076 lineto 0.44519 0.39626 lineto 0.651 0.631 0.818 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43494 0.42604 moveto
0.43946 0.41076 lineto
stroke
grestore
gsave
0.36889 0.38197 moveto 0.44519 0.39626 lineto 0.37507 0.36569 lineto 0.618 0.667 0.874 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36511 0.39894 moveto
0.36889 0.38197 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36889 0.38197 moveto
0.43946 0.41076 lineto
stroke
grestore
gsave
0.45706 0.85625 moveto 0.40097 0.8097 lineto 0.40701 0.79835 lineto 0.838 0.578 0.545 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40701 0.79835 moveto
0.41215 0.78575 lineto
stroke
grestore
gsave
0.44799 0.87132 moveto 0.40097 0.8097 lineto 0.45706 0.85625 lineto 0.842 0.573 0.533 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40701 0.79835 moveto
0.46418 0.83985 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45706 0.85625 moveto
0.46418 0.83985 lineto
stroke
grestore
gsave
0.37507 0.36569 moveto 0.44519 0.39626 lineto 0.45223 0.38266 lineto 0.661 0.653 0.832 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43946 0.41076 moveto
0.44519 0.39626 lineto
stroke
grestore
gsave
0.37507 0.36569 moveto 0.45223 0.38266 lineto 0.38372 0.35016 lineto 0.628 0.682 0.881 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36889 0.38197 moveto
0.37507 0.36569 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37507 0.36569 moveto
0.44519 0.39626 lineto
stroke
grestore
gsave
0.38372 0.35016 moveto 0.45223 0.38266 lineto 0.46067 0.37006 lineto 0.668 0.673 0.846 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44519 0.39626 moveto
0.45223 0.38266 lineto
stroke
grestore
gsave
0.44799 0.87132 moveto 0.39406 0.81967 lineto 0.40097 0.8097 lineto 0.844 0.573 0.529 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40097 0.8097 moveto
0.40701 0.79835 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40097 0.8097 moveto
0.45706 0.85625 lineto
stroke
grestore
gsave
0.43702 0.88487 moveto 0.39406 0.81967 lineto 0.44799 0.87132 lineto 0.842 0.574 0.532 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.44799 0.87132 moveto
0.45706 0.85625 lineto
stroke
grestore
gsave
0.39486 0.33546 moveto 0.46067 0.37006 lineto 0.47055 0.35857 lineto 0.67 0.69 0.86 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44014 0.37693 moveto
0.45223 0.38266 lineto
stroke
grestore
gsave
0.38372 0.35016 moveto 0.46067 0.37006 lineto 0.39486 0.33546 lineto 0.635 0.695 0.888 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38372 0.35016 moveto
0.44014 0.37693 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45223 0.38266 moveto
0.46067 0.37006 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37507 0.36569 moveto
0.38372 0.35016 lineto
stroke
grestore
gsave
0.43702 0.88487 moveto 0.38633 0.82815 lineto 0.39406 0.81967 lineto 0.853 0.573 0.513 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39406 0.81967 moveto
0.40097 0.8097 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39406 0.81967 moveto
0.44799 0.87132 lineto
stroke
grestore
gsave
0.40848 0.32169 moveto 0.47055 0.35857 lineto 0.48188 0.34831 lineto 0.668 0.704 0.874 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44579 0.36224 moveto
0.46067 0.37006 lineto
stroke
grestore
gsave
0.39486 0.33546 moveto 0.47055 0.35857 lineto 0.40848 0.32169 lineto 0.64 0.705 0.894 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46067 0.37006 moveto
0.47055 0.35857 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.38372 0.35016 moveto
0.39486 0.33546 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39486 0.33546 moveto
0.39748 0.33684 lineto
stroke
grestore
gsave
0.42423 0.89669 moveto 0.38633 0.82815 lineto 0.43702 0.88487 lineto 0.845 0.577 0.534 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.43702 0.88487 moveto
0.44799 0.87132 lineto
stroke
grestore
gsave
0.42423 0.89669 moveto 0.3779 0.83501 lineto 0.38633 0.82815 lineto 0.866 0.579 0.501 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.38633 0.82815 moveto
0.39406 0.81967 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38633 0.82815 moveto
0.43702 0.88487 lineto
stroke
grestore
gsave
0.4245 0.30893 moveto 0.48188 0.34831 lineto 0.49462 0.33938 lineto 0.662 0.714 0.887 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45093 0.34692 moveto
0.47055 0.35857 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43244 0.35522 moveto
0.44579 0.36224 lineto
stroke
grestore
gsave
0.40848 0.32169 moveto 0.48188 0.34831 lineto 0.4245 0.30893 lineto 0.642 0.713 0.898 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39748 0.33684 moveto
0.43244 0.35522 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47055 0.35857 moveto
0.48188 0.34831 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40848 0.32169 moveto
0.41108 0.32323 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39486 0.33546 moveto
0.40848 0.32169 lineto
stroke
grestore
gsave
0.40976 0.90659 moveto 0.3779 0.83501 lineto 0.42423 0.89669 lineto 0.85 0.584 0.537 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.42423 0.89669 moveto
0.43702 0.88487 lineto
stroke
grestore
gsave
0.40976 0.90659 moveto 0.36889 0.84018 lineto 0.3779 0.83501 lineto 0.882 0.593 0.493 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3779 0.83501 moveto
0.38633 0.82815 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3779 0.83501 moveto
0.42423 0.89669 lineto
stroke
grestore
gsave
0.44282 0.29731 moveto 0.49462 0.33938 lineto 0.50869 0.33188 lineto 0.651 0.719 0.898 setrgbcolor
fill
grestore
gsave
0.4245 0.30893 moveto 0.49462 0.33938 lineto 0.44282 0.29731 lineto 0.643 0.717 0.902 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41108 0.32323 moveto
0.42959 0.33423 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42959 0.33423 moveto
0.45093 0.34692 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48188 0.34831 moveto
0.49462 0.33938 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4245 0.30893 moveto
0.42728 0.31084 lineto
stroke
grestore
gsave
0.87382 0.52318 moveto 0.85005 0.53833 lineto 0.87574 0.54875 lineto 0.991 0.775 0.514 setrgbcolor
fill
grestore
gsave
0.87382 0.52318 moveto 0.84275 0.52048 lineto 0.85005 0.53833 lineto 0.942 0.619 0.395 setrgbcolor
fill
grestore
gsave
0.8707 0.49768 moveto 0.84275 0.52048 lineto 0.87382 0.52318 lineto 0.97 0.758 0.563 setrgbcolor
fill
grestore
gsave
0.8707 0.49768 moveto 0.83427 0.50286 lineto 0.84275 0.52048 lineto 0.909 0.608 0.463 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.84275 0.52048 moveto
0.87382 0.52318 lineto
stroke
grestore
gsave
0.86623 0.47247 moveto 0.83427 0.50286 lineto 0.8707 0.49768 lineto 0.942 0.739 0.601 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.8707 0.49768 moveto
0.87382 0.52318 lineto
stroke
grestore
gsave
0.87574 0.54875 moveto 0.8562 0.55628 lineto 0.87667 0.5742 lineto 0.998 0.784 0.454 setrgbcolor
fill
grestore
gsave
0.87574 0.54875 moveto 0.85005 0.53833 lineto 0.8562 0.55628 lineto 0.961 0.626 0.309 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.87382 0.52318 moveto
0.87574 0.54875 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.85005 0.53833 moveto
0.87574 0.54875 lineto
stroke
grestore
gsave
0.86623 0.47247 moveto 0.82466 0.48561 lineto 0.83427 0.50286 lineto 0.872 0.595 0.515 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83427 0.50286 moveto
0.8707 0.49768 lineto
stroke
grestore
gsave
0.86021 0.44776 moveto 0.82466 0.48561 lineto 0.86623 0.47247 lineto 0.911 0.72 0.631 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.86623 0.47247 moveto
0.8707 0.49768 lineto
stroke
grestore
gsave
0.44282 0.29731 moveto 0.50869 0.33188 lineto 0.46329 0.28692 lineto 0.643 0.719 0.903 setrgbcolor
fill
grestore
gsave
0.45738 0.28876 moveto 0.49585 0.33624 lineto 0.51217 0.33044 lineto 0.659 0.724 0.897 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49462 0.33938 moveto
0.50869 0.33188 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45111 0.32719 moveto
0.48188 0.34831 lineto
stroke
grestore
gsave
0.87667 0.5742 moveto 0.86119 0.57417 lineto 0.87676 0.59932 lineto 0.987 0.782 0.386 setrgbcolor
fill
grestore
gsave
0.87667 0.5742 moveto 0.8562 0.55628 lineto 0.86119 0.57417 lineto 0.951 0.621 0.209 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.87574 0.54875 moveto
0.87667 0.5742 lineto
stroke
grestore
gsave
0.86021 0.44776 moveto 0.81394 0.46883 lineto 0.82466 0.48561 lineto 0.838 0.585 0.556 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82466 0.48561 moveto
0.86623 0.47247 lineto
stroke
grestore
gsave
0.8525 0.42376 moveto 0.81394 0.46883 lineto 0.86021 0.44776 lineto 0.882 0.703 0.655 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.86021 0.44776 moveto
0.86623 0.47247 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50854 0.33173 moveto
0.50869 0.33188 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44282 0.29731 moveto
0.44572 0.29966 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42728 0.31084 moveto
0.45111 0.32719 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40848 0.32169 moveto
0.4245 0.30893 lineto
stroke
grestore
gsave
0.87676 0.59932 moveto 0.86507 0.59183 lineto 0.8762 0.62393 lineto 0.956 0.767 0.315 setrgbcolor
fill
grestore
gsave
0.87676 0.59932 moveto 0.86119 0.57417 lineto 0.86507 0.59183 lineto 0.907 0.602 0.11 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.87667 0.5742 moveto
0.87676 0.59932 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8762 0.59841 moveto
0.87676 0.59932 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.85887 0.55862 moveto
0.87667 0.5742 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8562 0.55628 moveto
0.85887 0.55862 lineto
stroke
grestore
gsave
0.48138 0.27953 moveto 0.51217 0.33044 lineto 0.52942 0.32625 lineto 0.647 0.715 0.898 setrgbcolor
fill
grestore
gsave
0.45738 0.28876 moveto 0.51217 0.33044 lineto 0.48138 0.27953 lineto 0.671 0.726 0.89 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48581 0.32385 moveto
0.49585 0.33624 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49585 0.33624 moveto
0.51217 0.33044 lineto
stroke
grestore
gsave
0.8525 0.42376 moveto 0.80217 0.4526 lineto 0.81394 0.46883 lineto 0.807 0.577 0.589 setrgbcolor
fill
grestore
gsave
0.84296 0.40071 moveto 0.80217 0.4526 lineto 0.8525 0.42376 lineto 0.854 0.689 0.676 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.85868 0.44845 moveto
0.86021 0.44776 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.8525 0.42376 moveto
0.86021 0.44776 lineto
stroke
grestore
gsave
0.39378 0.91437 moveto 0.36889 0.84018 lineto 0.40976 0.90659 lineto 0.856 0.595 0.543 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40976 0.90659 moveto
0.42423 0.89669 lineto
stroke
grestore
gsave
0.39378 0.91437 moveto 0.35947 0.84359 lineto 0.36889 0.84018 lineto 0.9 0.613 0.491 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.36889 0.84018 moveto
0.3779 0.83501 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36889 0.84018 moveto
0.40976 0.90659 lineto
stroke
grestore
gsave
0.8762 0.62393 moveto 0.86788 0.60908 lineto 0.87512 0.64784 lineto 0.912 0.744 0.25 setrgbcolor
fill
grestore
gsave
0.8762 0.62393 moveto 0.86507 0.59183 lineto 0.86788 0.60908 lineto 0.841 0.578 0.034 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.8762 0.62393 moveto
0.87676 0.59932 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87578 0.62274 moveto
0.8762 0.62393 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86363 0.5781 moveto
0.8762 0.59841 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86119 0.57417 moveto
0.86363 0.5781 lineto
stroke
grestore
gsave
0.50677 0.27191 moveto 0.52942 0.32625 lineto 0.5474 0.3237 lineto 0.636 0.701 0.893 setrgbcolor
fill
grestore
gsave
0.48138 0.27953 moveto 0.52942 0.32625 lineto 0.50677 0.27191 lineto 0.672 0.721 0.886 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51217 0.33044 moveto
0.52942 0.32625 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48138 0.27953 moveto
0.48405 0.28395 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48405 0.28395 moveto
0.48438 0.2845 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44572 0.29966 moveto
0.49462 0.33938 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45738 0.28876 moveto
0.48581 0.32385 lineto
stroke
grestore
gsave
0.84296 0.40071 moveto 0.78941 0.437 lineto 0.80217 0.4526 lineto 0.78 0.571 0.617 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80217 0.4526 moveto
0.80493 0.45102 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81394 0.46883 moveto
0.85868 0.44845 lineto
stroke
grestore
gsave
0.83147 0.37881 moveto 0.78941 0.437 lineto 0.84296 0.40071 lineto 0.83 0.677 0.694 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.85084 0.42471 moveto
0.8525 0.42376 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.84296 0.40071 moveto
0.8525 0.42376 lineto
stroke
grestore
gsave
0.53326 0.26602 moveto 0.5474 0.3237 lineto 0.56591 0.32283 lineto 0.627 0.684 0.884 setrgbcolor
fill
grestore
gsave
0.50677 0.27191 moveto 0.5474 0.3237 lineto 0.53326 0.26602 lineto 0.673 0.714 0.88 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52942 0.32625 moveto
0.5474 0.3237 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50677 0.27191 moveto
0.50716 0.27284 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50716 0.27284 moveto
0.51238 0.28536 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51238 0.28536 moveto
0.52942 0.32625 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48438 0.2845 moveto
0.51217 0.33044 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.4245 0.30893 moveto
0.44282 0.29731 lineto
stroke
grestore
gsave
0.83147 0.37881 moveto 0.77575 0.42209 lineto 0.78941 0.437 lineto 0.756 0.567 0.642 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78941 0.437 moveto
0.79192 0.4353 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80493 0.45102 moveto
0.85084 0.42471 lineto
stroke
grestore
gsave
0.81796 0.35827 moveto 0.77575 0.42209 lineto 0.83147 0.37881 lineto 0.807 0.669 0.71 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8412 0.40189 moveto
0.84296 0.40071 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.83147 0.37881 moveto
0.84296 0.40071 lineto
stroke
grestore
gsave
0.87512 0.64784 moveto 0.86966 0.62574 lineto 0.87368 0.67087 lineto 0.868 0.72 0.2 setrgbcolor
fill
grestore
gsave
0.87512 0.64784 moveto 0.86788 0.60908 lineto 0.86966 0.62574 lineto 0.781 0.566 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.87512 0.64784 moveto
0.8762 0.62393 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87484 0.64635 moveto
0.87512 0.64784 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86722 0.59803 moveto
0.87578 0.62274 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86507 0.59183 moveto
0.86722 0.59803 lineto
stroke
grestore
gsave
0.3765 0.91984 moveto 0.35947 0.84359 lineto 0.39378 0.91437 lineto 0.862 0.608 0.553 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.39378 0.91437 moveto
0.40976 0.90659 lineto
stroke
grestore
gsave
0.3765 0.91984 moveto 0.34982 0.84524 lineto 0.35947 0.84359 lineto 0.919 0.641 0.497 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35947 0.84359 moveto
0.36889 0.84018 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35947 0.84359 moveto
0.39378 0.91437 lineto
stroke
grestore
gsave
0.5605 0.262 moveto 0.56591 0.32283 lineto 0.58477 0.32362 lineto 0.623 0.666 0.871 setrgbcolor
fill
grestore
gsave
0.53326 0.26602 moveto 0.56591 0.32283 lineto 0.5605 0.262 lineto 0.675 0.706 0.871 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5474 0.3237 moveto
0.56591 0.32283 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53326 0.26602 moveto
0.5474 0.3237 lineto
stroke
grestore
gsave
0.58816 0.25997 moveto 0.58477 0.32362 lineto 0.60378 0.32603 lineto 0.622 0.648 0.855 setrgbcolor
fill
grestore
gsave
0.5605 0.262 moveto 0.58477 0.32362 lineto 0.58816 0.25997 lineto 0.679 0.698 0.861 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.56591 0.32283 moveto
0.58477 0.32362 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5605 0.262 moveto
0.56591 0.32283 lineto
stroke
grestore
gsave
0.81796 0.35827 moveto 0.76124 0.40793 lineto 0.77575 0.42209 lineto 0.734 0.566 0.664 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77575 0.42209 moveto
0.77794 0.42038 lineto
stroke
grestore
gsave
0.80241 0.3393 moveto 0.76124 0.40793 lineto 0.81796 0.35827 lineto 0.788 0.663 0.725 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82966 0.38021 moveto
0.83147 0.37881 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81796 0.35827 moveto
0.83147 0.37881 lineto
stroke
grestore
gsave
0.61589 0.26002 moveto 0.60378 0.32603 lineto 0.62278 0.33002 lineto 0.624 0.631 0.838 setrgbcolor
fill
grestore
gsave
0.58816 0.25997 moveto 0.60378 0.32603 lineto 0.61589 0.26002 lineto 0.684 0.689 0.849 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58477 0.32362 moveto
0.60378 0.32603 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58477 0.32362 moveto
0.58816 0.25997 lineto
stroke
grestore
gsave
0.87368 0.67087 moveto 0.87047 0.64161 lineto 0.87199 0.69285 lineto 0.833 0.702 0.167 setrgbcolor
fill
grestore
gsave
0.87368 0.67087 moveto 0.86966 0.62574 lineto 0.87047 0.64161 lineto 0.749 0.575 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86788 0.60908 moveto
0.8697 0.61882 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.87368 0.67087 moveto
0.87512 0.64784 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87352 0.66903 moveto
0.87368 0.67087 lineto
stroke
grestore
gsave
0.64333 0.26224 moveto 0.62278 0.33002 lineto 0.64162 0.3355 lineto 0.629 0.616 0.819 setrgbcolor
fill
grestore
gsave
0.61589 0.26002 moveto 0.62278 0.33002 lineto 0.64333 0.26224 lineto 0.69 0.681 0.836 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60378 0.32603 moveto
0.62278 0.33002 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60378 0.32603 moveto
0.61589 0.26002 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.44282 0.29731 moveto
0.45805 0.28958 lineto
stroke
grestore
gsave
0.80241 0.3393 moveto 0.74596 0.39457 lineto 0.76124 0.40793 lineto 0.716 0.566 0.684 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76124 0.40793 moveto
0.76478 0.40482 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79192 0.4353 moveto
0.8412 0.40189 lineto
stroke
grestore
gsave
0.78481 0.32207 moveto 0.74596 0.39457 lineto 0.80241 0.3393 lineto 0.77 0.659 0.74 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81613 0.35988 moveto
0.81796 0.35827 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.80241 0.3393 moveto
0.81796 0.35827 lineto
stroke
grestore
gsave
0.67015 0.26668 moveto 0.64162 0.3355 lineto 0.66019 0.34239 lineto 0.636 0.603 0.799 setrgbcolor
fill
grestore
gsave
0.64333 0.26224 moveto 0.64162 0.3355 lineto 0.67015 0.26668 lineto 0.697 0.674 0.823 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62278 0.33002 moveto
0.64333 0.26224 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62278 0.33002 moveto
0.64162 0.3355 lineto
stroke
grestore
gsave
0.35819 0.92283 moveto 0.34982 0.84524 lineto 0.3765 0.91984 lineto 0.869 0.624 0.565 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.3765 0.91984 moveto
0.39378 0.91437 lineto
stroke
grestore
gsave
0.35819 0.92283 moveto 0.34014 0.84512 lineto 0.34982 0.84524 lineto 0.937 0.674 0.513 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34982 0.84524 moveto
0.35947 0.84359 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34982 0.84524 moveto
0.3765 0.91984 lineto
stroke
grestore
gsave
0.69602 0.27337 moveto 0.66019 0.34239 lineto 0.67839 0.35059 lineto 0.646 0.592 0.78 setrgbcolor
fill
grestore
gsave
0.67015 0.26668 moveto 0.66019 0.34239 lineto 0.69602 0.27337 lineto 0.706 0.667 0.809 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64162 0.3355 moveto
0.66928 0.26877 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64162 0.3355 moveto
0.66019 0.34239 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66928 0.26877 moveto
0.67015 0.26668 lineto
stroke
grestore
gsave
0.72065 0.28231 moveto 0.67839 0.35059 lineto 0.69613 0.36001 lineto 0.657 0.583 0.76 setrgbcolor
fill
grestore
gsave
0.69602 0.27337 moveto 0.67839 0.35059 lineto 0.72065 0.28231 lineto 0.716 0.662 0.796 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66019 0.34239 moveto
0.69491 0.2755 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66019 0.34239 moveto
0.67839 0.35059 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69491 0.2755 moveto
0.69602 0.27337 lineto
stroke
grestore
gsave
0.74379 0.29346 moveto 0.69613 0.36001 lineto 0.71334 0.37053 lineto 0.67 0.576 0.742 setrgbcolor
fill
grestore
gsave
0.72065 0.28231 moveto 0.69613 0.36001 lineto 0.74379 0.29346 lineto 0.727 0.659 0.782 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67839 0.35059 moveto
0.69613 0.36001 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71933 0.28444 moveto
0.72065 0.28231 lineto
stroke
grestore
gsave
0.76523 0.30675 moveto 0.71334 0.37053 lineto 0.72997 0.38208 lineto 0.683 0.571 0.723 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69613 0.36001 moveto
0.69626 0.35982 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67839 0.35059 moveto
0.67872 0.35007 lineto
stroke
grestore
gsave
0.74379 0.29346 moveto 0.71334 0.37053 lineto 0.76523 0.30675 lineto 0.74 0.657 0.768 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80062 0.34105 moveto
0.80241 0.3393 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67872 0.35007 moveto
0.71933 0.28444 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.69613 0.36001 moveto
0.71334 0.37053 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71334 0.37053 moveto
0.71644 0.36672 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74229 0.29556 moveto
0.74379 0.29346 lineto
stroke
grestore
gsave
0.78481 0.32207 moveto 0.72997 0.38208 lineto 0.74596 0.39457 lineto 0.699 0.568 0.704 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69626 0.35982 moveto
0.69704 0.35873 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74596 0.39457 moveto
0.74887 0.39172 lineto
stroke
grestore
gsave
0.76523 0.30675 moveto 0.72997 0.38208 lineto 0.78481 0.32207 lineto 0.754 0.657 0.754 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77794 0.42038 moveto
0.82966 0.38021 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.78481 0.32207 moveto
0.80241 0.3393 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76478 0.40482 moveto
0.81613 0.35988 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74887 0.39172 moveto
0.80059 0.34108 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80059 0.34108 moveto
0.80062 0.34105 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69704 0.35873 moveto
0.74229 0.29556 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71644 0.36672 moveto
0.76359 0.30877 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.71334 0.37053 moveto
0.72997 0.38208 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73402 0.37765 moveto
0.78306 0.32399 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78306 0.32399 moveto
0.7831 0.32395 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7831 0.32395 moveto
0.78481 0.32207 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72997 0.38208 moveto
0.73402 0.37765 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76364 0.30871 moveto
0.76523 0.30675 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76359 0.30877 moveto
0.76364 0.30871 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72997 0.38208 moveto
0.74596 0.39457 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74596 0.39457 moveto
0.76124 0.40793 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.76523 0.30675 moveto
0.78481 0.32207 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76124 0.40793 moveto
0.77575 0.42209 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.77575 0.42209 moveto
0.78941 0.437 lineto
stroke
grestore
gsave
0.87199 0.69285 moveto 0.87035 0.65653 lineto 0.87015 0.71359 lineto 0.813 0.692 0.151 setrgbcolor
fill
grestore
gsave
0.87199 0.69285 moveto 0.87047 0.64161 lineto 0.87035 0.65653 lineto 0.752 0.61 0.041 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87112 0.64207 moveto
0.87352 0.66903 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86966 0.62574 moveto
0.87112 0.64207 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.87199 0.69285 moveto
0.87368 0.67087 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87047 0.64161 moveto
0.87192 0.69041 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87192 0.69041 moveto
0.87199 0.69285 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87136 0.62768 moveto
0.87484 0.64635 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8697 0.61882 moveto
0.87136 0.62768 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78941 0.437 moveto
0.80217 0.4526 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.80217 0.4526 moveto
0.81394 0.46883 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.81394 0.46883 moveto
0.82466 0.48561 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45738 0.28876 moveto
0.48138 0.27953 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.82466 0.48561 moveto
0.83427 0.50286 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.83427 0.50286 moveto
0.84275 0.52048 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.74379 0.29346 moveto
0.76523 0.30675 lineto
stroke
grestore
gsave
0.33914 0.92321 moveto 0.34014 0.84512 lineto 0.35819 0.92283 lineto 0.875 0.642 0.582 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.35819 0.92283 moveto
0.3765 0.91984 lineto
stroke
grestore
gsave
0.33914 0.92321 moveto 0.3306 0.84328 lineto 0.34014 0.84512 lineto 0.952 0.712 0.538 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34014 0.84512 moveto
0.34982 0.84524 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34014 0.84512 moveto
0.35819 0.92283 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.84275 0.52048 moveto
0.85005 0.53833 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.85005 0.53833 moveto
0.8562 0.55628 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48138 0.27953 moveto
0.50677 0.27191 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72065 0.28231 moveto
0.74379 0.29346 lineto
stroke
grestore
gsave
0.87015 0.71359 moveto 0.86933 0.67034 lineto 0.86824 0.73291 lineto 0.809 0.691 0.149 setrgbcolor
fill
grestore
gsave
0.87015 0.71359 moveto 0.87035 0.65653 lineto 0.86933 0.67034 lineto 0.788 0.665 0.114 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.87015 0.71359 moveto
0.87199 0.69285 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87015 0.71359 moveto
0.87016 0.71037 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.87016 0.71037 moveto
0.87035 0.65653 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.8562 0.55628 moveto
0.86119 0.57417 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69602 0.27337 moveto
0.72065 0.28231 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.50677 0.27191 moveto
0.53326 0.26602 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.86119 0.57417 moveto
0.86507 0.59183 lineto
stroke
grestore
gsave
0.31969 0.92086 moveto 0.3306 0.84328 lineto 0.33914 0.92321 lineto 0.88 0.661 0.602 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.33914 0.92321 moveto
0.35819 0.92283 lineto
stroke
grestore
gsave
0.31969 0.92086 moveto 0.32141 0.83981 lineto 0.3306 0.84328 lineto 0.963 0.752 0.571 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3306 0.84328 moveto
0.34014 0.84512 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3306 0.84328 moveto
0.33914 0.92321 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.67015 0.26668 moveto
0.69602 0.27337 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53326 0.26602 moveto
0.5605 0.262 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.86507 0.59183 moveto
0.86788 0.60908 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.64333 0.26224 moveto
0.67015 0.26668 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.5605 0.262 moveto
0.58816 0.25997 lineto
stroke
grestore
gsave
0.86824 0.73291 moveto 0.86745 0.68288 lineto 0.8663 0.75063 lineto 0.817 0.695 0.156 setrgbcolor
fill
grestore
gsave
0.86824 0.73291 moveto 0.86933 0.67034 lineto 0.86745 0.68288 lineto 0.846 0.731 0.207 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.86824 0.73291 moveto
0.87015 0.71359 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86824 0.73291 moveto
0.86933 0.67034 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61589 0.26002 moveto
0.64333 0.26224 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.58816 0.25997 moveto
0.61589 0.26002 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.86788 0.60908 moveto
0.86966 0.62574 lineto
stroke
grestore
gsave
0.30019 0.91574 moveto 0.32141 0.83981 lineto 0.31969 0.92086 lineto 0.883 0.68 0.624 setrgbcolor
fill
grestore
gsave
0.30019 0.91574 moveto 0.31272 0.83482 lineto 0.32141 0.83981 lineto 0.967 0.79 0.612 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32141 0.83981 moveto
0.3306 0.84328 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31969 0.92086 moveto
0.32141 0.83981 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.31969 0.92086 moveto
0.33914 0.92321 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.86966 0.62574 moveto
0.87047 0.64161 lineto
stroke
grestore
gsave
0.8663 0.75063 moveto 0.8647 0.69405 lineto 0.86437 0.76658 lineto 0.835 0.702 0.167 setrgbcolor
fill
grestore
gsave
0.8663 0.75063 moveto 0.86745 0.68288 lineto 0.8647 0.69405 lineto 0.909 0.789 0.307 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.8663 0.75063 moveto
0.86824 0.73291 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8663 0.75063 moveto
0.86745 0.68288 lineto
stroke
grestore
gsave
0.28104 0.90781 moveto 0.31272 0.83482 lineto 0.30019 0.91574 lineto 0.883 0.698 0.648 setrgbcolor
fill
grestore
gsave
0.28104 0.90781 moveto 0.30469 0.82842 lineto 0.31272 0.83482 lineto 0.964 0.825 0.658 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31272 0.83482 moveto
0.32141 0.83981 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.87035 0.65653 moveto
0.87047 0.64161 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.30019 0.91574 moveto
0.31969 0.92086 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.86933 0.67034 moveto
0.87035 0.65653 lineto
stroke
grestore
gsave
0.26263 0.89712 moveto 0.30469 0.82842 lineto 0.28104 0.90781 lineto 0.879 0.714 0.673 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30019 0.91574 moveto
0.30064 0.91289 lineto
stroke
grestore
gsave
0.26263 0.89712 moveto 0.29743 0.82076 lineto 0.30469 0.82842 lineto 0.953 0.853 0.705 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30064 0.91289 moveto
0.31272 0.83482 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30469 0.82842 moveto
0.31272 0.83482 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30299 0.83413 moveto
0.30469 0.82842 lineto
stroke
grestore
gsave
0.86437 0.76658 moveto 0.86109 0.70374 lineto 0.86244 0.78055 lineto 0.857 0.705 0.178 setrgbcolor
fill
grestore
gsave
0.86437 0.76658 moveto 0.8647 0.69405 lineto 0.86109 0.70374 lineto 0.959 0.826 0.396 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.86437 0.76658 moveto
0.8663 0.75063 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86437 0.76658 moveto
0.8647 0.69405 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.28104 0.90781 moveto
0.30019 0.91574 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.86745 0.68288 moveto
0.86933 0.67034 lineto
stroke
grestore
gsave
0.24535 0.88378 moveto 0.29743 0.82076 lineto 0.26263 0.89712 lineto 0.873 0.728 0.698 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28104 0.90781 moveto
0.28187 0.90505 lineto
stroke
grestore
gsave
0.24535 0.88378 moveto 0.29105 0.81199 lineto 0.29743 0.82076 lineto 0.935 0.874 0.752 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28187 0.90505 moveto
0.30299 0.83413 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.29743 0.82076 moveto
0.30469 0.82842 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29525 0.82555 moveto
0.29743 0.82076 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.8647 0.69405 moveto
0.86745 0.68288 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.26263 0.89712 moveto
0.28104 0.90781 lineto
stroke
grestore
gsave
0.86244 0.78055 moveto 0.85661 0.71189 lineto 0.86049 0.79236 lineto 0.878 0.702 0.182 setrgbcolor
fill
grestore
gsave
0.86244 0.78055 moveto 0.86109 0.70374 lineto 0.85661 0.71189 lineto 0.989 0.837 0.462 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.86244 0.78055 moveto
0.86437 0.76658 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86109 0.70374 moveto
0.86244 0.78055 lineto
stroke
grestore
gsave
0.2296 0.86793 moveto 0.29105 0.81199 lineto 0.24535 0.88378 lineto 0.863 0.738 0.723 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26263 0.89712 moveto
0.26383 0.89449 lineto
stroke
grestore
gsave
0.2296 0.86793 moveto 0.28561 0.80224 lineto 0.29105 0.81199 lineto 0.911 0.885 0.795 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26383 0.89449 moveto
0.29525 0.82555 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.29105 0.81199 moveto
0.29743 0.82076 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28856 0.8159 moveto
0.29105 0.81199 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.86109 0.70374 moveto
0.8647 0.69405 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.24535 0.88378 moveto
0.26263 0.89712 lineto
stroke
grestore
gsave
0.21571 0.84979 moveto 0.28561 0.80224 lineto 0.2296 0.86793 lineto 0.85 0.744 0.746 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24535 0.88378 moveto
0.24691 0.88133 lineto
stroke
grestore
gsave
0.21571 0.84979 moveto 0.28117 0.79165 lineto 0.28561 0.80224 lineto 0.881 0.888 0.833 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24691 0.88133 moveto
0.28856 0.8159 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28561 0.80224 moveto
0.29105 0.81199 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28298 0.80532 moveto
0.28561 0.80224 lineto
stroke
grestore
gsave
0.86049 0.79236 moveto 0.85123 0.71847 lineto 0.85846 0.80183 lineto 0.894 0.69 0.176 setrgbcolor
fill
grestore
gsave
0.86049 0.79236 moveto 0.85661 0.71189 lineto 0.85123 0.71847 lineto 1 0.826 0.502 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.86049 0.79236 moveto
0.86244 0.78055 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.85661 0.71189 moveto
0.86049 0.79236 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.85661 0.71189 moveto
0.86109 0.70374 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2296 0.86793 moveto
0.24535 0.88378 lineto
stroke
grestore
gsave
0.20403 0.82961 moveto 0.28117 0.79165 lineto 0.21571 0.84979 lineto 0.835 0.746 0.766 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2296 0.86793 moveto
0.23148 0.86571 lineto
stroke
grestore
gsave
0.20403 0.82961 moveto 0.27779 0.78034 lineto 0.28117 0.79165 lineto 0.847 0.882 0.865 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23148 0.86571 moveto
0.28298 0.80532 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28117 0.79165 moveto
0.28561 0.80224 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27858 0.79395 moveto
0.28117 0.79165 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.21571 0.84979 moveto
0.2296 0.86793 lineto
stroke
grestore
gsave
0.85846 0.80183 moveto 0.84493 0.72348 lineto 0.85625 0.80878 lineto 0.901 0.665 0.156 setrgbcolor
fill
grestore
gsave
0.85846 0.80183 moveto 0.85123 0.71847 lineto 0.84493 0.72348 lineto 0.997 0.798 0.517 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.85846 0.80183 moveto
0.86049 0.79236 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.85123 0.71847 moveto
0.85846 0.80183 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.85123 0.71847 moveto
0.85661 0.71189 lineto
stroke
grestore
gsave
0.19484 0.80772 moveto 0.27779 0.78034 lineto 0.20403 0.82961 lineto 0.817 0.745 0.784 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.21571 0.84979 moveto
0.2179 0.84785 lineto
stroke
grestore
gsave
0.19484 0.80772 moveto 0.27551 0.76842 lineto 0.27779 0.78034 lineto 0.81 0.868 0.89 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2179 0.84785 moveto
0.27858 0.79395 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27779 0.78034 moveto
0.28117 0.79165 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27538 0.78195 moveto
0.27779 0.78034 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.20403 0.82961 moveto
0.21571 0.84979 lineto
stroke
grestore
gsave
0.18836 0.78444 moveto 0.27551 0.76842 lineto 0.19484 0.80772 lineto 0.797 0.739 0.799 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.20403 0.82961 moveto
0.20647 0.82799 lineto
stroke
grestore
gsave
0.18836 0.78444 moveto 0.27438 0.75599 lineto 0.27551 0.76842 lineto 0.772 0.847 0.908 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.20647 0.82799 moveto
0.27538 0.78195 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27551 0.76842 moveto
0.27779 0.78034 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27343 0.76943 moveto
0.27551 0.76842 lineto
stroke
grestore
gsave
0.85625 0.80878 moveto 0.83769 0.72694 lineto 0.85375 0.81306 lineto 0.898 0.628 0.12 setrgbcolor
fill
grestore
gsave
0.85625 0.80878 moveto 0.84493 0.72348 lineto 0.83769 0.72694 lineto 0.986 0.762 0.513 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.85625 0.80878 moveto
0.85846 0.80183 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.84493 0.72348 moveto
0.85625 0.80878 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.84493 0.72348 moveto
0.85123 0.71847 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.19484 0.80772 moveto
0.20403 0.82961 lineto
stroke
grestore
gsave
0.18476 0.76015 moveto 0.27438 0.75599 lineto 0.18836 0.78444 lineto 0.776 0.729 0.81 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.19484 0.80772 moveto
0.19747 0.80644 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.19747 0.80644 moveto
0.27343 0.76943 lineto
stroke
grestore
gsave
0.18476 0.76015 moveto 0.27447 0.74315 lineto 0.27438 0.75599 lineto 0.733 0.82 0.918 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27438 0.75599 moveto
0.27551 0.76842 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27276 0.75652 moveto
0.27438 0.75599 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.18836 0.78444 moveto
0.19484 0.80772 lineto
stroke
grestore
gsave
0.85375 0.81306 moveto 0.83769 0.72694 lineto 0.82947 0.72891 lineto 0.972 0.72 0.494 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.83769 0.72694 moveto
0.84493 0.72348 lineto
stroke
grestore
gsave
0.85375 0.81306 moveto 0.82947 0.72891 lineto 0.85081 0.81453 lineto 0.881 0.575 0.063 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.85375 0.81306 moveto
0.85625 0.80878 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83769 0.72694 moveto
0.85375 0.81306 lineto
stroke
grestore
gsave
0.18417 0.73523 moveto 0.27447 0.74315 lineto 0.18476 0.76015 lineto 0.754 0.717 0.818 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.18476 0.76015 moveto
0.27342 0.74335 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.18836 0.78444 moveto
0.19113 0.78352 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.19113 0.78352 moveto
0.27276 0.75652 lineto
stroke
grestore
gsave
0.18417 0.73523 moveto 0.27584 0.73001 lineto 0.27447 0.74315 lineto 0.696 0.788 0.922 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27438 0.75599 moveto
0.27447 0.74315 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27342 0.74335 moveto
0.27447 0.74315 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.18476 0.76015 moveto
0.18836 0.78444 lineto
stroke
grestore
gsave
0.85081 0.81453 moveto 0.82947 0.72891 lineto 0.82026 0.72947 lineto 0.955 0.673 0.461 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.82947 0.72891 moveto
0.83769 0.72694 lineto
stroke
grestore
gsave
0.18666 0.71008 moveto 0.27584 0.73001 lineto 0.18417 0.73523 lineto 0.732 0.702 0.822 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.18417 0.73523 moveto
0.18476 0.76015 lineto
stroke
grestore
gsave
0.18666 0.71008 moveto 0.2786 0.71667 lineto 0.27584 0.73001 lineto 0.66 0.753 0.919 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27447 0.74315 moveto
0.27584 0.73001 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.18417 0.73523 moveto
0.27584 0.73001 lineto
stroke
grestore
gsave
0.84725 0.81309 moveto 0.82026 0.72947 lineto 0.81007 0.7287 lineto 0.937 0.621 0.414 setrgbcolor
fill
grestore
gsave
0.85081 0.81453 moveto 0.82026 0.72947 lineto 0.84725 0.81309 lineto 0.847 0.505 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82947 0.72891 moveto
0.85081 0.81453 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.82026 0.72947 moveto
0.82947 0.72891 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.85081 0.81453 moveto
0.85375 0.81306 lineto
stroke
grestore
gsave
0.19221 0.68507 moveto 0.2786 0.71667 lineto 0.18666 0.71008 lineto 0.71 0.684 0.823 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.18417 0.73523 moveto
0.18666 0.71008 lineto
stroke
grestore
gsave
0.19221 0.68507 moveto 0.28283 0.70328 lineto 0.2786 0.71667 lineto 0.628 0.716 0.91 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27584 0.73001 moveto
0.2786 0.71667 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.18666 0.71008 moveto
0.2786 0.71667 lineto
stroke
grestore
gsave
0.84289 0.80867 moveto 0.81007 0.7287 lineto 0.7989 0.7267 lineto 0.914 0.56 0.352 setrgbcolor
fill
grestore
gsave
0.84725 0.81309 moveto 0.81007 0.7287 lineto 0.84289 0.80867 lineto 0.791 0.415 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82026 0.72947 moveto
0.84643 0.81054 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.81007 0.7287 moveto
0.82026 0.72947 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.84725 0.81309 moveto
0.85081 0.81453 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.84643 0.81054 moveto
0.84725 0.81309 lineto
stroke
grestore
gsave
0.20081 0.66059 moveto 0.28283 0.70328 lineto 0.19221 0.68507 lineto 0.689 0.665 0.822 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.18666 0.71008 moveto
0.19221 0.68507 lineto
stroke
grestore
gsave
0.20081 0.66059 moveto 0.28862 0.68998 lineto 0.28283 0.70328 lineto 0.601 0.679 0.896 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.2786 0.71667 moveto
0.28283 0.70328 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.19221 0.68507 moveto
0.28283 0.70328 lineto
stroke
grestore
gsave
0.75962 0.71419 moveto 0.76119 0.71577 lineto 0.77365 0.71936 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.83752 0.80129 moveto 0.79945 0.72777 lineto 0.78694 0.72385 lineto 0.885 0.487 0.268 setrgbcolor
fill
grestore
gsave
0.78675 0.72355 moveto 0.78694 0.72385 lineto 0.7989 0.7267 lineto 0.885 0.487 0.268 setrgbcolor
fill
grestore
gsave
0.7989 0.7267 moveto 0.78694 0.72385 lineto 0.79945 0.72777 lineto 0.885 0.487 0.268 setrgbcolor
fill
grestore
gsave
0.83752 0.80129 moveto 0.78893 0.72689 lineto 0.8309 0.79099 lineto 0 0 0.392 setrgbcolor
fill
grestore
gsave
0.78765 0.72494 moveto 0.78902 0.72703 lineto 0.78893 0.72689 lineto 0 0 0.392 setrgbcolor
fill
grestore
gsave
0.8309 0.79099 moveto 0.78893 0.72689 lineto 0.78902 0.72703 lineto 0 0 0.392 setrgbcolor
fill
grestore
gsave
0.8309 0.79099 moveto 0.78765 0.72494 lineto 0.78782 0.72519 lineto 0 0 0.392 setrgbcolor
fill
grestore
gsave
0.8309 0.79099 moveto 0.78694 0.72385 lineto 0.78706 0.72404 lineto 0 0 0.392 setrgbcolor
fill
grestore
gsave
0.74083 0.70644 moveto 0.74153 0.70688 lineto 0.7447 0.70812 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.8309 0.79099 moveto 0.78908 0.72712 lineto 0.7751 0.72117 lineto 0.842 0.395 0.156 setrgbcolor
fill
grestore
gsave
0.8309 0.79099 moveto 0.7751 0.72117 lineto 0.82282 0.77791 lineto 0 0 0.543 setrgbcolor
fill
grestore
gsave
0.77365 0.71936 moveto 0.7751 0.72117 lineto 0.78706 0.72404 lineto 0.842 0.395 0.156 setrgbcolor
fill
grestore
gsave
0.78694 0.72385 moveto 0.78782 0.72519 lineto 0.78765 0.72494 lineto 0 0 0.392 setrgbcolor
fill
grestore
gsave
0.78706 0.72404 moveto 0.7751 0.72117 lineto 0.78908 0.72712 lineto 0.842 0.395 0.156 setrgbcolor
fill
grestore
gsave
0.77365 0.71936 moveto 0.77539 0.72143 lineto 0.7751 0.72117 lineto 0 0 0.543 setrgbcolor
fill
grestore
gsave
0.82282 0.77791 moveto 0.7751 0.72117 lineto 0.77539 0.72143 lineto 0 0 0.543 setrgbcolor
fill
grestore
gsave
0.82178 0.77686 moveto 0.78708 0.7354 lineto 0.77015 0.7248 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.78708 0.7354 moveto 0.77539 0.72143 lineto 0.77015 0.7248 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.77015 0.7248 moveto 0.77539 0.72143 lineto 0.76119 0.71577 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.76119 0.71577 moveto 0.77539 0.72143 lineto 0.76531 0.71706 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.77401 0.71979 moveto 0.82178 0.77686 lineto 0.82121 0.77599 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.77365 0.71936 moveto 0.76119 0.71577 lineto 0.77401 0.71979 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.82282 0.77791 moveto 0.82121 0.77599 lineto 0.82178 0.77686 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.82282 0.77791 moveto 0.76033 0.7149 lineto 0.81307 0.76227 lineto 0 0.145 0.679 setrgbcolor
fill
grestore
gsave
0.75962 0.71419 moveto 0.76076 0.71521 lineto 0.76033 0.7149 lineto 0 0.145 0.679 setrgbcolor
fill
grestore
gsave
0.81307 0.76227 moveto 0.76033 0.7149 lineto 0.76076 0.71521 lineto 0 0.145 0.679 setrgbcolor
fill
grestore
gsave
0.81159 0.7611 moveto 0.76075 0.7152 lineto 0.7447 0.70812 lineto 0.66 0.105 0 setrgbcolor
fill
grestore
gsave
0.75962 0.71419 moveto 0.81159 0.7611 lineto 0.81133 0.76071 lineto 0.66 0.105 0 setrgbcolor
fill
grestore
gsave
0.81307 0.76227 moveto 0.81133 0.76071 lineto 0.81159 0.7611 lineto 0.66 0.105 0 setrgbcolor
fill
grestore
gsave
0.81307 0.76227 moveto 0.7447 0.70812 lineto 0.80146 0.74437 lineto 0 0.283 0.783 setrgbcolor
fill
grestore
gsave
0.729 0.70131 moveto 0.80022 0.74364 lineto 0.74083 0.70644 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.80032 0.74369 moveto 0.80019 0.74361 lineto 0.80022 0.74364 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.74083 0.70644 moveto 0.80022 0.74364 lineto 0.80019 0.74361 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.75962 0.71419 moveto 0.7447 0.70812 lineto 0.76075 0.7152 lineto 0.66 0.105 0 setrgbcolor
fill
grestore
gsave
0.74153 0.70688 moveto 0.7998 0.74337 lineto 0.74518 0.70843 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.80032 0.74369 moveto 0.79977 0.74334 lineto 0.7998 0.74337 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.74518 0.70843 moveto 0.7998 0.74337 lineto 0.79977 0.74334 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.7447 0.70812 moveto 0.74153 0.70688 lineto 0.74518 0.70843 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.78675 0.72355 moveto 0.78706 0.72404 lineto 0.78694 0.72385 lineto 0 0 0.392 setrgbcolor
fill
grestore
gsave
0.78675 0.72355 moveto 0.77365 0.71936 lineto 0.78706 0.72404 lineto 0.842 0.395 0.156 setrgbcolor
fill
grestore
gsave
0.77401 0.71979 moveto 0.76531 0.71706 lineto 0.77539 0.72143 lineto 0.773 0.271 0.003 setrgbcolor
fill
grestore
gsave
0.72888 0.70124 moveto 0.729 0.70131 lineto 0.74083 0.70644 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.80146 0.74437 moveto 0.80025 0.7436 lineto 0.80032 0.74369 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
0.7447 0.70812 moveto 0.80032 0.74369 lineto 0.80025 0.7436 lineto 0.478 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.79999 0.7269 moveto
0.81007 0.7287 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81007 0.7287 moveto
0.81016 0.72892 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81016 0.72892 moveto
0.81089 0.73068 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81089 0.73068 moveto
0.81195 0.73328 lineto
stroke
grestore
gsave
0.84289 0.80867 moveto 0.7989 0.7267 lineto 0.83752 0.80129 lineto 0.706 0.301 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81195 0.73328 moveto
0.84187 0.80619 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.7989 0.7267 moveto
0.79999 0.7269 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83629 0.79892 moveto
0.83752 0.80129 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80176 0.73223 moveto
0.83629 0.79892 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80041 0.72962 moveto
0.80176 0.73223 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79945 0.72777 moveto
0.80041 0.72962 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7989 0.7267 moveto
0.79945 0.72777 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.84289 0.80867 moveto
0.84725 0.81309 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.84187 0.80619 moveto
0.84289 0.80867 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78675 0.72355 moveto
0.7989 0.7267 lineto
stroke
grestore
gsave
0.21235 0.63699 moveto 0.28862 0.68998 lineto 0.20081 0.66059 lineto 0.669 0.645 0.817 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.19221 0.68507 moveto
0.20081 0.66059 lineto
stroke
grestore
gsave
0.21235 0.63699 moveto 0.29606 0.67695 lineto 0.28862 0.68998 lineto 0.579 0.644 0.879 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28283 0.70328 moveto
0.28862 0.68998 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.20081 0.66059 moveto
0.28862 0.68998 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78728 0.72436 moveto
0.78786 0.72525 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78786 0.72525 moveto
0.78908 0.72712 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78908 0.72712 moveto
0.7996 0.74318 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78675 0.72355 moveto
0.78706 0.72404 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78706 0.72404 moveto
0.78728 0.72436 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.77365 0.71936 moveto
0.78675 0.72355 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.83752 0.80129 moveto
0.84289 0.80867 lineto
stroke
grestore
gsave
0.22673 0.61463 moveto 0.29606 0.67695 lineto 0.21235 0.63699 lineto 0.651 0.626 0.811 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.20081 0.66059 moveto
0.21235 0.63699 lineto
stroke
grestore
gsave
0.22673 0.61463 moveto 0.3052 0.66438 lineto 0.29606 0.67695 lineto 0.563 0.611 0.859 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28862 0.68998 moveto
0.29606 0.67695 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.21235 0.63699 moveto
0.29606 0.67695 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77401 0.71979 moveto
0.77435 0.7202 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77435 0.7202 moveto
0.77539 0.72143 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77539 0.72143 moveto
0.78678 0.735 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77365 0.71936 moveto
0.77401 0.71979 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75962 0.71419 moveto
0.77365 0.71936 lineto
stroke
grestore
gsave
0.24378 0.59381 moveto 0.3052 0.66438 lineto 0.22673 0.61463 lineto 0.636 0.607 0.803 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.21235 0.63699 moveto
0.22673 0.61463 lineto
stroke
grestore
gsave
0.24378 0.59381 moveto 0.31611 0.65249 lineto 0.3052 0.66438 lineto 0.553 0.583 0.838 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.29606 0.67695 moveto
0.3052 0.66438 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22673 0.61463 moveto
0.3052 0.66438 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.8309 0.79099 moveto
0.83752 0.80129 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7598 0.71434 moveto
0.76076 0.71521 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76076 0.71521 moveto
0.7729 0.72613 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75962 0.71419 moveto
0.7598 0.71434 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.7447 0.70812 moveto
0.75962 0.71419 lineto
stroke
grestore
gsave
0.26333 0.57484 moveto 0.31611 0.65249 lineto 0.24378 0.59381 lineto 0.623 0.589 0.795 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.22673 0.61463 moveto
0.24378 0.59381 lineto
stroke
grestore
gsave
0.26333 0.57484 moveto 0.32877 0.6415 lineto 0.31611 0.65249 lineto 0.549 0.56 0.818 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3052 0.66438 moveto
0.31611 0.65249 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24378 0.59381 moveto
0.31611 0.65249 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7447 0.70812 moveto
0.74518 0.70843 lineto
stroke
grestore
gsave
0.28517 0.55797 moveto 0.32877 0.6415 lineto 0.26333 0.57484 lineto 0.613 0.574 0.786 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.24378 0.59381 moveto
0.26333 0.57484 lineto
stroke
grestore
gsave
0.28517 0.55797 moveto 0.34315 0.63164 lineto 0.32877 0.6415 lineto 0.551 0.544 0.8 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31611 0.65249 moveto
0.32877 0.6415 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26333 0.57484 moveto
0.32877 0.6415 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.82282 0.77791 moveto
0.8309 0.79099 lineto
stroke
grestore
gsave
0.3091 0.54345 moveto 0.34315 0.63164 lineto 0.28517 0.55797 lineto 0.606 0.561 0.778 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.26333 0.57484 moveto
0.28517 0.55797 lineto
stroke
grestore
gsave
0.3091 0.54345 moveto 0.3592 0.62312 lineto 0.34315 0.63164 lineto 0.558 0.534 0.785 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32877 0.6415 moveto
0.34315 0.63164 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28517 0.55797 moveto
0.34315 0.63164 lineto
stroke
grestore
gsave
0.78785 0.72457 moveto 0.72888 0.70124 lineto 0.71221 0.69362 lineto 0 0.342 0.7 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74518 0.70843 moveto
0.74628 0.70914 lineto
stroke
grestore
gsave
0.80146 0.74437 moveto 0.72888 0.70124 lineto 0.78785 0.72457 lineto 0.081 0.392 0.85 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72888 0.70124 moveto
0.72895 0.70126 lineto
stroke
grestore
gsave
0.33487 0.5315 moveto 0.3592 0.62312 lineto 0.3091 0.54345 lineto 0.601 0.552 0.772 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.28517 0.55797 moveto
0.3091 0.54345 lineto
stroke
grestore
gsave
0.33487 0.5315 moveto 0.37679 0.61612 lineto 0.3592 0.62312 lineto 0.568 0.531 0.773 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34315 0.63164 moveto
0.3592 0.62312 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3091 0.54345 moveto
0.3592 0.62312 lineto
stroke
grestore
gsave
0.77213 0.70332 moveto 0.71221 0.69362 lineto 0.69468 0.68536 lineto 0.039 0.534 0.88 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72895 0.70126 moveto
0.73093 0.70205 lineto
stroke
grestore
gsave
0.78785 0.72457 moveto 0.71221 0.69362 lineto 0.77213 0.70332 lineto 0.213 0.471 0.885 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.71221 0.69362 moveto
0.72888 0.70124 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78656 0.72406 moveto
0.78785 0.72457 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78586 0.72379 moveto
0.78656 0.72406 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78585 0.72378 moveto
0.78586 0.72379 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81307 0.76227 moveto
0.82282 0.77791 lineto
stroke
grestore
gsave
0.36225 0.52229 moveto 0.37679 0.61612 lineto 0.33487 0.5315 lineto 0.598 0.545 0.767 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.3091 0.54345 moveto
0.33487 0.5315 lineto
stroke
grestore
gsave
0.36225 0.52229 moveto 0.39579 0.61081 lineto 0.37679 0.61612 lineto 0.581 0.533 0.766 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3592 0.62312 moveto
0.37679 0.61612 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33487 0.5315 moveto
0.37679 0.61612 lineto
stroke
grestore
gsave
0.75423 0.6811 moveto 0.69468 0.68536 lineto 0.67631 0.67658 lineto 0.257 0.649 0.964 setrgbcolor
fill
grestore
gsave
0.77213 0.70332 moveto 0.69468 0.68536 lineto 0.75423 0.6811 lineto 0.317 0.524 0.898 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.69468 0.68536 moveto
0.71221 0.69362 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77007 0.70299 moveto
0.77213 0.70332 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71221 0.69362 moveto
0.77007 0.70299 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73093 0.70205 moveto
0.78585 0.72378 lineto
stroke
grestore
gsave
0.39096 0.51597 moveto 0.39579 0.61081 lineto 0.36225 0.52229 lineto 0.597 0.542 0.764 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.33487 0.5315 moveto
0.36225 0.52229 lineto
stroke
grestore
gsave
0.39096 0.51597 moveto 0.416 0.6073 lineto 0.39579 0.61081 lineto 0.595 0.54 0.763 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37679 0.61612 moveto
0.39579 0.61081 lineto
stroke
grestore
gsave
0.73417 0.65844 moveto 0.67631 0.67658 lineto 0.65711 0.66743 lineto 0.408 0.702 0.982 setrgbcolor
fill
grestore
gsave
0.75423 0.6811 moveto 0.67631 0.67658 lineto 0.73417 0.65844 lineto 0.396 0.557 0.896 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67631 0.67658 moveto
0.69468 0.68536 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69468 0.68536 moveto
0.75423 0.6811 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.80146 0.74437 moveto
0.81307 0.76227 lineto
stroke
grestore
gsave
0.42075 0.51268 moveto 0.416 0.6073 lineto 0.39096 0.51597 lineto 0.597 0.542 0.763 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36225 0.52229 moveto
0.39579 0.61081 lineto
stroke
grestore
gsave
0.42075 0.51268 moveto 0.43722 0.60565 lineto 0.416 0.6073 lineto 0.609 0.552 0.765 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39579 0.61081 moveto
0.416 0.6073 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39096 0.51597 moveto
0.416 0.6073 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.36225 0.52229 moveto
0.39096 0.51597 lineto
stroke
grestore
gsave
0.712 0.63589 moveto 0.65711 0.66743 lineto 0.63712 0.65809 lineto 0.505 0.717 0.967 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67631 0.67658 moveto
0.67957 0.67556 lineto
stroke
grestore
gsave
0.73417 0.65844 moveto 0.65711 0.66743 lineto 0.712 0.63589 lineto 0.455 0.576 0.886 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67957 0.67556 moveto
0.73417 0.65844 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65711 0.66743 moveto
0.67631 0.67658 lineto
stroke
grestore
gsave
0.45132 0.51247 moveto 0.43722 0.60565 lineto 0.42075 0.51268 lineto 0.598 0.544 0.765 setrgbcolor
fill
grestore
gsave
0.45132 0.51247 moveto 0.45922 0.60587 lineto 0.43722 0.60565 lineto 0.622 0.566 0.771 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.416 0.6073 moveto
0.43722 0.60565 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42075 0.51268 moveto
0.43722 0.60565 lineto
stroke
grestore
gsave
0.68785 0.61399 moveto 0.63712 0.65809 lineto 0.61637 0.64877 lineto 0.567 0.713 0.94 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65711 0.66743 moveto
0.66067 0.66538 lineto
stroke
grestore
gsave
0.712 0.63589 moveto 0.63712 0.65809 lineto 0.68785 0.61399 lineto 0.499 0.586 0.873 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63712 0.65809 moveto
0.65711 0.66743 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71006 0.63701 moveto
0.712 0.63589 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39096 0.51597 moveto
0.42075 0.51268 lineto
stroke
grestore
gsave
0.48238 0.5154 moveto 0.45922 0.60587 lineto 0.45132 0.51247 lineto 0.599 0.549 0.77 setrgbcolor
fill
grestore
gsave
0.48238 0.5154 moveto 0.48177 0.60791 lineto 0.45922 0.60587 lineto 0.633 0.584 0.781 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43722 0.60565 moveto
0.45922 0.60587 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45132 0.51247 moveto
0.45922 0.60587 lineto
stroke
grestore
gsave
0.66188 0.59325 moveto 0.61637 0.64877 lineto 0.59493 0.63973 lineto 0.605 0.701 0.911 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63712 0.65809 moveto
0.6409 0.6548 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66067 0.66538 moveto
0.66343 0.6638 lineto
stroke
grestore
gsave
0.68785 0.61399 moveto 0.61637 0.64877 lineto 0.66188 0.59325 lineto 0.532 0.589 0.857 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66343 0.6638 moveto
0.71006 0.63701 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61637 0.64877 moveto
0.63712 0.65809 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68603 0.61557 moveto
0.68785 0.61399 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.78785 0.72457 moveto
0.80146 0.74437 lineto
stroke
grestore
gsave
0.51364 0.52143 moveto 0.48177 0.60791 lineto 0.48238 0.5154 lineto 0.598 0.555 0.777 setrgbcolor
fill
grestore
gsave
0.51364 0.52143 moveto 0.50463 0.61165 lineto 0.48177 0.60791 lineto 0.641 0.603 0.795 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45922 0.60587 moveto
0.48177 0.60791 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48177 0.60791 moveto
0.48238 0.5154 lineto
stroke
grestore
gsave
0.63432 0.57415 moveto 0.59493 0.63973 lineto 0.57289 0.63123 lineto 0.629 0.683 0.882 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61637 0.64877 moveto
0.62027 0.64402 lineto
stroke
grestore
gsave
0.66188 0.59325 moveto 0.59493 0.63973 lineto 0.63432 0.57415 lineto 0.556 0.587 0.841 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59493 0.63973 moveto
0.61637 0.64877 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6602 0.5953 moveto
0.66188 0.59325 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6409 0.6548 moveto
0.68603 0.61557 lineto
stroke
grestore
gsave
0.54477 0.5305 moveto 0.50463 0.61165 lineto 0.51364 0.52143 lineto 0.596 0.562 0.786 setrgbcolor
fill
grestore
gsave
0.54477 0.5305 moveto 0.52757 0.61693 lineto 0.50463 0.61165 lineto 0.646 0.623 0.812 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48177 0.60791 moveto
0.50463 0.61165 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50463 0.61165 moveto
0.51364 0.52143 lineto
stroke
grestore
gsave
0.60542 0.5571 moveto 0.57289 0.63123 lineto 0.55039 0.62354 lineto 0.641 0.664 0.856 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59493 0.63973 moveto
0.59883 0.63323 lineto
stroke
grestore
gsave
0.63432 0.57415 moveto 0.57289 0.63123 lineto 0.60542 0.5571 lineto 0.573 0.583 0.825 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57289 0.63123 moveto
0.59493 0.63973 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63288 0.57655 moveto
0.63432 0.57415 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62027 0.64402 moveto
0.6602 0.5953 lineto
stroke
grestore
gsave
0.57547 0.54246 moveto 0.52757 0.61693 lineto 0.54477 0.5305 lineto 0.592 0.569 0.798 setrgbcolor
fill
grestore
gsave
0.57547 0.54246 moveto 0.55039 0.62354 lineto 0.52757 0.61693 lineto 0.647 0.643 0.832 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50463 0.61165 moveto
0.52757 0.61693 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52757 0.61693 moveto
0.54477 0.5305 lineto
stroke
grestore
gsave
0.60542 0.5571 moveto 0.55039 0.62354 lineto 0.57547 0.54246 lineto 0.584 0.577 0.811 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57453 0.54551 moveto
0.57547 0.54246 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55039 0.62354 moveto
0.57453 0.54551 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52757 0.61693 moveto
0.55039 0.62354 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55039 0.62354 moveto
0.57289 0.63123 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57289 0.63123 moveto
0.57666 0.62264 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57666 0.62264 moveto
0.60421 0.55985 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60421 0.55985 moveto
0.60542 0.5571 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59883 0.63323 moveto
0.63288 0.57655 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42075 0.51268 moveto
0.45132 0.51247 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.77213 0.70332 moveto
0.78785 0.72457 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45132 0.51247 moveto
0.48238 0.5154 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48238 0.5154 moveto
0.51364 0.52143 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.75423 0.6811 moveto
0.77213 0.70332 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51364 0.52143 moveto
0.54477 0.5305 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.73417 0.65844 moveto
0.75423 0.6811 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54477 0.5305 moveto
0.57547 0.54246 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.712 0.63589 moveto
0.73417 0.65844 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57547 0.54246 moveto
0.60542 0.5571 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68785 0.61399 moveto
0.712 0.63589 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60542 0.5571 moveto
0.63432 0.57415 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.66188 0.59325 moveto
0.68785 0.61399 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63432 0.57415 moveto
0.66188 0.59325 lineto
stroke
grestore
gsave
0.002 setlinewidth
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
grestore
gsave
grestore
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; nowordwrap; ]
No Input Form was saved for this expression.

















;[o]
-Graphics3D-
:[font = input; startGroup; nowordwrap; ]
Show[%,ViewPoint->{3,-.4,.8},Boxed->False]
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 288; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.03857 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.107818 1.11329 0.0278321 1.11329 [
[ 0 0 0 0 ]
[ 1 1.03857 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 1.03857 lineto
0 1.03857 lineto
closepath
clip
newpath
gsave
0.59269 0.41819 moveto 0.55834 0.43862 lineto 0.56879 0.40275 lineto 0.807 0.411 0.302 setrgbcolor
fill
grestore
gsave
0.59269 0.41819 moveto 0.57122 0.45649 lineto 0.55834 0.43862 lineto 0.917 0.616 0.459 setrgbcolor
fill
grestore
gsave
0.61566 0.435 moveto 0.57122 0.45649 lineto 0.59269 0.41819 lineto 0.81 0.461 0.397 setrgbcolor
fill
grestore
gsave
0.56879 0.40275 moveto 0.54495 0.4213 lineto 0.54425 0.38857 lineto 0.786 0.332 0.169 setrgbcolor
fill
grestore
gsave
0.56879 0.40275 moveto 0.55834 0.43862 lineto 0.54495 0.4213 lineto 0.927 0.571 0.332 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.56879 0.40275 moveto
0.59269 0.41819 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55834 0.43862 moveto
0.56879 0.40275 lineto
stroke
grestore
gsave
0.61566 0.435 moveto 0.58349 0.47485 lineto 0.57122 0.45649 lineto 0.893 0.635 0.541 setrgbcolor
fill
grestore
gsave
0.63739 0.45323 moveto 0.58349 0.47485 lineto 0.61566 0.435 lineto 0.802 0.493 0.466 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59201 0.4194 moveto
0.59269 0.41819 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59269 0.41819 moveto
0.61566 0.435 lineto
stroke
grestore
gsave
0.54425 0.38857 moveto 0.53114 0.40457 lineto 0.51938 0.37555 lineto 0.728 0.212 0 setrgbcolor
fill
grestore
gsave
0.54425 0.38857 moveto 0.54495 0.4213 lineto 0.53114 0.40457 lineto 0.895 0.473 0.133 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.54425 0.38857 moveto
0.56879 0.40275 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54425 0.38857 moveto
0.54495 0.4213 lineto
stroke
grestore
gsave
0.63739 0.45323 moveto 0.59507 0.49368 lineto 0.58349 0.47485 lineto 0.866 0.64 0.595 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58349 0.47485 moveto
0.58426 0.47391 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57122 0.45649 moveto
0.59201 0.4194 lineto
stroke
grestore
gsave
0.65761 0.4729 moveto 0.59507 0.49368 lineto 0.63739 0.45323 lineto 0.79 0.512 0.515 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61465 0.43625 moveto
0.61566 0.435 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61566 0.435 moveto
0.63739 0.45323 lineto
stroke
grestore
gsave
0.51938 0.37555 moveto 0.51703 0.38847 lineto 0.49449 0.36356 lineto 0.613 0.044 0 setrgbcolor
fill
grestore
gsave
0.51938 0.37555 moveto 0.53114 0.40457 lineto 0.51703 0.38847 lineto 0.772 0.294 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.51938 0.37555 moveto
0.54425 0.38857 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51938 0.37555 moveto
0.53114 0.40457 lineto
stroke
grestore
gsave
0.65761 0.4729 moveto 0.60587 0.51293 lineto 0.59507 0.49368 lineto 0.838 0.638 0.632 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59507 0.49368 moveto
0.59577 0.49302 lineto
stroke
grestore
gsave
0.67604 0.49402 moveto 0.60587 0.51293 lineto 0.65761 0.4729 lineto 0.776 0.522 0.552 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58426 0.47391 moveto
0.61465 0.43625 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59577 0.49302 moveto
0.63607 0.45449 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63607 0.45449 moveto
0.63739 0.45323 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63739 0.45323 moveto
0.65761 0.4729 lineto
stroke
grestore
gsave
0.67604 0.49402 moveto 0.61578 0.53257 lineto 0.60587 0.51293 lineto 0.812 0.631 0.657 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60587 0.51293 moveto
0.60733 0.5118 lineto
stroke
grestore
gsave
0.69245 0.51654 moveto 0.61578 0.53257 lineto 0.67604 0.49402 lineto 0.761 0.527 0.579 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60733 0.5118 moveto
0.65601 0.47414 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65601 0.47414 moveto
0.65761 0.4729 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.65761 0.4729 moveto
0.67604 0.49402 lineto
stroke
grestore
gsave
0.49449 0.36356 moveto 0.50274 0.37304 lineto 0.46987 0.35247 lineto 0.435 0 0 setrgbcolor
fill
grestore
gsave
0.49449 0.36356 moveto 0.51703 0.38847 lineto 0.50274 0.37304 lineto 0.53 0.041 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.49449 0.36356 moveto
0.51938 0.37555 lineto
stroke
grestore
gsave
0.69245 0.51654 moveto 0.62469 0.55257 lineto 0.61578 0.53257 lineto 0.787 0.62 0.674 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61578 0.53257 moveto
0.61583 0.53254 lineto
stroke
grestore
gsave
0.7066 0.5404 moveto 0.62469 0.55257 lineto 0.69245 0.51654 lineto 0.746 0.528 0.599 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61583 0.53254 moveto
0.6742 0.4952 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6742 0.4952 moveto
0.67604 0.49402 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.67604 0.49402 moveto
0.69245 0.51654 lineto
stroke
grestore
gsave
0.46987 0.35247 moveto 0.48845 0.3583 lineto 0.44583 0.34211 lineto 0 0.349 0.7 setrgbcolor
fill
grestore
gsave
0.46987 0.35247 moveto 0.50274 0.37304 lineto 0.48845 0.3583 lineto 0 0.207 0.712 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.49282 0.36281 moveto
0.49449 0.36356 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46987 0.35247 moveto
0.47096 0.35315 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51563 0.38693 moveto
0.51703 0.38847 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49449 0.36356 moveto
0.51563 0.38693 lineto
stroke
grestore
gsave
0.7066 0.5404 moveto 0.63245 0.57289 lineto 0.62469 0.55257 lineto 0.764 0.608 0.685 setrgbcolor
fill
grestore
gsave
0.71829 0.56548 moveto 0.63245 0.57289 lineto 0.7066 0.5404 lineto 0.731 0.526 0.614 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62469 0.55257 moveto
0.6904 0.51763 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6904 0.51763 moveto
0.69245 0.51654 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69245 0.51654 moveto
0.7066 0.5404 lineto
stroke
grestore
gsave
0.44583 0.34211 moveto 0.47433 0.34429 lineto 0.42265 0.33233 lineto 0 0.5 0.841 setrgbcolor
fill
grestore
gsave
0.44583 0.34211 moveto 0.48845 0.3583 lineto 0.47433 0.34429 lineto 0.008 0.388 0.847 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.44583 0.34211 moveto
0.46987 0.35247 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44583 0.34211 moveto
0.44726 0.34265 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50041 0.37158 moveto
0.50274 0.37304 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47096 0.35315 moveto
0.50041 0.37158 lineto
stroke
grestore
gsave
0.71829 0.56548 moveto 0.63893 0.59348 lineto 0.63245 0.57289 lineto 0.742 0.594 0.692 setrgbcolor
fill
grestore
gsave
0.72737 0.59163 moveto 0.63893 0.59348 lineto 0.71829 0.56548 lineto 0.716 0.521 0.625 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63245 0.57289 moveto
0.70438 0.54137 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70438 0.54137 moveto
0.7066 0.5404 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7066 0.5404 moveto
0.71829 0.56548 lineto
stroke
grestore
gsave
0.72737 0.59163 moveto 0.64399 0.61428 lineto 0.63893 0.59348 lineto 0.722 0.579 0.694 setrgbcolor
fill
grestore
gsave
0.73369 0.61868 moveto 0.64399 0.61428 lineto 0.72737 0.59163 lineto 0.703 0.515 0.632 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63893 0.59348 moveto
0.71597 0.5663 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71597 0.5663 moveto
0.71829 0.56548 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71829 0.56548 moveto
0.72737 0.59163 lineto
stroke
grestore
gsave
0.42265 0.33233 moveto 0.46059 0.33099 lineto 0.40062 0.32297 lineto 0.133 0.604 0.921 setrgbcolor
fill
grestore
gsave
0.42265 0.33233 moveto 0.47433 0.34429 lineto 0.46059 0.33099 lineto 0.183 0.507 0.911 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.42265 0.33233 moveto
0.44583 0.34211 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42265 0.33233 moveto
0.42442 0.33273 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42442 0.33273 moveto
0.47433 0.34429 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48499 0.35699 moveto
0.48845 0.3583 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44726 0.34265 moveto
0.48499 0.35699 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62469 0.55257 moveto
0.63245 0.57289 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63245 0.57289 moveto
0.63893 0.59348 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61578 0.53257 moveto
0.62469 0.55257 lineto
stroke
grestore
gsave
0.73369 0.61868 moveto 0.64746 0.63522 lineto 0.64399 0.61428 lineto 0.703 0.563 0.693 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63893 0.59348 moveto
0.64399 0.61428 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64399 0.61428 moveto
0.72737 0.59163 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60587 0.51293 moveto
0.61578 0.53257 lineto
stroke
grestore
gsave
0.73716 0.64642 moveto 0.64746 0.63522 lineto 0.73369 0.61868 lineto 0.69 0.508 0.637 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.72737 0.59163 moveto
0.73369 0.61868 lineto
stroke
grestore
gsave
0.73716 0.64642 moveto 0.6492 0.65618 lineto 0.64746 0.63522 lineto 0.686 0.546 0.689 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64399 0.61428 moveto
0.64746 0.63522 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64746 0.63522 moveto
0.73369 0.61868 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59507 0.49368 moveto
0.60587 0.51293 lineto
stroke
grestore
gsave
0.7377 0.67459 moveto 0.6492 0.65618 lineto 0.73716 0.64642 lineto 0.678 0.501 0.639 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.73369 0.61868 moveto
0.73716 0.64642 lineto
stroke
grestore
gsave
0.7377 0.67459 moveto 0.6491 0.67704 lineto 0.6492 0.65618 lineto 0.672 0.529 0.682 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64746 0.63522 moveto
0.6492 0.65618 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6492 0.65618 moveto
0.73716 0.64642 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58349 0.47485 moveto
0.59507 0.49368 lineto
stroke
grestore
gsave
0.73527 0.70295 moveto 0.6491 0.67704 lineto 0.7377 0.67459 lineto 0.668 0.494 0.64 setrgbcolor
fill
grestore
gsave
0.73527 0.70295 moveto 0.64705 0.69765 lineto 0.6491 0.67704 lineto 0.66 0.514 0.674 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6491 0.67704 moveto
0.6492 0.65618 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6491 0.67704 moveto
0.7377 0.67459 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57122 0.45649 moveto
0.58349 0.47485 lineto
stroke
grestore
gsave
0.72989 0.73121 moveto 0.64705 0.69765 lineto 0.73527 0.70295 lineto 0.66 0.487 0.639 setrgbcolor
fill
grestore
gsave
0.72989 0.73121 moveto 0.64298 0.71784 lineto 0.64705 0.69765 lineto 0.652 0.499 0.664 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64705 0.69765 moveto
0.6491 0.67704 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64705 0.69765 moveto
0.73527 0.70295 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.73716 0.64642 moveto
0.7377 0.67459 lineto
stroke
grestore
gsave
0.72159 0.75906 moveto 0.64298 0.71784 lineto 0.72989 0.73121 lineto 0.654 0.481 0.638 setrgbcolor
fill
grestore
gsave
0.72159 0.75906 moveto 0.63686 0.73742 lineto 0.64298 0.71784 lineto 0.647 0.488 0.653 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64298 0.71784 moveto
0.64705 0.69765 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64298 0.71784 moveto
0.72989 0.73121 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55834 0.43862 moveto
0.57122 0.45649 lineto
stroke
grestore
gsave
0.71044 0.7862 moveto 0.63686 0.73742 lineto 0.72159 0.75906 lineto 0.65 0.478 0.637 setrgbcolor
fill
grestore
gsave
0.71044 0.7862 moveto 0.6287 0.7562 lineto 0.63686 0.73742 lineto 0.646 0.479 0.643 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63686 0.73742 moveto
0.64298 0.71784 lineto
stroke
grestore
gsave
0.40062 0.32297 moveto 0.44745 0.31841 lineto 0.37999 0.31388 lineto 0.249 0.672 0.963 setrgbcolor
fill
grestore
gsave
0.40062 0.32297 moveto 0.46059 0.33099 lineto 0.44745 0.31841 lineto 0.303 0.586 0.942 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40062 0.32297 moveto
0.42265 0.33233 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40062 0.32297 moveto
0.46059 0.33099 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54495 0.4213 moveto
0.55834 0.43862 lineto
stroke
grestore
gsave
0.69653 0.81231 moveto 0.6287 0.7562 lineto 0.71044 0.7862 lineto 0.648 0.476 0.636 setrgbcolor
fill
grestore
gsave
0.69653 0.81231 moveto 0.61855 0.77399 lineto 0.6287 0.7562 lineto 0.65 0.475 0.634 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63686 0.73742 moveto
0.72159 0.75906 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6287 0.7562 moveto
0.63686 0.73742 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.73527 0.70295 moveto
0.7377 0.67459 lineto
stroke
grestore
gsave
0.68002 0.83709 moveto 0.61855 0.77399 lineto 0.69653 0.81231 lineto 0.649 0.476 0.636 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69726 0.78136 moveto
0.71044 0.7862 lineto
stroke
grestore
gsave
0.68002 0.83709 moveto 0.6065 0.79059 lineto 0.61855 0.77399 lineto 0.657 0.476 0.628 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6287 0.7562 moveto
0.69726 0.78136 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61855 0.77399 moveto
0.6287 0.7562 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.53114 0.40457 moveto
0.54495 0.4213 lineto
stroke
grestore
gsave
0.66106 0.86023 moveto 0.6065 0.79059 lineto 0.68002 0.83709 lineto 0.652 0.479 0.638 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66287 0.82624 moveto
0.68002 0.83709 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6919 0.81004 moveto
0.69653 0.81231 lineto
stroke
grestore
gsave
0.66106 0.86023 moveto 0.59269 0.80585 lineto 0.6065 0.79059 lineto 0.668 0.482 0.624 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6065 0.79059 moveto
0.61855 0.77399 lineto
stroke
grestore
gsave
0.63985 0.88145 moveto 0.59269 0.80585 lineto 0.66106 0.86023 lineto 0.656 0.485 0.641 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65157 0.85268 moveto
0.66106 0.86023 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69178 0.80998 moveto
0.6919 0.81004 lineto
stroke
grestore
gsave
0.63985 0.88145 moveto 0.57727 0.81963 lineto 0.59269 0.80585 lineto 0.681 0.493 0.625 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61855 0.77399 moveto
0.69178 0.80998 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59269 0.80585 moveto
0.6065 0.79059 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72989 0.73121 moveto
0.73527 0.70295 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51703 0.38847 moveto
0.53114 0.40457 lineto
stroke
grestore
gsave
0.61661 0.90048 moveto 0.57727 0.81963 lineto 0.63985 0.88145 lineto 0.663 0.494 0.646 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61875 0.82657 moveto
0.65157 0.85268 lineto
stroke
grestore
gsave
0.61661 0.90048 moveto 0.56043 0.83182 lineto 0.57727 0.81963 lineto 0.696 0.508 0.628 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6065 0.79059 moveto
0.66287 0.82624 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59269 0.80585 moveto
0.61875 0.82657 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57727 0.81963 moveto
0.59269 0.80585 lineto
stroke
grestore
gsave
0.59159 0.91711 moveto 0.56043 0.83182 lineto 0.61661 0.90048 lineto 0.67 0.504 0.652 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59427 0.87318 moveto
0.61661 0.90048 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63732 0.87894 moveto
0.63985 0.88145 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60863 0.85061 moveto
0.63732 0.87894 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59332 0.83548 moveto
0.60863 0.85061 lineto
stroke
grestore
gsave
0.59159 0.91711 moveto 0.54238 0.84238 lineto 0.56043 0.83182 lineto 0.712 0.526 0.636 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57727 0.81963 moveto
0.59332 0.83548 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.56043 0.83182 moveto
0.57727 0.81963 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72159 0.75906 moveto
0.72989 0.73121 lineto
stroke
grestore
gsave
0.37999 0.31388 moveto 0.43515 0.30654 lineto 0.36104 0.30493 lineto 0.333 0.719 0.983 setrgbcolor
fill
grestore
gsave
0.37999 0.31388 moveto 0.44745 0.31841 lineto 0.43515 0.30654 lineto 0.386 0.642 0.958 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.37999 0.31388 moveto
0.40062 0.32297 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37999 0.31388 moveto
0.44745 0.31841 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50274 0.37304 moveto
0.51703 0.38847 lineto
stroke
grestore
gsave
0.56503 0.93114 moveto 0.54238 0.84238 lineto 0.59159 0.91711 lineto 0.677 0.517 0.661 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58055 0.85641 moveto
0.59427 0.87318 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57133 0.84514 moveto
0.58055 0.85641 lineto
stroke
grestore
gsave
0.56503 0.93114 moveto 0.52332 0.85129 lineto 0.54238 0.84238 lineto 0.728 0.548 0.647 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56043 0.83182 moveto
0.57133 0.84514 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54238 0.84238 moveto
0.56043 0.83182 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71044 0.7862 moveto
0.72159 0.75906 lineto
stroke
grestore
gsave
0.53723 0.94243 moveto 0.52332 0.85129 lineto 0.56503 0.93114 lineto 0.685 0.532 0.672 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58973 0.9143 moveto
0.59159 0.91711 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55616 0.86331 moveto
0.58973 0.9143 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54238 0.84238 moveto
0.55616 0.86331 lineto
stroke
grestore
gsave
0.53723 0.94243 moveto 0.50347 0.85856 lineto 0.52332 0.85129 lineto 0.743 0.572 0.662 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52332 0.85129 moveto
0.54238 0.84238 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52332 0.85129 moveto
0.53292 0.86966 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48845 0.3583 moveto
0.50274 0.37304 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69653 0.81231 moveto
0.71044 0.7862 lineto
stroke
grestore
gsave
0.50847 0.95087 moveto 0.50347 0.85856 lineto 0.53723 0.94243 lineto 0.692 0.548 0.685 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5635 0.92821 moveto
0.56503 0.93114 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53292 0.86966 moveto
0.5635 0.92821 lineto
stroke
grestore
gsave
0.50847 0.95087 moveto 0.48303 0.86426 lineto 0.50347 0.85856 lineto 0.757 0.597 0.68 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50347 0.85856 moveto
0.52332 0.85129 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50347 0.85856 moveto
0.50721 0.86784 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68002 0.83709 moveto
0.69653 0.81231 lineto
stroke
grestore
gsave
0.47902 0.95641 moveto 0.48303 0.86426 lineto 0.50847 0.95087 lineto 0.699 0.564 0.7 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48547 0.87255 moveto
0.50847 0.95087 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53602 0.93941 moveto
0.53723 0.94243 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50721 0.86784 moveto
0.53602 0.93941 lineto
stroke
grestore
gsave
0.47902 0.95641 moveto 0.46219 0.86849 lineto 0.48303 0.86426 lineto 0.768 0.624 0.7 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48303 0.86426 moveto
0.50347 0.85856 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48303 0.86426 moveto
0.48547 0.87255 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.66106 0.86023 moveto
0.68002 0.83709 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47433 0.34429 moveto
0.48845 0.3583 lineto
stroke
grestore
gsave
0.44919 0.95907 moveto 0.46219 0.86849 lineto 0.47902 0.95641 lineto 0.703 0.582 0.716 setrgbcolor
fill
grestore
gsave
0.44919 0.95907 moveto 0.44112 0.87136 lineto 0.46219 0.86849 lineto 0.778 0.652 0.723 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46219 0.86849 moveto
0.48303 0.86426 lineto
stroke
grestore
gsave
0.41925 0.9589 moveto 0.44112 0.87136 lineto 0.44919 0.95907 lineto 0.707 0.599 0.734 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.44919 0.95907 moveto
0.47902 0.95641 lineto
stroke
grestore
gsave
0.41925 0.9589 moveto 0.41997 0.87301 lineto 0.44112 0.87136 lineto 0.785 0.68 0.748 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44112 0.87136 moveto
0.44919 0.95907 lineto
stroke
grestore
gsave
0.38946 0.95602 moveto 0.41997 0.87301 lineto 0.41925 0.9589 lineto 0.707 0.616 0.753 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.41925 0.9589 moveto
0.44919 0.95907 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46219 0.86849 moveto
0.47902 0.95641 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47902 0.95641 moveto
0.50847 0.95087 lineto
stroke
grestore
gsave
0.38946 0.95602 moveto 0.39885 0.87357 lineto 0.41997 0.87301 lineto 0.788 0.709 0.776 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41925 0.9589 moveto
0.41997 0.87301 lineto
stroke
grestore
gsave
0.36009 0.95058 moveto 0.39885 0.87357 lineto 0.38946 0.95602 lineto 0.706 0.634 0.774 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.38946 0.95602 moveto
0.41925 0.9589 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.50847 0.95087 moveto
0.53723 0.94243 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63985 0.88145 moveto
0.66106 0.86023 lineto
stroke
grestore
gsave
0.36104 0.30493 moveto 0.42395 0.29537 lineto 0.34399 0.29598 lineto 0.393 0.751 0.993 setrgbcolor
fill
grestore
gsave
0.36104 0.30493 moveto 0.43515 0.30654 lineto 0.42395 0.29537 lineto 0.444 0.685 0.967 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36104 0.30493 moveto
0.37999 0.31388 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36104 0.30493 moveto
0.43515 0.30654 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53723 0.94243 moveto
0.56503 0.93114 lineto
stroke
grestore
gsave
0.36009 0.95058 moveto 0.37788 0.87318 lineto 0.39885 0.87357 lineto 0.787 0.738 0.807 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38946 0.95602 moveto
0.39885 0.87357 lineto
stroke
grestore
gsave
0.33136 0.94279 moveto 0.37788 0.87318 lineto 0.36009 0.95058 lineto 0.7 0.65 0.796 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36009 0.95058 moveto
0.38946 0.95602 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61661 0.90048 moveto
0.63985 0.88145 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56503 0.93114 moveto
0.59159 0.91711 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44112 0.87136 moveto
0.46219 0.86849 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59159 0.91711 moveto
0.61661 0.90048 lineto
stroke
grestore
gsave
0.33136 0.94279 moveto 0.35715 0.87194 lineto 0.37788 0.87318 lineto 0.78 0.767 0.841 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36009 0.95058 moveto
0.37788 0.87318 lineto
stroke
grestore
gsave
0.30349 0.93288 moveto 0.35715 0.87194 lineto 0.33136 0.94279 lineto 0.691 0.665 0.82 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.33136 0.94279 moveto
0.36009 0.95058 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46059 0.33099 moveto
0.47433 0.34429 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41997 0.87301 moveto
0.44112 0.87136 lineto
stroke
grestore
gsave
0.30349 0.93288 moveto 0.33673 0.86997 lineto 0.35715 0.87194 lineto 0.765 0.796 0.878 setrgbcolor
fill
grestore
gsave
0.27665 0.92113 moveto 0.33673 0.86997 lineto 0.30349 0.93288 lineto 0.676 0.678 0.845 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33136 0.94279 moveto
0.3322 0.94049 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.30349 0.93288 moveto
0.33136 0.94279 lineto
stroke
grestore
gsave
0.27665 0.92113 moveto 0.31672 0.86734 lineto 0.33673 0.86997 lineto 0.739 0.822 0.916 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33561 0.87209 moveto
0.33673 0.86997 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3322 0.94049 moveto
0.35715 0.87194 lineto
stroke
grestore
gsave
0.25102 0.90782 moveto 0.31672 0.86734 lineto 0.27665 0.92113 lineto 0.654 0.689 0.871 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30349 0.93288 moveto
0.30455 0.93086 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.27665 0.92113 moveto
0.30349 0.93288 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39885 0.87357 moveto
0.41997 0.87301 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44745 0.31841 moveto
0.46059 0.33099 lineto
stroke
grestore
gsave
0.34399 0.29598 moveto 0.41408 0.28487 lineto 0.3291 0.28692 lineto 0.435 0.774 0.997 setrgbcolor
fill
grestore
gsave
0.34399 0.29598 moveto 0.42395 0.29537 lineto 0.41408 0.28487 lineto 0.485 0.721 0.975 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.34399 0.29598 moveto
0.36104 0.30493 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34399 0.29598 moveto
0.42395 0.29537 lineto
stroke
grestore
gsave
0.25102 0.90782 moveto 0.29719 0.86414 lineto 0.31672 0.86734 lineto 0.694 0.841 0.954 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31566 0.86878 moveto
0.31672 0.86734 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30455 0.93086 moveto
0.33561 0.87209 lineto
stroke
grestore
gsave
0.22673 0.89329 moveto 0.29719 0.86414 lineto 0.25102 0.90782 lineto 0.623 0.696 0.897 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27665 0.92113 moveto
0.27792 0.91943 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.25102 0.90782 moveto
0.27665 0.92113 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37788 0.87318 moveto
0.39885 0.87357 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43515 0.30654 moveto
0.44745 0.31841 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35715 0.87194 moveto
0.37788 0.87318 lineto
stroke
grestore
gsave
0.22673 0.89329 moveto 0.27824 0.86042 lineto 0.29719 0.86414 lineto 0.622 0.848 0.985 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2963 0.86499 moveto
0.29719 0.86414 lineto
stroke
grestore
gsave
0.2039 0.87784 moveto 0.27824 0.86042 lineto 0.22673 0.89329 lineto 0.581 0.696 0.921 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25102 0.90782 moveto
0.25246 0.90646 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.22673 0.89329 moveto
0.25102 0.90782 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.33673 0.86997 moveto
0.35715 0.87194 lineto
stroke
grestore
gsave
0.2039 0.87784 moveto 0.25997 0.85624 lineto 0.27824 0.86042 lineto 0.514 0.829 1 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27654 0.8615 moveto
0.27824 0.86042 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27792 0.91943 moveto
0.31566 0.86878 lineto
stroke
grestore
gsave
0.18262 0.8618 moveto 0.25997 0.85624 lineto 0.2039 0.87784 lineto 0.525 0.688 0.942 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25246 0.90646 moveto
0.2963 0.86499 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22673 0.89329 moveto
0.22832 0.89227 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2039 0.87784 moveto
0.22673 0.89329 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42395 0.29537 moveto
0.43515 0.30654 lineto
stroke
grestore
gsave
0.3291 0.28692 moveto 0.40577 0.27506 lineto 0.31659 0.27766 lineto 0.464 0.791 0.999 setrgbcolor
fill
grestore
gsave
0.3291 0.28692 moveto 0.41408 0.28487 lineto 0.40577 0.27506 lineto 0.511 0.751 0.982 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.3291 0.28692 moveto
0.34399 0.29598 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3291 0.28692 moveto
0.41408 0.28487 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31672 0.86734 moveto
0.33673 0.86997 lineto
stroke
grestore
gsave
0.18262 0.8618 moveto 0.24249 0.85167 lineto 0.25997 0.85624 lineto 0.362 0.772 0.981 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25874 0.85672 moveto
0.25997 0.85624 lineto
stroke
grestore
gsave
0.16299 0.84551 moveto 0.24249 0.85167 lineto 0.18262 0.8618 lineto 0.452 0.668 0.955 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22832 0.89227 moveto
0.27654 0.8615 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2039 0.87784 moveto
0.2056 0.87718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2056 0.87718 moveto
0.25874 0.85672 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.18262 0.8618 moveto
0.2039 0.87784 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.18262 0.8618 moveto
0.24188 0.85177 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41408 0.28487 moveto
0.42395 0.29537 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.29719 0.86414 moveto
0.31672 0.86734 lineto
stroke
grestore
gsave
0.31659 0.27766 moveto 0.39923 0.26592 lineto 0.30666 0.26814 lineto 0.482 0.803 1 setrgbcolor
fill
grestore
gsave
0.31659 0.27766 moveto 0.40577 0.27506 lineto 0.39923 0.26592 lineto 0.525 0.776 0.989 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.31659 0.27766 moveto
0.3291 0.28692 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31659 0.27766 moveto
0.40577 0.27506 lineto
stroke
grestore
gsave
0.16299 0.84551 moveto 0.22594 0.84678 lineto 0.24249 0.85167 lineto 0.173 0.667 0.918 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24188 0.85177 moveto
0.24249 0.85167 lineto
stroke
grestore
gsave
0.14507 0.82928 moveto 0.22594 0.84678 lineto 0.16299 0.84551 lineto 0.362 0.632 0.957 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.16299 0.84551 moveto
0.18262 0.8618 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27824 0.86042 moveto
0.29719 0.86414 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40577 0.27506 moveto
0.41408 0.28487 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.25997 0.85624 moveto
0.27824 0.86042 lineto
stroke
grestore
gsave
0.14507 0.82928 moveto 0.21047 0.84166 lineto 0.22594 0.84678 lineto 0 0.525 0.813 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.16299 0.84551 moveto
0.22594 0.84678 lineto
stroke
grestore
gsave
0.12893 0.81343 moveto 0.21047 0.84166 lineto 0.14507 0.82928 lineto 0.256 0.58 0.943 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.14507 0.82928 moveto
0.16299 0.84551 lineto
stroke
grestore
gsave
0.30666 0.26814 moveto 0.39465 0.25748 lineto 0.29952 0.25833 lineto 0.491 0.81 1 setrgbcolor
fill
grestore
gsave
0.30666 0.26814 moveto 0.39923 0.26592 lineto 0.39465 0.25748 lineto 0.525 0.796 0.995 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.30666 0.26814 moveto
0.31659 0.27766 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30666 0.26814 moveto
0.39923 0.26592 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39923 0.26592 moveto
0.40577 0.27506 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.24249 0.85167 moveto
0.25997 0.85624 lineto
stroke
grestore
gsave
0.12893 0.81343 moveto 0.19623 0.83642 lineto 0.21047 0.84166 lineto 0 0.373 0.691 setrgbcolor
fill
grestore
gsave
0.11463 0.79825 moveto 0.19623 0.83642 lineto 0.12893 0.81343 lineto 0.141 0.513 0.913 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.14507 0.82928 moveto
0.14697 0.82964 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.12893 0.81343 moveto
0.14507 0.82928 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.22594 0.84678 moveto
0.24249 0.85167 lineto
stroke
grestore
gsave
0.29952 0.25833 moveto 0.39217 0.24978 lineto 0.29535 0.24823 lineto 0.494 0.813 1 setrgbcolor
fill
grestore
gsave
0.29952 0.25833 moveto 0.39465 0.25748 lineto 0.39217 0.24978 lineto 0.511 0.809 0.999 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.29952 0.25833 moveto
0.30666 0.26814 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29952 0.25833 moveto
0.39465 0.25748 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39465 0.25748 moveto
0.39923 0.26592 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.21047 0.84166 moveto
0.22594 0.84678 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39217 0.24978 moveto
0.39465 0.25748 lineto
stroke
grestore
gsave
0.11463 0.79825 moveto 0.18339 0.83119 lineto 0.19623 0.83642 lineto 0.352 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.20822 0.84123 moveto
0.21047 0.84166 lineto
stroke
grestore
gsave
0.10223 0.78405 moveto 0.18339 0.83119 lineto 0.11463 0.79825 lineto 0.025 0.435 0.868 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.14697 0.82964 moveto
0.20822 0.84123 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.12893 0.81343 moveto
0.13084 0.81408 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.11463 0.79825 moveto
0.12893 0.81343 lineto
stroke
grestore
gsave
0.29218 0.25278 moveto 0.38818 0.25771 lineto 0.39025 0.24952 lineto 0.533 0.812 0.997 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.29733 0.25304 moveto
0.29952 0.25833 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.19623 0.83642 moveto
0.21047 0.84166 lineto
stroke
grestore
gsave
0.29218 0.25278 moveto 0.39025 0.24952 lineto 0.29455 0.23967 lineto 0.556 0.806 0.992 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29218 0.25278 moveto
0.38818 0.25771 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39019 0.24975 moveto
0.39217 0.24978 lineto
stroke
grestore
gsave
0.10223 0.78405 moveto 0.17213 0.82611 lineto 0.18339 0.83119 lineto 0.452 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.19329 0.83541 moveto
0.19623 0.83642 lineto
stroke
grestore
gsave
0.09179 0.77109 moveto 0.17213 0.82611 lineto 0.10223 0.78405 lineto 0 0.357 0.816 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.13084 0.81408 moveto
0.19329 0.83541 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.11463 0.79825 moveto
0.11653 0.79916 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.11653 0.79916 moveto
0.16954 0.82455 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.10223 0.78405 moveto
0.11463 0.79825 lineto
stroke
grestore
gsave
0.29455 0.23967 moveto 0.39025 0.24952 lineto 0.39458 0.2422 lineto 0.495 0.805 1 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.38818 0.25771 moveto
0.39025 0.24952 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.18339 0.83119 moveto
0.19623 0.83642 lineto
stroke
grestore
gsave
0.29455 0.23967 moveto 0.39458 0.2422 lineto 0.30027 0.22645 lineto 0.55 0.798 0.991 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.29218 0.25278 moveto
0.29455 0.23967 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29455 0.23967 moveto
0.39025 0.24952 lineto
stroke
grestore
gsave
0.30027 0.22645 moveto 0.39458 0.2422 lineto 0.40113 0.23586 lineto 0.448 0.786 0.998 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39025 0.24952 moveto
0.39458 0.2422 lineto
stroke
grestore
gsave
0.09179 0.77109 moveto 0.16261 0.82134 lineto 0.17213 0.82611 lineto 0.513 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.17213 0.82611 moveto
0.18339 0.83119 lineto
stroke
grestore
gsave
0.08339 0.75962 moveto 0.16261 0.82134 lineto 0.09179 0.77109 lineto 0 0.285 0.764 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.10223 0.78405 moveto
0.10409 0.78517 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.10409 0.78517 moveto
0.15369 0.81501 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.09179 0.77109 moveto
0.10223 0.78405 lineto
stroke
grestore
gsave
0.3094 0.21328 moveto 0.40113 0.23586 lineto 0.40984 0.23061 lineto 0.399 0.758 0.994 setrgbcolor
fill
grestore
gsave
0.30027 0.22645 moveto 0.40113 0.23586 lineto 0.3094 0.21328 lineto 0.543 0.787 0.989 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30027 0.22645 moveto
0.39458 0.2422 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39458 0.2422 moveto
0.40113 0.23586 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.29455 0.23967 moveto
0.30027 0.22645 lineto
stroke
grestore
gsave
0.08339 0.75962 moveto 0.15499 0.81704 lineto 0.16261 0.82134 lineto 0.539 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.16261 0.82134 moveto
0.17213 0.82611 lineto
stroke
grestore
gsave
0.07711 0.74988 moveto 0.15499 0.81704 lineto 0.08339 0.75962 lineto 0 0.226 0.719 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.09179 0.77109 moveto
0.09357 0.77235 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.09357 0.77235 moveto
0.14305 0.80746 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.08339 0.75962 moveto
0.09179 0.77109 lineto
stroke
grestore
gsave
0.32197 0.20037 moveto 0.40984 0.23061 lineto 0.42059 0.22655 lineto 0.354 0.722 0.987 setrgbcolor
fill
grestore
gsave
0.3094 0.21328 moveto 0.40984 0.23061 lineto 0.32197 0.20037 lineto 0.536 0.772 0.985 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31148 0.21379 moveto
0.40113 0.23586 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40113 0.23586 moveto
0.40984 0.23061 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.30027 0.22645 moveto
0.3094 0.21328 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3094 0.21328 moveto
0.31148 0.21379 lineto
stroke
grestore
gsave
0.33797 0.188 moveto 0.42059 0.22655 lineto 0.43321 0.22379 lineto 0.318 0.683 0.978 setrgbcolor
fill
grestore
gsave
0.32197 0.20037 moveto 0.42059 0.22655 lineto 0.33797 0.188 lineto 0.531 0.755 0.978 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40984 0.23061 moveto
0.42059 0.22655 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.3094 0.21328 moveto
0.32197 0.20037 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32197 0.20037 moveto
0.32423 0.20115 lineto
stroke
grestore
gsave
0.07711 0.74988 moveto 0.14945 0.81336 lineto 0.15499 0.81704 lineto 0.533 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.15499 0.81704 moveto
0.16261 0.82134 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.08339 0.75962 moveto
0.13934 0.80448 lineto
stroke
grestore
gsave
0.07304 0.74209 moveto 0.14945 0.81336 lineto 0.07711 0.74988 lineto 0 0.182 0.686 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.07711 0.74988 moveto
0.08339 0.75962 lineto
stroke
grestore
gsave
0.35731 0.17644 moveto 0.43321 0.22379 lineto 0.44754 0.22238 lineto 0.295 0.644 0.967 setrgbcolor
fill
grestore
gsave
0.33797 0.188 moveto 0.43321 0.22379 lineto 0.35731 0.17644 lineto 0.528 0.735 0.969 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32423 0.20115 moveto
0.40984 0.23061 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42059 0.22655 moveto
0.43321 0.22379 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42903 0.22118 moveto
0.43321 0.22379 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33797 0.188 moveto
0.34024 0.18906 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.32197 0.20037 moveto
0.33797 0.188 lineto
stroke
grestore
gsave
0.07304 0.74209 moveto 0.14613 0.81043 lineto 0.14945 0.81336 lineto 0.494 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.14945 0.81336 moveto
0.15499 0.81704 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.07711 0.74988 moveto
0.14945 0.81336 lineto
stroke
grestore
gsave
0.07129 0.73642 moveto 0.14613 0.81043 lineto 0.07304 0.74209 lineto 0 0.155 0.666 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.07304 0.74209 moveto
0.07711 0.74988 lineto
stroke
grestore
gsave
0.37985 0.16602 moveto 0.44754 0.22238 lineto 0.46338 0.22241 lineto 0.287 0.606 0.953 setrgbcolor
fill
grestore
gsave
0.35731 0.17644 moveto 0.44754 0.22238 lineto 0.37985 0.16602 lineto 0.528 0.714 0.957 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34024 0.18906 moveto
0.42059 0.22655 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43321 0.22379 moveto
0.44754 0.22238 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44462 0.21995 moveto
0.44754 0.22238 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35731 0.17644 moveto
0.35923 0.17764 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35923 0.17764 moveto
0.3595 0.1778 lineto
stroke
grestore
gsave
0.07129 0.73642 moveto 0.14515 0.80837 lineto 0.14613 0.81043 lineto 0 0.064 0.571 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.14613 0.81043 moveto
0.14945 0.81336 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.07304 0.74209 moveto
0.14613 0.81043 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33797 0.188 moveto
0.35731 0.17644 lineto
stroke
grestore
gsave
0.40539 0.15708 moveto 0.46338 0.22241 lineto 0.48053 0.22389 lineto 0.293 0.572 0.935 setrgbcolor
fill
grestore
gsave
0.37985 0.16602 moveto 0.46338 0.22241 lineto 0.40539 0.15708 lineto 0.531 0.693 0.942 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44754 0.22238 moveto
0.46338 0.22241 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46141 0.22019 moveto
0.46338 0.22241 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37985 0.16602 moveto
0.38168 0.16754 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38168 0.16754 moveto
0.38187 0.1677 lineto
stroke
grestore
gsave
0.07197 0.73303 moveto 0.14515 0.80837 lineto 0.07129 0.73642 lineto 0 0.142 0.657 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.07129 0.73642 moveto
0.07304 0.74209 lineto
stroke
grestore
gsave
0.07197 0.73303 moveto 0.14664 0.80723 lineto 0.14515 0.80837 lineto 0 0.129 0.644 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.14515 0.80837 moveto
0.14613 0.81043 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.07129 0.73642 moveto
0.14515 0.80837 lineto
stroke
grestore
gsave
0.43363 0.14998 moveto 0.48053 0.22389 lineto 0.4988 0.22686 lineto 0.31 0.541 0.913 setrgbcolor
fill
grestore
gsave
0.40539 0.15708 moveto 0.48053 0.22389 lineto 0.43363 0.14998 lineto 0.536 0.672 0.925 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46338 0.22241 moveto
0.48053 0.22389 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47732 0.21883 moveto
0.48053 0.22389 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40539 0.15708 moveto
0.40703 0.15893 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40703 0.15893 moveto
0.40716 0.15908 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3595 0.1778 moveto
0.42903 0.22118 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.35731 0.17644 moveto
0.37985 0.16602 lineto
stroke
grestore
gsave
0.46421 0.14507 moveto 0.4988 0.22686 lineto 0.51799 0.23129 lineto 0.334 0.516 0.886 setrgbcolor
fill
grestore
gsave
0.43363 0.14998 moveto 0.4988 0.22686 lineto 0.46421 0.14507 lineto 0.544 0.652 0.906 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48053 0.22389 moveto
0.4988 0.22686 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4981 0.2252 moveto
0.4988 0.22686 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43363 0.14998 moveto
0.435 0.15215 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.435 0.15215 moveto
0.43509 0.15229 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40716 0.15908 moveto
0.46141 0.22019 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38187 0.1677 moveto
0.44462 0.21995 lineto
stroke
grestore
gsave
0.0752 0.73203 moveto 0.14664 0.80723 lineto 0.07197 0.73303 lineto 0 0.142 0.657 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.07129 0.73642 moveto
0.07197 0.73303 lineto
stroke
grestore
gsave
0.0752 0.73203 moveto 0.15066 0.80705 lineto 0.14664 0.80723 lineto 0 0.205 0.714 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.14515 0.80837 moveto
0.14664 0.80723 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.07197 0.73303 moveto
0.14664 0.80723 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37985 0.16602 moveto
0.40539 0.15708 lineto
stroke
grestore
gsave
0.49673 0.14269 moveto 0.51799 0.23129 lineto 0.53793 0.23719 lineto 0.363 0.495 0.858 setrgbcolor
fill
grestore
gsave
0.46421 0.14507 moveto 0.51799 0.23129 lineto 0.49673 0.14269 lineto 0.554 0.635 0.886 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4988 0.22686 moveto
0.51799 0.23129 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51767 0.22998 moveto
0.51799 0.23129 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46421 0.14507 moveto
0.46531 0.14767 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43509 0.15229 moveto
0.47732 0.21883 lineto
stroke
grestore
gsave
0.08111 0.73351 moveto 0.15066 0.80705 lineto 0.0752 0.73203 lineto 0 0.151 0.663 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.07197 0.73303 moveto
0.0752 0.73203 lineto
stroke
grestore
gsave
0.08111 0.73351 moveto 0.15728 0.8078 lineto 0.15066 0.80705 lineto 0 0.283 0.775 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.14664 0.80723 moveto
0.15066 0.80705 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.0752 0.73203 moveto
0.15066 0.80705 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40539 0.15708 moveto
0.43363 0.14998 lineto
stroke
grestore
gsave
0.53068 0.14312 moveto 0.53793 0.23719 lineto 0.55844 0.24454 lineto 0.393 0.479 0.829 setrgbcolor
fill
grestore
gsave
0.49673 0.14269 moveto 0.53793 0.23719 lineto 0.53068 0.14312 lineto 0.565 0.619 0.865 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51799 0.23129 moveto
0.53793 0.23719 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49673 0.14269 moveto
0.49741 0.14554 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49741 0.14554 moveto
0.51767 0.22998 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46531 0.14767 moveto
0.4981 0.2252 lineto
stroke
grestore
gsave
0.56555 0.14663 moveto 0.55844 0.24454 lineto 0.57937 0.25333 lineto 0.425 0.467 0.801 setrgbcolor
fill
grestore
gsave
0.53068 0.14312 moveto 0.55844 0.24454 lineto 0.56555 0.14663 lineto 0.579 0.606 0.844 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.53793 0.23719 moveto
0.55844 0.24454 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53068 0.14312 moveto
0.53793 0.23719 lineto
stroke
grestore
gsave
0.08982 0.73747 moveto 0.15728 0.8078 lineto 0.08111 0.73351 lineto 0 0.166 0.672 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.0752 0.73203 moveto
0.08111 0.73351 lineto
stroke
grestore
gsave
0.08982 0.73747 moveto 0.16651 0.8094 lineto 0.15728 0.8078 lineto 0 0.356 0.825 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.15066 0.80705 moveto
0.15728 0.8078 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.43363 0.14998 moveto
0.46421 0.14507 lineto
stroke
grestore
gsave
0.60079 0.1534 moveto 0.57937 0.25333 lineto 0.60054 0.26355 lineto 0.456 0.459 0.773 setrgbcolor
fill
grestore
gsave
0.56555 0.14663 moveto 0.57937 0.25333 lineto 0.60079 0.1534 lineto 0.593 0.596 0.824 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55844 0.24454 moveto
0.57937 0.25333 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55844 0.24454 moveto
0.56555 0.14663 lineto
stroke
grestore
gsave
0.10146 0.74387 moveto 0.16651 0.8094 lineto 0.08982 0.73747 lineto 0 0.183 0.68 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.08111 0.73351 moveto
0.08449 0.73681 lineto
stroke
grestore
gsave
0.10146 0.74387 moveto 0.17832 0.81175 lineto 0.16651 0.8094 lineto 0.031 0.423 0.865 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.08449 0.73681 moveto
0.15728 0.8078 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.15728 0.8078 moveto
0.16651 0.8094 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.1438 0.7881 moveto
0.16651 0.8094 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.08111 0.73351 moveto
0.08982 0.73747 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46421 0.14507 moveto
0.49673 0.14269 lineto
stroke
grestore
gsave
0.63582 0.16354 moveto 0.60054 0.26355 lineto 0.62179 0.2752 lineto 0.486 0.455 0.748 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57937 0.25333 moveto
0.57989 0.25091 lineto
stroke
grestore
gsave
0.60079 0.1534 moveto 0.60054 0.26355 lineto 0.63582 0.16354 lineto 0.609 0.588 0.805 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57989 0.25091 moveto
0.60079 0.1534 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57937 0.25333 moveto
0.60054 0.26355 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.49673 0.14269 moveto
0.53068 0.14312 lineto
stroke
grestore
gsave
0.67009 0.1771 moveto 0.62179 0.2752 lineto 0.64291 0.28829 lineto 0.516 0.453 0.724 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60054 0.26355 moveto
0.60164 0.26044 lineto
stroke
grestore
gsave
0.63582 0.16354 moveto 0.62179 0.2752 lineto 0.67009 0.1771 lineto 0.625 0.583 0.786 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60164 0.26044 moveto
0.63464 0.16688 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60054 0.26355 moveto
0.62179 0.2752 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63464 0.16688 moveto
0.63582 0.16354 lineto
stroke
grestore
gsave
0.1161 0.75262 moveto 0.17832 0.81175 lineto 0.10146 0.74387 lineto 0 0.2 0.683 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.08982 0.73747 moveto
0.093 0.74045 lineto
stroke
grestore
gsave
0.1161 0.75262 moveto 0.19264 0.81466 lineto 0.17832 0.81175 lineto 0.082 0.482 0.894 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.093 0.74045 moveto
0.1438 0.7881 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.16651 0.8094 moveto
0.17832 0.81175 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.16183 0.79719 moveto
0.17832 0.81175 lineto
stroke
grestore
gsave
0.70308 0.19403 moveto 0.64291 0.28829 lineto 0.66371 0.30286 lineto 0.546 0.454 0.703 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62179 0.2752 moveto
0.62363 0.27146 lineto
stroke
grestore
gsave
0.67009 0.1771 moveto 0.64291 0.28829 lineto 0.70308 0.19403 lineto 0.642 0.58 0.769 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62179 0.2752 moveto
0.64291 0.28829 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66847 0.18039 moveto
0.67009 0.1771 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53068 0.14312 moveto
0.56555 0.14663 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.08982 0.73747 moveto
0.10146 0.74387 lineto
stroke
grestore
gsave
0.13383 0.76352 moveto 0.19264 0.81466 lineto 0.1161 0.75262 lineto 0 0.21 0.676 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.10146 0.74387 moveto
0.10451 0.74657 lineto
stroke
grestore
gsave
0.13383 0.76352 moveto 0.20937 0.81792 lineto 0.19264 0.81466 lineto 0.112 0.532 0.914 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.17832 0.81175 moveto
0.19264 0.81466 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.1798 0.80424 moveto
0.19264 0.81466 lineto
stroke
grestore
gsave
0.73431 0.21424 moveto 0.66371 0.30286 lineto 0.68394 0.31891 lineto 0.575 0.458 0.683 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64291 0.28829 moveto
0.64565 0.28402 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62363 0.27146 moveto
0.62524 0.26819 lineto
stroke
grestore
gsave
0.70308 0.19403 moveto 0.66371 0.30286 lineto 0.73431 0.21424 lineto 0.66 0.579 0.753 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62524 0.26819 moveto
0.66847 0.18039 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64291 0.28829 moveto
0.66371 0.30286 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70105 0.19722 moveto
0.70308 0.19403 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56555 0.14663 moveto
0.60079 0.1534 lineto
stroke
grestore
gsave
0.76336 0.23752 moveto 0.68394 0.31891 lineto 0.70333 0.33644 lineto 0.604 0.465 0.665 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66371 0.30286 moveto
0.66746 0.29815 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64565 0.28402 moveto
0.64791 0.28047 lineto
stroke
grestore
gsave
0.73431 0.21424 moveto 0.68394 0.31891 lineto 0.76336 0.23752 lineto 0.678 0.58 0.738 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64791 0.28047 moveto
0.70105 0.19722 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66371 0.30286 moveto
0.68394 0.31891 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7319 0.21726 moveto
0.73431 0.21424 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60079 0.1534 moveto
0.63582 0.16354 lineto
stroke
grestore
gsave
0.15465 0.77632 moveto 0.20937 0.81792 lineto 0.13383 0.76352 lineto 0 0.212 0.655 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.1161 0.75262 moveto
0.11906 0.75502 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.10451 0.74657 moveto
0.10467 0.74671 lineto
stroke
grestore
gsave
0.15465 0.77632 moveto 0.22835 0.82132 lineto 0.20937 0.81792 lineto 0.117 0.57 0.918 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.10467 0.74671 moveto
0.16183 0.79719 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.19264 0.81466 moveto
0.20937 0.81792 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.19089 0.80461 moveto
0.19901 0.81046 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.19901 0.81046 moveto
0.20937 0.81792 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63582 0.16354 moveto
0.67009 0.1771 lineto
stroke
grestore
gsave
0.78988 0.26365 moveto 0.70333 0.33644 lineto 0.72162 0.35545 lineto 0.633 0.474 0.649 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68394 0.31891 moveto
0.68882 0.3139 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66746 0.29815 moveto
0.67046 0.29439 lineto
stroke
grestore
gsave
0.76336 0.23752 moveto 0.70333 0.33644 lineto 0.78988 0.26365 lineto 0.697 0.583 0.724 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68394 0.31891 moveto
0.70333 0.33644 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76062 0.24033 moveto
0.76336 0.23752 lineto
stroke
grestore
gsave
0.87694 0.42599 moveto 0.78669 0.46979 lineto 0.88459 0.46236 lineto 0.802 0.635 0.675 setrgbcolor
fill
grestore
gsave
0.87694 0.42599 moveto 0.77805 0.44482 lineto 0.78669 0.46979 lineto 0.772 0.561 0.614 setrgbcolor
fill
grestore
gsave
0.866 0.39045 moveto 0.77805 0.44482 lineto 0.87694 0.42599 lineto 0.787 0.624 0.679 setrgbcolor
fill
grestore
gsave
0.88459 0.46236 moveto 0.79273 0.4954 lineto 0.88897 0.49921 lineto 0.815 0.645 0.672 setrgbcolor
fill
grestore
gsave
0.88459 0.46236 moveto 0.78669 0.46979 lineto 0.79273 0.4954 lineto 0.794 0.585 0.617 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.87694 0.42599 moveto
0.88459 0.46236 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78669 0.46979 moveto
0.88459 0.46236 lineto
stroke
grestore
gsave
0.866 0.39045 moveto 0.767 0.42072 lineto 0.77805 0.44482 lineto 0.747 0.539 0.614 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77805 0.44482 moveto
0.87694 0.42599 lineto
stroke
grestore
gsave
0.85176 0.35609 moveto 0.767 0.42072 lineto 0.866 0.39045 lineto 0.771 0.614 0.685 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.866 0.39045 moveto
0.87694 0.42599 lineto
stroke
grestore
gsave
0.85176 0.35609 moveto 0.75374 0.39769 lineto 0.767 0.42072 lineto 0.72 0.519 0.618 setrgbcolor
fill
grestore
gsave
0.83426 0.32327 moveto 0.75374 0.39769 lineto 0.85176 0.35609 lineto 0.753 0.604 0.692 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86244 0.39154 moveto
0.866 0.39045 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.85176 0.35609 moveto
0.866 0.39045 lineto
stroke
grestore
gsave
0.88897 0.49921 moveto 0.79603 0.5214 lineto 0.89015 0.53621 lineto 0.825 0.654 0.671 setrgbcolor
fill
grestore
gsave
0.88897 0.49921 moveto 0.79273 0.4954 lineto 0.79603 0.5214 lineto 0.813 0.608 0.625 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.88459 0.46236 moveto
0.88897 0.49921 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79273 0.4954 moveto
0.88897 0.49921 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.67009 0.1771 moveto
0.70308 0.19403 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.10146 0.74387 moveto
0.1161 0.75262 lineto
stroke
grestore
gsave
0.83426 0.32327 moveto 0.73852 0.3759 lineto 0.75374 0.39769 lineto 0.691 0.501 0.625 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70333 0.33644 moveto
0.71416 0.32734 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75374 0.39769 moveto
0.76444 0.39315 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.767 0.42072 moveto
0.86244 0.39154 lineto
stroke
grestore
gsave
0.81358 0.29234 moveto 0.73852 0.3759 lineto 0.83426 0.32327 lineto 0.735 0.596 0.701 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.84828 0.35756 moveto
0.85176 0.35609 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.83426 0.32327 moveto
0.85176 0.35609 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83083 0.32515 moveto
0.83426 0.32327 lineto
stroke
grestore
gsave
0.89015 0.53621 moveto 0.79652 0.5475 lineto 0.88818 0.57304 lineto 0.832 0.661 0.671 setrgbcolor
fill
grestore
gsave
0.89015 0.53621 moveto 0.79603 0.5214 lineto 0.79652 0.5475 lineto 0.826 0.63 0.637 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.88897 0.49921 moveto
0.89015 0.53621 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79603 0.5214 moveto
0.89015 0.53621 lineto
stroke
grestore
gsave
0.81358 0.29234 moveto 0.72162 0.35545 lineto 0.73852 0.3759 lineto 0.662 0.486 0.636 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68882 0.3139 moveto
0.69263 0.31 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73852 0.3759 moveto
0.74752 0.37095 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76444 0.39315 moveto
0.84828 0.35756 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67046 0.29439 moveto
0.67434 0.28952 lineto
stroke
grestore
gsave
0.78988 0.26365 moveto 0.72162 0.35545 lineto 0.81358 0.29234 lineto 0.716 0.589 0.712 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67434 0.28952 moveto
0.7319 0.21726 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70333 0.33644 moveto
0.72162 0.35545 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71416 0.32734 moveto
0.78686 0.26619 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74752 0.37095 moveto
0.83083 0.32515 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69263 0.31 moveto
0.76062 0.24033 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81358 0.29234 moveto
0.83426 0.32327 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72912 0.35031 moveto
0.81033 0.29457 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72162 0.35545 moveto
0.72912 0.35031 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81033 0.29457 moveto
0.81136 0.29387 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81136 0.29387 moveto
0.81358 0.29234 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78686 0.26619 moveto
0.78988 0.26365 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.78988 0.26365 moveto
0.81358 0.29234 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70308 0.19403 moveto
0.73431 0.21424 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.76336 0.23752 moveto
0.78988 0.26365 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.73431 0.21424 moveto
0.76336 0.23752 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72162 0.35545 moveto
0.73852 0.3759 lineto
stroke
grestore
gsave
0.88818 0.57304 moveto 0.79416 0.57343 lineto 0.88314 0.60939 lineto 0.836 0.666 0.671 setrgbcolor
fill
grestore
gsave
0.88818 0.57304 moveto 0.79652 0.5475 lineto 0.79416 0.57343 lineto 0.835 0.648 0.651 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.88818 0.57304 moveto
0.89015 0.53621 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79652 0.5475 moveto
0.88818 0.57304 lineto
stroke
grestore
gsave
0.17855 0.79067 moveto 0.22835 0.82132 lineto 0.15465 0.77632 lineto 0 0.201 0.612 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.13383 0.76352 moveto
0.13669 0.76558 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.11906 0.75502 moveto
0.11919 0.75512 lineto
stroke
grestore
gsave
0.22835 0.82132 moveto 0.17988 0.79149 lineto 0.24939 0.82462 lineto 0.094 0.591 0.899 setrgbcolor
fill
grestore
gsave
0.17954 0.79128 moveto 0.18023 0.79161 lineto 0.17988 0.79149 lineto 0.094 0.591 0.899 setrgbcolor
fill
grestore
gsave
0.24939 0.82462 moveto 0.17988 0.79149 lineto 0.18023 0.79161 lineto 0.094 0.591 0.899 setrgbcolor
fill
grestore
gsave
0.24939 0.82462 moveto 0.17954 0.79128 lineto 0.18116 0.79192 lineto 0.094 0.591 0.899 setrgbcolor
fill
grestore
gsave
0.17855 0.79067 moveto 0.18116 0.79192 lineto 0.17954 0.79128 lineto 0.094 0.591 0.899 setrgbcolor
fill
grestore
gsave
0.20542 0.80616 moveto 0.24939 0.82462 lineto 0.17855 0.79067 lineto 0.408 0 0 setrgbcolor
fill
grestore
gsave
0.20542 0.80616 moveto 0.27227 0.82758 lineto 0.24939 0.82462 lineto 0.038 0.583 0.84 setrgbcolor
fill
grestore
gsave
0.26737 0.83855 moveto 0.29398 0.8308 lineto 0.2351 0.8223 lineto 0.523 0 0 setrgbcolor
fill
grestore
gsave
0.2351 0.8223 moveto 0.27058 0.82734 lineto 0.20542 0.80616 lineto 0.465 0 0 setrgbcolor
fill
grestore
gsave
0.27227 0.82758 moveto 0.26658 0.82576 lineto 0.27058 0.82734 lineto 0.465 0 0 setrgbcolor
fill
grestore
gsave
0.20542 0.80616 moveto 0.27058 0.82734 lineto 0.26658 0.82576 lineto 0.465 0 0 setrgbcolor
fill
grestore
gsave
0.2351 0.8223 moveto 0.29675 0.82999 lineto 0.27227 0.82758 lineto 0 0.532 0.725 setrgbcolor
fill
grestore
gsave
0.29675 0.82999 moveto 0.28872 0.82899 lineto 0.29398 0.8308 lineto 0.523 0 0 setrgbcolor
fill
grestore
gsave
0.2351 0.8223 moveto 0.29398 0.8308 lineto 0.28872 0.82899 lineto 0.523 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.11919 0.75512 moveto
0.1798 0.80424 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.13669 0.76558 moveto
0.13679 0.76566 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.13679 0.76566 moveto
0.19089 0.80461 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.20937 0.81792 moveto
0.22835 0.82132 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.15465 0.77632 moveto
0.1574 0.778 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.1574 0.778 moveto
0.15749 0.77805 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.15749 0.77805 moveto
0.21335 0.81216 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.21335 0.81216 moveto
0.22835 0.82132 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.22835 0.82132 moveto
0.23534 0.82242 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73852 0.3759 moveto
0.75374 0.39769 lineto
stroke
grestore
gsave
0.88314 0.60939 moveto 0.78894 0.59892 lineto 0.87509 0.64494 lineto 0.837 0.667 0.672 setrgbcolor
fill
grestore
gsave
0.88314 0.60939 moveto 0.79416 0.57343 lineto 0.78894 0.59892 lineto 0.837 0.662 0.666 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.88314 0.60939 moveto
0.88818 0.57304 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75374 0.39769 moveto
0.767 0.42072 lineto
stroke
grestore
gsave
0.87509 0.64494 moveto 0.78091 0.62369 lineto 0.86411 0.67941 lineto 0.835 0.665 0.672 setrgbcolor
fill
grestore
gsave
0.87509 0.64494 moveto 0.78894 0.59892 lineto 0.78091 0.62369 lineto 0.834 0.671 0.68 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.87509 0.64494 moveto
0.88314 0.60939 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86582 0.63999 moveto
0.87509 0.64494 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79416 0.57343 moveto
0.88314 0.60939 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.767 0.42072 moveto
0.77805 0.44482 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.17855 0.79067 moveto
0.18116 0.79192 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.18116 0.79192 moveto
0.22187 0.81143 lineto
stroke
grestore
gsave
0.86411 0.67941 moveto 0.77016 0.64751 lineto 0.85026 0.71251 lineto 0.831 0.66 0.67 setrgbcolor
fill
grestore
gsave
0.86411 0.67941 moveto 0.78091 0.62369 lineto 0.77016 0.64751 lineto 0.826 0.673 0.693 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.86411 0.67941 moveto
0.87509 0.64494 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78894 0.59892 moveto
0.86582 0.63999 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.77805 0.44482 moveto
0.78669 0.46979 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.1161 0.75262 moveto
0.13383 0.76352 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78669 0.46979 moveto
0.79273 0.4954 lineto
stroke
grestore
gsave
0.85026 0.71251 moveto 0.7568 0.67016 lineto 0.83361 0.74393 lineto 0.825 0.651 0.667 setrgbcolor
fill
grestore
gsave
0.85026 0.71251 moveto 0.77016 0.64751 lineto 0.7568 0.67016 lineto 0.814 0.668 0.702 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.85026 0.71251 moveto
0.86411 0.67941 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.84929 0.71172 moveto
0.85026 0.71251 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.20542 0.80616 moveto
0.20785 0.80694 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.20785 0.80694 moveto
0.2567 0.82259 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2567 0.82259 moveto
0.26897 0.82652 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.79273 0.4954 moveto
0.79603 0.5214 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.79603 0.5214 moveto
0.79652 0.5475 lineto
stroke
grestore
gsave
0.83361 0.74393 moveto 0.74099 0.69148 lineto 0.81421 0.7734 lineto 0.817 0.638 0.661 setrgbcolor
fill
grestore
gsave
0.83361 0.74393 moveto 0.7568 0.67016 lineto 0.74099 0.69148 lineto 0.798 0.657 0.707 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.83361 0.74393 moveto
0.85026 0.71251 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8329 0.74325 moveto
0.83361 0.74393 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83206 0.74244 moveto
0.8329 0.74325 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7568 0.67016 moveto
0.77063 0.68345 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78091 0.62369 moveto
0.86411 0.67941 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.79416 0.57343 moveto
0.79652 0.5475 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2351 0.8223 moveto
0.28872 0.82899 lineto
stroke
grestore
gsave
0.26737 0.83855 moveto 0.32259 0.83166 lineto 0.29675 0.82999 lineto 0.164 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28872 0.82899 moveto
0.29675 0.82999 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78894 0.59892 moveto
0.79416 0.57343 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.13383 0.76352 moveto
0.15465 0.77632 lineto
stroke
grestore
gsave
0.81421 0.7734 moveto 0.72289 0.71133 lineto 0.79213 0.80063 lineto 0.808 0.623 0.652 setrgbcolor
fill
grestore
gsave
0.81421 0.7734 moveto 0.74099 0.69148 lineto 0.72289 0.71133 lineto 0.781 0.641 0.707 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77016 0.64751 moveto
0.84929 0.71172 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77063 0.68345 moveto
0.83206 0.74244 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81421 0.7734 moveto
0.83361 0.74393 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81296 0.772 moveto
0.81421 0.7734 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81246 0.77144 moveto
0.81296 0.772 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74099 0.69148 moveto
0.74946 0.70096 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78091 0.62369 moveto
0.78894 0.59892 lineto
stroke
grestore
gsave
0.30191 0.85434 moveto 0.32259 0.83166 lineto 0.26737 0.83855 lineto 0.575 0.006 0 setrgbcolor
fill
grestore
gsave
0.30191 0.85434 moveto 0.34954 0.83243 lineto 0.32259 0.83166 lineto 0.278 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.29675 0.82999 moveto
0.32259 0.83166 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.77016 0.64751 moveto
0.78091 0.62369 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.7568 0.67016 moveto
0.77016 0.64751 lineto
stroke
grestore
gsave
0.33835 0.86909 moveto 0.34954 0.83243 lineto 0.30191 0.85434 lineto 0.617 0.08 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26737 0.83855 moveto
0.26934 0.83831 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26934 0.83831 moveto
0.32259 0.83166 lineto
stroke
grestore
gsave
0.33835 0.86909 moveto 0.37734 0.83219 lineto 0.34954 0.83243 lineto 0.376 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32259 0.83166 moveto
0.34954 0.83243 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34687 0.83366 moveto
0.34954 0.83243 lineto
stroke
grestore
gsave
0.79213 0.80063 moveto 0.70272 0.72961 lineto 0.76745 0.82534 lineto 0.798 0.605 0.64 setrgbcolor
fill
grestore
gsave
0.79213 0.80063 moveto 0.72289 0.71133 lineto 0.70272 0.72961 lineto 0.763 0.62 0.701 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74946 0.70096 moveto
0.81246 0.77144 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.79213 0.80063 moveto
0.81421 0.7734 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79066 0.79873 moveto
0.79213 0.80063 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79033 0.7983 moveto
0.79066 0.79873 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7375 0.73016 moveto
0.79033 0.7983 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72289 0.71133 moveto
0.7375 0.73016 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74099 0.69148 moveto
0.7568 0.67016 lineto
stroke
grestore
gsave
0.37629 0.88223 moveto 0.37734 0.83219 lineto 0.33835 0.86909 lineto 0.649 0.151 0.052 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33835 0.86909 moveto
0.37546 0.83397 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30191 0.85434 moveto
0.30359 0.85357 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30359 0.85357 moveto
0.34687 0.83366 lineto
stroke
grestore
gsave
0.37629 0.88223 moveto 0.40578 0.83085 lineto 0.37734 0.83219 lineto 0.45 0 0.048 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34954 0.83243 moveto
0.37734 0.83219 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37546 0.83397 moveto
0.37734 0.83219 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72289 0.71133 moveto
0.74099 0.69148 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.15465 0.77632 moveto
0.17855 0.79067 lineto
stroke
grestore
gsave
0.41526 0.89322 moveto 0.40578 0.83085 lineto 0.37629 0.88223 lineto 0.673 0.215 0.157 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37629 0.88223 moveto
0.40457 0.83297 lineto
stroke
grestore
gsave
0.41526 0.89322 moveto 0.43464 0.82835 lineto 0.40578 0.83085 lineto 0.505 0.092 0.19 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37734 0.83219 moveto
0.40578 0.83085 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40457 0.83297 moveto
0.40578 0.83085 lineto
stroke
grestore
gsave
0.76745 0.82534 moveto 0.68067 0.74628 lineto 0.74027 0.84727 lineto 0.788 0.584 0.625 setrgbcolor
fill
grestore
gsave
0.76745 0.82534 moveto 0.70272 0.72961 lineto 0.68067 0.74628 lineto 0.744 0.595 0.691 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.76745 0.82534 moveto
0.79213 0.80063 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70272 0.72961 moveto
0.76745 0.82534 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70272 0.72961 moveto
0.72289 0.71133 lineto
stroke
grestore
gsave
0.45479 0.90161 moveto 0.43464 0.82835 lineto 0.41526 0.89322 lineto 0.691 0.273 0.247 setrgbcolor
fill
grestore
gsave
0.45479 0.90161 moveto 0.46371 0.82465 lineto 0.43464 0.82835 lineto 0.546 0.182 0.302 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40578 0.83085 moveto
0.43464 0.82835 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41526 0.89322 moveto
0.43464 0.82835 lineto
stroke
grestore
gsave
0.74027 0.84727 moveto 0.68067 0.74628 lineto 0.65698 0.76132 lineto 0.725 0.567 0.675 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68067 0.74628 moveto
0.70272 0.72961 lineto
stroke
grestore
gsave
0.4944 0.90699 moveto 0.46371 0.82465 lineto 0.45479 0.90161 lineto 0.705 0.323 0.323 setrgbcolor
fill
grestore
gsave
0.4944 0.90699 moveto 0.4928 0.81971 lineto 0.46371 0.82465 lineto 0.578 0.257 0.389 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43464 0.82835 moveto
0.46371 0.82465 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45479 0.90161 moveto
0.46371 0.82465 lineto
stroke
grestore
gsave
0.71068 0.86617 moveto 0.65698 0.76132 lineto 0.63187 0.77476 lineto 0.706 0.535 0.655 setrgbcolor
fill
grestore
gsave
0.74027 0.84727 moveto 0.65698 0.76132 lineto 0.71068 0.86617 lineto 0.778 0.561 0.605 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65698 0.76132 moveto
0.68067 0.74628 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.74027 0.84727 moveto
0.76745 0.82534 lineto
stroke
grestore
gsave
0.53363 0.90908 moveto 0.4928 0.81971 lineto 0.4944 0.90699 lineto 0.717 0.368 0.386 setrgbcolor
fill
grestore
gsave
0.53363 0.90908 moveto 0.52172 0.81348 lineto 0.4928 0.81971 lineto 0.605 0.32 0.458 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46371 0.82465 moveto
0.4928 0.81971 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4928 0.81971 moveto
0.4944 0.90699 lineto
stroke
grestore
gsave
0.67886 0.88181 moveto 0.63187 0.77476 lineto 0.60557 0.78663 lineto 0.687 0.501 0.629 setrgbcolor
fill
grestore
gsave
0.71068 0.86617 moveto 0.63187 0.77476 lineto 0.67886 0.88181 lineto 0.767 0.535 0.582 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63187 0.77476 moveto
0.65698 0.76132 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63187 0.77476 moveto
0.63327 0.77796 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70909 0.86306 moveto
0.71068 0.86617 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68067 0.74628 moveto
0.74027 0.84727 lineto
stroke
grestore
gsave
0.57206 0.90767 moveto 0.52172 0.81348 lineto 0.53363 0.90908 lineto 0.727 0.408 0.439 setrgbcolor
fill
grestore
gsave
0.57206 0.90767 moveto 0.55029 0.80593 lineto 0.52172 0.81348 lineto 0.628 0.374 0.514 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4928 0.81971 moveto
0.52172 0.81348 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52172 0.81348 moveto
0.53363 0.90908 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71068 0.86617 moveto
0.74027 0.84727 lineto
stroke
grestore
gsave
0.64498 0.89401 moveto 0.60557 0.78663 lineto 0.57831 0.797 lineto 0.668 0.463 0.598 setrgbcolor
fill
grestore
gsave
0.67886 0.88181 moveto 0.60557 0.78663 lineto 0.64498 0.89401 lineto 0.757 0.507 0.555 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60557 0.78663 moveto
0.63187 0.77476 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60557 0.78663 moveto
0.60648 0.7891 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67743 0.87855 moveto
0.67886 0.88181 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65698 0.76132 moveto
0.70909 0.86306 lineto
stroke
grestore
gsave
0.60929 0.90266 moveto 0.55029 0.80593 lineto 0.57206 0.90767 lineto 0.737 0.444 0.484 setrgbcolor
fill
grestore
gsave
0.60929 0.90266 moveto 0.57831 0.797 lineto 0.55029 0.80593 lineto 0.649 0.421 0.56 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52172 0.81348 moveto
0.55029 0.80593 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55029 0.80593 moveto
0.57206 0.90767 lineto
stroke
grestore
gsave
0.64498 0.89401 moveto 0.57831 0.797 lineto 0.60929 0.90266 lineto 0.747 0.477 0.522 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57831 0.797 moveto
0.57884 0.79881 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57884 0.79881 moveto
0.6083 0.8993 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6083 0.8993 moveto
0.60929 0.90266 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55029 0.80593 moveto
0.57831 0.797 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57831 0.797 moveto
0.60557 0.78663 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60648 0.7891 moveto
0.64376 0.89067 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64376 0.89067 moveto
0.64498 0.89401 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63327 0.77796 moveto
0.67743 0.87855 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.17855 0.79067 moveto
0.20542 0.80616 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.67886 0.88181 moveto
0.71068 0.86617 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.64498 0.89401 moveto
0.67886 0.88181 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.20542 0.80616 moveto
0.2351 0.8223 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60929 0.90266 moveto
0.64498 0.89401 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2351 0.8223 moveto
0.26737 0.83855 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57206 0.90767 moveto
0.60929 0.90266 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.26737 0.83855 moveto
0.30191 0.85434 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53363 0.90908 moveto
0.57206 0.90767 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.30191 0.85434 moveto
0.33835 0.86909 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.4944 0.90699 moveto
0.53363 0.90908 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33835 0.86909 moveto
0.37629 0.88223 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45479 0.90161 moveto
0.4944 0.90699 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.41526 0.89322 moveto
0.45479 0.90161 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37629 0.88223 moveto
0.41526 0.89322 lineto
stroke
grestore
gsave
grestore
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; nowordwrap; ]
No Input Form was saved for this expression.

















;[o]
-Graphics3D-
:[font = input; startGroup; startGroup; nowordwrap; ]

clear;top=125;kappa[s_]=1;tau[s_]:=Sin[s];width=1.0;ds=.1;
pribbonfrenet
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 277; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.08079 
MathPictureStart
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0260524 1.10184 0.0275459 1.10184 [
[ 0 0 0 0 ]
[ 1 1.08079 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
0 0 m
1 0 L
1 1.08079 L
0 1.08079 L
closepath
clip
newpath
p
.002  w
.11113  .25957  m
.02755  .78701  L
s
.02755  .78701  m
.40586  1.05324 L
s
.40586  1.05324 m
.42251  .57709  L
s
.42251  .57709  m
.11113  .25957  L
s
.66295  .02755  m
.90359  .41965  L
s
.90359  .41965  m
.97245  .92345  L
s
.97245  .92345  m
.69507  .58075  L
s
.69507  .58075  m
.66295  .02755  L
s
.11113  .25957  m
.02755  .78701  L
s
.02755  .78701  m
.69507  .58075  L
s
.69507  .58075  m
.66295  .02755  L
s
.66295  .02755  m
.11113  .25957  L
s
.42251  .57709  m
.90359  .41965  L
s
.90359  .41965  m
.97245  .92345  L
s
.97245  .92345  m
.40586  1.05324 L
s
.40586  1.05324 m
.42251  .57709  L
s
P
p
.45735  .62859  m .42734  .61901  L .44848  .60758  L .489  .902  .836  r
F
P
p
.42734  .61901  m .42718  .61896  L .4274  .61884  L .489  .902  .836  r
F
P
p
.42734  .61901  m .4274  .61884  L .44848  .60758  L .489  .902  .836  r
F
P
p
.44848  .60758  m .4274  .61884  L .44823  .60948  L 0 0 0 r
F
P
p
.4274  .61884  m .42718  .61896  L .44823  .60948  L 0 0 0 r
F
P
p
.44848  .60758  m .44823  .60948  L .4392  .58664  L 0 0 0 r
F
P
p
.43933  .58669  m .44823  .60948  L .46944  .59938  L 0 0 0 r
F
P
p
.4392  .58664  m .43928  .58684  L .43933  .58669  L 0 0 0 r
F
P
p
.43928  .58684  m .44823  .60948  L .43933  .58669  L 0 0 0 r
F
P
p
.25  g
.004  w
.4274  .61884  m
.44765  .60802  L
s
P
p
.4392  .58664  m .46944  .59938  L .42974  .56584  L 0 0 0 r
F
P
p
.25  g
.004  w
.4392  .58664  m
.43928  .58684  L
s
P
p
.45735  .62859  m .40685  .62784  L .42718  .61896  L .489  .902  .836  r
F
P
p
.25  g
.004  w
.42718  .61896  m
.4274  .61884  L
s
P
p
.46558  .64961  m .40685  .62784  L .45735  .62859  L .619  .948  .937  r
F
P
p
.006  w
.44911  .60906  m
.45735  .62859  L
s
P
p
.42974  .56584  m .49022  .58866  L .42037  .54524  L .202  0 0 r
F
P
p
.42974  .56584  m .46944  .59938  L .49022  .58866  L .202  0 0 r
F
P
p
.25  g
.004  w
.44813  .60923  m
.44823  .60948  L
s
P
p
.006  w
.42974  .56584  m
.4392  .58664  L
s
P
p
.25  g
.004  w
.42974  .56584  m
.43009  .56613  L
s
P
p
.46558  .64961  m .38773  .63615  L .40685  .62784  L .619  .948  .937  r
F
P
p
.25  g
.004  w
.40685  .62784  m
.45735  .62859  L
s
P
p
.47295  .67056  m .38773  .63615  L .46558  .64961  L .68  .933  .968  r
F
P
p
.006  w
.45735  .62859  m
.46558  .64961  L
s
P
p
.42037  .54524  m .51  .57733  L .41132  .5249  L .356  0 .107  r
F
P
p
.42037  .54524  m .49022  .58866  L .51  .57733  L .356  0 .107  r
F
P
p
.25  g
.004  w
.46901  .59901  m
.46944  .59938  L
s
P
p
.006  w
.42037  .54524  m
.42974  .56584  L
s
P
p
.25  g
.004  w
.42097  .54562  m
.42098  .54563  L
s
P
p
.25  g
.004  w
.42037  .54524  m
.42097  .54562  L
s
P
p
.25  g
.004  w
.44813  .60923  m
.44813  .60923  L
s
P
p
.25  g
.004  w
.43928  .58684  m
.44813  .60923  L
s
P
p
.47295  .67056  m .37019  .64389  L .38773  .63615  L .68  .933  .968  r
F
P
p
.47926  .69136  m .37019  .64389  L .47295  .67056  L .704  .897  .966  r
F
P
p
.25  g
.004  w
.46493  .6495  m
.46558  .64961  L
s
P
p
.006  w
.46558  .64961  m
.47295  .67056  L
s
P
p
.47926  .69136  m .35448  .65108  L .37019  .64389  L .704  .897  .966  r
F
P
p
.25  g
.004  w
.37019  .64389  m
.37113  .64414  L
s
P
p
.25  g
.004  w
.38773  .63615  m
.46493  .6495  L
s
P
p
.48434  .71192  m .35448  .65108  L .47926  .69136  L .708  .857  .953  r
F
P
p
.25  g
.004  w
.47211  .67035  m
.47295  .67056  L
s
P
p
.006  w
.47295  .67056  m
.47926  .69136  L
s
P
p
.41132  .5249  m .52826  .56545  L .40288  .50487  L .462  .087  .241  r
F
P
p
.41132  .5249  m .51  .57733  L .52826  .56545  L .462  .087  .241  r
F
P
p
.25  g
.004  w
.48946  .58818  m
.49022  .58866  L
s
P
p
.006  w
.41132  .5249  m
.42037  .54524  L
s
P
p
.25  g
.004  w
.41132  .5249  m
.4122  .52537  L
s
P
p
.25  g
.004  w
.4122  .52537  m
.41221  .52537  L
s
P
p
.25  g
.004  w
.469  .59901  m
.46901  .59901  L
s
P
p
.25  g
.004  w
.43009  .56613  m
.469  .59901  L
s
P
p
.48434  .71192  m .34075  .65767  L .35448  .65108  L .708  .857  .953  r
F
P
p
.48804  .73214  m .34075  .65767  L .48434  .71192  L .703  .818  .936  r
F
P
p
.25  g
.004  w
.47826  .69104  m
.47926  .69136  L
s
P
p
.006  w
.47926  .69136  m
.48434  .71192  L
s
P
p
.40288  .50487  m .5446  .55311  L .39528  .48519  L .535  .192  .333  r
F
P
p
.40288  .50487  m .52826  .56545  L .5446  .55311  L .535  .192  .333  r
F
P
p
.25  g
.004  w
.48946  .58818  m
.48946  .58818  L
s
P
p
.25  g
.004  w
.50894  .57677  m
.51  .57733  L
s
P
p
.006  w
.40288  .50487  m
.41132  .5249  L
s
P
p
.25  g
.004  w
.40288  .50487  m
.40402  .50542  L
s
P
p
.25  g
.004  w
.40402  .50542  m
.40403  .50542  L
s
P
p
.48804  .73214  m .329  .66362  L .34075  .65767  L .703  .818  .936  r
F
P
p
.4902  .75191  m .329  .66362  L .48804  .73214  L .694  .782  .919  r
F
P
p
.25  g
.004  w
.48321  .7115  m
.48434  .71192  L
s
P
p
.006  w
.48434  .71192  m
.48804  .73214  L
s
P
p
.39528  .48519  m .55874  .54043  L .38879  .46593  L .589  .271  .397  r
F
P
p
.39528  .48519  m .5446  .55311  L .55874  .54043  L .589  .271  .397  r
F
P
p
.25  g
.004  w
.50894  .57677  m
.50894  .57677  L
s
P
p
.25  g
.004  w
.52694  .56482  m
.52826  .56545  L
s
P
p
.006  w
.39528  .48519  m
.40288  .50487  L
s
P
p
.25  g
.004  w
.39528  .48519  m
.39621  .48562  L
s
P
p
.25  g
.004  w
.39621  .48562  m
.39668  .48583  L
s
P
p
.25  g
.004  w
.42098  .54563  m
.48946  .58818  L
s
P
p
.4902  .75191  m .31919  .66886  L .329  .66362  L .694  .782  .919  r
F
P
p
.49073  .77111  m .31919  .66886  L .4902  .75191  L .682  .748  .901  r
F
P
p
.25  g
.004  w
.48681  .73162  m
.48804  .73214  L
s
P
p
.006  w
.48804  .73214  m
.4902  .75191  L
s
P
p
.38879  .46593  m .57055  .52756  L .38364  .44713  L .631  .332  .444  r
F
P
p
.38879  .46593  m .55874  .54043  L .57055  .52756  L .631  .332  .444  r
F
P
p
.25  g
.004  w
.52693  .56481  m
.52694  .56482  L
s
P
p
.25  g
.004  w
.54308  .55242  m
.5446  .55311  L
s
P
p
.006  w
.38879  .46593  m
.39528  .48519  L
s
P
p
.25  g
.004  w
.38879  .46593  m
.38989  .46641  L
s
P
p
.25  g
.004  w
.38989  .46641  m
.39043  .46665  L
s
P
p
.49073  .77111  m .3112  .67329  L .31919  .66886  L .682  .748  .901  r
F
P
p
.48952  .7896  m .3112  .67329  L .49073  .77111  L .669  .717  .884  r
F
P
p
.25  g
.004  w
.48894  .7513  m
.4902  .75191  L
s
P
p
.006  w
.4902  .75191  m
.49073  .77111  L
s
P
p
.38364  .44713  m .58003  .51468  L .38006  .42885  L .666  .381  .479  r
F
P
p
.38364  .44713  m .57055  .52756  L .58003  .51468  L .666  .381  .479  r
F
P
p
.25  g
.004  w
.54305  .55241  m
.54308  .55242  L
s
P
p
.25  g
.004  w
.55708  .5397  m
.55874  .54043  L
s
P
p
.006  w
.38364  .44713  m
.38879  .46593  L
s
P
p
.25  g
.004  w
.38364  .44713  m
.38365  .44713  L
s
P
p
.25  g
.004  w
.38365  .44713  m
.3849  .44767  L
s
P
p
.25  g
.004  w
.3849  .44767  m
.3855  .44793  L
s
P
p
.25  g
.004  w
.41221  .52537  m
.50894  .57677  L
s
P
p
.44065  .29793  m .53587  .37812  L .45823  .28859  L .9  .674  .586  r
F
P
p
.53587  .37812  m .55162  .39138  L .51562  .34676  L .9  .674  .586  r
F
P
p
.55162  .39138  m .54385  .37538  L .51562  .34676  L .9  .674  .586  r
F
P
p
.53587  .37812  m .51562  .34676  L .45823  .28859  L .9  .674  .586  r
F
P
p
.42507  .30856  m .55661  .4025  L .44065  .29793  L .88  .64  .571  r
F
P
p
.55661  .4025  m .56346  .40739  L .5518  .39253  L .88  .64  .571  r
F
P
p
.56346  .40739  m .5612  .40053  L .5518  .39253  L .88  .64  .571  r
F
P
p
.55661  .4025  m .5518  .39253  L .44065  .29793  L .88  .64  .571  r
F
P
p
.41164  .32038  m .54263  .40136  L .42507  .30856  L .857  .614  .569  r
F
P
p
.55592  .41808  m .57419  .43929  L .56228  .42608  L .966  .667  .409  r
F
P
p
.55043  .41117  m .55584  .41757  L .55592  .41808  L .966  .667  .409  r
F
P
p
.55584  .41757  m .57419  .43929  L .55592  .41808  L .966  .667  .409  r
F
P
p
.55032  .41059  m .57419  .43929  L .55043  .41117  L .966  .667  .409  r
F
P
p
.54258  .40115  m .57419  .43929  L .54263  .40136  L .966  .667  .409  r
F
P
p
.56228  .42608  m .57419  .43929  L .57376  .44035  L .966  .667  .409  r
F
P
p
.54263  .40136  m .53007  .38554  L .42507  .30856  L .857  .614  .569  r
F
P
p
.53003  .38543  m .57419  .43929  L .5303  .38633  L .966  .667  .409  r
F
P
p
.55886  .43591  m .56279  .438  L .55761  .42833  L .812  .564  .564  r
F
P
p
.42507  .30856  m .53007  .38554  L .52931  .383  L .88  .64  .571  r
F
P
p
.5054  .35469  m .57419  .43929  L .50599  .35611  L .966  .667  .409  r
F
P
p
.54263  .40136  m .55032  .41059  L .55043  .41117  L .966  .667  .409  r
F
P
p
.53977  .39776  m .54258  .40115  L .54263  .40136  L .966  .667  .409  r
F
P
p
.41164  .32038  m .54365  .40562  L .54263  .40136  L .857  .614  .569  r
F
P
p
.54263  .40136  m .54979  .40578  L .53007  .38554  L .857  .614  .569  r
F
P
p
.5303  .38633  m .53977  .39776  L .56228  .42608  L .966  .667  .409  r
F
P
p
.54273  .40179  m .57305  .43946  L .55316  .40769  L .966  .667  .409  r
F
P
p
.57305  .43946  m .57376  .44035  L .57299  .43913  L .966  .667  .409  r
F
P
p
.57305  .43946  m .57299  .43913  L .55316  .40769  L .966  .667  .409  r
F
P
p
.54979  .40578  m .54332  .39526  L .53007  .38554  L .857  .614  .569  r
F
P
p
.54263  .40136  m .54524  .4032  L .54979  .40578  L .857  .614  .569  r
F
P
p
.558  .41813  m .56098  .4201  L .56133  .42351  L .982  .697  .387  r
F
P
p
.56098  .4201  m .57343  .43982  L .56133  .42351  L .982  .697  .387  r
F
P
p
.55347  .40982  m .55334  .40894  L .54263  .40136  L .857  .614  .569  r
F
P
p
.54365  .40562  m .55381  .41219  L .54263  .40136  L .857  .614  .569  r
F
P
p
.5512  .40966  m .55347  .40982  L .54263  .40136  L .857  .614  .569  r
F
P
p
.55381  .41219  m .55365  .41109  L .5512  .40966  L .857  .614  .569  r
F
P
p
.55365  .41109  m .55347  .40982  L .5512  .40966  L .857  .614  .569  r
F
P
p
.54273  .40179  m .55316  .40769  L .54684  .39768  L .966  .667  .409  r
F
P
p
.55316  .40769  m .55759  .41471  L .55316  .40771  L .982  .697  .387  r
F
P
p
.55759  .41471  m .57376  .44035  L .55759  .41473  L .982  .697  .387  r
F
P
p
.55759  .41471  m .55759  .41473  L .55316  .40771  L .982  .697  .387  r
F
P
p
.55246  .42145  m .55886  .42516  L .55128  .41549  L .835  .589  .567  r
F
P
p
.55365  .41109  m .55776  .41614  L .558  .41813  L .982  .697  .387  r
F
P
p
.55776  .41614  m .56098  .4201  L .558  .41813  L .982  .697  .387  r
F
P
p
.55316  .40771  m .56098  .4201  L .56056  .41958  L .982  .697  .387  r
F
P
p
.55319  .40788  m .56056  .41958  L .55365  .41109  L .982  .697  .387  r
F
P
p
.55316  .40771  m .56056  .41958  L .55319  .40788  L .982  .697  .387  r
F
P
p
.54273  .40179  m .54684  .39768  L .53616  .39035  L .966  .667  .409  r
F
P
p
.54979  .40578  m .55319  .40788  L .54332  .39526  L .857  .614  .569  r
F
P
p
.54684  .39768  m .55316  .40769  L .54684  .39769  L .982  .697  .387  r
F
P
p
.52931  .383  m .54657  .39614  L .5464  .3952  L .88  .64  .571  r
F
P
p
.55316  .40769  m .55316  .40771  L .54685  .3977  L .982  .697  .387  r
F
P
p
.54583  .39699  m .54657  .39614  L .52931  .383  L .88  .64  .571  r
F
P
p
.54688  .39787  m .54684  .39768  L .54583  .39699  L .88  .64  .571  r
F
P
p
.54684  .39768  m .54657  .39614  L .54583  .39699  L .88  .64  .571  r
F
P
p
.50599  .35611  m .53003  .38543  L .5303  .38633  L .966  .667  .409  r
F
P
p
.44065  .29793  m .50435  .35215  L .50399  .35127  L .9  .674  .586  r
F
P
p
.45292  .29015  m .5054  .35469  L .50599  .35611  L .966  .667  .409  r
F
P
p
.55756  .41059  m .56026  .41226  L .55741  .40927  L .857  .614  .569  r
F
P
p
.55316  .40769  m .54685  .3977  L .54684  .39769  L .982  .697  .387  r
F
P
p
.50399  .35127  m .53602  .37872  L .53587  .37812  L .9  .674  .586  r
F
P
p
.53007  .38554  m .54688  .39787  L .52931  .383  L .88  .64  .571  r
F
P
p
.50435  .35215  m .53614  .3792  L .50399  .35127  L .9  .674  .586  r
F
P
p
.53614  .3792  m .5518  .39253  L .53602  .37872  L .9  .674  .586  r
F
P
p
.5518  .39253  m .55175  .3922  L .53602  .37872  L .9  .674  .586  r
F
P
p
.53587  .37812  m .55169  .39179  L .55162  .39138  L .9  .674  .586  r
F
P
p
.56133  .42351  m .57343  .43982  L .57303  .44243  L .982  .697  .387  r
F
P
p
.57303  .44243  m .57343  .43982  L .57344  .4431  L .982  .697  .387  r
F
P
p
.558  .41813  m .57283  .44212  L .56305  .42055  L .982  .697  .387  r
F
P
p
.57283  .44212  m .57283  .44201  L .56305  .42055  L .982  .697  .387  r
F
P
p
.57303  .44243  m .57297  .44208  L .56305  .42055  L .982  .697  .387  r
F
P
p
.56279  .438  m .5688  .44118  L .56213  .43147  L .812  .564  .564  r
F
P
p
.5696  .44147  m .5732  .44743  L .57302  .45317  L .952  .706  .249  r
F
P
p
.56865  .43824  m .56954  .44003  L .5696  .44147  L .952  .706  .249  r
F
P
p
.56954  .44003  m .5732  .44743  L .5696  .44147  L .952  .706  .249  r
F
P
p
.56545  .43013  m .57344  .4431  L .5732  .44743  L .983  .712  .332  r
F
P
p
.56348  .42574  m .56509  .42507  L .56545  .43013  L .983  .712  .332  r
F
P
p
.57283  .44212  m .57303  .44243  L .57283  .44201  L .982  .697  .387  r
F
P
p
.57303  .44243  m .57344  .4431  L .57297  .44208  L .982  .697  .387  r
F
P
p
.56509  .42507  m .57344  .4431  L .56545  .43013  L .983  .712  .332  r
F
P
p
.56306  .42067  m .57344  .4431  L .56306  .42068  L .983  .712  .332  r
F
P
p
.53602  .37872  m .55175  .3922  L .53587  .37812  L .9  .674  .586  r
F
P
p
.55175  .3922  m .55172  .392  L .53587  .37812  L .9  .674  .586  r
F
P
p
.56118  .40028  m .56117  .40018  L .55171  .39193  L .9  .674  .586  r
F
P
p
.55172  .392  m .55171  .39193  L .53587  .37812  L .9  .674  .586  r
F
P
p
.56118  .40028  m .55171  .39193  L .55172  .392  L .9  .674  .586  r
F
P
p
.56116  .40013  m .56115  .39997  L .55169  .39179  L .9  .674  .586  r
F
P
p
.56752  .40571  m .55169  .39179  L .55171  .39193  L .9  .674  .586  r
F
P
p
.55175  .3922  m .56118  .40028  L .55172  .392  L .9  .674  .586  r
F
P
p
.55319  .40788  m .54755  .39895  L .54332  .39526  L .857  .614  .569  r
F
P
p
.54683  .39767  m .55316  .40771  L .55264  .40701  L .982  .697  .387  r
F
P
p
.54755  .39895  m .54688  .39787  L .54332  .39526  L .857  .614  .569  r
F
P
p
.54669  .39758  m .55264  .40701  L .54428  .39592  L .982  .697  .387  r
F
P
p
.54683  .39767  m .55264  .40701  L .54669  .39758  L .982  .697  .387  r
F
P
p
.56488  .41392  m .56367  .41018  L .54688  .39787  L .857  .614  .569  r
F
P
p
.56492  .41405  m .54688  .39787  L .54755  .39895  L .857  .614  .569  r
F
P
p
.56924  .41781  m .56488  .41392  L .56492  .41405  L .857  .614  .569  r
F
P
p
.56488  .41392  m .54688  .39787  L .56492  .41405  L .857  .614  .569  r
F
P
p
.56026  .41226  m .55844  .40841  L .54755  .39895  L .857  .614  .569  r
F
P
p
.55365  .41109  m .558  .41813  L .56054  .41511  L .982  .697  .387  r
F
P
p
.558  .41813  m .56305  .42055  L .56054  .41511  L .982  .697  .387  r
F
P
p
.54688  .39787  m .55693  .40525  L .54657  .39614  L .88  .64  .571  r
F
P
p
.55693  .40525  m .55678  .40391  L .54657  .39614  L .88  .64  .571  r
F
P
p
.55171  .39193  m .55169  .39179  L .53587  .37812  L .9  .674  .586  r
F
P
p
.56306  .42067  m .56306  .42068  L .56056  .41529  L .983  .712  .332  r
F
P
p
.54979  .40578  m .56037  .41342  L .56026  .41226  L .857  .614  .569  r
F
P
p
.54524  .4032  m .56043  .41396  L .54979  .40578  L .857  .614  .569  r
F
P
p
.56043  .41396  m .5655  .41756  L .56037  .41342  L .857  .614  .569  r
F
P
p
.5655  .41756  m .56547  .41709  L .56037  .41342  L .857  .614  .569  r
F
P
p
.57234  .41972  m .6003  .44221  L .59999  .43681  L .857  .614  .569  r
F
P
p
.56536  .41541  m .56928  .419  L .56924  .41781  L .857  .614  .569  r
F
P
p
.56026  .41226  m .5654  .4161  L .56536  .41541  L .857  .614  .569  r
F
P
p
.5654  .4161  m .56928  .419  L .56536  .41541  L .857  .614  .569  r
F
P
p
.56037  .41342  m .56931  .41986  L .56026  .41226  L .857  .614  .569  r
F
P
p
.56931  .41986  m .5693  .41958  L .56026  .41226  L .857  .614  .569  r
F
P
p
.57236  .42206  m .57235  .4213  L .56026  .41226  L .857  .614  .569  r
F
P
p
.56043  .41396  m .56037  .41342  L .54979  .40578  L .857  .614  .569  r
F
P
p
.56306  .42067  m .56056  .41528  L .56056  .41528  L .983  .712  .332  r
F
P
p
.56306  .42067  m .56056  .41529  L .56056  .41528  L .983  .712  .332  r
F
P
p
.55693  .40525  m .56853  .41375  L .55678  .40391  L .88  .64  .571  r
F
P
p
.56853  .41375  m .57226  .41648  L .56849  .41283  L .88  .64  .571  r
F
P
p
.57226  .41648  m .57225  .4157  L .56849  .41283  L .88  .64  .571  r
F
P
p
.56931  .41986  m .57236  .42206  L .5693  .41958  L .857  .614  .569  r
F
P
p
.56924  .41781  m .57235  .4213  L .57234  .41972  L .857  .614  .569  r
F
P
p
.56928  .419  m .57235  .4213  L .56924  .41781  L .857  .614  .569  r
F
P
p
.5655  .41756  m .6003  .44221  L .56547  .41709  L .857  .614  .569  r
F
P
p
.56853  .41375  m .56849  .41283  L .55678  .40391  L .88  .64  .571  r
F
P
p
.55101  .40486  m .55316  .40771  L .55365  .41109  L .982  .697  .387  r
F
P
p
.55756  .41059  m .55741  .40927  L .54755  .39895  L .857  .614  .569  r
F
P
p
.55319  .40788  m .55756  .41059  L .54755  .39895  L .857  .614  .569  r
F
P
p
.5464  .3952  m .55673  .40353  L .55661  .4025  L .88  .64  .571  r
F
P
p
.54657  .39614  m .55678  .40391  L .5464  .3952  L .88  .64  .571  r
F
P
p
.55678  .40391  m .55673  .40353  L .5464  .3952  L .88  .64  .571  r
F
P
p
.5694  .42225  m .56933  .42027  L .56043  .41396  L .857  .614  .569  r
F
P
p
.56052  .41489  m .56043  .41396  L .55334  .40894  L .857  .614  .569  r
F
P
p
.5694  .42225  m .56043  .41396  L .56052  .41489  L .857  .614  .569  r
F
P
p
.56306  .42067  m .56056  .41528  L .56056  .41528  L .983  .712  .332  r
F
P
p
.56057  .41536  m .55334  .40894  L .55347  .40982  L .857  .614  .569  r
F
P
p
.56056  .41527  m .56306  .42067  L .56056  .41528  L .983  .712  .332  r
F
P
p
.56052  .41489  m .55334  .40894  L .56057  .41536  L .857  .614  .569  r
F
P
p
.55381  .41219  m .56069  .41663  L .55347  .40982  L .857  .614  .569  r
F
P
p
.56054  .41511  m .56305  .42055  L .56056  .41527  L .983  .712  .332  r
F
P
p
.56305  .42055  m .57344  .4431  L .56306  .42067  L .983  .712  .332  r
F
P
p
.56305  .42055  m .56306  .42067  L .56056  .41527  L .983  .712  .332  r
F
P
p
.55827  .42029  m .56332  .42377  L .55814  .41923  L .835  .589  .567  r
F
P
p
.40044  .33329  m .56317  .42197  L .41164  .32038  L .835  .589  .567  r
F
P
p
.56306  .42068  m .56466  .42415  L .56382  .42338  L .983  .712  .332  r
F
P
p
.56306  .42068  m .56382  .42338  L .56317  .42197  L .983  .712  .332  r
F
P
p
.56317  .42197  m .56069  .41663  L .41164  .32038  L .835  .589  .567  r
F
P
p
.56332  .42377  m .56324  .42286  L .55814  .41923  L .835  .589  .567  r
F
P
p
.56069  .41663  m .56057  .41536  L .55347  .40982  L .857  .614  .569  r
F
P
p
.55365  .41109  m .56054  .41511  L .49627  .27561  L .982  .697  .387  r
F
P
p
.5635  .42594  m .56332  .42377  L .55827  .42029  L .835  .589  .567  r
F
P
p
.55814  .41923  m .56324  .42286  L .56317  .42197  L .835  .589  .567  r
F
P
p
.55787  .41321  m .56306  .42068  L .56348  .42574  L .983  .712  .332  r
F
P
p
.55728  .40821  m .56306  .42068  L .55787  .41321  L .983  .712  .332  r
F
P
p
.57455  .42818  m .6003  .44221  L .57486  .42578  L .835  .589  .567  r
F
P
p
.56712  .42638  m .60031  .4492  L .56707  .42558  L .835  .589  .567  r
F
P
p
.57343  .43982  m .57376  .44035  L .57344  .4431  L .982  .697  .387  r
F
P
p
.57262  .44321  m .59983  .45764  L .57259  .43873  L .812  .564  .564  r
F
P
p
.57226  .41648  m .59999  .43681  L .57225  .4157  L .88  .64  .571  r
F
P
p
.57236  .42206  m .6003  .44221  L .57235  .4213  L .857  .614  .569  r
F
P
p
.57235  .4213  m .6003  .44221  L .57234  .41972  L .857  .614  .569  r
F
P
p
.56348  .42574  m .57285  .44667  L .56719  .42759  L .983  .712  .332  r
F
P
p
.57285  .44667  m .57285  .44647  L .56719  .42759  L .983  .712  .332  r
F
P
p
.57302  .44704  m .5732  .44743  L .57295  .44663  L .983  .712  .332  r
F
P
p
.57302  .44704  m .57295  .44663  L .56719  .42759  L .983  .712  .332  r
F
P
p
.56882  .43308  m .5732  .44743  L .57251  .44552  L .952  .706  .249  r
F
P
p
.56882  .43308  m .57251  .44552  L .56946  .43699  L .952  .706  .249  r
F
P
p
.56852  .43394  m .56946  .43699  L .56845  .43416  L .952  .706  .249  r
F
P
p
.56882  .43308  m .56946  .43699  L .56852  .43394  L .952  .706  .249  r
F
P
p
.39153  .34719  m .56842  .43362  L .40044  .33329  L .812  .564  .564  r
F
P
p
.56882  .43308  m .56845  .43416  L .56837  .43249  L .952  .706  .249  r
F
P
p
.56842  .43362  m .56733  .43007  L .40044  .33329  L .812  .564  .564  r
F
P
p
.5672  .42777  m .56882  .43308  L .56739  .4312  L .952  .706  .249  r
F
P
p
.56317  .42197  m .57455  .42818  L .56069  .41663  L .835  .589  .567  r
F
P
p
.56466  .42415  m .56509  .42507  L .56324  .42286  L .983  .712  .332  r
F
P
p
.56332  .42377  m .56712  .42638  L .56324  .42286  L .835  .589  .567  r
F
P
p
.56712  .42638  m .56707  .42558  L .56324  .42286  L .835  .589  .567  r
F
P
p
.57455  .42818  m .57486  .42578  L .56069  .41663  L .835  .589  .567  r
F
P
p
.56317  .42197  m .56382  .42338  L .56324  .42286  L .983  .712  .332  r
F
P
p
.56324  .42286  m .56509  .42507  L .56348  .42574  L .983  .712  .332  r
F
P
p
.56069  .41663  m .5694  .42225  L .56057  .41536  L .857  .614  .569  r
F
P
p
.5694  .42225  m .56052  .41489  L .56057  .41536  L .857  .614  .569  r
F
P
p
.55678  .40391  m .56457  .40985  L .55673  .40353  L .88  .64  .571  r
F
P
p
.56733  .43007  m .56712  .42638  L .56332  .42377  L .835  .589  .567  r
F
P
p
.56733  .43007  m .56332  .42377  L .5635  .42594  L .835  .589  .567  r
F
P
p
.5518  .39253  m .56753  .40591  L .55175  .3922  L .9  .674  .586  r
F
P
p
.56753  .40591  m .57214  .40984  L .56752  .40585  L .9  .674  .586  r
F
P
p
.56753  .40591  m .56752  .40585  L .55175  .3922  L .9  .674  .586  r
F
P
p
.57214  .40984  m .57214  .40979  L .56752  .40581  L .9  .674  .586  r
F
P
p
.56752  .40585  m .56752  .40581  L .55175  .3922  L .9  .674  .586  r
F
P
p
.57214  .40984  m .56752  .40581  L .56752  .40585  L .9  .674  .586  r
F
P
p
.57574  .4129  m .57574  .41276  L .57214  .40967  L .9  .674  .586  r
F
P
p
.56752  .40581  m .56752  .40571  L .55175  .3922  L .9  .674  .586  r
F
P
p
.57577  .41172  m .59951  .43313  L .59896  .43125  L .9  .674  .586  r
F
P
p
.56747  .40473  m .57213  .40927  L .57213  .40865  L .9  .674  .586  r
F
P
p
.55162  .39138  m .56749  .40522  L .56747  .40473  L .9  .674  .586  r
F
P
p
.56749  .40522  m .57213  .40927  L .56747  .40473  L .9  .674  .586  r
F
P
p
.55169  .39179  m .57214  .40947  L .55162  .39138  L .9  .674  .586  r
F
P
p
.57214  .40947  m .59951  .43313  L .57213  .40927  L .9  .674  .586  r
F
P
p
.57214  .40947  m .57213  .40927  L .55162  .39138  L .9  .674  .586  r
F
P
p
.56026  .41226  m .56924  .41781  L .55844  .40841  L .857  .614  .569  r
F
P
p
.55661  .4025  m .56457  .40985  L .57225  .41496  L .88  .64  .571  r
F
P
p
.57223  .41365  m .57225  .41496  L .59951  .43313  L .88  .64  .571  r
F
P
p
.55661  .4025  m .57225  .41496  L .57223  .41365  L .88  .64  .571  r
F
P
p
.56831  .43129  m .5732  .44743  L .56831  .43143  L .952  .706  .249  r
F
P
p
.57268  .44555  m .59859  .46734  L .59983  .45764  L .79  .54  .559  r
F
P
p
.56859  .43688  m .5693  .43851  L .56865  .43824  L .952  .706  .249  r
F
P
p
.57152  .44359  m .5732  .44743  L .57162  .44424  L .952  .706  .249  r
F
P
p
.5656  .43224  m .56846  .43436  L .56842  .43362  L .812  .564  .564  r
F
P
p
.57285  .44667  m .57302  .44704  L .57285  .44647  L .983  .712  .332  r
F
P
p
.5688  .44118  m .56854  .43592  L .56213  .43147  L .812  .564  .564  r
F
P
p
.56854  .43592  m .56846  .43436  L .5656  .43224  L .812  .564  .564  r
F
P
p
.56739  .4312  m .56845  .43416  L .56759  .4346  L .952  .706  .249  r
F
P
p
.56845  .43416  m .5732  .44743  L .56859  .43688  L .952  .706  .249  r
F
P
p
.56572  .43397  m .56854  .43592  L .5656  .43224  L .812  .564  .564  r
F
P
p
.56845  .43416  m .56859  .43688  L .56759  .4346  L .952  .706  .249  r
F
P
p
.56854  .43592  m .57077  .43747  L .56846  .43436  L .812  .564  .564  r
F
P
p
.57077  .43747  m .57073  .43604  L .56846  .43436  L .812  .564  .564  r
F
P
p
.56846  .43436  m .57073  .43604  L .56842  .43362  L .812  .564  .564  r
F
P
p
.57073  .43604  m .59983  .45764  L .57071  .43537  L .812  .564  .564  r
F
P
p
.57073  .43604  m .57071  .43537  L .56842  .43362  L .812  .564  .564  r
F
P
p
.56865  .43824  m .57302  .45317  L .57082  .43916  L .952  .706  .249  r
F
P
p
.55673  .40353  m .56457  .40985  L .55661  .4025  L .88  .64  .571  r
F
P
p
.56698  .42405  m .57006  .4277  L .56999  .42569  L .835  .589  .567  r
F
P
p
.56317  .42197  m .56705  .4252  L .56698  .42405  L .835  .589  .567  r
F
P
p
.56705  .4252  m .57006  .4277  L .56698  .42405  L .835  .589  .567  r
F
P
p
.56324  .42286  m .56707  .42558  L .56317  .42197  L .835  .589  .567  r
F
P
p
.56707  .42558  m .57006  .4277  L .56705  .4252  L .835  .589  .567  r
F
P
p
.56707  .42558  m .56705  .4252  L .56317  .42197  L .835  .589  .567  r
F
P
p
.56831  .43129  m .56831  .43143  L .5672  .42777  L .952  .706  .249  r
F
P
p
.55162  .39138  m .56747  .40473  L .54385  .37538  L .9  .674  .586  r
F
P
p
.56747  .40473  m .56712  .40276  L .54385  .37538  L .9  .674  .586  r
F
P
p
.57213  .40865  m .57201  .40393  L .56629  .39813  L .9  .674  .586  r
F
P
p
.57213  .40865  m .56629  .39813  L .56712  .40276  L .9  .674  .586  r
F
P
p
.56747  .40473  m .57213  .40865  L .56712  .40276  L .9  .674  .586  r
F
P
p
.57214  .40979  m .57214  .40967  L .56752  .40571  L .9  .674  .586  r
F
P
p
.57214  .40979  m .56752  .40571  L .56752  .40581  L .9  .674  .586  r
F
P
p
.56831  .43129  m .5672  .42777  L .56719  .42769  L .952  .706  .249  r
F
P
p
.56719  .42759  m .56831  .43129  L .56719  .42769  L .952  .706  .249  r
F
P
p
.56842  .43362  m .60031  .4492  L .56733  .43007  L .812  .564  .564  r
F
P
p
.56842  .43362  m .59983  .45764  L .60031  .4492  L .812  .564  .564  r
F
P
p
.56733  .43007  m .60031  .4492  L .56712  .42638  L .835  .589  .567  r
F
P
p
.56752  .40571  m .59951  .43313  L .5675  .40547  L .9  .674  .586  r
F
P
p
.56457  .40985  m .59999  .43681  L .59961  .4339  L .88  .64  .571  r
F
P
p
.56457  .40985  m .59961  .4339  L .59951  .43313  L .88  .64  .571  r
F
P
p
.56999  .42569  m .60031  .4492  L .6003  .44221  L .835  .589  .567  r
F
P
p
.57006  .4277  m .60031  .4492  L .56999  .42569  L .835  .589  .567  r
F
P
p
.5694  .42225  m .6003  .44221  L .56933  .42027  L .857  .614  .569  r
F
P
p
.56924  .41781  m .59999  .43681  L .56853  .41375  L .857  .614  .569  r
F
P
p
.56346  .40739  m .57223  .41365  L .5612  .40053  L .88  .64  .571  r
F
P
p
.57223  .41365  m .59951  .43313  L .57214  .40984  L .88  .64  .571  r
F
P
p
.57223  .41365  m .57214  .40984  L .5612  .40053  L .88  .64  .571  r
F
P
p
.56971  .44424  m .57136  .44556  L .57135  .44496  L .79  .54  .559  r
F
P
p
.3849  .362  m .57135  .44496  L .39153  .34719  L .79  .54  .559  r
F
P
p
.57083  .43933  m .57128  .44216  L .57113  .44363  L .87  .667  .139  r
F
P
p
.57083  .43933  m .57113  .44363  L .57092  .44231  L .87  .667  .139  r
F
P
p
.57128  .44216  m .57302  .45317  L .57139  .44661  L .87  .667  .139  r
F
P
p
.57135  .44496  m .57092  .44231  L .39153  .34719  L .79  .54  .559  r
F
P
p
.5701  .45329  m .57159  .45403  L .56971  .44424  L .79  .54  .559  r
F
P
p
.57127  .44203  m .57302  .45317  L .57127  .44203  L .87  .667  .139  r
F
P
p
.57366  .45505  m .59859  .46734  L .57377  .44748  L .79  .54  .559  r
F
P
p
.56712  .40276  m .56629  .39813  L .54385  .37538  L .9  .674  .586  r
F
P
p
.5671  .42755  m .56719  .42759  L .56704  .42711  L .983  .712  .332  r
F
P
p
.5671  .42755  m .56704  .42711  L .53635  .32577  L .983  .712  .332  r
F
P
p
.56348  .42574  m .5671  .42755  L .53635  .32577  L .983  .712  .332  r
F
P
p
.56719  .42769  m .5672  .42777  L .56588  .42347  L .952  .706  .249  r
F
P
p
.56587  .42324  m .56719  .42759  L .56716  .42758  L .952  .706  .249  r
F
P
p
.56719  .42759  m .56719  .42769  L .56716  .42758  L .952  .706  .249  r
F
P
p
.56587  .42324  m .56716  .42758  L .56588  .42347  L .952  .706  .249  r
F
P
p
.56837  .43249  m .56845  .43416  L .56739  .4312  L .952  .706  .249  r
F
P
p
.56588  .42347  m .5672  .42777  L .56617  .42777  L .952  .706  .249  r
F
P
p
.55886  .42516  m .56733  .43007  L .56317  .42558  L .835  .589  .567  r
F
P
p
.5672  .42777  m .56739  .4312  L .56617  .42777  L .952  .706  .249  r
F
P
p
.56865  .43824  m .57021  .4389  L .56854  .43592  L .812  .564  .564  r
F
P
p
.57085  .44004  m .57077  .43747  L .56854  .43592  L .812  .564  .564  r
F
P
p
.56924  .41781  m .56853  .41375  L .56367  .41018  L .857  .614  .569  r
F
P
p
.56924  .41781  m .56367  .41018  L .56488  .41392  L .857  .614  .569  r
F
P
p
.56752  .40571  m .5675  .40547  L .56115  .39997  L .9  .674  .586  r
F
P
p
.56752  .40571  m .56115  .39997  L .56116  .40013  L .9  .674  .586  r
F
P
p
.56759  .4346  m .56859  .43688  L .56865  .43824  L .952  .706  .249  r
F
P
p
.56118  .40028  m .56752  .40571  L .56117  .40018  L .9  .674  .586  r
F
P
p
.56865  .43824  m .57082  .43916  L .54421  .2695  L .952  .706  .249  r
F
P
p
.57033  .43603  m .57082  .43916  L .57034  .43624  L .87  .667  .139  r
F
P
p
.57082  .43916  m .57302  .45317  L .57083  .43933  L .87  .667  .139  r
F
P
p
.57082  .43916  m .57083  .43933  L .57034  .43624  L .87  .667  .139  r
F
P
p
.57262  .44321  m .57259  .43873  L .57077  .43747  L .812  .564  .564  r
F
P
p
.57082  .43916  m .57127  .44203  L .57082  .43916  L .87  .667  .139  r
F
P
p
.57262  .44321  m .57077  .43747  L .57085  .44004  L .812  .564  .564  r
F
P
p
.57091  .45047  m .57136  .44556  L .56971  .44424  L .79  .54  .559  r
F
P
p
.57159  .45403  m .5715  .45068  L .57091  .45047  L .79  .54  .559  r
F
P
p
.5715  .45068  m .57136  .44556  L .57091  .45047  L .79  .54  .559  r
F
P
p
.5688  .44118  m .57092  .44231  L .57021  .4389  L .812  .564  .564  r
F
P
p
.57127  .44203  m .57127  .44203  L .57082  .43916  L .87  .667  .139  r
F
P
p
.57128  .44216  m .57128  .4425  L .57124  .44248  L .87  .667  .139  r
F
P
p
.57128  .4425  m .57139  .44661  L .57124  .44248  L .87  .667  .139  r
F
P
p
.57124  .44248  m .57139  .44661  L .571  .44502  L .87  .667  .139  r
F
P
p
.57092  .44231  m .57262  .44321  L .57085  .44004  L .812  .564  .564  r
F
P
p
.57092  .44231  m .57085  .44004  L .57021  .4389  L .812  .564  .564  r
F
P
p
.57108  .44792  m .57302  .45317  L .5715  .45068  L .87  .667  .139  r
F
P
p
.5701  .44141  m .571  .44502  L .57108  .44792  L .87  .667  .139  r
F
P
p
.571  .44502  m .57302  .45317  L .57108  .44792  L .87  .667  .139  r
F
P
p
.57189  .45329  m .57302  .45317  L .57292  .46009  L .87  .667  .139  r
F
P
p
.5715  .45068  m .57185  .45125  L .57189  .45329  L .87  .667  .139  r
F
P
p
.57185  .45125  m .57302  .45317  L .57189  .45329  L .87  .667  .139  r
F
P
p
.5715  .45068  m .57292  .46009  L .57272  .45111  L .87  .667  .139  r
F
P
p
.57272  .45111  m .57277  .45353  L .57272  .45111  L .729  .587  .013  r
F
P
p
.57277  .45353  m .57292  .46009  L .57277  .45353  L .729  .587  .013  r
F
P
p
.57277  .45353  m .57277  .45353  L .57272  .45111  L .729  .587  .013  r
F
P
p
.57343  .45699  m .58416  .4669  L .59859  .46734  L .768  .514  .55  r
F
P
p
.58416  .4669  m .59631  .47811  L .59789  .47065  L .768  .514  .55  r
F
P
p
.58416  .4669  m .59789  .47065  L .59859  .46734  L .768  .514  .55  r
F
P
p
.57272  .45105  m .57269  .44661  L .57136  .44556  L .79  .54  .559  r
F
P
p
.57271  .4511  m .57272  .45105  L .57136  .44556  L .79  .54  .559  r
F
P
p
.57371  .45146  m .57377  .44748  L .57272  .45105  L .79  .54  .559  r
F
P
p
.57272  .45111  m .57272  .45105  L .57271  .4511  L .79  .54  .559  r
F
P
p
.57371  .45146  m .57272  .45105  L .57272  .45111  L .79  .54  .559  r
F
P
p
.57277  .45353  m .57277  .45353  L .57272  .45111  L .729  .587  .013  r
F
P
p
.57159  .45403  m .57275  .4546  L .57136  .44556  L .79  .54  .559  r
F
P
p
.57275  .4546  m .57272  .45117  L .57136  .44556  L .79  .54  .559  r
F
P
p
.57135  .44496  m .59983  .45764  L .57092  .44231  L .79  .54  .559  r
F
P
p
.57135  .44496  m .57269  .44661  L .57268  .44555  L .79  .54  .559  r
F
P
p
.57136  .44556  m .57269  .44661  L .57135  .44496  L .79  .54  .559  r
F
P
p
.57077  .43747  m .59983  .45764  L .57073  .43604  L .812  .564  .564  r
F
P
p
.5715  .45068  m .57272  .45111  L .56872  .26702  L .87  .667  .139  r
F
P
p
.57272  .45111  m .57272  .45111  L .57255  .44305  L .729  .587  .013  r
F
P
p
.57277  .45353  m .57272  .45111  L .57272  .45111  L .729  .587  .013  r
F
P
p
.57255  .44305  m .57272  .45111  L .57255  .44305  L .729  .587  .013  r
F
P
p
.57272  .45111  m .57277  .45353  L .57272  .45111  L .729  .587  .013  r
F
P
p
.57272  .45111  m .57272  .45111  L .57255  .44305  L .729  .587  .013  r
F
P
p
.57272  .45105  m .57377  .44748  L .57269  .44661  L .79  .54  .559  r
F
P
p
.57272  .45117  m .57272  .45111  L .57271  .4511  L .79  .54  .559  r
F
P
p
.57255  .44305  m .57272  .45111  L .57264  .45388  L .729  .587  .013  r
F
P
p
.38053  .37764  m .5728  .45673  L .3849  .362  L .768  .514  .55  r
F
P
p
.57272  .45111  m .57292  .46009  L .57283  .45813  L .729  .587  .013  r
F
P
p
.5728  .45673  m .57343  .45699  L .5728  .45667  L .768  .514  .55  r
F
P
p
.5728  .45673  m .5728  .45667  L .3849  .362  L .768  .514  .55  r
F
P
p
.57272  .45111  m .57283  .45813  L .57275  .4546  L .729  .587  .013  r
F
P
p
.57277  .45353  m .57292  .46009  L .57277  .45353  L .729  .587  .013  r
F
P
p
.57343  .45699  m .57366  .45505  L .57275  .4546  L .768  .514  .55  r
F
P
p
.5728  .45667  m .57275  .4546  L .3849  .362  L .768  .514  .55  r
F
P
p
.57343  .45699  m .57275  .4546  L .5728  .45667  L .768  .514  .55  r
F
P
p
.57269  .45214  m .57276  .45666  L .57264  .45388  L .729  .587  .013  r
F
P
p
.57272  .45111  m .57275  .4546  L .57269  .45214  L .729  .587  .013  r
F
P
p
.57275  .4546  m .57276  .45666  L .57269  .45214  L .729  .587  .013  r
F
P
p
.57275  .4546  m .57283  .45813  L .57276  .45666  L .729  .587  .013  r
F
P
p
.57366  .45505  m .57371  .45146  L .57272  .45111  L .79  .54  .559  r
F
P
p
.57366  .45505  m .57272  .45111  L .57272  .45117  L .79  .54  .559  r
F
P
p
.57219  .46688  m .57287  .4672  L .57196  .45639  L .768  .514  .55  r
F
P
p
.57287  .4672  m .5728  .45713  L .57196  .45639  L .768  .514  .55  r
F
P
p
.57196  .45639  m .5728  .45713  L .5728  .45673  L .768  .514  .55  r
F
P
p
.57264  .45388  m .57292  .46009  L .57294  .46791  L .729  .587  .013  r
F
P
p
.57285  .4638  m .57294  .46791  L .57335  .46394  L .729  .587  .013  r
F
P
p
.57335  .464  m .57294  .46791  L .57331  .46718  L 0 0 .108  r
F
P
p
.57331  .4674  m .59631  .47811  L .57342  .45769  L .768  .514  .55  r
F
P
p
.57356  .46185  m .57335  .46394  L .57356  .46195  L 0 0 .108  r
F
P
p
.57335  .46394  m .57294  .46791  L .57335  .464  L 0 0 .108  r
F
P
p
.57335  .46394  m .57335  .464  L .57356  .46195  L 0 0 .108  r
F
P
p
.5731  .46916  m .59631  .47811  L .57331  .4674  L .745  .486  .539  r
F
P
p
.5731  .46916  m .59266  .48974  L .59631  .47811  L .745  .486  .539  r
F
P
p
.5731  .46916  m .57294  .46791  L .573  .47003  L 0 0 .108  r
F
P
p
.573  .48096  m .59266  .48974  L .5731  .46916  L .745  .486  .539  r
F
P
p
.57334  .46711  m .573  .47003  L .57318  .47632  L 0 0 .108  r
F
P
p
.37834  .39404  m .573  .48096  L .5731  .46916  L .745  .486  .539  r
F
P
p
.57334  .46711  m .57311  .46756  L .5731  .46916  L 0 0 .108  r
F
P
p
.57311  .46756  m .57294  .46791  L .5731  .46916  L 0 0 .108  r
F
P
p
.57426  .4653  m .57334  .46711  L .57318  .47632  L 0 0 .108  r
F
P
p
.37834  .39404  m .5731  .46916  L .38053  .37764  L .745  .486  .539  r
F
P
p
.5731  .46916  m .57331  .4674  L .38053  .37764  L .745  .486  .539  r
F
P
p
.57287  .4672  m .57331  .4674  L .5728  .45713  L .768  .514  .55  r
F
P
p
.57331  .4674  m .57342  .45769  L .5728  .45713  L .768  .514  .55  r
F
P
p
.5728  .45673  m .57343  .4573  L .57343  .45699  L .768  .514  .55  r
F
P
p
.57343  .4573  m .59631  .47811  L .57343  .45699  L .768  .514  .55  r
F
P
p
.5728  .45713  m .59631  .47811  L .5728  .45673  L .768  .514  .55  r
F
P
p
.57267  .44862  m .57272  .45111  L .57267  .44863  L .729  .587  .013  r
F
P
p
.57272  .45111  m .57272  .45111  L .57267  .44863  L .729  .587  .013  r
F
P
p
.57275  .4546  m .57366  .45505  L .57272  .45117  L .79  .54  .559  r
F
P
p
.57343  .45699  m .59859  .46734  L .57366  .45505  L .768  .514  .55  r
F
P
p
.56939  .29922  m .57248  .43985  L .57258  .45085  L .729  .587  .013  r
F
P
p
.56937  .29816  m .5694  .29956  L .56939  .29922  L .729  .587  .013  r
F
P
p
.5694  .29956  m .57248  .43985  L .56939  .29922  L .729  .587  .013  r
F
P
p
.57242  .43723  m .57242  .43723  L .56955  .3054  L .729  .587  .013  r
F
P
p
.56955  .3054  m .56955  .3054  L .56872  .2674  L .729  .587  .013  r
F
P
p
.57242  .43723  m .56955  .3054  L .56955  .3054  L .729  .587  .013  r
F
P
p
.57213  .40865  m .59896  .43125  L .57201  .40393  L .9  .674  .586  r
F
P
p
.56873  .26792  m .56955  .3053  L .56937  .29816  L .729  .587  .013  r
F
P
p
.56955  .3053  m .57248  .43985  L .56937  .29816  L .729  .587  .013  r
F
P
p
.57269  .44661  m .59859  .46734  L .57268  .44555  L .79  .54  .559  r
F
P
p
.57258  .45085  m .57255  .44305  L .57264  .45388  L .729  .587  .013  r
F
P
p
.57248  .43985  m .57255  .44305  L .57258  .45085  L .729  .587  .013  r
F
P
p
.57255  .44305  m .57255  .44305  L .57242  .43724  L .729  .587  .013  r
F
P
p
.57242  .43724  m .57242  .43724  L .56873  .26792  L .729  .587  .013  r
F
P
p
.57255  .44305  m .57242  .43724  L .57242  .43724  L .729  .587  .013  r
F
P
p
.56874  .26822  m .57242  .43723  L .56873  .26792  L .729  .587  .013  r
F
P
p
.57242  .43723  m .57255  .44305  L .57242  .43724  L .729  .587  .013  r
F
P
p
.57242  .43723  m .57242  .43724  L .56873  .26792  L .729  .587  .013  r
F
P
p
.57213  .40865  m .57575  .41242  L .57577  .41172  L .9  .674  .586  r
F
P
p
.57213  .40927  m .57575  .41242  L .57213  .40865  L .9  .674  .586  r
F
P
p
.57575  .41242  m .59951  .43313  L .57577  .41172  L .9  .674  .586  r
F
P
p
.57574  .4129  m .57214  .40967  L .57214  .40979  L .9  .674  .586  r
F
P
p
.57248  .43984  m .57248  .43984  L .57242  .43723  L .729  .587  .013  r
F
P
p
.57242  .43723  m .57242  .43723  L .56872  .2674  L .729  .587  .013  r
F
P
p
.57248  .43984  m .57242  .43723  L .57242  .43723  L .729  .587  .013  r
F
P
p
.56873  .26756  m .57242  .43723  L .56872  .2674  L .729  .587  .013  r
F
P
p
.57242  .43723  m .57248  .43984  L .57242  .43723  L .729  .587  .013  r
F
P
p
.57214  .40984  m .57574  .4129  L .57214  .40979  L .9  .674  .586  r
F
P
p
.57574  .4129  m .59951  .43313  L .57574  .41276  L .9  .674  .586  r
F
P
p
.57248  .43984  m .57267  .44862  L .57248  .43984  L .729  .587  .013  r
F
P
p
.57267  .44862  m .57267  .44863  L .57248  .43984  L .729  .587  .013  r
F
P
p
.56872  .2674  m .56874  .26822  L .56873  .26792  L .729  .587  .013  r
F
P
p
.56872  .26702  m .56873  .26756  L .56872  .2674  L .729  .587  .013  r
F
P
p
.56872  .26702  m .57285  .4638  L .59364  .26807  L .729  .587  .013  r
F
P
p
.57285  .4638  m .57335  .46394  L .59364  .26807  L .729  .587  .013  r
F
P
p
.57465  .4516  m .57335  .464  L .57426  .4653  L 0 0 .108  r
F
P
p
.57335  .464  m .57331  .46718  L .57426  .4653  L 0 0 .108  r
F
P
p
.38053  .37764  m .57219  .46688  L .57196  .45639  L .768  .514  .55  r
F
P
p
.57092  .44231  m .57113  .44363  L .571  .44502  L .87  .667  .139  r
F
P
p
.56865  .43824  m .54421  .2695  L .54419  .2695  L .952  .706  .249  r
F
P
p
.54421  .2695  m .55031  .30843  L .54418  .26933  L .87  .667  .139  r
F
P
p
.55031  .30843  m .56846  .42408  L .55031  .3084  L .87  .667  .139  r
F
P
p
.55031  .30843  m .55031  .3084  L .54418  .26933  L .87  .667  .139  r
F
P
p
.56846  .42408  m .56846  .42408  L .55031  .3084  L .87  .667  .139  r
F
P
p
.55031  .3084  m .55031  .3084  L .54418  .26933  L .87  .667  .139  r
F
P
p
.56846  .42408  m .55031  .3084  L .55031  .3084  L .87  .667  .139  r
F
P
p
.56978  .43275  m .5708  .43915  L .57001  .43881  L .87  .667  .139  r
F
P
p
.5708  .43915  m .57083  .43933  L .57001  .43881  L .87  .667  .139  r
F
P
p
.5688  .44118  m .57021  .4389  L .56865  .43824  L .812  .564  .564  r
F
P
p
.57001  .43881  m .57083  .43933  L .5701  .44141  L .87  .667  .139  r
F
P
p
.57083  .43933  m .571  .44502  L .5701  .44141  L .87  .667  .139  r
F
P
p
.56978  .43249  m .57082  .43916  L .56978  .43249  L .87  .667  .139  r
F
P
p
.57082  .43916  m .57082  .43916  L .56978  .43249  L .87  .667  .139  r
F
P
p
.56895  .43379  m .56978  .43275  L .5701  .44141  L .87  .667  .139  r
F
P
p
.54956  .30508  m .56848  .4245  L .56895  .43379  L .87  .667  .139  r
F
P
p
.56848  .4245  m .56978  .43275  L .56895  .43379  L .87  .667  .139  r
F
P
p
.54419  .2695  m .54421  .2695  L .54397  .26798  L .952  .706  .249  r
F
P
p
.56978  .43249  m .56978  .43249  L .56846  .42408  L .87  .667  .139  r
F
P
p
.56978  .43249  m .56846  .42408  L .56846  .42408  L .87  .667  .139  r
F
P
p
.56846  .42408  m .56978  .43249  L .56846  .42408  L .87  .667  .139  r
F
P
p
.56846  .42408  m .56846  .42408  L .54418  .26933  L .87  .667  .139  r
F
P
p
.56913  .42849  m .56914  .4287  L .56848  .4245  L .87  .667  .139  r
F
P
p
.56847  .42428  m .56848  .4245  L .54956  .30508  L .87  .667  .139  r
F
P
p
.56913  .42849  m .56848  .4245  L .56847  .42428  L .87  .667  .139  r
F
P
p
.56978  .43254  m .56978  .43275  L .56914  .4287  L .87  .667  .139  r
F
P
p
.56978  .43254  m .56914  .4287  L .56913  .42849  L .87  .667  .139  r
F
P
p
.57033  .43603  m .57034  .43624  L .56978  .43275  L .87  .667  .139  r
F
P
p
.57033  .43603  m .56978  .43275  L .56978  .43254  L .87  .667  .139  r
F
P
p
.54415  .26915  m .54421  .2695  L .54414  .26905  L .87  .667  .139  r
F
P
p
.54421  .2695  m .54418  .26933  L .54414  .26905  L .87  .667  .139  r
F
P
p
.54401  .26821  m .54415  .26915  L .54399  .26814  L .87  .667  .139  r
F
P
p
.54415  .26915  m .54414  .26905  L .54399  .26814  L .87  .667  .139  r
F
P
p
.55182  .31801  m .56846  .42408  L .54956  .30508  L .87  .667  .139  r
F
P
p
.56846  .42408  m .57033  .43603  L .56847  .42428  L .87  .667  .139  r
F
P
p
.56846  .42408  m .56847  .42428  L .54956  .30508  L .87  .667  .139  r
F
P
p
.54399  .26814  m .55182  .31801  L .54956  .30508  L .87  .667  .139  r
F
P
p
.54397  .26798  m .54401  .26821  L .54399  .26814  L .87  .667  .139  r
F
P
p
.54397  .26798  m .5715  .45068  L .56872  .26702  L .87  .667  .139  r
F
P
p
.58261  .38035  m .57465  .4516  L .57426  .4653  L 0 0 .108  r
F
P
p
.58951  .31016  m .57874  .41264  L .58261  .38035  L 0 0 .108  r
F
P
p
.57874  .41264  m .57465  .4516  L .58261  .38035  L 0 0 .108  r
F
P
p
.57466  .45129  m .57356  .46185  L .57465  .4516  L 0 0 .108  r
F
P
p
.57356  .46185  m .57356  .46195  L .57465  .4516  L 0 0 .108  r
F
P
p
.58827  .31993  m .57466  .45129  L .58951  .31016  L 0 0 .108  r
F
P
p
.57466  .45129  m .57465  .4516  L .58951  .31016  L 0 0 .108  r
F
P
p
.59364  .26807  m .58827  .31993  L .58951  .31016  L 0 0 .108  r
F
P
p
.55268  .39806  m .56054  .41511  L .56046  .41507  L .983  .712  .332  r
F
P
p
.56054  .41511  m .56056  .41527  L .56046  .41507  L .983  .712  .332  r
F
P
p
.55268  .39806  m .56046  .41507  L .55273  .39837  L .983  .712  .332  r
F
P
p
.55273  .39837  m .56056  .41527  L .55274  .39838  L .983  .712  .332  r
F
P
p
.56056  .41527  m .56056  .41528  L .55274  .39838  L .983  .712  .332  r
F
P
p
.56056  .41528  m .55728  .40821  L .55728  .4082  L .983  .712  .332  r
F
P
p
.56056  .41528  m .55728  .40821  L .56056  .41528  L .983  .712  .332  r
F
P
p
.55728  .4082  m .55274  .39839  L .55274  .39838  L .983  .712  .332  r
F
P
p
.55728  .40821  m .55274  .39839  L .55728  .4082  L .983  .712  .332  r
F
P
p
.56231  .41175  m .56588  .42347  L .56302  .41897  L .952  .706  .249  r
F
P
p
.56588  .42347  m .56617  .42777  L .56302  .41897  L .952  .706  .249  r
F
P
p
.56227  .41136  m .56587  .42324  L .56231  .41175  L .952  .706  .249  r
F
P
p
.56587  .42324  m .56588  .42347  L .56231  .41175  L .952  .706  .249  r
F
P
p
.53495  .32478  m .53635  .32577  L .51972  .27088  L .983  .712  .332  r
F
P
p
.56056  .41528  m .55728  .40821  L .55728  .40821  L .983  .712  .332  r
F
P
p
.56056  .41528  m .55728  .40821  L .56056  .41528  L .983  .712  .332  r
F
P
p
.56056  .41528  m .56046  .41506  L .56046  .41506  L .983  .712  .332  r
F
P
p
.56056  .41528  m .56056  .41529  L .56046  .41506  L .983  .712  .332  r
F
P
p
.56348  .42574  m .53635  .32577  L .53495  .32478  L .983  .712  .332  r
F
P
p
.56227  .41136  m .56231  .41175  L .53162  .31116  L .952  .706  .249  r
F
P
p
.53174  .31155  m .53162  .31116  L .52875  .30177  L .952  .706  .249  r
F
P
p
.56227  .41136  m .53162  .31116  L .53174  .31155  L .952  .706  .249  r
F
P
p
.5329  .3144  m .53635  .32577  L .52875  .30177  L .952  .706  .249  r
F
P
p
.53635  .32577  m .56227  .41136  L .53174  .31155  L .952  .706  .249  r
F
P
p
.53635  .32577  m .53174  .31155  L .52875  .30177  L .952  .706  .249  r
F
P
p
.56302  .41897  m .56739  .4312  L .56759  .4346  L .952  .706  .249  r
F
P
p
.52875  .30177  m .56231  .41175  L .56302  .41897  L .952  .706  .249  r
F
P
p
.51972  .27088  m .5329  .3144  L .52875  .30177  L .952  .706  .249  r
F
P
p
.51972  .27088  m .56865  .43824  L .54419  .2695  L .952  .706  .249  r
F
P
p
.51972  .27088  m .54419  .2695  L .54397  .26798  L .952  .706  .249  r
F
P
p
.54428  .39592  m .55101  .40486  L .55365  .41109  L .982  .697  .387  r
F
P
p
.56046  .41506  m .56046  .41506  L .55728  .40821  L .983  .712  .332  r
F
P
p
.55728  .40821  m .55728  .40821  L .55274  .39839  L .983  .712  .332  r
F
P
p
.55274  .39838  m .55274  .39839  L .50734  .30035  L .983  .712  .332  r
F
P
p
.50794  .30158  m .55273  .39837  L .50734  .30035  L .983  .712  .332  r
F
P
p
.55273  .39837  m .55274  .39838  L .50734  .30035  L .983  .712  .332  r
F
P
p
.51249  .31083  m .55268  .39806  L .50663  .29876  L .983  .712  .332  r
F
P
p
.55268  .39806  m .55273  .39837  L .50663  .29876  L .983  .712  .332  r
F
P
p
.51487  .3166  m .55274  .39839  L .51048  .30734  L .983  .712  .332  r
F
P
p
.55274  .39839  m .55728  .40821  L .55274  .39843  L .983  .712  .332  r
F
P
p
.55274  .39839  m .55274  .39843  L .51048  .30734  L .983  .712  .332  r
F
P
p
.55356  .40358  m .55728  .40821  L .55787  .41321  L .983  .712  .332  r
F
P
p
.51048  .30734  m .55274  .39843  L .55356  .40358  L .983  .712  .332  r
F
P
p
.55274  .39843  m .55728  .40821  L .55356  .40358  L .983  .712  .332  r
F
P
p
.50734  .30035  m .51487  .3166  L .51048  .30734  L .983  .712  .332  r
F
P
p
.50663  .29876  m .50794  .30158  L .50734  .30035  L .983  .712  .332  r
F
P
p
.49627  .27561  m .51249  .31083  L .50663  .29876  L .983  .712  .332  r
F
P
p
.49627  .27561  m .56348  .42574  L .51972  .27088  L .983  .712  .332  r
F
P
p
.55863  .42332  m .56317  .42558  L .55827  .42029  L .835  .589  .567  r
F
P
p
.55886  .42516  m .56317  .42558  L .55863  .42332  L .835  .589  .567  r
F
P
p
.3849  .362  m .5701  .45329  L .56971  .44424  L .79  .54  .559  r
F
P
p
.53614  .3792  m .53602  .37872  L .50399  .35127  L .9  .674  .586  r
F
P
p
.53616  .39035  m .54684  .39768  L .47391  .28207  L .966  .667  .409  r
F
P
p
.53762  .38515  m .54683  .39767  L .54428  .39592  L .982  .697  .387  r
F
P
p
.47555  .28473  m .53677  .38173  L .53762  .38515  L .982  .697  .387  r
F
P
p
.53677  .38173  m .54683  .39767  L .53762  .38515  L .982  .697  .387  r
F
P
p
.54684  .39769  m .54685  .3977  L .53677  .38173  L .982  .697  .387  r
F
P
p
.53676  .38172  m .53677  .38173  L .47555  .28473  L .982  .697  .387  r
F
P
p
.54684  .39769  m .53677  .38173  L .53676  .38172  L .982  .697  .387  r
F
P
p
.45292  .29015  m .5303  .38633  L .47734  .28804  L .966  .667  .409  r
F
P
p
.5303  .38633  m .54273  .40179  L .53616  .39035  L .966  .667  .409  r
F
P
p
.5303  .38633  m .53616  .39035  L .47734  .28804  L .966  .667  .409  r
F
P
p
.55886  .42516  m .55827  .42029  L .55128  .41549  L .835  .589  .567  r
F
P
p
.47701  .28699  m .54684  .39768  L .47555  .28473  L .982  .697  .387  r
F
P
p
.54684  .39768  m .54684  .39769  L .47555  .28473  L .982  .697  .387  r
F
P
p
.47391  .28207  m .47701  .28699  L .47555  .28473  L .982  .697  .387  r
F
P
p
.47391  .28207  m .55365  .41109  L .49627  .27561  L .982  .697  .387  r
F
P
p
.55128  .41549  m .55827  .42029  L .55814  .41923  L .835  .589  .567  r
F
P
p
.47372  .28215  m .47734  .28804  L .47391  .28207  L .966  .667  .409  r
F
P
p
.45292  .29015  m .47734  .28804  L .47372  .28215  L .966  .667  .409  r
F
P
p
.56279  .438  m .56213  .43147  L .55761  .42833  L .812  .564  .564  r
F
P
p
.55761  .42833  m .56572  .43397  L .5656  .43224  L .812  .564  .564  r
F
P
p
.39153  .34719  m .55886  .43591  L .55761  .42833  L .812  .564  .564  r
F
P
p
.40044  .33329  m .55246  .42145  L .55128  .41549  L .835  .589  .567  r
F
P
p
.48952  .7896  m .30489  .6768  L .3112  .67329  L .669  .717  .884  r
F
P
p
.48651  .80725  m .30489  .6768  L .48952  .7896  L .656  .687  .867  r
F
P
p
.25  g
.004  w
.48949  .77043  m
.49073  .77111  L
s
P
p
.006  w
.48952  .7896  m
.49073  .77111  L
s
P
p
.38006  .42885  m .58733  .502  L .37823  .41113  L .695  .421  .505  r
F
P
p
.25  g
.004  w
.56903  .5269  m
.57055  .52756  L
s
P
p
.38006  .42885  m .58003  .51468  L .58733  .502  L .695  .421  .505  r
F
P
p
.25  g
.004  w
.55702  .53968  m
.55708  .5397  L
s
P
p
.25  g
.004  w
.3855  .44793  m
.41518  .4607  L
s
P
p
.25  g
.004  w
.56882  .52681  m
.56903  .5269  L
s
P
p
.006  w
.38006  .42885  m
.38364  .44713  L
s
P
p
.25  g
.004  w
.38006  .42885  m
.38009  .42886  L
s
P
p
.25  g
.004  w
.38009  .42886  m
.38145  .42944  L
s
P
p
.25  g
.004  w
.38145  .42944  m
.3821  .42972  L
s
P
p
.25  g
.004  w
.40801  .44084  m
.42293  .44725  L
s
P
p
.25  g
.004  w
.39793  .43652  m
.40801  .44084  L
s
P
p
.25  g
.004  w
.39205  .43399  m
.39793  .43652  L
s
P
p
.25  g
.004  w
.3821  .42972  m
.39205  .43399  L
s
P
p
.25  g
.004  w
.57227  .51135  m
.57359  .51192  L
s
P
p
.25  g
.004  w
.57359  .51192  m
.58003  .51468  L
s
P
p
.25  g
.004  w
.40403  .50542  m
.52693  .56481  L
s
P
p
1 0 0 r
.003  w
.59896  .43125  m
.59951  .43313  L
s
P
p
.25  g
.004  w
.44065  .29793  m
.44331  .3002  L
s
P
p
.25  g
.004  w
.44331  .3002  m
.44345  .30031  L
s
P
p
.25  g
.004  w
.44345  .30031  m
.49942  .34795  L
s
P
p
1 0 0 r
.003  w
.59951  .43313  m
.59999  .43681  L
s
P
p
.25  g
.004  w
.59795  .43532  m
.59999  .43681  L
s
P
p
.25  g
.004  w
.42507  .30856  m
.42758  .31039  L
s
P
p
.25  g
.004  w
.42758  .31039  m
.42773  .31051  L
s
P
p
.25  g
.004  w
.42773  .31051  m
.5291  .38484  L
s
P
p
1 0 0 r
.003  w
.59999  .43681  m
.6003  .44221  L
s
P
p
.25  g
.004  w
.59885  .44127  m
.6003  .44221  L
s
P
p
.25  g
.004  w
.59701  .44008  m
.59885  .44127  L
s
P
p
.25  g
.004  w
.41164  .32038  m
.41411  .32197  L
s
P
p
.25  g
.004  w
.41411  .32197  m
.41425  .32207  L
s
P
p
.25  g
.004  w
.41425  .32207  m
.5017  .37854  L
s
P
p
1 0 0 r
.003  w
.6003  .44221  m
.60031  .4492  L
s
P
p
.25  g
.004  w
.59893  .4484  m
.60031  .4492  L
s
P
p
.25  g
.004  w
.59806  .44789  m
.59893  .4484  L
s
P
p
.25  g
.004  w
.59573  .44654  m
.59806  .44789  L
s
P
p
.25  g
.004  w
.47343  .37562  m
.49298  .38695  L
s
P
p
.25  g
.004  w
.40044  .33329  m
.40291  .33472  L
s
P
p
.25  g
.004  w
.40291  .33472  m
.47343  .37562  L
s
P
p
1 0 0 r
.003  w
.59983  .45764  m
.60031  .4492  L
s
P
p
.48651  .80725  m .30013  .67927  L .30216  .67822  L .656  .687  .867  r
F
P
p
.48524  .8116  m .30013  .67927  L .48651  .80725  L .644  .658  .849  r
F
P
p
.48166  .82389  m .47492  .81852  L .48524  .8116  L .644  .658  .849  r
F
P
p
.47492  .81852  m .30013  .67927  L .48524  .8116  L .644  .658  .849  r
F
P
p
.43035  .88594  m .41377  .85952  L .444  .87697  L .55  .51  .765  r
F
P
p
.48166  .82389  m .46934  .81434  L .30013  .67927  L .644  .658  .849  r
F
P
p
.46934  .81434  m .29681  .68062  L .29819  .68006  L .644  .658  .849  r
F
P
p
.46934  .81434  m .29819  .68006  L .30013  .67927  L .644  .658  .849  r
F
P
p
.47495  .83936  m .46496  .83046  L .48166  .82389  L .639  .632  .827  r
F
P
p
.46496  .83046  m .29681  .68062  L .46934  .81434  L .639  .632  .827  r
F
P
p
.46496  .83046  m .46934  .81434  L .48166  .82389  L .639  .632  .827  r
F
P
p
.47495  .83936  m .29486  .68076  L .29681  .68062  L .639  .632  .827  r
F
P
p
.4664  .85349  m .29486  .68076  L .47495  .83936  L .52  .579  .855  r
F
P
p
.46355  .85062  m .29426  .67965  L .29486  .68076  L .52  .579  .855  r
F
P
p
.46353  .85059  m .29426  .67965  L .46355  .85062  L .52  .579  .855  r
F
P
p
.46343  .85049  m .46336  .85041  L .46392  .85099  L .52  .579  .855  r
F
P
p
.46336  .85041  m .29426  .67965  L .46353  .85059  L .52  .579  .855  r
F
P
p
.46336  .85041  m .46353  .85059  L .46392  .85099  L .52  .579  .855  r
F
P
p
.46392  .85099  m .46353  .85059  L .46355  .85062  L .52  .579  .855  r
F
P
p
.4664  .85349  m .46343  .85049  L .46392  .85099  L .52  .579  .855  r
F
P
p
.45606  .86609  m .29426  .67965  L .4664  .85349  L .573  .568  .809  r
F
P
p
.45606  .86609  m .29504  .67732  L .29426  .67965  L .573  .568  .809  r
F
P
p
.444  .87697  m .29691  .67983  L .45548  .8654  L .563  .54  .787  r
F
P
p
.29691  .67983  m .29552  .67796  L .2985  .68146  L .563  .54  .787  r
F
P
p
.29691  .67983  m .2985  .68146  L .45548  .8654  L .563  .54  .787  r
F
P
p
.29552  .67796  m .29504  .67732  L .29573  .67813  L .563  .54  .787  r
F
P
p
.29552  .67796  m .29573  .67813  L .45606  .86609  L .563  .54  .787  r
F
P
p
.444  .87697  m .29725  .67384  L .29504  .67732  L .563  .54  .787  r
F
P
p
.2983  .67551  m .29863  .67574  L .30263  .68128  L .55  .51  .765  r
F
P
p
.30198  .68059  m .30263  .68128  L .444  .87697  L .55  .51  .765  r
F
P
p
.2983  .67551  m .30263  .68128  L .30198  .68059  L .55  .51  .765  r
F
P
p
.41377  .85952  m .30055  .67909  L .42563  .85157  L .55  .51  .765  r
F
P
p
.30055  .67909  m .2983  .67551  L .30198  .68059  L .55  .51  .765  r
F
P
p
.30055  .67909  m .30198  .68059  L .42563  .85157  L .55  .51  .765  r
F
P
p
.45504  .86701  m .45548  .8654  L .45606  .86609  L .563  .54  .787  r
F
P
p
.444  .87697  m .45548  .8654  L .45504  .86701  L .563  .54  .787  r
F
P
p
.41377  .85952  m .42563  .85157  L .444  .87697  L .55  .51  .765  r
F
P
p
.2983  .67551  m .29725  .67384  L .29863  .67574  L .55  .51  .765  r
F
P
p
.48468  .80593  m .30216  .67822  L .30489  .6768  L .656  .687  .867  r
F
P
p
.48651  .80725  m .30216  .67822  L .48468  .80593  L .656  .687  .867  r
F
P
p
.25  g
.004  w
.30221  .6807  m
.30223  .68072  L
s
P
p
.25  g
.004  w
.30223  .68072  m
.48575  .80672  L
s
P
p
.25  g
.004  w
.48575  .80672  m
.48651  .80725  L
s
P
p
.006  w
.48651  .80725  m
.48952  .7896  L
s
P
p
.25  g
.004  w
.30489  .6768  m
.30669  .6779  L
s
P
p
.25  g
.004  w
.30669  .6779  m
.30677  .67795  L
s
P
p
.25  g
.004  w
.30677  .67795  m
.47805  .7826  L
s
P
p
.25  g
.004  w
.47805  .7826  m
.48841  .78892  L
s
P
p
.25  g
.004  w
.48841  .78892  m
.48952  .7896  L
s
P
p
.25  g
.004  w
.48412  .76751  m
.48949  .77043  L
s
P
p
.25  g
.004  w
.48547  .74961  m
.48894  .7513  L
s
P
p
.25  g
.004  w
.48489  .73079  m
.48681  .73162  L
s
P
p
.25  g
.004  w
.48273  .71132  m
.48321  .7115  L
s
P
p
.006  w
.48166  .82389  m
.48651  .80725  L
s
P
p
.61844  .2712  m .57318  .47632  L .57335  .47864  L 0 0 .203  r
F
P
p
.57236  .4823  m .59266  .48974  L .57275  .48085  L .721  .456  .524  r
F
P
p
.37823  .41113  m .58733  .502  L .59266  .48974  L .721  .456  .524  r
F
P
p
.5812  .44955  m .57335  .47864  L .57381  .48497  L 0 0 .203  r
F
P
p
.61844  .2712  m .57335  .47864  L .5812  .44955  L 0 0 .203  r
F
P
p
.37823  .41113  m .57236  .4823  L .37834  .39404  L .721  .456  .524  r
F
P
p
.57236  .4823  m .57275  .48085  L .37834  .39404  L .721  .456  .524  r
F
P
p
.25  g
.004  w
.38044  .41209  m
.39874  .42004  L
s
P
p
.25  g
.004  w
.39874  .42004  m
.40525  .42287  L
s
P
p
.25  g
.004  w
.40525  .42287  m
.4166  .4278  L
s
P
p
.25  g
.004  w
.4166  .4278  m
.43375  .43526  L
s
P
p
.25  g
.004  w
.43375  .43526  m
.45743  .44555  L
s
P
p
.25  g
.004  w
.45743  .44555  m
.48778  .45874  L
s
P
p
.25  g
.004  w
.48778  .45874  m
.57173  .49522  L
s
P
p
.25  g
.004  w
.37975  .41179  m
.38044  .41209  L
s
P
p
.25  g
.004  w
.37829  .41116  m
.37975  .41179  L
s
P
p
.25  g
.004  w
.37823  .41113  m
.37829  .41116  L
s
P
p
.25  g
.004  w
.49298  .38695  m
.53736  .41269  L
s
P
p
.25  g
.004  w
.53736  .41269  m
.55246  .42145  L
s
P
p
.25  g
.004  w
.55246  .42145  m
.55886  .42516  L
s
P
p
.25  g
.004  w
.55886  .42516  m
.56367  .42795  L
s
P
p
.25  g
.004  w
.56367  .42795  m
.56605  .42933  L
s
P
p
.25  g
.004  w
.57716  .43577  m
.58156  .43833  L
s
P
p
.25  g
.004  w
.58333  .43935  m
.59573  .44654  L
s
P
p
.25  g
.004  w
.5017  .37854  m
.53755  .40169  L
s
P
p
.25  g
.004  w
.53755  .40169  m
.54365  .40562  L
s
P
p
.25  g
.004  w
.54365  .40562  m
.55381  .41219  L
s
P
p
.25  g
.004  w
.55381  .41219  m
.55888  .41546  L
s
P
p
.25  g
.004  w
.57795  .42778  m
.58315  .43113  L
s
P
p
.25  g
.004  w
.58482  .43221  m
.59701  .44008  L
s
P
p
.25  g
.004  w
.54332  .39526  m
.54433  .396  L
s
P
p
.25  g
.004  w
.5786  .42113  m
.58442  .4254  L
s
P
p
.25  g
.004  w
.586  .42656  m
.59795  .43532  L
s
P
p
.25  g
.004  w
.57913  .41579  m
.58537  .42109  L
s
P
p
.25  g
.004  w
.58687  .42238  m
.59951  .43313  L
s
P
p
.25  g
.004  w
.57954  .41157  m
.5796  .41162  L
s
P
p
.25  g
.004  w
.5796  .41162  m
.58602  .41813  L
s
P
p
.25  g
.004  w
.58746  .41959  m
.59896  .43125  L
s
P
p
.006  w
.37823  .41113  m
.38006  .42885  L
s
P
p
.25  g
.004  w
.42293  .44725  m
.44309  .4559  L
s
P
p
.25  g
.004  w
.44309  .4559  m
.46842  .46677  L
s
P
p
.25  g
.004  w
.46842  .46677  m
.57227  .51135  L
s
P
p
.25  g
.004  w
.56871  .52677  m
.56882  .52681  L
s
P
p
.25  g
.004  w
.45408  .47744  m
.56871  .52677  L
s
P
p
.25  g
.004  w
.41518  .4607  m
.45408  .47744  L
s
P
p
.25  g
.004  w
.39043  .46665  m
.55702  .53968  L
s
P
p
.25  g
.004  w
.39668  .48583  m
.54305  .55241  L
s
P
p
.25  g
.004  w
.57173  .49522  m
.57259  .4956  L
s
P
p
.25  g
.004  w
.57259  .4956  m
.58733  .502  L
s
P
p
.006  w
.37823  .41113  m
.37834  .39404  L
s
P
p
.25  g
.004  w
.59777  .45655  m
.59983  .45764  L
s
P
p
.25  g
.004  w
.57624  .44513  m
.57966  .44694  L
s
P
p
.25  g
.004  w
.58154  .44794  m
.59777  .45655  L
s
P
p
.25  g
.004  w
.5688  .44118  m
.57018  .44191  L
s
P
p
.25  g
.004  w
.56279  .438  m
.5688  .44118  L
s
P
p
.25  g
.004  w
.55886  .43591  m
.56279  .438  L
s
P
p
.25  g
.004  w
.54164  .42679  m
.55886  .43591  L
s
P
p
.25  g
.004  w
.49146  .40018  m
.54164  .42679  L
s
P
p
.25  g
.004  w
.46485  .38607  m
.49146  .40018  L
s
P
p
.25  g
.004  w
.45159  .37904  m
.46485  .38607  L
s
P
p
.25  g
.004  w
.39153  .34719  m
.39398  .34849  L
s
P
p
.25  g
.004  w
.39398  .34849  m
.45159  .37904  L
s
P
p
1 0 0 r
.003  w
.59859  .46734  m
.59983  .45764  L
s
P
p
.25  g
.004  w
.3849  .362  m
.38508  .36209  L
s
P
p
.25  g
.004  w
.5971  .4666  m
.59859  .46734  L
s
P
p
.25  g
.004  w
.57159  .45403  m
.57265  .45455  L
s
P
p
.25  g
.004  w
.5752  .45581  m
.57746  .45692  L
s
P
p
.25  g
.004  w
.57946  .45791  m
.5971  .4666  L
s
P
p
.25  g
.004  w
.56378  .45018  m
.57159  .45403  L
s
P
p
.25  g
.004  w
.54828  .44254  m
.56378  .45018  L
s
P
p
.25  g
.004  w
.49608  .41681  m
.54828  .44254  L
s
P
p
.25  g
.004  w
.46335  .40068  m
.49608  .41681  L
s
P
p
.25  g
.004  w
.44411  .39119  m
.46335  .40068  L
s
P
p
.25  g
.004  w
.43393  .38617  m
.44411  .39119  L
s
P
p
.25  g
.004  w
.38508  .36209  m
.43393  .38617  L
s
P
p
1 0 0 r
.003  w
.59631  .47811  m
.59859  .46734  L
s
P
p
.25  g
.004  w
.57335  .46394  m
.57356  .46185  L
s
P
p
.25  g
.004  w
.47886  .82172  m
.48166  .82389  L
s
P
p
.25  g
.004  w
.46934  .81434  m
.47886  .82172  L
s
P
p
.25  g
.004  w
.30894  .69002  m
.46934  .81434  L
s
P
p
.006  w
.47495  .83936  m
.48166  .82389  L
s
P
p
.25  g
.004  w
.37834  .39404  m
.37844  .39409  L
s
P
p
.25  g
.004  w
.37844  .39409  m
.37996  .39477  L
s
P
p
.25  g
.004  w
.37996  .39477  m
.38068  .39508  L
s
P
p
.25  g
.004  w
.57057  .47988  m
.57275  .48085  L
s
P
p
.25  g
.004  w
.57275  .48085  m
.57353  .4812  L
s
P
p
.25  g
.004  w
.5745  .48163  m
.59266  .48974  L
s
P
p
.25  g
.004  w
.57043  .47981  m
.57057  .47988  L
s
P
p
.25  g
.004  w
.51472  .45494  m
.57043  .47981  L
s
P
p
.25  g
.004  w
.47696  .43808  m
.51472  .45494  L
s
P
p
.25  g
.004  w
.44832  .42529  m
.47696  .43808  L
s
P
p
.25  g
.004  w
.42815  .41628  m
.44832  .42529  L
s
P
p
.25  g
.004  w
.41516  .41048  m
.42815  .41628  L
s
P
p
.25  g
.004  w
.40786  .40722  m
.41516  .41048  L
s
P
p
.25  g
.004  w
.38068  .39508  m
.40786  .40722  L
s
P
p
.006  w
.37834  .39404  m
.38053  .37764  L
s
P
p
.25  g
.004  w
.38053  .37764  m
.38066  .37771  L
s
P
p
.25  g
.004  w
.38066  .37771  m
.38224  .37844  L
s
P
p
.25  g
.004  w
.57287  .4672  m
.57331  .4674  L
s
P
p
.25  g
.004  w
.57402  .46774  m
.57498  .46818  L
s
P
p
.25  g
.004  w
.5771  .46917  m
.59631  .47811  L
s
P
p
.25  g
.004  w
.56763  .46476  m
.57287  .4672  L
s
P
p
.25  g
.004  w
.50467  .43545  m
.56763  .46476  L
s
P
p
.25  g
.004  w
.46802  .41838  m
.50467  .43545  L
s
P
p
.25  g
.004  w
.4433  .40687  m
.46802  .41838  L
s
P
p
.25  g
.004  w
.42793  .39972  m
.4433  .40687  L
s
P
p
.25  g
.004  w
.41951  .39579  m
.42793  .39972  L
s
P
p
.25  g
.004  w
.38224  .37844  m
.41951  .39579  L
s
P
p
1 0 0 r
.003  w
.59266  .48974  m
.59631  .47811  L
s
P
p
.59364  .26807  m .57318  .47632  L .61844  .2712  L 0 0 .108  r
F
P
p
1 0 0 r
.003  w
.57307  .47257  m
.57318  .47632  L
s
P
p
.25  g
.004  w
.57356  .46185  m
.57466  .45129  L
s
P
p
1 0 0 r
.003  w
.57318  .47632  m
.57335  .47864  L
s
P
p
1 0 0 r
.003  w
.58733  .502  m
.59266  .48974  L
s
P
p
.25  g
.004  w
.46987  .83488  m
.47495  .83936  L
s
P
p
.25  g
.004  w
.46657  .83198  m
.46987  .83488  L
s
P
p
.25  g
.004  w
.31517  .69864  m
.46657  .83198  L
s
P
p
.006  w
.4664  .85349  m
.47495  .83936  L
s
P
p
.006  w
.38053  .37764  m
.3849  .362  L
s
P
p
1 0 0 r
.003  w
.58003  .51468  m
.58733  .502  L
s
P
p
.64279  .27645  m .57381  .48497  L .57502  .4935  L 0 0 .268  r
F
P
p
.25  g
.004  w
.57318  .47632  m
.57349  .47492  L
s
P
p
.61844  .2712  m .57381  .48497  L .64279  .27645  L 0 0 .203  r
F
P
p
1 0 0 r
.003  w
.57335  .47864  m
.57381  .48497  L
s
P
p
.25  g
.004  w
.61801  .27312  m
.61844  .2712  L
s
P
p
1 0 0 r
.003  w
.57055  .52756  m
.58003  .51468  L
s
P
p
.25  g
.004  w
.46343  .85049  m
.4664  .85349  L
s
P
p
.25  g
.004  w
.46336  .85041  m
.46343  .85049  L
s
P
p
.25  g
.004  w
.32084  .70649  m
.46336  .85041  L
s
P
p
.006  w
.45606  .86609  m
.4664  .85349  L
s
P
p
.006  w
.3849  .362  m
.39153  .34719  L
s
P
p
.66642  .28383  m .57502  .4935  L .57709  .50155  L 0 0 .305  r
F
P
p
.25  g
.004  w
.57381  .48497  m
.57432  .48343  L
s
P
p
.25  g
.004  w
.57349  .47492  m
.57355  .47464  L
s
P
p
.64279  .27645  m .57502  .4935  L .66642  .28383  L 0 0 .268  r
F
P
p
.25  g
.004  w
.57355  .47464  m
.58211  .43584  L
s
P
p
1 0 0 r
.003  w
.57381  .48497  m
.57502  .4935  L
s
P
p
.25  g
.004  w
.64219  .27828  m
.64279  .27645  L
s
P
p
.25  g
.004  w
.64214  .27843  m
.64219  .27828  L
s
P
p
1 0 0 r
.003  w
.55874  .54043  m
.57055  .52756  L
s
P
p
.006  w
.39153  .34719  m
.40044  .33329  L
s
P
p
.25  g
.004  w
.45381  .86345  m
.45606  .86609  L
s
P
p
.25  g
.004  w
.32593  .71353  m
.45381  .86345  L
s
P
p
.006  w
.444  .87697  m
.45606  .86609  L
s
P
p
.68904  .29332  m .57709  .50155  L .58028  .50882  L .049  0 .321  r
F
P
p
.25  g
.004  w
.57502  .4935  m
.57575  .49183  L
s
P
p
.25  g
.004  w
.57432  .48343  m
.5744  .48318  L
s
P
p
.66642  .28383  m .57709  .50155  L .68904  .29332  L 0 0 .305  r
F
P
p
1 0 0 r
.003  w
.57502  .4935  m
.57709  .50155  L
s
P
p
.25  g
.004  w
.66595  .28491  m
.66642  .28383  L
s
P
p
.25  g
.004  w
.66559  .28572  m
.66595  .28491  L
s
P
p
.25  g
.004  w
.66554  .28584  m
.66559  .28572  L
s
P
p
.8283  .48112  m .70763  .51771  L .83315  .50546  L .053  0 0 r
F
P
p
.70763  .51771  m .70823  .51777  L .70835  .51776  L .053  0 0 r
F
P
p
.70805  .51767  m .70835  .51776  L .83315  .50546  L .053  0 0 r
F
P
p
.70763  .51771  m .70835  .51776  L .70805  .51767  L .053  0 0 r
F
P
p
.83315  .50546  m .70823  .51777  L .7259  .51583  L .086  .644  .714  r
F
P
p
.70823  .51777  m .70707  .51788  L .7259  .51583  L .086  .644  .714  r
F
P
p
.83315  .50546  m .72672  .51575  L .83671  .53001  L .086  .644  .714  r
F
P
p
.72672  .51575  m .72664  .51576  L .72675  .51577  L .086  .644  .714  r
F
P
p
.72672  .51575  m .72675  .51577  L .83671  .53001  L .086  .644  .714  r
F
P
p
.72671  .51577  m .72703  .51597  L .83671  .53001  L .086  .644  .714  r
F
P
p
.72664  .51576  m .72678  .51584  L .72671  .51577  L .086  .644  .714  r
F
P
p
.72678  .51584  m .72703  .51597  L .72671  .51577  L .086  .644  .714  r
F
P
p
.77702  .51307  m .76122  .51321  L .77676  .5128  L .443  .792  .998  r
F
P
p
.72664  .51576  m .7259  .51583  L .72703  .51597  L .086  .644  .714  r
F
P
p
.83625  .52993  m .7259  .51583  L .74412  .51423  L .231  .742  .877  r
F
P
p
.83565  .52987  m .7259  .51583  L .83625  .52993  L .231  .742  .877  r
F
P
p
.83671  .53001  m .83565  .52987  L .83625  .52993  L .231  .742  .877  r
F
P
p
.83671  .53001  m .74499  .51438  L .83911  .55458  L .231  .742  .877  r
F
P
p
.74499  .51438  m .74501  .51441  L .83911  .55458  L .231  .742  .877  r
F
P
p
.74489  .51436  m .74516  .51468  L .83911  .55458  L .231  .742  .877  r
F
P
p
.76176  .5135  m .74412  .51423  L .76122  .51321  L .354  .787  .968  r
F
P
p
.83857  .55429  m .74516  .51468  L .76176  .5135  L .354  .787  .968  r
F
P
p
.74499  .51438  m .74489  .51436  L .74501  .51441  L .231  .742  .877  r
F
P
p
.74489  .51436  m .74412  .51423  L .74516  .51468  L .231  .742  .877  r
F
P
p
.74516  .51468  m .74412  .51423  L .76176  .5135  L .354  .787  .968  r
F
P
p
.83818  .55418  m .74412  .51423  L .83857  .55429  L .354  .787  .968  r
F
P
p
.83911  .55458  m .83818  .55418  L .83857  .55429  L .354  .787  .968  r
F
P
p
.83911  .55458  m .76215  .51371  L .84052  .57897  L .354  .787  .968  r
F
P
p
.76215  .51371  m .76194  .5136  L .7622  .51381  L .354  .787  .968  r
F
P
p
.76215  .51371  m .7622  .51381  L .84052  .57897  L .354  .787  .968  r
F
P
p
.76194  .5136  m .762  .5137  L .84052  .57897  L .354  .787  .968  r
F
P
p
.76176  .5135  m .76204  .51389  L .76218  .51402  L .354  .787  .968  r
F
P
p
.762  .5137  m .76218  .51402  L .84052  .57897  L .354  .787  .968  r
F
P
p
.76176  .5135  m .76218  .51402  L .762  .5137  L .354  .787  .968  r
F
P
p
.84007  .5785  m .81795  .56019  L .81544  .55294  L .443  .792  .998  r
F
P
p
.81795  .56019  m .76204  .51389  L .81544  .55294  L .443  .792  .998  r
F
P
p
.81544  .55294  m .76204  .51389  L .77702  .51307  L .443  .792  .998  r
F
P
p
.76194  .5136  m .76176  .5135  L .762  .5137  L .354  .787  .968  r
F
P
p
.76176  .5135  m .76122  .51321  L .76204  .51389  L .354  .787  .968  r
F
P
p
.76204  .51389  m .76122  .51321  L .77702  .51307  L .443  .792  .998  r
F
P
p
.83972  .57831  m .76122  .51321  L .84007  .5785  L .443  .792  .998  r
F
P
p
.84052  .57897  m .83972  .57831  L .84007  .5785  L .443  .792  .998  r
F
P
p
.84052  .57897  m .77805  .51415  L .84108  .60302  L .443  .792  .998  r
F
P
p
.77805  .51415  m .77781  .51389  L .77807  .51426  L .443  .792  .998  r
F
P
p
.77805  .51415  m .77807  .51426  L .84108  .60302  L .443  .792  .998  r
F
P
p
.77781  .51389  m .77789  .51415  L .84108  .60302  L .443  .792  .998  r
F
P
p
.77744  .51351  m .77766  .51407  L .84108  .60302  L .443  .792  .998  r
F
P
p
.79152  .51498  m .77676  .5128  L .79039  .51297  L .503  .776  .993  r
F
P
p
.84078  .60248  m .77812  .51471  L .79152  .51498  L .503  .776  .993  r
F
P
p
.77781  .51389  m .77744  .51351  L .77789  .51415  L .443  .792  .998  r
F
P
p
.77744  .51351  m .77676  .5128  L .77766  .51407  L .443  .792  .998  r
F
P
p
.77812  .51471  m .77676  .5128  L .79152  .51498  L .503  .776  .993  r
F
P
p
.84061  .60235  m .77676  .5128  L .84078  .60248  L .503  .776  .993  r
F
P
p
.8211  .79447  m .78935  .5249  L .77947  .52689  L .66  .567  .739  r
F
P
p
.78679  .59253  m .77947  .52689  L .77576  .52763  L .66  .567  .739  r
F
P
p
.8211  .79447  m .77947  .52689  L .78679  .59253  L .66  .567  .739  r
F
P
p
.84108  .60302  m .84061  .60235  L .84078  .60248  L .503  .776  .993  r
F
P
p
.84108  .60302  m .79222  .51623  L .84093  .62652  L .503  .776  .993  r
F
P
p
.79222  .51623  m .79246  .51732  L .84093  .62652  L .503  .776  .993  r
F
P
p
.79107  .51419  m .79116  .51452  L .79131  .51486  L .503  .776  .993  r
F
P
p
.79129  .51468  m .79131  .51486  L .84093  .62652  L .503  .776  .993  r
F
P
p
.79107  .51419  m .79131  .51486  L .79129  .51468  L .503  .776  .993  r
F
P
p
.79079  .51368  m .79097  .51429  L .79128  .51497  L .503  .776  .993  r
F
P
p
.79116  .51452  m .79128  .51497  L .84093  .62652  L .503  .776  .993  r
F
P
p
.79079  .51368  m .79128  .51497  L .79116  .51452  L .503  .776  .993  r
F
P
p
.80197  .51408  m .79039  .51297  L .80181  .51361  L .544  .752  .973  r
F
P
p
.79222  .51623  m .79107  .51419  L .79246  .51732  L .503  .776  .993  r
F
P
p
.84062  .62564  m .79098  .51429  L .80197  .51408  L .544  .752  .973  r
F
P
p
.79107  .51419  m .79079  .51368  L .79116  .51452  L .503  .776  .993  r
F
P
p
.79079  .51368  m .79039  .51297  L .79097  .51429  L .503  .776  .993  r
F
P
p
.79098  .51429  m .79039  .51297  L .80197  .51408  L .544  .752  .973  r
F
P
p
.84068  .62581  m .84058  .62557  L .84062  .62564  L .544  .752  .973  r
F
P
p
.84058  .62557  m .79039  .51297  L .84062  .62564  L .544  .752  .973  r
F
P
p
.8409  .62642  m .84056  .62567  L .84068  .62581  L .544  .752  .973  r
F
P
p
.84056  .62567  m .79039  .51297  L .84068  .62581  L .544  .752  .973  r
F
P
p
.84093  .62652  m .84088  .62641  L .8409  .62642  L .544  .752  .973  r
F
P
p
.84088  .62641  m .79039  .51297  L .8409  .62642  L .544  .752  .973  r
F
P
p
.84093  .62652  m .8029  .51675  L .8402  .64932  L .544  .752  .973  r
F
P
p
.8029  .51675  m .8031  .51793  L .8402  .64932  L .544  .752  .973  r
F
P
p
.80218  .51468  m .80227  .51514  L .80236  .51546  L .544  .752  .973  r
F
P
p
.80235  .51527  m .80236  .51546  L .8402  .64932  L .544  .752  .973  r
F
P
p
.80218  .51468  m .80236  .51546  L .80235  .51527  L .544  .752  .973  r
F
P
p
.80197  .51408  m .80212  .51472  L .80235  .5155  L .544  .752  .973  r
F
P
p
.80227  .51514  m .80235  .5155  L .8402  .64932  L .544  .752  .973  r
F
P
p
.80197  .51408  m .80235  .5155  L .80227  .51514  L .544  .752  .973  r
F
P
p
.83988  .6482  m .80181  .51361  L .8399  .64824  L .572  .727  .947  r
F
P
p
.8029  .51675  m .80218  .51468  L .8031  .51793  L .544  .752  .973  r
F
P
p
.84  .6484  m .80212  .51472  L .81083  .51459  L .572  .727  .947  r
F
P
p
.80218  .51468  m .80197  .51408  L .80227  .51514  L .544  .752  .973  r
F
P
p
.80197  .51408  m .80181  .51361  L .80212  .51472  L .544  .752  .973  r
F
P
p
.80212  .51472  m .80181  .51361  L .81083  .51459  L .572  .727  .947  r
F
P
p
.8399  .64824  m .80181  .51361  L .84  .6484  L .572  .727  .947  r
F
P
p
.84015  .64914  m .83988  .6482  L .84017  .64916  L .572  .727  .947  r
F
P
p
.83988  .6482  m .8399  .64824  L .84017  .64916  L .572  .727  .947  r
F
P
p
.84017  .64916  m .8399  .64824  L .84  .6484  L .572  .727  .947  r
F
P
p
.8402  .64932  m .84015  .64914  L .84017  .64916  L .572  .727  .947  r
F
P
p
.83911  .64431  m .81138  .51712  L .83756  .66316  L .572  .727  .947  r
F
P
p
.81138  .51712  m .8116  .51889  L .83901  .67124  L .572  .727  .947  r
F
P
p
.83911  .64431  m .83756  .66316  L .83901  .67124  L .572  .727  .947  r
F
P
p
.81138  .51712  m .81083  .51459  L .8116  .51889  L .572  .727  .947  r
F
P
p
.83881  .6698  m .81083  .51459  L .8173  .51577  L .592  .703  .92  r
F
P
p
.83878  .66972  m .81083  .51459  L .83881  .6698  L .592  .703  .92  r
F
P
p
.83883  .67004  m .81083  .51459  L .83884  .67006  L .592  .703  .92  r
F
P
p
.83873  .66963  m .81083  .51459  L .83886  .6702  L .592  .703  .92  r
F
P
p
.83896  .67097  m .81083  .51459  L .83898  .671  L .592  .703  .92  r
F
P
p
.8299  .75641  m .81667  .52042  L .82907  .76173  L .654  .64  .824  r
F
P
p
.83141  .74675  m .83109  .7419  L .8299  .75641  L .654  .64  .824  r
F
P
p
.83109  .7419  m .81667  .52042  L .8299  .75641  L .654  .64  .824  r
F
P
p
.8402  .64932  m .83911  .64431  L .83901  .67124  L .572  .727  .947  r
F
P
p
.83884  .67006  m .83878  .66972  L .83881  .6698  L .592  .703  .92  r
F
P
p
.83886  .6702  m .83883  .67004  L .83884  .67006  L .592  .703  .92  r
F
P
p
.83898  .671  m .83873  .66963  L .83886  .6702  L .592  .703  .92  r
F
P
p
.83901  .67124  m .83896  .67097  L .83898  .671  L .592  .703  .92  r
F
P
p
.83901  .67124  m .8175  .51722  L .83746  .69212  L .592  .703  .92  r
F
P
p
.8175  .51722  m .8173  .51577  L .81767  .519  L .592  .703  .92  r
F
P
p
.8175  .51722  m .81767  .519  L .83746  .69212  L .592  .703  .92  r
F
P
p
.83728  .69022  m .8173  .51577  L .82113  .517  L .604  .678  .894  r
F
P
p
.83731  .69056  m .83727  .69014  L .83728  .69022  L .604  .678  .894  r
F
P
p
.83727  .69014  m .8173  .51577  L .83728  .69022  L .604  .678  .894  r
F
P
p
.83726  .69034  m .83719  .68975  L .83727  .6904  L .604  .678  .894  r
F
P
p
.83719  .68975  m .8173  .51577  L .83721  .68985  L .604  .678  .894  r
F
P
p
.83719  .68975  m .83721  .68985  L .83727  .6904  L .604  .678  .894  r
F
P
p
.83741  .6917  m .83726  .69034  L .83742  .69173  L .604  .678  .894  r
F
P
p
.83726  .69034  m .83727  .6904  L .83742  .69173  L .604  .678  .894  r
F
P
p
.83742  .69173  m .83727  .6904  L .83731  .69056  L .604  .678  .894  r
F
P
p
.83727  .6904  m .8173  .51577  L .83731  .69056  L .604  .678  .894  r
F
P
p
.83746  .69212  m .83741  .6917  L .83742  .69173  L .604  .678  .894  r
F
P
p
.83746  .69212  m .82113  .517  L .83564  .71177  L .604  .678  .894  r
F
P
p
.83546  .70944  m .8354  .70867  L .83547  .70948  L .589  .638  .867  r
F
P
p
.8354  .70867  m .82113  .517  L .83541  .70874  L .589  .638  .867  r
F
P
p
.8354  .70867  m .83541  .70874  L .83547  .70948  L .589  .638  .867  r
F
P
p
.82659  .77479  m .80998  .52157  L .803  .52265  L .658  .602  .781  r
F
P
p
.81682  .67931  m .803  .52265  L .80082  .52299  L .658  .602  .781  r
F
P
p
.82659  .77479  m .803  .52265  L .81682  .67931  L .658  .602  .781  r
F
P
p
.83559  .71111  m .83546  .70944  L .83559  .71113  L .589  .638  .867  r
F
P
p
.83546  .70944  m .83547  .70948  L .83559  .71113  L .589  .638  .867  r
F
P
p
.83548  .70946  m .82113  .517  L .8223  .5182  L .589  .638  .867  r
F
P
p
.83559  .71113  m .83543  .70897  L .83548  .70946  L .589  .638  .867  r
F
P
p
.83543  .70897  m .82113  .517  L .83548  .70946  L .589  .638  .867  r
F
P
p
.82395  .78576  m .80082  .52299  L .79229  .52441  L .66  .585  .76  r
F
P
p
.80261  .62484  m .79229  .52441  L .78935  .5249  L .66  .585  .76  r
F
P
p
.82395  .78576  m .79229  .52441  L .80261  .62484  L .66  .585  .76  r
F
P
p
.83564  .71177  m .83559  .71111  L .83559  .71113  L .589  .638  .867  r
F
P
p
.70763  .51771  m .70707  .51788  L .70823  .51777  L .053  0 0 r
F
P
p
.006  w
.83671  .53001  m
.83911  .55458  L
s
P
p
.006  w
.83315  .50546  m
.83671  .53001  L
s
P
p
1 0 0 r
.003  w
.5446  .55311  m
.55874  .54043  L
s
P
p
.006  w
.83911  .55458  m
.84052  .57897  L
s
P
p
.8283  .48112  m .68816  .5202  L .70707  .51788  L .053  0 0 r
F
P
p
.82201  .4572  m .68816  .5202  L .8283  .48112  L .159  0 0 r
F
P
p
.006  w
.8283  .48112  m
.83315  .50546  L
s
P
p
.25  g
.004  w
.79087  .5378  m
.79109  .53798  L
s
P
p
.006  w
.84052  .57897  m
.84108  .60302  L
s
P
p
.82201  .4572  m .66972  .52251  L .68816  .5202  L .159  0 0 r
F
P
p
.81416  .43391  m .66972  .52251  L .82201  .4572  L .229  0 0 r
F
P
p
.25  g
.004  w
.82698  .48149  m
.8283  .48112  L
s
P
p
.006  w
.82201  .4572  m
.8283  .48112  L
s
P
p
.25  g
.004  w
.80319  .54987  m
.80364  .5505  L
s
P
p
.25  g
.004  w
.81271  .56322  m
.81283  .56339  L
s
P
p
.006  w
.84093  .62652  m
.84108  .60302  L
s
P
p
.006  w
.40044  .33329  m
.41164  .32038  L
s
P
p
1 0 0 r
.003  w
.52826  .56545  m
.5446  .55311  L
s
P
p
.81416  .43391  m .65225  .5245  L .66972  .52251  L .229  0 0 r
F
P
p
.80464  .41144  m .65225  .5245  L .81416  .43391  L .267  0 .01  r
F
P
p
.25  g
.004  w
.82696  .48149  m
.82698  .48149  L
s
P
p
.25  g
.004  w
.82058  .45782  m
.82201  .4572  L
s
P
p
.006  w
.81416  .43391  m
.82201  .4572  L
s
P
p
.25  g
.004  w
.30263  .68128  m
.42565  .85156  L
s
P
p
.25  g
.004  w
.30117  .67926  m
.30263  .68128  L
s
P
p
.25  g
.004  w
.42565  .85156  m
.444  .87697  L
s
P
p
.71044  .30488  m .58028  .50882  L .58489  .51501  L .129  0 .32  r
F
P
p
.25  g
.004  w
.57709  .50155  m
.57804  .49979  L
s
P
p
.25  g
.004  w
.57575  .49183  m
.57584  .49163  L
s
P
p
.68904  .29332  m .58028  .50882  L .71044  .30488  L .049  0 .321  r
F
P
p
1 0 0 r
.003  w
.57709  .50155  m
.58028  .50882  L
s
P
p
.25  g
.004  w
.68844  .29445  m
.68904  .29332  L
s
P
p
.25  g
.004  w
.68802  .29523  m
.68844  .29445  L
s
P
p
.25  g
.004  w
.68797  .29532  m
.68802  .29523  L
s
P
p
1 0 0 r
.003  w
.29426  .67965  m
.29486  .68076  L
s
P
p
1 0 0 r
.003  w
.29426  .67965  m
.29504  .67732  L
s
P
p
.006  w
.8402  .64932  m
.84093  .62652  L
s
P
p
1 0 0 r
.003  w
.30216  .67822  m
.30489  .6768  L
s
P
p
1 0 0 r
.003  w
.30089  .67888  m
.30216  .67822  L
s
P
p
.80464  .41144  m .63621  .52586  L .65225  .5245  L .267  0 .01  r
F
P
p
.79337  .39001  m .63621  .52586  L .80464  .41144  L .282  0 .111  r
F
P
p
.006  w
.80464  .41144  m
.81416  .43391  L
s
P
p
.25  g
.004  w
.82057  .45782  m
.82058  .45782  L
s
P
p
.25  g
.004  w
.81264  .43476  m
.81416  .43391  L
s
P
p
.42943  .88448  m .30099  .66936  L .29725  .67384  L .55  .51  .765  r
F
P
p
.42879  .88333  m .30099  .66936  L .42943  .88448  L .55  .51  .765  r
F
P
p
.43035  .88594  m .42879  .88333  L .42943  .88448  L .55  .51  .765  r
F
P
p
.41526  .89282  m .30099  .66936  L .43035  .88594  L .535  .48  .741  r
F
P
p
.41423  .89082  m .30635  .6641  L .30099  .66936  L .535  .48  .741  r
F
P
p
.41415  .8906  m .30635  .6641  L .41423  .89082  L .535  .48  .741  r
F
P
p
.41399  .89015  m .30635  .6641  L .41452  .89137  L .535  .48  .741  r
F
P
p
.41452  .89137  m .41415  .8906  L .41423  .89082  L .535  .48  .741  r
F
P
p
.41526  .89282  m .41399  .89015  L .41452  .89137  L .535  .48  .741  r
F
P
p
.39891  .89744  m .30668  .66492  L .41526  .89282  L .521  .449  .715  r
F
P
p
.30668  .66492  m .30711  .6657  L .41526  .89282  L .521  .449  .715  r
F
P
p
.30668  .66492  m .30635  .6641  L .30711  .6657  L .521  .449  .715  r
F
P
p
.39812  .89544  m .31342  .65838  L .30635  .6641  L .521  .449  .715  r
F
P
p
.39891  .89744  m .3979  .89461  L .39812  .89544  L .521  .449  .715  r
F
P
p
.3979  .89461  m .31342  .65838  L .39812  .89544  L .521  .449  .715  r
F
P
p
.38156  .89965  m .38115  .89819  L .39891  .89744  L .508  .417  .687  r
F
P
p
.38115  .89819  m .31365  .65921  L .3979  .89461  L .508  .417  .687  r
F
P
p
.38115  .89819  m .3979  .89461  L .39891  .89744  L .508  .417  .687  r
F
P
p
.31365  .65921  m .31401  .66004  L .39891  .89744  L .508  .417  .687  r
F
P
p
.31365  .65921  m .31342  .65838  L .31401  .66004  L .508  .417  .687  r
F
P
p
.381  .89765  m .32222  .65253  L .31342  .65838  L .508  .417  .687  r
F
P
p
.38156  .89965  m .38087  .89678  L .381  .89765  L .508  .417  .687  r
F
P
p
.38087  .89678  m .32222  .65253  L .381  .89765  L .508  .417  .687  r
F
P
p
.36346  .89931  m .36322  .89785  L .38156  .89965  L .497  .385  .657  r
F
P
p
.36322  .89785  m .32247  .65404  L .38087  .89678  L .497  .385  .657  r
F
P
p
.36322  .89785  m .38087  .89678  L .38156  .89965  L .497  .385  .657  r
F
P
p
.32247  .65404  m .32276  .65479  L .38156  .89965  L .497  .385  .657  r
F
P
p
.32247  .65404  m .32222  .65253  L .32276  .65479  L .497  .385  .657  r
F
P
p
.36313  .89732  m .33273  .64698  L .32222  .65253  L .497  .385  .657  r
F
P
p
.36346  .89931  m .36311  .89644  L .36313  .89732  L .497  .385  .657  r
F
P
p
.36311  .89644  m .33273  .64698  L .36313  .89732  L .497  .385  .657  r
F
P
p
.34492  .89633  m .34485  .89489  L .36346  .89931  L .487  .354  .624  r
F
P
p
.34485  .89489  m .33281  .64847  L .36311  .89644  L .487  .354  .624  r
F
P
p
.34485  .89489  m .36311  .89644  L .36346  .89931  L .487  .354  .624  r
F
P
p
.33281  .64847  m .33301  .64923  L .36346  .89931  L .487  .354  .624  r
F
P
p
.33281  .64847  m .33273  .64698  L .33301  .64923  L .487  .354  .624  r
F
P
p
.34483  .89437  m .34486  .64215  L .33273  .64698  L .487  .354  .624  r
F
P
p
.34492  .89633  m .34492  .89349  L .34483  .89437  L .487  .354  .624  r
F
P
p
.34492  .89349  m .34486  .64215  L .34483  .89437  L .487  .354  .624  r
F
P
p
.32627  .89067  m .32638  .88926  L .34492  .89633  L .481  .323  .589  r
F
P
p
.32638  .88926  m .34475  .64362  L .34492  .89349  L .481  .323  .589  r
F
P
p
.32638  .88926  m .34492  .89349  L .34492  .89633  L .481  .323  .589  r
F
P
p
.34475  .64362  m .34486  .6444  L .34492  .89633  L .481  .323  .589  r
F
P
p
.34475  .64362  m .34486  .64215  L .34486  .6444  L .481  .323  .589  r
F
P
p
.32642  .88876  m .35839  .63846  L .34486  .64215  L .481  .323  .589  r
F
P
p
.32627  .89067  m .32663  .88789  L .32642  .88876  L .481  .323  .589  r
F
P
p
.32663  .88789  m .35839  .63846  L .32642  .88876  L .481  .323  .589  r
F
P
p
.30786  .88232  m .30815  .88095  L .32627  .89067  L .477  .294  .553  r
F
P
p
.30815  .88095  m .35809  .63991  L .32663  .88789  L .477  .294  .553  r
F
P
p
.30815  .88095  m .32663  .88789  L .32627  .89067  L .477  .294  .553  r
F
P
p
.35809  .63991  m .3581  .6407  L .32627  .89067  L .477  .294  .553  r
F
P
p
.35809  .63991  m .35839  .63846  L .3581  .6407  L .477  .294  .553  r
F
P
p
.30824  .88048  m .37304  .6363  L .35839  .63846  L .477  .294  .553  r
F
P
p
.30786  .88232  m .30857  .87965  L .30824  .88048  L .477  .294  .553  r
F
P
p
.30857  .87965  m .37304  .6363  L .30824  .88048  L .477  .294  .553  r
F
P
p
.29005  .87133  m .29051  .87003  L .30786  .88232  L .478  .267  .515  r
F
P
p
.29051  .87003  m .37254  .63771  L .30857  .87965  L .478  .267  .515  r
F
P
p
.29051  .87003  m .30857  .87965  L .30786  .88232  L .478  .267  .515  r
F
P
p
.37254  .63771  m .37246  .63851  L .30786  .88232  L .478  .267  .515  r
F
P
p
.37254  .63771  m .37304  .6363  L .37246  .63851  L .478  .267  .515  r
F
P
p
.29067  .86958  m .38843  .63601  L .37304  .6363  L .478  .267  .515  r
F
P
p
.29005  .87133  m .29111  .86881  L .29067  .86958  L .478  .267  .515  r
F
P
p
.29111  .86881  m .38843  .63601  L .29067  .86958  L .478  .267  .515  r
F
P
p
.27321  .85779  m .27384  .85659  L .29005  .87133  L .483  .244  .476  r
F
P
p
.27384  .85659  m .38773  .63736  L .29111  .8688  L .483  .244  .476  r
F
P
p
.27384  .85659  m .29111  .8688  L .29005  .87133  L .483  .244  .476  r
F
P
p
.38773  .63736  m .38754  .63814  L .29005  .87133  L .483  .244  .476  r
F
P
p
.38773  .63736  m .38843  .63601  L .38754  .63814  L .483  .244  .476  r
F
P
p
.27405  .85618  m .40411  .63781  L .38843  .63601  L .483  .244  .476  r
F
P
p
.27321  .85779  m .2746  .85547  L .27405  .85618  L .483  .244  .476  r
F
P
p
.2746  .85547  m .40411  .63781  L .27405  .85618  L .483  .244  .476  r
F
P
p
.2577  .84188  m .25848  .84079  L .27321  .85779  L .493  .226  .438  r
F
P
p
.25848  .84079  m .40321  .63907  L .2746  .85547  L .493  .226  .438  r
F
P
p
.25848  .84079  m .2746  .85547  L .27321  .85779  L .493  .226  .438  r
F
P
p
.40321  .63907  m .40291  .63984  L .27321  .85779  L .493  .226  .438  r
F
P
p
.40321  .63907  m .40411  .63781  L .40291  .63984  L .493  .226  .438  r
F
P
p
.25874  .84042  m .41958  .64183  L .40411  .63781  L .493  .226  .438  r
F
P
p
.2577  .84188  m .25938  .8398  L .25874  .84042  L .493  .226  .438  r
F
P
p
.25938  .8398  m .41958  .64183  L .25874  .84042  L .493  .226  .438  r
F
P
p
.24383  .82381  m .24476  .82285  L .2577  .84188  L .508  .214  .402  r
F
P
p
.24476  .82285  m .41848  .64297  L .25938  .8398  L .508  .214  .402  r
F
P
p
.24476  .82285  m .25938  .8398  L .2577  .84188  L .508  .214  .402  r
F
P
p
.41848  .64297  m .41807  .6437  L .2577  .84188  L .508  .214  .402  r
F
P
p
.41848  .64297  m .41958  .64183  L .41807  .6437  L .508  .214  .402  r
F
P
p
.24506  .82253  m .43433  .64806  L .41958  .64183  L .508  .214  .402  r
F
P
p
.24383  .82381  m .24578  .82201  L .24506  .82253  L .508  .214  .402  r
F
P
p
.24578  .82201  m .43433  .64806  L .24506  .82253  L .508  .214  .402  r
F
P
p
.23193  .80383  m .23298  .80302  L .24383  .82381  L .528  .208  .369  r
F
P
p
.23298  .80302  m .43305  .64905  L .24578  .82201  L .528  .208  .369  r
F
P
p
.23298  .80302  m .24578  .82201  L .24383  .82381  L .528  .208  .369  r
F
P
p
.43305  .64905  m .43253  .64972  L .24383  .82381  L .528  .208  .369  r
F
P
p
.43305  .64905  m .43433  .64806  L .43253  .64972  L .528  .208  .369  r
F
P
p
.23332  .80276  m .44787  .65636  L .43433  .64806  L .528  .208  .369  r
F
P
p
.23193  .80383  m .2341  .80235  L .23332  .80276  L .528  .208  .369  r
F
P
p
.2341  .80235  m .44787  .65636  L .23332  .80276  L .528  .208  .369  r
F
P
p
.22225  .78226  m .2234  .78162  L .23193  .80383  L .553  .209  .34  r
F
P
p
.2234  .78162  m .44643  .65716  L .2341  .80235  L .553  .209  .34  r
F
P
p
.2234  .78162  m .2341  .80235  L .23193  .80383  L .553  .209  .34  r
F
P
p
.44643  .65716  m .44582  .65776  L .23193  .80383  L .553  .209  .34  r
F
P
p
.44643  .65716  m .44787  .65636  L .44582  .65776  L .553  .209  .34  r
F
P
p
.22376  .78142  m .45978  .66647  L .44787  .65636  L .553  .209  .34  r
F
P
p
.22225  .78226  m .2246  .78112  L .22376  .78142  L .553  .209  .34  r
F
P
p
.2246  .78112  m .45978  .66647  L .22376  .78142  L .553  .209  .34  r
F
P
p
.21501  .75943  m .21624  .75897  L .22225  .78226  L .583  .219  .316  r
F
P
p
.21624  .75897  m .4582  .66706  L .2246  .78112  L .583  .219  .316  r
F
P
p
.21624  .75897  m .2246  .78112  L .22225  .78226  L .583  .219  .316  r
F
P
p
.4582  .66706  m .4575  .66758  L .22225  .78226  L .583  .219  .316  r
F
P
p
.4582  .66706  m .45978  .66647  L .4575  .66758  L .583  .219  .316  r
F
P
p
.21661  .75883  m .4697  .67802  L .45978  .66647  L .583  .219  .316  r
F
P
p
.21501  .75943  m .21748  .75865  L .21661  .75883  L .583  .219  .316  r
F
P
p
.21748  .75865  m .4697  .67802  L .21661  .75883  L .583  .219  .316  r
F
P
p
.21038  .73571  m .21166  .73543  L .21501  .75943  L .615  .235  .299  r
F
P
p
.21166  .73543  m .46802  .6784  L .21748  .75864  L .615  .235  .299  r
F
P
p
.21166  .73543  m .21748  .75864  L .21501  .75943  L .615  .235  .299  r
F
P
p
.46802  .6784  m .46725  .67881  L .21501  .75943  L .615  .235  .299  r
F
P
p
.46802  .6784  m .4697  .67802  L .46725  .67881  L .615  .235  .299  r
F
P
p
.21203  .73535  m .47742  .69059  L .4697  .67802  L .615  .235  .299  r
F
P
p
.21038  .73571  m .21292  .73528  L .21203  .73535  L .615  .235  .299  r
F
P
p
.21292  .73528  m .47742  .69059  L .21203  .73535  L .615  .235  .299  r
F
P
p
.20848  .71147  m .20978  .71137  L .21038  .73571  L .65  .258  .288  r
F
P
p
.20978  .71137  m .47568  .69073  L .21291  .73528  L .65  .258  .288  r
F
P
p
.20978  .71137  m .21291  .73528  L .21038  .73571  L .65  .258  .288  r
F
P
p
.47568  .69073  m .47485  .69102  L .21038  .73571  L .65  .258  .288  r
F
P
p
.47568  .69073  m .47742  .69059  L .47485  .69102  L .65  .258  .288  r
F
P
p
.21014  .71135  m .48285  .70369  L .47742  .69059  L .65  .258  .288  r
F
P
p
.20848  .71147  m .21102  .7114  L .21014  .71135  L .65  .258  .288  r
F
P
p
.21102  .7114  m .48285  .70369  L .21014  .71135  L .65  .258  .288  r
F
P
p
.20937  .6871  m .21065  .68718  L .20848  .71147  L .686  .287  .285  r
F
P
p
.21065  .68718  m .4811  .70359  L .21102  .7114  L .686  .287  .285  r
F
P
p
.21065  .68718  m .21102  .7114  L .20848  .71147  L .686  .287  .285  r
F
P
p
.4811  .70359  m .48023  .70377  L .20848  .71147  L .686  .287  .285  r
F
P
p
.4811  .70359  m .48285  .70369  L .48023  .70377  L .686  .287  .285  r
F
P
p
.211  .6872  m .48604  .71685  L .48285  .70369  L .686  .287  .285  r
F
P
p
.20937  .6871  m .21186  .68737  L .211  .6872  L .686  .287  .285  r
F
P
p
.21186  .68737  m .48604  .71685  L .211  .6872  L .686  .287  .285  r
F
P
p
.21306  .66297  m .21431  .66322  L .20937  .6871  L .723  .321  .287  r
F
P
p
.21431  .66322  m .48431  .71651  L .21186  .68737  L .723  .321  .287  r
F
P
p
.21431  .66322  m .21186  .68737  L .20937  .6871  L .723  .321  .287  r
F
P
p
.48431  .71651  m .48343  .71657  L .20937  .6871  L .723  .321  .287  r
F
P
p
.48431  .71651  m .48604  .71685  L .48343  .71657  L .723  .321  .287  r
F
P
p
.21306  .66297  m .48718  .72961  L .48604  .71685  L .723  .321  .287  r
F
P
p
.21953  .63946  m .48552  .72905  L .21306  .66297  L .758  .358  .295  r
F
P
p
.48552  .72905  m .48464  .72899  L .21306  .66297  L .758  .358  .295  r
F
P
p
.48552  .72905  m .48718  .72961  L .48464  .72899  L .758  .358  .295  r
F
P
p
.22071  .63986  m .48656  .7416  L .48718  .72961  L .758  .358  .295  r
F
P
p
.21953  .63946  m .22195  .64038  L .22071  .63986  L .758  .358  .295  r
F
P
p
.22195  .64038  m .48656  .7416  L .22071  .63986  L .758  .358  .295  r
F
P
p
.22869  .6169  m .485  .74084  L .21953  .63946  L .792  .398  .308  r
F
P
p
.485  .74084  m .48415  .74068  L .21953  .63946  L .792  .398  .308  r
F
P
p
.485  .74084  m .48656  .7416  L .48415  .74068  L .792  .398  .308  r
F
P
p
.22979  .61743  m .48457  .75253  L .48656  .7416  L .792  .398  .308  r
F
P
p
.22869  .6169  m .23095  .6181  L .22979  .61743  L .792  .398  .308  r
F
P
p
.23095  .6181  m .48457  .75253  L .22979  .61743  L .792  .398  .308  r
F
P
p
.24045  .59563  m .48367  .75195  L .22869  .6169  L .824  .44  .326  r
F
P
p
.48367  .75195  m .4827  .75153  L .22869  .6169  L .824  .44  .326  r
F
P
p
.48367  .75195  m .48457  .75253  L .4827  .75153  L .824  .44  .326  r
F
P
p
.24145  .59627  m .48164  .7622  L .48457  .75253  L .824  .44  .326  r
F
P
p
.24045  .59563  m .24252  .59706  L .24145  .59627  L .824  .44  .326  r
F
P
p
.24252  .59706  m .48164  .7622  L .24145  .59627  L .824  .44  .326  r
F
P
p
.25467  .57596  m .48087  .76157  L .24045  .59563  L .854  .482  .346  r
F
P
p
.48087  .76157  m .48  .76107  L .24045  .59563  L .854  .482  .346  r
F
P
p
.48087  .76157  m .48164  .7622  L .48  .76107  L .854  .482  .346  r
F
P
p
.28562  .60136  m .47822  .77054  L .48164  .7622  L .854  .482  .346  r
F
P
p
.5172  .52335  m .47932  .78525  L .48951  .51377  L .977  .919  .622  r
F
P
p
.47932  .78525  m .4785  .79092  L .47875  .7847  L .977  .919  .622  r
F
P
p
.47932  .78525  m .47875  .7847  L .48951  .51377  L .977  .919  .622  r
F
P
p
.25554  .57668  m .30475  .61952  L .28562  .60136  L .854  .482  .346  r
F
P
p
.30475  .61952  m .47822  .77054  L .28562  .60136  L .854  .482  .346  r
F
P
p
.25467  .57596  m .2565  .57756  L .25554  .57668  L .854  .482  .346  r
F
P
p
.2565  .57756  m .47822  .77054  L .25554  .57668  L .854  .482  .346  r
F
P
p
.27118  .55816  m .47757  .76988  L .25467  .57596  L .881  .525  .369  r
F
P
p
.47757  .76988  m .47683  .76933  L .25467  .57596  L .881  .525  .369  r
F
P
p
.47757  .76988  m .47822  .77054  L .47683  .76933  L .881  .525  .369  r
F
P
p
.28233  .56959  m .47472  .77753  L .47822  .77054  L .881  .525  .369  r
F
P
p
.29061  .57907  m .47472  .77753  L .28233  .56959  L .881  .525  .369  r
F
P
p
.27275  .55985  m .47472  .77753  L .27191  .55891  L .881  .525  .369  r
F
P
p
.27191  .55891  m .29061  .57907  L .28233  .56959  L .881  .525  .369  r
F
P
p
.27118  .55816  m .27275  .55985  L .27191  .55891  L .881  .525  .369  r
F
P
p
.28981  .54248  m .4742  .77686  L .27118  .55816  L .905  .567  .394  r
F
P
p
.4742  .77686  m .47472  .77753  L .47358  .77629  L .905  .567  .394  r
F
P
p
.4742  .77686  m .47358  .77629  L .27118  .55816  L .905  .567  .394  r
F
P
p
.465  .76517  m .47154  .78324  L .47472  .77753  L .905  .567  .394  r
F
P
p
.291  .54399  m .46538  .77507  L .465  .76517  L .905  .567  .394  r
F
P
p
.46538  .77507  m .47154  .78324  L .465  .76517  L .905  .567  .394  r
F
P
p
.2916  .54482  m .47154  .78324  L .291  .54399  L .905  .567  .394  r
F
P
p
.29107  .54415  m .47154  .78324  L .29038  .5432  L .905  .567  .394  r
F
P
p
.29038  .5432  m .2916  .54482  L .291  .54399  L .905  .567  .394  r
F
P
p
.28981  .54248  m .29107  .54415  L .29038  .5432  L .905  .567  .394  r
F
P
p
.31037  .52914  m .47113  .78259  L .28981  .54248  L .927  .608  .418  r
F
P
p
.47113  .78259  m .47062  .78202  L .28981  .54248  L .927  .608  .418  r
F
P
p
.47113  .78259  m .47154  .78324  L .47062  .78202  L .927  .608  .418  r
F
P
p
.31073  .52972  m .46897  .78777  L .47154  .78324  L .927  .608  .418  r
F
P
p
.31037  .52914  m .31124  .53055  L .31073  .52972  L .927  .608  .418  r
F
P
p
.31124  .53055  m .46897  .78777  L .31073  .52972  L .927  .608  .418  r
F
P
p
.33265  .51835  m .46867  .78717  L .31124  .53055  L .947  .649  .441  r
F
P
p
.33265  .51835  m .31124  .53055  L .31037  .52914  L .947  .649  .441  r
F
P
p
.46867  .78717  m .46897  .78777  L .46827  .78662  L .947  .649  .441  r
F
P
p
.46867  .78717  m .46827  .78662  L .31037  .52914  L .947  .649  .441  r
F
P
p
.33272  .51849  m .46725  .79123  L .46897  .78777  L .947  .649  .441  r
F
P
p
.33284  .51875  m .46725  .79123  L .33272  .51849  L .947  .649  .441  r
F
P
p
.33265  .51835  m .33284  .51875  L .33272  .51849  L .947  .649  .441  r
F
P
p
.45498  .76011  m .46704  .7907  L .33265  .51835  L .966  .688  .456  r
F
P
p
.35642  .51026  m .45498  .76011  L .33265  .51835  L .966  .688  .456  r
F
P
p
.46704  .7907  m .46675  .79021  L .33265  .51835  L .966  .688  .456  r
F
P
p
.35642  .51026  m .46652  .79371  L .46467  .78468  L .966  .688  .456  r
F
P
p
.38147  .50501  m .46641  .79331  L .35642  .51026  L .958  .662  .232  r
F
P
p
.46641  .79331  m .46652  .79371  L .46622  .79292  L .958  .662  .232  r
F
P
p
.46641  .79331  m .46622  .79292  L .35642  .51026  L .958  .662  .232  r
F
P
p
.46704  .7907  m .46725  .79123  L .46675  .79021  L .966  .688  .456  r
F
P
p
.46467  .78468  m .46652  .79371  L .46725  .79123  L .966  .688  .456  r
F
P
p
.46602  .792  m .46677  .79491  L .46652  .79371  L .958  .662  .232  r
F
P
p
.46677  .79491  m .46686  .79526  L .46652  .79371  L .958  .662  .232  r
F
P
p
.38147  .50501  m .46604  .79246  L .46602  .792  L .958  .662  .232  r
F
P
p
.46604  .79246  m .46686  .79526  L .46602  .792  L .958  .662  .232  r
F
P
p
.46183  .50709  m .47062  .79208  L .43442  .50338  L .992  .847  .595  r
F
P
p
.47062  .79208  m .47072  .79544  L .47024  .79156  L .992  .847  .595  r
F
P
p
.47062  .79208  m .47024  .79156  L .43442  .50338  L .992  .847  .595  r
F
P
p
.48951  .51377  m .47441  .78924  L .46183  .50709  L .99  .885  .611  r
F
P
p
.47441  .78924  m .47415  .79385  L .47393  .78869  L .99  .885  .611  r
F
P
p
.47441  .78924  m .47393  .78869  L .46183  .50709  L .99  .885  .611  r
F
P
p
.006  w
.43035  .88594  m
.444  .87697  L
s
P
p
.25  g
.004  w
.40369  .7099  m
.40917  .71256  L
s
P
p
.25  g
.004  w
.48513  .74945  m
.48547  .74961  L
s
P
p
.25  g
.004  w
.37528  .7082  m
.44258  .74488  L
s
P
p
.25  g
.004  w
.48205  .76638  m
.48412  .76751  L
s
P
p
.25  g
.004  w
.46682  .66897  m
.46881  .66949  L
s
P
p
1 0 0 r
.003  w
.51  .57733  m
.52826  .56545  L
s
P
p
.25  g
.004  w
.42879  .88333  m
.43035  .88594  L
s
P
p
.25  g
.004  w
.4287  .88319  m
.42879  .88333  L
s
P
p
.25  g
.004  w
.34506  .74314  m
.4287  .88319  L
s
P
p
.25  g
.004  w
.80181  .51361  m
.80271  .51678  L
s
P
p
.25  g
.004  w
.80271  .51678  m
.80431  .52245  L
s
P
p
.006  w
.83901  .67124  m
.8402  .64932  L
s
P
p
.006  w
.41164  .32038  m
.42507  .30856  L
s
P
p
.79337  .39001  m .62192  .52629  L .63621  .52586  L .282  0 .111  r
F
P
p
.7803  .36981  m .62192  .52629  L .79337  .39001  L .279  0 .186  r
F
P
p
.25  g
.004  w
.81263  .43476  m
.81264  .43476  L
s
P
p
.25  g
.004  w
.79039  .51297  m
.79157  .51564  L
s
P
p
.25  g
.004  w
.79157  .51564  m
.79526  .52392  L
s
P
p
.25  g
.004  w
.80305  .41252  m
.80464  .41144  L
s
P
p
.006  w
.79337  .39001  m
.80464  .41144  L
s
P
p
.25  g
.004  w
.41399  .89015  m
.41526  .89282  L
s
P
p
.25  g
.004  w
.41393  .89003  m
.41399  .89015  L
s
P
p
.25  g
.004  w
.34488  .74503  m
.41393  .89003  L
s
P
p
.006  w
.41526  .89282  m
.43035  .88594  L
s
P
p
1 0 0 r
.003  w
.50934  .57771  m
.51  .57733  L
s
P
p
.7304  .31842  m .58489  .51501  L .59118  .51993  L .189  0 .307  r
F
P
p
.25  g
.004  w
.58028  .50882  m
.58144  .50699  L
s
P
p
.25  g
.004  w
.57804  .49979  m
.57812  .49964  L
s
P
p
.71044  .30488  m .58489  .51501  L .7304  .31842  L .129  0 .32  r
F
P
p
.25  g
.004  w
.57466  .45129  m
.58827  .31993  L
s
P
p
1 0 0 r
.003  w
.58028  .50882  m
.58489  .51501  L
s
P
p
.25  g
.004  w
.58489  .51501  m
.58498  .51488  L
s
P
p
.25  g
.004  w
.70971  .30602  m
.71044  .30488  L
s
P
p
.25  g
.004  w
.70923  .30677  m
.70971  .30602  L
s
P
p
.25  g
.004  w
.70919  .30684  m
.70923  .30677  L
s
P
p
.7803  .36981  m .60961  .52554  L .62192  .52629  L .279  0 .186  r
F
P
p
.25  g
.004  w
.58498  .51488  m
.58589  .51365  L
s
P
p
.25  g
.004  w
.62192  .52629  m
.62202  .52621  L
s
P
p
.25  g
.004  w
.63621  .52586  m
.63643  .52571  L
s
P
p
.76542  .35103  m .60961  .52554  L .7803  .36981  L .263  0 .241  r
F
P
p
.25  g
.004  w
.77676  .5128  m
.77812  .51471  L
s
P
p
.25  g
.004  w
.77812  .51471  m
.78588  .5256  L
s
P
p
.006  w
.7803  .36981  m
.79337  .39001  L
s
P
p
.25  g
.004  w
.79175  .39129  m
.79337  .39001  L
s
P
p
.25  g
.004  w
.77927  .37075  m
.7803  .36981  L
s
P
p
.25  g
.004  w
.39794  .89472  m
.39891  .89744  L
s
P
p
.25  g
.004  w
.3979  .89461  m
.39794  .89472  L
s
P
p
.25  g
.004  w
.34488  .74636  m
.3979  .89461  L
s
P
p
.25  g
.004  w
.81083  .51459  m
.81143  .51797  L
s
P
p
.006  w
.83746  .69212  m
.83901  .67124  L
s
P
p
1 0 0 r
.003  w
.48527  .59122  m
.48646  .5906  L
s
P
p
.006  w
.42507  .30856  m
.44065  .29793  L
s
P
p
.25  g
.004  w
.3809  .89688  m
.38156  .89965  L
s
P
p
.25  g
.004  w
.34492  .74709  m
.3809  .89688  L
s
P
p
.76542  .35103  m .59938  .52345  L .60961  .52554  L .263  0 .241  r
F
P
p
.25  g
.004  w
.60961  .52554  m
.60965  .52551  L
s
P
p
.25  g
.004  w
.60965  .52551  m
.61079  .52447  L
s
P
p
.25  g
.004  w
.61079  .52447  m
.61135  .52395  L
s
P
p
.25  g
.004  w
.58589  .51365  m
.5863  .5131  L
s
P
p
.25  g
.004  w
.62202  .52621  m
.62313  .52533  L
s
P
p
.25  g
.004  w
.62313  .52533  m
.62368  .52489  L
s
P
p
.25  g
.004  w
.63643  .52571  m
.63743  .52503  L
s
P
p
.25  g
.004  w
.63743  .52503  m
.63794  .52468  L
s
P
p
.25  g
.004  w
.65349  .52381  m
.65392  .52357  L
s
P
p
.25  g
.004  w
.65225  .5245  m
.65349  .52381  L
s
P
p
.74877  .33385  m .59938  .52345  L .76542  .35103  L .233  0 .28  r
F
P
p
.25  g
.004  w
.76122  .51321  m
.76186  .51375  L
s
P
p
.25  g
.004  w
.76186  .51375  m
.7624  .5142  L
s
P
p
.25  g
.004  w
.7624  .5142  m
.77805  .52717  L
s
P
p
.25  g
.004  w
.77868  .37129  m
.77927  .37075  L
s
P
p
.006  w
.76542  .35103  m
.7803  .36981  L
s
P
p
.25  g
.004  w
.76387  .35265  m
.76443  .35206  L
s
P
p
.25  g
.004  w
.76443  .35206  m
.76542  .35103  L
s
P
p
1 0 0 r
.003  w
.46474  .60162  m
.46587  .60108  L
s
P
p
.25  g
.004  w
.8173  .51577  m
.81768  .51911  L
s
P
p
1 0 0 r
.003  w
.42718  .61896  m
.44764  .60974  L
s
P
p
.006  w
.39891  .89744  m
.41526  .89282  L
s
P
p
.25  g
.004  w
.36312  .89652  m
.36346  .89931  L
s
P
p
.25  g
.004  w
.36311  .89644  m
.36312  .89652  L
s
P
p
.25  g
.004  w
.34488  .74675  m
.36311  .89644  L
s
P
p
.74877  .33385  m .59118  .51993  L .59938  .52345  L .233  0 .28  r
F
P
p
.25  g
.004  w
.59938  .52345  m
.59939  .52343  L
s
P
p
.25  g
.004  w
.59939  .52343  m
.60051  .52227  L
s
P
p
.25  g
.004  w
.60051  .52227  m
.60105  .52171  L
s
P
p
.25  g
.004  w
.58144  .50699  m
.58151  .50688  L
s
P
p
.25  g
.004  w
.67128  .52184  m
.67193  .52156  L
s
P
p
.25  g
.004  w
.66972  .52251  m
.67128  .52184  L
s
P
p
.7304  .31842  m .59118  .51993  L .74877  .33385  L .189  0 .307  r
F
P
p
1 0 0 r
.003  w
.58489  .51501  m
.59118  .51993  L
s
P
p
.25  g
.004  w
.74412  .51423  m
.74492  .51457  L
s
P
p
.25  g
.004  w
.74492  .51457  m
.74509  .51464  L
s
P
p
.25  g
.004  w
.68959  .5198  m
.69291  .51887  L
s
P
p
.25  g
.004  w
.6895  .51982  m
.68959  .5198  L
s
P
p
.25  g
.004  w
.68816  .5202  m
.6895  .51982  L
s
P
p
.25  g
.004  w
.70823  .51777  m
.72678  .51594  L
s
P
p
.25  g
.004  w
.70707  .51788  m
.70823  .51777  L
s
P
p
.25  g
.004  w
.72688  .51595  m
.75735  .51985  L
s
P
p
.25  g
.004  w
.7259  .51583  m
.72688  .51595  L
s
P
p
.25  g
.004  w
.58211  .43584  m
.61801  .27312  L
s
P
p
.25  g
.004  w
.5744  .48318  m
.64214  .27843  L
s
P
p
.25  g
.004  w
.57584  .49163  m
.66554  .28584  L
s
P
p
.25  g
.004  w
.57812  .49964  m
.68797  .29532  L
s
P
p
.25  g
.004  w
.58151  .50688  m
.70919  .30684  L
s
P
p
.25  g
.004  w
.63794  .52468  m
.80305  .41252  L
s
P
p
.25  g
.004  w
.62368  .52489  m
.79175  .39129  L
s
P
p
.25  g
.004  w
.5863  .5131  m
.729  .32031  L
s
P
p
.25  g
.004  w
.61135  .52395  m
.77868  .37129  L
s
P
p
.25  g
.004  w
.60105  .52171  m
.76384  .35268  L
s
P
p
.25  g
.004  w
.76384  .35268  m
.76387  .35265  L
s
P
p
.006  w
.74877  .33385  m
.76542  .35103  L
s
P
p
.25  g
.004  w
.59274  .51808  m
.74726  .33563  L
s
P
p
.25  g
.004  w
.59225  .51866  m
.59274  .51808  L
s
P
p
.25  g
.004  w
.74726  .33563  m
.74729  .33559  L
s
P
p
.25  g
.004  w
.59122  .51988  m
.59225  .51866  L
s
P
p
.25  g
.004  w
.59118  .51993  m
.59122  .51988  L
s
P
p
.25  g
.004  w
.74729  .33559  m
.74784  .33494  L
s
P
p
.25  g
.004  w
.74784  .33494  m
.74877  .33385  L
s
P
p
.25  g
.004  w
.72956  .31955  m
.7304  .31842  L
s
P
p
.25  g
.004  w
.72904  .32025  m
.72956  .31955  L
s
P
p
.25  g
.004  w
.729  .32031  m
.72904  .32025  L
s
P
p
.25  g
.004  w
.58827  .31993  m
.59364  .26807  L
s
P
p
.006  w
.7304  .31842  m
.74877  .33385  L
s
P
p
1 0 0 r
.003  w
.41642  .62366  m
.42718  .61896  L
s
P
p
1 0 0 r
.003  w
.59118  .51993  m
.59938  .52345  L
s
P
p
.006  w
.44065  .29793  m
.45363  .29103  L
s
P
p
.006  w
.71044  .30488  m
.7304  .31842  L
s
P
p
.25  g
.004  w
.34492  .89355  m
.34492  .89633  L
s
P
p
.25  g
.004  w
.34492  .89349  m
.34492  .89355  L
s
P
p
.25  g
.004  w
.34488  .74452  m
.34492  .89349  L
s
P
p
.83564  .71177  m .8223  .5182  L .8336  .73004  L .589  .638  .867  r
F
P
p
.006  w
.83564  .71177  m
.83746  .69212  L
s
P
p
.006  w
.68904  .29332  m
.71044  .30488  L
s
P
p
.006  w
.45292  .29015  m
.47391  .28207  L
s
P
p
.006  w
.38156  .89965  m
.39891  .89744  L
s
P
p
.25  g
.004  w
.32627  .89067  m
.32662  .88794  L
s
P
p
.25  g
.004  w
.32662  .88794  m
.32663  .88789  L
s
P
p
.25  g
.004  w
.32663  .88789  m
.34536  .74079  L
s
P
p
1 0 0 r
.003  w
.59938  .52345  m
.60961  .52554  L
s
P
p
.006  w
.66642  .28383  m
.68904  .29332  L
s
P
p
.006  w
.47391  .28207  m
.49627  .27561  L
s
P
p
.8336  .73004  m .8208  .51933  L .83141  .74675  L .662  .669  .847  r
F
P
p
.8336  .73004  m .8223  .5182  L .8208  .51933  L .662  .669  .847  r
F
P
p
.006  w
.8336  .73004  m
.83564  .71177  L
s
P
p
.25  g
.004  w
.83326  .72358  m
.83333  .72501  L
s
P
p
.25  g
.004  w
.83333  .72501  m
.83342  .72654  L
s
P
p
.25  g
.004  w
.83342  .72654  m
.83354  .72888  L
s
P
p
.25  g
.004  w
.83354  .72888  m
.8336  .73004  L
s
P
p
.25  g
.004  w
.69291  .51887  m
.82696  .48149  L
s
P
p
.25  g
.004  w
.82113  .517  m
.82128  .51897  L
s
P
p
.006  w
.64279  .27645  m
.66642  .28383  L
s
P
p
.006  w
.49627  .27561  m
.51972  .27088  L
s
P
p
.25  g
.004  w
.30786  .88232  m
.30856  .87968  L
s
P
p
.25  g
.004  w
.30856  .87968  m
.30857  .87965  L
s
P
p
.25  g
.004  w
.30857  .87965  m
.34662  .73601  L
s
P
p
.006  w
.61844  .2712  m
.64279  .27645  L
s
P
p
.006  w
.36346  .89931  m
.38156  .89965  L
s
P
p
.006  w
.51972  .27088  m
.54397  .26798  L
s
P
p
.006  w
.59364  .26807  m
.61844  .2712  L
s
P
p
.006  w
.54397  .26798  m
.56872  .26702  L
s
P
p
.006  w
.56872  .26702  m
.59364  .26807  L
s
P
p
1 0 0 r
.003  w
.60961  .52554  m
.62192  .52629  L
s
P
p
.25  g
.004  w
.29005  .87133  m
.2911  .86883  L
s
P
p
.25  g
.004  w
.2911  .86883  m
.29111  .86881  L
s
P
p
.25  g
.004  w
.29111  .86881  m
.34886  .73067  L
s
P
p
.83141  .74675  m .8208  .51933  L .81667  .52042  L .654  .64  .824  r
F
P
p
.25  g
.004  w
.83128  .74403  m
.83141  .74675  L
s
P
p
.25  g
.004  w
.83096  .73725  m
.83128  .74403  L
s
P
p
.006  w
.83141  .74675  m
.8336  .73004  L
s
P
p
.25  g
.004  w
.8223  .5182  m
.82233  .51863  L
s
P
p
.25  g
.004  w
.82233  .51863  m
.82239  .51991  L
s
P
p
.25  g
.004  w
.81768  .51911  m
.81779  .52012  L
s
P
p
.006  w
.34492  .89633  m
.36346  .89931  L
s
P
p
.25  g
.004  w
.27321  .85779  m
.27459  .85548  L
s
P
p
.25  g
.004  w
.27459  .85548  m
.2746  .85547  L
s
P
p
.25  g
.004  w
.2746  .85547  m
.3521  .72523  L
s
P
p
1 0 0 r
.003  w
.62192  .52629  m
.63621  .52586  L
s
P
p
.82907  .76173  m .80998  .52157  L .82659  .77479  L .656  .62  .802  r
F
P
p
.82907  .76173  m .81667  .52042  L .80998  .52157  L .656  .62  .802  r
F
P
p
.25  g
.004  w
.8208  .51933  m
.82084  .52012  L
s
P
p
.25  g
.004  w
.82084  .52012  m
.82092  .52184  L
s
P
p
.25  g
.004  w
.81143  .51797  m
.81202  .52122  L
s
P
p
.006  w
.82907  .76173  m
.83141  .74675  L
s
P
p
.25  g
.004  w
.81667  .52042  m
.81679  .5226  L
s
P
p
.25  g
.004  w
.82903  .76088  m
.82907  .76173  L
s
P
p
.25  g
.004  w
.67193  .52156  m
.82057  .45782  L
s
P
p
.25  g
.004  w
.82239  .51991  m
.82243  .52051  L
s
P
p
.006  w
.32627  .89067  m
.34492  .89633  L
s
P
p
.25  g
.004  w
.2577  .84188  m
.25938  .8398  L
s
P
p
.25  g
.004  w
.25938  .8398  m
.35624  .7201  L
s
P
p
1 0 0 r
.003  w
.42209  .64289  m
.43433  .64806  L
s
P
p
1 0 0 r
.003  w
.63621  .52586  m
.65225  .5245  L
s
P
p
.82659  .77479  m .80082  .52299  L .82395  .78576  L .658  .602  .781  r
F
P
p
.25  g
.004  w
.82359  .72903  m
.8265  .7733  L
s
P
p
.25  g
.004  w
.8265  .7733  m
.82659  .77479  L
s
P
p
.25  g
.004  w
.80998  .52157  m
.8101  .52342  L
s
P
p
.006  w
.82659  .77479  m
.82907  .76173  L
s
P
p
.25  g
.004  w
.65392  .52357  m
.81263  .43476  L
s
P
p
.006  w
.30786  .88232  m
.32627  .89067  L
s
P
p
.25  g
.004  w
.24383  .82381  m
.24579  .822  L
s
P
p
.25  g
.004  w
.24579  .822  m
.36111  .71561  L
s
P
p
1 0 0 r
.003  w
.43433  .64806  m
.44787  .65636  L
s
P
p
1 0 0 r
.003  w
.65225  .5245  m
.66972  .52251  L
s
P
p
.006  w
.29005  .87133  m
.30786  .88232  L
s
P
p
.25  g
.004  w
.80082  .52299  m
.80095  .52443  L
s
P
p
.82395  .78576  m .78935  .5249  L .8211  .79447  L .66  .585  .76  r
F
P
p
.25  g
.004  w
.82261  .7705  m
.82379  .78392  L
s
P
p
.25  g
.004  w
.82379  .78392  m
.82395  .78576  L
s
P
p
.006  w
.82395  .78576  m
.82659  .77479  L
s
P
p
.25  g
.004  w
.82243  .52051  m
.83326  .72358  L
s
P
p
.25  g
.004  w
.23193  .80383  m
.23412  .80233  L
s
P
p
.25  g
.004  w
.23412  .80233  m
.36645  .71196  L
s
P
p
1 0 0 r
.003  w
.44787  .65636  m
.45409  .66164  L
s
P
p
1 0 0 r
.003  w
.66972  .52251  m
.68816  .5202  L
s
P
p
.006  w
.27321  .85779  m
.29005  .87133  L
s
P
p
.25  g
.004  w
.22225  .78226  m
.22463  .7811  L
s
P
p
.25  g
.004  w
.22463  .7811  m
.37203  .70924  L
s
P
p
1 0 0 r
.003  w
.467  .67489  m
.46915  .67738  L
s
P
p
1 0 0 r
.003  w
.68816  .5202  m
.70707  .51788  L
s
P
p
.8211  .79447  m .77576  .52763  L .81796  .80076  L .66  .567  .739  r
F
P
p
.25  g
.004  w
.81538  .74591  m
.82086  .79239  L
s
P
p
.25  g
.004  w
.82086  .79239  m
.8209  .79277  L
s
P
p
.25  g
.004  w
.8209  .79277  m
.82104  .79393  L
s
P
p
.25  g
.004  w
.82104  .79393  m
.8211  .79447  L
s
P
p
.006  w
.8211  .79447  m
.82395  .78576  L
s
P
p
.25  g
.004  w
.82092  .52184  m
.83096  .73725  L
s
P
p
.25  g
.004  w
.81252  .65589  m
.82261  .7705  L
s
P
p
.006  w
.2577  .84188  m
.27321  .85779  L
s
P
p
1 0 0 r
.003  w
.70707  .51788  m
.7259  .51583  L
s
P
p
.78629  .78127  m .66587  .5767  L .64612  .5916  L .597  .383  .56  r
F
P
p
.79386  .79155  m .66587  .5767  L .78629  .78127  L .617  .421  .593  r
F
P
p
.79386  .79155  m .68582  .5637  L .66587  .5767  L .617  .421  .593  r
F
P
p
.25  g
.004  w
.78935  .5249  m
.78936  .52498  L
s
P
p
.78629  .78127  m .64699  .59278  L .77741  .76832  L .597  .383  .56  r
F
P
p
.64699  .59278  m .64707  .59289  L .77741  .76832  L .597  .383  .56  r
F
P
p
.64681  .59254  m .64727  .59316  L .77741  .76832  L .597  .383  .56  r
F
P
p
.64675  .59246  m .64683  .59256  L .64681  .59254  L .597  .383  .56  r
F
P
p
.64683  .59256  m .64727  .59316  L .64681  .59254  L .597  .383  .56  r
F
P
p
.64699  .59278  m .64675  .59246  L .64707  .59289  L .597  .383  .56  r
F
P
p
.64675  .59246  m .64612  .5916  L .64727  .59316  L .597  .383  .56  r
F
P
p
.77741  .76832  m .64612  .5916  L .6269  .60818  L .571  .337  .523  r
F
P
p
.77741  .76832  m .62783  .60916  L .76706  .75292  L .571  .337  .523  r
F
P
p
.62783  .60916  m .6269  .60818  L .62816  .60948  L .571  .337  .523  r
F
P
p
.62783  .60916  m .62816  .60948  L .76706  .75292  L .571  .337  .523  r
F
P
p
.60922  .62666  m .6269  .60818  L .6085  .62608  L .535  .283  .479  r
F
P
p
.76622  .75224  m .62816  .60948  L .60922  .62666  L .535  .283  .479  r
F
P
p
.62816  .60948  m .6269  .60818  L .60922  .62666  L .535  .283  .479  r
F
P
p
.76557  .75138  m .6269  .60818  L .76622  .75224  L .535  .283  .479  r
F
P
p
.76706  .75292  m .76557  .75138  L .76622  .75224  L .535  .283  .479  r
F
P
p
.76706  .75292  m .60946  .62685  L .75511  .73534  L .535  .283  .479  r
F
P
p
.60946  .62685  m .60955  .62691  L .75511  .73534  L .535  .283  .479  r
F
P
p
.60924  .62667  m .6098  .62705  L .75511  .73534  L .535  .283  .479  r
F
P
p
.60922  .62666  m .60924  .62667  L .60924  .62667  L .535  .283  .479  r
F
P
p
.60924  .62667  m .6098  .62705  L .60924  .62667  L .535  .283  .479  r
F
P
p
.75394  .73469  m .6098  .62705  L .59113  .64488  L .488  .216  .427  r
F
P
p
.75355  .73417  m .6085  .62608  L .75394  .73469  L .488  .216  .427  r
F
P
p
.75511  .73534  m .75355  .73417  L .75394  .73469  L .488  .216  .427  r
F
P
p
.75511  .73534  m .59212  .64543  L .74145  .71593  L .488  .216  .427  r
F
P
p
.59212  .64543  m .59113  .64488  L .59246  .64551  L .488  .216  .427  r
F
P
p
.59212  .64543  m .59246  .64551  L .74145  .71593  L .488  .216  .427  r
F
P
p
.7398  .71515  m .59246  .64551  L .7405  .71562  L .423  .131  .363  r
F
P
p
.59246  .64551  m .59113  .64488  L .59246  .64551  L .423  .131  .363  r
F
P
p
.59246  .64551  m .59246  .64551  L .7405  .71562  L .423  .131  .363  r
F
P
p
.74023  .71555  m .59113  .64488  L .57496  .6641  L .423  .131  .363  r
F
P
p
.74012  .71544  m .59113  .64488  L .74023  .71555  L .423  .131  .363  r
F
P
p
.74039  .71542  m .7398  .71515  L .74056  .71565  L .423  .131  .363  r
F
P
p
.7398  .71515  m .7405  .71562  L .74056  .71565  L .423  .131  .363  r
F
P
p
.74056  .71565  m .74012  .71544  L .74023  .71555  L .423  .131  .363  r
F
P
p
.74145  .71593  m .74039  .71542  L .74056  .71565  L .423  .131  .363  r
F
P
p
.74145  .71593  m .57594  .66441  L .72601  .6951  L .423  .131  .363  r
F
P
p
.57594  .66441  m .57603  .6644  L .72601  .6951  L .423  .131  .363  r
F
P
p
.57574  .66434  m .57626  .66437  L .72601  .6951  L .423  .131  .363  r
F
P
p
.57569  .66433  m .57575  .66433  L .57574  .66434  L .423  .131  .363  r
F
P
p
.57575  .66433  m .57626  .66437  L .57574  .66434  L .423  .131  .363  r
F
P
p
.72476  .69501  m .57626  .66437  L .56007  .68322  L .334  .024  .282  r
F
P
p
.72433  .69475  m .57496  .6641  L .72476  .69501  L .334  .024  .282  r
F
P
p
.72601  .6951  m .72433  .69475  L .72476  .69501  L .334  .024  .282  r
F
P
p
.72601  .6951  m .56104  .68329  L .70875  .67331  L .334  .024  .282  r
F
P
p
.56104  .68329  m .56007  .68322  L .56135  .68313  L .334  .024  .282  r
F
P
p
.56104  .68329  m .56135  .68313  L .70875  .67331  L .334  .024  .282  r
F
P
p
.70708  .67342  m .56135  .68313  L .70782  .67347  L .213  0 .178  r
F
P
p
.56135  .68313  m .56007  .68322  L .56135  .68313  L .213  0 .178  r
F
P
p
.56135  .68313  m .56135  .68313  L .70782  .67347  L .213  0 .178  r
F
P
p
.70751  .67353  m .56007  .68322  L .5465  .70174  L .213  0 .178  r
F
P
p
.7074  .6735  m .56007  .68322  L .70751  .67353  L .213  0 .178  r
F
P
p
.70764  .67338  m .70708  .67342  L .70783  .67347  L .213  0 .178  r
F
P
p
.70708  .67342  m .70782  .67347  L .70783  .67347  L .213  0 .178  r
F
P
p
.70783  .67347  m .7074  .6735  L .70751  .67353  L .213  0 .178  r
F
P
p
.70875  .67331  m .70764  .67338  L .70783  .67347  L .213  0 .178  r
F
P
p
.70875  .67331  m .54744  .70157  L .68971  .65107  L .213  0 .178  r
F
P
p
.54744  .70157  m .54752  .7015  L .68971  .65107  L .213  0 .178  r
F
P
p
.54718  .70162  m .54768  .70132  L .68971  .65107  L .213  0 .178  r
F
P
p
.6885  .6516  m .54768  .70132  L .53424  .7192  L .05  0 .047  r
F
P
p
.54718  .70162  m .5465  .70174  L .54768  .70132  L .213  0 .178  r
F
P
p
.68807  .65165  m .5465  .70174  L .6885  .6516  L .05  0 .047  r
F
P
p
.68971  .65107  m .68807  .65165  L .6885  .6516  L .05  0 .047  r
F
P
p
.68971  .65107  m .53424  .7192  L .66894  .62888  L .05  0 .047  r
F
P
p
.66805  .62953  m .53424  .7192  L .66806  .62952  L 0 0 0 r
F
P
p
.6674  .62992  m .53424  .7192  L .66805  .62953  L 0 0 0 r
F
P
p
.66779  .62972  m .53424  .7192  L .52322  .7352  L 0 0 0 r
F
P
p
.66769  .62977  m .53424  .7192  L .66779  .62972  L 0 0 0 r
F
P
p
.66789  .62959  m .6674  .62992  L .66805  .62953  L 0 0 0 r
F
P
p
.66806  .62952  m .66769  .62977  L .66779  .62972  L 0 0 0 r
F
P
p
.66894  .62888  m .66789  .62959  L .66806  .62952  L 0 0 0 r
F
P
p
.66894  .62888  m .52322  .7352  L .64656  .60727  L 0 0 0 r
F
P
p
.64549  .60841  m .52322  .7352  L .51335  .74944  L 0 0 0 r
F
P
p
.64656  .60727  m .64512  .60876  L .64549  .60841  L 0 0 0 r
F
P
p
.64512  .60876  m .52322  .7352  L .64549  .60841  L 0 0 0 r
F
P
p
.54744  .70157  m .54718  .70162  L .54752  .7015  L .213  0 .178  r
F
P
p
.54768  .70132  m .5465  .70174  L .53424  .7192  L .05  0 .047  r
F
P
p
.57594  .66441  m .57569  .66433  L .57603  .6644  L .423  .131  .363  r
F
P
p
.57569  .66433  m .57496  .6641  L .57626  .66437  L .423  .131  .363  r
F
P
p
.57626  .66437  m .57496  .6641  L .56007  .68322  L .334  .024  .282  r
F
P
p
.60946  .62685  m .60922  .62666  L .60955  .62691  L .535  .283  .479  r
F
P
p
.60922  .62666  m .6085  .62608  L .6098  .62705  L .535  .283  .479  r
F
P
p
.6098  .62705  m .6085  .62608  L .59113  .64488  L .488  .216  .427  r
F
P
p
.25  g
.004  w
.64612  .5916  m
.64727  .59316  L
s
P
p
.25  g
.004  w
.64727  .59316  m
.64731  .5932  L
s
P
p
1 0 0 r
.003  w
.64612  .5916  m
.66587  .5767  L
s
P
p
.25  g
.004  w
.66587  .5767  m
.66691  .57847  L
s
P
p
.25  g
.004  w
.66691  .57847  m
.66696  .57855  L
s
P
p
1 0 0 r
.003  w
.6269  .60818  m
.64612  .5916  L
s
P
p
.80029  .79904  m .68582  .5637  L .79386  .79155  L .632  .453  .622  r
F
P
p
.80029  .79904  m .70561  .55273  L .68582  .5637  L .632  .453  .622  r
F
P
p
.25  g
.004  w
.78936  .52498  m
.78953  .52639  L
s
P
p
1 0 0 r
.003  w
.66587  .5767  m
.68582  .5637  L
s
P
p
.25  g
.004  w
.64731  .5932  m
.69416  .65627  L
s
P
p
.25  g
.004  w
.68582  .5637  m
.68673  .56563  L
s
P
p
.25  g
.004  w
.68673  .56563  m
.68679  .56576  L
s
P
p
.25  g
.004  w
.21501  .75943  m
.21753  .75863  L
s
P
p
.25  g
.004  w
.21753  .75863  m
.37763  .70745  L
s
P
p
.25  g
.004  w
.6269  .60818  m
.62815  .60946  L
s
P
p
.25  g
.004  w
.62815  .60946  m
.62816  .60948  L
s
P
p
.25  g
.004  w
.62816  .60948  m
.63631  .6179  L
s
P
p
1 0 0 r
.003  w
.6085  .62608  m
.6269  .60818  L
s
P
p
.80575  .80368  m .70561  .55273  L .80029  .79904  L .643  .481  .648  r
F
P
p
.80575  .80368  m .72487  .54379  L .70561  .55273  L .643  .481  .648  r
F
P
p
.25  g
.004  w
.80095  .52443  m
.801  .52504  L
s
P
p
.25  g
.004  w
.78953  .52639  m
.78961  .52712  L
s
P
p
1 0 0 r
.003  w
.68582  .5637  m
.70561  .55273  L
s
P
p
.25  g
.004  w
.70561  .55273  m
.70646  .55495  L
s
P
p
1 0 0 r
.003  w
.7259  .51583  m
.74412  .51423  L
s
P
p
.81042  .80547  m .72487  .54379  L .80575  .80368  L .651  .506  .673  r
F
P
p
.81042  .80547  m .74321  .53678  L .72487  .54379  L .651  .506  .673  r
F
P
p
.25  g
.004  w
.8101  .52342  m
.81014  .52408  L
s
P
p
.25  g
.004  w
.801  .52504  m
.80104  .52543  L
s
P
p
.25  g
.004  w
.79934  .60972  m
.81538  .74591  L
s
P
p
.25  g
.004  w
.78961  .52712  m
.78964  .52731  L
s
P
p
1 0 0 r
.003  w
.70561  .55273  m
.72487  .54379  L
s
P
p
.25  g
.004  w
.72487  .54379  m
.72548  .54576  L
s
P
p
.25  g
.004  w
.72548  .54576  m
.72559  .54611  L
s
P
p
.25  g
.004  w
.6085  .62608  m
.6098  .62705  L
s
P
p
.25  g
.004  w
.6098  .62705  m
.60981  .62706  L
s
P
p
.25  g
.004  w
.60981  .62706  m
.62009  .63472  L
s
P
p
1 0 0 r
.003  w
.59113  .64488  m
.59168  .64429  L
s
P
p
1 0 0 r
.003  w
.59168  .64429  m
.6085  .62608  L
s
P
p
.006  w
.24383  .82381  m
.2577  .84188  L
s
P
p
.81444  .80446  m .74321  .53678  L .81042  .80547  L .656  .528  .696  r
F
P
p
.81444  .80446  m .76029  .53148  L .74321  .53678  L .656  .528  .696  r
F
P
p
.25  g
.004  w
.81014  .52408  m
.81015  .52414  L
s
P
p
.25  g
.004  w
.66696  .57855  m
.7483  .71673  L
s
P
p
.25  g
.004  w
.68679  .56576  m
.75552  .71069  L
s
P
p
.25  g
.004  w
.70646  .55495  m
.74463  .65424  L
s
P
p
.25  g
.004  w
.72559  .54611  m
.74887  .62093  L
s
P
p
1 0 0 r
.003  w
.72487  .54379  m
.74321  .53678  L
s
P
p
.25  g
.004  w
.74321  .53678  m
.7438  .53913  L
s
P
p
.25  g
.004  w
.7438  .53913  m
.74896  .55977  L
s
P
p
1 0 0 r
.003  w
.74321  .53678  m
.74768  .53539  L
s
P
p
.81796  .80076  m .76029  .53148  L .81444  .80446  L .659  .548  .718  r
F
P
p
.25  g
.004  w
.80981  .80304  m
.81042  .80547  L
s
P
p
.25  g
.004  w
.80504  .8014  m
.80575  .80368  L
s
P
p
.25  g
.004  w
.80499  .80124  m
.80504  .8014  L
s
P
p
.81796  .80076  m .77576  .52763  L .76029  .53148  L .659  .548  .718  r
F
P
p
.25  g
.004  w
.81679  .5226  m
.81681  .52301  L
s
P
p
.25  g
.004  w
.81681  .52301  m
.82903  .76088  L
s
P
p
.006  w
.81796  .80076  m
.8211  .79447  L
s
P
p
.25  g
.004  w
.81015  .52414  m
.82359  .72903  L
s
P
p
.25  g
.004  w
.80104  .52543  m
.81252  .65589  L
s
P
p
.25  g
.004  w
.78964  .52731  m
.79934  .60972  L
s
P
p
.25  g
.004  w
.7483  .71673  m
.78506  .77918  L
s
P
p
.25  g
.004  w
.78506  .77918  m
.7851  .77925  L
s
P
p
.25  g
.004  w
.7851  .77925  m
.78556  .78003  L
s
P
p
.25  g
.004  w
.78556  .78003  m
.78629  .78127  L
s
P
p
.25  g
.004  w
.75552  .71069  m
.79278  .78928  L
s
P
p
.25  g
.004  w
.79278  .78928  m
.79283  .78938  L
s
P
p
.25  g
.004  w
.79283  .78938  m
.79324  .79025  L
s
P
p
.25  g
.004  w
.79324  .79025  m
.79386  .79155  L
s
P
p
.25  g
.004  w
.74463  .65424  m
.79937  .79666  L
s
P
p
.25  g
.004  w
.79937  .79666  m
.79942  .79678  L
s
P
p
.25  g
.004  w
.79942  .79678  m
.79978  .79772  L
s
P
p
.25  g
.004  w
.79978  .79772  m
.80029  .79904  L
s
P
p
.25  g
.004  w
.74887  .62093  m
.80499  .80124  L
s
P
p
.25  g
.004  w
.77005  .64409  m
.80981  .80304  L
s
P
p
.25  g
.004  w
.74896  .55977  m
.77005  .64409  L
s
P
p
1 0 0 r
.003  w
.74768  .53539  m
.76029  .53148  L
s
P
p
.25  g
.004  w
.81783  .79991  m
.81796  .80076  L
s
P
p
.25  g
.004  w
.81766  .7988  m
.81783  .79991  L
s
P
p
.25  g
.004  w
.81761  .7985  m
.81766  .7988  L
s
P
p
.25  g
.004  w
.80404  .71066  m
.81761  .7985  L
s
P
p
.25  g
.004  w
.78438  .58342  m
.80404  .71066  L
s
P
p
.25  g
.004  w
.77613  .52999  m
.78438  .58342  L
s
P
p
.25  g
.004  w
.77606  .52956  m
.77613  .52999  L
s
P
p
.25  g
.004  w
.77589  .52847  m
.77606  .52956  L
s
P
p
.25  g
.004  w
.77576  .52763  m
.77589  .52847  L
s
P
p
.25  g
.004  w
.74509  .51464  m
.7451  .51465  L
s
P
p
.25  g
.004  w
.7451  .51465  m
.7757  .52765  L
s
P
p
.006  w
.81444  .80446  m
.81796  .80076  L
s
P
p
1 0 0 r
.003  w
.74412  .51423  m
.76122  .51321  L
s
P
p
.25  g
.004  w
.78869  .67465  m
.81444  .80446  L
s
P
p
.25  g
.004  w
.7676  .56835  m
.78869  .67465  L
s
P
p
.25  g
.004  w
.76029  .53148  m
.7606  .53308  L
s
P
p
.25  g
.004  w
.7606  .53308  m
.76074  .53376  L
s
P
p
.25  g
.004  w
.76074  .53376  m
.76075  .53382  L
s
P
p
.25  g
.004  w
.76075  .53382  m
.7676  .56835  L
s
P
p
1 0 0 r
.003  w
.76462  .53041  m
.77576  .52763  L
s
P
p
1 0 0 r
.003  w
.76029  .53148  m
.76462  .53041  L
s
P
p
.25  g
.004  w
.59113  .64488  m
.59118  .64491  L
s
P
p
.25  g
.004  w
.59118  .64491  m
.59245  .64551  L
s
P
p
.25  g
.004  w
.59245  .64551  m
.59246  .64551  L
s
P
p
.25  g
.004  w
.59246  .64551  m
.59246  .64551  L
s
P
p
.25  g
.004  w
.59246  .64551  m
.6043  .65111  L
s
P
p
1 0 0 r
.003  w
.57496  .6641  m
.57622  .66259  L
s
P
p
1 0 0 r
.003  w
.57622  .66259  m
.59113  .64488  L
s
P
p
1 0 0 r
.003  w
.77947  .52689  m
.78935  .5249  L
s
P
p
1 0 0 r
.003  w
.77576  .52763  m
.77947  .52689  L
s
P
p
1 0 0 r
.003  w
.76122  .51321  m
.77676  .5128  L
s
P
p
1 0 0 r
.003  w
.79229  .52441  m
.80082  .52299  L
s
P
p
1 0 0 r
.003  w
.78935  .5249  m
.79229  .52441  L
s
P
p
1 0 0 r
.003  w
.803  .52265  m
.80998  .52157  L
s
P
p
1 0 0 r
.003  w
.80082  .52299  m
.803  .52265  L
s
P
p
.25  g
.004  w
.57496  .6641  m
.57508  .66412  L
s
P
p
.25  g
.004  w
.57508  .66412  m
.57587  .66429  L
s
P
p
.25  g
.004  w
.57587  .66429  m
.57626  .66437  L
s
P
p
.25  g
.004  w
.57626  .66437  m
.57627  .66437  L
s
P
p
.25  g
.004  w
.57627  .66437  m
.58899  .66698  L
s
P
p
1 0 0 r
.003  w
.56007  .68322  m
.57496  .6641  L
s
P
p
.25  g
.004  w
.21038  .73571  m
.21299  .73527  L
s
P
p
.25  g
.004  w
.21299  .73527  m
.38315  .70652  L
s
P
p
1 0 0 r
.003  w
.47954  .6957  m
.48205  .70176  L
s
P
p
.006  w
.23193  .80383  m
.24383  .82381  L
s
P
p
1 0 0 r
.003  w
.77676  .5128  m
.79039  .51297  L
s
P
p
1 0 0 r
.003  w
.81148  .52131  m
.81667  .52042  L
s
P
p
1 0 0 r
.003  w
.80998  .52157  m
.81148  .52131  L
s
P
p
1 0 0 r
.003  w
.8176  .52017  m
.8208  .51933  L
s
P
p
1 0 0 r
.003  w
.81667  .52042  m
.8176  .52017  L
s
P
p
1 0 0 r
.003  w
.79039  .51297  m
.80181  .51361  L
s
P
p
1 0 0 r
.003  w
.82124  .519  m
.8223  .5182  L
s
P
p
1 0 0 r
.003  w
.8208  .51933  m
.82124  .519  L
s
P
p
1 0 0 r
.003  w
.80181  .51361  m
.81083  .51459  L
s
P
p
1 0 0 r
.003  w
.82113  .517  m
.8223  .5182  L
s
P
p
1 0 0 r
.003  w
.81083  .51459  m
.8173  .51577  L
s
P
p
1 0 0 r
.003  w
.8173  .51577  m
.82113  .517  L
s
P
p
.25  g
.004  w
.56007  .68322  m
.561  .68315  L
s
P
p
.25  g
.004  w
.561  .68315  m
.56133  .68313  L
s
P
p
.25  g
.004  w
.56133  .68313  m
.56135  .68313  L
s
P
p
.25  g
.004  w
.56135  .68313  m
.57425  .68227  L
s
P
p
1 0 0 r
.003  w
.5465  .70174  m
.56007  .68322  L
s
P
p
.006  w
.81042  .80547  m
.81444  .80446  L
s
P
p
.006  w
.22225  .78226  m
.23193  .80383  L
s
P
p
.25  g
.004  w
.20848  .71147  m
.21112  .7114  L
s
P
p
.25  g
.004  w
.21112  .7114  m
.38856  .70637  L
s
P
p
.25  g
.004  w
.5465  .70174  m
.54768  .70132  L
s
P
p
.25  g
.004  w
.54768  .70132  m
.54772  .70131  L
s
P
p
.25  g
.004  w
.54772  .70131  m
.56013  .69692  L
s
P
p
1 0 0 r
.003  w
.53424  .7192  m
.5465  .70174  L
s
P
p
.006  w
.21501  .75943  m
.22225  .78226  L
s
P
p
.25  g
.004  w
.53424  .7192  m
.53531  .71848  L
s
P
p
.25  g
.004  w
.53531  .71848  m
.54671  .71084  L
s
P
p
1 0 0 r
.003  w
.52322  .7352  m
.53424  .7192  L
s
P
p
.006  w
.80575  .80368  m
.81042  .80547  L
s
P
p
.25  g
.004  w
.20937  .6871  m
.21198  .68738  L
s
P
p
.25  g
.004  w
.21198  .68738  m
.39396  .70695  L
s
P
p
.006  w
.21038  .73571  m
.21501  .75943  L
s
P
p
.006  w
.20848  .71147  m
.21038  .73571  L
s
P
p
.25  g
.004  w
.21306  .66297  m
.2156  .66359  L
s
P
p
.25  g
.004  w
.2156  .66359  m
.39948  .70829  L
s
P
p
1 0 0 r
.003  w
.48656  .7416  m
.48707  .73166  L
s
P
p
.006  w
.80029  .79904  m
.80575  .80368  L
s
P
p
.62274  .58671  m .51335  .74944  L .50455  .76172  L .609  .826  .432  r
F
P
p
.25  g
.004  w
.52322  .7352  m
.52416  .73422  L
s
P
p
.64656  .60727  m .51335  .74944  L .62274  .58671  L 0 0 0 r
F
P
p
.006  w
.20848  .71147  m
.20937  .6871  L
s
P
p
.25  g
.004  w
.21953  .63946  m
.22195  .64038  L
s
P
p
.25  g
.004  w
.22195  .64038  m
.40534  .71053  L
s
P
p
1 0 0 r
.003  w
.48457  .75253  m
.48656  .7416  L
s
P
p
.006  w
.20937  .6871  m
.21306  .66297  L
s
P
p
.59765  .56767  m .50455  .76172  L .49673  .77196  L .777  .918  .538  r
F
P
p
.25  g
.004  w
.51335  .74944  m
.51416  .74824  L
s
P
p
.62274  .58671  m .50455  .76172  L .59765  .56767  L .609  .826  .432  r
F
P
p
1 0 0 r
.003  w
.50455  .76172  m
.51335  .74944  L
s
P
p
.25  g
.004  w
.6227  .58676  m
.62274  .58671  L
s
P
p
.25  g
.004  w
.62185  .58804  m
.6227  .58676  L
s
P
p
.25  g
.004  w
.62144  .58864  m
.62185  .58804  L
s
P
p
.006  w
.79386  .79155  m
.80029  .79904  L
s
P
p
.006  w
.21306  .66297  m
.21953  .63946  L
s
P
p
.25  g
.004  w
.22869  .6169  m
.23095  .6181  L
s
P
p
.25  g
.004  w
.23095  .6181  m
.4117  .7139  L
s
P
p
1 0 0 r
.003  w
.48358  .75579  m
.48457  .75253  L
s
P
p
.57154  .55055  m .49673  .77196  L .4898  .78015  L .885  .95  .597  r
F
P
p
.25  g
.004  w
.50455  .76172  m
.50521  .76035  L
s
P
p
.25  g
.004  w
.51416  .74824  m
.51426  .74809  L
s
P
p
.59765  .56767  m .49673  .77196  L .57154  .55055  L .777  .918  .538  r
F
P
p
1 0 0 r
.003  w
.49673  .77196  m
.50455  .76172  L
s
P
p
.25  g
.004  w
.59761  .56776  m
.59765  .56767  L
s
P
p
.25  g
.004  w
.59688  .56928  m
.59761  .56776  L
s
P
p
.25  g
.004  w
.59654  .56999  m
.59688  .56928  L
s
P
p
.006  w
.21953  .63946  m
.22869  .6169  L
s
P
p
.25  g
.004  w
.24045  .59563  m
.24252  .59706  L
s
P
p
.25  g
.004  w
.24252  .59706  m
.4187  .71873  L
s
P
p
1 0 0 r
.003  w
.47822  .77054  m
.47943  .76758  L
s
P
p
.006  w
.78629  .78127  m
.79386  .79155  L
s
P
p
.54464  .53568  m .4898  .78015  L .48373  .78642  L .946  .944  .62  r
F
P
p
.25  g
.004  w
.49673  .77196  m
.49724  .77045  L
s
P
p
.25  g
.004  w
.50521  .76035  m
.50533  .7601  L
s
P
p
.57154  .55055  m .4898  .78015  L .54464  .53568  L .885  .95  .597  r
F
P
p
1 0 0 r
.003  w
.4898  .78015  m
.49673  .77196  L
s
P
p
.25  g
.004  w
.57149  .55069  m
.57154  .55055  L
s
P
p
.25  g
.004  w
.5709  .55243  m
.57149  .55069  L
s
P
p
.25  g
.004  w
.57063  .55323  m
.5709  .55243  L
s
P
p
.006  w
.22869  .6169  m
.24045  .59563  L
s
P
p
.25  g
.004  w
.25467  .57596  m
.2565  .57756  L
s
P
p
.25  g
.004  w
.2565  .57756  m
.42635  .72539  L
s
P
p
1 0 0 r
.003  w
.47509  .77679  m
.47822  .77054  L
s
P
p
.5172  .52335  m .48373  .78642  L .4785  .79092  L .977  .919  .622  r
F
P
p
.25  g
.004  w
.4898  .78015  m
.49016  .77853  L
s
P
p
.25  g
.004  w
.49724  .77045  m
.49736  .77007  L
s
P
p
.25  g
.004  w
.50533  .7601  m
.50536  .76004  L
s
P
p
.54464  .53568  m .48373  .78642  L .5172  .52335  L .946  .944  .62  r
F
P
p
.25  g
.004  w
.51426  .74809  m
.62144  .58864  L
s
P
p
.25  g
.004  w
.50536  .76004  m
.59654  .56999  L
s
P
p
.25  g
.004  w
.49736  .77007  m
.57063  .55323  L
s
P
p
.25  g
.004  w
.49016  .77853  m
.54396  .53869  L
s
P
p
1 0 0 r
.003  w
.48373  .78642  m
.4898  .78015  L
s
P
p
.25  g
.004  w
.51678  .52666  m
.5169  .52573  L
s
P
p
.25  g
.004  w
.5169  .52573  m
.51717  .52364  L
s
P
p
.25  g
.004  w
.51717  .52364  m
.5172  .52335  L
s
P
p
.25  g
.004  w
.48373  .78642  m
.4846  .77952  L
s
P
p
.25  g
.004  w
.54459  .53589  m
.54464  .53568  L
s
P
p
.25  g
.004  w
.54416  .53782  m
.54459  .53589  L
s
P
p
.25  g
.004  w
.54396  .53869  m
.54416  .53782  L
s
P
p
.006  w
.24045  .59563  m
.25467  .57596  L
s
P
p
.006  w
.77741  .76832  m
.78629  .78127  L
s
P
p
.25  g
.004  w
.27118  .55816  m
.27275  .55985  L
s
P
p
.25  g
.004  w
.27275  .55985  m
.29114  .57966  L
s
P
p
.25  g
.004  w
.29114  .57966  m
.43455  .73423  L
s
P
p
1 0 0 r
.003  w
.47154  .78324  m
.47354  .77964  L
s
P
p
.48951  .51377  m .4785  .79092  L .47415  .79385  L .99  .885  .611  r
F
P
p
.25  g
.004  w
.4785  .79092  m
.47875  .7847  L
s
P
p
.25  g
.004  w
.48938  .5172  m
.48951  .51377  L
s
P
p
.25  g
.004  w
.47875  .7847  m
.48938  .5172  L
s
P
p
1 0 0 r
.003  w
.4785  .79092  m
.48373  .78642  L
s
P
p
.25  g
.004  w
.4846  .77952  m
.51678  .52666  L
s
P
p
.006  w
.25467  .57596  m
.27118  .55816  L
s
P
p
.25  g
.004  w
.28981  .54248  m
.29107  .54415  L
s
P
p
.25  g
.004  w
.29107  .54415  m
.29214  .54555  L
s
P
p
.46183  .50709  m .47415  .79385  L .47072  .79544  L .992  .847  .595  r
F
P
p
.25  g
.004  w
.47393  .78869  m
.47415  .79385  L
s
P
p
1 0 0 r
.003  w
.46897  .78777  m
.46962  .78661  L
s
P
p
1 0 0 r
.003  w
.47415  .79385  m
.4785  .79092  L
s
P
p
.006  w
.27118  .55816  m
.28981  .54248  L
s
P
p
.25  g
.004  w
.31037  .52914  m
.31124  .53055  L
s
P
p
.43442  .50338  m .47072  .79544  L .46827  .79586  L .987  .808  .577  r
F
P
p
.25  g
.004  w
.47024  .79156  m
.47072  .79544  L
s
P
p
1 0 0 r
.003  w
.46725  .79123  m
.46764  .79044  L
s
P
p
1 0 0 r
.003  w
.47072  .79544  m
.47415  .79385  L
s
P
p
.006  w
.76706  .75292  m
.77741  .76832  L
s
P
p
.25  g
.004  w
.33265  .51835  m
.33284  .51875  L
s
P
p
.25  g
.004  w
.33284  .51875  m
.3375  .52819  L
s
P
p
.40755  .5027  m .46827  .79586  L .46686  .79526  L .973  .768  .569  r
F
P
p
.43442  .50338  m .46827  .79586  L .40755  .5027  L .987  .808  .577  r
F
P
p
1 0 0 r
.003  w
.46827  .79586  m
.47072  .79544  L
s
P
p
1 0 0 r
.003  w
.46652  .79371  m
.46654  .79366  L
s
P
p
.25  g
.004  w
.46757  .79248  m
.46827  .79586  L
s
P
p
.25  g
.004  w
.3593  .51769  m
.36228  .52535  L
s
P
p
.25  g
.004  w
.35642  .51026  m
.3593  .51769  L
s
P
p
.40755  .5027  m .46686  .79526  L .38147  .50501  L .973  .768  .569  r
F
P
p
.25  g
.004  w
.4668  .79505  m
.46686  .79526  L
s
P
p
.25  g
.004  w
.46604  .79246  m
.4668  .79505  L
s
P
p
.25  g
.004  w
.38147  .50501  m
.38327  .51115  L
s
P
p
.25  g
.004  w
.38327  .51115  m
.38334  .51139  L
s
P
p
.25  g
.004  w
.38334  .51139  m
.46604  .79246  L
s
P
p
.25  g
.004  w
.46567  .79149  m
.46603  .79245  L
s
P
p
.25  g
.004  w
.36228  .52535  m
.46567  .79149  L
s
P
p
1 0 0 r
.003  w
.46686  .79526  m
.46827  .79586  L
s
P
p
.25  g
.004  w
.40755  .5027  m
.40849  .50726  L
s
P
p
.25  g
.004  w
.40849  .50726  m
.40855  .50752  L
s
P
p
.25  g
.004  w
.40855  .50752  m
.46757  .79248  L
s
P
p
.25  g
.004  w
.3375  .52819  m
.4593  .7751  L
s
P
p
.25  g
.004  w
.29214  .54555  m
.44304  .74548  L
s
P
p
.25  g
.004  w
.46391  .55548  m
.47393  .78869  L
s
P
p
.25  g
.004  w
.46183  .50709  m
.46391  .55548  L
s
P
p
.25  g
.004  w
.31124  .53055  m
.45145  .7592  L
s
P
p
.25  g
.004  w
.43442  .50338  m
.43544  .51159  L
s
P
p
.25  g
.004  w
.43544  .51159  m
.47024  .79156  L
s
P
p
.006  w
.28981  .54248  m
.31037  .52914  L
s
P
p
.006  w
.31037  .52914  m
.33265  .51835  L
s
P
p
.006  w
.75511  .73534  m
.76706  .75292  L
s
P
p
.006  w
.33265  .51835  m
.35642  .51026  L
s
P
p
.006  w
.74145  .71593  m
.75511  .73534  L
s
P
p
.006  w
.35642  .51026  m
.38147  .50501  L
s
P
p
.006  w
.38147  .50501  m
.40755  .5027  L
s
P
p
.006  w
.72601  .6951  m
.74145  .71593  L
s
P
p
.006  w
.40755  .5027  m
.43442  .50338  L
s
P
p
.006  w
.70875  .67331  m
.72601  .6951  L
s
P
p
.006  w
.43442  .50338  m
.46183  .50709  L
s
P
p
.006  w
.46183  .50709  m
.48951  .51377  L
s
P
p
.006  w
.68971  .65107  m
.70875  .67331  L
s
P
p
.006  w
.48951  .51377  m
.5172  .52335  L
s
P
p
.006  w
.66894  .62888  m
.68971  .65107  L
s
P
p
.006  w
.5172  .52335  m
.54464  .53568  L
s
P
p
.006  w
.64656  .60727  m
.66894  .62888  L
s
P
p
.006  w
.54464  .53568  m
.57154  .55055  L
s
P
p
.006  w
.62274  .58671  m
.64656  .60727  L
s
P
p
.006  w
.57154  .55055  m
.59765  .56767  L
s
P
p
.006  w
.59765  .56767  m
.62274  .58671  L
s
P
p
.002  w
.66295  .02755  m
.90359  .41965  L
s
.90359  .41965  m
.97245  .92345  L
s
.97245  .92345  m
.69507  .58075  L
s
.69507  .58075  m
.66295  .02755  L
s
.11113  .25957  m
.02755  .78701  L
s
.02755  .78701  m
.69507  .58075  L
s
.69507  .58075  m
.66295  .02755  L
s
.66295  .02755  m
.11113  .25957  L
s
P
p
P
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; nowordwrap; ]
No Input Form was saved for this expression.



;[o]
-Graphics3D-
:[font = input; startGroup; nowordwrap; ]

Show[%,ViewPoint->{-0.120,-1.153,3.179}]
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 277; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.07771 
MathPictureStart
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0784552 1.10743 -0.057406 1.10743 [
[ 0 0 0 0 ]
[ 1 1.07771 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
0 0 m
1 0 L
1 1.07771 L
0 1.07771 L
closepath
clip
newpath
p
.002  w
.17139  .02769  m
.06667  .18034  L
s
.06667  .18034  m
.02769  .97715  L
s
.02769  .97715  m
.13265  .65062  L
s
.13265  .65062  m
.17139  .02769  L
s
.84613  .09787  m
.75084  .70942  L
s
.75084  .70942  m
.8343  1.05002 L
s
.8343  1.05002 m
.97231  .27244  L
s
.97231  .27244  m
.84613  .09787  L
s
.17139  .02769  m
.06667  .18034  L
s
.06667  .18034  m
.97231  .27244  L
s
.97231  .27244  m
.84613  .09787  L
s
.84613  .09787  m
.17139  .02769  L
s
.13265  .65062  m
.75084  .70942  L
s
.75084  .70942  m
.8343  1.05002 L
s
.8343  1.05002 m
.02769  .97715  L
s
.02769  .97715  m
.13265  .65062  L
s
P
p
.46932  .42238  m .47167  .44925  L .48047  .36886  L .985  .793  .393  r
F
P
p
.4731  .46549  m .47406  .47647  L .47966  .45012  L .985  .793  .393  r
F
P
p
.47406  .47647  m .47886  .53114  L .4795  .4666  L .985  .793  .393  r
F
P
p
.47406  .47647  m .4795  .4666  L .47966  .45012  L .985  .793  .393  r
F
P
p
.47406  .47647  m .47869  .53305  L .47886  .53114  L .985  .793  .393  r
F
P
p
.46637  .46663  m .46832  .47716  L .46747  .46311  L .975  .735  .315  r
F
P
p
.46832  .47716  m .47292  .46638  L .47152  .45019  L .975  .735  .315  r
F
P
p
.46747  .46311  m .47152  .45019  L .45541  .26393  L .975  .735  .315  r
F
P
p
.46832  .47716  m .47152  .45019  L .46747  .46311  L .975  .735  .315  r
F
P
p
.51239  .31968  m .51032  .3264  L .5183  .30086  L 0 0 .098  r
F
P
p
.47167  .44925  m .47292  .46638  L .4731  .46549  L .985  .793  .393  r
F
P
p
.42973  .26907  m .46637  .46663  L .45541  .26393  L .975  .735  .315  r
F
P
p
.46637  .46663  m .46747  .46311  L .45541  .26393  L .975  .735  .315  r
F
P
p
.46832  .47716  m .4784  .53583  L .47869  .53305  L .975  .735  .315  r
F
P
p
.46637  .46663  m .46827  .47754  L .46832  .47716  L .975  .735  .315  r
F
P
p
.46827  .47754  m .4784  .53583  L .46832  .47716  L .975  .735  .315  r
F
P
p
.45975  .47026  m .46256  .48012  L .4633  .45307  L .974  .692  .29  r
F
P
p
.53058  .33099  m .52231  .35102  L .53758  .31459  L 0 0 .103  r
F
P
p
.46458  .48723  m .4784  .53583  L .46805  .47906  L .974  .692  .29  r
F
P
p
.46631  .46714  m .46821  .47793  L .46637  .46663  L .975  .735  .315  r
F
P
p
.46821  .47793  m .4784  .53583  L .46827  .47754  L .975  .735  .315  r
F
P
p
.46821  .47793  m .46827  .47754  L .46637  .46663  L .975  .735  .315  r
F
P
p
.45879  .4638  m .4623  .44758  L .45858  .4272  L .974  .692  .29  r
F
P
p
.45558  .45559  m .45659  .45935  L .45841  .46554  L .974  .692  .29  r
F
P
p
.45608  .47935  m .45433  .48969  L .45726  .48226  L 0 0 .132  r
F
P
p
.45433  .48969  m .44801  .52703  L .45533  .49159  L 0 0 .132  r
F
P
p
.45433  .48969  m .45533  .49159  L .45726  .48226  L 0 0 .132  r
F
P
p
.45558  .45594  m .45083  .50054  L .45841  .46554  L 0 0 .132  r
F
P
p
.45083  .50054  m .44801  .52703  L .45841  .46554  L 0 0 .132  r
F
P
p
.45238  .48591  m .44777  .52737  L .45083  .50054  L 0 0 .132  r
F
P
p
.45962  .49174  m .46146  .49708  L .4615  .49662  L .966  .648  .269  r
F
P
p
.45954  .4929  m .46136  .49806  L .45962  .49174  L .966  .648  .269  r
F
P
p
.46136  .49806  m .47738  .54338  L .46146  .49708  L .966  .648  .269  r
F
P
p
.46136  .49806  m .46146  .49708  L .45962  .49174  L .966  .648  .269  r
F
P
p
.4615  .49662  m .46791  .51548  L .47799  .53934  L .966  .648  .269  r
F
P
p
.46146  .49708  m .47738  .54338  L .4615  .49662  L .966  .648  .269  r
F
P
p
.46129  .49881  m .45899  .50437  L .46129  .49886  L 0 0 .103  r
F
P
p
.45945  .49418  m .4489  .52882  L .46129  .49881  L 0 0 .098  r
F
P
p
.45899  .50437  m .45899  .50445  L .46128  .49892  L 0 0 .103  r
F
P
p
.45899  .50437  m .46128  .49892  L .46129  .49886  L 0 0 .103  r
F
P
p
.45945  .49418  m .45736  .50047  L .45733  .50115  L 0 0 .098  r
F
P
p
.45954  .49282  m .44837  .52756  L .45945  .49418  L 0 0 .098  r
F
P
p
.46237  .48221  m .45967  .49094  L .46128  .48636  L 0 0 .098  r
F
P
p
.45962  .49174  m .47799  .53934  L .46229  .48309  L .966  .648  .269  r
F
P
p
.46229  .48309  m .46128  .48636  L .46224  .48361  L 0 0 .098  r
F
P
p
.46237  .48221  m .46128  .48636  L .46229  .48309  L 0 0 .098  r
F
P
p
.45967  .49094  m .44837  .52756  L .45954  .49282  L 0 0 .098  r
F
P
p
.45371  .47335  m .45235  .48527  L .45238  .48591  L 0 0 .132  r
F
P
p
.45558  .45559  m .4537  .47292  L .45371  .47335  L 0 0 .132  r
F
P
p
.4537  .47292  m .45235  .48527  L .45371  .47335  L 0 0 .132  r
F
P
p
.45841  .46554  m .45608  .47935  L .45976  .47012  L 0 0 .132  r
F
P
p
.45608  .47935  m .45726  .48226  L .45976  .47012  L 0 0 .132  r
F
P
p
.45558  .45501  m .45369  .47254  L .45558  .45559  L 0 0 .132  r
F
P
p
.45369  .47254  m .44777  .52737  L .4537  .47292  L 0 0 .132  r
F
P
p
.45369  .47254  m .4537  .47292  L .45558  .45559  L 0 0 .132  r
F
P
p
.4586  .42645  m .45234  .48482  L .45858  .4272  L 0 0 .132  r
F
P
p
.45234  .48482  m .44777  .52737  L .45234  .48501  L 0 0 .132  r
F
P
p
.45234  .48482  m .45234  .48501  L .45858  .4272  L 0 0 .132  r
F
P
p
.45235  .48527  m .44777  .52737  L .45238  .48591  L 0 0 .132  r
F
P
p
.45968  .49091  m .45748  .49804  L .45968  .49092  L 0 0 .098  r
F
P
p
.45962  .47258  m .44837  .52756  L .46238  .48206  L 0 0 .096  r
F
P
p
.45748  .49804  m .45748  .49806  L .46237  .48221  L 0 0 .098  r
F
P
p
.46238  .48206  m .46314  .48466  L .46245  .48128  L .974  .692  .29  r
F
P
p
.46229  .48309  m .46314  .48466  L .46238  .48206  L .974  .692  .29  r
F
P
p
.46424  .49009  m .46442  .48862  L .46245  .48128  L .974  .692  .29  r
F
P
p
.46458  .48723  m .47799  .53934  L .4784  .53583  L .974  .692  .29  r
F
P
p
.46453  .48768  m .47799  .53934  L .46458  .48723  L .974  .692  .29  r
F
P
p
.46249  .48091  m .47799  .53934  L .46256  .48012  L .974  .692  .29  r
F
P
p
.46424  .49009  m .47799  .53934  L .46442  .48862  L .974  .692  .29  r
F
P
p
.4633  .45307  m .46614  .46862  L .46553  .4646  L .975  .735  .315  r
F
P
p
.46331  .45292  m .46553  .4646  L .46347  .45097  L .975  .735  .315  r
F
P
p
.4633  .45307  m .46553  .4646  L .46331  .45292  L .975  .735  .315  r
F
P
p
.46614  .46862  m .46631  .46714  L .46347  .45097  L .975  .735  .315  r
F
P
p
.46256  .48012  m .46614  .46862  L .4633  .45307  L .974  .692  .29  r
F
P
p
.46347  .45097  m .46631  .46714  L .46637  .46663  L .975  .735  .315  r
F
P
p
.46894  .4257  m .45976  .47013  L .46858  .42884  L 0 0 .096  r
F
P
p
.46122  .49954  m .47738  .54338  L .46136  .49806  L .966  .648  .269  r
F
P
p
.46397  .49243  m .46128  .49892  L .46363  .49522  L 0 0 .103  r
F
P
p
.45889  .50576  m .46017  .5088  L .46021  .50843  L .951  .6  .244  r
F
P
p
.46114  .50035  m .46255  .50407  L .46122  .49954  L .966  .648  .269  r
F
P
p
.46255  .50407  m .47738  .54338  L .46263  .50336  L .966  .648  .269  r
F
P
p
.46255  .50407  m .46263  .50336  L .46122  .49954  L .966  .648  .269  r
F
P
p
.46245  .48128  m .47799  .53934  L .46249  .48091  L .974  .692  .29  r
F
P
p
.46614  .46862  m .4784  .53583  L .46631  .46714  L .975  .735  .315  r
F
P
p
.46832  .47716  m .47869  .53305  L .47292  .46638  L .975  .735  .315  r
F
P
p
.46128  .49892  m .4489  .52882  L .45675  .51092  L 0 0 .103  r
F
P
p
.46128  .49892  m .45894  .50512  L .46114  .50035  L 0 0 .103  r
F
P
p
.45894  .50512  m .45675  .51092  L .45889  .50576  L 0 0 .103  r
F
P
p
.45894  .50512  m .45889  .50576  L .46114  .50035  L 0 0 .103  r
F
P
p
.45889  .50576  m .46021  .50843  L .46114  .50035  L .951  .6  .244  r
F
P
p
.46021  .50843  m .47738  .54338  L .46255  .50407  L .951  .6  .244  r
F
P
p
.46021  .50843  m .46255  .50407  L .46114  .50035  L .951  .6  .244  r
F
P
p
.55096  .33691  m .50198  .43062  L .55798  .32418  L 0 0 .105  r
F
P
p
.45879  .50714  m .46005  .51002  L .45886  .50621  L .951  .6  .244  r
F
P
p
.46005  .51002  m .47649  .54768  L .46013  .50919  L .951  .6  .244  r
F
P
p
.46005  .51002  m .46013  .50919  L .45886  .50621  L .951  .6  .244  r
F
P
p
.46021  .50843  m .46694  .52467  L .47738  .54338  L .951  .6  .244  r
F
P
p
.46017  .5088  m .47649  .54768  L .46021  .50843  L .951  .6  .244  r
F
P
p
.45886  .50621  m .46013  .50919  L .45889  .50576  L .951  .6  .244  r
F
P
p
.46013  .50919  m .47649  .54768  L .46017  .5088  L .951  .6  .244  r
F
P
p
.46013  .50919  m .46017  .5088  L .45889  .50576  L .951  .6  .244  r
F
P
p
.45629  .52589  m .47516  .55191  L .45819  .52301  L .901  .487  .167  r
F
P
p
.45836  .52111  m .45637  .52422  L .45785  .52682  L 0 0 .099  r
F
P
p
.45451  .5341  m .47022  .55886  L .47316  .55575  L .865  .418  .11  r
F
P
p
.45451  .53416  m .47022  .55886  L .45451  .5341  L .865  .418  .11  r
F
P
p
.45454  .5326  m .45288  .53476  L .45361  .53521  L 0 0 .083  r
F
P
p
.45451  .5341  m .45361  .53521  L .45447  .53576  L 0 0 .083  r
F
P
p
.45454  .5326  m .45361  .53521  L .45451  .5341  L 0 0 .083  r
F
P
p
.45433  .52741  m .45096  .53268  L .45434  .5298  L 0 0 .099  r
F
P
p
.45675  .52653  m .46443  .54021  L .47516  .55191  L .901  .487  .167  r
F
P
p
.45674  .52669  m .47316  .55575  L .45675  .52653  L .901  .487  .167  r
F
P
p
.45611  .5296  m .45436  .5324  L .45647  .53007  L 0 0 .099  r
F
P
p
.45436  .5324  m .45288  .53476  L .45454  .5326  L 0 0 .099  r
F
P
p
.45436  .5324  m .45454  .5326  L .45647  .53007  L 0 0 .099  r
F
P
p
.45436  .5324  m .45291  .53102  L .45288  .53476  L 0 0 .099  r
F
P
p
.45451  .5341  m .47316  .55575  L .45633  .53184  L .865  .418  .11  r
F
P
p
.45647  .53007  m .45454  .5326  L .45599  .53627  L 0 0 .083  r
F
P
p
.45602  .53139  m .47316  .55575  L .45629  .52589  L .901  .487  .167  r
F
P
p
.45611  .5296  m .45434  .5298  L .45436  .5324  L 0 0 .099  r
F
P
p
.45785  .52682  m .45617  .52825  L .45611  .5296  L 0 0 .099  r
F
P
p
.45617  .52825  m .45434  .5298  L .45611  .5296  L 0 0 .099  r
F
P
p
.45434  .5298  m .45291  .53102  L .45436  .5324  L 0 0 .099  r
F
P
p
.45291  .53102  m .45096  .53268  L .45146  .53322  L 0 0 .099  r
F
P
p
.45291  .53102  m .45146  .53322  L .45288  .53476  L 0 0 .099  r
F
P
p
.45779  .51617  m .44971  .53061  L .45693  .5182  L 0 0 .105  r
F
P
p
.45787  .51506  m .44971  .53061  L .45779  .51617  L 0 0 .105  r
F
P
p
.45996  .511  m .44971  .53061  L .45995  .51108  L 0 0 .105  r
F
P
p
.45869  .50852  m .44971  .53061  L .45996  .511  L 0 0 .103  r
F
P
p
.45776  .51664  m .45861  .51836  L .45863  .51808  L .93  .547  .211  r
F
P
p
.45755  .51984  m .45096  .53268  L .45836  .52111  L 0 0 .105  r
F
P
p
.45743  .52171  m .47516  .55191  L .46543  .53218  L .93  .547  .211  r
F
P
p
.45755  .51984  m .46543  .53218  L .45776  .51664  L .93  .547  .211  r
F
P
p
.45743  .52171  m .46543  .53218  L .45755  .51984  L .93  .547  .211  r
F
P
p
.45863  .51808  m .47516  .55191  L .47649  .54768  L .93  .547  .211  r
F
P
p
.45861  .51836  m .47516  .55191  L .45863  .51808  L .93  .547  .211  r
F
P
p
.45776  .51664  m .47649  .54768  L .45979  .51283  L .93  .547  .211  r
F
P
p
.45995  .51108  m .45787  .51506  L .45779  .51617  L 0 0 .105  r
F
P
p
.45995  .51108  m .45693  .5182  L .45979  .51283  L 0 0 .105  r
F
P
p
.46114  .50035  m .45889  .50576  L .46107  .50106  L 0 0 .103  r
F
P
p
.45889  .50576  m .45675  .51092  L .45887  .50608  L 0 0 .103  r
F
P
p
.45889  .50576  m .45887  .50608  L .46107  .50106  L 0 0 .103  r
F
P
p
.45726  .48227  m .44801  .52703  L .45723  .48304  L 0 0 .096  r
F
P
p
.46363  .49522  m .45887  .50608  L .46355  .49595  L 0 0 .103  r
F
P
p
.45887  .50608  m .4489  .52882  L .45884  .50651  L 0 0 .103  r
F
P
p
.45887  .50608  m .45884  .50651  L .46355  .49595  L 0 0 .103  r
F
P
p
.45861  .50977  m .47649  .54768  L .45879  .50714  L .951  .6  .244  r
F
P
p
.46087  .50317  m .4489  .52882  L .44971  .53061  L 0 0 .103  r
F
P
p
.46102  .50162  m .4489  .52882  L .46087  .50317  L 0 0 .103  r
F
P
p
.45899  .50437  m .4489  .52882  L .45899  .50445  L 0 0 .103  r
F
P
p
.45704  .50709  m .45857  .51028  L .45706  .5065  L .951  .6  .244  r
F
P
p
.45857  .51028  m .47649  .54768  L .45861  .50977  L .951  .6  .244  r
F
P
p
.45857  .51028  m .45861  .50977  L .45706  .5065  L .951  .6  .244  r
F
P
p
.45748  .49804  m .44837  .52756  L .45748  .49806  L 0 0 .098  r
F
P
p
.45733  .50115  m .44837  .52756  L .4489  .52882  L 0 0 .098  r
F
P
p
.45736  .50047  m .44837  .52756  L .45733  .50115  L 0 0 .098  r
F
P
p
.45529  .49377  m .44914  .52171  L .44837  .52756  L 0 0 .096  r
F
P
p
.45971  .47103  m .46245  .48128  L .45973  .47068  L .974  .692  .29  r
F
P
p
.46245  .48128  m .46249  .48091  L .45974  .47054  L .974  .692  .29  r
F
P
p
.45976  .47013  m .45726  .48227  L .4597  .47123  L 0 0 .096  r
F
P
p
.45975  .47026  m .46249  .48091  L .46256  .48012  L .974  .692  .29  r
F
P
p
.45976  .47012  m .45726  .48226  L .45976  .47013  L 0 0 .096  r
F
P
p
.45726  .48226  m .45533  .49159  L .45726  .48226  L 0 0 .096  r
F
P
p
.45726  .48226  m .45726  .48226  L .45976  .47013  L 0 0 .096  r
F
P
p
.45748  .49804  m .46237  .48221  L .46237  .48219  L 0 0 .098  r
F
P
p
.46256  .48012  m .46453  .48768  L .46458  .48723  L .974  .692  .29  r
F
P
p
.46256  .48012  m .46458  .48723  L .46614  .46862  L .974  .692  .29  r
F
P
p
.46591  .4706  m .45968  .49083  L .46589  .47075  L 0 0 .098  r
F
P
p
.45968  .49083  m .44837  .52756  L .45968  .49091  L 0 0 .098  r
F
P
p
.45968  .49083  m .45968  .49091  L .46589  .47075  L 0 0 .098  r
F
P
p
.46122  .49954  m .46136  .49806  L .45954  .4929  L .966  .648  .269  r
F
P
p
.45968  .49091  m .45748  .49803  L .45968  .49091  L 0 0 .098  r
F
P
p
.46458  .48723  m .46805  .47906  L .46614  .46862  L .974  .692  .29  r
F
P
p
.47152  .45019  m .47292  .46638  L .47167  .44925  L .985  .793  .393  r
F
P
p
.47167  .44925  m .4731  .46549  L .47993  .42296  L .985  .793  .393  r
F
P
p
.4731  .46549  m .47966  .45012  L .47993  .42296  L .985  .793  .393  r
F
P
p
.45748  .49803  m .45748  .49804  L .51759  .30318  L 0 0 .098  r
F
P
p
.45945  .4941  m .45711  .48605  L .45709  .4868  L .966  .648  .269  r
F
P
p
.46122  .49954  m .45947  .4938  L .45945  .4941  L .966  .648  .269  r
F
P
p
.45947  .4938  m .45711  .48605  L .45945  .4941  L .966  .648  .269  r
F
P
p
.517  .30509  m .45968  .49091  L .51759  .30318  L 0 0 .098  r
F
P
p
.45968  .49091  m .45968  .49091  L .51759  .30318  L 0 0 .098  r
F
P
p
.45748  .49803  m .44837  .52756  L .45748  .49804  L 0 0 .098  r
F
P
p
.45861  .50977  m .45879  .50714  L .45721  .50351  L .951  .6  .244  r
F
P
p
.45713  .50508  m .45721  .50351  L .45519  .49887  L .951  .6  .244  r
F
P
p
.45861  .50977  m .45721  .50351  L .45713  .50508  L .951  .6  .244  r
F
P
p
.45947  .4938  m .45954  .4929  L .45711  .48605  L .966  .648  .269  r
F
P
p
.46122  .49954  m .45954  .4929  L .45947  .4938  L .966  .648  .269  r
F
P
p
.45714  .48532  m .45954  .4929  L .45962  .49174  L .966  .648  .269  r
F
P
p
.45533  .49159  m .45533  .4916  L .45976  .47013  L 0 0 .096  r
F
P
p
.46932  .42238  m .47152  .45019  L .47167  .44925  L .985  .793  .393  r
F
P
p
.4692  .42337  m .47152  .45019  L .46932  .42238  L .985  .793  .393  r
F
P
p
.47167  .44925  m .47993  .42296  L .48047  .36886  L .985  .793  .393  r
F
P
p
.45976  .47013  m .45976  .47013  L .50191  .26604  L 0 0 .096  r
F
P
p
.45533  .49159  m .45976  .47013  L .45976  .47013  L 0 0 .096  r
F
P
p
.45968  .49091  m .45968  .49092  L .46237  .48219  L 0 0 .098  r
F
P
p
.45968  .49091  m .46237  .48219  L .46237  .48218  L 0 0 .098  r
F
P
p
.46237  .48217  m .45968  .49091  L .46237  .48218  L 0 0 .098  r
F
P
p
.45962  .47262  m .46229  .48309  L .46026  .47475  L .974  .692  .29  r
F
P
p
.45717  .48458  m .45531  .49247  L .45529  .49377  L 0 0 .096  r
F
P
p
.45962  .47258  m .4572  .48377  L .45717  .48458  L 0 0 .096  r
F
P
p
.4572  .48377  m .45531  .49247  L .45717  .48458  L 0 0 .096  r
F
P
p
.45966  .47187  m .45721  .48349  L .45962  .47258  L 0 0 .096  r
F
P
p
.45721  .48349  m .45531  .49247  L .4572  .48377  L 0 0 .096  r
F
P
p
.45721  .48349  m .4572  .48377  L .45962  .47258  L 0 0 .096  r
F
P
p
.45942  .49464  m .45945  .4941  L .45709  .4868  L .966  .648  .269  r
F
P
p
.45974  .47054  m .46249  .48091  L .45975  .47026  L .974  .692  .29  r
F
P
p
.46245  .48128  m .45974  .47054  L .45973  .47068  L .974  .692  .29  r
F
P
p
.4597  .47123  m .44801  .52703  L .45966  .47187  L 0 0 .096  r
F
P
p
.45726  .48227  m .45723  .48304  L .4597  .47123  L 0 0 .096  r
F
P
p
.46229  .48309  m .46245  .48128  L .45558  .45559  L .974  .692  .29  r
F
P
p
.46318  .4546  m .4597  .47123  L .46311  .45556  L 0 0 .096  r
F
P
p
.4597  .47123  m .45966  .47187  L .46311  .45556  L 0 0 .096  r
F
P
p
.45559  .45871  m .45962  .47258  L .45558  .45559  L .974  .692  .29  r
F
P
p
.45962  .47258  m .46026  .47475  L .45964  .47224  L .974  .692  .29  r
F
P
p
.45962  .47258  m .45964  .47224  L .45558  .45559  L .974  .692  .29  r
F
P
p
.45707  .48715  m .45709  .4868  L .45377  .47659  L .966  .648  .269  r
F
P
p
.45942  .49464  m .45709  .4868  L .45707  .48715  L .966  .648  .269  r
F
P
p
.45383  .47948  m .45703  .48818  L .45377  .47659  L .966  .648  .269  r
F
P
p
.45703  .48818  m .45942  .49464  L .45707  .48715  L .966  .648  .269  r
F
P
p
.45703  .48818  m .45707  .48715  L .45377  .47659  L .966  .648  .269  r
F
P
p
.45559  .45907  m .45958  .47338  L .45962  .47262  L .974  .692  .29  r
F
P
p
.45958  .47338  m .46229  .48309  L .45962  .47262  L .974  .692  .29  r
F
P
p
.45377  .47659  m .45711  .48605  L .45714  .48532  L .966  .648  .269  r
F
P
p
.45711  .48605  m .45954  .4929  L .45714  .48532  L .966  .648  .269  r
F
P
p
.45841  .46554  m .45974  .47054  L .45975  .47026  L .974  .692  .29  r
F
P
p
.50114  .26971  m .45976  .47012  L .50191  .26604  L 0 0 .096  r
F
P
p
.45976  .47012  m .45976  .47013  L .50191  .26604  L 0 0 .096  r
F
P
p
.45533  .49159  m .44801  .52703  L .45533  .4916  L 0 0 .096  r
F
P
p
.45531  .49247  m .44914  .52171  L .45529  .49377  L 0 0 .096  r
F
P
p
.45516  .50011  m .45519  .49887  L .45264  .49305  L .951  .6  .244  r
F
P
p
.45861  .50977  m .45519  .49887  L .45516  .50011  L .951  .6  .244  r
F
P
p
.45973  .47068  m .45974  .47054  L .45841  .46554  L .974  .692  .29  r
F
P
p
.46311  .45556  m .45966  .47187  L .45962  .47258  L 0 0 .096  r
F
P
p
.45281  .49749  m .45512  .50238  L .45264  .49305  L .951  .6  .244  r
F
P
p
.45512  .50238  m .45861  .50977  L .45516  .50011  L .951  .6  .244  r
F
P
p
.45512  .50238  m .45516  .50011  L .45264  .49305  L .951  .6  .244  r
F
P
p
.47387  .4773  m .47869  .53305  L .47406  .47647  L .985  .793  .393  r
F
P
p
.57753  .28608  m .45948  .51609  L .60025  .29929  L 0 0 .105  r
F
P
p
.45948  .51609  m .45755  .51984  L .45969  .51652  L 0 0 .105  r
F
P
p
.45948  .51609  m .45969  .51652  L .60025  .29929  L 0 0 .105  r
F
P
p
.45755  .51984  m .45836  .52111  L .60025  .29929  L 0 0 .105  r
F
P
p
.45948  .51609  m .44971  .53061  L .45096  .53268  L 0 0 .105  r
F
P
p
.45973  .51339  m .44971  .53061  L .45948  .51609  L 0 0 .105  r
F
P
p
.45083  .50054  m .44777  .52737  L .44801  .52703  L 0 0 .132  r
F
P
p
.44914  .52171  m .44801  .52703  L .44803  .52706  L 0 0 .096  r
F
P
p
.44914  .52171  m .44803  .52706  L .44837  .52756  L 0 0 .096  r
F
P
p
.4418  .51934  m .45439  .53988  L .45436  .53393  L .865  .418  .11  r
F
P
p
.29853  .35299  m .40755  .48372  L .4418  .51934  L .865  .418  .11  r
F
P
p
.40755  .48372  m .45439  .53988  L .4418  .51934  L .865  .418  .11  r
F
P
p
.60025  .29929  m .45611  .5296  L .62147  .31486  L 0 0 .099  r
F
P
p
.45611  .5296  m .45647  .53007  L .62147  .31486  L 0 0 .099  r
F
P
p
.46443  .54021  m .47316  .55575  L .47454  .55309  L .901  .487  .167  r
F
P
p
.46443  .54021  m .47454  .55309  L .47516  .55191  L .901  .487  .167  r
F
P
p
.45629  .52589  m .45674  .52669  L .45675  .52653  L .901  .487  .167  r
F
P
p
.45439  .53988  m .45439  .53988  L .45436  .53393  L .865  .418  .11  r
F
P
p
.45439  .53988  m .47022  .55886  L .45451  .53416  L .865  .418  .11  r
F
P
p
.45439  .53988  m .45451  .53416  L .45436  .53393  L .865  .418  .11  r
F
P
p
.45599  .53627  m .45454  .5326  L .45576  .53658  L 0 0 .083  r
F
P
p
.46791  .51548  m .47738  .54338  L .47782  .54045  L .966  .648  .269  r
F
P
p
.46791  .51548  m .47782  .54045  L .47799  .53934  L .966  .648  .269  r
F
P
p
.62147  .31486  m .45647  .53007  L .45599  .53627  L 0 0 .083  r
F
P
p
.29853  .35299  m .45451  .5341  L .31669  .33336  L .865  .418  .11  r
F
P
p
.45454  .5326  m .45447  .53576  L .45576  .53658  L 0 0 .083  r
F
P
p
.45433  .52741  m .45434  .5298  L .45617  .52825  L 0 0 .099  r
F
P
p
.45451  .5341  m .45633  .53184  L .31669  .33336  L .865  .418  .11  r
F
P
p
.45436  .53393  m .45451  .53416  L .45451  .5341  L .865  .418  .11  r
F
P
p
.45637  .52422  m .45433  .52741  L .45617  .52825  L 0 0 .099  r
F
P
p
.45637  .52422  m .45617  .52825  L .45785  .52682  L 0 0 .099  r
F
P
p
.31669  .33336  m .45602  .53139  L .45629  .52589  L .901  .487  .167  r
F
P
p
.31669  .33336  m .45629  .52589  L .33654  .31577  L .901  .487  .167  r
F
P
p
.45629  .52589  m .45819  .52301  L .33654  .31577  L .901  .487  .167  r
F
P
p
.60025  .29929  m .45836  .52111  L .45785  .52682  L 0 0 .099  r
F
P
p
.45979  .51283  m .45693  .5182  L .45973  .51339  L 0 0 .105  r
F
P
p
.33654  .31577  m .45743  .52171  L .45776  .51664  L .93  .547  .211  r
F
P
p
.33654  .31577  m .45776  .51664  L .35795  .3004  L .93  .547  .211  r
F
P
p
.45858  .4272  m .45558  .45501  L .45558  .45559  L 0 0 .132  r
F
P
p
.40476  .27693  m .45841  .46554  L .42973  .26907  L .974  .692  .29  r
F
P
p
.45841  .46554  m .45879  .4638  L .42973  .26907  L .974  .692  .29  r
F
P
p
.45879  .4638  m .45858  .4272  L .4564  .44781  L .974  .692  .29  r
F
P
p
.45857  .42791  m .45558  .45594  L .46331  .45292  L 0 0 .132  r
F
P
p
.45558  .45594  m .45976  .47012  L .46331  .45292  L 0 0 .132  r
F
P
p
.45863  .42489  m .4633  .45307  L .46347  .45097  L .975  .735  .315  r
F
P
p
.45858  .4272  m .4633  .45307  L .45863  .42489  L .975  .735  .315  r
F
P
p
.46432  .37386  m .46291  .38624  L .45083  .50054  L 0 0 .132  r
F
P
p
.4646  .36859  m .4692  .42337  L .46932  .42238  L .985  .793  .393  r
F
P
p
.46455  .36954  m .4692  .42337  L .4646  .36859  L .985  .793  .393  r
F
P
p
.45541  .26393  m .46932  .42238  L .48154  .26155  L .985  .793  .393  r
F
P
p
.46829  .33663  m .46439  .3726  L .46432  .37386  L 0 0 .132  r
F
P
p
.46439  .3726  m .46291  .38624  L .46432  .37386  L 0 0 .132  r
F
P
p
.45541  .26393  m .46455  .36954  L .4646  .36859  L .985  .793  .393  r
F
P
p
.45776  .51664  m .45979  .51283  L .35795  .3004  L .93  .547  .211  r
F
P
p
.46222  .50675  m .45995  .51108  L .46186  .50973  L 0 0 .105  r
F
P
p
.45995  .51108  m .45973  .51339  L .46186  .50973  L 0 0 .105  r
F
P
p
.50198  .43062  m .45996  .511  L .50956  .4165  L 0 0 .105  r
F
P
p
.45996  .511  m .45995  .51108  L .50956  .4165  L 0 0 .105  r
F
P
p
.50198  .43062  m .50956  .4165  L .55798  .32418  L 0 0 .105  r
F
P
p
.45721  .50351  m .45879  .50714  L .45726  .50244  L .951  .6  .244  r
F
P
p
.45879  .50714  m .45886  .50621  L .45726  .50244  L .951  .6  .244  r
F
P
p
.35795  .3004  m .45889  .50576  L .38076  .2874  L .951  .6  .244  r
F
P
p
.45889  .50576  m .46114  .50035  L .38076  .2874  L .951  .6  .244  r
F
P
p
.47082  .49036  m .46222  .50675  L .46927  .49701  L 0 0 .105  r
F
P
p
.46222  .50675  m .46186  .50973  L .46927  .49701  L 0 0 .105  r
F
P
p
.4731  .46549  m .47387  .4773  L .47406  .47647  L .985  .793  .393  r
F
P
p
.47292  .46638  m .47387  .4773  L .4731  .46549  L .985  .793  .393  r
F
P
p
.55354  .27537  m .45869  .50852  L .57753  .28608  L 0 0 .103  r
F
P
p
.45869  .50852  m .45996  .511  L .57753  .28608  L 0 0 .103  r
F
P
p
.46694  .52467  m .47649  .54768  L .47713  .5446  L .951  .6  .244  r
F
P
p
.46694  .52467  m .47713  .5446  L .47738  .54338  L .951  .6  .244  r
F
P
p
.46927  .49701  m .45973  .51339  L .45948  .51609  L 0 0 .105  r
F
P
p
.46128  .49892  m .46107  .50106  L .46363  .49522  L 0 0 .103  r
F
P
p
.45935  .4956  m .46114  .50035  L .45942  .49464  L .966  .648  .269  r
F
P
p
.46114  .50035  m .46122  .49954  L .45942  .49464  L .966  .648  .269  r
F
P
p
.45709  .4868  m .45711  .48605  L .45377  .47659  L .966  .648  .269  r
F
P
p
.45976  .47013  m .4597  .47123  L .46858  .42884  L 0 0 .096  r
F
P
p
.45659  .45935  m .45971  .47103  L .45841  .46554  L .974  .692  .29  r
F
P
p
.45971  .47103  m .45973  .47068  L .45841  .46554  L .974  .692  .29  r
F
P
p
.46237  .48218  m .46237  .48219  L .51447  .31344  L 0 0 .098  r
F
P
p
.47124  .47485  m .46397  .49243  L .47015  .48036  L 0 0 .103  r
F
P
p
.46397  .49243  m .46363  .49522  L .47015  .48036  L 0 0 .103  r
F
P
p
.51003  .32769  m .46237  .48217  L .51447  .31344  L 0 0 .098  r
F
P
p
.46237  .48217  m .46237  .48218  L .51447  .31344  L 0 0 .098  r
F
P
p
.46237  .48219  m .46237  .48221  L .51447  .31344  L 0 0 .098  r
F
P
p
.45559  .45907  m .46026  .47475  L .45559  .45871  L .974  .692  .29  r
F
P
p
.50276  .26187  m .45962  .47258  L .52853  .26727  L 0 0 .096  r
F
P
p
.45962  .47258  m .46238  .48206  L .52853  .26727  L 0 0 .096  r
F
P
p
.46229  .48309  m .46424  .49009  L .46314  .48466  L .974  .692  .29  r
F
P
p
.46671  .48821  m .46363  .49522  L .46657  .48916  L 0 0 .103  r
F
P
p
.46363  .49522  m .46355  .49595  L .46657  .48916  L 0 0 .103  r
F
P
p
.45386  .48106  m .45935  .4956  L .45383  .47948  L .966  .648  .269  r
F
P
p
.45935  .4956  m .45942  .49464  L .45383  .47948  L .966  .648  .269  r
F
P
p
.45284  .49834  m .45704  .50709  L .45281  .49749  L .951  .6  .244  r
F
P
p
.45704  .50709  m .45706  .5065  L .45281  .49749  L .951  .6  .244  r
F
P
p
.47653  .25921  m .47001  .32006  L .46829  .33663  L 0 0 .132  r
F
P
p
.47001  .32006  m .46291  .38624  L .46829  .33663  L 0 0 .132  r
F
P
p
.38076  .2874  m .45377  .47659  L .40476  .27693  L .966  .648  .269  r
F
P
p
.45377  .47659  m .45962  .49174  L .45434  .47108  L .966  .648  .269  r
F
P
p
.45377  .47659  m .45434  .47108  L .40476  .27693  L .966  .648  .269  r
F
P
p
.39171  .37081  m .45284  .49834  L .40449  .39508  L .951  .6  .244  r
F
P
p
.45284  .49834  m .45281  .49749  L .40449  .39508  L .951  .6  .244  r
F
P
p
.41555  .37958  m .45386  .48106  L .4312  .4181  L .966  .648  .269  r
F
P
p
.45386  .48106  m .45383  .47948  L .4312  .4181  L .966  .648  .269  r
F
P
p
.45967  .49094  m .45954  .49282  L .46547  .47438  L 0 0 .098  r
F
P
p
.45962  .49174  m .46229  .48309  L .40476  .27693  L .966  .648  .269  r
F
P
p
.46589  .47082  m .46237  .48221  L .46547  .47438  L 0 0 .098  r
F
P
p
.46237  .48221  m .46224  .48361  L .46547  .47438  L 0 0 .098  r
F
P
p
.45942  .49464  m .46122  .49954  L .45945  .4941  L .966  .648  .269  r
F
P
p
.46129  .49886  m .46128  .49892  L .46725  .48449  L 0 0 .103  r
F
P
p
.46728  .4843  m .46129  .49881  L .46725  .48449  L 0 0 .103  r
F
P
p
.46129  .49881  m .46129  .49886  L .46725  .48449  L 0 0 .103  r
F
P
p
.52853  .26727  m .45945  .49418  L .55354  .27537  L 0 0 .098  r
F
P
p
.45945  .49418  m .46129  .49881  L .55354  .27537  L 0 0 .098  r
F
P
p
.46657  .48916  m .46102  .50162  L .46087  .50317  L 0 0 .103  r
F
P
p
.45726  .50244  m .45886  .50621  L .45889  .50576  L .951  .6  .244  r
F
P
p
.45264  .49305  m .45721  .50351  L .45726  .50244  L .951  .6  .244  r
F
P
p
.46547  .47438  m .45954  .49282  L .45945  .49418  L 0 0 .098  r
F
P
p
.4312  .4181  m .45383  .47948  L .45377  .47659  L .966  .648  .269  r
F
P
p
.40449  .39508  m .45281  .49749  L .45264  .49305  L .951  .6  .244  r
F
P
p
.35795  .3004  m .39171  .37081  L .40449  .39508  L .951  .6  .244  r
F
P
p
.38076  .2874  m .41555  .37958  L .4312  .4181  L .966  .648  .269  r
F
P
p
.45841  .46554  m .45975  .47026  L .45879  .4638  L .974  .692  .29  r
F
P
p
.40476  .27693  m .45559  .45907  L .45558  .45559  L .974  .692  .29  r
F
P
p
.46291  .38624  m .4586  .42645  L .45858  .4272  L 0 0 .132  r
F
P
p
.42973  .26907  m .45858  .4272  L .45863  .42489  L .975  .735  .315  r
F
P
p
.4564  .44781  m .45858  .4272  L .42973  .26907  L .974  .692  .29  r
F
P
p
.45975  .47026  m .4633  .45307  L .4623  .44758  L .974  .692  .29  r
F
P
p
.45975  .47026  m .4623  .44758  L .45879  .4638  L .974  .692  .29  r
F
P
p
.46932  .42238  m .48047  .36886  L .48154  .26155  L .985  .793  .393  r
F
P
p
.47653  .25921  m .45857  .42791  L .50144  .26685  L 0 0 .132  r
F
P
p
.50252  .26184  m .50144  .26685  L .50276  .26187  L 0 0 .132  r
F
P
p
.47653  .25921  m .50144  .26685  L .50252  .26184  L 0 0 .132  r
F
P
p
.45857  .42791  m .46331  .45292  L .50276  .26187  L 0 0 .132  r
F
P
p
.51447  .31344  m .46589  .47082  L .46547  .47438  L 0 0 .098  r
F
P
p
.52231  .35102  m .46728  .4843  L .53083  .33091  L 0 0 .103  r
F
P
p
.46728  .4843  m .46725  .48449  L .53083  .33091  L 0 0 .103  r
F
P
p
.52231  .35102  m .53083  .33091  L .53758  .31459  L 0 0 .103  r
F
P
p
.51759  .30318  m .51003  .32769  L .51447  .31344  L 0 0 .098  r
F
P
p
.47015  .48036  m .46671  .48821  L .46657  .48916  L 0 0 .103  r
F
P
p
.4708  .45474  m .46591  .4706  L .47076  .45499  L 0 0 .098  r
F
P
p
.46591  .4706  m .46589  .47075  L .47076  .45499  L 0 0 .098  r
F
P
p
.46858  .42884  m .46318  .4546  L .46311  .45556  L 0 0 .096  r
F
P
p
.50191  .26604  m .46894  .4257  L .46858  .42884  L 0 0 .096  r
F
P
p
.51032  .3264  m .4708  .45474  L .517  .30509  L 0 0 .098  r
F
P
p
.4708  .45474  m .47076  .45499  L .517  .30509  L 0 0 .098  r
F
P
p
.51032  .3264  m .517  .30509  L .5183  .30086  L 0 0 .098  r
F
P
p
.5183  .30086  m .517  .30509  L .51759  .30318  L 0 0 .098  r
F
P
p
.5368  .31651  m .47124  .47485  L .47015  .48036  L 0 0 .103  r
F
P
p
.53758  .31459  m .53633  .31763  L .5368  .31651  L 0 0 .103  r
F
P
p
.53633  .31763  m .47124  .47485  L .5368  .31651  L 0 0 .103  r
F
P
p
.55798  .32418  m .47082  .49036  L .46927  .49701  L 0 0 .105  r
F
P
p
.57753  .28608  m .55096  .33691  L .55798  .32418  L 0 0 .105  r
F
P
p
.55354  .27537  m .53058  .33099  L .53758  .31459  L 0 0 .103  r
F
P
p
.52853  .26727  m .51239  .31968  L .5183  .30086  L 0 0 .098  r
F
P
p
.50276  .26187  m .50114  .26971  L .50191  .26604  L 0 0 .096  r
F
P
p
.25  g
.004  w
.47886  .53114  m
.47911  .50533  L
s
P
p
1 0 0 r
.003  w
.47869  .53305  m
.47886  .53114  L
s
P
p
.25  g
.004  w
.45541  .26393  m
.45579  .26829  L
s
P
p
.25  g
.004  w
.45579  .26829  m
.45581  .26852  L
s
P
p
.25  g
.004  w
.47658  .50871  m
.47869  .53305  L
s
P
p
1 0 0 r
.003  w
.4784  .53583  m
.47869  .53305  L
s
P
p
.25  g
.004  w
.46331  .45292  m
.46894  .42567  L
s
P
p
.25  g
.004  w
.50114  .26971  m
.50276  .26187  L
s
P
p
.25  g
.004  w
.47782  .53262  m
.4784  .53583  L
s
P
p
.25  g
.004  w
.42973  .26907  m
.42985  .26974  L
s
P
p
.25  g
.004  w
.42985  .26974  m
.43027  .27202  L
s
P
p
.25  g
.004  w
.43027  .27202  m
.43045  .27301  L
s
P
p
.25  g
.004  w
.4623  .44758  m
.4633  .45307  L
s
P
p
.25  g
.004  w
.47407  .51208  m
.47782  .53262  L
s
P
p
1 0 0 r
.003  w
.47799  .53934  m
.4784  .53583  L
s
P
p
.25  g
.004  w
.46591  .4706  m
.4708  .45474  L
s
P
p
.25  g
.004  w
.46238  .48206  m
.46591  .4706  L
s
P
p
.25  g
.004  w
.47741  .53727  m
.47799  .53934  L
s
P
p
.25  g
.004  w
.47668  .53464  m
.47741  .53727  L
s
P
p
.25  g
.004  w
.45559  .45907  m
.45958  .47338  L
s
P
p
.25  g
.004  w
.45958  .47338  m
.46229  .48309  L
s
P
p
.25  g
.004  w
.47138  .51567  m
.47668  .53464  L
s
P
p
.25  g
.004  w
.40476  .27693  m
.4049  .27742  L
s
P
p
.25  g
.004  w
.4049  .27742  m
.40549  .27954  L
s
P
p
.25  g
.004  w
.40549  .27954  m
.40575  .28047  L
s
P
p
1 0 0 r
.003  w
.47738  .54338  m
.47799  .53934  L
s
P
p
.25  g
.004  w
.46728  .4843  m
.4713  .47457  L
s
P
p
.25  g
.004  w
.46129  .49881  m
.46728  .4843  L
s
P
p
.25  g
.004  w
.4767  .54157  m
.47738  .54338  L
s
P
p
.25  g
.004  w
.47512  .53738  m
.4767  .54157  L
s
P
p
.25  g
.004  w
.45386  .48106  m
.45935  .4956  L
s
P
p
.25  g
.004  w
.45935  .4956  m
.46114  .50035  L
s
P
p
.25  g
.004  w
.46842  .51964  m
.47512  .53738  L
s
P
p
.25  g
.004  w
.38076  .2874  m
.38165  .28976  L
s
P
p
.25  g
.004  w
.38165  .28976  m
.38199  .29065  L
s
P
p
1 0 0 r
.003  w
.47649  .54768  m
.47738  .54338  L
s
P
p
.25  g
.004  w
.57654  .28797  m
.57753  .28608  L
s
P
p
.25  g
.004  w
.35795  .3004  m
.35938  .30338  L
s
P
p
.25  g
.004  w
.45857  .51028  m
.45979  .51283  L
s
P
p
.25  g
.004  w
.46515  .52401  m
.47649  .54768  L
s
P
p
1 0 0 r
.003  w
.47516  .55191  m
.47649  .54768  L
s
P
p
.23528  .47382  m .44272  .5589  L .24426  .44745  L .354  0 0 r
F
P
p
.23528  .47382  m .43044  .55527  L .44272  .5589  L .354  0 0 r
F
P
p
.228  .50076  m .43044  .55527  L .23528  .47382  L 0 .446  .742  r
F
P
p
.24426  .44745  m .4526  .56107  L .25504  .42192  L .533  0 0 r
F
P
p
.24426  .44745  m .44272  .5589  L .4526  .56107  L .533  0 0 r
F
P
p
.006  w
.23528  .47382  m
.24426  .44745  L
s
P
p
.25  g
.004  w
.24426  .44745  m
.24617  .44852  L
s
P
p
.22928  .50111  m .41563  .55035  L .43044  .55527  L 0 .446  .742  r
F
P
p
.22896  .50102  m .22939  .50114  L .22928  .50111  L 0 .446  .742  r
F
P
p
.22939  .50114  m .41563  .55035  L .22928  .50111  L 0 .446  .742  r
F
P
p
.22974  .50122  m .41563  .55035  L .22896  .50102  L 0 .446  .742  r
F
P
p
.228  .50076  m .22974  .50122  L .22896  .50102  L 0 .446  .742  r
F
P
p
.2223  .52801  m .41563  .55035  L .228  .50076  L .106  .618  .892  r
F
P
p
.22349  .52815  m .39834  .54442  L .41563  .55035  L .106  .618  .892  r
F
P
p
.2223  .52801  m .22389  .52816  L .22349  .52815  L .106  .618  .892  r
F
P
p
.22389  .52816  m .39834  .54442  L .22349  .52815  L .106  .618  .892  r
F
P
p
.21803  .5553  m .21886  .55525  L .2223  .52801  L .309  .73  .974  r
F
P
p
.21886  .55525  m .39737  .54448  L .22389  .52816  L .309  .73  .974  r
F
P
p
.21886  .55525  m .22389  .52816  L .2223  .52801  L .309  .73  .974  r
F
P
p
.39737  .54448  m .39647  .54424  L .2223  .52801  L .309  .73  .974  r
F
P
p
.39737  .54448  m .39834  .54442  L .39647  .54424  L .309  .73  .974  r
F
P
p
.21912  .55524  m .37872  .53785  L .39834  .54442  L .309  .73  .974  r
F
P
p
.21803  .5553  m .21945  .55515  L .21912  .55524  L .309  .73  .974  r
F
P
p
.21945  .55515  m .37872  .53785  L .21912  .55524  L .309  .73  .974  r
F
P
p
.21502  .58237  m .21575  .58218  L .21803  .5553  L .459  .785  .999  r
F
P
p
.21575  .58218  m .37753  .53818  L .21945  .55515  L .459  .785  .999  r
F
P
p
.21575  .58218  m .21945  .55515  L .21803  .5553  L .459  .785  .999  r
F
P
p
.37753  .53818  m .37699  .53804  L .21803  .5553  L .459  .785  .999  r
F
P
p
.37753  .53818  m .37872  .53785  L .37699  .53804  L .459  .785  .999  r
F
P
p
.21598  .58211  m .35711  .53107  L .37872  .53785  L .459  .785  .999  r
F
P
p
.21502  .58237  m .21625  .58193  L .21598  .58211  L .459  .785  .999  r
F
P
p
.21625  .58193  m .35711  .53107  L .21598  .58211  L .459  .785  .999  r
F
P
p
.21308  .60897  m .21371  .60863  L .21502  .58237  L .559  .803  .99  r
F
P
p
.21371  .60863  m .35605  .53164  L .21625  .58193  L .559  .803  .99  r
F
P
p
.21371  .60863  m .21625  .58193  L .21502  .58237  L .559  .803  .99  r
F
P
p
.35605  .53164  m .35556  .53163  L .21502  .58237  L .559  .803  .99  r
F
P
p
.35605  .53164  m .35711  .53107  L .35556  .53163  L .559  .803  .99  r
F
P
p
.2139  .60853  m .33395  .52451  L .35711  .53107  L .559  .803  .99  r
F
P
p
.21308  .60897  m .21411  .60825  L .2139  .60853  L .559  .803  .99  r
F
P
p
.21411  .60825  m .33395  .52451  L .2139  .60853  L .559  .803  .99  r
F
P
p
.212  .63484  m .21252  .63437  L .21308  .60897  L .623  .799  .966  r
F
P
p
.21252  .63437  m .33305  .52531  L .21411  .60825  L .623  .799  .966  r
F
P
p
.21252  .63437  m .21411  .60825  L .21308  .60897  L .623  .799  .966  r
F
P
p
.33305  .52531  m .33263  .52542  L .21308  .60897  L .623  .799  .966  r
F
P
p
.33305  .52531  m .33395  .52451  L .33263  .52542  L .623  .799  .966  r
F
P
p
.21268  .63423  m .30978  .51856  L .33395  .52451  L .623  .799  .966  r
F
P
p
.212  .63484  m .21282  .63388  L .21268  .63423  L .623  .799  .966  r
F
P
p
.21282  .63388  m .30978  .51856  L .21268  .63423  L .623  .799  .966  r
F
P
p
.21158  .65977  m .21199  .65917  L .212  .63484  L .664  .785  .938  r
F
P
p
.21199  .65917  m .30907  .51959  L .21281  .63388  L .664  .785  .938  r
F
P
p
.21199  .65917  m .21281  .63388  L .212  .63484  L .664  .785  .938  r
F
P
p
.30907  .51959  m .30873  .51982  L .212  .63484  L .664  .785  .938  r
F
P
p
.30907  .51959  m .30978  .51856  L .30873  .51982  L .664  .785  .938  r
F
P
p
.21211  .65901  m .28522  .51356  L .30978  .51856  L .664  .785  .938  r
F
P
p
.21158  .65977  m .21218  .65857  L .21211  .65901  L .664  .785  .938  r
F
P
p
.21218  .65857  m .28522  .51356  L .21211  .65901  L .664  .785  .938  r
F
P
p
.21159  .68351  m .2119  .68281  L .21158  .65977  L .69  .766  .91  r
F
P
p
.2119  .68281  m .28469  .51477  L .21218  .65858  L .69  .766  .91  r
F
P
p
.2119  .68281  m .21218  .65858  L .21158  .65977  L .69  .766  .91  r
F
P
p
.28469  .51477  m .28444  .51511  L .21158  .65977  L .69  .766  .91  r
F
P
p
.28469  .51477  m .28522  .51356  L .28444  .51511  L .69  .766  .91  r
F
P
p
.21198  .68263  m .26088  .50971  L .28522  .51356  L .69  .766  .91  r
F
P
p
.21159  .68351  m .21199  .68213  L .21198  .68263  L .69  .766  .91  r
F
P
p
.21199  .68213  m .26088  .50971  L .21198  .68263  L .69  .766  .91  r
F
P
p
.21185  .70588  m .21205  .70508  L .21159  .68351  L .706  .746  .883  r
F
P
p
.21205  .70508  m .26054  .51108  L .21199  .68213  L .706  .746  .883  r
F
P
p
.21205  .70508  m .21199  .68213  L .21159  .68351  L .706  .746  .883  r
F
P
p
.26054  .51108  m .26037  .51152  L .21159  .68351  L .706  .746  .883  r
F
P
p
.26054  .51108  m .26088  .50971  L .26037  .51152  L .706  .746  .883  r
F
P
p
.21185  .70588  m .23735  .50712  L .26088  .50971  L .706  .746  .883  r
F
P
p
.21213  .72665  m .23718  .50861  L .21185  .70588  L .716  .726  .858  r
F
P
p
.23718  .50861  m .23709  .50913  L .21185  .70588  L .716  .726  .858  r
F
P
p
.23718  .50861  m .23735  .50712  L .23709  .50913  L .716  .726  .858  r
F
P
p
.21213  .72665  m .21515  .50575  L .23735  .50712  L .716  .726  .858  r
F
P
p
.21226  .74564  m .21513  .50732  L .21213  .72665  L .721  .705  .835  r
F
P
p
.21513  .50732  m .21515  .50575  L .21512  .50791  L .721  .705  .835  r
F
P
p
.21513  .50732  m .21512  .50791  L .21213  .72665  L .721  .705  .835  r
F
P
p
.25  g
.004  w
.228  .50076  m
.22974  .50122  L
s
P
p
.25  g
.004  w
.24617  .44852  m
.24618  .44853  L
s
P
p
.25  g
.004  w
.23528  .47382  m
.23712  .47459  L
s
P
p
.006  w
.228  .50076  m
.23528  .47382  L
s
P
p
.006  w
.22681  .50647  m
.22761  .50263  L
s
P
p
.006  w
.22761  .50263  m
.228  .50076  L
s
P
p
.25504  .42192  m .46027  .56173  L .26767  .3975  L .662  .107  0 r
F
P
p
.25504  .42192  m .4526  .56107  L .46027  .56173  L .662  .107  0 r
F
P
p
.25  g
.004  w
.45996  .511  m
.47088  .49011  L
s
P
p
.25  g
.004  w
.45284  .49834  m
.45857  .51028  L
s
P
p
.006  w
.24426  .44745  m
.25504  .42192  L
s
P
p
.25  g
.004  w
.22974  .50122  m
.26331  .51009  L
s
P
p
.25  g
.004  w
.25504  .42192  m
.25698  .42329  L
s
P
p
.25  g
.004  w
.59902  .3012  m
.60025  .29929  L
s
P
p
.26767  .3975  m .46604  .56094  L .28218  .37445  L .752  .235  0 r
F
P
p
.26767  .3975  m .46027  .56173  L .46604  .56094  L .752  .235  0 r
F
P
p
.006  w
.25504  .42192  m
.26767  .3975  L
s
P
p
.25  g
.004  w
.45836  .52111  m
.4697  .50338  L
s
P
p
.25  g
.004  w
.26767  .3975  m
.26964  .39918  L
s
P
p
.72075  .50197  m .5511  .52694  L .72392  .52977  L 0 0 0 r
F
P
p
.5511  .52694  m .55078  .52698  L .55126  .52699  L 0 0 0 r
F
P
p
.5511  .52694  m .55126  .52699  L .72392  .52977  L 0 0 0 r
F
P
p
.55081  .52698  m .55172  .52715  L .72392  .52977  L 0 0 0 r
F
P
p
.55078  .52698  m .55082  .52699  L .55081  .52698  L 0 0 0 r
F
P
p
.55082  .52699  m .55172  .52715  L .55081  .52698  L 0 0 0 r
F
P
p
.59727  .52265  m .5724  .52447  L .59658  .52247  L .313  .769  .952  r
F
P
p
.55078  .52698  m .54986  .52712  L .55172  .52715  L 0 0 0 r
F
P
p
.72392  .52977  m .54986  .52712  L .5724  .52447  L .208  .73  .852  r
F
P
p
.72392  .52977  m .57349  .52451  L .72531  .55773  L .208  .73  .852  r
F
P
p
.57349  .52451  m .5724  .52447  L .57403  .52482  L .208  .73  .852  r
F
P
p
.57349  .52451  m .57403  .52482  L .72531  .55773  L .208  .73  .852  r
F
P
p
.72472  .55756  m .57404  .52482  L .59727  .52265  L .313  .769  .952  r
F
P
p
.57404  .52482  m .5724  .52447  L .59727  .52265  L .313  .769  .952  r
F
P
p
.72392  .55742  m .5724  .52447  L .72472  .55756  L .313  .769  .952  r
F
P
p
.72531  .55773  m .72392  .55742  L .72472  .55756  L .313  .769  .952  r
F
P
p
.72531  .55773  m .59751  .52272  L .72509  .5856  L .313  .769  .952  r
F
P
p
.59751  .52272  m .59763  .52283  L .72509  .5856  L .313  .769  .952  r
F
P
p
.59734  .52269  m .59794  .52313  L .72509  .5856  L .313  .769  .952  r
F
P
p
.59727  .52265  m .59737  .52273  L .59734  .52269  L .313  .769  .952  r
F
P
p
.59737  .52273  m .59794  .52313  L .59734  .52269  L .313  .769  .952  r
F
P
p
.72445  .58521  m .59794  .52313  L .62183  .52144  L .399  .772  .993  r
F
P
p
.59751  .52272  m .59727  .52265  L .59763  .52283  L .313  .769  .952  r
F
P
p
.59727  .52265  m .59658  .52247  L .59794  .52313  L .313  .769  .952  r
F
P
p
.59794  .52313  m .59658  .52247  L .62183  .52144  L .399  .772  .993  r
F
P
p
.72392  .58503  m .59658  .52247  L .72445  .58521  L .399  .772  .993  r
F
P
p
.72509  .5856  m .72392  .58503  L .72445  .58521  L .399  .772  .993  r
F
P
p
.72509  .5856  m .62257  .5219  L .72348  .61317  L .399  .772  .993  r
F
P
p
.62257  .5219  m .62183  .52144  L .6229  .5224  L .399  .772  .993  r
F
P
p
.62257  .5219  m .6229  .5224  L .72348  .61317  L .399  .772  .993  r
F
P
p
.72312  .61274  m .62183  .52144  L .72312  .61274  L .462  .753  .993  r
F
P
p
.72254  .61232  m .62183  .52144  L .72312  .61274  L .462  .753  .993  r
F
P
p
.723  .61259  m .62183  .52144  L .64747  .52162  L .462  .753  .993  r
F
P
p
.72288  .61252  m .62183  .52144  L .723  .61259  L .462  .753  .993  r
F
P
p
.72285  .6126  m .72254  .61232  L .72312  .61274  L .462  .753  .993  r
F
P
p
.72312  .61274  m .72288  .61252  L .723  .61259  L .462  .753  .993  r
F
P
p
.72348  .61317  m .72285  .6126  L .72312  .61274  L .462  .753  .993  r
F
P
p
.72348  .61317  m .64801  .52227  L .72069  .64019  L .462  .753  .993  r
F
P
p
.64801  .52227  m .64807  .52244  L .72069  .64019  L .462  .753  .993  r
F
P
p
.64797  .52227  m .6482  .52281  L .72069  .64019  L .462  .753  .993  r
F
P
p
.64786  .52209  m .64802  .52242  L .64797  .52227  L .462  .753  .993  r
F
P
p
.64802  .52242  m .6482  .52281  L .64797  .52227  L .462  .753  .993  r
F
P
p
.72038  .63944  m .6482  .52281  L .67284  .52317  L .507  .728  .972  r
F
P
p
.72  .63909  m .64747  .52162  L .72038  .63944  L .507  .728  .972  r
F
P
p
.72069  .64019  m .72  .63909  L .72038  .63944  L .507  .728  .972  r
F
P
p
.72069  .64019  m .67317  .52399  L .71696  .66647  L .507  .728  .972  r
F
P
p
.67317  .52399  m .67284  .52317  L .67329  .52464  L .507  .728  .972  r
F
P
p
.67317  .52399  m .67329  .52464  L .71696  .66647  L .507  .728  .972  r
F
P
p
.71685  .66575  m .67329  .52464  L .71687  .66577  L .54  .702  .944  r
F
P
p
.67329  .52464  m .67284  .52317  L .67329  .52464  L .54  .702  .944  r
F
P
p
.67329  .52464  m .67329  .52464  L .71687  .66577  L .54  .702  .944  r
F
P
p
.71655  .66513  m .67284  .52317  L .71685  .66575  L .54  .702  .944  r
F
P
p
.71684  .66555  m .67284  .52317  L .69728  .52611  L .54  .702  .944  r
F
P
p
.71677  .66545  m .67284  .52317  L .71684  .66555  L .54  .702  .944  r
F
P
p
.71668  .66555  m .71655  .66513  L .71685  .66575  L .54  .702  .944  r
F
P
p
.71687  .66577  m .71677  .66545  L .71684  .66555  L .54  .702  .944  r
F
P
p
.71696  .66647  m .71668  .66555  L .71687  .66577  L .54  .702  .944  r
F
P
p
.71696  .66647  m .69742  .52707  L .71255  .6918  L .54  .702  .944  r
F
P
p
.69742  .52707  m .69742  .5273  L .71255  .6918  L .54  .702  .944  r
F
P
p
.69737  .52676  m .69742  .52762  L .71255  .6918  L .54  .702  .944  r
F
P
p
.71261  .69072  m .69742  .52762  L .72024  .53033  L .566  .679  .915  r
F
P
p
.71241  .6902  m .69728  .52611  L .71261  .69072  L .566  .679  .915  r
F
P
p
.71255  .6918  m .71241  .6902  L .71261  .69072  L .566  .679  .915  r
F
P
p
.71255  .6918  m .72024  .53033  L .70771  .716  L .566  .679  .915  r
F
P
p
.70788  .71499  m .72024  .53033  L .70789  .71504  L .587  .659  .887  r
F
P
p
.7078  .71473  m .70783  .71421  L .70788  .71499  L .587  .659  .887  r
F
P
p
.70783  .71421  m .72024  .53033  L .70788  .71499  L .587  .659  .887  r
F
P
p
.70794  .71476  m .72024  .53033  L .74126  .53563  L .587  .659  .887  r
F
P
p
.70789  .71504  m .70792  .71462  L .70794  .71476  L .587  .659  .887  r
F
P
p
.70792  .71462  m .72024  .53033  L .70794  .71476  L .587  .659  .887  r
F
P
p
.70771  .716  m .7078  .71473  L .70789  .71504  L .587  .659  .887  r
F
P
p
.70771  .716  m .74126  .53563  L .70269  .73889  L .587  .659  .887  r
F
P
p
.70309  .73749  m .74126  .53563  L .75999  .54172  L .605  .643  .862  r
F
P
p
.70269  .73889  m .70308  .73683  L .70309  .73749  L .605  .643  .862  r
F
P
p
.70308  .73683  m .74126  .53563  L .70309  .73749  L .605  .643  .862  r
F
P
p
.69742  .52707  m .69737  .52676  L .69742  .5273  L .54  .702  .944  r
F
P
p
.69737  .52676  m .69728  .52611  L .69742  .52762  L .54  .702  .944  r
F
P
p
.69742  .52762  m .69728  .52611  L .72024  .53033  L .566  .679  .915  r
F
P
p
.64801  .52227  m .64786  .52209  L .64807  .52244  L .462  .753  .993  r
F
P
p
.64786  .52209  m .64747  .52162  L .6482  .52281  L .462  .753  .993  r
F
P
p
.6482  .52281  m .64747  .52162  L .67284  .52317  L .507  .728  .972  r
F
P
p
.72075  .50197  m .52946  .53006  L .54986  .52712  L 0 0 0 r
F
P
p
.71565  .47458  m .52946  .53006  L .72075  .50197  L 0 0 0 r
F
P
p
.006  w
.72075  .50197  m
.72392  .52977  L
s
P
p
.006  w
.72392  .52977  m
.72399  .53127  L
s
P
p
.25  g
.004  w
.33654  .31577  m
.33809  .31841  L
s
P
p
1 0 0 r
.003  w
.47316  .55575  m
.47516  .55191  L
s
P
p
.71565  .47458  m .51152  .53294  L .52946  .53006  L 0 0 0 r
F
P
p
.70851  .44786  m .51152  .53294  L .71565  .47458  L .054  0 0 r
F
P
p
.25  g
.004  w
.71903  .50223  m
.72075  .50197  L
s
P
p
.006  w
.71565  .47458  m
.72075  .50197  L
s
P
p
.28218  .37445  m .47022  .55886  L .29853  .35299  L .817  .336  .035  r
F
P
p
.25  g
.004  w
.33809  .31841  m
.33815  .31851  L
s
P
p
.25  g
.004  w
.46455  .36954  m
.46462  .37034  L
s
P
p
.28218  .37445  m .46604  .56094  L .47022  .55886  L .817  .336  .035  r
F
P
p
.25  g
.004  w
.38199  .29065  m
.41555  .37958  L
s
P
p
.25  g
.004  w
.46291  .38624  m
.4644  .37231  L
s
P
p
.25  g
.004  w
.40575  .28047  m
.43923  .40046  L
s
P
p
.25  g
.004  w
.4586  .42645  m
.46291  .38624  L
s
P
p
.25  g
.004  w
.43923  .40046  m
.45559  .45907  L
s
P
p
.25  g
.004  w
.35938  .30338  m
.45284  .49834  L
s
P
p
.25  g
.004  w
.41555  .37958  m
.45386  .48106  L
s
P
p
.25  g
.004  w
.44209  .55855  m
.44272  .5589  L
s
P
p
.25  g
.004  w
.44118  .55804  m
.44209  .55855  L
s
P
p
.25  g
.004  w
.4408  .55783  m
.44118  .55804  L
s
P
p
.25  g
.004  w
.44073  .55779  m
.4408  .55783  L
s
P
p
.25  g
.004  w
.24618  .44853  m
.44073  .55779  L
s
P
p
.25  g
.004  w
.42843  .55444  m
.42847  .55445  L
s
P
p
.25  g
.004  w
.23712  .47459  m
.42843  .55444  L
s
P
p
.25  g
.004  w
.43004  .5551  m
.43044  .55527  L
s
P
p
.25  g
.004  w
.42897  .55466  m
.43004  .5551  L
s
P
p
.25  g
.004  w
.42847  .55445  m
.42897  .55466  L
s
P
p
.25  g
.004  w
.45067  .55972  m
.45078  .55979  L
s
P
p
.25  g
.004  w
.3069  .45845  m
.45067  .55972  L
s
P
p
.25  g
.004  w
.25698  .42329  m
.3069  .45845  L
s
P
p
.25  g
.004  w
.32842  .4493  m
.4528  .55536  L
s
P
p
.25  g
.004  w
.26964  .39918  m
.32842  .4493  L
s
P
p
.25  g
.004  w
.45859  .5603  m
.46027  .56173  L
s
P
p
.25  g
.004  w
.4528  .55536  m
.45859  .5603  L
s
P
p
.006  w
.26767  .3975  m
.28218  .37445  L
s
P
p
.25  g
.004  w
.33815  .31851  m
.45232  .513  L
s
P
p
.25  g
.004  w
.45232  .513  m
.45522  .51796  L
s
P
p
.25  g
.004  w
.45522  .51796  m
.45819  .52301  L
s
P
p
.25  g
.004  w
.46158  .52879  m
.47516  .55191  L
s
P
p
.25  g
.004  w
.3784  .47204  m
.4532  .54792  L
s
P
p
.25  g
.004  w
.28218  .37445  m
.28351  .3758  L
s
P
p
.25  g
.004  w
.28351  .3758  m
.28411  .37641  L
s
P
p
.25  g
.004  w
.28411  .37641  m
.3784  .47204  L
s
P
p
.25  g
.004  w
.4532  .54792  m
.45351  .54823  L
s
P
p
.25  g
.004  w
.45351  .54823  m
.46604  .56094  L
s
P
p
.25  g
.004  w
.45078  .55979  m
.451  .55995  L
s
P
p
.25  g
.004  w
.451  .55995  m
.4526  .56107  L
s
P
p
.006  w
.28218  .37445  m
.29853  .35299  L
s
P
p
.70851  .44786  m .49623  .53543  L .51152  .53294  L .054  0 0 r
F
P
p
.69925  .42204  m .49623  .53543  L .70851  .44786  L .087  0 0 r
F
P
p
.25  g
.004  w
.71381  .47511  m
.71565  .47458  L
s
P
p
.006  w
.70851  .44786  m
.71565  .47458  L
s
P
p
.006  w
.21308  .60897  m
.21389  .59789  L
s
P
p
.25  g
.004  w
.40755  .48372  m
.45439  .53988  L
s
P
p
.25  g
.004  w
.29853  .35299  m
.29861  .35308  L
s
P
p
.25  g
.004  w
.29861  .35308  m
.29983  .35454  L
s
P
p
.25  g
.004  w
.29983  .35454  m
.30039  .35522  L
s
P
p
.25  g
.004  w
.30039  .35522  m
.40755  .48372  L
s
P
p
.25  g
.004  w
.45439  .53988  m
.47022  .55886  L
s
P
p
.006  w
.29853  .35299  m
.31669  .33336  L
s
P
p
.69925  .42204  m .4836  .53728  L .49623  .53543  L .087  0 0 r
F
P
p
.68784  .39737  m .4836  .53728  L .69925  .42204  L .095  0 0 r
F
P
p
.25  g
.004  w
.7066  .44864  m
.70851  .44786  L
s
P
p
.006  w
.69925  .42204  m
.70851  .44786  L
s
P
p
.25  g
.004  w
.45647  .53007  m
.45835  .52762  L
s
P
p
.68784  .39737  m .47351  .53833  L .4836  .53728  L .095  0 0 r
F
P
p
.67428  .3741  m .47351  .53833  L .68784  .39737  L .085  0 0 r
F
P
p
.25  g
.004  w
.69731  .42307  m
.69925  .42204  L
s
P
p
.006  w
.68784  .39737  m
.69925  .42204  L
s
P
p
.25  g
.004  w
.45835  .52762  m
.49764  .47637  L
s
P
p
.25  g
.004  w
.44311  .51304  m
.45633  .53184  L
s
P
p
.25  g
.004  w
.31669  .33336  m
.31679  .3335  L
s
P
p
.25  g
.004  w
.31679  .3335  m
.31792  .33511  L
s
P
p
.25  g
.004  w
.31792  .33511  m
.31844  .33585  L
s
P
p
.25  g
.004  w
.31844  .33585  m
.44311  .51304  L
s
P
p
.25  g
.004  w
.45777  .53389  m
.47316  .55575  L
s
P
p
.006  w
.31669  .33336  m
.33654  .31577  L
s
P
p
.25  g
.004  w
.21308  .60897  m
.21372  .60852  L
s
P
p
.25  g
.004  w
.21372  .60852  m
.21374  .6085  L
s
P
p
.006  w
.212  .63484  m
.21289  .61351  L
s
P
p
.006  w
.21289  .61351  m
.21308  .60897  L
s
P
p
1 0 0 r
.003  w
.47022  .55886  m
.47316  .55575  L
s
P
p
.67428  .3741  m .46572  .53853  L .47351  .53833  L .085  0 0 r
F
P
p
.65863  .35246  m .46572  .53853  L .67428  .3741  L .059  0 .017  r
F
P
p
.25  g
.004  w
.67117  .40834  m
.68592  .39864  L
s
P
p
.25  g
.004  w
.68592  .39864  m
.68784  .39737  L
s
P
p
.006  w
.67428  .3741  m
.68784  .39737  L
s
P
p
.25  g
.004  w
.6521  .39159  m
.67428  .3741  L
s
P
p
.006  w
.33654  .31577  m
.35795  .3004  L
s
P
p
.65863  .35246  m .45992  .5379  L .46572  .53853  L .059  0 .017  r
F
P
p
.25  g
.004  w
.47351  .53833  m
.47398  .53802  L
s
P
p
.64098  .33264  m .45992  .5379  L .65863  .35246  L .019  0 .057  r
F
P
p
.006  w
.65863  .35246  m
.67428  .3741  L
s
P
p
.25  g
.004  w
.64747  .52162  m
.6482  .52281  L
s
P
p
.25  g
.004  w
.6482  .52281  m
.6482  .52281  L
s
P
p
.25  g
.004  w
.63298  .37639  m
.65863  .35246  L
s
P
p
.006  w
.35795  .3004  m
.38076  .2874  L
s
P
p
.25  g
.004  w
.212  .63484  m
.2125  .63425  L
s
P
p
.25  g
.004  w
.2125  .63425  m
.21282  .63388  L
s
P
p
.25  g
.004  w
.21282  .63388  m
.21284  .63384  L
s
P
p
.25  g
.004  w
.21284  .63384  m
.21341  .63317  L
s
P
p
.006  w
.21158  .65977  m
.212  .63484  L
s
P
p
.64098  .33264  m .45576  .53658  L .45992  .5379  L .019  0 .057  r
F
P
p
.25  g
.004  w
.46572  .53853  m
.46771  .53696  L
s
P
p
.25  g
.004  w
.47398  .53802  m
.47516  .53725  L
s
P
p
.25  g
.004  w
.47516  .53725  m
.47563  .53694  L
s
P
p
.25  g
.004  w
.4836  .53728  m
.48389  .53712  L
s
P
p
.62147  .31486  m .45576  .53658  L .64098  .33264  L 0 0 .083  r
F
P
p
.25  g
.004  w
.43045  .27301  m
.45858  .4272  L
s
P
p
1 0 0 r
.003  w
.45447  .53576  m
.45576  .53658  L
s
P
p
.25  g
.004  w
.45581  .26852  m
.46455  .36954  L
s
P
p
.25  g
.004  w
.4708  .45474  m
.51032  .3264  L
s
P
p
.25  g
.004  w
.52946  .53006  m
.5315  .52976  L
s
P
p
.25  g
.004  w
.5315  .52976  m
.71903  .50223  L
s
P
p
.25  g
.004  w
.47088  .49011  m
.54957  .33956  L
s
P
p
.25  g
.004  w
.54986  .52712  m
.55172  .52715  L
s
P
p
.25  g
.004  w
.55172  .52715  m
.5872  .52769  L
s
P
p
.25  g
.004  w
.51152  .53294  m
.513  .53252  L
s
P
p
.25  g
.004  w
.513  .53252  m
.51368  .53232  L
s
P
p
.25  g
.004  w
.51368  .53232  m
.71381  .47511  L
s
P
p
.25  g
.004  w
.4713  .47457  m
.52887  .33511  L
s
P
p
.25  g
.004  w
.5724  .52447  m
.57403  .52482  L
s
P
p
.25  g
.004  w
.57403  .52482  m
.57403  .52482  L
s
P
p
.25  g
.004  w
.57403  .52482  m
.62311  .5355  L
s
P
p
.25  g
.004  w
.4697  .50338  m
.56658  .35193  L
s
P
p
.25  g
.004  w
.49623  .53543  m
.49638  .53537  L
s
P
p
.25  g
.004  w
.49638  .53537  m
.49779  .53478  L
s
P
p
.25  g
.004  w
.49844  .53452  m
.7066  .44864  L
s
P
p
.25  g
.004  w
.49779  .53478  m
.49844  .53452  L
s
P
p
.25  g
.004  w
.46894  .42567  m
.50114  .26971  L
s
P
p
.25  g
.004  w
.59658  .52247  m
.59794  .52313  L
s
P
p
.25  g
.004  w
.59794  .52313  m
.59795  .52314  L
s
P
p
.25  g
.004  w
.59795  .52314  m
.6545  .55092  L
s
P
p
.25  g
.004  w
.48579  .53611  m
.69731  .42307  L
s
P
p
.25  g
.004  w
.48522  .53641  m
.48579  .53611  L
s
P
p
.25  g
.004  w
.48389  .53712  m
.48522  .53641  L
s
P
p
.25  g
.004  w
.62183  .52144  m
.62288  .52238  L
s
P
p
.25  g
.004  w
.62288  .52238  m
.6229  .5224  L
s
P
p
.25  g
.004  w
.6229  .5224  m
.6229  .5224  L
s
P
p
.25  g
.004  w
.6229  .5224  m
.67948  .57347  L
s
P
p
.25  g
.004  w
.49764  .47637  m
.59212  .35314  L
s
P
p
.25  g
.004  w
.47563  .53694  m
.67117  .40834  L
s
P
p
.25  g
.004  w
.46771  .53696  m
.4886  .52049  L
s
P
p
.25  g
.004  w
.4886  .52049  m
.6521  .39159  L
s
P
p
.25  g
.004  w
.59212  .35314  m
.59321  .35172  L
s
P
p
.25  g
.004  w
.4644  .37231  m
.47653  .25921  L
s
P
p
.25  g
.004  w
.46175  .5362  m
.49137  .50855  L
s
P
p
.25  g
.004  w
.46153  .5364  m
.46175  .5362  L
s
P
p
.25  g
.004  w
.45992  .5379  m
.46153  .5364  L
s
P
p
.25  g
.004  w
.49137  .50855  m
.60987  .39797  L
s
P
p
.25  g
.004  w
.60987  .39797  m
.63298  .37639  L
s
P
p
.25  g
.004  w
.59321  .35172  m
.62003  .31673  L
s
P
p
.25  g
.004  w
.57207  .34334  m
.59902  .3012  L
s
P
p
.25  g
.004  w
.57088  .34521  m
.57207  .34334  L
s
P
p
.25  g
.004  w
.56658  .35193  m
.57088  .34521  L
s
P
p
.25  g
.004  w
.55096  .33691  m
.57654  .28797  L
s
P
p
.25  g
.004  w
.54957  .33956  m
.55096  .33691  L
s
P
p
.25  g
.004  w
.52887  .33511  m
.53058  .33099  L
s
P
p
.006  w
.64098  .33264  m
.65863  .35246  L
s
P
p
.25  g
.004  w
.46525  .52613  m
.60916  .36768  L
s
P
p
.25  g
.004  w
.45711  .53509  m
.46525  .52613  L
s
P
p
.25  g
.004  w
.45576  .53658  m
.45711  .53509  L
s
P
p
.25  g
.004  w
.60916  .36768  m
.61291  .36355  L
s
P
p
.25  g
.004  w
.61291  .36355  m
.63937  .33442  L
s
P
p
.25  g
.004  w
.63937  .33442  m
.64098  .33264  L
s
P
p
.25  g
.004  w
.62003  .31673  m
.62147  .31486  L
s
P
p
.25  g
.004  w
.53058  .33099  m
.55354  .27537  L
s
P
p
.25  g
.004  w
.51239  .31968  m
.52853  .26727  L
s
P
p
.25  g
.004  w
.51032  .3264  m
.51239  .31968  L
s
P
p
1 0 0 r
.003  w
.45687  .53693  m
.45992  .5379  L
s
P
p
1 0 0 r
.003  w
.45576  .53658  m
.45687  .53693  L
s
P
p
.006  w
.62147  .31486  m
.64098  .33264  L
s
P
p
.25  g
.004  w
.67284  .52317  m
.67326  .52455  L
s
P
p
.006  w
.38076  .2874  m
.40476  .27693  L
s
P
p
.006  w
.60025  .29929  m
.62147  .31486  L
s
P
p
1 0 0 r
.003  w
.46604  .56094  m
.47022  .55886  L
s
P
p
.006  w
.40476  .27693  m
.42973  .26907  L
s
P
p
.006  w
.57753  .28608  m
.60025  .29929  L
s
P
p
.25  g
.004  w
.69728  .52611  m
.69742  .52762  L
s
P
p
.25  g
.004  w
.69742  .52762  m
.69744  .52778  L
s
P
p
.25  g
.004  w
.69728  .52611  m
.69728  .52611  L
s
P
p
.25  g
.004  w
.21158  .65977  m
.21194  .65905  L
s
P
p
.25  g
.004  w
.21194  .65905  m
.21218  .65857  L
s
P
p
.25  g
.004  w
.21218  .65857  m
.2122  .65852  L
s
P
p
.25  g
.004  w
.2122  .65852  m
.21309  .65677  L
s
P
p
.006  w
.21158  .65977  m
.21159  .68351  L
s
P
p
.006  w
.42973  .26907  m
.45541  .26393  L
s
P
p
.006  w
.55354  .27537  m
.57753  .28608  L
s
P
p
.006  w
.45541  .26393  m
.47604  .26205  L
s
P
p
.006  w
.47604  .26205  m
.47623  .26204  L
s
P
p
.006  w
.52853  .26727  m
.55354  .27537  L
s
P
p
1 0 0 r
.003  w
.46191  .53812  m
.46572  .53853  L
s
P
p
1 0 0 r
.003  w
.45992  .5379  m
.46191  .53812  L
s
P
p
.006  w
.50276  .26187  m
.52853  .26727  L
s
P
p
.006  w
.47653  .25921  m
.50276  .26187  L
s
P
p
1 0 0 r
.003  w
.46027  .56173  m
.46604  .56094  L
s
P
p
.25  g
.004  w
.72014  .53194  m
.72024  .53033  L
s
P
p
.25  g
.004  w
.21159  .68351  m
.21201  .68205  L
s
P
p
.25  g
.004  w
.21201  .68205  m
.21278  .67934  L
s
P
p
.006  w
.21159  .68351  m
.21185  .70588  L
s
P
p
1 0 0 r
.003  w
.46572  .53853  m
.47351  .53833  L
s
P
p
.70269  .73889  m .75999  .54172  L .69772  .76031  L .605  .643  .862  r
F
P
p
.25  g
.004  w
.70269  .73889  m
.7027  .7388  L
s
P
p
.25  g
.004  w
.7027  .7388  m
.70296  .73746  L
s
P
p
.25  g
.004  w
.70296  .73746  m
.70308  .73683  L
s
P
p
.25  g
.004  w
.21185  .70588  m
.21206  .70422  L
s
P
p
.25  g
.004  w
.21206  .70422  m
.21248  .70091  L
s
P
p
.006  w
.21185  .70588  m
.21213  .72665  L
s
P
p
1 0 0 r
.003  w
.4526  .56107  m
.46027  .56173  L
s
P
p
1 0 0 r
.003  w
.47351  .53833  m
.4836  .53728  L
s
P
p
.69772  .76031  m .7762  .54825  L .69306  .7801  L .62  .63  .839  r
F
P
p
.69772  .76031  m .75999  .54172  L .7762  .54825  L .62  .63  .839  r
F
P
p
.25  g
.004  w
.74094  .53731  m
.74126  .53563  L
s
P
p
.25  g
.004  w
.72012  .53218  m
.72014  .53194  L
s
P
p
.006  w
.69772  .76031  m
.70269  .73889  L
s
P
p
.25  g
.004  w
.69818  .7587  m
.69837  .75803  L
s
P
p
.25  g
.004  w
.69776  .76017  m
.69818  .7587  L
s
P
p
.25  g
.004  w
.69772  .76031  m
.69776  .76017  L
s
P
p
1 0 0 r
.003  w
.44272  .5589  m
.4526  .56107  L
s
P
p
1 0 0 r
.003  w
.4836  .53728  m
.49623  .53543  L
s
P
p
.69306  .7801  m .78977  .55483  L .68891  .79811  L .634  .619  .817  r
F
P
p
.69306  .7801  m .7762  .54825  L .78977  .55483  L .634  .619  .817  r
F
P
p
.25  g
.004  w
.74088  .53766  m
.74094  .53731  L
s
P
p
.25  g
.004  w
.7595  .54344  m
.75999  .54172  L
s
P
p
.006  w
.69306  .7801  m
.69772  .76031  L
s
P
p
.25  g
.004  w
.6937  .77831  m
.69396  .77759  L
s
P
p
.25  g
.004  w
.69313  .77991  m
.6937  .77831  L
s
P
p
.25  g
.004  w
.69306  .7801  m
.69313  .77991  L
s
P
p
.21226  .74564  m .19471  .50545  L .21515  .50575  L .721  .705  .835  r
F
P
p
.21206  .76267  m .19471  .50545  L .21226  .74564  L .722  .685  .813  r
F
P
p
1 0 0 r
.003  w
.43044  .55527  m
.44272  .5589  L
s
P
p
1 0 0 r
.003  w
.49623  .53543  m
.51152  .53294  L
s
P
p
.68549  .8142  m .80787  .56858  L .68298  .82823  L .658  .601  .779  r
F
P
p
.80787  .56858  m .80884  .56662  L .80769  .56902  L .658  .601  .779  r
F
P
p
.80787  .56858  m .80769  .56902  L .68298  .82823  L .658  .601  .779  r
F
P
p
.68298  .82823  m .81402  .57191  L .68154  .84005  L .669  .592  .761  r
F
P
p
.81402  .57191  m .8144  .57118  L .81391  .57217  L .669  .592  .761  r
F
P
p
.81402  .57191  m .81391  .57217  L .68154  .84005  L .669  .592  .761  r
F
P
p
.68298  .82823  m .80884  .56662  L .8144  .57118  L .669  .592  .761  r
F
P
p
.68154  .84005  m .81735  .57453  L .68131  .84952  L .677  .583  .742  r
F
P
p
.68154  .84005  m .8144  .57118  L .81735  .57453  L .677  .583  .742  r
F
P
p
.68131  .84952  m .81774  .57652  L .68239  .85651  L .671  .557  .717  r
F
P
p
.68131  .84952  m .81735  .57453  L .81774  .57652  L .671  .557  .717  r
F
P
p
.68239  .85651  m .81748  .57705  L .81559  .5771  L .722  .599  .719  r
F
P
p
.81748  .57705  m .81774  .57652  L .81559  .5771  L .722  .599  .719  r
F
P
p
.81166  .57719  m .81559  .5771  L .81198  .57649  L .721  .58  .696  r
F
P
p
.75462  .705  m .81476  .57885  L .69075  .84808  L .722  .599  .719  r
F
P
p
.81476  .57885  m .81467  .57906  L .69075  .84808  L .722  .599  .719  r
F
P
p
.75462  .705  m .69075  .84808  L .68486  .86088  L .722  .599  .719  r
F
P
p
.68239  .85651  m .75462  .705  L .68486  .86088  L .722  .599  .719  r
F
P
p
.81476  .57885  m .81507  .57819  L .81467  .57906  L .722  .599  .719  r
F
P
p
.81507  .57819  m .81537  .57756  L .81494  .57849  L .722  .599  .719  r
F
P
p
.81507  .57819  m .81494  .57849  L .68486  .86088  L .722  .599  .719  r
F
P
p
.81537  .57756  m .81559  .5771  L .81517  .57802  L .722  .599  .719  r
F
P
p
.81537  .57756  m .81517  .57802  L .81484  .57872  L .722  .599  .719  r
F
P
p
.81494  .57849  m .81484  .57872  L .68486  .86088  L .722  .599  .719  r
F
P
p
.81537  .57756  m .81484  .57872  L .81494  .57849  L .722  .599  .719  r
F
P
p
.81161  .57731  m .81559  .5771  L .81166  .57719  L .721  .58  .696  r
F
P
p
.69073  .84813  m .81484  .57872  L .81161  .57731  L .721  .58  .696  r
F
P
p
.81484  .57872  m .81559  .5771  L .81161  .57731  L .721  .58  .696  r
F
P
p
.68486  .86088  m .69073  .84813  L .81092  .57632  L .721  .58  .696  r
F
P
p
.69073  .84813  m .81198  .57649  L .81092  .57632  L .721  .58  .696  r
F
P
p
.68486  .86088  m .81011  .57816  L .68875  .86248  L .721  .58  .696  r
F
P
p
.81011  .57816  m .81038  .57755  L .81004  .57835  L .721  .58  .696  r
F
P
p
.81011  .57816  m .81004  .57835  L .68875  .86248  L .721  .58  .696  r
F
P
p
.81038  .57755  m .81026  .57785  L .68875  .86248  L .721  .58  .696  r
F
P
p
.81067  .5769  m .81044  .57746  L .81015  .57813  L .721  .58  .696  r
F
P
p
.81026  .57785  m .81015  .57813  L .68875  .86248  L .721  .58  .696  r
F
P
p
.81067  .5769  m .81015  .57813  L .81026  .57785  L .721  .58  .696  r
F
P
p
.80525  .57503  m .81092  .57632  L .80536  .57478  L .728  .57  .676  r
F
P
p
.68895  .862  m .81044  .57746  L .80525  .57503  L .728  .57  .676  r
F
P
p
.81038  .57755  m .81067  .5769  L .81026  .57785  L .721  .58  .696  r
F
P
p
.81067  .5769  m .81092  .57632  L .81044  .57746  L .721  .58  .696  r
F
P
p
.81044  .57746  m .81092  .57632  L .80525  .57503  L .728  .57  .676  r
F
P
p
.68921  .8614  m .81092  .57632  L .68895  .862  L .728  .57  .676  r
F
P
p
.68549  .8142  m .80065  .56107  L .80884  .56662  L .658  .601  .779  r
F
P
p
.69368  .85013  m .80536  .57478  L .80374  .57433  L .728  .57  .676  r
F
P
p
.68875  .86248  m .80536  .57478  L .69368  .85013  L .728  .57  .676  r
F
P
p
.68875  .86248  m .68921  .8614  L .68895  .862  L .728  .57  .676  r
F
P
p
.68875  .86248  m .80299  .57622  L .69407  .86119  L .728  .57  .676  r
F
P
p
.80299  .57622  m .80294  .57638  L .69407  .86119  L .728  .57  .676  r
F
P
p
.80321  .57566  m .803  .57627  L .69407  .86119  L .728  .57  .676  r
F
P
p
.69434  .86041  m .79636  .57205  L .73377  .7461  L .736  .56  .654  r
F
P
p
.69423  .86073  m .69436  .86036  L .69434  .86041  L .736  .56  .654  r
F
P
p
.69436  .86036  m .79636  .57205  L .69434  .86041  L .736  .56  .654  r
F
P
p
.69407  .86119  m .69425  .86068  L .69423  .86073  L .736  .56  .654  r
F
P
p
.69425  .86068  m .79636  .57205  L .69423  .86073  L .736  .56  .654  r
F
P
p
.80299  .57622  m .80321  .57566  L .80294  .57638  L .728  .57  .676  r
F
P
p
.80321  .57566  m .80374  .57433  L .803  .57627  L .728  .57  .676  r
F
P
p
.69425  .86068  m .80374  .57433  L .79636  .57205  L .736  .56  .654  r
F
P
p
.69407  .86119  m .69439  .86036  L .69425  .86068  L .736  .56  .654  r
F
P
p
.69439  .86036  m .80374  .57433  L .69425  .86068  L .736  .56  .654  r
F
P
p
.68891  .79811  m .79922  .56409  L .68549  .8142  L .647  .609  .797  r
F
P
p
.79922  .56409  m .79904  .56461  L .68549  .8142  L .647  .609  .797  r
F
P
p
.68891  .79811  m .78977  .55483  L .80065  .56107  L .647  .609  .797  r
F
P
p
.73377  .7461  m .79636  .57205  L .79405  .57134  L .736  .56  .654  r
F
P
p
.69407  .86119  m .7934  .57323  L .70077  .8569  L .736  .56  .654  r
F
P
p
.7934  .57323  m .79337  .57336  L .70077  .8569  L .736  .56  .654  r
F
P
p
.79357  .57276  m .79348  .57305  L .70077  .8569  L .736  .56  .654  r
F
P
p
.79379  .5721  m .79358  .5728  L .79339  .57338  L .736  .56  .654  r
F
P
p
.79348  .57305  m .79339  .57338  L .70077  .8569  L .736  .56  .654  r
F
P
p
.79379  .5721  m .79339  .57338  L .79348  .57305  L .736  .56  .654  r
F
P
p
.70127  .85535  m .79405  .57134  L .70126  .85538  L .744  .549  .631  r
F
P
p
.7934  .57323  m .79357  .57276  L .79337  .57336  L .736  .56  .654  r
F
P
p
.70102  .85599  m .79358  .5728  L .7819  .56765  L .744  .549  .631  r
F
P
p
.79357  .57276  m .79379  .5721  L .79348  .57305  L .736  .56  .654  r
F
P
p
.79379  .5721  m .79405  .57134  L .79358  .5728  L .736  .56  .654  r
F
P
p
.79358  .5728  m .79405  .57134  L .7819  .56765  L .744  .549  .631  r
F
P
p
.70126  .85538  m .79405  .57134  L .70102  .85599  L .744  .549  .631  r
F
P
p
.70079  .85683  m .70127  .85535  L .70078  .85686  L .744  .549  .631  r
F
P
p
.70127  .85535  m .70126  .85538  L .70078  .85686  L .744  .549  .631  r
F
P
p
.70078  .85686  m .70126  .85538  L .70102  .85599  L .744  .549  .631  r
F
P
p
.70077  .8569  m .70079  .85683  L .70078  .85686  L .744  .549  .631  r
F
P
p
.70077  .8569  m .78138  .5695  L .70875  .8495  L .744  .549  .631  r
F
P
p
.78138  .5695  m .78149  .56913  L .78137  .5696  L .744  .549  .631  r
F
P
p
.78138  .5695  m .78137  .5696  L .70875  .8495  L .744  .549  .631  r
F
P
p
.78149  .56913  m .78143  .56941  L .70875  .8495  L .744  .549  .631  r
F
P
p
.78167  .56848  m .78149  .56923  L .78136  .56976  L .744  .549  .631  r
F
P
p
.78143  .56941  m .78136  .56976  L .70875  .8495  L .744  .549  .631  r
F
P
p
.78167  .56848  m .78136  .56976  L .78143  .56941  L .744  .549  .631  r
F
P
p
.70899  .84833  m .78149  .56923  L .76737  .56359  L .75  .536  .605  r
F
P
p
.70897  .8484  m .70901  .84828  L .70899  .84833  L .75  .536  .605  r
F
P
p
.70901  .84828  m .7819  .56765  L .70899  .84833  L .75  .536  .605  r
F
P
p
.70884  .84908  m .70921  .84762  L .70897  .8484  L .75  .536  .605  r
F
P
p
.70921  .84762  m .7819  .56765  L .70897  .8484  L .75  .536  .605  r
F
P
p
.70875  .8495  m .70891  .84888  L .70884  .84908  L .75  .536  .605  r
F
P
p
.70891  .84888  m .7819  .56765  L .70884  .84908  L .75  .536  .605  r
F
P
p
.70875  .8495  m .767  .56537  L .71787  .83891  L .75  .536  .605  r
F
P
p
.767  .56537  m .767  .56543  L .71787  .83891  L .75  .536  .605  r
F
P
p
.76706  .56511  m .76702  .56536  L .71787  .83891  L .75  .536  .605  r
F
P
p
.76718  .56448  m .76707  .56526  L .76698  .56573  L .75  .536  .605  r
F
P
p
.76702  .56536  m .76698  .56573  L .71787  .83891  L .75  .536  .605  r
F
P
p
.76718  .56448  m .76698  .56573  L .76702  .56536  L .75  .536  .605  r
F
P
p
.71814  .83718  m .76706  .56526  L .71814  .83718  L .756  .519  .574  r
F
P
p
.76706  .56526  m .76706  .56526  L .71814  .83718  L .756  .519  .574  r
F
P
p
.71825  .8368  m .71831  .83647  L .71814  .83718  L .756  .519  .574  r
F
P
p
.71831  .83647  m .76737  .56359  L .71814  .83718  L .756  .519  .574  r
F
P
p
.71804  .83799  m .71825  .8368  L .71795  .83827  L .756  .519  .574  r
F
P
p
.71825  .8368  m .71814  .83718  L .71795  .83827  L .756  .519  .574  r
F
P
p
.767  .56537  m .76706  .56511  L .767  .56543  L .75  .536  .605  r
F
P
p
.76706  .56511  m .76718  .56448  L .76702  .56536  L .75  .536  .605  r
F
P
p
.76718  .56448  m .76737  .56359  L .76707  .56526  L .75  .536  .605  r
F
P
p
.71803  .83759  m .76737  .56359  L .75058  .55949  L .756  .519  .574  r
F
P
p
.71795  .83827  m .71814  .83718  L .71803  .83759  L .756  .519  .574  r
F
P
p
.71814  .83718  m .76737  .56359  L .71803  .83759  L .756  .519  .574  r
F
P
p
.71787  .83891  m .71804  .83799  L .71795  .83827  L .756  .519  .574  r
F
P
p
.71787  .83891  m .75039  .56117  L .72794  .82511  L .756  .519  .574  r
F
P
p
.75039  .56117  m .75039  .5612  L .72794  .82511  L .756  .519  .574  r
F
P
p
.7504  .56103  m .7504  .56126  L .72794  .82511  L .756  .519  .574  r
F
P
p
.75047  .56043  m .75043  .56124  L .7504  .56162  L .756  .519  .574  r
F
P
p
.7504  .56126  m .7504  .56162  L .72794  .82511  L .756  .519  .574  r
F
P
p
.75047  .56043  m .7504  .56162  L .7504  .56126  L .756  .519  .574  r
F
P
p
.73751  .7126  m .75058  .55949  L .7375  .71256  L .759  .498  .538  r
F
P
p
.73751  .7126  m .7375  .71256  L .73643  .72514  L .759  .498  .538  r
F
P
p
.73643  .72525  m .73751  .7126  L .73643  .72514  L .759  .498  .538  r
F
P
p
.73643  .72525  m .73643  .72514  L .72804  .82334  L .759  .498  .538  r
F
P
p
.72807  .82317  m .73643  .72525  L .72804  .82334  L .759  .498  .538  r
F
P
p
.72813  .82289  m .72815  .82264  L .72807  .82317  L .759  .498  .538  r
F
P
p
.72815  .82264  m .75058  .55949  L .72807  .82317  L .759  .498  .538  r
F
P
p
.72804  .82401  m .72813  .82289  L .72795  .82432  L .759  .498  .538  r
F
P
p
.72813  .82289  m .72804  .82334  L .72795  .82432  L .759  .498  .538  r
F
P
p
.75039  .56117  m .7504  .56103  L .75039  .5612  L .756  .519  .574  r
F
P
p
.7504  .56103  m .75047  .56043  L .7504  .56126  L .756  .519  .574  r
F
P
p
.75047  .56043  m .75058  .55949  L .75043  .56124  L .756  .519  .574  r
F
P
p
.72796  .82369  m .75058  .55949  L .73174  .55722  L .759  .498  .538  r
F
P
p
.73174  .55722  m .75058  .55949  L .73177  .5557  L .759  .498  .538  r
F
P
p
.72795  .82432  m .72804  .82334  L .72796  .82369  L .759  .498  .538  r
F
P
p
.72804  .82334  m .75058  .55949  L .72796  .82369  L .759  .498  .538  r
F
P
p
.72794  .82511  m .72804  .82401  L .72795  .82432  L .759  .498  .538  r
F
P
p
.72794  .82511  m .73174  .55726  L .73871  .80808  L .759  .498  .538  r
F
P
p
.73174  .55726  m .73175  .55726  L .73871  .80808  L .759  .498  .538  r
F
P
p
.73174  .55722  m .73182  .55778  L .73871  .80808  L .759  .498  .538  r
F
P
p
.73174  .55726  m .73174  .55722  L .73175  .55726  L .759  .498  .538  r
F
P
p
.73174  .55722  m .73177  .5557  L .73182  .55778  L .759  .498  .538  r
F
P
p
.73856  .80664  m .73177  .5557  L .71121  .55251  L .759  .471  .495  r
F
P
p
.72125  .64579  m .71137  .55398  L .7316  .67676  L .759  .471  .495  r
F
P
p
.71137  .55398  m .71142  .55416  L .7316  .67676  L .759  .471  .495  r
F
P
p
.73859  .80632  m .73177  .5557  L .73857  .8065  L .759  .471  .495  r
F
P
p
.73857  .8065  m .73177  .5557  L .73856  .80664  L .759  .471  .495  r
F
P
p
.73868  .80689  m .73177  .5557  L .73862  .80722  L .759  .471  .495  r
F
P
p
.72125  .64579  m .7316  .67676  L .74988  .7879  L .759  .471  .495  r
F
P
p
.7386  .80656  m .73859  .80632  L .73858  .8069  L .759  .471  .495  r
F
P
p
.73859  .80632  m .73857  .8065  L .73858  .8069  L .759  .471  .495  r
F
P
p
.73858  .8069  m .73857  .8065  L .73856  .80664  L .759  .471  .495  r
F
P
p
.73862  .80722  m .7386  .80656  L .73858  .8069  L .759  .471  .495  r
F
P
p
.73871  .80808  m .73868  .80689  L .73862  .80722  L .759  .471  .495  r
F
P
p
.73871  .80808  m .72125  .64579  L .74988  .7879  L .759  .471  .495  r
F
P
p
.71131  .55348  m .71149  .55426  L .71153  .5545  L .759  .471  .495  r
F
P
p
.71142  .55416  m .71153  .5545  L .74988  .7879  L .759  .471  .495  r
F
P
p
.71131  .55348  m .71153  .5545  L .71142  .55416  L .759  .471  .495  r
F
P
p
.74952  .78648  m .71149  .55426  L .68927  .55014  L .755  .435  .443  r
F
P
p
.71137  .55398  m .71131  .55348  L .71142  .55416  L .759  .471  .495  r
F
P
p
.71131  .55348  m .71121  .55251  L .71149  .55426  L .759  .471  .495  r
F
P
p
.71149  .55426  m .71121  .55251  L .68927  .55014  L .755  .435  .443  r
F
P
p
.74968  .78667  m .74952  .78572  L .74965  .787  L .755  .435  .443  r
F
P
p
.74952  .78572  m .71121  .55251  L .74952  .7862  L .755  .435  .443  r
F
P
p
.74952  .78572  m .74952  .7862  L .74965  .787  L .755  .435  .443  r
F
P
p
.74965  .787  m .74952  .7862  L .74952  .78648  L .755  .435  .443  r
F
P
p
.74952  .7862  m .71121  .55251  L .74952  .78648  L .755  .435  .443  r
F
P
p
.74988  .7879  m .74968  .78667  L .74965  .787  L .755  .435  .443  r
F
P
p
.74988  .7879  m .68963  .55154  L .76112  .76467  L .755  .435  .443  r
F
P
p
.68963  .55154  m .68971  .55168  L .76112  .76467  L .755  .435  .443  r
F
P
p
.68964  .55145  m .68984  .55182  L .76112  .76467  L .755  .435  .443  r
F
P
p
.68952  .55109  m .68972  .55156  L .68964  .55145  L .755  .435  .443  r
F
P
p
.68972  .55156  m .68984  .55182  L .68964  .55145  L .755  .435  .443  r
F
P
p
.76065  .7636  m .76051  .76317  L .76053  .76332  L .744  .388  .378  r
F
P
p
.68952  .55109  m .68927  .55014  L .68984  .55182  L .755  .435  .443  r
F
P
p
.76051  .76317  m .68927  .55014  L .76053  .76332  L .744  .388  .378  r
F
P
p
.76073  .76379  m .7606  .7634  L .76065  .7636  L .744  .388  .378  r
F
P
p
.7606  .7634  m .68927  .55014  L .76065  .7636  L .744  .388  .378  r
F
P
p
.76112  .76467  m .76072  .76347  L .76073  .76379  L .744  .388  .378  r
F
P
p
.76072  .76347  m .68927  .55014  L .76073  .76379  L .744  .388  .378  r
F
P
p
.76112  .76467  m .66698  .55003  L .77205  .73857  L .744  .388  .378  r
F
P
p
.66698  .55003  m .66641  .54875  L .66734  .55041  L .744  .388  .378  r
F
P
p
.66698  .55003  m .66734  .55041  L .77205  .73857  L .744  .388  .378  r
F
P
p
.77103  .73678  m .66734  .55041  L .77114  .73713  L .722  .325  .296  r
F
P
p
.66734  .55041  m .66641  .54875  L .66734  .55041  L .722  .325  .296  r
F
P
p
.66734  .55041  m .66734  .55041  L .77114  .73713  L .722  .325  .296  r
F
P
p
.77095  .73661  m .66641  .54875  L .77103  .73678  L .722  .325  .296  r
F
P
p
.68963  .55154  m .68952  .55109  L .68971  .55168  L .755  .435  .443  r
F
P
p
.72249  .64952  m .68927  .55014  L .66641  .54875  L .744  .388  .378  r
F
P
p
.77121  .73734  m .66641  .54875  L .64313  .54837  L .722  .325  .296  r
F
P
p
.77114  .73713  m .66641  .54875  L .77121  .73734  L .722  .325  .296  r
F
P
p
.771  .73669  m .77095  .73661  L .77103  .73678  L .722  .325  .296  r
F
P
p
.77142  .73744  m .771  .73669  L .77149  .73774  L .722  .325  .296  r
F
P
p
.771  .73669  m .77114  .73713  L .77149  .73774  L .722  .325  .296  r
F
P
p
.77149  .73774  m .77114  .73713  L .77121  .73734  L .722  .325  .296  r
F
P
p
.77205  .73857  m .77142  .73744  L .77149  .73774  L .722  .325  .296  r
F
P
p
.77205  .73857  m .6439  .54952  L .78226  .70985  L .722  .325  .296  r
F
P
p
.6439  .54952  m .64403  .5496  L .78226  .70985  L .722  .325  .296  r
F
P
p
.64379  .54931  m .6443  .54974  L .78226  .70985  L .722  .325  .296  r
F
P
p
.64368  .54919  m .64385  .54934  L .64379  .54931  L .722  .325  .296  r
F
P
p
.64385  .54934  m .6443  .54974  L .64379  .54931  L .722  .325  .296  r
F
P
p
.78118  .70878  m .6443  .54974  L .61994  .54895  L .683  .239  .191  r
F
P
p
.64368  .54919  m .64313  .54837  L .6443  .54974  L .722  .325  .296  r
F
P
p
.78085  .70822  m .64313  .54837  L .78118  .70878  L .683  .239  .191  r
F
P
p
.78226  .70985  m .78085  .70822  L .78118  .70878  L .683  .239  .191  r
F
P
p
.78226  .70985  m .62093  .54993  L .79136  .67883  L .683  .239  .191  r
F
P
p
.62093  .54993  m .61994  .54895  L .62147  .55011  L .683  .239  .191  r
F
P
p
.62093  .54993  m .62147  .55011  L .79136  .67883  L .683  .239  .191  r
F
P
p
.78955  .67745  m .62147  .55011  L .79027  .67809  L .619  .126  .058  r
F
P
p
.62147  .55011  m .61994  .54895  L .62147  .55011  L .619  .126  .058  r
F
P
p
.62147  .55011  m .62147  .55011  L .79027  .67809  L .619  .126  .058  r
F
P
p
.79004  .67795  m .61994  .54895  L .59742  .55033  L .619  .126  .058  r
F
P
p
.78991  .67781  m .61994  .54895  L .79004  .67795  L .619  .126  .058  r
F
P
p
.79026  .67799  m .78955  .67745  L .79044  .67822  L .619  .126  .058  r
F
P
p
.78955  .67745  m .79027  .67809  L .79044  .67822  L .619  .126  .058  r
F
P
p
.79044  .67822  m .78991  .67781  L .79004  .67795  L .619  .126  .058  r
F
P
p
.79136  .67883  m .79026  .67799  L .79044  .67822  L .619  .126  .058  r
F
P
p
.79136  .67883  m .5986  .55112  L .79895  .64587  L .619  .126  .058  r
F
P
p
.5986  .55112  m .59876  .55114  L .79895  .64587  L .619  .126  .058  r
F
P
p
.59833  .55093  m .5992  .55118  L .79895  .64587  L .619  .126  .058  r
F
P
p
.59829  .55091  m .59836  .55093  L .59833  .55093  L .619  .126  .058  r
F
P
p
.59836  .55093  m .5992  .55118  L .59833  .55093  L .619  .126  .058  r
F
P
p
.7974  .64522  m .5992  .55118  L .57607  .55227  L .52  0 0 r
F
P
p
.59829  .55091  m .59742  .55033  L .5992  .55118  L .619  .126  .058  r
F
P
p
.79684  .64487  m .59742  .55033  L .7974  .64522  L .52  0 0 r
F
P
p
.79895  .64587  m .79684  .64487  L .7974  .64522  L .52  0 0 r
F
P
p
.79895  .64587  m .57743  .55284  L .80463  .61141  L .52  0 0 r
F
P
p
.57743  .55284  m .57607  .55227  L .57813  .5528  L .52  0 0 r
F
P
p
.57743  .55284  m .57813  .5528  L .80463  .61141  L .52  0 0 r
F
P
p
.80218  .61077  m .57813  .5528  L .80324  .61108  L .375  0 0 r
F
P
p
.57813  .5528  m .57607  .55227  L .57813  .5528  L .375  0 0 r
F
P
p
.57813  .5528  m .57813  .5528  L .80324  .61108  L .375  0 0 r
F
P
p
.80288  .61101  m .57607  .55227  L .55639  .55445  L .375  0 0 r
F
P
p
.80269  .61094  m .57607  .55227  L .80288  .61101  L .375  0 0 r
F
P
p
.80308  .61101  m .80218  .61077  L .80337  .61112  L .375  0 0 r
F
P
p
.80218  .61077  m .80324  .61108  L .80337  .61112  L .375  0 0 r
F
P
p
.80337  .61112  m .80269  .61094  L .80288  .61101  L .375  0 0 r
F
P
p
.80463  .61141  m .80308  .61101  L .80337  .61112  L .375  0 0 r
F
P
p
.80463  .61141  m .55752  .55471  L .80808  .57589  L .375  0 0 r
F
P
p
.55752  .55471  m .55639  .55445  L .55864  .55464  L .375  0 0 r
F
P
p
.55752  .55471  m .55864  .55464  L .80808  .57589  L .375  0 0 r
F
P
p
.80615  .57576  m .55864  .55464  L .53876  .55652  L .19  0 0 r
F
P
p
.80808  .57589  m .80539  .57567  L .80615  .57576  L .19  0 0 r
F
P
p
.80539  .57567  m .55639  .55445  L .80615  .57576  L .19  0 0 r
F
P
p
.78149  .56913  m .78167  .56848  L .78143  .56941  L .744  .549  .631  r
F
P
p
.78167  .56848  m .7819  .56765  L .78149  .56923  L .744  .549  .631  r
F
P
p
.78149  .56923  m .7819  .56765  L .76737  .56359  L .75  .536  .605  r
F
P
p
.79922  .56409  m .80065  .56107  L .79904  .56461  L .647  .609  .797  r
F
P
p
.80808  .57589  m .53876  .55652  L .809  .53982  L .19  0 0 r
F
P
p
.80709  .53993  m .80608  .54  L .80747  .53991  L 0 0 0 r
F
P
p
.80608  .54  m .53876  .55652  L .80742  .53992  L 0 0 0 r
F
P
p
.80608  .54  m .80742  .53992  L .80747  .53991  L 0 0 0 r
F
P
p
.55864  .55464  m .55639  .55445  L .53876  .55652  L .19  0 0 r
F
P
p
.80693  .53995  m .53876  .55652  L .52349  .55812  L 0 0 0 r
F
P
p
.80747  .53991  m .80671  .53996  L .80693  .53995  L 0 0 0 r
F
P
p
.80671  .53996  m .53876  .55652  L .80693  .53995  L 0 0 0 r
F
P
p
.809  .53982  m .80709  .53993  L .80747  .53991  L 0 0 0 r
F
P
p
.5986  .55112  m .59829  .55091  L .59876  .55114  L .619  .126  .058  r
F
P
p
.5992  .55118  m .59742  .55033  L .57607  .55227  L .52  0 0 r
F
P
p
.6439  .54952  m .64368  .54919  L .64403  .5496  L .722  .325  .296  r
F
P
p
.6443  .54974  m .64313  .54837  L .61994  .54895  L .683  .239  .191  r
F
P
p
.25  g
.004  w
.68891  .79811  m
.68902  .79785  L
s
P
p
.25  g
.004  w
.68902  .79785  m
.68973  .79613  L
s
P
p
.25  g
.004  w
.72591  .70886  m
.7276  .7048  L
s
P
p
.25  g
.004  w
.69795  .7763  m
.72591  .70886  L
s
P
p
.25  g
.004  w
.69005  .79536  m
.69795  .7763  L
s
P
p
.25  g
.004  w
.68973  .79613  m
.69005  .79536  L
s
P
p
.006  w
.68891  .79811  m
.69306  .7801  L
s
P
p
.25  g
.004  w
.70974  .73358  m
.72511  .69072  L
s
P
p
.25  g
.004  w
.69701  .76908  m
.70974  .73358  L
s
P
p
.25  g
.004  w
.69396  .77759  m
.69701  .76908  L
s
P
p
.25  g
.004  w
.71817  .68853  m
.72154  .67671  L
s
P
p
.25  g
.004  w
.7058  .73194  m
.71817  .68853  L
s
P
p
.25  g
.004  w
.69891  .75612  m
.7058  .73194  L
s
P
p
.25  g
.004  w
.69837  .75803  m
.69891  .75612  L
s
P
p
.25  g
.004  w
.67326  .52455  m
.67434  .52805  L
s
P
p
.25  g
.004  w
.67434  .52805  m
.67534  .53132  L
s
P
p
.25  g
.004  w
.67534  .53132  m
.67891  .5429  L
s
P
p
.25  g
.004  w
.67891  .5429  m
.68041  .54777  L
s
P
p
.25  g
.004  w
.69744  .52778  m
.69799  .53376  L
s
P
p
.25  g
.004  w
.69799  .53376  m
.69805  .53445  L
s
P
p
.25  g
.004  w
.69805  .53445  m
.69832  .53738  L
s
P
p
.25  g
.004  w
.69832  .53738  m
.69832  .53738  L
s
P
p
.25  g
.004  w
.69832  .53738  m
.69856  .53996  L
s
P
p
.25  g
.004  w
.69856  .53996  m
.69872  .54167  L
s
P
p
.25  g
.004  w
.69872  .54167  m
.69917  .54661  L
s
P
p
.25  g
.004  w
.70818  .64435  m
.70845  .64727  L
s
P
p
.25  g
.004  w
.70845  .64727  m
.71064  .67108  L
s
P
p
.25  g
.004  w
.71064  .67108  m
.7107  .6717  L
s
P
p
.25  g
.004  w
.72009  .53254  m
.72012  .53218  L
s
P
p
.25  g
.004  w
.71958  .5401  m
.72009  .53254  L
s
P
p
.25  g
.004  w
.71957  .54032  m
.71958  .5401  L
s
P
p
.25  g
.004  w
.7195  .54131  m
.71957  .54032  L
s
P
p
.25  g
.004  w
.71937  .54322  m
.7195  .54131  L
s
P
p
.25  g
.004  w
.71937  .54322  m
.71937  .54322  L
s
P
p
.25  g
.004  w
.71929  .54451  m
.71937  .54322  L
s
P
p
.25  g
.004  w
.71927  .5448  m
.71929  .54451  L
s
P
p
.25  g
.004  w
.71923  .54537  m
.71927  .5448  L
s
P
p
.25  g
.004  w
.70986  .68421  m
.71199  .65265  L
s
P
p
.25  g
.004  w
.70834  .70667  m
.70986  .68421  L
s
P
p
.25  g
.004  w
.70809  .71043  m
.70834  .70667  L
s
P
p
.25  g
.004  w
.74078  .53818  m
.74088  .53766  L
s
P
p
.25  g
.004  w
.74058  .53922  m
.74078  .53818  L
s
P
p
.25  g
.004  w
.73965  .5441  m
.74058  .53922  L
s
P
p
.25  g
.004  w
.71164  .69168  m
.71692  .66389  L
s
P
p
.25  g
.004  w
.70597  .7216  m
.71164  .69168  L
s
P
p
.25  g
.004  w
.70308  .73683  m
.70597  .7216  L
s
P
p
.25  g
.004  w
.6482  .52281  m
.64855  .52337  L
s
P
p
.25  g
.004  w
.64855  .52337  m
.66123  .54391  L
s
P
p
.25  g
.004  w
.66123  .54391  m
.6642  .54871  L
s
P
p
.006  w
.68777  .80347  m
.68891  .79811  L
s
P
p
.006  w
.68549  .8142  m
.68777  .80347  L
s
P
p
.21206  .76267  m .1764  .50598  L .19471  .50545  L .722  .685  .813  r
F
P
p
.21137  .77757  m .1764  .50598  L .21206  .76267  L .722  .665  .793  r
F
P
p
.25  g
.004  w
.21212  .74371  m
.21226  .74564  L
s
P
p
.006  w
.21206  .76267  m
.21226  .74564  L
s
P
p
1 0 0 r
.003  w
.41563  .55035  m
.43044  .55527  L
s
P
p
1 0 0 r
.003  w
.51152  .53294  m
.52946  .53006  L
s
P
p
.25  g
.004  w
.68566  .81384  m
.6865  .81199  L
s
P
p
.25  g
.004  w
.6865  .81199  m
.68687  .81118  L
s
P
p
.25  g
.004  w
.70764  .76551  m
.72906  .71843  L
s
P
p
.25  g
.004  w
.68724  .81036  m
.70764  .76551  L
s
P
p
.25  g
.004  w
.68687  .81118  m
.68724  .81036  L
s
P
p
.25  g
.004  w
.68549  .8142  m
.68566  .81384  L
s
P
p
.006  w
.68298  .82823  m
.68549  .8142  L
s
P
p
.21137  .77757  m .16045  .50703  L .1764  .50598  L .722  .665  .793  r
F
P
p
.25  g
.004  w
.19471  .50545  m
.19482  .50692  L
s
P
p
.21005  .79015  m .16045  .50703  L .21137  .77757  L .72  .645  .773  r
F
P
p
.25  g
.004  w
.21178  .76066  m
.21206  .76267  L
s
P
p
.006  w
.21137  .77757  m
.21206  .76267  L
s
P
p
1 0 0 r
.003  w
.39834  .54442  m
.41563  .55035  L
s
P
p
1 0 0 r
.003  w
.52946  .53006  m
.54986  .52712  L
s
P
p
.25  g
.004  w
.68298  .82823  m
.68322  .82774  L
s
P
p
.25  g
.004  w
.68322  .82774  m
.68418  .82574  L
s
P
p
.25  g
.004  w
.68418  .82574  m
.6846  .82486  L
s
P
p
.25  g
.004  w
.80829  .56778  m
.80884  .56662  L
s
P
p
.25  g
.004  w
.68985  .81396  m
.72926  .73203  L
s
P
p
.25  g
.004  w
.6846  .82486  m
.68985  .81396  L
s
P
p
.006  w
.68154  .84005  m
.68298  .82823  L
s
P
p
1 0 0 r
.003  w
.37872  .53785  m
.39834  .54442  L
s
P
p
.21005  .79015  m .14704  .50827  L .16045  .50703  L .72  .645  .773  r
F
P
p
.25  g
.004  w
.1764  .50598  m
.17666  .50785  L
s
P
p
.25  g
.004  w
.19482  .50692  m
.19487  .5076  L
s
P
p
.25  g
.004  w
.19487  .5076  m
.19488  .50769  L
s
P
p
.208  .80025  m .14704  .50827  L .21005  .79015  L .716  .625  .754  r
F
P
p
.25  g
.004  w
.21098  .77552  m
.21137  .77757  L
s
P
p
.006  w
.21005  .79015  m
.21137  .77757  L
s
P
p
1 0 0 r
.003  w
.54986  .52712  m
.5724  .52447  L
s
P
p
1 0 0 r
.003  w
.35711  .53107  m
.37872  .53785  L
s
P
p
.25  g
.004  w
.68154  .84005  m
.68188  .83936  L
s
P
p
.25  g
.004  w
.68188  .83936  m
.68297  .83716  L
s
P
p
.25  g
.004  w
.68297  .83716  m
.68344  .83621  L
s
P
p
.25  g
.004  w
.81391  .57217  m
.8144  .57118  L
s
P
p
.25  g
.004  w
.68344  .83621  m
.72898  .74405  L
s
P
p
.25  g
.004  w
.81211  .57581  m
.81391  .57217  L
s
P
p
.25  g
.004  w
.81179  .57646  m
.81211  .57581  L
s
P
p
.006  w
.68131  .84952  m
.68154  .84005  L
s
P
p
1 0 0 r
.003  w
.5724  .52447  m
.59658  .52247  L
s
P
p
.208  .80025  m .13628  .50938  L .1408  .50891  L .716  .625  .754  r
F
P
p
.20514  .80773  m .13628  .50938  L .208  .80025  L .712  .605  .735  r
F
P
p
.20514  .80773  m .12824  .51004  L .13168  .50976  L .712  .605  .735  r
F
P
p
.20443  .80462  m .13168  .50976  L .13628  .50938  L .712  .605  .735  r
F
P
p
.20514  .80773  m .13168  .50976  L .20443  .80462  L .712  .605  .735  r
F
P
p
.20142  .81241  m .12824  .51004  L .20514  .80773  L .709  .586  .716  r
F
P
p
.20142  .81241  m .19602  .79162  L .12824  .51004  L .709  .586  .716  r
F
P
p
.19602  .79162  m .12295  .51003  L .12515  .51003  L .709  .586  .716  r
F
P
p
.19602  .79162  m .12515  .51003  L .12824  .51004  L .709  .586  .716  r
F
P
p
.19681  .81416  m .19252  .79651  L .20142  .81241  L .71  .569  .694  r
F
P
p
.19252  .79651  m .12295  .51003  L .19602  .79162  L .71  .569  .694  r
F
P
p
.19252  .79651  m .19602  .79162  L .20142  .81241  L .71  .569  .694  r
F
P
p
.19681  .81416  m .12046  .50919  L .12295  .51003  L .71  .569  .694  r
F
P
p
.19134  .81285  m .12046  .50919  L .19681  .81416  L .641  .508  .685  r
F
P
p
.19012  .80761  m .12077  .50745  L .12046  .50919  L .641  .508  .685  r
F
P
p
.19027  .80828  m .19011  .80756  L .19012  .80761  L .641  .508  .685  r
F
P
p
.19011  .80756  m .12077  .50745  L .19012  .80761  L .641  .508  .685  r
F
P
p
.19013  .80761  m .19006  .80732  L .19027  .80828  L .641  .508  .685  r
F
P
p
.19006  .80732  m .12077  .50745  L .19011  .80756  L .641  .508  .685  r
F
P
p
.19006  .80732  m .19011  .80756  L .19027  .80828  L .641  .508  .685  r
F
P
p
.19106  .81161  m .19008  .80738  L .19106  .81164  L .641  .508  .685  r
F
P
p
.19008  .80738  m .12077  .50745  L .19013  .80761  L .641  .508  .685  r
F
P
p
.19008  .80738  m .19013  .80761  L .19106  .81164  L .641  .508  .685  r
F
P
p
.19106  .81164  m .19013  .80761  L .19027  .80828  L .641  .508  .685  r
F
P
p
.19134  .81285  m .19106  .81161  L .19106  .81164  L .641  .508  .685  r
F
P
p
.18508  .80837  m .12077  .50745  L .19134  .81285  L .672  .509  .656  r
F
P
p
.18441  .80526  m .12391  .50486  L .12077  .50745  L .672  .509  .656  r
F
P
p
.12408  .50577  m .12416  .5061  L .1253  .51176  L .667  .486  .631  r
F
P
p
.18437  .80484  m .12391  .50486  L .18441  .80526  L .672  .509  .656  r
F
P
p
.12416  .5061  m .12416  .50611  L .1253  .51176  L .667  .486  .631  r
F
P
p
.1253  .51176  m .12416  .50611  L .12537  .51209  L .667  .486  .631  r
F
P
p
.12517  .51116  m .12537  .51209  L .18508  .80837  L .667  .486  .631  r
F
P
p
.12408  .50577  m .12537  .51209  L .12517  .51116  L .667  .486  .631  r
F
P
p
.18508  .80837  m .18437  .80484  L .18441  .80526  L .672  .509  .656  r
F
P
p
.17812  .80063  m .15661  .66724  L .18485  .80722  L .667  .486  .631  r
F
P
p
.12456  .50841  m .12408  .50577  L .12517  .51116  L .667  .486  .631  r
F
P
p
.12456  .50841  m .12517  .51116  L .18485  .80722  L .667  .486  .631  r
F
P
p
.12408  .50577  m .12391  .50486  L .12416  .50611  L .667  .486  .631  r
F
P
p
.17764  .79798  m .12988  .50154  L .12391  .50486  L .667  .486  .631  r
F
P
p
.17762  .79749  m .12988  .50154  L .17764  .79798  L .667  .486  .631  r
F
P
p
.17812  .80063  m .17762  .79749  L .17764  .79798  L .667  .486  .631  r
F
P
p
.13134  .51086  m .13157  .512  L .17812  .80063  L .659  .459  .603  r
F
P
p
.17062  .78957  m .13084  .50834  L .17812  .80063  L .659  .459  .603  r
F
P
p
.13084  .50834  m .13134  .51086  L .17812  .80063  L .659  .459  .603  r
F
P
p
.13018  .50371  m .13031  .50421  L .13157  .512  L .659  .459  .603  r
F
P
p
.13018  .50371  m .13157  .512  L .13134  .51086  L .659  .459  .603  r
F
P
p
.13084  .50834  m .13018  .50371  L .13134  .51086  L .659  .459  .603  r
F
P
p
.13018  .50371  m .12988  .50154  L .13031  .50421  L .659  .459  .603  r
F
P
p
.17029  .78723  m .13865  .4977  L .12988  .50154  L .659  .459  .603  r
F
P
p
.17062  .78957  m .17031  .78671  L .17029  .78723  L .659  .459  .603  r
F
P
p
.17031  .78671  m .13865  .4977  L .17029  .78723  L .659  .459  .603  r
F
P
p
.16277  .77518  m .16254  .77256  L .17062  .78957  L .649  .43  .572  r
F
P
p
.16254  .77256  m .13893  .50097  L .17031  .78671  L .649  .43  .572  r
F
P
p
.16254  .77256  m .17031  .78671  L .17062  .78957  L .649  .43  .572  r
F
P
p
.1548  .7575  m .15477  .75576  L .16277  .77518  L .639  .396  .535  r
F
P
p
.13893  .50097  m .13907  .50156  L .17062  .78957  L .649  .43  .572  r
F
P
p
.1969  .74708  m .1408  .50891  L .14704  .50827  L .716  .625  .754  r
F
P
p
.208  .80025  m .1408  .50891  L .1969  .74708  L .716  .625  .754  r
F
P
p
.13893  .50097  m .13865  .4977  L .13907  .50156  L .649  .43  .572  r
F
P
p
.16259  .77307  m .15018  .49364  L .13865  .4977  L .649  .43  .572  r
F
P
p
.16277  .77518  m .16265  .77256  L .16259  .77307  L .649  .43  .572  r
F
P
p
.16265  .77256  m .15018  .49364  L .16259  .77307  L .649  .43  .572  r
F
P
p
.15477  .75576  m .15038  .50549  L .1626  .77154  L .639  .396  .535  r
F
P
p
.15477  .75576  m .1626  .77154  L .16277  .77518  L .639  .396  .535  r
F
P
p
.15038  .50549  m .15075  .50821  L .16277  .77518  L .639  .396  .535  r
F
P
p
.15023  .49679  m .15038  .49809  L .16277  .77518  L .639  .396  .535  r
F
P
p
.15038  .50549  m .15023  .49679  L .15075  .50821  L .639  .396  .535  r
F
P
p
.15023  .49679  m .15018  .49364  L .15038  .49809  L .639  .396  .535  r
F
P
p
.15477  .75559  m .16435  .48967  L .15018  .49364  L .639  .396  .535  r
F
P
p
.1548  .7575  m .15489  .75509  L .15477  .75559  L .639  .396  .535  r
F
P
p
.15489  .75509  m .16435  .48967  L .15477  .75559  L .639  .396  .535  r
F
P
p
.147  .73661  m .14715  .73444  L .1548  .7575  L .626  .358  .492  r
F
P
p
.14715  .73444  m .16419  .49192  L .15489  .75509  L .626  .358  .492  r
F
P
p
.14715  .73444  m .15489  .75509  L .1548  .7575  L .626  .358  .492  r
F
P
p
.13966  .71268  m .13992  .71126  L .147  .73661  L .612  .314  .44  r
F
P
p
.16419  .49192  m .16423  .49289  L .1548  .7575  L .626  .358  .492  r
F
P
p
.16419  .49192  m .16435  .48967  L .16423  .49289  L .626  .358  .492  r
F
P
p
.14712  .7349  m .181  .48615  L .16435  .48967  L .626  .358  .492  r
F
P
p
.147  .73661  m .14729  .73443  L .14712  .7349  L .626  .358  .492  r
F
P
p
.14729  .73443  m .181  .48615  L .14712  .7349  L .626  .358  .492  r
F
P
p
.13992  .71126  m .18068  .4879  L .14742  .73352  L .612  .314  .44  r
F
P
p
.13992  .71126  m .14742  .73352  L .147  .73661  L .612  .314  .44  r
F
P
p
.18068  .4879  m .18065  .48872  L .147  .73661  L .612  .314  .44  r
F
P
p
.18068  .4879  m .181  .48615  L .18065  .48872  L .612  .314  .44  r
F
P
p
.14001  .71074  m .19988  .48338  L .181  .48615  L .612  .314  .44  r
F
P
p
.13966  .71268  m .14039  .7099  L .14001  .71074  L .612  .314  .44  r
F
P
p
.14039  .7099  m .19988  .48338  L .14001  .71074  L .612  .314  .44  r
F
P
p
.13312  .68593  m .13353  .68468  L .13966  .71268  L .596  .263  .377  r
F
P
p
.13353  .68468  m .19942  .48478  L .14039  .7099  L .596  .263  .377  r
F
P
p
.13353  .68468  m .14039  .7099  L .13966  .71268  L .596  .263  .377  r
F
P
p
.19942  .48478  m .19933  .48548  L .13966  .71268  L .596  .263  .377  r
F
P
p
.19942  .48478  m .19988  .48338  L .19933  .48548  L .596  .263  .377  r
F
P
p
.13368  .68423  m .22069  .48166  L .19988  .48338  L .596  .263  .377  r
F
P
p
.13312  .68593  m .13416  .68349  L .13368  .68423  L .596  .263  .377  r
F
P
p
.13416  .68349  m .22069  .48166  L .13368  .68423  L .596  .263  .377  r
F
P
p
.12772  .65666  m .2201  .48276  L .13414  .68354  L .575  .202  .297  r
F
P
p
.2201  .48276  m .21996  .48336  L .13312  .68593  L .575  .202  .297  r
F
P
p
.2201  .48276  m .22069  .48166  L .21996  .48336  L .575  .202  .297  r
F
P
p
.12848  .65522  m .24301  .48119  L .22069  .48166  L .575  .202  .297  r
F
P
p
.12772  .65666  m .12908  .65459  L .12848  .65522  L .575  .202  .297  r
F
P
p
.12908  .65459  m .24301  .48119  L .12848  .65522  L .575  .202  .297  r
F
P
p
.24232  .48202  m .24226  .4822  L .12908  .65459  L .549  .129  .197  r
F
P
p
.12908  .65459  m .12908  .65459  L .12772  .65666  L .549  .129  .197  r
F
P
p
.24232  .48202  m .12908  .65459  L .12908  .65459  L .549  .129  .197  r
F
P
p
.24226  .4822  m .24206  .48264  L .12772  .65666  L .549  .129  .197  r
F
P
p
.12381  .62523  m .24232  .48202  L .12772  .65666  L .549  .129  .197  r
F
P
p
.24226  .4822  m .24213  .48253  L .24206  .48264  L .549  .129  .197  r
F
P
p
.24232  .48202  m .24301  .48119  L .24213  .48253  L .549  .129  .197  r
F
P
p
.12477  .62406  m .26641  .48208  L .24301  .48119  L .549  .129  .197  r
F
P
p
.12381  .62523  m .12547  .62356  L .12477  .62406  L .549  .129  .197  r
F
P
p
.12547  .62356  m .26641  .48208  L .12477  .62406  L .549  .129  .197  r
F
P
p
.12172  .59206  m .12257  .59141  L .12381  .62523  L .513  .041  .072  r
F
P
p
.12257  .59141  m .2656  .4827  L .12547  .62356  L .513  .041  .072  r
F
P
p
.12257  .59141  m .12547  .62356  L .12381  .62523  L .513  .041  .072  r
F
P
p
.2656  .4827  m .26522  .48327  L .12381  .62523  L .513  .041  .072  r
F
P
p
.2656  .4827  m .26641  .48208  L .26522  .48327  L .513  .041  .072  r
F
P
p
.12287  .59118  m .29038  .48434  L .26641  .48208  L .513  .041  .072  r
F
P
p
.12172  .59206  m .12365  .59082  L .12287  .59118  L .513  .041  .072  r
F
P
p
.12365  .59082  m .29038  .48434  L .12287  .59118  L .513  .041  .072  r
F
P
p
.12175  .55761  m .12272  .55719  L .12172  .59206  L .465  0 0 r
F
P
p
.12272  .55719  m .28942  .48475  L .12365  .59082  L .465  0 0 r
F
P
p
.12272  .55719  m .12365  .59082  L .12172  .59206  L .465  0 0 r
F
P
p
.28942  .48475  m .28896  .48525  L .12172  .59206  L .465  0 0 r
F
P
p
.28942  .48475  m .29038  .48434  L .28896  .48525  L .465  0 0 r
F
P
p
.12306  .55704  m .3144  .48786  L .29038  .48434  L .465  0 0 r
F
P
p
.12175  .55761  m .12392  .55683  L .12306  .55704  L .465  0 0 r
F
P
p
.12392  .55683  m .3144  .48786  L .12306  .55704  L .465  0 0 r
F
P
p
.12415  .52241  m .12524  .52221  L .12175  .55761  L .401  0 0 r
F
P
p
.12524  .52221  m .31329  .48806  L .12392  .55682  L .401  0 0 r
F
P
p
.12524  .52221  m .12392  .55682  L .12175  .55761  L .401  0 0 r
F
P
p
.31329  .48806  m .31274  .48846  L .12175  .55761  L .401  0 0 r
F
P
p
.31329  .48806  m .3144  .48786  L .31274  .48846  L .401  0 0 r
F
P
p
.1256  .52214  m .33793  .49244  L .3144  .48786  L .401  0 0 r
F
P
p
.12415  .52241  m .12652  .52207  L .1256  .52214  L .401  0 0 r
F
P
p
.12652  .52207  m .33793  .49244  L .1256  .52214  L .401  0 0 r
F
P
p
.12914  .48695  m .13031  .48698  L .12415  .52241  L .32  0 0 r
F
P
p
.13031  .48698  m .33669  .4924  L .12652  .52207  L .32  0 0 r
F
P
p
.13031  .48698  m .12652  .52207  L .12415  .52241  L .32  0 0 r
F
P
p
.33669  .4924  m .33606  .4927  L .12415  .52241  L .32  0 0 r
F
P
p
.33669  .4924  m .33793  .49244  L .33606  .4927  L .32  0 0 r
F
P
p
.12914  .48695  m .36047  .49777  L .33793  .49244  L .32  0 0 r
F
P
p
.13685  .45177  m .35913  .49749  L .12914  .48695  L .233  0 0 r
F
P
p
.35913  .49749  m .36047  .49777  L .35841  .49767  L .233  0 0 r
F
P
p
.35913  .49749  m .35841  .49767  L .12914  .48695  L .233  0 0 r
F
P
p
.13685  .45177  m .38157  .50348  L .36047  .49777  L .233  0 0 r
F
P
p
.14737  .41736  m .38014  .50296  L .13685  .45177  L 0 .42  .738  r
F
P
p
.38014  .50296  m .38157  .50348  L .37936  .50302  L 0 .42  .738  r
F
P
p
.38014  .50296  m .37936  .50302  L .13685  .45177  L 0 .42  .738  r
F
P
p
.12772  .65666  m .13414  .68354  L .13312  .68593  L .575  .202  .297  r
F
P
p
.18449  .80772  m .18485  .80722  L .18508  .80837  L .667  .486  .631  r
F
P
p
.17812  .80063  m .18485  .80722  L .18449  .80772  L .667  .486  .631  r
F
P
p
.25  g
.004  w
.16377  .62087  m
.20343  .78171  L
s
P
p
.25  g
.004  w
.20343  .78171  m
.20756  .79845  L
s
P
p
.25  g
.004  w
.20756  .79845  m
.208  .80025  L
s
P
p
.006  w
.208  .80025  m
.21005  .79015  L
s
P
p
.25  g
.004  w
.16837  .6037  m
.19386  .71774  L
s
P
p
.25  g
.004  w
.19386  .71774  m
.20961  .78815  L
s
P
p
.25  g
.004  w
.20961  .78815  m
.21005  .79015  L
s
P
p
.25  g
.004  w
.17551  .58705  m
.18843  .65572  L
s
P
p
.25  g
.004  w
.18843  .65572  m
.20474  .74234  L
s
P
p
.25  g
.004  w
.20474  .74234  m
.21098  .77552  L
s
P
p
.25  g
.004  w
.18518  .56921  m
.21134  .75748  L
s
P
p
.25  g
.004  w
.21134  .75748  m
.21178  .76066  L
s
P
p
.25  g
.004  w
.19802  .55073  m
.21212  .74371  L
s
P
p
.006  w
.20514  .80773  m
.208  .80025  L
s
P
p
1 0 0 r
.003  w
.33395  .52451  m
.35711  .53107  L
s
P
p
1 0 0 r
.003  w
.59658  .52247  m
.62183  .52144  L
s
P
p
.25  g
.004  w
.68131  .84952  m
.68181  .84852  L
s
P
p
.25  g
.004  w
.68181  .84852  m
.68306  .84599  L
s
P
p
.25  g
.004  w
.68306  .84599  m
.68363  .84483  L
s
P
p
.25  g
.004  w
.81696  .5753  m
.81735  .57453  L
s
P
p
.25  g
.004  w
.68363  .84483  m
.72758  .75599  L
s
P
p
.25  g
.004  w
.81615  .57694  m
.81696  .5753  L
s
P
p
.006  w
.68131  .84952  m
.68239  .85651  L
s
P
p
1 0 0 r
.003  w
.30978  .51856  m
.33395  .52451  L
s
P
p
1 0 0 r
.003  w
.62183  .52144  m
.64747  .52162  L
s
P
p
.25  g
.004  w
.1607  .63569  m
.20482  .80647  L
s
P
p
.25  g
.004  w
.20482  .80647  m
.20514  .80773  L
s
P
p
.006  w
.20142  .81241  m
.20514  .80773  L
s
P
p
1 0 0 r
.003  w
.64747  .52162  m
.67284  .52317  L
s
P
p
1 0 0 r
.003  w
.28522  .51356  m
.30978  .51856  L
s
P
p
1 0 0 r
.003  w
.67284  .52317  m
.69728  .52611  L
s
P
p
1 0 0 r
.003  w
.28243  .51312  m
.28522  .51356  L
s
P
p
1 0 0 r
.003  w
.26088  .50971  m
.28243  .51312  L
s
P
p
1 0 0 r
.003  w
.69728  .52611  m
.72024  .53033  L
s
P
p
.25  g
.004  w
.81748  .57705  m
.81774  .57652  L
s
P
p
.25  g
.004  w
.81709  .57785  m
.81748  .57705  L
s
P
p
.25  g
.004  w
.81672  .57862  m
.81709  .57785  L
s
P
p
.25  g
.004  w
.81636  .57935  m
.81672  .57862  L
s
P
p
.25  g
.004  w
.81605  .58001  m
.81636  .57935  L
s
P
p
.25  g
.004  w
.80558  .60167  m
.81605  .58001  L
s
P
p
.006  w
.68239  .85651  m
.68486  .86088  L
s
P
p
1 0 0 r
.003  w
.72024  .53033  m
.74126  .53563  L
s
P
p
1 0 0 r
.003  w
.74126  .53563  m
.74947  .5383  L
s
P
p
1 0 0 r
.003  w
.74947  .5383  m
.75999  .54172  L
s
P
p
1 0 0 r
.003  w
.25564  .50913  m
.26088  .50971  L
s
P
p
1 0 0 r
.003  w
.81559  .5771  m
.81621  .57693  L
s
P
p
1 0 0 r
.003  w
.81621  .57693  m
.81774  .57652  L
s
P
p
1 0 0 r
.003  w
.81735  .57453  m
.81774  .57652  L
s
P
p
1 0 0 r
.003  w
.8144  .57118  m
.81735  .57453  L
s
P
p
.25  g
.004  w
.81517  .57802  m
.81559  .5771  L
s
P
p
.25  g
.004  w
.81484  .57872  m
.81517  .57802  L
s
P
p
.25  g
.004  w
.81453  .5794  m
.81484  .57872  L
s
P
p
.25  g
.004  w
.81425  .58001  m
.81453  .5794  L
s
P
p
.25  g
.004  w
.81404  .58047  m
.81425  .58001  L
s
P
p
.25  g
.004  w
.81404  .58047  m
.81404  .58047  L
s
P
p
.25  g
.004  w
.81393  .58069  m
.81404  .58047  L
s
P
p
.25  g
.004  w
.80593  .59808  m
.81393  .58069  L
s
P
p
1 0 0 r
.003  w
.81092  .57632  m
.81559  .5771  L
s
P
p
1 0 0 r
.003  w
.80884  .56662  m
.8144  .57118  L
s
P
p
.25  g
.004  w
.81015  .57813  m
.81092  .57632  L
s
P
p
.25  g
.004  w
.8099  .57872  m
.81015  .57813  L
s
P
p
.25  g
.004  w
.8097  .57918  m
.8099  .57872  L
s
P
p
.25  g
.004  w
.8097  .57918  m
.8097  .57918  L
s
P
p
.25  g
.004  w
.80961  .57939  m
.8097  .57918  L
s
P
p
.25  g
.004  w
.80719  .58507  m
.80961  .57939  L
s
P
p
1 0 0 r
.003  w
.80809  .57553  m
.81092  .57632  L
s
P
p
1 0 0 r
.003  w
.80832  .56627  m
.80884  .56662  L
s
P
p
1 0 0 r
.003  w
.75999  .54172  m
.76241  .5427  L
s
P
p
.25  g
.004  w
.20019  .80768  m
.20142  .81241  L
s
P
p
.25  g
.004  w
.19602  .79162  m
.20019  .80768  L
s
P
p
.25  g
.004  w
.15893  .64869  m
.19602  .79162  L
s
P
p
.006  w
.19681  .81416  m
.20142  .81241  L
s
P
p
.25  g
.004  w
.17022  .78587  m
.17062  .78957  L
s
P
p
.25  g
.004  w
.1702  .78567  m
.17022  .78587  L
s
P
p
.25  g
.004  w
.15844  .67835  m
.1702  .78567  L
s
P
p
.25  g
.004  w
.17748  .79665  m
.17812  .80063  L
s
P
p
.25  g
.004  w
.17744  .7964  m
.17748  .79665  L
s
P
p
.25  g
.004  w
.15853  .67914  m
.17744  .7964  L
s
P
p
1 0 0 r
.003  w
.12391  .50486  m
.12685  .50322  L
s
P
p
.25  g
.004  w
.16262  .77171  m
.16277  .77518  L
s
P
p
.25  g
.004  w
.16261  .77155  m
.16262  .77171  L
s
P
p
.25  g
.004  w
.15799  .66822  m
.16261  .77155  L
s
P
p
.25  g
.004  w
.18419  .80395  m
.18485  .80722  L
s
P
p
.25  g
.004  w
.18413  .80368  m
.18419  .80395  L
s
P
p
.25  g
.004  w
.15831  .67557  m
.18413  .80368  L
s
P
p
.25  g
.004  w
.18485  .80722  m
.18508  .80837  L
s
P
p
1 0 0 r
.003  w
.12077  .50745  m
.12391  .50486  L
s
P
p
.25  g
.004  w
.19008  .80738  m
.19134  .81285  L
s
P
p
.25  g
.004  w
.19004  .80723  m
.19008  .80738  L
s
P
p
.25  g
.004  w
.158  .66856  m
.19004  .80723  L
s
P
p
1 0 0 r
.003  w
.12046  .50919  m
.12077  .50745  L
s
P
p
.25  g
.004  w
.19313  .79947  m
.19681  .81416  L
s
P
p
.25  g
.004  w
.15827  .66022  m
.19313  .79947  L
s
P
p
.25  g
.004  w
.1548  .7575  m
.15492  .75426  L
s
P
p
.25  g
.004  w
.15492  .75426  m
.15492  .75413  L
s
P
p
.25  g
.004  w
.15492  .75413  m
.15859  .6512  L
s
P
p
.25  g
.004  w
.147  .73661  m
.1474  .73362  L
s
P
p
.25  g
.004  w
.1474  .73362  m
.14742  .73352  L
s
P
p
.25  g
.004  w
.14742  .73352  m
.16157  .62924  L
s
P
p
.25  g
.004  w
.13966  .71268  m
.14037  .70998  L
s
P
p
.25  g
.004  w
.14037  .70998  m
.14039  .7099  L
s
P
p
.25  g
.004  w
.14039  .7099  m
.16814  .60422  L
s
P
p
.006  w
.68486  .86088  m
.68875  .86248  L
s
P
p
.25  g
.004  w
.13312  .68593  m
.13414  .68354  L
s
P
p
.25  g
.004  w
.13414  .68354  m
.13416  .68349  L
s
P
p
.25  g
.004  w
.13416  .68349  m
.17935  .57808  L
s
P
p
.25  g
.004  w
.12772  .65666  m
.12906  .65463  L
s
P
p
.25  g
.004  w
.12906  .65463  m
.12908  .65459  L
s
P
p
.25  g
.004  w
.12908  .65459  m
.19596  .5528  L
s
P
p
1 0 0 r
.003  w
.64313  .54837  m
.66489  .54873  L
s
P
p
.006  w
.19134  .81285  m
.19681  .81416  L
s
P
p
.25  g
.004  w
.12381  .62523  m
.12545  .62358  L
s
P
p
.25  g
.004  w
.12545  .62358  m
.12547  .62356  L
s
P
p
.25  g
.004  w
.12547  .62356  m
.21831  .53037  L
s
P
p
.25  g
.004  w
.64313  .54837  m
.6443  .54974  L
s
P
p
.25  g
.004  w
.6443  .54974  m
.64435  .5498  L
s
P
p
.25  g
.004  w
.64435  .5498  m
.64452  .54998  L
s
P
p
1 0 0 r
.003  w
.61994  .54895  m
.62075  .54893  L
s
P
p
1 0 0 r
.003  w
.62075  .54893  m
.64313  .54837  L
s
P
p
.25  g
.004  w
.12172  .59206  m
.12364  .59083  L
s
P
p
.25  g
.004  w
.12364  .59083  m
.12365  .59082  L
s
P
p
.006  w
.68875  .86248  m
.69407  .86119  L
s
P
p
.25  g
.004  w
.12175  .55761  m
.12391  .55683  L
s
P
p
.25  g
.004  w
.61994  .54895  m
.62  .549  L
s
P
p
.25  g
.004  w
.62  .549  m
.62143  .55008  L
s
P
p
.25  g
.004  w
.62143  .55008  m
.62147  .55011  L
s
P
p
.25  g
.004  w
.62147  .55011  m
.62306  .55131  L
s
P
p
1 0 0 r
.003  w
.59742  .55033  m
.61994  .54895  L
s
P
p
.006  w
.18508  .80837  m
.19134  .81285  L
s
P
p
.25  g
.004  w
.12415  .52241  m
.12652  .52207  L
s
P
p
.25  g
.004  w
.59742  .55033  m
.59864  .55092  L
s
P
p
.25  g
.004  w
.59864  .55092  m
.5992  .55118  L
s
P
p
.25  g
.004  w
.5992  .55118  m
.59922  .55119  L
s
P
p
.25  g
.004  w
.59922  .55119  m
.6022  .5526  L
s
P
p
1 0 0 r
.003  w
.57607  .55227  m
.59742  .55033  L
s
P
p
.006  w
.69407  .86119  m
.70077  .8569  L
s
P
p
.25  g
.004  w
.12914  .48695  m
.13167  .48707  L
s
P
p
.006  w
.17812  .80063  m
.18508  .80837  L
s
P
p
.25  g
.004  w
.57607  .55227  m
.57812  .5528  L
s
P
p
.25  g
.004  w
.57812  .5528  m
.57813  .5528  L
s
P
p
.25  g
.004  w
.57813  .5528  m
.58214  .55384  L
s
P
p
1 0 0 r
.003  w
.55639  .55445  m
.57607  .55227  L
s
P
p
.14737  .41736  m .40087  .50918  L .38157  .50348  L 0 .42  .738  r
F
P
p
.25  g
.004  w
.38152  .50347  m
.38157  .50348  L
s
P
p
.25  g
.004  w
.38008  .50317  m
.38152  .50347  L
s
P
p
.25  g
.004  w
.37936  .50302  m
.38008  .50317  L
s
P
p
.006  w
.70077  .8569  m
.70875  .8495  L
s
P
p
.25  g
.004  w
.55639  .55445  m
.55864  .55464  L
s
P
p
.25  g
.004  w
.55864  .55464  m
.56306  .55502  L
s
P
p
1 0 0 r
.003  w
.53876  .55652  m
.55639  .55445  L
s
P
p
.006  w
.17062  .78957  m
.17812  .80063  L
s
P
p
.16071  .3842  m .40087  .50918  L .14737  .41736  L 0 .435  .808  r
F
P
p
.25  g
.004  w
.13685  .45177  m
.13948  .45233  L
s
P
p
.16071  .3842  m .41807  .51445  L .40087  .50918  L 0 .435  .808  r
F
P
p
1 0 0 r
.003  w
.38157  .50348  m
.40087  .50918  L
s
P
p
.25  g
.004  w
.39855  .50834  m
.3993  .50861  L
s
P
p
.25  g
.004  w
.3993  .50861  m
.40085  .50917  L
s
P
p
.25  g
.004  w
.40085  .50917  m
.40087  .50918  L
s
P
p
.006  w
.70875  .8495  m
.71787  .83891  L
s
P
p
.006  w
.16277  .77518  m
.17062  .78957  L
s
P
p
.17681  .35269  m .41807  .51445  L .16071  .3842  L 0 .422  .838  r
F
P
p
.25  g
.004  w
.14737  .41736  m
.15004  .41833  L
s
P
p
.17681  .35269  m .433  .51891  L .41807  .51445  L 0 .422  .838  r
F
P
p
1 0 0 r
.003  w
.40087  .50918  m
.41807  .51445  L
s
P
p
.25  g
.004  w
.41569  .51324  m
.41644  .51362  L
s
P
p
.25  g
.004  w
.41644  .51362  m
.41802  .51442  L
s
P
p
.25  g
.004  w
.41802  .51442  m
.41807  .51445  L
s
P
p
.80716  .50366  m .52349  .55812  L .51076  .55892  L .211  .736  .79  r
F
P
p
.25  g
.004  w
.53876  .55652  m
.54118  .55637  L
s
P
p
.809  .53982  m .52349  .55812  L .80716  .50366  L 0 0 0 r
F
P
p
.006  w
.71787  .83891  m
.72794  .82511  L
s
P
p
.006  w
.1548  .7575  m
.16277  .77518  L
s
P
p
.19555  .32321  m .433  .51891  L .17681  .35269  L 0 .389  .838  r
F
P
p
.25  g
.004  w
.16071  .3842  m
.16336  .38554  L
s
P
p
.19555  .32321  m .44562  .52227  L .433  .51891  L 0 .389  .838  r
F
P
p
1 0 0 r
.003  w
.41807  .51445  m
.433  .51891  L
s
P
p
.25  g
.004  w
.43062  .51737  m
.43132  .51782  L
s
P
p
.25  g
.004  w
.43132  .51782  m
.43287  .51882  L
s
P
p
.25  g
.004  w
.43287  .51882  m
.433  .51891  L
s
P
p
.80242  .4679  m .51076  .55892  L .5006  .55864  L .376  .842  .862  r
F
P
p
.25  g
.004  w
.52349  .55812  m
.526  .55764  L
s
P
p
.80716  .50366  m .51076  .55892  L .80242  .4679  L .211  .736  .79  r
F
P
p
1 0 0 r
.003  w
.51076  .55892  m
.52349  .55812  L
s
P
p
.25  g
.004  w
.80513  .50405  m
.80716  .50366  L
s
P
p
.25  g
.004  w
.8041  .50425  m
.80513  .50405  L
s
P
p
.006  w
.72794  .82511  m
.73871  .80808  L
s
P
p
.006  w
.147  .73661  m
.1548  .7575  L
s
P
p
.21679  .29606  m .44562  .52227  L .19555  .32321  L 0 .342  .819  r
F
P
p
.25  g
.004  w
.17681  .35269  m
.17939  .35437  L
s
P
p
.21679  .29606  m .45598  .5243  L .44562  .52227  L 0 .342  .819  r
F
P
p
1 0 0 r
.003  w
.433  .51891  m
.44562  .52227  L
s
P
p
.25  g
.004  w
.44391  .5209  m
.44534  .52204  L
s
P
p
.25  g
.004  w
.44329  .52041  m
.44391  .5209  L
s
P
p
.25  g
.004  w
.44534  .52204  m
.44562  .52227  L
s
P
p
.006  w
.73871  .80808  m
.74988  .7879  L
s
P
p
.79468  .433  m .5006  .55864  L .49293  .5571  L .507  .91  .894  r
F
P
p
.25  g
.004  w
.51076  .55892  m
.51329  .55813  L
s
P
p
.25  g
.004  w
.526  .55764  m
.52604  .55763  L
s
P
p
.80242  .4679  m .5006  .55864  L .79468  .433  L .376  .842  .862  r
F
P
p
1 0 0 r
.003  w
.5006  .55864  m
.51076  .55892  L
s
P
p
.25  g
.004  w
.8003  .46856  m
.80242  .4679  L
s
P
p
.25  g
.004  w
.79926  .46889  m
.8003  .46856  L
s
P
p
.006  w
.13966  .71268  m
.147  .73661  L
s
P
p
.24032  .27149  m .45598  .5243  L .21679  .29606  L 0 .285  .785  r
F
P
p
.25  g
.004  w
.19555  .32321  m
.19801  .32517  L
s
P
p
.24032  .27149  m .46422  .52493  L .45598  .5243  L 0 .285  .785  r
F
P
p
1 0 0 r
.003  w
.44562  .52227  m
.45598  .5243  L
s
P
p
.25  g
.004  w
.45552  .52386  m
.45598  .5243  L
s
P
p
.25  g
.004  w
.45426  .52266  m
.45552  .52386  L
s
P
p
.25  g
.004  w
.45375  .52218  m
.45426  .52266  L
s
P
p
.006  w
.74988  .7879  m
.76112  .76467  L
s
P
p
.006  w
.13312  .68593  m
.13966  .71268  L
s
P
p
.78393  .39936  m .49293  .5571  L .48754  .55424  L .609  .953  .898  r
F
P
p
.25  g
.004  w
.5006  .55864  m
.50309  .55758  L
s
P
p
.25  g
.004  w
.51329  .55813  m
.51337  .5581  L
s
P
p
.79468  .433  m .49293  .5571  L .78393  .39936  L .507  .91  .894  r
F
P
p
1 0 0 r
.003  w
.49293  .5571  m
.5006  .55864  L
s
P
p
.25  g
.004  w
.79252  .43392  m
.79468  .433  L
s
P
p
.25  g
.004  w
.79148  .43436  m
.79252  .43392  L
s
P
p
.2659  .24968  m .46422  .52493  L .24032  .27149  L 0 .218  .741  r
F
P
p
.25  g
.004  w
.21679  .29606  m
.21908  .29824  L
s
P
p
.25  g
.004  w
.12365  .59082  m
.24621  .51255  L
s
P
p
.2659  .24968  m .47059  .5242  L .46422  .52493  L 0 .218  .741  r
F
P
p
1 0 0 r
.003  w
.45598  .5243  m
.46422  .52493  L
s
P
p
.25  g
.004  w
.46357  .52419  m
.46422  .52493  L
s
P
p
.25  g
.004  w
.46253  .52302  m
.46357  .52419  L
s
P
p
.25  g
.004  w
.46215  .52259  m
.46253  .52302  L
s
P
p
.006  w
.76112  .76467  m
.77205  .73857  L
s
P
p
.006  w
.12772  .65666  m
.13312  .68593  L
s
P
p
.48014  .18137  m .485  .50708  L .4477  .18192  L 0 0 .111  r
F
P
p
.48014  .18137  m .48545  .50575  L .485  .50708  L 0 0 .111  r
F
P
p
.51247  .18387  m .48545  .50575  L .48014  .18137  L 0 0 .003  r
F
P
p
.51247  .18387  m .48562  .50574  L .48545  .50575  L 0 0 .003  r
F
P
p
.54441  .18939  m .48562  .50574  L .51247  .18387  L 0 0 .21  r
F
P
p
.006  w
.48014  .18137  m
.51247  .18387  L
s
P
p
.4477  .18192  m .48422  .50948  L .41541  .18554  L 0 0 .231  r
F
P
p
.4477  .18192  m .485  .50708  L .48422  .50948  L 0 0 .231  r
F
P
p
.006  w
.4477  .18192  m
.48014  .18137  L
s
P
p
.25  g
.004  w
.4477  .18192  m
.44789  .18359  L
s
P
p
.54441  .18939  m .48549  .50718  L .48562  .50574  L 0 0 .21  r
F
P
p
.5757  .1979  m .48549  .50718  L .54441  .18939  L .893  .853  .401  r
F
P
p
.006  w
.51247  .18387  m
.54441  .18939  L
s
P
p
.77024  .36735  m .48754  .55424  L .48413  .55011  L .687  .979  .884  r
F
P
p
.25  g
.004  w
.50309  .55758  m
.50323  .55752  L
s
P
p
.25  g
.004  w
.49293  .5571  m
.49532  .55581  L
s
P
p
.78393  .39936  m .48754  .55424  L .77024  .36735  L .609  .953  .898  r
F
P
p
1 0 0 r
.003  w
.48754  .55424  m
.49293  .5571  L
s
P
p
.25  g
.004  w
.7839  .39938  m
.78393  .39936  L
s
P
p
.25  g
.004  w
.78177  .40053  m
.7839  .39938  L
s
P
p
.25  g
.004  w
.78076  .40108  m
.78177  .40053  L
s
P
p
.41541  .18554  m .48303  .51262  L .38355  .19223  L 0 0 .346  r
F
P
p
.41541  .18554  m .48422  .50948  L .48303  .51262  L 0 0 .346  r
F
P
p
.006  w
.41541  .18554  m
.4477  .18192  L
s
P
p
.25  g
.004  w
.41541  .18554  m
.41586  .18767  L
s
P
p
.5757  .1979  m .48509  .51008  L .48549  .50718  L .893  .853  .401  r
F
P
p
.25  g
.004  w
.48754  .55424  m
.49252  .55095  L
s
P
p
.60605  .20939  m .48509  .51008  L .5757  .1979  L .883  .895  .474  r
F
P
p
.006  w
.54441  .18939  m
.5757  .1979  L
s
P
p
.25  g
.004  w
.51114  .19986  m
.51247  .18387  L
s
P
p
.25  g
.004  w
.54321  .19586  m
.54441  .18939  L
s
P
p
.38355  .19223  m .48131  .51609  L .35239  .20201  L 0 0 .45  r
F
P
p
.38355  .19223  m .48303  .51262  L .48131  .51609  L 0 0 .45  r
F
P
p
.006  w
.38355  .19223  m
.41541  .18554  L
s
P
p
.25  g
.004  w
.38355  .19223  m
.38412  .19408  L
s
P
p
.25  g
.004  w
.38412  .19408  m
.38428  .19459  L
s
P
p
.60605  .20939  m .48443  .51433  L .48509  .51008  L .883  .895  .474  r
F
P
p
.63521  .2238  m .48443  .51433  L .60605  .20939  L .884  .936  .563  r
F
P
p
.25  g
.004  w
.5744  .20239  m
.5757  .1979  L
s
P
p
.006  w
.5757  .1979  m
.60605  .20939  L
s
P
p
.25  g
.004  w
.48014  .18137  m
.48032  .19234  L
s
P
p
.25  g
.004  w
.60291  .21727  m
.60605  .20939  L
s
P
p
.006  w
.12381  .62523  m
.12772  .65666  L
s
P
p
.006  w
.77205  .73857  m
.78226  .70985  L
s
P
p
.35239  .20201  m .47883  .51945  L .32221  .21487  L 0 0 .542  r
F
P
p
.25  g
.004  w
.24032  .27149  m
.24145  .27277  L
s
P
p
.35239  .20201  m .48131  .51609  L .47883  .51945  L 0 0 .542  r
F
P
p
.006  w
.35239  .20201  m
.38355  .19223  L
s
P
p
.25  g
.004  w
.35239  .20201  m
.35273  .20285  L
s
P
p
.25  g
.004  w
.35273  .20285  m
.35325  .20412  L
s
P
p
.25  g
.004  w
.35325  .20412  m
.35341  .2045  L
s
P
p
.25  g
.004  w
.48015  .51328  m
.48031  .51367  L
s
P
p
.25  g
.004  w
.48031  .51367  m
.48077  .51477  L
s
P
p
.25  g
.004  w
.48077  .51477  m
.48131  .51609  L
s
P
p
.29329  .23078  m .47059  .5242  L .2659  .24968  L 0 .141  .686  r
F
P
p
.25  g
.004  w
.26685  .25095  m
.26761  .25198  L
s
P
p
.25  g
.004  w
.2659  .24968  m
.26685  .25095  L
s
P
p
.25  g
.004  w
.24145  .27277  m
.2424  .27384  L
s
P
p
.25  g
.004  w
.12391  .55683  m
.2789  .50071  L
s
P
p
.29329  .23078  m .47536  .52228  L .47059  .5242  L 0 .141  .686  r
F
P
p
1 0 0 r
.003  w
.46422  .52493  m
.47059  .5242  L
s
P
p
.25  g
.004  w
.46976  .52309  m
.47059  .5242  L
s
P
p
.25  g
.004  w
.46896  .52202  m
.46976  .52309  L
s
P
p
.25  g
.004  w
.46872  .5217  m
.46896  .52202  L
s
P
p
.63521  .2238  m .48358  .51968  L .48443  .51433  L .884  .936  .563  r
F
P
p
.6629  .2411  m .48358  .51968  L .63521  .2238  L .877  .967  .644  r
F
P
p
.25  g
.004  w
.57432  .20264  m
.5744  .20239  L
s
P
p
.006  w
.60605  .20939  m
.63521  .2238  L
s
P
p
.32221  .21487  m .47536  .52228  L .29329  .23078  L 0 .056  .62  r
F
P
p
.25  g
.004  w
.26761  .25198  m
.26774  .25215  L
s
P
p
.25  g
.004  w
.12652  .52207  m
.31505  .49564  L
s
P
p
.32221  .21487  m .47883  .51945  L .47536  .52228  L 0 .056  .62  r
F
P
p
.006  w
.32221  .21487  m
.35239  .20201  L
s
P
p
.25  g
.004  w
.13167  .48707  m
.35283  .49741  L
s
P
p
.25  g
.004  w
.13948  .45233  m
.37936  .50302  L
s
P
p
.25  g
.004  w
.15004  .41833  m
.39855  .50834  L
s
P
p
.25  g
.004  w
.19801  .32517  m
.44329  .52041  L
s
P
p
.25  g
.004  w
.17939  .35437  m
.43062  .51737  L
s
P
p
.25  g
.004  w
.16336  .38554  m
.41569  .51324  L
s
P
p
.25  g
.004  w
.2424  .27384  m
.46215  .52259  L
s
P
p
.25  g
.004  w
.21908  .29824  m
.45375  .52218  L
s
P
p
.25  g
.004  w
.35341  .2045  m
.48015  .51328  L
s
P
p
.25  g
.004  w
.26774  .25215  m
.46872  .5217  L
s
P
p
1 0 0 r
.003  w
.47059  .5242  m
.47536  .52228  L
s
P
p
.25  g
.004  w
.32221  .21487  m
.32276  .21594  L
s
P
p
.25  g
.004  w
.32276  .21594  m
.32336  .21712  L
s
P
p
.25  g
.004  w
.32336  .21712  m
.32351  .21741  L
s
P
p
.25  g
.004  w
.32351  .21741  m
.47747  .51681  L
s
P
p
.25  g
.004  w
.47747  .51681  m
.47748  .51681  L
s
P
p
.25  g
.004  w
.47748  .51681  m
.47782  .51747  L
s
P
p
.25  g
.004  w
.47782  .51747  m
.47857  .51893  L
s
P
p
.25  g
.004  w
.47857  .51893  m
.47883  .51945  L
s
P
p
.006  w
.29329  .23078  m
.32221  .21487  L
s
P
p
.6629  .2411  m .4827  .52582  L .48358  .51968  L .877  .967  .644  r
F
P
p
.68884  .26121  m .4827  .52582  L .6629  .2411  L .86  .987  .713  r
F
P
p
.25  g
.004  w
.63343  .22729  m
.63521  .2238  L
s
P
p
.006  w
.63521  .2238  m
.6629  .2411  L
s
P
p
.25  g
.004  w
.65175  .25871  m
.6629  .2411  L
s
P
p
.25  g
.004  w
.4744  .52075  m
.47536  .52228  L
s
P
p
.25  g
.004  w
.47384  .51985  m
.4744  .52075  L
s
P
p
.25  g
.004  w
.47373  .51968  m
.47384  .51985  L
s
P
p
.25  g
.004  w
.29329  .23078  m
.29404  .23198  L
s
P
p
.25  g
.004  w
.29404  .23198  m
.29473  .23308  L
s
P
p
.25  g
.004  w
.29473  .23308  m
.29487  .23331  L
s
P
p
.25  g
.004  w
.29487  .23331  m
.47373  .51968  L
s
P
p
.006  w
.2659  .24968  m
.29329  .23078  L
s
P
p
.006  w
.12172  .59206  m
.12381  .62523  L
s
P
p
.68884  .26121  m .48199  .53234  L .4827  .52582  L .86  .987  .713  r
F
P
p
.71279  .28403  m .48199  .53234  L .68884  .26121  L .833  .997  .771  r
F
P
p
.25  g
.004  w
.61145  .27016  m
.63332  .22748  L
s
P
p
.25  g
.004  w
.63332  .22748  m
.63343  .22729  L
s
P
p
.006  w
.6629  .2411  m
.68884  .26121  L
s
P
p
.25  g
.004  w
.6832  .2686  m
.68884  .26121  L
s
P
p
.006  w
.78226  .70985  m
.79136  .67883  L
s
P
p
.006  w
.24032  .27149  m
.2659  .24968  L
s
P
p
.7537  .3373  m .48413  .55011  L .48233  .54487  L .748  .994  .857  r
F
P
p
.25  g
.004  w
.49532  .55581  m
.49553  .55569  L
s
P
p
.77024  .36735  m .48413  .55011  L .7537  .3373  L .687  .979  .884  r
F
P
p
1 0 0 r
.003  w
.48413  .55011  m
.48754  .55424  L
s
P
p
.25  g
.004  w
.48413  .55011  m
.49067  .54494  L
s
P
p
.25  g
.004  w
.77016  .36741  m
.77024  .36735  L
s
P
p
.25  g
.004  w
.76811  .36876  m
.77016  .36741  L
s
P
p
.25  g
.004  w
.76715  .3694  m
.76811  .36876  L
s
P
p
.71279  .28403  m .48175  .53883  L .48199  .53234  L .833  .997  .771  r
F
P
p
.73449  .30945  m .48175  .53883  L .71279  .28403  L .796  .999  .819  r
F
P
p
.25  g
.004  w
.65351  .30752  m
.6832  .2686  L
s
P
p
.006  w
.68884  .26121  m
.71279  .28403  L
s
P
p
.25  g
.004  w
.7121  .2848  m
.71261  .28424  L
s
P
p
.25  g
.004  w
.68845  .31088  m
.7121  .2848  L
s
P
p
.25  g
.004  w
.71261  .28424  m
.71279  .28403  L
s
P
p
.006  w
.21679  .29606  m
.24032  .27149  L
s
P
p
.006  w
.12172  .59206  m
.12175  .55761  L
s
P
p
1 0 0 r
.003  w
.47536  .52228  m
.47883  .51945  L
s
P
p
.006  w
.19555  .32321  m
.21679  .29606  L
s
P
p
.006  w
.79136  .67883  m
.79895  .64587  L
s
P
p
.73449  .30945  m .48233  .54487  L .48175  .53883  L .796  .999  .819  r
F
P
p
.25  g
.004  w
.48175  .53883  m
.48205  .5385  L
s
P
p
.25  g
.004  w
.38428  .19459  m
.48212  .5097  L
s
P
p
.25  g
.004  w
.48212  .5097  m
.48216  .5098  L
s
P
p
.7537  .3373  m .48233  .54487  L .73449  .30945  L .748  .994  .857  r
F
P
p
1 0 0 r
.003  w
.48233  .54487  m
.48413  .55011  L
s
P
p
.25  g
.004  w
.48312  .53086  m
.48413  .52954  L
s
P
p
.25  g
.004  w
.48199  .53234  m
.48312  .53086  L
s
P
p
.25  g
.004  w
.4827  .52582  m
.48402  .52373  L
s
P
p
.25  g
.004  w
.41586  .18767  m
.48355  .50632  L
s
P
p
.25  g
.004  w
.48355  .50632  m
.48361  .50663  L
s
P
p
.25  g
.004  w
.48361  .50663  m
.48381  .50758  L
s
P
p
.25  g
.004  w
.48283  .51198  m
.48303  .51262  L
s
P
p
.25  g
.004  w
.48238  .51051  m
.48283  .51198  L
s
P
p
.25  g
.004  w
.48216  .5098  m
.48238  .51051  L
s
P
p
.25  g
.004  w
.48381  .50758  m
.48419  .50934  L
s
P
p
.25  g
.004  w
.48419  .50934  m
.48422  .50948  L
s
P
p
.25  g
.004  w
.48499  .50706  m
.485  .50708  L
s
P
p
.25  g
.004  w
.48477  .50513  m
.48499  .50706  L
s
P
p
.25  g
.004  w
.48465  .50404  m
.48477  .50513  L
s
P
p
.25  g
.004  w
.48549  .50718  m
.48554  .50693  L
s
P
p
.25  g
.004  w
.48543  .50445  m
.48545  .50575  L
s
P
p
.25  g
.004  w
.49553  .55569  m
.78076  .40108  L
s
P
p
.25  g
.004  w
.50323  .55752  m
.79148  .43436  L
s
P
p
.25  g
.004  w
.48562  .50574  m
.51114  .19986  L
s
P
p
.25  g
.004  w
.51337  .5581  m
.79926  .46889  L
s
P
p
.25  g
.004  w
.52604  .55763  m
.8041  .50425  L
s
P
p
.25  g
.004  w
.48554  .50693  m
.54321  .19586  L
s
P
p
.25  g
.004  w
.49252  .55095  m
.76715  .3694  L
s
P
p
.25  g
.004  w
.48542  .50363  m
.48543  .50445  L
s
P
p
.25  g
.004  w
.48509  .51008  m
.48561  .5083  L
s
P
p
.25  g
.004  w
.48561  .5083  m
.57432  .20264  L
s
P
p
.25  g
.004  w
.4854  .50286  m
.48542  .50363  L
s
P
p
.25  g
.004  w
.48443  .51433  m
.48527  .51222  L
s
P
p
.25  g
.004  w
.48582  .51083  m
.60291  .21727  L
s
P
p
.25  g
.004  w
.48527  .51222  m
.48582  .51083  L
s
P
p
.25  g
.004  w
.48539  .50222  m
.4854  .50286  L
s
P
p
.25  g
.004  w
.48032  .19234  m
.48539  .50222  L
s
P
p
.25  g
.004  w
.4846  .50361  m
.48465  .50404  L
s
P
p
.25  g
.004  w
.48358  .51968  m
.48474  .51743  L
s
P
p
.25  g
.004  w
.48474  .51743  m
.4854  .51615  L
s
P
p
.25  g
.004  w
.48614  .51469  m
.61145  .27016  L
s
P
p
.25  g
.004  w
.4854  .51615  m
.48614  .51469  L
s
P
p
.25  g
.004  w
.44789  .18359  m
.4846  .50361  L
s
P
p
.25  g
.004  w
.60005  .3404  m
.65175  .25871  L
s
P
p
.25  g
.004  w
.48402  .52373  m
.48486  .5224  L
s
P
p
.25  g
.004  w
.4866  .51965  m
.60005  .3404  L
s
P
p
.25  g
.004  w
.48486  .5224  m
.4866  .51965  L
s
P
p
.25  g
.004  w
.48413  .52954  m
.48503  .52835  L
s
P
p
.25  g
.004  w
.48724  .52546  m
.65351  .30752  L
s
P
p
.25  g
.004  w
.48503  .52835  m
.48724  .52546  L
s
P
p
.25  g
.004  w
.49067  .54494  m
.74502  .34415  L
s
P
p
.25  g
.004  w
.48205  .5385  m
.48319  .53725  L
s
P
p
.25  g
.004  w
.48319  .53725  m
.48421  .53612  L
s
P
p
.25  g
.004  w
.48809  .53184  m
.68845  .31088  L
s
P
p
.25  g
.004  w
.48421  .53612  m
.48809  .53184  L
s
P
p
.006  w
.71279  .28403  m
.73449  .30945  L
s
P
p
.25  g
.004  w
.71815  .32471  m
.73252  .31129  L
s
P
p
.25  g
.004  w
.68107  .35932  m
.71815  .32471  L
s
P
p
.25  g
.004  w
.48233  .54487  m
.48309  .54417  L
s
P
p
.25  g
.004  w
.48922  .53845  m
.68107  .35932  L
s
P
p
.25  g
.004  w
.48421  .54312  m
.48922  .53845  L
s
P
p
.25  g
.004  w
.48309  .54417  m
.48421  .54312  L
s
P
p
.25  g
.004  w
.73252  .31129  m
.73433  .30959  L
s
P
p
.25  g
.004  w
.73433  .30959  m
.73449  .30945  L
s
P
p
.25  g
.004  w
.75359  .33739  m
.7537  .3373  L
s
P
p
.25  g
.004  w
.75164  .33892  m
.75359  .33739  L
s
P
p
.25  g
.004  w
.75073  .33964  m
.75164  .33892  L
s
P
p
.25  g
.004  w
.74502  .34415  m
.75073  .33964  L
s
P
p
.006  w
.73449  .30945  m
.7537  .3373  L
s
P
p
.006  w
.12175  .55761  m
.12415  .52241  L
s
P
p
.006  w
.17681  .35269  m
.19555  .32321  L
s
P
p
.006  w
.7537  .3373  m
.77024  .36735  L
s
P
p
.006  w
.16071  .3842  m
.17681  .35269  L
s
P
p
1 0 0 r
.003  w
.48175  .53883  m
.48233  .54487  L
s
P
p
.006  w
.12415  .52241  m
.12914  .48695  L
s
P
p
.006  w
.79895  .64587  m
.80463  .61141  L
s
P
p
.006  w
.77024  .36735  m
.78393  .39936  L
s
P
p
.006  w
.14737  .41736  m
.16071  .3842  L
s
P
p
.006  w
.12914  .48695  m
.13685  .45177  L
s
P
p
.006  w
.13685  .45177  m
.14737  .41736  L
s
P
p
1 0 0 r
.003  w
.47883  .51945  m
.48131  .51609  L
s
P
p
.006  w
.80463  .61141  m
.80808  .57589  L
s
P
p
.006  w
.78393  .39936  m
.79468  .433  L
s
P
p
.006  w
.79468  .433  m
.80242  .4679  L
s
P
p
.006  w
.80808  .57589  m
.809  .53982  L
s
P
p
.006  w
.80242  .4679  m
.80716  .50366  L
s
P
p
.006  w
.80716  .50366  m
.809  .53982  L
s
P
p
1 0 0 r
.003  w
.48175  .53883  m
.48199  .53234  L
s
P
p
1 0 0 r
.003  w
.48206  .51458  m
.48303  .51262  L
s
P
p
1 0 0 r
.003  w
.48131  .51609  m
.48206  .51458  L
s
P
p
1 0 0 r
.003  w
.48199  .53234  m
.4827  .52582  L
s
P
p
1 0 0 r
.003  w
.48353  .51131  m
.48422  .50948  L
s
P
p
1 0 0 r
.003  w
.48303  .51262  m
.48353  .51131  L
s
P
p
1 0 0 r
.003  w
.4827  .52582  m
.48358  .51968  L
s
P
p
1 0 0 r
.003  w
.48453  .50851  m
.485  .50708  L
s
P
p
1 0 0 r
.003  w
.48422  .50948  m
.48453  .50851  L
s
P
p
1 0 0 r
.003  w
.48358  .51968  m
.48443  .51433  L
s
P
p
1 0 0 r
.003  w
.48518  .50654  m
.48545  .50575  L
s
P
p
1 0 0 r
.003  w
.485  .50708  m
.48518  .50654  L
s
P
p
1 0 0 r
.003  w
.48443  .51433  m
.48509  .51008  L
s
P
p
1 0 0 r
.003  w
.48552  .50574  m
.48562  .50574  L
s
P
p
1 0 0 r
.003  w
.48545  .50575  m
.48552  .50574  L
s
P
p
1 0 0 r
.003  w
.48509  .51008  m
.48549  .50718  L
s
P
p
1 0 0 r
.003  w
.48549  .50718  m
.48562  .50574  L
s
P
p
.002  w
.17139  .02769  m
.06667  .18034  L
s
.06667  .18034  m
.97231  .27244  L
s
.97231  .27244  m
.84613  .09787  L
s
.84613  .09787  m
.17139  .02769  L
s
P
p
P
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; endGroup; nowordwrap; ]
No Input Form was saved for this expression.



;[o]
-Graphics3D-
:[font = text; inactive; ]
If you use Cos instead of Sine it doesn't work out.
:[font = input; startGroup; nowordwrap; ]
clear;top=125;kappa[s_]=1;tau[s_]:=Cos[s];width=.5;ds=.1;
pribbonfrenet
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 277; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.08079 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0260524 1.10184 0.0275459 1.10184 [
[ 0 0 0 0 ]
[ 1 1.08079 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 1.08079 lineto
0 1.08079 lineto
closepath
clip
newpath
gsave
0.002 setlinewidth
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
0.42251 0.57709 moveto
0.11113 0.25957 lineto
stroke
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
0.42251 0.57709 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
grestore
gsave
0.52931 0.66791 moveto 0.53813 0.69368 lineto 0.54949 0.67087 lineto 0.549 0.029 0 setrgbcolor
fill
grestore
gsave
0.52931 0.66791 moveto 0.52563 0.70038 lineto 0.53813 0.69368 lineto 0.253 0 0.076 setrgbcolor
fill
grestore
gsave
0.50913 0.66572 moveto 0.52563 0.70038 lineto 0.52931 0.66791 lineto 0.607 0.141 0.122 setrgbcolor
fill
grestore
gsave
0.50913 0.66572 moveto 0.51337 0.70676 lineto 0.52563 0.70038 lineto 0.391 0.042 0.248 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52563 0.70038 moveto
0.52931 0.66791 lineto
stroke
grestore
gsave
0.48907 0.66444 moveto 0.51337 0.70676 lineto 0.50913 0.66572 lineto 0.642 0.22 0.228 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.50913 0.66572 moveto
0.52931 0.66791 lineto
stroke
grestore
gsave
0.54949 0.67087 moveto 0.55087 0.68668 lineto 0.56957 0.67445 lineto 0.448 0 0 setrgbcolor
fill
grestore
gsave
0.54949 0.67087 moveto 0.53813 0.69368 lineto 0.55087 0.68668 lineto 0.023 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.52931 0.66791 moveto
0.54949 0.67087 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53813 0.69368 moveto
0.54949 0.67087 lineto
stroke
grestore
gsave
0.48907 0.66444 moveto 0.5014 0.71282 lineto 0.51337 0.70676 lineto 0.478 0.163 0.354 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50913 0.66572 moveto
0.51337 0.70676 lineto
stroke
grestore
gsave
0.46926 0.6642 moveto 0.5014 0.71282 lineto 0.48907 0.66444 lineto 0.665 0.278 0.303 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.48907 0.66444 moveto
0.50913 0.66572 lineto
stroke
grestore
gsave
0.56957 0.67445 moveto 0.56381 0.67944 lineto 0.58942 0.67846 lineto 0.282 0 0 setrgbcolor
fill
grestore
gsave
0.56957 0.67445 moveto 0.55087 0.68668 lineto 0.56381 0.67944 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.54949 0.67087 moveto
0.56957 0.67445 lineto
stroke
grestore
gsave
0.46926 0.6642 moveto 0.48978 0.71859 lineto 0.5014 0.71282 lineto 0.537 0.247 0.421 setrgbcolor
fill
grestore
gsave
0.44984 0.6651 moveto 0.48978 0.71859 lineto 0.46926 0.6642 lineto 0.681 0.32 0.356 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48907 0.66444 moveto
0.48928 0.66525 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46926 0.6642 moveto
0.48907 0.66444 lineto
stroke
grestore
gsave
0.58942 0.67846 moveto 0.57696 0.67202 lineto 0.60895 0.68271 lineto 0 0.506 0.777 setrgbcolor
fill
grestore
gsave
0.58942 0.67846 moveto 0.56381 0.67944 lineto 0.57696 0.67202 lineto 0.593 0.949 0.858 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.56957 0.67445 moveto
0.57184 0.67491 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58896 0.67848 moveto
0.58942 0.67846 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55087 0.68668 moveto
0.56957 0.67445 lineto
stroke
grestore
gsave
0.44984 0.6651 moveto 0.47857 0.72412 lineto 0.48978 0.71859 lineto 0.581 0.307 0.466 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.501 0.71122 moveto
0.5014 0.71282 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48928 0.66525 moveto
0.501 0.71122 lineto
stroke
grestore
gsave
0.43092 0.6672 moveto 0.47857 0.72412 lineto 0.44984 0.6651 lineto 0.693 0.352 0.395 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46926 0.6642 moveto
0.4696 0.66508 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.44984 0.6651 moveto
0.46926 0.6642 lineto
stroke
grestore
gsave
0.60895 0.68271 moveto 0.59028 0.66452 lineto 0.62804 0.68699 lineto 0.14 0.611 0.923 setrgbcolor
fill
grestore
gsave
0.60895 0.68271 moveto 0.57696 0.67202 lineto 0.59028 0.66452 lineto 0.721 0.956 0.948 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.58942 0.67846 moveto
0.60895 0.68271 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60836 0.68251 moveto
0.60895 0.68271 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56381 0.67944 moveto
0.56389 0.67943 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56389 0.67943 moveto
0.58896 0.67848 lineto
stroke
grestore
gsave
0.43092 0.6672 moveto 0.46786 0.72944 lineto 0.47857 0.72412 lineto 0.616 0.351 0.494 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4889 0.71626 moveto
0.48978 0.71859 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4696 0.66508 moveto
0.4889 0.71626 lineto
stroke
grestore
gsave
0.41266 0.67056 moveto 0.46786 0.72944 lineto 0.43092 0.6672 lineto 0.702 0.377 0.423 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44984 0.6651 moveto
0.45028 0.66601 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.43092 0.6672 moveto
0.44984 0.6651 lineto
stroke
grestore
gsave
0.62804 0.68699 moveto 0.60377 0.65705 lineto 0.64661 0.69109 lineto 0.279 0.641 0.966 setrgbcolor
fill
grestore
gsave
0.62804 0.68699 moveto 0.59028 0.66452 lineto 0.60377 0.65705 lineto 0.752 0.895 0.942 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57696 0.67202 moveto
0.57723 0.67211 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60895 0.68271 moveto
0.62804 0.68699 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62734 0.68658 moveto
0.62804 0.68699 lineto
stroke
grestore
gsave
0.41266 0.67056 moveto 0.45776 0.73462 lineto 0.46786 0.72944 lineto 0.645 0.384 0.509 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47694 0.72078 moveto
0.47857 0.72412 lineto
stroke
grestore
gsave
0.39518 0.67523 moveto 0.45776 0.73462 lineto 0.41266 0.67056 lineto 0.71 0.395 0.442 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43092 0.6672 moveto
0.43145 0.66809 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.41266 0.67056 moveto
0.43092 0.6672 lineto
stroke
grestore
gsave
0.64661 0.69109 moveto 0.61738 0.64968 lineto 0.66457 0.69478 lineto 0.362 0.632 0.957 setrgbcolor
fill
grestore
gsave
0.64661 0.69109 moveto 0.60377 0.65705 lineto 0.61738 0.64968 lineto 0.75 0.828 0.912 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59028 0.66452 moveto
0.59081 0.66483 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.62804 0.68699 moveto
0.64661 0.69109 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64582 0.69046 moveto
0.64661 0.69109 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64581 0.69045 moveto
0.64582 0.69046 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57723 0.67211 moveto
0.57755 0.67222 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57755 0.67222 moveto
0.60836 0.68251 lineto
stroke
grestore
gsave
0.39518 0.67523 moveto 0.44836 0.73968 lineto 0.45776 0.73462 lineto 0.67 0.407 0.514 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46498 0.72459 moveto
0.46786 0.72944 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47438 0.71551 moveto
0.47694 0.72078 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45028 0.66601 moveto
0.47438 0.71551 lineto
stroke
grestore
gsave
0.37865 0.68119 moveto 0.44836 0.73968 lineto 0.39518 0.67523 lineto 0.715 0.407 0.455 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41266 0.67056 moveto
0.41323 0.67138 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39518 0.67523 moveto
0.41266 0.67056 lineto
stroke
grestore
gsave
0.66457 0.69478 moveto 0.63106 0.6425 lineto 0.68184 0.69784 lineto 0.408 0.608 0.93 setrgbcolor
fill
grestore
gsave
0.66457 0.69478 moveto 0.61738 0.64968 lineto 0.63106 0.6425 lineto 0.736 0.77 0.88 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60377 0.65705 moveto
0.60458 0.65769 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.64661 0.69109 moveto
0.66457 0.69478 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66368 0.69392 moveto
0.66457 0.69478 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66367 0.69392 moveto
0.66368 0.69392 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59081 0.66483 moveto
0.59127 0.66511 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59127 0.66511 moveto
0.62734 0.68658 lineto
stroke
grestore
gsave
0.37865 0.68119 moveto 0.43978 0.74465 lineto 0.44836 0.73968 lineto 0.692 0.421 0.509 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45244 0.72706 moveto
0.45776 0.73462 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46001 0.7162 moveto
0.46498 0.72459 lineto
stroke
grestore
gsave
0.3632 0.68844 moveto 0.43978 0.74465 lineto 0.37865 0.68119 lineto 0.719 0.415 0.463 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39518 0.67523 moveto
0.39567 0.67581 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37865 0.68119 moveto
0.39518 0.67523 lineto
stroke
grestore
gsave
0.68184 0.69784 moveto 0.64473 0.63556 lineto 0.69834 0.70004 lineto 0.432 0.58 0.9 setrgbcolor
fill
grestore
gsave
0.68184 0.69784 moveto 0.63106 0.6425 lineto 0.64473 0.63556 lineto 0.72 0.721 0.85 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60458 0.65769 moveto
0.60522 0.6582 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61738 0.64968 moveto
0.61852 0.65076 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.66457 0.69478 moveto
0.68184 0.69784 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68085 0.69676 moveto
0.68184 0.69784 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68085 0.69676 moveto
0.68085 0.69676 lineto
stroke
grestore
gsave
0.3632 0.68844 moveto 0.43212 0.74953 lineto 0.43978 0.74465 lineto 0.709 0.425 0.492 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43634 0.72511 moveto
0.44836 0.73968 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44103 0.71086 moveto
0.45244 0.72706 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45037 0.69996 moveto
0.46001 0.7162 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43145 0.66809 moveto
0.45037 0.69996 lineto
stroke
grestore
gsave
0.34899 0.69693 moveto 0.43212 0.74953 lineto 0.3632 0.68844 lineto 0.721 0.419 0.466 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41323 0.67138 moveto
0.44103 0.71086 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.3632 0.68844 moveto
0.37865 0.68119 lineto
stroke
grestore
gsave
0.34899 0.69693 moveto 0.42548 0.75428 lineto 0.43212 0.74953 lineto 0.722 0.417 0.461 setrgbcolor
fill
grestore
gsave
0.33617 0.7066 moveto 0.42548 0.75428 lineto 0.34899 0.69693 lineto 0.721 0.418 0.465 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39567 0.67581 moveto
0.43634 0.72511 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3632 0.68844 moveto
0.37442 0.69838 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.34899 0.69693 moveto
0.3632 0.68844 lineto
stroke
grestore
gsave
0.69834 0.70004 moveto 0.65829 0.62887 lineto 0.71401 0.70118 lineto 0.442 0.551 0.871 setrgbcolor
fill
grestore
gsave
0.69834 0.70004 moveto 0.64473 0.63556 lineto 0.65829 0.62887 lineto 0.703 0.679 0.824 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61852 0.65076 moveto
0.61936 0.65156 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63106 0.6425 moveto
0.63254 0.64411 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68184 0.69784 moveto
0.69834 0.70004 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69763 0.69919 moveto
0.69834 0.70004 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69728 0.69877 moveto
0.69763 0.69919 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60522 0.6582 moveto
0.60605 0.65885 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60605 0.65885 moveto
0.64581 0.69045 lineto
stroke
grestore
gsave
0.33617 0.7066 moveto 0.4199 0.75886 lineto 0.42548 0.75428 lineto 0.728 0.394 0.414 setrgbcolor
fill
grestore
gsave
0.3249 0.71735 moveto 0.4199 0.75886 lineto 0.33617 0.7066 lineto 0.718 0.414 0.461 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37865 0.68119 moveto
0.39372 0.69684 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34899 0.69693 moveto
0.35175 0.699 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33617 0.7066 moveto
0.34899 0.69693 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34113 0.70969 moveto
0.35102 0.71587 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33617 0.7066 moveto
0.34113 0.70969 lineto
stroke
grestore
gsave
0.71401 0.70118 moveto 0.67162 0.62242 lineto 0.72879 0.70105 lineto 0.444 0.522 0.843 setrgbcolor
fill
grestore
gsave
0.71401 0.70118 moveto 0.65829 0.62887 lineto 0.67162 0.62242 lineto 0.685 0.641 0.8 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63254 0.64411 moveto
0.6336 0.64527 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64473 0.63556 moveto
0.64658 0.63778 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69834 0.70004 moveto
0.71401 0.70118 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71325 0.7002 moveto
0.71401 0.70118 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71288 0.69972 moveto
0.71325 0.7002 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61936 0.65156 moveto
0.62042 0.65258 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62042 0.65258 moveto
0.66367 0.69392 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48978 0.71859 moveto
0.5014 0.71282 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47857 0.72412 moveto
0.48978 0.71859 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5014 0.71282 moveto
0.51337 0.70676 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46786 0.72944 moveto
0.47857 0.72412 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51337 0.70676 moveto
0.52563 0.70038 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45776 0.73462 moveto
0.46786 0.72944 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52563 0.70038 moveto
0.53813 0.69368 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.53813 0.69368 moveto
0.55087 0.68668 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44836 0.73968 moveto
0.45776 0.73462 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55087 0.68668 moveto
0.56381 0.67944 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43978 0.74465 moveto
0.44836 0.73968 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.56381 0.67944 moveto
0.57696 0.67202 lineto
stroke
grestore
gsave
0.3249 0.71735 moveto 0.41545 0.76317 lineto 0.4199 0.75886 lineto 0.721 0.35 0.346 setrgbcolor
fill
grestore
gsave
0.31531 0.72906 moveto 0.41545 0.76317 lineto 0.3249 0.71735 lineto 0.713 0.405 0.455 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39372 0.69684 moveto
0.43978 0.74465 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37442 0.69838 moveto
0.43212 0.74953 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35175 0.699 moveto
0.35179 0.69903 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.3249 0.71735 moveto
0.33617 0.7066 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3249 0.71735 moveto
0.33472 0.72232 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57696 0.67202 moveto
0.59028 0.66452 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43212 0.74953 moveto
0.43978 0.74465 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59028 0.66452 moveto
0.60377 0.65705 lineto
stroke
grestore
gsave
0.72879 0.70105 moveto 0.6846 0.61615 lineto 0.74263 0.69948 lineto 0.439 0.494 0.819 setrgbcolor
fill
grestore
gsave
0.72879 0.70105 moveto 0.67162 0.62242 lineto 0.6846 0.61615 lineto 0.667 0.607 0.778 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64658 0.63778 moveto
0.64788 0.63935 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64788 0.63935 moveto
0.69728 0.69877 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65829 0.62887 moveto
0.66053 0.63178 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66053 0.63178 moveto
0.71288 0.69972 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71401 0.70118 moveto
0.72879 0.70105 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72799 0.69995 moveto
0.72879 0.70105 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72761 0.69943 moveto
0.72799 0.69995 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6336 0.64527 moveto
0.63494 0.64672 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63494 0.64672 moveto
0.68085 0.69676 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60377 0.65705 moveto
0.61738 0.64968 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42548 0.75428 moveto
0.43212 0.74953 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61738 0.64968 moveto
0.63106 0.6425 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63106 0.6425 moveto
0.64473 0.63556 lineto
stroke
grestore
gsave
0.31531 0.72906 moveto 0.41211 0.76713 lineto 0.41545 0.76317 lineto 0.697 0.28 0.251 setrgbcolor
fill
grestore
gsave
0.30757 0.74158 moveto 0.41211 0.76713 lineto 0.31531 0.72906 lineto 0.705 0.393 0.446 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35179 0.69903 moveto
0.42548 0.75428 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35102 0.71587 moveto
0.4199 0.75886 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33472 0.72232 moveto
0.3861 0.74832 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.31531 0.72906 moveto
0.3249 0.71735 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3212 0.73137 moveto
0.37076 0.75087 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31531 0.72906 moveto
0.3212 0.73137 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4199 0.75886 moveto
0.42548 0.75428 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64473 0.63556 moveto
0.65829 0.62887 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65829 0.62887 moveto
0.67162 0.62242 lineto
stroke
grestore
gsave
0.74263 0.69948 moveto 0.69708 0.60998 lineto 0.7555 0.69632 lineto 0.43 0.466 0.796 setrgbcolor
fill
grestore
gsave
0.74263 0.69948 moveto 0.6846 0.61615 lineto 0.69708 0.60998 lineto 0.648 0.574 0.758 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67162 0.62242 moveto
0.67428 0.62608 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67428 0.62608 moveto
0.72761 0.69943 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72879 0.70105 moveto
0.74263 0.69948 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74143 0.69775 moveto
0.74263 0.69948 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6846 0.61615 moveto
0.74143 0.69775 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41545 0.76317 moveto
0.4199 0.75886 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67162 0.62242 moveto
0.6846 0.61615 lineto
stroke
grestore
gsave
0.30757 0.74158 moveto 0.40987 0.77063 lineto 0.41211 0.76713 lineto 0.644 0.176 0.127 setrgbcolor
fill
grestore
gsave
0.30178 0.75473 moveto 0.40987 0.77063 lineto 0.30757 0.74158 lineto 0.693 0.377 0.437 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3861 0.74832 moveto
0.41545 0.76317 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3925 0.75942 moveto
0.41211 0.76713 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37076 0.75087 moveto
0.3925 0.75942 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.30757 0.74158 moveto
0.31531 0.72906 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30757 0.74158 moveto
0.38099 0.76243 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41211 0.76713 moveto
0.41545 0.76317 lineto
stroke
grestore
gsave
0.7555 0.69632 moveto 0.69708 0.60998 lineto 0.70891 0.6038 lineto 0.627 0.543 0.74 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6846 0.61615 moveto
0.69708 0.60998 lineto
stroke
grestore
gsave
0.4869 0.31956 moveto 0.49473 0.33291 lineto 0.46582 0.32642 lineto 0.127 0 0 setrgbcolor
fill
grestore
gsave
0.4869 0.31956 moveto 0.50724 0.33429 lineto 0.49473 0.33291 lineto 0.348 0 0 setrgbcolor
fill
grestore
gsave
0.50829 0.31312 moveto 0.50724 0.33429 lineto 0.4869 0.31956 lineto 0.224 0 0 setrgbcolor
fill
grestore
gsave
0.50829 0.31312 moveto 0.52003 0.33678 lineto 0.50724 0.33429 lineto 0.527 0 0 setrgbcolor
fill
grestore
gsave
0.52986 0.30727 moveto 0.52003 0.33678 lineto 0.50829 0.31312 lineto 0.317 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.4869 0.31956 moveto
0.50829 0.31312 lineto
stroke
grestore
gsave
0.46582 0.32642 moveto 0.4826 0.33264 lineto 0.44517 0.33354 lineto 0.037 0 0 setrgbcolor
fill
grestore
gsave
0.46582 0.32642 moveto 0.49473 0.33291 lineto 0.4826 0.33264 lineto 0.153 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.46582 0.32642 moveto
0.4869 0.31956 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46582 0.32642 moveto
0.46646 0.32656 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4869 0.31956 moveto
0.50473 0.33247 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50473 0.33247 moveto
0.50724 0.33429 lineto
stroke
grestore
gsave
0.7555 0.69632 moveto 0.70891 0.6038 lineto 0.76735 0.69144 lineto 0.417 0.438 0.775 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.74263 0.69948 moveto
0.7555 0.69632 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69708 0.60998 moveto
0.7555 0.69632 lineto
stroke
grestore
gsave
0.76735 0.69144 moveto 0.70891 0.6038 lineto 0.71995 0.5975 lineto 0.604 0.512 0.723 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.69708 0.60998 moveto
0.70891 0.6038 lineto
stroke
grestore
gsave
0.52986 0.30727 moveto 0.53298 0.34037 lineto 0.52003 0.33678 lineto 0.653 0.159 0.064 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50829 0.31312 moveto
0.52003 0.33678 lineto
stroke
grestore
gsave
0.5515 0.3022 moveto 0.53298 0.34037 lineto 0.52986 0.30727 lineto 0.397 0 0.091 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.50829 0.31312 moveto
0.52986 0.30727 lineto
stroke
grestore
gsave
0.44517 0.33354 moveto 0.47098 0.33343 lineto 0.42508 0.34079 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.44517 0.33354 moveto 0.4826 0.33264 lineto 0.47098 0.33343 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.44517 0.33354 moveto
0.46582 0.32642 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44517 0.33354 moveto
0.44604 0.33352 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46646 0.32656 moveto
0.49012 0.33188 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49012 0.33188 moveto
0.49473 0.33291 lineto
stroke
grestore
gsave
0.77817 0.68474 moveto 0.71995 0.5975 lineto 0.73004 0.59097 lineto 0.578 0.48 0.707 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70891 0.6038 moveto
0.71313 0.61012 lineto
stroke
grestore
gsave
0.76735 0.69144 moveto 0.71995 0.5975 lineto 0.77817 0.68474 lineto 0.4 0.411 0.756 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70891 0.6038 moveto
0.71995 0.5975 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7555 0.69632 moveto
0.76735 0.69144 lineto
stroke
grestore
gsave
0.5515 0.3022 moveto 0.54602 0.34503 lineto 0.53298 0.34037 lineto 0.725 0.299 0.238 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52986 0.30727 moveto
0.53298 0.34037 lineto
stroke
grestore
gsave
0.57307 0.29809 moveto 0.54602 0.34503 lineto 0.5515 0.3022 lineto 0.461 0.064 0.201 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.52986 0.30727 moveto
0.5515 0.3022 lineto
stroke
grestore
gsave
0.42508 0.34079 moveto 0.46 0.33524 lineto 0.40567 0.34803 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.42508 0.34079 moveto 0.47098 0.33343 lineto 0.46 0.33524 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.42508 0.34079 moveto
0.44517 0.33354 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42508 0.34079 moveto
0.42622 0.34061 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44604 0.33352 moveto
0.47428 0.33284 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47428 0.33284 moveto
0.4826 0.33264 lineto
stroke
grestore
gsave
0.30178 0.75473 moveto 0.40864 0.77356 lineto 0.40987 0.77063 lineto 0.553 0.034 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40987 0.77063 moveto
0.41211 0.76713 lineto
stroke
grestore
gsave
0.29806 0.76831 moveto 0.40864 0.77356 lineto 0.30178 0.75473 lineto 0.679 0.359 0.427 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38099 0.76243 moveto
0.40987 0.77063 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.30178 0.75473 moveto
0.30757 0.74158 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30178 0.75473 moveto
0.39636 0.7714 lineto
stroke
grestore
gsave
0.78792 0.67617 moveto 0.73004 0.59097 lineto 0.73905 0.5841 lineto 0.547 0.447 0.692 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71995 0.5975 moveto
0.7249 0.60492 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71313 0.61012 moveto
0.71626 0.61482 lineto
stroke
grestore
gsave
0.77817 0.68474 moveto 0.73004 0.59097 lineto 0.78792 0.67617 lineto 0.381 0.384 0.738 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71626 0.61482 moveto
0.76735 0.69144 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.71995 0.5975 moveto
0.73004 0.59097 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77688 0.68281 moveto
0.77817 0.68474 lineto
stroke
grestore
gsave
0.57307 0.29809 moveto 0.55907 0.35067 lineto 0.54602 0.34503 lineto 0.76 0.397 0.367 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54602 0.34503 moveto
0.5515 0.3022 lineto
stroke
grestore
gsave
0.59445 0.29514 moveto 0.55907 0.35067 lineto 0.57307 0.29809 lineto 0.507 0.149 0.294 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.5515 0.3022 moveto
0.57307 0.29809 lineto
stroke
grestore
gsave
0.40567 0.34803 moveto 0.44977 0.33803 lineto 0.38707 0.35516 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.40567 0.34803 moveto 0.46 0.33524 lineto 0.44977 0.33803 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4541 0.33614 moveto
0.47098 0.33343 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40567 0.34803 moveto
0.42508 0.34079 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40567 0.34803 moveto
0.4072 0.34767 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.76735 0.69144 moveto
0.77817 0.68474 lineto
stroke
grestore
gsave
0.79658 0.66572 moveto 0.73905 0.5841 lineto 0.74686 0.57682 lineto 0.512 0.413 0.68 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73004 0.59097 moveto
0.73597 0.59971 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7249 0.60492 moveto
0.72872 0.61064 lineto
stroke
grestore
gsave
0.78792 0.67617 moveto 0.73905 0.5841 lineto 0.79658 0.66572 lineto 0.361 0.359 0.722 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73004 0.59097 moveto
0.73905 0.5841 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78655 0.67417 moveto
0.78792 0.67617 lineto
stroke
grestore
gsave
0.59445 0.29514 moveto 0.57209 0.35719 lineto 0.55907 0.35067 lineto 0.774 0.463 0.461 setrgbcolor
fill
grestore
gsave
0.61551 0.29351 moveto 0.57209 0.35719 lineto 0.59445 0.29514 lineto 0.54 0.218 0.37 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57279 0.29915 moveto
0.57307 0.29809 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57307 0.29809 moveto
0.59445 0.29514 lineto
stroke
grestore
gsave
0.38707 0.35516 moveto 0.44039 0.34173 lineto 0.36942 0.36208 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.38707 0.35516 moveto 0.44977 0.33803 lineto 0.44039 0.34173 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.38707 0.35516 moveto
0.40567 0.34803 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38944 0.35451 moveto
0.38947 0.3545 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38707 0.35516 moveto
0.38944 0.35451 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42622 0.34061 moveto
0.4541 0.33614 lineto
stroke
grestore
gsave
0.29806 0.76831 moveto 0.40832 0.77583 lineto 0.40864 0.77356 lineto 0.418 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40864 0.77356 moveto
0.40987 0.77063 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39636 0.7714 moveto
0.40864 0.77356 lineto
stroke
grestore
gsave
0.2965 0.78209 moveto 0.40832 0.77583 lineto 0.29806 0.76831 lineto 0.661 0.34 0.419 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.29806 0.76831 moveto
0.30178 0.75473 lineto
stroke
grestore
gsave
0.80415 0.65339 moveto 0.74686 0.57682 lineto 0.75335 0.56907 lineto 0.47 0.378 0.67 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73905 0.5841 moveto
0.74642 0.59455 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73597 0.59971 moveto
0.74079 0.6068 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72872 0.61064 moveto
0.73398 0.61853 lineto
stroke
grestore
gsave
0.79658 0.66572 moveto 0.74686 0.57682 lineto 0.80415 0.65339 lineto 0.341 0.335 0.708 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73905 0.5841 moveto
0.74686 0.57682 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79518 0.66372 moveto
0.79658 0.66572 lineto
stroke
grestore
gsave
0.61551 0.29351 moveto 0.58506 0.36445 lineto 0.57209 0.35719 lineto 0.776 0.508 0.531 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57209 0.35719 moveto
0.57326 0.35396 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55907 0.35067 moveto
0.57279 0.29915 lineto
stroke
grestore
gsave
0.63612 0.2934 moveto 0.58506 0.36445 lineto 0.61551 0.29351 lineto 0.562 0.272 0.433 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.594 0.29637 moveto
0.59445 0.29514 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59445 0.29514 moveto
0.61551 0.29351 lineto
stroke
grestore
gsave
0.8106 0.63926 moveto 0.75335 0.56907 lineto 0.75845 0.56085 lineto 0.421 0.344 0.664 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74642 0.59455 moveto
0.75291 0.60377 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74079 0.6068 moveto
0.74782 0.61714 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73398 0.61853 moveto
0.74147 0.62976 lineto
stroke
grestore
gsave
0.80415 0.65339 moveto 0.75335 0.56907 lineto 0.8106 0.63926 lineto 0.321 0.315 0.697 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74147 0.62976 moveto
0.77688 0.68281 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74686 0.57682 moveto
0.75656 0.58979 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74686 0.57682 moveto
0.75335 0.56907 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80268 0.65143 moveto
0.80308 0.65196 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80308 0.65196 moveto
0.80415 0.65339 lineto
stroke
grestore
gsave
0.36942 0.36208 moveto 0.43195 0.34632 lineto 0.35286 0.36871 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.36942 0.36208 moveto 0.44039 0.34173 lineto 0.43195 0.34632 lineto 0.005 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36942 0.36208 moveto
0.38707 0.35516 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36942 0.36208 moveto
0.37504 0.36047 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.77817 0.68474 moveto
0.78792 0.67617 lineto
stroke
grestore
gsave
0.2965 0.78209 moveto 0.40876 0.77737 lineto 0.40832 0.77583 lineto 0.245 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40832 0.77583 moveto
0.40864 0.77356 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29806 0.76831 moveto
0.40832 0.77583 lineto
stroke
grestore
gsave
0.81591 0.62341 moveto 0.75845 0.56085 lineto 0.76206 0.55218 lineto 0.368 0.313 0.664 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74782 0.61714 moveto
0.75871 0.63317 lineto
stroke
grestore
gsave
0.8106 0.63926 moveto 0.75845 0.56085 lineto 0.81591 0.62341 lineto 0.305 0.299 0.688 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75871 0.63317 moveto
0.78655 0.67417 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75291 0.60377 moveto
0.76338 0.61861 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75335 0.56907 moveto
0.75845 0.56085 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80903 0.63734 moveto
0.80944 0.63784 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80944 0.63784 moveto
0.81038 0.63898 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81038 0.63898 moveto
0.8106 0.63926 lineto
stroke
grestore
gsave
0.63612 0.2934 moveto 0.59795 0.37229 lineto 0.58506 0.36445 lineto 0.772 0.541 0.585 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58506 0.36445 moveto
0.58642 0.36128 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57326 0.35396 moveto
0.594 0.29637 lineto
stroke
grestore
gsave
0.65616 0.29496 moveto 0.59795 0.37229 lineto 0.63612 0.2934 lineto 0.576 0.315 0.484 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61491 0.29492 moveto
0.61551 0.29351 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61551 0.29351 moveto
0.63612 0.2934 lineto
stroke
grestore
gsave
0.29716 0.79582 moveto 0.40876 0.77737 lineto 0.2965 0.78209 lineto 0.641 0.319 0.412 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.2965 0.78209 moveto
0.29806 0.76831 lineto
stroke
grestore
gsave
0.82007 0.60598 moveto 0.76206 0.55218 lineto 0.76416 0.54311 lineto 0.315 0.291 0.673 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7862 0.6294 moveto
0.80268 0.65143 lineto
stroke
grestore
gsave
0.81591 0.62341 moveto 0.76206 0.55218 lineto 0.82007 0.60598 lineto 0.294 0.289 0.683 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75656 0.58979 moveto
0.76648 0.60305 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78776 0.61126 moveto
0.80903 0.63734 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75335 0.56907 moveto
0.76768 0.58664 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75845 0.56085 moveto
0.76206 0.55218 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81419 0.62153 moveto
0.81462 0.622 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81462 0.622 moveto
0.81561 0.62308 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81561 0.62308 moveto
0.81591 0.62341 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76338 0.61861 moveto
0.79518 0.66372 lineto
stroke
grestore
gsave
0.35286 0.36871 moveto 0.4245 0.35177 lineto 0.33753 0.37501 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.35286 0.36871 moveto 0.43195 0.34632 lineto 0.4245 0.35177 lineto 0.143 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.35286 0.36871 moveto
0.36942 0.36208 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35286 0.36871 moveto
0.35292 0.36869 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35292 0.36869 moveto
0.36433 0.36546 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4072 0.34767 moveto
0.46 0.33524 lineto
stroke
grestore
gsave
0.29716 0.79582 moveto 0.4098 0.77812 lineto 0.40876 0.77737 lineto 0.056 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40832 0.77583 moveto
0.40876 0.77737 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2965 0.78209 moveto
0.40876 0.77737 lineto
stroke
grestore
gsave
0.82305 0.58715 moveto 0.76416 0.54311 lineto 0.76471 0.53371 lineto 0.272 0.285 0.692 setrgbcolor
fill
grestore
gsave
0.82007 0.60598 moveto 0.76416 0.54311 lineto 0.82305 0.58715 lineto 0.289 0.285 0.681 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76206 0.55218 moveto
0.76416 0.54311 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81804 0.60409 moveto
0.81854 0.60456 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81854 0.60456 moveto
0.81964 0.60558 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81964 0.60558 moveto
0.82007 0.60598 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78642 0.59131 moveto
0.81419 0.62153 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76648 0.60305 moveto
0.7862 0.6294 lineto
stroke
grestore
gsave
0.65616 0.29496 moveto 0.61076 0.38056 lineto 0.59795 0.37229 lineto 0.764 0.564 0.628 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59795 0.37229 moveto
0.5994 0.36928 lineto
stroke
grestore
gsave
0.6755 0.29834 moveto 0.61076 0.38056 lineto 0.65616 0.29496 lineto 0.583 0.348 0.526 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6149 0.29493 moveto
0.61491 0.29492 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63537 0.29496 moveto
0.63612 0.2934 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63612 0.2934 moveto
0.65616 0.29496 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.78792 0.67617 moveto
0.79658 0.66572 lineto
stroke
grestore
gsave
0.82483 0.56711 moveto 0.76471 0.53371 lineto 0.76372 0.5241 lineto 0.248 0.301 0.721 setrgbcolor
fill
grestore
gsave
0.82305 0.58715 moveto 0.76471 0.53371 lineto 0.82483 0.56711 lineto 0.293 0.288 0.683 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76416 0.54311 moveto
0.76471 0.53371 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81966 0.58461 moveto
0.82014 0.58497 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82014 0.58497 moveto
0.82098 0.5856 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82098 0.5856 moveto
0.82237 0.58664 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82237 0.58664 moveto
0.82305 0.58715 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76768 0.58664 moveto
0.78776 0.61126 lineto
stroke
grestore
gsave
0.82538 0.54611 moveto 0.76372 0.5241 lineto 0.76121 0.51437 lineto 0.253 0.338 0.757 setrgbcolor
fill
grestore
gsave
0.82483 0.56711 moveto 0.76372 0.5241 lineto 0.82538 0.54611 lineto 0.304 0.298 0.687 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76372 0.5241 moveto
0.76471 0.53371 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78985 0.54768 moveto
0.82032 0.56461 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82032 0.56461 moveto
0.82483 0.56711 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76206 0.55218 moveto
0.81804 0.60409 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75845 0.56085 moveto
0.77202 0.57563 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77202 0.57563 moveto
0.78642 0.59131 lineto
stroke
grestore
gsave
0.33753 0.37501 moveto 0.41807 0.35804 lineto 0.32359 0.38093 lineto 0.022 0 0 setrgbcolor
fill
grestore
gsave
0.33753 0.37501 moveto 0.4245 0.35177 lineto 0.41807 0.35804 lineto 0.275 0 0.087 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.33753 0.37501 moveto
0.35286 0.36871 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33753 0.37501 moveto
0.33758 0.37499 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33758 0.37499 moveto
0.34433 0.37319 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40738 0.35634 moveto
0.4245 0.35177 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38947 0.3545 moveto
0.44977 0.33803 lineto
stroke
grestore
gsave
0.30006 0.80923 moveto 0.4098 0.77812 lineto 0.29716 0.79582 lineto 0.618 0.299 0.408 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.2965 0.78209 moveto
0.29716 0.79582 lineto
stroke
grestore
gsave
0.30006 0.80923 moveto 0.41126 0.77808 lineto 0.4098 0.77812 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40876 0.77737 moveto
0.4098 0.77812 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29716 0.79582 moveto
0.4098 0.77812 lineto
stroke
grestore
gsave
0.82466 0.5244 moveto 0.76121 0.51437 lineto 0.75723 0.50464 lineto 0.286 0.39 0.795 setrgbcolor
fill
grestore
gsave
0.82538 0.54611 moveto 0.76121 0.51437 lineto 0.82466 0.5244 lineto 0.322 0.312 0.693 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76121 0.51437 moveto
0.76372 0.5241 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82497 0.54597 moveto
0.82538 0.54611 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78477 0.53162 moveto
0.82497 0.54597 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76471 0.53371 moveto
0.78985 0.54768 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76416 0.54311 moveto
0.81966 0.58461 lineto
stroke
grestore
gsave
0.6755 0.29834 moveto 0.6235 0.3891 lineto 0.61076 0.38056 lineto 0.754 0.582 0.663 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61076 0.38056 moveto
0.61326 0.37586 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58642 0.36128 moveto
0.6149 0.29493 lineto
stroke
grestore
gsave
0.69401 0.30364 moveto 0.6235 0.3891 lineto 0.6755 0.29834 lineto 0.585 0.374 0.561 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63537 0.29497 moveto
0.63537 0.29496 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65527 0.29664 moveto
0.65616 0.29496 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.65616 0.29496 moveto
0.6755 0.29834 lineto
stroke
grestore
gsave
0.82266 0.50227 moveto 0.75723 0.50464 lineto 0.75186 0.49499 lineto 0.339 0.448 0.826 setrgbcolor
fill
grestore
gsave
0.82466 0.5244 moveto 0.75723 0.50464 lineto 0.82266 0.50227 lineto 0.347 0.331 0.699 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75723 0.50464 moveto
0.76121 0.51437 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.82387 0.52428 moveto
0.82466 0.5244 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76997 0.51576 moveto
0.82387 0.52428 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76121 0.51437 moveto
0.76997 0.51576 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76372 0.5241 moveto
0.78477 0.53162 lineto
stroke
grestore
gsave
0.81934 0.48 moveto 0.75186 0.49499 lineto 0.7452 0.4855 lineto 0.401 0.502 0.847 setrgbcolor
fill
grestore
gsave
0.82266 0.50227 moveto 0.75186 0.49499 lineto 0.81934 0.48 lineto 0.374 0.35 0.704 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75186 0.49499 moveto
0.75723 0.50464 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75723 0.50464 moveto
0.82266 0.50227 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.79658 0.66572 moveto
0.80415 0.65339 lineto
stroke
grestore
gsave
0.81467 0.45791 moveto 0.7452 0.4855 lineto 0.73737 0.47621 lineto 0.461 0.545 0.856 setrgbcolor
fill
grestore
gsave
0.81934 0.48 moveto 0.7452 0.4855 lineto 0.81467 0.45791 lineto 0.404 0.369 0.707 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75186 0.49499 moveto
0.81934 0.48 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.7452 0.4855 moveto
0.75186 0.49499 lineto
stroke
grestore
gsave
0.30519 0.82204 moveto 0.41126 0.77808 lineto 0.30006 0.80923 lineto 0.594 0.281 0.408 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.29716 0.79582 moveto
0.30006 0.80923 lineto
stroke
grestore
gsave
0.30519 0.82204 moveto 0.41297 0.77728 lineto 0.41126 0.77808 lineto 0.286 0.766 0.667 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4098 0.77812 moveto
0.41103 0.77809 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30006 0.80923 moveto
0.41059 0.77827 lineto
stroke
grestore
gsave
0.80863 0.43629 moveto 0.73737 0.47621 lineto 0.72849 0.46714 lineto 0.516 0.577 0.855 setrgbcolor
fill
grestore
gsave
0.81467 0.45791 moveto 0.73737 0.47621 lineto 0.80863 0.43629 lineto 0.433 0.387 0.707 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73737 0.47621 moveto
0.7452 0.4855 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81347 0.45838 moveto
0.81467 0.45791 lineto
stroke
grestore
gsave
0.32359 0.38093 moveto 0.41263 0.36514 lineto 0.31119 0.38647 lineto 0.089 0 0 setrgbcolor
fill
grestore
gsave
0.32359 0.38093 moveto 0.41807 0.35804 lineto 0.41263 0.36514 lineto 0.382 0.027 0.233 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.32359 0.38093 moveto
0.33753 0.37501 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32359 0.38093 moveto
0.32435 0.38075 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32435 0.38075 moveto
0.32482 0.38063 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40781 0.36053 moveto
0.41807 0.35804 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37504 0.36047 moveto
0.44039 0.34173 lineto
stroke
grestore
gsave
0.8012 0.41544 moveto 0.72849 0.46714 lineto 0.71871 0.45827 lineto 0.562 0.599 0.848 setrgbcolor
fill
grestore
gsave
0.80863 0.43629 moveto 0.72849 0.46714 lineto 0.8012 0.41544 lineto 0.46 0.401 0.705 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7452 0.4855 moveto
0.81347 0.45838 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72849 0.46714 moveto
0.73737 0.47621 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72849 0.46714 moveto
0.7304 0.46578 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80736 0.437 moveto
0.80863 0.43629 lineto
stroke
grestore
gsave
0.69401 0.30364 moveto 0.63616 0.39778 lineto 0.6235 0.3891 lineto 0.743 0.596 0.693 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6235 0.3891 moveto
0.62589 0.38493 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5994 0.36928 moveto
0.63537 0.29497 lineto
stroke
grestore
gsave
0.71159 0.31094 moveto 0.63616 0.39778 lineto 0.69401 0.30364 lineto 0.583 0.393 0.59 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65527 0.29665 moveto
0.65527 0.29664 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67448 0.30012 moveto
0.6755 0.29834 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.6755 0.29834 moveto
0.69401 0.30364 lineto
stroke
grestore
gsave
0.79238 0.39565 moveto 0.71871 0.45827 lineto 0.70818 0.44956 lineto 0.6 0.613 0.836 setrgbcolor
fill
grestore
gsave
0.8012 0.41544 moveto 0.71871 0.45827 lineto 0.79238 0.39565 lineto 0.486 0.413 0.7 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.71871 0.45827 moveto
0.72849 0.46714 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71871 0.45827 moveto
0.72245 0.45509 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79998 0.41631 moveto
0.8012 0.41544 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79987 0.41639 moveto
0.79998 0.41631 lineto
stroke
grestore
gsave
0.78218 0.37717 moveto 0.70818 0.44956 lineto 0.69703 0.44095 lineto 0.632 0.62 0.82 setrgbcolor
fill
grestore
gsave
0.79238 0.39565 moveto 0.70818 0.44956 lineto 0.78218 0.37717 lineto 0.508 0.421 0.692 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70818 0.44956 moveto
0.71871 0.45827 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70818 0.44956 moveto
0.71104 0.44675 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7911 0.39674 moveto
0.79238 0.39565 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.79101 0.39682 moveto
0.7911 0.39674 lineto
stroke
grestore
gsave
0.77061 0.36022 moveto 0.69703 0.44095 lineto 0.6854 0.43238 lineto 0.658 0.623 0.803 setrgbcolor
fill
grestore
gsave
0.78218 0.37717 moveto 0.69703 0.44095 lineto 0.77061 0.36022 lineto 0.528 0.425 0.682 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73737 0.47621 moveto
0.80736 0.437 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.69703 0.44095 moveto
0.70818 0.44956 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69703 0.44095 moveto
0.70115 0.43643 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78141 0.37792 moveto
0.78218 0.37717 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78085 0.37846 moveto
0.78141 0.37792 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78078 0.37853 moveto
0.78085 0.37846 lineto
stroke
grestore
gsave
0.7577 0.345 moveto 0.6854 0.43238 lineto 0.67341 0.42381 lineto 0.68 0.623 0.784 setrgbcolor
fill
grestore
gsave
0.77061 0.36022 moveto 0.6854 0.43238 lineto 0.7577 0.345 lineto 0.545 0.426 0.669 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6854 0.43238 moveto
0.69703 0.44095 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6854 0.43238 moveto
0.68834 0.42883 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7698 0.3611 moveto
0.77061 0.36022 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76926 0.36169 moveto
0.7698 0.3611 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7692 0.36176 moveto
0.76926 0.36169 lineto
stroke
grestore
gsave
0.74352 0.33165 moveto 0.67341 0.42381 lineto 0.66116 0.41518 lineto 0.699 0.62 0.764 setrgbcolor
fill
grestore
gsave
0.7577 0.345 moveto 0.67341 0.42381 lineto 0.74352 0.33165 lineto 0.559 0.424 0.654 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69329 0.30482 moveto
0.69401 0.30364 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7304 0.46578 moveto
0.79987 0.41639 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67341 0.42381 moveto
0.6854 0.43238 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67637 0.41992 moveto
0.67701 0.41908 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67341 0.42381 moveto
0.67637 0.41992 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75689 0.34599 moveto
0.7577 0.345 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75636 0.34662 moveto
0.75689 0.34599 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75632 0.34668 moveto
0.75636 0.34662 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.80415 0.65339 moveto
0.8106 0.63926 lineto
stroke
grestore
gsave
0.31249 0.83397 moveto 0.41297 0.77728 lineto 0.30519 0.82204 lineto 0.57 0.265 0.413 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.30006 0.80923 moveto
0.30519 0.82204 lineto
stroke
grestore
gsave
0.31249 0.83397 moveto 0.41475 0.77579 lineto 0.41297 0.77728 lineto 0.419 0.84 0.68 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30519 0.82204 moveto
0.40984 0.77858 lineto
stroke
grestore
gsave
0.72812 0.32028 moveto 0.66116 0.41518 lineto 0.64873 0.40649 lineto 0.715 0.614 0.743 setrgbcolor
fill
grestore
gsave
0.74352 0.33165 moveto 0.66116 0.41518 lineto 0.72812 0.32028 lineto 0.57 0.418 0.636 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69289 0.30546 moveto
0.69329 0.30482 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66116 0.41518 moveto
0.67341 0.42381 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66116 0.41518 moveto
0.6636 0.41173 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7427 0.33273 moveto
0.74352 0.33165 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7422 0.33338 moveto
0.7427 0.33273 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74217 0.33343 moveto
0.7422 0.33338 lineto
stroke
grestore
gsave
0.71159 0.31094 moveto 0.64873 0.40649 lineto 0.63616 0.39778 lineto 0.73 0.606 0.719 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63616 0.39778 moveto
0.63833 0.39425 lineto
stroke
grestore
gsave
0.72812 0.32028 moveto 0.64873 0.40649 lineto 0.71159 0.31094 lineto 0.578 0.408 0.615 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.69401 0.30364 moveto
0.71159 0.31094 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61326 0.37586 moveto
0.65527 0.29665 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62589 0.38493 moveto
0.67448 0.30012 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63833 0.39425 moveto
0.69288 0.30548 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69288 0.30548 moveto
0.69289 0.30546 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71104 0.44675 moveto
0.78078 0.37853 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70115 0.43643 moveto
0.7692 0.36176 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68834 0.42883 moveto
0.75632 0.34668 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67701 0.41908 moveto
0.74217 0.33343 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6636 0.41173 moveto
0.72682 0.32212 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64873 0.40649 moveto
0.66116 0.41518 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65168 0.40201 moveto
0.71036 0.3128 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71036 0.3128 moveto
0.71038 0.31278 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71038 0.31278 moveto
0.71082 0.31212 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71082 0.31212 moveto
0.71159 0.31094 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64873 0.40649 moveto
0.65168 0.40201 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72732 0.32142 moveto
0.72812 0.32028 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72685 0.32209 moveto
0.72732 0.32142 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72682 0.32212 moveto
0.72685 0.32209 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72245 0.45509 moveto
0.79101 0.39682 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71159 0.31094 moveto
0.72812 0.32028 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63616 0.39778 moveto
0.64873 0.40649 lineto
stroke
grestore
gsave
0.31119 0.38647 moveto 0.40815 0.37304 lineto 0.30049 0.39162 lineto 0.159 0 0 setrgbcolor
fill
grestore
gsave
0.31119 0.38647 moveto 0.41263 0.36514 lineto 0.40815 0.37304 lineto 0.465 0.143 0.335 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.31119 0.38647 moveto
0.32359 0.38093 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31119 0.38647 moveto
0.31143 0.38642 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31143 0.38642 moveto
0.31234 0.38622 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31234 0.38622 moveto
0.31269 0.38615 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40525 0.36669 moveto
0.41263 0.36514 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39273 0.36932 moveto
0.40525 0.36669 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38693 0.36558 moveto
0.40781 0.36053 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36433 0.36546 moveto
0.43195 0.34632 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6235 0.3891 moveto
0.63616 0.39778 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61076 0.38056 moveto
0.6235 0.3891 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59795 0.37229 moveto
0.61076 0.38056 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58506 0.36445 moveto
0.59795 0.37229 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57209 0.35719 moveto
0.58506 0.36445 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55907 0.35067 moveto
0.57209 0.35719 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54602 0.34503 moveto
0.55907 0.35067 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.53298 0.34037 moveto
0.54602 0.34503 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52003 0.33678 moveto
0.53298 0.34037 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50724 0.33429 moveto
0.52003 0.33678 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49473 0.33291 moveto
0.50724 0.33429 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4826 0.33264 moveto
0.49473 0.33291 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47098 0.33343 moveto
0.4826 0.33264 lineto
stroke
grestore
gsave
0.32186 0.84474 moveto 0.41475 0.77579 lineto 0.31249 0.83397 lineto 0.546 0.253 0.422 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.30519 0.82204 moveto
0.31249 0.83397 lineto
stroke
grestore
gsave
0.41475 0.77579 moveto 0.32284 0.84401 lineto 0.41648 0.77369 lineto 0.525 0.884 0.659 setrgbcolor
fill
grestore
gsave
0.41648 0.77369 moveto 0.32284 0.84401 lineto 0.32379 0.84329 lineto 0.525 0.884 0.659 setrgbcolor
fill
grestore
gsave
0.32186 0.84474 moveto 0.32379 0.84329 lineto 0.32284 0.84401 lineto 0.525 0.884 0.659 setrgbcolor
fill
grestore
gsave
0.33315 0.85407 moveto 0.41648 0.77369 lineto 0.32186 0.84474 lineto 0.524 0.246 0.436 setrgbcolor
fill
grestore
gsave
0.41648 0.77369 moveto 0.33402 0.85323 lineto 0.41805 0.7711 lineto 0.607 0.9 0.611 setrgbcolor
fill
grestore
gsave
0.33315 0.85407 moveto 0.33487 0.8524 lineto 0.33402 0.85323 lineto 0.607 0.9 0.611 setrgbcolor
fill
grestore
gsave
0.41805 0.7711 moveto 0.33402 0.85323 lineto 0.33487 0.8524 lineto 0.607 0.9 0.611 setrgbcolor
fill
grestore
gsave
0.34618 0.86173 moveto 0.41693 0.77251 lineto 0.33315 0.85407 lineto 0.504 0.245 0.455 setrgbcolor
fill
grestore
gsave
0.41805 0.7711 moveto 0.41547 0.77362 lineto 0.41693 0.77251 lineto 0.504 0.245 0.455 setrgbcolor
fill
grestore
gsave
0.33315 0.85407 moveto 0.41693 0.77251 lineto 0.41547 0.77362 lineto 0.504 0.245 0.455 setrgbcolor
fill
grestore
gsave
0.41805 0.7711 moveto 0.34692 0.86079 lineto 0.4194 0.76814 lineto 0.667 0.892 0.538 setrgbcolor
fill
grestore
gsave
0.34618 0.86173 moveto 0.34765 0.85985 lineto 0.34692 0.86079 lineto 0.667 0.892 0.538 setrgbcolor
fill
grestore
gsave
0.4194 0.76814 moveto 0.34692 0.86079 lineto 0.34765 0.85985 lineto 0.667 0.892 0.538 setrgbcolor
fill
grestore
gsave
0.36071 0.86747 moveto 0.41865 0.76942 lineto 0.34618 0.86173 lineto 0.487 0.248 0.478 setrgbcolor
fill
grestore
gsave
0.4194 0.76814 moveto 0.41756 0.7705 lineto 0.41865 0.76942 lineto 0.487 0.248 0.478 setrgbcolor
fill
grestore
gsave
0.34618 0.86173 moveto 0.41865 0.76942 lineto 0.41756 0.7705 lineto 0.487 0.248 0.478 setrgbcolor
fill
grestore
gsave
0.4194 0.76814 moveto 0.3613 0.86646 lineto 0.42053 0.76493 lineto 0.703 0.858 0.443 setrgbcolor
fill
grestore
gsave
0.36071 0.86747 moveto 0.36189 0.86544 lineto 0.3613 0.86646 lineto 0.703 0.858 0.443 setrgbcolor
fill
grestore
gsave
0.42053 0.76493 moveto 0.3613 0.86646 lineto 0.36189 0.86544 lineto 0.703 0.858 0.443 setrgbcolor
fill
grestore
gsave
0.37646 0.87112 moveto 0.42008 0.76602 lineto 0.36071 0.86747 lineto 0.474 0.258 0.504 setrgbcolor
fill
grestore
gsave
0.42053 0.76493 moveto 0.41933 0.76699 lineto 0.42008 0.76602 lineto 0.474 0.258 0.504 setrgbcolor
fill
grestore
gsave
0.36071 0.86747 moveto 0.42008 0.76602 lineto 0.41933 0.76699 lineto 0.474 0.258 0.504 setrgbcolor
fill
grestore
gsave
0.42053 0.76493 moveto 0.37691 0.87006 lineto 0.42146 0.76154 lineto 0.715 0.799 0.326 setrgbcolor
fill
grestore
gsave
0.37646 0.87112 moveto 0.37735 0.86897 lineto 0.37691 0.87006 lineto 0.715 0.799 0.326 setrgbcolor
fill
grestore
gsave
0.42146 0.76154 moveto 0.37691 0.87006 lineto 0.37735 0.86897 lineto 0.715 0.799 0.326 setrgbcolor
fill
grestore
gsave
0.39315 0.87253 moveto 0.42124 0.7624 lineto 0.37646 0.87112 lineto 0.465 0.272 0.533 setrgbcolor
fill
grestore
gsave
0.42146 0.76154 moveto 0.42078 0.7632 lineto 0.42124 0.7624 lineto 0.465 0.272 0.533 setrgbcolor
fill
grestore
gsave
0.37646 0.87112 moveto 0.42124 0.7624 lineto 0.42078 0.7632 lineto 0.465 0.272 0.533 setrgbcolor
fill
grestore
gsave
0.39315 0.87253 moveto 0.42225 0.75804 lineto 0.42146 0.76154 lineto 0.7 0.713 0.187 setrgbcolor
fill
grestore
gsave
0.41044 0.87159 moveto 0.42219 0.75863 lineto 0.39315 0.87253 lineto 0.461 0.291 0.563 setrgbcolor
fill
grestore
gsave
0.42225 0.75804 moveto 0.42195 0.75921 lineto 0.42219 0.75863 lineto 0.461 0.291 0.563 setrgbcolor
fill
grestore
gsave
0.39315 0.87253 moveto 0.42219 0.75863 lineto 0.42195 0.75921 lineto 0.461 0.291 0.563 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31249 0.83397 moveto
0.31461 0.83277 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31461 0.83277 moveto
0.41035 0.77829 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72812 0.32028 moveto
0.74352 0.33165 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.8106 0.63926 moveto
0.81591 0.62341 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46 0.33524 moveto
0.47098 0.33343 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44977 0.33803 moveto
0.46 0.33524 lineto
stroke
grestore
gsave
0.30049 0.39162 moveto 0.40453 0.38174 lineto 0.29165 0.39643 lineto 0.227 0 0 setrgbcolor
fill
grestore
gsave
0.30049 0.39162 moveto 0.40815 0.37304 lineto 0.40453 0.38174 lineto 0.53 0.231 0.404 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.30049 0.39162 moveto
0.31119 0.38647 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30049 0.39162 moveto
0.30104 0.39153 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30104 0.39153 moveto
0.30193 0.39137 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30193 0.39137 moveto
0.3022 0.39133 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39352 0.37556 moveto
0.40815 0.37304 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32482 0.38063 moveto
0.38693 0.36558 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34433 0.37319 moveto
0.40738 0.35634 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44039 0.34173 moveto
0.44977 0.33803 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.31249 0.83397 moveto
0.32186 0.84474 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.74352 0.33165 moveto
0.7577 0.345 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32186 0.84474 moveto
0.32379 0.84329 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32379 0.84329 moveto
0.3238 0.84329 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3238 0.84329 moveto
0.41183 0.77718 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81591 0.62341 moveto
0.82007 0.60598 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43195 0.34632 moveto
0.44039 0.34173 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4245 0.35177 moveto
0.43195 0.34632 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7577 0.345 moveto
0.77061 0.36022 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.82007 0.60598 moveto
0.82305 0.58715 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41807 0.35804 moveto
0.4245 0.35177 lineto
stroke
grestore
gsave
0.29165 0.39643 moveto 0.40166 0.39123 lineto 0.28482 0.40093 lineto 0.291 0 0 setrgbcolor
fill
grestore
gsave
0.29165 0.39643 moveto 0.40453 0.38174 lineto 0.40166 0.39123 lineto 0.582 0.299 0.452 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3022 0.39133 moveto
0.39352 0.37556 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.29165 0.39643 moveto
0.30049 0.39162 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29165 0.39643 moveto
0.29331 0.39621 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29331 0.39621 moveto
0.29353 0.39618 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40001 0.38233 moveto
0.40453 0.38174 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31269 0.38615 moveto
0.39273 0.36932 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33315 0.85407 moveto
0.33487 0.8524 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33487 0.8524 moveto
0.33487 0.8524 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33487 0.8524 moveto
0.41397 0.77509 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.32186 0.84474 moveto
0.33315 0.85407 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.77061 0.36022 moveto
0.78218 0.37717 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41263 0.36514 moveto
0.41807 0.35804 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.82305 0.58715 moveto
0.82483 0.56711 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40815 0.37304 moveto
0.41263 0.36514 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34618 0.86173 moveto
0.34765 0.85985 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34765 0.85985 moveto
0.41646 0.7719 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.78218 0.37717 moveto
0.79238 0.39565 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33315 0.85407 moveto
0.34618 0.86173 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.82483 0.56711 moveto
0.82538 0.54611 lineto
stroke
grestore
gsave
0.28482 0.40093 moveto 0.39942 0.40148 lineto 0.28015 0.40521 lineto 0.348 0 0 setrgbcolor
fill
grestore
gsave
0.28482 0.40093 moveto 0.40166 0.39123 lineto 0.39942 0.40148 lineto 0.626 0.353 0.485 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.28482 0.40093 moveto
0.29165 0.39643 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28482 0.40093 moveto
0.28665 0.40078 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39808 0.39153 moveto
0.40166 0.39123 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28684 0.40076 moveto
0.39808 0.39153 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28665 0.40078 moveto
0.28684 0.40076 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29353 0.39618 moveto
0.40001 0.38233 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40453 0.38174 moveto
0.40815 0.37304 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.79238 0.39565 moveto
0.8012 0.41544 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.82466 0.5244 moveto
0.82538 0.54611 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36071 0.86747 moveto
0.36189 0.86544 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36189 0.86544 moveto
0.41897 0.7676 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.8012 0.41544 moveto
0.80863 0.43629 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40166 0.39123 moveto
0.40453 0.38174 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.82266 0.50227 moveto
0.82466 0.5244 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.80863 0.43629 moveto
0.81467 0.45791 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81934 0.48 moveto
0.82266 0.50227 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.34618 0.86173 moveto
0.36071 0.86747 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81467 0.45791 moveto
0.81934 0.48 lineto
stroke
grestore
gsave
0.28015 0.40521 moveto 0.39765 0.41244 lineto 0.27775 0.40936 lineto 0.395 0 0 setrgbcolor
fill
grestore
gsave
0.28015 0.40521 moveto 0.39942 0.40148 lineto 0.39765 0.41244 lineto 0.665 0.398 0.507 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.28015 0.40521 moveto
0.28482 0.40093 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28015 0.40521 moveto
0.39942 0.40148 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39942 0.40148 moveto
0.40166 0.39123 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37646 0.87112 moveto
0.37735 0.86897 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42078 0.7632 moveto
0.4212 0.76219 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.36071 0.86747 moveto
0.37646 0.87112 lineto
stroke
grestore
gsave
0.27775 0.40936 moveto 0.39765 0.41244 lineto 0.39623 0.42404 lineto 0.701 0.437 0.522 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39765 0.41244 moveto
0.39942 0.40148 lineto
stroke
grestore
gsave
0.41044 0.87159 moveto 0.42297 0.75444 lineto 0.42225 0.75804 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42195 0.75921 moveto
0.42225 0.75804 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37735 0.86897 moveto
0.42078 0.7632 lineto
stroke
grestore
gsave
0.27775 0.40936 moveto 0.39623 0.42404 lineto 0.27773 0.41351 lineto 0.433 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.27775 0.40936 moveto
0.28015 0.40521 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27775 0.40936 moveto
0.39765 0.41244 lineto
stroke
grestore
gsave
0.27773 0.41351 moveto 0.39623 0.42404 lineto 0.39504 0.43621 lineto 0.735 0.472 0.532 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39623 0.42404 moveto
0.39765 0.41244 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37646 0.87112 moveto
0.39315 0.87253 lineto
stroke
grestore
gsave
0.42801 0.86825 moveto 0.42297 0.75444 lineto 0.41044 0.87159 lineto 0.461 0.313 0.594 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41044 0.87159 moveto
0.42291 0.75504 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39315 0.87253 moveto
0.39372 0.8703 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39372 0.8703 moveto
0.42195 0.75921 lineto
stroke
grestore
gsave
0.42801 0.86825 moveto 0.42371 0.75073 lineto 0.42297 0.75444 lineto 0 0 0.138 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42225 0.75804 moveto
0.42297 0.75444 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42291 0.75504 moveto
0.42297 0.75444 lineto
stroke
grestore
gsave
0.28015 0.41778 moveto 0.39504 0.43621 lineto 0.39399 0.44886 lineto 0.769 0.506 0.536 setrgbcolor
fill
grestore
gsave
0.27773 0.41351 moveto 0.39504 0.43621 lineto 0.28015 0.41778 lineto 0.457 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27773 0.41351 moveto
0.39623 0.42404 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39504 0.43621 moveto
0.39623 0.42404 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.27773 0.41351 moveto
0.27775 0.40936 lineto
stroke
grestore
gsave
0.28503 0.42234 moveto 0.39399 0.44886 lineto 0.39304 0.46186 lineto 0.804 0.538 0.537 setrgbcolor
fill
grestore
gsave
0.39399 0.44886 moveto 0.33364 0.43417 lineto 0.32508 0.43005 lineto 0.463 0 0 setrgbcolor
fill
grestore
gsave
0.29236 0.42734 moveto 0.39304 0.46186 lineto 0.39217 0.47512 lineto 0.84 0.571 0.531 setrgbcolor
fill
grestore
gsave
0.28503 0.42234 moveto 0.3449 0.44425 lineto 0.29236 0.42734 lineto 0.443 0 0 setrgbcolor
fill
grestore
gsave
0.39304 0.46186 moveto 0.35144 0.4476 lineto 0.3449 0.44425 lineto 0.443 0 0 setrgbcolor
fill
grestore
gsave
0.29236 0.42734 moveto 0.3449 0.44425 lineto 0.35144 0.4476 lineto 0.443 0 0 setrgbcolor
fill
grestore
gsave
0.30206 0.43297 moveto 0.39217 0.47512 lineto 0.39143 0.48852 lineto 0.879 0.605 0.519 setrgbcolor
fill
grestore
gsave
0.29236 0.42734 moveto 0.36823 0.46366 lineto 0.30206 0.43297 lineto 0.389 0 0 setrgbcolor
fill
grestore
gsave
0.39217 0.47512 moveto 0.37188 0.46563 lineto 0.36823 0.46366 lineto 0.389 0 0 setrgbcolor
fill
grestore
gsave
0.30206 0.43297 moveto 0.36823 0.46366 lineto 0.37188 0.46563 lineto 0.389 0 0 setrgbcolor
fill
grestore
gsave
0.34244 0.41285 moveto 0.40281 0.47747 lineto 0.40185 0.49005 lineto 0.965 0.683 0.449 setrgbcolor
fill
grestore
gsave
0.38074 0.46262 moveto 0.391 0.47595 lineto 0.38612 0.46538 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.391 0.47595 moveto 0.40104 0.48899 lineto 0.39384 0.47748 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.38612 0.46538 moveto 0.391 0.47595 lineto 0.39384 0.47748 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.38066 0.45681 moveto 0.38074 0.46262 lineto 0.38612 0.46538 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.40185 0.49005 moveto 0.40068 0.48822 lineto 0.40104 0.48899 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.39384 0.47748 moveto 0.40104 0.48899 lineto 0.40068 0.48822 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.37368 0.45345 moveto 0.38074 0.46262 lineto 0.38066 0.45681 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.35752 0.42051 moveto 0.37368 0.45345 lineto 0.38066 0.45681 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.35752 0.42051 moveto 0.40185 0.49005 lineto 0.40127 0.5026 lineto 0.987 0.713 0.379 setrgbcolor
fill
grestore
gsave
0.35752 0.42051 moveto 0.40055 0.50125 lineto 0.37402 0.42961 lineto 0.156 0.407 0.851 setrgbcolor
fill
grestore
gsave
0.40127 0.5026 moveto 0.40041 0.5003 lineto 0.40055 0.50125 lineto 0.156 0.407 0.851 setrgbcolor
fill
grestore
gsave
0.37402 0.42961 moveto 0.40055 0.50125 lineto 0.40041 0.5003 lineto 0.156 0.407 0.851 setrgbcolor
fill
grestore
gsave
0.40117 0.51507 moveto 0.37431 0.43053 lineto 0.40127 0.5026 lineto 0.953 0.705 0.248 setrgbcolor
fill
grestore
gsave
0.40127 0.5026 moveto 0.37431 0.43053 lineto 0.37459 0.43114 lineto 0.953 0.705 0.248 setrgbcolor
fill
grestore
gsave
0.37402 0.42961 moveto 0.37459 0.43114 lineto 0.37431 0.43053 lineto 0.953 0.705 0.248 setrgbcolor
fill
grestore
gsave
0.37402 0.42961 moveto 0.40117 0.51507 lineto 0.39159 0.44025 lineto 0.242 0.426 0.843 setrgbcolor
fill
grestore
gsave
0.40164 0.52749 moveto 0.3917 0.4412 lineto 0.40117 0.51507 lineto 0.79 0.603 0.039 setrgbcolor
fill
grestore
gsave
0.39159 0.44025 moveto 0.39179 0.44183 lineto 0.3917 0.4412 lineto 0.79 0.603 0.039 setrgbcolor
fill
grestore
gsave
0.40117 0.51507 moveto 0.3917 0.4412 lineto 0.39179 0.44183 lineto 0.79 0.603 0.039 setrgbcolor
fill
grestore
gsave
0.34244 0.41285 moveto 0.37368 0.45345 lineto 0.35752 0.42051 lineto 0.053 0.383 0.846 setrgbcolor
fill
grestore
gsave
0.28015 0.41778 moveto 0.32508 0.43005 lineto 0.28503 0.42234 lineto 0.463 0 0 setrgbcolor
fill
grestore
gsave
0.28503 0.42234 moveto 0.32508 0.43005 lineto 0.33364 0.43417 lineto 0.463 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28233 0.41813 moveto
0.31765 0.4238 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31765 0.4238 moveto
0.35555 0.42988 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39462 0.43615 moveto
0.39504 0.43621 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3936 0.43598 moveto
0.39462 0.43615 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38128 0.43401 moveto
0.3936 0.43598 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39399 0.44886 moveto
0.39504 0.43621 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28503 0.42234 moveto
0.28714 0.42285 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33364 0.43417 moveto
0.36466 0.44172 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39358 0.44876 moveto
0.39399 0.44886 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39277 0.44856 moveto
0.39358 0.44876 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39265 0.44853 moveto
0.39277 0.44856 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.27773 0.41351 moveto
0.28015 0.41778 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28015 0.41778 moveto
0.28233 0.41813 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39352 0.45532 moveto
0.39399 0.44886 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39315 0.87253 moveto
0.41044 0.87159 lineto
stroke
grestore
gsave
0.44552 0.86248 moveto 0.42371 0.75073 lineto 0.42801 0.86825 lineto 0.464 0.339 0.624 setrgbcolor
fill
grestore
gsave
0.44552 0.86248 moveto 0.42454 0.74682 lineto 0.42371 0.75073 lineto 0 0 0.31 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42297 0.75444 moveto
0.42371 0.75073 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29236 0.42734 moveto
0.2943 0.428 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2943 0.428 moveto
0.29434 0.42802 lineto
stroke
grestore
gsave
0.46261 0.85434 moveto 0.42454 0.74682 lineto 0.44552 0.86248 lineto 0.471 0.366 0.653 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42793 0.86601 moveto
0.42801 0.86825 lineto
stroke
grestore
gsave
0.46261 0.85434 moveto 0.4255 0.74263 lineto 0.42454 0.74682 lineto 0 0 0.472 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42371 0.75073 moveto
0.42375 0.7516 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42371 0.75073 moveto
0.42454 0.74682 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39157 0.48594 moveto
0.39162 0.48502 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.41044 0.87159 moveto
0.42801 0.86825 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.28015 0.41778 moveto
0.28503 0.42234 lineto
stroke
grestore
gsave
0.30206 0.43297 moveto 0.39143 0.48852 lineto 0.31398 0.43939 lineto 0 0.253 0.671 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37346 0.47712 moveto
0.39143 0.48852 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31555 0.44039 moveto
0.37346 0.47712 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31553 0.44038 moveto
0.31555 0.44039 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31498 0.44003 moveto
0.31553 0.44038 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31398 0.43939 moveto
0.31498 0.44003 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39143 0.48852 moveto
0.39157 0.48594 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37188 0.46563 moveto
0.38479 0.47167 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35467 0.45758 moveto
0.37188 0.46563 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30386 0.43381 moveto
0.35467 0.45758 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30383 0.4338 moveto
0.30386 0.43381 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30318 0.4335 moveto
0.30383 0.4338 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30206 0.43297 moveto
0.30318 0.4335 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35144 0.4476 moveto
0.37554 0.45586 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29434 0.42802 moveto
0.35144 0.4476 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28714 0.42285 moveto
0.33364 0.43417 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4015 0.47608 moveto
0.40281 0.47747 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40053 0.47503 moveto
0.4015 0.47608 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39928 0.4737 moveto
0.40053 0.47503 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39533 0.46947 moveto
0.39928 0.4737 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40185 0.49005 moveto
0.40281 0.47747 lineto
stroke
grestore
gsave
0.47898 0.84387 moveto 0.4255 0.74263 lineto 0.46261 0.85434 lineto 0.481 0.393 0.679 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44512 0.86031 moveto
0.44552 0.86248 lineto
stroke
grestore
gsave
0.47898 0.84387 moveto 0.42661 0.73803 lineto 0.4255 0.74263 lineto 0 0.052 0.612 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42381 0.75323 moveto
0.42793 0.86601 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42375 0.7516 moveto
0.42381 0.75323 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42454 0.74682 moveto
0.42478 0.74815 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42454 0.74682 moveto
0.4255 0.74263 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42801 0.86825 moveto
0.44552 0.86248 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40068 0.48822 moveto
0.40185 0.49005 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39983 0.48689 moveto
0.40068 0.48822 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39699 0.48243 moveto
0.39983 0.48689 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40127 0.5026 moveto
0.40185 0.49005 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.28503 0.42234 moveto
0.29236 0.42734 lineto
stroke
grestore
gsave
0.49431 0.83121 moveto 0.42661 0.73803 lineto 0.47898 0.84387 lineto 0.494 0.42 0.703 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46193 0.85226 moveto
0.46261 0.85434 lineto
stroke
grestore
gsave
0.49431 0.83121 moveto 0.42784 0.73289 lineto 0.42661 0.73803 lineto 0 0.205 0.721 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42518 0.75035 moveto
0.44512 0.86031 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42478 0.74815 moveto
0.42518 0.75035 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4255 0.74263 moveto
0.4261 0.74442 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4255 0.74263 moveto
0.42661 0.73803 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.44552 0.86248 moveto
0.46261 0.85434 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40041 0.5003 moveto
0.40127 0.5026 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39869 0.49567 moveto
0.40041 0.5003 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40117 0.51507 moveto
0.40127 0.5026 lineto
stroke
grestore
gsave
0.50831 0.8165 moveto 0.42784 0.73289 lineto 0.49431 0.83121 lineto 0.507 0.446 0.723 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47803 0.84195 moveto
0.47898 0.84387 lineto
stroke
grestore
gsave
0.50831 0.8165 moveto 0.42913 0.7271 lineto 0.42784 0.73289 lineto 0.132 0.332 0.797 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42703 0.74724 moveto
0.46193 0.85226 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4261 0.74442 moveto
0.42703 0.74724 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42661 0.73803 moveto
0.42773 0.7403 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42661 0.73803 moveto
0.42784 0.73289 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.29236 0.42734 moveto
0.30206 0.43297 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46261 0.85434 moveto
0.47898 0.84387 lineto
stroke
grestore
gsave
0.52072 0.7999 moveto 0.42913 0.7271 lineto 0.50831 0.8165 lineto 0.521 0.469 0.74 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49312 0.82946 moveto
0.49431 0.83121 lineto
stroke
grestore
gsave
0.52072 0.7999 moveto 0.43038 0.72055 lineto 0.42913 0.7271 lineto 0.257 0.43 0.842 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42944 0.74375 moveto
0.47803 0.84195 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42773 0.7403 moveto
0.42944 0.74375 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42784 0.73289 moveto
0.4297 0.73565 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42784 0.73289 moveto
0.42913 0.7271 lineto
stroke
grestore
gsave
0.40985 0.45249 moveto 0.40164 0.52749 lineto 0.40273 0.53987 lineto 0 0 0.2 setrgbcolor
fill
grestore
gsave
0.39159 0.44025 moveto 0.40164 0.52749 lineto 0.40985 0.45249 lineto 0.313 0.442 0.831 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.47898 0.84387 moveto
0.49431 0.83121 lineto
stroke
grestore
gsave
0.53131 0.78162 moveto 0.43038 0.72055 lineto 0.52072 0.7999 lineto 0.535 0.49 0.753 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50694 0.81495 moveto
0.50831 0.8165 lineto
stroke
grestore
gsave
0.53131 0.78162 moveto 0.43148 0.71317 lineto 0.43038 0.72055 lineto 0.36 0.498 0.862 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4297 0.73565 moveto
0.43249 0.73978 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42913 0.7271 moveto
0.432 0.73035 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42913 0.7271 moveto
0.43038 0.72055 lineto
stroke
grestore
gsave
0.42839 0.46636 moveto 0.40273 0.53987 lineto 0.40445 0.55224 lineto 0 0 0.382 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40164 0.52749 moveto
0.40199 0.52426 lineto
stroke
grestore
gsave
0.40985 0.45249 moveto 0.40273 0.53987 lineto 0.42839 0.46636 lineto 0.371 0.456 0.818 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40164 0.52749 moveto
0.40273 0.53987 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.30206 0.43297 moveto
0.31398 0.43939 lineto
stroke
grestore
gsave
0.53989 0.76188 moveto 0.43148 0.71317 lineto 0.53131 0.78162 lineto 0.548 0.508 0.763 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51922 0.79858 moveto
0.52072 0.7999 lineto
stroke
grestore
gsave
0.53989 0.76188 moveto 0.43229 0.70492 lineto 0.43148 0.71317 lineto 0.44 0.541 0.863 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43658 0.74583 moveto
0.49312 0.82946 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43249 0.73978 moveto
0.43658 0.74583 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.432 0.73035 moveto
0.43635 0.73526 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43038 0.72055 moveto
0.43468 0.72433 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43038 0.72055 moveto
0.43148 0.71317 lineto
stroke
grestore
gsave
0.44682 0.48185 moveto 0.40445 0.55224 lineto 0.40677 0.56463 lineto 0.064 0.021 0.492 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40273 0.53987 moveto
0.40401 0.5362 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40199 0.52426 moveto
0.40224 0.52198 lineto
stroke
grestore
gsave
0.42839 0.46636 moveto 0.40445 0.55224 lineto 0.44682 0.48185 lineto 0.418 0.469 0.806 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40273 0.53987 moveto
0.40445 0.55224 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42783 0.46796 moveto
0.42839 0.46636 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.49431 0.83121 moveto
0.50831 0.8165 lineto
stroke
grestore
gsave
0.46472 0.4989 moveto 0.40677 0.56463 lineto 0.4096 0.57709 lineto 0.227 0.151 0.557 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40445 0.55224 moveto
0.40691 0.54815 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40401 0.5362 moveto
0.40492 0.53358 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40224 0.52198 moveto
0.40256 0.51907 lineto
stroke
grestore
gsave
0.44682 0.48185 moveto 0.40677 0.56463 lineto 0.46472 0.4989 lineto 0.456 0.481 0.796 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40445 0.55224 moveto
0.40677 0.56463 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44587 0.48343 moveto
0.44682 0.48185 lineto
stroke
grestore
gsave
0.54628 0.74089 moveto 0.43229 0.70492 lineto 0.53989 0.76188 lineto 0.559 0.522 0.77 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52974 0.78055 moveto
0.53131 0.78162 lineto
stroke
grestore
gsave
0.54628 0.74089 moveto 0.43269 0.6958 lineto 0.43229 0.70492 lineto 0.5 0.564 0.852 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44286 0.74261 moveto
0.50694 0.81495 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43635 0.73526 moveto
0.44286 0.74261 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43468 0.72433 moveto
0.44136 0.7302 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43148 0.71317 moveto
0.4379 0.71757 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43148 0.71317 moveto
0.43229 0.70492 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.50831 0.8165 moveto
0.52072 0.7999 lineto
stroke
grestore
gsave
0.48173 0.5174 moveto 0.4096 0.57709 lineto 0.4128 0.58962 lineto 0.34 0.246 0.6 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40677 0.56463 moveto
0.4107 0.56017 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40691 0.54815 moveto
0.40869 0.54519 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40492 0.53358 moveto
0.4061 0.5302 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40256 0.51907 moveto
0.40297 0.51532 lineto
stroke
grestore
gsave
0.46472 0.4989 moveto 0.4096 0.57709 lineto 0.48173 0.5174 lineto 0.487 0.493 0.788 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40297 0.51532 moveto
0.40985 0.45249 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40677 0.56463 moveto
0.4096 0.57709 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4638 0.49994 moveto
0.46472 0.4989 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4634 0.5004 moveto
0.4638 0.49994 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.34244 0.41285 moveto
0.35752 0.42051 lineto
stroke
grestore
gsave
0.55036 0.7189 moveto 0.43269 0.6958 lineto 0.54628 0.74089 lineto 0.568 0.532 0.774 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53836 0.76106 moveto
0.53989 0.76188 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44136 0.7302 moveto
0.51922 0.79858 lineto
stroke
grestore
gsave
0.55036 0.7189 moveto 0.43258 0.68586 lineto 0.43269 0.6958 lineto 0.541 0.57 0.833 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44859 0.7249 moveto
0.52974 0.78055 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4379 0.71757 moveto
0.44859 0.7249 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43229 0.70492 moveto
0.4423 0.71022 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43229 0.70492 moveto
0.43269 0.6958 lineto
stroke
grestore
gsave
0.49748 0.53723 moveto 0.4128 0.58962 lineto 0.41623 0.60221 lineto 0.419 0.317 0.633 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4107 0.56017 moveto
0.41363 0.55685 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40869 0.54519 moveto
0.41103 0.54131 lineto
stroke
grestore
gsave
0.48173 0.5174 moveto 0.4128 0.58962 lineto 0.49748 0.53723 lineto 0.513 0.503 0.783 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4096 0.57709 moveto
0.4154 0.57229 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4096 0.57709 moveto
0.4128 0.58962 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48163 0.51748 moveto
0.48173 0.5174 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48055 0.51838 moveto
0.48163 0.51748 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48004 0.5188 moveto
0.48055 0.51838 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4061 0.5302 moveto
0.42783 0.46796 lineto
stroke
grestore
gsave
0.55203 0.69617 moveto 0.43258 0.68586 lineto 0.55036 0.7189 lineto 0.575 0.539 0.777 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54497 0.74037 moveto
0.54628 0.74089 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4423 0.71022 moveto
0.53836 0.76106 lineto
stroke
grestore
gsave
0.55203 0.69617 moveto 0.43187 0.67518 lineto 0.43258 0.68586 lineto 0.566 0.564 0.81 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45057 0.7029 moveto
0.54497 0.74037 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43269 0.6958 moveto
0.45057 0.7029 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43258 0.68586 moveto
0.43269 0.6958 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52072 0.7999 moveto
0.53131 0.78162 lineto
stroke
grestore
gsave
0.51166 0.55821 moveto 0.41623 0.60221 lineto 0.4197 0.61483 lineto 0.477 0.375 0.66 setrgbcolor
fill
grestore
gsave
0.49748 0.53723 moveto 0.41623 0.60221 lineto 0.51166 0.55821 lineto 0.534 0.513 0.779 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4154 0.57229 moveto
0.41986 0.56859 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4128 0.58962 moveto
0.42104 0.58452 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4128 0.58962 moveto
0.41623 0.60221 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49733 0.53732 moveto
0.49748 0.53723 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49604 0.53812 moveto
0.49733 0.53732 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49545 0.53848 moveto
0.49604 0.53812 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41363 0.55685 moveto
0.4634 0.5004 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41103 0.54131 moveto
0.44587 0.48343 lineto
stroke
grestore
gsave
0.55125 0.67294 moveto 0.43187 0.67518 lineto 0.55203 0.69617 lineto 0.579 0.542 0.778 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54981 0.71875 moveto
0.55036 0.7189 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43258 0.68586 moveto
0.54981 0.71875 lineto
stroke
grestore
gsave
0.55125 0.67294 moveto 0.43052 0.66387 lineto 0.43187 0.67518 lineto 0.578 0.549 0.785 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43187 0.67518 moveto
0.43258 0.68586 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43187 0.67518 moveto
0.55203 0.69617 lineto
stroke
grestore
gsave
0.524 0.58015 moveto 0.4197 0.61483 lineto 0.42301 0.62741 lineto 0.519 0.423 0.685 setrgbcolor
fill
grestore
gsave
0.51166 0.55821 moveto 0.4197 0.61483 lineto 0.524 0.58015 lineto 0.55 0.523 0.777 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41623 0.60221 moveto
0.4197 0.61483 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50997 0.55899 moveto
0.51166 0.55821 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50931 0.55929 moveto
0.50997 0.55899 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41986 0.56859 moveto
0.48004 0.5188 lineto
stroke
grestore
gsave
0.54801 0.64947 moveto 0.43052 0.66387 lineto 0.55125 0.67294 lineto 0.58 0.543 0.778 setrgbcolor
fill
grestore
gsave
0.54801 0.64947 moveto 0.42855 0.65205 lineto 0.43052 0.66387 lineto 0.579 0.526 0.76 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43052 0.66387 moveto
0.43187 0.67518 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43052 0.66387 moveto
0.55125 0.67294 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.35752 0.42051 moveto
0.37402 0.42961 lineto
stroke
grestore
gsave
0.53428 0.60283 moveto 0.42301 0.62741 lineto 0.42601 0.63985 lineto 0.55 0.463 0.71 setrgbcolor
fill
grestore
gsave
0.524 0.58015 moveto 0.42301 0.62741 lineto 0.53428 0.60283 lineto 0.563 0.53 0.777 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4197 0.61483 moveto
0.42301 0.62741 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52133 0.58103 moveto
0.524 0.58015 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42782 0.59687 moveto
0.50931 0.55929 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41623 0.60221 moveto
0.42782 0.59687 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42769 0.58041 moveto
0.49545 0.53848 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42104 0.58452 moveto
0.42769 0.58041 lineto
stroke
grestore
gsave
0.54232 0.62602 moveto 0.42855 0.65205 lineto 0.54801 0.64947 lineto 0.578 0.541 0.777 setrgbcolor
fill
grestore
gsave
0.54232 0.62602 moveto 0.42601 0.63985 lineto 0.42855 0.65205 lineto 0.569 0.497 0.735 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42855 0.65205 moveto
0.43052 0.66387 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42855 0.65205 moveto
0.54801 0.64947 lineto
stroke
grestore
gsave
0.53428 0.60283 moveto 0.42601 0.63985 lineto 0.54232 0.62602 lineto 0.572 0.537 0.777 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53912 0.6264 moveto
0.54232 0.62602 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42601 0.63985 moveto
0.53912 0.6264 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42601 0.63985 moveto
0.42855 0.65205 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42301 0.62741 moveto
0.42601 0.63985 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42301 0.62741 moveto
0.44879 0.62171 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44879 0.62171 moveto
0.53144 0.60345 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53144 0.60345 moveto
0.53428 0.60283 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43636 0.60929 moveto
0.52133 0.58103 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4197 0.61483 moveto
0.43636 0.60929 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53131 0.78162 moveto
0.53989 0.76188 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37402 0.42961 moveto
0.39159 0.44025 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53989 0.76188 moveto
0.54628 0.74089 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54628 0.74089 moveto
0.55036 0.7189 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39159 0.44025 moveto
0.40985 0.45249 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55036 0.7189 moveto
0.55203 0.69617 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40985 0.45249 moveto
0.42839 0.46636 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55125 0.67294 moveto
0.55203 0.69617 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42839 0.46636 moveto
0.44682 0.48185 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54801 0.64947 moveto
0.55125 0.67294 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54232 0.62602 moveto
0.54801 0.64947 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.44682 0.48185 moveto
0.46472 0.4989 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53428 0.60283 moveto
0.54232 0.62602 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46472 0.4989 moveto
0.48173 0.5174 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.524 0.58015 moveto
0.53428 0.60283 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48173 0.5174 moveto
0.49748 0.53723 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51166 0.55821 moveto
0.524 0.58015 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.49748 0.53723 moveto
0.51166 0.55821 lineto
stroke
grestore
gsave
0.002 setlinewidth
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
grestore
gsave
grestore
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; nowordwrap; ]
No Input Form was saved for this expression.













;[o]
-Graphics3D-
:[font = text; inactive; ]
And if Kappa is not 1, it doesn't come out even either.
:[font = input; startGroup; nowordwrap; ]
clear;top=125;kappa[s_]=2;tau[s_]:=Sin[s];width=.3;ds=.1;
pribbonfrenet
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 277; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.08079 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0260524 1.10184 0.0275459 1.10184 [
[ 0 0 0 0 ]
[ 1 1.08079 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 1.08079 lineto
0 1.08079 lineto
closepath
clip
newpath
gsave
0.002 setlinewidth
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
0.42251 0.57709 moveto
0.11113 0.25957 lineto
stroke
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
0.42251 0.57709 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
grestore
gsave
0.62348 0.67739 moveto 0.67255 0.61166 lineto 0.59409 0.65722 lineto 0.599 0.606 0.83 setrgbcolor
fill
grestore
gsave
0.62348 0.67739 moveto 0.68327 0.62767 lineto 0.67255 0.61166 lineto 0.453 0.404 0.712 setrgbcolor
fill
grestore
gsave
0.65587 0.69461 moveto 0.68327 0.62767 lineto 0.62348 0.67739 lineto 0.564 0.599 0.847 setrgbcolor
fill
grestore
gsave
0.59409 0.65722 moveto 0.66261 0.59477 lineto 0.56885 0.63417 lineto 0.63 0.616 0.818 setrgbcolor
fill
grestore
gsave
0.59409 0.65722 moveto 0.67255 0.61166 lineto 0.66261 0.59477 lineto 0.525 0.44 0.702 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.59409 0.65722 moveto
0.62348 0.67739 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59409 0.65722 moveto
0.5989 0.65443 lineto
stroke
grestore
gsave
0.65587 0.69461 moveto 0.69436 0.64274 lineto 0.68327 0.62767 lineto 0.35 0.356 0.725 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68081 0.62971 moveto
0.68327 0.62767 lineto
stroke
grestore
gsave
0.69001 0.70893 moveto 0.69436 0.64274 lineto 0.65587 0.69461 lineto 0.522 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.62348 0.67739 moveto
0.65587 0.69461 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62348 0.67739 moveto
0.6271 0.67438 lineto
stroke
grestore
gsave
0.60225 0.53042 moveto 0.59984 0.53004 lineto 0.59957 0.53113 lineto 0.727 0.687 0.812 setrgbcolor
fill
grestore
gsave
0.52843 0.51877 moveto 0.60225 0.53042 lineto 0.61139 0.52039 lineto 0.727 0.687 0.812 setrgbcolor
fill
grestore
gsave
0.62317 0.51648 moveto 0.61476 0.51779 lineto 0.596 0.54409 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.64844 0.48778 moveto 0.63209 0.49236 lineto 0.62317 0.51648 lineto 0.843 0.998 0.822 setrgbcolor
fill
grestore
gsave
0.604 0.52025 moveto 0.61573 0.5086 lineto 0.60543 0.50674 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.60543 0.50674 moveto 0.61573 0.5086 lineto 0.61644 0.50501 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.604 0.52025 moveto 0.60543 0.50674 lineto 0.60223 0.52021 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.62317 0.51648 moveto 0.61573 0.5086 lineto 0.61389 0.51792 lineto 0.968 0.879 0.494 setrgbcolor
fill
grestore
gsave
0.63209 0.49236 moveto 0.61989 0.50448 lineto 0.62317 0.51648 lineto 0.843 0.998 0.822 setrgbcolor
fill
grestore
gsave
0.61573 0.5086 moveto 0.61615 0.50904 lineto 0.61989 0.50448 lineto 0.843 0.998 0.822 setrgbcolor
fill
grestore
gsave
0.62317 0.51648 moveto 0.61989 0.50448 lineto 0.61615 0.50904 lineto 0.843 0.998 0.822 setrgbcolor
fill
grestore
gsave
0.52843 0.51877 moveto 0.61989 0.50448 lineto 0.53633 0.48674 lineto 0.746 0.712 0.819 setrgbcolor
fill
grestore
gsave
0.53633 0.48674 moveto 0.61989 0.50448 lineto 0.62372 0.49978 lineto 0.746 0.712 0.819 setrgbcolor
fill
grestore
gsave
0.61989 0.50448 moveto 0.61644 0.50501 lineto 0.61573 0.5086 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.63209 0.49236 moveto 0.6313 0.49258 lineto 0.61573 0.5086 lineto 0.843 0.998 0.822 setrgbcolor
fill
grestore
gsave
0.62372 0.49978 moveto 0.63155 0.49105 lineto 0.53633 0.48674 lineto 0.774 0.639 0.711 setrgbcolor
fill
grestore
gsave
0.64844 0.48778 moveto 0.63267 0.48432 lineto 0.6313 0.49258 lineto 0.98 0.852 0.642 setrgbcolor
fill
grestore
gsave
0.67061 0.45843 moveto 0.656 0.46348 lineto 0.64844 0.48778 lineto 0.872 0.964 0.855 setrgbcolor
fill
grestore
gsave
0.63286 0.48316 moveto 0.63267 0.48432 lineto 0.63402 0.48311 lineto 0.774 0.639 0.711 setrgbcolor
fill
grestore
gsave
0.53633 0.48674 moveto 0.63155 0.49105 lineto 0.63286 0.48316 lineto 0.774 0.639 0.711 setrgbcolor
fill
grestore
gsave
0.55155 0.45497 moveto 0.63505 0.48172 lineto 0.64313 0.46472 lineto 0.809 0.684 0.726 setrgbcolor
fill
grestore
gsave
0.63267 0.48432 moveto 0.63402 0.48311 lineto 0.63208 0.48419 lineto 0.872 0.964 0.855 setrgbcolor
fill
grestore
gsave
0.64259 0.47545 moveto 0.63505 0.48172 lineto 0.63402 0.48311 lineto 0.872 0.964 0.855 setrgbcolor
fill
grestore
gsave
0.53633 0.48674 moveto 0.63402 0.48311 lineto 0.55155 0.45497 lineto 0.763 0.738 0.829 setrgbcolor
fill
grestore
gsave
0.55155 0.45497 moveto 0.63402 0.48311 lineto 0.63505 0.48172 lineto 0.763 0.738 0.829 setrgbcolor
fill
grestore
gsave
0.63208 0.48419 moveto 0.63402 0.48311 lineto 0.63505 0.48172 lineto 0.872 0.964 0.855 setrgbcolor
fill
grestore
gsave
0.64844 0.48778 moveto 0.656 0.46348 lineto 0.63267 0.48432 lineto 0.872 0.964 0.855 setrgbcolor
fill
grestore
gsave
0.63884 0.48294 moveto 0.63505 0.48172 lineto 0.63402 0.48311 lineto 0.763 0.738 0.829 setrgbcolor
fill
grestore
gsave
0.63884 0.48294 moveto 0.64012 0.47751 lineto 0.63505 0.48172 lineto 0.809 0.684 0.726 setrgbcolor
fill
grestore
gsave
0.64313 0.46472 moveto 0.63505 0.48172 lineto 0.64012 0.47751 lineto 0.809 0.684 0.726 setrgbcolor
fill
grestore
gsave
0.61007 0.47936 moveto 0.63208 0.48419 lineto 0.656 0.46348 lineto 0.872 0.964 0.855 setrgbcolor
fill
grestore
gsave
0.656 0.46348 moveto 0.63208 0.48419 lineto 0.64259 0.47545 lineto 0.872 0.964 0.855 setrgbcolor
fill
grestore
gsave
0.63884 0.48294 moveto 0.63402 0.48311 lineto 0.63155 0.49105 lineto 0.774 0.639 0.711 setrgbcolor
fill
grestore
gsave
0.63155 0.49105 moveto 0.63402 0.48311 lineto 0.63267 0.48432 lineto 0.774 0.639 0.711 setrgbcolor
fill
grestore
gsave
0.63884 0.48294 moveto 0.62372 0.49978 lineto 0.63859 0.48566 lineto 0.774 0.639 0.711 setrgbcolor
fill
grestore
gsave
0.60704 0.49938 moveto 0.6313 0.49258 lineto 0.61007 0.47936 lineto 0.98 0.852 0.642 setrgbcolor
fill
grestore
gsave
0.61007 0.47936 moveto 0.6313 0.49258 lineto 0.63267 0.48432 lineto 0.98 0.852 0.642 setrgbcolor
fill
grestore
gsave
0.60704 0.49938 moveto 0.61512 0.50795 lineto 0.6313 0.49258 lineto 0.843 0.998 0.822 setrgbcolor
fill
grestore
gsave
0.61573 0.5086 moveto 0.6313 0.49258 lineto 0.61512 0.50795 lineto 0.843 0.998 0.822 setrgbcolor
fill
grestore
gsave
0.63711 0.50178 moveto 0.63859 0.48566 lineto 0.62372 0.49978 lineto 0.774 0.639 0.711 setrgbcolor
fill
grestore
gsave
0.63711 0.50178 moveto 0.62372 0.49978 lineto 0.61989 0.50448 lineto 0.746 0.712 0.819 setrgbcolor
fill
grestore
gsave
0.62899 0.50305 moveto 0.61989 0.50448 lineto 0.61139 0.52039 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.61139 0.52039 moveto 0.61989 0.50448 lineto 0.604 0.52025 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.60297 0.51963 moveto 0.61389 0.51792 lineto 0.60704 0.49938 lineto 0.968 0.879 0.494 setrgbcolor
fill
grestore
gsave
0.60704 0.49938 moveto 0.61389 0.51792 lineto 0.61573 0.5086 lineto 0.968 0.879 0.494 setrgbcolor
fill
grestore
gsave
0.52843 0.51877 moveto 0.60223 0.52021 lineto 0.60543 0.50674 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.59957 0.53113 moveto 0.6012 0.53148 lineto 0.60225 0.53042 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.596 0.54409 moveto 0.61476 0.51779 lineto 0.6115 0.52108 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.596 0.54409 moveto 0.6115 0.52108 lineto 0.60791 0.52471 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.59957 0.53113 moveto 0.59894 0.53376 lineto 0.6012 0.53148 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.59971 0.53178 moveto 0.59919 0.53351 lineto 0.61188 0.51824 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.596 0.54409 moveto 0.60791 0.52471 lineto 0.59919 0.53351 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.61188 0.51824 moveto 0.59919 0.53351 lineto 0.60791 0.52471 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.52803 0.55021 moveto 0.58801 0.54479 lineto 0.59957 0.53113 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.59677 0.54262 moveto 0.59739 0.5403 lineto 0.5969 0.54235 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.596 0.54409 moveto 0.60339 0.51956 lineto 0.6027 0.52058 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.596 0.54409 moveto 0.59882 0.53418 lineto 0.59677 0.54262 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.59894 0.53376 moveto 0.5969 0.54235 lineto 0.6012 0.53148 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.59651 0.54403 moveto 0.59726 0.54202 lineto 0.5969 0.54235 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.6012 0.53148 moveto 0.5969 0.54235 lineto 0.59726 0.54202 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.60297 0.51963 moveto 0.6027 0.52058 lineto 0.60339 0.51956 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.60297 0.51963 moveto 0.59677 0.54262 lineto 0.59882 0.53418 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.596 0.54409 moveto 0.59674 0.54266 lineto 0.56819 0.57028 lineto 0.521 0.844 0.549 setrgbcolor
fill
grestore
gsave
0.56819 0.57028 moveto 0.59674 0.54266 lineto 0.59026 0.54882 lineto 0.521 0.844 0.549 setrgbcolor
fill
grestore
gsave
0.5969 0.54235 moveto 0.59499 0.54417 lineto 0.56819 0.57028 lineto 0.521 0.844 0.549 setrgbcolor
fill
grestore
gsave
0.58801 0.54479 moveto 0.57865 0.55724 lineto 0.59499 0.54417 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.57181 0.56632 moveto 0.57685 0.5615 lineto 0.57865 0.55724 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.59499 0.54417 moveto 0.57865 0.55724 lineto 0.57685 0.5615 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.57965 0.55866 moveto 0.57685 0.5615 lineto 0.59499 0.54417 lineto 0.521 0.844 0.549 setrgbcolor
fill
grestore
gsave
0.56819 0.57028 moveto 0.59499 0.54417 lineto 0.57685 0.5615 lineto 0.521 0.844 0.549 setrgbcolor
fill
grestore
gsave
0.56896 0.56995 moveto 0.57614 0.56257 lineto 0.57421 0.56777 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.5766 0.5621 moveto 0.57539 0.56496 lineto 0.57614 0.56257 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.57421 0.56777 moveto 0.57614 0.56257 lineto 0.57539 0.56496 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.56819 0.57028 moveto 0.57456 0.56762 lineto 0.541 0.59474 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.64114 0.54 moveto 0.57969 0.56333 lineto 0.64654 0.55881 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.64654 0.55881 moveto 0.57969 0.56333 lineto 0.57801 0.56473 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.64654 0.55881 moveto 0.57539 0.56496 lineto 0.57507 0.56599 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.57456 0.56762 moveto 0.56673 0.57418 lineto 0.541 0.59474 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.5418 0.59411 moveto 0.54184 0.59419 lineto 0.56673 0.57418 lineto 0.683 0.646 0.808 setrgbcolor
fill
grestore
gsave
0.54885 0.60843 moveto 0.56383 0.57973 lineto 0.54184 0.59419 lineto 0.683 0.646 0.808 setrgbcolor
fill
grestore
gsave
0.56673 0.57418 moveto 0.54184 0.59419 lineto 0.56383 0.57973 lineto 0.683 0.646 0.808 setrgbcolor
fill
grestore
gsave
0.64654 0.55881 moveto 0.56673 0.57418 lineto 0.54885 0.60843 lineto 0.683 0.646 0.808 setrgbcolor
fill
grestore
gsave
0.51574 0.61726 moveto 0.54098 0.59476 lineto 0.58789 0.57958 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.541 0.59474 moveto 0.54102 0.59473 lineto 0.54098 0.59476 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.58789 0.57958 moveto 0.54098 0.59476 lineto 0.54102 0.59473 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.54685 0.59083 moveto 0.54103 0.59472 lineto 0.56673 0.57418 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.541 0.59474 moveto 0.56673 0.57418 lineto 0.54103 0.59472 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.535 0.58029 moveto 0.5418 0.59411 lineto 0.56673 0.57418 lineto 0.683 0.646 0.808 setrgbcolor
fill
grestore
gsave
0.56819 0.57028 moveto 0.56999 0.56845 lineto 0.56896 0.56995 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.5969 0.54235 moveto 0.59026 0.54882 lineto 0.59674 0.54266 lineto 0.521 0.844 0.549 setrgbcolor
fill
grestore
gsave
0.59499 0.54417 moveto 0.57685 0.5615 lineto 0.64114 0.54 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.56999 0.56845 moveto 0.57685 0.5615 lineto 0.56896 0.56995 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.56896 0.56995 moveto 0.57685 0.5615 lineto 0.5766 0.5621 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.57181 0.56632 moveto 0.57539 0.56496 lineto 0.57685 0.5615 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.64114 0.54 moveto 0.57685 0.5615 lineto 0.57539 0.56496 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.59651 0.54403 moveto 0.59894 0.53376 lineto 0.58801 0.54479 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.64114 0.54 moveto 0.6012 0.53148 lineto 0.59651 0.54403 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.60011 0.53047 moveto 0.59971 0.53178 lineto 0.59978 0.5317 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.60011 0.53047 moveto 0.59978 0.5317 lineto 0.61188 0.51824 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.60339 0.51956 moveto 0.60011 0.53047 lineto 0.61188 0.51824 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.59819 0.53988 moveto 0.59704 0.54209 lineto 0.60297 0.51963 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.5969 0.54235 moveto 0.59757 0.53986 lineto 0.59704 0.54209 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.60297 0.51963 moveto 0.59704 0.54209 lineto 0.59757 0.53986 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.60297 0.51963 moveto 0.5969 0.54235 lineto 0.59739 0.5403 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.59819 0.53988 moveto 0.57965 0.55866 lineto 0.5969 0.54235 lineto 0.521 0.844 0.549 setrgbcolor
fill
grestore
gsave
0.59819 0.53988 moveto 0.5766 0.5621 lineto 0.57685 0.5615 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.5627 0.57495 moveto 0.57289 0.57299 lineto 0.57181 0.56632 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.64654 0.55881 moveto 0.57507 0.56599 lineto 0.57289 0.57299 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.57421 0.56777 moveto 0.57469 0.56721 lineto 0.57456 0.56762 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.57539 0.56496 moveto 0.57801 0.56473 lineto 0.57969 0.56333 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.59819 0.53988 moveto 0.57421 0.56777 lineto 0.5766 0.5621 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.57181 0.56632 moveto 0.57289 0.57299 lineto 0.57507 0.56599 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.59303 0.55993 moveto 0.57456 0.56762 lineto 0.59819 0.53988 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.59819 0.53988 moveto 0.57456 0.56762 lineto 0.57469 0.56721 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.59303 0.55993 moveto 0.54685 0.59083 lineto 0.57456 0.56762 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.57181 0.56632 moveto 0.57507 0.56599 lineto 0.57539 0.56496 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.56705 0.56812 moveto 0.57181 0.56632 lineto 0.58801 0.54479 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.535 0.58029 moveto 0.5627 0.57495 lineto 0.57181 0.56632 lineto 0.666 0.532 0.692 setrgbcolor
fill
grestore
gsave
0.59957 0.53113 moveto 0.58801 0.54479 lineto 0.59894 0.53376 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.60884 0.52319 moveto 0.60791 0.52471 lineto 0.61359 0.51797 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.61359 0.51797 moveto 0.60791 0.52471 lineto 0.6115 0.52108 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.63711 0.50178 moveto 0.62899 0.50305 lineto 0.63792 0.52091 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.61476 0.51779 moveto 0.61389 0.51792 lineto 0.6115 0.52108 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.6115 0.52108 moveto 0.61389 0.51792 lineto 0.6131 0.51871 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.63792 0.52091 moveto 0.62899 0.50305 lineto 0.61139 0.52039 lineto 0.739 0.599 0.701 setrgbcolor
fill
grestore
gsave
0.61359 0.51797 moveto 0.6131 0.51871 lineto 0.61389 0.51792 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.63792 0.52091 moveto 0.60225 0.53042 lineto 0.64114 0.54 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.64114 0.54 moveto 0.60225 0.53042 lineto 0.6012 0.53148 lineto 0.703 0.564 0.695 setrgbcolor
fill
grestore
gsave
0.52803 0.55021 moveto 0.59957 0.53113 lineto 0.52843 0.51877 lineto 0.727 0.687 0.812 setrgbcolor
fill
grestore
gsave
0.52843 0.51877 moveto 0.59957 0.53113 lineto 0.59984 0.53004 lineto 0.727 0.687 0.812 setrgbcolor
fill
grestore
gsave
0.63792 0.52091 moveto 0.61139 0.52039 lineto 0.60225 0.53042 lineto 0.727 0.687 0.812 setrgbcolor
fill
grestore
gsave
0.61188 0.51824 moveto 0.60884 0.52319 lineto 0.61359 0.51797 lineto 0.735 0.975 0.727 setrgbcolor
fill
grestore
gsave
0.535 0.58029 moveto 0.56705 0.56812 lineto 0.52803 0.55021 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.52803 0.55021 moveto 0.56705 0.56812 lineto 0.58801 0.54479 lineto 0.706 0.665 0.808 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60704 0.49938 moveto
0.61512 0.50795 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61512 0.50795 moveto
0.61573 0.5086 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63722 0.50052 moveto
0.64844 0.48778 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59938 0.53222 moveto
0.60297 0.51963 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59894 0.53376 moveto
0.59938 0.53222 lineto
stroke
grestore
gsave
0.56885 0.63417 moveto 0.65382 0.57712 lineto 0.54885 0.60843 lineto 0.657 0.63 0.811 setrgbcolor
fill
grestore
gsave
0.56885 0.63417 moveto 0.66261 0.59477 lineto 0.65382 0.57712 lineto 0.58 0.472 0.696 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.56885 0.63417 moveto
0.59409 0.65722 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67872 0.63145 moveto
0.68081 0.62971 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6271 0.67438 moveto
0.67872 0.63145 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66901 0.61371 moveto
0.67255 0.61166 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5989 0.65443 moveto
0.66901 0.61371 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56885 0.63417 moveto
0.57469 0.63172 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62796 0.48329 moveto
0.63267 0.48432 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63859 0.48562 moveto
0.64844 0.48778 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57965 0.55866 moveto
0.59819 0.53988 lineto
stroke
grestore
gsave
0.69001 0.70893 moveto 0.70544 0.65682 lineto 0.69436 0.64274 lineto 0.186 0.284 0.732 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69167 0.64636 moveto
0.69294 0.64465 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69294 0.64465 moveto
0.69436 0.64274 lineto
stroke
grestore
gsave
0.72462 0.72043 moveto 0.70544 0.65682 lineto 0.69001 0.70893 lineto 0.471 0.595 0.895 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65587 0.69461 moveto
0.65817 0.69152 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65817 0.69152 moveto
0.69167 0.64636 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.65587 0.69461 moveto
0.69001 0.70893 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69001 0.70893 moveto
0.70494 0.6585 lineto
stroke
grestore
gsave
0.79781 0.31442 moveto 0.72881 0.38649 lineto 0.82021 0.31855 lineto 0.768 0.869 0.923 setrgbcolor
fill
grestore
gsave
0.79781 0.31442 moveto 0.71818 0.38712 lineto 0.72881 0.38649 lineto 0.777 0.892 0.926 setrgbcolor
fill
grestore
gsave
0.54885 0.60843 moveto 0.65382 0.57712 lineto 0.64654 0.55881 lineto 0.626 0.502 0.692 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64825 0.57878 moveto
0.65382 0.57712 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54885 0.60843 moveto
0.5555 0.60644 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57861 0.55972 moveto
0.57965 0.55866 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54885 0.60843 moveto
0.56885 0.63417 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65801 0.59671 moveto
0.66261 0.59477 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54554 0.6017 moveto
0.54885 0.60843 lineto
stroke
grestore
gsave
0.57348 0.4244 moveto 0.64313 0.46472 lineto 0.64987 0.44754 lineto 0.842 0.736 0.746 setrgbcolor
fill
grestore
gsave
0.55155 0.45497 moveto 0.64313 0.46472 lineto 0.57348 0.4244 lineto 0.777 0.765 0.842 setrgbcolor
fill
grestore
gsave
0.67061 0.45843 moveto 0.61177 0.45979 lineto 0.61007 0.47936 lineto 0.925 0.79 0.693 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61007 0.47936 moveto
0.62796 0.48329 lineto
stroke
grestore
gsave
0.60111 0.39603 moveto 0.64987 0.44754 lineto 0.65877 0.4318 lineto 0.87 0.793 0.773 setrgbcolor
fill
grestore
gsave
0.57348 0.4244 moveto 0.64987 0.44754 lineto 0.60111 0.39603 lineto 0.787 0.792 0.856 setrgbcolor
fill
grestore
gsave
0.68856 0.42892 moveto 0.61177 0.45979 lineto 0.67061 0.45843 lineto 0.866 0.917 0.862 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.64844 0.48778 moveto
0.67061 0.45843 lineto
stroke
grestore
gsave
0.77001 0.3153 moveto 0.71818 0.38712 lineto 0.79781 0.31442 lineto 0.77 0.87 0.921 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.80612 0.32902 moveto
0.82021 0.31855 lineto
stroke
grestore
gsave
0.77001 0.3153 moveto 0.70634 0.39066 lineto 0.71818 0.38712 lineto 0.798 0.922 0.92 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.71818 0.38712 moveto
0.72881 0.38649 lineto
stroke
grestore
gsave
0.541 0.59474 moveto 0.59303 0.55993 lineto 0.58789 0.57958 lineto 0.16 0 0.393 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.541 0.59474 moveto
0.54103 0.59472 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54103 0.59472 moveto
0.54417 0.59262 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54417 0.59262 moveto
0.54685 0.59083 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.535 0.58029 moveto
0.54164 0.59379 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54164 0.59379 moveto
0.5418 0.59411 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57685 0.5615 moveto
0.57861 0.55972 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.541 0.59474 moveto
0.54177 0.59405 lineto
stroke
grestore
gsave
0.72462 0.72043 moveto 0.71612 0.66984 lineto 0.70544 0.65682 lineto 0 0.16 0.696 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70494 0.6585 moveto
0.70544 0.65682 lineto
stroke
grestore
gsave
0.75838 0.7293 moveto 0.71612 0.66984 lineto 0.72462 0.72043 lineto 0.406 0.597 0.923 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.69001 0.70893 moveto
0.72462 0.72043 lineto
stroke
grestore
gsave
0.73803 0.32147 moveto 0.70634 0.39066 lineto 0.77001 0.3153 lineto 0.776 0.869 0.917 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78967 0.32184 moveto
0.79781 0.31442 lineto
stroke
grestore
gsave
0.73803 0.32147 moveto 0.69385 0.39707 lineto 0.70634 0.39066 lineto 0.829 0.936 0.899 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70634 0.39066 moveto
0.71818 0.38712 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5627 0.57495 moveto
0.56673 0.57418 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5905 0.5696 moveto
0.64654 0.55881 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.535 0.58029 moveto
0.5422 0.5789 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5422 0.5789 moveto
0.55277 0.57687 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55277 0.57687 moveto
0.5627 0.57495 lineto
stroke
grestore
gsave
0.73803 0.32147 moveto 0.70651 0.33191 lineto 0.69385 0.39707 lineto 0.783 0.864 0.91 setrgbcolor
fill
grestore
gsave
0.69385 0.39707 moveto 0.70651 0.33191 lineto 0.70333 0.33329 lineto 0.783 0.864 0.91 setrgbcolor
fill
grestore
gsave
0.69385 0.39707 moveto 0.69715 0.37485 lineto 0.68133 0.40623 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.68133 0.40623 moveto 0.69715 0.37485 lineto 0.68929 0.37983 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.70019 0.32191 moveto 0.65172 0.3557 lineto 0.70372 0.33312 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.68133 0.40623 moveto 0.70323 0.33344 lineto 0.66823 0.3514 lineto 0.789 0.854 0.899 setrgbcolor
fill
grestore
gsave
0.70323 0.33344 moveto 0.70018 0.34358 lineto 0.70333 0.33329 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.70333 0.33329 moveto 0.70018 0.34358 lineto 0.70023 0.34354 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.70333 0.33329 moveto 0.69468 0.36184 lineto 0.69473 0.36181 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.70333 0.33329 moveto 0.68929 0.37983 lineto 0.69715 0.37485 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.65172 0.3557 moveto 0.63388 0.36813 lineto 0.65692 0.35955 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.60033 0.39151 moveto 0.63472 0.37209 lineto 0.63388 0.36813 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.65692 0.35955 moveto 0.63388 0.36813 lineto 0.63472 0.37209 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.65877 0.4318 moveto 0.63553 0.37659 lineto 0.60111 0.39603 lineto 0.793 0.817 0.871 setrgbcolor
fill
grestore
gsave
0.60111 0.39603 moveto 0.63553 0.37659 lineto 0.61003 0.38899 lineto 0.793 0.817 0.871 setrgbcolor
fill
grestore
gsave
0.60033 0.39151 moveto 0.62566 0.39486 lineto 0.63437 0.37874 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.66944 0.41791 moveto 0.64069 0.38064 lineto 0.65877 0.4318 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.63637 0.37504 moveto 0.63932 0.38253 lineto 0.64069 0.38064 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.65877 0.4318 moveto 0.64069 0.38064 lineto 0.63932 0.38253 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.65877 0.4318 moveto 0.63637 0.37504 lineto 0.63599 0.37574 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.65877 0.4318 moveto 0.63599 0.37574 lineto 0.63581 0.37725 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.63496 0.37321 moveto 0.63563 0.3764 lineto 0.63599 0.37574 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.63581 0.37725 moveto 0.63599 0.37574 lineto 0.63563 0.3764 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.66944 0.41791 moveto 0.66786 0.35275 lineto 0.63496 0.37321 lineto 0.793 0.838 0.886 setrgbcolor
fill
grestore
gsave
0.68133 0.40623 moveto 0.67537 0.38129 lineto 0.66944 0.41791 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.66944 0.41791 moveto 0.67537 0.38129 lineto 0.66958 0.38586 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.66944 0.41791 moveto 0.66971 0.3576 lineto 0.66837 0.35933 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.66786 0.35275 moveto 0.66803 0.35977 lineto 0.66823 0.3514 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.66944 0.41791 moveto 0.66837 0.35933 lineto 0.66803 0.35977 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.66823 0.3514 moveto 0.66803 0.35977 lineto 0.66837 0.35933 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.60033 0.39151 moveto 0.63437 0.37874 lineto 0.63563 0.3764 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.66971 0.3576 moveto 0.66958 0.38586 lineto 0.67537 0.38129 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.66823 0.3514 moveto 0.66837 0.35933 lineto 0.66971 0.3576 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.70323 0.33344 moveto 0.63472 0.37211 lineto 0.6906 0.35287 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.60033 0.39151 moveto 0.63563 0.3764 lineto 0.63472 0.37211 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.63496 0.37321 moveto 0.63599 0.37574 lineto 0.63637 0.37504 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.6906 0.35287 moveto 0.63472 0.37211 lineto 0.63563 0.3764 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.60033 0.39151 moveto 0.70323 0.33344 lineto 0.70239 0.33388 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.63309 0.3708 moveto 0.63581 0.37725 lineto 0.63496 0.37321 lineto 0.885 0.85 0.804 setrgbcolor
fill
grestore
gsave
0.63437 0.37874 moveto 0.66113 0.36869 lineto 0.63563 0.3764 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.68259 0.36063 moveto 0.66202 0.36754 lineto 0.66113 0.36869 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.63563 0.3764 moveto 0.66113 0.36869 lineto 0.66202 0.36754 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.68133 0.40623 moveto 0.69473 0.36181 lineto 0.69468 0.36184 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.70126 0.39982 moveto 0.62844 0.4184 lineto 0.61187 0.44094 lineto 0.827 0.708 0.733 setrgbcolor
fill
grestore
gsave
0.62827 0.41844 moveto 0.62812 0.41865 lineto 0.62844 0.4184 lineto 0.827 0.708 0.733 setrgbcolor
fill
grestore
gsave
0.61187 0.44094 moveto 0.62844 0.4184 lineto 0.62812 0.41865 lineto 0.827 0.708 0.733 setrgbcolor
fill
grestore
gsave
0.6906 0.35287 moveto 0.66484 0.3639 lineto 0.68259 0.36063 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.63563 0.3764 moveto 0.66202 0.36754 lineto 0.66484 0.3639 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.68259 0.36063 moveto 0.66484 0.3639 lineto 0.66202 0.36754 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.66366 0.3869 moveto 0.62706 0.39941 lineto 0.63509 0.40997 lineto 0.791 0.686 0.748 setrgbcolor
fill
grestore
gsave
0.60632 0.40649 moveto 0.62065 0.40823 lineto 0.62706 0.39941 lineto 0.791 0.686 0.748 setrgbcolor
fill
grestore
gsave
0.63509 0.40997 moveto 0.62706 0.39941 lineto 0.62065 0.40823 lineto 0.791 0.686 0.748 setrgbcolor
fill
grestore
gsave
0.63309 0.3708 moveto 0.61003 0.38899 lineto 0.63553 0.37659 lineto 0.793 0.817 0.871 setrgbcolor
fill
grestore
gsave
0.62566 0.39486 moveto 0.60388 0.39198 lineto 0.60632 0.40649 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.60033 0.39151 moveto 0.60107 0.39335 lineto 0.60388 0.39198 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.60632 0.40649 moveto 0.60388 0.39198 lineto 0.60107 0.39335 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.68259 0.36063 moveto 0.63437 0.37874 lineto 0.62566 0.39486 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.65172 0.3557 moveto 0.65692 0.35955 lineto 0.66639 0.35366 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.65172 0.3557 moveto 0.66766 0.35349 lineto 0.66911 0.34815 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.63309 0.3708 moveto 0.63496 0.37321 lineto 0.66778 0.34955 lineto 0.793 0.838 0.886 setrgbcolor
fill
grestore
gsave
0.66778 0.34955 moveto 0.63496 0.37321 lineto 0.66786 0.35275 lineto 0.793 0.838 0.886 setrgbcolor
fill
grestore
gsave
0.66766 0.35349 moveto 0.66639 0.35366 lineto 0.65692 0.35955 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.70372 0.33312 moveto 0.66911 0.34815 lineto 0.66766 0.35349 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.66778 0.34955 moveto 0.66786 0.35275 lineto 0.66823 0.3514 lineto 0.883 0.899 0.837 setrgbcolor
fill
grestore
gsave
0.66778 0.34955 moveto 0.66823 0.3514 lineto 0.70338 0.33295 lineto 0.789 0.854 0.899 setrgbcolor
fill
grestore
gsave
0.70327 0.33338 moveto 0.70239 0.33388 lineto 0.70323 0.33344 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.70338 0.33295 moveto 0.66823 0.3514 lineto 0.70323 0.33344 lineto 0.789 0.854 0.899 setrgbcolor
fill
grestore
gsave
0.69468 0.36184 moveto 0.70023 0.34354 lineto 0.70018 0.34358 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.70763 0.34557 moveto 0.6906 0.35287 lineto 0.68259 0.36063 lineto 0.762 0.673 0.764 setrgbcolor
fill
grestore
gsave
0.61012 0.42307 moveto 0.63509 0.40997 lineto 0.60632 0.40649 lineto 0.791 0.686 0.748 setrgbcolor
fill
grestore
gsave
0.70785 0.3718 moveto 0.66366 0.3869 lineto 0.63509 0.40997 lineto 0.791 0.686 0.748 setrgbcolor
fill
grestore
gsave
0.61012 0.42307 moveto 0.61075 0.42953 lineto 0.62827 0.41844 lineto 0.827 0.708 0.733 setrgbcolor
fill
grestore
gsave
0.61187 0.44094 moveto 0.62827 0.41844 lineto 0.61075 0.42953 lineto 0.827 0.708 0.733 setrgbcolor
fill
grestore
gsave
0.70338 0.33295 moveto 0.70323 0.33344 lineto 0.70333 0.33329 lineto 0.861 0.929 0.87 setrgbcolor
fill
grestore
gsave
0.70372 0.33312 moveto 0.70327 0.33338 lineto 0.70763 0.34557 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.70763 0.34557 moveto 0.70327 0.33338 lineto 0.6906 0.35287 lineto 0.785 0.796 0.862 setrgbcolor
fill
grestore
gsave
0.70338 0.33295 moveto 0.70333 0.33329 lineto 0.70651 0.33191 lineto 0.783 0.864 0.91 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71856 0.35478 moveto
0.73803 0.32147 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69385 0.39707 moveto
0.70405 0.37962 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.69385 0.39707 moveto
0.70634 0.39066 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76436 0.32199 moveto
0.77001 0.3153 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73307 0.35903 moveto
0.76436 0.32199 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70634 0.39066 moveto
0.73307 0.35903 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78926 0.32222 moveto
0.78967 0.32184 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71818 0.38712 moveto
0.78926 0.32222 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72881 0.38649 moveto
0.80612 0.32902 lineto
stroke
grestore
gsave
0.68856 0.42892 moveto 0.61187 0.44094 lineto 0.61177 0.45979 lineto 0.871 0.742 0.717 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65812 0.45872 moveto
0.67061 0.45843 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64258 0.45908 moveto
0.65301 0.45884 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65301 0.45884 moveto
0.65812 0.45872 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61177 0.45979 moveto
0.64258 0.45908 lineto
stroke
grestore
gsave
0.70126 0.39982 moveto 0.61187 0.44094 lineto 0.68856 0.42892 lineto 0.847 0.874 0.861 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.67061 0.45843 moveto
0.68856 0.42892 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61187 0.44094 moveto
0.66141 0.43317 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66141 0.43317 moveto
0.68856 0.42892 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68411 0.4042 moveto
0.69385 0.39707 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68176 0.40479 moveto
0.68496 0.39416 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70323 0.33344 moveto
0.70338 0.33295 lineto
stroke
grestore
gsave
0.51574 0.61726 moveto 0.52185 0.61557 lineto 0.50419 0.63308 lineto 0.131 0 0 setrgbcolor
fill
grestore
gsave
0.58316 0.59864 moveto 0.52299 0.62488 lineto 0.52185 0.61557 lineto 0.131 0 0 setrgbcolor
fill
grestore
gsave
0.50419 0.63308 moveto 0.52185 0.61557 lineto 0.52299 0.62488 lineto 0.131 0 0 setrgbcolor
fill
grestore
gsave
0.51574 0.61726 moveto 0.50419 0.63308 lineto 0.50144 0.63048 lineto 0.131 0 0 setrgbcolor
fill
grestore
gsave
0.5252 0.63003 moveto 0.51044 0.63778 lineto 0.50524 0.63486 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.50874 0.63867 moveto 0.5081 0.63797 lineto 0.51044 0.63778 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.50524 0.63486 moveto 0.51044 0.63778 lineto 0.5081 0.63797 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.51117 0.64805 moveto 0.5081 0.63797 lineto 0.49253 0.63926 lineto 0.373 0.562 0.909 setrgbcolor
fill
grestore
gsave
0.49368 0.63766 moveto 0.50524 0.63486 lineto 0.47607 0.65582 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.47809 0.63245 moveto 0.49253 0.63926 lineto 0.49317 0.58892 lineto 0.373 0.562 0.909 setrgbcolor
fill
grestore
gsave
0.51117 0.64805 moveto 0.50918 0.63915 lineto 0.5081 0.63797 lineto 0 0 0.481 setrgbcolor
fill
grestore
gsave
0.47607 0.65582 moveto 0.50524 0.63486 lineto 0.50874 0.63867 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.49368 0.63766 moveto 0.50144 0.63048 lineto 0.50419 0.63308 lineto 0.131 0 0 setrgbcolor
fill
grestore
gsave
0.57926 0.61693 moveto 0.54139 0.6261 lineto 0.58316 0.59864 lineto 0.444 0.227 0.489 setrgbcolor
fill
grestore
gsave
0.49368 0.63766 moveto 0.53864 0.61806 lineto 0.54139 0.6261 lineto 0.444 0.227 0.489 setrgbcolor
fill
grestore
gsave
0.58316 0.59864 moveto 0.54139 0.6261 lineto 0.53864 0.61806 lineto 0.444 0.227 0.489 setrgbcolor
fill
grestore
gsave
0.57926 0.61693 moveto 0.52639 0.63686 lineto 0.5252 0.63003 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.52639 0.63686 moveto 0.52005 0.63925 lineto 0.5252 0.63003 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.51117 0.64805 moveto 0.52468 0.64051 lineto 0.50918 0.63915 lineto 0.254 0.536 0.92 setrgbcolor
fill
grestore
gsave
0.53477 0.64325 moveto 0.52846 0.64153 lineto 0.57926 0.61693 lineto 0.516 0.28 0.496 setrgbcolor
fill
grestore
gsave
0.52005 0.63925 moveto 0.52639 0.63686 lineto 0.52846 0.64153 lineto 0.516 0.28 0.496 setrgbcolor
fill
grestore
gsave
0.57926 0.61693 moveto 0.52846 0.64153 lineto 0.52639 0.63686 lineto 0.516 0.28 0.496 setrgbcolor
fill
grestore
gsave
0.54317 0.66156 moveto 0.5294 0.64281 lineto 0.51117 0.64805 lineto 0.254 0.536 0.92 setrgbcolor
fill
grestore
gsave
0.52682 0.63931 moveto 0.52168 0.64218 lineto 0.5294 0.64281 lineto 0.254 0.536 0.92 setrgbcolor
fill
grestore
gsave
0.51117 0.64805 moveto 0.5294 0.64281 lineto 0.52168 0.64218 lineto 0.254 0.536 0.92 setrgbcolor
fill
grestore
gsave
0.5297 0.64434 moveto 0.54156 0.6595 lineto 0.53069 0.64658 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.52846 0.64153 moveto 0.5294 0.64281 lineto 0.5297 0.64434 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.54317 0.66156 moveto 0.5297 0.64434 lineto 0.5294 0.64281 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.47607 0.65582 moveto 0.52008 0.6464 lineto 0.46407 0.67169 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.57273 0.67318 moveto 0.54756 0.65237 lineto 0.54317 0.66156 lineto 0.09 0.488 0.898 setrgbcolor
fill
grestore
gsave
0.54317 0.66156 moveto 0.54756 0.65237 lineto 0.5424 0.65125 lineto 0.09 0.488 0.898 setrgbcolor
fill
grestore
gsave
0.54317 0.66156 moveto 0.54111 0.65908 lineto 0.54156 0.6595 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.53069 0.64658 moveto 0.54156 0.6595 lineto 0.54111 0.65908 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.5297 0.64434 moveto 0.52746 0.64527 lineto 0.52631 0.64506 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.52987 0.64522 moveto 0.52405 0.64756 lineto 0.5297 0.64434 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.46407 0.67169 moveto 0.52282 0.6472 lineto 0.52405 0.64756 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.5297 0.64434 moveto 0.52405 0.64756 lineto 0.52282 0.6472 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.53069 0.64658 moveto 0.52997 0.64572 lineto 0.53018 0.64542 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.57572 0.65054 moveto 0.55618 0.65424 lineto 0.57664 0.63428 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.54317 0.66156 moveto 0.54222 0.64881 lineto 0.52997 0.64572 lineto 0.09 0.488 0.898 setrgbcolor
fill
grestore
gsave
0.52997 0.64572 moveto 0.54222 0.64881 lineto 0.53793 0.64714 lineto 0.09 0.488 0.898 setrgbcolor
fill
grestore
gsave
0.55618 0.65424 moveto 0.54417 0.64957 lineto 0.57664 0.63428 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.53793 0.64714 moveto 0.54267 0.64557 lineto 0.54417 0.64957 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.57664 0.63428 moveto 0.54417 0.64957 lineto 0.54267 0.64557 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.54215 0.6479 moveto 0.5424 0.65125 lineto 0.54417 0.64957 lineto 0.09 0.488 0.898 setrgbcolor
fill
grestore
gsave
0.54417 0.64957 moveto 0.5424 0.65125 lineto 0.54756 0.65237 lineto 0.09 0.488 0.898 setrgbcolor
fill
grestore
gsave
0.54215 0.6479 moveto 0.53793 0.64714 lineto 0.54222 0.64881 lineto 0.09 0.488 0.898 setrgbcolor
fill
grestore
gsave
0.5467 0.64423 moveto 0.53793 0.64714 lineto 0.53477 0.64325 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.53477 0.64325 moveto 0.53793 0.64714 lineto 0.53285 0.64623 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.53018 0.64542 moveto 0.52997 0.64572 lineto 0.52987 0.64522 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.50918 0.63915 moveto 0.52468 0.64051 lineto 0.52005 0.63925 lineto 0.254 0.536 0.92 setrgbcolor
fill
grestore
gsave
0.52005 0.63925 moveto 0.52846 0.64153 lineto 0.47607 0.65582 lineto 0.516 0.28 0.496 setrgbcolor
fill
grestore
gsave
0.53477 0.64325 moveto 0.5297 0.64434 lineto 0.52846 0.64153 lineto 0.516 0.28 0.496 setrgbcolor
fill
grestore
gsave
0.47607 0.65582 moveto 0.52846 0.64153 lineto 0.5297 0.64434 lineto 0.516 0.28 0.496 setrgbcolor
fill
grestore
gsave
0.52741 0.64264 moveto 0.53018 0.64542 lineto 0.52918 0.64477 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.52741 0.64264 moveto 0.52846 0.64153 lineto 0.53018 0.64542 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.53477 0.64325 moveto 0.53072 0.64954 lineto 0.52987 0.64522 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.46407 0.67169 moveto 0.52987 0.64522 lineto 0.53072 0.64954 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.52918 0.64477 moveto 0.52987 0.64522 lineto 0.52997 0.64572 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.53477 0.64325 moveto 0.52987 0.64522 lineto 0.5297 0.64434 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.5467 0.64423 moveto 0.54304 0.64393 lineto 0.57664 0.63428 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.53477 0.64325 moveto 0.54361 0.64136 lineto 0.54304 0.64393 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.57664 0.63428 moveto 0.54304 0.64393 lineto 0.54361 0.64136 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.52682 0.63931 moveto 0.52846 0.64153 lineto 0.52741 0.64264 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.52682 0.63931 moveto 0.52005 0.63925 lineto 0.52468 0.64051 lineto 0.254 0.536 0.92 setrgbcolor
fill
grestore
gsave
0.52477 0.63948 moveto 0.52682 0.63931 lineto 0.52741 0.64264 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.52539 0.64023 moveto 0.52997 0.64572 lineto 0.54215 0.6479 lineto 0.09 0.488 0.898 setrgbcolor
fill
grestore
gsave
0.57664 0.63428 moveto 0.53477 0.64325 lineto 0.57926 0.61693 lineto 0.516 0.28 0.496 setrgbcolor
fill
grestore
gsave
0.5252 0.63003 moveto 0.52005 0.63925 lineto 0.50784 0.63914 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.50154 0.6049 moveto 0.50918 0.63915 lineto 0.52682 0.63931 lineto 0.254 0.536 0.92 setrgbcolor
fill
grestore
gsave
0.52433 0.63592 moveto 0.52682 0.63931 lineto 0.52477 0.63948 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.50154 0.6049 moveto 0.52433 0.63592 lineto 0.50885 0.62038 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.50885 0.62038 moveto 0.52433 0.63592 lineto 0.52477 0.63948 lineto 0.804 0.381 0 setrgbcolor
fill
grestore
gsave
0.50885 0.62038 moveto 0.54215 0.6479 lineto 0.51473 0.63535 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.54417 0.64957 moveto 0.54201 0.64853 lineto 0.54215 0.6479 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.51473 0.63535 moveto 0.54215 0.6479 lineto 0.54201 0.64853 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.57273 0.67318 moveto 0.55311 0.66038 lineto 0.55148 0.65561 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.54661 0.65605 moveto 0.54659 0.65613 lineto 0.54649 0.65609 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.54661 0.65605 moveto 0.54649 0.65609 lineto 0.54645 0.65608 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.53793 0.64714 moveto 0.54417 0.64957 lineto 0.54645 0.65608 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.55148 0.65561 moveto 0.54665 0.65616 lineto 0.54512 0.65211 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.54417 0.64957 moveto 0.54756 0.65237 lineto 0.54512 0.65211 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.55148 0.65561 moveto 0.54731 0.65332 lineto 0.54756 0.65237 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.54512 0.65211 moveto 0.54756 0.65237 lineto 0.54731 0.65332 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.55618 0.65424 moveto 0.54661 0.65605 lineto 0.54417 0.64957 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.54645 0.65608 moveto 0.54417 0.64957 lineto 0.54661 0.65605 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.55311 0.66038 moveto 0.54665 0.65616 lineto 0.55148 0.65561 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.53793 0.64714 moveto 0.54645 0.65608 lineto 0.53077 0.64953 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.53072 0.64954 moveto 0.53285 0.64623 lineto 0.53793 0.64714 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.51473 0.63535 moveto 0.54512 0.65211 lineto 0.54665 0.65616 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.57273 0.67318 moveto 0.5469 0.65627 lineto 0.54665 0.65616 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.59852 0.68318 moveto 0.56578 0.66449 lineto 0.57273 0.67318 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.57273 0.67318 moveto 0.56578 0.66449 lineto 0.56082 0.66288 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.57173 0.66643 moveto 0.5611 0.66182 lineto 0.57572 0.65054 lineto 0.611 0.332 0.469 setrgbcolor
fill
grestore
gsave
0.55159 0.6577 moveto 0.55901 0.65549 lineto 0.5611 0.66182 lineto 0.611 0.332 0.469 setrgbcolor
fill
grestore
gsave
0.57572 0.65054 moveto 0.5611 0.66182 lineto 0.55901 0.65549 lineto 0.611 0.332 0.469 setrgbcolor
fill
grestore
gsave
0.55326 0.65822 moveto 0.55386 0.65868 lineto 0.55667 0.65929 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.57273 0.67318 moveto 0.55808 0.66051 lineto 0.55386 0.65868 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.55667 0.65929 moveto 0.55386 0.65868 lineto 0.55808 0.66051 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.55618 0.65424 moveto 0.54843 0.6567 lineto 0.54661 0.65605 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.54661 0.65605 moveto 0.54843 0.6567 lineto 0.54659 0.65613 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.54131 0.65261 moveto 0.54677 0.65618 lineto 0.54881 0.6548 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.57273 0.67318 moveto 0.55326 0.65822 lineto 0.54677 0.65618 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.56025 0.65513 moveto 0.55159 0.6577 lineto 0.55618 0.65424 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.55618 0.65424 moveto 0.55159 0.6577 lineto 0.54843 0.6567 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.54881 0.6548 moveto 0.54677 0.65618 lineto 0.55326 0.65822 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.45871 0.68524 moveto 0.54843 0.6567 lineto 0.55159 0.6577 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.56328 0.66841 moveto 0.5631 0.66786 lineto 0.59852 0.68318 lineto 0.857 0.466 0.303 setrgbcolor
fill
grestore
gsave
0.55667 0.65929 moveto 0.56082 0.66288 lineto 0.56578 0.66449 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.5611 0.66182 moveto 0.56578 0.66449 lineto 0.5631 0.66786 lineto 0.857 0.466 0.303 setrgbcolor
fill
grestore
gsave
0.59852 0.68318 moveto 0.5631 0.66786 lineto 0.56578 0.66449 lineto 0.857 0.466 0.303 setrgbcolor
fill
grestore
gsave
0.63368 0.69956 moveto 0.63098 0.6987 lineto 0.61924 0.69187 lineto 0.378 0 0 setrgbcolor
fill
grestore
gsave
0.46079 0.69652 moveto 0.55571 0.67122 lineto 0.5785 0.67954 lineto 0.645 0.337 0.435 setrgbcolor
fill
grestore
gsave
0.45871 0.68524 moveto 0.55257 0.66961 lineto 0.46079 0.69652 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.56229 0.668 moveto 0.55398 0.67033 lineto 0.55257 0.66961 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.46079 0.69652 moveto 0.55257 0.66961 lineto 0.55398 0.67033 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.47084 0.70566 moveto 0.58053 0.67925 lineto 0.58679 0.6915 lineto 0.672 0.327 0.381 setrgbcolor
fill
grestore
gsave
0.6408 0.70659 moveto 0.59122 0.69441 lineto 0.63368 0.69956 lineto 0.418 0 0 setrgbcolor
fill
grestore
gsave
0.46079 0.69652 moveto 0.56837 0.681 lineto 0.47084 0.70566 lineto 0.389 0 0 setrgbcolor
fill
grestore
gsave
0.47084 0.70566 moveto 0.56837 0.681 lineto 0.56957 0.68171 lineto 0.389 0 0 setrgbcolor
fill
grestore
gsave
0.47084 0.70566 moveto 0.5785 0.67954 lineto 0.57876 0.67967 lineto 0.389 0 0 setrgbcolor
fill
grestore
gsave
0.46079 0.69652 moveto 0.56229 0.668 lineto 0.56242 0.66805 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.46079 0.69652 moveto 0.56242 0.66805 lineto 0.56218 0.66902 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.5631 0.66786 moveto 0.56282 0.66822 lineto 0.56242 0.66805 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.56218 0.66902 moveto 0.56242 0.66805 lineto 0.56282 0.66822 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.57173 0.66643 moveto 0.56229 0.668 lineto 0.55159 0.6577 lineto 0.611 0.332 0.469 setrgbcolor
fill
grestore
gsave
0.45871 0.68524 moveto 0.54346 0.6601 lineto 0.56229 0.668 lineto 0.611 0.332 0.469 setrgbcolor
fill
grestore
gsave
0.55159 0.6577 moveto 0.56229 0.668 lineto 0.54346 0.6601 lineto 0.611 0.332 0.469 setrgbcolor
fill
grestore
gsave
0.55355 0.66434 moveto 0.56282 0.66822 lineto 0.5607 0.66733 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.59852 0.68318 moveto 0.56869 0.67068 lineto 0.56282 0.66822 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.5631 0.66786 moveto 0.56242 0.66805 lineto 0.56229 0.668 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.54626 0.65739 moveto 0.54099 0.65907 lineto 0.54649 0.65609 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.45871 0.68524 moveto 0.53946 0.65843 lineto 0.54099 0.65907 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.54649 0.65609 moveto 0.54099 0.65907 lineto 0.53946 0.65843 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.46407 0.67169 moveto 0.54645 0.65608 lineto 0.45871 0.68524 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.45871 0.68524 moveto 0.54645 0.65608 lineto 0.54649 0.65609 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.46407 0.67169 moveto 0.53077 0.64953 lineto 0.54645 0.65608 lineto 0.569 0.313 0.488 setrgbcolor
fill
grestore
gsave
0.51886 0.6498 moveto 0.5611 0.66182 lineto 0.56328 0.66841 lineto 0.857 0.466 0.303 setrgbcolor
fill
grestore
gsave
0.57173 0.66643 moveto 0.56218 0.66902 lineto 0.5631 0.66786 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.46079 0.69652 moveto 0.57173 0.66643 lineto 0.5726 0.66671 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.5607 0.66733 moveto 0.56282 0.66822 lineto 0.56869 0.67068 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.48903 0.71282 moveto 0.58679 0.6915 lineto 0.59575 0.70227 lineto 0.687 0.294 0.296 setrgbcolor
fill
grestore
gsave
0.47084 0.70566 moveto 0.58679 0.6915 lineto 0.48903 0.71282 lineto 0.368 0 0 setrgbcolor
fill
grestore
gsave
0.52076 0.67709 moveto 0.58272 0.68942 lineto 0.59122 0.69441 lineto 0.418 0 0 setrgbcolor
fill
grestore
gsave
0.63368 0.69956 moveto 0.59122 0.69441 lineto 0.58272 0.68942 lineto 0.418 0 0 setrgbcolor
fill
grestore
gsave
0.5785 0.67954 moveto 0.56957 0.68171 lineto 0.56837 0.681 lineto 0.389 0 0 setrgbcolor
fill
grestore
gsave
0.58053 0.67925 moveto 0.57876 0.67967 lineto 0.5785 0.67954 lineto 0.389 0 0 setrgbcolor
fill
grestore
gsave
0.63098 0.6987 moveto 0.59109 0.68602 lineto 0.58693 0.68261 lineto 0.378 0 0 setrgbcolor
fill
grestore
gsave
0.57425 0.68067 moveto 0.58343 0.68208 lineto 0.59109 0.68602 lineto 0.378 0 0 setrgbcolor
fill
grestore
gsave
0.58693 0.68261 moveto 0.59109 0.68602 lineto 0.58343 0.68208 lineto 0.378 0 0 setrgbcolor
fill
grestore
gsave
0.52096 0.66372 moveto 0.56672 0.67683 lineto 0.57425 0.68067 lineto 0.378 0 0 setrgbcolor
fill
grestore
gsave
0.58693 0.68261 moveto 0.57425 0.68067 lineto 0.56672 0.67683 lineto 0.378 0 0 setrgbcolor
fill
grestore
gsave
0.61924 0.69187 moveto 0.63098 0.6987 lineto 0.58693 0.68261 lineto 0.378 0 0 setrgbcolor
fill
grestore
gsave
0.58053 0.67925 moveto 0.5785 0.67954 lineto 0.56442 0.66889 lineto 0.645 0.337 0.435 setrgbcolor
fill
grestore
gsave
0.56442 0.66889 moveto 0.5785 0.67954 lineto 0.55571 0.67122 lineto 0.645 0.337 0.435 setrgbcolor
fill
grestore
gsave
0.59852 0.68318 moveto 0.58568 0.6778 lineto 0.57716 0.67423 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.59852 0.68318 moveto 0.57234 0.67221 lineto 0.56869 0.67068 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.57691 0.66556 moveto 0.57946 0.6752 lineto 0.56442 0.66889 lineto 0.645 0.337 0.435 setrgbcolor
fill
grestore
gsave
0.58053 0.67925 moveto 0.56442 0.66889 lineto 0.57946 0.6752 lineto 0.645 0.337 0.435 setrgbcolor
fill
grestore
gsave
0.61924 0.69187 moveto 0.58568 0.6778 lineto 0.59852 0.68318 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.57234 0.67221 moveto 0.57716 0.67423 lineto 0.58568 0.6778 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.5607 0.66733 moveto 0.56869 0.67068 lineto 0.57234 0.67221 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.54881 0.6548 moveto 0.55326 0.65822 lineto 0.55667 0.65929 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.5469 0.65627 moveto 0.54677 0.65618 lineto 0.54665 0.65616 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.54665 0.65616 moveto 0.54677 0.65618 lineto 0.54659 0.65613 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.54665 0.65616 moveto 0.54659 0.65613 lineto 0.54659 0.65613 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.54626 0.65739 moveto 0.54659 0.65613 lineto 0.54843 0.6567 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.54626 0.65739 moveto 0.54649 0.65609 lineto 0.54659 0.65613 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.54131 0.65261 moveto 0.54659 0.65613 lineto 0.54677 0.65618 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.54111 0.65255 moveto 0.54659 0.65613 lineto 0.54131 0.65261 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.54131 0.65261 moveto 0.54659 0.65613 lineto 0.54659 0.65613 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.51682 0.63671 moveto 0.54111 0.65255 lineto 0.51633 0.63626 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.51633 0.63626 moveto 0.54111 0.65255 lineto 0.54131 0.65261 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.52008 0.6464 moveto 0.52631 0.64506 lineto 0.52282 0.6472 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.52282 0.6472 moveto 0.52631 0.64506 lineto 0.52746 0.64527 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.46407 0.67169 moveto 0.52008 0.6464 lineto 0.52282 0.6472 lineto 0.316 0 0.039 setrgbcolor
fill
grestore
gsave
0.51633 0.63626 moveto 0.54131 0.65261 lineto 0.54881 0.6548 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.51473 0.63535 moveto 0.51682 0.63671 lineto 0.51633 0.63626 lineto 0 0.408 0.808 setrgbcolor
fill
grestore
gsave
0.47607 0.65582 moveto 0.50784 0.63914 lineto 0.52005 0.63925 lineto 0.242 0 0.016 setrgbcolor
fill
grestore
gsave
0.51473 0.63535 moveto 0.5611 0.66182 lineto 0.51886 0.6498 lineto 0.857 0.466 0.303 setrgbcolor
fill
grestore
gsave
0.57691 0.66556 moveto 0.57173 0.66643 lineto 0.57572 0.65054 lineto 0.611 0.332 0.469 setrgbcolor
fill
grestore
gsave
0.57691 0.66556 moveto 0.5726 0.66671 lineto 0.57173 0.66643 lineto 0.386 0 0 setrgbcolor
fill
grestore
gsave
0.51886 0.6498 moveto 0.55355 0.66434 lineto 0.5607 0.66733 lineto 0.274 0 0 setrgbcolor
fill
grestore
gsave
0.51473 0.63535 moveto 0.54417 0.64957 lineto 0.54512 0.65211 lineto 0.892 0.471 0.169 setrgbcolor
fill
grestore
gsave
0.57572 0.65054 moveto 0.56025 0.65513 lineto 0.55618 0.65424 lineto 0.362 0 0.029 setrgbcolor
fill
grestore
gsave
0.49317 0.58892 moveto 0.49253 0.63926 lineto 0.5081 0.63797 lineto 0.373 0.562 0.909 setrgbcolor
fill
grestore
gsave
0.50759 0.63629 moveto 0.5081 0.63797 lineto 0.5088 0.63744 lineto 0 0 0.481 setrgbcolor
fill
grestore
gsave
0.5088 0.63744 moveto 0.5081 0.63797 lineto 0.50918 0.63915 lineto 0 0 0.481 setrgbcolor
fill
grestore
gsave
0.49317 0.58892 moveto 0.50759 0.63629 lineto 0.50154 0.6049 lineto 0 0 0.481 setrgbcolor
fill
grestore
gsave
0.50154 0.6049 moveto 0.50759 0.63629 lineto 0.5088 0.63744 lineto 0 0 0.481 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.52132 0.61228 moveto
0.541 0.59474 lineto
stroke
grestore
gsave
0.51574 0.61726 moveto 0.58789 0.57958 lineto 0.58316 0.59864 lineto 0.337 0.142 0.462 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57718 0.63067 moveto
0.65801 0.59671 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58328 0.59816 moveto
0.64825 0.57878 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51574 0.61726 moveto
0.52132 0.61228 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51574 0.61726 moveto
0.5202 0.61493 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5202 0.61493 moveto
0.52134 0.61433 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52134 0.61433 moveto
0.58418 0.58152 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58418 0.58152 moveto
0.58789 0.57958 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52803 0.55021 moveto
0.53385 0.57532 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53385 0.57532 moveto
0.535 0.58029 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59057 0.56158 moveto
0.59303 0.55993 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54685 0.59083 moveto
0.59057 0.56158 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51269 0.62008 moveto
0.51574 0.61726 lineto
stroke
grestore
gsave
0.75838 0.7293 moveto 0.726 0.68177 lineto 0.71612 0.66984 lineto 0 0 0.521 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71612 0.66984 moveto
0.72462 0.72043 lineto
stroke
grestore
gsave
0.78996 0.73576 moveto 0.726 0.68177 lineto 0.75838 0.7293 lineto 0.327 0.598 0.945 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.72462 0.72043 moveto
0.75838 0.7293 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58801 0.54479 moveto
0.59385 0.54427 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59713 0.54397 moveto
0.64114 0.54 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52803 0.55021 moveto
0.58372 0.54518 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58372 0.54518 moveto
0.58801 0.54479 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52803 0.55021 moveto
0.52843 0.51877 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62372 0.49978 moveto
0.63711 0.50178 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53633 0.48674 moveto
0.60734 0.49734 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63711 0.50178 moveto
0.63859 0.48566 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63859 0.48566 moveto
0.63884 0.48294 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63711 0.50178 moveto
0.63792 0.52091 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63505 0.48172 moveto
0.63884 0.48294 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55155 0.45497 moveto
0.61055 0.47387 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63884 0.48294 moveto
0.64012 0.47751 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60111 0.39603 moveto
0.60288 0.3979 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57348 0.4244 moveto
0.57843 0.42727 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57843 0.42727 moveto
0.61184 0.44661 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6134 0.52043 moveto
0.63792 0.52091 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61139 0.52039 moveto
0.6134 0.52043 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52843 0.51877 moveto
0.60223 0.52021 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60223 0.52021 moveto
0.6028 0.52022 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63792 0.52091 moveto
0.64114 0.54 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64114 0.54 moveto
0.64654 0.55881 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64654 0.55881 moveto
0.65382 0.57712 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.79781 0.31442 moveto
0.82021 0.31855 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65382 0.57712 moveto
0.66261 0.59477 lineto
stroke
grestore
gsave
0.40268 0.62662 moveto 0.37548 0.61863 lineto 0.37471 0.65524 lineto 0.85 0.997 0.82 setrgbcolor
fill
grestore
gsave
0.40268 0.62662 moveto 0.37967 0.59758 lineto 0.37548 0.61863 lineto 0.994 0.871 0.549 setrgbcolor
fill
grestore
gsave
0.41409 0.59439 moveto 0.42258 0.58511 lineto 0.38578 0.57184 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.42416 0.60091 moveto 0.42429 0.60039 lineto 0.41409 0.59439 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.42816 0.59628 moveto 0.42997 0.57488 lineto 0.42772 0.58363 lineto 0.884 0.91 0.839 setrgbcolor
fill
grestore
gsave
0.43055 0.56804 moveto 0.42866 0.57846 lineto 0.42997 0.57488 lineto 0.884 0.91 0.839 setrgbcolor
fill
grestore
gsave
0.42772 0.58363 moveto 0.42997 0.57488 lineto 0.42866 0.57846 lineto 0.884 0.91 0.839 setrgbcolor
fill
grestore
gsave
0.44995 0.5647 moveto 0.43055 0.56804 lineto 0.42816 0.59628 lineto 0.884 0.91 0.839 setrgbcolor
fill
grestore
gsave
0.38578 0.57184 moveto 0.42258 0.58511 lineto 0.42017 0.57715 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.4326 0.56768 moveto 0.43005 0.56703 lineto 0.43055 0.56804 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.44995 0.5647 moveto 0.43201 0.56212 lineto 0.4326 0.56768 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.43201 0.56212 moveto 0.42729 0.56144 lineto 0.4326 0.56768 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.38578 0.57184 moveto 0.42697 0.56834 lineto 0.42436 0.55549 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.43055 0.56804 moveto 0.42729 0.56144 lineto 0.42697 0.56834 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.42436 0.55549 moveto 0.42697 0.56834 lineto 0.42729 0.56144 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.4669 0.53238 moveto 0.43271 0.5417 lineto 0.44995 0.5647 lineto 0.866 0.86 0.832 setrgbcolor
fill
grestore
gsave
0.43228 0.53818 moveto 0.42352 0.54452 lineto 0.43271 0.5417 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.38578 0.57184 moveto 0.42374 0.54746 lineto 0.42352 0.54452 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.43271 0.5417 moveto 0.42352 0.54452 lineto 0.42374 0.54746 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.42729 0.56144 moveto 0.42479 0.56108 lineto 0.43005 0.56703 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.43271 0.5417 moveto 0.42374 0.54746 lineto 0.42764 0.5541 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.38578 0.57184 moveto 0.42436 0.55549 lineto 0.42374 0.54746 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.42764 0.5541 moveto 0.42374 0.54746 lineto 0.42436 0.55549 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.42866 0.57846 moveto 0.43055 0.56804 lineto 0.38578 0.57184 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.38578 0.57184 moveto 0.43228 0.53818 lineto 0.36157 0.54704 lineto 0.605 0.625 0.845 setrgbcolor
fill
grestore
gsave
0.43167 0.53318 moveto 0.43228 0.53818 lineto 0.4669 0.53238 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.36157 0.54704 moveto 0.42892 0.5386 lineto 0.42603 0.52889 lineto 0.605 0.625 0.845 setrgbcolor
fill
grestore
gsave
0.43228 0.53818 moveto 0.42896 0.53324 lineto 0.42892 0.5386 lineto 0.605 0.625 0.845 setrgbcolor
fill
grestore
gsave
0.42603 0.52889 moveto 0.42892 0.5386 lineto 0.42896 0.53324 lineto 0.605 0.625 0.845 setrgbcolor
fill
grestore
gsave
0.47802 0.49994 moveto 0.43492 0.51544 lineto 0.4669 0.53238 lineto 0.843 0.818 0.825 setrgbcolor
fill
grestore
gsave
0.43167 0.53318 moveto 0.42653 0.53329 lineto 0.43271 0.5417 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.36157 0.54704 moveto 0.42499 0.51971 lineto 0.42445 0.51493 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.43492 0.51544 moveto 0.42499 0.51971 lineto 0.42899 0.52805 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.36157 0.54704 moveto 0.42603 0.52889 lineto 0.42499 0.51971 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.42899 0.52805 moveto 0.42499 0.51971 lineto 0.42603 0.52889 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.36157 0.54704 moveto 0.43413 0.50998 lineto 0.34258 0.52021 lineto 0.635 0.642 0.84 setrgbcolor
fill
grestore
gsave
0.4336 0.50631 moveto 0.43413 0.50998 lineto 0.47802 0.49994 lineto 0.817 0.657 0.684 setrgbcolor
fill
grestore
gsave
0.34258 0.52021 moveto 0.43114 0.51031 lineto 0.42972 0.50533 lineto 0.635 0.642 0.84 setrgbcolor
fill
grestore
gsave
0.43413 0.50998 moveto 0.431 0.50668 lineto 0.43114 0.51031 lineto 0.635 0.642 0.84 setrgbcolor
fill
grestore
gsave
0.42972 0.50533 moveto 0.43114 0.51031 lineto 0.431 0.50668 lineto 0.635 0.642 0.84 setrgbcolor
fill
grestore
gsave
0.4825 0.46806 moveto 0.44159 0.48634 lineto 0.47802 0.49994 lineto 0.818 0.784 0.82 setrgbcolor
fill
grestore
gsave
0.47802 0.49994 moveto 0.44159 0.48634 lineto 0.43798 0.4927 lineto 0.818 0.784 0.82 setrgbcolor
fill
grestore
gsave
0.43094 0.50512 moveto 0.44159 0.48634 lineto 0.34258 0.52021 lineto 0.625 0.528 0.723 setrgbcolor
fill
grestore
gsave
0.44011 0.47853 moveto 0.44126 0.48458 lineto 0.4825 0.46806 lineto 0.778 0.629 0.695 setrgbcolor
fill
grestore
gsave
0.44159 0.48634 moveto 0.44297 0.48573 lineto 0.44126 0.48458 lineto 0.778 0.629 0.695 setrgbcolor
fill
grestore
gsave
0.4825 0.46806 moveto 0.44126 0.48458 lineto 0.44297 0.48573 lineto 0.778 0.629 0.695 setrgbcolor
fill
grestore
gsave
0.32401 0.46189 moveto 0.44104 0.46496 lineto 0.4401 0.44673 lineto 0.7 0.6 0.741 setrgbcolor
fill
grestore
gsave
0.47973 0.43752 moveto 0.43267 0.46311 lineto 0.4825 0.46806 lineto 0.794 0.757 0.819 setrgbcolor
fill
grestore
gsave
0.34258 0.52021 moveto 0.43504 0.48683 lineto 0.32979 0.49166 lineto 0.661 0.66 0.839 setrgbcolor
fill
grestore
gsave
0.32979 0.49166 moveto 0.43504 0.48683 lineto 0.43486 0.48499 lineto 0.661 0.66 0.839 setrgbcolor
fill
grestore
gsave
0.32979 0.49166 moveto 0.44126 0.48458 lineto 0.44 0.48374 lineto 0.661 0.66 0.839 setrgbcolor
fill
grestore
gsave
0.32979 0.49166 moveto 0.44104 0.46496 lineto 0.32401 0.46189 lineto 0.682 0.679 0.84 setrgbcolor
fill
grestore
gsave
0.44126 0.48458 moveto 0.43486 0.48499 lineto 0.43504 0.48683 lineto 0.661 0.66 0.839 setrgbcolor
fill
grestore
gsave
0.34258 0.52021 moveto 0.44159 0.48634 lineto 0.44126 0.48458 lineto 0.625 0.528 0.723 setrgbcolor
fill
grestore
gsave
0.44011 0.47853 moveto 0.43861 0.47891 lineto 0.44159 0.48634 lineto 0.778 0.629 0.695 setrgbcolor
fill
grestore
gsave
0.43477 0.48412 moveto 0.43761 0.47545 lineto 0.32979 0.49166 lineto 0.666 0.564 0.731 setrgbcolor
fill
grestore
gsave
0.44159 0.48634 moveto 0.43861 0.47891 lineto 0.44079 0.48644 lineto 0.778 0.629 0.695 setrgbcolor
fill
grestore
gsave
0.4825 0.46806 moveto 0.44904 0.46473 lineto 0.43861 0.47891 lineto 0.794 0.757 0.819 setrgbcolor
fill
grestore
gsave
0.44448 0.48342 moveto 0.44262 0.47345 lineto 0.43477 0.48412 lineto 0.666 0.564 0.731 setrgbcolor
fill
grestore
gsave
0.44104 0.46496 moveto 0.43477 0.48412 lineto 0.44262 0.47345 lineto 0.666 0.564 0.731 setrgbcolor
fill
grestore
gsave
0.37449 0.49474 moveto 0.44079 0.48644 lineto 0.43861 0.47891 lineto 0.778 0.629 0.695 setrgbcolor
fill
grestore
gsave
0.44104 0.46496 moveto 0.435 0.46641 lineto 0.43761 0.47545 lineto 0.666 0.564 0.731 setrgbcolor
fill
grestore
gsave
0.32979 0.49166 moveto 0.43761 0.47545 lineto 0.435 0.46641 lineto 0.666 0.564 0.731 setrgbcolor
fill
grestore
gsave
0.43435 0.47996 moveto 0.43861 0.47891 lineto 0.43267 0.46311 lineto 0.794 0.757 0.819 setrgbcolor
fill
grestore
gsave
0.43267 0.46311 moveto 0.43861 0.47891 lineto 0.44904 0.46473 lineto 0.794 0.757 0.819 setrgbcolor
fill
grestore
gsave
0.37449 0.49474 moveto 0.43435 0.47996 lineto 0.43267 0.46311 lineto 0.794 0.757 0.819 setrgbcolor
fill
grestore
gsave
0.44448 0.48342 moveto 0.44 0.48374 lineto 0.44126 0.48458 lineto 0.661 0.66 0.839 setrgbcolor
fill
grestore
gsave
0.44293 0.48398 moveto 0.44126 0.48458 lineto 0.44159 0.48634 lineto 0.625 0.528 0.723 setrgbcolor
fill
grestore
gsave
0.37954 0.51407 moveto 0.44159 0.48634 lineto 0.37449 0.49474 lineto 0.778 0.629 0.695 setrgbcolor
fill
grestore
gsave
0.47802 0.49994 moveto 0.43041 0.49134 lineto 0.431 0.50668 lineto 0.818 0.784 0.82 setrgbcolor
fill
grestore
gsave
0.44448 0.48342 moveto 0.44293 0.48398 lineto 0.45004 0.50186 lineto 0.625 0.528 0.723 setrgbcolor
fill
grestore
gsave
0.45004 0.50186 moveto 0.44293 0.48398 lineto 0.43094 0.50512 lineto 0.625 0.528 0.723 setrgbcolor
fill
grestore
gsave
0.43041 0.49134 moveto 0.43798 0.4927 lineto 0.44159 0.48634 lineto 0.818 0.784 0.82 setrgbcolor
fill
grestore
gsave
0.43413 0.50998 moveto 0.42445 0.51493 lineto 0.43492 0.51544 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.43492 0.51544 moveto 0.42445 0.51493 lineto 0.42499 0.51971 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.43492 0.51544 moveto 0.43413 0.50998 lineto 0.37954 0.51407 lineto 0.817 0.657 0.684 setrgbcolor
fill
grestore
gsave
0.4336 0.50631 moveto 0.431 0.50668 lineto 0.43413 0.50998 lineto 0.817 0.657 0.684 setrgbcolor
fill
grestore
gsave
0.37954 0.51407 moveto 0.43413 0.50998 lineto 0.431 0.50668 lineto 0.817 0.657 0.684 setrgbcolor
fill
grestore
gsave
0.45004 0.50186 moveto 0.42972 0.50533 lineto 0.43413 0.50998 lineto 0.635 0.642 0.84 setrgbcolor
fill
grestore
gsave
0.37954 0.51407 moveto 0.431 0.50668 lineto 0.43041 0.49134 lineto 0.818 0.784 0.82 setrgbcolor
fill
grestore
gsave
0.43492 0.51544 moveto 0.43819 0.51426 lineto 0.43413 0.50998 lineto 0.817 0.657 0.684 setrgbcolor
fill
grestore
gsave
0.47802 0.49994 moveto 0.43413 0.50998 lineto 0.43819 0.51426 lineto 0.817 0.657 0.684 setrgbcolor
fill
grestore
gsave
0.38339 0.55514 moveto 0.42764 0.54308 lineto 0.38248 0.53429 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.43271 0.5417 moveto 0.42739 0.54091 lineto 0.42764 0.54308 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.38248 0.53429 moveto 0.42764 0.54308 lineto 0.42739 0.54091 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.38248 0.53429 moveto 0.42739 0.54091 lineto 0.42653 0.53329 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.43271 0.5417 moveto 0.42653 0.53329 lineto 0.42739 0.54091 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.38248 0.53429 moveto 0.43492 0.51544 lineto 0.37954 0.51407 lineto 0.817 0.657 0.684 setrgbcolor
fill
grestore
gsave
0.43855 0.50773 moveto 0.43413 0.50998 lineto 0.43492 0.51544 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.45004 0.50186 moveto 0.43855 0.50773 lineto 0.45727 0.52009 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.4669 0.53238 moveto 0.43492 0.51544 lineto 0.43317 0.51916 lineto 0.843 0.818 0.825 setrgbcolor
fill
grestore
gsave
0.4669 0.53238 moveto 0.42906 0.51754 lineto 0.42896 0.53324 lineto 0.843 0.818 0.825 setrgbcolor
fill
grestore
gsave
0.45727 0.52009 moveto 0.43855 0.50773 lineto 0.42899 0.52805 lineto 0.576 0.488 0.719 setrgbcolor
fill
grestore
gsave
0.42906 0.51754 moveto 0.43317 0.51916 lineto 0.43492 0.51544 lineto 0.843 0.818 0.825 setrgbcolor
fill
grestore
gsave
0.45727 0.52009 moveto 0.42603 0.52889 lineto 0.43228 0.53818 lineto 0.605 0.625 0.845 setrgbcolor
fill
grestore
gsave
0.38248 0.53429 moveto 0.42896 0.53324 lineto 0.42906 0.51754 lineto 0.843 0.818 0.825 setrgbcolor
fill
grestore
gsave
0.43271 0.5417 moveto 0.43435 0.54125 lineto 0.43228 0.53818 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.4669 0.53238 moveto 0.43228 0.53818 lineto 0.43435 0.54125 lineto 0.862 0.694 0.673 setrgbcolor
fill
grestore
gsave
0.38239 0.57633 moveto 0.42539 0.56892 lineto 0.38339 0.55514 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.43055 0.56804 moveto 0.42521 0.56658 lineto 0.42539 0.56892 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.38339 0.55514 moveto 0.42539 0.56892 lineto 0.42521 0.56658 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.38339 0.55514 moveto 0.42515 0.56578 lineto 0.42479 0.56108 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.43005 0.56703 moveto 0.42479 0.56108 lineto 0.42515 0.56578 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.43494 0.53625 moveto 0.43228 0.53818 lineto 0.43271 0.5417 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.45727 0.52009 moveto 0.43494 0.53625 lineto 0.46569 0.53798 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.44995 0.5647 moveto 0.43271 0.5417 lineto 0.43104 0.5458 lineto 0.866 0.86 0.832 setrgbcolor
fill
grestore
gsave
0.44995 0.5647 moveto 0.42817 0.54293 lineto 0.42729 0.56144 lineto 0.866 0.86 0.832 setrgbcolor
fill
grestore
gsave
0.46569 0.53798 moveto 0.43494 0.53625 lineto 0.42764 0.5541 lineto 0.511 0.443 0.716 setrgbcolor
fill
grestore
gsave
0.42817 0.54293 moveto 0.43104 0.5458 lineto 0.43271 0.5417 lineto 0.866 0.86 0.832 setrgbcolor
fill
grestore
gsave
0.4326 0.56768 moveto 0.42729 0.56144 lineto 0.43005 0.56703 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.43353 0.55161 moveto 0.42436 0.55549 lineto 0.43055 0.56804 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.38339 0.55514 moveto 0.42729 0.56144 lineto 0.42817 0.54293 lineto 0.866 0.86 0.832 setrgbcolor
fill
grestore
gsave
0.43353 0.55161 moveto 0.43055 0.56804 lineto 0.46569 0.53798 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.42866 0.57846 moveto 0.43323 0.57346 lineto 0.43055 0.56804 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.46569 0.53798 moveto 0.43055 0.56804 lineto 0.43323 0.57346 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.38339 0.55514 moveto 0.43055 0.56804 lineto 0.43005 0.56703 lineto 0.914 0.745 0.658 setrgbcolor
fill
grestore
gsave
0.46569 0.53798 moveto 0.43323 0.57346 lineto 0.47479 0.55544 lineto 0.42 0.385 0.714 setrgbcolor
fill
grestore
gsave
0.42866 0.57846 moveto 0.43351 0.57604 lineto 0.43323 0.57346 lineto 0.42 0.385 0.714 setrgbcolor
fill
grestore
gsave
0.47479 0.55544 moveto 0.43323 0.57346 lineto 0.43351 0.57604 lineto 0.42 0.385 0.714 setrgbcolor
fill
grestore
gsave
0.41409 0.59439 moveto 0.42274 0.58884 lineto 0.42258 0.58511 lineto 0.42 0.385 0.714 setrgbcolor
fill
grestore
gsave
0.42429 0.60039 moveto 0.4248 0.59482 lineto 0.41409 0.59439 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.42551 0.58706 moveto 0.42274 0.58884 lineto 0.4248 0.59482 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.41409 0.59439 moveto 0.4248 0.59482 lineto 0.42274 0.58884 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.42563 0.59518 moveto 0.4248 0.59482 lineto 0.42598 0.59634 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.42429 0.60039 moveto 0.42533 0.59636 lineto 0.4248 0.59482 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.38239 0.57633 moveto 0.4252 0.59598 lineto 0.4248 0.59482 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.42598 0.59634 moveto 0.4248 0.59482 lineto 0.4252 0.59598 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.37967 0.59758 moveto 0.42307 0.59642 lineto 0.38239 0.57633 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.42533 0.59636 moveto 0.42302 0.59528 lineto 0.42307 0.59642 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.38239 0.57633 moveto 0.42307 0.59642 lineto 0.42302 0.59528 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.42866 0.57846 moveto 0.42258 0.58511 lineto 0.42551 0.58706 lineto 0.42 0.385 0.714 setrgbcolor
fill
grestore
gsave
0.42551 0.58706 moveto 0.42258 0.58511 lineto 0.42274 0.58884 lineto 0.42 0.385 0.714 setrgbcolor
fill
grestore
gsave
0.42866 0.57846 moveto 0.42017 0.57715 lineto 0.42258 0.58511 lineto 0.567 0.61 0.855 setrgbcolor
fill
grestore
gsave
0.4272 0.56861 moveto 0.42772 0.58363 lineto 0.43055 0.56804 lineto 0.884 0.91 0.839 setrgbcolor
fill
grestore
gsave
0.42816 0.59628 moveto 0.4272 0.56861 lineto 0.4248 0.59482 lineto 0.884 0.91 0.839 setrgbcolor
fill
grestore
gsave
0.47479 0.55544 moveto 0.42866 0.57846 lineto 0.42551 0.58706 lineto 0.42 0.385 0.714 setrgbcolor
fill
grestore
gsave
0.42551 0.58706 moveto 0.4248 0.59482 lineto 0.42817 0.58535 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.42598 0.59634 moveto 0.4252 0.59598 lineto 0.42533 0.59636 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.42816 0.59628 moveto 0.42563 0.59518 lineto 0.42598 0.59634 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.42817 0.58535 moveto 0.4248 0.59482 lineto 0.42533 0.59636 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.38239 0.57633 moveto 0.42533 0.59636 lineto 0.4252 0.59598 lineto 0.97 0.809 0.628 setrgbcolor
fill
grestore
gsave
0.38239 0.57633 moveto 0.4248 0.59482 lineto 0.4272 0.56861 lineto 0.884 0.91 0.839 setrgbcolor
fill
grestore
gsave
0.47479 0.55544 moveto 0.42817 0.58535 lineto 0.44529 0.61459 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.42816 0.59628 moveto 0.42533 0.59636 lineto 0.42411 0.60111 lineto 0.886 0.961 0.84 setrgbcolor
fill
grestore
gsave
0.44529 0.61459 moveto 0.42817 0.58535 lineto 0.42416 0.60091 lineto 0.52 0.595 0.869 setrgbcolor
fill
grestore
gsave
0.40268 0.62662 moveto 0.42411 0.60111 lineto 0.37967 0.59758 lineto 0.886 0.961 0.84 setrgbcolor
fill
grestore
gsave
0.37967 0.59758 moveto 0.42411 0.60111 lineto 0.42533 0.59636 lineto 0.886 0.961 0.84 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37967 0.59758 moveto
0.40268 0.62662 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40268 0.62662 moveto
0.42411 0.60111 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42411 0.60111 moveto
0.42424 0.60096 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42551 0.58706 moveto
0.4341 0.58155 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42416 0.60091 moveto
0.42424 0.60096 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38239 0.57633 moveto
0.42296 0.59402 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42296 0.59402 moveto
0.4248 0.59482 lineto
stroke
grestore
gsave
0.44529 0.61459 moveto 0.48411 0.57243 lineto 0.47479 0.55544 lineto 0.276 0.299 0.705 setrgbcolor
fill
grestore
gsave
0.47809 0.63245 moveto 0.48411 0.57243 lineto 0.44529 0.61459 lineto 0.458 0.58 0.888 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4341 0.58155 moveto
0.47479 0.55544 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42424 0.60096 moveto
0.44529 0.61459 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44529 0.61459 moveto
0.44769 0.61199 lineto
stroke
grestore
gsave
0.70785 0.3718 moveto 0.61012 0.42307 lineto 0.70126 0.39982 lineto 0.825 0.84 0.86 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69171 0.40226 moveto
0.70126 0.39982 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61012 0.42307 moveto
0.62827 0.41844 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62827 0.41844 moveto
0.62844 0.4184 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68856 0.42892 moveto
0.70126 0.39982 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70733 0.374 moveto
0.71856 0.35478 lineto
stroke
grestore
gsave
0.37471 0.65524 moveto 0.37028 0.63974 lineto 0.34556 0.68179 lineto 0.748 0.984 0.757 setrgbcolor
fill
grestore
gsave
0.34556 0.68179 moveto 0.37028 0.63974 lineto 0.36865 0.64177 lineto 0.748 0.984 0.757 setrgbcolor
fill
grestore
gsave
0.37013 0.63921 moveto 0.36865 0.64177 lineto 0.37028 0.63974 lineto 0.748 0.984 0.757 setrgbcolor
fill
grestore
gsave
0.34556 0.68179 moveto 0.37013 0.63921 lineto 0.36401 0.65903 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.34556 0.68179 moveto 0.36401 0.65903 lineto 0.31653 0.70595 lineto 0.573 0.898 0.641 setrgbcolor
fill
grestore
gsave
0.35758 0.67785 moveto 0.31792 0.705 lineto 0.36401 0.65903 lineto 0 0 0.216 setrgbcolor
fill
grestore
gsave
0.31653 0.70595 moveto 0.31954 0.70298 lineto 0.31792 0.705 lineto 0 0 0.216 setrgbcolor
fill
grestore
gsave
0.36401 0.65903 moveto 0.31792 0.705 lineto 0.31954 0.70298 lineto 0 0 0.216 setrgbcolor
fill
grestore
gsave
0.37471 0.65524 moveto 0.37548 0.61863 lineto 0.37013 0.63921 lineto 0.844 0.817 0.335 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.37471 0.65524 moveto
0.40268 0.62662 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37471 0.65524 moveto
0.37548 0.61863 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.36105 0.66769 moveto
0.37471 0.65524 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66261 0.59477 moveto
0.67255 0.61166 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4339 0.55145 moveto
0.46569 0.53798 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43353 0.55161 moveto
0.4339 0.55145 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42764 0.5541 moveto
0.43353 0.55161 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.36157 0.54704 moveto
0.38275 0.56873 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38339 0.55514 moveto
0.42479 0.56108 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42479 0.56108 moveto
0.42729 0.56144 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46487 0.53625 moveto
0.4669 0.53238 lineto
stroke
grestore
gsave
0.47809 0.63245 moveto 0.49317 0.58892 lineto 0.48411 0.57243 lineto 0.021 0.15 0.66 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47809 0.63245 moveto
0.49242 0.59106 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49242 0.59106 moveto
0.49317 0.58892 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.44529 0.61459 moveto
0.47809 0.63245 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44769 0.61199 moveto
0.48203 0.57468 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48203 0.57468 moveto
0.48411 0.57243 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47809 0.63245 moveto
0.49253 0.63926 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52843 0.51877 moveto
0.53633 0.48674 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67255 0.61166 moveto
0.68327 0.62767 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57819 0.60081 moveto
0.58316 0.59864 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53864 0.61806 moveto
0.57819 0.60081 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52299 0.62488 moveto
0.53864 0.61806 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51786 0.62712 moveto
0.52299 0.62488 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47607 0.65582 moveto
0.4921 0.6393 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.4921 0.6393 moveto
0.49226 0.63913 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36865 0.64177 moveto
0.37013 0.63921 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35163 0.67126 moveto
0.36865 0.64177 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45082 0.5219 moveto
0.45727 0.52009 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43613 0.52604 moveto
0.45082 0.5219 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42899 0.52805 moveto
0.43613 0.52604 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36157 0.54704 moveto
0.38278 0.54107 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.34258 0.52021 moveto
0.36157 0.54704 lineto
stroke
grestore
gsave
0.74167 0.70221 moveto 0.73465 0.69257 lineto 0.74241 0.70258 lineto 0.752 0.238 0 setrgbcolor
fill
grestore
gsave
0.74167 0.70221 moveto 0.74241 0.70258 lineto 0.74218 0.70242 lineto 0.135 0.583 0.926 setrgbcolor
fill
grestore
gsave
0.74167 0.70221 moveto 0.74218 0.70242 lineto 0.74666 0.71068 lineto 0.721 0.228 0.069 setrgbcolor
fill
grestore
gsave
0.72848 0.68387 moveto 0.78771 0.73385 lineto 0.73526 0.69304 lineto 0.705 0.186 0 setrgbcolor
fill
grestore
gsave
0.78812 0.7342 moveto 0.78757 0.73378 lineto 0.78771 0.73385 lineto 0.705 0.186 0 setrgbcolor
fill
grestore
gsave
0.73526 0.69304 moveto 0.78771 0.73385 lineto 0.78757 0.73378 lineto 0.705 0.186 0 setrgbcolor
fill
grestore
gsave
0.73465 0.69257 moveto 0.78812 0.7342 lineto 0.78681 0.7333 lineto 0.705 0.186 0 setrgbcolor
fill
grestore
gsave
0.73465 0.69257 moveto 0.72848 0.68387 lineto 0.73526 0.69304 lineto 0.705 0.186 0 setrgbcolor
fill
grestore
gsave
0.78996 0.73576 moveto 0.78681 0.7333 lineto 0.78812 0.7342 lineto 0.705 0.186 0 setrgbcolor
fill
grestore
gsave
0.81806 0.74006 moveto 0.73465 0.69257 lineto 0.78996 0.73576 lineto 0.233 0.595 0.949 setrgbcolor
fill
grestore
gsave
0.81806 0.74006 moveto 0.74241 0.70258 lineto 0.73465 0.69257 lineto 0.752 0.238 0 setrgbcolor
fill
grestore
gsave
0.84139 0.7425 moveto 0.74218 0.70242 lineto 0.81806 0.74006 lineto 0.135 0.583 0.926 setrgbcolor
fill
grestore
gsave
0.81806 0.74006 moveto 0.74218 0.70242 lineto 0.74241 0.70258 lineto 0.135 0.583 0.926 setrgbcolor
fill
grestore
gsave
0.84139 0.7425 moveto 0.74882 0.71141 lineto 0.74218 0.70242 lineto 0.721 0.228 0.069 setrgbcolor
fill
grestore
gsave
0.74666 0.71068 moveto 0.74218 0.70242 lineto 0.74882 0.71141 lineto 0.721 0.228 0.069 setrgbcolor
fill
grestore
gsave
0.85877 0.74339 moveto 0.74848 0.71121 lineto 0.84139 0.7425 lineto 0.053 0.565 0.878 setrgbcolor
fill
grestore
gsave
0.74666 0.71068 moveto 0.74882 0.71141 lineto 0.74848 0.71121 lineto 0.053 0.565 0.878 setrgbcolor
fill
grestore
gsave
0.84139 0.7425 moveto 0.74848 0.71121 lineto 0.74882 0.71141 lineto 0.053 0.565 0.878 setrgbcolor
fill
grestore
gsave
0.7268 0.68245 moveto 0.72848 0.68387 lineto 0.73465 0.69257 lineto 0.705 0.186 0 setrgbcolor
fill
grestore
gsave
0.726 0.68177 moveto 0.7268 0.68245 lineto 0.73465 0.69257 lineto 0.705 0.186 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78701 0.73345 moveto
0.78996 0.73576 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78681 0.7333 moveto
0.78701 0.73345 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76629 0.71727 moveto
0.78681 0.7333 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.75838 0.7293 moveto
0.78996 0.73576 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.726 0.68177 moveto
0.72621 0.68208 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75735 0.72779 moveto
0.75838 0.7293 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7566 0.7267 moveto
0.75735 0.72779 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72621 0.68208 moveto
0.72688 0.68307 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75651 0.72657 moveto
0.7566 0.7267 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72688 0.68307 moveto
0.75651 0.72657 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.78996 0.73576 moveto
0.81806 0.74006 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68327 0.62767 moveto
0.69436 0.64274 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38248 0.53429 moveto
0.42653 0.53329 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42653 0.53329 moveto
0.42896 0.53324 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46309 0.53246 moveto
0.4669 0.53238 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.4669 0.53238 moveto
0.47802 0.49994 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.77001 0.3153 moveto
0.79781 0.31442 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50154 0.6049 moveto
0.5088 0.63744 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5088 0.63744 moveto
0.50918 0.63915 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53633 0.48674 moveto
0.55155 0.45497 lineto
stroke
grestore
gsave
0.70763 0.34557 moveto 0.60632 0.40649 lineto 0.70785 0.3718 lineto 0.804 0.814 0.86 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70218 0.37374 moveto
0.70785 0.3718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70069 0.37424 moveto
0.70218 0.37374 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60632 0.40649 moveto
0.62706 0.39941 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62706 0.39941 moveto
0.66382 0.38684 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66382 0.38684 moveto
0.70069 0.37424 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70126 0.39982 moveto
0.70785 0.3718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63507 0.3755 moveto
0.63553 0.37659 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62844 0.4184 moveto
0.69171 0.40226 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70768 0.3519 moveto
0.70785 0.3718 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70766 0.34934 moveto
0.70768 0.3519 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70763 0.34557 moveto
0.70766 0.34934 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.69436 0.64274 moveto
0.70544 0.65682 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4447 0.50277 moveto
0.45004 0.50186 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43876 0.50378 moveto
0.4447 0.50277 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43094 0.50512 moveto
0.43876 0.50378 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34258 0.52021 moveto
0.3795 0.5139 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.32979 0.49166 moveto
0.34258 0.52021 lineto
stroke
grestore
gsave
0.31653 0.70595 moveto 0.35758 0.67785 lineto 0.28899 0.72747 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31653 0.70595 moveto
0.31954 0.70298 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37954 0.51407 moveto
0.42997 0.50683 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42997 0.50683 moveto
0.431 0.50668 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45082 0.50384 moveto
0.47802 0.49994 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47802 0.49994 moveto
0.4825 0.46806 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47607 0.65582 moveto
0.48272 0.65332 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48272 0.65332 moveto
0.51083 0.64272 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51083 0.64272 moveto
0.51625 0.64068 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5731 0.61925 moveto
0.57926 0.61693 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54008 0.6317 moveto
0.5731 0.61925 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52804 0.63624 moveto
0.54008 0.6317 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46407 0.67169 moveto
0.47607 0.65582 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70544 0.65682 moveto
0.71612 0.66984 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.73803 0.32147 moveto
0.77001 0.3153 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55155 0.45497 moveto
0.57348 0.4244 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81377 0.73793 moveto
0.81806 0.74006 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.78424 0.7233 moveto
0.81377 0.73793 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.81806 0.74006 moveto
0.84139 0.7425 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60297 0.51963 moveto
0.60704 0.49938 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60704 0.49938 moveto
0.61007 0.47936 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61007 0.47936 moveto
0.61177 0.45979 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44292 0.48353 moveto
0.44448 0.48342 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44 0.48374 moveto
0.44292 0.48353 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32979 0.49166 moveto
0.38783 0.48749 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59819 0.53988 moveto
0.60297 0.51963 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61177 0.45979 moveto
0.61187 0.44094 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59303 0.55993 moveto
0.59819 0.53988 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6906 0.35287 moveto
0.70763 0.34557 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66484 0.3639 moveto
0.6906 0.35287 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63798 0.3754 moveto
0.66484 0.3639 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63563 0.3764 moveto
0.63798 0.3754 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70372 0.33312 moveto
0.70763 0.34557 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70363 0.33283 moveto
0.70364 0.33286 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70324 0.33162 moveto
0.70363 0.33283 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61012 0.42307 moveto
0.61187 0.44094 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.71612 0.66984 moveto
0.726 0.68177 lineto
stroke
grestore
gsave
0.28899 0.72747 moveto 0.35134 0.6954 lineto 0.26428 0.74614 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.28899 0.72747 moveto 0.35758 0.67785 lineto 0.35134 0.6954 lineto 0.205 0 0.316 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36092 0.66208 moveto
0.36401 0.65903 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.28899 0.72747 moveto
0.31653 0.70595 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28899 0.72747 moveto
0.29347 0.72423 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43435 0.47996 moveto
0.43861 0.47891 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44342 0.47772 moveto
0.45225 0.47554 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45225 0.47554 moveto
0.4825 0.46806 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57348 0.4244 moveto
0.60111 0.39603 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70338 0.33295 moveto
0.70651 0.33191 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70651 0.33191 moveto
0.73803 0.32147 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58789 0.57958 moveto
0.59303 0.55993 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60632 0.40649 moveto
0.61012 0.42307 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60107 0.39335 moveto
0.60632 0.40649 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60085 0.39282 moveto
0.60107 0.39335 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58316 0.59864 moveto
0.58789 0.57958 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60111 0.39603 moveto
0.60189 0.39541 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57963 0.67586 moveto
0.59842 0.68314 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.726 0.68177 moveto
0.73465 0.69257 lineto
stroke
grestore
gsave
0.16631 0.3505 moveto 0.22995 0.41417 lineto 0.24238 0.40877 lineto 0.638 0.73 0.914 setrgbcolor
fill
grestore
gsave
0.70019 0.32191 moveto 0.5921 0.37846 lineto 0.60033 0.39151 lineto 0.738 0.669 0.783 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.66778 0.34955 moveto
0.70338 0.33295 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61003 0.38899 moveto
0.63309 0.3708 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60033 0.39151 moveto
0.60085 0.39282 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60033 0.39151 moveto
0.61455 0.38543 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66778 0.34955 moveto
0.66786 0.35275 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63309 0.3708 moveto
0.63507 0.3755 lineto
stroke
grestore
gsave
0.32401 0.46189 moveto 0.4401 0.44673 lineto 0.3258 0.43149 lineto 0.7 0.698 0.845 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32401 0.46189 moveto
0.4298 0.46467 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.32401 0.46189 moveto
0.32979 0.49166 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44262 0.47345 moveto
0.44448 0.48342 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44448 0.48342 moveto
0.45004 0.50186 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63309 0.3708 moveto
0.66778 0.34955 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45004 0.50186 moveto
0.45727 0.52009 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45727 0.52009 moveto
0.46569 0.53798 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57926 0.61693 moveto
0.58316 0.59864 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51555 0.65458 moveto
0.52376 0.65185 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46407 0.67169 moveto
0.51555 0.65458 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55603 0.64113 moveto
0.55885 0.64019 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54267 0.64557 moveto
0.55603 0.64113 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54029 0.64636 moveto
0.54267 0.64557 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55885 0.64019 moveto
0.57664 0.63428 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45871 0.68524 moveto
0.46407 0.67169 lineto
stroke
grestore
gsave
0.47973 0.43752 moveto 0.36732 0.47661 lineto 0.37449 0.49474 lineto 0.744 0.608 0.707 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37449 0.49474 moveto
0.43435 0.47996 lineto
stroke
grestore
gsave
0.3258 0.43149 moveto 0.4401 0.44673 lineto 0.44192 0.42904 lineto 0.729 0.637 0.756 setrgbcolor
fill
grestore
gsave
0.44663 0.41223 moveto 0.35264 0.40294 lineto 0.44192 0.42904 lineto 0.753 0.674 0.774 setrgbcolor
fill
grestore
gsave
0.44192 0.42904 moveto 0.342 0.40296 lineto 0.3258 0.43149 lineto 0.713 0.717 0.852 setrgbcolor
fill
grestore
gsave
0.3258 0.43149 moveto 0.342 0.40296 lineto 0.33052 0.41659 lineto 0.713 0.717 0.852 setrgbcolor
fill
grestore
gsave
0.31951 0.42168 moveto 0.32576 0.42076 lineto 0.34155 0.39939 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.34388 0.41809 moveto 0.34186 0.40187 lineto 0.32576 0.42076 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.34155 0.39939 moveto 0.32576 0.42076 lineto 0.34186 0.40187 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.36344 0.37657 moveto 0.35925 0.38148 lineto 0.44663 0.41223 lineto 0.723 0.735 0.86 setrgbcolor
fill
grestore
gsave
0.34186 0.40187 moveto 0.34982 0.40266 lineto 0.35925 0.38148 lineto 0.723 0.735 0.86 setrgbcolor
fill
grestore
gsave
0.44663 0.41223 moveto 0.35925 0.38148 lineto 0.34982 0.40266 lineto 0.723 0.735 0.86 setrgbcolor
fill
grestore
gsave
0.35264 0.40294 moveto 0.34186 0.40187 lineto 0.35222 0.40563 lineto 0.753 0.674 0.774 setrgbcolor
fill
grestore
gsave
0.35222 0.40563 moveto 0.34186 0.40187 lineto 0.342 0.40296 lineto 0.753 0.674 0.774 setrgbcolor
fill
grestore
gsave
0.44192 0.42904 moveto 0.35264 0.40294 lineto 0.35222 0.40563 lineto 0.753 0.674 0.774 setrgbcolor
fill
grestore
gsave
0.34388 0.41809 moveto 0.36198 0.39242 lineto 0.34155 0.39939 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.45422 0.39672 moveto 0.40256 0.38413 lineto 0.44663 0.41223 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.44663 0.41223 moveto 0.40256 0.38413 lineto 0.3997 0.38831 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.44663 0.41223 moveto 0.38135 0.37895 lineto 0.38022 0.38215 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.44663 0.41223 moveto 0.36361 0.37463 lineto 0.36354 0.37547 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.44663 0.41223 moveto 0.35924 0.37356 lineto 0.36176 0.37585 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.46449 0.3829 moveto 0.42895 0.36732 lineto 0.45422 0.39672 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.36444 0.42677 moveto 0.37421 0.41661 lineto 0.37297 0.40264 lineto 0.655 0.581 0.76 setrgbcolor
fill
grestore
gsave
0.42895 0.36732 moveto 0.40672 0.35757 lineto 0.42219 0.37506 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.42219 0.37506 moveto 0.40672 0.35757 lineto 0.4039 0.36269 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.38135 0.37895 moveto 0.3997 0.38831 lineto 0.40256 0.38413 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.34639 0.3619 moveto 0.35924 0.37356 lineto 0.35971 0.33229 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.35971 0.33229 moveto 0.35924 0.37356 lineto 0.35933 0.37343 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.31951 0.42168 moveto 0.35933 0.37364 lineto 0.34639 0.3619 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.45422 0.39672 moveto 0.37869 0.34564 lineto 0.35924 0.37356 lineto 0.73 0.751 0.869 setrgbcolor
fill
grestore
gsave
0.40797 0.32016 moveto 0.38345 0.33965 lineto 0.46449 0.3829 lineto 0.733 0.764 0.878 setrgbcolor
fill
grestore
gsave
0.37699 0.34164 moveto 0.3811 0.34229 lineto 0.37832 0.33865 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.37832 0.33865 moveto 0.3811 0.34229 lineto 0.38294 0.34023 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.36361 0.37463 moveto 0.38022 0.38215 lineto 0.38135 0.37895 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.35924 0.37356 moveto 0.36354 0.37547 lineto 0.36361 0.37463 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.34155 0.39939 moveto 0.36198 0.39242 lineto 0.36337 0.37732 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.35925 0.38148 moveto 0.35933 0.37364 lineto 0.31951 0.42168 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.35971 0.33229 moveto 0.35925 0.38148 lineto 0.37832 0.33865 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.35269 0.37197 moveto 0.34186 0.40187 lineto 0.36344 0.37657 lineto 0.723 0.735 0.86 setrgbcolor
fill
grestore
gsave
0.35925 0.38148 moveto 0.3835 0.35695 lineto 0.37699 0.34164 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.46449 0.3829 moveto 0.38345 0.33965 lineto 0.3785 0.3452 lineto 0.733 0.764 0.878 setrgbcolor
fill
grestore
gsave
0.40672 0.35757 moveto 0.38597 0.34848 lineto 0.4039 0.36269 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.3785 0.3452 moveto 0.38552 0.35003 lineto 0.38597 0.34848 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.4039 0.36269 moveto 0.38597 0.34848 lineto 0.38552 0.35003 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.36198 0.39242 moveto 0.38102 0.36544 lineto 0.36337 0.37732 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.4039 0.36269 moveto 0.3785 0.3452 lineto 0.37869 0.34564 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.39572 0.34459 moveto 0.3835 0.35695 lineto 0.38102 0.36544 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.36337 0.37732 moveto 0.38102 0.36544 lineto 0.3835 0.35695 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.39572 0.34459 moveto 0.37699 0.34164 lineto 0.3835 0.35695 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.37719 0.34463 moveto 0.3785 0.3452 lineto 0.38345 0.33965 lineto 0.733 0.764 0.878 setrgbcolor
fill
grestore
gsave
0.39572 0.34459 moveto 0.38294 0.34023 lineto 0.3811 0.34229 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.37719 0.34463 moveto 0.37869 0.34564 lineto 0.3785 0.3452 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.35269 0.37197 moveto 0.35924 0.37356 lineto 0.37719 0.34463 lineto 0.73 0.751 0.869 setrgbcolor
fill
grestore
gsave
0.37719 0.34463 moveto 0.35924 0.37356 lineto 0.37869 0.34564 lineto 0.73 0.751 0.869 setrgbcolor
fill
grestore
gsave
0.35933 0.37364 moveto 0.35933 0.37343 lineto 0.35924 0.37356 lineto 0.7 0.707 0.853 setrgbcolor
fill
grestore
gsave
0.42677 0.36189 moveto 0.38829 0.39103 lineto 0.37421 0.41661 lineto 0.655 0.581 0.76 setrgbcolor
fill
grestore
gsave
0.37297 0.40264 moveto 0.37421 0.41661 lineto 0.38829 0.39103 lineto 0.655 0.581 0.76 setrgbcolor
fill
grestore
gsave
0.45422 0.39672 moveto 0.42895 0.36732 lineto 0.42219 0.37506 lineto 0.78 0.746 0.821 setrgbcolor
fill
grestore
gsave
0.45162 0.38362 moveto 0.3759 0.42803 lineto 0.35807 0.45995 lineto 0.683 0.584 0.739 setrgbcolor
fill
grestore
gsave
0.37014 0.43141 moveto 0.36751 0.43765 lineto 0.3759 0.42803 lineto 0.683 0.584 0.739 setrgbcolor
fill
grestore
gsave
0.35807 0.45995 moveto 0.3759 0.42803 lineto 0.36751 0.43765 lineto 0.683 0.584 0.739 setrgbcolor
fill
grestore
gsave
0.34687 0.44507 moveto 0.35415 0.45474 lineto 0.37014 0.43141 lineto 0.683 0.584 0.739 setrgbcolor
fill
grestore
gsave
0.35807 0.45995 moveto 0.37014 0.43141 lineto 0.35415 0.45474 lineto 0.683 0.584 0.739 setrgbcolor
fill
grestore
gsave
0.34687 0.44507 moveto 0.36444 0.42677 lineto 0.35 0.42004 lineto 0.655 0.581 0.76 setrgbcolor
fill
grestore
gsave
0.35 0.42004 moveto 0.36444 0.42677 lineto 0.37297 0.40264 lineto 0.655 0.581 0.76 setrgbcolor
fill
grestore
gsave
0.35269 0.37197 moveto 0.36176 0.37585 lineto 0.35924 0.37356 lineto 0.771 0.711 0.796 setrgbcolor
fill
grestore
gsave
0.33539 0.40124 moveto 0.34186 0.40187 lineto 0.35269 0.37197 lineto 0.723 0.735 0.86 setrgbcolor
fill
grestore
gsave
0.33539 0.40124 moveto 0.33052 0.41659 lineto 0.342 0.40296 lineto 0.713 0.717 0.852 setrgbcolor
fill
grestore
gsave
0.34388 0.41809 moveto 0.32719 0.42055 lineto 0.33391 0.43223 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.31951 0.42168 moveto 0.32367 0.42473 lineto 0.32719 0.42055 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.33391 0.43223 moveto 0.32719 0.42055 lineto 0.32367 0.42473 lineto 0.629 0.585 0.785 setrgbcolor
fill
grestore
gsave
0.33539 0.40124 moveto 0.342 0.40296 lineto 0.34186 0.40187 lineto 0.753 0.674 0.774 setrgbcolor
fill
grestore
gsave
0.33391 0.43223 moveto 0.34625 0.44445 lineto 0.35 0.42004 lineto 0.655 0.581 0.76 setrgbcolor
fill
grestore
gsave
0.34687 0.44507 moveto 0.35 0.42004 lineto 0.34625 0.44445 lineto 0.655 0.581 0.76 setrgbcolor
fill
grestore
gsave
0.46942 0.4091 moveto 0.36732 0.47661 lineto 0.47973 0.43752 lineto 0.772 0.737 0.821 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.47973 0.43752 moveto
0.4825 0.46806 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36792 0.4764 moveto
0.46664 0.44207 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46664 0.44207 moveto
0.4693 0.44114 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4693 0.44114 moveto
0.47973 0.43752 lineto
stroke
grestore
gsave
0.68541 0.3016 moveto 0.5921 0.37846 lineto 0.70019 0.32191 lineto 0.769 0.784 0.866 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.70019 0.32191 moveto
0.70324 0.33162 lineto
stroke
grestore
gsave
0.68541 0.3016 moveto 0.58168 0.36764 lineto 0.5921 0.37846 lineto 0.719 0.672 0.803 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5921 0.37846 moveto
0.60033 0.39151 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5921 0.37846 moveto
0.70019 0.32191 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3258 0.43149 moveto
0.33432 0.43263 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35603 0.43552 moveto
0.36182 0.4363 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38352 0.43919 moveto
0.41713 0.44367 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.32401 0.46189 moveto
0.3258 0.43149 lineto
stroke
grestore
gsave
0.20054 0.33697 moveto 0.24238 0.40877 lineto 0.25659 0.4059 lineto 0.61 0.708 0.914 setrgbcolor
fill
grestore
gsave
0.16631 0.3505 moveto 0.24238 0.40877 lineto 0.20054 0.33697 lineto 0.666 0.734 0.901 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.22995 0.41417 moveto
0.24238 0.40877 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46569 0.53798 moveto
0.47479 0.55544 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43025 0.42599 moveto
0.44002 0.42854 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4071 0.41995 moveto
0.43025 0.42599 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44252 0.42688 moveto
0.44663 0.41223 lineto
stroke
grestore
gsave
0.66352 0.28538 moveto 0.58168 0.36764 lineto 0.68541 0.3016 lineto 0.755 0.778 0.872 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.68541 0.3016 moveto
0.70019 0.32191 lineto
stroke
grestore
gsave
0.66352 0.28538 moveto 0.56924 0.35935 lineto 0.58168 0.36764 lineto 0.705 0.683 0.826 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58168 0.36764 moveto
0.5921 0.37846 lineto
stroke
grestore
gsave
0.26428 0.74614 moveto 0.34586 0.71145 lineto 0.24372 0.76182 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.26428 0.74614 moveto 0.35134 0.6954 lineto 0.34586 0.71145 lineto 0.34 0.072 0.354 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35276 0.68133 moveto
0.35758 0.67785 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.26428 0.74614 moveto
0.28899 0.72747 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26428 0.74614 moveto
0.2701 0.74275 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35855 0.66443 moveto
0.36092 0.66208 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31954 0.70298 moveto
0.35855 0.66443 lineto
stroke
grestore
gsave
0.23881 0.32793 moveto 0.25659 0.4059 lineto 0.27201 0.40572 lineto 0.591 0.677 0.9 setrgbcolor
fill
grestore
gsave
0.20054 0.33697 moveto 0.25659 0.4059 lineto 0.23881 0.32793 lineto 0.667 0.728 0.895 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.24238 0.40877 moveto
0.25659 0.4059 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.16631 0.3505 moveto
0.22995 0.41417 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73465 0.69257 moveto
0.74167 0.70221 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42691 0.40378 moveto
0.44663 0.41223 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44663 0.41223 moveto
0.45422 0.39672 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47479 0.55544 moveto
0.48411 0.57243 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57664 0.63428 moveto
0.57926 0.61693 lineto
stroke
grestore
gsave
0.63516 0.27393 moveto 0.56924 0.35935 lineto 0.66352 0.28538 lineto 0.744 0.775 0.878 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68019 0.30492 moveto
0.68541 0.3016 lineto
stroke
grestore
gsave
0.63516 0.27393 moveto 0.55508 0.35384 lineto 0.56924 0.35935 lineto 0.699 0.702 0.85 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58168 0.36764 moveto
0.58708 0.3642 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.56924 0.35935 moveto
0.58168 0.36764 lineto
stroke
grestore
gsave
0.27937 0.32395 moveto 0.27201 0.40572 lineto 0.28803 0.40831 lineto 0.585 0.644 0.876 setrgbcolor
fill
grestore
gsave
0.23881 0.32793 moveto 0.27201 0.40572 lineto 0.27937 0.32395 lineto 0.671 0.722 0.887 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.25659 0.4059 moveto
0.27201 0.40572 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23881 0.32793 moveto
0.23942 0.3306 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23942 0.3306 moveto
0.25373 0.39336 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25373 0.39336 moveto
0.25659 0.4059 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.20054 0.33697 moveto
0.24238 0.40877 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.3258 0.43149 moveto
0.32714 0.42727 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.38248 0.53429 moveto
0.38339 0.55514 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37954 0.51407 moveto
0.38248 0.53429 lineto
stroke
grestore
gsave
0.60137 0.26778 moveto 0.55508 0.35384 lineto 0.63516 0.27393 lineto 0.737 0.776 0.884 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65921 0.28876 moveto
0.66352 0.28538 lineto
stroke
grestore
gsave
0.60137 0.26778 moveto 0.53965 0.3513 lineto 0.55508 0.35384 lineto 0.7 0.727 0.871 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58708 0.3642 moveto
0.59769 0.35745 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56924 0.35935 moveto
0.57663 0.35355 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55508 0.35384 moveto
0.56924 0.35935 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.38239 0.57633 moveto
0.38339 0.55514 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37449 0.49474 moveto
0.37954 0.51407 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48411 0.57243 moveto
0.49317 0.58892 lineto
stroke
grestore
gsave
0.40797 0.32016 moveto 0.46449 0.3829 lineto 0.4771 0.37118 lineto 0.78 0.773 0.847 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45422 0.39672 moveto
0.46449 0.3829 lineto
stroke
grestore
gsave
0.32032 0.32537 moveto 0.28803 0.40831 lineto 0.30405 0.41366 lineto 0.591 0.616 0.845 setrgbcolor
fill
grestore
gsave
0.27937 0.32395 moveto 0.28803 0.40831 lineto 0.32032 0.32537 lineto 0.678 0.715 0.877 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27201 0.40572 moveto
0.28803 0.40831 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27201 0.40572 moveto
0.27937 0.32395 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37967 0.59758 moveto
0.38239 0.57633 lineto
stroke
grestore
gsave
0.46942 0.4091 moveto 0.35807 0.45995 lineto 0.36732 0.47661 lineto 0.712 0.594 0.722 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.36732 0.47661 moveto
0.37449 0.49474 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36732 0.47661 moveto
0.36792 0.4764 lineto
stroke
grestore
gsave
0.35971 0.33229 moveto 0.30405 0.41366 lineto 0.31951 0.42168 lineto 0.607 0.596 0.814 setrgbcolor
fill
grestore
gsave
0.32032 0.32537 moveto 0.30405 0.41366 lineto 0.35971 0.33229 lineto 0.688 0.71 0.865 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28803 0.40831 moveto
0.32032 0.32537 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28803 0.40831 moveto
0.30405 0.41366 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30405 0.41366 moveto
0.32605 0.3815 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30405 0.41366 moveto
0.31951 0.42168 lineto
stroke
grestore
gsave
0.56356 0.26728 moveto 0.53965 0.3513 lineto 0.60137 0.26778 lineto 0.732 0.778 0.889 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63225 0.27683 moveto
0.63516 0.27393 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57663 0.35355 moveto
0.65921 0.28876 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59769 0.35745 moveto
0.68019 0.30492 lineto
stroke
grestore
gsave
0.56356 0.26728 moveto 0.52349 0.35181 lineto 0.53965 0.3513 lineto 0.709 0.754 0.887 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56643 0.34252 moveto
0.63225 0.27683 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.53965 0.3513 moveto
0.55508 0.35384 lineto
stroke
grestore
gsave
0.44372 0.29949 moveto 0.4771 0.37118 lineto 0.49154 0.36191 lineto 0.768 0.789 0.87 setrgbcolor
fill
grestore
gsave
0.40797 0.32016 moveto 0.4771 0.37118 lineto 0.44372 0.29949 lineto 0.733 0.774 0.885 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4523 0.36937 moveto
0.46449 0.3829 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46449 0.3829 moveto
0.4771 0.37118 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40797 0.32016 moveto
0.41285 0.32558 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41285 0.32558 moveto
0.42811 0.34251 lineto
stroke
grestore
gsave
0.45162 0.38362 moveto 0.35807 0.45995 lineto 0.46942 0.4091 lineto 0.751 0.723 0.825 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36188 0.45822 moveto
0.46942 0.4091 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35807 0.45995 moveto
0.36188 0.45822 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35807 0.45995 moveto
0.36732 0.47661 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46942 0.4091 moveto
0.47973 0.43752 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57946 0.67519 moveto
0.59379 0.6812 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59379 0.6812 moveto
0.59852 0.68318 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37548 0.61863 moveto
0.37967 0.59758 lineto
stroke
grestore
gsave
0.42677 0.36189 moveto 0.34687 0.44507 lineto 0.45162 0.38362 lineto 0.733 0.713 0.833 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34687 0.44507 moveto
0.34837 0.44419 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45162 0.38362 moveto
0.46942 0.4091 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34687 0.44507 moveto
0.35807 0.45995 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31951 0.42168 moveto
0.32162 0.41955 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32162 0.41955 moveto
0.33334 0.40769 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31951 0.42168 moveto
0.32367 0.42473 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57572 0.65054 moveto
0.57664 0.63428 lineto
stroke
grestore
gsave
0.39572 0.34459 moveto 0.33391 0.43223 lineto 0.42677 0.36189 lineto 0.715 0.708 0.842 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33391 0.43223 moveto
0.33428 0.43194 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33578 0.43081 moveto
0.35 0.42004 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33428 0.43194 moveto
0.33578 0.43081 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35 0.42004 moveto
0.37297 0.40264 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37297 0.40264 moveto
0.38829 0.39103 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38829 0.39103 moveto
0.39461 0.38625 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39461 0.38625 moveto
0.42677 0.36189 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32367 0.42473 moveto
0.33391 0.43223 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35925 0.38148 moveto
0.36337 0.37732 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36337 0.37732 moveto
0.3835 0.35695 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3835 0.35695 moveto
0.39572 0.34459 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.33391 0.43223 moveto
0.34687 0.44507 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35972 0.37498 moveto
0.36176 0.37585 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35269 0.37197 moveto
0.35972 0.37498 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3759 0.42803 moveto
0.4455 0.38721 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4455 0.38721 moveto
0.45162 0.38362 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37014 0.43141 moveto
0.3759 0.42803 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34837 0.44419 moveto
0.37014 0.43141 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32605 0.3815 moveto
0.34514 0.35358 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34514 0.35358 moveto
0.35971 0.33229 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33052 0.41659 moveto
0.33539 0.40124 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33539 0.40124 moveto
0.342 0.40296 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37719 0.34463 moveto
0.37869 0.34564 lineto
stroke
grestore
gsave
0.52341 0.27254 moveto 0.52349 0.35181 lineto 0.56356 0.26728 lineto 0.731 0.78 0.892 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53965 0.3513 moveto
0.60076 0.26861 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60076 0.26861 moveto
0.60137 0.26778 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55508 0.35384 moveto
0.56643 0.34252 lineto
stroke
grestore
gsave
0.52341 0.27254 moveto 0.50723 0.35539 lineto 0.52349 0.35181 lineto 0.727 0.777 0.893 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52349 0.35181 moveto
0.53965 0.3513 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52349 0.35181 moveto
0.56356 0.26728 lineto
stroke
grestore
gsave
0.48282 0.28341 moveto 0.49154 0.36191 lineto 0.50723 0.35539 lineto 0.749 0.791 0.887 setrgbcolor
fill
grestore
gsave
0.44372 0.29949 moveto 0.49154 0.36191 lineto 0.48282 0.28341 lineto 0.732 0.779 0.89 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4771 0.37118 moveto
0.49154 0.36191 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42811 0.34251 moveto
0.4523 0.36937 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44972 0.31236 moveto
0.4771 0.37118 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44684 0.30618 moveto
0.44972 0.31236 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44372 0.29949 moveto
0.44684 0.30618 lineto
stroke
grestore
gsave
0.48282 0.28341 moveto 0.50723 0.35539 lineto 0.52341 0.27254 lineto 0.731 0.781 0.893 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50723 0.35539 moveto
0.52341 0.27254 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49154 0.36191 moveto
0.50723 0.35539 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48282 0.28341 moveto
0.49154 0.36191 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50723 0.35539 moveto
0.52349 0.35181 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37013 0.63921 moveto
0.37548 0.61863 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49317 0.58892 moveto
0.50154 0.6049 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.66352 0.28538 moveto
0.68541 0.3016 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.36401 0.65903 moveto
0.37013 0.63921 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55901 0.65549 moveto
0.57572 0.65054 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55309 0.65725 moveto
0.55901 0.65549 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53445 0.66278 moveto
0.54346 0.66011 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52276 0.66624 moveto
0.52593 0.6653 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5262 0.66522 moveto
0.53445 0.66278 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45871 0.68524 moveto
0.52276 0.66624 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45871 0.68524 moveto
0.46079 0.69652 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57572 0.65054 moveto
0.57691 0.66556 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33539 0.40124 moveto
0.35269 0.37197 lineto
stroke
grestore
gsave
0.24372 0.76182 moveto 0.34169 0.7258 lineto 0.22855 0.77442 lineto 0.033 0 0 setrgbcolor
fill
grestore
gsave
0.24372 0.76182 moveto 0.34586 0.71145 lineto 0.34169 0.7258 lineto 0.424 0.129 0.358 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34473 0.69925 moveto
0.35134 0.6954 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2701 0.74275 moveto
0.34473 0.69925 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.24372 0.76182 moveto
0.26428 0.74614 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24372 0.76182 moveto
0.25073 0.75836 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25073 0.75836 moveto
0.34586 0.71145 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34905 0.68401 moveto
0.35276 0.68133 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29347 0.72423 moveto
0.34905 0.68401 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35758 0.67785 moveto
0.36401 0.65903 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50154 0.6049 moveto
0.50885 0.62038 lineto
stroke
grestore
gsave
0.85877 0.74339 moveto 0.74924 0.71797 lineto 0.74666 0.71068 lineto 0.667 0.185 0.097 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74167 0.70221 moveto
0.74666 0.71068 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.81114 0.73234 moveto
0.84139 0.7425 lineto
stroke
grestore
gsave
0.86913 0.74307 moveto 0.74924 0.71797 lineto 0.85877 0.74339 lineto 0.002 0.552 0.825 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.84139 0.7425 moveto
0.85877 0.74339 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42677 0.36189 moveto
0.45162 0.38362 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35134 0.6954 moveto
0.35758 0.67785 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56442 0.66889 moveto
0.57691 0.66556 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55571 0.67122 moveto
0.56442 0.66889 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63516 0.27393 moveto
0.66352 0.28538 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50885 0.62038 moveto
0.51473 0.63535 lineto
stroke
grestore
gsave
0.61924 0.69187 moveto 0.52096 0.66372 lineto 0.51886 0.6498 lineto 0.803 0.436 0.361 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61343 0.6902 moveto
0.61924 0.69187 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58693 0.68261 moveto
0.61343 0.6902 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58141 0.68103 moveto
0.58693 0.68261 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56672 0.67683 moveto
0.58141 0.68103 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57691 0.66556 moveto
0.57946 0.6752 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52816 0.67856 moveto
0.54463 0.67417 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46079 0.69652 moveto
0.52748 0.67874 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54463 0.67417 moveto
0.54963 0.67284 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59852 0.68318 moveto
0.61924 0.69187 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51886 0.6498 moveto
0.52135 0.65084 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52135 0.65084 moveto
0.56282 0.66822 lineto
stroke
grestore
gsave
0.86913 0.74307 moveto 0.74908 0.72408 lineto 0.74924 0.71797 lineto 0.602 0.116 0.073 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74666 0.71068 moveto
0.74924 0.71797 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83222 0.73723 moveto
0.85877 0.74339 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.35269 0.37197 moveto
0.37719 0.34463 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40345 0.3489 moveto
0.42677 0.36189 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39572 0.34459 moveto
0.40345 0.3489 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34586 0.71145 moveto
0.35134 0.6954 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.16631 0.3505 moveto
0.20054 0.33697 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47084 0.70566 moveto
0.47851 0.70381 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56979 0.68183 moveto
0.57442 0.68072 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55839 0.68458 moveto
0.56979 0.68183 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58261 0.68332 moveto
0.58374 0.68553 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58374 0.68553 moveto
0.58606 0.69008 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51473 0.63535 moveto
0.51886 0.6498 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60137 0.26778 moveto
0.63516 0.27393 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46079 0.69652 moveto
0.47084 0.70566 lineto
stroke
grestore
gsave
0.22855 0.77442 moveto 0.33936 0.73827 lineto 0.21992 0.78388 lineto 0.082 0 0 setrgbcolor
fill
grestore
gsave
0.22855 0.77442 moveto 0.34169 0.7258 lineto 0.33936 0.73827 lineto 0.477 0.153 0.338 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.22855 0.77442 moveto
0.24372 0.76182 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22855 0.77442 moveto
0.34169 0.7258 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34169 0.7258 moveto
0.34586 0.71145 lineto
stroke
grestore
gsave
0.87162 0.74186 moveto 0.74908 0.72408 lineto 0.86913 0.74307 lineto 0 0.552 0.786 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.85877 0.74339 moveto
0.86913 0.74307 lineto
stroke
grestore
gsave
0.87162 0.74186 moveto 0.74598 0.72901 lineto 0.74908 0.72408 lineto 0.521 0.017 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74908 0.72408 moveto
0.74924 0.71797 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.84296 0.73893 moveto
0.86913 0.74307 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.38294 0.34023 moveto
0.39572 0.34459 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.35971 0.33229 moveto
0.38279 0.34018 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37719 0.34463 moveto
0.38345 0.33965 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.38345 0.33965 moveto
0.40797 0.32016 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.20054 0.33697 moveto
0.23881 0.32793 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.32032 0.32537 moveto
0.35971 0.33229 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56356 0.26728 moveto
0.60137 0.26778 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.23881 0.32793 moveto
0.27937 0.32395 lineto
stroke
grestore
gsave
0.86566 0.74008 moveto 0.74598 0.72901 lineto 0.87162 0.74186 lineto 0 0.565 0.768 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.86913 0.74307 moveto
0.87162 0.74186 lineto
stroke
grestore
gsave
0.86566 0.74008 moveto 0.73983 0.73278 lineto 0.74598 0.72901 lineto 0.414 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74598 0.72901 moveto
0.74908 0.72408 lineto
stroke
grestore
gsave
0.63368 0.69956 moveto 0.52076 0.67709 lineto 0.52096 0.66372 lineto 0.749 0.395 0.382 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60624 0.6941 moveto
0.63368 0.69956 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58272 0.68942 moveto
0.60624 0.6941 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51886 0.6498 moveto
0.52096 0.66372 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61924 0.69187 moveto
0.63368 0.69956 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52352 0.66445 moveto
0.56672 0.67683 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52096 0.66372 moveto
0.52352 0.66445 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40797 0.32016 moveto
0.44372 0.29949 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.27937 0.32395 moveto
0.32032 0.32537 lineto
stroke
grestore
gsave
0.60731 0.71154 moveto 0.51933 0.71794 lineto 0.59575 0.70227 lineto 0.68 0.223 0.16 setrgbcolor
fill
grestore
gsave
0.59575 0.70227 moveto 0.51933 0.71794 lineto 0.51897 0.71748 lineto 0.68 0.223 0.16 setrgbcolor
fill
grestore
gsave
0.59575 0.70227 moveto 0.51505 0.71825 lineto 0.48903 0.71282 lineto 0.321 0 0 setrgbcolor
fill
grestore
gsave
0.49417 0.72429 moveto 0.50144 0.71692 lineto 0.51505 0.71825 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.60731 0.71154 moveto 0.55078 0.72177 lineto 0.51505 0.71825 lineto 0.248 0 0 setrgbcolor
fill
grestore
gsave
0.51738 0.7248 moveto 0.51544 0.71935 lineto 0.55116 0.72215 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.59049 0.72639 moveto 0.55465 0.72561 lineto 0.55116 0.72215 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.51738 0.7248 moveto 0.55116 0.72215 lineto 0.55465 0.72561 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.62119 0.7193 moveto 0.58784 0.72498 lineto 0.55114 0.72213 lineto 0.158 0 0 setrgbcolor
fill
grestore
gsave
0.62119 0.7193 moveto 0.56123 0.72172 lineto 0.60731 0.71154 lineto 0.622 0.089 0 setrgbcolor
fill
grestore
gsave
0.55114 0.72213 moveto 0.55957 0.72054 lineto 0.56123 0.72172 lineto 0.622 0.089 0 setrgbcolor
fill
grestore
gsave
0.60731 0.71154 moveto 0.56123 0.72172 lineto 0.55957 0.72054 lineto 0.622 0.089 0 setrgbcolor
fill
grestore
gsave
0.51276 0.70205 moveto 0.53922 0.70608 lineto 0.51637 0.71414 lineto 0.576 0.215 0.319 setrgbcolor
fill
grestore
gsave
0.60731 0.71154 moveto 0.55114 0.72213 lineto 0.55078 0.72177 lineto 0.622 0.089 0 setrgbcolor
fill
grestore
gsave
0.63692 0.7256 moveto 0.59868 0.72525 lineto 0.62119 0.7193 lineto 0.474 0 0 setrgbcolor
fill
grestore
gsave
0.59049 0.72639 moveto 0.59048 0.72639 lineto 0.6119 0.72686 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.63692 0.7256 moveto 0.6297 0.72727 lineto 0.60183 0.72589 lineto 0.066 0 0 setrgbcolor
fill
grestore
gsave
0.60183 0.72589 moveto 0.6297 0.72727 lineto 0.62175 0.72688 lineto 0.066 0 0 setrgbcolor
fill
grestore
gsave
0.63692 0.7256 moveto 0.60183 0.72589 lineto 0.58817 0.72516 lineto 0.066 0 0 setrgbcolor
fill
grestore
gsave
0.59868 0.72525 moveto 0.58817 0.72516 lineto 0.59531 0.72371 lineto 0.474 0 0 setrgbcolor
fill
grestore
gsave
0.59531 0.72371 moveto 0.58817 0.72516 lineto 0.58784 0.72498 lineto 0.474 0 0 setrgbcolor
fill
grestore
gsave
0.62119 0.7193 moveto 0.59868 0.72525 lineto 0.59531 0.72371 lineto 0.474 0 0 setrgbcolor
fill
grestore
gsave
0.6302 0.71996 moveto 0.61298 0.72645 lineto 0.50477 0.71354 lineto 0.336 0 0 setrgbcolor
fill
grestore
gsave
0.6119 0.72686 moveto 0.60585 0.72611 lineto 0.61298 0.72645 lineto 0.336 0 0 setrgbcolor
fill
grestore
gsave
0.50477 0.71354 moveto 0.61298 0.72645 lineto 0.60585 0.72611 lineto 0.336 0 0 setrgbcolor
fill
grestore
gsave
0.62967 0.72728 moveto 0.62175 0.72688 lineto 0.6297 0.72727 lineto 0.066 0 0 setrgbcolor
fill
grestore
gsave
0.59048 0.72639 moveto 0.57896 0.72466 lineto 0.58817 0.72516 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.6119 0.72686 moveto 0.59048 0.72639 lineto 0.58511 0.72353 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.58688 0.72515 moveto 0.58817 0.72516 lineto 0.60183 0.72589 lineto 0.066 0 0 setrgbcolor
fill
grestore
gsave
0.58511 0.72353 moveto 0.58817 0.72516 lineto 0.50477 0.71354 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.50477 0.71354 moveto 0.58817 0.72516 lineto 0.57896 0.72466 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.58688 0.72515 moveto 0.58784 0.72498 lineto 0.58817 0.72516 lineto 0.474 0 0 setrgbcolor
fill
grestore
gsave
0.53922 0.70608 moveto 0.56545 0.71009 lineto 0.55321 0.71602 lineto 0.576 0.215 0.319 setrgbcolor
fill
grestore
gsave
0.6302 0.71996 moveto 0.58165 0.71748 lineto 0.56545 0.71009 lineto 0.576 0.215 0.319 setrgbcolor
fill
grestore
gsave
0.55321 0.71602 moveto 0.56545 0.71009 lineto 0.58165 0.71748 lineto 0.576 0.215 0.319 setrgbcolor
fill
grestore
gsave
0.51637 0.71414 moveto 0.53922 0.70608 lineto 0.55321 0.71602 lineto 0.576 0.215 0.319 setrgbcolor
fill
grestore
gsave
0.51933 0.71794 moveto 0.51505 0.71825 lineto 0.51897 0.71748 lineto 0.68 0.223 0.16 setrgbcolor
fill
grestore
gsave
0.51897 0.71748 moveto 0.51505 0.71825 lineto 0.51505 0.71825 lineto 0.68 0.223 0.16 setrgbcolor
fill
grestore
gsave
0.48903 0.71282 moveto 0.51505 0.71825 lineto 0.51501 0.71825 lineto 0.321 0 0 setrgbcolor
fill
grestore
gsave
0.50477 0.71354 moveto 0.59049 0.72639 lineto 0.50155 0.7168 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.54809 0.72225 moveto 0.55114 0.72213 lineto 0.58688 0.72515 lineto 0.158 0 0 setrgbcolor
fill
grestore
gsave
0.58688 0.72515 moveto 0.55114 0.72213 lineto 0.58784 0.72498 lineto 0.158 0 0 setrgbcolor
fill
grestore
gsave
0.51505 0.71825 moveto 0.55057 0.72209 lineto 0.51544 0.71935 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.55116 0.72215 moveto 0.51544 0.71935 lineto 0.55057 0.72209 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.54809 0.72225 moveto 0.55078 0.72177 lineto 0.55114 0.72213 lineto 0.622 0.089 0 setrgbcolor
fill
grestore
gsave
0.49417 0.72429 moveto 0.51505 0.71825 lineto 0.51738 0.7248 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.51504 0.71826 moveto 0.51505 0.71825 lineto 0.54809 0.72225 lineto 0.248 0 0 setrgbcolor
fill
grestore
gsave
0.54809 0.72225 moveto 0.51505 0.71825 lineto 0.55078 0.72177 lineto 0.248 0 0 setrgbcolor
fill
grestore
gsave
0.51505 0.71825 moveto 0.51505 0.71825 lineto 0.50155 0.7168 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.50155 0.7168 moveto 0.51505 0.71825 lineto 0.50144 0.71692 lineto 0.5 0.119 0.25 setrgbcolor
fill
grestore
gsave
0.51504 0.71826 moveto 0.51505 0.71825 lineto 0.51505 0.71825 lineto 0.68 0.223 0.16 setrgbcolor
fill
grestore
gsave
0.51504 0.71826 moveto 0.51501 0.71825 lineto 0.51505 0.71825 lineto 0.321 0 0 setrgbcolor
fill
grestore
gsave
0.50477 0.71354 moveto 0.51003 0.70598 lineto 0.51637 0.71414 lineto 0.576 0.215 0.319 setrgbcolor
fill
grestore
gsave
0.51276 0.70205 moveto 0.51637 0.71414 lineto 0.51003 0.70598 lineto 0.576 0.215 0.319 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47851 0.70381 moveto
0.55477 0.68545 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57801 0.69341 moveto
0.58287 0.69235 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49603 0.71129 moveto
0.50817 0.70865 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58868 0.69378 moveto
0.59575 0.70227 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48903 0.71282 moveto
0.49603 0.71129 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59575 0.70227 moveto
0.60731 0.71154 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52341 0.27254 moveto
0.56356 0.26728 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.44372 0.29949 moveto
0.48282 0.28341 lineto
stroke
grestore
gsave
0.21992 0.78388 moveto 0.33936 0.73827 lineto 0.33936 0.74871 lineto 0.508 0.151 0.296 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.33936 0.73827 moveto
0.34169 0.7258 lineto
stroke
grestore
gsave
0.85106 0.73802 moveto 0.73983 0.73278 lineto 0.86566 0.74008 lineto 0.02 0.589 0.77 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.86551 0.74124 moveto
0.87162 0.74186 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.83923 0.73855 moveto
0.86551 0.74124 lineto
stroke
grestore
gsave
0.85106 0.73802 moveto 0.73068 0.73538 lineto 0.73983 0.73278 lineto 0.272 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73983 0.73278 moveto
0.74598 0.72901 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48282 0.28341 moveto
0.52341 0.27254 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54809 0.72225 moveto
0.55078 0.72177 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60731 0.71154 moveto
0.61944 0.71832 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47084 0.70566 moveto
0.48903 0.71282 lineto
stroke
grestore
gsave
0.21992 0.78388 moveto 0.33936 0.74871 lineto 0.21874 0.79026 lineto 0.1 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.21992 0.78388 moveto
0.22855 0.77442 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.21992 0.78388 moveto
0.33936 0.73827 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.86566 0.74008 moveto
0.87162 0.74186 lineto
stroke
grestore
gsave
0.82807 0.73591 moveto 0.73068 0.73538 lineto 0.85106 0.73802 lineto 0.053 0.616 0.785 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8603 0.73977 moveto
0.86566 0.74008 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.8175 0.73729 moveto
0.8603 0.73977 lineto
stroke
grestore
gsave
0.82807 0.73591 moveto 0.71876 0.73683 lineto 0.73068 0.73538 lineto 0.105 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73068 0.73538 moveto
0.73983 0.73278 lineto
stroke
grestore
gsave
0.6408 0.70659 moveto 0.51808 0.68988 lineto 0.52076 0.67709 lineto 0.696 0.347 0.381 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52076 0.67709 moveto
0.52096 0.66372 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52786 0.70435 moveto
0.56495 0.69626 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52076 0.67709 moveto
0.58272 0.68942 lineto
stroke
grestore
gsave
0.21874 0.79026 moveto 0.33936 0.74871 lineto 0.34205 0.75703 lineto 0.518 0.121 0.227 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.33936 0.74871 moveto
0.33936 0.73827 lineto
stroke
grestore
gsave
0.79744 0.73393 moveto 0.71876 0.73683 lineto 0.82807 0.73591 lineto 0.083 0.639 0.802 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.84755 0.73794 moveto
0.85106 0.73802 lineto
stroke
grestore
gsave
0.79744 0.73393 moveto 0.70449 0.7371 lineto 0.71876 0.73683 lineto 0.038 0.608 0.728 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72128 0.73652 moveto
0.73068 0.73538 lineto
stroke
grestore
gsave
0.62967 0.72728 moveto 0.63692 0.7256 lineto 0.65387 0.73046 lineto 0.251 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6297 0.72727 moveto
0.63692 0.7256 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62641 0.72139 moveto
0.63692 0.7256 lineto
stroke
grestore
gsave
0.63981 0.71329 moveto 0.51808 0.68988 lineto 0.6408 0.70659 lineto 0.415 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60584 0.70183 moveto
0.6408 0.70659 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63368 0.69956 moveto
0.6408 0.70659 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56028 0.7093 moveto
0.58922 0.70356 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59252 0.71422 moveto
0.60731 0.71154 lineto
stroke
grestore
gsave
0.76041 0.73214 moveto 0.70449 0.7371 lineto 0.79744 0.73393 lineto 0.099 0.65 0.813 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77511 0.73636 moveto
0.84755 0.73794 lineto
stroke
grestore
gsave
0.76041 0.73214 moveto 0.68844 0.73616 lineto 0.70449 0.7371 lineto 0.105 0.652 0.828 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70449 0.7371 moveto
0.71876 0.73683 lineto
stroke
grestore
gsave
0.63981 0.71329 moveto 0.51276 0.70205 lineto 0.51808 0.68988 lineto 0.64 0.289 0.36 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51808 0.68988 moveto
0.52076 0.67709 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51808 0.68988 moveto
0.60584 0.70183 lineto
stroke
grestore
gsave
0.67436 0.72898 moveto 0.65387 0.73046 lineto 0.67131 0.73396 lineto 0 0.523 0.784 setrgbcolor
fill
grestore
gsave
0.62967 0.72728 moveto 0.65387 0.73046 lineto 0.67436 0.72898 lineto 0.012 0.585 0.746 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63692 0.7256 moveto
0.64478 0.72785 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62967 0.72728 moveto
0.6297 0.72727 lineto
stroke
grestore
gsave
0.22569 0.79364 moveto 0.34205 0.75703 lineto 0.34766 0.76319 lineto 0.5 0.053 0.12 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32524 0.75357 moveto
0.33936 0.74871 lineto
stroke
grestore
gsave
0.21874 0.79026 moveto 0.34205 0.75703 lineto 0.22569 0.79364 lineto 0.092 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.21874 0.79026 moveto
0.32524 0.75357 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.33936 0.74871 moveto
0.34205 0.75703 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.21874 0.79026 moveto
0.21992 0.78388 lineto
stroke
grestore
gsave
0.7187 0.73053 moveto 0.68844 0.73616 lineto 0.76041 0.73214 lineto 0.095 0.647 0.812 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77053 0.73484 moveto
0.79744 0.73393 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71876 0.73683 moveto
0.82807 0.73591 lineto
stroke
grestore
gsave
0.7187 0.73053 moveto 0.67131 0.73396 lineto 0.68844 0.73616 lineto 0.077 0.621 0.846 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70449 0.7371 moveto
0.77053 0.73484 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68844 0.73616 moveto
0.70449 0.7371 lineto
stroke
grestore
gsave
0.67436 0.72898 moveto 0.67131 0.73396 lineto 0.7187 0.73053 lineto 0.066 0.626 0.792 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67131 0.73396 moveto
0.70278 0.73168 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70278 0.73168 moveto
0.7187 0.73053 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67131 0.73396 moveto
0.68844 0.73616 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65387 0.73046 moveto
0.67131 0.73396 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68844 0.73616 moveto
0.75199 0.73261 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75199 0.73261 moveto
0.76041 0.73214 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65387 0.73046 moveto
0.67436 0.72898 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48903 0.71282 moveto
0.50267 0.71567 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.85106 0.73802 moveto
0.86566 0.74008 lineto
stroke
grestore
gsave
0.6302 0.71996 moveto 0.51276 0.70205 lineto 0.63981 0.71329 lineto 0.385 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51276 0.70205 moveto
0.54284 0.70471 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54284 0.70471 moveto
0.63981 0.71329 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51501 0.71825 moveto
0.51504 0.71826 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51276 0.70205 moveto
0.51808 0.68988 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.63981 0.71329 moveto
0.6408 0.70659 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51504 0.71826 moveto
0.51505 0.71825 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50477 0.71354 moveto
0.51276 0.70205 lineto
stroke
grestore
gsave
0.24106 0.79422 moveto 0.34766 0.76319 lineto 0.35622 0.76718 lineto 0.44 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32582 0.76214 moveto
0.34205 0.75703 lineto
stroke
grestore
gsave
0.22569 0.79364 moveto 0.34766 0.76319 lineto 0.24106 0.79422 lineto 0.064 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34205 0.75703 moveto
0.34766 0.76319 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.21874 0.79026 moveto
0.22569 0.79364 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22569 0.79364 moveto
0.23451 0.79087 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58165 0.71748 moveto
0.6302 0.71996 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55321 0.71602 moveto
0.58165 0.71748 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51637 0.71414 moveto
0.55321 0.71602 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50477 0.71354 moveto
0.51637 0.71414 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50155 0.7168 moveto
0.50477 0.71354 lineto
stroke
grestore
gsave
0.26471 0.79227 moveto 0.35622 0.76718 lineto 0.3676 0.76906 lineto 0.323 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32875 0.76869 moveto
0.34766 0.76319 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31065 0.76691 moveto
0.32582 0.76214 lineto
stroke
grestore
gsave
0.24106 0.79422 moveto 0.35622 0.76718 lineto 0.26471 0.79227 lineto 0.026 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34766 0.76319 moveto
0.35622 0.76718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24106 0.79422 moveto
0.24952 0.79176 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.6302 0.71996 moveto
0.63981 0.71329 lineto
stroke
grestore
gsave
0.58531 0.73415 moveto 0.49417 0.72429 lineto 0.6119 0.72686 lineto 0.272 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59048 0.72639 moveto
0.6119 0.72686 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58688 0.72515 moveto
0.58784 0.72498 lineto
stroke
grestore
gsave
0.58531 0.73415 moveto 0.48117 0.73421 lineto 0.49417 0.72429 lineto 0.401 0 0.142 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49417 0.72429 moveto
0.50155 0.7168 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49417 0.72429 moveto
0.59048 0.72639 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51504 0.71826 moveto
0.54809 0.72225 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.82807 0.73591 moveto
0.85106 0.73802 lineto
stroke
grestore
gsave
0.296 0.78813 moveto 0.3676 0.76906 lineto 0.38145 0.76892 lineto 0.158 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30791 0.77476 moveto
0.32875 0.76869 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28496 0.77499 moveto
0.31065 0.76691 lineto
stroke
grestore
gsave
0.26471 0.79227 moveto 0.3676 0.76906 lineto 0.296 0.78813 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23451 0.79087 moveto
0.28496 0.77499 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33272 0.77362 moveto
0.35622 0.76718 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35622 0.76718 moveto
0.3676 0.76906 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26471 0.79227 moveto
0.27289 0.79003 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.22569 0.79364 moveto
0.24106 0.79422 lineto
stroke
grestore
gsave
0.55135 0.74191 moveto 0.48117 0.73421 lineto 0.58531 0.73415 lineto 0.198 0 0 setrgbcolor
fill
grestore
gsave
0.55135 0.74191 moveto 0.46613 0.7432 lineto 0.48117 0.73421 lineto 0.272 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48117 0.73421 moveto
0.49417 0.72429 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48117 0.73421 moveto
0.58531 0.73415 lineto
stroke
grestore
gsave
0.33376 0.78223 moveto 0.38145 0.76892 lineto 0.39725 0.76689 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.296 0.78813 moveto 0.38145 0.76892 lineto 0.33376 0.78223 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30305 0.78625 moveto
0.32944 0.77922 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3676 0.76906 moveto
0.38145 0.76892 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3013 0.78672 moveto
0.30305 0.78625 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.296 0.78813 moveto
0.3013 0.78672 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27289 0.79003 moveto
0.33272 0.77362 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24952 0.79176 moveto
0.30791 0.77476 lineto
stroke
grestore
gsave
0.51145 0.75009 moveto 0.46613 0.7432 lineto 0.55135 0.74191 lineto 0.121 0 0 setrgbcolor
fill
grestore
gsave
0.51145 0.75009 moveto 0.44954 0.75112 lineto 0.46613 0.7432 lineto 0.118 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46613 0.7432 moveto
0.48117 0.73421 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46613 0.7432 moveto
0.55135 0.74191 lineto
stroke
grestore
gsave
0.37633 0.77502 moveto 0.39725 0.76689 lineto 0.41437 0.76313 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.33376 0.78223 moveto 0.39725 0.76689 lineto 0.37633 0.77502 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.38145 0.76892 moveto
0.39725 0.76689 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33793 0.78106 moveto
0.33929 0.78069 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33376 0.78223 moveto
0.33793 0.78106 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32944 0.77922 moveto
0.3676 0.76906 lineto
stroke
grestore
gsave
0.46749 0.75854 moveto 0.44954 0.75112 lineto 0.51145 0.75009 lineto 0.049 0 0 setrgbcolor
fill
grestore
gsave
0.46749 0.75854 moveto 0.43205 0.75782 lineto 0.44954 0.75112 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44954 0.75112 moveto
0.46613 0.7432 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44954 0.75112 moveto
0.51145 0.75009 lineto
stroke
grestore
gsave
0.42167 0.76698 moveto 0.41437 0.76313 lineto 0.43205 0.75782 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.37633 0.77502 moveto 0.41437 0.76313 lineto 0.42167 0.76698 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39725 0.76689 moveto
0.41437 0.76313 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38072 0.77332 moveto
0.39725 0.76689 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37633 0.77502 moveto
0.38072 0.77332 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33929 0.78069 moveto
0.38145 0.76892 lineto
stroke
grestore
gsave
0.42167 0.76698 moveto 0.43205 0.75782 lineto 0.46749 0.75854 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43205 0.75782 moveto
0.46749 0.75854 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41437 0.76313 moveto
0.43205 0.75782 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41437 0.76313 moveto
0.42167 0.76698 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43205 0.75782 moveto
0.44954 0.75112 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61969 0.72392 moveto
0.6302 0.71996 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61298 0.72645 moveto
0.61969 0.72392 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61192 0.72685 moveto
0.61298 0.72645 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.6119 0.72686 moveto
0.61192 0.72685 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54809 0.72225 moveto
0.58688 0.72515 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.79744 0.73393 moveto
0.82807 0.73591 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.24106 0.79422 moveto
0.26471 0.79227 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.58688 0.72515 moveto
0.60183 0.72589 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.62175 0.72688 moveto
0.62967 0.72728 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.613 0.72645 moveto
0.62175 0.72688 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.76041 0.73214 moveto
0.79744 0.73393 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.58531 0.73415 moveto
0.6119 0.72686 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.62967 0.72728 moveto
0.67436 0.72898 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7187 0.73053 moveto
0.76041 0.73214 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.67436 0.72898 moveto
0.7187 0.73053 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.26471 0.79227 moveto
0.296 0.78813 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55135 0.74191 moveto
0.58531 0.73415 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.296 0.78813 moveto
0.33376 0.78223 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51145 0.75009 moveto
0.55135 0.74191 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33376 0.78223 moveto
0.37633 0.77502 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46749 0.75854 moveto
0.51145 0.75009 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37633 0.77502 moveto
0.42167 0.76698 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42167 0.76698 moveto
0.46749 0.75854 lineto
stroke
grestore
gsave
0.002 setlinewidth
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
grestore
gsave
grestore
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; endGroup; nowordwrap; ]
No Input Form was saved for this expression.













;[o]
-Graphics3D-
:[font = subsubsection; inactive; startGroup; ]
Reversing Helix: Kappa periodic, Tau constant.
:[font = input; startGroup; nowordwrap; ]
clear;top=80;kappa[s_]:=10 Sin[s];tau[s_]:=3.0;ds:=0.1;
width=.5;pribbonfrenet
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 278; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.08079 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0260524 1.10184 0.0275459 1.10184 [
[ 0 0 0 0 ]
[ 1 1.08079 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 1.08079 lineto
0 1.08079 lineto
closepath
clip
newpath
gsave
0.002 setlinewidth
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
0.42251 0.57709 moveto
0.11113 0.25957 lineto
stroke
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
0.42251 0.57709 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
grestore
gsave
0.72211 0.38411 moveto 0.73396 0.4795 lineto 0.68313 0.48384 lineto 0.679 0.753 0.907 setrgbcolor
fill
grestore
gsave
0.72104 0.36921 moveto 0.73396 0.4795 lineto 0.72211 0.38411 lineto 0.764 0.572 0 setrgbcolor
fill
grestore
gsave
0.72211 0.38411 moveto 0.68313 0.48384 lineto 0.72453 0.40099 lineto 0.025 0.014 0.504 setrgbcolor
fill
grestore
gsave
0.72453 0.40099 moveto 0.68313 0.48384 lineto 0.63698 0.47314 lineto 0.62 0.739 0.931 setrgbcolor
fill
grestore
gsave
0.72104 0.36921 moveto 0.78452 0.46006 lineto 0.73396 0.4795 lineto 0.721 0.746 0.871 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68313 0.48384 moveto
0.73396 0.4795 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73396 0.4795 moveto
0.78452 0.46006 lineto
stroke
grestore
gsave
0.72453 0.40099 moveto 0.63698 0.47314 lineto 0.72741 0.42159 lineto 0.394 0.324 0.659 setrgbcolor
fill
grestore
gsave
0.72741 0.42159 moveto 0.63698 0.47314 lineto 0.60257 0.44932 lineto 0.554 0.705 0.94 setrgbcolor
fill
grestore
gsave
0.72741 0.42159 moveto 0.60257 0.44932 lineto 0.72765 0.44627 lineto 0.538 0.47 0.727 setrgbcolor
fill
grestore
gsave
0.72765 0.44627 moveto 0.60257 0.44932 lineto 0.58912 0.41889 lineto 0.491 0.658 0.935 setrgbcolor
fill
grestore
gsave
0.72765 0.44627 moveto 0.58912 0.41889 lineto 0.72093 0.4729 lineto 0.605 0.56 0.778 setrgbcolor
fill
grestore
gsave
0.72093 0.4729 moveto 0.58912 0.41889 lineto 0.60453 0.395 lineto 0.439 0.606 0.917 setrgbcolor
fill
grestore
gsave
0.72093 0.4729 moveto 0.60857 0.3977 lineto 0.70385 0.49667 lineto 0.634 0.626 0.825 setrgbcolor
fill
grestore
gsave
0.70385 0.49667 moveto 0.60857 0.3977 lineto 0.61109 0.40171 lineto 0.634 0.626 0.825 setrgbcolor
fill
grestore
gsave
0.70385 0.49667 moveto 0.61109 0.40171 lineto 0.6475 0.39542 lineto 0.408 0.556 0.89 setrgbcolor
fill
grestore
gsave
0.60453 0.395 moveto 0.61109 0.40171 lineto 0.60857 0.3977 lineto 0.634 0.626 0.825 setrgbcolor
fill
grestore
gsave
0.60453 0.395 moveto 0.6475 0.39542 lineto 0.61109 0.40171 lineto 0.408 0.556 0.89 setrgbcolor
fill
grestore
gsave
0.70385 0.49667 moveto 0.65382 0.40678 lineto 0.67639 0.51158 lineto 0.632 0.677 0.874 setrgbcolor
fill
grestore
gsave
0.6475 0.39542 moveto 0.65188 0.41304 lineto 0.65382 0.40678 lineto 0.632 0.677 0.874 setrgbcolor
fill
grestore
gsave
0.65382 0.40678 moveto 0.65211 0.41232 lineto 0.67639 0.51158 lineto 0.632 0.677 0.874 setrgbcolor
fill
grestore
gsave
0.67639 0.51158 moveto 0.65211 0.41232 lineto 0.65205 0.41372 lineto 0.632 0.677 0.874 setrgbcolor
fill
grestore
gsave
0.65188 0.41304 moveto 0.65205 0.41372 lineto 0.65211 0.41232 lineto 0.632 0.677 0.874 setrgbcolor
fill
grestore
gsave
0.69917 0.43218 moveto 0.67756 0.50749 lineto 0.6475 0.39542 lineto 0.409 0.519 0.859 setrgbcolor
fill
grestore
gsave
0.67639 0.51158 moveto 0.67393 0.50171 lineto 0.67756 0.50749 lineto 0.409 0.519 0.859 setrgbcolor
fill
grestore
gsave
0.6475 0.39542 moveto 0.67756 0.50749 lineto 0.67393 0.50171 lineto 0.409 0.519 0.859 setrgbcolor
fill
grestore
gsave
0.67639 0.51158 moveto 0.69609 0.4429 lineto 0.64328 0.51332 lineto 0.584 0.706 0.927 setrgbcolor
fill
grestore
gsave
0.69917 0.43218 moveto 0.68626 0.45091 lineto 0.69609 0.4429 lineto 0.584 0.706 0.927 setrgbcolor
fill
grestore
gsave
0.64328 0.51332 moveto 0.69609 0.4429 lineto 0.68626 0.45091 lineto 0.584 0.706 0.927 setrgbcolor
fill
grestore
gsave
0.72679 0.4967 moveto 0.64809 0.51236 lineto 0.69917 0.43218 lineto 0.442 0.509 0.832 setrgbcolor
fill
grestore
gsave
0.64328 0.51332 moveto 0.64835 0.50596 lineto 0.64809 0.51236 lineto 0.442 0.509 0.832 setrgbcolor
fill
grestore
gsave
0.69917 0.43218 moveto 0.64809 0.51236 lineto 0.64835 0.50596 lineto 0.442 0.509 0.832 setrgbcolor
fill
grestore
gsave
0.62712 0.50724 moveto 0.69572 0.49999 lineto 0.61318 0.50199 lineto 0.436 0.671 0.962 setrgbcolor
fill
grestore
gsave
0.64328 0.51332 moveto 0.69572 0.49999 lineto 0.62712 0.50724 lineto 0.436 0.671 0.962 setrgbcolor
fill
grestore
gsave
0.64328 0.51332 moveto 0.71231 0.49959 lineto 0.69572 0.49999 lineto 0.436 0.671 0.962 setrgbcolor
fill
grestore
gsave
0.72679 0.4967 moveto 0.69455 0.4982 lineto 0.71231 0.49959 lineto 0.436 0.671 0.962 setrgbcolor
fill
grestore
gsave
0.61318 0.50199 moveto 0.71231 0.49959 lineto 0.69455 0.4982 lineto 0.436 0.671 0.962 setrgbcolor
fill
grestore
gsave
0.70599 0.55848 moveto 0.62259 0.50772 lineto 0.72679 0.4967 lineto 0.491 0.526 0.82 setrgbcolor
fill
grestore
gsave
0.61916 0.50563 moveto 0.62334 0.50528 lineto 0.62259 0.50772 lineto 0.491 0.526 0.82 setrgbcolor
fill
grestore
gsave
0.72679 0.4967 moveto 0.62259 0.50772 lineto 0.62334 0.50528 lineto 0.491 0.526 0.82 setrgbcolor
fill
grestore
gsave
0.61318 0.50199 moveto 0.62426 0.50147 lineto 0.61916 0.50563 lineto 0.491 0.526 0.82 setrgbcolor
fill
grestore
gsave
0.72679 0.4967 moveto 0.61916 0.50563 lineto 0.62426 0.50147 lineto 0.491 0.526 0.82 setrgbcolor
fill
grestore
gsave
0.61318 0.50199 moveto 0.68077 0.54313 lineto 0.5955 0.48347 lineto 0.147 0.469 0.892 setrgbcolor
fill
grestore
gsave
0.5955 0.48347 moveto 0.68077 0.54313 lineto 0.67715 0.5401 lineto 0.147 0.469 0.892 setrgbcolor
fill
grestore
gsave
0.68076 0.54135 moveto 0.66958 0.53377 lineto 0.68689 0.54686 lineto 0.147 0.469 0.892 setrgbcolor
fill
grestore
gsave
0.5955 0.48347 moveto 0.67715 0.5401 lineto 0.66958 0.53377 lineto 0.147 0.469 0.892 setrgbcolor
fill
grestore
gsave
0.68689 0.54686 moveto 0.66958 0.53377 lineto 0.67715 0.5401 lineto 0.147 0.469 0.892 setrgbcolor
fill
grestore
gsave
0.68689 0.54686 moveto 0.67715 0.5401 lineto 0.68077 0.54313 lineto 0.147 0.469 0.892 setrgbcolor
fill
grestore
gsave
0.70599 0.55848 moveto 0.68076 0.54135 lineto 0.68689 0.54686 lineto 0.147 0.469 0.892 setrgbcolor
fill
grestore
gsave
0.64095 0.58537 moveto 0.59875 0.49075 lineto 0.70599 0.55848 lineto 0.536 0.558 0.825 setrgbcolor
fill
grestore
gsave
0.5955 0.48347 moveto 0.6072 0.49141 lineto 0.59875 0.49075 lineto 0.536 0.558 0.825 setrgbcolor
fill
grestore
gsave
0.70599 0.55848 moveto 0.59875 0.49075 lineto 0.6072 0.49141 lineto 0.536 0.558 0.825 setrgbcolor
fill
grestore
gsave
0.5955 0.48347 moveto 0.62739 0.55497 lineto 0.59573 0.46819 lineto 0.084 0.275 0.76 setrgbcolor
fill
grestore
gsave
0.59573 0.46819 moveto 0.62739 0.55497 lineto 0.62653 0.55109 lineto 0.084 0.275 0.76 setrgbcolor
fill
grestore
gsave
0.59573 0.46819 moveto 0.6301 0.56069 lineto 0.62551 0.54537 lineto 0.084 0.275 0.76 setrgbcolor
fill
grestore
gsave
0.6309 0.56283 moveto 0.62998 0.55986 lineto 0.6301 0.56069 lineto 0.084 0.275 0.76 setrgbcolor
fill
grestore
gsave
0.62551 0.54537 moveto 0.6301 0.56069 lineto 0.62998 0.55986 lineto 0.084 0.275 0.76 setrgbcolor
fill
grestore
gsave
0.6309 0.56283 moveto 0.62653 0.55109 lineto 0.62739 0.55497 lineto 0.084 0.275 0.76 setrgbcolor
fill
grestore
gsave
0.64095 0.58537 moveto 0.62551 0.54537 lineto 0.6309 0.56283 lineto 0.084 0.275 0.76 setrgbcolor
fill
grestore
gsave
0.59573 0.46819 moveto 0.64095 0.58537 lineto 0.5609 0.56444 lineto 0.563 0.593 0.842 setrgbcolor
fill
grestore
gsave
0.59573 0.46819 moveto 0.57206 0.53362 lineto 0.61081 0.46659 lineto 0.359 0.368 0.733 setrgbcolor
fill
grestore
gsave
0.5609 0.56444 moveto 0.57961 0.52777 lineto 0.57206 0.53362 lineto 0.359 0.368 0.733 setrgbcolor
fill
grestore
gsave
0.61081 0.46659 moveto 0.57206 0.53362 lineto 0.57961 0.52777 lineto 0.359 0.368 0.733 setrgbcolor
fill
grestore
gsave
0.5609 0.56444 moveto 0.5998 0.47533 lineto 0.60439 0.47917 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.59567 0.47226 moveto 0.59566 0.47301 lineto 0.5609 0.56444 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.50319 0.50688 moveto 0.59567 0.47226 lineto 0.5609 0.56444 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.5609 0.56444 moveto 0.59599 0.47214 lineto 0.5998 0.47533 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.60484 0.4783 moveto 0.60439 0.47917 lineto 0.60222 0.46981 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.60222 0.46981 moveto 0.60439 0.47917 lineto 0.5998 0.47533 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.59567 0.47226 moveto 0.59599 0.47214 lineto 0.59566 0.47301 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.60222 0.46981 moveto 0.5998 0.47533 lineto 0.59599 0.47214 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.61081 0.46659 moveto 0.60484 0.4783 lineto 0.60222 0.46981 lineto 0.568 0.621 0.866 setrgbcolor
fill
grestore
gsave
0.61081 0.46659 moveto 0.5401 0.49306 lineto 0.62843 0.48223 lineto 0.535 0.5 0.764 setrgbcolor
fill
grestore
gsave
0.53436 0.49521 moveto 0.54312 0.494 lineto 0.5401 0.49306 lineto 0.535 0.5 0.764 setrgbcolor
fill
grestore
gsave
0.62843 0.48223 moveto 0.5401 0.49306 lineto 0.54312 0.494 lineto 0.535 0.5 0.764 setrgbcolor
fill
grestore
gsave
0.62843 0.48223 moveto 0.53436 0.49521 lineto 0.53701 0.49667 lineto 0.535 0.5 0.764 setrgbcolor
fill
grestore
gsave
0.62843 0.48223 moveto 0.52571 0.49845 lineto 0.5275 0.5021 lineto 0.535 0.5 0.764 setrgbcolor
fill
grestore
gsave
0.61202 0.48546 moveto 0.55302 0.49707 lineto 0.60918 0.47709 lineto 0.544 0.633 0.89 setrgbcolor
fill
grestore
gsave
0.50319 0.50688 moveto 0.5275 0.5021 lineto 0.52571 0.49845 lineto 0.535 0.5 0.764 setrgbcolor
fill
grestore
gsave
0.50319 0.50688 moveto 0.55134 0.49335 lineto 0.55302 0.49707 lineto 0.544 0.633 0.89 setrgbcolor
fill
grestore
gsave
0.60918 0.47709 moveto 0.55302 0.49707 lineto 0.55134 0.49335 lineto 0.544 0.633 0.89 setrgbcolor
fill
grestore
gsave
0.52571 0.49845 moveto 0.53701 0.49667 lineto 0.53436 0.49521 lineto 0.535 0.5 0.764 setrgbcolor
fill
grestore
gsave
0.49774 0.44372 moveto 0.61011 0.47683 lineto 0.50319 0.50688 lineto 0.544 0.633 0.89 setrgbcolor
fill
grestore
gsave
0.61011 0.47683 moveto 0.61041 0.47819 lineto 0.60918 0.47709 lineto 0.544 0.633 0.89 setrgbcolor
fill
grestore
gsave
0.61202 0.48546 moveto 0.60918 0.47709 lineto 0.61041 0.47819 lineto 0.544 0.633 0.89 setrgbcolor
fill
grestore
gsave
0.62843 0.48223 moveto 0.61202 0.48546 lineto 0.61011 0.47683 lineto 0.544 0.633 0.89 setrgbcolor
fill
grestore
gsave
0.62843 0.48223 moveto 0.54585 0.4579 lineto 0.63357 0.50775 lineto 0.608 0.594 0.812 setrgbcolor
fill
grestore
gsave
0.49774 0.44372 moveto 0.55534 0.47087 lineto 0.54585 0.4579 lineto 0.608 0.594 0.812 setrgbcolor
fill
grestore
gsave
0.63357 0.50775 moveto 0.54585 0.4579 lineto 0.55534 0.47087 lineto 0.608 0.594 0.812 setrgbcolor
fill
grestore
gsave
0.6207 0.49593 moveto 0.55678 0.46879 lineto 0.62029 0.49312 lineto 0.49 0.614 0.902 setrgbcolor
fill
grestore
gsave
0.49774 0.44372 moveto 0.55747 0.46779 lineto 0.55678 0.46879 lineto 0.49 0.614 0.902 setrgbcolor
fill
grestore
gsave
0.62029 0.49312 moveto 0.55678 0.46879 lineto 0.55747 0.46779 lineto 0.49 0.614 0.902 setrgbcolor
fill
grestore
gsave
0.6216 0.50211 moveto 0.61608 0.49951 lineto 0.6207 0.49593 lineto 0.49 0.614 0.902 setrgbcolor
fill
grestore
gsave
0.49774 0.44372 moveto 0.6207 0.49593 lineto 0.61608 0.49951 lineto 0.49 0.614 0.902 setrgbcolor
fill
grestore
gsave
0.55011 0.41578 moveto 0.62029 0.49312 lineto 0.49774 0.44372 lineto 0.49 0.614 0.902 setrgbcolor
fill
grestore
gsave
0.63357 0.50775 moveto 0.6216 0.50211 lineto 0.62029 0.49312 lineto 0.49 0.614 0.902 setrgbcolor
fill
grestore
gsave
0.63357 0.50775 moveto 0.58284 0.45185 lineto 0.61892 0.52898 lineto 0.623 0.661 0.866 setrgbcolor
fill
grestore
gsave
0.55011 0.41578 moveto 0.58095 0.46651 lineto 0.58284 0.45185 lineto 0.623 0.661 0.866 setrgbcolor
fill
grestore
gsave
0.61892 0.52898 moveto 0.58284 0.45185 lineto 0.58095 0.46651 lineto 0.623 0.661 0.866 setrgbcolor
fill
grestore
gsave
0.61991 0.51784 moveto 0.58273 0.46347 lineto 0.62612 0.44829 lineto 0.43 0.564 0.887 setrgbcolor
fill
grestore
gsave
0.55011 0.41578 moveto 0.62612 0.44829 lineto 0.58273 0.46347 lineto 0.43 0.564 0.887 setrgbcolor
fill
grestore
gsave
0.55011 0.41578 moveto 0.61991 0.51784 lineto 0.61034 0.51487 lineto 0.43 0.564 0.887 setrgbcolor
fill
grestore
gsave
0.61892 0.52898 moveto 0.61034 0.51487 lineto 0.61991 0.51784 lineto 0.43 0.564 0.887 setrgbcolor
fill
grestore
gsave
0.61892 0.52898 moveto 0.62612 0.44829 lineto 0.58985 0.53472 lineto 0.576 0.698 0.925 setrgbcolor
fill
grestore
gsave
0.6027 0.53271 moveto 0.59915 0.53076 lineto 0.62612 0.44829 lineto 0.419 0.517 0.851 setrgbcolor
fill
grestore
gsave
0.59294 0.52735 moveto 0.59429 0.52413 lineto 0.59915 0.53076 lineto 0.419 0.517 0.851 setrgbcolor
fill
grestore
gsave
0.62612 0.44829 moveto 0.59915 0.53076 lineto 0.59429 0.52413 lineto 0.419 0.517 0.851 setrgbcolor
fill
grestore
gsave
0.66837 0.52242 moveto 0.6027 0.53271 lineto 0.62612 0.44829 lineto 0.419 0.517 0.851 setrgbcolor
fill
grestore
gsave
0.58985 0.53472 moveto 0.59294 0.52735 lineto 0.6027 0.53271 lineto 0.419 0.517 0.851 setrgbcolor
fill
grestore
gsave
0.58985 0.53472 moveto 0.64418 0.52621 lineto 0.56012 0.52361 lineto 0.403 0.654 0.96 setrgbcolor
fill
grestore
gsave
0.66837 0.52242 moveto 0.62057 0.52294 lineto 0.64418 0.52621 lineto 0.403 0.654 0.96 setrgbcolor
fill
grestore
gsave
0.56012 0.52361 moveto 0.64418 0.52621 lineto 0.62057 0.52294 lineto 0.403 0.654 0.96 setrgbcolor
fill
grestore
gsave
0.6463 0.58806 moveto 0.5724 0.53279 lineto 0.66837 0.52242 lineto 0.47 0.517 0.825 setrgbcolor
fill
grestore
gsave
0.56012 0.52361 moveto 0.5736 0.52346 lineto 0.5724 0.53279 lineto 0.47 0.517 0.825 setrgbcolor
fill
grestore
gsave
0.66837 0.52242 moveto 0.5724 0.53279 lineto 0.5736 0.52346 lineto 0.47 0.517 0.825 setrgbcolor
fill
grestore
gsave
0.56012 0.52361 moveto 0.61137 0.56194 lineto 0.54336 0.50411 lineto 0.073 0.406 0.859 setrgbcolor
fill
grestore
gsave
0.6463 0.58806 moveto 0.59977 0.55011 lineto 0.61137 0.56194 lineto 0.073 0.406 0.859 setrgbcolor
fill
grestore
gsave
0.54336 0.50411 moveto 0.61137 0.56194 lineto 0.59977 0.55011 lineto 0.073 0.406 0.859 setrgbcolor
fill
grestore
gsave
0.57685 0.60894 moveto 0.54609 0.51264 lineto 0.6463 0.58806 lineto 0.529 0.553 0.824 setrgbcolor
fill
grestore
gsave
0.54336 0.50411 moveto 0.5554 0.51393 lineto 0.54609 0.51264 lineto 0.529 0.553 0.824 setrgbcolor
fill
grestore
gsave
0.6463 0.58806 moveto 0.54609 0.51264 lineto 0.5554 0.51393 lineto 0.529 0.553 0.824 setrgbcolor
fill
grestore
gsave
0.54336 0.50411 moveto 0.56364 0.5676 lineto 0.54559 0.48951 lineto 0.081 0.242 0.731 setrgbcolor
fill
grestore
gsave
0.57092 0.5904 moveto 0.56329 0.55999 lineto 0.56364 0.5676 lineto 0.081 0.242 0.731 setrgbcolor
fill
grestore
gsave
0.54559 0.48951 moveto 0.56364 0.5676 lineto 0.56329 0.55999 lineto 0.081 0.242 0.731 setrgbcolor
fill
grestore
gsave
0.57321 0.59506 moveto 0.56456 0.56198 lineto 0.57092 0.5904 lineto 0.081 0.242 0.731 setrgbcolor
fill
grestore
gsave
0.54559 0.48951 moveto 0.56428 0.56395 lineto 0.56456 0.56198 lineto 0.081 0.242 0.731 setrgbcolor
fill
grestore
gsave
0.57092 0.5904 moveto 0.56456 0.56198 lineto 0.56428 0.56395 lineto 0.081 0.242 0.731 setrgbcolor
fill
grestore
gsave
0.57685 0.60894 moveto 0.57321 0.59506 lineto 0.57092 0.5904 lineto 0.081 0.242 0.731 setrgbcolor
fill
grestore
gsave
0.54559 0.48951 moveto 0.57685 0.60894 lineto 0.49901 0.58204 lineto 0.566 0.597 0.843 setrgbcolor
fill
grestore
gsave
0.54559 0.48951 moveto 0.51753 0.54526 lineto 0.56167 0.49038 lineto 0.382 0.375 0.727 setrgbcolor
fill
grestore
gsave
0.56167 0.49038 moveto 0.51753 0.54526 lineto 0.51784 0.54528 lineto 0.382 0.375 0.727 setrgbcolor
fill
grestore
gsave
0.56167 0.49038 moveto 0.51697 0.54636 lineto 0.52598 0.5426 lineto 0.382 0.375 0.727 setrgbcolor
fill
grestore
gsave
0.44709 0.5276 moveto 0.47799 0.51757 lineto 0.49901 0.58204 lineto 0.573 0.633 0.872 setrgbcolor
fill
grestore
gsave
0.54612 0.49543 moveto 0.52169 0.54036 lineto 0.47799 0.51757 lineto 0.573 0.633 0.872 setrgbcolor
fill
grestore
gsave
0.51697 0.54636 moveto 0.51784 0.54528 lineto 0.51753 0.54526 lineto 0.382 0.375 0.727 setrgbcolor
fill
grestore
gsave
0.49901 0.58204 moveto 0.52598 0.5426 lineto 0.51697 0.54636 lineto 0.382 0.375 0.727 setrgbcolor
fill
grestore
gsave
0.49901 0.58204 moveto 0.47799 0.51757 lineto 0.52169 0.54036 lineto 0.573 0.633 0.872 setrgbcolor
fill
grestore
gsave
0.56167 0.49038 moveto 0.55325 0.5027 lineto 0.54612 0.49543 lineto 0.573 0.633 0.872 setrgbcolor
fill
grestore
gsave
0.49901 0.58204 moveto 0.54612 0.49543 lineto 0.55325 0.5027 lineto 0.573 0.633 0.872 setrgbcolor
fill
grestore
gsave
0.56167 0.49038 moveto 0.49422 0.51229 lineto 0.57808 0.50801 lineto 0.546 0.507 0.764 setrgbcolor
fill
grestore
gsave
0.57808 0.50801 moveto 0.49422 0.51229 lineto 0.49499 0.51311 lineto 0.546 0.507 0.764 setrgbcolor
fill
grestore
gsave
0.57808 0.50801 moveto 0.49093 0.51336 lineto 0.50334 0.51919 lineto 0.546 0.507 0.764 setrgbcolor
fill
grestore
gsave
0.43897 0.47523 moveto 0.47603 0.48396 lineto 0.44709 0.5276 lineto 0.544 0.65 0.904 setrgbcolor
fill
grestore
gsave
0.5607 0.50391 moveto 0.50113 0.51634 lineto 0.47603 0.48396 lineto 0.544 0.65 0.904 setrgbcolor
fill
grestore
gsave
0.49093 0.51336 moveto 0.49499 0.51311 lineto 0.49422 0.51229 lineto 0.546 0.507 0.764 setrgbcolor
fill
grestore
gsave
0.44709 0.5276 moveto 0.50334 0.51919 lineto 0.49093 0.51336 lineto 0.546 0.507 0.764 setrgbcolor
fill
grestore
gsave
0.44709 0.5276 moveto 0.47603 0.48396 lineto 0.50113 0.51634 lineto 0.544 0.65 0.904 setrgbcolor
fill
grestore
gsave
0.44709 0.5276 moveto 0.5607 0.50391 lineto 0.56101 0.51056 lineto 0.544 0.65 0.904 setrgbcolor
fill
grestore
gsave
0.57808 0.50801 moveto 0.56101 0.51056 lineto 0.5607 0.50391 lineto 0.544 0.65 0.904 setrgbcolor
fill
grestore
gsave
0.57808 0.50801 moveto 0.49927 0.48944 lineto 0.58161 0.53386 lineto 0.614 0.597 0.81 setrgbcolor
fill
grestore
gsave
0.58161 0.53386 moveto 0.49927 0.48944 lineto 0.49957 0.49148 lineto 0.614 0.597 0.81 setrgbcolor
fill
grestore
gsave
0.58161 0.53386 moveto 0.49256 0.48786 lineto 0.501 0.50073 lineto 0.614 0.597 0.81 setrgbcolor
fill
grestore
gsave
0.47091 0.45152 moveto 0.50015 0.47327 lineto 0.43897 0.47523 lineto 0.462 0.63 0.926 setrgbcolor
fill
grestore
gsave
0.56911 0.52456 moveto 0.50094 0.49872 lineto 0.50015 0.47327 lineto 0.462 0.63 0.926 setrgbcolor
fill
grestore
gsave
0.49256 0.48786 moveto 0.49957 0.49148 lineto 0.49927 0.48944 lineto 0.614 0.597 0.81 setrgbcolor
fill
grestore
gsave
0.43897 0.47523 moveto 0.501 0.50073 lineto 0.49256 0.48786 lineto 0.614 0.597 0.81 setrgbcolor
fill
grestore
gsave
0.43897 0.47523 moveto 0.50015 0.47327 lineto 0.50094 0.49872 lineto 0.462 0.63 0.926 setrgbcolor
fill
grestore
gsave
0.43897 0.47523 moveto 0.56911 0.52456 lineto 0.56883 0.52468 lineto 0.462 0.63 0.926 setrgbcolor
fill
grestore
gsave
0.43897 0.47523 moveto 0.56974 0.52503 lineto 0.56922 0.52876 lineto 0.462 0.63 0.926 setrgbcolor
fill
grestore
gsave
0.56974 0.52503 moveto 0.56883 0.52468 lineto 0.56911 0.52456 lineto 0.462 0.63 0.926 setrgbcolor
fill
grestore
gsave
0.58161 0.53386 moveto 0.56922 0.52876 lineto 0.56974 0.52503 lineto 0.462 0.63 0.926 setrgbcolor
fill
grestore
gsave
0.58161 0.53386 moveto 0.51419 0.48371 lineto 0.56728 0.55597 lineto 0.633 0.663 0.861 setrgbcolor
fill
grestore
gsave
0.47091 0.45152 moveto 0.51357 0.49777 lineto 0.51419 0.48371 lineto 0.633 0.663 0.861 setrgbcolor
fill
grestore
gsave
0.56728 0.55597 moveto 0.51419 0.48371 lineto 0.51357 0.49777 lineto 0.633 0.663 0.861 setrgbcolor
fill
grestore
gsave
0.51923 0.46696 moveto 0.53174 0.49013 lineto 0.47091 0.45152 lineto 0.32 0.539 0.908 setrgbcolor
fill
grestore
gsave
0.56238 0.5469 moveto 0.51478 0.49726 lineto 0.53174 0.49013 lineto 0.32 0.539 0.908 setrgbcolor
fill
grestore
gsave
0.47091 0.45152 moveto 0.53174 0.49013 lineto 0.51478 0.49726 lineto 0.32 0.539 0.908 setrgbcolor
fill
grestore
gsave
0.47091 0.45152 moveto 0.56238 0.5469 lineto 0.56182 0.54663 lineto 0.32 0.539 0.908 setrgbcolor
fill
grestore
gsave
0.47091 0.45152 moveto 0.56278 0.54764 lineto 0.55943 0.54747 lineto 0.32 0.539 0.908 setrgbcolor
fill
grestore
gsave
0.56278 0.54764 moveto 0.56182 0.54663 lineto 0.56238 0.5469 lineto 0.32 0.539 0.908 setrgbcolor
fill
grestore
gsave
0.56728 0.55597 moveto 0.55943 0.54747 lineto 0.56278 0.54764 lineto 0.32 0.539 0.908 setrgbcolor
fill
grestore
gsave
0.56728 0.55597 moveto 0.53829 0.50226 lineto 0.53919 0.56635 lineto 0.61 0.712 0.917 setrgbcolor
fill
grestore
gsave
0.53919 0.56635 moveto 0.53829 0.50226 lineto 0.53337 0.50682 lineto 0.61 0.712 0.917 setrgbcolor
fill
grestore
gsave
0.53919 0.56635 moveto 0.53174 0.49013 lineto 0.52698 0.50551 lineto 0.61 0.712 0.917 setrgbcolor
fill
grestore
gsave
0.53174 0.49013 moveto 0.53337 0.50682 lineto 0.53829 0.50226 lineto 0.61 0.712 0.917 setrgbcolor
fill
grestore
gsave
0.54066 0.56118 moveto 0.52805 0.50571 lineto 0.55492 0.5108 lineto 0.197 0.39 0.828 setrgbcolor
fill
grestore
gsave
0.51923 0.46696 moveto 0.52698 0.50551 lineto 0.53174 0.49013 lineto 0.61 0.712 0.917 setrgbcolor
fill
grestore
gsave
0.51923 0.46696 moveto 0.55492 0.5108 lineto 0.52805 0.50571 lineto 0.197 0.39 0.828 setrgbcolor
fill
grestore
gsave
0.51923 0.46696 moveto 0.54066 0.56118 lineto 0.54024 0.56055 lineto 0.197 0.39 0.828 setrgbcolor
fill
grestore
gsave
0.51923 0.46696 moveto 0.54051 0.56172 lineto 0.53765 0.55867 lineto 0.197 0.39 0.828 setrgbcolor
fill
grestore
gsave
0.54051 0.56172 moveto 0.54024 0.56055 lineto 0.54066 0.56118 lineto 0.197 0.39 0.828 setrgbcolor
fill
grestore
gsave
0.53919 0.56635 moveto 0.53765 0.55867 lineto 0.54051 0.56172 lineto 0.197 0.39 0.828 setrgbcolor
fill
grestore
gsave
0.53919 0.56635 moveto 0.55492 0.5108 lineto 0.50591 0.56374 lineto 0.507 0.729 0.973 setrgbcolor
fill
grestore
gsave
0.51014 0.56357 moveto 0.50977 0.56104 lineto 0.55492 0.5108 lineto 0.246 0.317 0.74 setrgbcolor
fill
grestore
gsave
0.50958 0.55977 moveto 0.51045 0.55884 lineto 0.50977 0.56104 lineto 0.246 0.317 0.74 setrgbcolor
fill
grestore
gsave
0.55492 0.5108 moveto 0.50977 0.56104 lineto 0.51045 0.55884 lineto 0.246 0.317 0.74 setrgbcolor
fill
grestore
gsave
0.56148 0.56158 moveto 0.51068 0.56355 lineto 0.55492 0.5108 lineto 0.246 0.317 0.74 setrgbcolor
fill
grestore
gsave
0.51014 0.56357 moveto 0.51071 0.5629 lineto 0.51068 0.56355 lineto 0.246 0.317 0.74 setrgbcolor
fill
grestore
gsave
0.55492 0.5108 moveto 0.51068 0.56355 lineto 0.51071 0.5629 lineto 0.246 0.317 0.74 setrgbcolor
fill
grestore
gsave
0.50591 0.56374 moveto 0.50958 0.55977 lineto 0.51014 0.56357 lineto 0.246 0.317 0.74 setrgbcolor
fill
grestore
gsave
0.50591 0.56374 moveto 0.56148 0.56158 lineto 0.4753 0.55194 lineto 0.173 0.602 0.939 setrgbcolor
fill
grestore
gsave
0.53946 0.6026 moveto 0.4804 0.55597 lineto 0.56148 0.56158 lineto 0.411 0.371 0.704 setrgbcolor
fill
grestore
gsave
0.4753 0.55194 moveto 0.48373 0.55288 lineto 0.4804 0.55597 lineto 0.411 0.371 0.704 setrgbcolor
fill
grestore
gsave
0.56148 0.56158 moveto 0.4804 0.55597 lineto 0.48373 0.55288 lineto 0.411 0.371 0.704 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58185 0.52337 moveto
0.59721 0.49326 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64079 0.47402 moveto
0.66628 0.47993 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72104 0.36921 moveto
0.78452 0.46006 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65474 0.46302 moveto
0.66312 0.45824 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64696 0.46745 moveto
0.65474 0.46302 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63948 0.47172 moveto
0.64696 0.46745 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72746 0.4272 moveto
0.73396 0.4795 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52736 0.54057 moveto
0.53251 0.53305 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49901 0.58204 moveto
0.50406 0.57465 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48422 0.56653 moveto
0.49901 0.58204 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44709 0.5276 moveto
0.48422 0.56653 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49901 0.58204 moveto
0.52465 0.5909 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54244 0.59705 moveto
0.57685 0.60894 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5656 0.4946 moveto
0.59387 0.48903 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49774 0.44372 moveto
0.49919 0.46055 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62718 0.44872 moveto
0.65632 0.44801 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62638 0.44874 moveto
0.62718 0.44872 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58912 0.41889 moveto
0.59652 0.43563 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64822 0.58237 moveto
0.70599 0.55848 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56394 0.55962 moveto
0.57321 0.59506 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56336 0.55742 moveto
0.56394 0.55962 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57321 0.59506 moveto
0.57685 0.60894 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57685 0.60894 moveto
0.6463 0.58806 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4515 0.52694 moveto
0.49878 0.51987 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49878 0.51987 moveto
0.50334 0.51919 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50334 0.51919 moveto
0.52895 0.51536 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44709 0.5276 moveto
0.4515 0.52694 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68607 0.45119 moveto
0.69917 0.43218 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65417 0.4975 moveto
0.68607 0.45119 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69455 0.4982 moveto
0.72679 0.4967 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69359 0.49825 moveto
0.69455 0.4982 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6556 0.50001 moveto
0.69359 0.49825 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6475 0.39542 moveto
0.65205 0.41372 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65205 0.41372 moveto
0.66792 0.47754 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62057 0.52294 moveto
0.6499 0.52262 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61831 0.52297 moveto
0.62057 0.52294 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58018 0.52339 moveto
0.61831 0.52297 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6499 0.52262 moveto
0.66837 0.52242 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60081 0.42368 moveto
0.65374 0.44537 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58912 0.41889 moveto
0.60081 0.42368 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58912 0.41889 moveto
0.60453 0.395 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67081 0.5346 moveto
0.70599 0.55848 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66549 0.53099 moveto
0.67081 0.5346 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61004 0.4866 moveto
0.6194 0.46431 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60935 0.48825 moveto
0.61004 0.4866 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59467 0.52323 moveto
0.60935 0.48825 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6194 0.46431 moveto
0.62612 0.44829 lineto
stroke
grestore
gsave
0.4753 0.55194 moveto 0.53946 0.6026 lineto 0.45184 0.5367 lineto 0.547 0 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4753 0.55194 moveto
0.48167 0.55265 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48167 0.55265 moveto
0.48373 0.55288 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51923 0.46696 moveto
0.52698 0.50551 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56105 0.55827 moveto
0.56728 0.55597 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60215 0.55205 moveto
0.63126 0.5758 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.581 0.53481 moveto
0.60215 0.55205 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63126 0.5758 moveto
0.6463 0.58806 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60453 0.395 moveto
0.61109 0.40171 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61109 0.40171 moveto
0.66203 0.45386 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71822 0.47668 moveto
0.72093 0.4729 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5629 0.43681 moveto
0.57974 0.46452 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57974 0.46452 moveto
0.60315 0.50303 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55011 0.41578 moveto
0.5629 0.43681 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70599 0.55848 moveto
0.72679 0.4967 lineto
stroke
grestore
gsave
0.45184 0.5367 moveto 0.49829 0.62793 lineto 0.43629 0.52307 lineto 0.928 0.543 0.221 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43897 0.47523 moveto
0.44405 0.50797 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44405 0.50797 moveto
0.44709 0.5276 lineto
stroke
grestore
gsave
0.45184 0.5367 moveto 0.53946 0.6026 lineto 0.49829 0.62793 lineto 0.55 0.465 0.712 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.45184 0.5367 moveto
0.4753 0.55194 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45828 0.54154 moveto
0.46002 0.54285 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45184 0.5367 moveto
0.45828 0.54154 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49774 0.44372 moveto
0.55314 0.46983 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55314 0.46983 moveto
0.55534 0.47087 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55534 0.47087 moveto
0.59495 0.48954 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49774 0.44372 moveto
0.55011 0.41578 lineto
stroke
grestore
gsave
0.42007 0.5099 moveto 0.3923 0.64025 lineto 0.33603 0.6334 lineto 0.737 0.7 0.815 setrgbcolor
fill
grestore
gsave
0.42669 0.51397 moveto 0.3923 0.64025 lineto 0.42007 0.5099 lineto 0.967 0.936 0.677 setrgbcolor
fill
grestore
gsave
0.42669 0.51397 moveto 0.44733 0.63921 lineto 0.3923 0.64025 lineto 0.701 0.631 0.776 setrgbcolor
fill
grestore
gsave
0.43629 0.52307 moveto 0.44733 0.63921 lineto 0.42669 0.51397 lineto 0.996 0.797 0.522 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42669 0.51397 moveto
0.42797 0.52177 lineto
stroke
grestore
gsave
0.43629 0.52307 moveto 0.49829 0.62793 lineto 0.44733 0.63921 lineto 0.641 0.553 0.74 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.43629 0.52307 moveto
0.45184 0.5367 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3923 0.64025 moveto
0.44733 0.63921 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42797 0.52177 moveto
0.44733 0.63921 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50786 0.57883 moveto
0.53946 0.6026 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46002 0.54285 moveto
0.50786 0.57883 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52238 0.55721 moveto
0.52961 0.55802 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48373 0.55288 moveto
0.52238 0.55721 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44733 0.63921 moveto
0.49829 0.62793 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72104 0.36921 moveto
0.72211 0.38411 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47091 0.45152 moveto
0.5087 0.49248 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5087 0.49248 moveto
0.51357 0.49777 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51357 0.49777 moveto
0.52872 0.51418 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56728 0.55597 moveto
0.57396 0.54567 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57396 0.54567 moveto
0.58161 0.53386 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43897 0.47523 moveto
0.49505 0.49828 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49505 0.49828 moveto
0.501 0.50073 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.501 0.50073 moveto
0.52566 0.51086 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43897 0.47523 moveto
0.47091 0.45152 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7276 0.44648 moveto
0.72765 0.44627 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72093 0.4729 moveto
0.7276 0.44648 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72211 0.38411 moveto
0.72453 0.40099 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54559 0.48951 moveto
0.56167 0.49038 lineto
stroke
grestore
gsave
0.41396 0.50943 moveto 0.33603 0.6334 lineto 0.28124 0.61799 lineto 0.754 0.759 0.857 setrgbcolor
fill
grestore
gsave
0.42007 0.5099 moveto 0.33603 0.6334 lineto 0.41396 0.50943 lineto 0.856 0.995 0.762 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3923 0.64025 moveto
0.40139 0.59759 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.33603 0.6334 moveto
0.3923 0.64025 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47642 0.59093 moveto
0.49829 0.62793 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44169 0.5322 moveto
0.47642 0.59093 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43629 0.52307 moveto
0.44169 0.5322 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42669 0.51397 moveto
0.43629 0.52307 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49829 0.62793 moveto
0.53946 0.6026 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72741 0.42159 moveto
0.72765 0.44627 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.72453 0.40099 moveto
0.72741 0.42159 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60453 0.395 moveto
0.6475 0.39542 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57808 0.50801 moveto
0.58161 0.53386 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56167 0.49038 moveto
0.57808 0.50801 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42007 0.5099 moveto
0.42669 0.51397 lineto
stroke
grestore
gsave
0.40745 0.5101 moveto 0.28124 0.61799 lineto 0.23408 0.59052 lineto 0.75 0.803 0.895 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33603 0.6334 moveto
0.35928 0.59641 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40139 0.59759 moveto
0.40296 0.59024 lineto
stroke
grestore
gsave
0.41396 0.50943 moveto 0.28124 0.61799 lineto 0.40745 0.5101 lineto 0.682 0.976 0.806 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28124 0.61799 moveto
0.33603 0.6334 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4117 0.51302 moveto
0.41396 0.50943 lineto
stroke
grestore
gsave
0.52186 0.55501 moveto 0.48218 0.64885 lineto 0.32772 0.64332 lineto 0.688 0.82 0.946 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40296 0.59024 moveto
0.42007 0.5099 lineto
stroke
grestore
gsave
0.55102 0.53254 moveto 0.48218 0.64885 lineto 0.52186 0.55501 lineto 0.77 0.914 0.936 setrgbcolor
fill
grestore
gsave
0.55102 0.53254 moveto 0.64438 0.58995 lineto 0.48218 0.64885 lineto 0.704 0.821 0.938 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52698 0.50551 moveto
0.53283 0.53466 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53273 0.53478 moveto
0.53631 0.5309 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51294 0.55615 moveto
0.53273 0.53478 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48218 0.64885 moveto
0.55686 0.62173 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.41396 0.50943 moveto
0.42007 0.5099 lineto
stroke
grestore
gsave
0.53558 0.59192 moveto 0.4751 0.68305 lineto 0.32614 0.66831 lineto 0.675 0.825 0.955 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35928 0.59641 moveto
0.4117 0.51302 lineto
stroke
grestore
gsave
0.56704 0.57069 moveto 0.4751 0.68305 lineto 0.53558 0.59192 lineto 0.747 0.932 0.949 setrgbcolor
fill
grestore
gsave
0.56704 0.57069 moveto 0.64942 0.62848 lineto 0.4751 0.68305 lineto 0.695 0.833 0.949 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6463 0.58806 moveto
0.66837 0.52242 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47091 0.45152 moveto
0.51923 0.46696 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6475 0.39542 moveto
0.69917 0.43218 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55011 0.41578 moveto
0.62612 0.44829 lineto
stroke
grestore
gsave
0.42221 0.73993 moveto 0.55131 0.68058 lineto 0.50561 0.73319 lineto 0.585 0.871 0.994 setrgbcolor
fill
grestore
gsave
0.55337 0.67963 moveto 0.55278 0.68029 lineto 0.55131 0.68058 lineto 0.585 0.871 0.994 setrgbcolor
fill
grestore
gsave
0.50561 0.73319 moveto 0.55131 0.68058 lineto 0.55278 0.68029 lineto 0.585 0.871 0.994 setrgbcolor
fill
grestore
gsave
0.56292 0.67524 moveto 0.56067 0.67751 lineto 0.55337 0.67963 lineto 0.585 0.871 0.994 setrgbcolor
fill
grestore
gsave
0.50561 0.73319 moveto 0.55337 0.67963 lineto 0.56067 0.67751 lineto 0.585 0.871 0.994 setrgbcolor
fill
grestore
gsave
0.56292 0.67524 moveto 0.42221 0.73993 lineto 0.5362 0.6937 lineto 0.019 0 0 setrgbcolor
fill
grestore
gsave
0.36061 0.73167 moveto 0.53324 0.69434 lineto 0.42221 0.73993 lineto 0.52 0.83 1 setrgbcolor
fill
grestore
gsave
0.5362 0.6937 moveto 0.53477 0.69428 lineto 0.53324 0.69434 lineto 0.52 0.83 1 setrgbcolor
fill
grestore
gsave
0.42221 0.73993 moveto 0.53324 0.69434 lineto 0.53477 0.69428 lineto 0.52 0.83 1 setrgbcolor
fill
grestore
gsave
0.51191 0.70977 moveto 0.51607 0.70702 lineto 0.41389 0.72015 lineto 0.382 0.002 0.187 setrgbcolor
fill
grestore
gsave
0.5362 0.6937 moveto 0.53324 0.69434 lineto 0.51607 0.70702 lineto 0.382 0.002 0.187 setrgbcolor
fill
grestore
gsave
0.41389 0.72015 moveto 0.51607 0.70702 lineto 0.53324 0.69434 lineto 0.382 0.002 0.187 setrgbcolor
fill
grestore
gsave
0.51191 0.70977 moveto 0.41389 0.72015 lineto 0.38775 0.72774 lineto 0.382 0.002 0.187 setrgbcolor
fill
grestore
gsave
0.36061 0.73167 moveto 0.38775 0.72774 lineto 0.41389 0.72015 lineto 0.382 0.002 0.187 setrgbcolor
fill
grestore
gsave
0.51191 0.70977 moveto 0.36061 0.73167 lineto 0.32225 0.71288 lineto 0.476 0.768 0.995 setrgbcolor
fill
grestore
gsave
0.51191 0.70977 moveto 0.39197 0.71174 lineto 0.48947 0.72514 lineto 0.569 0.244 0.379 setrgbcolor
fill
grestore
gsave
0.48947 0.72514 moveto 0.39197 0.71174 lineto 0.36871 0.71629 lineto 0.569 0.244 0.379 setrgbcolor
fill
grestore
gsave
0.32225 0.71288 moveto 0.36871 0.71629 lineto 0.39197 0.71174 lineto 0.569 0.244 0.379 setrgbcolor
fill
grestore
gsave
0.48947 0.72514 moveto 0.32225 0.71288 lineto 0.30778 0.68751 lineto 0.467 0.692 0.965 setrgbcolor
fill
grestore
gsave
0.48947 0.72514 moveto 0.37082 0.70057 lineto 0.46625 0.74075 lineto 0.676 0.412 0.515 setrgbcolor
fill
grestore
gsave
0.30778 0.68751 moveto 0.34912 0.7014 lineto 0.37082 0.70057 lineto 0.676 0.412 0.515 setrgbcolor
fill
grestore
gsave
0.46625 0.74075 moveto 0.37082 0.70057 lineto 0.34912 0.7014 lineto 0.676 0.412 0.515 setrgbcolor
fill
grestore
gsave
0.58963 0.65294 moveto 0.50561 0.73319 lineto 0.56292 0.67524 lineto 0.568 0.903 0.664 setrgbcolor
fill
grestore
gsave
0.58963 0.65294 moveto 0.60523 0.70642 lineto 0.50561 0.73319 lineto 0.651 0.889 0.983 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56067 0.67751 moveto
0.56292 0.67524 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55916 0.67904 moveto
0.56067 0.67751 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50561 0.73319 moveto
0.55916 0.67904 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4751 0.68305 moveto
0.52806 0.66647 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42221 0.73993 moveto
0.45574 0.73722 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47366 0.73577 moveto
0.50561 0.73319 lineto
stroke
grestore
gsave
0.61067 0.62671 moveto 0.60523 0.70642 lineto 0.58963 0.65294 lineto 0.844 0.977 0.874 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52806 0.66647 moveto
0.59577 0.64527 lineto
stroke
grestore
gsave
0.61067 0.62671 moveto 0.70722 0.65578 lineto 0.60523 0.70642 lineto 0.7 0.881 0.965 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50561 0.73319 moveto
0.60523 0.70642 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58963 0.65294 moveto
0.60523 0.70642 lineto
stroke
grestore
gsave
0.55852 0.50534 moveto 0.64438 0.58995 lineto 0.55102 0.53254 lineto 0.786 0.823 0.881 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53631 0.5309 moveto
0.55492 0.5108 lineto
stroke
grestore
gsave
0.55852 0.50534 moveto 0.74354 0.49158 lineto 0.64438 0.58995 lineto 0.711 0.808 0.925 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61151 0.60189 moveto
0.64438 0.58995 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62612 0.44829 moveto
0.65457 0.4982 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.69917 0.43218 moveto
0.72518 0.49295 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55492 0.5108 moveto
0.55559 0.51598 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42221 0.73993 moveto
0.44106 0.73229 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.36061 0.73167 moveto
0.42221 0.73993 lineto
stroke
grestore
gsave
0.57461 0.54451 moveto 0.64942 0.62848 lineto 0.56704 0.57069 lineto 0.786 0.843 0.895 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55102 0.53254 moveto
0.57398 0.54666 lineto
stroke
grestore
gsave
0.57461 0.54451 moveto 0.76139 0.52421 lineto 0.64942 0.62848 lineto 0.71 0.823 0.935 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63331 0.63353 moveto
0.64942 0.62848 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70441 0.5304 moveto
0.74139 0.49371 lineto
stroke
grestore
gsave
0.40176 0.50925 moveto 0.23408 0.59052 lineto 0.20735 0.54647 lineto 0.729 0.824 0.924 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28124 0.61799 moveto
0.31276 0.59104 lineto
stroke
grestore
gsave
0.40745 0.5101 moveto 0.23408 0.59052 lineto 0.40176 0.50925 lineto 0.529 0.922 0.859 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.23408 0.59052 moveto
0.28124 0.61799 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40745 0.5101 moveto
0.41396 0.50943 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40363 0.51337 moveto
0.40745 0.5101 lineto
stroke
grestore
gsave
0.48674 0.56409 moveto 0.32772 0.64332 lineto 0.26125 0.56959 lineto 0.675 0.806 0.945 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23408 0.59052 moveto
0.26612 0.57499 lineto
stroke
grestore
gsave
0.52186 0.55501 moveto 0.32772 0.64332 lineto 0.48674 0.56409 lineto 0.646 0.921 0.977 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32772 0.64332 moveto
0.38868 0.6455 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34011 0.56767 moveto
0.40363 0.51337 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32772 0.64332 moveto
0.36938 0.62256 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51923 0.46696 moveto
0.55492 0.5108 lineto
stroke
grestore
gsave
0.61826 0.59892 moveto 0.70722 0.65578 lineto 0.61067 0.62671 lineto 0.833 0.858 0.864 setrgbcolor
fill
grestore
gsave
0.61826 0.59892 moveto 0.78548 0.58232 lineto 0.70722 0.65578 lineto 0.724 0.856 0.944 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60523 0.70642 moveto
0.70722 0.65578 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61067 0.62671 moveto
0.70722 0.65578 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38775 0.72774 moveto
0.41555 0.72372 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36061 0.73167 moveto
0.38775 0.72774 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32225 0.71288 moveto
0.36061 0.73167 lineto
stroke
grestore
gsave
0.50052 0.5989 moveto 0.32614 0.66831 lineto 0.27698 0.59175 lineto 0.664 0.805 0.95 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28114 0.59166 moveto
0.28135 0.59189 lineto
stroke
grestore
gsave
0.53558 0.59192 moveto 0.32614 0.66831 lineto 0.50052 0.5989 lineto 0.598 0.913 0.978 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32614 0.66831 moveto
0.4751 0.68305 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4751 0.68305 moveto
0.53558 0.59192 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36984 0.65092 moveto
0.39279 0.64178 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32614 0.66831 moveto
0.36984 0.65092 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50356 0.59829 moveto
0.52186 0.55501 lineto
stroke
grestore
gsave
0.40176 0.50925 moveto 0.20735 0.54647 lineto 0.40017 0.50481 lineto 0.467 0.878 0.943 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40176 0.50925 moveto
0.40745 0.5101 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27811 0.56918 moveto
0.40176 0.50925 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36871 0.71629 moveto
0.40033 0.71861 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35024 0.71493 moveto
0.36871 0.71629 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32225 0.71288 moveto
0.35024 0.71493 lineto
stroke
grestore
gsave
0.40017 0.50481 moveto 0.22137 0.48428 lineto 0.40731 0.49614 lineto 0.489 0.829 0.998 setrgbcolor
fill
grestore
gsave
0.40017 0.50481 moveto 0.20735 0.54647 lineto 0.22137 0.48428 lineto 0.703 0.823 0.939 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40017 0.50481 moveto
0.40176 0.50925 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.20735 0.54647 moveto
0.40017 0.50481 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.20735 0.54647 moveto
0.23408 0.59052 lineto
stroke
grestore
gsave
0.53988 0.48345 moveto 0.74354 0.49158 lineto 0.55852 0.50534 lineto 0.743 0.744 0.852 setrgbcolor
fill
grestore
gsave
0.53988 0.48345 moveto 0.73179 0.39429 lineto 0.74354 0.49158 lineto 0.707 0.791 0.916 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74139 0.49371 moveto
0.74354 0.49158 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52186 0.55501 moveto
0.55102 0.53254 lineto
stroke
grestore
gsave
0.48674 0.56409 moveto 0.26125 0.56959 lineto 0.46594 0.55717 lineto 0.563 0.847 0.997 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.48674 0.56409 moveto
0.52186 0.55501 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42192 0.59639 moveto
0.48674 0.56409 lineto
stroke
grestore
gsave
0.40731 0.49614 moveto 0.29778 0.41201 lineto 0.42736 0.48489 lineto 0.542 0.765 0.98 setrgbcolor
fill
grestore
gsave
0.40731 0.49614 moveto 0.22137 0.48428 lineto 0.29778 0.41201 lineto 0.684 0.808 0.941 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40017 0.50481 moveto
0.40731 0.49614 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.20735 0.54647 moveto
0.22137 0.48428 lineto
stroke
grestore
gsave
0.60577 0.57478 moveto 0.78548 0.58232 lineto 0.61826 0.59892 lineto 0.777 0.767 0.844 setrgbcolor
fill
grestore
gsave
0.55098 0.52665 moveto 0.76139 0.52421 lineto 0.57461 0.54451 lineto 0.744 0.755 0.861 setrgbcolor
fill
grestore
gsave
0.55098 0.52665 moveto 0.73048 0.42164 lineto 0.76139 0.52421 lineto 0.711 0.803 0.922 setrgbcolor
fill
grestore
gsave
0.60577 0.57478 moveto 0.80177 0.49836 lineto 0.78548 0.58232 lineto 0.727 0.825 0.926 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56704 0.57069 moveto
0.61649 0.60538 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70722 0.65578 moveto
0.78548 0.58232 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61826 0.59892 moveto
0.78548 0.58232 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55852 0.50534 moveto
0.59161 0.50288 lineto
stroke
grestore
gsave
0.46625 0.74075 moveto 0.30778 0.68751 lineto 0.31832 0.66029 lineto 0.484 0.613 0.904 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30778 0.68751 moveto
0.36032 0.70516 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30778 0.68751 moveto
0.32225 0.71288 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53558 0.59192 moveto
0.56704 0.57069 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57461 0.54451 moveto
0.72545 0.52812 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55102 0.53254 moveto
0.55236 0.52769 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55297 0.52548 moveto
0.55852 0.50534 lineto
stroke
grestore
gsave
0.50052 0.5989 moveto 0.27698 0.59175 lineto 0.48296 0.59066 lineto 0.533 0.833 0.999 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.50052 0.5989 moveto
0.53558 0.59192 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39279 0.64178 moveto
0.50052 0.5989 lineto
stroke
grestore
gsave
0.46594 0.55717 moveto 0.3451 0.4607 lineto 0.4739 0.54022 lineto 0.583 0.763 0.964 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40195 0.4958 moveto
0.40731 0.49614 lineto
stroke
grestore
gsave
0.46594 0.55717 moveto 0.26125 0.56959 lineto 0.3451 0.4607 lineto 0.675 0.789 0.935 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.46594 0.55717 moveto
0.48674 0.56409 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26125 0.56959 moveto
0.46594 0.55717 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.26125 0.56959 moveto
0.28114 0.59166 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56704 0.57069 moveto
0.57461 0.54451 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.5362 0.6937 moveto
0.56292 0.67524 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56292 0.67524 moveto
0.58963 0.65294 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51191 0.70977 moveto
0.5362 0.6937 lineto
stroke
grestore
gsave
0.42736 0.48489 moveto 0.44046 0.35337 lineto 0.46106 0.47532 lineto 0.594 0.715 0.928 setrgbcolor
fill
grestore
gsave
0.42736 0.48489 moveto 0.29778 0.41201 lineto 0.44046 0.35337 lineto 0.679 0.79 0.933 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40731 0.49614 moveto
0.42736 0.48489 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22137 0.48428 moveto
0.322 0.4907 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.58963 0.65294 moveto
0.61067 0.62671 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48947 0.72514 moveto
0.51191 0.70977 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61067 0.62671 moveto
0.61826 0.59892 lineto
stroke
grestore
gsave
0.48296 0.59066 moveto 0.36458 0.49149 lineto 0.49406 0.5744 lineto 0.566 0.754 0.966 setrgbcolor
fill
grestore
gsave
0.48296 0.59066 moveto 0.27698 0.59175 lineto 0.36458 0.49149 lineto 0.668 0.785 0.937 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.48296 0.59066 moveto
0.50052 0.5989 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27698 0.59175 moveto
0.48296 0.59066 lineto
stroke
grestore
gsave
0.5027 0.47333 moveto 0.73179 0.39429 lineto 0.53988 0.48345 lineto 0.693 0.702 0.855 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.53988 0.48345 moveto
0.55852 0.50534 lineto
stroke
grestore
gsave
0.46106 0.47532 moveto 0.61057 0.34168 lineto 0.5027 0.47333 lineto 0.643 0.694 0.882 setrgbcolor
fill
grestore
gsave
0.46106 0.47532 moveto 0.44046 0.35337 lineto 0.61057 0.34168 lineto 0.685 0.779 0.922 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.42736 0.48489 moveto
0.46106 0.47532 lineto
stroke
grestore
gsave
0.5027 0.47333 moveto 0.61057 0.34168 lineto 0.73179 0.39429 lineto 0.696 0.779 0.915 setrgbcolor
fill
grestore
gsave
0.4739 0.54022 moveto 0.55033 0.39188 lineto 0.5089 0.52602 lineto 0.633 0.714 0.906 setrgbcolor
fill
grestore
gsave
0.4739 0.54022 moveto 0.3451 0.4607 lineto 0.55033 0.39188 lineto 0.686 0.78 0.923 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.46622 0.55658 moveto
0.4739 0.54022 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52343 0.47897 moveto
0.53988 0.48345 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44046 0.35337 moveto
0.45251 0.42469 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.26125 0.56959 moveto
0.3451 0.4607 lineto
stroke
grestore
gsave
0.46625 0.74075 moveto 0.31832 0.66029 lineto 0.43891 0.7561 lineto 0.735 0.539 0.627 setrgbcolor
fill
grestore
gsave
0.43891 0.7561 moveto 0.31832 0.66029 lineto 0.35383 0.63852 lineto 0.513 0.553 0.834 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31832 0.66029 moveto
0.43611 0.75387 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27698 0.59175 moveto
0.32024 0.65912 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30778 0.68751 moveto
0.31832 0.66029 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36032 0.70516 moveto
0.38541 0.71359 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.46625 0.74075 moveto
0.48947 0.72514 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.22137 0.48428 moveto
0.29778 0.41201 lineto
stroke
grestore
gsave
0.43891 0.7561 moveto 0.35383 0.63852 lineto 0.40513 0.76889 lineto 0.757 0.631 0.721 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.43891 0.7561 moveto
0.46625 0.74075 lineto
stroke
grestore
gsave
0.5089 0.52602 moveto 0.73048 0.42164 lineto 0.55098 0.52665 lineto 0.688 0.712 0.867 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.55098 0.52665 moveto
0.57461 0.54451 lineto
stroke
grestore
gsave
0.5089 0.52602 moveto 0.55033 0.39188 lineto 0.73048 0.42164 lineto 0.7 0.786 0.917 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.5089 0.52602 moveto
0.55098 0.52665 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68802 0.41462 moveto
0.72517 0.39737 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.4739 0.54022 moveto
0.5089 0.52602 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56716 0.39466 moveto
0.61057 0.34168 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72517 0.39737 moveto
0.73179 0.39429 lineto
stroke
grestore
gsave
0.40513 0.76889 moveto 0.35383 0.63852 lineto 0.40827 0.6325 lineto 0.544 0.519 0.778 setrgbcolor
fill
grestore
gsave
0.40513 0.76889 moveto 0.40827 0.6325 lineto 0.36542 0.7754 lineto 0.747 0.69 0.797 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40513 0.76889 moveto
0.43891 0.7561 lineto
stroke
grestore
gsave
0.49406 0.5744 moveto 0.54769 0.42649 lineto 0.52955 0.56146 lineto 0.618 0.706 0.908 setrgbcolor
fill
grestore
gsave
0.49406 0.5744 moveto 0.36458 0.49149 lineto 0.54769 0.42649 lineto 0.681 0.776 0.922 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.48296 0.59066 moveto
0.49406 0.5744 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36458 0.49149 moveto
0.49406 0.5744 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27698 0.59175 moveto
0.36458 0.49149 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29778 0.41201 moveto
0.36969 0.45246 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3451 0.4607 moveto
0.38387 0.48464 lineto
stroke
grestore
gsave
0.36542 0.7754 moveto 0.40827 0.6325 lineto 0.4644 0.65234 lineto 0.572 0.505 0.741 setrgbcolor
fill
grestore
gsave
0.36542 0.7754 moveto 0.4644 0.65234 lineto 0.32452 0.77172 lineto 0.711 0.713 0.85 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36542 0.7754 moveto
0.40513 0.76889 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40509 0.64309 moveto
0.40827 0.6325 lineto
stroke
grestore
gsave
0.32452 0.77172 moveto 0.4644 0.65234 lineto 0.49425 0.70039 lineto 0.599 0.504 0.719 setrgbcolor
fill
grestore
gsave
0.32452 0.77172 moveto 0.48641 0.70368 lineto 0.29119 0.75595 lineto 0.656 0.697 0.877 setrgbcolor
fill
grestore
gsave
0.48665 0.70358 moveto 0.48624 0.70369 lineto 0.48641 0.70368 lineto 0.656 0.697 0.877 setrgbcolor
fill
grestore
gsave
0.29119 0.75595 moveto 0.48641 0.70368 lineto 0.48624 0.70369 lineto 0.656 0.697 0.877 setrgbcolor
fill
grestore
gsave
0.29119 0.75595 moveto 0.48665 0.70358 lineto 0.47737 0.70501 lineto 0.656 0.697 0.877 setrgbcolor
fill
grestore
gsave
0.49425 0.70039 moveto 0.47737 0.70501 lineto 0.48665 0.70358 lineto 0.656 0.697 0.877 setrgbcolor
fill
grestore
gsave
0.29119 0.75595 moveto 0.49425 0.70039 lineto 0.47122 0.76367 lineto 0.625 0.516 0.71 setrgbcolor
fill
grestore
gsave
0.29119 0.75595 moveto 0.44914 0.76272 lineto 0.27554 0.73035 lineto 0.593 0.641 0.868 setrgbcolor
fill
grestore
gsave
0.47122 0.76367 moveto 0.43948 0.75827 lineto 0.44914 0.76272 lineto 0.593 0.641 0.868 setrgbcolor
fill
grestore
gsave
0.27554 0.73035 moveto 0.44914 0.76272 lineto 0.43948 0.75827 lineto 0.593 0.641 0.868 setrgbcolor
fill
grestore
gsave
0.38971 0.81489 moveto 0.37419 0.80339 lineto 0.47122 0.76367 lineto 0.651 0.54 0.714 setrgbcolor
fill
grestore
gsave
0.28185 0.73502 moveto 0.43877 0.75876 lineto 0.37419 0.80339 lineto 0.651 0.54 0.714 setrgbcolor
fill
grestore
gsave
0.47122 0.76367 moveto 0.37419 0.80339 lineto 0.43877 0.75876 lineto 0.651 0.54 0.714 setrgbcolor
fill
grestore
gsave
0.27554 0.73035 moveto 0.29295 0.73331 lineto 0.28185 0.73502 lineto 0.651 0.54 0.714 setrgbcolor
fill
grestore
gsave
0.47122 0.76367 moveto 0.28185 0.73502 lineto 0.29295 0.73331 lineto 0.651 0.54 0.714 setrgbcolor
fill
grestore
gsave
0.27554 0.73035 moveto 0.36881 0.79941 lineto 0.28414 0.70246 lineto 0.54 0.546 0.81 setrgbcolor
fill
grestore
gsave
0.38971 0.81489 moveto 0.36508 0.78866 lineto 0.36881 0.79941 lineto 0.54 0.546 0.81 setrgbcolor
fill
grestore
gsave
0.28414 0.70246 moveto 0.36881 0.79941 lineto 0.36508 0.78866 lineto 0.54 0.546 0.81 setrgbcolor
fill
grestore
gsave
0.27652 0.82561 moveto 0.27782 0.80461 lineto 0.38971 0.81489 lineto 0.673 0.572 0.733 setrgbcolor
fill
grestore
gsave
0.28342 0.71402 moveto 0.36256 0.78912 lineto 0.27782 0.80461 lineto 0.673 0.572 0.733 setrgbcolor
fill
grestore
gsave
0.38971 0.81489 moveto 0.27782 0.80461 lineto 0.36256 0.78912 lineto 0.673 0.572 0.733 setrgbcolor
fill
grestore
gsave
0.28414 0.70246 moveto 0.29446 0.71345 lineto 0.28342 0.71402 lineto 0.673 0.572 0.733 setrgbcolor
fill
grestore
gsave
0.38971 0.81489 moveto 0.28342 0.71402 lineto 0.29446 0.71345 lineto 0.673 0.572 0.733 setrgbcolor
fill
grestore
gsave
0.28414 0.70246 moveto 0.27828 0.79716 lineto 0.31431 0.68329 lineto 0.528 0.446 0.707 setrgbcolor
fill
grestore
gsave
0.27652 0.82561 moveto 0.28733 0.78491 lineto 0.27828 0.79716 lineto 0.528 0.446 0.707 setrgbcolor
fill
grestore
gsave
0.31431 0.68329 moveto 0.27828 0.79716 lineto 0.28733 0.78491 lineto 0.528 0.446 0.707 setrgbcolor
fill
grestore
gsave
0.18232 0.78363 moveto 0.20874 0.76354 lineto 0.27652 0.82561 lineto 0.684 0.606 0.762 setrgbcolor
fill
grestore
gsave
0.30021 0.69401 moveto 0.28401 0.78401 lineto 0.20874 0.76354 lineto 0.684 0.606 0.762 setrgbcolor
fill
grestore
gsave
0.27652 0.82561 moveto 0.20874 0.76354 lineto 0.28401 0.78401 lineto 0.684 0.606 0.762 setrgbcolor
fill
grestore
gsave
0.31431 0.68329 moveto 0.31023 0.69863 lineto 0.30021 0.69401 lineto 0.684 0.606 0.762 setrgbcolor
fill
grestore
gsave
0.27652 0.82561 moveto 0.30021 0.69401 lineto 0.31023 0.69863 lineto 0.684 0.606 0.762 setrgbcolor
fill
grestore
gsave
0.31431 0.68329 moveto 0.18232 0.78363 lineto 0.3518 0.68222 lineto 0.579 0.417 0.626 setrgbcolor
fill
grestore
gsave
0.15771 0.70337 moveto 0.32905 0.6847 lineto 0.18232 0.78363 lineto 0.68 0.629 0.791 setrgbcolor
fill
grestore
gsave
0.3518 0.68222 moveto 0.33225 0.69392 lineto 0.32905 0.6847 lineto 0.68 0.629 0.791 setrgbcolor
fill
grestore
gsave
0.18232 0.78363 moveto 0.32905 0.6847 lineto 0.33225 0.69392 lineto 0.68 0.629 0.791 setrgbcolor
fill
grestore
gsave
0.3518 0.68222 moveto 0.21704 0.69691 lineto 0.37559 0.70043 lineto 0.665 0.489 0.637 setrgbcolor
fill
grestore
gsave
0.37559 0.70043 moveto 0.21704 0.69691 lineto 0.22264 0.69843 lineto 0.665 0.489 0.637 setrgbcolor
fill
grestore
gsave
0.20519 0.6982 moveto 0.20781 0.69928 lineto 0.37559 0.70043 lineto 0.665 0.489 0.637 setrgbcolor
fill
grestore
gsave
0.21586 0.70259 moveto 0.2341 0.70234 lineto 0.20781 0.69928 lineto 0.665 0.489 0.637 setrgbcolor
fill
grestore
gsave
0.37559 0.70043 moveto 0.20781 0.69928 lineto 0.2341 0.70234 lineto 0.665 0.489 0.637 setrgbcolor
fill
grestore
gsave
0.20519 0.6982 moveto 0.22264 0.69843 lineto 0.21704 0.69691 lineto 0.665 0.489 0.637 setrgbcolor
fill
grestore
gsave
0.15771 0.70337 moveto 0.21586 0.70259 lineto 0.20519 0.6982 lineto 0.665 0.489 0.637 setrgbcolor
fill
grestore
gsave
0.22425 0.62452 moveto 0.35673 0.69097 lineto 0.15771 0.70337 lineto 0.662 0.633 0.81 setrgbcolor
fill
grestore
gsave
0.37559 0.70043 moveto 0.34948 0.70078 lineto 0.35673 0.69097 lineto 0.662 0.633 0.81 setrgbcolor
fill
grestore
gsave
0.15771 0.70337 moveto 0.35673 0.69097 lineto 0.34948 0.70078 lineto 0.662 0.633 0.81 setrgbcolor
fill
grestore
gsave
0.37559 0.70043 moveto 0.27529 0.65012 lineto 0.36991 0.72793 lineto 0.724 0.599 0.717 setrgbcolor
fill
grestore
gsave
0.22425 0.62452 moveto 0.28184 0.6654 lineto 0.27529 0.65012 lineto 0.724 0.599 0.717 setrgbcolor
fill
grestore
gsave
0.36991 0.72793 moveto 0.27529 0.65012 lineto 0.28184 0.6654 lineto 0.724 0.599 0.717 setrgbcolor
fill
grestore
gsave
0.35108 0.59507 moveto 0.36851 0.71801 lineto 0.22425 0.62452 lineto 0.636 0.614 0.811 setrgbcolor
fill
grestore
gsave
0.36991 0.72793 moveto 0.35347 0.71626 lineto 0.36851 0.71801 lineto 0.636 0.614 0.811 setrgbcolor
fill
grestore
gsave
0.22425 0.62452 moveto 0.36851 0.71801 lineto 0.35347 0.71626 lineto 0.636 0.614 0.811 setrgbcolor
fill
grestore
gsave
0.36991 0.72793 moveto 0.35794 0.64346 lineto 0.33558 0.74828 lineto 0.725 0.677 0.804 setrgbcolor
fill
grestore
gsave
0.35108 0.59507 moveto 0.34455 0.65962 lineto 0.35794 0.64346 lineto 0.725 0.677 0.804 setrgbcolor
fill
grestore
gsave
0.33558 0.74828 moveto 0.35794 0.64346 lineto 0.34455 0.65962 lineto 0.725 0.677 0.804 setrgbcolor
fill
grestore
gsave
0.35222 0.73356 moveto 0.35158 0.65616 lineto 0.45936 0.63872 lineto 0.616 0.579 0.79 setrgbcolor
fill
grestore
gsave
0.35108 0.59507 moveto 0.45936 0.63872 lineto 0.35158 0.65616 lineto 0.616 0.579 0.79 setrgbcolor
fill
grestore
gsave
0.33558 0.74828 moveto 0.33748 0.72956 lineto 0.35222 0.73356 lineto 0.616 0.579 0.79 setrgbcolor
fill
grestore
gsave
0.35108 0.59507 moveto 0.35222 0.73356 lineto 0.33748 0.72956 lineto 0.616 0.579 0.79 setrgbcolor
fill
grestore
gsave
0.33558 0.74828 moveto 0.41184 0.68078 lineto 0.29091 0.74864 lineto 0.678 0.695 0.859 setrgbcolor
fill
grestore
gsave
0.45936 0.63872 moveto 0.38545 0.68695 lineto 0.41184 0.68078 lineto 0.678 0.695 0.859 setrgbcolor
fill
grestore
gsave
0.29091 0.74864 moveto 0.41184 0.68078 lineto 0.38545 0.68695 lineto 0.678 0.695 0.859 setrgbcolor
fill
grestore
gsave
0.32016 0.74553 moveto 0.31534 0.74354 lineto 0.45936 0.63872 lineto 0.612 0.545 0.754 setrgbcolor
fill
grestore
gsave
0.30515 0.73935 moveto 0.31171 0.73507 lineto 0.31534 0.74354 lineto 0.612 0.545 0.754 setrgbcolor
fill
grestore
gsave
0.45936 0.63872 moveto 0.31534 0.74354 lineto 0.31171 0.73507 lineto 0.612 0.545 0.754 setrgbcolor
fill
grestore
gsave
0.47372 0.7292 moveto 0.32016 0.74553 lineto 0.45936 0.63872 lineto 0.612 0.545 0.754 setrgbcolor
fill
grestore
gsave
0.29091 0.74864 moveto 0.30515 0.73935 lineto 0.32016 0.74553 lineto 0.612 0.545 0.754 setrgbcolor
fill
grestore
gsave
0.29091 0.74864 moveto 0.47372 0.7292 lineto 0.26097 0.72796 lineto 0.608 0.65 0.866 setrgbcolor
fill
grestore
gsave
0.38361 0.80633 moveto 0.27861 0.73924 lineto 0.47372 0.7292 lineto 0.631 0.535 0.727 setrgbcolor
fill
grestore
gsave
0.26097 0.72796 moveto 0.28782 0.72812 lineto 0.27861 0.73924 lineto 0.631 0.535 0.727 setrgbcolor
fill
grestore
gsave
0.47372 0.7292 moveto 0.27861 0.73924 lineto 0.28782 0.72812 lineto 0.631 0.535 0.727 setrgbcolor
fill
grestore
gsave
0.26097 0.72796 moveto 0.38361 0.80633 lineto 0.26247 0.69795 lineto 0.545 0.55 0.81 setrgbcolor
fill
grestore
gsave
0.24778 0.82238 moveto 0.26031 0.71619 lineto 0.38361 0.80633 lineto 0.661 0.56 0.729 setrgbcolor
fill
grestore
gsave
0.26247 0.69795 moveto 0.27819 0.71202 lineto 0.26031 0.71619 lineto 0.661 0.56 0.729 setrgbcolor
fill
grestore
gsave
0.38361 0.80633 moveto 0.26031 0.71619 lineto 0.27819 0.71202 lineto 0.661 0.56 0.729 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46186 0.6545 moveto
0.4644 0.65234 lineto
stroke
grestore
gsave
0.57286 0.56087 moveto 0.80177 0.49836 lineto 0.60577 0.57478 lineto 0.722 0.715 0.843 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.60577 0.57478 moveto
0.61826 0.59892 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47737 0.70501 moveto
0.49425 0.70039 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47019 0.70697 moveto
0.47737 0.70501 lineto
stroke
grestore
gsave
0.52955 0.56146 moveto 0.72032 0.43347 lineto 0.57286 0.56087 lineto 0.669 0.695 0.865 setrgbcolor
fill
grestore
gsave
0.52955 0.56146 moveto 0.54769 0.42649 lineto 0.72032 0.43347 lineto 0.699 0.78 0.914 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.49406 0.5744 moveto
0.52955 0.56146 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71091 0.43309 moveto
0.73048 0.42164 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52955 0.56146 moveto
0.54769 0.42649 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53865 0.42969 moveto
0.55033 0.39188 lineto
stroke
grestore
gsave
0.57286 0.56087 moveto 0.72032 0.43347 lineto 0.80177 0.49836 lineto 0.716 0.798 0.915 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57286 0.56087 moveto
0.72032 0.43347 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52955 0.56146 moveto
0.57286 0.56087 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57286 0.56087 moveto
0.60577 0.57478 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73786 0.52328 moveto
0.80177 0.49836 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60577 0.57478 moveto
0.73786 0.52328 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78548 0.58232 moveto
0.80177 0.49836 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73048 0.42164 moveto
0.73838 0.44785 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73179 0.39429 moveto
0.73818 0.44718 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61057 0.34168 moveto
0.73179 0.39429 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72032 0.43347 moveto
0.80177 0.49836 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43972 0.75831 moveto
0.47122 0.76367 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27652 0.82561 moveto
0.27833 0.81877 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30238 0.7282 moveto
0.30757 0.70869 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.18232 0.78363 moveto
0.24885 0.81328 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.26476 0.82037 moveto
0.27652 0.82561 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27652 0.82561 moveto
0.38971 0.81489 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.18232 0.78363 moveto
0.23595 0.75154 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23595 0.75154 moveto
0.23786 0.75039 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23786 0.75039 moveto
0.25767 0.73854 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28773 0.72055 moveto
0.32011 0.70118 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.15771 0.70337 moveto
0.18232 0.78363 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46135 0.65126 moveto
0.4644 0.65234 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38188 0.80654 moveto
0.38971 0.81489 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30369 0.72328 moveto
0.30835 0.72824 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.38971 0.81489 moveto
0.47122 0.76367 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.29778 0.41201 moveto
0.44046 0.35337 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.16321 0.7033 moveto
0.2341 0.70234 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2341 0.70234 moveto
0.26199 0.70196 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26688 0.7019 moveto
0.332 0.70102 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.15771 0.70337 moveto
0.16321 0.7033 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.15771 0.70337 moveto
0.22425 0.62452 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55033 0.39188 moveto
0.73048 0.42164 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47122 0.76367 moveto
0.49425 0.70039 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4644 0.65234 moveto
0.49425 0.70039 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3451 0.4607 moveto
0.3808 0.44873 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3808 0.44873 moveto
0.55033 0.39188 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38825 0.68513 moveto
0.45936 0.63872 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38545 0.68695 moveto
0.38825 0.68513 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32205 0.72832 moveto
0.38545 0.68695 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34479 0.65726 moveto
0.35108 0.59507 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3387 0.71746 moveto
0.34479 0.65726 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22425 0.62452 moveto
0.27976 0.66392 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27976 0.66392 moveto
0.28184 0.6654 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38249 0.72867 moveto
0.47372 0.7292 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29624 0.72817 moveto
0.38249 0.72867 lineto
stroke
grestore
gsave
0.26247 0.69795 moveto 0.24778 0.82238 lineto 0.29327 0.67635 lineto 0.531 0.442 0.699 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24778 0.82238 moveto
0.24957 0.81662 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28904 0.68993 moveto
0.29327 0.67635 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28724 0.6957 moveto
0.28904 0.68993 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24957 0.81662 moveto
0.28724 0.6957 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28184 0.6654 moveto
0.3398 0.70656 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.24778 0.82238 moveto
0.38361 0.80633 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44046 0.35337 moveto
0.61057 0.34168 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.36458 0.49149 moveto
0.54769 0.42649 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.22425 0.62452 moveto
0.35108 0.59507 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2813 0.71479 moveto
0.38361 0.80633 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.26247 0.69795 moveto
0.29327 0.67635 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54769 0.42649 moveto
0.72032 0.43347 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.38361 0.80633 moveto
0.47372 0.7292 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35108 0.59507 moveto
0.45936 0.63872 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45936 0.63872 moveto
0.47372 0.7292 lineto
stroke
grestore
gsave
0.002 setlinewidth
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
grestore
gsave
grestore
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; nowordwrap; ]
No Input Form was saved for this expression.

















;[o]
-Graphics3D-
:[font = input; startGroup; nowordwrap; ]
Show[%,BoxRatios->{1,1,4}]
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 120; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 2.50342 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.739522 2.49056 -0.0494087 2.49056 [
[ 0 0 0 0 ]
[ 1 2.50342 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 2.50342 lineto
0 2.50342 lineto
closepath
clip
newpath
gsave
0.002 setlinewidth
0.1343 0.24647 moveto
0.06226 2.17355 lineto
stroke
0.06226 2.17355 moveto
0.38116 2.44115 lineto
stroke
0.38116 2.44115 moveto
0.40046 0.56217 lineto
stroke
0.40046 0.56217 moveto
0.1343 0.24647 lineto
stroke
0.61919 0.06226 moveto
0.8691 0.3949 lineto
stroke
0.8691 0.3949 moveto
0.93774 2.29996 lineto
stroke
0.93774 2.29996 moveto
0.6419 2.01517 lineto
stroke
0.6419 2.01517 moveto
0.61919 0.06226 lineto
stroke
0.1343 0.24647 moveto
0.06226 2.17355 lineto
stroke
0.06226 2.17355 moveto
0.6419 2.01517 lineto
stroke
0.6419 2.01517 moveto
0.61919 0.06226 lineto
stroke
0.61919 0.06226 moveto
0.1343 0.24647 lineto
stroke
0.40046 0.56217 moveto
0.8691 0.3949 lineto
stroke
0.8691 0.3949 moveto
0.93774 2.29996 lineto
stroke
0.93774 2.29996 moveto
0.38116 2.44115 lineto
stroke
0.38116 2.44115 moveto
0.40046 0.56217 lineto
stroke
grestore
gsave
0.68919 0.37464 moveto 0.75818 0.46354 lineto 0.71011 0.50448 lineto 0.817 0.765 0.804 setrgbcolor
fill
grestore
gsave
0.6902 0.43014 moveto 0.71011 0.50448 lineto 0.6606 0.51431 lineto 0.702 0.827 0.942 setrgbcolor
fill
grestore
gsave
0.68919 0.37464 moveto 0.71011 0.50448 lineto 0.6902 0.43014 lineto 0.893 0.68 0.165 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.71011 0.50448 moveto
0.75818 0.46354 lineto
stroke
grestore
gsave
0.6902 0.43014 moveto 0.6606 0.51431 lineto 0.69262 0.48775 lineto 0 0 0.318 setrgbcolor
fill
grestore
gsave
0.69262 0.48775 moveto 0.6606 0.51431 lineto 0.615 0.49964 lineto 0.242 0.653 0.961 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6606 0.51431 moveto
0.71011 0.50448 lineto
stroke
grestore
gsave
0.69262 0.48775 moveto 0.615 0.49964 lineto 0.69582 0.54774 lineto 0.22 0.116 0.518 setrgbcolor
fill
grestore
gsave
0.69582 0.54774 moveto 0.615 0.49964 lineto 0.58071 0.4736 lineto 0 0.212 0.669 setrgbcolor
fill
grestore
gsave
0.69582 0.54774 moveto 0.58071 0.4736 lineto 0.69703 0.60718 lineto 0.417 0.285 0.593 setrgbcolor
fill
grestore
gsave
0.69703 0.60718 moveto 0.58071 0.4736 lineto 0.5668 0.45741 lineto 0 0 0.468 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58071 0.4736 moveto
0.60401 0.50035 lineto
stroke
grestore
gsave
0.69703 0.60718 moveto 0.5668 0.45741 lineto 0.69211 0.65906 lineto 0.515 0.388 0.645 setrgbcolor
fill
grestore
gsave
0.69211 0.65906 moveto 0.5668 0.45741 lineto 0.58018 0.47675 lineto 0 0 0.407 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5668 0.45741 moveto
0.57974 0.47824 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68919 0.37464 moveto
0.75818 0.46354 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6902 0.43014 moveto
0.71011 0.50448 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68919 0.37464 moveto
0.6902 0.43014 lineto
stroke
grestore
gsave
0.54147 0.7497 moveto 0.57086 0.63958 lineto 0.62042 0.85293 lineto 0.351 0.334 0.699 setrgbcolor
fill
grestore
gsave
0.59118 0.65862 moveto 0.65662 0.81539 lineto 0.5736 0.63287 lineto 0.901 0.494 0.096 setrgbcolor
fill
grestore
gsave
0.5736 0.63287 moveto 0.65662 0.81539 lineto 0.65279 0.80807 lineto 0.901 0.494 0.096 setrgbcolor
fill
grestore
gsave
0.5736 0.63287 moveto 0.66295 0.83055 lineto 0.64666 0.79677 lineto 0.901 0.494 0.096 setrgbcolor
fill
grestore
gsave
0.5736 0.63287 moveto 0.68105 0.87391 lineto 0.62042 0.85293 lineto 0.299 0.273 0.661 setrgbcolor
fill
grestore
gsave
0.5736 0.63287 moveto 0.60618 0.78599 lineto 0.57322 0.63074 lineto 0 0 0.152 setrgbcolor
fill
grestore
gsave
0.62042 0.85293 moveto 0.60331 0.77239 lineto 0.60618 0.78599 lineto 0 0 0.152 setrgbcolor
fill
grestore
gsave
0.57322 0.63074 moveto 0.60618 0.78599 lineto 0.60331 0.77239 lineto 0 0 0.152 setrgbcolor
fill
grestore
gsave
0.56104 0.67637 moveto 0.55192 0.71056 lineto 0.57259 0.6838 lineto 0.05 0.027 0.507 setrgbcolor
fill
grestore
gsave
0.57259 0.6838 moveto 0.55192 0.71056 lineto 0.55448 0.71232 lineto 0.05 0.027 0.507 setrgbcolor
fill
grestore
gsave
0.62042 0.85293 moveto 0.57086 0.63958 lineto 0.57843 0.65528 lineto 0.351 0.334 0.699 setrgbcolor
fill
grestore
gsave
0.56104 0.67637 moveto 0.57259 0.6838 lineto 0.58712 0.66094 lineto 0.05 0.027 0.507 setrgbcolor
fill
grestore
gsave
0.57322 0.63074 moveto 0.57843 0.65528 lineto 0.57086 0.63958 lineto 0.351 0.334 0.699 setrgbcolor
fill
grestore
gsave
0.57322 0.63074 moveto 0.56104 0.67637 lineto 0.58712 0.66094 lineto 0.05 0.027 0.507 setrgbcolor
fill
grestore
gsave
0.54926 0.72053 moveto 0.55448 0.71232 lineto 0.55192 0.71056 lineto 0.05 0.027 0.507 setrgbcolor
fill
grestore
gsave
0.54147 0.7497 moveto 0.55843 0.71672 lineto 0.54926 0.72053 lineto 0.05 0.027 0.507 setrgbcolor
fill
grestore
gsave
0.58712 0.66094 moveto 0.54926 0.72053 lineto 0.55843 0.71672 lineto 0.05 0.027 0.507 setrgbcolor
fill
grestore
gsave
0.48463 0.62715 moveto 0.57336 0.6564 lineto 0.54147 0.7497 lineto 0.319 0.353 0.74 setrgbcolor
fill
grestore
gsave
0.54147 0.7497 moveto 0.57336 0.6564 lineto 0.58148 0.67191 lineto 0.319 0.353 0.74 setrgbcolor
fill
grestore
gsave
0.58712 0.66094 moveto 0.58148 0.67191 lineto 0.57336 0.6564 lineto 0.319 0.353 0.74 setrgbcolor
fill
grestore
gsave
0.58712 0.66094 moveto 0.52046 0.63897 lineto 0.60389 0.71387 lineto 0.385 0.281 0.612 setrgbcolor
fill
grestore
gsave
0.60389 0.71387 moveto 0.52046 0.63897 lineto 0.5329 0.66225 lineto 0.385 0.281 0.612 setrgbcolor
fill
grestore
gsave
0.48463 0.62715 moveto 0.5329 0.66225 lineto 0.52046 0.63897 lineto 0.385 0.281 0.612 setrgbcolor
fill
grestore
gsave
0.55034 0.64882 moveto 0.58654 0.69279 lineto 0.48463 0.62715 lineto 0.145 0.288 0.753 setrgbcolor
fill
grestore
gsave
0.48004 0.5634 moveto 0.55034 0.64882 lineto 0.48463 0.62715 lineto 0.145 0.288 0.753 setrgbcolor
fill
grestore
gsave
0.48463 0.62715 moveto 0.58654 0.69279 lineto 0.58752 0.69745 lineto 0.145 0.288 0.753 setrgbcolor
fill
grestore
gsave
0.48463 0.62715 moveto 0.59405 0.70191 lineto 0.58984 0.70365 lineto 0.145 0.288 0.753 setrgbcolor
fill
grestore
gsave
0.59405 0.70191 moveto 0.58752 0.69745 lineto 0.58654 0.69279 lineto 0.145 0.288 0.753 setrgbcolor
fill
grestore
gsave
0.60389 0.71387 moveto 0.58984 0.70365 lineto 0.59405 0.70191 lineto 0.145 0.288 0.753 setrgbcolor
fill
grestore
gsave
0.60389 0.71387 moveto 0.52565 0.61882 lineto 0.60952 0.76467 lineto 0.507 0.409 0.678 setrgbcolor
fill
grestore
gsave
0.48004 0.5634 moveto 0.53474 0.64843 lineto 0.52565 0.61882 lineto 0.507 0.409 0.678 setrgbcolor
fill
grestore
gsave
0.60952 0.76467 moveto 0.52565 0.61882 lineto 0.53474 0.64843 lineto 0.507 0.409 0.678 setrgbcolor
fill
grestore
gsave
0.59805 0.74225 moveto 0.53242 0.64278 lineto 0.52915 0.60756 lineto 0 0.093 0.649 setrgbcolor
fill
grestore
gsave
0.48004 0.5634 moveto 0.52915 0.60756 lineto 0.53242 0.64278 lineto 0 0.093 0.649 setrgbcolor
fill
grestore
gsave
0.60952 0.76467 moveto 0.59276 0.73861 lineto 0.59805 0.74225 lineto 0 0.093 0.649 setrgbcolor
fill
grestore
gsave
0.48004 0.5634 moveto 0.59805 0.74225 lineto 0.59276 0.73861 lineto 0 0.093 0.649 setrgbcolor
fill
grestore
gsave
0.60952 0.76467 moveto 0.52915 0.60756 lineto 0.59637 0.78815 lineto 0.516 0.498 0.776 setrgbcolor
fill
grestore
gsave
0.59934 0.74438 moveto 0.5968 0.78189 lineto 0.52915 0.60756 lineto 0 0 0.53 setrgbcolor
fill
grestore
gsave
0.59637 0.78815 moveto 0.5877 0.76486 lineto 0.5968 0.78189 lineto 0 0 0.53 setrgbcolor
fill
grestore
gsave
0.52915 0.60756 moveto 0.5968 0.78189 lineto 0.5877 0.76486 lineto 0 0 0.53 setrgbcolor
fill
grestore
gsave
0.59637 0.78815 moveto 0.59934 0.74438 lineto 0.56871 0.77592 lineto 0.119 0.434 0.874 setrgbcolor
fill
grestore
gsave
0.64112 0.89421 moveto 0.57904 0.79279 lineto 0.59934 0.74438 lineto 0 0 0.55 setrgbcolor
fill
grestore
gsave
0.56871 0.77592 moveto 0.57262 0.77189 lineto 0.57904 0.79279 lineto 0 0 0.55 setrgbcolor
fill
grestore
gsave
0.59934 0.74438 moveto 0.57904 0.79279 lineto 0.57262 0.77189 lineto 0 0 0.55 setrgbcolor
fill
grestore
gsave
0.66295 0.83055 moveto 0.65279 0.80807 lineto 0.65662 0.81539 lineto 0.901 0.494 0.096 setrgbcolor
fill
grestore
gsave
0.68105 0.87391 moveto 0.64666 0.79677 lineto 0.66295 0.83055 lineto 0.901 0.494 0.096 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48463 0.62715 moveto
0.53109 0.66094 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53109 0.66094 moveto
0.5329 0.66225 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48004 0.5634 moveto
0.48463 0.62715 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48463 0.62715 moveto
0.54147 0.7497 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54147 0.7497 moveto
0.55477 0.72384 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55843 0.71672 moveto
0.55907 0.71547 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55907 0.71547 moveto
0.56502 0.70391 lineto
stroke
grestore
gsave
0.59118 0.65862 moveto 0.69615 0.79976 lineto 0.68105 0.87391 lineto 0.174 0.179 0.624 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59089 0.81431 moveto
0.59753 0.823 lineto
stroke
grestore
gsave
0.62055 0.68859 moveto 0.69615 0.79976 lineto 0.59118 0.65862 lineto 0.75 0.236 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.57545 0.63559 moveto
0.59118 0.65862 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59118 0.65862 moveto
0.60844 0.67623 lineto
stroke
grestore
gsave
0.48014 0.82019 moveto 0.52192 0.72211 lineto 0.55724 0.92944 lineto 0.372 0.346 0.7 setrgbcolor
fill
grestore
gsave
0.53986 0.74206 moveto 0.58964 0.87559 lineto 0.52352 0.7136 lineto 0.905 0.516 0.089 setrgbcolor
fill
grestore
gsave
0.52352 0.7136 moveto 0.58964 0.87559 lineto 0.58513 0.86623 lineto 0.905 0.516 0.089 setrgbcolor
fill
grestore
gsave
0.52352 0.7136 moveto 0.5985 0.89936 lineto 0.58045 0.85759 lineto 0.905 0.516 0.089 setrgbcolor
fill
grestore
gsave
0.52352 0.7136 moveto 0.6237 0.96697 lineto 0.55724 0.92944 lineto 0.297 0.267 0.655 setrgbcolor
fill
grestore
gsave
0.52352 0.7136 moveto 0.54369 0.84272 lineto 0.52549 0.71373 lineto 0 0 0.225 setrgbcolor
fill
grestore
gsave
0.55724 0.92944 moveto 0.54299 0.83264 lineto 0.54369 0.84272 lineto 0 0 0.225 setrgbcolor
fill
grestore
gsave
0.52549 0.71373 moveto 0.54369 0.84272 lineto 0.54299 0.83264 lineto 0 0 0.225 setrgbcolor
fill
grestore
gsave
0.5292 0.73897 moveto 0.54299 0.83264 lineto 0.52192 0.72211 lineto 0.372 0.346 0.7 setrgbcolor
fill
grestore
gsave
0.55724 0.92944 moveto 0.54037 0.83039 lineto 0.54299 0.83264 lineto 0.372 0.346 0.7 setrgbcolor
fill
grestore
gsave
0.52192 0.72211 moveto 0.54299 0.83264 lineto 0.54037 0.83039 lineto 0.372 0.346 0.7 setrgbcolor
fill
grestore
gsave
0.52549 0.71373 moveto 0.5292 0.73897 lineto 0.52192 0.72211 lineto 0.372 0.346 0.7 setrgbcolor
fill
grestore
gsave
0.52549 0.71373 moveto 0.49806 0.77812 lineto 0.54062 0.74841 lineto 0.135 0.082 0.527 setrgbcolor
fill
grestore
gsave
0.49305 0.78988 moveto 0.50166 0.78237 lineto 0.49806 0.77812 lineto 0.135 0.082 0.527 setrgbcolor
fill
grestore
gsave
0.54062 0.74841 moveto 0.49806 0.77812 lineto 0.50166 0.78237 lineto 0.135 0.082 0.527 setrgbcolor
fill
grestore
gsave
0.42998 0.71136 moveto 0.46044 0.72156 lineto 0.48014 0.82019 lineto 0.343 0.379 0.754 setrgbcolor
fill
grestore
gsave
0.54062 0.74841 moveto 0.49305 0.78988 lineto 0.50503 0.79065 lineto 0.135 0.082 0.527 setrgbcolor
fill
grestore
gsave
0.52597 0.74351 moveto 0.50267 0.78249 lineto 0.46044 0.72156 lineto 0.343 0.379 0.754 setrgbcolor
fill
grestore
gsave
0.48014 0.82019 moveto 0.50503 0.79065 lineto 0.49305 0.78988 lineto 0.135 0.082 0.527 setrgbcolor
fill
grestore
gsave
0.48014 0.82019 moveto 0.46044 0.72156 lineto 0.50267 0.78249 lineto 0.343 0.379 0.754 setrgbcolor
fill
grestore
gsave
0.48014 0.82019 moveto 0.52597 0.74351 lineto 0.5328 0.75768 lineto 0.343 0.379 0.754 setrgbcolor
fill
grestore
gsave
0.54062 0.74841 moveto 0.5328 0.75768 lineto 0.52597 0.74351 lineto 0.343 0.379 0.754 setrgbcolor
fill
grestore
gsave
0.42998 0.71136 moveto 0.48502 0.75162 lineto 0.47305 0.72578 lineto 0.416 0.302 0.615 setrgbcolor
fill
grestore
gsave
0.54062 0.74841 moveto 0.47305 0.72578 lineto 0.55625 0.80371 lineto 0.416 0.302 0.615 setrgbcolor
fill
grestore
gsave
0.55625 0.80371 moveto 0.47305 0.72578 lineto 0.48502 0.75162 lineto 0.416 0.302 0.615 setrgbcolor
fill
grestore
gsave
0.4874 0.73059 moveto 0.53977 0.78621 lineto 0.42998 0.71136 lineto 0.104 0.3 0.776 setrgbcolor
fill
grestore
gsave
0.42406 0.66332 moveto 0.4874 0.73059 lineto 0.42998 0.71136 lineto 0.104 0.3 0.776 setrgbcolor
fill
grestore
gsave
0.42998 0.71136 moveto 0.53977 0.78621 lineto 0.53995 0.78873 lineto 0.104 0.3 0.776 setrgbcolor
fill
grestore
gsave
0.42998 0.71136 moveto 0.54645 0.79331 lineto 0.5416 0.793 lineto 0.104 0.3 0.776 setrgbcolor
fill
grestore
gsave
0.54645 0.79331 moveto 0.53995 0.78873 lineto 0.53977 0.78621 lineto 0.104 0.3 0.776 setrgbcolor
fill
grestore
gsave
0.55625 0.80371 moveto 0.5416 0.793 lineto 0.54645 0.79331 lineto 0.104 0.3 0.776 setrgbcolor
fill
grestore
gsave
0.55625 0.80371 moveto 0.42406 0.66332 lineto 0.56001 0.85525 lineto 0.527 0.42 0.676 setrgbcolor
fill
grestore
gsave
0.45543 0.69829 moveto 0.54794 0.83714 lineto 0.42406 0.66332 lineto 0 0 0.532 setrgbcolor
fill
grestore
gsave
0.42406 0.66332 moveto 0.54794 0.83714 lineto 0.54324 0.83158 lineto 0 0 0.532 setrgbcolor
fill
grestore
gsave
0.50054 0.797 moveto 0.5418 0.87412 lineto 0.45543 0.69829 lineto 0.706 0.323 0 setrgbcolor
fill
grestore
gsave
0.54668 0.88324 moveto 0.53592 0.86143 lineto 0.5418 0.87412 lineto 0.706 0.323 0 setrgbcolor
fill
grestore
gsave
0.45543 0.69829 moveto 0.5418 0.87412 lineto 0.53592 0.86143 lineto 0.706 0.323 0 setrgbcolor
fill
grestore
gsave
0.56001 0.85525 moveto 0.54324 0.83158 lineto 0.54794 0.83714 lineto 0 0 0.532 setrgbcolor
fill
grestore
gsave
0.5985 0.89936 moveto 0.58513 0.86623 lineto 0.58964 0.87559 lineto 0.905 0.516 0.089 setrgbcolor
fill
grestore
gsave
0.6237 0.96697 moveto 0.58045 0.85759 lineto 0.5985 0.89936 lineto 0.905 0.516 0.089 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42998 0.71136 moveto
0.43434 0.71455 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43434 0.71455 moveto
0.47718 0.74588 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47988 0.74786 moveto
0.48061 0.74839 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48502 0.75162 moveto
0.48831 0.75402 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48061 0.74839 moveto
0.48502 0.75162 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57949 0.79941 moveto
0.59089 0.81431 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54388 0.75284 moveto
0.57949 0.79941 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55477 0.72384 moveto
0.55843 0.71672 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5329 0.66225 moveto
0.55306 0.67691 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42406 0.66332 moveto
0.42998 0.71136 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42998 0.71136 moveto
0.47061 0.79952 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47061 0.79952 moveto
0.48014 0.82019 lineto
stroke
grestore
gsave
0.69211 0.65906 moveto 0.584 0.48297 lineto 0.67738 0.69385 lineto 0.562 0.468 0.706 setrgbcolor
fill
grestore
gsave
0.58018 0.47675 moveto 0.58645 0.49074 lineto 0.584 0.48297 lineto 0.562 0.468 0.706 setrgbcolor
fill
grestore
gsave
0.67738 0.69385 moveto 0.584 0.48297 lineto 0.58645 0.49074 lineto 0.562 0.468 0.706 setrgbcolor
fill
grestore
gsave
0.67738 0.69385 moveto 0.58018 0.47675 lineto 0.61908 0.55008 lineto 0 0 0.432 setrgbcolor
fill
grestore
gsave
0.67738 0.69385 moveto 0.62401 0.56224 lineto 0.65214 0.7038 lineto 0.536 0.54 0.806 setrgbcolor
fill
grestore
gsave
0.61908 0.55008 moveto 0.62409 0.5734 lineto 0.62401 0.56224 lineto 0.536 0.54 0.806 setrgbcolor
fill
grestore
gsave
0.65214 0.7038 moveto 0.62401 0.56224 lineto 0.62409 0.5734 lineto 0.536 0.54 0.806 setrgbcolor
fill
grestore
gsave
0.66719 0.67142 moveto 0.65295 0.70206 lineto 0.61908 0.55008 lineto 0 0 0.503 setrgbcolor
fill
grestore
gsave
0.65214 0.7038 moveto 0.64921 0.69019 lineto 0.65295 0.70206 lineto 0 0 0.503 setrgbcolor
fill
grestore
gsave
0.61908 0.55008 moveto 0.65295 0.70206 lineto 0.64921 0.69019 lineto 0 0 0.503 setrgbcolor
fill
grestore
gsave
0.65214 0.7038 moveto 0.66719 0.67142 lineto 0.62055 0.68859 lineto 0.112 0.461 0.889 setrgbcolor
fill
grestore
gsave
0.69615 0.79976 moveto 0.62502 0.69517 lineto 0.66719 0.67142 lineto 0 0.053 0.574 setrgbcolor
fill
grestore
gsave
0.62055 0.68859 moveto 0.62496 0.68696 lineto 0.62502 0.69517 lineto 0 0.053 0.574 setrgbcolor
fill
grestore
gsave
0.66719 0.67142 moveto 0.62502 0.69517 lineto 0.62496 0.68696 lineto 0 0.053 0.574 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58018 0.47675 moveto
0.58645 0.49074 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58645 0.49074 moveto
0.62468 0.57613 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60844 0.67623 moveto
0.62055 0.68859 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59754 0.66718 moveto
0.60191 0.67304 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59118 0.65862 moveto
0.59754 0.66718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57974 0.47824 moveto
0.58372 0.48464 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5668 0.45741 moveto
0.58018 0.47675 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.6902 0.43014 moveto
0.69262 0.48775 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58018 0.47675 moveto
0.61908 0.55008 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6568 0.67525 moveto
0.66719 0.67142 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65664 0.6753 moveto
0.6568 0.67525 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62496 0.68696 moveto
0.65664 0.6753 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62495 0.68697 moveto
0.62496 0.68696 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62055 0.68859 moveto
0.62495 0.68697 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64546 0.79408 moveto
0.64666 0.79677 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64666 0.79677 moveto
0.68105 0.87391 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66603 0.75926 moveto
0.6669 0.76043 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6669 0.76043 moveto
0.69615 0.79976 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69262 0.48775 moveto
0.69582 0.54774 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48004 0.5634 moveto
0.53264 0.64517 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53264 0.64517 moveto
0.55758 0.68394 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48004 0.5634 moveto
0.52915 0.60756 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50484 0.79087 moveto
0.50503 0.79065 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48526 0.81411 moveto
0.50024 0.79634 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50249 0.79367 moveto
0.50484 0.79087 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50503 0.79065 moveto
0.50684 0.7885 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50684 0.7885 moveto
0.51004 0.7847 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48014 0.82019 moveto
0.48526 0.81411 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61908 0.55008 moveto
0.6201 0.55484 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6201 0.55484 moveto
0.62391 0.57253 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62391 0.57253 moveto
0.62409 0.5734 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62409 0.5734 moveto
0.64679 0.67893 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.67267 0.69571 moveto
0.67738 0.69385 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69582 0.54774 moveto
0.69703 0.60718 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57322 0.63074 moveto
0.58712 0.66094 lineto
stroke
grestore
gsave
0.53986 0.74206 moveto 0.64112 0.89421 lineto 0.6237 0.96697 lineto 0.123 0.144 0.61 setrgbcolor
fill
grestore
gsave
0.56871 0.77592 moveto 0.64112 0.89421 lineto 0.53986 0.74206 lineto 0.775 0.276 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5896 0.66877 moveto
0.64546 0.79408 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60191 0.67304 moveto
0.66603 0.75926 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48014 0.82019 moveto
0.55724 0.92944 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.64837 0.8626 moveto
0.68105 0.87391 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6306 0.85645 moveto
0.64837 0.8626 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59704 0.82797 moveto
0.64112 0.89421 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59492 0.82479 moveto
0.59704 0.82797 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54888 0.75562 moveto
0.55275 0.76143 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53986 0.74206 moveto
0.54888 0.75562 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53148 0.72747 moveto
0.53284 0.72984 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53284 0.72984 moveto
0.53986 0.74206 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53986 0.74206 moveto
0.56871 0.77592 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.67738 0.69385 moveto
0.69211 0.65906 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69211 0.65906 moveto
0.69703 0.60718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58045 0.85759 moveto
0.60892 0.92959 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57813 0.85172 moveto
0.58045 0.85759 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54898 0.77799 moveto
0.57813 0.85172 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60892 0.92959 moveto
0.6237 0.96697 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52352 0.7136 moveto
0.52549 0.71373 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42406 0.66332 moveto
0.46742 0.72453 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47056 0.72897 moveto
0.47735 0.73855 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59388 0.75 moveto
0.59934 0.74438 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58612 0.75799 moveto
0.59388 0.75 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58554 0.75859 moveto
0.58612 0.75799 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57262 0.77189 moveto
0.58554 0.75859 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57226 0.77227 moveto
0.57262 0.77189 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56871 0.77592 moveto
0.57226 0.77227 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.58712 0.66094 moveto
0.5943 0.68359 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.5943 0.68359 moveto
0.60389 0.71387 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54446 0.84257 moveto
0.5509 0.88635 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54382 0.83827 moveto
0.54446 0.84257 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5509 0.88635 moveto
0.55342 0.90347 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54299 0.83264 moveto
0.54382 0.83827 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54273 0.83086 moveto
0.54299 0.83264 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55342 0.90347 moveto
0.55724 0.92944 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55724 0.92944 moveto
0.6237 0.96697 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52549 0.71373 moveto
0.54062 0.74841 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61908 0.55008 moveto
0.66719 0.67142 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52915 0.60756 moveto
0.55745 0.6836 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55745 0.6836 moveto
0.55863 0.68676 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55863 0.68676 moveto
0.58542 0.75872 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.6065 0.77005 moveto
0.60952 0.76467 lineto
stroke
grestore
gsave
0.45768 0.83418 moveto 0.51981 1.07807 lineto 0.43538 0.81516 lineto 0.899 0.546 0.366 setrgbcolor
fill
grestore
gsave
0.45768 0.83418 moveto 0.54044 1.01593 lineto 0.51981 1.07807 lineto 0.237 0.143 0.54 setrgbcolor
fill
grestore
gsave
0.48732 0.861 moveto 0.54044 1.01593 lineto 0.45768 0.83418 lineto 0.829 0.404 0.229 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.45768 0.83418 moveto
0.46559 0.84133 lineto
stroke
grestore
gsave
0.48732 0.861 moveto 0.53381 0.91618 lineto 0.54044 1.01593 lineto 0 0 0.428 setrgbcolor
fill
grestore
gsave
0.51968 0.88231 moveto 0.53381 0.91618 lineto 0.48732 0.861 lineto 0.583 0.008 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.46559 0.84133 moveto
0.48732 0.861 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60389 0.71387 moveto
0.60952 0.76467 lineto
stroke
grestore
gsave
0.43538 0.81516 moveto 0.47988 1.10611 lineto 0.42105 0.81147 lineto 0.96 0.655 0.408 setrgbcolor
fill
grestore
gsave
0.43538 0.81516 moveto 0.51981 1.07807 lineto 0.47988 1.10611 lineto 0.465 0.311 0.587 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.43538 0.81516 moveto
0.45768 0.83418 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45768 0.83418 moveto
0.4651 0.85047 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51029 0.94972 moveto
0.54044 1.01593 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43538 0.81516 moveto
0.4423 0.83673 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4423 0.83673 moveto
0.44326 0.83972 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54838 0.64504 moveto
0.56137 0.67036 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52915 0.60756 moveto
0.54838 0.64504 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.56137 0.67036 moveto
0.59934 0.74438 lineto
stroke
grestore
gsave
0.54668 0.88324 moveto 0.50054 0.797 lineto 0.51968 0.88231 lineto 0.395 0.586 0.918 setrgbcolor
fill
grestore
gsave
0.51968 0.88231 moveto 0.50054 0.797 lineto 0.53381 0.91618 lineto 0 0 0.243 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51813 0.87543 moveto
0.51968 0.88231 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51754 0.87276 moveto
0.51813 0.87543 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51661 0.89577 moveto
0.53381 0.91618 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48732 0.861 moveto
0.49179 0.86631 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51323 0.89176 moveto
0.51661 0.89577 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48732 0.861 moveto
0.51968 0.88231 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4651 0.85047 moveto
0.46595 0.85233 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47735 0.73855 moveto
0.48301 0.74654 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54062 0.74841 moveto
0.54796 0.77438 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68105 0.87391 moveto
0.69615 0.79976 lineto
stroke
grestore
gsave
0.42105 0.81147 moveto 0.42979 1.11408 lineto 0.41258 0.82436 lineto 0.991 0.754 0.379 setrgbcolor
fill
grestore
gsave
0.42105 0.81147 moveto 0.47988 1.10611 lineto 0.42979 1.11408 lineto 0.6 0.427 0.618 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.42105 0.81147 moveto
0.43538 0.81516 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42105 0.81147 moveto
0.42531 0.83283 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42531 0.83283 moveto
0.42609 0.8367 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50338 0.93455 moveto
0.51029 0.94972 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48938 0.98333 moveto
0.51981 1.07807 lineto
stroke
grestore
gsave
0.56001 0.85525 moveto 0.45543 0.69829 lineto 0.54668 0.88324 lineto 0.558 0.514 0.763 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53592 0.86143 moveto
0.54668 0.88324 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49677 0.78209 moveto
0.53592 0.86143 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45543 0.69829 moveto
0.49677 0.78209 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44326 0.83972 moveto
0.48938 0.98333 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46595 0.85233 moveto
0.50338 0.93455 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54796 0.77438 moveto
0.55625 0.80371 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.5244 0.88247 moveto
0.54668 0.88324 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49224 0.86685 moveto
0.51323 0.89176 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49179 0.86631 moveto
0.49224 0.86685 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50054 0.797 moveto
0.50892 0.83434 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50892 0.83434 moveto
0.50965 0.83761 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50965 0.83761 moveto
0.51754 0.87276 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42406 0.66332 moveto
0.45543 0.69829 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55275 0.76143 moveto
0.59492 0.82479 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54668 0.88324 moveto
0.56001 0.85525 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45543 0.69829 moveto
0.50054 0.797 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55625 0.80371 moveto
0.56001 0.85525 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66719 0.67142 moveto
0.69615 0.79976 lineto
stroke
grestore
gsave
0.41258 0.82436 moveto 0.37582 1.11549 lineto 0.40697 0.85067 lineto 0.823 0.735 0.21 setrgbcolor
fill
grestore
gsave
0.41258 0.82436 moveto 0.42979 1.11408 lineto 0.37582 1.11549 lineto 0.7 0.526 0.65 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.41258 0.82436 moveto
0.42105 0.81147 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41258 0.82436 moveto
0.41362 0.84186 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41362 0.84186 moveto
0.42979 1.11408 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45888 1.00094 moveto
0.47988 1.10611 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42609 0.8367 moveto
0.45888 1.00094 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6237 0.96697 moveto
0.64112 0.89421 lineto
stroke
grestore
gsave
0.40697 0.85067 moveto 0.37582 1.11549 lineto 0.32156 1.11767 lineto 0.788 0.633 0.689 setrgbcolor
fill
grestore
gsave
0.40697 0.85067 moveto 0.32156 1.11767 lineto 0.40182 0.88518 lineto 0 0 0.072 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37582 1.11549 moveto
0.40697 0.85067 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40697 0.85067 moveto
0.41258 0.82436 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59934 0.74438 moveto
0.64112 0.89421 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37582 1.11549 moveto
0.42979 1.11408 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42979 1.11408 moveto
0.47988 1.10611 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.50054 0.797 moveto
0.53381 0.91618 lineto
stroke
grestore
gsave
0.40182 0.88518 moveto 0.32156 1.11767 lineto 0.27063 1.12063 lineto 0.868 0.761 0.742 setrgbcolor
fill
grestore
gsave
0.40182 0.88518 moveto 0.27063 1.12063 lineto 0.39634 0.92234 lineto 0.087 0 0.241 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32156 1.11767 moveto
0.38021 0.94779 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32156 1.11767 moveto
0.37582 1.11549 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.40182 0.88518 moveto
0.40697 0.85067 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47988 1.10611 moveto
0.51981 1.07807 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.51981 1.07807 moveto
0.54044 1.01593 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.53381 0.91618 moveto
0.54044 1.01593 lineto
stroke
grestore
gsave
0.39634 0.92234 moveto 0.27063 1.12063 lineto 0.22995 1.11843 lineto 0.913 0.904 0.802 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27063 1.12063 moveto
0.32156 1.11767 lineto
stroke
grestore
gsave
0.39634 0.92234 moveto 0.22995 1.11843 lineto 0.39175 0.95717 lineto 0.32 0.025 0.298 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.39634 0.92234 moveto
0.40182 0.88518 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27063 1.12063 moveto
0.34423 1.00454 lineto
stroke
grestore
gsave
0.52972 1.10811 moveto 0.61953 1.09477 lineto 0.46436 1.21136 lineto 0.791 0.988 0.889 setrgbcolor
fill
grestore
gsave
0.53628 1.07006 moveto 0.61953 1.09477 lineto 0.52972 1.10811 lineto 0.952 0.877 0.725 setrgbcolor
fill
grestore
gsave
0.53628 1.07006 moveto 0.70548 0.97671 lineto 0.61953 1.09477 lineto 0.842 0.947 0.888 setrgbcolor
fill
grestore
gsave
0.50298 1.14952 moveto 0.46436 1.21136 lineto 0.31731 1.27427 lineto 0.701 0.98 0.9 setrgbcolor
fill
grestore
gsave
0.52972 1.10811 moveto 0.46436 1.21136 lineto 0.50298 1.14952 lineto 0.61 0.811 0.399 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46436 1.21136 moveto
0.61953 1.09477 lineto
stroke
grestore
gsave
0.39175 0.95717 moveto 0.22995 1.11843 lineto 0.21205 1.10202 lineto 0.853 0.993 0.837 setrgbcolor
fill
grestore
gsave
0.39175 0.95717 moveto 0.21205 1.10202 lineto 0.39113 0.98577 lineto 0.459 0.109 0.285 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22995 1.11843 moveto
0.31062 1.03803 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39175 0.95717 moveto
0.39634 0.92234 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.22995 1.11843 moveto
0.27063 1.12063 lineto
stroke
grestore
gsave
0.39113 0.98577 moveto 0.21205 1.10202 lineto 0.23374 1.06376 lineto 0.727 0.99 0.86 setrgbcolor
fill
grestore
gsave
0.39113 0.98577 moveto 0.23374 1.06376 lineto 0.39861 1.00576 lineto 0.547 0.114 0.17 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.39113 0.98577 moveto
0.39175 0.95717 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.21205 1.10202 moveto
0.22995 1.11843 lineto
stroke
grestore
gsave
0.45745 1.33914 moveto 0.52774 1.25963 lineto 0.62471 1.22298 lineto 0.72 0.988 0.859 setrgbcolor
fill
grestore
gsave
0.54445 1.24073 moveto 0.56012 1.23726 lineto 0.52774 1.25963 lineto 0.72 0.988 0.859 setrgbcolor
fill
grestore
gsave
0.62471 1.22298 moveto 0.52774 1.25963 lineto 0.56012 1.23726 lineto 0.72 0.988 0.859 setrgbcolor
fill
grestore
gsave
0.54445 1.24073 moveto 0.45745 1.33914 lineto 0.51565 1.28018 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.51565 1.28018 moveto 0.45745 1.33914 lineto 0.31655 1.39204 lineto 0.617 0.958 0.882 setrgbcolor
fill
grestore
gsave
0.51565 1.28018 moveto 0.42097 1.33337 lineto 0.4833 1.3114 lineto 0.262 0 0.121 setrgbcolor
fill
grestore
gsave
0.31655 1.39204 moveto 0.38153 1.36062 lineto 0.42097 1.33337 lineto 0.262 0 0.121 setrgbcolor
fill
grestore
gsave
0.4833 1.3114 moveto 0.42097 1.33337 lineto 0.38153 1.36062 lineto 0.262 0 0.121 setrgbcolor
fill
grestore
gsave
0.5509 1.20674 moveto 0.62471 1.22298 lineto 0.54445 1.24073 lineto 0.961 0.917 0.72 setrgbcolor
fill
grestore
gsave
0.5509 1.20674 moveto 0.72165 1.09947 lineto 0.62471 1.22298 lineto 0.832 0.98 0.879 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52972 1.10811 moveto
0.61953 1.09477 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45745 1.33914 moveto
0.62471 1.22298 lineto
stroke
grestore
gsave
0.51925 1.04337 moveto 0.70548 0.97671 lineto 0.53628 1.07006 lineto 0.828 0.701 0.724 setrgbcolor
fill
grestore
gsave
0.51925 1.04337 moveto 0.68645 0.90312 lineto 0.70548 0.97671 lineto 0.83 0.887 0.883 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61953 1.09477 moveto
0.70548 0.97671 lineto
stroke
grestore
gsave
0.39861 1.00576 moveto 0.23374 1.06376 lineto 0.30874 1.00406 lineto 0.687 0.969 0.927 setrgbcolor
fill
grestore
gsave
0.39861 1.00576 moveto 0.30874 1.00406 lineto 0.41765 1.01711 lineto 0.464 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.39113 0.98577 moveto
0.39861 1.00576 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.21205 1.10202 moveto
0.22208 1.09551 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.22208 1.09551 moveto
0.31505 1.03516 lineto
stroke
grestore
gsave
0.50298 1.14952 moveto 0.31731 1.27427 lineto 0.47059 1.18276 lineto 0.155 0 0.061 setrgbcolor
fill
grestore
gsave
0.47059 1.18276 moveto 0.44118 1.20032 lineto 0.43208 1.19569 lineto 0.683 0.955 0.95 setrgbcolor
fill
grestore
gsave
0.26459 1.25195 moveto 0.43208 1.19569 lineto 0.31731 1.27427 lineto 0.683 0.955 0.95 setrgbcolor
fill
grestore
gsave
0.31731 1.27427 moveto 0.43208 1.19569 lineto 0.44118 1.20032 lineto 0.683 0.955 0.95 setrgbcolor
fill
grestore
gsave
0.47059 1.18276 moveto 0.26459 1.25195 lineto 0.45178 1.19897 lineto 0.394 0 0.008 setrgbcolor
fill
grestore
gsave
0.45178 1.19897 moveto 0.39756 1.17815 lineto 0.45956 1.19797 lineto 0 0.538 0.831 setrgbcolor
fill
grestore
gsave
0.34944 1.15967 moveto 0.38673 1.17264 lineto 0.39756 1.17815 lineto 0 0.538 0.831 setrgbcolor
fill
grestore
gsave
0.45956 1.19797 moveto 0.39756 1.17815 lineto 0.38673 1.17264 lineto 0 0.538 0.831 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31731 1.27427 moveto
0.35853 1.24966 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35853 1.24966 moveto
0.43593 1.20345 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31731 1.27427 moveto
0.46436 1.21136 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49579 1.16105 moveto
0.50298 1.14952 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46436 1.21136 moveto
0.49579 1.16105 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.21205 1.10202 moveto
0.23374 1.06376 lineto
stroke
grestore
gsave
0.41765 1.01711 moveto 0.43414 0.93779 lineto 0.44849 1.0229 lineto 0.339 0.558 0.916 setrgbcolor
fill
grestore
gsave
0.41765 1.01711 moveto 0.30874 1.00406 lineto 0.43414 0.93779 lineto 0.72 0.925 0.96 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30874 1.00406 moveto
0.41765 1.01711 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23374 1.06376 moveto
0.37938 1.01253 lineto
stroke
grestore
gsave
0.5659 1.4742 moveto 0.58384 1.42506 lineto 0.48693 1.49358 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.58481 1.42172 moveto 0.58384 1.42506 lineto 0.5659 1.4742 lineto 0.668 0.741 0.242 setrgbcolor
fill
grestore
gsave
0.58481 1.42172 moveto 0.67958 1.33777 lineto 0.58384 1.42506 lineto 0.496 0.832 0.543 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.50298 1.14952 moveto
0.52972 1.10811 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47059 1.18276 moveto
0.50298 1.14952 lineto
stroke
grestore
gsave
0.59095 1.37623 moveto 0.67958 1.33777 lineto 0.58481 1.42172 lineto 0.984 0.871 0.642 setrgbcolor
fill
grestore
gsave
0.59095 1.37623 moveto 0.74636 1.24608 lineto 0.67958 1.33777 lineto 0.822 0.998 0.783 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.58384 1.42506 moveto
0.67958 1.33777 lineto
stroke
grestore
gsave
0.52927 1.18938 moveto 0.72165 1.09947 lineto 0.5509 1.20674 lineto 0.838 0.72 0.733 setrgbcolor
fill
grestore
gsave
0.52927 1.18938 moveto 0.68425 1.03402 lineto 0.72165 1.09947 lineto 0.847 0.913 0.879 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62471 1.22298 moveto
0.72165 1.09947 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52972 1.10811 moveto
0.53628 1.07006 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53628 1.07006 moveto
0.70548 0.97671 lineto
stroke
grestore
gsave
0.54127 1.52966 moveto 0.48693 1.49358 lineto 0.40571 1.53796 lineto 0.245 0 0 setrgbcolor
fill
grestore
gsave
0.5659 1.4742 moveto 0.48693 1.49358 lineto 0.54127 1.52966 lineto 0.061 0 0.25 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48693 1.49358 moveto
0.58352 1.42529 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5659 1.4742 moveto
0.58384 1.42506 lineto
stroke
grestore
gsave
0.44849 1.0229 moveto 0.57853 0.89398 lineto 0.48591 1.02924 lineto 0.604 0.573 0.792 setrgbcolor
fill
grestore
gsave
0.44849 1.0229 moveto 0.43414 0.93779 lineto 0.57853 0.89398 lineto 0.759 0.871 0.929 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.41765 1.01711 moveto
0.44849 1.0229 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43414 0.93779 moveto
0.44849 1.0229 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45484 1.19633 moveto
0.47059 1.18276 lineto
stroke
grestore
gsave
0.48591 1.02924 moveto 0.68645 0.90312 lineto 0.51925 1.04337 lineto 0.72 0.613 0.737 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.51925 1.04337 moveto
0.53628 1.07006 lineto
stroke
grestore
gsave
0.48591 1.02924 moveto 0.57853 0.89398 lineto 0.68645 0.90312 lineto 0.796 0.856 0.895 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48591 1.02924 moveto
0.57853 0.89398 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48591 1.02924 moveto
0.51925 1.04337 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68645 0.90312 moveto
0.70548 0.97671 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.44849 1.0229 moveto
0.48591 1.02924 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51925 1.04337 moveto
0.68084 0.90782 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68084 0.90782 moveto
0.68645 0.90312 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57853 0.89398 moveto
0.68645 0.90312 lineto
stroke
grestore
gsave
0.4833 1.3114 moveto 0.45362 1.32575 lineto 0.44619 1.32067 lineto 0.644 0.939 0.963 setrgbcolor
fill
grestore
gsave
0.28014 1.36212 moveto 0.44619 1.32067 lineto 0.31655 1.39204 lineto 0.644 0.939 0.963 setrgbcolor
fill
grestore
gsave
0.31655 1.39204 moveto 0.44619 1.32067 lineto 0.45362 1.32575 lineto 0.644 0.939 0.963 setrgbcolor
fill
grestore
gsave
0.4833 1.3114 moveto 0.28014 1.36212 lineto 0.4674 1.32635 lineto 0.454 0 0.019 setrgbcolor
fill
grestore
gsave
0.4674 1.32635 moveto 0.41885 1.30196 lineto 0.47786 1.32681 lineto 0 0.475 0.818 setrgbcolor
fill
grestore
gsave
0.3666 1.2757 moveto 0.40884 1.2951 lineto 0.41885 1.30196 lineto 0 0.475 0.818 setrgbcolor
fill
grestore
gsave
0.47786 1.32681 moveto 0.41885 1.30196 lineto 0.40884 1.2951 lineto 0 0.475 0.818 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31655 1.39204 moveto
0.38153 1.36062 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38153 1.36062 moveto
0.44257 1.3311 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31655 1.39204 moveto
0.45745 1.33914 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45745 1.33914 moveto
0.46996 1.32646 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50469 1.29128 moveto
0.51565 1.28018 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47219 1.3242 moveto
0.50469 1.29128 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.23374 1.06376 moveto
0.30874 1.00406 lineto
stroke
grestore
gsave
0.51636 1.58624 moveto 0.40571 1.53796 lineto 0.3472 1.55851 lineto 0.44 0 0 setrgbcolor
fill
grestore
gsave
0.54127 1.52966 moveto 0.40571 1.53796 lineto 0.51636 1.58624 lineto 0.372 0.128 0.408 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40571 1.53796 moveto
0.48693 1.49358 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48693 1.49358 moveto
0.54127 1.52966 lineto
stroke
grestore
gsave
0.45178 1.19897 moveto 0.26459 1.25195 lineto 0.34944 1.15967 lineto 0.726 0.902 0.958 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26459 1.25195 moveto
0.45178 1.19897 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.26459 1.25195 moveto
0.31731 1.27427 lineto
stroke
grestore
gsave
0.57885 1.34289 moveto 0.74636 1.24608 lineto 0.59095 1.37623 lineto 0.875 0.724 0.691 setrgbcolor
fill
grestore
gsave
0.57885 1.34289 moveto 0.75143 1.17411 lineto 0.74636 1.24608 lineto 0.888 0.946 0.842 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58481 1.42172 moveto
0.65406 1.36038 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65406 1.36038 moveto
0.67958 1.33777 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67958 1.33777 moveto
0.74636 1.24608 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5509 1.20674 moveto
0.72165 1.09947 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54445 1.24073 moveto
0.62471 1.22298 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51565 1.28018 moveto
0.54445 1.24073 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54445 1.24073 moveto
0.5509 1.20674 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.4833 1.3114 moveto
0.51565 1.28018 lineto
stroke
grestore
gsave
0.45956 1.19797 moveto 0.52739 1.06256 lineto 0.49139 1.18983 lineto 0.575 0.612 0.852 setrgbcolor
fill
grestore
gsave
0.45956 1.19797 moveto 0.34944 1.15967 lineto 0.52739 1.06256 lineto 0.769 0.855 0.915 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.45178 1.19897 moveto
0.45956 1.19797 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38673 1.17264 moveto
0.45956 1.19797 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34944 1.15967 moveto
0.38673 1.17264 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.26459 1.25195 moveto
0.34944 1.15967 lineto
stroke
grestore
gsave
0.49364 1.64379 moveto 0.3472 1.55851 lineto 0.31274 1.55871 lineto 0.565 0 0 setrgbcolor
fill
grestore
gsave
0.51636 1.58624 moveto 0.3472 1.55851 lineto 0.49364 1.64379 lineto 0.52 0.266 0.47 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3472 1.55851 moveto
0.40571 1.53796 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47051 1.32343 moveto
0.4833 1.3114 lineto
stroke
grestore
gsave
0.49139 1.18983 moveto 0.68425 1.03402 lineto 0.52927 1.18938 lineto 0.718 0.627 0.755 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.52927 1.18938 moveto
0.5509 1.20674 lineto
stroke
grestore
gsave
0.49139 1.18983 moveto 0.52739 1.06256 lineto 0.68425 1.03402 lineto 0.812 0.859 0.884 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.49139 1.18983 moveto
0.52927 1.18938 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68425 1.03402 moveto
0.72165 1.09947 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45956 1.19797 moveto
0.49139 1.18983 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52927 1.18938 moveto
0.68425 1.03402 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30874 1.00406 moveto
0.43414 0.93779 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.43414 0.93779 moveto
0.57853 0.89398 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52739 1.06256 moveto
0.68425 1.03402 lineto
stroke
grestore
gsave
0.4674 1.32635 moveto 0.28014 1.36212 lineto 0.3666 1.2757 lineto 0.711 0.876 0.959 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28014 1.36212 moveto
0.31655 1.39204 lineto
stroke
grestore
gsave
0.49364 1.64379 moveto 0.31274 1.55871 lineto 0.47264 1.70258 lineto 0.612 0.357 0.506 setrgbcolor
fill
grestore
gsave
0.47264 1.70258 moveto 0.31274 1.55871 lineto 0.30202 1.54481 lineto 0 0.102 0.612 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31274 1.55871 moveto
0.3399 1.58316 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31703 1.55869 moveto
0.3472 1.55851 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51448 1.58542 moveto
0.51636 1.58624 lineto
stroke
grestore
gsave
0.54887 1.32539 moveto 0.75143 1.17411 lineto 0.57885 1.34289 lineto 0.77 0.632 0.707 setrgbcolor
fill
grestore
gsave
0.54887 1.32539 moveto 0.67332 1.14968 lineto 0.75143 1.17411 lineto 0.854 0.866 0.848 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59095 1.37623 moveto
0.70037 1.2846 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70037 1.2846 moveto
0.74636 1.24608 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74636 1.24608 moveto
0.75143 1.17411 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59797 1.3242 moveto
0.75143 1.17411 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57885 1.34289 moveto
0.59797 1.3242 lineto
stroke
grestore
gsave
0.47786 1.32681 moveto 0.52512 1.18862 lineto 0.50997 1.32257 lineto 0.531 0.573 0.842 setrgbcolor
fill
grestore
gsave
0.47786 1.32681 moveto 0.3666 1.2757 lineto 0.52512 1.18862 lineto 0.76 0.824 0.902 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.4674 1.32635 moveto
0.47786 1.32681 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40884 1.2951 moveto
0.47786 1.32681 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3666 1.2757 moveto
0.40884 1.2951 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28014 1.36212 moveto
0.4674 1.32635 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.5659 1.4742 moveto
0.58481 1.42172 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.58481 1.42172 moveto
0.59095 1.37623 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28014 1.36212 moveto
0.3666 1.2757 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54127 1.52966 moveto
0.5659 1.4742 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57885 1.34289 moveto
0.59095 1.37623 lineto
stroke
grestore
gsave
0.47264 1.70258 moveto 0.30202 1.54481 lineto 0.45093 1.76169 lineto 0.68 0.429 0.535 setrgbcolor
fill
grestore
gsave
0.45093 1.76169 moveto 0.30202 1.54481 lineto 0.31486 1.52766 lineto 0.128 0.235 0.706 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32513 1.57847 moveto
0.34095 1.60152 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30202 1.54481 moveto
0.32513 1.57847 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40571 1.53796 moveto
0.51448 1.58542 lineto
stroke
grestore
gsave
0.50997 1.32257 moveto 0.67332 1.14968 lineto 0.54887 1.32539 lineto 0.673 0.581 0.744 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.54887 1.32539 moveto
0.57885 1.34289 lineto
stroke
grestore
gsave
0.50997 1.32257 moveto 0.52512 1.18862 lineto 0.67332 1.14968 lineto 0.806 0.822 0.863 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67332 1.14968 moveto
0.75143 1.17411 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49139 1.18983 moveto
0.52739 1.06256 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47786 1.32681 moveto
0.50997 1.32257 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50997 1.32257 moveto
0.52512 1.18862 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.50997 1.32257 moveto
0.54887 1.32539 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.51636 1.58624 moveto
0.54127 1.52966 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54887 1.32539 moveto
0.67332 1.14968 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34944 1.15967 moveto
0.381 1.14244 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.381 1.14244 moveto
0.52739 1.06256 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.49364 1.64379 moveto
0.51636 1.58624 lineto
stroke
grestore
gsave
0.45093 1.76169 moveto 0.31486 1.52766 lineto 0.42533 1.81752 lineto 0.732 0.492 0.566 setrgbcolor
fill
grestore
gsave
0.42533 1.81752 moveto 0.31486 1.52766 lineto 0.34987 1.52471 lineto 0.349 0.29 0.649 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31486 1.52766 moveto
0.32993 1.56721 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32993 1.56721 moveto
0.34083 1.59582 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30202 1.54481 moveto
0.31486 1.52766 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36059 1.56631 moveto
0.49364 1.64379 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34095 1.60152 moveto
0.34556 1.60823 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52512 1.18862 moveto
0.67332 1.14968 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47264 1.70258 moveto
0.49364 1.64379 lineto
stroke
grestore
gsave
0.42533 1.81752 moveto 0.34987 1.52471 lineto 0.39366 1.86312 lineto 0.768 0.55 0.603 setrgbcolor
fill
grestore
gsave
0.39366 1.86312 moveto 0.34987 1.52471 lineto 0.40055 1.55835 lineto 0.452 0.326 0.617 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34987 1.52471 moveto
0.35467 1.56186 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35467 1.56186 moveto
0.35845 1.59106 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31486 1.52766 moveto
0.34987 1.52471 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34083 1.59582 moveto
0.36844 1.66827 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3666 1.2757 moveto
0.52512 1.18862 lineto
stroke
grestore
gsave
0.39366 1.86312 moveto 0.40055 1.55835 lineto 0.35653 1.88919 lineto 0.781 0.598 0.652 setrgbcolor
fill
grestore
gsave
0.35653 1.88919 moveto 0.40055 1.55835 lineto 0.45137 1.64729 lineto 0.513 0.354 0.602 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3974 1.58205 moveto
0.40055 1.55835 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39457 1.60334 moveto
0.3974 1.58205 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45093 1.76169 moveto
0.47264 1.70258 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34987 1.52471 moveto
0.40055 1.55835 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35845 1.59106 moveto
0.37706 1.73488 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.42533 1.81752 moveto
0.45093 1.76169 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39366 1.86312 moveto
0.42533 1.81752 lineto
stroke
grestore
gsave
0.35653 1.88919 moveto 0.45137 1.64729 lineto 0.31869 1.88748 lineto 0.751 0.616 0.709 setrgbcolor
fill
grestore
gsave
0.31869 1.88748 moveto 0.45137 1.64729 lineto 0.47807 1.79116 lineto 0.557 0.379 0.595 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.35653 1.88919 moveto
0.39366 1.86312 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40055 1.55835 moveto
0.45137 1.64729 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36884 1.79671 moveto
0.39457 1.60334 lineto
stroke
grestore
gsave
0.31869 1.88748 moveto 0.47093 1.79548 lineto 0.28873 1.85629 lineto 0.653 0.568 0.746 setrgbcolor
fill
grestore
gsave
0.47115 1.79534 moveto 0.47077 1.79547 lineto 0.47093 1.79548 lineto 0.653 0.568 0.746 setrgbcolor
fill
grestore
gsave
0.28873 1.85629 moveto 0.47093 1.79548 lineto 0.47077 1.79547 lineto 0.653 0.568 0.746 setrgbcolor
fill
grestore
gsave
0.28873 1.85629 moveto 0.47115 1.79534 lineto 0.46271 1.79644 lineto 0.653 0.568 0.746 setrgbcolor
fill
grestore
gsave
0.28873 1.85629 moveto 0.46271 1.79644 lineto 0.45662 1.9559 lineto 0.595 0.404 0.593 setrgbcolor
fill
grestore
gsave
0.47807 1.79116 moveto 0.46271 1.79644 lineto 0.47115 1.79534 lineto 0.653 0.568 0.746 setrgbcolor
fill
grestore
gsave
0.47807 1.79116 moveto 0.45662 1.9559 lineto 0.46271 1.79644 lineto 0.595 0.404 0.593 setrgbcolor
fill
grestore
gsave
0.28873 1.85629 moveto 0.43628 1.94383 lineto 0.27613 1.8052 lineto 0.512 0.442 0.714 setrgbcolor
fill
grestore
gsave
0.27613 1.8052 moveto 0.43628 1.94383 lineto 0.42748 1.93157 lineto 0.512 0.442 0.714 setrgbcolor
fill
grestore
gsave
0.45662 1.9559 moveto 0.42748 1.93157 lineto 0.43628 1.94383 lineto 0.512 0.442 0.714 setrgbcolor
fill
grestore
gsave
0.29787 1.86171 moveto 0.28184 1.82003 lineto 0.45662 1.9559 lineto 0.628 0.432 0.598 setrgbcolor
fill
grestore
gsave
0.38025 2.07591 moveto 0.29787 1.86171 lineto 0.45662 1.9559 lineto 0.628 0.432 0.598 setrgbcolor
fill
grestore
gsave
0.27613 1.8052 moveto 0.29227 1.81867 lineto 0.28184 1.82003 lineto 0.628 0.432 0.598 setrgbcolor
fill
grestore
gsave
0.45662 1.9559 moveto 0.28184 1.82003 lineto 0.29227 1.81867 lineto 0.628 0.432 0.598 setrgbcolor
fill
grestore
gsave
0.27613 1.8052 moveto 0.36106 2.02601 lineto 0.28624 1.75535 lineto 0.439 0.332 0.636 setrgbcolor
fill
grestore
gsave
0.28624 1.75535 moveto 0.36106 2.02601 lineto 0.35963 2.01384 lineto 0.439 0.332 0.636 setrgbcolor
fill
grestore
gsave
0.28624 1.75535 moveto 0.36879 2.04611 lineto 0.36817 2.0347 lineto 0.439 0.332 0.636 setrgbcolor
fill
grestore
gsave
0.27371 2.08545 moveto 0.27589 2.02801 lineto 0.38025 2.07591 lineto 0.656 0.461 0.609 setrgbcolor
fill
grestore
gsave
0.28509 1.78566 moveto 0.35565 2.00088 lineto 0.27589 2.02801 lineto 0.656 0.461 0.609 setrgbcolor
fill
grestore
gsave
0.36879 2.04611 moveto 0.35963 2.01384 lineto 0.36106 2.02601 lineto 0.439 0.332 0.636 setrgbcolor
fill
grestore
gsave
0.38025 2.07591 moveto 0.36817 2.0347 lineto 0.36879 2.04611 lineto 0.439 0.332 0.636 setrgbcolor
fill
grestore
gsave
0.38025 2.07591 moveto 0.27589 2.02801 lineto 0.35565 2.00088 lineto 0.656 0.461 0.609 setrgbcolor
fill
grestore
gsave
0.28624 1.75535 moveto 0.29529 1.7862 lineto 0.28509 1.78566 lineto 0.656 0.461 0.609 setrgbcolor
fill
grestore
gsave
0.38025 2.07591 moveto 0.28509 1.78566 lineto 0.29529 1.7862 lineto 0.656 0.461 0.609 setrgbcolor
fill
grestore
gsave
0.28624 1.75535 moveto 0.27666 2.00774 lineto 0.31544 1.73241 lineto 0.474 0.31 0.579 setrgbcolor
fill
grestore
gsave
0.27371 2.08545 moveto 0.28593 1.98208 lineto 0.27666 2.00774 lineto 0.474 0.31 0.579 setrgbcolor
fill
grestore
gsave
0.31544 1.73241 moveto 0.27666 2.00774 lineto 0.28593 1.98208 lineto 0.474 0.31 0.579 setrgbcolor
fill
grestore
gsave
0.18812 1.96718 moveto 0.21413 1.91922 lineto 0.27371 2.08545 lineto 0.674 0.487 0.626 setrgbcolor
fill
grestore
gsave
0.30214 1.75692 moveto 0.28289 1.97941 lineto 0.21413 1.91922 lineto 0.674 0.487 0.626 setrgbcolor
fill
grestore
gsave
0.27371 2.08545 moveto 0.21413 1.91922 lineto 0.28289 1.97941 lineto 0.674 0.487 0.626 setrgbcolor
fill
grestore
gsave
0.31544 1.73241 moveto 0.31107 1.76936 lineto 0.30214 1.75692 lineto 0.674 0.487 0.626 setrgbcolor
fill
grestore
gsave
0.27371 2.08545 moveto 0.30214 1.75692 lineto 0.31107 1.76936 lineto 0.674 0.487 0.626 setrgbcolor
fill
grestore
gsave
0.31544 1.73241 moveto 0.22324 1.90243 lineto 0.35006 1.75362 lineto 0.562 0.355 0.558 setrgbcolor
fill
grestore
gsave
0.35006 1.75362 moveto 0.22324 1.90243 lineto 0.2298 1.90013 lineto 0.562 0.355 0.558 setrgbcolor
fill
grestore
gsave
0.35006 1.75362 moveto 0.21542 1.91765 lineto 0.24043 1.8982 lineto 0.562 0.355 0.558 setrgbcolor
fill
grestore
gsave
0.21413 1.91922 moveto 0.21613 1.91762 lineto 0.21542 1.91765 lineto 0.562 0.355 0.558 setrgbcolor
fill
grestore
gsave
0.24043 1.8982 moveto 0.21542 1.91765 lineto 0.21613 1.91762 lineto 0.562 0.355 0.558 setrgbcolor
fill
grestore
gsave
0.3294 1.75652 moveto 0.23765 1.89332 lineto 0.17221 1.77855 lineto 0.672 0.501 0.646 setrgbcolor
fill
grestore
gsave
0.21413 1.91922 moveto 0.2298 1.90013 lineto 0.22324 1.90243 lineto 0.562 0.355 0.558 setrgbcolor
fill
grestore
gsave
0.18812 1.96718 moveto 0.24043 1.8982 lineto 0.21413 1.91922 lineto 0.562 0.355 0.558 setrgbcolor
fill
grestore
gsave
0.18812 1.96718 moveto 0.17221 1.77855 lineto 0.23765 1.89332 lineto 0.672 0.501 0.646 setrgbcolor
fill
grestore
gsave
0.18812 1.96718 moveto 0.3294 1.75652 lineto 0.33188 1.7776 lineto 0.672 0.501 0.646 setrgbcolor
fill
grestore
gsave
0.35006 1.75362 moveto 0.33188 1.7776 lineto 0.3294 1.75652 lineto 0.672 0.501 0.646 setrgbcolor
fill
grestore
gsave
0.35006 1.75362 moveto 0.22695 1.77088 lineto 0.37137 1.81546 lineto 0.653 0.43 0.568 setrgbcolor
fill
grestore
gsave
0.17221 1.77855 moveto 0.24505 1.79205 lineto 0.22695 1.77088 lineto 0.653 0.43 0.568 setrgbcolor
fill
grestore
gsave
0.37137 1.81546 moveto 0.22695 1.77088 lineto 0.24505 1.79205 lineto 0.653 0.43 0.568 setrgbcolor
fill
grestore
gsave
0.35492 1.79204 moveto 0.35569 1.80608 lineto 0.17221 1.77855 lineto 0.646 0.491 0.66 setrgbcolor
fill
grestore
gsave
0.35605 1.81262 moveto 0.34912 1.81133 lineto 0.35569 1.80608 lineto 0.646 0.491 0.66 setrgbcolor
fill
grestore
gsave
0.17221 1.77855 moveto 0.35569 1.80608 lineto 0.34912 1.81133 lineto 0.646 0.491 0.66 setrgbcolor
fill
grestore
gsave
0.23933 1.62744 moveto 0.35469 1.79171 lineto 0.17221 1.77855 lineto 0.646 0.491 0.66 setrgbcolor
fill
grestore
gsave
0.35492 1.79204 moveto 0.35458 1.79202 lineto 0.35469 1.79171 lineto 0.646 0.491 0.66 setrgbcolor
fill
grestore
gsave
0.17221 1.77855 moveto 0.35469 1.79171 lineto 0.35458 1.79202 lineto 0.646 0.491 0.66 setrgbcolor
fill
grestore
gsave
0.37137 1.81546 moveto 0.35605 1.81262 lineto 0.35492 1.79204 lineto 0.646 0.491 0.66 setrgbcolor
fill
grestore
gsave
0.37137 1.81546 moveto 0.23933 1.62744 lineto 0.36561 1.89061 lineto 0.721 0.508 0.601 setrgbcolor
fill
grestore
gsave
0.36408 1.8531 moveto 0.29055 1.7201 lineto 0.35419 1.61069 lineto 0.604 0.458 0.657 setrgbcolor
fill
grestore
gsave
0.23933 1.62744 moveto 0.35419 1.61069 lineto 0.29055 1.7201 lineto 0.604 0.458 0.657 setrgbcolor
fill
grestore
gsave
0.36561 1.89061 moveto 0.34998 1.85804 lineto 0.36408 1.8531 lineto 0.604 0.458 0.657 setrgbcolor
fill
grestore
gsave
0.23933 1.62744 moveto 0.36408 1.8531 lineto 0.34998 1.85804 lineto 0.604 0.458 0.657 setrgbcolor
fill
grestore
gsave
0.36561 1.89061 moveto 0.35825 1.71029 lineto 0.33376 1.94058 lineto 0.746 0.569 0.655 setrgbcolor
fill
grestore
gsave
0.35419 1.61069 moveto 0.34578 1.7464 lineto 0.35825 1.71029 lineto 0.746 0.569 0.655 setrgbcolor
fill
grestore
gsave
0.33376 1.94058 moveto 0.35825 1.71029 lineto 0.34578 1.7464 lineto 0.746 0.569 0.655 setrgbcolor
fill
grestore
gsave
0.33376 1.94058 moveto 0.33551 1.91232 lineto 0.35142 1.91162 lineto 0.572 0.42 0.636 setrgbcolor
fill
grestore
gsave
0.35142 1.91162 moveto 0.34747 1.91179 lineto 0.35419 1.61069 lineto 0.572 0.42 0.636 setrgbcolor
fill
grestore
gsave
0.33551 1.91232 moveto 0.33635 1.89879 lineto 0.34747 1.91179 lineto 0.572 0.42 0.636 setrgbcolor
fill
grestore
gsave
0.35419 1.61069 moveto 0.34747 1.91179 lineto 0.33635 1.89879 lineto 0.572 0.42 0.636 setrgbcolor
fill
grestore
gsave
0.44851 1.75238 moveto 0.35142 1.91162 lineto 0.35419 1.61069 lineto 0.572 0.42 0.636 setrgbcolor
fill
grestore
gsave
0.33376 1.94058 moveto 0.40551 1.8229 lineto 0.29307 1.93929 lineto 0.691 0.57 0.714 setrgbcolor
fill
grestore
gsave
0.44851 1.75238 moveto 0.38182 1.83258 lineto 0.40551 1.8229 lineto 0.691 0.57 0.714 setrgbcolor
fill
grestore
gsave
0.29307 1.93929 moveto 0.40551 1.8229 lineto 0.38182 1.83258 lineto 0.691 0.57 0.714 setrgbcolor
fill
grestore
gsave
0.29307 1.93929 moveto 0.44851 1.75238 lineto 0.46024 1.97747 lineto 0.573 0.403 0.613 setrgbcolor
fill
grestore
gsave
0.29307 1.93929 moveto 0.41141 1.96632 lineto 0.26712 1.89166 lineto 0.551 0.465 0.711 setrgbcolor
fill
grestore
gsave
0.26712 1.89166 moveto 0.41141 1.96632 lineto 0.37818 1.941 lineto 0.551 0.465 0.711 setrgbcolor
fill
grestore
gsave
0.46024 1.97747 moveto 0.37818 1.941 lineto 0.41141 1.96632 lineto 0.551 0.465 0.711 setrgbcolor
fill
grestore
gsave
0.37734 2.149 moveto 0.2829 1.9285 lineto 0.46024 1.97747 lineto 0.603 0.415 0.601 setrgbcolor
fill
grestore
gsave
0.26712 1.89166 moveto 0.29183 1.90264 lineto 0.2829 1.9285 lineto 0.603 0.415 0.601 setrgbcolor
fill
grestore
gsave
0.46024 1.97747 moveto 0.2829 1.9285 lineto 0.29183 1.90264 lineto 0.603 0.415 0.601 setrgbcolor
fill
grestore
gsave
0.26712 1.89166 moveto 0.37734 2.149 lineto 0.27067 1.83172 lineto 0.456 0.342 0.636 setrgbcolor
fill
grestore
gsave
0.25145 2.16148 moveto 0.26791 1.87909 lineto 0.37734 2.149 lineto 0.642 0.447 0.604 setrgbcolor
fill
grestore
gsave
0.26914 1.85795 moveto 0.2758 1.87587 lineto 0.26791 1.87909 lineto 0.642 0.447 0.604 setrgbcolor
fill
grestore
gsave
0.37734 2.149 moveto 0.26791 1.87909 lineto 0.2758 1.87587 lineto 0.642 0.447 0.604 setrgbcolor
fill
grestore
gsave
0.27067 1.83172 moveto 0.28305 1.86855 lineto 0.26914 1.85795 lineto 0.642 0.447 0.604 setrgbcolor
fill
grestore
gsave
0.37734 2.149 moveto 0.26914 1.85795 lineto 0.28305 1.86855 lineto 0.642 0.447 0.604 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30888 1.83254 moveto
0.3389 1.85761 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41835 1.70708 moveto
0.45137 1.64729 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46271 1.79644 moveto
0.47807 1.79116 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.32314 1.84445 moveto
0.34007 1.83863 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45101 1.80047 moveto
0.46271 1.79644 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45137 1.64729 moveto
0.47807 1.79116 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30512 1.81973 moveto
0.3279 1.89741 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29515 1.90411 moveto
0.30608 1.81163 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25339 1.65674 moveto
0.28685 1.72647 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28685 1.72647 moveto
0.28865 1.73022 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28865 1.73022 moveto
0.34014 1.83753 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23933 1.62744 moveto
0.25339 1.65674 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.23933 1.62744 moveto
0.35419 1.61069 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.17221 1.77855 moveto
0.23933 1.62744 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.17221 1.77855 moveto
0.24245 1.79157 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24245 1.79157 moveto
0.32547 1.80695 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.17221 1.77855 moveto
0.18812 1.96718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.18812 1.96718 moveto
0.24043 1.8982 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24043 1.8982 moveto
0.24228 1.89576 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24228 1.89576 moveto
0.26896 1.86057 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27687 1.85015 moveto
0.31158 1.80438 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4584 1.94223 moveto
0.47807 1.79116 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3461 1.74134 moveto
0.35102 1.6618 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33712 1.88632 moveto
0.3461 1.74134 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35102 1.6618 moveto
0.35419 1.61069 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35419 1.61069 moveto
0.44851 1.75238 lineto
stroke
grestore
gsave
0.27067 1.83172 moveto 0.25145 2.16148 lineto 0.30011 1.80113 lineto 0.487 0.317 0.576 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28872 1.88543 moveto
0.37734 2.149 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.18812 1.96718 moveto
0.25721 2.06265 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.27067 1.83172 moveto
0.30011 1.80113 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.26862 1.86631 moveto
0.27067 1.83172 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.26712 1.89166 moveto
0.26862 1.86631 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37818 1.941 moveto
0.46024 1.97747 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29498 1.90404 moveto
0.37818 1.941 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25145 2.16148 moveto
0.29384 1.84753 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29384 1.84753 moveto
0.29444 1.84311 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29444 1.84311 moveto
0.29572 1.83364 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29572 1.83364 moveto
0.30011 1.80113 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38438 1.8295 moveto
0.44851 1.75238 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38182 1.83258 moveto
0.38438 1.8295 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31499 1.91293 moveto
0.38182 1.83258 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44851 1.75238 moveto
0.46024 1.97747 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.37734 2.149 moveto
0.46024 1.97747 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.25145 2.16148 moveto
0.37734 2.149 lineto
stroke
grestore
gsave
0.002 setlinewidth
0.61919 0.06226 moveto
0.8691 0.3949 lineto
stroke
0.8691 0.3949 moveto
0.93774 2.29996 lineto
stroke
0.93774 2.29996 moveto
0.6419 2.01517 lineto
stroke
0.6419 2.01517 moveto
0.61919 0.06226 lineto
stroke
0.1343 0.24647 moveto
0.06226 2.17355 lineto
stroke
0.06226 2.17355 moveto
0.6419 2.01517 lineto
stroke
0.6419 2.01517 moveto
0.61919 0.06226 lineto
stroke
0.61919 0.06226 moveto
0.1343 0.24647 lineto
stroke
grestore
gsave
grestore
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; endGroup; nowordwrap; ]
No Input Form was saved for this expression.

















;[o]
-Graphics3D-
:[font = subsubsection; inactive; startGroup; ]
Ruffle: Kappa periodic, Tau periodic; out of phase.
:[font = text; inactive; ]
Multiply Cos and Sin by 0.6 as otherwise it looks too bunchy.  Bigger width than 1.5 makes nice conical overlaps.  Swapping Cos and Sin gives a curve that looks the same.
:[font = input; startGroup; nowordwrap; ]
clear;top=100;kappa[s_]:=0.6Cos[s];tau[s_]:=0.6Sin[s];
ds:=N[12Pi/top];width=1.5;pribbonfrenet
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 277; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.08079 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0260524 1.10184 0.0275459 1.10184 [
[ 0 0 0 0 ]
[ 1 1.08079 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 1.08079 lineto
0 1.08079 lineto
closepath
clip
newpath
gsave
0.002 setlinewidth
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
0.42251 0.57709 moveto
0.11113 0.25957 lineto
stroke
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
0.42251 0.57709 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.40586 1.05324 lineto
stroke
0.40586 1.05324 moveto
0.42251 0.57709 lineto
stroke
grestore
gsave
0.53671 0.50625 moveto 0.57456 0.55964 lineto 0.54955 0.57333 lineto 0.785 0.76 0.83 setrgbcolor
fill
grestore
gsave
0.54814 0.49635 moveto 0.57456 0.55964 lineto 0.53671 0.50625 lineto 0.76 0.753 0.847 setrgbcolor
fill
grestore
gsave
0.54814 0.49635 moveto 0.59709 0.54422 lineto 0.57456 0.55964 lineto 0.744 0.746 0.853 setrgbcolor
fill
grestore
gsave
0.52278 0.5132 moveto 0.54955 0.57333 lineto 0.52465 0.58404 lineto 0.823 0.769 0.802 setrgbcolor
fill
grestore
gsave
0.53671 0.50625 moveto 0.54955 0.57333 lineto 0.52278 0.5132 lineto 0.756 0.742 0.839 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.54955 0.57333 moveto
0.57456 0.55964 lineto
stroke
grestore
gsave
0.55688 0.48395 moveto 0.59709 0.54422 lineto 0.54814 0.49635 lineto 0.762 0.748 0.84 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54814 0.49635 moveto
0.55098 0.49913 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53773 0.54678 moveto
0.54955 0.57333 lineto
stroke
grestore
gsave
0.55688 0.48395 moveto 0.61504 0.52833 lineto 0.59709 0.54422 lineto 0.695 0.725 0.873 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57456 0.55964 moveto
0.59709 0.54422 lineto
stroke
grestore
gsave
0.50704 0.51704 moveto 0.52465 0.58404 lineto 0.5023 0.59074 lineto 0.859 0.775 0.767 setrgbcolor
fill
grestore
gsave
0.52278 0.5132 moveto 0.52465 0.58404 lineto 0.50704 0.51704 lineto 0.758 0.72 0.817 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52465 0.58404 moveto
0.54955 0.57333 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52359 0.515 moveto
0.53773 0.54678 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52278 0.5132 moveto
0.52359 0.515 lineto
stroke
grestore
gsave
0.56341 0.46974 moveto 0.61504 0.52833 lineto 0.55688 0.48395 lineto 0.752 0.725 0.828 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55688 0.48395 moveto
0.55985 0.48622 lineto
stroke
grestore
gsave
0.56341 0.46974 moveto 0.62727 0.5132 lineto 0.61504 0.52833 lineto 0.628 0.694 0.891 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59709 0.54422 moveto
0.61504 0.52833 lineto
stroke
grestore
gsave
0.49022 0.51802 moveto 0.5023 0.59074 lineto 0.48418 0.593 lineto 0.896 0.775 0.72 setrgbcolor
fill
grestore
gsave
0.50704 0.51704 moveto 0.5023 0.59074 lineto 0.49022 0.51802 lineto 0.767 0.696 0.783 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5023 0.59074 moveto
0.52465 0.58404 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50704 0.51704 moveto
0.52465 0.58404 lineto
stroke
grestore
gsave
0.56886 0.45457 moveto 0.62727 0.5132 lineto 0.56341 0.46974 lineto 0.727 0.692 0.816 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56341 0.46974 moveto
0.56871 0.47334 lineto
stroke
grestore
gsave
0.56886 0.45457 moveto 0.63371 0.49996 lineto 0.62727 0.5132 lineto 0.527 0.642 0.906 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53671 0.50625 moveto
0.57456 0.55964 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55098 0.49913 moveto
0.59709 0.54422 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56947 0.49355 moveto
0.61504 0.52833 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61504 0.52833 moveto
0.62727 0.5132 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59492 0.49118 moveto
0.62727 0.5132 lineto
stroke
grestore
gsave
0.47285 0.51691 moveto 0.48418 0.593 lineto 0.47082 0.59132 lineto 0.932 0.767 0.655 setrgbcolor
fill
grestore
gsave
0.49022 0.51802 moveto 0.48418 0.593 lineto 0.47285 0.51691 lineto 0.778 0.67 0.745 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48418 0.593 moveto
0.5023 0.59074 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49022 0.51802 moveto
0.5023 0.59074 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.50704 0.51704 moveto
0.52278 0.5132 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52278 0.5132 moveto
0.53671 0.50625 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53671 0.50625 moveto
0.54814 0.49635 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.49022 0.51802 moveto
0.50704 0.51704 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54814 0.49635 moveto
0.55688 0.48395 lineto
stroke
grestore
gsave
0.57457 0.43945 moveto 0.63371 0.49996 lineto 0.56886 0.45457 lineto 0.691 0.651 0.806 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56886 0.45457 moveto
0.5728 0.45733 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55985 0.48622 moveto
0.56947 0.49355 lineto
stroke
grestore
gsave
0.57457 0.43945 moveto 0.63532 0.4895 lineto 0.63371 0.49996 lineto 0.342 0.539 0.902 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57616 0.47842 moveto
0.59492 0.49118 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56871 0.47334 moveto
0.57616 0.47842 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62727 0.5132 moveto
0.63371 0.49996 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60974 0.48318 moveto
0.63371 0.49996 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59687 0.47418 moveto
0.60974 0.48318 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5728 0.45733 moveto
0.59687 0.47418 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55688 0.48395 moveto
0.56341 0.46974 lineto
stroke
grestore
gsave
0.45523 0.51501 moveto 0.47082 0.59132 lineto 0.46176 0.5872 lineto 0.962 0.741 0.556 setrgbcolor
fill
grestore
gsave
0.47285 0.51691 moveto 0.47082 0.59132 lineto 0.45523 0.51501 lineto 0.785 0.643 0.705 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.47082 0.59132 moveto
0.48418 0.593 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.47285 0.51691 moveto
0.49022 0.51802 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47285 0.51691 moveto
0.48418 0.593 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56341 0.46974 moveto
0.56886 0.45457 lineto
stroke
grestore
gsave
0.36288 0.58463 moveto 0.42319 0.62939 lineto 0.40848 0.65085 lineto 0.818 0.736 0.774 setrgbcolor
fill
grestore
gsave
0.36699 0.56838 moveto 0.42319 0.62939 lineto 0.36288 0.58463 lineto 0.878 0.702 0.659 setrgbcolor
fill
grestore
gsave
0.36699 0.56838 moveto 0.4343 0.61053 lineto 0.42319 0.62939 lineto 0.772 0.712 0.796 setrgbcolor
fill
grestore
gsave
0.3585 0.60081 moveto 0.40848 0.65085 lineto 0.39081 0.67303 lineto 0.859 0.758 0.751 setrgbcolor
fill
grestore
gsave
0.36288 0.58463 moveto 0.40848 0.65085 lineto 0.3585 0.60081 lineto 0.909 0.739 0.658 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39888 0.61135 moveto
0.42319 0.62939 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40848 0.65085 moveto
0.42319 0.62939 lineto
stroke
grestore
gsave
0.45523 0.51501 moveto 0.46176 0.5872 lineto 0.43762 0.51391 lineto 0.784 0.613 0.667 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.45523 0.51501 moveto
0.47285 0.51691 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45523 0.51501 moveto
0.47082 0.59132 lineto
stroke
grestore
gsave
0.37232 0.55296 moveto 0.4343 0.61053 lineto 0.36699 0.56838 lineto 0.844 0.666 0.661 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36699 0.56838 moveto
0.36723 0.56854 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36288 0.58463 moveto
0.36392 0.5854 lineto
stroke
grestore
gsave
0.37232 0.55296 moveto 0.44191 0.59566 lineto 0.4343 0.61053 lineto 0.715 0.682 0.817 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42319 0.62939 moveto
0.4343 0.61053 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41372 0.59764 moveto
0.4343 0.61053 lineto
stroke
grestore
gsave
0.58162 0.4255 moveto 0.63532 0.4895 lineto 0.57457 0.43945 lineto 0.646 0.605 0.794 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.56886 0.45457 moveto
0.57457 0.43945 lineto
stroke
grestore
gsave
0.58162 0.4255 moveto 0.63383 0.48233 lineto 0.63532 0.4895 lineto 0 0.291 0.79 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63371 0.49996 moveto
0.63532 0.4895 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57457 0.43945 moveto
0.63532 0.4895 lineto
stroke
grestore
gsave
0.3526 0.61593 moveto 0.39081 0.67303 lineto 0.3716 0.69376 lineto 0.896 0.778 0.723 setrgbcolor
fill
grestore
gsave
0.3585 0.60081 moveto 0.39081 0.67303 lineto 0.3526 0.61593 lineto 0.929 0.773 0.666 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39081 0.67303 moveto
0.40848 0.65085 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37983 0.62217 moveto
0.40848 0.65085 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36392 0.5854 moveto
0.36438 0.58574 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3585 0.60081 moveto
0.35943 0.60175 lineto
stroke
grestore
gsave
0.43762 0.51391 moveto 0.45602 0.58269 lineto 0.4205 0.51515 lineto 0.777 0.585 0.64 setrgbcolor
fill
grestore
gsave
0.43762 0.51391 moveto 0.46176 0.5872 lineto 0.45602 0.58269 lineto 0.97 0.675 0.407 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.43762 0.51391 moveto
0.45523 0.51501 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43762 0.51391 moveto
0.46176 0.5872 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46176 0.5872 moveto
0.47082 0.59132 lineto
stroke
grestore
gsave
0.38011 0.53917 moveto 0.44191 0.59566 lineto 0.37232 0.55296 lineto 0.812 0.633 0.66 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36438 0.58574 moveto
0.36469 0.58597 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36723 0.56854 moveto
0.36899 0.56964 lineto
stroke
grestore
gsave
0.38011 0.53917 moveto 0.44669 0.58561 lineto 0.44191 0.59566 lineto 0.642 0.64 0.833 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.4343 0.61053 moveto
0.44191 0.59566 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36469 0.58597 moveto
0.39888 0.61135 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42578 0.58576 moveto
0.44191 0.59566 lineto
stroke
grestore
gsave
0.4205 0.51515 moveto 0.45242 0.57991 lineto 0.40463 0.51971 lineto 0.768 0.571 0.631 setrgbcolor
fill
grestore
gsave
0.4205 0.51515 moveto 0.45602 0.58269 lineto 0.45242 0.57991 lineto 0.936 0.588 0.34 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.4205 0.51515 moveto
0.43762 0.51391 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45602 0.58269 moveto
0.46176 0.5872 lineto
stroke
grestore
gsave
0.39093 0.52785 moveto 0.44669 0.58561 lineto 0.38011 0.53917 lineto 0.785 0.601 0.652 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37232 0.55296 moveto
0.37449 0.55429 lineto
stroke
grestore
gsave
0.39093 0.52785 moveto 0.44975 0.58051 lineto 0.44669 0.58561 lineto 0.559 0.578 0.83 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44191 0.59566 moveto
0.44669 0.58561 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4205 0.51515 moveto
0.44749 0.56647 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44749 0.56647 moveto
0.45602 0.58269 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44669 0.58561 moveto
0.44906 0.58166 lineto
stroke
grestore
gsave
0.40463 0.51971 moveto 0.44975 0.58051 lineto 0.39093 0.52785 lineto 0.769 0.577 0.639 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38011 0.53917 moveto
0.38109 0.53985 lineto
stroke
grestore
gsave
0.40463 0.51971 moveto 0.45242 0.57991 lineto 0.44975 0.58051 lineto 0.624 0.547 0.747 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.40463 0.51971 moveto
0.4205 0.51515 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37449 0.55429 moveto
0.41646 0.58004 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36899 0.56964 moveto
0.41372 0.59764 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41646 0.58004 moveto
0.42578 0.58576 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43616 0.57826 moveto
0.43943 0.58055 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43943 0.58055 moveto
0.44669 0.58561 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42838 0.57284 moveto
0.43616 0.57826 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4199 0.56692 moveto
0.42838 0.57284 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38109 0.53985 moveto
0.4199 0.56692 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44906 0.58166 moveto
0.44975 0.58051 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44523 0.57085 moveto
0.45043 0.57739 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43887 0.56284 moveto
0.44523 0.57085 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.40463 0.51971 moveto
0.43887 0.56284 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45043 0.57739 moveto
0.45242 0.57991 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45242 0.57991 moveto
0.45602 0.58269 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.39093 0.52785 moveto
0.40463 0.51971 lineto
stroke
grestore
gsave
0.59052 0.41391 moveto 0.63383 0.48233 lineto 0.58162 0.4255 lineto 0.598 0.553 0.775 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.57457 0.43945 moveto
0.58162 0.4255 lineto
stroke
grestore
gsave
0.66943 0.41619 moveto 0.68945 0.48493 lineto 0.66762 0.48569 lineto 0.74 0.73 0.843 setrgbcolor
fill
grestore
gsave
0.68358 0.42076 moveto 0.68945 0.48493 lineto 0.66943 0.41619 lineto 0.477 0.562 0.863 setrgbcolor
fill
grestore
gsave
0.68358 0.42076 moveto 0.71414 0.48213 lineto 0.68945 0.48493 lineto 0.689 0.728 0.88 setrgbcolor
fill
grestore
gsave
0.34459 0.62886 moveto 0.3716 0.69376 lineto 0.35289 0.71088 lineto 0.933 0.794 0.684 setrgbcolor
fill
grestore
gsave
0.3526 0.61593 moveto 0.3716 0.69376 lineto 0.34459 0.62886 lineto 0.936 0.794 0.679 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3526 0.61593 moveto
0.35468 0.61904 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35468 0.61904 moveto
0.39081 0.67303 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3716 0.69376 moveto
0.39081 0.67303 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36064 0.60295 moveto
0.37983 0.62217 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35943 0.60175 moveto
0.36064 0.60295 lineto
stroke
grestore
gsave
0.69641 0.42338 moveto 0.71414 0.48213 lineto 0.68358 0.42076 lineto 0.407 0.569 0.901 setrgbcolor
fill
grestore
gsave
0.69641 0.42338 moveto 0.73901 0.47794 lineto 0.71414 0.48213 lineto 0.621 0.716 0.914 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68945 0.48493 moveto
0.71414 0.48213 lineto
stroke
grestore
gsave
0.59052 0.41391 moveto 0.63138 0.47851 lineto 0.63383 0.48233 lineto 0.602 0.183 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63383 0.48233 moveto
0.63532 0.4895 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58162 0.4255 moveto
0.63383 0.48233 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44546 0.57667 moveto
0.44975 0.58051 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43961 0.57144 moveto
0.44546 0.57667 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43259 0.56515 moveto
0.43961 0.57144 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39093 0.52785 moveto
0.43259 0.56515 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.44975 0.58051 moveto
0.45242 0.57991 lineto
stroke
grestore
gsave
0.65485 0.41056 moveto 0.66762 0.48569 lineto 0.65043 0.48441 lineto 0.779 0.726 0.803 setrgbcolor
fill
grestore
gsave
0.66943 0.41619 moveto 0.66762 0.48569 lineto 0.65485 0.41056 lineto 0.529 0.552 0.823 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66762 0.48569 moveto
0.68945 0.48493 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66943 0.41619 moveto
0.68945 0.48493 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.38011 0.53917 moveto
0.39093 0.52785 lineto
stroke
grestore
gsave
0.60122 0.40574 moveto 0.63138 0.47851 lineto 0.59052 0.41391 lineto 0.56 0.506 0.752 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.58162 0.4255 moveto
0.59052 0.41391 lineto
stroke
grestore
gsave
0.70685 0.42352 moveto 0.73901 0.47794 lineto 0.69641 0.42338 lineto 0.341 0.578 0.929 setrgbcolor
fill
grestore
gsave
0.70685 0.42352 moveto 0.76093 0.4732 lineto 0.73901 0.47794 lineto 0.526 0.69 0.943 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70243 0.4586 moveto
0.71414 0.48213 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68358 0.42076 moveto
0.70243 0.4586 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.71414 0.48213 moveto
0.73901 0.47794 lineto
stroke
grestore
gsave
0.64045 0.40523 moveto 0.65043 0.48441 lineto 0.63864 0.48182 lineto 0.81 0.715 0.761 setrgbcolor
fill
grestore
gsave
0.65485 0.41056 moveto 0.65043 0.48441 lineto 0.64045 0.40523 lineto 0.557 0.534 0.785 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65043 0.48441 moveto
0.66762 0.48569 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65485 0.41056 moveto
0.66762 0.48569 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.37232 0.55296 moveto
0.38011 0.53917 lineto
stroke
grestore
gsave
0.60122 0.40574 moveto 0.6302 0.4777 lineto 0.63138 0.47851 lineto 0.858 0.495 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63138 0.47851 moveto
0.63383 0.48233 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59052 0.41391 moveto
0.62902 0.47477 lineto
stroke
grestore
gsave
0.61337 0.4017 moveto 0.6302 0.4777 lineto 0.60122 0.40574 lineto 0.546 0.481 0.734 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.59052 0.41391 moveto
0.60122 0.40574 lineto
stroke
grestore
gsave
0.62655 0.40179 moveto 0.63864 0.48182 lineto 0.63216 0.47915 lineto 0.818 0.686 0.719 setrgbcolor
fill
grestore
gsave
0.64045 0.40523 moveto 0.63864 0.48182 lineto 0.62655 0.40179 lineto 0.563 0.509 0.753 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63864 0.48182 moveto
0.65043 0.48441 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60122 0.40574 moveto
0.60521 0.41567 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6313 0.47845 moveto
0.63138 0.47851 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64045 0.40523 moveto
0.65043 0.48441 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.36699 0.56838 moveto
0.37232 0.55296 lineto
stroke
grestore
gsave
0.61337 0.4017 moveto 0.63216 0.47915 lineto 0.6302 0.4777 lineto 0.546 0.481 0.734 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60521 0.41567 moveto
0.6302 0.4777 lineto
stroke
grestore
gsave
0.62655 0.40179 moveto 0.63216 0.47915 lineto 0.61337 0.4017 lineto 0.554 0.486 0.733 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61337 0.4017 moveto
0.61473 0.40732 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61473 0.40732 moveto
0.63216 0.47915 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6302 0.4777 moveto
0.63216 0.47915 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60122 0.40574 moveto
0.61337 0.4017 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62655 0.40179 moveto
0.63864 0.48182 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63216 0.47915 moveto
0.63864 0.48182 lineto
stroke
grestore
gsave
0.33459 0.6386 moveto 0.35289 0.71088 lineto 0.33693 0.72248 lineto 0.968 0.803 0.624 setrgbcolor
fill
grestore
gsave
0.34459 0.62886 moveto 0.35289 0.71088 lineto 0.33459 0.6386 lineto 0.933 0.794 0.684 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34499 0.62982 moveto
0.3716 0.69376 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.35289 0.71088 moveto
0.3716 0.69376 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34459 0.62886 moveto
0.34499 0.62982 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.36288 0.58463 moveto
0.36699 0.56838 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61337 0.4017 moveto
0.62655 0.40179 lineto
stroke
grestore
gsave
0.71407 0.42093 moveto 0.76093 0.4732 lineto 0.70685 0.42352 lineto 0.315 0.597 0.946 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70685 0.42352 moveto
0.70962 0.42607 lineto
stroke
grestore
gsave
0.71407 0.42093 moveto 0.77701 0.46853 lineto 0.76093 0.4732 lineto 0.382 0.634 0.954 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70803 0.43826 moveto
0.73901 0.47794 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69641 0.42338 moveto
0.70803 0.43826 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73901 0.47794 moveto
0.76093 0.4732 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.3585 0.60081 moveto
0.36288 0.58463 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.62655 0.40179 moveto
0.64045 0.40523 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.3526 0.61593 moveto
0.3585 0.60081 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.64045 0.40523 moveto
0.65485 0.41056 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.34459 0.62886 moveto
0.3526 0.61593 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.65485 0.41056 moveto
0.66943 0.41619 lineto
stroke
grestore
gsave
0.3231 0.6445 moveto 0.33693 0.72248 lineto 0.32543 0.72734 lineto 0.996 0.794 0.515 setrgbcolor
fill
grestore
gsave
0.33459 0.6386 moveto 0.33693 0.72248 lineto 0.3231 0.6445 lineto 0.929 0.774 0.668 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33459 0.6386 moveto
0.35289 0.71088 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.33693 0.72248 moveto
0.35289 0.71088 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33459 0.6386 moveto
0.34459 0.62886 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.66943 0.41619 moveto
0.68358 0.42076 lineto
stroke
grestore
gsave
0.71782 0.41551 moveto 0.77701 0.46853 lineto 0.71407 0.42093 lineto 0.332 0.613 0.952 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70962 0.42607 moveto
0.71355 0.42968 lineto
stroke
grestore
gsave
0.71782 0.41551 moveto 0.78534 0.46422 lineto 0.77701 0.46853 lineto 0.152 0.514 0.914 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71355 0.42968 moveto
0.76093 0.4732 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76093 0.4732 moveto
0.77701 0.46853 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68358 0.42076 moveto
0.69641 0.42338 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69641 0.42338 moveto
0.70685 0.42352 lineto
stroke
grestore
gsave
0.3231 0.6445 moveto 0.32543 0.72734 lineto 0.31067 0.6465 lineto 0.929 0.741 0.628 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.3231 0.6445 moveto
0.33459 0.6386 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3231 0.6445 moveto
0.33693 0.72248 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70685 0.42352 moveto
0.71407 0.42093 lineto
stroke
grestore
gsave
0.31067 0.6465 moveto 0.32543 0.72734 lineto 0.31887 0.72538 lineto 0.971 0.72 0.294 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32543 0.72734 moveto
0.33693 0.72248 lineto
stroke
grestore
gsave
0.71861 0.40745 moveto 0.78534 0.46422 lineto 0.71782 0.41551 lineto 0.339 0.598 0.942 setrgbcolor
fill
grestore
gsave
0.71861 0.40745 moveto 0.78538 0.46033 lineto 0.78534 0.46422 lineto 0 0.262 0.735 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71407 0.42093 moveto
0.72399 0.42843 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72399 0.42843 moveto
0.77701 0.46853 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.77701 0.46853 moveto
0.78534 0.46422 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72159 0.41823 moveto
0.78534 0.46422 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71782 0.41551 moveto
0.72159 0.41823 lineto
stroke
grestore
gsave
0.31067 0.6465 moveto 0.31887 0.72538 lineto 0.29757 0.64521 lineto 0.931 0.697 0.562 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.31067 0.6465 moveto
0.3231 0.6445 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31067 0.6465 moveto
0.32543 0.72734 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71407 0.42093 moveto
0.71782 0.41551 lineto
stroke
grestore
gsave
0.29757 0.64521 moveto 0.31634 0.71791 lineto 0.28391 0.6419 lineto 0.927 0.635 0.47 setrgbcolor
fill
grestore
gsave
0.31634 0.71791 moveto 0.2977 0.64572 lineto 0.31887 0.72538 lineto 0.727 0.446 0 setrgbcolor
fill
grestore
gsave
0.31887 0.72538 moveto 0.2977 0.64572 lineto 0.29765 0.64549 lineto 0.727 0.446 0 setrgbcolor
fill
grestore
gsave
0.28391 0.6419 moveto 0.31634 0.71791 lineto 0.31604 0.70744 lineto 0 0.026 0.593 setrgbcolor
fill
grestore
gsave
0.28391 0.6419 moveto 0.30997 0.69505 lineto 0.2699 0.63824 lineto 0.906 0.552 0.359 setrgbcolor
fill
grestore
gsave
0.31604 0.70744 moveto 0.31127 0.70028 lineto 0.30997 0.69505 lineto 0.906 0.552 0.359 setrgbcolor
fill
grestore
gsave
0.2699 0.63824 moveto 0.30997 0.69505 lineto 0.31127 0.70028 lineto 0.906 0.552 0.359 setrgbcolor
fill
grestore
gsave
0.29757 0.64521 moveto 0.29765 0.64549 lineto 0.2977 0.64572 lineto 0.727 0.446 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.29757 0.64521 moveto
0.31067 0.6465 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29757 0.64521 moveto
0.29765 0.64549 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29765 0.64549 moveto
0.31181 0.6988 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31628 0.71563 moveto
0.31887 0.72538 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31887 0.72538 moveto
0.32543 0.72734 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.28391 0.6419 moveto
0.29757 0.64521 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31634 0.71791 moveto
0.31887 0.72538 lineto
stroke
grestore
gsave
0.71758 0.39734 moveto 0.78538 0.46033 lineto 0.71861 0.40745 lineto 0.295 0.54 0.915 setrgbcolor
fill
grestore
gsave
0.71758 0.39734 moveto 0.77814 0.4569 lineto 0.78538 0.46033 lineto 0.655 0.137 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78534 0.46422 moveto
0.78538 0.46033 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71782 0.41551 moveto
0.71861 0.40745 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71861 0.40745 moveto
0.76612 0.44508 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30447 0.69009 moveto
0.31634 0.71791 lineto
stroke
grestore
gsave
0.2699 0.63824 moveto 0.31604 0.70744 lineto 0.31615 0.69703 lineto 0.216 0.355 0.79 setrgbcolor
fill
grestore
gsave
0.2699 0.63824 moveto 0.31615 0.69703 lineto 0.25621 0.63586 lineto 0.869 0.463 0.258 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29409 0.67452 moveto
0.31604 0.70744 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2699 0.63824 moveto
0.28391 0.6419 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31604 0.70744 moveto
0.31634 0.71791 lineto
stroke
grestore
gsave
0.71599 0.3863 moveto 0.77814 0.4569 lineto 0.71758 0.39734 lineto 0.178 0.428 0.862 setrgbcolor
fill
grestore
gsave
0.71599 0.3863 moveto 0.76588 0.4541 lineto 0.77814 0.4569 lineto 0.888 0.461 0.148 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.77814 0.4569 moveto
0.78538 0.46033 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71758 0.39734 moveto
0.71861 0.40745 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71758 0.39734 moveto
0.74126 0.42063 lineto
stroke
grestore
gsave
0.25621 0.63586 moveto 0.31615 0.69703 lineto 0.31543 0.68949 lineto 0.414 0.516 0.853 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31604 0.70744 moveto
0.31615 0.69703 lineto
stroke
grestore
gsave
0.25621 0.63586 moveto 0.31543 0.68949 lineto 0.24407 0.63598 lineto 0.836 0.405 0.21 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.25621 0.63586 moveto
0.2699 0.63824 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29029 0.67064 moveto
0.31615 0.69703 lineto
stroke
grestore
gsave
0.71477 0.37582 moveto 0.76588 0.4541 lineto 0.71599 0.3863 lineto 0 0.241 0.754 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.71599 0.3863 moveto
0.71758 0.39734 lineto
stroke
grestore
gsave
0.24407 0.63598 moveto 0.31543 0.68949 lineto 0.31329 0.68686 lineto 0.136 0.478 0.898 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31543 0.68949 moveto
0.31615 0.69703 lineto
stroke
grestore
gsave
0.71477 0.37582 moveto 0.75158 0.45216 lineto 0.76588 0.4541 lineto 0.925 0.613 0.433 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76588 0.4541 moveto
0.77814 0.4569 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71599 0.3863 moveto
0.7271 0.40138 lineto
stroke
grestore
gsave
0.23489 0.63916 moveto 0.31329 0.68686 lineto 0.30951 0.6903 lineto 0.797 0.633 0.679 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.31267 0.68742 moveto
0.31543 0.68949 lineto
stroke
grestore
gsave
0.24407 0.63598 moveto 0.31329 0.68686 lineto 0.23489 0.63916 lineto 0.83 0.402 0.219 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31329 0.68686 moveto
0.31543 0.68949 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.24407 0.63598 moveto
0.25621 0.63586 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.31148 0.68851 moveto
0.31329 0.68686 lineto
stroke
grestore
gsave
0.2298 0.64534 moveto 0.30951 0.6903 lineto 0.30411 0.70007 lineto 0.821 0.678 0.705 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.3132 0.68681 moveto
0.31329 0.68686 lineto
stroke
grestore
gsave
0.23489 0.63916 moveto 0.30951 0.6903 lineto 0.2298 0.64534 lineto 0.847 0.429 0.239 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30951 0.6903 moveto
0.31148 0.68851 lineto
stroke
grestore
gsave
0.2291 0.65414 moveto 0.30411 0.70007 lineto 0.29735 0.71562 lineto 0.864 0.704 0.682 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30636 0.68265 moveto
0.3132 0.68681 lineto
stroke
grestore
gsave
0.2298 0.64534 moveto 0.30411 0.70007 lineto 0.2291 0.65414 lineto 0.872 0.454 0.223 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30142 0.68573 moveto
0.30951 0.6903 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30411 0.70007 moveto
0.30951 0.6903 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.30268 0.69919 moveto
0.30411 0.70007 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23489 0.63916 moveto
0.24792 0.64708 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.23489 0.63916 moveto
0.24407 0.63598 lineto
stroke
grestore
gsave
0.23215 0.66505 moveto 0.29735 0.71562 lineto 0.28982 0.73563 lineto 0.91 0.725 0.639 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29763 0.67733 moveto
0.30636 0.68265 lineto
stroke
grestore
gsave
0.2291 0.65414 moveto 0.29735 0.71562 lineto 0.23215 0.66505 lineto 0.885 0.456 0.142 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29312 0.68106 moveto
0.30142 0.68573 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.29057 0.69178 moveto
0.30268 0.69919 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.29735 0.71562 moveto
0.30411 0.70007 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2291 0.65414 moveto
0.23087 0.65522 lineto
stroke
grestore
gsave
0.71424 0.36758 moveto 0.75158 0.45216 lineto 0.71477 0.37582 lineto 0 0 0.559 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.71477 0.37582 moveto
0.71599 0.3863 lineto
stroke
grestore
gsave
0.71424 0.36758 moveto 0.73835 0.45133 lineto 0.75158 0.45216 lineto 0.9 0.675 0.589 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75158 0.45216 moveto
0.76588 0.4541 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71477 0.37582 moveto
0.71933 0.38529 lineto
stroke
grestore
gsave
0.23759 0.67747 moveto 0.28982 0.73563 lineto 0.28246 0.75799 lineto 0.955 0.74 0.573 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28349 0.67562 moveto
0.29312 0.68106 lineto
stroke
grestore
gsave
0.23215 0.66505 moveto 0.28982 0.73563 lineto 0.23759 0.67747 lineto 0.851 0.415 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2298 0.64534 moveto
0.28349 0.67562 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2815 0.68623 moveto
0.29057 0.69178 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2809 0.70286 moveto
0.29735 0.71562 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28982 0.73563 moveto
0.29735 0.71562 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23343 0.66604 moveto
0.23428 0.6667 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23215 0.66505 moveto
0.23343 0.66604 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24792 0.64708 moveto
0.29763 0.67733 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2298 0.64534 moveto
0.23489 0.63916 lineto
stroke
grestore
gsave
0.71436 0.36313 moveto 0.73835 0.45133 lineto 0.71424 0.36758 lineto 0 0 0.327 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.71424 0.36758 moveto
0.71477 0.37582 lineto
stroke
grestore
gsave
0.71436 0.36313 moveto 0.72885 0.45178 lineto 0.73744 0.448 lineto 0.87 0.708 0.679 setrgbcolor
fill
grestore
gsave
0.71504 0.36351 moveto 0.72885 0.45178 lineto 0.71436 0.36313 lineto 0 0 0.181 setrgbcolor
fill
grestore
gsave
0.71504 0.36351 moveto 0.72494 0.4535 lineto 0.72885 0.45178 lineto 0.882 0.758 0.721 setrgbcolor
fill
grestore
gsave
0.72495 0.45359 moveto 0.72885 0.45178 lineto 0.72494 0.4535 lineto 0.882 0.758 0.721 setrgbcolor
fill
grestore
gsave
0.73835 0.45133 moveto 0.73744 0.448 lineto 0.72885 0.45178 lineto 0.87 0.708 0.679 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.71424 0.36758 moveto
0.71436 0.36313 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73835 0.45133 moveto
0.75158 0.45216 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71424 0.36758 moveto
0.71479 0.3695 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71479 0.3695 moveto
0.7162 0.3744 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72885 0.45178 moveto
0.73835 0.45133 lineto
stroke
grestore
gsave
0.24382 0.6906 moveto 0.28246 0.75799 lineto 0.27648 0.78004 lineto 0.989 0.743 0.463 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27172 0.69574 moveto
0.2809 0.70286 lineto
stroke
grestore
gsave
0.23759 0.67747 moveto 0.28246 0.75799 lineto 0.24382 0.6906 lineto 0.717 0.32 0 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27251 0.71635 moveto
0.28982 0.73563 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28246 0.75799 moveto
0.28982 0.73563 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23811 0.67805 moveto
0.2392 0.67927 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23759 0.67747 moveto
0.23811 0.67805 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23087 0.65522 moveto
0.2815 0.68623 lineto
stroke
grestore
gsave
0.71639 0.36898 moveto 0.72495 0.45359 lineto 0.71504 0.36351 lineto 0 0 0.164 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71436 0.36313 moveto
0.71631 0.37507 lineto
stroke
grestore
gsave
0.71639 0.36898 moveto 0.72754 0.45672 lineto 0.72495 0.45359 lineto 0.423 0.461 0.795 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72702 0.45263 moveto
0.72885 0.45178 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72494 0.4535 moveto
0.72495 0.45359 lineto
stroke
grestore
gsave
0.71872 0.37888 moveto 0.72754 0.45672 lineto 0.71639 0.36898 lineto 0 0 0.212 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71504 0.36351 moveto
0.71668 0.37847 lineto
stroke
grestore
gsave
0.71872 0.37888 moveto 0.73658 0.46091 lineto 0.72754 0.45672 lineto 0.568 0.618 0.862 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72495 0.45359 moveto
0.72754 0.45672 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2291 0.65414 moveto
0.2298 0.64534 lineto
stroke
grestore
gsave
0.7222 0.39184 moveto 0.75104 0.46588 lineto 0.73658 0.46091 lineto 0.5 0.62 0.901 setrgbcolor
fill
grestore
gsave
0.7265 0.4062 moveto 0.73877 0.43604 lineto 0.7222 0.39184 lineto 0.76 0.435 0 setrgbcolor
fill
grestore
gsave
0.73877 0.43604 moveto 0.74312 0.44663 lineto 0.73867 0.43412 lineto 0.76 0.435 0 setrgbcolor
fill
grestore
gsave
0.73867 0.43412 moveto 0.74312 0.44663 lineto 0.74406 0.44796 lineto 0.76 0.435 0 setrgbcolor
fill
grestore
gsave
0.75104 0.46588 moveto 0.74406 0.44796 lineto 0.74312 0.44663 lineto 0.76 0.435 0 setrgbcolor
fill
grestore
gsave
0.7222 0.39184 moveto 0.73877 0.43604 lineto 0.73867 0.43412 lineto 0.76 0.435 0 setrgbcolor
fill
grestore
gsave
0.7265 0.4062 moveto 0.7688 0.4716 lineto 0.75104 0.46588 lineto 0.359 0.582 0.927 setrgbcolor
fill
grestore
gsave
0.73066 0.42053 moveto 0.75774 0.45679 lineto 0.7265 0.4062 lineto 0.888 0.512 0.046 setrgbcolor
fill
grestore
gsave
0.7688 0.4716 moveto 0.76157 0.46043 lineto 0.75774 0.45679 lineto 0.888 0.512 0.046 setrgbcolor
fill
grestore
gsave
0.7265 0.4062 moveto 0.75774 0.45679 lineto 0.76157 0.46043 lineto 0.888 0.512 0.046 setrgbcolor
fill
grestore
gsave
0.73066 0.42053 moveto 0.78672 0.47849 lineto 0.7688 0.4716 lineto 0.104 0.471 0.893 setrgbcolor
fill
grestore
gsave
0.7332 0.43378 moveto 0.78672 0.47849 lineto 0.73066 0.42053 lineto 0.93 0.547 0.208 setrgbcolor
fill
grestore
gsave
0.78672 0.47849 moveto 0.73559 0.43578 lineto 0.80101 0.48721 lineto 0 0.216 0.677 setrgbcolor
fill
grestore
gsave
0.7354 0.43563 moveto 0.73553 0.43573 lineto 0.73559 0.43578 lineto 0 0.216 0.677 setrgbcolor
fill
grestore
gsave
0.80101 0.48721 moveto 0.73559 0.43578 lineto 0.73553 0.43573 lineto 0 0.216 0.677 setrgbcolor
fill
grestore
gsave
0.7332 0.43378 moveto 0.73524 0.43539 lineto 0.7354 0.43563 lineto 0 0.216 0.677 setrgbcolor
fill
grestore
gsave
0.80101 0.48721 moveto 0.7354 0.43563 lineto 0.73524 0.43539 lineto 0 0.216 0.677 setrgbcolor
fill
grestore
gsave
0.80101 0.48721 moveto 0.7395 0.4494 lineto 0.80797 0.49811 lineto 0.664 0.12 0 setrgbcolor
fill
grestore
gsave
0.73704 0.4479 moveto 0.73951 0.44964 lineto 0.7395 0.4494 lineto 0.664 0.12 0 setrgbcolor
fill
grestore
gsave
0.80797 0.49811 moveto 0.7395 0.4494 lineto 0.73951 0.44964 lineto 0.664 0.12 0 setrgbcolor
fill
grestore
gsave
0.73658 0.46091 moveto 0.72878 0.42506 lineto 0.72958 0.42727 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.73262 0.44518 moveto 0.73723 0.44842 lineto 0.73704 0.4479 lineto 0.664 0.12 0 setrgbcolor
fill
grestore
gsave
0.80797 0.49811 moveto 0.73704 0.4479 lineto 0.73723 0.44842 lineto 0.664 0.12 0 setrgbcolor
fill
grestore
gsave
0.7222 0.39184 moveto 0.72958 0.42727 lineto 0.71872 0.37888 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.71872 0.37888 moveto 0.72958 0.42727 lineto 0.72878 0.42506 lineto 0 0 0.222 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73573 0.45699 moveto
0.73658 0.46091 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73418 0.44989 moveto
0.73573 0.45699 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73238 0.4416 moveto
0.73324 0.44556 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73326 0.44562 moveto
0.73418 0.44989 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71872 0.37888 moveto
0.71912 0.38069 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71912 0.38069 moveto
0.73238 0.4416 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72754 0.45672 moveto
0.73658 0.46091 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7275 0.45637 moveto
0.72754 0.45672 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72701 0.45248 moveto
0.7275 0.45637 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71703 0.37395 moveto
0.72701 0.45248 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71639 0.36898 moveto
0.71703 0.37395 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71668 0.37847 moveto
0.72494 0.4535 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73658 0.46091 moveto
0.75104 0.46588 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7222 0.39184 moveto
0.72974 0.41121 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75104 0.46588 moveto
0.7688 0.4716 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71436 0.36313 moveto
0.71504 0.36351 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.7688 0.4716 moveto
0.77196 0.47281 lineto
stroke
grestore
gsave
0.24382 0.6906 moveto 0.27648 0.78004 lineto 0.24955 0.70325 lineto 0 0 0.368 setrgbcolor
fill
grestore
gsave
0.24955 0.70325 moveto 0.27648 0.78004 lineto 0.27334 0.79869 lineto 0.966 0.695 0.268 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27648 0.78004 moveto
0.28246 0.75799 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26518 0.72786 moveto
0.28246 0.75799 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2632 0.70599 moveto
0.27251 0.71635 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2392 0.67927 moveto
0.2632 0.70599 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24382 0.6906 moveto
0.2449 0.69248 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.23428 0.6667 moveto
0.27172 0.69574 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2291 0.65414 moveto
0.23215 0.66505 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71504 0.36351 moveto
0.71639 0.36898 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.77128 0.46253 moveto
0.77641 0.46783 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73066 0.42053 moveto
0.73086 0.42074 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.23215 0.66505 moveto
0.23759 0.67747 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.23759 0.67747 moveto
0.24382 0.6906 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71639 0.36898 moveto
0.71872 0.37888 lineto
stroke
grestore
gsave
0.24955 0.70325 moveto 0.27334 0.79869 lineto 0.2541 0.71387 lineto 0 0 0.386 setrgbcolor
fill
grestore
gsave
0.2541 0.71387 moveto 0.27334 0.79869 lineto 0.2745 0.81098 lineto 0.769 0.51 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.27334 0.79869 moveto
0.27648 0.78004 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25532 0.71067 moveto
0.26518 0.72786 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2449 0.69248 moveto
0.24504 0.69273 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.24504 0.69273 moveto
0.25532 0.71067 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25859 0.72903 moveto
0.27648 0.78004 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25561 0.72054 moveto
0.25859 0.72903 lineto
stroke
grestore
gsave
0.73262 0.44518 moveto 0.80101 0.48721 lineto 0.7332 0.43378 lineto 0.913 0.538 0.3 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73337 0.43392 moveto
0.73524 0.43539 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7332 0.43378 moveto
0.73337 0.43392 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7265 0.4062 moveto
0.74609 0.43648 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.24382 0.6906 moveto
0.24955 0.70325 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.71872 0.37888 moveto
0.7222 0.39184 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7222 0.39184 moveto
0.7265 0.4062 lineto
stroke
grestore
gsave
0.25738 0.72086 moveto 0.2745 0.81098 lineto 0.28093 0.81463 lineto 0 0 0.433 setrgbcolor
fill
grestore
gsave
0.2541 0.71387 moveto 0.2745 0.81098 lineto 0.25738 0.72086 lineto 0 0 0.34 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.24955 0.70325 moveto
0.2541 0.71387 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7265 0.4062 moveto
0.73066 0.42053 lineto
stroke
grestore
gsave
0.7279 0.45398 moveto 0.80797 0.49811 lineto 0.73262 0.44518 lineto 0.881 0.507 0.328 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73262 0.44518 moveto
0.7387 0.44945 lineto
stroke
grestore
gsave
0.7279 0.45398 moveto 0.80496 0.51072 lineto 0.80797 0.49811 lineto 0.821 0.351 0.093 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73524 0.43539 moveto
0.76971 0.46255 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76971 0.46255 moveto
0.80101 0.48721 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73086 0.42074 moveto
0.75298 0.44361 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75298 0.44361 moveto
0.77128 0.46253 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.80101 0.48721 moveto
0.80797 0.49811 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.73066 0.42053 moveto
0.7332 0.43378 lineto
stroke
grestore
gsave
0.25738 0.72086 moveto 0.28093 0.81463 lineto 0.25958 0.72309 lineto 0 0 0.325 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.2541 0.71387 moveto
0.25738 0.72086 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25738 0.72086 moveto
0.2745 0.81098 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.73262 0.44518 moveto
0.7332 0.43378 lineto
stroke
grestore
gsave
0.25958 0.72309 moveto 0.28093 0.81463 lineto 0.29238 0.80881 lineto 0.084 0.162 0.648 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.2745 0.81098 moveto
0.28093 0.81463 lineto
stroke
grestore
gsave
0.25958 0.72309 moveto 0.29238 0.80881 lineto 0.26079 0.7202 lineto 0 0 0.424 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.25738 0.72086 moveto
0.25958 0.72309 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25958 0.72309 moveto
0.28093 0.81463 lineto
stroke
grestore
gsave
0.71885 0.45952 moveto 0.80496 0.51072 lineto 0.7279 0.45398 lineto 0.859 0.475 0.315 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7279 0.45398 moveto
0.73202 0.45702 lineto
stroke
grestore
gsave
0.71885 0.45952 moveto 0.79119 0.5237 lineto 0.80496 0.51072 lineto 0.859 0.475 0.315 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7387 0.44945 moveto
0.80797 0.49811 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.80496 0.51072 moveto
0.80797 0.49811 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73202 0.45702 moveto
0.80496 0.51072 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.7279 0.45398 moveto
0.73262 0.44518 lineto
stroke
grestore
gsave
0.26079 0.7202 moveto 0.30707 0.79456 lineto 0.26094 0.71273 lineto 0 0.055 0.621 setrgbcolor
fill
grestore
gsave
0.26079 0.7202 moveto 0.29238 0.80881 lineto 0.30707 0.79456 lineto 0.357 0.361 0.727 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.25958 0.72309 moveto
0.26079 0.7202 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26079 0.7202 moveto
0.29238 0.80881 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.28093 0.81463 moveto
0.29238 0.80881 lineto
stroke
grestore
gsave
0.70615 0.4614 moveto 0.79119 0.5237 lineto 0.71885 0.45952 lineto 0.859 0.467 0.299 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.71885 0.45952 moveto
0.7279 0.45398 lineto
stroke
grestore
gsave
0.70615 0.4614 moveto 0.76806 0.53522 lineto 0.79119 0.5237 lineto 0.858 0.545 0.458 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.79119 0.5237 moveto
0.80496 0.51072 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71885 0.45952 moveto
0.79119 0.5237 lineto
stroke
grestore
gsave
0.26094 0.71273 moveto 0.32208 0.77469 lineto 0.25994 0.70194 lineto 0.045 0.317 0.802 setrgbcolor
fill
grestore
gsave
0.26094 0.71273 moveto 0.30707 0.79456 lineto 0.32208 0.77469 lineto 0.522 0.478 0.748 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.26079 0.7202 moveto
0.26094 0.71273 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26094 0.71273 moveto
0.30707 0.79456 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.29238 0.80881 moveto
0.30707 0.79456 lineto
stroke
grestore
gsave
0.25994 0.70194 moveto 0.3345 0.75298 lineto 0.2581 0.6895 lineto 0.268 0.51 0.901 setrgbcolor
fill
grestore
gsave
0.25994 0.70194 moveto 0.32208 0.77469 lineto 0.3345 0.75298 lineto 0.63 0.551 0.747 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.25994 0.70194 moveto
0.26094 0.71273 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25994 0.70194 moveto
0.32208 0.77469 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.30707 0.79456 moveto
0.32208 0.77469 lineto
stroke
grestore
gsave
0.69106 0.45988 moveto 0.76806 0.53522 lineto 0.70615 0.4614 lineto 0.883 0.507 0.325 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.70615 0.4614 moveto
0.71885 0.45952 lineto
stroke
grestore
gsave
0.69106 0.45988 moveto 0.73875 0.54379 lineto 0.76806 0.53522 lineto 0.84 0.59 0.56 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76806 0.53522 moveto
0.79119 0.5237 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70615 0.4614 moveto
0.76806 0.53522 lineto
stroke
grestore
gsave
0.2581 0.6895 moveto 0.3345 0.75298 lineto 0.34264 0.73312 lineto 0.706 0.603 0.739 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.32208 0.77469 moveto
0.3345 0.75298 lineto
stroke
grestore
gsave
0.25645 0.67707 moveto 0.34264 0.73312 lineto 0.34642 0.71793 lineto 0.764 0.644 0.73 setrgbcolor
fill
grestore
gsave
0.2581 0.6895 moveto 0.34264 0.73312 lineto 0.25645 0.67707 lineto 0.402 0.628 0.945 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.3345 0.75298 moveto
0.34264 0.73312 lineto
stroke
grestore
gsave
0.25666 0.66601 moveto 0.34642 0.71793 lineto 0.34699 0.7091 lineto 0.803 0.689 0.739 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34161 0.73245 moveto
0.34264 0.73312 lineto
stroke
grestore
gsave
0.25645 0.67707 moveto 0.34642 0.71793 lineto 0.25666 0.66601 lineto 0.462 0.694 0.967 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34264 0.73312 moveto
0.34642 0.71793 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34346 0.71622 moveto
0.34642 0.71793 lineto
stroke
grestore
gsave
0.26051 0.65724 moveto 0.34699 0.7091 lineto 0.34603 0.70721 lineto 0.451 0.714 0.98 setrgbcolor
fill
grestore
gsave
0.25666 0.66601 moveto 0.34699 0.7091 lineto 0.26051 0.65724 lineto 0.468 0.72 0.979 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34642 0.71793 moveto
0.34699 0.7091 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34514 0.70798 moveto
0.34699 0.7091 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25708 0.66625 moveto
0.25953 0.66767 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25666 0.66601 moveto
0.25708 0.66625 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25645 0.67707 moveto
0.25679 0.67729 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.2581 0.6895 moveto
0.25994 0.70194 lineto
stroke
grestore
gsave
0.26051 0.65724 moveto 0.34603 0.70721 lineto 0.26918 0.65132 lineto 0.451 0.714 0.98 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.27141 0.65293 moveto
0.28017 0.65931 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26918 0.65132 moveto
0.27141 0.65293 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.34603 0.70721 moveto
0.34699 0.7091 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26416 0.65943 moveto
0.26697 0.66111 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26051 0.65724 moveto
0.26416 0.65943 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25953 0.66767 moveto
0.34346 0.71622 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.25679 0.67729 moveto
0.34161 0.73245 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.2581 0.6895 moveto
0.3345 0.75298 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.25645 0.67707 moveto
0.2581 0.6895 lineto
stroke
grestore
gsave
0.6748 0.45608 moveto 0.73875 0.54379 lineto 0.69106 0.45988 lineto 0.913 0.584 0.405 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.69106 0.45988 moveto
0.70615 0.4614 lineto
stroke
grestore
gsave
0.6748 0.45608 moveto 0.70741 0.54875 lineto 0.73875 0.54379 lineto 0.812 0.619 0.641 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73875 0.54379 moveto
0.76806 0.53522 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69106 0.45988 moveto
0.73875 0.54379 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.25645 0.67707 moveto
0.25666 0.66601 lineto
stroke
grestore
gsave
0.65814 0.45186 moveto 0.70741 0.54875 lineto 0.6748 0.45608 lineto 0.931 0.663 0.509 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.6748 0.45608 moveto
0.69106 0.45988 lineto
stroke
grestore
gsave
0.65814 0.45186 moveto 0.67809 0.55044 lineto 0.70741 0.54875 lineto 0.774 0.635 0.708 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70741 0.54875 moveto
0.73875 0.54379 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6748 0.45608 moveto
0.70741 0.54875 lineto
stroke
grestore
gsave
0.59253 0.46727 moveto 0.62432 0.55123 lineto 0.62714 0.54884 lineto 0.716 0.758 0.886 setrgbcolor
fill
grestore
gsave
0.57933 0.48297 moveto 0.62432 0.55123 lineto 0.59253 0.46727 lineto 0.916 0.841 0.755 setrgbcolor
fill
grestore
gsave
0.57933 0.48297 moveto 0.6268 0.55712 lineto 0.62432 0.55123 lineto 0.851 0.467 0 setrgbcolor
fill
grestore
gsave
0.60789 0.45623 moveto 0.62714 0.54884 lineto 0.63679 0.5489 lineto 0.605 0.647 0.865 setrgbcolor
fill
grestore
gsave
0.59253 0.46727 moveto 0.62714 0.54884 lineto 0.60789 0.45623 lineto 0.912 0.833 0.754 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62432 0.55123 moveto
0.62714 0.54884 lineto
stroke
grestore
gsave
0.56886 0.50218 moveto 0.6268 0.55712 lineto 0.57933 0.48297 lineto 0.916 0.826 0.743 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59253 0.46727 moveto
0.5958 0.47592 lineto
stroke
grestore
gsave
0.56886 0.50218 moveto 0.63226 0.56718 lineto 0.6268 0.55712 lineto 0.838 0.392 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62432 0.55123 moveto
0.6268 0.55712 lineto
stroke
grestore
gsave
0.64132 0.44933 moveto 0.67809 0.55044 lineto 0.65814 0.45186 lineto 0.931 0.727 0.605 setrgbcolor
fill
grestore
gsave
0.64132 0.44933 moveto 0.65393 0.54997 lineto 0.67809 0.55044 lineto 0.725 0.641 0.765 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.65814 0.45186 moveto
0.6748 0.45608 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67809 0.55044 moveto
0.70741 0.54875 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65814 0.45186 moveto
0.67809 0.55044 lineto
stroke
grestore
gsave
0.62444 0.45037 moveto 0.63679 0.5489 lineto 0.65393 0.54997 lineto 0.664 0.641 0.817 setrgbcolor
fill
grestore
gsave
0.60789 0.45623 moveto 0.63679 0.5489 lineto 0.62444 0.45037 lineto 0.913 0.809 0.73 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62714 0.54884 moveto
0.63679 0.5489 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60789 0.45623 moveto
0.61435 0.48728 lineto
stroke
grestore
gsave
0.62444 0.45037 moveto 0.65393 0.54997 lineto 0.64132 0.44933 lineto 0.921 0.773 0.68 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64132 0.44933 moveto
0.65393 0.54997 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63679 0.5489 moveto
0.65393 0.54997 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62444 0.45037 moveto
0.62463 0.45183 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62578 0.54227 moveto
0.62714 0.54884 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65393 0.54997 moveto
0.67809 0.55044 lineto
stroke
grestore
gsave
0.56069 0.52345 moveto 0.63226 0.56718 lineto 0.56886 0.50218 lineto 0.901 0.793 0.731 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57933 0.48297 moveto
0.58143 0.48625 lineto
stroke
grestore
gsave
0.56069 0.52345 moveto 0.63757 0.5818 lineto 0.63226 0.56718 lineto 0.898 0.486 0.196 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6268 0.55712 moveto
0.63226 0.56718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62594 0.55578 moveto
0.6268 0.55712 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62671 0.56148 moveto
0.63226 0.56718 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63546 0.5383 moveto
0.63679 0.5489 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.25666 0.66601 moveto
0.26051 0.65724 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.64132 0.44933 moveto
0.65814 0.45186 lineto
stroke
grestore
gsave
0.32739 0.62351 moveto 0.39495 0.68649 lineto 0.39624 0.6902 lineto 0.805 0.336 0 setrgbcolor
fill
grestore
gsave
0.55344 0.54539 moveto 0.63757 0.5818 lineto 0.56069 0.52345 lineto 0.871 0.751 0.727 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56069 0.52345 moveto
0.56957 0.53019 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56886 0.50218 moveto
0.56967 0.50301 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56967 0.50301 moveto
0.59543 0.52942 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61435 0.48728 moveto
0.62578 0.54227 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62463 0.45183 moveto
0.63546 0.5383 lineto
stroke
grestore
gsave
0.55344 0.54539 moveto 0.63903 0.60112 lineto 0.63757 0.5818 lineto 0.891 0.538 0.37 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62274 0.54707 moveto
0.62432 0.55123 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62326 0.5516 moveto
0.62594 0.55578 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63226 0.56718 moveto
0.63757 0.5818 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63309 0.5784 moveto
0.63757 0.5818 lineto
stroke
grestore
gsave
0.32739 0.62351 moveto 0.39624 0.6902 lineto 0.34505 0.61779 lineto 0.636 0.753 0.933 setrgbcolor
fill
grestore
gsave
0.34505 0.61779 moveto 0.39624 0.6902 lineto 0.40123 0.69847 lineto 0.652 0.216 0 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.39495 0.68649 moveto
0.39624 0.6902 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.26697 0.66111 moveto
0.34514 0.70798 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39239 0.6841 moveto
0.39495 0.68649 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39106 0.68287 moveto
0.39239 0.6841 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.26051 0.65724 moveto
0.26918 0.65132 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.62444 0.45037 moveto
0.64132 0.44933 lineto
stroke
grestore
gsave
0.36605 0.61558 moveto 0.40123 0.69847 lineto 0.41181 0.70907 lineto 0 0.131 0.679 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38971 0.68096 moveto
0.39624 0.6902 lineto
stroke
grestore
gsave
0.34505 0.61779 moveto 0.40123 0.69847 lineto 0.36605 0.61558 lineto 0.658 0.726 0.899 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.28017 0.65931 moveto
0.34603 0.70721 lineto
stroke
grestore
gsave
0.54522 0.56676 moveto 0.63903 0.60112 lineto 0.55344 0.54539 lineto 0.831 0.705 0.725 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55344 0.54539 moveto
0.55814 0.54845 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59543 0.52942 moveto
0.62671 0.56148 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58143 0.48625 moveto
0.62326 0.5516 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5958 0.47592 moveto
0.62274 0.54707 lineto
stroke
grestore
gsave
0.54522 0.56676 moveto 0.63307 0.62476 lineto 0.63903 0.60112 lineto 0.859 0.56 0.481 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62826 0.57473 moveto
0.63309 0.5784 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63757 0.5818 moveto
0.63903 0.60112 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.60789 0.45623 moveto
0.62444 0.45037 lineto
stroke
grestore
gsave
0.38894 0.61651 moveto 0.41181 0.70907 lineto 0.42935 0.71918 lineto 0.236 0.375 0.801 setrgbcolor
fill
grestore
gsave
0.36605 0.61558 moveto 0.41181 0.70907 lineto 0.38894 0.61651 lineto 0.689 0.697 0.853 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39406 0.68156 moveto
0.40123 0.69847 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.40123 0.69847 moveto
0.41181 0.70907 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36605 0.61558 moveto
0.36707 0.61799 lineto
stroke
grestore
gsave
0.53438 0.58632 moveto 0.63307 0.62476 lineto 0.54522 0.56676 lineto 0.787 0.658 0.721 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54522 0.56676 moveto
0.54617 0.56738 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55814 0.54845 moveto
0.5991 0.57513 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56957 0.53019 moveto
0.62826 0.57473 lineto
stroke
grestore
gsave
0.53438 0.58632 moveto 0.61738 0.65126 lineto 0.63307 0.62476 lineto 0.82 0.567 0.556 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5991 0.57513 moveto
0.6217 0.58984 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6217 0.58984 moveto
0.63903 0.60112 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63307 0.62476 moveto
0.63903 0.60112 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59253 0.46727 moveto
0.60789 0.45623 lineto
stroke
grestore
gsave
0.41255 0.61949 moveto 0.42935 0.71918 lineto 0.45434 0.72572 lineto 0.455 0.48 0.796 setrgbcolor
fill
grestore
gsave
0.38894 0.61651 moveto 0.42935 0.71918 lineto 0.41255 0.61949 lineto 0.715 0.667 0.801 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.41181 0.70907 moveto
0.42935 0.71918 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38894 0.61651 moveto
0.38952 0.61884 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38952 0.61884 moveto
0.38967 0.61946 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.38967 0.61946 moveto
0.41181 0.70907 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36707 0.61799 moveto
0.39406 0.68156 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.57933 0.48297 moveto
0.59253 0.46727 lineto
stroke
grestore
gsave
0.52004 0.6028 moveto 0.61738 0.65126 lineto 0.53438 0.58632 lineto 0.746 0.611 0.708 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53438 0.58632 moveto
0.53692 0.58831 lineto
stroke
grestore
gsave
0.52004 0.6028 moveto 0.59184 0.6779 lineto 0.61738 0.65126 lineto 0.78 0.566 0.61 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54617 0.56738 moveto
0.60429 0.60576 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60429 0.60576 moveto
0.63307 0.62476 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61738 0.65126 moveto
0.63307 0.62476 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53692 0.58831 moveto
0.61738 0.65126 lineto
stroke
grestore
gsave
0.43617 0.62281 moveto 0.45434 0.72572 lineto 0.48597 0.72586 lineto 0.572 0.524 0.763 setrgbcolor
fill
grestore
gsave
0.41255 0.61949 moveto 0.45434 0.72572 lineto 0.43617 0.62281 lineto 0.73 0.633 0.751 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42935 0.71918 moveto
0.45434 0.72572 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41255 0.61949 moveto
0.42935 0.71918 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56886 0.50218 moveto
0.57933 0.48297 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.56069 0.52345 moveto
0.56886 0.50218 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55344 0.54539 moveto
0.56069 0.52345 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54522 0.56676 moveto
0.55344 0.54539 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.53438 0.58632 moveto
0.54522 0.56676 lineto
stroke
grestore
gsave
0.50223 0.61498 moveto 0.59184 0.6779 lineto 0.52004 0.6028 lineto 0.718 0.572 0.689 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.52004 0.6028 moveto
0.53438 0.58632 lineto
stroke
grestore
gsave
0.45939 0.62433 moveto 0.48597 0.72586 lineto 0.52197 0.71772 lineto 0.644 0.544 0.727 setrgbcolor
fill
grestore
gsave
0.43617 0.62281 moveto 0.48597 0.72586 lineto 0.45939 0.62433 lineto 0.73 0.597 0.707 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.45434 0.72572 moveto
0.48597 0.72586 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43617 0.62281 moveto
0.45434 0.72572 lineto
stroke
grestore
gsave
0.50223 0.61498 moveto 0.55872 0.70114 lineto 0.59184 0.6779 lineto 0.739 0.561 0.653 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.59184 0.6779 moveto
0.61738 0.65126 lineto
stroke
grestore
gsave
0.48169 0.62211 moveto 0.55872 0.70114 lineto 0.50223 0.61498 lineto 0.711 0.554 0.675 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.50223 0.61498 moveto
0.52004 0.6028 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52004 0.6028 moveto
0.52213 0.60498 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52213 0.60498 moveto
0.59184 0.6779 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.32739 0.62351 moveto
0.34505 0.61779 lineto
stroke
grestore
gsave
0.48169 0.62211 moveto 0.52197 0.71772 lineto 0.55872 0.70114 lineto 0.696 0.554 0.69 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.55872 0.70114 moveto
0.59184 0.6779 lineto
stroke
grestore
gsave
0.45939 0.62433 moveto 0.52197 0.71772 lineto 0.48169 0.62211 lineto 0.72 0.566 0.68 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.48597 0.72586 moveto
0.52197 0.71772 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50223 0.61498 moveto
0.55872 0.70114 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46504 0.64589 moveto
0.48597 0.72586 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.46072 0.62939 moveto
0.46504 0.64589 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.48169 0.62211 moveto
0.50223 0.61498 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.48169 0.62211 moveto
0.52197 0.71772 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45939 0.62433 moveto
0.46072 0.62939 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.45939 0.62433 moveto
0.48169 0.62211 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.43617 0.62281 moveto
0.45939 0.62433 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.41255 0.61949 moveto
0.43617 0.62281 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.38894 0.61651 moveto
0.41255 0.61949 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.34505 0.61779 moveto
0.36605 0.61558 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.52197 0.71772 moveto
0.55872 0.70114 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.36605 0.61558 moveto
0.38894 0.61651 lineto
stroke
grestore
gsave
0.002 setlinewidth
0.66295 0.02755 moveto
0.90359 0.41965 lineto
stroke
0.90359 0.41965 moveto
0.97245 0.92345 lineto
stroke
0.97245 0.92345 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.11113 0.25957 moveto
0.02755 0.78701 lineto
stroke
0.02755 0.78701 moveto
0.69507 0.58075 lineto
stroke
0.69507 0.58075 moveto
0.66295 0.02755 lineto
stroke
0.66295 0.02755 moveto
0.11113 0.25957 lineto
stroke
grestore
gsave
grestore
% End of Graphics
MathPictureEnd
:[font = output; inactive; formatted; output; endGroup; nowordwrap; ]
No Input Form was saved for this expression.

















;[o]
-Graphics3D-
:[font = input; startGroup; nowordwrap; ]
Show[%,ViewPoint->{2,1,1.7}]
:[font = postscript; inactive; output; BITMAP; PostScript; pictureLeft = 100; pictureTop = 0; pictureWidth = 280; pictureHeight = 300; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.06741 
MathPictureStart
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0144498 1.09603 0.0274008 1.09603 [
[ 0 0 0 0 ]
[ 1 1.06741 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
%%Object: Graphics3D
[ ] 0 setdash
0 setgray
0 0 moveto
1 0 lineto
1 1.06741 lineto
0 1.06741 lineto
closepath
clip
newpath
gsave
0.002 setlinewidth
0.42581 0.57925 moveto
0.40436 1.04001 lineto
stroke
0.40436 1.04001 moveto
0.9726 0.92449 lineto
stroke
0.9726 0.92449 moveto
0.89182 0.43512 lineto
stroke
0.89182 0.43512 moveto
0.42581 0.57925 lineto
stroke
0.13183 0.256 moveto
0.68597 0.0274 lineto
stroke
0.68597 0.0274 moveto
0.73274 0.56832 lineto
stroke
0.73274 0.56832 moveto
0.0274 0.77364 lineto
stroke
0.0274 0.77364 moveto
0.13183 0.256 lineto
stroke
0.42581 0.57925 moveto
0.40436 1.04001 lineto
stroke
0.40436 1.04001 moveto
0.0274 0.77364 lineto
stroke
0.0274 0.77364 moveto
0.13183 0.256 lineto
stroke
0.13183 0.256 moveto
0.42581 0.57925 lineto
stroke
0.89182 0.43512 moveto
0.68597 0.0274 lineto
stroke
0.68597 0.0274 moveto
0.73274 0.56832 lineto
stroke
0.73274 0.56832 moveto
0.9726 0.92449 lineto
stroke
0.9726 0.92449 moveto
0.89182 0.43512 lineto
stroke
grestore
gsave
0.68329 0.5188 moveto 0.73384 0.51618 lineto 0.68336 0.53563 lineto 0.377 0.306 0.65 setrgbcolor
fill
grestore
gsave
0.68329 0.5188 moveto 0.726 0.51361 lineto 0.73384 0.51618 lineto 0.262 0.674 0.967 setrgbcolor
fill
grestore
gsave
0.68535 0.50209 moveto 0.726 0.51361 lineto 0.68329 0.5188 lineto 0.302 0.248 0.629 setrgbcolor
fill
grestore
gsave
0.68336 0.53563 moveto 0.7469 0.5219 lineto 0.68544 0.55197 lineto 0.453 0.355 0.654 setrgbcolor
fill
grestore
gsave
0.68336 0.53563 moveto 0.73384 0.51618 lineto 0.7469 0.5219 lineto 0.485 0.687 0.957 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.68329 0.5188 moveto
0.68336 0.53563 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68336 0.53563 moveto
0.68406 0.53536 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68329 0.5188 moveto
0.72276 0.514 lineto
stroke
grestore
gsave
0.68535 0.50209 moveto 0.72495 0.51204 lineto 0.726 0.51361 lineto 0.079 0.428 0.871 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72276 0.514 moveto
0.726 0.51361 lineto
stroke
grestore
gsave
0.68968 0.48614 moveto 0.72495 0.51204 lineto 0.68535 0.50209 lineto 0.279 0.223 0.614 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.68329 0.5188 moveto
0.68535 0.50209 lineto
stroke
grestore
gsave
0.68544 0.55197 moveto 0.76275 0.53267 lineto 0.68927 0.56757 lineto 0.513 0.387 0.646 setrgbcolor
fill
grestore
gsave
0.68544 0.55197 moveto 0.7469 0.5219 lineto 0.76275 0.53267 lineto 0.561 0.63 0.877 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72554 0.51938 moveto
0.73384 0.51618 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68336 0.53563 moveto
0.68544 0.55197 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68544 0.55197 moveto
0.68726 0.55108 lineto
stroke
grestore
gsave
0.68927 0.56757 moveto 0.77828 0.54971 lineto 0.69417 0.58275 lineto 0.558 0.41 0.635 setrgbcolor
fill
grestore
gsave
0.68927 0.56757 moveto 0.76275 0.53267 lineto 0.77828 0.54971 lineto 0.592 0.581 0.81 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7321 0.52915 moveto
0.7469 0.5219 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68544 0.55197 moveto
0.68927 0.56757 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68927 0.56757 moveto
0.69127 0.56662 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69127 0.56662 moveto
0.69135 0.56658 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71949 0.52171 moveto
0.72554 0.51938 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68406 0.53536 moveto
0.71949 0.52171 lineto
stroke
grestore
gsave
0.68968 0.48614 moveto 0.73125 0.5093 lineto 0.72495 0.51204 lineto 0.464 0.178 0.394 setrgbcolor
fill
grestore
gsave
0.69626 0.47122 moveto 0.73125 0.5093 lineto 0.68968 0.48614 lineto 0.328 0.264 0.631 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68535 0.50209 moveto
0.68916 0.50304 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68535 0.50209 moveto
0.68968 0.48614 lineto
stroke
grestore
gsave
0.69417 0.58275 moveto 0.79017 0.57331 lineto 0.69885 0.59816 lineto 0.595 0.432 0.63 setrgbcolor
fill
grestore
gsave
0.69417 0.58275 moveto 0.77828 0.54971 lineto 0.79017 0.57331 lineto 0.609 0.545 0.758 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.68927 0.56757 moveto
0.69417 0.58275 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69417 0.58275 moveto
0.69657 0.58181 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73945 0.54373 moveto
0.76275 0.53267 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69135 0.56658 moveto
0.73945 0.54373 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7237 0.53326 moveto
0.7321 0.52915 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68726 0.55108 moveto
0.7237 0.53326 lineto
stroke
grestore
gsave
0.69626 0.47122 moveto 0.74446 0.50326 lineto 0.73125 0.5093 lineto 0.551 0.291 0.475 setrgbcolor
fill
grestore
gsave
0.7047 0.45706 moveto 0.74446 0.50326 lineto 0.69626 0.47122 lineto 0.406 0.343 0.675 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68968 0.48614 moveto
0.69139 0.48709 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.68968 0.48614 moveto
0.69626 0.47122 lineto
stroke
grestore
gsave
0.69885 0.59816 moveto 0.79535 0.60257 lineto 0.70154 0.61439 lineto 0.623 0.455 0.634 setrgbcolor
fill
grestore
gsave
0.69885 0.59816 moveto 0.79017 0.57331 lineto 0.79535 0.60257 lineto 0.622 0.519 0.716 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.69417 0.58275 moveto
0.69885 0.59816 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69885 0.59816 moveto
0.79017 0.57331 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.74329 0.56345 moveto
0.77828 0.54971 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69657 0.58181 moveto
0.74329 0.56345 lineto
stroke
grestore
gsave
0.59646 0.73355 moveto 0.62446 0.74194 lineto 0.57989 0.74746 lineto 0.21 0 0.143 setrgbcolor
fill
grestore
gsave
0.59646 0.73355 moveto 0.63503 0.74349 lineto 0.62446 0.74194 lineto 0.231 0 0 setrgbcolor
fill
grestore
gsave
0.61449 0.72036 moveto 0.63503 0.74349 lineto 0.59646 0.73355 lineto 0.317 0 0.246 setrgbcolor
fill
grestore
gsave
0.70154 0.61439 moveto 0.79171 0.63533 lineto 0.70053 0.63148 lineto 0.639 0.473 0.642 setrgbcolor
fill
grestore
gsave
0.70154 0.61439 moveto 0.79535 0.60257 lineto 0.79171 0.63533 lineto 0.632 0.497 0.68 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.69885 0.59816 moveto
0.70154 0.61439 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70154 0.61439 moveto
0.79535 0.60257 lineto
stroke
grestore
gsave
0.57989 0.74746 moveto 0.61978 0.74279 lineto 0.56537 0.76164 lineto 0.181 0 0.127 setrgbcolor
fill
grestore
gsave
0.57989 0.74746 moveto 0.62446 0.74194 lineto 0.61978 0.74279 lineto 0 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.57989 0.74746 moveto
0.59646 0.73355 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57989 0.74746 moveto
0.58227 0.74716 lineto
stroke
grestore
gsave
0.61449 0.72036 moveto 0.65192 0.74509 lineto 0.63503 0.74349 lineto 0.539 0.019 0 setrgbcolor
fill
grestore
gsave
0.63331 0.70773 moveto 0.65192 0.74509 lineto 0.61449 0.72036 lineto 0.428 0.141 0.374 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.59646 0.73355 moveto
0.61449 0.72036 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59725 0.73375 moveto
0.62545 0.74102 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59646 0.73355 moveto
0.59725 0.73375 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62427 0.74197 moveto
0.62446 0.74194 lineto
stroke
grestore
gsave
0.7047 0.45706 moveto 0.76299 0.49199 lineto 0.74446 0.50326 lineto 0.589 0.377 0.561 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73996 0.50027 moveto
0.74446 0.50326 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73044 0.50885 moveto
0.73125 0.5093 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68916 0.50304 moveto
0.72495 0.51204 lineto
stroke
grestore
gsave
0.71398 0.44302 moveto 0.76299 0.49199 lineto 0.7047 0.45706 lineto 0.476 0.427 0.724 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69626 0.47122 moveto
0.69684 0.4716 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.69626 0.47122 moveto
0.7047 0.45706 lineto
stroke
grestore
gsave
0.63331 0.70773 moveto 0.67469 0.7438 lineto 0.65192 0.74509 lineto 0.626 0.223 0.26 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62545 0.74102 moveto
0.63306 0.74298 lineto
stroke
grestore
gsave
0.65201 0.69491 moveto 0.67469 0.7438 lineto 0.63331 0.70773 lineto 0.508 0.263 0.479 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63306 0.74298 moveto
0.63503 0.74349 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61449 0.72036 moveto
0.64103 0.73789 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64103 0.73789 moveto
0.65192 0.74509 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.61449 0.72036 moveto
0.63331 0.70773 lineto
stroke
grestore
gsave
0.56537 0.76164 moveto 0.61986 0.74771 lineto 0.55345 0.7753 lineto 0.243 0 0.184 setrgbcolor
fill
grestore
gsave
0.56537 0.76164 moveto 0.61978 0.74279 lineto 0.61986 0.74771 lineto 0.417 0.358 0.685 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.56537 0.76164 moveto
0.57989 0.74746 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.58227 0.74716 moveto
0.62427 0.74197 lineto
stroke
grestore
gsave
0.70053 0.63148 moveto 0.77866 0.66842 lineto 0.69474 0.64886 lineto 0.639 0.476 0.646 setrgbcolor
fill
grestore
gsave
0.70053 0.63148 moveto 0.79171 0.63533 lineto 0.77866 0.66842 lineto 0.639 0.476 0.646 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.70053 0.63148 moveto
0.70154 0.61439 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70053 0.63148 moveto
0.79171 0.63533 lineto
stroke
grestore
gsave
0.65201 0.69491 moveto 0.70181 0.73663 lineto 0.67469 0.7438 lineto 0.647 0.324 0.411 setrgbcolor
fill
grestore
gsave
0.66941 0.68104 moveto 0.70181 0.73663 lineto 0.65201 0.69491 lineto 0.561 0.352 0.555 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.63331 0.70773 moveto
0.65201 0.69491 lineto
stroke
grestore
gsave
0.69474 0.64886 moveto 0.75736 0.6982 lineto 0.6841 0.66563 lineto 0.624 0.457 0.635 setrgbcolor
fill
grestore
gsave
0.69474 0.64886 moveto 0.77866 0.66842 lineto 0.75736 0.6982 lineto 0.645 0.452 0.608 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.69474 0.64886 moveto
0.70053 0.63148 lineto
stroke
grestore
gsave
0.66941 0.68104 moveto 0.73055 0.72152 lineto 0.70181 0.73663 lineto 0.65 0.382 0.5 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66719 0.73726 moveto
0.67469 0.7438 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.63331 0.70773 moveto
0.66719 0.73726 lineto
stroke
grestore
gsave
0.6841 0.66563 moveto 0.73055 0.72152 lineto 0.66941 0.68104 lineto 0.598 0.416 0.606 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.65201 0.69491 moveto
0.66941 0.68104 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65201 0.69491 moveto
0.67107 0.71088 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66941 0.68104 moveto
0.67086 0.682 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69474 0.64886 moveto
0.69911 0.64988 lineto
stroke
grestore
gsave
0.6841 0.66563 moveto 0.75736 0.6982 lineto 0.73055 0.72152 lineto 0.649 0.422 0.561 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68708 0.66696 moveto
0.75736 0.6982 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6841 0.66563 moveto
0.68708 0.66696 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.66941 0.68104 moveto
0.6841 0.66563 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69911 0.64988 moveto
0.77866 0.66842 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.6841 0.66563 moveto
0.69474 0.64886 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67086 0.682 moveto
0.70152 0.7023 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70152 0.7023 moveto
0.73055 0.72152 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68744 0.7246 moveto
0.70181 0.73663 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67107 0.71088 moveto
0.68744 0.7246 lineto
stroke
grestore
gsave
0.55345 0.7753 moveto 0.62289 0.75783 lineto 0.54452 0.78783 lineto 0.337 0.004 0.243 setrgbcolor
fill
grestore
gsave
0.55345 0.7753 moveto 0.61986 0.74771 lineto 0.62289 0.75783 lineto 0.505 0.429 0.704 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61972 0.74281 moveto
0.61978 0.74279 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.56537 0.76164 moveto
0.57403 0.75864 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.55345 0.7753 moveto
0.56537 0.76164 lineto
stroke
grestore
gsave
0.71398 0.44302 moveto 0.78412 0.47417 lineto 0.76299 0.49199 lineto 0.611 0.441 0.627 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75939 0.48984 moveto
0.76299 0.49199 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72793 0.50745 moveto
0.73044 0.50885 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69139 0.48709 moveto
0.72793 0.50745 lineto
stroke
grestore
gsave
0.72254 0.42857 moveto 0.78412 0.47417 lineto 0.71398 0.44302 lineto 0.531 0.502 0.769 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.7047 0.45706 moveto
0.71398 0.44302 lineto
stroke
grestore
gsave
0.54452 0.78783 moveto 0.62657 0.77367 lineto 0.53854 0.79912 lineto 0.424 0.08 0.276 setrgbcolor
fill
grestore
gsave
0.54452 0.78783 moveto 0.62289 0.75783 lineto 0.62657 0.77367 lineto 0.546 0.422 0.662 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61277 0.75065 moveto
0.61986 0.74771 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.54452 0.78783 moveto
0.55345 0.7753 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54452 0.78783 moveto
0.54627 0.78716 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62131 0.75844 moveto
0.62289 0.75783 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61474 0.74453 moveto
0.61972 0.74281 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.57403 0.75864 moveto
0.61474 0.74453 lineto
stroke
grestore
gsave
0.72254 0.42857 moveto 0.80425 0.44971 lineto 0.78412 0.47417 lineto 0.625 0.492 0.68 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.75554 0.48753 moveto
0.75939 0.48984 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.7047 0.45706 moveto
0.75554 0.48753 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73597 0.49761 moveto
0.73996 0.50027 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69684 0.4716 moveto
0.73597 0.49761 lineto
stroke
grestore
gsave
0.72854 0.41362 moveto 0.80425 0.44971 lineto 0.72254 0.42857 lineto 0.577 0.566 0.805 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.71398 0.44302 moveto
0.72254 0.42857 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72254 0.42857 moveto
0.72339 0.42879 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.79017 0.57331 moveto
0.79535 0.60257 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.77828 0.54971 moveto
0.79017 0.57331 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.79171 0.63533 moveto
0.79535 0.60257 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76275 0.53267 moveto
0.77828 0.54971 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.77866 0.66842 moveto
0.79171 0.63533 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.7469 0.5219 moveto
0.76275 0.53267 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73384 0.51618 moveto
0.7469 0.5219 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.75736 0.6982 moveto
0.77866 0.66842 lineto
stroke
grestore
gsave
0.53854 0.79912 moveto 0.62833 0.79494 lineto 0.53485 0.80962 lineto 0.499 0.142 0.291 setrgbcolor
fill
grestore
gsave
0.53854 0.79912 moveto 0.62657 0.77367 lineto 0.62833 0.79494 lineto 0.574 0.405 0.615 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.53854 0.79912 moveto
0.54452 0.78783 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53854 0.79912 moveto
0.54018 0.79865 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54018 0.79865 moveto
0.54126 0.79833 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60806 0.76351 moveto
0.62131 0.75844 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54627 0.78716 moveto
0.60806 0.76351 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60559 0.75364 moveto
0.61277 0.75065 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55345 0.7753 moveto
0.60559 0.75364 lineto
stroke
grestore
gsave
0.72854 0.41362 moveto 0.81953 0.42025 lineto 0.80425 0.44971 lineto 0.635 0.537 0.726 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72339 0.42879 moveto
0.80425 0.44971 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.76937 0.46762 moveto
0.78412 0.47417 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71398 0.44302 moveto
0.76937 0.46762 lineto
stroke
grestore
gsave
0.73035 0.39867 moveto 0.81953 0.42025 lineto 0.72854 0.41362 lineto 0.614 0.614 0.828 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.72254 0.42857 moveto
0.72854 0.41362 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.726 0.51361 moveto
0.73384 0.51618 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72495 0.51204 moveto
0.726 0.51361 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73055 0.72152 moveto
0.75736 0.6982 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.72495 0.51204 moveto
0.73125 0.5093 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73125 0.5093 moveto
0.74446 0.50326 lineto
stroke
grestore
gsave
0.73035 0.39867 moveto 0.82664 0.3889 lineto 0.81953 0.42025 lineto 0.643 0.579 0.768 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72854 0.41362 moveto
0.81953 0.42025 lineto
stroke
grestore
gsave
0.72701 0.38455 moveto 0.82664 0.3889 lineto 0.73035 0.39867 lineto 0.641 0.642 0.836 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.72854 0.41362 moveto
0.73035 0.39867 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.74446 0.50326 moveto
0.76299 0.49199 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76299 0.49199 moveto
0.78412 0.47417 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70181 0.73663 moveto
0.73055 0.72152 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78412 0.47417 moveto
0.80425 0.44971 lineto
stroke
grestore
gsave
0.53485 0.80962 moveto 0.62569 0.82039 lineto 0.53204 0.82003 lineto 0.567 0.202 0.307 setrgbcolor
fill
grestore
gsave
0.53485 0.80962 moveto 0.62833 0.79494 lineto 0.62569 0.82039 lineto 0.597 0.389 0.57 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.53485 0.80962 moveto
0.53854 0.79912 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53485 0.80962 moveto
0.53725 0.80924 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53725 0.80924 moveto
0.62833 0.79494 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6034 0.78037 moveto
0.62657 0.77367 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.54126 0.79833 moveto
0.6034 0.78037 lineto
stroke
grestore
gsave
0.72701 0.38455 moveto 0.8236 0.35945 lineto 0.82664 0.3889 lineto 0.648 0.62 0.808 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.73035 0.39867 moveto
0.82664 0.3889 lineto
stroke
grestore
gsave
0.71848 0.37196 moveto 0.8236 0.35945 lineto 0.72701 0.38455 lineto 0.652 0.648 0.833 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.72701 0.38455 moveto
0.73035 0.39867 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.80425 0.44971 moveto
0.81953 0.42025 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67469 0.7438 moveto
0.70181 0.73663 lineto
stroke
grestore
gsave
0.71848 0.37196 moveto 0.8102 0.33534 lineto 0.8236 0.35945 lineto 0.65 0.663 0.849 setrgbcolor
fill
grestore
gsave
0.70573 0.36107 moveto 0.8102 0.33534 lineto 0.71848 0.37196 lineto 0.645 0.64 0.831 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.71848 0.37196 moveto
0.72701 0.38455 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.81953 0.42025 moveto
0.82664 0.3889 lineto
stroke
grestore
gsave
0.70573 0.36107 moveto 0.78811 0.31881 lineto 0.8102 0.33534 lineto 0.647 0.711 0.894 setrgbcolor
fill
grestore
gsave
0.69034 0.35146 moveto 0.78811 0.31881 lineto 0.70573 0.36107 lineto 0.623 0.631 0.837 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72701 0.38455 moveto
0.8236 0.35945 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.70573 0.36107 moveto
0.71848 0.37196 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70973 0.35902 moveto
0.72281 0.35231 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70573 0.36107 moveto
0.70973 0.35902 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.65192 0.74509 moveto
0.67469 0.7438 lineto
stroke
grestore
gsave
0.53204 0.82003 moveto 0.61666 0.84782 lineto 0.52818 0.83076 lineto 0.628 0.266 0.336 setrgbcolor
fill
grestore
gsave
0.53204 0.82003 moveto 0.62569 0.82039 lineto 0.61666 0.84782 lineto 0.62 0.377 0.528 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.53204 0.82003 moveto
0.53485 0.80962 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53204 0.82003 moveto
0.62569 0.82039 lineto
stroke
grestore
gsave
0.69034 0.35146 moveto 0.76046 0.31052 lineto 0.78811 0.31881 lineto 0.633 0.772 0.947 setrgbcolor
fill
grestore
gsave
0.6739 0.34236 moveto 0.76046 0.31052 lineto 0.69034 0.35146 lineto 0.587 0.627 0.859 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.69034 0.35146 moveto
0.70573 0.36107 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69034 0.35146 moveto
0.70375 0.34363 lineto
stroke
grestore
gsave
0.6739 0.34236 moveto 0.73117 0.30957 lineto 0.76046 0.31052 lineto 0.583 0.845 0.994 setrgbcolor
fill
grestore
gsave
0.6576 0.33319 moveto 0.73117 0.30957 lineto 0.6739 0.34236 lineto 0.529 0.63 0.895 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.71848 0.37196 moveto
0.72043 0.37118 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72043 0.37118 moveto
0.8102 0.33534 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.6739 0.34236 moveto
0.69034 0.35146 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6739 0.34236 moveto
0.68477 0.33614 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61986 0.74771 moveto
0.62289 0.75783 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61978 0.74279 moveto
0.61982 0.74514 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61982 0.74514 moveto
0.61986 0.74771 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.6241 0.74201 moveto
0.62446 0.74194 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61978 0.74279 moveto
0.6241 0.74201 lineto
stroke
grestore
gsave
0.6576 0.33319 moveto 0.70402 0.31394 lineto 0.73117 0.30957 lineto 0.393 0.845 0.913 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70932 0.32208 moveto
0.73117 0.30957 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.724 0.33181 moveto
0.76046 0.31052 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.72281 0.35231 moveto
0.78811 0.31881 lineto
stroke
grestore
gsave
0.64214 0.32389 moveto 0.70402 0.31394 lineto 0.6576 0.33319 lineto 0.421 0.625 0.937 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.70375 0.34363 moveto
0.724 0.33181 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.68477 0.33614 moveto
0.69793 0.3286 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.6576 0.33319 moveto
0.6739 0.34236 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6576 0.33319 moveto
0.65847 0.33283 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.63503 0.74349 moveto
0.65192 0.74509 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62289 0.75783 moveto
0.62657 0.77367 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62446 0.74194 moveto
0.63503 0.74349 lineto
stroke
grestore
gsave
0.70402 0.31394 moveto 0.64288 0.32377 lineto 0.68206 0.32096 lineto 0.042 0 0 setrgbcolor
fill
grestore
gsave
0.68206 0.32096 moveto 0.64288 0.32377 lineto 0.64321 0.32381 lineto 0.042 0 0 setrgbcolor
fill
grestore
gsave
0.64214 0.32389 moveto 0.64321 0.32381 lineto 0.64288 0.32377 lineto 0.042 0 0 setrgbcolor
fill
grestore
gsave
0.62798 0.31495 moveto 0.68206 0.32096 lineto 0.64214 0.32389 lineto 0.207 0.564 0.937 setrgbcolor
fill
grestore
gsave
0.62798 0.31495 moveto 0.66717 0.32787 lineto 0.68206 0.32096 lineto 0.354 0 0.102 setrgbcolor
fill
grestore
gsave
0.61567 0.30705 moveto 0.66323 0.32628 lineto 0.62798 0.31495 lineto 0 0.393 0.807 setrgbcolor
fill
grestore
gsave
0.66717 0.32787 moveto 0.66181 0.3261 lineto 0.66323 0.32628 lineto 0 0.393 0.807 setrgbcolor
fill
grestore
gsave
0.62798 0.31495 moveto 0.66323 0.32628 lineto 0.66181 0.3261 lineto 0 0.393 0.807 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64214 0.32389 moveto
0.64321 0.32381 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.64214 0.32389 moveto
0.6576 0.33319 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65847 0.33283 moveto
0.65869 0.33274 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65869 0.33274 moveto
0.65899 0.33261 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.6833 0.32253 moveto
0.69043 0.31957 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69043 0.31957 moveto
0.70402 0.31394 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.69793 0.3286 moveto
0.70932 0.32208 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.62798 0.31495 moveto
0.64214 0.32389 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.8236 0.35945 moveto
0.82664 0.3889 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62657 0.77367 moveto
0.62833 0.79494 lineto
stroke
grestore
gsave
0.52818 0.83076 moveto 0.60023 0.87416 lineto 0.52145 0.84157 lineto 0.671 0.323 0.375 setrgbcolor
fill
grestore
gsave
0.52818 0.83076 moveto 0.61666 0.84782 lineto 0.60023 0.87416 lineto 0.643 0.368 0.487 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.52818 0.83076 moveto
0.53204 0.82003 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.62569 0.82039 moveto
0.62833 0.79494 lineto
stroke
grestore
gsave
0.61567 0.30705 moveto 0.66003 0.33226 lineto 0.66717 0.32787 lineto 0.497 0.164 0.332 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62798 0.31495 moveto
0.6318 0.31621 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65899 0.33261 moveto
0.65995 0.33221 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.66044 0.33201 moveto
0.6833 0.32253 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64321 0.32381 moveto
0.64495 0.32369 lineto
stroke
grestore
gsave
0.60592 0.3006 moveto 0.66003 0.33226 lineto 0.61567 0.30705 lineto 0 0.238 0.661 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.61567 0.30705 moveto
0.62798 0.31495 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.8102 0.33534 moveto
0.8236 0.35945 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.61666 0.84782 moveto
0.62569 0.82039 lineto
stroke
grestore
gsave
0.52145 0.84157 moveto 0.57685 0.89583 lineto 0.51074 0.8516 lineto 0.687 0.352 0.403 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52818 0.83076 moveto
0.53219 0.83153 lineto
stroke
grestore
gsave
0.52145 0.84157 moveto 0.60023 0.87416 lineto 0.57685 0.89583 lineto 0.667 0.359 0.441 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.55702 0.83632 moveto
0.61666 0.84782 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.53219 0.83153 moveto
0.55702 0.83632 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.52145 0.84157 moveto
0.52818 0.83076 lineto
stroke
grestore
gsave
0.60592 0.3006 moveto 0.66022 0.33228 lineto 0.66003 0.33226 lineto 0 0.238 0.661 setrgbcolor
fill
grestore
gsave
0.59926 0.29552 moveto 0.66022 0.33228 lineto 0.60592 0.3006 lineto 0 0.254 0.688 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.60592 0.3006 moveto
0.61567 0.30705 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.78811 0.31881 moveto
0.8102 0.33534 lineto
stroke
grestore
gsave
0.51074 0.8516 moveto 0.5486 0.90952 lineto 0.49593 0.85978 lineto 0.678 0.342 0.398 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52145 0.84157 moveto
0.52571 0.84334 lineto
stroke
grestore
gsave
0.51074 0.8516 moveto 0.57685 0.89583 lineto 0.5486 0.90952 lineto 0.692 0.344 0.383 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.51074 0.8516 moveto
0.52145 0.84157 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.60023 0.87416 moveto
0.61666 0.84782 lineto
stroke
grestore
gsave
0.59926 0.29552 moveto 0.66635 0.3267 lineto 0.66022 0.33228 lineto 0.519 0.451 0.72 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65822 0.33123 moveto
0.66003 0.33226 lineto
stroke
grestore
gsave
0.59566 0.29125 moveto 0.66635 0.3267 lineto 0.59926 0.29552 lineto 0 0.404 0.818 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.61567 0.30705 moveto
0.62162 0.31043 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60592 0.3006 moveto
0.60975 0.30283 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59926 0.29552 moveto
0.60592 0.3006 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.76046 0.31052 moveto
0.78811 0.31881 lineto
stroke
grestore
gsave
0.49593 0.85978 moveto 0.5188 0.91321 lineto 0.47774 0.86543 lineto 0.649 0.286 0.343 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51074 0.8516 moveto
0.51439 0.85404 lineto
stroke
grestore
gsave
0.49593 0.85978 moveto 0.5486 0.90952 lineto 0.5188 0.91321 lineto 0.716 0.318 0.293 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.49593 0.85978 moveto
0.51074 0.8516 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.49593 0.85978 moveto
0.50212 0.86563 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.52571 0.84334 moveto
0.60023 0.87416 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.73117 0.30957 moveto
0.76046 0.31052 lineto
stroke
grestore
gsave
0.47774 0.86543 moveto 0.49097 0.9071 lineto 0.45727 0.86863 lineto 0.592 0.172 0.213 setrgbcolor
fill
grestore
gsave
0.47774 0.86543 moveto 0.5188 0.91321 lineto 0.49097 0.9071 lineto 0.733 0.264 0.134 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.47774 0.86543 moveto
0.49593 0.85978 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47774 0.86543 moveto
0.47959 0.86758 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.50212 0.86563 moveto
0.5486 0.90952 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.51439 0.85404 moveto
0.57685 0.89583 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.57685 0.89583 moveto
0.60023 0.87416 lineto
stroke
grestore
gsave
0.59566 0.29125 moveto 0.67606 0.31502 lineto 0.66635 0.3267 lineto 0.569 0.52 0.76 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65605 0.32191 moveto
0.66635 0.3267 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64779 0.32502 moveto
0.66022 0.33228 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.64868 0.32581 moveto
0.65822 0.33123 lineto
stroke
grestore
gsave
0.59416 0.28714 moveto 0.67606 0.31502 lineto 0.59566 0.29125 lineto 0.118 0.569 0.919 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.62162 0.31043 moveto
0.64868 0.32581 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60975 0.30283 moveto
0.64779 0.32502 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59926 0.29552 moveto
0.60131 0.29648 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59566 0.29125 moveto
0.59926 0.29552 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59566 0.29125 moveto
0.5993 0.29233 lineto
stroke
grestore
gsave
0.45727 0.86863 moveto 0.46775 0.89373 lineto 0.4355 0.87015 lineto 0.465 0 0 setrgbcolor
fill
grestore
gsave
0.45727 0.86863 moveto 0.49097 0.9071 lineto 0.46775 0.89373 lineto 0.68 0.133 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.45727 0.86863 moveto
0.47774 0.86543 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.47959 0.86758 moveto
0.4884 0.87783 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4884 0.87783 moveto
0.5188 0.91321 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.70402 0.31394 moveto
0.73117 0.30957 lineto
stroke
grestore
gsave
0.4355 0.87015 moveto 0.46775 0.89373 lineto 0.45018 0.87722 lineto 0 0.129 0.632 setrgbcolor
fill
grestore
gsave
0.4355 0.87015 moveto 0.45018 0.87722 lineto 0.41315 0.87101 lineto 0.165 0 0 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.4355 0.87015 moveto
0.45727 0.86863 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.45727 0.86863 moveto
0.49097 0.9071 lineto
stroke
grestore
gsave
0.41315 0.87101 moveto 0.43785 0.86179 lineto 0.39086 0.87197 lineto 0.24 0.748 0.879 setrgbcolor
fill
grestore
gsave
0.41315 0.87101 moveto 0.45018 0.87722 lineto 0.43785 0.86179 lineto 0.083 0.319 0.797 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.44368 0.87613 moveto
0.46775 0.89373 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68206 0.32096 moveto
0.70402 0.31394 lineto
stroke
grestore
gsave
0.39086 0.87197 moveto 0.4296 0.85053 lineto 0.36941 0.87306 lineto 0.471 0.851 0.984 setrgbcolor
fill
grestore
gsave
0.39086 0.87197 moveto 0.43785 0.86179 lineto 0.4296 0.85053 lineto 0.318 0.385 0.774 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.39086 0.87197 moveto
0.41315 0.87101 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39086 0.87197 moveto
0.39103 0.87193 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.43378 0.86267 moveto
0.43785 0.86179 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66717 0.32787 moveto
0.68206 0.32096 lineto
stroke
grestore
gsave
0.36941 0.87306 moveto 0.42415 0.84504 lineto 0.34993 0.87375 lineto 0.552 0.875 0.993 setrgbcolor
fill
grestore
gsave
0.36941 0.87306 moveto 0.4296 0.85053 lineto 0.42415 0.84504 lineto 0.45 0.442 0.758 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.36941 0.87306 moveto
0.39086 0.87197 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36968 0.87296 moveto
0.37123 0.87238 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.36941 0.87306 moveto
0.36968 0.87296 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.4275 0.85132 moveto
0.4296 0.85053 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66066 0.33187 moveto
0.66717 0.32787 lineto
stroke
grestore
gsave
0.59416 0.28714 moveto 0.68608 0.29772 lineto 0.67606 0.31502 lineto 0.6 0.586 0.809 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.67506 0.31473 moveto
0.67606 0.31502 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.65427 0.30858 moveto
0.67506 0.31473 lineto
stroke
grestore
gsave
0.59298 0.28291 moveto 0.68608 0.29772 lineto 0.59416 0.28714 lineto 0.269 0.699 0.966 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.60131 0.29648 moveto
0.65605 0.32191 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.5993 0.29233 moveto
0.65427 0.30858 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59416 0.28714 moveto
0.59566 0.29125 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66003 0.33226 moveto
0.66022 0.33228 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5486 0.90952 moveto
0.57685 0.89583 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66022 0.33228 moveto
0.66635 0.3267 lineto
stroke
grestore
gsave
0.34993 0.87375 moveto 0.42029 0.84569 lineto 0.33368 0.8733 lineto 0.546 0.879 0.99 setrgbcolor
fill
grestore
gsave
0.34993 0.87375 moveto 0.42415 0.84504 lineto 0.42029 0.84569 lineto 0.546 0.879 0.99 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.41315 0.87101 moveto
0.45018 0.87722 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.39103 0.87193 moveto
0.43378 0.86267 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.37123 0.87238 moveto
0.4275 0.85132 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.34993 0.87375 moveto
0.36941 0.87306 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34993 0.87375 moveto
0.35288 0.87261 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35288 0.87261 moveto
0.35516 0.87173 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.35516 0.87173 moveto
0.42246 0.8457 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.42246 0.8457 moveto
0.42415 0.84504 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.33368 0.8733 moveto
0.34993 0.87375 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.66635 0.3267 moveto
0.67606 0.31502 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33368 0.8733 moveto
0.33603 0.87255 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.33603 0.87255 moveto
0.34539 0.86956 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.34539 0.86956 moveto
0.42029 0.84569 lineto
stroke
grestore
gsave
0.59298 0.28291 moveto 0.69264 0.27669 lineto 0.68608 0.29772 lineto 0.626 0.652 0.856 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.67606 0.31502 moveto
0.68608 0.29772 lineto
stroke
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59416 0.28714 moveto
0.68608 0.29772 lineto
stroke
grestore
gsave
0.59001 0.279 moveto 0.69264 0.27669 lineto 0.59298 0.28291 lineto 0.379 0.797 0.976 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.59298 0.28291 moveto
0.59416 0.28714 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.5188 0.91321 moveto
0.5486 0.90952 lineto
stroke
grestore
gsave
0.59001 0.279 moveto 0.69219 0.25529 lineto 0.69264 0.27669 lineto 0.647 0.72 0.901 setrgbcolor
fill
grestore
gsave
0.58344 0.27633 moveto 0.69219 0.25529 lineto 0.59001 0.279 lineto 0.473 0.868 0.968 setrgbcolor
fill
grestore
gsave
0.25 setgray
0.004 setlinewidth
0.59298 0.28291 moveto
0.69264 0.27669 lineto
stroke
grestore
gsave
0.006 setlinewidth
0.59001 0.279 moveto
0.59298 0.28291 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.68608 0.29772 moveto
0.69264 0.27669 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.49097 0.9071 moveto
0.5188 0.91321 lineto
stroke
grestore
gsave
0.58344 0.27633 moveto 0.68232 0.23777 lineto 0.69219 0.25529 lineto 0.664 0.791 0.942 setrgbcolor
fill
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.69219 0.25529 moveto
0.69264 0.27669 lineto
stroke
grestore
gsave
0.57225 0.27588 moveto 0.68232 0.23777 lineto 0.58344 0.27633 lineto 0.56 0.915 0.96 setrgbcolor
fill
grestore
gsave
0.006 setlinewidth
0.58344 0.27633 moveto
0.59001 0.279 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.46775 0.89373 moveto
0.49097 0.9071 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42029 0.84569 moveto
0.42415 0.84504 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewidth
0.42415 0.84504 moveto
0.4296 0.85053 lineto
stroke
grestore
gsave
1 0 0 setrgbcolor
0.003 setlinewi