(*^

::[paletteColors = 128; 
	fontset = title, New York, 24, L3, center, bold, nohscroll;
	fontset = subtitle, New York, 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, New York, 14, L2, center, bold, nohscroll;
	fontset = section, New York, 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, New York, 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, New York, 10, L2, bold, nohscroll, whiteBox;
	fontset = text, New York, 12, L2, nohscroll;
	fontset = smalltext, New York, 10, L2, nohscroll;
	fontset = input, Courier, 12, L2, bold, nowordwrap;
	fontset = output, Courier, 12, L2, nowordwrap;
	fontset = message, Courier, 12, L2, R65535, nowordwrap;
	fontset = print, Courier, 12, L2, nowordwrap;
	fontset = info, Courier, 12, L2, nowordwrap;
	fontset = postscript, Courier, 12, L2, nowordwrap;
	fontset = name, Geneva, 10, L2, italic, B65535, nohscroll;
	fontset = header, New York, 10, L2, nohscroll;
	fontset = footer, New York, 12, L2, center, nohscroll;
	fontset = help, Geneva, 10, L2, nohscroll;
	fontset = clipboard, New York, 12, L2;
	fontset = completions, New York, 12, L2;
	fontset = network, Courier, 10, L2, nowordwrap;
	fontset = graphlabel, New York, 12, L2;
	fontset = special1, New York, 12, L2;
	fontset = special2, New York, 12, L2, center;
	fontset = special3, New York, 12, L2, right;
	fontset = special4, New York, 12, L2;
	fontset = special5, New York, 12, L2;]
:[inactive; startGroup; font = title; ]
 Ribbon Curves
:[inactive; font = subsubtitle; ]
by Rudy Rucker for Autodesk
:[inactive; font = subsection; ]
Sept 27, 1988.
:[inactive; endGroup; font = text; ]
	 	A single view of a space curve can be hard to decipher if the curves are simple black lines.  We need to be able to see when one line is closer than another.  
			The algorithm introduced here draws a short normal to the curve at each knot point, and connects the ends of the normals by a line.  This leads to a series of quadrilaterals which can be filled in to make a "paved ribbon".  This ribbon lies on the the developable surface associated with the curve, and is enveloped by the curve's osculating planes. 
			The algorithm in this notebook turns kappa-tau curves (see  my Mathematica  notebook "Best Kappa-Tau") into ribbon curves.  This is readily done because one has easy access to the normals of the kappa-tau curves.  Note also that the "rungs" of the paved ribbon curves occur at equal arclength increments. 
;[s]
6:0,2;380,1;387,2;583,3;594,2;825,0;826,-1;
4:1,15,12,New York,0,12,0,0,0;1,17,14,New York,0,14,0,0,0;3,19,14,New York,0,14,0,0,0;1,19,14,New York,2,14,0,0,0;
:[inactive; locked; font = section; ]
Ribbon Curve Algorithms
:[inactive; locked; startGroup; Cclosed; font = subsection; ]
Unpaved
:[locked; font = input; ]
clear:=Clear[ds,width,kappa,tau,top,point,tangent,normal,binormal,
             curve,ncurve,length];
:[locked; endGroup; font = input; ]

normalize[vector_]:=(1/Sqrt[vector.vector])vector;
cross[u_,v_]:={u[[2]]v[[3]]-u[[3]]v[[2]],u[[3]]v[[1]]-u[[1]]v[[3]],
                u[[1]]v[[2]]-u[[2]]v[[1]]};
ribbonfrenet:=(
 point = {0.,0.,0.};
 tangent=normalize[{kappa[0],0.,tau[0]}];
 normal={0.,1.,0.};
 npoint = {0.,width,0.};
 binormal=cross[tangent,normal];
 curve=List[point];
 ncurve=List[npoint]; 
 Do[newpoint=point+ds tangent;AppendTo[curve,newpoint];point=newpoint;
   newtangent=normalize[tangent+kappa[n ds]normal ds];
   newnormal=normalize[normal+(-kappa[n ds]tangent+tau[n ds]binormal)ds];
   tangent=newtangent;normal=newnormal;npoint=point+width normal;
   AppendTo[ncurve,npoint];binormal=cross[tangent,normal];,
   {n,1,top,1}];
 Show[Graphics3D[Line[curve]],Graphics3D[{RGBColor[1,0,0],Line[ncurve]}],
   BoxRatios->{1,1,1}] )
   
:[inactive; locked; startGroup; font = subsection; ]
Paved
:[font = input; ]
clear:=Clear[ds,width,kappa,tau,top,point,tangent,normal,binormal,
             curve,ncurve,tiles,picture];
:[endGroup; font = input; ]

normalize[vector_]:=(1/Sqrt[vector.vector])vector;
cross[u_,v_]:={u[[2]]v[[3]]-u[[3]]v[[2]],u[[3]]v[[1]]-u[[1]]v[[3]],
                u[[1]]v[[2]]-u[[2]]v[[1]]};
pribbonfrenet:=(
 point = {0.,0.,0.};
 edgepoint = {0.,width,0.};
 tangent=normalize[{kappa[0],0.,tau[0]}];
 normal={0.,1.,0.};
 binormal=cross[tangent,normal];
 curve=List[point];
 edgecurve=List[edgepoint];
 tiles=List[];
 rungs=List[Line[{point,edgepoint}]]; 
 Do[newpoint=point+ds tangent;
    newtangent=normalize[tangent+kappa[n ds]normal ds];
    newnormal=normalize[normal+(tau[n ds]binormal-kappa[n ds]tangent)ds];
    newedgepoint=newpoint+width newnormal;
    AppendTo[curve,newpoint];
    AppendTo[edgecurve,newedgepoint];
    AppendTo[tiles,Polygon[{point,edgepoint,newedgepoint,newpoint}]];
    AppendTo[rungs,Line[{newpoint,newedgepoint}]];
    tangent=newtangent;normal=newnormal;binormal=cross[tangent,normal];
    point=newpoint;edgepoint=newedgepoint;,
   {n,1,top,1}];
 picture=(Graphics3D[{Thickness[.006],Line[curve]}],
         Graphics3D[{Thickness[.003],RGBColor[1,0,0],Line[edgecurve]}],
         Graphics3D[{RGBColor[1,1,0],EdgeForm[],tiles}],
         Graphics3D[{GrayLevel[0.25],rungs}]);
 Show[picture,BoxRatios->{1,1,1}])   
:[inactive; startGroup; Cclosed; font = section; ]
Usage
:[inactive; endGroup; font = text; ]
1)Enter clear, 
2)Enter definitions of top, kappa[s_],tau[s_],width, and ds,
3)Enter ribbonfrenet or pribbonfrenet.  pribbonfrenet is better. 

More details on step 2) are found in the Usage section of the notebook "Best Kappa-Tau."
An easy approach is simply to select one of the demonstrations control lines below, copy it to the end of the file, make a few changes, and enter it.  

;[s]
9:0,0;8,1;14,0;39,1;77,0;84,1;97,0;100,1;114,0;386,-1;
2:5,15,12,New York,0,12,0,0,0;4,15,12,New York,0,12,0,0,0;
:[inactive; startGroup; font = section; ]
Plots with  ribbonfrenet
:[font = input; ]
clear;top=50;kappa[s_]=1.;tau[s_]=1.;width=.1;ds=.24;ribbonfrenet
:[inactive; PostScript; output; pictureLeft = 43; pictureWidth = 293; pictureHeight = 262; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.42805 0.53407 lineto
stroke
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.42805 0.53407 moveto
0.41259 0.97619 lineto
stroke
0.42805 0.53407 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.65131 0.02381 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
grestore
0 0 0 setrgbcolor
0.005 setlinewidth
0.45799 0.50047 moveto
0.39026 0.51069 lineto
stroke
0 0 0 setrgbcolor
0.53062 0.47885 moveto
0.45799 0.50047 lineto
stroke
0 0 0 setrgbcolor
0.39026 0.51069 moveto
0.33328 0.50972 lineto
stroke
0 0 0 setrgbcolor
0.60189 0.44634 moveto
0.53062 0.47885 lineto
stroke
0 0 0 setrgbcolor
0.33328 0.50972 moveto
0.2924 0.49849 lineto
stroke
1 0 0 setrgbcolor
0.47625 0.48061 moveto
0.41922 0.49264 lineto
stroke
1 0 0 setrgbcolor
0.53643 0.45906 moveto
0.47625 0.48061 lineto
stroke
1 0 0 setrgbcolor
0.41922 0.49264 moveto
0.37047 0.49523 lineto
stroke
0 0 0 setrgbcolor
0.6652 0.40427 moveto
0.60189 0.44634 lineto
stroke
1 0 0 setrgbcolor
0.59427 0.4286 moveto
0.53643 0.45906 lineto
stroke
1 0 0 setrgbcolor
0.37047 0.49523 moveto
0.33468 0.48912 lineto
stroke
0 0 0 setrgbcolor
0.48672 0.70776 moveto
0.41611 0.72008 lineto
stroke
0 0 0 setrgbcolor
0.56168 0.68543 moveto
0.48672 0.70776 lineto
stroke
0 0 0 setrgbcolor
0.41611 0.72008 moveto
0.35587 0.72253 lineto
stroke
0 0 0 setrgbcolor
0.2924 0.49849 moveto
0.27225 0.47871 lineto
stroke
1 0 0 setrgbcolor
0.64417 0.39062 moveto
0.59427 0.4286 lineto
stroke
0 0 0 setrgbcolor
0.63452 0.65356 moveto
0.56168 0.68543 lineto
stroke
1 0 0 setrgbcolor
0.33468 0.48912 moveto
0.31577 0.47573 lineto
stroke
0 0 0 setrgbcolor
0.35587 0.72253 moveto
0.31154 0.71587 lineto
stroke
0 0 0 setrgbcolor
0.71388 0.35494 moveto
0.6652 0.40427 lineto
stroke
1 0 0 setrgbcolor
0.44473 0.70399 moveto
0.39329 0.70938 lineto
stroke
1 0 0 setrgbcolor
0.5041 0.69028 moveto
0.44473 0.70399 lineto
stroke
1 0 0 setrgbcolor
0.5661 0.66822 moveto
0.5041 0.69028 lineto
stroke
1 0 0 setrgbcolor
0.68067 0.34731 moveto
0.64417 0.39062 lineto
stroke
1 0 0 setrgbcolor
0.62507 0.63839 moveto
0.5661 0.66822 lineto
stroke
1 0 0 setrgbcolor
0.39329 0.70938 moveto
0.35463 0.70703 lineto
stroke
0 0 0 setrgbcolor
0.69844 0.6134 moveto
0.63452 0.65356 lineto
stroke
0 0 0 setrgbcolor
0.27225 0.47871 moveto
0.27631 0.45296 lineto
stroke
1 0 0 setrgbcolor
0.31577 0.47573 moveto
0.31663 0.45721 lineto
stroke
0 0 0 setrgbcolor
0.31154 0.71587 moveto
0.288 0.70151 lineto
stroke
0 0 0 setrgbcolor
0.59451 0.90414 moveto
0.51717 0.92666 lineto
stroke
0 0 0 setrgbcolor
0.74176 0.30177 moveto
0.71388 0.35494 lineto
stroke
1 0 0 setrgbcolor
0.67523 0.60207 moveto
0.62507 0.63839 lineto
stroke
1 0 0 setrgbcolor
0.35463 0.70703 moveto
0.33289 0.69814 lineto
stroke
0 0 0 setrgbcolor
0.66896 0.87356 moveto
0.59451 0.90414 lineto
stroke
1 0 0 setrgbcolor
0.69904 0.30172 moveto
0.68067 0.34731 lineto
stroke
0 0 0 setrgbcolor
0.74659 0.56705 moveto
0.69844 0.6134 lineto
stroke
1 0 0 setrgbcolor
0.59747 0.88981 moveto
0.53361 0.91193 lineto
stroke
1 0 0 setrgbcolor
0.31663 0.45721 moveto
0.33853 0.43641 lineto
stroke
0 0 0 setrgbcolor
0.288 0.70151 moveto
0.28901 0.68163 lineto
stroke
1 0 0 setrgbcolor
0.71101 0.56126 moveto
0.67523 0.60207 lineto
stroke
1 0 0 setrgbcolor
0.65758 0.86115 moveto
0.59747 0.88981 lineto
stroke
0 0 0 setrgbcolor
0.27631 0.45296 moveto
0.30615 0.42474 lineto
stroke
0 0 0 setrgbcolor
0.73349 0.83602 moveto
0.66896 0.87356 lineto
stroke
1 0 0 setrgbcolor
0.33289 0.69814 moveto
0.33122 0.68451 lineto
stroke
0 0 0 setrgbcolor
0.74405 0.24917 moveto
0.74176 0.30177 lineto
stroke
1 0 0 setrgbcolor
0.69602 0.25759 moveto
0.69904 0.30172 lineto
stroke
1 0 0 setrgbcolor
0.70798 0.82707 moveto
0.65758 0.86115 lineto
stroke
0 0 0 setrgbcolor
0.77264 0.51764 moveto
0.74659 0.56705 lineto
stroke
1 0 0 setrgbcolor
0.36979 0.19289 moveto
0.42817 0.17553 lineto
stroke
1 0 0 setrgbcolor
0.72761 0.51874 moveto
0.71101 0.56126 lineto
stroke
1 0 0 setrgbcolor
0.33853 0.43641 moveto
0.38058 0.41678 lineto
stroke
0 0 0 setrgbcolor
0.78102 0.79339 moveto
0.73349 0.83602 lineto
stroke
1 0 0 setrgbcolor
0.33122 0.68451 moveto
0.3512 0.66856 lineto
stroke
1 0 0 setrgbcolor
0.67067 0.21895 moveto
0.69602 0.25759 lineto
stroke
0 0 0 setrgbcolor
0.28901 0.68163 moveto
0.31655 0.65916 lineto
stroke
0 0 0 setrgbcolor
0.35216 0.17157 moveto
0.42618 0.14888 lineto
stroke
0 0 0 setrgbcolor
0.30615 0.42474 moveto
0.36063 0.39833 lineto
stroke
0 0 0 setrgbcolor
0.71855 0.20222 moveto
0.74405 0.24917 lineto
stroke
1 0 0 setrgbcolor
0.74295 0.78934 moveto
0.70798 0.82707 lineto
stroke
1 0 0 setrgbcolor
0.42817 0.17553 moveto
0.49568 0.16777 lineto
stroke
1 0 0 setrgbcolor
0.72186 0.47792 moveto
0.72761 0.51874 lineto
stroke
0 0 0 setrgbcolor
0.77183 0.4692 moveto
0.77264 0.51764 lineto
stroke
1 0 0 setrgbcolor
0.62502 0.18958 moveto
0.67067 0.21895 lineto
stroke
1 0 0 setrgbcolor
0.38058 0.41678 moveto
0.43923 0.40199 lineto
stroke
1 0 0 setrgbcolor
0.49568 0.16777 moveto
0.56417 0.17216 lineto
stroke
1 0 0 setrgbcolor
0.3512 0.66856 moveto
0.39225 0.65324 lineto
stroke
0 0 0 setrgbcolor
0.8051 0.7484 moveto
0.78102 0.79339 lineto
stroke
0 0 0 setrgbcolor
0.42618 0.14888 moveto
0.51043 0.13871 lineto
stroke
1 0 0 setrgbcolor
0.56417 0.17216 moveto
0.62502 0.18958 lineto
stroke
0 0 0 setrgbcolor
0.66674 0.16592 moveto
0.71855 0.20222 lineto
stroke
1 0 0 setrgbcolor
0.75766 0.75041 moveto
0.74295 0.78934 lineto
stroke
0 0 0 setrgbcolor
0.31655 0.65916 moveto
0.3699 0.63779 lineto
stroke
0 0 0 setrgbcolor
0.36063 0.39833 moveto
0.43514 0.37843 lineto
stroke
1 0 0 setrgbcolor
0.69307 0.44242 moveto
0.72186 0.47792 lineto
stroke
0 0 0 setrgbcolor
0.51043 0.13871 moveto
0.5943 0.14414 lineto
stroke
1 0 0 setrgbcolor
0.43923 0.40199 moveto
0.50826 0.39546 lineto
stroke
0 0 0 setrgbcolor
0.5943 0.14414 moveto
0.66674 0.16592 lineto
stroke
0 0 0 setrgbcolor
0.74221 0.42634 moveto
0.77183 0.4692 lineto
stroke
1 0 0 setrgbcolor
0.39225 0.65324 moveto
0.45109 0.64178 lineto
stroke
1 0 0 setrgbcolor
0.64371 0.41556 moveto
0.69307 0.44242 lineto
stroke
1 0 0 setrgbcolor
0.749 0.71324 moveto
0.75766 0.75041 lineto
stroke
0 0 0 setrgbcolor
0.80098 0.70463 moveto
0.8051 0.7484 lineto
stroke
1 0 0 setrgbcolor
0.50826 0.39546 moveto
0.57942 0.39966 lineto
stroke
0 0 0 setrgbcolor
0.43514 0.37843 moveto
0.5215 0.36932 lineto
stroke
1 0 0 setrgbcolor
0.57942 0.39966 moveto
0.64371 0.41556 lineto
stroke
0 0 0 setrgbcolor
0.3699 0.63779 moveto
0.44479 0.6216 lineto
stroke
0 0 0 setrgbcolor
0.68578 0.3935 moveto
0.74221 0.42634 lineto
stroke
1 0 0 setrgbcolor
0.45109 0.64178 moveto
0.52162 0.6372 lineto
stroke
0 0 0 setrgbcolor
0.5215 0.36932 moveto
0.6089 0.37403 lineto
stroke
1 0 0 setrgbcolor
0.71659 0.68102 moveto
0.749 0.71324 lineto
stroke
0 0 0 setrgbcolor
0.6089 0.37403 moveto
0.68578 0.3935 lineto
stroke
0 0 0 setrgbcolor
0.767 0.66611 moveto
0.80098 0.70463 lineto
stroke
1 0 0 setrgbcolor
0.52162 0.6372 moveto
0.59549 0.64179 lineto
stroke
0 0 0 setrgbcolor
0.44479 0.6216 moveto
0.53324 0.61444 lineto
stroke
1 0 0 setrgbcolor
0.66334 0.65657 moveto
0.71659 0.68102 lineto
stroke
1 0 0 setrgbcolor
0.59549 0.64179 moveto
0.66334 0.65657 lineto
stroke
0 0 0 setrgbcolor
0.70571 0.63667 moveto
0.767 0.66611 lineto
stroke
0 0 0 setrgbcolor
0.53324 0.61444 moveto
0.62424 0.61911 lineto
stroke
0 0 0 setrgbcolor
0.62424 0.61911 moveto
0.70571 0.63667 lineto
stroke
0 setgray
0.002 setlinewidth
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
% End of Graphics
Mpend % End of picture
:[font = input; ]
clear;top=200;kappa[s_]=s;tau[s_]=50./(1+s);width=.001;ds=.02;ribbonfrenet
:[inactive; PostScript; output; pictureWidth = 448; pictureHeight = 336; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.42805 0.53407 lineto
stroke
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.42805 0.53407 moveto
0.41259 0.97619 lineto
stroke
0.42805 0.53407 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.65131 0.02381 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
grestore
1 0 0 setrgbcolor
0.005 setlinewidth
0.5554 0.31712 moveto
0.54912 0.31942 lineto
stroke
1 0 0 setrgbcolor
0.54912 0.31942 moveto
0.5441 0.31856 lineto
stroke
1 0 0 setrgbcolor
0.5441 0.31856 moveto
0.54302 0.31625 lineto
stroke
0 0 0 setrgbcolor
0.55121 0.31174 moveto
0.55123 0.3137 lineto
stroke
0 0 0 setrgbcolor
0.55123 0.3137 moveto
0.55128 0.31572 lineto
stroke
0 0 0 setrgbcolor
0.55128 0.31572 moveto
0.55131 0.31783 lineto
stroke
0 0 0 setrgbcolor
0.55131 0.31783 moveto
0.55115 0.32001 lineto
stroke
0 0 0 setrgbcolor
0.55115 0.32001 moveto
0.55074 0.32215 lineto
stroke
1 0 0 setrgbcolor
0.54302 0.31625 moveto
0.54623 0.31489 lineto
stroke
0 0 0 setrgbcolor
0.55074 0.32215 moveto
0.55012 0.32408 lineto
stroke
1 0 0 setrgbcolor
0.55578 0.33136 moveto
0.55103 0.33462 lineto
stroke
1 0 0 setrgbcolor
0.55804 0.32608 moveto
0.55578 0.33136 lineto
stroke
1 0 0 setrgbcolor
0.55103 0.33462 moveto
0.54615 0.3354 lineto
stroke
0 0 0 setrgbcolor
0.55012 0.32408 moveto
0.54956 0.32573 lineto
stroke
1 0 0 setrgbcolor
0.55649 0.32037 moveto
0.55804 0.32608 lineto
stroke
0 0 0 setrgbcolor
0.54956 0.32573 moveto
0.54935 0.32718 lineto
stroke
1 0 0 setrgbcolor
0.54615 0.3354 moveto
0.54339 0.3344 lineto
stroke
1 0 0 setrgbcolor
0.54623 0.31489 moveto
0.55175 0.31621 lineto
stroke
0 0 0 setrgbcolor
0.54935 0.32718 moveto
0.54968 0.32865 lineto
stroke
1 0 0 setrgbcolor
0.55175 0.31621 moveto
0.55649 0.32037 lineto
stroke
0 0 0 setrgbcolor
0.54968 0.32865 moveto
0.55048 0.33043 lineto
stroke
1 0 0 setrgbcolor
0.54339 0.3344 moveto
0.54384 0.3331 lineto
stroke
0 0 0 setrgbcolor
0.55048 0.33043 moveto
0.55138 0.33269 lineto
stroke
0 0 0 setrgbcolor
0.55138 0.33269 moveto
0.55191 0.3354 lineto
stroke
0 0 0 setrgbcolor
0.55191 0.3354 moveto
0.55167 0.33826 lineto
stroke
0 0 0 setrgbcolor
0.55167 0.33826 moveto
0.55059 0.34089 lineto
stroke
0 0 0 setrgbcolor
0.55059 0.34089 moveto
0.54899 0.34294 lineto
stroke
1 0 0 setrgbcolor
0.54384 0.3331 moveto
0.54706 0.33301 lineto
stroke
0 0 0 setrgbcolor
0.54899 0.34294 moveto
0.54748 0.34428 lineto
stroke
1 0 0 setrgbcolor
0.55434 0.34811 moveto
0.55097 0.35131 lineto
stroke
1 0 0 setrgbcolor
0.5559 0.34361 moveto
0.55434 0.34811 lineto
stroke
1 0 0 setrgbcolor
0.55097 0.35131 moveto
0.54724 0.35283 lineto
stroke
0 0 0 setrgbcolor
0.54748 0.34428 moveto
0.54672 0.3451 lineto
stroke
1 0 0 setrgbcolor
0.55481 0.3388 moveto
0.5559 0.34361 lineto
stroke
1 0 0 setrgbcolor
0.54706 0.33301 moveto
0.55138 0.33495 lineto
stroke
1 0 0 setrgbcolor
0.54724 0.35283 moveto
0.54464 0.35299 lineto
stroke
1 0 0 setrgbcolor
0.55138 0.33495 moveto
0.55481 0.3388 lineto
stroke
0 0 0 setrgbcolor
0.54672 0.3451 moveto
0.5471 0.34582 lineto
stroke
1 0 0 setrgbcolor
0.54464 0.35299 moveto
0.54407 0.35264 lineto
stroke
0 0 0 setrgbcolor
0.5471 0.34582 moveto
0.54858 0.34699 lineto
stroke
0 0 0 setrgbcolor
0.54858 0.34699 moveto
0.55066 0.34899 lineto
stroke
1 0 0 setrgbcolor
0.54407 0.35264 moveto
0.54555 0.35274 lineto
stroke
0 0 0 setrgbcolor
0.55273 0.3593 moveto
0.55066 0.36252 lineto
stroke
0 0 0 setrgbcolor
0.55337 0.35556 moveto
0.55273 0.3593 lineto
stroke
0 0 0 setrgbcolor
0.55066 0.36252 moveto
0.54774 0.36473 lineto
stroke
0 0 0 setrgbcolor
0.55066 0.34899 moveto
0.55252 0.35194 lineto
stroke
0 0 0 setrgbcolor
0.55252 0.35194 moveto
0.55337 0.35556 lineto
stroke
0 0 0 setrgbcolor
0.54774 0.36473 moveto
0.54489 0.36577 lineto
stroke
1 0 0 setrgbcolor
0.54555 0.35274 moveto
0.5483 0.35399 lineto
stroke
0 0 0 setrgbcolor
0.54489 0.36577 moveto
0.54311 0.36586 lineto
stroke
1 0 0 setrgbcolor
0.5515 0.36755 moveto
0.5491 0.37009 lineto
stroke
1 0 0 setrgbcolor
0.55298 0.36408 moveto
0.5515 0.36755 lineto
stroke
1 0 0 setrgbcolor
0.5483 0.35399 moveto
0.55111 0.35658 lineto
stroke
1 0 0 setrgbcolor
0.55287 0.36018 moveto
0.55298 0.36408 lineto
stroke
1 0 0 setrgbcolor
0.55111 0.35658 moveto
0.55287 0.36018 lineto
stroke
1 0 0 setrgbcolor
0.5491 0.37009 moveto
0.54672 0.37159 lineto
stroke
0 0 0 setrgbcolor
0.54311 0.36586 moveto
0.54306 0.36558 lineto
stroke
1 0 0 setrgbcolor
0.54672 0.37159 moveto
0.54523 0.37232 lineto
stroke
0 0 0 setrgbcolor
0.54306 0.36558 moveto
0.54491 0.36568 lineto
stroke
1 0 0 setrgbcolor
0.54523 0.37232 moveto
0.54508 0.37283 lineto
stroke
0 0 0 setrgbcolor
0.55182 0.38722 moveto
0.54724 0.38995 lineto
stroke
0 0 0 setrgbcolor
0.55501 0.38308 moveto
0.55182 0.38722 lineto
stroke
0 0 0 setrgbcolor
0.54724 0.38995 moveto
0.54244 0.39098 lineto
stroke
0 0 0 setrgbcolor
0.55607 0.37818 moveto
0.55501 0.38308 lineto
stroke
1 0 0 setrgbcolor
0.54508 0.37283 moveto
0.54624 0.37372 lineto
stroke
0 0 0 setrgbcolor
0.54491 0.36568 moveto
0.54818 0.36684 lineto
stroke
0 0 0 setrgbcolor
0.55485 0.37337 moveto
0.55607 0.37818 lineto
stroke
0 0 0 setrgbcolor
0.54244 0.39098 moveto
0.53873 0.39048 lineto
stroke
1 0 0 setrgbcolor
0.54624 0.37372 moveto
0.54816 0.37541 lineto
stroke
0 0 0 setrgbcolor
0.54818 0.36684 moveto
0.55188 0.36942 lineto
stroke
0 0 0 setrgbcolor
0.55188 0.36942 moveto
0.55485 0.37337 lineto
stroke
1 0 0 setrgbcolor
0.54816 0.37541 moveto
0.55004 0.37801 lineto
stroke
1 0 0 setrgbcolor
0.55004 0.37801 moveto
0.55113 0.38129 lineto
stroke
1 0 0 setrgbcolor
0.55098 0.38477 moveto
0.54958 0.38793 lineto
stroke
1 0 0 setrgbcolor
0.55113 0.38129 moveto
0.55098 0.38477 lineto
stroke
1 0 0 setrgbcolor
0.54958 0.38793 moveto
0.54739 0.39034 lineto
stroke
0 0 0 setrgbcolor
0.53873 0.39048 moveto
0.53718 0.38906 lineto
stroke
1 0 0 setrgbcolor
0.54739 0.39034 moveto
0.54512 0.39184 lineto
stroke
1 0 0 setrgbcolor
0.54512 0.39184 moveto
0.54355 0.39257 lineto
stroke
1 0 0 setrgbcolor
0.54355 0.39257 moveto
0.54325 0.39293 lineto
stroke
0 0 0 setrgbcolor
0.53718 0.38906 moveto
0.53833 0.38758 lineto
stroke
0 0 0 setrgbcolor
0.55003 0.41877 moveto
0.54272 0.42084 lineto
stroke
0 0 0 setrgbcolor
0.55618 0.41456 moveto
0.55003 0.41877 lineto
stroke
0 0 0 setrgbcolor
0.55992 0.40875 moveto
0.55618 0.41456 lineto
stroke
0 0 0 setrgbcolor
0.54272 0.42084 moveto
0.53578 0.42066 lineto
stroke
1 0 0 setrgbcolor
0.54325 0.39293 moveto
0.5444 0.39348 lineto
stroke
0 0 0 setrgbcolor
0.56057 0.40224 moveto
0.55992 0.40875 lineto
stroke
0 0 0 setrgbcolor
0.53833 0.38758 moveto
0.54205 0.38699 lineto
stroke
1 0 0 setrgbcolor
0.5444 0.39348 moveto
0.54673 0.39473 lineto
stroke
0 0 0 setrgbcolor
0.53578 0.42066 moveto
0.53073 0.4186 lineto
stroke
1 0 0 setrgbcolor
0.55106 0.41301 moveto
0.54754 0.41617 lineto
stroke
1 0 0 setrgbcolor
0.55317 0.40893 moveto
0.55106 0.41301 lineto
stroke
1 0 0 setrgbcolor
0.54754 0.41617 moveto
0.54336 0.41806 lineto
stroke
0 0 0 setrgbcolor
0.55814 0.39604 moveto
0.56057 0.40224 lineto
stroke
1 0 0 setrgbcolor
0.55348 0.40451 moveto
0.55317 0.40893 lineto
stroke
0 0 0 setrgbcolor
0.56773 0.89163 moveto
0.50617 0.89397 lineto
stroke
0 0 0 setrgbcolor
0.62687 0.88306 moveto
0.56773 0.89163 lineto
stroke
1 0 0 setrgbcolor
0.54673 0.39473 moveto
0.54959 0.39701 lineto
stroke
1 0 0 setrgbcolor
0.55211 0.40036 moveto
0.55348 0.40451 lineto
stroke
1 0 0 setrgbcolor
0.54336 0.41806 moveto
0.53949 0.41861 lineto
stroke
0 0 0 setrgbcolor
0.50617 0.89397 moveto
0.44405 0.89002 lineto
stroke
0 0 0 setrgbcolor
0.54205 0.38699 moveto
0.5475 0.38804 lineto
stroke
1 0 0 setrgbcolor
0.54959 0.39701 moveto
0.55211 0.40036 lineto
stroke
0 0 0 setrgbcolor
0.55336 0.39111 moveto
0.55814 0.39604 lineto
stroke
0 0 0 setrgbcolor
0.5475 0.38804 moveto
0.55336 0.39111 lineto
stroke
1 0 0 setrgbcolor
0.53949 0.41861 moveto
0.5369 0.41807 lineto
stroke
0 0 0 setrgbcolor
0.53073 0.4186 moveto
0.52875 0.41546 lineto
stroke
0 0 0 setrgbcolor
0.55156 0.45446 moveto
0.54101 0.45693 lineto
stroke
0 0 0 setrgbcolor
0.56051 0.44928 moveto
0.55156 0.45446 lineto
stroke
1 0 0 setrgbcolor
0.56776 0.88752 moveto
0.50788 0.89001 lineto
stroke
1 0 0 setrgbcolor
0.62522 0.87894 moveto
0.56776 0.88752 lineto
stroke
0 0 0 setrgbcolor
0.54101 0.45693 moveto
0.53062 0.45652 lineto
stroke
1 0 0 setrgbcolor
0.50788 0.89001 moveto
0.44739 0.88636 lineto
stroke
0 0 0 setrgbcolor
0.56642 0.44198 moveto
0.56051 0.44928 lineto
stroke
0 0 0 setrgbcolor
0.68175 0.8684 moveto
0.62687 0.88306 lineto
stroke
1 0 0 setrgbcolor
0.5369 0.41807 moveto
0.53632 0.41698 lineto
stroke
0 0 0 setrgbcolor
0.52875 0.41546 moveto
0.53042 0.4123 lineto
stroke
0 0 0 setrgbcolor
0.53062 0.45652 moveto
0.52213 0.45354 lineto
stroke
0 0 0 setrgbcolor
0.56838 0.43355 moveto
0.56642 0.44198 lineto
stroke
0 0 0 setrgbcolor
0.44405 0.89002 moveto
0.38327 0.8798 lineto
stroke
1 0 0 setrgbcolor
0.55195 0.44872 moveto
0.54491 0.45193 lineto
stroke
1 0 0 setrgbcolor
0.5573 0.44377 moveto
0.55195 0.44872 lineto
stroke
1 0 0 setrgbcolor
0.54491 0.45193 moveto
0.53735 0.4531 lineto
stroke
1 0 0 setrgbcolor
0.53632 0.41698 moveto
0.53804 0.41605 lineto
stroke
1 0 0 setrgbcolor
0.56012 0.43767 moveto
0.5573 0.44377 lineto
stroke
1 0 0 setrgbcolor
0.67842 0.86443 moveto
0.62522 0.87894 lineto
stroke
1 0 0 setrgbcolor
0.53735 0.4531 moveto
0.53061 0.45225 lineto
stroke
1 0 0 setrgbcolor
0.56007 0.43123 moveto
0.56012 0.43767 lineto
stroke
0 0 0 setrgbcolor
0.56618 0.42512 moveto
0.56838 0.43355 lineto
stroke
1 0 0 setrgbcolor
0.44739 0.88636 moveto
0.38818 0.87658 lineto
stroke
1 0 0 setrgbcolor
0.53804 0.41605 moveto
0.54188 0.416 lineto
stroke
0 0 0 setrgbcolor
0.55096 0.49859 moveto
0.53593 0.50075 lineto
stroke
0 0 0 setrgbcolor
0.56437 0.49301 moveto
0.55096 0.49859 lineto
stroke
0 0 0 setrgbcolor
0.53042 0.4123 moveto
0.53559 0.41023 lineto
stroke
0 0 0 setrgbcolor
0.52213 0.45354 moveto
0.51709 0.44874 lineto
stroke
0 0 0 setrgbcolor
0.53593 0.50075 moveto
0.52124 0.49939 lineto
stroke
1 0 0 setrgbcolor
0.53061 0.45225 moveto
0.52594 0.44981 lineto
stroke
1 0 0 setrgbcolor
0.55734 0.42528 moveto
0.56007 0.43123 lineto
stroke
0 0 0 setrgbcolor
0.57445 0.48454 moveto
0.56437 0.49301 lineto
stroke
0 0 0 setrgbcolor
0.53195 0.78887 moveto
0.4828 0.78758 lineto
stroke
0 0 0 setrgbcolor
0.58 0.7842 moveto
0.53195 0.78887 lineto
stroke
1 0 0 setrgbcolor
0.54188 0.416 moveto
0.54711 0.4174 lineto
stroke
1 0 0 setrgbcolor
0.55266 0.42052 moveto
0.55734 0.42528 lineto
stroke
0 0 0 setrgbcolor
0.56038 0.41788 moveto
0.56618 0.42512 lineto
stroke
0 0 0 setrgbcolor
0.62492 0.7737 moveto
0.58 0.7842 lineto
stroke
1 0 0 setrgbcolor
0.54711 0.4174 moveto
0.55266 0.42052 lineto
stroke
0 0 0 setrgbcolor
0.53559 0.41023 moveto
0.54335 0.41019 lineto
stroke
1 0 0 setrgbcolor
0.55162 0.49299 moveto
0.53971 0.49582 lineto
stroke
1 0 0 setrgbcolor
0.5618 0.48749 moveto
0.55162 0.49299 lineto
stroke
0 0 0 setrgbcolor
0.52124 0.49939 moveto
0.50882 0.49484 lineto
stroke
1 0 0 setrgbcolor
0.53971 0.49582 moveto
0.52764 0.49576 lineto
stroke
0 0 0 setrgbcolor
0.73048 0.84793 moveto
0.68175 0.8684 lineto
stroke
0 0 0 setrgbcolor
0.57992 0.4741 moveto
0.57445 0.48454 lineto
stroke
1 0 0 setrgbcolor
0.52594 0.44981 moveto
0.5243 0.44646 lineto
stroke
1 0 0 setrgbcolor
0.56895 0.47987 moveto
0.5618 0.48749 lineto
stroke
0 0 0 setrgbcolor
0.55221 0.41273 moveto
0.56038 0.41788 lineto
stroke
1 0 0 setrgbcolor
0.53324 0.78442 moveto
0.48596 0.78346 lineto
stroke
1 0 0 setrgbcolor
0.57935 0.77962 moveto
0.53324 0.78442 lineto
stroke
0 0 0 setrgbcolor
0.51709 0.44874 moveto
0.51651 0.44319 lineto
stroke
0 0 0 setrgbcolor
0.4828 0.78758 moveto
0.4346 0.78036 lineto
stroke
0 0 0 setrgbcolor
0.54913 0.55228 moveto
0.52824 0.55387 lineto
stroke
0 0 0 setrgbcolor
0.56848 0.54655 moveto
0.54913 0.55228 lineto
stroke
0 0 0 setrgbcolor
0.54335 0.41019 moveto
0.55221 0.41273 lineto
stroke
1 0 0 setrgbcolor
0.52764 0.49576 moveto
0.51704 0.49299 lineto
stroke
1 0 0 setrgbcolor
0.62234 0.76921 moveto
0.57935 0.77962 lineto
stroke
0 0 0 setrgbcolor
0.52824 0.55387 moveto
0.50792 0.55128 lineto
stroke
0 0 0 setrgbcolor
0.58437 0.53711 moveto
0.56848 0.54655 lineto
stroke
1 0 0 setrgbcolor
0.72552 0.84428 moveto
0.67842 0.86443 lineto
stroke
1 0 0 setrgbcolor
0.5722 0.47095 moveto
0.56895 0.47987 lineto
stroke
0 0 0 setrgbcolor
0.53353 0.69652 moveto
0.49572 0.69539 lineto
stroke
0 0 0 setrgbcolor
0.57046 0.69219 moveto
0.53353 0.69652 lineto
stroke
0 0 0 setrgbcolor
0.38327 0.8798 moveto
0.32584 0.86344 lineto
stroke
0 0 0 setrgbcolor
0.66473 0.75769 moveto
0.62492 0.7737 lineto
stroke
0 0 0 setrgbcolor
0.55147 0.61675 moveto
0.52319 0.61857 lineto
stroke
0 0 0 setrgbcolor
0.57792 0.61014 moveto
0.55147 0.61675 lineto
stroke
0 0 0 setrgbcolor
0.60442 0.68255 moveto
0.57046 0.69219 lineto
stroke
1 0 0 setrgbcolor
0.48596 0.78346 moveto
0.43953 0.77677 lineto
stroke
1 0 0 setrgbcolor
0.5243 0.44646 moveto
0.52618 0.44313 lineto
stroke
0 0 0 setrgbcolor
0.58013 0.46288 moveto
0.57992 0.4741 lineto
stroke
0 0 0 setrgbcolor
0.50882 0.49484 moveto
0.50043 0.48786 lineto
stroke
1 0 0 setrgbcolor
0.55005 0.54688 moveto
0.53193 0.54905 lineto
stroke
1 0 0 setrgbcolor
0.56652 0.54112 moveto
0.55005 0.54688 lineto
stroke
0 0 0 setrgbcolor
0.52319 0.61857 moveto
0.49521 0.61552 lineto
stroke
1 0 0 setrgbcolor
0.53193 0.54905 moveto
0.51399 0.54754 lineto
stroke
1 0 0 setrgbcolor
0.51704 0.49299 moveto
0.50943 0.48805 lineto
stroke
1 0 0 setrgbcolor
0.5797 0.53223 moveto
0.56652 0.54112 lineto
stroke
0 0 0 setrgbcolor
0.50792 0.55128 moveto
0.49023 0.54485 lineto
stroke
0 0 0 setrgbcolor
0.60052 0.59913 moveto
0.57792 0.61014 lineto
stroke
0 0 0 setrgbcolor
0.51651 0.44319 moveto
0.52072 0.43817 lineto
stroke
0 0 0 setrgbcolor
0.59521 0.52476 moveto
0.58437 0.53711 lineto
stroke
1 0 0 setrgbcolor
0.57125 0.46174 moveto
0.5722 0.47095 lineto
stroke
1 0 0 setrgbcolor
0.38818 0.87658 moveto
0.33222 0.8608 lineto
stroke
0 0 0 setrgbcolor
0.49572 0.69539 moveto
0.45921 0.68884 lineto
stroke
1 0 0 setrgbcolor
0.53514 0.69174 moveto
0.49945 0.69106 lineto
stroke
1 0 0 setrgbcolor
0.56986 0.68723 moveto
0.53514 0.69174 lineto
stroke
1 0 0 setrgbcolor
0.66028 0.75353 moveto
0.62234 0.76921 lineto
stroke
1 0 0 setrgbcolor
0.55206 0.61155 moveto
0.52624 0.61378 lineto
stroke
1 0 0 setrgbcolor
0.57597 0.60494 moveto
0.55206 0.61155 lineto
stroke
1 0 0 setrgbcolor
0.6016 0.67773 moveto
0.56986 0.68723 lineto
stroke
1 0 0 setrgbcolor
0.52624 0.61378 moveto
0.50051 0.61153 lineto
stroke
1 0 0 setrgbcolor
0.52618 0.44313 moveto
0.5315 0.44078 lineto
stroke
0 0 0 setrgbcolor
0.6334 0.66806 moveto
0.60442 0.68255 lineto
stroke
1 0 0 setrgbcolor
0.51399 0.54754 moveto
0.49812 0.54257 lineto
stroke
0 0 0 setrgbcolor
0.4346 0.78036 moveto
0.38948 0.76739 lineto
stroke
0 0 0 setrgbcolor
0.57515 0.45219 moveto
0.58013 0.46288 lineto
stroke
1 0 0 setrgbcolor
0.58827 0.52099 moveto
0.5797 0.53223 lineto
stroke
0 0 0 setrgbcolor
0.49521 0.61552 moveto
0.46972 0.60787 lineto
stroke
1 0 0 setrgbcolor
0.59614 0.59435 moveto
0.57597 0.60494 lineto
stroke
1 0 0 setrgbcolor
0.49945 0.69106 moveto
0.46487 0.68525 lineto
stroke
1 0 0 setrgbcolor
0.5664 0.4533 moveto
0.57125 0.46174 lineto
stroke
1 0 0 setrgbcolor
0.50943 0.48805 moveto
0.506 0.48178 lineto
stroke
0 0 0 setrgbcolor
0.50043 0.48786 moveto
0.49737 0.47955 lineto
stroke
0 0 0 setrgbcolor
0.61748 0.58442 moveto
0.60052 0.59913 lineto
stroke
0 0 0 setrgbcolor
0.52072 0.43817 moveto
0.52925 0.43491 lineto
stroke
1 0 0 setrgbcolor
0.43953 0.77677 moveto
0.39602 0.76453 lineto
stroke
1 0 0 setrgbcolor
0.62849 0.66369 moveto
0.6016 0.67773 lineto
stroke
1 0 0 setrgbcolor
0.5315 0.44078 moveto
0.53954 0.44024 lineto
stroke
0 0 0 setrgbcolor
0.59988 0.51062 moveto
0.59521 0.52476 lineto
stroke
1 0 0 setrgbcolor
0.50051 0.61153 moveto
0.4769 0.605 lineto
stroke
0 0 0 setrgbcolor
0.49023 0.54485 moveto
0.47711 0.53531 lineto
stroke
1 0 0 setrgbcolor
0.55855 0.44654 moveto
0.5664 0.4533 lineto
stroke
0 0 0 setrgbcolor
0.69755 0.73671 moveto
0.66473 0.75769 lineto
stroke
0 0 0 setrgbcolor
0.56585 0.4433 moveto
0.57515 0.45219 lineto
stroke
0 0 0 setrgbcolor
0.77116 0.82206 moveto
0.73048 0.84793 lineto
stroke
0 0 0 setrgbcolor
0.45921 0.68884 moveto
0.42617 0.6772 lineto
stroke
1 0 0 setrgbcolor
0.49812 0.54257 moveto
0.48606 0.53476 lineto
stroke
1 0 0 setrgbcolor
0.53954 0.44024 moveto
0.54907 0.4421 lineto
stroke
1 0 0 setrgbcolor
0.59137 0.50841 moveto
0.58827 0.52099 lineto
stroke
1 0 0 setrgbcolor
0.61097 0.5805 moveto
0.59614 0.59435 lineto
stroke
1 0 0 setrgbcolor
0.54907 0.4421 moveto
0.55855 0.44654 lineto
stroke
0 0 0 setrgbcolor
0.52925 0.43491 moveto
0.54087 0.43439 lineto
stroke
0 0 0 setrgbcolor
0.6556 0.6494 moveto
0.6334 0.66806 lineto
stroke
1 0 0 setrgbcolor
0.46487 0.68525 moveto
0.43348 0.67459 lineto
stroke
1 0 0 setrgbcolor
0.69135 0.7331 moveto
0.66028 0.75353 lineto
stroke
0 0 0 setrgbcolor
0.55376 0.43719 moveto
0.56585 0.4433 lineto
stroke
1 0 0 setrgbcolor
0.76466 0.81891 moveto
0.72552 0.84428 lineto
stroke
1 0 0 setrgbcolor
0.506 0.48178 moveto
0.50748 0.47527 lineto
stroke
0 0 0 setrgbcolor
0.46972 0.60787 moveto
0.44883 0.5962 lineto
stroke
0 0 0 setrgbcolor
0.54087 0.43439 moveto
0.55376 0.43719 lineto
stroke
0 0 0 setrgbcolor
0.49737 0.47955 moveto
0.50032 0.47123 lineto
stroke
0 0 0 setrgbcolor
0.62739 0.56705 moveto
0.61748 0.58442 lineto
stroke
0 0 0 setrgbcolor
0.5979 0.49602 moveto
0.59988 0.51062 lineto
stroke
1 0 0 setrgbcolor
0.4769 0.605 moveto
0.45736 0.59472 lineto
stroke
1 0 0 setrgbcolor
0.64884 0.64581 moveto
0.62849 0.66369 lineto
stroke
0 0 0 setrgbcolor
0.32584 0.86344 moveto
0.2739 0.84119 lineto
stroke
1 0 0 setrgbcolor
0.58877 0.4957 moveto
0.59137 0.50841 lineto
stroke
0 0 0 setrgbcolor
0.47711 0.53531 moveto
0.47016 0.52373 lineto
stroke
1 0 0 setrgbcolor
0.48606 0.53476 moveto
0.47929 0.525 lineto
stroke
1 0 0 setrgbcolor
0.61925 0.56436 moveto
0.61097 0.5805 lineto
stroke
0 0 0 setrgbcolor
0.38948 0.76739 moveto
0.34962 0.74908 lineto
stroke
1 0 0 setrgbcolor
0.33222 0.8608 moveto
0.28162 0.83927 lineto
stroke
1 0 0 setrgbcolor
0.50748 0.47527 moveto
0.51394 0.46968 lineto
stroke
1 0 0 setrgbcolor
0.39602 0.76453 moveto
0.35755 0.74711 lineto
stroke
0 0 0 setrgbcolor
0.42617 0.6772 moveto
0.39878 0.66107 lineto
stroke
0 0 0 setrgbcolor
0.50032 0.47123 moveto
0.50921 0.46434 lineto
stroke
0 0 0 setrgbcolor
0.58956 0.48242 moveto
0.5979 0.49602 lineto
stroke
1 0 0 setrgbcolor
0.58088 0.48409 moveto
0.58877 0.4957 lineto
stroke
1 0 0 setrgbcolor
0.43348 0.67459 moveto
0.40736 0.65964 lineto
stroke
0 0 0 setrgbcolor
0.72156 0.7115 moveto
0.69755 0.73671 lineto
stroke
0 0 0 setrgbcolor
0.66948 0.62757 moveto
0.6556 0.6494 lineto
stroke
0 0 0 setrgbcolor
0.44883 0.5962 moveto
0.43445 0.58143 lineto
stroke
0 0 0 setrgbcolor
0.62936 0.54829 moveto
0.62739 0.56705 lineto
stroke
1 0 0 setrgbcolor
0.45736 0.59472 moveto
0.44371 0.5815 lineto
stroke
1 0 0 setrgbcolor
0.51394 0.46968 moveto
0.52478 0.46614 lineto
stroke
1 0 0 setrgbcolor
0.71387 0.7087 moveto
0.69135 0.7331 lineto
stroke
1 0 0 setrgbcolor
0.66124 0.62505 moveto
0.64884 0.64581 lineto
stroke
1 0 0 setrgbcolor
0.62026 0.54715 moveto
0.61925 0.56436 lineto
stroke
1 0 0 setrgbcolor
0.47929 0.525 moveto
0.47881 0.51447 lineto
stroke
0 0 0 setrgbcolor
0.47016 0.52373 moveto
0.47044 0.51145 lineto
stroke
1 0 0 setrgbcolor
0.56878 0.4747 moveto
0.58088 0.48409 lineto
stroke
0 0 0 setrgbcolor
0.57593 0.47117 moveto
0.58956 0.48242 lineto
stroke
0 0 0 setrgbcolor
0.80185 0.79143 moveto
0.77116 0.82206 lineto
stroke
0 0 0 setrgbcolor
0.50921 0.46434 moveto
0.52312 0.46017 lineto
stroke
1 0 0 setrgbcolor
0.52478 0.46614 moveto
0.53874 0.46553 lineto
stroke
1 0 0 setrgbcolor
0.55408 0.46837 moveto
0.56878 0.4747 lineto
stroke
1 0 0 setrgbcolor
0.79397 0.78898 moveto
0.76466 0.81891 lineto
stroke
1 0 0 setrgbcolor
0.53874 0.46553 moveto
0.55408 0.46837 lineto
stroke
0 0 0 setrgbcolor
0.55878 0.46338 moveto
0.57593 0.47117 lineto
stroke
0 0 0 setrgbcolor
0.52312 0.46017 moveto
0.54038 0.45968 lineto
stroke
0 0 0 setrgbcolor
0.62316 0.52964 moveto
0.62936 0.54829 lineto
stroke
0 0 0 setrgbcolor
0.34962 0.74908 moveto
0.31726 0.72604 lineto
stroke
0 0 0 setrgbcolor
0.39878 0.66107 moveto
0.37908 0.64133 lineto
stroke
1 0 0 setrgbcolor
0.61391 0.53024 moveto
0.62026 0.54715 lineto
stroke
1 0 0 setrgbcolor
0.47881 0.51447 moveto
0.48505 0.50451 lineto
stroke
0 0 0 setrgbcolor
0.54038 0.45968 moveto
0.55878 0.46338 lineto
stroke
1 0 0 setrgbcolor
0.44371 0.5815 moveto
0.43741 0.56646 lineto
stroke
1 0 0 setrgbcolor
0.40736 0.65964 moveto
0.38846 0.64122 lineto
stroke
0 0 0 setrgbcolor
0.43445 0.58143 moveto
0.42814 0.56478 lineto
stroke
1 0 0 setrgbcolor
0.35755 0.74711 moveto
0.32628 0.72513 lineto
stroke
0 0 0 setrgbcolor
0.67393 0.60383 moveto
0.66948 0.62757 lineto
stroke
0 0 0 setrgbcolor
0.47044 0.51145 moveto
0.47833 0.49999 lineto
stroke
0 0 0 setrgbcolor
0.2739 0.84119 moveto
0.22977 0.81348 lineto
stroke
1 0 0 setrgbcolor
0.66473 0.60263 moveto
0.66124 0.62505 lineto
stroke
1 0 0 setrgbcolor
0.28162 0.83927 moveto
0.23866 0.81244 lineto
stroke
0 0 0 setrgbcolor
0.73523 0.68311 moveto
0.72156 0.7115 lineto
stroke
1 0 0 setrgbcolor
0.72635 0.68133 moveto
0.71387 0.7087 lineto
stroke
1 0 0 setrgbcolor
0.60082 0.51502 moveto
0.61391 0.53024 lineto
stroke
1 0 0 setrgbcolor
0.48505 0.50451 moveto
0.49772 0.49646 lineto
stroke
0 0 0 setrgbcolor
0.60932 0.51267 moveto
0.62316 0.52964 lineto
stroke
0 0 0 setrgbcolor
0.47833 0.49999 moveto
0.49338 0.49089 lineto
stroke
1 0 0 setrgbcolor
0.43741 0.56646 moveto
0.43946 0.55096 lineto
stroke
0 0 0 setrgbcolor
0.42814 0.56478 moveto
0.43095 0.54773 lineto
stroke
0 0 0 setrgbcolor
0.66839 0.57968 moveto
0.67393 0.60383 lineto
stroke
0 0 0 setrgbcolor
0.82071 0.75695 moveto
0.80185 0.79143 lineto
stroke
1 0 0 setrgbcolor
0.65888 0.57999 moveto
0.66473 0.60263 lineto
stroke
1 0 0 setrgbcolor
0.58234 0.50278 moveto
0.60082 0.51502 lineto
stroke
1 0 0 setrgbcolor
0.49772 0.49646 moveto
0.51575 0.49157 lineto
stroke
0 0 0 setrgbcolor
0.37908 0.64133 moveto
0.36888 0.61915 lineto
stroke
1 0 0 setrgbcolor
0.38846 0.64122 moveto
0.3785 0.62047 lineto
stroke
1 0 0 setrgbcolor
0.81169 0.75538 moveto
0.79397 0.78898 lineto
stroke
0 0 0 setrgbcolor
0.5892 0.49883 moveto
0.60932 0.51267 lineto
stroke
0 0 0 setrgbcolor
0.31726 0.72604 moveto
0.29459 0.69917 lineto
stroke
0 0 0 setrgbcolor
0.49338 0.49089 moveto
0.51429 0.48551 lineto
stroke
1 0 0 setrgbcolor
0.32628 0.72513 moveto
0.30433 0.69946 lineto
stroke
1 0 0 setrgbcolor
0.56041 0.49451 moveto
0.58234 0.50278 lineto
stroke
1 0 0 setrgbcolor
0.51575 0.49157 moveto
0.53739 0.49076 lineto
stroke
0 0 0 setrgbcolor
0.73734 0.65285 moveto
0.73523 0.68311 lineto
stroke
1 0 0 setrgbcolor
0.72774 0.65231 moveto
0.72635 0.68133 lineto
stroke
0 0 0 setrgbcolor
0.56489 0.48931 moveto
0.5892 0.49883 lineto
stroke
1 0 0 setrgbcolor
0.53739 0.49076 moveto
0.56041 0.49451 lineto
stroke
0 0 0 setrgbcolor
0.51429 0.48551 moveto
0.53899 0.48482 lineto
stroke
1 0 0 setrgbcolor
0.43946 0.55096 moveto
0.45022 0.53651 lineto
stroke
0 0 0 setrgbcolor
0.53899 0.48482 moveto
0.56489 0.48931 lineto
stroke
0 0 0 setrgbcolor
0.22977 0.81348 moveto
0.19591 0.78099 lineto
stroke
0 0 0 setrgbcolor
0.43095 0.54773 moveto
0.44321 0.53194 lineto
stroke
1 0 0 setrgbcolor
0.64398 0.55868 moveto
0.65888 0.57999 lineto
stroke
1 0 0 setrgbcolor
0.23866 0.81244 moveto
0.20571 0.78096 lineto
stroke
0 0 0 setrgbcolor
0.65306 0.55678 moveto
0.66839 0.57968 lineto
stroke
1 0 0 setrgbcolor
0.3785 0.62047 moveto
0.37882 0.59877 lineto
stroke
0 0 0 setrgbcolor
0.36888 0.61915 moveto
0.36959 0.59602 lineto
stroke
1 0 0 setrgbcolor
0.45022 0.53651 moveto
0.46926 0.52466 lineto
stroke
0 0 0 setrgbcolor
0.82612 0.71981 moveto
0.82071 0.75695 lineto
stroke
1 0 0 setrgbcolor
0.62111 0.54026 moveto
0.64398 0.55868 lineto
stroke
1 0 0 setrgbcolor
0.81631 0.71932 moveto
0.81169 0.75538 lineto
stroke
0 0 0 setrgbcolor
0.44321 0.53194 moveto
0.46441 0.51909 lineto
stroke
0 0 0 setrgbcolor
0.72726 0.62233 moveto
0.73734 0.65285 lineto
stroke
0 0 0 setrgbcolor
0.62899 0.53683 moveto
0.65306 0.55678 lineto
stroke
1 0 0 setrgbcolor
0.71751 0.62317 moveto
0.72774 0.65231 lineto
stroke
1 0 0 setrgbcolor
0.30433 0.69946 moveto
0.29365 0.67128 lineto
stroke
0 0 0 setrgbcolor
0.29459 0.69917 moveto
0.28367 0.6697 lineto
stroke
1 0 0 setrgbcolor
0.46926 0.52466 moveto
0.4953 0.51685 lineto
stroke
1 0 0 setrgbcolor
0.59213 0.52609 moveto
0.62111 0.54026 lineto
stroke
1 0 0 setrgbcolor
0.37882 0.59877 moveto
0.39015 0.57776 lineto
stroke
0 0 0 setrgbcolor
0.46441 0.51909 moveto
0.49309 0.51071 lineto
stroke
0 0 0 setrgbcolor
0.5981 0.52136 moveto
0.62899 0.53683 lineto
stroke
0 0 0 setrgbcolor
0.36959 0.59602 moveto
0.38198 0.57367 lineto
stroke
1 0 0 setrgbcolor
0.4953 0.51685 moveto
0.52628 0.51415 lineto
stroke
0 0 0 setrgbcolor
0.19591 0.78099 moveto
0.17486 0.74472 lineto
stroke
1 0 0 setrgbcolor
0.20571 0.78096 moveto
0.18523 0.74583 lineto
stroke
1 0 0 setrgbcolor
0.55955 0.51722 moveto
0.59213 0.52609 lineto
stroke
0 0 0 setrgbcolor
0.49309 0.51071 moveto
0.52695 0.50798 lineto
stroke
1 0 0 setrgbcolor
0.52628 0.51415 moveto
0.55955 0.51722 lineto
stroke
1 0 0 setrgbcolor
0.69587 0.59565 moveto
0.71751 0.62317 lineto
stroke
0 0 0 setrgbcolor
0.56304 0.51153 moveto
0.5981 0.52136 lineto
stroke
0 0 0 setrgbcolor
0.70515 0.59337 moveto
0.72726 0.62233 lineto
stroke
0 0 0 setrgbcolor
0.52695 0.50798 moveto
0.56304 0.51153 lineto
stroke
0 0 0 setrgbcolor
0.81691 0.68161 moveto
0.82612 0.71981 lineto
stroke
1 0 0 setrgbcolor
0.80677 0.68235 moveto
0.81631 0.71932 lineto
stroke
1 0 0 setrgbcolor
0.29365 0.67128 moveto
0.29587 0.64209 lineto
stroke
0 0 0 setrgbcolor
0.28367 0.6697 moveto
0.28618 0.63919 lineto
stroke
1 0 0 setrgbcolor
0.39015 0.57776 moveto
0.41247 0.55919 lineto
stroke
0 0 0 setrgbcolor
0.38198 0.57367 moveto
0.406 0.55398 lineto
stroke
1 0 0 setrgbcolor
0.66395 0.57153 moveto
0.69587 0.59565 lineto
stroke
0 0 0 setrgbcolor
0.67205 0.56785 moveto
0.70515 0.59337 lineto
stroke
1 0 0 setrgbcolor
0.41247 0.55919 moveto
0.4448 0.54481 lineto
stroke
0 0 0 setrgbcolor
0.406 0.55398 moveto
0.44059 0.53879 lineto
stroke
1 0 0 setrgbcolor
0.18523 0.74583 moveto
0.17956 0.7084 lineto
stroke
0 0 0 setrgbcolor
0.17486 0.74472 moveto
0.16906 0.70606 lineto
stroke
1 0 0 setrgbcolor
0.29587 0.64209 moveto
0.31204 0.6137 lineto
stroke
1 0 0 setrgbcolor
0.78268 0.64629 moveto
0.80677 0.68235 lineto
stroke
1 0 0 setrgbcolor
0.62378 0.55247 moveto
0.66395 0.57153 lineto
stroke
0 0 0 setrgbcolor
0.79259 0.64422 moveto
0.81691 0.68161 lineto
stroke
0 0 0 setrgbcolor
0.28618 0.63919 moveto
0.30324 0.60953 lineto
stroke
0 0 0 setrgbcolor
0.63006 0.54757 moveto
0.67205 0.56785 lineto
stroke
1 0 0 setrgbcolor
0.4448 0.54481 moveto
0.4852 0.53615 lineto
stroke
0 0 0 setrgbcolor
0.44059 0.53879 moveto
0.48362 0.52973 lineto
stroke
1 0 0 setrgbcolor
0.57825 0.53979 moveto
0.62378 0.55247 lineto
stroke
1 0 0 setrgbcolor
0.4852 0.53615 moveto
0.53083 0.5343 lineto
stroke
0 0 0 setrgbcolor
0.58217 0.53397 moveto
0.63006 0.54757 lineto
stroke
1 0 0 setrgbcolor
0.53083 0.5343 moveto
0.57825 0.53979 lineto
stroke
0 0 0 setrgbcolor
0.48362 0.52973 moveto
0.53205 0.52795 lineto
stroke
0 0 0 setrgbcolor
0.53205 0.52795 moveto
0.58217 0.53397 lineto
stroke
1 0 0 setrgbcolor
0.31204 0.6137 moveto
0.34234 0.58812 lineto
stroke
1 0 0 setrgbcolor
0.74462 0.6132 moveto
0.78268 0.64629 lineto
stroke
0 0 0 setrgbcolor
0.30324 0.60953 moveto
0.33506 0.58283 lineto
stroke
0 0 0 setrgbcolor
0.75367 0.60978 moveto
0.79259 0.64422 lineto
stroke
1 0 0 setrgbcolor
0.34234 0.58812 moveto
0.38589 0.56742 lineto
stroke
1 0 0 setrgbcolor
0.69429 0.58517 moveto
0.74462 0.6132 lineto
stroke
0 0 0 setrgbcolor
0.33506 0.58283 moveto
0.3807 0.56126 lineto
stroke
0 0 0 setrgbcolor
0.70183 0.58049 moveto
0.75367 0.60978 lineto
stroke
1 0 0 setrgbcolor
0.38589 0.56742 moveto
0.44058 0.55352 lineto
stroke
1 0 0 setrgbcolor
0.63457 0.5641 moveto
0.69429 0.58517 lineto
stroke
0 0 0 setrgbcolor
0.3807 0.56126 moveto
0.43792 0.54684 lineto
stroke
0 0 0 setrgbcolor
0.64001 0.55837 moveto
0.70183 0.58049 lineto
stroke
1 0 0 setrgbcolor
0.44058 0.55352 moveto
0.50313 0.54791 lineto
stroke
1 0 0 setrgbcolor
0.56934 0.55142 moveto
0.63457 0.5641 lineto
stroke
0 0 0 setrgbcolor
0.43792 0.54684 moveto
0.50324 0.54113 lineto
stroke
0 0 0 setrgbcolor
0.57223 0.54496 moveto
0.64001 0.55837 lineto
stroke
1 0 0 setrgbcolor
0.50313 0.54791 moveto
0.56934 0.55142 lineto
stroke
0 0 0 setrgbcolor
0.50324 0.54113 moveto
0.57223 0.54496 lineto
stroke
0 setgray
0.002 setlinewidth
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
% End of Graphics
Mpend % End of picture
:[font = input; ]
Show[%,ViewPoint->{1.3,-2.4,1.1}]
:[inactive; PostScript; output; endGroup; pictureLeft = 15; pictureWidth = 572; pictureHeight = 332; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.09207 0.22158 moveto
0.4296 0.46455 lineto
stroke
0.09207 0.22158 moveto
0.02806 0.86029 lineto
stroke
0.41829 0.97619 moveto
0.02806 0.86029 lineto
stroke
0.41829 0.97619 moveto
0.4296 0.46455 lineto
stroke
0.6859 0.02381 moveto
0.92236 0.34778 lineto
stroke
0.6859 0.02381 moveto
0.71294 0.76041 lineto
stroke
0.97194 0.92139 moveto
0.71294 0.76041 lineto
stroke
0.97194 0.92139 moveto
0.92236 0.34778 lineto
stroke
0.09207 0.22158 moveto
0.02806 0.86029 lineto
stroke
0.09207 0.22158 moveto
0.6859 0.02381 lineto
stroke
0.71294 0.76041 moveto
0.6859 0.02381 lineto
stroke
0.71294 0.76041 moveto
0.02806 0.86029 lineto
stroke
0.4296 0.46455 moveto
0.41829 0.97619 lineto
stroke
0.4296 0.46455 moveto
0.92236 0.34778 lineto
stroke
0.97194 0.92139 moveto
0.92236 0.34778 lineto
stroke
0.97194 0.92139 moveto
0.41829 0.97619 lineto
stroke
0.09207 0.22158 moveto
0.6859 0.02381 lineto
stroke
0.09207 0.22158 moveto
0.4296 0.46455 lineto
stroke
0.92236 0.34778 moveto
0.4296 0.46455 lineto
stroke
0.92236 0.34778 moveto
0.6859 0.02381 lineto
stroke
0.02806 0.86029 moveto
0.71294 0.76041 lineto
stroke
0.02806 0.86029 moveto
0.41829 0.97619 lineto
stroke
0.97194 0.92139 moveto
0.41829 0.97619 lineto
stroke
0.97194 0.92139 moveto
0.71294 0.76041 lineto
stroke
grestore
0 0 0 setrgbcolor
0.005 setlinewidth
0.57865 0.91507 moveto
0.51433 0.91775 lineto
stroke
0 0 0 setrgbcolor
0.64063 0.90936 moveto
0.57865 0.91507 lineto
stroke
0 0 0 setrgbcolor
0.51433 0.91775 moveto
0.44934 0.91741 lineto
stroke
1 0 0 setrgbcolor
0.57873 0.91309 moveto
0.5161 0.91585 lineto
stroke
1 0 0 setrgbcolor
0.639 0.90736 moveto
0.57873 0.91309 lineto
stroke
1 0 0 setrgbcolor
0.5161 0.91585 moveto
0.45276 0.91565 lineto
stroke
0 0 0 setrgbcolor
0.69858 0.90062 moveto
0.64063 0.90936 lineto
stroke
0 0 0 setrgbcolor
0.44934 0.91741 moveto
0.38538 0.91406 lineto
stroke
1 0 0 setrgbcolor
0.69523 0.89867 moveto
0.639 0.90736 lineto
stroke
1 0 0 setrgbcolor
0.45276 0.91565 moveto
0.39042 0.91251 lineto
stroke
0 0 0 setrgbcolor
0.7507 0.8889 moveto
0.69858 0.90062 lineto
stroke
0 0 0 setrgbcolor
0.38538 0.91406 moveto
0.32429 0.90777 lineto
stroke
1 0 0 setrgbcolor
0.74565 0.88709 moveto
0.69523 0.89867 lineto
stroke
1 0 0 setrgbcolor
0.39042 0.91251 moveto
0.33089 0.9065 lineto
stroke
0 0 0 setrgbcolor
0.54141 0.82108 moveto
0.48923 0.82186 lineto
stroke
0 0 0 setrgbcolor
0.59244 0.81703 moveto
0.54141 0.82108 lineto
stroke
0 0 0 setrgbcolor
0.64035 0.80974 moveto
0.59244 0.81703 lineto
stroke
0 0 0 setrgbcolor
0.48923 0.82186 moveto
0.43788 0.81941 lineto
stroke
1 0 0 setrgbcolor
0.54279 0.81864 moveto
0.49255 0.81961 lineto
stroke
1 0 0 setrgbcolor
0.59181 0.8145 moveto
0.54279 0.81864 lineto
stroke
1 0 0 setrgbcolor
0.63772 0.80724 moveto
0.59181 0.8145 lineto
stroke
1 0 0 setrgbcolor
0.56844 0.29328 moveto
0.56135 0.29617 lineto
stroke
1 0 0 setrgbcolor
0.56135 0.29617 moveto
0.5557 0.2964 lineto
stroke
1 0 0 setrgbcolor
0.49255 0.81961 moveto
0.44305 0.81744 lineto
stroke
0 0 0 setrgbcolor
0.68322 0.79931 moveto
0.64035 0.80974 lineto
stroke
1 0 0 setrgbcolor
0.5557 0.2964 moveto
0.5545 0.29541 lineto
stroke
0 0 0 setrgbcolor
0.79508 0.8743 moveto
0.7507 0.8889 lineto
stroke
0 0 0 setrgbcolor
0.56375 0.28873 moveto
0.56377 0.29135 lineto
stroke
0 0 0 setrgbcolor
0.56377 0.29135 moveto
0.56382 0.29401 lineto
stroke
0 0 0 setrgbcolor
0.56382 0.29401 moveto
0.56384 0.29675 lineto
stroke
1 0 0 setrgbcolor
0.56346 0.31662 moveto
0.55797 0.31825 lineto
stroke
1 0 0 setrgbcolor
0.56883 0.31292 moveto
0.56346 0.31662 lineto
stroke
0 0 0 setrgbcolor
0.56384 0.29675 moveto
0.56366 0.29954 lineto
stroke
1 0 0 setrgbcolor
0.5714 0.30754 moveto
0.56883 0.31292 lineto
stroke
0 0 0 setrgbcolor
0.56366 0.29954 moveto
0.56319 0.3023 lineto
stroke
1 0 0 setrgbcolor
0.67861 0.79697 moveto
0.63772 0.80724 lineto
stroke
0 0 0 setrgbcolor
0.56319 0.3023 moveto
0.56249 0.30489 lineto
stroke
0 0 0 setrgbcolor
0.43788 0.81941 moveto
0.38942 0.81382 lineto
stroke
1 0 0 setrgbcolor
0.55797 0.31825 moveto
0.55487 0.3184 lineto
stroke
1 0 0 setrgbcolor
0.5545 0.29541 moveto
0.55814 0.29523 lineto
stroke
1 0 0 setrgbcolor
0.78838 0.87271 moveto
0.74565 0.88709 lineto
stroke
0 0 0 setrgbcolor
0.56249 0.30489 moveto
0.56185 0.30725 lineto
stroke
1 0 0 setrgbcolor
0.56969 0.30178 moveto
0.5714 0.30754 lineto
stroke
0 0 0 setrgbcolor
0.56185 0.30725 moveto
0.5616 0.30943 lineto
stroke
0 0 0 setrgbcolor
0.32429 0.90777 moveto
0.26814 0.89862 lineto
stroke
0 0 0 setrgbcolor
0.5616 0.30943 moveto
0.56198 0.31164 lineto
stroke
1 0 0 setrgbcolor
0.55487 0.3184 moveto
0.55539 0.31831 lineto
stroke
0 0 0 setrgbcolor
0.56198 0.31164 moveto
0.56287 0.31411 lineto
stroke
1 0 0 setrgbcolor
0.56436 0.29731 moveto
0.56969 0.30178 lineto
stroke
1 0 0 setrgbcolor
0.55814 0.29523 moveto
0.56436 0.29731 lineto
stroke
1 0 0 setrgbcolor
0.44305 0.81744 moveto
0.39631 0.81224 lineto
stroke
0 0 0 setrgbcolor
0.56287 0.31411 moveto
0.56389 0.31698 lineto
stroke
0 0 0 setrgbcolor
0.56418 0.32358 moveto
0.56295 0.32675 lineto
stroke
0 0 0 setrgbcolor
0.56447 0.32021 moveto
0.56418 0.32358 lineto
stroke
0 0 0 setrgbcolor
0.56389 0.31698 moveto
0.56447 0.32021 lineto
stroke
0 0 0 setrgbcolor
0.56295 0.32675 moveto
0.56115 0.32944 lineto
stroke
1 0 0 setrgbcolor
0.33089 0.9065 moveto
0.27621 0.89769 lineto
stroke
0 0 0 setrgbcolor
0.54324 0.73157 moveto
0.50256 0.7323 lineto
stroke
0 0 0 setrgbcolor
0.58299 0.72753 moveto
0.54324 0.73157 lineto
stroke
1 0 0 setrgbcolor
0.56334 0.33934 moveto
0.55915 0.34159 lineto
stroke
1 0 0 setrgbcolor
0.56715 0.33571 moveto
0.56334 0.33934 lineto
stroke
0 0 0 setrgbcolor
0.56115 0.32944 moveto
0.55945 0.33155 lineto
stroke
1 0 0 setrgbcolor
0.56892 0.33099 moveto
0.56715 0.33571 lineto
stroke
1 0 0 setrgbcolor
0.55915 0.34159 moveto
0.55624 0.34274 lineto
stroke
0 0 0 setrgbcolor
0.61969 0.72024 moveto
0.58299 0.72753 lineto
stroke
0 0 0 setrgbcolor
0.55945 0.33155 moveto
0.55859 0.33322 lineto
stroke
1 0 0 setrgbcolor
0.55539 0.31831 moveto
0.55902 0.31922 lineto
stroke
1 0 0 setrgbcolor
0.56773 0.32602 moveto
0.56892 0.33099 lineto
stroke
0 0 0 setrgbcolor
0.55859 0.33322 moveto
0.55902 0.33483 lineto
stroke
1 0 0 setrgbcolor
0.55624 0.34274 moveto
0.5556 0.34347 lineto
stroke
0 0 0 setrgbcolor
0.71909 0.78596 moveto
0.68322 0.79931 lineto
stroke
1 0 0 setrgbcolor
0.56389 0.32183 moveto
0.56773 0.32602 lineto
stroke
1 0 0 setrgbcolor
0.55902 0.31922 moveto
0.56389 0.32183 lineto
stroke
0 0 0 setrgbcolor
0.50256 0.7323 moveto
0.46315 0.72977 lineto
stroke
0 0 0 setrgbcolor
0.56296 0.3546 moveto
0.55967 0.35742 lineto
stroke
0 0 0 setrgbcolor
0.56531 0.35095 moveto
0.56296 0.3546 lineto
stroke
0 0 0 setrgbcolor
0.55902 0.33483 moveto
0.56069 0.3368 lineto
stroke
1 0 0 setrgbcolor
0.54498 0.72867 moveto
0.50655 0.72968 lineto
stroke
1 0 0 setrgbcolor
0.58239 0.72451 moveto
0.54498 0.72867 lineto
stroke
0 0 0 setrgbcolor
0.56604 0.34687 moveto
0.56531 0.35095 lineto
stroke
0 0 0 setrgbcolor
0.55967 0.35742 moveto
0.55648 0.35929 lineto
stroke
0 0 0 setrgbcolor
0.5651 0.34289 moveto
0.56604 0.34687 lineto
stroke
1 0 0 setrgbcolor
0.5556 0.34347 moveto
0.55727 0.34457 lineto
stroke
0 0 0 setrgbcolor
0.56069 0.3368 moveto
0.56302 0.33946 lineto
stroke
1 0 0 setrgbcolor
0.61674 0.71729 moveto
0.58239 0.72451 lineto
stroke
0 0 0 setrgbcolor
0.55648 0.35929 moveto
0.55448 0.3604 lineto
stroke
0 0 0 setrgbcolor
0.56302 0.33946 moveto
0.5651 0.34289 lineto
stroke
1 0 0 setrgbcolor
0.5639 0.36177 moveto
0.56119 0.36487 lineto
stroke
1 0 0 setrgbcolor
0.56557 0.35792 moveto
0.5639 0.36177 lineto
stroke
1 0 0 setrgbcolor
0.56119 0.36487 moveto
0.55852 0.36712 lineto
stroke
1 0 0 setrgbcolor
0.56547 0.35372 moveto
0.56557 0.35792 lineto
stroke
1 0 0 setrgbcolor
0.7126 0.78391 moveto
0.67861 0.79697 lineto
stroke
0 0 0 setrgbcolor
0.65129 0.70992 moveto
0.61969 0.72024 lineto
stroke
1 0 0 setrgbcolor
0.55727 0.34457 moveto
0.56035 0.34662 lineto
stroke
1 0 0 setrgbcolor
0.50655 0.72968 moveto
0.4692 0.72759 lineto
stroke
1 0 0 setrgbcolor
0.55852 0.36712 moveto
0.55684 0.36875 lineto
stroke
0 0 0 setrgbcolor
0.55448 0.3604 moveto
0.55444 0.36122 lineto
stroke
1 0 0 setrgbcolor
0.56351 0.34976 moveto
0.56547 0.35372 lineto
stroke
1 0 0 setrgbcolor
0.56035 0.34662 moveto
0.56351 0.34976 lineto
stroke
0 0 0 setrgbcolor
0.56418 0.38597 moveto
0.55904 0.38921 lineto
stroke
0 0 0 setrgbcolor
0.56778 0.3816 moveto
0.56418 0.38597 lineto
stroke
0 0 0 setrgbcolor
0.55904 0.38921 moveto
0.55367 0.3911 lineto
stroke
1 0 0 setrgbcolor
0.55684 0.36875 moveto
0.55669 0.37022 lineto
stroke
0 0 0 setrgbcolor
0.56898 0.37662 moveto
0.56778 0.3816 lineto
stroke
0 0 0 setrgbcolor
0.55367 0.3911 moveto
0.54952 0.39178 lineto
stroke
0 0 0 setrgbcolor
0.55444 0.36122 moveto
0.55652 0.36234 lineto
stroke
0 0 0 setrgbcolor
0.38942 0.81382 moveto
0.34605 0.80527 lineto
stroke
0 0 0 setrgbcolor
0.56288 0.64967 moveto
0.53211 0.6522 lineto
stroke
0 0 0 setrgbcolor
0.59171 0.644 moveto
0.56288 0.64967 lineto
stroke
1 0 0 setrgbcolor
0.55669 0.37022 moveto
0.55799 0.37199 lineto
stroke
0 0 0 setrgbcolor
0.56765 0.3717 moveto
0.56898 0.37662 lineto
stroke
1 0 0 setrgbcolor
0.64609 0.70722 moveto
0.61674 0.71729 lineto
stroke
0 0 0 setrgbcolor
0.53211 0.6522 moveto
0.50166 0.65156 lineto
stroke
0 0 0 setrgbcolor
0.55652 0.36234 moveto
0.56019 0.36433 lineto
stroke
0 0 0 setrgbcolor
0.46315 0.72977 moveto
0.42724 0.72416 lineto
stroke
1 0 0 setrgbcolor
0.56168 0.38867 moveto
0.55921 0.39166 lineto
stroke
1 0 0 setrgbcolor
0.56326 0.38509 moveto
0.56168 0.38867 lineto
stroke
0 0 0 setrgbcolor
0.56206 0.42491 moveto
0.55391 0.42762 lineto
stroke
0 0 0 setrgbcolor
0.56895 0.42052 moveto
0.56206 0.42491 lineto
stroke
1 0 0 setrgbcolor
0.55799 0.37199 moveto
0.56014 0.3744 lineto
stroke
0 0 0 setrgbcolor
0.54952 0.39178 moveto
0.54779 0.39172 lineto
stroke
1 0 0 setrgbcolor
0.56345 0.38124 moveto
0.56326 0.38509 lineto
stroke
1 0 0 setrgbcolor
0.55921 0.39166 moveto
0.55667 0.39393 lineto
stroke
0 0 0 setrgbcolor
0.56434 0.36747 moveto
0.56765 0.3717 lineto
stroke
0 0 0 setrgbcolor
0.55391 0.42762 moveto
0.54617 0.42859 lineto
stroke
1 0 0 setrgbcolor
0.56224 0.37755 moveto
0.56345 0.38124 lineto
stroke
1 0 0 setrgbcolor
0.56014 0.3744 moveto
0.56224 0.37755 lineto
stroke
0 0 0 setrgbcolor
0.56019 0.36433 moveto
0.56434 0.36747 lineto
stroke
0 0 0 setrgbcolor
0.57317 0.41488 moveto
0.56895 0.42052 lineto
stroke
1 0 0 setrgbcolor
0.39631 0.81224 moveto
0.35447 0.80418 lineto
stroke
1 0 0 setrgbcolor
0.55667 0.39393 moveto
0.55492 0.39559 lineto
stroke
0 0 0 setrgbcolor
0.61649 0.63539 moveto
0.59171 0.644 lineto
stroke
0 0 0 setrgbcolor
0.82965 0.85702 moveto
0.79508 0.8743 lineto
stroke
1 0 0 setrgbcolor
0.55492 0.39559 moveto
0.55458 0.39696 lineto
stroke
0 0 0 setrgbcolor
0.54617 0.42859 moveto
0.54054 0.42811 lineto
stroke
1 0 0 setrgbcolor
0.56355 0.64626 moveto
0.53544 0.64907 lineto
stroke
1 0 0 setrgbcolor
0.58965 0.64057 moveto
0.56355 0.64626 lineto
stroke
1 0 0 setrgbcolor
0.4692 0.72759 moveto
0.43508 0.72258 lineto
stroke
0 0 0 setrgbcolor
0.56363 0.46805 moveto
0.55191 0.47107 lineto
stroke
0 0 0 setrgbcolor
0.57361 0.46298 moveto
0.56363 0.46805 lineto
stroke
0 0 0 setrgbcolor
0.54779 0.39172 moveto
0.54909 0.39163 lineto
stroke
0 0 0 setrgbcolor
0.57394 0.40867 moveto
0.57317 0.41488 lineto
stroke
0 0 0 setrgbcolor
0.55191 0.47107 moveto
0.54037 0.47192 lineto
stroke
0 0 0 setrgbcolor
0.56057 0.58011 moveto
0.53766 0.58248 lineto
stroke
0 0 0 setrgbcolor
0.58185 0.57485 moveto
0.56057 0.58011 lineto
stroke
1 0 0 setrgbcolor
0.53544 0.64907 moveto
0.50741 0.64895 lineto
stroke
1 0 0 setrgbcolor
0.55931 0.42399 moveto
0.55463 0.42657 lineto
stroke
1 0 0 setrgbcolor
0.56325 0.42042 moveto
0.55931 0.42399 lineto
stroke
1 0 0 setrgbcolor
0.56562 0.41613 moveto
0.56325 0.42042 lineto
stroke
0 0 0 setrgbcolor
0.50166 0.65156 moveto
0.47381 0.64792 lineto
stroke
0 0 0 setrgbcolor
0.53766 0.58248 moveto
0.51535 0.58197 lineto
stroke
1 0 0 setrgbcolor
0.55458 0.39696 moveto
0.55588 0.39848 lineto
stroke
0 0 0 setrgbcolor
0.56279 0.51964 moveto
0.54619 0.52242 lineto
stroke
0 0 0 setrgbcolor
0.57765 0.51437 moveto
0.56279 0.51964 lineto
stroke
1 0 0 setrgbcolor
0.55463 0.42657 moveto
0.55032 0.42811 lineto
stroke
0 0 0 setrgbcolor
0.58025 0.45629 moveto
0.57361 0.46298 lineto
stroke
0 0 0 setrgbcolor
0.67585 0.69691 moveto
0.65129 0.70992 lineto
stroke
0 0 0 setrgbcolor
0.54619 0.52242 moveto
0.52996 0.52265 lineto
stroke
1 0 0 setrgbcolor
0.566 0.41156 moveto
0.56562 0.41613 lineto
stroke
0 0 0 setrgbcolor
0.59943 0.56699 moveto
0.58185 0.57485 lineto
stroke
1 0 0 setrgbcolor
0.8214 0.85576 moveto
0.78838 0.87271 lineto
stroke
0 0 0 setrgbcolor
0.54037 0.47192 moveto
0.53094 0.47084 lineto
stroke
1 0 0 setrgbcolor
0.6118 0.63223 moveto
0.58965 0.64057 lineto
stroke
0 0 0 setrgbcolor
0.57126 0.4027 moveto
0.57394 0.40867 lineto
stroke
1 0 0 setrgbcolor
0.55588 0.39848 moveto
0.55849 0.40056 lineto
stroke
0 0 0 setrgbcolor
0.54909 0.39163 moveto
0.55327 0.39225 lineto
stroke
1 0 0 setrgbcolor
0.56449 0.4072 moveto
0.566 0.41156 lineto
stroke
1 0 0 setrgbcolor
0.55032 0.42811 moveto
0.54743 0.42882 lineto
stroke
0 0 0 setrgbcolor
0.54054 0.42811 moveto
0.53833 0.4268 lineto
stroke
0 0 0 setrgbcolor
0.58889 0.50697 moveto
0.57765 0.51437 lineto
stroke
1 0 0 setrgbcolor
0.55626 0.4673 moveto
0.54786 0.46934 lineto
stroke
1 0 0 setrgbcolor
0.56411 0.46371 moveto
0.55626 0.4673 lineto
stroke
1 0 0 setrgbcolor
0.55849 0.40056 moveto
0.56168 0.40346 lineto
stroke
1 0 0 setrgbcolor
0.56168 0.40346 moveto
0.56449 0.4072 lineto
stroke
1 0 0 setrgbcolor
0.57009 0.4588 moveto
0.56411 0.46371 lineto
stroke
0 0 0 setrgbcolor
0.746 0.77002 moveto
0.71909 0.78596 lineto
stroke
1 0 0 setrgbcolor
0.56162 0.57635 moveto
0.54171 0.57914 lineto
stroke
1 0 0 setrgbcolor
0.57976 0.57107 moveto
0.56162 0.57635 lineto
stroke
1 0 0 setrgbcolor
0.50741 0.64895 moveto
0.4816 0.64605 lineto
stroke
0 0 0 setrgbcolor
0.58251 0.44871 moveto
0.58025 0.45629 lineto
stroke
0 0 0 setrgbcolor
0.63531 0.62427 moveto
0.61649 0.63539 lineto
stroke
1 0 0 setrgbcolor
0.54171 0.57914 moveto
0.52201 0.57938 lineto
stroke
0 0 0 setrgbcolor
0.52996 0.52265 moveto
0.51622 0.52057 lineto
stroke
0 0 0 setrgbcolor
0.56594 0.3977 moveto
0.57126 0.4027 lineto
stroke
1 0 0 setrgbcolor
0.54786 0.46934 moveto
0.54037 0.46987 lineto
stroke
1 0 0 setrgbcolor
0.66862 0.69467 moveto
0.64609 0.70722 lineto
stroke
1 0 0 setrgbcolor
0.56356 0.51557 moveto
0.55039 0.51884 lineto
stroke
1 0 0 setrgbcolor
0.57486 0.51034 moveto
0.56356 0.51557 lineto
stroke
0 0 0 setrgbcolor
0.55327 0.39225 moveto
0.55938 0.39418 lineto
stroke
0 0 0 setrgbcolor
0.51535 0.58197 moveto
0.49587 0.57881 lineto
stroke
1 0 0 setrgbcolor
0.55039 0.51884 moveto
0.53704 0.52002 lineto
stroke
1 0 0 setrgbcolor
0.54743 0.42882 moveto
0.54679 0.42911 lineto
stroke
1 0 0 setrgbcolor
0.57327 0.45301 moveto
0.57009 0.4588 lineto
stroke
0 0 0 setrgbcolor
0.26814 0.89862 moveto
0.21928 0.88676 lineto
stroke
1 0 0 setrgbcolor
0.59435 0.56357 moveto
0.57976 0.57107 lineto
stroke
0 0 0 setrgbcolor
0.55938 0.39418 moveto
0.56594 0.3977 lineto
stroke
0 0 0 setrgbcolor
0.53094 0.47084 moveto
0.52532 0.4684 lineto
stroke
1 0 0 setrgbcolor
0.73784 0.76841 moveto
0.7126 0.78391 lineto
stroke
0 0 0 setrgbcolor
0.61155 0.55703 moveto
0.59943 0.56699 lineto
stroke
1 0 0 setrgbcolor
0.58285 0.50353 moveto
0.57486 0.51034 lineto
stroke
0 0 0 setrgbcolor
0.59508 0.49808 moveto
0.58889 0.50697 lineto
stroke
0 0 0 setrgbcolor
0.53833 0.4268 moveto
0.5402 0.42548 lineto
stroke
1 0 0 setrgbcolor
0.53704 0.52002 moveto
0.52531 0.51923 lineto
stroke
1 0 0 setrgbcolor
0.54037 0.46987 moveto
0.53517 0.4692 lineto
stroke
1 0 0 setrgbcolor
0.57326 0.44694 moveto
0.57327 0.45301 lineto
stroke
1 0 0 setrgbcolor
0.27621 0.89769 moveto
0.22868 0.88625 lineto
stroke
1 0 0 setrgbcolor
0.52201 0.57938 moveto
0.50454 0.57723 lineto
stroke
1 0 0 setrgbcolor
0.54679 0.42911 moveto
0.54872 0.42952 lineto
stroke
1 0 0 setrgbcolor
0.62827 0.62165 moveto
0.6118 0.63223 lineto
stroke
0 0 0 setrgbcolor
0.58014 0.4411 moveto
0.58251 0.44871 lineto
stroke
0 0 0 setrgbcolor
0.42724 0.72416 moveto
0.3971 0.71582 lineto
stroke
0 0 0 setrgbcolor
0.47381 0.64792 moveto
0.45079 0.64166 lineto
stroke
1 0 0 setrgbcolor
0.57026 0.44122 moveto
0.57326 0.44694 lineto
stroke
0 0 0 setrgbcolor
0.51622 0.52057 moveto
0.50689 0.51674 lineto
stroke
1 0 0 setrgbcolor
0.58655 0.49574 moveto
0.58285 0.50353 lineto
stroke
1 0 0 setrgbcolor
0.60394 0.55437 moveto
0.59435 0.56357 lineto
stroke
1 0 0 setrgbcolor
0.54872 0.42952 moveto
0.55301 0.43063 lineto
stroke
1 0 0 setrgbcolor
0.43508 0.72258 moveto
0.40637 0.71494 lineto
stroke
1 0 0 setrgbcolor
0.53517 0.4692 moveto
0.53335 0.46787 lineto
stroke
0 0 0 setrgbcolor
0.5402 0.42548 moveto
0.546 0.42501 lineto
stroke
1 0 0 setrgbcolor
0.4816 0.64605 moveto
0.4601 0.64069 lineto
stroke
1 0 0 setrgbcolor
0.52531 0.51923 moveto
0.51686 0.51688 lineto
stroke
0 0 0 setrgbcolor
0.52532 0.4684 moveto
0.52467 0.4654 lineto
stroke
0 0 0 setrgbcolor
0.49587 0.57881 moveto
0.48133 0.57349 lineto
stroke
1 0 0 setrgbcolor
0.56506 0.43641 moveto
0.57026 0.44122 lineto
stroke
0 0 0 setrgbcolor
0.57371 0.43437 moveto
0.58014 0.4411 lineto
stroke
0 0 0 setrgbcolor
0.59545 0.48856 moveto
0.59508 0.49808 lineto
stroke
1 0 0 setrgbcolor
0.55301 0.43063 moveto
0.55886 0.43285 lineto
stroke
1 0 0 setrgbcolor
0.55886 0.43285 moveto
0.56506 0.43641 lineto
stroke
0 0 0 setrgbcolor
0.34605 0.80527 moveto
0.31011 0.79407 lineto
stroke
0 0 0 setrgbcolor
0.64657 0.61127 moveto
0.63531 0.62427 lineto
stroke
1 0 0 setrgbcolor
0.50454 0.57723 moveto
0.49119 0.5731 lineto
stroke
0 0 0 setrgbcolor
0.61693 0.54573 moveto
0.61155 0.55703 lineto
stroke
0 0 0 setrgbcolor
0.69166 0.68178 moveto
0.67585 0.69691 lineto
stroke
0 0 0 setrgbcolor
0.546 0.42501 moveto
0.55469 0.42613 lineto
stroke
1 0 0 setrgbcolor
0.58559 0.48771 moveto
0.58655 0.49574 lineto
stroke
1 0 0 setrgbcolor
0.35447 0.80418 moveto
0.31979 0.79357 lineto
stroke
0 0 0 setrgbcolor
0.5646 0.42924 moveto
0.57371 0.43437 lineto
stroke
1 0 0 setrgbcolor
0.53335 0.46787 moveto
0.53546 0.46655 lineto
stroke
1 0 0 setrgbcolor
0.63768 0.60946 moveto
0.62827 0.62165 lineto
stroke
0 0 0 setrgbcolor
0.55469 0.42613 moveto
0.5646 0.42924 lineto
stroke
1 0 0 setrgbcolor
0.60756 0.54417 moveto
0.60394 0.55437 lineto
stroke
1 0 0 setrgbcolor
0.68276 0.68019 moveto
0.66862 0.69467 lineto
stroke
1 0 0 setrgbcolor
0.51686 0.51688 moveto
0.51303 0.51356 lineto
stroke
0 0 0 setrgbcolor
0.50689 0.51674 moveto
0.50343 0.51193 lineto
stroke
0 0 0 setrgbcolor
0.52467 0.4654 moveto
0.52936 0.46281 lineto
stroke
0 0 0 setrgbcolor
0.59003 0.47938 moveto
0.59545 0.48856 lineto
stroke
1 0 0 setrgbcolor
0.58027 0.48021 moveto
0.58559 0.48771 lineto
stroke
1 0 0 setrgbcolor
0.53546 0.46655 moveto
0.54139 0.46597 lineto
stroke
0 0 0 setrgbcolor
0.45079 0.64166 moveto
0.43471 0.63335 lineto
stroke
0 0 0 setrgbcolor
0.48133 0.57349 moveto
0.47349 0.56674 lineto
stroke
1 0 0 setrgbcolor
0.4601 0.64069 moveto
0.44488 0.63339 lineto
stroke
1 0 0 setrgbcolor
0.49119 0.5731 moveto
0.4836 0.56763 lineto
stroke
0 0 0 setrgbcolor
0.61499 0.53403 moveto
0.61693 0.54573 lineto
stroke
0 0 0 setrgbcolor
0.76216 0.75199 moveto
0.746 0.77002 lineto
stroke
1 0 0 setrgbcolor
0.57157 0.47394 moveto
0.58027 0.48021 lineto
stroke
0 0 0 setrgbcolor
0.52936 0.46281 moveto
0.53889 0.46154 lineto
stroke
0 0 0 setrgbcolor
0.85226 0.83739 moveto
0.82965 0.85702 lineto
stroke
1 0 0 setrgbcolor
0.54139 0.46597 moveto
0.55037 0.46678 lineto
stroke
1 0 0 setrgbcolor
0.60487 0.5338 moveto
0.60756 0.54417 lineto
stroke
1 0 0 setrgbcolor
0.51303 0.51356 moveto
0.51464 0.51008 lineto
stroke
0 0 0 setrgbcolor
0.57975 0.47151 moveto
0.59003 0.47938 lineto
stroke
0 0 0 setrgbcolor
0.3971 0.71582 moveto
0.37497 0.70523 lineto
stroke
0 0 0 setrgbcolor
0.64919 0.59721 moveto
0.64657 0.61127 lineto
stroke
1 0 0 setrgbcolor
0.75262 0.75095 moveto
0.73784 0.76841 lineto
stroke
1 0 0 setrgbcolor
0.40637 0.71494 moveto
0.38519 0.70517 lineto
stroke
0 0 0 setrgbcolor
0.50343 0.51193 moveto
0.50667 0.50713 lineto
stroke
1 0 0 setrgbcolor
0.84267 0.83658 moveto
0.8214 0.85576 lineto
stroke
1 0 0 setrgbcolor
0.56101 0.46939 moveto
0.57157 0.47394 lineto
stroke
1 0 0 setrgbcolor
0.55037 0.46678 moveto
0.56101 0.46939 lineto
stroke
1 0 0 setrgbcolor
0.63917 0.59643 moveto
0.63768 0.60946 lineto
stroke
0 0 0 setrgbcolor
0.53889 0.46154 moveto
0.55188 0.46237 lineto
stroke
0 0 0 setrgbcolor
0.56629 0.46569 moveto
0.57975 0.47151 lineto
stroke
0 0 0 setrgbcolor
0.69734 0.66524 moveto
0.69166 0.68178 lineto
stroke
0 0 0 setrgbcolor
0.55188 0.46237 moveto
0.56629 0.46569 lineto
stroke
1 0 0 setrgbcolor
0.51464 0.51008 moveto
0.52181 0.50727 lineto
stroke
0 0 0 setrgbcolor
0.60594 0.52295 moveto
0.61499 0.53403 lineto
stroke
1 0 0 setrgbcolor
0.59626 0.52416 moveto
0.60487 0.5338 lineto
stroke
1 0 0 setrgbcolor
0.6873 0.66448 moveto
0.68276 0.68019 lineto
stroke
1 0 0 setrgbcolor
0.4836 0.56763 moveto
0.48294 0.56161 lineto
stroke
0 0 0 setrgbcolor
0.47349 0.56674 moveto
0.47363 0.5595 lineto
stroke
0 0 0 setrgbcolor
0.21928 0.88676 moveto
0.18036 0.87245 lineto
stroke
0 0 0 setrgbcolor
0.50667 0.50713 moveto
0.51653 0.50336 lineto
stroke
1 0 0 setrgbcolor
0.44488 0.63339 moveto
0.43762 0.62488 lineto
stroke
0 0 0 setrgbcolor
0.43471 0.63335 moveto
0.42736 0.62377 lineto
stroke
1 0 0 setrgbcolor
0.22868 0.88625 moveto
0.19089 0.87243 lineto
stroke
0 0 0 setrgbcolor
0.31011 0.79407 moveto
0.28405 0.78066 lineto
stroke
1 0 0 setrgbcolor
0.31979 0.79357 moveto
0.29463 0.78083 lineto
stroke
0 0 0 setrgbcolor
0.64277 0.58308 moveto
0.64919 0.59721 lineto
stroke
1 0 0 setrgbcolor
0.52181 0.50727 moveto
0.53389 0.50596 lineto
stroke
1 0 0 setrgbcolor
0.58289 0.51607 moveto
0.59626 0.52416 lineto
stroke
1 0 0 setrgbcolor
0.63252 0.58349 moveto
0.63917 0.59643 lineto
stroke
0 0 0 setrgbcolor
0.59091 0.51351 moveto
0.60594 0.52295 lineto
stroke
0 0 0 setrgbcolor
0.51653 0.50336 moveto
0.53204 0.50159 lineto
stroke
1 0 0 setrgbcolor
0.48294 0.56161 moveto
0.48976 0.55599 lineto
stroke
1 0 0 setrgbcolor
0.53389 0.50596 moveto
0.54947 0.50681 lineto
stroke
1 0 0 setrgbcolor
0.56656 0.51018 moveto
0.58289 0.51607 lineto
stroke
0 0 0 setrgbcolor
0.37497 0.70523 moveto
0.36294 0.69309 lineto
stroke
1 0 0 setrgbcolor
0.38519 0.70517 moveto
0.37353 0.69391 lineto
stroke
0 0 0 setrgbcolor
0.766 0.73257 moveto
0.76216 0.75199 lineto
stroke
0 0 0 setrgbcolor
0.47363 0.5595 moveto
0.48223 0.55282 lineto
stroke
1 0 0 setrgbcolor
0.54947 0.50681 moveto
0.56656 0.51018 lineto
stroke
0 0 0 setrgbcolor
0.57185 0.50654 moveto
0.59091 0.51351 lineto
stroke
1 0 0 setrgbcolor
0.75554 0.73225 moveto
0.75262 0.75095 lineto
stroke
0 0 0 setrgbcolor
0.69209 0.64822 moveto
0.69734 0.66524 lineto
stroke
0 0 0 setrgbcolor
0.53204 0.50159 moveto
0.55131 0.50254 lineto
stroke
1 0 0 setrgbcolor
0.68161 0.64843 moveto
0.6873 0.66448 lineto
stroke
1 0 0 setrgbcolor
0.61831 0.57161 moveto
0.63252 0.58349 lineto
stroke
0 0 0 setrgbcolor
0.55131 0.50254 moveto
0.57185 0.50654 lineto
stroke
1 0 0 setrgbcolor
0.43762 0.62488 moveto
0.43953 0.61603 lineto
stroke
0 0 0 setrgbcolor
0.62779 0.56997 moveto
0.64277 0.58308 lineto
stroke
0 0 0 setrgbcolor
0.42736 0.62377 moveto
0.43003 0.61388 lineto
stroke
1 0 0 setrgbcolor
0.48976 0.55599 moveto
0.50377 0.55171 lineto
stroke
0 0 0 setrgbcolor
0.86083 0.81596 moveto
0.85226 0.83739 lineto
stroke
1 0 0 setrgbcolor
0.85023 0.8157 moveto
0.84267 0.83658 lineto
stroke
0 0 0 setrgbcolor
0.48223 0.55282 moveto
0.49889 0.54778 lineto
stroke
1 0 0 setrgbcolor
0.59795 0.5617 moveto
0.61831 0.57161 lineto
stroke
0 0 0 setrgbcolor
0.60565 0.55894 moveto
0.62779 0.56997 lineto
stroke
1 0 0 setrgbcolor
0.50377 0.55171 moveto
0.52382 0.54965 lineto
stroke
1 0 0 setrgbcolor
0.29463 0.78083 moveto
0.28132 0.76657 lineto
stroke
0 0 0 setrgbcolor
0.28405 0.78066 moveto
0.27031 0.76567 lineto
stroke
1 0 0 setrgbcolor
0.37353 0.69391 moveto
0.37304 0.682 lineto
stroke
1 0 0 setrgbcolor
0.6658 0.63306 moveto
0.68161 0.64843 lineto
stroke
0 0 0 setrgbcolor
0.67591 0.63181 moveto
0.69209 0.64822 lineto
stroke
1 0 0 setrgbcolor
0.43953 0.61603 moveto
0.45113 0.60786 lineto
stroke
0 0 0 setrgbcolor
0.36294 0.69309 moveto
0.36276 0.68028 lineto
stroke
0 0 0 setrgbcolor
0.49889 0.54778 moveto
0.52218 0.54538 lineto
stroke
1 0 0 setrgbcolor
0.57361 0.55451 moveto
0.59795 0.5617 lineto
stroke
0 0 0 setrgbcolor
0.43003 0.61388 moveto
0.44326 0.6048 lineto
stroke
0 0 0 setrgbcolor
0.18036 0.87245 moveto
0.15433 0.8561 lineto
stroke
1 0 0 setrgbcolor
0.52382 0.54965 moveto
0.54796 0.55048 lineto
stroke
1 0 0 setrgbcolor
0.19089 0.87243 moveto
0.16568 0.85666 lineto
stroke
0 0 0 setrgbcolor
0.75651 0.71266 moveto
0.766 0.73257 lineto
stroke
1 0 0 setrgbcolor
0.74573 0.71317 moveto
0.75554 0.73225 lineto
stroke
0 0 0 setrgbcolor
0.57865 0.55086 moveto
0.60565 0.55894 lineto
stroke
1 0 0 setrgbcolor
0.54796 0.55048 moveto
0.57361 0.55451 lineto
stroke
0 0 0 setrgbcolor
0.52218 0.54538 moveto
0.54977 0.5463 lineto
stroke
0 0 0 setrgbcolor
0.54977 0.5463 moveto
0.57865 0.55086 lineto
stroke
1 0 0 setrgbcolor
0.64091 0.61941 moveto
0.6658 0.63306 lineto
stroke
1 0 0 setrgbcolor
0.45113 0.60786 moveto
0.47208 0.60142 lineto
stroke
0 0 0 setrgbcolor
0.64976 0.61715 moveto
0.67591 0.63181 lineto
stroke
0 0 0 setrgbcolor
0.44326 0.6048 moveto
0.4666 0.59767 lineto
stroke
0 0 0 setrgbcolor
0.85363 0.79348 moveto
0.86083 0.81596 lineto
stroke
1 0 0 setrgbcolor
0.84248 0.79389 moveto
0.85023 0.8157 lineto
stroke
1 0 0 setrgbcolor
0.37304 0.682 moveto
0.38476 0.67045 lineto
stroke
0 0 0 setrgbcolor
0.36276 0.68028 moveto
0.37557 0.66787 lineto
stroke
1 0 0 setrgbcolor
0.28132 0.76657 moveto
0.28194 0.75161 lineto
stroke
1 0 0 setrgbcolor
0.72311 0.69477 moveto
0.74573 0.71317 lineto
stroke
1 0 0 setrgbcolor
0.47208 0.60142 moveto
0.501 0.59768 lineto
stroke
1 0 0 setrgbcolor
0.60894 0.60847 moveto
0.64091 0.61941 lineto
stroke
0 0 0 setrgbcolor
0.73347 0.69337 moveto
0.75651 0.71266 lineto
stroke
0 0 0 setrgbcolor
0.27031 0.76567 moveto
0.2711 0.74994 lineto
stroke
0 0 0 setrgbcolor
0.61568 0.60531 moveto
0.64976 0.61715 lineto
stroke
0 0 0 setrgbcolor
0.4666 0.59767 moveto
0.4985 0.59355 lineto
stroke
1 0 0 setrgbcolor
0.501 0.59768 moveto
0.53557 0.5974 lineto
stroke
1 0 0 setrgbcolor
0.57271 0.601 moveto
0.60894 0.60847 lineto
stroke
1 0 0 setrgbcolor
0.16568 0.85666 moveto
0.15599 0.83954 lineto
stroke
0 0 0 setrgbcolor
0.57665 0.59718 moveto
0.61568 0.60531 lineto
stroke
0 0 0 setrgbcolor
0.15433 0.8561 moveto
0.14428 0.83834 lineto
stroke
1 0 0 setrgbcolor
0.53557 0.5974 moveto
0.57271 0.601 lineto
stroke
0 0 0 setrgbcolor
0.4985 0.59355 moveto
0.53633 0.59324 lineto
stroke
1 0 0 setrgbcolor
0.38476 0.67045 moveto
0.40891 0.66038 lineto
stroke
0 0 0 setrgbcolor
0.37557 0.66787 moveto
0.40155 0.65708 lineto
stroke
0 0 0 setrgbcolor
0.53633 0.59324 moveto
0.57665 0.59718 lineto
stroke
1 0 0 setrgbcolor
0.68863 0.6782 moveto
0.72311 0.69477 lineto
stroke
0 0 0 setrgbcolor
0.69778 0.67591 moveto
0.73347 0.69337 lineto
stroke
1 0 0 setrgbcolor
0.81847 0.77212 moveto
0.84248 0.79389 lineto
stroke
0 0 0 setrgbcolor
0.82955 0.77096 moveto
0.85363 0.79348 lineto
stroke
1 0 0 setrgbcolor
0.28194 0.75161 moveto
0.29807 0.73699 lineto
stroke
0 0 0 setrgbcolor
0.2711 0.74994 moveto
0.28808 0.73456 lineto
stroke
1 0 0 setrgbcolor
0.40891 0.66038 moveto
0.44457 0.65294 lineto
stroke
0 0 0 setrgbcolor
0.40155 0.65708 moveto
0.43973 0.6491 lineto
stroke
1 0 0 setrgbcolor
0.64443 0.66459 moveto
0.68863 0.6782 lineto
stroke
0 0 0 setrgbcolor
0.65158 0.66151 moveto
0.69778 0.67591 lineto
stroke
1 0 0 setrgbcolor
0.44457 0.65294 moveto
0.48959 0.64912 lineto
stroke
1 0 0 setrgbcolor
0.59376 0.65487 moveto
0.64443 0.66459 lineto
stroke
0 0 0 setrgbcolor
0.43973 0.6491 moveto
0.48775 0.64503 lineto
stroke
1 0 0 setrgbcolor
0.77833 0.75159 moveto
0.81847 0.77212 lineto
stroke
0 0 0 setrgbcolor
0.78861 0.74963 moveto
0.82955 0.77096 lineto
stroke
1 0 0 setrgbcolor
0.29807 0.73699 moveto
0.33035 0.72388 lineto
stroke
0 0 0 setrgbcolor
0.59824 0.65118 moveto
0.65158 0.66151 lineto
stroke
1 0 0 setrgbcolor
0.48959 0.64912 moveto
0.54068 0.64967 lineto
stroke
0 0 0 setrgbcolor
0.28808 0.73456 moveto
0.32196 0.72077 lineto
stroke
1 0 0 setrgbcolor
0.54068 0.64967 moveto
0.59376 0.65487 lineto
stroke
0 0 0 setrgbcolor
0.48775 0.64503 moveto
0.54206 0.64562 lineto
stroke
0 0 0 setrgbcolor
0.54206 0.64562 moveto
0.59824 0.65118 lineto
stroke
1 0 0 setrgbcolor
0.72359 0.73359 moveto
0.77833 0.75159 lineto
stroke
1 0 0 setrgbcolor
0.33035 0.72388 moveto
0.37811 0.71358 lineto
stroke
0 0 0 setrgbcolor
0.73226 0.73087 moveto
0.78861 0.74963 lineto
stroke
0 0 0 setrgbcolor
0.32196 0.72077 moveto
0.37205 0.70993 lineto
stroke
1 0 0 setrgbcolor
0.65735 0.71937 moveto
0.72359 0.73359 lineto
stroke
1 0 0 setrgbcolor
0.37811 0.71358 moveto
0.43911 0.70727 lineto
stroke
0 0 0 setrgbcolor
0.66366 0.716 moveto
0.73226 0.73087 lineto
stroke
0 0 0 setrgbcolor
0.37205 0.70993 moveto
0.43595 0.7033 lineto
stroke
1 0 0 setrgbcolor
0.58415 0.70994 moveto
0.65735 0.71937 lineto
stroke
1 0 0 setrgbcolor
0.43911 0.70727 moveto
0.50949 0.70589 lineto
stroke
0 0 0 setrgbcolor
0.5875 0.70611 moveto
0.66366 0.716 lineto
stroke
0 0 0 setrgbcolor
0.43595 0.7033 moveto
0.50958 0.70185 lineto
stroke
1 0 0 setrgbcolor
0.50949 0.70589 moveto
0.58415 0.70994 lineto
stroke
0 0 0 setrgbcolor
0.50958 0.70185 moveto
0.5875 0.70611 lineto
stroke
0 setgray
0.002 setlinewidth
0.6859 0.02381 moveto
0.92236 0.34778 lineto
stroke
0.6859 0.02381 moveto
0.71294 0.76041 lineto
stroke
0.97194 0.92139 moveto
0.71294 0.76041 lineto
stroke
0.97194 0.92139 moveto
0.92236 0.34778 lineto
stroke
0.09207 0.22158 moveto
0.02806 0.86029 lineto
stroke
0.09207 0.22158 moveto
0.6859 0.02381 lineto
stroke
0.71294 0.76041 moveto
0.6859 0.02381 lineto
stroke
0.71294 0.76041 moveto
0.02806 0.86029 lineto
stroke
0.02806 0.86029 moveto
0.71294 0.76041 lineto
stroke
0.02806 0.86029 moveto
0.41829 0.97619 lineto
stroke
0.97194 0.92139 moveto
0.41829 0.97619 lineto
stroke
0.97194 0.92139 moveto
0.71294 0.76041 lineto
stroke
% End of Graphics
Mpend % End of picture
:[inactive; startGroup; font = section; ]
Plots with pribbonfrenet
:[font = input; ]
clear;top=60;kappa[s_]=1.;tau[s_]=1.;width=.3;ds=.1;pribbonfrenet
:[inactive; PostScript; output; pictureLeft = 43; pictureWidth = 293; pictureHeight = 262; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.42805 0.53407 lineto
stroke
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.42805 0.53407 moveto
0.41259 0.97619 lineto
stroke
0.42805 0.53407 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.65131 0.02381 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
grestore
0.79 0.761 0.826 setrgbcolor
0.54004 0.58453 moveto
0.54721 0.65456 lineto
0.5545 0.57503 lineto
fill
0.734 0.721 0.839 setrgbcolor
0.54004 0.58453 moveto
0.5132 0.66295 lineto
0.54721 0.65456 lineto
fill
0.733 0.703 0.821 setrgbcolor
0.56852 0.56439 moveto
0.54721 0.65456 lineto
0.58089 0.64366 lineto
fill
0.794 0.765 0.826 setrgbcolor
0.56852 0.56439 moveto
0.5545 0.57503 lineto
0.54721 0.65456 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.54721 0.65456 moveto
0.5545 0.57503 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5132 0.66295 moveto
0.54721 0.65456 lineto
stroke
0.732 0.694 0.814 setrgbcolor
0.58182 0.55266 moveto
0.58089 0.64366 lineto
0.61376 0.63027 lineto
fill
0 0 0 setrgbcolor
0.54721 0.65456 moveto
0.58089 0.64366 lineto
stroke
0.786 0.738 0.808 setrgbcolor
0.58182 0.55266 moveto
0.56852 0.56439 lineto
0.58089 0.64366 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.56852 0.56439 moveto
0.58089 0.64366 lineto
stroke
0.732 0.731 0.849 setrgbcolor
0.5132 0.66295 moveto
0.52537 0.59291 lineto
0.47936 0.66886 lineto
fill
0.796 0.791 0.847 setrgbcolor
0.5132 0.66295 moveto
0.54004 0.58453 lineto
0.52537 0.59291 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5132 0.66295 moveto
0.53929 0.58672 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.53929 0.58672 moveto
0.54004 0.58453 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47936 0.66886 moveto
0.5132 0.66295 lineto
stroke
0.73 0.686 0.807 setrgbcolor
0.59416 0.53989 moveto
0.61376 0.63027 lineto
0.64533 0.6144 lineto
fill
0 0 0 setrgbcolor
0.58089 0.64366 moveto
0.61376 0.63027 lineto
stroke
0.778 0.715 0.793 setrgbcolor
0.59416 0.53989 moveto
0.58182 0.55266 lineto
0.61376 0.63027 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.58182 0.55266 moveto
0.61376 0.63027 lineto
stroke
0.729 0.739 0.859 setrgbcolor
0.47936 0.66886 moveto
0.51078 0.60015 lineto
0.44616 0.67233 lineto
fill
0.798 0.826 0.873 setrgbcolor
0.47936 0.66886 moveto
0.52537 0.59291 lineto
0.51078 0.60015 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.47936 0.66886 moveto
0.48079 0.66649 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.48079 0.66649 moveto
0.52175 0.5989 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52175 0.5989 moveto
0.52321 0.59649 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52321 0.59649 moveto
0.52409 0.59502 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52409 0.59502 moveto
0.52537 0.59291 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.44616 0.67233 moveto
0.47936 0.66886 lineto
stroke
0.728 0.678 0.801 setrgbcolor
0.60531 0.52614 moveto
0.64533 0.6144 lineto
0.67511 0.59611 lineto
fill
0 0 0 setrgbcolor
0.61376 0.63027 moveto
0.64533 0.6144 lineto
stroke
0.769 0.696 0.782 setrgbcolor
0.60531 0.52614 moveto
0.59416 0.53989 lineto
0.64533 0.6144 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.59416 0.53989 moveto
0.64533 0.6144 lineto
stroke
0.724 0.748 0.87 setrgbcolor
0.44616 0.67233 moveto
0.49651 0.60628 lineto
0.41411 0.67343 lineto
fill
0.793 0.865 0.902 setrgbcolor
0.44616 0.67233 moveto
0.51078 0.60015 lineto
0.49651 0.60628 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.44616 0.67233 moveto
0.44818 0.67007 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44818 0.67007 moveto
0.50569 0.60583 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50569 0.60583 moveto
0.50774 0.60354 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50774 0.60354 moveto
0.50942 0.60166 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50942 0.60166 moveto
0.51078 0.60015 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.41411 0.67343 moveto
0.44616 0.67233 lineto
stroke
0.725 0.671 0.796 setrgbcolor
0.61506 0.51149 moveto
0.67511 0.59611 lineto
0.7026 0.57549 lineto
fill
0 0 0 setrgbcolor
0.64533 0.6144 moveto
0.67511 0.59611 lineto
stroke
0.761 0.68 0.773 setrgbcolor
0.61506 0.51149 moveto
0.60531 0.52614 lineto
0.67511 0.59611 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60531 0.52614 moveto
0.60677 0.5276 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60677 0.5276 moveto
0.67511 0.59611 lineto
stroke
0.724 0.746 0.869 setrgbcolor
0.38369 0.67224 moveto
0.41411 0.67343 lineto
0.49651 0.60628 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.41411 0.67343 moveto
0.41671 0.67131 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41671 0.67131 moveto
0.49005 0.61154 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49005 0.61154 moveto
0.49265 0.60943 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49265 0.60943 moveto
0.49479 0.60768 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49479 0.60768 moveto
0.49651 0.60628 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.38369 0.67224 moveto
0.41411 0.67343 lineto
stroke
0.722 0.664 0.792 setrgbcolor
0.62318 0.49606 moveto
0.7026 0.57549 lineto
0.72731 0.55264 lineto
fill
0 0 0 setrgbcolor
0.67511 0.59611 moveto
0.7026 0.57549 lineto
stroke
0.752 0.666 0.765 setrgbcolor
0.62318 0.49606 moveto
0.61506 0.51149 lineto
0.7026 0.57549 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.61506 0.51149 moveto
0.61687 0.51282 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61687 0.51282 moveto
0.7026 0.57549 lineto
stroke
0.717 0.753 0.88 setrgbcolor
0.35541 0.66887 moveto
0.38369 0.67224 lineto
0.48283 0.61134 lineto
fill
0.719 0.947 0.953 setrgbcolor
0.38369 0.67224 moveto
0.49651 0.60628 lineto
0.48283 0.61134 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.38683 0.67031 moveto
0.47821 0.61418 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.47821 0.61418 moveto
0.48077 0.61261 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.48077 0.61261 moveto
0.48283 0.61134 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3858 0.67094 moveto
0.38683 0.67031 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38369 0.67224 moveto
0.3858 0.67094 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.35541 0.66887 moveto
0.38369 0.67224 lineto
stroke
0.719 0.658 0.788 setrgbcolor
0.62952 0.47997 moveto
0.72731 0.55264 lineto
0.74874 0.52774 lineto
fill
0 0 0 setrgbcolor
0.7026 0.57549 moveto
0.72731 0.55264 lineto
stroke
0.744 0.654 0.759 setrgbcolor
0.62952 0.47997 moveto
0.62318 0.49606 lineto
0.72731 0.55264 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62318 0.49606 moveto
0.62801 0.49869 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62801 0.49869 moveto
0.72731 0.55264 lineto
stroke
0.709 0.758 0.89 setrgbcolor
0.32978 0.66346 moveto
0.35541 0.66887 lineto
0.47 0.6154 lineto
fill
0.615 0.944 0.942 setrgbcolor
0.35541 0.66887 moveto
0.48283 0.61134 lineto
0.47 0.6154 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.35907 0.66717 moveto
0.46763 0.6165 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46763 0.6165 moveto
0.47 0.6154 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35786 0.66773 moveto
0.35907 0.66717 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35541 0.66887 moveto
0.35786 0.66773 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.32978 0.66346 moveto
0.35541 0.66887 lineto
stroke
0.715 0.653 0.786 setrgbcolor
0.63391 0.46336 moveto
0.74874 0.52774 lineto
0.76642 0.50099 lineto
fill
0 0 0 setrgbcolor
0.72731 0.55264 moveto
0.74874 0.52774 lineto
stroke
0.737 0.643 0.755 setrgbcolor
0.63391 0.46336 moveto
0.62952 0.47997 lineto
0.74874 0.52774 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62952 0.47997 moveto
0.63872 0.48366 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63872 0.48366 moveto
0.74874 0.52774 lineto
stroke
0.712 0.648 0.783 setrgbcolor
0.63624 0.44639 moveto
0.76642 0.50099 lineto
0.77988 0.47265 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.74874 0.52774 moveto
0.76642 0.50099 lineto
stroke
0.729 0.634 0.751 setrgbcolor
0.63624 0.44639 moveto
0.63391 0.46336 lineto
0.76642 0.50099 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63391 0.46336 moveto
0.63998 0.46508 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63998 0.46508 moveto
0.76642 0.50099 lineto
stroke
0.7 0.762 0.899 setrgbcolor
0.3073 0.65618 moveto
0.32978 0.66346 lineto
0.45826 0.61851 lineto
fill
0.455 0.884 0.881 setrgbcolor
0.32978 0.66346 moveto
0.47 0.6154 lineto
0.45826 0.61851 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.33254 0.66249 moveto
0.45826 0.61851 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.32978 0.66346 moveto
0.33254 0.66249 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.3073 0.65618 moveto
0.32978 0.66346 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.5545 0.57503 moveto
0.56852 0.56439 lineto
stroke
1 0 0 setrgbcolor
0.56852 0.56439 moveto
0.58182 0.55266 lineto
stroke
1 0 0 setrgbcolor
0.54004 0.58453 moveto
0.5545 0.57503 lineto
stroke
1 0 0 setrgbcolor
0.58182 0.55266 moveto
0.59416 0.53989 lineto
stroke
1 0 0 setrgbcolor
0.52537 0.59291 moveto
0.54004 0.58453 lineto
stroke
0.708 0.643 0.782 setrgbcolor
0.63641 0.42923 moveto
0.77988 0.47265 lineto
0.78872 0.44303 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.76642 0.50099 moveto
0.77988 0.47265 lineto
stroke
0.722 0.625 0.749 setrgbcolor
0.63641 0.42923 moveto
0.63624 0.44639 lineto
0.77988 0.47265 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63624 0.44639 moveto
0.63914 0.44692 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63914 0.44692 moveto
0.77988 0.47265 lineto
stroke
1 0 0 setrgbcolor
0.59416 0.53989 moveto
0.60531 0.52614 lineto
stroke
1 0 0 setrgbcolor
0.51078 0.60015 moveto
0.52537 0.59291 lineto
stroke
1 0 0 setrgbcolor
0.60531 0.52614 moveto
0.61506 0.51149 lineto
stroke
0.689 0.763 0.907 setrgbcolor
0.28849 0.64723 moveto
0.3073 0.65618 lineto
0.44785 0.62078 lineto
fill
0.267 0.773 0.781 setrgbcolor
0.3073 0.65618 moveto
0.45826 0.61851 lineto
0.44785 0.62078 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.44755 0.62086 moveto
0.44785 0.62078 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3073 0.65618 moveto
0.44755 0.62086 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.28849 0.64723 moveto
0.3073 0.65618 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.49651 0.60628 moveto
0.51078 0.60015 lineto
stroke
1 0 0 setrgbcolor
0.61506 0.51149 moveto
0.62318 0.49606 lineto
stroke
1 0 0 setrgbcolor
0.62318 0.49606 moveto
0.62952 0.47997 lineto
stroke
1 0 0 setrgbcolor
0.48283 0.61134 moveto
0.49651 0.60628 lineto
stroke
1 0 0 setrgbcolor
0.62952 0.47997 moveto
0.63391 0.46336 lineto
stroke
0.704 0.639 0.781 setrgbcolor
0.63439 0.41207 moveto
0.78872 0.44303 lineto
0.79256 0.4125 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.77988 0.47265 moveto
0.78872 0.44303 lineto
stroke
0.715 0.618 0.747 setrgbcolor
0.63439 0.41207 moveto
0.63641 0.42923 lineto
0.78872 0.44303 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63641 0.42923 moveto
0.78872 0.44303 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.78872 0.44303 moveto
0.79256 0.4125 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.47 0.6154 moveto
0.48283 0.61134 lineto
stroke
0.574 0.621 0.861 setrgbcolor
0.3637 0.16678 moveto
0.44442 0.26536 lineto
0.45667 0.26591 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.3637 0.16678 moveto
0.44086 0.26101 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44086 0.26101 moveto
0.44241 0.2629 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44241 0.2629 moveto
0.44442 0.26536 lineto
stroke
1 0 0 setrgbcolor
0.44442 0.26536 moveto
0.45667 0.26591 lineto
stroke
1 0 0 setrgbcolor
0.63391 0.46336 moveto
0.63624 0.44639 lineto
stroke
1 0 0 setrgbcolor
0.45826 0.61851 moveto
0.47 0.6154 lineto
stroke
0.678 0.761 0.914 setrgbcolor
0.27384 0.63685 moveto
0.28849 0.64723 lineto
0.439 0.62231 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.28849 0.64723 moveto
0.439 0.62231 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.27384 0.63685 moveto
0.28849 0.64723 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.63624 0.44639 moveto
0.63641 0.42923 lineto
stroke
0.587 0.61 0.842 setrgbcolor
0.3972 0.15938 moveto
0.45667 0.26591 lineto
0.47034 0.26766 lineto
fill
0.66 0.643 0.822 setrgbcolor
0.3637 0.16678 moveto
0.45667 0.26591 lineto
0.3972 0.15938 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.3972 0.15938 moveto
0.4552 0.26326 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4552 0.26326 moveto
0.45667 0.26591 lineto
stroke
1 0 0 setrgbcolor
0.45667 0.26591 moveto
0.47034 0.26766 lineto
stroke
1 0 0 setrgbcolor
0.63439 0.41207 moveto
0.63641 0.42923 lineto
stroke
1 0 0 setrgbcolor
0.44785 0.62078 moveto
0.45826 0.61851 lineto
stroke
0.704 0.639 0.78 setrgbcolor
0.79112 0.38148 moveto
0.63439 0.41207 lineto
0.79256 0.4125 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.63439 0.41207 moveto
0.79256 0.4125 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.79112 0.38148 moveto
0.79256 0.4125 lineto
stroke
0.599 0.601 0.825 setrgbcolor
0.434 0.15541 moveto
0.47034 0.26766 lineto
0.48514 0.27073 lineto
fill
0.661 0.638 0.816 setrgbcolor
0.3972 0.15938 moveto
0.47034 0.26766 lineto
0.434 0.15541 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43527 0.15934 moveto
0.47034 0.26766 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.434 0.15541 moveto
0.43527 0.15934 lineto
stroke
1 0 0 setrgbcolor
0.47034 0.26766 moveto
0.48514 0.27073 lineto
stroke
0.7 0.607 0.748 setrgbcolor
0.79112 0.38148 moveto
0.63018 0.39511 lineto
0.63439 0.41207 lineto
fill
1 0 0 setrgbcolor
0.63018 0.39511 moveto
0.63439 0.41207 lineto
stroke
1 0 0 setrgbcolor
0.439 0.62231 moveto
0.44785 0.62078 lineto
stroke
0.7 0.635 0.78 setrgbcolor
0.7842 0.35046 moveto
0.63018 0.39511 lineto
0.79112 0.38148 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.63018 0.39511 moveto
0.79112 0.38148 lineto
stroke
0.693 0.602 0.749 setrgbcolor
0.7842 0.35046 moveto
0.62382 0.37854 lineto
0.63018 0.39511 lineto
fill
1 0 0 setrgbcolor
0.62382 0.37854 moveto
0.63018 0.39511 lineto
stroke
0.61 0.594 0.81 setrgbcolor
0.47323 0.15521 moveto
0.48514 0.27073 lineto
0.50079 0.27522 lineto
fill
0.663 0.634 0.811 setrgbcolor
0.434 0.15541 moveto
0.48514 0.27073 lineto
0.47323 0.15521 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.47323 0.15521 moveto
0.48514 0.27073 lineto
stroke
1 0 0 setrgbcolor
0.48514 0.27073 moveto
0.50079 0.27522 lineto
stroke
0.697 0.632 0.78 setrgbcolor
0.77172 0.31996 moveto
0.62382 0.37854 lineto
0.7842 0.35046 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.62382 0.37854 moveto
0.77882 0.3514 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.77882 0.3514 moveto
0.7842 0.35046 lineto
stroke
0.686 0.598 0.751 setrgbcolor
0.77172 0.31996 moveto
0.61542 0.36255 lineto
0.62382 0.37854 lineto
fill
1 0 0 setrgbcolor
0.61542 0.36255 moveto
0.62382 0.37854 lineto
stroke
0.666 0.758 0.918 setrgbcolor
0.26382 0.62533 moveto
0.27384 0.63685 lineto
0.4319 0.62321 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.27384 0.63685 moveto
0.4319 0.62321 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.26382 0.62533 moveto
0.27384 0.63685 lineto
stroke
0.62 0.59 0.798 setrgbcolor
0.5139 0.15902 moveto
0.50079 0.27522 lineto
0.51693 0.2812 lineto
fill
0.665 0.631 0.805 setrgbcolor
0.47323 0.15521 moveto
0.50079 0.27522 lineto
0.5139 0.15902 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.50079 0.27522 moveto
0.5139 0.15902 lineto
stroke
1 0 0 setrgbcolor
0.50079 0.27522 moveto
0.51693 0.2812 lineto
stroke
0.693 0.63 0.781 setrgbcolor
0.75376 0.29054 moveto
0.61542 0.36255 lineto
0.77172 0.31996 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.61542 0.36255 moveto
0.61943 0.36146 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61943 0.36146 moveto
0.76644 0.3214 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76644 0.3214 moveto
0.77172 0.31996 lineto
stroke
0.679 0.594 0.753 setrgbcolor
0.75376 0.29054 moveto
0.6051 0.34735 lineto
0.61542 0.36255 lineto
fill
1 0 0 setrgbcolor
0.6051 0.34735 moveto
0.61542 0.36255 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.7842 0.35046 moveto
0.79112 0.38148 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.4319 0.62321 moveto
0.439 0.62231 lineto
stroke
0.63 0.587 0.787 setrgbcolor
0.55498 0.16695 moveto
0.51693 0.2812 lineto
0.53324 0.2887 lineto
fill
0.668 0.628 0.8 setrgbcolor
0.5139 0.15902 moveto
0.51693 0.2812 lineto
0.55498 0.16695 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5186 0.27621 moveto
0.55498 0.16695 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51787 0.27838 moveto
0.5186 0.27621 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51693 0.2812 moveto
0.51787 0.27838 lineto
stroke
1 0 0 setrgbcolor
0.51693 0.2812 moveto
0.53324 0.2887 lineto
stroke
0.689 0.628 0.782 setrgbcolor
0.73053 0.26277 moveto
0.6051 0.34735 lineto
0.75376 0.29054 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.6051 0.34735 moveto
0.60889 0.3459 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60889 0.3459 moveto
0.74869 0.29247 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.74869 0.29247 moveto
0.75376 0.29054 lineto
stroke
0.672 0.591 0.756 setrgbcolor
0.73053 0.26277 moveto
0.59308 0.33311 lineto
0.6051 0.34735 lineto
fill
1 0 0 setrgbcolor
0.59308 0.33311 moveto
0.6051 0.34735 lineto
stroke
0.639 0.586 0.778 setrgbcolor
0.59539 0.17895 moveto
0.53324 0.2887 lineto
0.54935 0.2977 lineto
fill
0.671 0.627 0.796 setrgbcolor
0.55498 0.16695 moveto
0.53324 0.2887 lineto
0.59539 0.17895 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.53927 0.27805 moveto
0.59321 0.1828 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.53324 0.2887 moveto
0.53927 0.27805 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59321 0.1828 moveto
0.59539 0.17895 lineto
stroke
1 0 0 setrgbcolor
0.53324 0.2887 moveto
0.54935 0.2977 lineto
stroke
0.685 0.626 0.784 setrgbcolor
0.70244 0.23722 moveto
0.59308 0.33311 lineto
0.73053 0.26277 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.59308 0.33311 moveto
0.59923 0.32997 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59923 0.32997 moveto
0.72582 0.26519 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.72582 0.26519 moveto
0.72735 0.2644 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.72735 0.2644 moveto
0.73053 0.26277 lineto
stroke
0.664 0.588 0.76 setrgbcolor
0.70244 0.23722 moveto
0.57959 0.32 lineto
0.59308 0.33311 lineto
fill
1 0 0 setrgbcolor
0.57959 0.32 moveto
0.59308 0.33311 lineto
stroke
0.648 0.586 0.771 setrgbcolor
0.63407 0.19488 moveto
0.54935 0.2977 lineto
0.56491 0.30816 lineto
fill
0.674 0.626 0.792 setrgbcolor
0.59539 0.17895 moveto
0.54935 0.2977 lineto
0.63407 0.19488 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5576 0.28769 moveto
0.63111 0.19847 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63111 0.19847 moveto
0.63407 0.19488 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54935 0.2977 moveto
0.5576 0.28769 lineto
stroke
1 0 0 setrgbcolor
0.54935 0.2977 moveto
0.56491 0.30816 lineto
stroke
0.681 0.625 0.786 setrgbcolor
0.67004 0.21443 moveto
0.57959 0.32 lineto
0.70244 0.23722 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.57959 0.32 moveto
0.58803 0.31432 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.69958 0.23915 moveto
0.70244 0.23722 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.69817 0.2401 moveto
0.69958 0.23915 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58803 0.31432 moveto
0.69817 0.2401 lineto
stroke
0.656 0.587 0.765 setrgbcolor
0.67004 0.21443 moveto
0.56491 0.30816 lineto
0.57959 0.32 lineto
fill
1 0 0 setrgbcolor
0.56491 0.30816 moveto
0.57959 0.32 lineto
stroke
0.678 0.625 0.789 setrgbcolor
0.63407 0.19488 moveto
0.56491 0.30816 lineto
0.67004 0.21443 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.56491 0.30816 moveto
0.57209 0.30176 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66637 0.21771 moveto
0.67004 0.21443 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57209 0.30176 moveto
0.66637 0.21771 lineto
stroke
1 0 0 setrgbcolor
0.42673 0.62363 moveto
0.4319 0.62321 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.77172 0.31996 moveto
0.7842 0.35046 lineto
stroke
0.644 0.745 0.922 setrgbcolor
0.25886 0.61299 moveto
0.42366 0.6237 lineto
0.26382 0.62533 lineto
fill
0 0 0 setrgbcolor
0.25886 0.61299 moveto
0.26382 0.62533 lineto
stroke
0.128 0 0 setrgbcolor
0.25886 0.61299 moveto
0.42673 0.62363 lineto
0.42366 0.6237 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.42366 0.6237 moveto
0.42673 0.62363 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.75376 0.29054 moveto
0.77172 0.31996 lineto
stroke
0.646 0.743 0.92 setrgbcolor
0.25886 0.61299 moveto
0.42366 0.6237 lineto
0.25933 0.60021 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.25886 0.61299 moveto
0.42366 0.6237 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.25886 0.61299 moveto
0.25933 0.60021 lineto
stroke
0 0 0 setrgbcolor
0.3637 0.16678 moveto
0.3972 0.15938 lineto
stroke
0 0.559 0.782 setrgbcolor
0.25933 0.60021 moveto
0.4228 0.6236 lineto
0.42423 0.62348 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.25933 0.60021 moveto
0.41857 0.62299 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41857 0.62299 moveto
0.4228 0.6236 lineto
stroke
1 0 0 setrgbcolor
0.4228 0.6236 moveto
0.42423 0.62348 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.73053 0.26277 moveto
0.75376 0.29054 lineto
stroke
0.057 0.589 0.862 setrgbcolor
0.26553 0.5874 moveto
0.42423 0.62348 lineto
0.42799 0.62352 lineto
fill
0.63 0.724 0.914 setrgbcolor
0.25933 0.60021 moveto
0.42423 0.62348 lineto
0.26553 0.5874 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.26553 0.5874 moveto
0.41311 0.62095 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41311 0.62095 moveto
0.41703 0.62184 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41703 0.62184 moveto
0.42016 0.62255 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42016 0.62255 moveto
0.42423 0.62348 lineto
stroke
1 0 0 setrgbcolor
0.42423 0.62348 moveto
0.42799 0.62352 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.3972 0.15938 moveto
0.434 0.15541 lineto
stroke
0 0 0 setrgbcolor
0.70244 0.23722 moveto
0.73053 0.26277 lineto
stroke
0 0 0 setrgbcolor
0.25933 0.60021 moveto
0.26553 0.5874 lineto
stroke
0.155 0.618 0.93 setrgbcolor
0.27762 0.57501 moveto
0.42799 0.62352 lineto
0.43407 0.6239 lineto
fill
0.627 0.713 0.908 setrgbcolor
0.26553 0.5874 moveto
0.42799 0.62352 lineto
0.27762 0.57501 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.28275 0.57667 moveto
0.41303 0.6187 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41303 0.6187 moveto
0.41754 0.62015 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41754 0.62015 moveto
0.42122 0.62134 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42122 0.62134 moveto
0.42416 0.62229 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42416 0.62229 moveto
0.42799 0.62352 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27762 0.57501 moveto
0.28275 0.57667 lineto
stroke
1 0 0 setrgbcolor
0.42799 0.62352 moveto
0.43407 0.6239 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.434 0.15541 moveto
0.47323 0.15521 lineto
stroke
0 0 0 setrgbcolor
0.67004 0.21443 moveto
0.70244 0.23722 lineto
stroke
0 0 0 setrgbcolor
0.63407 0.19488 moveto
0.67004 0.21443 lineto
stroke
0 0 0 setrgbcolor
0.47323 0.15521 moveto
0.5139 0.15902 lineto
stroke
0.259 0.634 0.962 setrgbcolor
0.29566 0.56354 moveto
0.43407 0.6239 lineto
0.44241 0.62479 lineto
fill
0.625 0.702 0.9 setrgbcolor
0.27762 0.57501 moveto
0.43407 0.6239 lineto
0.29566 0.56354 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.30045 0.56563 moveto
0.4204 0.61794 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4204 0.61794 moveto
0.42453 0.61974 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42453 0.61974 moveto
0.42789 0.62121 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42789 0.62121 moveto
0.43057 0.62238 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43057 0.62238 moveto
0.43407 0.6239 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29566 0.56354 moveto
0.30045 0.56563 lineto
stroke
1 0 0 setrgbcolor
0.43407 0.6239 moveto
0.44241 0.62479 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.59539 0.17895 moveto
0.63407 0.19488 lineto
stroke
0 0 0 setrgbcolor
0.5139 0.15902 moveto
0.55498 0.16695 lineto
stroke
0 0 0 setrgbcolor
0.55498 0.16695 moveto
0.59539 0.17895 lineto
stroke
0.35 0.635 0.96 setrgbcolor
0.31953 0.55347 moveto
0.44241 0.62479 lineto
0.45289 0.62637 lineto
fill
0.625 0.691 0.891 setrgbcolor
0.29566 0.56354 moveto
0.44241 0.62479 lineto
0.31953 0.55347 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.32381 0.55596 moveto
0.434 0.61991 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.434 0.61991 moveto
0.43696 0.62164 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43696 0.62164 moveto
0.43933 0.62301 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43933 0.62301 moveto
0.44241 0.62479 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3224 0.55514 moveto
0.32381 0.55596 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31953 0.55347 moveto
0.3224 0.55514 lineto
stroke
1 0 0 setrgbcolor
0.44241 0.62479 moveto
0.45289 0.62637 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.26553 0.5874 moveto
0.27762 0.57501 lineto
stroke
0.421 0.627 0.939 setrgbcolor
0.34892 0.54531 moveto
0.45289 0.62637 lineto
0.46536 0.62879 lineto
fill
0.626 0.681 0.881 setrgbcolor
0.31953 0.55347 moveto
0.45289 0.62637 lineto
0.34892 0.54531 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.35257 0.54816 moveto
0.44832 0.62281 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44832 0.62281 moveto
0.45031 0.62436 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.45031 0.62436 moveto
0.45289 0.62637 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35137 0.54722 moveto
0.35257 0.54816 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.34892 0.54531 moveto
0.35137 0.54722 lineto
stroke
1 0 0 setrgbcolor
0.45289 0.62637 moveto
0.46536 0.62879 lineto
stroke
0.474 0.616 0.91 setrgbcolor
0.38334 0.53954 moveto
0.46536 0.62879 lineto
0.47958 0.6322 lineto
fill
0.629 0.671 0.871 setrgbcolor
0.34892 0.54531 moveto
0.46536 0.62879 lineto
0.38334 0.53954 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.38624 0.54269 moveto
0.46333 0.62659 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46333 0.62659 moveto
0.46536 0.62879 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38529 0.54166 moveto
0.38624 0.54269 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38334 0.53954 moveto
0.38529 0.54166 lineto
stroke
1 0 0 setrgbcolor
0.46536 0.62879 moveto
0.47958 0.6322 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.27762 0.57501 moveto
0.29566 0.56354 lineto
stroke
0.703 0.658 0.802 setrgbcolor
0.84808 0.77515 moveto
0.6734 0.80095 lineto
0.84709 0.80412 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.6734 0.80095 moveto
0.84709 0.80412 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84709 0.80412 moveto
0.84808 0.77515 lineto
stroke
0.515 0.607 0.882 setrgbcolor
0.42211 0.53659 moveto
0.47958 0.6322 lineto
0.49528 0.63672 lineto
fill
0.632 0.663 0.862 setrgbcolor
0.38334 0.53954 moveto
0.47958 0.6322 lineto
0.42211 0.53659 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42414 0.53997 moveto
0.47816 0.62985 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.47816 0.62985 moveto
0.47958 0.6322 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42347 0.53886 moveto
0.42414 0.53997 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42211 0.53659 moveto
0.42347 0.53886 lineto
stroke
1 0 0 setrgbcolor
0.47958 0.6322 moveto
0.49528 0.63672 lineto
stroke
0.701 0.615 0.757 setrgbcolor
0.84808 0.77515 moveto
0.66962 0.78362 lineto
0.6734 0.80095 lineto
fill
1 0 0 setrgbcolor
0.66962 0.78362 moveto
0.6734 0.80095 lineto
stroke
0.545 0.599 0.858 setrgbcolor
0.46433 0.53681 moveto
0.49528 0.63672 lineto
0.51215 0.64246 lineto
fill
0.637 0.657 0.852 setrgbcolor
0.42211 0.53659 moveto
0.49528 0.63672 lineto
0.46433 0.53681 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.46543 0.54036 moveto
0.49528 0.63672 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46433 0.53681 moveto
0.46543 0.54036 lineto
stroke
1 0 0 setrgbcolor
0.49528 0.63672 moveto
0.51215 0.64246 lineto
stroke
0.698 0.653 0.801 setrgbcolor
0.84302 0.74591 moveto
0.66962 0.78362 lineto
0.84808 0.77515 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.66962 0.78362 moveto
0.84808 0.77515 lineto
stroke
0.693 0.609 0.757 setrgbcolor
0.84302 0.74591 moveto
0.66342 0.76653 lineto
0.66962 0.78362 lineto
fill
1 0 0 setrgbcolor
0.66342 0.76653 moveto
0.66962 0.78362 lineto
stroke
0.57 0.593 0.837 setrgbcolor
0.50898 0.54048 moveto
0.51215 0.64246 lineto
0.52984 0.64947 lineto
fill
0.641 0.651 0.844 setrgbcolor
0.46433 0.53681 moveto
0.51215 0.64246 lineto
0.50898 0.54048 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.50898 0.54048 moveto
0.51215 0.64246 lineto
stroke
1 0 0 setrgbcolor
0.51215 0.64246 moveto
0.52984 0.64947 lineto
stroke
0.693 0.649 0.801 setrgbcolor
0.83175 0.71682 moveto
0.66342 0.76653 lineto
0.84302 0.74591 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.66342 0.76653 moveto
0.83701 0.7466 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.83701 0.7466 moveto
0.84302 0.74591 lineto
stroke
0.684 0.603 0.759 setrgbcolor
0.83175 0.71682 moveto
0.65489 0.74987 lineto
0.66342 0.76653 lineto
fill
1 0 0 setrgbcolor
0.65489 0.74987 moveto
0.66342 0.76653 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84302 0.74591 moveto
0.84808 0.77515 lineto
stroke
0 0 0 setrgbcolor
0.29566 0.56354 moveto
0.31953 0.55347 lineto
stroke
0.688 0.645 0.801 setrgbcolor
0.81424 0.68836 moveto
0.65489 0.74987 lineto
0.83175 0.71682 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.65489 0.74987 moveto
0.65943 0.74902 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65943 0.74902 moveto
0.82577 0.71793 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.82577 0.71793 moveto
0.83175 0.71682 lineto
stroke
0.675 0.598 0.761 setrgbcolor
0.81424 0.68836 moveto
0.64415 0.73379 lineto
0.65489 0.74987 lineto
fill
1 0 0 setrgbcolor
0.64415 0.73379 moveto
0.65489 0.74987 lineto
stroke
0.59 0.589 0.819 setrgbcolor
0.5549 0.54777 moveto
0.52984 0.64947 lineto
0.54796 0.65781 lineto
fill
0.646 0.646 0.836 setrgbcolor
0.50898 0.54048 moveto
0.52984 0.64947 lineto
0.5549 0.54777 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.53045 0.64698 moveto
0.5549 0.54777 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52984 0.64947 moveto
0.53045 0.64698 lineto
stroke
1 0 0 setrgbcolor
0.52984 0.64947 moveto
0.54796 0.65781 lineto
stroke
0.683 0.642 0.803 setrgbcolor
0.79066 0.66104 moveto
0.64415 0.73379 lineto
0.81424 0.68836 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.64415 0.73379 moveto
0.64848 0.73263 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64848 0.73263 moveto
0.80844 0.68991 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.80844 0.68991 moveto
0.81424 0.68836 lineto
stroke
0.666 0.594 0.765 setrgbcolor
0.79066 0.66104 moveto
0.63142 0.71846 lineto
0.64415 0.73379 lineto
fill
1 0 0 setrgbcolor
0.63142 0.71846 moveto
0.64415 0.73379 lineto
stroke
0.607 0.587 0.805 setrgbcolor
0.60085 0.55869 moveto
0.54796 0.65781 lineto
0.56613 0.66748 lineto
fill
0.651 0.643 0.828 setrgbcolor
0.5549 0.54777 moveto
0.54796 0.65781 lineto
0.60085 0.55869 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55026 0.65351 moveto
0.59898 0.5622 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54926 0.65538 moveto
0.55026 0.65351 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54796 0.65781 moveto
0.54926 0.65538 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59898 0.5622 moveto
0.60085 0.55869 lineto
stroke
1 0 0 setrgbcolor
0.54796 0.65781 moveto
0.56613 0.66748 lineto
stroke
0.678 0.64 0.805 setrgbcolor
0.76135 0.63538 moveto
0.63142 0.71846 lineto
0.79066 0.66104 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.63142 0.71846 moveto
0.63852 0.7159 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63852 0.7159 moveto
0.78518 0.66302 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.78518 0.66302 moveto
0.79066 0.66104 lineto
stroke
0.656 0.591 0.77 setrgbcolor
0.76135 0.63538 moveto
0.61693 0.70404 lineto
0.63142 0.71846 lineto
fill
1 0 0 setrgbcolor
0.61693 0.70404 moveto
0.63142 0.71846 lineto
stroke
0.621 0.587 0.793 setrgbcolor
0.64561 0.57318 moveto
0.56613 0.66748 lineto
0.58393 0.67845 lineto
fill
0.657 0.641 0.822 setrgbcolor
0.60085 0.55869 moveto
0.56613 0.66748 lineto
0.64561 0.57318 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5738 0.65838 moveto
0.64281 0.5765 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64281 0.5765 moveto
0.64561 0.57318 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56613 0.66748 moveto
0.5738 0.65838 lineto
stroke
1 0 0 setrgbcolor
0.56613 0.66748 moveto
0.58393 0.67845 lineto
stroke
0.673 0.639 0.808 setrgbcolor
0.72687 0.61188 moveto
0.61693 0.70404 lineto
0.76135 0.63538 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.61693 0.70404 moveto
0.62333 0.701 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.75797 0.63699 moveto
0.76135 0.63538 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62333 0.701 moveto
0.75632 0.63777 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.75632 0.63777 moveto
0.75797 0.63699 lineto
stroke
0.646 0.589 0.776 setrgbcolor
0.72687 0.61188 moveto
0.60099 0.69067 lineto
0.61693 0.70404 lineto
fill
1 0 0 setrgbcolor
0.60099 0.69067 moveto
0.61693 0.70404 lineto
stroke
0.634 0.587 0.784 setrgbcolor
0.68798 0.59102 moveto
0.58393 0.67845 lineto
0.60099 0.69067 lineto
fill
0.662 0.639 0.817 setrgbcolor
0.64561 0.57318 moveto
0.58393 0.67845 lineto
0.68798 0.59102 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.59097 0.67254 moveto
0.68431 0.5941 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68431 0.5941 moveto
0.68798 0.59102 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58393 0.67845 moveto
0.59097 0.67254 lineto
stroke
1 0 0 setrgbcolor
0.58393 0.67845 moveto
0.60099 0.69067 lineto
stroke
0.667 0.639 0.812 setrgbcolor
0.68798 0.59102 moveto
0.60099 0.69067 lineto
0.72687 0.61188 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.60099 0.69067 moveto
0.60955 0.68531 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.72246 0.61465 moveto
0.72687 0.61188 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60955 0.68531 moveto
0.72246 0.61465 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.83175 0.71682 moveto
0.84302 0.74591 lineto
stroke
0 0 0 setrgbcolor
0.31953 0.55347 moveto
0.34892 0.54531 lineto
stroke
0 0 0 setrgbcolor
0.81424 0.68836 moveto
0.83175 0.71682 lineto
stroke
0 0 0 setrgbcolor
0.34892 0.54531 moveto
0.38334 0.53954 lineto
stroke
0 0 0 setrgbcolor
0.79066 0.66104 moveto
0.81424 0.68836 lineto
stroke
0 0 0 setrgbcolor
0.38334 0.53954 moveto
0.42211 0.53659 lineto
stroke
0 0 0 setrgbcolor
0.76135 0.63538 moveto
0.79066 0.66104 lineto
stroke
0 0 0 setrgbcolor
0.42211 0.53659 moveto
0.46433 0.53681 lineto
stroke
0 0 0 setrgbcolor
0.72687 0.61188 moveto
0.76135 0.63538 lineto
stroke
0 0 0 setrgbcolor
0.46433 0.53681 moveto
0.50898 0.54048 lineto
stroke
0 0 0 setrgbcolor
0.68798 0.59102 moveto
0.72687 0.61188 lineto
stroke
0 0 0 setrgbcolor
0.50898 0.54048 moveto
0.5549 0.54777 lineto
stroke
0 0 0 setrgbcolor
0.64561 0.57318 moveto
0.68798 0.59102 lineto
stroke
0 0 0 setrgbcolor
0.5549 0.54777 moveto
0.60085 0.55869 lineto
stroke
0 0 0 setrgbcolor
0.60085 0.55869 moveto
0.64561 0.57318 lineto
stroke
0 setgray
0.002 setlinewidth
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
% End of Graphics
Mpend % End of picture
:[font = input; ]
clear;top=125;kappa[s_]=1;tau[s_]:=Sin[s];width=.3;ds=.1;pribbonfrenet
:[inactive; PostScript; output; pictureLeft = 43; pictureWidth = 293; pictureHeight = 262; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.42805 0.53407 lineto
stroke
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.42805 0.53407 moveto
0.41259 0.97619 lineto
stroke
0.42805 0.53407 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.65131 0.02381 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
grestore
0.911 0.54 0.099 setrgbcolor
0.42621 0.55076 moveto
0.435 0.57053 lineto
0.43156 0.57411 lineto
fill
0 0 0.45 setrgbcolor
0.42621 0.55076 moveto
0.43124 0.5571 lineto
0.435 0.57053 lineto
fill
0.913 0.546 0.103 setrgbcolor
0.43156 0.57411 moveto
0.435 0.57053 lineto
0.44345 0.59041 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43156 0.57411 moveto
0.435 0.57053 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.42621 0.55076 moveto
0.435 0.57053 lineto
stroke
0 0 0 setrgbcolor
0.435 0.57053 moveto
0.44345 0.59041 lineto
stroke
0 0 0.451 setrgbcolor
0.41733 0.53115 moveto
0.42621 0.55076 lineto
0.43124 0.5571 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42621 0.55076 moveto
0.43124 0.5571 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.41733 0.53115 moveto
0.42621 0.55076 lineto
stroke
0.983 0.794 0.572 setrgbcolor
0.43156 0.57411 moveto
0.44345 0.59041 lineto
0.43181 0.59102 lineto
fill
0.954 0.644 0.405 setrgbcolor
0.43181 0.59102 moveto
0.44345 0.59041 lineto
0.45134 0.61033 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43181 0.59102 moveto
0.44345 0.59041 lineto
stroke
0.078 0.237 0.726 setrgbcolor
0.40861 0.51175 moveto
0.41733 0.53115 lineto
0.43091 0.54005 lineto
fill
0.249 0.213 0.62 setrgbcolor
0.41733 0.53115 moveto
0.43124 0.5571 lineto
0.43091 0.54005 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.41733 0.53115 moveto
0.43091 0.54005 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.40861 0.51175 moveto
0.41733 0.53115 lineto
stroke
0.92 0.742 0.643 setrgbcolor
0.43181 0.59102 moveto
0.45134 0.61033 lineto
0.43195 0.6078 lineto
fill
0.878 0.637 0.569 setrgbcolor
0.43189 0.62437 moveto
0.45134 0.61033 lineto
0.45843 0.63024 lineto
fill
0 0 0 setrgbcolor
0.44345 0.59041 moveto
0.45134 0.61033 lineto
stroke
0.921 0.741 0.641 setrgbcolor
0.43189 0.62437 moveto
0.43195 0.6078 lineto
0.45134 0.61033 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43195 0.6078 moveto
0.45134 0.61033 lineto
stroke
0.333 0.398 0.779 setrgbcolor
0.40031 0.49259 moveto
0.40861 0.51175 lineto
0.43064 0.52301 lineto
fill
0.432 0.364 0.68 setrgbcolor
0.40861 0.51175 moveto
0.43091 0.54005 lineto
0.43064 0.52301 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40861 0.51175 moveto
0.43064 0.52301 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.40031 0.49259 moveto
0.40861 0.51175 lineto
stroke
0.851 0.626 0.597 setrgbcolor
0.43155 0.64068 moveto
0.45843 0.63024 lineto
0.46453 0.65006 lineto
fill
0 0 0 setrgbcolor
0.45134 0.61033 moveto
0.45843 0.63024 lineto
stroke
0.874 0.7 0.662 setrgbcolor
0.43155 0.64068 moveto
0.43189 0.62437 lineto
0.45843 0.63024 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43189 0.62437 moveto
0.45843 0.63024 lineto
stroke
0.454 0.471 0.787 setrgbcolor
0.39269 0.47372 moveto
0.40031 0.49259 lineto
0.43047 0.50603 lineto
fill
0.519 0.437 0.703 setrgbcolor
0.40031 0.49259 moveto
0.43064 0.52301 lineto
0.43047 0.50603 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40031 0.49259 moveto
0.43047 0.50603 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.39269 0.47372 moveto
0.40031 0.49259 lineto
stroke
0.831 0.616 0.612 setrgbcolor
0.43083 0.65664 moveto
0.46453 0.65006 lineto
0.46946 0.66971 lineto
fill
0 0 0 setrgbcolor
0.45843 0.63024 moveto
0.46453 0.65006 lineto
stroke
0.843 0.671 0.668 setrgbcolor
0.43083 0.65664 moveto
0.43155 0.64068 lineto
0.46453 0.65006 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43155 0.64068 moveto
0.46453 0.65006 lineto
stroke
0.522 0.512 0.786 setrgbcolor
0.38601 0.45517 moveto
0.39269 0.47372 lineto
0.43047 0.48916 lineto
fill
0.569 0.481 0.715 setrgbcolor
0.39269 0.47372 moveto
0.43047 0.50603 lineto
0.43047 0.48916 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.39269 0.47372 moveto
0.43047 0.48916 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.38601 0.45517 moveto
0.39269 0.47372 lineto
stroke
0.816 0.608 0.62 setrgbcolor
0.42965 0.67217 moveto
0.46946 0.66971 lineto
0.47305 0.68909 lineto
fill
0 0 0 setrgbcolor
0.46453 0.65006 moveto
0.46946 0.66971 lineto
stroke
0.822 0.65 0.669 setrgbcolor
0.42965 0.67217 moveto
0.43083 0.65664 lineto
0.46946 0.66971 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43083 0.65664 moveto
0.46946 0.66971 lineto
stroke
0.564 0.539 0.785 setrgbcolor
0.38052 0.43699 moveto
0.38601 0.45517 lineto
0.43073 0.47246 lineto
fill
0.602 0.51 0.723 setrgbcolor
0.38601 0.45517 moveto
0.43047 0.48916 lineto
0.43073 0.47246 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4292 0.47187 moveto
0.43073 0.47246 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38601 0.45517 moveto
0.4292 0.47187 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.38052 0.43699 moveto
0.38601 0.45517 lineto
stroke
0.805 0.6 0.625 setrgbcolor
0.42791 0.68716 moveto
0.47305 0.68909 lineto
0.47516 0.70811 lineto
fill
0 0 0 setrgbcolor
0.46946 0.66971 moveto
0.47305 0.68909 lineto
stroke
0.806 0.633 0.666 setrgbcolor
0.42791 0.68716 moveto
0.42965 0.67217 lineto
0.47305 0.68909 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42965 0.67217 moveto
0.4338 0.67378 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4338 0.67378 moveto
0.47305 0.68909 lineto
stroke
0.593 0.559 0.785 setrgbcolor
0.37644 0.41921 moveto
0.38052 0.43699 lineto
0.43133 0.45598 lineto
fill
0.625 0.532 0.729 setrgbcolor
0.38052 0.43699 moveto
0.43073 0.47246 lineto
0.43133 0.45598 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.42937 0.45525 moveto
0.43133 0.45598 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38052 0.43699 moveto
0.42937 0.45525 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.37644 0.41921 moveto
0.38052 0.43699 lineto
stroke
0.796 0.594 0.628 setrgbcolor
0.4255 0.70152 moveto
0.47516 0.70811 lineto
0.47567 0.72665 lineto
fill
0 0 0 setrgbcolor
0.47305 0.68909 moveto
0.47516 0.70811 lineto
stroke
0.795 0.619 0.662 setrgbcolor
0.4255 0.70152 moveto
0.42791 0.68716 lineto
0.47516 0.70811 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42791 0.68716 moveto
0.43396 0.68984 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43396 0.68984 moveto
0.47516 0.70811 lineto
stroke
0.615 0.575 0.785 setrgbcolor
0.37399 0.40186 moveto
0.37644 0.41921 lineto
0.43239 0.4398 lineto
fill
0.643 0.55 0.735 setrgbcolor
0.37644 0.41921 moveto
0.43133 0.45598 lineto
0.43239 0.4398 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.37644 0.41921 moveto
0.43239 0.4398 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.37399 0.40186 moveto
0.37644 0.41921 lineto
stroke
0.79 0.589 0.629 setrgbcolor
0.42237 0.71512 moveto
0.47567 0.72665 lineto
0.47448 0.74458 lineto
fill
0 0 0 setrgbcolor
0.47516 0.70811 moveto
0.47567 0.72665 lineto
stroke
0.788 0.608 0.657 setrgbcolor
0.42237 0.71512 moveto
0.4255 0.70152 lineto
0.47567 0.72665 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4255 0.70152 moveto
0.4344 0.70598 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4344 0.70598 moveto
0.47567 0.72665 lineto
stroke
1 0 0 setrgbcolor
0.43124 0.5571 moveto
0.43156 0.57411 lineto
stroke
1 0 0 setrgbcolor
0.43156 0.57411 moveto
0.43181 0.59102 lineto
stroke
1 0 0 setrgbcolor
0.43091 0.54005 moveto
0.43124 0.5571 lineto
stroke
1 0 0 setrgbcolor
0.43181 0.59102 moveto
0.43195 0.6078 lineto
stroke
1 0 0 setrgbcolor
0.43064 0.52301 moveto
0.43091 0.54005 lineto
stroke
1 0 0 setrgbcolor
0.43189 0.62437 moveto
0.43195 0.6078 lineto
stroke
1 0 0 setrgbcolor
0.43047 0.50603 moveto
0.43064 0.52301 lineto
stroke
1 0 0 setrgbcolor
0.43155 0.64068 moveto
0.43189 0.62437 lineto
stroke
1 0 0 setrgbcolor
0.43047 0.50603 moveto
0.43047 0.48916 lineto
stroke
1 0 0 setrgbcolor
0.43083 0.65664 moveto
0.43155 0.64068 lineto
stroke
1 0 0 setrgbcolor
0.43047 0.48916 moveto
0.43073 0.47246 lineto
stroke
0.631 0.588 0.786 setrgbcolor
0.37338 0.385 moveto
0.37399 0.40186 lineto
0.43402 0.424 lineto
fill
0.656 0.566 0.741 setrgbcolor
0.37399 0.40186 moveto
0.43239 0.4398 lineto
0.43402 0.424 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.42925 0.42223 moveto
0.43402 0.424 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37399 0.40186 moveto
0.42925 0.42223 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.37338 0.385 moveto
0.37399 0.40186 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.43073 0.47246 moveto
0.43133 0.45598 lineto
stroke
0.786 0.586 0.629 setrgbcolor
0.41843 0.72782 moveto
0.47448 0.74458 lineto
0.47152 0.76176 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.47448 0.74458 moveto
0.47567 0.72665 lineto
stroke
0.783 0.598 0.65 setrgbcolor
0.41843 0.72782 moveto
0.42237 0.71512 lineto
0.47448 0.74458 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42237 0.71512 moveto
0.43616 0.72291 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43616 0.72291 moveto
0.47448 0.74458 lineto
stroke
1 0 0 setrgbcolor
0.42965 0.67217 moveto
0.43083 0.65664 lineto
stroke
1 0 0 setrgbcolor
0.43133 0.45598 moveto
0.43239 0.4398 lineto
stroke
1 0 0 setrgbcolor
0.42791 0.68716 moveto
0.42965 0.67217 lineto
stroke
1 0 0 setrgbcolor
0.43239 0.4398 moveto
0.43402 0.424 lineto
stroke
0.656 0.609 0.79 setrgbcolor
0.37338 0.385 moveto
0.43959 0.39382 lineto
0.37476 0.36866 lineto
fill
0.666 0.581 0.75 setrgbcolor
0.37338 0.385 moveto
0.43638 0.40864 lineto
0.43959 0.39382 lineto
fill
0.668 0.579 0.746 setrgbcolor
0.37338 0.385 moveto
0.43402 0.424 lineto
0.43638 0.40864 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.37338 0.385 moveto
0.43638 0.40864 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.37338 0.385 moveto
0.37476 0.36866 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.4255 0.70152 moveto
0.42791 0.68716 lineto
stroke
0.783 0.583 0.629 setrgbcolor
0.41366 0.73951 moveto
0.47152 0.76176 lineto
0.46674 0.77805 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.47152 0.76176 moveto
0.47448 0.74458 lineto
stroke
0.78 0.591 0.643 setrgbcolor
0.41366 0.73951 moveto
0.41843 0.72782 lineto
0.47152 0.76176 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.41843 0.72782 moveto
0.4433 0.74372 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4433 0.74372 moveto
0.47152 0.76176 lineto
stroke
1 0 0 setrgbcolor
0.43402 0.424 moveto
0.43638 0.40864 lineto
stroke
1 0 0 setrgbcolor
0.42237 0.71512 moveto
0.4255 0.70152 lineto
stroke
1 0 0 setrgbcolor
0.43638 0.40864 moveto
0.43959 0.39382 lineto
stroke
0.664 0.619 0.793 setrgbcolor
0.37476 0.36866 moveto
0.44379 0.37963 lineto
0.37826 0.3529 lineto
fill
0.675 0.594 0.756 setrgbcolor
0.37476 0.36866 moveto
0.43959 0.39382 lineto
0.44379 0.37963 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.37476 0.36866 moveto
0.43959 0.39382 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.37476 0.36866 moveto
0.37826 0.3529 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.41843 0.72782 moveto
0.42237 0.71512 lineto
stroke
0.782 0.582 0.629 setrgbcolor
0.40805 0.75005 moveto
0.46674 0.77805 lineto
0.46013 0.79328 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.46674 0.77805 moveto
0.47152 0.76176 lineto
stroke
0.781 0.585 0.635 setrgbcolor
0.40805 0.75005 moveto
0.41366 0.73951 lineto
0.46674 0.77805 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.41366 0.73951 moveto
0.46674 0.77805 lineto
stroke
1 0 0 setrgbcolor
0.43959 0.39382 moveto
0.44379 0.37963 lineto
stroke
1 0 0 setrgbcolor
0.41366 0.73951 moveto
0.41843 0.72782 lineto
stroke
0.682 0.606 0.763 setrgbcolor
0.37826 0.3529 moveto
0.44379 0.37963 lineto
0.4491 0.36617 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.37826 0.3529 moveto
0.44379 0.37963 lineto
stroke
1 0 0 setrgbcolor
0.44379 0.37963 moveto
0.4491 0.36617 lineto
stroke
0.671 0.627 0.797 setrgbcolor
0.37826 0.3529 moveto
0.4491 0.36617 lineto
0.384 0.33778 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.37826 0.3529 moveto
0.384 0.33778 lineto
stroke
0.783 0.582 0.629 setrgbcolor
0.40163 0.75932 moveto
0.46013 0.79328 lineto
0.45171 0.80727 lineto
fill
0 0 0 setrgbcolor
0.46013 0.79328 moveto
0.46674 0.77805 lineto
stroke
0.783 0.582 0.627 setrgbcolor
0.40163 0.75932 moveto
0.40805 0.75005 lineto
0.46013 0.79328 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.40805 0.75005 moveto
0.46013 0.79328 lineto
stroke
1 0 0 setrgbcolor
0.40805 0.75005 moveto
0.41366 0.73951 lineto
stroke
0.688 0.617 0.771 setrgbcolor
0.384 0.33778 moveto
0.4491 0.36617 lineto
0.45564 0.35354 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.384 0.33778 moveto
0.4491 0.36617 lineto
stroke
1 0 0 setrgbcolor
0.4491 0.36617 moveto
0.45564 0.35354 lineto
stroke
0.676 0.635 0.801 setrgbcolor
0.384 0.33778 moveto
0.45564 0.35354 lineto
0.39203 0.32336 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.384 0.33778 moveto
0.39203 0.32336 lineto
stroke
0.692 0.627 0.779 setrgbcolor
0.39203 0.32336 moveto
0.45564 0.35354 lineto
0.46348 0.34184 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.44442 0.34822 moveto
0.45564 0.35354 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39203 0.32336 moveto
0.44442 0.34822 lineto
stroke
1 0 0 setrgbcolor
0.45564 0.35354 moveto
0.46348 0.34184 lineto
stroke
1 0 0 setrgbcolor
0.40163 0.75932 moveto
0.40805 0.75005 lineto
stroke
0.784 0.584 0.63 setrgbcolor
0.39446 0.76718 moveto
0.45171 0.80727 lineto
0.44152 0.81985 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.45171 0.80727 moveto
0.46013 0.79328 lineto
stroke
0.789 0.581 0.619 setrgbcolor
0.39446 0.76718 moveto
0.40163 0.75932 lineto
0.45171 0.80727 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.40163 0.75932 moveto
0.45171 0.80727 lineto
stroke
0.694 0.637 0.787 setrgbcolor
0.40237 0.30972 moveto
0.46348 0.34184 lineto
0.47265 0.33117 lineto
fill
0.68 0.642 0.805 setrgbcolor
0.39203 0.32336 moveto
0.46348 0.34184 lineto
0.40237 0.30972 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40237 0.30972 moveto
0.40481 0.31099 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44967 0.33458 moveto
0.46348 0.34184 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43727 0.32806 moveto
0.44967 0.33458 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40481 0.31099 moveto
0.43727 0.32806 lineto
stroke
1 0 0 setrgbcolor
0.46348 0.34184 moveto
0.47265 0.33117 lineto
stroke
1 0 0 setrgbcolor
0.39446 0.76718 moveto
0.40163 0.75932 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.39203 0.32336 moveto
0.40237 0.30972 lineto
stroke
0.694 0.645 0.796 setrgbcolor
0.41502 0.29693 moveto
0.47265 0.33117 lineto
0.48318 0.32165 lineto
fill
0.683 0.648 0.809 setrgbcolor
0.40237 0.30972 moveto
0.47265 0.33117 lineto
0.41502 0.29693 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.41502 0.29693 moveto
0.41743 0.29836 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.45444 0.32035 moveto
0.47265 0.33117 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43462 0.30857 moveto
0.45444 0.32035 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41743 0.29836 moveto
0.43462 0.30857 lineto
stroke
1 0 0 setrgbcolor
0.47265 0.33117 moveto
0.48318 0.32165 lineto
stroke
0.786 0.588 0.632 setrgbcolor
0.38663 0.77356 moveto
0.44152 0.81985 lineto
0.42965 0.83083 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.44152 0.81985 moveto
0.45171 0.80727 lineto
stroke
0.797 0.583 0.611 setrgbcolor
0.38663 0.77356 moveto
0.39446 0.76718 lineto
0.44152 0.81985 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.39446 0.76718 moveto
0.44152 0.81985 lineto
stroke
1 0 0 setrgbcolor
0.38663 0.77356 moveto
0.39446 0.76718 lineto
stroke
0.693 0.651 0.804 setrgbcolor
0.4299 0.28509 moveto
0.48318 0.32165 lineto
0.495 0.31336 lineto
fill
0.684 0.652 0.812 setrgbcolor
0.41502 0.29693 moveto
0.48318 0.32165 lineto
0.4299 0.28509 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4299 0.28509 moveto
0.43248 0.28686 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4546 0.30204 moveto
0.48318 0.32165 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43248 0.28686 moveto
0.4546 0.30204 lineto
stroke
1 0 0 setrgbcolor
0.48318 0.32165 moveto
0.495 0.31336 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.40237 0.30972 moveto
0.41502 0.29693 lineto
stroke
0.789 0.593 0.635 setrgbcolor
0.37826 0.77836 moveto
0.42965 0.83083 lineto
0.41621 0.84002 lineto
fill
0 0 0 setrgbcolor
0.42965 0.83083 moveto
0.44152 0.81985 lineto
stroke
0.807 0.588 0.606 setrgbcolor
0.37826 0.77836 moveto
0.38663 0.77356 lineto
0.42965 0.83083 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.38663 0.77356 moveto
0.42965 0.83083 lineto
stroke
1 0 0 setrgbcolor
0.37826 0.77836 moveto
0.38663 0.77356 lineto
stroke
0.689 0.655 0.811 setrgbcolor
0.44691 0.27429 moveto
0.495 0.31336 lineto
0.50807 0.30639 lineto
fill
0.685 0.655 0.814 setrgbcolor
0.4299 0.28509 moveto
0.495 0.31336 lineto
0.44691 0.27429 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.44691 0.27429 moveto
0.4496 0.27648 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4496 0.27648 moveto
0.495 0.31336 lineto
stroke
1 0 0 setrgbcolor
0.495 0.31336 moveto
0.50807 0.30639 lineto
stroke
0.875 0.698 0.658 setrgbcolor
0.81825 0.48151 moveto
0.84889 0.50776 lineto
0.8471 0.48402 lineto
fill
0.875 0.697 0.656 setrgbcolor
0.84421 0.46034 moveto
0.81825 0.48151 lineto
0.8471 0.48402 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.81825 0.48151 moveto
0.8471 0.48402 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.8471 0.48402 moveto
0.84889 0.50776 lineto
stroke
0 0 0 setrgbcolor
0.84421 0.46034 moveto
0.8471 0.48402 lineto
stroke
0.833 0.61 0.6 setrgbcolor
0.84421 0.46034 moveto
0.81038 0.46515 lineto
0.81825 0.48151 lineto
fill
0.846 0.675 0.67 setrgbcolor
0.84005 0.43693 moveto
0.81038 0.46515 lineto
0.84421 0.46034 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.81038 0.46515 moveto
0.84421 0.46034 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84005 0.43693 moveto
0.84421 0.46034 lineto
stroke
0.909 0.724 0.64 setrgbcolor
0.82503 0.49808 moveto
0.84974 0.53139 lineto
0.84889 0.50776 lineto
fill
0.916 0.639 0.5 setrgbcolor
0.81825 0.48151 moveto
0.82503 0.49808 lineto
0.84889 0.50776 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.82503 0.49808 moveto
0.84889 0.50776 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84889 0.50776 moveto
0.84974 0.53139 lineto
stroke
0.802 0.596 0.622 setrgbcolor
0.84005 0.43693 moveto
0.80145 0.44913 lineto
0.81038 0.46515 lineto
fill
0.821 0.658 0.68 setrgbcolor
0.83446 0.41398 moveto
0.80145 0.44913 lineto
0.84005 0.43693 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.80145 0.44913 moveto
0.84005 0.43693 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.83446 0.41398 moveto
0.84005 0.43693 lineto
stroke
0.685 0.657 0.815 setrgbcolor
0.44691 0.27429 moveto
0.50807 0.30639 lineto
0.46591 0.26465 lineto
fill
0.692 0.658 0.811 setrgbcolor
0.46043 0.26635 moveto
0.49615 0.31044 lineto
0.5113 0.30505 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.48683 0.29893 moveto
0.49615 0.31044 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46043 0.26635 moveto
0.48683 0.29893 lineto
stroke
1 0 0 setrgbcolor
0.49615 0.31044 moveto
0.5113 0.30505 lineto
stroke
0.945 0.754 0.614 setrgbcolor
0.83074 0.51475 moveto
0.84983 0.55471 lineto
0.84974 0.53139 lineto
fill
0.96 0.657 0.409 setrgbcolor
0.82503 0.49808 moveto
0.83074 0.51475 lineto
0.84974 0.53139 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.83223 0.51606 moveto
0.84974 0.53139 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.83074 0.51475 moveto
0.83223 0.51606 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84974 0.53139 moveto
0.84983 0.55471 lineto
stroke
0.779 0.586 0.64 setrgbcolor
0.83446 0.41398 moveto
0.7915 0.43355 lineto
0.80145 0.44913 lineto
fill
0.801 0.645 0.689 setrgbcolor
0.8273 0.3917 moveto
0.7915 0.43355 lineto
0.83446 0.41398 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.7915 0.43355 moveto
0.83304 0.41463 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.83304 0.41463 moveto
0.83446 0.41398 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.8273 0.3917 moveto
0.83446 0.41398 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.50793 0.30625 moveto
0.50807 0.30639 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.41502 0.29693 moveto
0.4299 0.28509 lineto
stroke
0.978 0.784 0.575 setrgbcolor
0.83538 0.53137 moveto
0.84931 0.57756 lineto
0.84983 0.55471 lineto
fill
0.966 0.651 0.265 setrgbcolor
0.83074 0.51475 moveto
0.83538 0.53137 lineto
0.84983 0.55471 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.83673 0.53355 moveto
0.84983 0.55471 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.83538 0.53137 moveto
0.83673 0.53355 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84931 0.57756 moveto
0.84983 0.55471 lineto
stroke
0.686 0.653 0.811 setrgbcolor
0.48271 0.25778 moveto
0.5113 0.30505 lineto
0.52731 0.30116 lineto
fill
0.698 0.658 0.806 setrgbcolor
0.46043 0.26635 moveto
0.5113 0.30505 lineto
0.48271 0.25778 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4855 0.26239 moveto
0.5113 0.30505 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.48519 0.26188 moveto
0.4855 0.26239 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.48271 0.25778 moveto
0.48519 0.26188 lineto
stroke
1 0 0 setrgbcolor
0.5113 0.30505 moveto
0.52731 0.30116 lineto
stroke
0.759 0.58 0.654 setrgbcolor
0.8273 0.3917 moveto
0.78057 0.41848 lineto
0.7915 0.43355 lineto
fill
0.784 0.635 0.697 setrgbcolor
0.81844 0.3703 moveto
0.78057 0.41848 lineto
0.8273 0.3917 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.78313 0.41701 moveto
0.82577 0.39259 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.82577 0.39259 moveto
0.8273 0.3917 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.78057 0.41848 moveto
0.78313 0.41701 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.81844 0.3703 moveto
0.8273 0.3917 lineto
stroke
0.819 0.598 0.602 setrgbcolor
0.36952 0.78153 moveto
0.37826 0.77836 lineto
0.41621 0.84002 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.37826 0.77836 moveto
0.41621 0.84002 lineto
stroke
1 0 0 setrgbcolor
0.36952 0.78153 moveto
0.37826 0.77836 lineto
stroke
0.793 0.6 0.64 setrgbcolor
0.36952 0.78153 moveto
0.41621 0.84002 lineto
0.40137 0.84725 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.41621 0.84002 moveto
0.42965 0.83083 lineto
stroke
0.998 0.806 0.519 setrgbcolor
0.83898 0.54776 moveto
0.84831 0.59977 lineto
0.84931 0.57756 lineto
fill
0.886 0.597 0.084 setrgbcolor
0.83538 0.53137 moveto
0.83898 0.54776 lineto
0.84931 0.57756 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.83898 0.54776 moveto
0.84931 0.57756 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84831 0.59977 moveto
0.84931 0.57756 lineto
stroke
0.68 0.646 0.809 setrgbcolor
0.50629 0.25071 moveto
0.52731 0.30116 lineto
0.54401 0.2988 lineto
fill
0.697 0.655 0.803 setrgbcolor
0.48271 0.25778 moveto
0.52731 0.30116 lineto
0.50629 0.25071 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51149 0.2632 moveto
0.52731 0.30116 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50665 0.25157 moveto
0.51149 0.2632 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50629 0.25071 moveto
0.50665 0.25157 lineto
stroke
1 0 0 setrgbcolor
0.52731 0.30116 moveto
0.54401 0.2988 lineto
stroke
0.744 0.576 0.666 setrgbcolor
0.81844 0.3703 moveto
0.76873 0.404 lineto
0.78057 0.41848 lineto
fill
0.769 0.628 0.704 setrgbcolor
0.80778 0.34996 moveto
0.76873 0.404 lineto
0.81844 0.3703 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.77106 0.40242 moveto
0.81682 0.3714 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.81682 0.3714 moveto
0.81844 0.3703 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76873 0.404 moveto
0.77106 0.40242 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.80778 0.34996 moveto
0.81844 0.3703 lineto
stroke
0.676 0.637 0.803 setrgbcolor
0.53088 0.24524 moveto
0.54401 0.2988 lineto
0.5612 0.29799 lineto
fill
0.697 0.65 0.799 setrgbcolor
0.50629 0.25071 moveto
0.54401 0.2988 lineto
0.53088 0.24524 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53088 0.24524 moveto
0.54401 0.2988 lineto
stroke
1 0 0 setrgbcolor
0.54401 0.2988 moveto
0.5612 0.29799 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4299 0.28509 moveto
0.44691 0.27429 lineto
stroke
0.731 0.573 0.676 setrgbcolor
0.80778 0.34996 moveto
0.75604 0.39015 lineto
0.76873 0.404 lineto
fill
0.757 0.623 0.71 setrgbcolor
0.79524 0.3309 moveto
0.75604 0.39015 lineto
0.80778 0.34996 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.75807 0.38857 moveto
0.80609 0.35127 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.80609 0.35127 moveto
0.80778 0.34996 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.75604 0.39015 moveto
0.75807 0.38857 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.79524 0.3309 moveto
0.80778 0.34996 lineto
stroke
0.994 0.813 0.447 setrgbcolor
0.84158 0.56378 moveto
0.84697 0.62115 lineto
0.84831 0.59977 lineto
fill
0.751 0.518 0 setrgbcolor
0.83898 0.54776 moveto
0.84158 0.56378 lineto
0.84831 0.59977 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.8442 0.57777 moveto
0.84831 0.59977 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.84158 0.56378 moveto
0.8442 0.57777 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84697 0.62115 moveto
0.84831 0.59977 lineto
stroke
0.833 0.612 0.603 setrgbcolor
0.36056 0.78305 moveto
0.36952 0.78153 lineto
0.40137 0.84725 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.36952 0.78153 moveto
0.40137 0.84725 lineto
stroke
1 0 0 setrgbcolor
0.36056 0.78305 moveto
0.36952 0.78153 lineto
stroke
0.672 0.627 0.795 setrgbcolor
0.55618 0.24151 moveto
0.5612 0.29799 lineto
0.57871 0.29872 lineto
fill
0.697 0.646 0.794 setrgbcolor
0.53088 0.24524 moveto
0.5612 0.29799 lineto
0.55618 0.24151 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55618 0.24151 moveto
0.5612 0.29799 lineto
stroke
1 0 0 setrgbcolor
0.5612 0.29799 moveto
0.57871 0.29872 lineto
stroke
0.671 0.617 0.785 setrgbcolor
0.58186 0.23962 moveto
0.57871 0.29872 lineto
0.59636 0.30096 lineto
fill
0.698 0.64 0.787 setrgbcolor
0.55618 0.24151 moveto
0.57871 0.29872 lineto
0.58186 0.23962 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.57871 0.29872 moveto
0.58186 0.23962 lineto
stroke
1 0 0 setrgbcolor
0.57871 0.29872 moveto
0.59636 0.30096 lineto
stroke
0.72 0.572 0.686 setrgbcolor
0.79524 0.3309 moveto
0.74256 0.377 lineto
0.75604 0.39015 lineto
fill
0.747 0.619 0.717 setrgbcolor
0.78079 0.31328 moveto
0.74256 0.377 lineto
0.79524 0.3309 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.74585 0.37412 moveto
0.79353 0.33239 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.79353 0.33239 moveto
0.79524 0.3309 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.74256 0.377 moveto
0.74585 0.37412 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.78079 0.31328 moveto
0.79524 0.3309 lineto
stroke
0.796 0.607 0.646 setrgbcolor
0.36056 0.78305 moveto
0.40137 0.84725 lineto
0.38533 0.85232 lineto
fill
0 0 0 setrgbcolor
0.40137 0.84725 moveto
0.41621 0.84002 lineto
stroke
0.671 0.607 0.775 setrgbcolor
0.60761 0.23967 moveto
0.59636 0.30096 lineto
0.614 0.30466 lineto
fill
0.7 0.635 0.78 setrgbcolor
0.58186 0.23962 moveto
0.59636 0.30096 lineto
0.60761 0.23967 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.59636 0.30096 moveto
0.60761 0.23967 lineto
stroke
1 0 0 setrgbcolor
0.59636 0.30096 moveto
0.614 0.30466 lineto
stroke
0.967 0.801 0.371 setrgbcolor
0.84324 0.57924 moveto
0.8454 0.64156 lineto
0.84697 0.62115 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.84613 0.61168 moveto
0.84697 0.62115 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.84408 0.58872 moveto
0.84613 0.61168 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.84324 0.57924 moveto
0.84408 0.58872 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.8454 0.64156 moveto
0.84697 0.62115 lineto
stroke
0.672 0.599 0.764 setrgbcolor
0.63309 0.24173 moveto
0.614 0.30466 lineto
0.6315 0.30975 lineto
fill
0.702 0.63 0.773 setrgbcolor
0.60761 0.23967 moveto
0.614 0.30466 lineto
0.63309 0.24173 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.614 0.30466 moveto
0.63309 0.24173 lineto
stroke
1 0 0 setrgbcolor
0.614 0.30466 moveto
0.6315 0.30975 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.44691 0.27429 moveto
0.46105 0.26711 lineto
stroke
0.711 0.571 0.696 setrgbcolor
0.78079 0.31328 moveto
0.72838 0.3646 lineto
0.74256 0.377 lineto
fill
0.738 0.617 0.723 setrgbcolor
0.76445 0.29729 moveto
0.72838 0.3646 lineto
0.78079 0.31328 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.73108 0.36195 moveto
0.77913 0.3149 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.77913 0.3149 moveto
0.78079 0.31328 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.72838 0.3646 moveto
0.73108 0.36195 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.76445 0.29729 moveto
0.78079 0.31328 lineto
stroke
0.675 0.591 0.754 setrgbcolor
0.65798 0.24585 moveto
0.6315 0.30975 lineto
0.64874 0.31615 lineto
fill
0.705 0.626 0.766 setrgbcolor
0.63309 0.24173 moveto
0.6315 0.30975 lineto
0.65798 0.24585 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.6315 0.30975 moveto
0.65718 0.24779 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65718 0.24779 moveto
0.65798 0.24585 lineto
stroke
1 0 0 setrgbcolor
0.6315 0.30975 moveto
0.64874 0.31615 lineto
stroke
0.847 0.63 0.608 setrgbcolor
0.35156 0.78294 moveto
0.36056 0.78305 lineto
0.38533 0.85232 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.36056 0.78305 moveto
0.38533 0.85232 lineto
stroke
1 0 0 setrgbcolor
0.35156 0.78294 moveto
0.36056 0.78305 lineto
stroke
0.679 0.585 0.743 setrgbcolor
0.682 0.25207 moveto
0.64874 0.31615 lineto
0.66564 0.32377 lineto
fill
0.708 0.622 0.758 setrgbcolor
0.65798 0.24585 moveto
0.64874 0.31615 lineto
0.682 0.25207 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.64874 0.31615 moveto
0.68098 0.25404 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68098 0.25404 moveto
0.682 0.25207 lineto
stroke
1 0 0 setrgbcolor
0.64874 0.31615 moveto
0.66564 0.32377 lineto
stroke
0.684 0.58 0.733 setrgbcolor
0.70488 0.26037 moveto
0.66564 0.32377 lineto
0.68211 0.33251 lineto
fill
0.713 0.619 0.751 setrgbcolor
0.682 0.25207 moveto
0.66564 0.32377 lineto
0.70488 0.26037 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.66594 0.32328 moveto
0.70365 0.26234 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66564 0.32377 moveto
0.66594 0.32328 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.70365 0.26234 moveto
0.70488 0.26037 lineto
stroke
1 0 0 setrgbcolor
0.66564 0.32377 moveto
0.68211 0.33251 lineto
stroke
0.689 0.577 0.724 setrgbcolor
0.72637 0.27072 moveto
0.68211 0.33251 lineto
0.69809 0.34228 lineto
fill
0.718 0.617 0.744 setrgbcolor
0.70488 0.26037 moveto
0.68211 0.33251 lineto
0.72637 0.27072 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.68296 0.33132 moveto
0.72497 0.27266 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68223 0.33234 moveto
0.68296 0.33132 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68211 0.33251 moveto
0.68223 0.33234 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.72497 0.27266 moveto
0.72637 0.27072 lineto
stroke
1 0 0 setrgbcolor
0.68211 0.33251 moveto
0.69809 0.34228 lineto
stroke
0.695 0.574 0.714 setrgbcolor
0.74628 0.28306 moveto
0.69809 0.34228 lineto
0.71353 0.353 lineto
fill
0.723 0.616 0.737 setrgbcolor
0.72637 0.27072 moveto
0.69809 0.34228 lineto
0.74628 0.28306 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.70097 0.33874 moveto
0.74479 0.28488 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.74479 0.28488 moveto
0.74628 0.28306 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.69809 0.34228 moveto
0.70097 0.33874 lineto
stroke
1 0 0 setrgbcolor
0.69809 0.34228 moveto
0.71353 0.353 lineto
stroke
0.703 0.572 0.705 setrgbcolor
0.76445 0.29729 moveto
0.71353 0.353 lineto
0.72838 0.3646 lineto
fill
0.73 0.616 0.73 setrgbcolor
0.74628 0.28306 moveto
0.71353 0.353 lineto
0.76445 0.29729 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.71729 0.34889 moveto
0.76286 0.29903 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76286 0.29903 moveto
0.76445 0.29729 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.71353 0.353 moveto
0.71729 0.34889 lineto
stroke
1 0 0 setrgbcolor
0.71353 0.353 moveto
0.72838 0.3646 lineto
stroke
1 0 0 setrgbcolor
0.72838 0.3646 moveto
0.74256 0.377 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.74628 0.28306 moveto
0.76445 0.29729 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.74256 0.377 moveto
0.75604 0.39015 lineto
stroke
1 0 0 setrgbcolor
0.75604 0.39015 moveto
0.76873 0.404 lineto
stroke
0.93 0.78 0.308 setrgbcolor
0.84399 0.59398 moveto
0.84369 0.66082 lineto
0.8454 0.64156 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.84399 0.59398 moveto
0.8454 0.64156 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84369 0.66082 moveto
0.8454 0.64156 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.76873 0.404 moveto
0.78057 0.41848 lineto
stroke
1 0 0 setrgbcolor
0.78057 0.41848 moveto
0.7915 0.43355 lineto
stroke
1 0 0 setrgbcolor
0.7915 0.43355 moveto
0.80145 0.44913 lineto
stroke
0.798 0.616 0.654 setrgbcolor
0.35156 0.78294 moveto
0.38533 0.85232 lineto
0.36833 0.8551 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.38533 0.85232 moveto
0.40137 0.84725 lineto
stroke
0 0 0 setrgbcolor
0.46043 0.26635 moveto
0.48271 0.25778 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.80145 0.44913 moveto
0.81038 0.46515 lineto
stroke
1 0 0 setrgbcolor
0.81038 0.46515 moveto
0.81825 0.48151 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.72637 0.27072 moveto
0.74628 0.28306 lineto
stroke
0.86 0.652 0.618 setrgbcolor
0.34271 0.78124 moveto
0.35156 0.78294 lineto
0.36833 0.8551 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.35156 0.78294 moveto
0.36833 0.8551 lineto
stroke
1 0 0 setrgbcolor
0.34271 0.78124 moveto
0.35156 0.78294 lineto
stroke
1 0 0 setrgbcolor
0.81825 0.48151 moveto
0.82503 0.49808 lineto
stroke
1 0 0 setrgbcolor
0.82503 0.49808 moveto
0.83074 0.51475 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.48271 0.25778 moveto
0.50629 0.25071 lineto
stroke
0 0 0 setrgbcolor
0.70488 0.26037 moveto
0.72637 0.27072 lineto
stroke
0.861 0.724 0.203 setrgbcolor
0.84293 0.62066 moveto
0.84369 0.66082 lineto
0.84388 0.60784 lineto
fill
0.893 0.758 0.259 setrgbcolor
0.84293 0.62066 moveto
0.84192 0.67876 lineto
0.84369 0.66082 lineto
fill
0.72 0.591 0.017 setrgbcolor
0.84399 0.59398 moveto
0.84388 0.60784 lineto
0.84369 0.66082 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.84369 0.66082 moveto
0.84388 0.60784 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84192 0.67876 moveto
0.84369 0.66082 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.83074 0.51475 moveto
0.83538 0.53137 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.682 0.25207 moveto
0.70488 0.26037 lineto
stroke
0 0 0 setrgbcolor
0.50629 0.25071 moveto
0.53088 0.24524 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.83538 0.53137 moveto
0.83898 0.54776 lineto
stroke
0.8 0.625 0.663 setrgbcolor
0.34271 0.78124 moveto
0.36833 0.8551 lineto
0.35064 0.85545 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.36833 0.8551 moveto
0.38533 0.85232 lineto
stroke
0 0 0 setrgbcolor
0.35064 0.85545 moveto
0.36833 0.8551 lineto
stroke
0.801 0.626 0.663 setrgbcolor
0.33258 0.85328 moveto
0.34271 0.78124 lineto
0.35064 0.85545 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.34271 0.78124 moveto
0.35064 0.85545 lineto
stroke
0.867 0.69 0.659 setrgbcolor
0.33258 0.85328 moveto
0.33417 0.77802 lineto
0.34271 0.78124 lineto
fill
1 0 0 setrgbcolor
0.33417 0.77802 moveto
0.34271 0.78124 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.65798 0.24585 moveto
0.682 0.25207 lineto
stroke
0 0 0 setrgbcolor
0.53088 0.24524 moveto
0.55618 0.24151 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.83898 0.54776 moveto
0.84158 0.56378 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.63309 0.24173 moveto
0.65798 0.24585 lineto
stroke
0 0 0 setrgbcolor
0.55618 0.24151 moveto
0.58186 0.23962 lineto
stroke
0.942 0.806 0.352 setrgbcolor
0.84118 0.63231 moveto
0.84192 0.67876 lineto
0.84293 0.62066 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.84192 0.67876 moveto
0.84293 0.62066 lineto
stroke
0.906 0.766 0.275 setrgbcolor
0.84118 0.63231 moveto
0.84012 0.69521 lineto
0.84192 0.67876 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.84012 0.69521 moveto
0.84192 0.67876 lineto
stroke
0 0 0 setrgbcolor
0.60761 0.23967 moveto
0.63309 0.24173 lineto
stroke
0 0 0 setrgbcolor
0.58186 0.23962 moveto
0.60761 0.23967 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.84158 0.56378 moveto
0.84324 0.57924 lineto
stroke
0.802 0.635 0.674 setrgbcolor
0.31448 0.84851 moveto
0.33417 0.77802 lineto
0.33258 0.85328 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.33258 0.85328 moveto
0.33417 0.77802 lineto
stroke
0.87 0.711 0.681 setrgbcolor
0.31448 0.84851 moveto
0.32611 0.77338 lineto
0.33417 0.77802 lineto
fill
1 0 0 setrgbcolor
0.32611 0.77338 moveto
0.33417 0.77802 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.33258 0.85328 moveto
0.35064 0.85545 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.84324 0.57924 moveto
0.84399 0.59398 lineto
stroke
0.991 0.848 0.486 setrgbcolor
0.83863 0.64267 moveto
0.84012 0.69521 lineto
0.84118 0.63231 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.84012 0.69521 moveto
0.84118 0.63231 lineto
stroke
0.929 0.777 0.303 setrgbcolor
0.83863 0.64267 moveto
0.83833 0.71002 lineto
0.84012 0.69521 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.83833 0.71002 moveto
0.84012 0.69521 lineto
stroke
0.801 0.643 0.685 setrgbcolor
0.29669 0.84115 moveto
0.32611 0.77338 lineto
0.31448 0.84851 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.31448 0.84851 moveto
0.31489 0.84587 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31489 0.84587 moveto
0.32611 0.77338 lineto
stroke
0.868 0.729 0.706 setrgbcolor
0.29669 0.84115 moveto
0.31865 0.76744 lineto
0.32611 0.77338 lineto
fill
1 0 0 setrgbcolor
0.31865 0.76744 moveto
0.32611 0.77338 lineto
stroke
1 0 0 setrgbcolor
0.84388 0.60784 moveto
0.84399 0.59398 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.31448 0.84851 moveto
0.33258 0.85328 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.84293 0.62066 moveto
0.84388 0.60784 lineto
stroke
0.799 0.651 0.697 setrgbcolor
0.2796 0.83123 moveto
0.31865 0.76744 lineto
0.29669 0.84115 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.29669 0.84115 moveto
0.29746 0.83859 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29746 0.83859 moveto
0.31707 0.77274 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31707 0.77274 moveto
0.31865 0.76744 lineto
stroke
0.862 0.744 0.73 setrgbcolor
0.2796 0.83123 moveto
0.31191 0.76033 lineto
0.31865 0.76744 lineto
fill
1 0 0 setrgbcolor
0.31191 0.76033 moveto
0.31865 0.76744 lineto
stroke
0.995 0.844 0.575 setrgbcolor
0.83528 0.65167 moveto
0.83833 0.71002 lineto
0.83863 0.64267 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.83833 0.71002 moveto
0.83863 0.64267 lineto
stroke
0.954 0.783 0.333 setrgbcolor
0.83528 0.65167 moveto
0.83654 0.72299 lineto
0.83833 0.71002 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.83654 0.72299 moveto
0.83833 0.71002 lineto
stroke
0 0 0 setrgbcolor
0.29669 0.84115 moveto
0.31448 0.84851 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.84118 0.63231 moveto
0.84293 0.62066 lineto
stroke
0.795 0.657 0.709 setrgbcolor
0.26356 0.81884 moveto
0.31191 0.76033 lineto
0.2796 0.83123 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.2796 0.83123 moveto
0.28071 0.82879 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28071 0.82879 moveto
0.30988 0.76478 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30988 0.76478 moveto
0.31191 0.76033 lineto
stroke
0.851 0.753 0.754 setrgbcolor
0.26356 0.81884 moveto
0.30598 0.75218 lineto
0.31191 0.76033 lineto
fill
1 0 0 setrgbcolor
0.30598 0.75218 moveto
0.31191 0.76033 lineto
stroke
1 0 0 setrgbcolor
0.83863 0.64267 moveto
0.84118 0.63231 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.2796 0.83123 moveto
0.29669 0.84115 lineto
stroke
0.949 0.78 0.324 setrgbcolor
0.83528 0.65167 moveto
0.83473 0.73395 lineto
0.83654 0.72299 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.83528 0.65167 moveto
0.83654 0.72299 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.83473 0.73395 moveto
0.83654 0.72299 lineto
stroke
0.79 0.661 0.721 setrgbcolor
0.24892 0.80412 moveto
0.30598 0.75218 lineto
0.26356 0.81884 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.26356 0.81884 moveto
0.265 0.81657 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.265 0.81657 moveto
0.30367 0.75581 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30367 0.75581 moveto
0.30598 0.75218 lineto
stroke
0.836 0.757 0.775 setrgbcolor
0.24892 0.80412 moveto
0.30093 0.74313 lineto
0.30598 0.75218 lineto
fill
1 0 0 setrgbcolor
0.30093 0.74313 moveto
0.30598 0.75218 lineto
stroke
1 0 0 setrgbcolor
0.83528 0.65167 moveto
0.83863 0.64267 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.26356 0.81884 moveto
0.2796 0.83123 lineto
stroke
0.782 0.663 0.731 setrgbcolor
0.23603 0.78728 moveto
0.30093 0.74313 lineto
0.24892 0.80412 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.24892 0.80412 moveto
0.25068 0.80207 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.25068 0.80207 moveto
0.2985 0.74599 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2985 0.74599 moveto
0.30093 0.74313 lineto
stroke
0.819 0.757 0.794 setrgbcolor
0.23603 0.78728 moveto
0.29681 0.7333 lineto
0.30093 0.74313 lineto
fill
1 0 0 setrgbcolor
0.29681 0.7333 moveto
0.30093 0.74313 lineto
stroke
0.968 0.777 0.343 setrgbcolor
0.83112 0.65924 moveto
0.83284 0.74275 lineto
0.83473 0.73395 lineto
fill
0.964 0.791 0.618 setrgbcolor
0.83528 0.65167 moveto
0.83112 0.65924 lineto
0.83473 0.73395 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.83112 0.65924 moveto
0.83473 0.73395 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.83284 0.74275 moveto
0.83473 0.73395 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.83112 0.65924 moveto
0.83528 0.65167 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.24892 0.80412 moveto
0.26356 0.81884 lineto
stroke
0.774 0.664 0.741 setrgbcolor
0.22519 0.76855 moveto
0.29681 0.7333 lineto
0.23603 0.78728 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.23603 0.78728 moveto
0.23806 0.78548 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.23806 0.78548 moveto
0.2944 0.73544 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2944 0.73544 moveto
0.29681 0.7333 lineto
stroke
0.799 0.751 0.808 setrgbcolor
0.22519 0.76855 moveto
0.29367 0.7228 lineto
0.29681 0.7333 lineto
fill
1 0 0 setrgbcolor
0.29367 0.7228 moveto
0.29681 0.7333 lineto
stroke
0.936 0.754 0.629 setrgbcolor
0.83112 0.65924 moveto
0.82613 0.66535 lineto
0.83284 0.74275 lineto
fill
1 0 0 setrgbcolor
0.82613 0.66535 moveto
0.83112 0.65924 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.23603 0.78728 moveto
0.24892 0.80412 lineto
stroke
0.979 0.764 0.35 setrgbcolor
0.82613 0.66535 moveto
0.83078 0.74921 lineto
0.83284 0.74275 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.82613 0.66535 moveto
0.83284 0.74275 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.83078 0.74921 moveto
0.83284 0.74275 lineto
stroke
0.765 0.662 0.749 setrgbcolor
0.21665 0.74822 moveto
0.29367 0.7228 lineto
0.22519 0.76855 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.22519 0.76855 moveto
0.22745 0.76704 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.22745 0.76704 moveto
0.29143 0.72429 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29143 0.72429 moveto
0.29367 0.7228 lineto
stroke
0.778 0.742 0.819 setrgbcolor
0.21665 0.74822 moveto
0.29155 0.71173 lineto
0.29367 0.7228 lineto
fill
1 0 0 setrgbcolor
0.29155 0.71173 moveto
0.29367 0.7228 lineto
stroke
0.913 0.719 0.626 setrgbcolor
0.82613 0.66535 moveto
0.82028 0.67 lineto
0.83078 0.74921 lineto
fill
1 0 0 setrgbcolor
0.82028 0.67 moveto
0.82613 0.66535 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.22519 0.76855 moveto
0.23603 0.78728 lineto
stroke
0.754 0.659 0.755 setrgbcolor
0.21063 0.72661 moveto
0.29155 0.71173 lineto
0.21665 0.74822 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.21665 0.74822 moveto
0.21909 0.74703 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.21909 0.74703 moveto
0.28962 0.71267 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28962 0.71267 moveto
0.29155 0.71173 lineto
stroke
0.757 0.729 0.827 setrgbcolor
0.21063 0.72661 moveto
0.2905 0.70019 lineto
0.29155 0.71173 lineto
fill
1 0 0 setrgbcolor
0.2905 0.70019 moveto
0.29155 0.71173 lineto
stroke
0.982 0.741 0.34 setrgbcolor
0.82028 0.67 moveto
0.82846 0.75318 lineto
0.83078 0.74921 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.82028 0.67 moveto
0.83078 0.74921 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.82846 0.75318 moveto
0.83078 0.74921 lineto
stroke
0.893 0.687 0.615 setrgbcolor
0.82028 0.67 moveto
0.81355 0.67321 lineto
0.82846 0.75318 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.81355 0.67321 moveto
0.82028 0.67 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.21665 0.74822 moveto
0.22519 0.76855 lineto
stroke
0.744 0.654 0.76 setrgbcolor
0.20729 0.70405 moveto
0.2905 0.70019 lineto
0.21063 0.72661 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.21063 0.72661 moveto
0.21321 0.72575 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.21321 0.72575 moveto
0.289 0.70068 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.289 0.70068 moveto
0.2905 0.70019 lineto
stroke
0.735 0.713 0.83 setrgbcolor
0.20729 0.70405 moveto
0.29059 0.68827 lineto
0.2905 0.70019 lineto
fill
1 0 0 setrgbcolor
0.2905 0.70019 moveto
0.29059 0.68827 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.21063 0.72661 moveto
0.21665 0.74822 lineto
stroke
0.978 0.708 0.31 setrgbcolor
0.81355 0.67321 moveto
0.82573 0.75455 lineto
0.82846 0.75318 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.81355 0.67321 moveto
0.82846 0.75318 lineto
stroke
0.879 0.657 0.598 setrgbcolor
0.81355 0.67321 moveto
0.80592 0.67505 lineto
0.82573 0.75455 lineto
fill
1 0 0 setrgbcolor
0.80592 0.67505 moveto
0.81355 0.67321 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.82573 0.75455 moveto
0.82846 0.75318 lineto
stroke
0.733 0.647 0.764 setrgbcolor
0.20675 0.68091 moveto
0.29059 0.68827 lineto
0.20729 0.70405 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.20729 0.70405 moveto
0.28961 0.68845 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28961 0.68845 moveto
0.29059 0.68827 lineto
stroke
0.715 0.695 0.83 setrgbcolor
0.20675 0.68091 moveto
0.29187 0.67606 lineto
0.29059 0.68827 lineto
fill
1 0 0 setrgbcolor
0.29059 0.68827 moveto
0.29187 0.67606 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.20729 0.70405 moveto
0.21063 0.72661 lineto
stroke
0.964 0.663 0.254 setrgbcolor
0.80592 0.67505 moveto
0.82243 0.7532 lineto
0.82573 0.75455 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.80592 0.67505 moveto
0.82573 0.75455 lineto
stroke
0.867 0.628 0.574 setrgbcolor
0.80592 0.67505 moveto
0.79737 0.67557 lineto
0.82243 0.7532 lineto
fill
1 0 0 setrgbcolor
0.79737 0.67557 moveto
0.80592 0.67505 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.20675 0.68091 moveto
0.20729 0.70405 lineto
stroke
0.722 0.64 0.766 setrgbcolor
0.20905 0.65756 moveto
0.29187 0.67606 lineto
0.20675 0.68091 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.20675 0.68091 moveto
0.29187 0.67606 lineto
stroke
0.696 0.676 0.827 setrgbcolor
0.20905 0.65756 moveto
0.29443 0.66368 lineto
0.29187 0.67606 lineto
fill
1 0 0 setrgbcolor
0.29187 0.67606 moveto
0.29443 0.66368 lineto
stroke
0.863 0.626 0.578 setrgbcolor
0.78791 0.67485 moveto
0.82243 0.7532 lineto
0.79737 0.67557 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.79737 0.67557 moveto
0.79839 0.67871 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.79839 0.67871 moveto
0.82243 0.7532 lineto
stroke
1 0 0 setrgbcolor
0.78791 0.67485 moveto
0.79737 0.67557 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.82243 0.7532 moveto
0.82573 0.75455 lineto
stroke
0 0 0 setrgbcolor
0.20675 0.68091 moveto
0.20905 0.65756 lineto
stroke
0.711 0.631 0.766 setrgbcolor
0.21421 0.63433 moveto
0.29443 0.66368 lineto
0.20905 0.65756 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.20905 0.65756 moveto
0.29443 0.66368 lineto
stroke
0.679 0.656 0.82 setrgbcolor
0.21421 0.63433 moveto
0.29835 0.65124 lineto
0.29443 0.66368 lineto
fill
1 0 0 setrgbcolor
0.29443 0.66368 moveto
0.29835 0.65124 lineto
stroke
0.855 0.595 0.544 setrgbcolor
0.77753 0.67299 moveto
0.81839 0.74911 lineto
0.78791 0.67485 lineto
fill
0.892 0.516 0.055 setrgbcolor
0.78791 0.67485 moveto
0.81839 0.74911 lineto
0.82243 0.7532 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.78877 0.67695 moveto
0.81839 0.74911 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.78791 0.67485 moveto
0.78877 0.67695 lineto
stroke
1 0 0 setrgbcolor
0.77753 0.67299 moveto
0.78791 0.67485 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.20905 0.65756 moveto
0.21421 0.63433 lineto
stroke
0.7 0.622 0.765 setrgbcolor
0.22219 0.6116 moveto
0.29835 0.65124 lineto
0.21421 0.63433 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.21421 0.63433 moveto
0.29835 0.65124 lineto
stroke
0.664 0.637 0.812 setrgbcolor
0.22219 0.6116 moveto
0.30373 0.63889 lineto
0.29835 0.65124 lineto
fill
1 0 0 setrgbcolor
0.29835 0.65124 moveto
0.30373 0.63889 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.81839 0.74911 moveto
0.82243 0.7532 lineto
stroke
0 0 0 setrgbcolor
0.21421 0.63433 moveto
0.22219 0.6116 lineto
stroke
0.849 0.559 0.498 setrgbcolor
0.76625 0.67007 moveto
0.81339 0.74225 lineto
0.77753 0.67299 lineto
fill
0.783 0.371 0 setrgbcolor
0.77753 0.67299 moveto
0.81339 0.74225 lineto
0.81839 0.74911 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.81225 0.74005 moveto
0.81339 0.74225 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.77753 0.67299 moveto
0.77778 0.67348 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.77778 0.67348 moveto
0.77839 0.67466 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.77839 0.67466 moveto
0.81225 0.74005 lineto
stroke
1 0 0 setrgbcolor
0.76625 0.67007 moveto
0.77753 0.67299 lineto
stroke
0.691 0.612 0.763 setrgbcolor
0.23291 0.58969 moveto
0.30373 0.63889 lineto
0.22219 0.6116 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.22219 0.6116 moveto
0.30373 0.63889 lineto
stroke
0.652 0.618 0.802 setrgbcolor
0.23291 0.58969 moveto
0.31063 0.62679 lineto
0.30373 0.63889 lineto
fill
1 0 0 setrgbcolor
0.30373 0.63889 moveto
0.31063 0.62679 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.22219 0.6116 moveto
0.23291 0.58969 lineto
stroke
0.823 0.438 0.323 setrgbcolor
0.75409 0.66617 moveto
0.79974 0.72054 lineto
0.76625 0.67007 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.75409 0.66617 moveto
0.76625 0.67007 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.81339 0.74225 moveto
0.81839 0.74911 lineto
stroke
0.682 0.602 0.76 setrgbcolor
0.24626 0.56893 moveto
0.31063 0.62679 lineto
0.23291 0.58969 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.23291 0.58969 moveto
0.31063 0.62679 lineto
stroke
0.644 0.601 0.791 setrgbcolor
0.24626 0.56893 moveto
0.31913 0.61512 lineto
0.31063 0.62679 lineto
fill
1 0 0 setrgbcolor
0.31063 0.62679 moveto
0.31913 0.61512 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.23291 0.58969 moveto
0.24626 0.56893 lineto
stroke
0.774 0.308 0.136 setrgbcolor
0.74107 0.66137 moveto
0.79069 0.70602 lineto
0.75409 0.66617 lineto
fill
0 0.095 0.645 setrgbcolor
0.75409 0.66617 moveto
0.80724 0.73268 lineto
0.79974 0.72054 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.74107 0.66137 moveto
0.75409 0.66617 lineto
stroke
0.675 0.593 0.756 setrgbcolor
0.26209 0.5496 moveto
0.31913 0.61512 lineto
0.24626 0.56893 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.24626 0.56893 moveto
0.31913 0.61512 lineto
stroke
0.638 0.586 0.779 setrgbcolor
0.26209 0.5496 moveto
0.32925 0.60409 lineto
0.31913 0.61512 lineto
fill
1 0 0 setrgbcolor
0.31913 0.61512 moveto
0.32925 0.60409 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.24626 0.56893 moveto
0.26209 0.5496 lineto
stroke
0 0 0 setrgbcolor
0.80724 0.73268 moveto
0.81339 0.74225 lineto
stroke
0.617 0.05 0 setrgbcolor
0.72721 0.65574 moveto
0.77992 0.6894 lineto
0.74107 0.66137 lineto
fill
0.009 0.306 0.798 setrgbcolor
0.74107 0.66137 moveto
0.79974 0.72054 lineto
0.79069 0.70602 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.72721 0.65574 moveto
0.74107 0.66137 lineto
stroke
0.669 0.585 0.752 setrgbcolor
0.28024 0.53198 moveto
0.32925 0.60409 lineto
0.26209 0.5496 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.26209 0.5496 moveto
0.32925 0.60409 lineto
stroke
0.636 0.574 0.768 setrgbcolor
0.28024 0.53198 moveto
0.341 0.59388 lineto
0.32925 0.60409 lineto
fill
1 0 0 setrgbcolor
0.32925 0.60409 moveto
0.341 0.59388 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.26209 0.5496 moveto
0.28024 0.53198 lineto
stroke
0.228 0.44 0.859 setrgbcolor
0.72721 0.65574 moveto
0.79069 0.70602 lineto
0.77992 0.6894 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.72721 0.65574 moveto
0.72868 0.65668 lineto
stroke
0.664 0.577 0.748 setrgbcolor
0.30053 0.51632 moveto
0.341 0.59388 lineto
0.28024 0.53198 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.28024 0.53198 moveto
0.341 0.59388 lineto
stroke
0.636 0.565 0.758 setrgbcolor
0.30053 0.51632 moveto
0.35436 0.58473 lineto
0.341 0.59388 lineto
fill
1 0 0 setrgbcolor
0.341 0.59388 moveto
0.35436 0.58473 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.28024 0.53198 moveto
0.30053 0.51632 lineto
stroke
0 0 0 setrgbcolor
0.79974 0.72054 moveto
0.80724 0.73268 lineto
stroke
0.66 0.571 0.744 setrgbcolor
0.32275 0.50284 moveto
0.35436 0.58473 lineto
0.30053 0.51632 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.30053 0.51632 moveto
0.35436 0.58473 lineto
stroke
0.639 0.56 0.749 setrgbcolor
0.32275 0.50284 moveto
0.36926 0.57681 lineto
0.35436 0.58473 lineto
fill
1 0 0 setrgbcolor
0.35436 0.58473 moveto
0.36926 0.57681 lineto
stroke
0 0.386 0.751 setrgbcolor
0.69704 0.64228 moveto
0.76728 0.67102 lineto
0.71253 0.64935 lineto
fill
0.372 0.515 0.871 setrgbcolor
0.71253 0.64935 moveto
0.77992 0.6894 lineto
0.76728 0.67102 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.71442 0.6501 moveto
0.76541 0.67028 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.71253 0.64935 moveto
0.71442 0.6501 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76541 0.67028 moveto
0.76543 0.67029 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76543 0.67029 moveto
0.76608 0.67054 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76608 0.67054 moveto
0.76728 0.67102 lineto
stroke
1 0 0 setrgbcolor
0.69704 0.64228 moveto
0.71253 0.64935 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.30053 0.51632 moveto
0.32275 0.50284 lineto
stroke
0.658 0.567 0.74 setrgbcolor
0.34668 0.49174 moveto
0.36926 0.57681 lineto
0.32275 0.50284 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.32275 0.50284 moveto
0.36926 0.57681 lineto
stroke
0.643 0.557 0.743 setrgbcolor
0.34668 0.49174 moveto
0.3856 0.57032 lineto
0.36926 0.57681 lineto
fill
1 0 0 setrgbcolor
0.36926 0.57681 moveto
0.3856 0.57032 lineto
stroke
0.27 0.634 0.963 setrgbcolor
0.68076 0.63461 moveto
0.75268 0.65128 lineto
0.69704 0.64228 lineto
fill
0.465 0.555 0.863 setrgbcolor
0.69704 0.64228 moveto
0.75268 0.65128 lineto
0.76728 0.67102 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.69704 0.64228 moveto
0.75076 0.65097 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.75076 0.65097 moveto
0.75268 0.65128 lineto
stroke
1 0 0 setrgbcolor
0.68076 0.63461 moveto
0.69704 0.64228 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.32275 0.50284 moveto
0.34668 0.49174 lineto
stroke
0 0 0 setrgbcolor
0.79069 0.70602 moveto
0.79974 0.72054 lineto
stroke
0.657 0.564 0.738 setrgbcolor
0.37209 0.48319 moveto
0.3856 0.57032 lineto
0.34668 0.49174 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.34668 0.49174 moveto
0.3856 0.57032 lineto
stroke
0.649 0.558 0.738 setrgbcolor
0.37209 0.48319 moveto
0.40324 0.56539 lineto
0.3856 0.57032 lineto
fill
1 0 0 setrgbcolor
0.3856 0.57032 moveto
0.40324 0.56539 lineto
stroke
0.484 0.689 0.958 setrgbcolor
0.66371 0.62645 moveto
0.73606 0.63065 lineto
0.68076 0.63461 lineto
fill
0.525 0.576 0.849 setrgbcolor
0.68076 0.63461 moveto
0.73606 0.63065 lineto
0.75268 0.65128 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.68076 0.63461 moveto
0.73606 0.63065 lineto
stroke
1 0 0 setrgbcolor
0.66371 0.62645 moveto
0.68076 0.63461 lineto
stroke
0.656 0.562 0.737 setrgbcolor
0.39875 0.47733 moveto
0.40324 0.56539 lineto
0.37209 0.48319 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.37209 0.48319 moveto
0.40324 0.56539 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.34668 0.49174 moveto
0.37209 0.48319 lineto
stroke
0.655 0.561 0.736 setrgbcolor
0.39875 0.47733 moveto
0.422 0.56213 lineto
0.40324 0.56539 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.40324 0.56539 moveto
0.422 0.56213 lineto
stroke
0.63 0.685 0.883 setrgbcolor
0.69685 0.58867 moveto
0.66371 0.62645 lineto
0.64588 0.61795 lineto
fill
0.566 0.585 0.831 setrgbcolor
0.69685 0.58867 moveto
0.71743 0.60961 lineto
0.66371 0.62645 lineto
fill
0.566 0.587 0.833 setrgbcolor
0.66371 0.62645 moveto
0.71743 0.60961 lineto
0.73606 0.63065 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.66563 0.62585 moveto
0.71743 0.60961 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66371 0.62645 moveto
0.66563 0.62585 lineto
stroke
1 0 0 setrgbcolor
0.64588 0.61795 moveto
0.66371 0.62645 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.77992 0.6894 moveto
0.79069 0.70602 lineto
stroke
0.656 0.562 0.736 setrgbcolor
0.42641 0.47427 moveto
0.422 0.56213 lineto
0.39875 0.47733 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.39875 0.47733 moveto
0.422 0.56213 lineto
stroke
0.661 0.566 0.737 setrgbcolor
0.42641 0.47427 moveto
0.4417 0.5606 lineto
0.422 0.56213 lineto
fill
1 0 0 setrgbcolor
0.422 0.56213 moveto
0.4417 0.5606 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.37209 0.48319 moveto
0.39875 0.47733 lineto
stroke
0.657 0.671 0.851 setrgbcolor
0.67442 0.56834 moveto
0.64588 0.61795 lineto
0.62732 0.60928 lineto
fill
0.594 0.589 0.816 setrgbcolor
0.67442 0.56834 moveto
0.69685 0.58867 lineto
0.64588 0.61795 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.69504 0.58971 moveto
0.69685 0.58867 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64795 0.61677 moveto
0.69504 0.58971 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64588 0.61795 moveto
0.64795 0.61677 lineto
stroke
1 0 0 setrgbcolor
0.62732 0.60928 moveto
0.64588 0.61795 lineto
stroke
0.656 0.563 0.737 setrgbcolor
0.4548 0.47408 moveto
0.4417 0.5606 lineto
0.42641 0.47427 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.42641 0.47427 moveto
0.4417 0.5606 lineto
stroke
0.667 0.573 0.739 setrgbcolor
0.4548 0.47408 moveto
0.46213 0.5608 lineto
0.4417 0.5606 lineto
fill
1 0 0 setrgbcolor
0.4417 0.5606 moveto
0.46213 0.5608 lineto
stroke
0.672 0.656 0.825 setrgbcolor
0.65031 0.54908 moveto
0.62732 0.60928 lineto
0.60805 0.60063 lineto
fill
0.614 0.59 0.803 setrgbcolor
0.65031 0.54908 moveto
0.67442 0.56834 lineto
0.62732 0.60928 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.62732 0.60928 moveto
0.67442 0.56834 lineto
stroke
1 0 0 setrgbcolor
0.60805 0.60063 moveto
0.62732 0.60928 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.39875 0.47733 moveto
0.42641 0.47427 lineto
stroke
0.674 0.578 0.739 setrgbcolor
0.4548 0.47408 moveto
0.48307 0.56269 lineto
0.46213 0.5608 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4548 0.47408 moveto
0.46213 0.5608 lineto
stroke
1 0 0 setrgbcolor
0.46213 0.5608 moveto
0.48307 0.56269 lineto
stroke
0.681 0.642 0.804 setrgbcolor
0.62472 0.53134 moveto
0.60805 0.60063 lineto
0.58814 0.59224 lineto
fill
0.628 0.589 0.791 setrgbcolor
0.62472 0.53134 moveto
0.65031 0.54908 lineto
0.60805 0.60063 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.60805 0.60063 moveto
0.65031 0.54908 lineto
stroke
1 0 0 setrgbcolor
0.58814 0.59224 moveto
0.60805 0.60063 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.76728 0.67102 moveto
0.77992 0.6894 lineto
stroke
0.656 0.568 0.743 setrgbcolor
0.4548 0.47408 moveto
0.48364 0.47679 lineto
0.48307 0.56269 lineto
fill
0.679 0.586 0.745 setrgbcolor
0.48364 0.47679 moveto
0.5043 0.56617 lineto
0.48307 0.56269 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.48307 0.56269 moveto
0.48364 0.47679 lineto
stroke
1 0 0 setrgbcolor
0.48307 0.56269 moveto
0.5043 0.56617 lineto
stroke
0.685 0.63 0.787 setrgbcolor
0.59789 0.51551 moveto
0.58814 0.59224 lineto
0.56768 0.58435 lineto
fill
0.638 0.587 0.78 setrgbcolor
0.59789 0.51551 moveto
0.62472 0.53134 lineto
0.58814 0.59224 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.58814 0.59224 moveto
0.62472 0.53134 lineto
stroke
1 0 0 setrgbcolor
0.56768 0.58435 moveto
0.58814 0.59224 lineto
stroke
0.655 0.571 0.748 setrgbcolor
0.48364 0.47679 moveto
0.51266 0.48239 lineto
0.5043 0.56617 lineto
fill
0.683 0.596 0.752 setrgbcolor
0.51266 0.48239 moveto
0.5256 0.57107 lineto
0.5043 0.56617 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5043 0.56617 moveto
0.51266 0.48239 lineto
stroke
1 0 0 setrgbcolor
0.5043 0.56617 moveto
0.5256 0.57107 lineto
stroke
0.686 0.618 0.773 setrgbcolor
0.57008 0.50192 moveto
0.56768 0.58435 lineto
0.54679 0.57721 lineto
fill
0.646 0.583 0.77 setrgbcolor
0.57008 0.50192 moveto
0.59789 0.51551 lineto
0.56768 0.58435 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.56768 0.58435 moveto
0.59789 0.51551 lineto
stroke
1 0 0 setrgbcolor
0.54679 0.57721 moveto
0.56768 0.58435 lineto
stroke
0.654 0.575 0.754 setrgbcolor
0.51266 0.48239 moveto
0.54157 0.49081 lineto
0.5256 0.57107 lineto
fill
0.685 0.606 0.761 setrgbcolor
0.54157 0.49081 moveto
0.54679 0.57721 lineto
0.5256 0.57107 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5256 0.57107 moveto
0.54157 0.49081 lineto
stroke
1 0 0 setrgbcolor
0.5256 0.57107 moveto
0.54679 0.57721 lineto
stroke
0.651 0.579 0.761 setrgbcolor
0.54157 0.49081 moveto
0.57008 0.50192 lineto
0.54679 0.57721 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.54679 0.57721 moveto
0.57008 0.50192 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.42641 0.47427 moveto
0.4548 0.47408 lineto
stroke
0 0 0 setrgbcolor
0.75268 0.65128 moveto
0.76728 0.67102 lineto
stroke
0 0 0 setrgbcolor
0.4548 0.47408 moveto
0.48364 0.47679 lineto
stroke
0 0 0 setrgbcolor
0.48364 0.47679 moveto
0.51266 0.48239 lineto
stroke
0 0 0 setrgbcolor
0.73606 0.63065 moveto
0.75268 0.65128 lineto
stroke
0 0 0 setrgbcolor
0.51266 0.48239 moveto
0.54157 0.49081 lineto
stroke
0 0 0 setrgbcolor
0.71743 0.60961 moveto
0.73606 0.63065 lineto
stroke
0 0 0 setrgbcolor
0.54157 0.49081 moveto
0.57008 0.50192 lineto
stroke
0 0 0 setrgbcolor
0.69685 0.58867 moveto
0.71743 0.60961 lineto
stroke
0 0 0 setrgbcolor
0.57008 0.50192 moveto
0.59789 0.51551 lineto
stroke
0 0 0 setrgbcolor
0.67442 0.56834 moveto
0.69685 0.58867 lineto
stroke
0 0 0 setrgbcolor
0.59789 0.51551 moveto
0.62472 0.53134 lineto
stroke
0 0 0 setrgbcolor
0.65031 0.54908 moveto
0.67442 0.56834 lineto
stroke
0 0 0 setrgbcolor
0.62472 0.53134 moveto
0.65031 0.54908 lineto
stroke
0 setgray
0.002 setlinewidth
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
% End of Graphics
Mpend % End of picture
:[font = input; ]
Show[%,ViewPoint->{3,-.4,.8},Boxed->False]
:[inactive; PostScript; output; endGroup; pictureLeft = 43; pictureWidth = 293; pictureHeight = 262; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
0.767 0.537 0.586 setrgbcolor
0.56665 0.38708 moveto
0.58981 0.40205 lineto
0.56901 0.43916 lineto
fill
0.826 0.615 0.617 setrgbcolor
0.58981 0.40205 moveto
0.5809 0.45695 lineto
0.56901 0.43916 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.56901 0.43916 moveto
0.58981 0.40205 lineto
stroke
0.757 0.548 0.613 setrgbcolor
0.58981 0.40205 moveto
0.61207 0.41834 lineto
0.5809 0.45695 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.56665 0.38708 moveto
0.58981 0.40205 lineto
stroke
0.778 0.52 0.545 setrgbcolor
0.54288 0.37334 moveto
0.56665 0.38708 lineto
0.55653 0.42185 lineto
fill
0.858 0.61 0.562 setrgbcolor
0.56665 0.38708 moveto
0.56901 0.43916 lineto
0.55653 0.42185 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.55653 0.42185 moveto
0.56665 0.38708 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.54288 0.37334 moveto
0.56665 0.38708 lineto
stroke
0.801 0.614 0.648 setrgbcolor
0.61207 0.41834 moveto
0.59212 0.47519 lineto
0.5809 0.45695 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.5809 0.45695 moveto
0.58096 0.45687 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58096 0.45687 moveto
0.61207 0.41834 lineto
stroke
0.748 0.553 0.632 setrgbcolor
0.61207 0.41834 moveto
0.63312 0.436 lineto
0.59212 0.47519 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.58981 0.40205 moveto
0.61207 0.41834 lineto
stroke
0.787 0.488 0.482 setrgbcolor
0.51878 0.36073 moveto
0.54288 0.37334 lineto
0.54355 0.40506 lineto
fill
0.896 0.584 0.448 setrgbcolor
0.54288 0.37334 moveto
0.55653 0.42185 lineto
0.54355 0.40506 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.54288 0.37334 moveto
0.54355 0.40506 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51878 0.36073 moveto
0.54288 0.37334 lineto
stroke
0.782 0.61 0.667 setrgbcolor
0.63312 0.436 moveto
0.60259 0.49384 lineto
0.59212 0.47519 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.59212 0.47519 moveto
0.63312 0.436 lineto
stroke
0.739 0.556 0.646 setrgbcolor
0.63312 0.436 moveto
0.65271 0.45506 lineto
0.60259 0.49384 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.61207 0.41834 moveto
0.63312 0.436 lineto
stroke
0.789 0.427 0.371 setrgbcolor
0.49466 0.34912 moveto
0.51878 0.36073 lineto
0.53017 0.38885 lineto
fill
0.889 0.464 0.153 setrgbcolor
0.51878 0.36073 moveto
0.54355 0.40506 lineto
0.53017 0.38885 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51878 0.36073 moveto
0.53017 0.38885 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49466 0.34912 moveto
0.51878 0.36073 lineto
stroke
0.766 0.606 0.68 setrgbcolor
0.65271 0.45506 moveto
0.61219 0.51288 lineto
0.60259 0.49384 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60259 0.49384 moveto
0.60317 0.49339 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60317 0.49339 moveto
0.65271 0.45506 lineto
stroke
0.731 0.558 0.656 setrgbcolor
0.65271 0.45506 moveto
0.67058 0.47552 lineto
0.61219 0.51288 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.63312 0.436 moveto
0.65271 0.45506 lineto
stroke
0.752 0.601 0.688 setrgbcolor
0.67058 0.47552 moveto
0.62081 0.53225 lineto
0.61219 0.51288 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.61219 0.51288 moveto
0.61265 0.51258 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61265 0.51258 moveto
0.61318 0.51224 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61318 0.51224 moveto
0.67058 0.47552 lineto
stroke
0.724 0.557 0.664 setrgbcolor
0.67058 0.47552 moveto
0.68647 0.49735 lineto
0.62081 0.53225 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.65271 0.45506 moveto
0.67058 0.47552 lineto
stroke
0.756 0.298 0.16 setrgbcolor
0.47081 0.33836 moveto
0.49466 0.34912 lineto
0.5165 0.37325 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51564 0.37231 moveto
0.5165 0.37325 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49466 0.34912 moveto
0.51564 0.37231 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47081 0.33836 moveto
0.49466 0.34912 lineto
stroke
0.741 0.595 0.694 setrgbcolor
0.68647 0.49735 moveto
0.62834 0.55194 lineto
0.62081 0.53225 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62081 0.53225 moveto
0.62108 0.53211 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62108 0.53211 moveto
0.62261 0.5313 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62261 0.5313 moveto
0.68647 0.49735 lineto
stroke
0.717 0.556 0.669 setrgbcolor
0.68647 0.49735 moveto
0.70018 0.52046 lineto
0.62834 0.55194 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.67058 0.47552 moveto
0.68647 0.49735 lineto
stroke
0.73 0.589 0.697 setrgbcolor
0.70018 0.52046 moveto
0.63462 0.57189 lineto
0.62834 0.55194 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62834 0.55194 moveto
0.63115 0.55071 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63115 0.55071 moveto
0.70018 0.52046 lineto
stroke
0.711 0.554 0.673 setrgbcolor
0.70018 0.52046 moveto
0.71151 0.54476 lineto
0.63462 0.57189 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.68647 0.49735 moveto
0.70018 0.52046 lineto
stroke
0 0.389 0.742 setrgbcolor
0.42506 0.31885 moveto
0.44751 0.32832 lineto
0.48881 0.34402 lineto
fill
0.377 0.533 0.884 setrgbcolor
0.44751 0.32832 moveto
0.50266 0.3583 lineto
0.48881 0.34402 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.48674 0.34323 moveto
0.48881 0.34402 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44751 0.32832 moveto
0.48674 0.34323 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.42506 0.31885 moveto
0.44751 0.32832 lineto
stroke
0.721 0.582 0.699 setrgbcolor
0.71151 0.54476 moveto
0.63952 0.59205 lineto
0.63462 0.57189 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63462 0.57189 moveto
0.70926 0.54556 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.70926 0.54556 moveto
0.71151 0.54476 lineto
stroke
0.705 0.552 0.676 setrgbcolor
0.71151 0.54476 moveto
0.72031 0.5701 lineto
0.63952 0.59205 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.70018 0.52046 moveto
0.71151 0.54476 lineto
stroke
0 0 0 setrgbcolor
0.71151 0.54476 moveto
0.72031 0.5701 lineto
stroke
0.706 0.552 0.677 setrgbcolor
0.63952 0.59205 moveto
0.72031 0.5701 lineto
0.72644 0.59631 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63952 0.59205 moveto
0.72031 0.5701 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.72031 0.5701 moveto
0.72644 0.59631 lineto
stroke
0.212 0.619 0.951 setrgbcolor
0.4037 0.30978 moveto
0.42506 0.31885 lineto
0.47513 0.33044 lineto
fill
0.493 0.586 0.876 setrgbcolor
0.42506 0.31885 moveto
0.48881 0.34402 lineto
0.47513 0.33044 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42506 0.31885 moveto
0.47513 0.33044 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4037 0.30978 moveto
0.42506 0.31885 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.62081 0.53225 moveto
0.62834 0.55194 lineto
stroke
1 0 0 setrgbcolor
0.62834 0.55194 moveto
0.63462 0.57189 lineto
stroke
1 0 0 setrgbcolor
0.63462 0.57189 moveto
0.63952 0.59205 lineto
stroke
1 0 0 setrgbcolor
0.61219 0.51288 moveto
0.62081 0.53225 lineto
stroke
0.705 0.571 0.701 setrgbcolor
0.63952 0.59205 moveto
0.72644 0.59631 lineto
0.64288 0.61233 lineto
fill
1 0 0 setrgbcolor
0.63952 0.59205 moveto
0.64288 0.61233 lineto
stroke
1 0 0 setrgbcolor
0.60259 0.49384 moveto
0.61219 0.51288 lineto
stroke
0.698 0.564 0.699 setrgbcolor
0.64288 0.61233 moveto
0.72979 0.62319 lineto
0.64457 0.63264 lineto
fill
0.7 0.549 0.679 setrgbcolor
0.64288 0.61233 moveto
0.72644 0.59631 lineto
0.72979 0.62319 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.64288 0.61233 moveto
0.72644 0.59631 lineto
stroke
1 0 0 setrgbcolor
0.64288 0.61233 moveto
0.64457 0.63264 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.72644 0.59631 moveto
0.72979 0.62319 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.59212 0.47519 moveto
0.60259 0.49384 lineto
stroke
0.693 0.558 0.697 setrgbcolor
0.64457 0.63264 moveto
0.73032 0.65049 lineto
0.64447 0.65286 lineto
fill
0.696 0.546 0.68 setrgbcolor
0.64457 0.63264 moveto
0.72979 0.62319 lineto
0.73032 0.65049 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.64457 0.63264 moveto
0.72979 0.62319 lineto
stroke
1 0 0 setrgbcolor
0.64447 0.65286 moveto
0.64457 0.63264 lineto
stroke
1 0 0 setrgbcolor
0.5809 0.45695 moveto
0.59212 0.47519 lineto
stroke
0.692 0.555 0.694 setrgbcolor
0.64249 0.67283 moveto
0.64447 0.65286 lineto
0.73032 0.65049 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.64447 0.65286 moveto
0.73032 0.65049 lineto
stroke
1 0 0 setrgbcolor
0.64249 0.67283 moveto
0.64447 0.65286 lineto
stroke
1 0 0 setrgbcolor
0.56901 0.43916 moveto
0.5809 0.45695 lineto
stroke
0.688 0.54 0.68 setrgbcolor
0.64249 0.67283 moveto
0.73032 0.65049 lineto
0.72797 0.67797 lineto
fill
0.688 0.549 0.69 setrgbcolor
0.63854 0.69239 moveto
0.64249 0.67283 lineto
0.72797 0.67797 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.64249 0.67283 moveto
0.72797 0.67797 lineto
stroke
1 0 0 setrgbcolor
0.63854 0.69239 moveto
0.64249 0.67283 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.72979 0.62319 moveto
0.73032 0.65049 lineto
stroke
0.686 0.538 0.679 setrgbcolor
0.63854 0.69239 moveto
0.72797 0.67797 lineto
0.72276 0.70535 lineto
fill
0.685 0.543 0.686 setrgbcolor
0.63261 0.71137 moveto
0.63854 0.69239 lineto
0.72276 0.70535 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63854 0.69239 moveto
0.72276 0.70535 lineto
stroke
1 0 0 setrgbcolor
0.63261 0.71137 moveto
0.63854 0.69239 lineto
stroke
1 0 0 setrgbcolor
0.55653 0.42185 moveto
0.56901 0.43916 lineto
stroke
0.684 0.537 0.679 setrgbcolor
0.63261 0.71137 moveto
0.72276 0.70535 lineto
0.71471 0.73233 lineto
fill
0.684 0.539 0.682 setrgbcolor
0.62471 0.72956 moveto
0.63261 0.71137 lineto
0.71471 0.73233 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.63261 0.71137 moveto
0.71471 0.73233 lineto
stroke
1 0 0 setrgbcolor
0.62471 0.72956 moveto
0.63261 0.71137 lineto
stroke
0.409 0.693 0.978 setrgbcolor
0.38372 0.30098 moveto
0.4037 0.30978 lineto
0.46181 0.31755 lineto
fill
0.555 0.614 0.866 setrgbcolor
0.4037 0.30978 moveto
0.47513 0.33044 lineto
0.46181 0.31755 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4037 0.30978 moveto
0.46181 0.31755 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.38372 0.30098 moveto
0.4037 0.30978 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.54355 0.40506 moveto
0.55653 0.42185 lineto
stroke
0.684 0.536 0.679 setrgbcolor
0.62471 0.72956 moveto
0.71471 0.73233 lineto
0.7039 0.75863 lineto
fill
0.684 0.536 0.678 setrgbcolor
0.61487 0.74679 moveto
0.62471 0.72956 lineto
0.7039 0.75863 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.62471 0.72956 moveto
0.7039 0.75863 lineto
stroke
1 0 0 setrgbcolor
0.61487 0.74679 moveto
0.62471 0.72956 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.72797 0.67797 moveto
0.73032 0.65049 lineto
stroke
0.684 0.536 0.679 setrgbcolor
0.61487 0.74679 moveto
0.7039 0.75863 lineto
0.69043 0.78393 lineto
fill
0.686 0.534 0.674 setrgbcolor
0.6032 0.76288 moveto
0.61487 0.74679 lineto
0.69043 0.78393 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.61487 0.74679 moveto
0.69043 0.78393 lineto
stroke
1 0 0 setrgbcolor
0.6032 0.76288 moveto
0.61487 0.74679 lineto
stroke
1 0 0 setrgbcolor
0.53017 0.38885 moveto
0.54355 0.40506 lineto
stroke
0.685 0.538 0.679 setrgbcolor
0.6032 0.76288 moveto
0.69043 0.78393 lineto
0.67443 0.80794 lineto
fill
0.689 0.535 0.672 setrgbcolor
0.58981 0.77767 moveto
0.6032 0.76288 lineto
0.67443 0.80794 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.6032 0.76288 moveto
0.67443 0.80794 lineto
stroke
1 0 0 setrgbcolor
0.58981 0.77767 moveto
0.6032 0.76288 lineto
stroke
0.687 0.54 0.681 setrgbcolor
0.58981 0.77767 moveto
0.67443 0.80794 lineto
0.65606 0.83036 lineto
fill
0.694 0.538 0.671 setrgbcolor
0.57487 0.79102 moveto
0.58981 0.77767 lineto
0.65606 0.83036 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.58981 0.77767 moveto
0.60569 0.7903 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60569 0.7903 moveto
0.65606 0.83036 lineto
stroke
1 0 0 setrgbcolor
0.57487 0.79102 moveto
0.58981 0.77767 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.72276 0.70535 moveto
0.72797 0.67797 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.5165 0.37325 moveto
0.53017 0.38885 lineto
stroke
0.689 0.543 0.683 setrgbcolor
0.57487 0.79102 moveto
0.65606 0.83036 lineto
0.63551 0.85092 lineto
fill
0.7 0.543 0.671 setrgbcolor
0.55855 0.80284 moveto
0.57487 0.79102 lineto
0.63551 0.85092 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.57487 0.79102 moveto
0.58422 0.80025 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58422 0.80025 moveto
0.63551 0.85092 lineto
stroke
1 0 0 setrgbcolor
0.55855 0.80284 moveto
0.57487 0.79102 lineto
stroke
0.692 0.548 0.685 setrgbcolor
0.55855 0.80284 moveto
0.63551 0.85092 lineto
0.61299 0.86937 lineto
fill
0.706 0.549 0.673 setrgbcolor
0.54106 0.81307 moveto
0.55855 0.80284 lineto
0.61299 0.86937 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55855 0.80284 moveto
0.57397 0.82168 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57397 0.82168 moveto
0.61299 0.86937 lineto
stroke
1 0 0 setrgbcolor
0.54106 0.81307 moveto
0.55855 0.80284 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.71471 0.73233 moveto
0.72276 0.70535 lineto
stroke
0.508 0.717 0.965 setrgbcolor
0.36535 0.2923 moveto
0.38372 0.30098 lineto
0.44908 0.30537 lineto
fill
0.594 0.633 0.86 setrgbcolor
0.38372 0.30098 moveto
0.46181 0.31755 lineto
0.44908 0.30537 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.38372 0.30098 moveto
0.44908 0.30537 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.36535 0.2923 moveto
0.38372 0.30098 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.50266 0.3583 moveto
0.5165 0.37325 lineto
stroke
0.695 0.553 0.689 setrgbcolor
0.54106 0.81307 moveto
0.61299 0.86937 lineto
0.58874 0.88548 lineto
fill
0.713 0.557 0.676 setrgbcolor
0.52259 0.82169 moveto
0.54106 0.81307 lineto
0.58874 0.88548 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.54106 0.81307 moveto
0.55156 0.82902 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55156 0.82902 moveto
0.58874 0.88548 lineto
stroke
1 0 0 setrgbcolor
0.52259 0.82169 moveto
0.54106 0.81307 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.7039 0.75863 moveto
0.71471 0.73233 lineto
stroke
0.697 0.558 0.693 setrgbcolor
0.52259 0.82169 moveto
0.58874 0.88548 lineto
0.56302 0.89907 lineto
fill
0.719 0.567 0.681 setrgbcolor
0.50336 0.82874 moveto
0.52259 0.82169 lineto
0.56302 0.89907 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.52259 0.82169 moveto
0.52993 0.83574 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52993 0.83574 moveto
0.56302 0.89907 lineto
stroke
1 0 0 setrgbcolor
0.50336 0.82874 moveto
0.52259 0.82169 lineto
stroke
1 0 0 setrgbcolor
0.48881 0.34402 moveto
0.50266 0.3583 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.69043 0.78393 moveto
0.7039 0.75863 lineto
stroke
0.7 0.565 0.698 setrgbcolor
0.50336 0.82874 moveto
0.56302 0.89907 lineto
0.53608 0.91001 lineto
fill
0.725 0.577 0.687 setrgbcolor
0.48356 0.83426 moveto
0.50336 0.82874 lineto
0.53608 0.91001 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.50336 0.82874 moveto
0.50555 0.83417 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50555 0.83417 moveto
0.53608 0.91001 lineto
stroke
1 0 0 setrgbcolor
0.48356 0.83426 moveto
0.50336 0.82874 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.67443 0.80794 moveto
0.69043 0.78393 lineto
stroke
0.702 0.571 0.704 setrgbcolor
0.48356 0.83426 moveto
0.53608 0.91001 lineto
0.5082 0.91818 lineto
fill
0.73 0.587 0.695 setrgbcolor
0.46337 0.83836 moveto
0.48356 0.83426 lineto
0.5082 0.91818 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.48356 0.83426 moveto
0.485 0.83916 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.485 0.83916 moveto
0.5082 0.91818 lineto
stroke
1 0 0 setrgbcolor
0.46337 0.83836 moveto
0.48356 0.83426 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.65606 0.83036 moveto
0.67443 0.80794 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.47513 0.33044 moveto
0.48881 0.34402 lineto
stroke
0.706 0.585 0.718 setrgbcolor
0.44295 0.84115 moveto
0.47967 0.92356 lineto
0.45077 0.92613 lineto
fill
0.707 0.586 0.718 setrgbcolor
0.42175 0.92597 moveto
0.44295 0.84115 lineto
0.45077 0.92613 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.44295 0.84115 moveto
0.45077 0.92613 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.45077 0.92613 moveto
0.47967 0.92356 lineto
stroke
0 0 0 setrgbcolor
0.42175 0.92597 moveto
0.45077 0.92613 lineto
stroke
0.74 0.62 0.725 setrgbcolor
0.42175 0.92597 moveto
0.42245 0.84274 lineto
0.44295 0.84115 lineto
fill
0.707 0.593 0.726 setrgbcolor
0.3929 0.92318 moveto
0.42245 0.84274 lineto
0.42175 0.92597 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42175 0.92597 moveto
0.42245 0.84274 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.3929 0.92318 moveto
0.42175 0.92597 lineto
stroke
0.704 0.578 0.71 setrgbcolor
0.46337 0.83836 moveto
0.5082 0.91818 lineto
0.47967 0.92356 lineto
fill
0.735 0.598 0.704 setrgbcolor
0.44295 0.84115 moveto
0.46337 0.83836 lineto
0.47967 0.92356 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.46337 0.83836 moveto
0.47967 0.92356 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47967 0.92356 moveto
0.5082 0.91818 lineto
stroke
0.743 0.633 0.738 setrgbcolor
0.3929 0.92318 moveto
0.40199 0.84329 lineto
0.42245 0.84274 lineto
fill
0.707 0.601 0.735 setrgbcolor
0.36444 0.91791 moveto
0.40199 0.84329 lineto
0.3929 0.92318 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.3929 0.92318 moveto
0.40199 0.84329 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.36444 0.91791 moveto
0.3929 0.92318 lineto
stroke
0 0 0 setrgbcolor
0.5082 0.91818 moveto
0.53608 0.91001 lineto
stroke
0 0 0 setrgbcolor
0.63551 0.85092 moveto
0.65606 0.83036 lineto
stroke
0.564 0.727 0.95 setrgbcolor
0.34884 0.28363 moveto
0.36535 0.2923 lineto
0.43717 0.29386 lineto
fill
0.62 0.649 0.857 setrgbcolor
0.36535 0.2923 moveto
0.44908 0.30537 lineto
0.43717 0.29386 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.36535 0.2923 moveto
0.43717 0.29386 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.34884 0.28363 moveto
0.36535 0.2923 lineto
stroke
0 0 0 setrgbcolor
0.53608 0.91001 moveto
0.56302 0.89907 lineto
stroke
0.744 0.647 0.752 setrgbcolor
0.36444 0.91791 moveto
0.38167 0.8429 lineto
0.40199 0.84329 lineto
fill
0.705 0.608 0.745 setrgbcolor
0.3366 0.91035 moveto
0.38167 0.8429 lineto
0.36444 0.91791 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.36444 0.91791 moveto
0.38167 0.8429 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.3366 0.91035 moveto
0.36444 0.91791 lineto
stroke
0 0 0 setrgbcolor
0.61299 0.86937 moveto
0.63551 0.85092 lineto
stroke
0 0 0 setrgbcolor
0.56302 0.89907 moveto
0.58874 0.88548 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.44295 0.84115 moveto
0.46337 0.83836 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.58874 0.88548 moveto
0.61299 0.86937 lineto
stroke
0.744 0.662 0.769 setrgbcolor
0.3366 0.91035 moveto
0.36158 0.84171 lineto
0.38167 0.8429 lineto
fill
0.702 0.615 0.756 setrgbcolor
0.30959 0.90075 moveto
0.36158 0.84171 lineto
0.3366 0.91035 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.3366 0.91035 moveto
0.33741 0.90813 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33741 0.90813 moveto
0.36158 0.84171 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.30959 0.90075 moveto
0.3366 0.91035 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.46181 0.31755 moveto
0.47513 0.33044 lineto
stroke
1 0 0 setrgbcolor
0.42245 0.84274 moveto
0.44295 0.84115 lineto
stroke
0.741 0.678 0.789 setrgbcolor
0.30959 0.90075 moveto
0.3418 0.8398 lineto
0.36158 0.84171 lineto
fill
0.698 0.622 0.768 setrgbcolor
0.28359 0.88937 moveto
0.3418 0.8398 lineto
0.30959 0.90075 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.34072 0.84185 moveto
0.3418 0.8398 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30959 0.90075 moveto
0.31062 0.8988 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31062 0.8988 moveto
0.34072 0.84185 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.28359 0.88937 moveto
0.30959 0.90075 lineto
stroke
0.735 0.696 0.813 setrgbcolor
0.28359 0.88937 moveto
0.32241 0.83725 lineto
0.3418 0.8398 lineto
fill
0.691 0.629 0.782 setrgbcolor
0.25875 0.87648 moveto
0.32241 0.83725 lineto
0.28359 0.88937 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.32138 0.83864 moveto
0.32241 0.83725 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28359 0.88937 moveto
0.28482 0.88772 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28482 0.88772 moveto
0.32138 0.83864 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.25875 0.87648 moveto
0.28359 0.88937 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.40199 0.84329 moveto
0.42245 0.84274 lineto
stroke
1 0 0 setrgbcolor
0.44908 0.30537 moveto
0.46181 0.31755 lineto
stroke
0.598 0.733 0.938 setrgbcolor
0.33441 0.27485 moveto
0.34884 0.28363 lineto
0.42631 0.28304 lineto
fill
0.639 0.664 0.858 setrgbcolor
0.34884 0.28363 moveto
0.43717 0.29386 lineto
0.42631 0.28304 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.34884 0.28363 moveto
0.42631 0.28304 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.33441 0.27485 moveto
0.34884 0.28363 lineto
stroke
0.724 0.716 0.842 setrgbcolor
0.25875 0.87648 moveto
0.30349 0.83415 lineto
0.32241 0.83725 lineto
fill
0.68 0.635 0.798 setrgbcolor
0.23521 0.86239 moveto
0.30349 0.83415 lineto
0.25875 0.87648 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.30262 0.83497 moveto
0.30349 0.83415 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.25875 0.87648 moveto
0.26015 0.87516 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.26015 0.87516 moveto
0.30262 0.83497 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.23521 0.86239 moveto
0.25875 0.87648 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.38167 0.8429 moveto
0.40199 0.84329 lineto
stroke
1 0 0 setrgbcolor
0.43717 0.29386 moveto
0.44908 0.30537 lineto
stroke
1 0 0 setrgbcolor
0.36158 0.84171 moveto
0.38167 0.8429 lineto
stroke
0.702 0.738 0.878 setrgbcolor
0.23521 0.86239 moveto
0.28513 0.83055 lineto
0.30349 0.83415 lineto
fill
0.666 0.641 0.815 setrgbcolor
0.21309 0.84742 moveto
0.28513 0.83055 lineto
0.23521 0.86239 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.28348 0.8316 moveto
0.28513 0.83055 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.23521 0.86239 moveto
0.23675 0.86141 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.23675 0.86141 moveto
0.28348 0.8316 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.21309 0.84742 moveto
0.23521 0.86239 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.3418 0.8398 moveto
0.36158 0.84171 lineto
stroke
0.662 0.76 0.922 setrgbcolor
0.21309 0.84742 moveto
0.26742 0.8265 lineto
0.28513 0.83055 lineto
fill
0.646 0.644 0.834 setrgbcolor
0.19248 0.83188 moveto
0.26742 0.8265 lineto
0.21309 0.84742 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.26623 0.82696 moveto
0.26742 0.8265 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.21309 0.84742 moveto
0.21474 0.84678 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.21474 0.84678 moveto
0.26623 0.82696 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.19248 0.83188 moveto
0.21309 0.84742 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.42631 0.28304 moveto
0.43717 0.29386 lineto
stroke
0.62 0.738 0.93 setrgbcolor
0.32228 0.26588 moveto
0.33441 0.27485 lineto
0.41674 0.27287 lineto
fill
0.652 0.678 0.862 setrgbcolor
0.33441 0.27485 moveto
0.42631 0.28304 lineto
0.41674 0.27287 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.33441 0.27485 moveto
0.41674 0.27287 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.32228 0.26588 moveto
0.33441 0.27485 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.32241 0.83725 moveto
0.3418 0.8398 lineto
stroke
0.584 0.772 0.969 setrgbcolor
0.19248 0.83188 moveto
0.25048 0.82207 lineto
0.26742 0.8265 lineto
fill
0.617 0.645 0.855 setrgbcolor
0.17345 0.8161 moveto
0.25048 0.82207 lineto
0.19248 0.83188 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.2499 0.82217 moveto
0.25048 0.82207 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.19248 0.83188 moveto
0.2499 0.82217 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.17345 0.8161 moveto
0.19248 0.83188 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.41674 0.27287 moveto
0.42631 0.28304 lineto
stroke
1 0 0 setrgbcolor
0.30349 0.83415 moveto
0.32241 0.83725 lineto
stroke
0.635 0.742 0.926 setrgbcolor
0.31266 0.25666 moveto
0.32228 0.26588 lineto
0.40869 0.26336 lineto
fill
0.661 0.693 0.869 setrgbcolor
0.32228 0.26588 moveto
0.41674 0.27287 lineto
0.40869 0.26336 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.32228 0.26588 moveto
0.40869 0.26336 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.31266 0.25666 moveto
0.32228 0.26588 lineto
stroke
0.43 0.749 0.994 setrgbcolor
0.17345 0.8161 moveto
0.23445 0.81733 lineto
0.25048 0.82207 lineto
fill
0.578 0.641 0.876 setrgbcolor
0.15609 0.80037 moveto
0.23445 0.81733 lineto
0.17345 0.8161 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.17345 0.8161 moveto
0.23445 0.81733 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.15609 0.80037 moveto
0.17345 0.8161 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.28513 0.83055 moveto
0.30349 0.83415 lineto
stroke
1 0 0 setrgbcolor
0.40869 0.26336 moveto
0.41674 0.27287 lineto
stroke
1 0 0 setrgbcolor
0.26742 0.8265 moveto
0.28513 0.83055 lineto
stroke
0.161 0.632 0.929 setrgbcolor
0.15609 0.80037 moveto
0.21946 0.81236 lineto
0.23445 0.81733 lineto
fill
0.524 0.629 0.897 setrgbcolor
0.14045 0.78501 moveto
0.21946 0.81236 lineto
0.15609 0.80037 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.15609 0.80037 moveto
0.15793 0.80072 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.15793 0.80072 moveto
0.21946 0.81236 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.14045 0.78501 moveto
0.15609 0.80037 lineto
stroke
0.666 0.709 0.88 setrgbcolor
0.31266 0.25666 moveto
0.40869 0.26336 lineto
0.40236 0.2545 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.40236 0.2545 moveto
0.40869 0.26336 lineto
stroke
0.644 0.746 0.923 setrgbcolor
0.30574 0.24715 moveto
0.31266 0.25666 lineto
0.40236 0.2545 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.31266 0.25666 moveto
0.40236 0.2545 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.30574 0.24715 moveto
0.31266 0.25666 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.25048 0.82207 moveto
0.26742 0.8265 lineto
stroke
0 0.401 0.725 setrgbcolor
0.14045 0.78501 moveto
0.20566 0.80729 lineto
0.21946 0.81236 lineto
fill
0.452 0.606 0.912 setrgbcolor
0.1266 0.77031 moveto
0.14045 0.78501 lineto
0.20566 0.80729 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.20282 0.80631 moveto
0.20566 0.80729 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.14045 0.78501 moveto
0.20282 0.80631 lineto
stroke
0.666 0.725 0.893 setrgbcolor
0.30574 0.24715 moveto
0.40236 0.2545 lineto
0.39792 0.24633 lineto
fill
1 0 0 setrgbcolor
0.39792 0.24633 moveto
0.40236 0.2545 lineto
stroke
1 0 0 setrgbcolor
0.23445 0.81733 moveto
0.25048 0.82207 lineto
stroke
0.649 0.749 0.922 setrgbcolor
0.3017 0.23736 moveto
0.30574 0.24715 lineto
0.39792 0.24633 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.30574 0.24715 moveto
0.39792 0.24633 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.30363 0.24203 moveto
0.30574 0.24715 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.21946 0.81236 moveto
0.23445 0.81733 lineto
stroke
0.659 0.741 0.91 setrgbcolor
0.3017 0.23736 moveto
0.39792 0.24633 lineto
0.39552 0.23886 lineto
fill
1 0 0 setrgbcolor
0.39552 0.23886 moveto
0.39792 0.24633 lineto
stroke
0.267 0.519 0.907 setrgbcolor
0.11458 0.75655 moveto
0.1266 0.77031 lineto
0.18231 0.7973 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.1266 0.77031 moveto
0.14045 0.78501 lineto
stroke
0.665 0.735 0.901 setrgbcolor
0.29863 0.24177 moveto
0.39165 0.24655 lineto
0.39366 0.23861 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.29863 0.24177 moveto
0.39165 0.24655 lineto
stroke
1 0 0 setrgbcolor
0.39165 0.24655 moveto
0.39366 0.23861 lineto
stroke
1 0 0 setrgbcolor
0.20566 0.80729 moveto
0.21946 0.81236 lineto
stroke
0.672 0.721 0.886 setrgbcolor
0.29863 0.24177 moveto
0.39366 0.23861 lineto
0.30093 0.22907 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.29863 0.24177 moveto
0.30093 0.22907 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.3936 0.23883 moveto
0.39552 0.23886 lineto
stroke
0.577 0.001 0 setrgbcolor
0.11458 0.75655 moveto
0.18231 0.7973 lineto
0.19322 0.80222 lineto
fill
0.162 0.459 0.885 setrgbcolor
0.10447 0.74399 moveto
0.11458 0.75655 lineto
0.17308 0.79268 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.11458 0.75655 moveto
0.1266 0.77031 lineto
stroke
0.65 0.742 0.916 setrgbcolor
0.30093 0.22907 moveto
0.39366 0.23861 lineto
0.39785 0.23152 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.30093 0.22907 moveto
0.39366 0.23861 lineto
stroke
1 0 0 setrgbcolor
0.39366 0.23861 moveto
0.39785 0.23152 lineto
stroke
1 0 0 setrgbcolor
0.19322 0.80222 moveto
0.20566 0.80729 lineto
stroke
0.669 0.717 0.884 setrgbcolor
0.30093 0.22907 moveto
0.39785 0.23152 lineto
0.30647 0.21626 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.30093 0.22907 moveto
0.30647 0.21626 lineto
stroke
0.629 0.743 0.929 setrgbcolor
0.30647 0.21626 moveto
0.39785 0.23152 lineto
0.4042 0.22538 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.30647 0.21626 moveto
0.39785 0.23152 lineto
stroke
1 0 0 setrgbcolor
0.39785 0.23152 moveto
0.4042 0.22538 lineto
stroke
1 0 0 setrgbcolor
0.18231 0.7973 moveto
0.19322 0.80222 lineto
stroke
0.646 0.089 0 setrgbcolor
0.10447 0.74399 moveto
0.17308 0.79268 lineto
0.18231 0.7973 lineto
fill
0.069 0.399 0.855 setrgbcolor
0.09633 0.73288 moveto
0.10447 0.74399 lineto
0.16571 0.78851 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.10447 0.74399 moveto
0.11458 0.75655 lineto
stroke
0.603 0.735 0.937 setrgbcolor
0.31532 0.2035 moveto
0.4042 0.22538 lineto
0.41264 0.22029 lineto
fill
0.664 0.709 0.881 setrgbcolor
0.30647 0.21626 moveto
0.4042 0.22538 lineto
0.31532 0.2035 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.31733 0.20399 moveto
0.4042 0.22538 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31532 0.2035 moveto
0.31733 0.20399 lineto
stroke
1 0 0 setrgbcolor
0.4042 0.22538 moveto
0.41264 0.22029 lineto
stroke
1 0 0 setrgbcolor
0.17308 0.79268 moveto
0.18231 0.7973 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.30647 0.21626 moveto
0.31532 0.2035 lineto
stroke
0.663 0.116 0 setrgbcolor
0.09633 0.73288 moveto
0.16571 0.78851 lineto
0.17308 0.79268 lineto
fill
0 0.35 0.826 setrgbcolor
0.09024 0.72344 moveto
0.09633 0.73288 lineto
0.16034 0.78495 lineto
fill
0 0 0 setrgbcolor
0.09633 0.73288 moveto
0.10447 0.74399 lineto
stroke
0 0 0 setrgbcolor
0.09024 0.72344 moveto
0.09633 0.73288 lineto
stroke
0.578 0.719 0.939 setrgbcolor
0.3275 0.19099 moveto
0.41264 0.22029 lineto
0.42305 0.21636 lineto
fill
0.66 0.699 0.875 setrgbcolor
0.31532 0.2035 moveto
0.41264 0.22029 lineto
0.3275 0.19099 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.32968 0.19174 moveto
0.41264 0.22029 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3275 0.19099 moveto
0.32968 0.19174 lineto
stroke
1 0 0 setrgbcolor
0.41264 0.22029 moveto
0.42305 0.21636 lineto
stroke
1 0 0 setrgbcolor
0.16571 0.78851 moveto
0.17308 0.79268 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.31532 0.2035 moveto
0.3275 0.19099 lineto
stroke
0.557 0.696 0.932 setrgbcolor
0.343 0.179 moveto
0.42305 0.21636 lineto
0.43529 0.21368 lineto
fill
0.655 0.687 0.868 setrgbcolor
0.3275 0.19099 moveto
0.42305 0.21636 lineto
0.343 0.179 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.3452 0.18003 moveto
0.42305 0.21636 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.343 0.179 moveto
0.3452 0.18003 lineto
stroke
1 0 0 setrgbcolor
0.42305 0.21636 moveto
0.43529 0.21368 lineto
stroke
0.623 0.085 0 setrgbcolor
0.09024 0.72344 moveto
0.16034 0.78495 lineto
0.16571 0.78851 lineto
fill
0 0.346 0.823 setrgbcolor
0.0863 0.71589 moveto
0.09024 0.72344 lineto
0.16034 0.78495 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.09024 0.72344 moveto
0.16034 0.78495 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.0863 0.71589 moveto
0.09024 0.72344 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.16034 0.78495 moveto
0.16571 0.78851 lineto
stroke
0.545 0.668 0.918 setrgbcolor
0.36174 0.1678 moveto
0.43529 0.21368 lineto
0.44917 0.21232 lineto
fill
0.652 0.674 0.858 setrgbcolor
0.343 0.179 moveto
0.43529 0.21368 lineto
0.36174 0.1678 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.43123 0.21115 moveto
0.43529 0.21368 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.36386 0.16912 moveto
0.43123 0.21115 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.36361 0.16896 moveto
0.36386 0.16912 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.36174 0.1678 moveto
0.36361 0.16896 lineto
stroke
1 0 0 setrgbcolor
0.43529 0.21368 moveto
0.44917 0.21232 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.3275 0.19099 moveto
0.343 0.179 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.15712 0.78211 moveto
0.16034 0.78495 lineto
stroke
0 0.314 0.803 setrgbcolor
0.0846 0.71039 moveto
0.15712 0.78211 lineto
0.0863 0.71589 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.0863 0.71589 moveto
0.15712 0.78211 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.0846 0.71039 moveto
0.0863 0.71589 lineto
stroke
0.541 0.64 0.897 setrgbcolor
0.38358 0.1577 moveto
0.44917 0.21232 lineto
0.46452 0.21234 lineto
fill
0.649 0.66 0.847 setrgbcolor
0.36174 0.1678 moveto
0.44917 0.21232 lineto
0.38358 0.1577 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.44634 0.20996 moveto
0.44917 0.21232 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38554 0.15933 moveto
0.44634 0.20996 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38536 0.15918 moveto
0.38554 0.15933 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38358 0.1577 moveto
0.38536 0.15918 lineto
stroke
1 0 0 setrgbcolor
0.44917 0.21232 moveto
0.46452 0.21234 lineto
stroke
0 0.141 0.654 setrgbcolor
0.0846 0.71039 moveto
0.15617 0.78011 lineto
0.15712 0.78211 lineto
fill
1 0 0 setrgbcolor
0.15617 0.78011 moveto
0.15712 0.78211 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.343 0.179 moveto
0.36174 0.1678 lineto
stroke
0.544 0.614 0.873 setrgbcolor
0.40832 0.14904 moveto
0.46452 0.21234 lineto
0.48114 0.21378 lineto
fill
0.648 0.646 0.834 setrgbcolor
0.38358 0.1577 moveto
0.46452 0.21234 lineto
0.40832 0.14904 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.46261 0.2102 moveto
0.46452 0.21234 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41004 0.15098 moveto
0.46261 0.2102 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40992 0.15084 moveto
0.41004 0.15098 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40832 0.14904 moveto
0.40992 0.15084 lineto
stroke
1 0 0 setrgbcolor
0.46452 0.21234 moveto
0.48114 0.21378 lineto
stroke
0 0.301 0.795 setrgbcolor
0.08526 0.70711 moveto
0.15617 0.78011 lineto
0.0846 0.71039 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.0846 0.71039 moveto
0.15617 0.78011 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.0846 0.71039 moveto
0.08526 0.70711 lineto
stroke
0 0.279 0.779 setrgbcolor
0.08526 0.70711 moveto
0.15761 0.779 lineto
0.15617 0.78011 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.15617 0.78011 moveto
0.15761 0.779 lineto
stroke
0.551 0.592 0.847 setrgbcolor
0.43569 0.14217 moveto
0.48114 0.21378 lineto
0.49883 0.21665 lineto
fill
0.648 0.633 0.821 setrgbcolor
0.40832 0.14904 moveto
0.48114 0.21378 lineto
0.43569 0.14217 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.47802 0.20888 moveto
0.48114 0.21378 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4371 0.1444 moveto
0.47802 0.20888 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43702 0.14427 moveto
0.4371 0.1444 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43569 0.14217 moveto
0.43702 0.14427 lineto
stroke
1 0 0 setrgbcolor
0.48114 0.21378 moveto
0.49883 0.21665 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.36174 0.1678 moveto
0.38358 0.1577 lineto
stroke
0.562 0.573 0.823 setrgbcolor
0.46533 0.13741 moveto
0.49883 0.21665 lineto
0.51743 0.22095 lineto
fill
0.65 0.621 0.808 setrgbcolor
0.43569 0.14217 moveto
0.49883 0.21665 lineto
0.46533 0.13741 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.49816 0.21505 moveto
0.49883 0.21665 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46639 0.13993 moveto
0.49816 0.21505 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46533 0.13741 moveto
0.46639 0.13993 lineto
stroke
1 0 0 setrgbcolor
0.49883 0.21665 moveto
0.51743 0.22095 lineto
stroke
0 0.302 0.795 setrgbcolor
0.08839 0.70615 moveto
0.15761 0.779 lineto
0.08526 0.70711 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.08526 0.70711 moveto
0.15761 0.779 lineto
stroke
0.088 0.387 0.846 setrgbcolor
0.08839 0.70615 moveto
0.16151 0.77883 lineto
0.15761 0.779 lineto
fill
1 0 0 setrgbcolor
0.15761 0.779 moveto
0.16151 0.77883 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.38358 0.1577 moveto
0.40832 0.14904 lineto
stroke
0.573 0.559 0.8 setrgbcolor
0.49683 0.1351 moveto
0.51743 0.22095 lineto
0.53675 0.22667 lineto
fill
0.652 0.611 0.795 setrgbcolor
0.46533 0.13741 moveto
0.51743 0.22095 lineto
0.49683 0.1351 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51712 0.21968 moveto
0.51743 0.22095 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49749 0.13786 moveto
0.51712 0.21968 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49683 0.1351 moveto
0.49749 0.13786 lineto
stroke
1 0 0 setrgbcolor
0.51743 0.22095 moveto
0.53675 0.22667 lineto
stroke
0.229 0.455 0.87 setrgbcolor
0.08839 0.70615 moveto
0.16792 0.77955 lineto
0.16151 0.77883 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.08839 0.70615 moveto
0.16151 0.77883 lineto
stroke
1 0 0 setrgbcolor
0.16151 0.77883 moveto
0.16792 0.77955 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.40832 0.14904 moveto
0.43569 0.14217 lineto
stroke
0.585 0.548 0.779 setrgbcolor
0.52973 0.13552 moveto
0.53675 0.22667 lineto
0.55662 0.23379 lineto
fill
0.655 0.602 0.783 setrgbcolor
0.49683 0.1351 moveto
0.53675 0.22667 lineto
0.52973 0.13552 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.52973 0.13552 moveto
0.53675 0.22667 lineto
stroke
1 0 0 setrgbcolor
0.53675 0.22667 moveto
0.55662 0.23379 lineto
stroke
0 0.317 0.804 setrgbcolor
0.08839 0.70615 moveto
0.09411 0.70757 lineto
0.16792 0.77955 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.08526 0.70711 moveto
0.08839 0.70615 lineto
stroke
0.597 0.54 0.761 setrgbcolor
0.56352 0.13892 moveto
0.55662 0.23379 lineto
0.5769 0.24231 lineto
fill
0.659 0.595 0.771 setrgbcolor
0.52973 0.13552 moveto
0.55662 0.23379 lineto
0.56352 0.13892 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.55662 0.23379 moveto
0.56352 0.13892 lineto
stroke
1 0 0 setrgbcolor
0.55662 0.23379 moveto
0.5769 0.24231 lineto
stroke
0.325 0.507 0.882 setrgbcolor
0.09411 0.70757 moveto
0.17686 0.78111 lineto
0.16792 0.77955 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.09411 0.70757 moveto
0.16792 0.77955 lineto
stroke
1 0 0 setrgbcolor
0.16792 0.77955 moveto
0.17686 0.78111 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.43569 0.14217 moveto
0.46533 0.13741 lineto
stroke
0.609 0.535 0.745 setrgbcolor
0.59766 0.14547 moveto
0.5769 0.24231 lineto
0.59742 0.2522 lineto
fill
0.664 0.589 0.76 setrgbcolor
0.56352 0.13892 moveto
0.5769 0.24231 lineto
0.59766 0.14547 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.5774 0.23996 moveto
0.59766 0.14547 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5769 0.24231 moveto
0.5774 0.23996 lineto
stroke
1 0 0 setrgbcolor
0.5769 0.24231 moveto
0.59742 0.2522 lineto
stroke
0 0.326 0.808 setrgbcolor
0.09411 0.70757 moveto
0.10256 0.71141 lineto
0.17686 0.78111 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.08839 0.70615 moveto
0.09411 0.70757 lineto
stroke
0.391 0.546 0.89 setrgbcolor
0.10256 0.71141 moveto
0.18831 0.78338 lineto
0.17686 0.78111 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.10256 0.71141 moveto
0.17686 0.78111 lineto
stroke
1 0 0 setrgbcolor
0.17686 0.78111 moveto
0.18831 0.78338 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.46533 0.13741 moveto
0.49683 0.1351 lineto
stroke
0.621 0.531 0.731 setrgbcolor
0.6316 0.1553 moveto
0.59742 0.2522 lineto
0.61801 0.26349 lineto
fill
0.669 0.584 0.751 setrgbcolor
0.59766 0.14547 moveto
0.59742 0.2522 lineto
0.6316 0.1553 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.59848 0.24919 moveto
0.63046 0.15854 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59742 0.2522 moveto
0.59848 0.24919 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63046 0.15854 moveto
0.6316 0.1553 lineto
stroke
1 0 0 setrgbcolor
0.59742 0.2522 moveto
0.61801 0.26349 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49683 0.1351 moveto
0.52973 0.13552 lineto
stroke
0.632 0.529 0.719 setrgbcolor
0.66481 0.16844 moveto
0.61801 0.26349 lineto
0.63848 0.27618 lineto
fill
0.675 0.581 0.742 setrgbcolor
0.6316 0.1553 moveto
0.61801 0.26349 lineto
0.66481 0.16844 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62135 0.2567 moveto
0.66323 0.17163 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61979 0.25987 moveto
0.62135 0.2567 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61801 0.26349 moveto
0.61979 0.25987 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66323 0.17163 moveto
0.66481 0.16844 lineto
stroke
1 0 0 setrgbcolor
0.61801 0.26349 moveto
0.63848 0.27618 lineto
stroke
0 0.327 0.803 setrgbcolor
0.10256 0.71141 moveto
0.11383 0.71762 lineto
0.18831 0.78338 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.09411 0.70757 moveto
0.10256 0.71141 lineto
stroke
0.434 0.58 0.899 setrgbcolor
0.11383 0.71762 moveto
0.20219 0.7862 lineto
0.18831 0.78338 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.11383 0.71762 moveto
0.18831 0.78338 lineto
stroke
1 0 0 setrgbcolor
0.18831 0.78338 moveto
0.20219 0.7862 lineto
stroke
0.643 0.529 0.708 setrgbcolor
0.69677 0.18485 moveto
0.63848 0.27618 lineto
0.65863 0.2903 lineto
fill
0.681 0.579 0.733 setrgbcolor
0.66481 0.16844 moveto
0.63848 0.27618 lineto
0.69677 0.18485 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.64332 0.2686 moveto
0.6948 0.18794 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64112 0.27204 moveto
0.64332 0.2686 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63848 0.27618 moveto
0.64112 0.27204 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6948 0.18794 moveto
0.69677 0.18485 lineto
stroke
1 0 0 setrgbcolor
0.63848 0.27618 moveto
0.65863 0.2903 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.52973 0.13552 moveto
0.56352 0.13892 lineto
stroke
0 0.312 0.78 setrgbcolor
0.11383 0.71762 moveto
0.12802 0.72609 lineto
0.20219 0.7862 lineto
fill
0 0 0 setrgbcolor
0.10256 0.71141 moveto
0.11383 0.71762 lineto
stroke
0.461 0.612 0.913 setrgbcolor
0.12802 0.72609 moveto
0.2184 0.78937 lineto
0.20219 0.7862 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.12802 0.72609 moveto
0.13017 0.72783 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.13017 0.72783 moveto
0.20219 0.7862 lineto
stroke
1 0 0 setrgbcolor
0.20219 0.7862 moveto
0.2184 0.78937 lineto
stroke
0.655 0.53 0.699 setrgbcolor
0.72703 0.20442 moveto
0.65863 0.2903 lineto
0.67823 0.30585 lineto
fill
0.688 0.578 0.726 setrgbcolor
0.69677 0.18485 moveto
0.65863 0.2903 lineto
0.72703 0.20442 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.66893 0.27737 moveto
0.7247 0.20736 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66517 0.28209 moveto
0.66893 0.27737 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66226 0.28573 moveto
0.66517 0.28209 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65863 0.2903 moveto
0.66226 0.28573 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.7247 0.20736 moveto
0.72703 0.20442 lineto
stroke
1 0 0 setrgbcolor
0.65863 0.2903 moveto
0.67823 0.30585 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.56352 0.13892 moveto
0.59766 0.14547 lineto
stroke
0.666 0.532 0.691 setrgbcolor
0.75518 0.22699 moveto
0.67823 0.30585 lineto
0.69702 0.32284 lineto
fill
0.695 0.578 0.72 setrgbcolor
0.72703 0.20442 moveto
0.67823 0.30585 lineto
0.75518 0.22699 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.68665 0.29722 moveto
0.75253 0.22971 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68296 0.30099 moveto
0.68665 0.29722 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67823 0.30585 moveto
0.68296 0.30099 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.75253 0.22971 moveto
0.75518 0.22699 lineto
stroke
1 0 0 setrgbcolor
0.67823 0.30585 moveto
0.69702 0.32284 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.59766 0.14547 moveto
0.6316 0.1553 lineto
stroke
0 0.27 0.72 setrgbcolor
0.12802 0.72609 moveto
0.1452 0.73666 lineto
0.2184 0.78937 lineto
fill
0.473 0.644 0.932 setrgbcolor
0.1452 0.73666 moveto
0.23679 0.79266 lineto
0.2184 0.78937 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.1452 0.73666 moveto
0.14807 0.73873 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.14807 0.73873 moveto
0.2124 0.78505 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2124 0.78505 moveto
0.2184 0.78937 lineto
stroke
1 0 0 setrgbcolor
0.2184 0.78937 moveto
0.23679 0.79266 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.6316 0.1553 moveto
0.66481 0.16844 lineto
stroke
0.678 0.536 0.684 setrgbcolor
0.78088 0.25231 moveto
0.69702 0.32284 lineto
0.71474 0.34126 lineto
fill
0.703 0.579 0.714 setrgbcolor
0.75518 0.22699 moveto
0.69702 0.32284 lineto
0.78088 0.25231 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.70751 0.31401 moveto
0.77795 0.25477 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.69702 0.32284 moveto
0.70751 0.31401 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.77795 0.25477 moveto
0.78088 0.25231 lineto
stroke
1 0 0 setrgbcolor
0.69702 0.32284 moveto
0.71474 0.34126 lineto
stroke
0.748 0.602 0.695 setrgbcolor
0.86524 0.4096 moveto
0.77779 0.45205 lineto
0.87265 0.44484 lineto
fill
0.735 0.572 0.67 setrgbcolor
0.86524 0.4096 moveto
0.76942 0.42785 lineto
0.77779 0.45205 lineto
fill
0.741 0.597 0.696 setrgbcolor
0.85463 0.37517 moveto
0.76942 0.42785 lineto
0.86524 0.4096 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.76942 0.42785 moveto
0.86524 0.4096 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.86524 0.4096 moveto
0.87265 0.44484 lineto
stroke
0 0 0 setrgbcolor
0.85463 0.37517 moveto
0.86524 0.4096 lineto
stroke
0.754 0.607 0.695 setrgbcolor
0.87265 0.44484 moveto
0.78364 0.47686 lineto
0.8769 0.48055 lineto
fill
0.745 0.582 0.672 setrgbcolor
0.87265 0.44484 moveto
0.77779 0.45205 lineto
0.78364 0.47686 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.77779 0.45205 moveto
0.87265 0.44484 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.87265 0.44484 moveto
0.8769 0.48055 lineto
stroke
0.725 0.562 0.67 setrgbcolor
0.85463 0.37517 moveto
0.75871 0.4045 lineto
0.76942 0.42785 lineto
fill
0.734 0.593 0.698 setrgbcolor
0.84083 0.34187 moveto
0.75871 0.4045 lineto
0.85463 0.37517 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.75871 0.4045 moveto
0.85118 0.37622 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.85118 0.37622 moveto
0.85463 0.37517 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.84083 0.34187 moveto
0.85463 0.37517 lineto
stroke
0.713 0.554 0.671 setrgbcolor
0.84083 0.34187 moveto
0.74586 0.38219 lineto
0.75871 0.4045 lineto
fill
0.726 0.588 0.701 setrgbcolor
0.82388 0.31007 moveto
0.74586 0.38219 lineto
0.84083 0.34187 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.75623 0.37778 moveto
0.83747 0.3433 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.83747 0.3433 moveto
0.84083 0.34187 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.74586 0.38219 moveto
0.75623 0.37778 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.82388 0.31007 moveto
0.84083 0.34187 lineto
stroke
0.754 0.607 0.695 setrgbcolor
0.78364 0.47686 moveto
0.87804 0.51641 lineto
0.8769 0.48055 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.78364 0.47686 moveto
0.8769 0.48055 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.8769 0.48055 moveto
0.87804 0.51641 lineto
stroke
0 0 0 setrgbcolor
0.66481 0.16844 moveto
0.69677 0.18485 lineto
stroke
0 0 0 setrgbcolor
0.11383 0.71762 moveto
0.12802 0.72609 lineto
stroke
0.701 0.547 0.674 setrgbcolor
0.82388 0.31007 moveto
0.73111 0.36107 lineto
0.74586 0.38219 lineto
fill
0.718 0.584 0.704 setrgbcolor
0.80384 0.28011 moveto
0.73111 0.36107 lineto
0.82388 0.31007 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.73984 0.35627 moveto
0.82055 0.3119 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.73111 0.36107 moveto
0.73984 0.35627 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.82055 0.3119 moveto
0.82388 0.31007 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.80384 0.28011 moveto
0.82388 0.31007 lineto
stroke
0.758 0.611 0.695 setrgbcolor
0.78684 0.50205 moveto
0.87613 0.55209 lineto
0.87804 0.51641 lineto
fill
0.76 0.597 0.674 setrgbcolor
0.78364 0.47686 moveto
0.78684 0.50205 lineto
0.87804 0.51641 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.78684 0.50205 moveto
0.87804 0.51641 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.87613 0.55209 moveto
0.87804 0.51641 lineto
stroke
0.689 0.54 0.679 setrgbcolor
0.80384 0.28011 moveto
0.71474 0.34126 lineto
0.73111 0.36107 lineto
fill
0.71 0.582 0.709 setrgbcolor
0.78088 0.25231 moveto
0.71474 0.34126 lineto
0.80384 0.28011 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.72201 0.33627 moveto
0.8007 0.28227 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.71474 0.34126 moveto
0.72201 0.33627 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.8007 0.28227 moveto
0.80169 0.28158 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.80169 0.28158 moveto
0.80384 0.28011 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.78088 0.25231 moveto
0.80384 0.28011 lineto
stroke
0 0 0 setrgbcolor
0.69677 0.18485 moveto
0.72703 0.20442 lineto
stroke
0 0 0 setrgbcolor
0.75518 0.22699 moveto
0.78088 0.25231 lineto
stroke
0 0 0 setrgbcolor
0.72703 0.20442 moveto
0.75518 0.22699 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.71474 0.34126 moveto
0.73111 0.36107 lineto
stroke
0.762 0.615 0.695 setrgbcolor
0.78732 0.52734 moveto
0.87124 0.58731 lineto
0.87613 0.55209 lineto
fill
0.765 0.606 0.681 setrgbcolor
0.78684 0.50205 moveto
0.78732 0.52734 lineto
0.87613 0.55209 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.78732 0.52734 moveto
0.87613 0.55209 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.87124 0.58731 moveto
0.87613 0.55209 lineto
stroke
0.466 0.679 0.957 setrgbcolor
0.23679 0.79266 moveto
0.16812 0.75073 lineto
0.25717 0.79586 lineto
fill
0.429 0.713 0.983 setrgbcolor
0.18853 0.76296 moveto
0.27934 0.79873 lineto
0.25717 0.79586 lineto
fill
0.627 0.067 0 setrgbcolor
0.21457 0.77797 moveto
0.27597 0.79765 lineto
0.24333 0.79361 lineto
fill
0.627 0.067 0 setrgbcolor
0.24333 0.79361 moveto
0.27597 0.79765 lineto
0.27802 0.79854 lineto
fill
0.466 0.679 0.957 setrgbcolor
0.16538 0.74906 moveto
0.17182 0.75234 lineto
0.16812 0.75073 lineto
fill
0.466 0.679 0.957 setrgbcolor
0.25717 0.79586 moveto
0.16812 0.75073 lineto
0.17182 0.75234 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.23184 0.78964 moveto
0.23679 0.79266 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.16538 0.74906 moveto
0.16812 0.75073 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.16812 0.75073 moveto
0.23184 0.78964 lineto
stroke
1 0 0 setrgbcolor
0.23679 0.79266 moveto
0.25717 0.79586 lineto
stroke
1 0 0 setrgbcolor
0.73111 0.36107 moveto
0.74586 0.38219 lineto
stroke
0.764 0.617 0.696 setrgbcolor
0.78502 0.55247 moveto
0.86344 0.62176 lineto
0.87124 0.58731 lineto
fill
0.766 0.612 0.687 setrgbcolor
0.78732 0.52734 moveto
0.78502 0.55247 lineto
0.87124 0.58731 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.78502 0.55247 moveto
0.87124 0.58731 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.86344 0.62176 moveto
0.87124 0.58731 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.74586 0.38219 moveto
0.75871 0.4045 lineto
stroke
0.764 0.617 0.696 setrgbcolor
0.77997 0.57716 moveto
0.85281 0.65516 lineto
0.86344 0.62176 lineto
fill
0.765 0.616 0.693 setrgbcolor
0.78502 0.55247 moveto
0.77997 0.57716 lineto
0.86344 0.62176 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.77997 0.57716 moveto
0.86344 0.62176 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.85281 0.65516 moveto
0.86344 0.62176 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.75871 0.4045 moveto
0.76942 0.42785 lineto
stroke
0.503 0 0 setrgbcolor
0.18853 0.76296 moveto
0.25717 0.79586 lineto
0.21457 0.77797 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.25634 0.79546 moveto
0.25717 0.79586 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.19106 0.76418 moveto
0.22616 0.781 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.18853 0.76296 moveto
0.19106 0.76418 lineto
stroke
1 0 0 setrgbcolor
0.25717 0.79586 moveto
0.27934 0.79873 lineto
stroke
0.763 0.616 0.696 setrgbcolor
0.77219 0.60116 moveto
0.83939 0.68722 lineto
0.85281 0.65516 lineto
fill
0.762 0.617 0.699 setrgbcolor
0.77997 0.57716 moveto
0.77219 0.60116 lineto
0.85281 0.65516 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.77219 0.60116 moveto
0.85281 0.65516 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.83939 0.68722 moveto
0.85281 0.65516 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.76942 0.42785 moveto
0.77779 0.45205 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.12802 0.72609 moveto
0.1452 0.73666 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.77779 0.45205 moveto
0.78364 0.47686 lineto
stroke
0.761 0.614 0.695 setrgbcolor
0.76177 0.62424 moveto
0.82325 0.71767 lineto
0.83939 0.68722 lineto
fill
0.756 0.615 0.703 setrgbcolor
0.77219 0.60116 moveto
0.76177 0.62424 lineto
0.83939 0.68722 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.80323 0.65788 moveto
0.83939 0.68722 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76177 0.62424 moveto
0.80323 0.65788 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.82325 0.71767 moveto
0.83939 0.68722 lineto
stroke
0.324 0.727 0.98 setrgbcolor
0.21457 0.77797 moveto
0.30307 0.80106 lineto
0.27934 0.79873 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.27157 0.79623 moveto
0.27934 0.79873 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.21457 0.77797 moveto
0.27157 0.79623 lineto
stroke
1 0 0 setrgbcolor
0.27934 0.79873 moveto
0.30307 0.80106 lineto
stroke
1 0 0 setrgbcolor
0.78364 0.47686 moveto
0.78684 0.50205 lineto
stroke
1 0 0 setrgbcolor
0.78684 0.50205 moveto
0.78732 0.52734 lineto
stroke
0.759 0.61 0.693 setrgbcolor
0.74883 0.6462 moveto
0.80445 0.74623 lineto
0.82325 0.71767 lineto
fill
0.749 0.611 0.705 setrgbcolor
0.76177 0.62424 moveto
0.74883 0.6462 lineto
0.82325 0.71767 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.79587 0.69138 moveto
0.82325 0.71767 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.77012 0.66664 moveto
0.79587 0.69138 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.74883 0.6462 moveto
0.77012 0.66664 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.80445 0.74623 moveto
0.82325 0.71767 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.78502 0.55247 moveto
0.78732 0.52734 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29676 0.80027 moveto
0.30307 0.80106 lineto
stroke
1 0 0 setrgbcolor
0.77997 0.57716 moveto
0.78502 0.55247 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.1452 0.73666 moveto
0.16538 0.74906 lineto
stroke
0.755 0.604 0.69 setrgbcolor
0.7335 0.66685 moveto
0.78306 0.77261 lineto
0.80445 0.74623 lineto
fill
0.741 0.604 0.705 setrgbcolor
0.74883 0.6462 moveto
0.7335 0.66685 lineto
0.80445 0.74623 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.76024 0.69676 moveto
0.80445 0.74623 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.74678 0.6817 moveto
0.76024 0.69676 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.7335 0.66685 moveto
0.74678 0.6817 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.78306 0.77261 moveto
0.80445 0.74623 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.77219 0.60116 moveto
0.77997 0.57716 lineto
stroke
0.726 0.296 0.226 setrgbcolor
0.24333 0.79361 moveto
0.27459 0.80936 lineto
0.3281 0.80267 lineto
fill
0.278 0 0 setrgbcolor
0.27459 0.80936 moveto
0.35421 0.80342 lineto
0.3281 0.80267 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.27459 0.80936 moveto
0.3281 0.80267 lineto
stroke
1 0 0 setrgbcolor
0.3281 0.80267 moveto
0.35421 0.80342 lineto
stroke
1 0 0 setrgbcolor
0.76177 0.62424 moveto
0.77219 0.60116 lineto
stroke
1 0 0 setrgbcolor
0.74883 0.6462 moveto
0.76177 0.62424 lineto
stroke
0.733 0.357 0.34 setrgbcolor
0.27459 0.80936 moveto
0.30806 0.82466 lineto
0.35421 0.80342 lineto
fill
0.492 0.012 0.044 setrgbcolor
0.30806 0.82466 moveto
0.38115 0.80319 lineto
0.35421 0.80342 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.30806 0.82466 moveto
0.35421 0.80342 lineto
stroke
1 0 0 setrgbcolor
0.35421 0.80342 moveto
0.38115 0.80319 lineto
stroke
0.751 0.598 0.686 setrgbcolor
0.71597 0.68608 moveto
0.75915 0.79656 lineto
0.78306 0.77261 lineto
fill
0.733 0.595 0.703 setrgbcolor
0.7335 0.66685 moveto
0.71597 0.68608 lineto
0.78306 0.77261 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.73335 0.7085 moveto
0.78306 0.77261 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.71597 0.68608 moveto
0.73335 0.7085 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.75915 0.79656 moveto
0.78306 0.77261 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.7335 0.66685 moveto
0.74883 0.6462 lineto
stroke
0.732 0.401 0.42 setrgbcolor
0.30806 0.82466 moveto
0.34337 0.83895 lineto
0.38115 0.80319 lineto
fill
0.58 0.198 0.282 setrgbcolor
0.34337 0.83895 moveto
0.40871 0.8019 lineto
0.38115 0.80319 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.37997 0.80431 moveto
0.38115 0.80319 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.34337 0.83895 moveto
0.37997 0.80431 lineto
stroke
1 0 0 setrgbcolor
0.38115 0.80319 moveto
0.40871 0.8019 lineto
stroke
1 0 0 setrgbcolor
0.71597 0.68608 moveto
0.7335 0.66685 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.16538 0.74906 moveto
0.18853 0.76296 lineto
stroke
0.73 0.434 0.478 setrgbcolor
0.34337 0.83895 moveto
0.38013 0.85167 lineto
0.40871 0.8019 lineto
fill
0.643 0.373 0.493 setrgbcolor
0.40871 0.8019 moveto
0.41789 0.86233 lineto
0.43667 0.79947 lineto
fill
0.728 0.431 0.477 setrgbcolor
0.40871 0.8019 moveto
0.38013 0.85167 lineto
0.41789 0.86233 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.40793 0.80326 moveto
0.40871 0.8019 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38013 0.85167 moveto
0.40793 0.80326 lineto
stroke
1 0 0 setrgbcolor
0.40871 0.8019 moveto
0.43667 0.79947 lineto
stroke
0.724 0.585 0.698 setrgbcolor
0.71597 0.68608 moveto
0.69642 0.7038 lineto
0.75915 0.79656 lineto
fill
1 0 0 setrgbcolor
0.69642 0.7038 moveto
0.71597 0.68608 lineto
stroke
0.747 0.59 0.681 setrgbcolor
0.69642 0.7038 moveto
0.73281 0.81781 lineto
0.75915 0.79656 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.69642 0.7038 moveto
0.75915 0.79656 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.73281 0.81781 moveto
0.75915 0.79656 lineto
stroke
0.716 0.573 0.693 setrgbcolor
0.69642 0.7038 moveto
0.67506 0.71995 lineto
0.73281 0.81781 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.67506 0.71995 moveto
0.69642 0.7038 lineto
stroke
0.655 0.416 0.545 setrgbcolor
0.43667 0.79947 moveto
0.4562 0.87045 lineto
0.46483 0.79589 lineto
fill
0.726 0.458 0.521 setrgbcolor
0.43667 0.79947 moveto
0.41789 0.86233 lineto
0.4562 0.87045 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.41789 0.86233 moveto
0.43667 0.79947 lineto
stroke
1 0 0 setrgbcolor
0.43667 0.79947 moveto
0.46483 0.79589 lineto
stroke
0.743 0.582 0.674 setrgbcolor
0.67506 0.71995 moveto
0.70414 0.83611 lineto
0.73281 0.81781 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.67506 0.71995 moveto
0.73281 0.81781 lineto
stroke
0.708 0.561 0.685 setrgbcolor
0.67506 0.71995 moveto
0.6521 0.73452 lineto
0.70414 0.83611 lineto
fill
1 0 0 setrgbcolor
0.6521 0.73452 moveto
0.67506 0.71995 lineto
stroke
0.653 0.414 0.545 setrgbcolor
0.49302 0.7911 moveto
0.46483 0.79589 lineto
0.4562 0.87045 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4562 0.87045 moveto
0.46483 0.79589 lineto
stroke
1 0 0 setrgbcolor
0.46483 0.79589 moveto
0.49302 0.7911 lineto
stroke
0.739 0.572 0.667 setrgbcolor
0.6521 0.73452 moveto
0.67331 0.85127 lineto
0.70414 0.83611 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.6521 0.73452 moveto
0.65498 0.74013 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65498 0.74013 moveto
0.70414 0.83611 lineto
stroke
0.701 0.547 0.675 setrgbcolor
0.6521 0.73452 moveto
0.62777 0.74754 lineto
0.67331 0.85127 lineto
fill
1 0 0 setrgbcolor
0.62777 0.74754 moveto
0.6521 0.73452 lineto
stroke
0.726 0.498 0.581 setrgbcolor
0.49302 0.7911 moveto
0.4562 0.87045 lineto
0.49458 0.87567 lineto
fill
0.663 0.448 0.582 setrgbcolor
0.52105 0.78506 moveto
0.49302 0.7911 lineto
0.49458 0.87567 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.49302 0.7911 moveto
0.49458 0.87567 lineto
stroke
1 0 0 setrgbcolor
0.49302 0.7911 moveto
0.52105 0.78506 lineto
stroke
0.736 0.562 0.658 setrgbcolor
0.62777 0.74754 moveto
0.64048 0.86309 lineto
0.67331 0.85127 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.62777 0.74754 moveto
0.62962 0.75174 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62962 0.75174 moveto
0.67331 0.85127 lineto
stroke
0.693 0.532 0.663 setrgbcolor
0.62777 0.74754 moveto
0.60229 0.75905 lineto
0.64048 0.86309 lineto
fill
1 0 0 setrgbcolor
0.60229 0.75905 moveto
0.62777 0.74754 lineto
stroke
0.727 0.514 0.602 setrgbcolor
0.52105 0.78506 moveto
0.49458 0.87567 lineto
0.53259 0.8777 lineto
fill
0.672 0.474 0.61 setrgbcolor
0.54873 0.77775 moveto
0.52105 0.78506 lineto
0.53259 0.8777 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.52105 0.78506 moveto
0.53259 0.8777 lineto
stroke
1 0 0 setrgbcolor
0.52105 0.78506 moveto
0.54873 0.77775 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.70414 0.83611 moveto
0.73281 0.81781 lineto
stroke
0.732 0.551 0.647 setrgbcolor
0.60229 0.75905 moveto
0.60589 0.87147 lineto
0.64048 0.86309 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60229 0.75905 moveto
0.60337 0.76199 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60337 0.76199 moveto
0.64048 0.86309 lineto
stroke
0.686 0.515 0.649 setrgbcolor
0.60229 0.75905 moveto
0.57588 0.7691 lineto
0.60589 0.87147 lineto
fill
1 0 0 setrgbcolor
0.57588 0.7691 moveto
0.60229 0.75905 lineto
stroke
0.728 0.527 0.619 setrgbcolor
0.54873 0.77775 moveto
0.53259 0.8777 lineto
0.56982 0.87633 lineto
fill
0.679 0.496 0.631 setrgbcolor
0.57588 0.7691 moveto
0.54873 0.77775 lineto
0.56982 0.87633 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.54873 0.77775 moveto
0.56982 0.87633 lineto
stroke
1 0 0 setrgbcolor
0.54873 0.77775 moveto
0.57588 0.7691 lineto
stroke
0.73 0.54 0.634 setrgbcolor
0.57588 0.7691 moveto
0.56982 0.87633 lineto
0.60589 0.87147 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.57588 0.7691 moveto
0.57641 0.77092 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57641 0.77092 moveto
0.60589 0.87147 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.18853 0.76296 moveto
0.21457 0.77797 lineto
stroke
0 0 0 setrgbcolor
0.67331 0.85127 moveto
0.70414 0.83611 lineto
stroke
0 0 0 setrgbcolor
0.64048 0.86309 moveto
0.67331 0.85127 lineto
stroke
0 0 0 setrgbcolor
0.21457 0.77797 moveto
0.24333 0.79361 lineto
stroke
0 0 0 setrgbcolor
0.60589 0.87147 moveto
0.64048 0.86309 lineto
stroke
0 0 0 setrgbcolor
0.24333 0.79361 moveto
0.27459 0.80936 lineto
stroke
0 0 0 setrgbcolor
0.56982 0.87633 moveto
0.60589 0.87147 lineto
stroke
0 0 0 setrgbcolor
0.27459 0.80936 moveto
0.30806 0.82466 lineto
stroke
0 0 0 setrgbcolor
0.53259 0.8777 moveto
0.56982 0.87633 lineto
stroke
0 0 0 setrgbcolor
0.30806 0.82466 moveto
0.34337 0.83895 lineto
stroke
0 0 0 setrgbcolor
0.49458 0.87567 moveto
0.53259 0.8777 lineto
stroke
0 0 0 setrgbcolor
0.34337 0.83895 moveto
0.38013 0.85167 lineto
stroke
0 0 0 setrgbcolor
0.4562 0.87045 moveto
0.49458 0.87567 lineto
stroke
0 0 0 setrgbcolor
0.41789 0.86233 moveto
0.4562 0.87045 lineto
stroke
0 0 0 setrgbcolor
0.38013 0.85167 moveto
0.41789 0.86233 lineto
stroke
% End of Graphics
Mpend % End of picture
:[font = input; ]
clear;top=100;kappa[s_]:=0.6Cos[s];tau[s_]:=0.6Sin[s];ds:=N[12Pi/top];
width=1.5;pribbonfrenet;Show[picture,ViewPoint->{2,1,1.7}]
:[inactive; PostScript; output; pictureLeft = 43; pictureWidth = 293; pictureHeight = 262; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.43022 0.54284 moveto
0.86852 0.40728 lineto
stroke
0.43022 0.54284 moveto
0.41005 0.97619 lineto
stroke
0.94449 0.86754 moveto
0.41005 0.97619 lineto
stroke
0.94449 0.86754 moveto
0.86852 0.40728 lineto
stroke
0.15373 0.23881 moveto
0.67491 0.02381 lineto
stroke
0.15373 0.23881 moveto
0.05551 0.72566 lineto
stroke
0.7189 0.53256 moveto
0.05551 0.72566 lineto
stroke
0.7189 0.53256 moveto
0.67491 0.02381 lineto
stroke
0.43022 0.54284 moveto
0.41005 0.97619 lineto
stroke
0.43022 0.54284 moveto
0.15373 0.23881 lineto
stroke
0.05551 0.72566 moveto
0.15373 0.23881 lineto
stroke
0.05551 0.72566 moveto
0.41005 0.97619 lineto
stroke
0.86852 0.40728 moveto
0.94449 0.86754 lineto
stroke
0.86852 0.40728 moveto
0.67491 0.02381 lineto
stroke
0.7189 0.53256 moveto
0.67491 0.02381 lineto
stroke
0.7189 0.53256 moveto
0.94449 0.86754 lineto
stroke
0.43022 0.54284 moveto
0.15373 0.23881 lineto
stroke
0.43022 0.54284 moveto
0.86852 0.40728 lineto
stroke
0.67491 0.02381 moveto
0.86852 0.40728 lineto
stroke
0.67491 0.02381 moveto
0.15373 0.23881 lineto
stroke
0.41005 0.97619 moveto
0.05551 0.72566 lineto
stroke
0.41005 0.97619 moveto
0.94449 0.86754 lineto
stroke
0.7189 0.53256 moveto
0.94449 0.86754 lineto
stroke
0.7189 0.53256 moveto
0.05551 0.72566 lineto
stroke
grestore
0.561 0.464 0.701 setrgbcolor
0.67927 0.4796 moveto
0.73599 0.46882 lineto
0.68217 0.49682 lineto
fill
0.572 0.703 0.93 setrgbcolor
0.67927 0.4796 moveto
0.72212 0.46412 lineto
0.73599 0.46882 lineto
fill
0.506 0.43 0.704 setrgbcolor
0.67885 0.46194 moveto
0.72212 0.46412 lineto
0.67927 0.4796 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.71438 0.46692 moveto
0.72212 0.46412 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.7082 0.46915 moveto
0.71438 0.46692 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67927 0.4796 moveto
0.7082 0.46915 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.67927 0.4796 moveto
0.68217 0.49682 lineto
stroke
0 0 0 setrgbcolor
0.67885 0.46194 moveto
0.67927 0.4796 lineto
stroke
0.6 0.481 0.689 setrgbcolor
0.68217 0.49682 moveto
0.75417 0.47929 lineto
0.6872 0.5131 lineto
fill
0.629 0.633 0.835 setrgbcolor
0.68217 0.49682 moveto
0.73599 0.46882 lineto
0.75417 0.47929 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.7209 0.47667 moveto
0.73599 0.46882 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68402 0.49586 moveto
0.7209 0.47667 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68217 0.49682 moveto
0.68402 0.49586 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.68217 0.49682 moveto
0.6872 0.5131 lineto
stroke
0.262 0.682 0.966 setrgbcolor
0.67885 0.46194 moveto
0.71582 0.46229 lineto
0.72212 0.46412 lineto
fill
0.459 0.391 0.693 setrgbcolor
0.6812 0.44477 moveto
0.71582 0.46229 lineto
0.67885 0.46194 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.67885 0.46194 moveto
0.71582 0.46229 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.67885 0.46194 moveto
0.6812 0.44477 lineto
stroke
0.628 0.493 0.678 setrgbcolor
0.6872 0.5131 moveto
0.77222 0.4974 lineto
0.6935 0.5288 lineto
fill
0.645 0.59 0.777 setrgbcolor
0.6872 0.5131 moveto
0.75417 0.47929 lineto
0.77222 0.4974 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.72903 0.49198 moveto
0.75417 0.47929 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68982 0.51178 moveto
0.72903 0.49198 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6872 0.5131 moveto
0.68982 0.51178 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.6872 0.5131 moveto
0.6935 0.5288 lineto
stroke
0.508 0.361 0.616 setrgbcolor
0.6812 0.44477 moveto
0.71872 0.4602 lineto
0.71582 0.46229 lineto
fill
0.472 0.396 0.69 setrgbcolor
0.68653 0.42871 moveto
0.71872 0.4602 lineto
0.6812 0.44477 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.71865 0.46017 moveto
0.71872 0.4602 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68382 0.44585 moveto
0.71865 0.46017 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6812 0.44477 moveto
0.68382 0.44585 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.6812 0.44477 moveto
0.68653 0.42871 lineto
stroke
0.65 0.506 0.674 setrgbcolor
0.6935 0.5288 moveto
0.7852 0.52348 lineto
0.69921 0.54494 lineto
fill
0.654 0.563 0.74 setrgbcolor
0.6935 0.5288 moveto
0.77222 0.4974 lineto
0.7852 0.52348 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.73197 0.51346 moveto
0.77222 0.4974 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.69527 0.5281 moveto
0.73197 0.51346 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6935 0.5288 moveto
0.69527 0.5281 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.6935 0.5288 moveto
0.69921 0.54494 lineto
stroke
0.425 0.162 0.409 setrgbcolor
0.5997 0.67411 moveto
0.63788 0.67215 lineto
0.58423 0.68968 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63712 0.67219 moveto
0.63788 0.67215 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60167 0.67401 moveto
0.63712 0.67219 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5997 0.67411 moveto
0.60167 0.67401 lineto
stroke
0.511 0.276 0.494 setrgbcolor
0.61756 0.65909 moveto
0.65212 0.67328 lineto
0.5997 0.67411 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.58423 0.68968 moveto
0.5997 0.67411 lineto
stroke
0 0 0 setrgbcolor
0.5997 0.67411 moveto
0.61756 0.65909 lineto
stroke
0.513 0.273 0.488 setrgbcolor
0.63693 0.64491 moveto
0.65212 0.67328 lineto
0.61756 0.65909 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.61774 0.65916 moveto
0.65212 0.67328 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61756 0.65909 moveto
0.61774 0.65916 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.61756 0.65909 moveto
0.63693 0.64491 lineto
stroke
0.437 0.177 0.42 setrgbcolor
0.58423 0.68968 moveto
0.63169 0.67807 lineto
0.57184 0.70474 lineto
fill
0.537 0.463 0.72 setrgbcolor
0.58423 0.68968 moveto
0.63152 0.67288 lineto
0.63169 0.67807 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.58423 0.68968 moveto
0.58791 0.68838 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63103 0.67306 moveto
0.63152 0.67288 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58791 0.68838 moveto
0.63103 0.67306 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.57184 0.70474 moveto
0.58423 0.68968 lineto
stroke
0.61 0.403 0.576 setrgbcolor
0.68653 0.42871 moveto
0.7307 0.45476 lineto
0.71872 0.4602 lineto
fill
0.526 0.446 0.709 setrgbcolor
0.69444 0.41355 moveto
0.7307 0.45476 lineto
0.68653 0.42871 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.68727 0.42915 moveto
0.70907 0.44201 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68653 0.42871 moveto
0.68727 0.42915 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.72777 0.45304 moveto
0.7307 0.45476 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.70907 0.44201 moveto
0.72777 0.45304 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.68653 0.42871 moveto
0.69444 0.41355 lineto
stroke
0.662 0.329 0.398 setrgbcolor
0.63693 0.64491 moveto
0.67423 0.67262 lineto
0.65212 0.67328 lineto
fill
0.579 0.376 0.57 setrgbcolor
0.65661 0.63083 moveto
0.67423 0.67262 lineto
0.63693 0.64491 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63693 0.64491 moveto
0.67423 0.67262 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.63693 0.64491 moveto
0.65661 0.63083 lineto
stroke
0.664 0.519 0.677 setrgbcolor
0.69921 0.54494 moveto
0.78879 0.5559 lineto
0.70172 0.56227 lineto
fill
0.66 0.545 0.712 setrgbcolor
0.69921 0.54494 moveto
0.7852 0.52348 lineto
0.78879 0.5559 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.69921 0.54494 moveto
0.7852 0.52348 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.69921 0.54494 moveto
0.70172 0.56227 lineto
stroke
0.676 0.422 0.53 setrgbcolor
0.65661 0.63083 moveto
0.70247 0.6659 lineto
0.67423 0.67262 lineto
fill
0.618 0.445 0.626 setrgbcolor
0.67485 0.61567 moveto
0.70247 0.6659 lineto
0.65661 0.63083 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.68805 0.65488 moveto
0.70247 0.6659 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65661 0.63083 moveto
0.68805 0.65488 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.65661 0.63083 moveto
0.67485 0.61567 lineto
stroke
0.512 0.257 0.466 setrgbcolor
0.57184 0.70474 moveto
0.63584 0.6894 lineto
0.56302 0.71835 lineto
fill
0.595 0.506 0.723 setrgbcolor
0.57184 0.70474 moveto
0.63169 0.67807 lineto
0.63584 0.6894 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62285 0.68201 moveto
0.63169 0.67807 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57184 0.70474 moveto
0.62285 0.68201 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.56302 0.71835 moveto
0.57184 0.70474 lineto
stroke
0.668 0.526 0.681 setrgbcolor
0.70172 0.56227 moveto
0.78052 0.59104 lineto
0.69877 0.58058 lineto
fill
0.666 0.53 0.688 setrgbcolor
0.70172 0.56227 moveto
0.78879 0.5559 lineto
0.78052 0.59104 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.70172 0.56227 moveto
0.78879 0.5559 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.69877 0.58058 moveto
0.70172 0.56227 lineto
stroke
0.675 0.466 0.594 setrgbcolor
0.67485 0.61567 moveto
0.73309 0.64984 lineto
0.70247 0.6659 lineto
fill
0.643 0.49 0.66 setrgbcolor
0.68954 0.59878 moveto
0.73309 0.64984 lineto
0.67485 0.61567 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.7006 0.63078 moveto
0.73309 0.64984 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67485 0.61567 moveto
0.7006 0.63078 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.67485 0.61567 moveto
0.68954 0.59878 lineto
stroke
0.66 0.517 0.678 setrgbcolor
0.69877 0.58058 moveto
0.76084 0.62396 lineto
0.68954 0.59878 lineto
fill
0.67 0.514 0.664 setrgbcolor
0.69877 0.58058 moveto
0.78052 0.59104 lineto
0.76084 0.62396 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.69877 0.58058 moveto
0.78052 0.59104 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.68954 0.59878 moveto
0.69877 0.58058 lineto
stroke
0.673 0.494 0.635 setrgbcolor
0.68954 0.59878 moveto
0.76084 0.62396 lineto
0.73309 0.64984 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.69349 0.60018 moveto
0.76084 0.62396 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68954 0.59878 moveto
0.69349 0.60018 lineto
stroke
0.639 0.465 0.631 setrgbcolor
0.69444 0.41355 moveto
0.74975 0.44317 lineto
0.7307 0.45476 lineto
fill
0.575 0.503 0.736 setrgbcolor
0.70345 0.39849 moveto
0.74975 0.44317 lineto
0.69444 0.41355 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.74151 0.43876 moveto
0.74975 0.44317 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.69444 0.41355 moveto
0.74151 0.43876 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.69444 0.41355 moveto
0.70345 0.39849 lineto
stroke
0.569 0.309 0.482 setrgbcolor
0.56302 0.71835 moveto
0.64052 0.70756 lineto
0.55767 0.73037 lineto
fill
0.62 0.495 0.688 setrgbcolor
0.56302 0.71835 moveto
0.63584 0.6894 lineto
0.64052 0.70756 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.63432 0.69 moveto
0.63584 0.6894 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61752 0.69668 moveto
0.63432 0.69 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56506 0.71754 moveto
0.61752 0.69668 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56438 0.71781 moveto
0.56506 0.71754 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56302 0.71835 moveto
0.56438 0.71781 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.55767 0.73037 moveto
0.56302 0.71835 lineto
stroke
0.653 0.508 0.673 setrgbcolor
0.70345 0.39849 moveto
0.77185 0.42349 lineto
0.74975 0.44317 lineto
fill
0.612 0.553 0.764 setrgbcolor
0.71111 0.38291 moveto
0.77185 0.42349 lineto
0.70345 0.39849 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.70345 0.39849 moveto
0.77185 0.42349 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.70345 0.39849 moveto
0.71111 0.38291 lineto
stroke
0.617 0.348 0.488 setrgbcolor
0.55767 0.73037 moveto
0.64188 0.7319 lineto
0.55461 0.74161 lineto
fill
0.636 0.481 0.655 setrgbcolor
0.55767 0.73037 moveto
0.64052 0.70756 lineto
0.64188 0.7319 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.56103 0.72945 moveto
0.64052 0.70756 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55767 0.73037 moveto
0.56103 0.72945 lineto
stroke
1 0 0 setrgbcolor
0.78052 0.59104 moveto
0.78879 0.5559 lineto
stroke
1 0 0 setrgbcolor
0.7852 0.52348 moveto
0.78879 0.5559 lineto
stroke
1 0 0 setrgbcolor
0.77222 0.4974 moveto
0.7852 0.52348 lineto
stroke
1 0 0 setrgbcolor
0.76084 0.62396 moveto
0.78052 0.59104 lineto
stroke
1 0 0 setrgbcolor
0.75417 0.47929 moveto
0.77222 0.4974 lineto
stroke
1 0 0 setrgbcolor
0.73599 0.46882 moveto
0.75417 0.47929 lineto
stroke
1 0 0 setrgbcolor
0.73309 0.64984 moveto
0.76084 0.62396 lineto
stroke
0.662 0.541 0.706 setrgbcolor
0.71111 0.38291 moveto
0.79154 0.39589 lineto
0.77185 0.42349 lineto
fill
0.642 0.595 0.785 setrgbcolor
0.7147 0.36704 moveto
0.79154 0.39589 lineto
0.71111 0.38291 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.71111 0.38291 moveto
0.79154 0.39589 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.71111 0.38291 moveto
0.7147 0.36704 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.72212 0.46412 moveto
0.73599 0.46882 lineto
stroke
1 0 0 setrgbcolor
0.71582 0.46229 moveto
0.72212 0.46412 lineto
stroke
0.658 0.389 0.501 setrgbcolor
0.55461 0.74161 moveto
0.6364 0.76023 lineto
0.5515 0.75305 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.55461 0.74161 moveto
0.55767 0.73037 lineto
stroke
0.651 0.469 0.624 setrgbcolor
0.55461 0.74161 moveto
0.64188 0.7319 lineto
0.6364 0.76023 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.55461 0.74161 moveto
0.64188 0.7319 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5515 0.75305 moveto
0.55461 0.74161 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.70247 0.6659 moveto
0.73309 0.64984 lineto
stroke
1 0 0 setrgbcolor
0.71582 0.46229 moveto
0.71872 0.4602 lineto
stroke
1 0 0 setrgbcolor
0.71872 0.4602 moveto
0.7307 0.45476 lineto
stroke
0.669 0.571 0.736 setrgbcolor
0.7147 0.36704 moveto
0.80321 0.3634 lineto
0.79154 0.39589 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.7122 0.3519 moveto
0.80321 0.3634 lineto
0.7147 0.36704 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.7147 0.36704 moveto
0.80321 0.3634 lineto
stroke
1 0 0 setrgbcolor
0.7307 0.45476 moveto
0.74975 0.44317 lineto
stroke
1 0 0 setrgbcolor
0.67423 0.67262 moveto
0.70247 0.6659 lineto
stroke
1 0 0 setrgbcolor
0.74975 0.44317 moveto
0.77185 0.42349 lineto
stroke
1 0 0 setrgbcolor
0.63169 0.67807 moveto
0.63584 0.6894 lineto
stroke
1 0 0 setrgbcolor
0.63152 0.67288 moveto
0.63164 0.6767 lineto
stroke
1 0 0 setrgbcolor
0.63164 0.6767 moveto
0.63169 0.67807 lineto
stroke
1 0 0 setrgbcolor
0.65212 0.67328 moveto
0.67423 0.67262 lineto
stroke
1 0 0 setrgbcolor
0.63533 0.67244 moveto
0.63788 0.67215 lineto
stroke
1 0 0 setrgbcolor
0.63152 0.67288 moveto
0.63533 0.67244 lineto
stroke
1 0 0 setrgbcolor
0.63584 0.6894 moveto
0.64052 0.70756 lineto
stroke
1 0 0 setrgbcolor
0.77185 0.42349 moveto
0.79154 0.39589 lineto
stroke
1 0 0 setrgbcolor
0.63788 0.67215 moveto
0.65212 0.67328 lineto
stroke
0.688 0.429 0.526 setrgbcolor
0.5515 0.75305 moveto
0.62173 0.78888 lineto
0.54549 0.76495 lineto
fill
0.667 0.461 0.596 setrgbcolor
0.5515 0.75305 moveto
0.6364 0.76023 lineto
0.62173 0.78888 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5515 0.75305 moveto
0.6364 0.76023 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.54549 0.76495 moveto
0.5515 0.75305 lineto
stroke
0.674 0.6 0.765 setrgbcolor
0.7122 0.3519 moveto
0.8028 0.33115 lineto
0.80321 0.3634 lineto
fill
0.679 0.631 0.794 setrgbcolor
0.70307 0.33864 moveto
0.8028 0.33115 lineto
0.7122 0.3519 lineto
fill
0 0 0 setrgbcolor
0.7122 0.3519 moveto
0.7147 0.36704 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.64052 0.70756 moveto
0.64188 0.7319 lineto
stroke
1 0 0 setrgbcolor
0.79154 0.39589 moveto
0.80321 0.3634 lineto
stroke
0.679 0.631 0.794 setrgbcolor
0.70307 0.33864 moveto
0.78908 0.30445 lineto
0.8028 0.33115 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.70307 0.33864 moveto
0.7122 0.3519 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.7122 0.3519 moveto
0.8028 0.33115 lineto
stroke
0.678 0.627 0.79 setrgbcolor
0.68843 0.32764 moveto
0.78908 0.30445 lineto
0.70307 0.33864 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.70307 0.33864 moveto
0.78908 0.30445 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.68843 0.32764 moveto
0.70307 0.33864 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.6364 0.76023 moveto
0.64188 0.7319 lineto
stroke
0.681 0.668 0.83 setrgbcolor
0.68843 0.32764 moveto
0.76406 0.28694 lineto
0.78908 0.30445 lineto
fill
0.665 0.621 0.795 setrgbcolor
0.67055 0.31827 moveto
0.76406 0.28694 lineto
0.68843 0.32764 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.69358 0.32487 moveto
0.76406 0.28694 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68843 0.32764 moveto
0.69358 0.32487 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.67055 0.31827 moveto
0.68843 0.32764 lineto
stroke
0.697 0.45 0.546 setrgbcolor
0.54549 0.76495 moveto
0.59768 0.81309 lineto
0.53454 0.77638 lineto
fill
0.684 0.454 0.567 setrgbcolor
0.54549 0.76495 moveto
0.62173 0.78888 lineto
0.59768 0.81309 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.55111 0.76672 moveto
0.62173 0.78888 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54549 0.76495 moveto
0.55111 0.76672 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.53454 0.77638 moveto
0.54549 0.76495 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.8028 0.33115 moveto
0.80321 0.3634 lineto
stroke
0.681 0.723 0.881 setrgbcolor
0.67055 0.31827 moveto
0.73233 0.27962 lineto
0.76406 0.28694 lineto
fill
0.643 0.625 0.816 setrgbcolor
0.65169 0.30937 moveto
0.73233 0.27962 lineto
0.67055 0.31827 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.69694 0.30176 moveto
0.73233 0.27962 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67657 0.3145 moveto
0.69694 0.30176 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67055 0.31827 moveto
0.67657 0.3145 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.65169 0.30937 moveto
0.67055 0.31827 lineto
stroke
0.656 0.824 0.963 setrgbcolor
0.65169 0.30937 moveto
0.6997 0.28102 lineto
0.73233 0.27962 lineto
fill
0.604 0.639 0.858 setrgbcolor
0.63333 0.30029 moveto
0.6997 0.28102 lineto
0.65169 0.30937 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.68002 0.29264 moveto
0.6997 0.28102 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66973 0.29872 moveto
0.68002 0.29264 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65522 0.30729 moveto
0.66973 0.29872 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65169 0.30937 moveto
0.65522 0.30729 lineto
stroke
0.307 0.799 0.81 setrgbcolor
0.63333 0.30029 moveto
0.67149 0.28794 lineto
0.6997 0.28102 lineto
fill
0.213 0.576 0.941 setrgbcolor
0.61623 0.29129 moveto
0.63333 0.30029 lineto
0.65143 0.29643 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.63333 0.30029 moveto
0.65169 0.30937 lineto
stroke
0.419 0.026 0.183 setrgbcolor
0.61623 0.29129 moveto
0.65143 0.29643 lineto
0.67149 0.28794 lineto
fill
0 0.305 0.698 setrgbcolor
0.60119 0.28327 moveto
0.61623 0.29129 lineto
0.64113 0.30267 lineto
fill
0 0 0 setrgbcolor
0.61623 0.29129 moveto
0.63333 0.30029 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.62173 0.78888 moveto
0.6364 0.76023 lineto
stroke
0.689 0.439 0.539 setrgbcolor
0.53454 0.77638 moveto
0.5669 0.82813 lineto
0.51828 0.78586 lineto
fill
0.703 0.443 0.528 setrgbcolor
0.53454 0.77638 moveto
0.59768 0.81309 lineto
0.5669 0.82813 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.53454 0.77638 moveto
0.59768 0.81309 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51828 0.78586 moveto
0.53454 0.77638 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.78908 0.30445 moveto
0.8028 0.33115 lineto
stroke
0.574 0.309 0.475 setrgbcolor
0.60119 0.28327 moveto
0.64113 0.30267 lineto
0.65143 0.29643 lineto
fill
0 0.25 0.638 setrgbcolor
0.58928 0.2769 moveto
0.60119 0.28327 lineto
0.64024 0.30372 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.60119 0.28327 moveto
0.61623 0.29129 lineto
stroke
0 0 0 setrgbcolor
0.58928 0.2769 moveto
0.60119 0.28327 lineto
stroke
0.668 0.39 0.49 setrgbcolor
0.51828 0.78586 moveto
0.53424 0.83127 lineto
0.4978 0.79245 lineto
fill
0.727 0.421 0.46 setrgbcolor
0.51828 0.78586 moveto
0.5669 0.82813 lineto
0.53424 0.83127 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51828 0.78586 moveto
0.52343 0.79034 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52343 0.79034 moveto
0.5669 0.82813 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4978 0.79245 moveto
0.51828 0.78586 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.59768 0.81309 moveto
0.62173 0.78888 lineto
stroke
0.679 0.292 0.307 setrgbcolor
0.58928 0.2769 moveto
0.64024 0.30372 lineto
0.64113 0.30267 lineto
fill
0 0.3 0.708 setrgbcolor
0.5814 0.27203 moveto
0.64024 0.30372 lineto
0.58928 0.2769 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.63023 0.29845 moveto
0.64024 0.30372 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59408 0.27942 moveto
0.63023 0.29845 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58928 0.2769 moveto
0.59408 0.27942 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5814 0.27203 moveto
0.58928 0.2769 lineto
stroke
0.62 0.271 0.357 setrgbcolor
0.4978 0.79245 moveto
0.50482 0.82335 lineto
0.47474 0.79641 lineto
fill
0.756 0.362 0.305 setrgbcolor
0.4978 0.79245 moveto
0.53424 0.83127 lineto
0.50482 0.82335 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4978 0.79245 moveto
0.49911 0.79385 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49911 0.79385 moveto
0.53424 0.83127 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47474 0.79641 moveto
0.4978 0.79245 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.76406 0.28694 moveto
0.78908 0.30445 lineto
stroke
0.624 0.269 0.348 setrgbcolor
0.47474 0.79641 moveto
0.50482 0.82335 lineto
0.45049 0.79895 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.47474 0.79641 moveto
0.50482 0.82335 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.46945 0.79696 moveto
0.47474 0.79641 lineto
stroke
0.25 0.759 0.86 setrgbcolor
0.45049 0.79895 moveto
0.46601 0.79368 lineto
0.42605 0.80137 lineto
fill
0.175 0.43 0.864 setrgbcolor
0.45049 0.79895 moveto
0.48191 0.80882 lineto
0.46601 0.79368 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.45049 0.79895 moveto
0.48191 0.80882 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.42605 0.80137 moveto
0.45049 0.79895 lineto
stroke
0.592 0.869 0.993 setrgbcolor
0.42605 0.80137 moveto
0.45581 0.7828 lineto
0.40246 0.80406 lineto
fill
0.468 0.5 0.808 setrgbcolor
0.42605 0.80137 moveto
0.46601 0.79368 lineto
0.45581 0.7828 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.46363 0.79414 moveto
0.46601 0.79368 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4416 0.79837 moveto
0.46363 0.79414 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42605 0.80137 moveto
0.4416 0.79837 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.40246 0.80406 moveto
0.42605 0.80137 lineto
stroke
0.652 0.868 0.98 setrgbcolor
0.40246 0.80406 moveto
0.44952 0.77866 lineto
0.38122 0.80631 lineto
fill
0.572 0.541 0.782 setrgbcolor
0.40246 0.80406 moveto
0.45581 0.7828 lineto
0.44952 0.77866 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4538 0.7836 moveto
0.45581 0.7828 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4044 0.80328 moveto
0.42797 0.79389 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44254 0.78808 moveto
0.4538 0.7836 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40246 0.80406 moveto
0.4044 0.80328 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.38122 0.80631 moveto
0.40246 0.80406 lineto
stroke
0.603 0.522 0.736 setrgbcolor
0.5814 0.27203 moveto
0.64673 0.29771 lineto
0.64024 0.30372 lineto
fill
0.098 0.531 0.909 setrgbcolor
0.57737 0.26783 moveto
0.64673 0.29771 lineto
0.5814 0.27203 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.64067 0.29533 moveto
0.64673 0.29771 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58336 0.2728 moveto
0.64067 0.29533 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5814 0.27203 moveto
0.58336 0.2728 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.57737 0.26783 moveto
0.5814 0.27203 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.73233 0.27962 moveto
0.76406 0.28694 lineto
stroke
1 0 0 setrgbcolor
0.5669 0.82813 moveto
0.59768 0.81309 lineto
stroke
0.362 0.023 0.249 setrgbcolor
0.38122 0.80631 moveto
0.44952 0.77866 lineto
0.44533 0.78174 lineto
fill
0.647 0.878 0.983 setrgbcolor
0.38122 0.80631 moveto
0.36403 0.80705 lineto
0.44952 0.77866 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.38122 0.80631 moveto
0.38469 0.8049 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38469 0.8049 moveto
0.38875 0.80326 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38875 0.80326 moveto
0.39527 0.80062 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43593 0.78416 moveto
0.44952 0.77866 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.36403 0.80705 moveto
0.38122 0.80631 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.6997 0.28102 moveto
0.73233 0.27962 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.38605 0.80019 moveto
0.38969 0.79906 lineto
stroke
0.512 0.857 0.993 setrgbcolor
0.3521 0.80575 moveto
0.44119 0.79117 lineto
0.36403 0.80705 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.3521 0.80575 moveto
0.36403 0.80705 lineto
stroke
0.636 0.565 0.758 setrgbcolor
0.57737 0.26783 moveto
0.65694 0.28402 lineto
0.64673 0.29771 lineto
fill
0.349 0.688 0.98 setrgbcolor
0.57536 0.26352 moveto
0.65694 0.28402 lineto
0.57737 0.26783 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.64182 0.28094 moveto
0.65694 0.28402 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57737 0.26783 moveto
0.64182 0.28094 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.57536 0.26352 moveto
0.57737 0.26783 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.67149 0.28794 moveto
0.6997 0.28102 lineto
stroke
1 0 0 setrgbcolor
0.53424 0.83127 moveto
0.5669 0.82813 lineto
stroke
1 0 0 setrgbcolor
0.65143 0.29643 moveto
0.67149 0.28794 lineto
stroke
1 0 0 setrgbcolor
0.64183 0.30224 moveto
0.64698 0.29912 lineto
stroke
1 0 0 setrgbcolor
0.64698 0.29912 moveto
0.65143 0.29643 lineto
stroke
0.368 0.772 0.983 setrgbcolor
0.34537 0.80285 moveto
0.43492 0.80489 lineto
0.3521 0.80575 lineto
fill
0.623 0.404 0.563 setrgbcolor
0.3521 0.80575 moveto
0.44533 0.78174 lineto
0.44119 0.79117 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.34537 0.80285 moveto
0.3521 0.80575 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.64024 0.30372 moveto
0.64673 0.29771 lineto
stroke
0.657 0.61 0.79 setrgbcolor
0.57536 0.26352 moveto
0.66573 0.26386 lineto
0.65694 0.28402 lineto
fill
0.479 0.788 0.998 setrgbcolor
0.5724 0.25929 moveto
0.66573 0.26386 lineto
0.57536 0.26352 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.57536 0.26352 moveto
0.66573 0.26386 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5724 0.25929 moveto
0.57536 0.26352 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.64673 0.29771 moveto
0.65694 0.28402 lineto
stroke
1 0 0 setrgbcolor
0.50482 0.82335 moveto
0.53424 0.83127 lineto
stroke
1 0 0 setrgbcolor
0.65694 0.28402 moveto
0.66573 0.26386 lineto
stroke
0.22 0.642 0.954 setrgbcolor
0.34222 0.79931 moveto
0.42466 0.81971 lineto
0.34537 0.80285 lineto
fill
0.65 0.402 0.531 setrgbcolor
0.34537 0.80285 moveto
0.44119 0.79117 lineto
0.43492 0.80489 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.34222 0.79931 moveto
0.34537 0.80285 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.44533 0.78174 moveto
0.44952 0.77866 lineto
stroke
1 0 0 setrgbcolor
0.44952 0.77866 moveto
0.45581 0.7828 lineto
stroke
1 0 0 setrgbcolor
0.48191 0.80882 moveto
0.50482 0.82335 lineto
stroke
1 0 0 setrgbcolor
0.44119 0.79117 moveto
0.44411 0.78452 lineto
stroke
1 0 0 setrgbcolor
0.44411 0.78452 moveto
0.44533 0.78174 lineto
stroke
0.676 0.658 0.824 setrgbcolor
0.5724 0.25929 moveto
0.66751 0.24094 lineto
0.66573 0.26386 lineto
fill
0.571 0.864 0.995 setrgbcolor
0.56558 0.25634 moveto
0.66751 0.24094 lineto
0.5724 0.25929 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5724 0.25929 moveto
0.66751 0.24094 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.56558 0.25634 moveto
0.5724 0.25929 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.45581 0.7828 moveto
0.46601 0.79368 lineto
stroke
1 0 0 setrgbcolor
0.46601 0.79368 moveto
0.48191 0.80882 lineto
stroke
1 0 0 setrgbcolor
0.43492 0.80489 moveto
0.44119 0.79117 lineto
stroke
1 0 0 setrgbcolor
0.66573 0.26386 moveto
0.66751 0.24094 lineto
stroke
0 0.444 0.861 setrgbcolor
0.33987 0.79571 moveto
0.40927 0.83155 lineto
0.34222 0.79931 lineto
fill
0.678 0.393 0.482 setrgbcolor
0.34222 0.79931 moveto
0.43492 0.80489 lineto
0.42466 0.81971 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.33987 0.79571 moveto
0.34222 0.79931 lineto
stroke
0.64 0.726 0.91 setrgbcolor
0.28273 0.77937 moveto
0.37447 0.77108 lineto
0.29323 0.78766 lineto
fill
0 0 0 setrgbcolor
0.28273 0.77937 moveto
0.29323 0.78766 lineto
stroke
0.696 0.713 0.861 setrgbcolor
0.56558 0.25634 moveto
0.65805 0.22115 lineto
0.66751 0.24094 lineto
fill
0.657 0.905 0.98 setrgbcolor
0.55317 0.25616 moveto
0.65805 0.22115 lineto
0.56558 0.25634 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.58734 0.24806 moveto
0.65805 0.22115 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56558 0.25634 moveto
0.58734 0.24806 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.55317 0.25616 moveto
0.56558 0.25634 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.42466 0.81971 moveto
0.43492 0.80489 lineto
stroke
1 0 0 setrgbcolor
0.65805 0.22115 moveto
0.66751 0.24094 lineto
stroke
0.605 0.316 0.451 setrgbcolor
0.28273 0.77937 moveto
0.37997 0.76532 lineto
0.37447 0.77108 lineto
fill
0.584 0.684 0.91 setrgbcolor
0.27819 0.76963 moveto
0.34115 0.77676 lineto
0.28273 0.77937 lineto
fill
0.584 0.684 0.91 setrgbcolor
0.28273 0.77937 moveto
0.34115 0.77676 lineto
0.35169 0.77962 lineto
fill
0.647 0.329 0.418 setrgbcolor
0.27819 0.76963 moveto
0.37447 0.77108 lineto
0.36685 0.77968 lineto
fill
0.513 0.608 0.884 setrgbcolor
0.2781 0.75942 moveto
0.32587 0.77651 lineto
0.27819 0.76963 lineto
fill
0.513 0.608 0.884 setrgbcolor
0.35623 0.78738 moveto
0.33678 0.78295 lineto
0.32587 0.77651 lineto
fill
0.513 0.608 0.884 setrgbcolor
0.27819 0.76963 moveto
0.32587 0.77651 lineto
0.33678 0.78295 lineto
fill
0.63 0.122 0.021 setrgbcolor
0.34244 0.78994 moveto
0.27938 0.76002 lineto
0.35623 0.78738 lineto
fill
0.584 0.684 0.91 setrgbcolor
0.36685 0.77968 moveto
0.35169 0.77962 lineto
0.34115 0.77676 lineto
fill
0.689 0.311 0.327 setrgbcolor
0.2781 0.75942 moveto
0.36685 0.77968 lineto
0.35623 0.78738 lineto
fill
0.735 0.218 0 setrgbcolor
0.31592 0.77647 moveto
0.32751 0.78551 lineto
0.36581 0.82939 lineto
fill
0.675 0.155 0 setrgbcolor
0.31592 0.77647 moveto
0.36581 0.82939 lineto
0.34381 0.81005 lineto
fill
0 0.216 0.735 setrgbcolor
0.34381 0.81005 moveto
0.33075 0.78653 lineto
0.30181 0.76445 lineto
fill
0.58 0.006 0 setrgbcolor
0.34244 0.78994 moveto
0.3272 0.78366 lineto
0.30473 0.76547 lineto
fill
0 0.216 0.735 setrgbcolor
0.32724 0.7802 moveto
0.30889 0.76884 lineto
0.33075 0.78653 lineto
fill
0 0.216 0.735 setrgbcolor
0.30181 0.76445 moveto
0.33075 0.78653 lineto
0.30889 0.76884 lineto
fill
0.52 0.606 0.878 setrgbcolor
0.2781 0.75942 moveto
0.27972 0.7492 lineto
0.35623 0.78738 lineto
fill
0.58 0.006 0 setrgbcolor
0.28021 0.74956 moveto
0.30473 0.76547 lineto
0.32641 0.78333 lineto
fill
0.58 0.006 0 setrgbcolor
0.32641 0.78333 moveto
0.30473 0.76547 lineto
0.3272 0.78366 lineto
fill
0.63 0.122 0.021 setrgbcolor
0.35623 0.78738 moveto
0.27938 0.76002 lineto
0.28109 0.76049 lineto
fill
0.408 0.504 0.845 setrgbcolor
0.34244 0.78994 moveto
0.30108 0.76307 lineto
0.28024 0.73838 lineto
fill
0 0.214 0.709 setrgbcolor
0.2964 0.75962 moveto
0.29921 0.76149 lineto
0.2864 0.7507 lineto
fill
0.408 0.504 0.845 setrgbcolor
0.27972 0.7492 moveto
0.27991 0.74523 lineto
0.30108 0.76307 lineto
fill
0.408 0.504 0.845 setrgbcolor
0.28024 0.73838 moveto
0.30108 0.76307 lineto
0.27991 0.74523 lineto
fill
0 0.214 0.709 setrgbcolor
0.28623 0.75054 moveto
0.2864 0.7507 lineto
0.32724 0.7802 lineto
fill
0 0.214 0.709 setrgbcolor
0.32724 0.7802 moveto
0.2864 0.7507 lineto
0.29921 0.76149 lineto
fill
0 0.214 0.709 setrgbcolor
0.30181 0.76445 moveto
0.30889 0.76884 lineto
0.2964 0.75962 lineto
fill
0.58 0.006 0 setrgbcolor
0.34244 0.78994 moveto
0.30138 0.76329 lineto
0.30108 0.76307 lineto
fill
0 0.214 0.709 setrgbcolor
0.32724 0.7802 moveto
0.2964 0.75962 lineto
0.30889 0.76884 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.27819 0.76963 moveto
0.28273 0.77937 lineto
stroke
0 0.113 0.595 setrgbcolor
0.33551 0.79155 moveto
0.38896 0.83604 lineto
0.33987 0.79571 lineto
fill
0.714 0.384 0.418 setrgbcolor
0.33987 0.79571 moveto
0.42466 0.81971 lineto
0.40927 0.83155 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.34153 0.79657 moveto
0.34685 0.79932 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.33968 0.79552 moveto
0.33987 0.79571 lineto
stroke
0.715 0.782 0.904 setrgbcolor
0.55317 0.25616 moveto
0.63599 0.2105 lineto
0.65805 0.22115 lineto
fill
0.717 0.904 0.961 setrgbcolor
0.53503 0.25943 moveto
0.63599 0.2105 lineto
0.55317 0.25616 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.57059 0.24656 moveto
0.63599 0.2105 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55317 0.25616 moveto
0.57059 0.24656 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.53503 0.25943 moveto
0.55317 0.25616 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.40927 0.83155 moveto
0.42466 0.81971 lineto
stroke
0.727 0.87 0.948 setrgbcolor
0.53503 0.25943 moveto
0.60335 0.21272 lineto
0.63599 0.2105 lineto
fill
0.729 0.888 0.953 setrgbcolor
0.51234 0.26554 moveto
0.60335 0.21272 lineto
0.53503 0.25943 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.53503 0.25943 moveto
0.5401 0.25597 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5401 0.25597 moveto
0.60335 0.21272 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51234 0.26554 moveto
0.53503 0.25943 lineto
stroke
0 0 0 setrgbcolor
0.2781 0.75942 moveto
0.27819 0.76963 lineto
stroke
0.51 0 0 setrgbcolor
0.32751 0.78551 moveto
0.33551 0.79155 lineto
0.38896 0.83604 lineto
fill
0.757 0.374 0.328 setrgbcolor
0.33551 0.79155 moveto
0.40927 0.83155 lineto
0.38896 0.83604 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.33925 0.79467 moveto
0.38896 0.83604 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33551 0.79155 moveto
0.33925 0.79467 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.33212 0.789 moveto
0.33551 0.79155 lineto
stroke
0.677 0.96 0.941 setrgbcolor
0.51234 0.26554 moveto
0.56478 0.22764 lineto
0.60335 0.21272 lineto
fill
0.696 0.899 0.969 setrgbcolor
0.48692 0.27297 moveto
0.51234 0.26554 lineto
0.56478 0.22764 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51234 0.26554 moveto
0.53386 0.24999 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.53386 0.24999 moveto
0.56478 0.22764 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.48692 0.27297 moveto
0.51234 0.26554 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.37447 0.77108 moveto
0.37997 0.76532 lineto
stroke
1 0 0 setrgbcolor
0.63599 0.2105 moveto
0.65805 0.22115 lineto
stroke
0.267 0 0.207 setrgbcolor
0.4604 0.2805 moveto
0.49263 0.27924 lineto
0.52611 0.25163 lineto
fill
0.132 0 0 setrgbcolor
0.434 0.28811 moveto
0.49263 0.27924 lineto
0.4604 0.2805 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4604 0.2805 moveto
0.49263 0.27924 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.434 0.28811 moveto
0.4604 0.2805 lineto
stroke
0.46 0.245 0.499 setrgbcolor
0.434 0.28811 moveto
0.46777 0.30524 lineto
0.49263 0.27924 lineto
fill
0.522 0.158 0.29 setrgbcolor
0.40891 0.29684 moveto
0.46777 0.30524 lineto
0.434 0.28811 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43534 0.28879 moveto
0.46777 0.30524 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.434 0.28811 moveto
0.43534 0.28879 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.40891 0.29684 moveto
0.434 0.28811 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.36685 0.77968 moveto
0.37447 0.77108 lineto
stroke
0.537 0.39 0.628 setrgbcolor
0.40891 0.29684 moveto
0.45253 0.32576 lineto
0.46777 0.30524 lineto
fill
0.62 0.345 0.479 setrgbcolor
0.38674 0.3077 moveto
0.45253 0.32576 lineto
0.40891 0.29684 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40992 0.29751 moveto
0.44209 0.31884 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40891 0.29684 moveto
0.40992 0.29751 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44975 0.32392 moveto
0.45253 0.32576 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44209 0.31884 moveto
0.44975 0.32392 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.38674 0.3077 moveto
0.40891 0.29684 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.32653 0.77675 moveto
0.35623 0.78738 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28109 0.76049 moveto
0.30124 0.7677 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30124 0.7677 moveto
0.30655 0.7696 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2781 0.75942 moveto
0.27922 0.75982 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27922 0.75982 moveto
0.28109 0.76049 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.2781 0.75942 moveto
0.27972 0.7492 lineto
stroke
0.793 0.337 0.158 setrgbcolor
0.32751 0.78551 moveto
0.38896 0.83604 lineto
0.36581 0.82939 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.33486 0.79394 moveto
0.36581 0.82939 lineto
stroke
1 0 0 setrgbcolor
0.38896 0.83604 moveto
0.40927 0.83155 lineto
stroke
0.583 0.477 0.698 setrgbcolor
0.38674 0.3077 moveto
0.44577 0.33883 lineto
0.45253 0.32576 lineto
fill
0.656 0.414 0.541 setrgbcolor
0.36928 0.32075 moveto
0.44577 0.33883 lineto
0.38674 0.3077 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.38674 0.3077 moveto
0.43679 0.3341 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43783 0.33465 moveto
0.43809 0.33478 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43809 0.33478 moveto
0.44411 0.33796 lineto
stroke
1 0 0 setrgbcolor
0.35623 0.78738 moveto
0.36685 0.77968 lineto
stroke
0.633 0.515 0.701 setrgbcolor
0.36928 0.32075 moveto
0.445 0.34425 lineto
0.44577 0.33883 lineto
fill
0.653 0.409 0.538 setrgbcolor
0.35763 0.33498 moveto
0.36928 0.32075 lineto
0.44696 0.3432 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.36928 0.32075 moveto
0.38674 0.3077 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.60335 0.21272 moveto
0.63599 0.2105 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29996 0.76235 moveto
0.30108 0.76307 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3272 0.78004 moveto
0.34244 0.78994 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29598 0.75976 moveto
0.29996 0.76235 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28089 0.74996 moveto
0.28408 0.75204 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28408 0.75204 moveto
0.29598 0.75976 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27972 0.7492 moveto
0.28089 0.74996 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.27972 0.7492 moveto
0.2798 0.7476 lineto
stroke
0 0 0 setrgbcolor
0.2798 0.7476 moveto
0.27992 0.74503 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.32545 0.77909 moveto
0.32724 0.7802 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30889 0.76884 moveto
0.31613 0.77332 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.32003 0.77574 moveto
0.32545 0.77909 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.28623 0.75054 moveto
0.2864 0.7507 lineto
stroke
0.641 0.874 0.984 setrgbcolor
0.44778 0.33808 moveto
0.44175 0.33956 lineto
0.44329 0.33296 lineto
fill
0.407 0.743 0.993 setrgbcolor
0.35763 0.33498 moveto
0.44445 0.34297 lineto
0.445 0.34425 lineto
fill
0.605 0.792 0.97 setrgbcolor
0.3512 0.34907 moveto
0.44778 0.33808 lineto
0.44696 0.3432 lineto
fill
0.641 0.874 0.984 setrgbcolor
0.34771 0.36253 moveto
0.43786 0.33464 lineto
0.44175 0.33956 lineto
fill
0.641 0.874 0.984 setrgbcolor
0.44329 0.33296 moveto
0.44175 0.33956 lineto
0.43786 0.33464 lineto
fill
0.407 0.743 0.993 setrgbcolor
0.44696 0.3432 moveto
0.44533 0.34408 lineto
0.44445 0.34297 lineto
fill
0.615 0.359 0.507 setrgbcolor
0.3512 0.34907 moveto
0.35763 0.33498 lineto
0.44778 0.33808 lineto
fill
0 0 0 setrgbcolor
0.35763 0.33498 moveto
0.36928 0.32075 lineto
stroke
0.604 0.575 0.794 setrgbcolor
0.23682 0.70711 moveto
0.25284 0.72181 lineto
0.31652 0.68985 lineto
fill
0.529 0.562 0.833 setrgbcolor
0.26973 0.73612 moveto
0.27922 0.73155 lineto
0.25284 0.72181 lineto
fill
0.529 0.562 0.833 setrgbcolor
0.31597 0.71386 moveto
0.27483 0.71904 lineto
0.27922 0.73155 lineto
fill
0.529 0.562 0.833 setrgbcolor
0.25284 0.72181 moveto
0.27922 0.73155 lineto
0.27483 0.71904 lineto
fill
0.504 0.349 0.603 setrgbcolor
0.31652 0.68985 moveto
0.27006 0.71316 lineto
0.31597 0.71386 lineto
fill
0.641 0.585 0.776 setrgbcolor
0.22397 0.69105 moveto
0.23682 0.70711 lineto
0.31667 0.67522 lineto
fill
0.547 0.347 0.561 setrgbcolor
0.23682 0.70711 moveto
0.31652 0.68985 lineto
0.31667 0.67522 lineto
fill
0.443 0.352 0.657 setrgbcolor
0.31597 0.71386 moveto
0.27781 0.73223 lineto
0.31836 0.74573 lineto
fill
0.214 0.35 0.786 setrgbcolor
0.28024 0.73838 moveto
0.29234 0.74277 lineto
0.27933 0.73334 lineto
fill
0.443 0.352 0.657 setrgbcolor
0.26973 0.73612 moveto
0.2882 0.73977 lineto
0.27781 0.73223 lineto
fill
0.443 0.352 0.657 setrgbcolor
0.31836 0.74573 moveto
0.27781 0.73223 lineto
0.2882 0.73977 lineto
fill
0.328 0.51 0.883 setrgbcolor
0.2882 0.73977 moveto
0.28749 0.74366 lineto
0.31836 0.74573 lineto
fill
0 0.113 0.662 setrgbcolor
0.29791 0.73433 moveto
0.28196 0.71904 lineto
0.3104 0.76479 lineto
fill
0.504 0.349 0.603 setrgbcolor
0.31597 0.71386 moveto
0.27006 0.71316 lineto
0.2746 0.71907 lineto
fill
0 0.113 0.662 setrgbcolor
0.2727 0.71016 moveto
0.28347 0.72577 lineto
0.28196 0.71904 lineto
fill
0.328 0.51 0.883 setrgbcolor
0.31836 0.74573 moveto
0.28749 0.74366 lineto
0.28894 0.75014 lineto
fill
0 0.113 0.662 setrgbcolor
0.3104 0.76479 moveto
0.28196 0.71904 lineto
0.28347 0.72577 lineto
fill
0.328 0.51 0.883 setrgbcolor
0.28623 0.75054 moveto
0.28894 0.75014 lineto
0.28749 0.74366 lineto
fill
0.214 0.35 0.786 setrgbcolor
0.28024 0.73838 moveto
0.28559 0.74358 lineto
0.28738 0.74097 lineto
fill
0.328 0.51 0.883 setrgbcolor
0.26973 0.73612 moveto
0.28285 0.74759 lineto
0.2882 0.73977 lineto
fill
0.328 0.51 0.883 setrgbcolor
0.28623 0.75054 moveto
0.2882 0.73977 lineto
0.28285 0.74759 lineto
fill
0.317 0.335 0.72 setrgbcolor
0.28623 0.75054 moveto
0.3141 0.7707 lineto
0.31836 0.74573 lineto
fill
0.317 0.335 0.72 setrgbcolor
0.32724 0.7802 moveto
0.32663 0.77781 lineto
0.3141 0.7707 lineto
fill
0.317 0.335 0.72 setrgbcolor
0.31836 0.74573 moveto
0.3141 0.7707 lineto
0.32663 0.77781 lineto
fill
0.214 0.35 0.786 setrgbcolor
0.28738 0.74097 moveto
0.31551 0.7715 lineto
0.29234 0.74277 lineto
fill
0.214 0.35 0.786 setrgbcolor
0.32641 0.78333 moveto
0.31735 0.77254 lineto
0.31551 0.7715 lineto
fill
0.214 0.35 0.786 setrgbcolor
0.29234 0.74277 moveto
0.31551 0.7715 lineto
0.31735 0.77254 lineto
fill
0.214 0.35 0.786 setrgbcolor
0.32641 0.78333 moveto
0.28738 0.74097 lineto
0.28559 0.74358 lineto
fill
0.214 0.35 0.786 setrgbcolor
0.27795 0.72565 moveto
0.27933 0.73334 lineto
0.29234 0.74277 lineto
fill
0 0.12 0.663 setrgbcolor
0.29791 0.73433 moveto
0.26558 0.69268 lineto
0.2727 0.71016 lineto
fill
0 0.12 0.663 setrgbcolor
0.2727 0.71016 moveto
0.26558 0.69268 lineto
0.26649 0.69526 lineto
fill
0 0.157 0.686 setrgbcolor
0.2727 0.71016 moveto
0.2766 0.72166 lineto
0.3104 0.76479 lineto
fill
0 0.157 0.686 setrgbcolor
0.27795 0.72565 moveto
0.30221 0.75491 lineto
0.2766 0.72166 lineto
fill
0 0.157 0.686 setrgbcolor
0.3104 0.76479 moveto
0.2766 0.72166 lineto
0.30221 0.75491 lineto
fill
0.504 0.349 0.603 setrgbcolor
0.25284 0.72181 moveto
0.2746 0.71907 lineto
0.27006 0.71316 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.25284 0.72181 moveto
0.27006 0.71316 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27006 0.71316 moveto
0.27045 0.71297 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27045 0.71297 moveto
0.27081 0.71278 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27081 0.71278 moveto
0.27318 0.7116 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.293 0.70165 moveto
0.31652 0.68985 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.23682 0.70711 moveto
0.25284 0.72181 lineto
stroke
0 0 0 setrgbcolor
0.25284 0.72181 moveto
0.26973 0.73612 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.23682 0.70711 moveto
0.26252 0.69684 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.26252 0.69684 moveto
0.26649 0.69526 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.26732 0.69493 moveto
0.30535 0.67974 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30535 0.67974 moveto
0.31667 0.67522 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.22397 0.69105 moveto
0.23682 0.70711 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.28623 0.75054 moveto
0.28894 0.75014 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28894 0.75014 moveto
0.29187 0.7497 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3035 0.74796 moveto
0.31836 0.74573 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.27461 0.74039 moveto
0.28285 0.74759 lineto
stroke
0 0 0 setrgbcolor
0.28285 0.74759 moveto
0.28479 0.74928 lineto
stroke
0 0 0 setrgbcolor
0.28479 0.74928 moveto
0.28623 0.75054 lineto
stroke
0 0 0 setrgbcolor
0.26973 0.73612 moveto
0.27461 0.74039 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.26973 0.73612 moveto
0.27781 0.73223 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27781 0.73223 moveto
0.27891 0.7317 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27891 0.7317 moveto
0.27903 0.73165 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29626 0.72335 moveto
0.31597 0.71386 lineto
stroke
0.658 0.594 0.772 setrgbcolor
0.21668 0.6732 moveto
0.22397 0.69105 lineto
0.31483 0.66852 lineto
fill
0.591 0.367 0.545 setrgbcolor
0.22397 0.69105 moveto
0.31667 0.67522 lineto
0.31483 0.66852 lineto
fill
1 0 0 setrgbcolor
0.34244 0.78994 moveto
0.35623 0.78738 lineto
stroke
1 0 0 setrgbcolor
0.36581 0.82939 moveto
0.38896 0.83604 lineto
stroke
0.658 0.594 0.772 setrgbcolor
0.21668 0.6732 moveto
0.31483 0.66852 lineto
0.31084 0.66691 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.21668 0.6732 moveto
0.31084 0.66691 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.21668 0.6732 moveto
0.22397 0.69105 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.30527 0.67089 moveto
0.31483 0.66852 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.22397 0.69105 moveto
0.30527 0.67089 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31135 0.76866 moveto
0.31251 0.76979 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31251 0.76979 moveto
0.32641 0.78333 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28559 0.74358 moveto
0.28984 0.74772 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28984 0.74772 moveto
0.31135 0.76866 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.27795 0.72565 moveto
0.27933 0.73334 lineto
stroke
0.553 0.293 0.474 setrgbcolor
0.34771 0.36253 moveto
0.3512 0.34907 lineto
0.44329 0.33296 lineto
fill
0 0 0 setrgbcolor
0.3512 0.34907 moveto
0.35763 0.33498 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.56478 0.22764 moveto
0.60335 0.21272 lineto
stroke
1 0 0 setrgbcolor
0.445 0.34425 moveto
0.44696 0.3432 lineto
stroke
1 0 0 setrgbcolor
0.44676 0.33692 moveto
0.45253 0.32576 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30864 0.76267 moveto
0.3104 0.76479 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28386 0.73278 moveto
0.30864 0.76267 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.27795 0.72565 moveto
0.28037 0.72857 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28037 0.72857 moveto
0.28386 0.73278 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.2727 0.71016 moveto
0.2766 0.72166 lineto
stroke
0 0 0 setrgbcolor
0.2766 0.72166 moveto
0.27795 0.72565 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.45253 0.32576 moveto
0.46777 0.30524 lineto
stroke
0.47 0.214 0.444 setrgbcolor
0.34415 0.37625 moveto
0.34771 0.36253 lineto
0.43044 0.33348 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.34771 0.36253 moveto
0.3512 0.34907 lineto
stroke
0 0 0 setrgbcolor
0.34415 0.37625 moveto
0.34771 0.36253 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.44696 0.3432 moveto
0.44778 0.33808 lineto
stroke
0.651 0.542 0.717 setrgbcolor
0.21578 0.57635 moveto
0.21756 0.59764 lineto
0.31226 0.57953 lineto
fill
0.547 0.232 0.385 setrgbcolor
0.21756 0.59764 moveto
0.31184 0.58566 lineto
0.31226 0.57953 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.21756 0.59764 moveto
0.30764 0.58042 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30764 0.58042 moveto
0.31226 0.57953 lineto
stroke
0.631 0.526 0.716 setrgbcolor
0.21756 0.59764 moveto
0.22491 0.61741 lineto
0.31184 0.58566 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.21578 0.57635 moveto
0.21756 0.59764 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.52611 0.25163 moveto
0.56478 0.22764 lineto
stroke
0.644 0.534 0.714 setrgbcolor
0.21578 0.57635 moveto
0.3056 0.5738 lineto
0.22097 0.55434 lineto
fill
0.589 0.732 0.942 setrgbcolor
0.21578 0.57635 moveto
0.30967 0.57683 lineto
0.3056 0.5738 lineto
fill
0.644 0.412 0.552 setrgbcolor
0.21578 0.57635 moveto
0.31226 0.57953 lineto
0.30967 0.57683 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.21578 0.57635 moveto
0.30967 0.57683 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.21578 0.57635 moveto
0.22097 0.55434 lineto
stroke
0.499 0.225 0.429 setrgbcolor
0.22491 0.61741 moveto
0.30755 0.59899 lineto
0.31184 0.58566 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.22491 0.61741 moveto
0.29618 0.59138 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29618 0.59138 moveto
0.31184 0.58566 lineto
stroke
0.594 0.506 0.724 setrgbcolor
0.22491 0.61741 moveto
0.23523 0.63593 lineto
0.30755 0.59899 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.21756 0.59764 moveto
0.22491 0.61741 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.32641 0.78333 moveto
0.3272 0.78366 lineto
stroke
1 0 0 setrgbcolor
0.32974 0.7847 moveto
0.34244 0.78994 lineto
stroke
1 0 0 setrgbcolor
0.46777 0.30524 moveto
0.49263 0.27924 lineto
stroke
0.617 0.498 0.695 setrgbcolor
0.22097 0.55434 moveto
0.30183 0.56675 lineto
0.23265 0.53289 lineto
fill
0.491 0.665 0.939 setrgbcolor
0.22097 0.55434 moveto
0.3056 0.5738 lineto
0.30183 0.56675 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.22097 0.55434 moveto
0.29187 0.57065 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29187 0.57065 moveto
0.3056 0.5738 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.22097 0.55434 moveto
0.23265 0.53289 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.34381 0.81005 moveto
0.36581 0.82939 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2727 0.71016 moveto
0.29791 0.73433 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.26522 0.69221 moveto
0.2727 0.71016 lineto
stroke
0.463 0.243 0.494 setrgbcolor
0.23523 0.63593 moveto
0.30039 0.62243 lineto
0.30755 0.59899 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.23523 0.63593 moveto
0.28373 0.61116 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28373 0.61116 moveto
0.30755 0.59899 lineto
stroke
0.53 0.478 0.742 setrgbcolor
0.23523 0.63593 moveto
0.24612 0.65426 lineto
0.30039 0.62243 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.22491 0.61741 moveto
0.23523 0.63593 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.31084 0.66691 moveto
0.31483 0.66852 lineto
stroke
1 0 0 setrgbcolor
0.31483 0.66852 moveto
0.31667 0.67522 lineto
stroke
1 0 0 setrgbcolor
0.49263 0.27924 moveto
0.52611 0.25163 lineto
stroke
0.575 0.434 0.653 setrgbcolor
0.23265 0.53289 moveto
0.30049 0.55225 lineto
0.24885 0.5127 lineto
fill
0.466 0.551 0.859 setrgbcolor
0.23265 0.53289 moveto
0.30183 0.56675 lineto
0.30049 0.55225 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.23265 0.53289 moveto
0.23485 0.53396 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.23485 0.53396 moveto
0.28352 0.55778 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28352 0.55778 moveto
0.30183 0.56675 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.23265 0.53289 moveto
0.24885 0.5127 lineto
stroke
0.418 0.26 0.558 setrgbcolor
0.24612 0.65426 moveto
0.2938 0.65607 lineto
0.30039 0.62243 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.24612 0.65426 moveto
0.30039 0.62243 lineto
stroke
0.407 0.423 0.763 setrgbcolor
0.24612 0.65426 moveto
0.25625 0.67314 lineto
0.2938 0.65607 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.23523 0.63593 moveto
0.24612 0.65426 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.44329 0.33296 moveto
0.44778 0.33808 lineto
stroke
0.164 0.29 0.748 setrgbcolor
0.25625 0.67314 moveto
0.26522 0.69221 lineto
0.29211 0.69577 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.24612 0.65426 moveto
0.25625 0.67314 lineto
stroke
0.185 0.227 0.672 setrgbcolor
0.26522 0.69221 moveto
0.29791 0.73433 lineto
0.29211 0.69577 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.26522 0.69221 moveto
0.29211 0.69577 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.25625 0.67314 moveto
0.26522 0.69221 lineto
stroke
0.631 0.946 0.948 setrgbcolor
0.34415 0.37625 moveto
0.43044 0.33348 lineto
0.44329 0.33296 lineto
fill
0.481 0.233 0.461 setrgbcolor
0.33825 0.3918 moveto
0.34415 0.37625 lineto
0.43044 0.33348 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.34415 0.37625 moveto
0.36681 0.36502 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.36681 0.36502 moveto
0.40115 0.348 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40115 0.348 moveto
0.43044 0.33348 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.33825 0.3918 moveto
0.34415 0.37625 lineto
stroke
0.341 0.262 0.62 setrgbcolor
0.25625 0.67314 moveto
0.29211 0.69577 lineto
0.2938 0.65607 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.25625 0.67314 moveto
0.2938 0.65607 lineto
stroke
1 0 0 setrgbcolor
0.31652 0.68985 moveto
0.31667 0.67522 lineto
stroke
0.506 0.332 0.58 setrgbcolor
0.24885 0.5127 moveto
0.3038 0.52796 lineto
0.26707 0.49335 lineto
fill
0.439 0.441 0.764 setrgbcolor
0.24885 0.5127 moveto
0.30049 0.55225 lineto
0.3038 0.52796 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.24885 0.5127 moveto
0.2509 0.51427 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2509 0.51427 moveto
0.28185 0.53797 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28185 0.53797 moveto
0.30049 0.55225 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.24885 0.5127 moveto
0.26707 0.49335 lineto
stroke
0.381 0.167 0.459 setrgbcolor
0.26707 0.49335 moveto
0.31356 0.49363 lineto
0.28523 0.47363 lineto
fill
0.392 0.326 0.663 setrgbcolor
0.26707 0.49335 moveto
0.3038 0.52796 lineto
0.31356 0.49363 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.26707 0.49335 moveto
0.26801 0.49424 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.26801 0.49424 moveto
0.3038 0.52796 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.26707 0.49335 moveto
0.28523 0.47363 lineto
stroke
0.377 0.143 0.427 setrgbcolor
0.3291 0.41018 moveto
0.40897 0.34524 lineto
0.33825 0.3918 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.33825 0.3918 moveto
0.3405 0.39032 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3405 0.39032 moveto
0.36528 0.37401 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.36528 0.37401 moveto
0.40897 0.34524 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.3291 0.41018 moveto
0.33825 0.3918 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.31597 0.71386 moveto
0.31652 0.68985 lineto
stroke
1 0 0 setrgbcolor
0.32724 0.7802 moveto
0.33075 0.78653 lineto
stroke
1 0 0 setrgbcolor
0.33075 0.78653 moveto
0.34381 0.81005 lineto
stroke
1 0 0 setrgbcolor
0.3056 0.5738 moveto
0.30804 0.57562 lineto
stroke
1 0 0 setrgbcolor
0.30804 0.57562 moveto
0.30967 0.57683 lineto
stroke
1 0 0 setrgbcolor
0.30967 0.57683 moveto
0.31226 0.57953 lineto
stroke
1 0 0 setrgbcolor
0.3104 0.76479 moveto
0.32459 0.78122 lineto
stroke
1 0 0 setrgbcolor
0.32459 0.78122 moveto
0.32641 0.78333 lineto
stroke
1 0 0 setrgbcolor
0.43044 0.33348 moveto
0.44329 0.33296 lineto
stroke
0.193 0 0.297 setrgbcolor
0.28523 0.47363 moveto
0.33062 0.45192 lineto
0.30205 0.45269 lineto
fill
0.316 0.186 0.54 setrgbcolor
0.28523 0.47363 moveto
0.31356 0.49363 lineto
0.33062 0.45192 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.28523 0.47363 moveto
0.31356 0.49363 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.28523 0.47363 moveto
0.30205 0.45269 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.31184 0.58566 moveto
0.31226 0.57953 lineto
stroke
0 0 0 setrgbcolor
0.3291 0.41018 moveto
0.38196 0.37094 lineto
0.40897 0.34524 lineto
fill
0.222 0 0.337 setrgbcolor
0.31685 0.431 moveto
0.38196 0.37094 lineto
0.3291 0.41018 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.33422 0.40638 moveto
0.38196 0.37094 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3291 0.41018 moveto
0.33215 0.40791 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33215 0.40791 moveto
0.33422 0.40638 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.31685 0.431 moveto
0.3291 0.41018 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.30183 0.56675 moveto
0.3056 0.5738 lineto
stroke
1 0 0 setrgbcolor
0.31597 0.71386 moveto
0.31836 0.74573 lineto
stroke
0.101 0 0.237 setrgbcolor
0.30205 0.45269 moveto
0.35432 0.40855 lineto
0.31685 0.431 lineto
fill
0.2 0 0.367 setrgbcolor
0.30205 0.45269 moveto
0.33062 0.45192 lineto
0.35432 0.40855 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.30205 0.45269 moveto
0.33062 0.45192 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.30205 0.45269 moveto
0.31685 0.431 lineto
stroke
0.028 0 0.106 setrgbcolor
0.31685 0.431 moveto
0.35432 0.40855 lineto
0.38196 0.37094 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.31685 0.431 moveto
0.31954 0.42939 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31954 0.42939 moveto
0.35432 0.40855 lineto
stroke
1 0 0 setrgbcolor
0.31836 0.74573 moveto
0.32724 0.7802 lineto
stroke
1 0 0 setrgbcolor
0.30755 0.59899 moveto
0.31184 0.58566 lineto
stroke
1 0 0 setrgbcolor
0.30049 0.55225 moveto
0.30183 0.56675 lineto
stroke
1 0 0 setrgbcolor
0.40897 0.34524 moveto
0.43044 0.33348 lineto
stroke
1 0 0 setrgbcolor
0.29791 0.73433 moveto
0.3104 0.76479 lineto
stroke
1 0 0 setrgbcolor
0.30039 0.62243 moveto
0.30755 0.59899 lineto
stroke
1 0 0 setrgbcolor
0.30049 0.55225 moveto
0.3038 0.52796 lineto
stroke
1 0 0 setrgbcolor
0.2938 0.65607 moveto
0.30039 0.62243 lineto
stroke
1 0 0 setrgbcolor
0.29211 0.69577 moveto
0.29791 0.73433 lineto
stroke
1 0 0 setrgbcolor
0.38196 0.37094 moveto
0.40897 0.34524 lineto
stroke
1 0 0 setrgbcolor
0.29211 0.69577 moveto
0.2938 0.65607 lineto
stroke
1 0 0 setrgbcolor
0.3038 0.52796 moveto
0.31356 0.49363 lineto
stroke
1 0 0 setrgbcolor
0.35432 0.40855 moveto
0.38196 0.37094 lineto
stroke
1 0 0 setrgbcolor
0.31356 0.49363 moveto
0.33062 0.45192 lineto
stroke
1 0 0 setrgbcolor
0.33062 0.45192 moveto
0.35432 0.40855 lineto
stroke
0 setgray
0.002 setlinewidth
0.15373 0.23881 moveto
0.67491 0.02381 lineto
stroke
0.15373 0.23881 moveto
0.05551 0.72566 lineto
stroke
0.7189 0.53256 moveto
0.05551 0.72566 lineto
stroke
0.7189 0.53256 moveto
0.67491 0.02381 lineto
stroke
0.86852 0.40728 moveto
0.94449 0.86754 lineto
stroke
0.86852 0.40728 moveto
0.67491 0.02381 lineto
stroke
0.7189 0.53256 moveto
0.67491 0.02381 lineto
stroke
0.7189 0.53256 moveto
0.94449 0.86754 lineto
stroke
0.41005 0.97619 moveto
0.05551 0.72566 lineto
stroke
0.41005 0.97619 moveto
0.94449 0.86754 lineto
stroke
0.7189 0.53256 moveto
0.94449 0.86754 lineto
stroke
0.7189 0.53256 moveto
0.05551 0.72566 lineto
stroke
% End of Graphics
Mpend % End of picture
:[font = input; ]
clear;top=80;kappa[s_]:=0.6Cos[s];tau[s_]:=0.6Sin[s];ds:=N[11.5Pi/top];
width=4;pribbonfrenet;Show[picture,ViewPoint->{2,1,1.7}]
:[inactive; PostScript; output; pictureLeft = 43; pictureWidth = 293; pictureHeight = 262; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.43022 0.54284 moveto
0.86852 0.40728 lineto
stroke
0.43022 0.54284 moveto
0.41005 0.97619 lineto
stroke
0.94449 0.86754 moveto
0.41005 0.97619 lineto
stroke
0.94449 0.86754 moveto
0.86852 0.40728 lineto
stroke
0.15373 0.23881 moveto
0.67491 0.02381 lineto
stroke
0.15373 0.23881 moveto
0.05551 0.72566 lineto
stroke
0.7189 0.53256 moveto
0.05551 0.72566 lineto
stroke
0.7189 0.53256 moveto
0.67491 0.02381 lineto
stroke
0.43022 0.54284 moveto
0.41005 0.97619 lineto
stroke
0.43022 0.54284 moveto
0.15373 0.23881 lineto
stroke
0.05551 0.72566 moveto
0.15373 0.23881 lineto
stroke
0.05551 0.72566 moveto
0.41005 0.97619 lineto
stroke
0.86852 0.40728 moveto
0.94449 0.86754 lineto
stroke
0.86852 0.40728 moveto
0.67491 0.02381 lineto
stroke
0.7189 0.53256 moveto
0.67491 0.02381 lineto
stroke
0.7189 0.53256 moveto
0.94449 0.86754 lineto
stroke
0.43022 0.54284 moveto
0.15373 0.23881 lineto
stroke
0.43022 0.54284 moveto
0.86852 0.40728 lineto
stroke
0.67491 0.02381 moveto
0.86852 0.40728 lineto
stroke
0.67491 0.02381 moveto
0.15373 0.23881 lineto
stroke
0.41005 0.97619 moveto
0.05551 0.72566 lineto
stroke
0.41005 0.97619 moveto
0.94449 0.86754 lineto
stroke
0.7189 0.53256 moveto
0.94449 0.86754 lineto
stroke
0.7189 0.53256 moveto
0.05551 0.72566 lineto
stroke
grestore
0.571 0.465 0.694 setrgbcolor
0.60562 0.48787 moveto
0.68049 0.45474 lineto
0.60914 0.50254 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.62144 0.40579 moveto
0.68606 0.44873 lineto
0.61594 0.41841 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.68606 0.44873 moveto
0.68943 0.45097 lineto
0.67615 0.45084 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.67615 0.45084 moveto
0.68943 0.45097 lineto
0.68238 0.4542 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.61594 0.41841 moveto
0.68606 0.44873 lineto
0.67615 0.45084 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.67901 0.45516 moveto
0.66207 0.44528 lineto
0.67615 0.45084 lineto
fill
0.611 0.483 0.681 setrgbcolor
0.60914 0.50254 moveto
0.75053 0.44889 lineto
0.61393 0.51654 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.7886 0.47514 moveto
0.73768 0.48721 lineto
0.73056 0.45987 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.66178 0.5052 moveto
0.70483 0.47683 lineto
0.73768 0.48721 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.73056 0.45987 moveto
0.73768 0.48721 lineto
0.70483 0.47683 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.73056 0.45987 moveto
0.66178 0.5052 lineto
0.66159 0.50494 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.73056 0.45987 moveto
0.66086 0.50542 lineto
0.66774 0.4904 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.68943 0.45097 moveto
0.69553 0.45503 lineto
0.68395 0.45504 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.75053 0.44889 moveto
0.72747 0.45764 lineto
0.69085 0.45841 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.69259 0.47088 moveto
0.69087 0.4586 lineto
0.72747 0.45764 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.69085 0.45841 moveto
0.72747 0.45764 lineto
0.69087 0.4586 lineto
fill
0.611 0.483 0.681 setrgbcolor
0.61393 0.51654 moveto
0.75053 0.44889 lineto
0.75121 0.44983 lineto
fill
0.64 0.498 0.673 setrgbcolor
0.61393 0.51654 moveto
0.7886 0.47514 lineto
0.61896 0.53052 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.74528 0.48809 moveto
0.68814 0.45867 lineto
0.68832 0.45867 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.74528 0.48809 moveto
0.69057 0.45861 lineto
0.69553 0.45503 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.68395 0.45504 moveto
0.69553 0.45503 lineto
0.69057 0.45861 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.69045 0.45559 moveto
0.69553 0.45503 lineto
0.69085 0.45841 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.75053 0.44889 moveto
0.69085 0.45841 lineto
0.69553 0.45503 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.69259 0.47088 moveto
0.64709 0.48815 lineto
0.67092 0.46687 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.67092 0.46687 moveto
0.64709 0.48815 lineto
0.64453 0.48211 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.63617 0.47425 moveto
0.66335 0.46213 lineto
0.63608 0.47439 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.63608 0.47439 moveto
0.66335 0.46213 lineto
0.66348 0.46211 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.64306 0.46172 moveto
0.65003 0.46423 lineto
0.64768 0.4646 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.64306 0.46172 moveto
0.64768 0.4646 lineto
0.64633 0.46481 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.63608 0.47439 moveto
0.66348 0.46211 lineto
0.66403 0.46202 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.64963 0.45938 moveto
0.65518 0.46341 lineto
0.636 0.45508 lineto
fill
0.571 0.465 0.694 setrgbcolor
0.60914 0.50254 moveto
0.68049 0.45474 lineto
0.68497 0.45876 lineto
fill
0.664 0.573 0.743 setrgbcolor
0.80067 0.52147 moveto
0.63194 0.52988 lineto
0.7886 0.47514 lineto
fill
0.664 0.573 0.743 setrgbcolor
0.61896 0.53052 moveto
0.632 0.52627 lineto
0.63194 0.52988 lineto
fill
0.664 0.573 0.743 setrgbcolor
0.7886 0.47514 moveto
0.63194 0.52988 lineto
0.632 0.52627 lineto
fill
0.531 0.463 0.724 setrgbcolor
0.61594 0.41841 moveto
0.63347 0.43415 lineto
0.61017 0.43074 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.66335 0.46213 moveto
0.63617 0.47425 lineto
0.65518 0.46341 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.61006 0.48589 moveto
0.63743 0.47226 lineto
0.63617 0.47425 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.65518 0.46341 moveto
0.63617 0.47425 lineto
0.63743 0.47226 lineto
fill
0.46 0.392 0.694 setrgbcolor
0.61017 0.43074 moveto
0.64538 0.46391 lineto
0.60584 0.44361 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.6529 0.46377 moveto
0.6375 0.47214 lineto
0.63798 0.47138 lineto
fill
0.451 0.393 0.701 setrgbcolor
0.6239 0.46851 moveto
0.63203 0.47289 lineto
0.63646 0.46594 lineto
fill
0.451 0.393 0.701 setrgbcolor
0.68558 0.50178 moveto
0.63985 0.46842 lineto
0.63203 0.47289 lineto
fill
0.451 0.393 0.701 setrgbcolor
0.63646 0.46594 moveto
0.63203 0.47289 lineto
0.63985 0.46842 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.61006 0.48589 moveto
0.60639 0.48753 lineto
0.65518 0.46341 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.65518 0.46341 moveto
0.60639 0.48753 lineto
0.60685 0.48726 lineto
fill
0.46 0.392 0.694 setrgbcolor
0.68558 0.50178 moveto
0.63646 0.46594 lineto
0.64538 0.46391 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.62914 0.46403 moveto
0.64447 0.46412 lineto
0.64618 0.45826 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.64535 0.46412 moveto
0.62914 0.46403 lineto
0.63646 0.46594 lineto
fill
0.46 0.392 0.694 setrgbcolor
0.60584 0.44361 moveto
0.64538 0.46391 lineto
0.63646 0.46594 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.64618 0.45826 moveto
0.64447 0.46412 lineto
0.64538 0.46391 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.60374 0.47263 moveto
0.63646 0.46594 lineto
0.62914 0.46403 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.65518 0.46341 moveto
0.6375 0.47214 lineto
0.6529 0.46377 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.71174 0.50446 moveto
0.65003 0.46423 lineto
0.65518 0.46341 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.636 0.45508 moveto
0.65518 0.46341 lineto
0.65003 0.46423 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.65826 0.46104 moveto
0.66335 0.46213 lineto
0.6529 0.46377 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.65358 0.45576 moveto
0.64618 0.45826 lineto
0.64521 0.46608 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.64521 0.46608 moveto
0.64618 0.45826 lineto
0.64507 0.46611 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.65003 0.46423 moveto
0.64556 0.46262 lineto
0.64744 0.46253 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.64306 0.46172 moveto
0.64562 0.4622 lineto
0.64556 0.46262 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.71174 0.50446 moveto
0.64768 0.4646 lineto
0.65003 0.46423 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.71174 0.50446 moveto
0.64633 0.46481 lineto
0.64768 0.4646 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.636 0.45508 moveto
0.64744 0.46253 lineto
0.64306 0.46172 lineto
fill
0.531 0.463 0.724 setrgbcolor
0.63325 0.4475 moveto
0.66217 0.45993 lineto
0.65518 0.46341 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.67894 0.45518 moveto
0.66335 0.46213 lineto
0.65826 0.46104 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.67894 0.45518 moveto
0.66403 0.46202 lineto
0.66348 0.46211 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.67784 0.46093 moveto
0.65358 0.45576 lineto
0.64521 0.46608 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.60562 0.48787 moveto
0.63798 0.47138 lineto
0.6375 0.47214 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.60562 0.48787 moveto
0.63617 0.47425 lineto
0.63608 0.47439 lineto
fill
0.429 0.372 0.692 setrgbcolor
0.60562 0.48787 moveto
0.64784 0.47212 lineto
0.60374 0.47263 lineto
fill
0.429 0.372 0.692 setrgbcolor
0.67784 0.46093 moveto
0.6401 0.46689 lineto
0.64784 0.47212 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.63985 0.46842 moveto
0.64521 0.47034 lineto
0.6406 0.46723 lineto
fill
0.429 0.372 0.692 setrgbcolor
0.60374 0.47263 moveto
0.64784 0.47212 lineto
0.6401 0.46689 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.68558 0.50178 moveto
0.64521 0.47034 lineto
0.63985 0.46842 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.64081 0.46692 moveto
0.6406 0.46723 lineto
0.64521 0.47034 lineto
fill
0.433 0.314 0.617 setrgbcolor
0.67784 0.46093 moveto
0.62811 0.45871 lineto
0.67323 0.48463 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.63646 0.46594 moveto
0.63179 0.46082 lineto
0.63278 0.46326 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.63278 0.46326 moveto
0.63179 0.46082 lineto
0.63063 0.46016 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.63985 0.46842 moveto
0.63765 0.46625 lineto
0.63646 0.46594 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.62889 0.45764 moveto
0.63646 0.46594 lineto
0.63765 0.46625 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.62889 0.45764 moveto
0.63985 0.46842 lineto
0.64081 0.46692 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.64507 0.46611 moveto
0.64535 0.46412 lineto
0.60374 0.47263 lineto
fill
0.451 0.393 0.701 setrgbcolor
0.60584 0.44361 moveto
0.6239 0.46851 lineto
0.63646 0.46594 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.68558 0.50178 moveto
0.64173 0.46545 lineto
0.64126 0.46619 lineto
fill
0.433 0.314 0.617 setrgbcolor
0.60371 0.45762 moveto
0.67323 0.48463 lineto
0.62811 0.45871 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.62889 0.45764 moveto
0.63063 0.46016 lineto
0.63179 0.46082 lineto
fill
0.451 0.393 0.701 setrgbcolor
0.60371 0.45762 moveto
0.6239 0.46851 lineto
0.60584 0.44361 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.63679 0.46379 moveto
0.64081 0.46692 lineto
0.63602 0.46198 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.68558 0.50178 moveto
0.64126 0.46619 lineto
0.64081 0.46692 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.63602 0.46198 moveto
0.64081 0.46692 lineto
0.64126 0.46619 lineto
fill
0.531 0.463 0.724 setrgbcolor
0.63347 0.43415 moveto
0.66217 0.45993 lineto
0.63325 0.4475 lineto
fill
0.531 0.463 0.724 setrgbcolor
0.71174 0.50446 moveto
0.65518 0.46341 lineto
0.66217 0.45993 lineto
fill
0.531 0.463 0.724 setrgbcolor
0.61017 0.43074 moveto
0.63347 0.43415 lineto
0.63325 0.4475 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.68558 0.50178 moveto
0.64633 0.46481 lineto
0.71174 0.50446 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.68049 0.45474 moveto
0.66403 0.46202 lineto
0.67894 0.45518 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.67323 0.48463 moveto
0.64173 0.46545 lineto
0.68558 0.50178 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.63602 0.46198 moveto
0.64126 0.46619 lineto
0.64173 0.46545 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.62889 0.45764 moveto
0.63679 0.46379 lineto
0.63602 0.46198 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.60914 0.50254 moveto
0.64453 0.48211 lineto
0.64709 0.48815 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.66217 0.45993 moveto
0.66441 0.4593 lineto
0.71174 0.50446 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.67901 0.45516 moveto
0.68146 0.45885 lineto
0.66441 0.4593 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.67092 0.46687 moveto
0.68497 0.45876 lineto
0.69259 0.47088 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.71174 0.50446 moveto
0.66441 0.4593 lineto
0.68146 0.45885 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.69045 0.45559 moveto
0.69087 0.4586 lineto
0.68497 0.45876 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.69259 0.47088 moveto
0.68497 0.45876 lineto
0.69087 0.4586 lineto
fill
0.727 0.357 0.348 setrgbcolor
0.61017 0.43074 moveto
0.64963 0.45938 lineto
0.636 0.45508 lineto
fill
0.127 0.361 0.822 setrgbcolor
0.60584 0.44361 moveto
0.63278 0.46326 lineto
0.62889 0.45764 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.61393 0.51654 moveto
0.66774 0.4904 lineto
0.66086 0.50542 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.68238 0.4542 moveto
0.68485 0.45307 lineto
0.68395 0.45504 lineto
fill
0.584 0.525 0.755 setrgbcolor
0.68943 0.45097 moveto
0.68395 0.45504 lineto
0.68485 0.45307 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.68238 0.4542 moveto
0.68395 0.45504 lineto
0.68062 0.4547 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.74528 0.48809 moveto
0.68062 0.4547 lineto
0.68395 0.45504 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.75121 0.44983 moveto
0.77245 0.46421 lineto
0.73056 0.45987 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.7886 0.47514 moveto
0.73056 0.45987 lineto
0.77245 0.46421 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.75053 0.44889 moveto
0.75782 0.4499 lineto
0.75121 0.44983 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.77769 0.45268 moveto
0.75053 0.44889 lineto
0.76113 0.44771 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.76253 0.44433 moveto
0.76733 0.45001 lineto
0.75121 0.44983 lineto
fill
0.666 0.622 0.795 setrgbcolor
0.7886 0.47514 moveto
0.75121 0.44983 lineto
0.76733 0.45001 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.76406 0.46757 moveto
0.75121 0.44983 lineto
0.77769 0.45268 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.77769 0.45268 moveto
0.75121 0.44983 lineto
0.75782 0.4499 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.7465 0.44332 moveto
0.76113 0.44771 lineto
0.75053 0.44889 lineto
fill
0.624 0.576 0.78 setrgbcolor
0.62442 0.39273 moveto
0.77769 0.45268 lineto
0.62144 0.40579 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.76253 0.44433 moveto
0.75053 0.44889 lineto
0.72949 0.43305 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.74528 0.48809 moveto
0.68943 0.45097 lineto
0.7465 0.44332 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.67615 0.45084 moveto
0.68238 0.4542 lineto
0.68049 0.45474 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.69842 0.44058 moveto
0.67894 0.45518 lineto
0.65826 0.46104 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.65488 0.45532 moveto
0.66233 0.45714 lineto
0.69842 0.44058 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.67784 0.46093 moveto
0.69842 0.44058 lineto
0.66233 0.45714 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.61594 0.41841 moveto
0.67901 0.45516 lineto
0.66217 0.45993 lineto
fill
0.321 0.008 0.268 setrgbcolor
0.67784 0.46093 moveto
0.65488 0.45532 lineto
0.65423 0.4559 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.68943 0.45097 moveto
0.67239 0.43965 lineto
0.72912 0.4381 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.62144 0.40579 moveto
0.68792 0.42574 lineto
0.67239 0.43965 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.72912 0.4381 moveto
0.67239 0.43965 lineto
0.68792 0.42574 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.7465 0.44332 moveto
0.68943 0.45097 lineto
0.72912 0.4381 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.70147 0.44545 moveto
0.68782 0.45149 lineto
0.72745 0.43355 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.72745 0.43355 moveto
0.68782 0.45149 lineto
0.68732 0.45165 lineto
fill
0.675 0.72 0.882 setrgbcolor
0.72949 0.43305 moveto
0.75053 0.44889 lineto
0.69045 0.45559 lineto
fill
0.611 0.483 0.681 setrgbcolor
0.76253 0.44433 moveto
0.75121 0.44983 lineto
0.75053 0.44889 lineto
fill
0.672 0.498 0.641 setrgbcolor
0.74528 0.48809 moveto
0.7465 0.44332 lineto
0.76406 0.46757 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.7274 0.49682 moveto
0.68049 0.45474 lineto
0.74528 0.48809 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.72745 0.43355 moveto
0.68049 0.45474 lineto
0.67894 0.45518 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.61594 0.41841 moveto
0.66321 0.44387 lineto
0.66207 0.44528 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.67615 0.45084 moveto
0.66207 0.44528 lineto
0.66321 0.44387 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.72745 0.43355 moveto
0.67894 0.45518 lineto
0.69842 0.44058 lineto
fill
0.578 0.923 0.958 setrgbcolor
0.72949 0.43305 moveto
0.70147 0.44545 lineto
0.72745 0.43355 lineto
fill
0.571 0.465 0.694 setrgbcolor
0.68049 0.45474 moveto
0.70147 0.44545 lineto
0.68497 0.45876 lineto
fill
0.571 0.465 0.694 setrgbcolor
0.72949 0.43305 moveto
0.71183 0.44325 lineto
0.70147 0.44545 lineto
fill
0.571 0.465 0.694 setrgbcolor
0.68497 0.45876 moveto
0.70147 0.44545 lineto
0.71183 0.44325 lineto
fill
0.685 0.454 0.565 setrgbcolor
0.71174 0.50446 moveto
0.67615 0.45084 lineto
0.7274 0.49682 lineto
fill
0.397 0.348 0.686 setrgbcolor
0.60371 0.45762 moveto
0.60374 0.47263 lineto
0.67323 0.48463 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.60374 0.47263 moveto
0.60562 0.48787 lineto
stroke
0 0 0 setrgbcolor
0.60371 0.45762 moveto
0.60374 0.47263 lineto
stroke
0 0 0 setrgbcolor
0.60562 0.48787 moveto
0.60914 0.50254 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.65126 0.47609 moveto
0.67323 0.48463 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63482 0.4697 moveto
0.63521 0.46986 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63155 0.46843 moveto
0.63482 0.4697 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63521 0.46986 moveto
0.65126 0.47609 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6263 0.46639 moveto
0.63155 0.46843 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60672 0.45879 moveto
0.6263 0.46639 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60371 0.45762 moveto
0.60672 0.45879 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.60371 0.45762 moveto
0.60584 0.44361 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.69045 0.45559 moveto
0.71183 0.44325 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68497 0.45876 moveto
0.69045 0.45559 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64346 0.48273 moveto
0.64453 0.48211 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64453 0.48211 moveto
0.64675 0.48083 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60914 0.50254 moveto
0.61082 0.50158 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61082 0.50158 moveto
0.64346 0.48273 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.71183 0.44325 moveto
0.72949 0.43305 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.60914 0.50254 moveto
0.61393 0.51654 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.61393 0.51654 moveto
0.61577 0.51565 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66592 0.49128 moveto
0.66603 0.49123 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61577 0.51565 moveto
0.62522 0.51106 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62522 0.51106 moveto
0.65561 0.49629 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65561 0.49629 moveto
0.66592 0.49128 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.75121 0.44983 moveto
0.76253 0.44433 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.61393 0.51654 moveto
0.61896 0.53052 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.66289 0.48522 moveto
0.68558 0.50178 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65862 0.48211 moveto
0.66289 0.48522 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60694 0.44441 moveto
0.62072 0.45446 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60584 0.44361 moveto
0.60694 0.44441 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62072 0.45446 moveto
0.62644 0.45863 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.60584 0.44361 moveto
0.61017 0.43074 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.61896 0.53052 moveto
0.62126 0.52977 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65064 0.52018 moveto
0.67392 0.51258 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62126 0.52977 moveto
0.65064 0.52018 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.74283 0.49008 moveto
0.7886 0.47514 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67392 0.51258 moveto
0.70188 0.50345 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.73789 0.4917 moveto
0.74283 0.49008 lineto
stroke
0.66 0.514 0.674 setrgbcolor
0.61896 0.53052 moveto
0.80067 0.52147 lineto
0.62234 0.54531 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.61896 0.53052 moveto
0.62234 0.54531 lineto
stroke
0.512 0.285 0.507 setrgbcolor
0.54959 0.64228 moveto
0.57115 0.65076 lineto
0.56359 0.6295 lineto
fill
0.512 0.285 0.507 setrgbcolor
0.57115 0.65076 moveto
0.57305 0.65151 lineto
0.58757 0.64548 lineto
fill
0.512 0.285 0.507 setrgbcolor
0.56359 0.6295 moveto
0.57115 0.65076 lineto
0.58757 0.64548 lineto
fill
0.561 0.304 0.484 setrgbcolor
0.59979 0.6611 moveto
0.60021 0.66099 lineto
0.61966 0.6597 lineto
fill
0.621 0.455 0.635 setrgbcolor
0.60679 0.59194 moveto
0.68192 0.67909 lineto
0.59347 0.60531 lineto
fill
0.621 0.455 0.635 setrgbcolor
0.59347 0.60531 moveto
0.68192 0.67909 lineto
0.6811 0.67938 lineto
fill
0.617 0.351 0.493 setrgbcolor
0.5118 0.7019 moveto
0.68149 0.68115 lineto
0.68167 0.68164 lineto
fill
0.659 0.509 0.669 setrgbcolor
0.67864 0.682 moveto
0.68167 0.68164 lineto
0.64219 0.72321 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.65541 0.63978 moveto
0.62217 0.60707 lineto
0.68294 0.63858 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.60679 0.59194 moveto
0.62637 0.60393 lineto
0.62217 0.60707 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.68294 0.63858 moveto
0.62217 0.60707 lineto
0.62637 0.60393 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.60679 0.59194 moveto
0.65541 0.63978 lineto
0.65364 0.63985 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.70331 0.68692 moveto
0.65364 0.63985 lineto
0.65541 0.63978 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.70331 0.68692 moveto
0.65541 0.63978 lineto
0.73488 0.67039 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.73488 0.67039 moveto
0.65541 0.63978 lineto
0.68294 0.63858 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.60679 0.59194 moveto
0.65364 0.63985 lineto
0.64829 0.64009 lineto
fill
0.621 0.455 0.635 setrgbcolor
0.59347 0.60531 moveto
0.68102 0.67932 lineto
0.67989 0.68059 lineto
fill
0.583 0.388 0.583 setrgbcolor
0.57856 0.61748 moveto
0.61772 0.65518 lineto
0.56359 0.6295 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.62666 0.65437 moveto
0.59979 0.6611 lineto
0.62268 0.65354 lineto
fill
0.561 0.304 0.484 setrgbcolor
0.60021 0.66099 moveto
0.63074 0.65335 lineto
0.61969 0.65969 lineto
fill
0.583 0.388 0.583 setrgbcolor
0.62223 0.65952 moveto
0.6153 0.65598 lineto
0.61772 0.65518 lineto
fill
0.583 0.388 0.583 setrgbcolor
0.56359 0.6295 moveto
0.61772 0.65518 lineto
0.6153 0.65598 lineto
fill
0.561 0.304 0.484 setrgbcolor
0.61969 0.65969 moveto
0.63074 0.65335 lineto
0.6314 0.65609 lineto
fill
0.582 0.388 0.584 setrgbcolor
0.62223 0.65952 moveto
0.61772 0.65518 lineto
0.63206 0.65886 lineto
fill
0.582 0.388 0.584 setrgbcolor
0.57856 0.61748 moveto
0.62442 0.65295 lineto
0.61772 0.65518 lineto
fill
0.582 0.388 0.584 setrgbcolor
0.63206 0.65886 moveto
0.61772 0.65518 lineto
0.62442 0.65295 lineto
fill
0.583 0.388 0.583 setrgbcolor
0.56359 0.6295 moveto
0.62223 0.65952 lineto
0.6093 0.66043 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.59521 0.6609 moveto
0.59449 0.64834 lineto
0.62266 0.65354 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.62266 0.65354 moveto
0.59449 0.64834 lineto
0.59547 0.64788 lineto
fill
0.512 0.285 0.507 setrgbcolor
0.57305 0.65151 moveto
0.58101 0.65464 lineto
0.58793 0.64572 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.59445 0.64766 moveto
0.59521 0.6609 lineto
0.59281 0.6484 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.59979 0.6611 moveto
0.59546 0.66218 lineto
0.62268 0.65354 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.5196 0.68118 moveto
0.59521 0.6609 lineto
0.59546 0.66218 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.62268 0.65354 moveto
0.59546 0.66218 lineto
0.59521 0.6609 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.58802 0.64549 moveto
0.59248 0.64251 lineto
0.59613 0.64235 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.58793 0.64572 moveto
0.59294 0.64906 lineto
0.59082 0.6383 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.60329 0.64043 moveto
0.59007 0.64687 lineto
0.59315 0.64369 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.5196 0.68118 moveto
0.58856 0.64603 lineto
0.59007 0.64687 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.59315 0.64369 moveto
0.59007 0.64687 lineto
0.58856 0.64603 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.62468 0.65816 moveto
0.66502 0.67291 lineto
0.60778 0.68361 lineto
fill
0.659 0.509 0.669 setrgbcolor
0.64219 0.72321 moveto
0.68167 0.68164 lineto
0.68639 0.68444 lineto
fill
0.659 0.509 0.669 setrgbcolor
0.68429 0.73008 moveto
0.64219 0.72321 lineto
0.69082 0.68055 lineto
fill
0.659 0.509 0.669 setrgbcolor
0.5118 0.7019 moveto
0.67864 0.682 lineto
0.64219 0.72321 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.68157 0.67869 moveto
0.64829 0.64009 lineto
0.69762 0.68484 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.67482 0.68159 moveto
0.55813 0.68912 lineto
0.67449 0.67765 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.67449 0.67765 moveto
0.55813 0.68912 lineto
0.56089 0.6878 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.60778 0.68361 moveto
0.66502 0.67291 lineto
0.67449 0.67765 lineto
fill
0.617 0.351 0.493 setrgbcolor
0.51476 0.69192 moveto
0.67482 0.68159 lineto
0.5118 0.7019 lineto
fill
0.617 0.351 0.493 setrgbcolor
0.5118 0.7019 moveto
0.67482 0.68159 lineto
0.67648 0.68177 lineto
fill
0.583 0.388 0.583 setrgbcolor
0.65592 0.69197 moveto
0.61296 0.6629 lineto
0.62223 0.65952 lineto
fill
0.583 0.388 0.583 setrgbcolor
0.6093 0.66043 moveto
0.61966 0.6597 lineto
0.61296 0.6629 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.62468 0.65816 moveto
0.60778 0.68361 lineto
0.60011 0.66571 lineto
fill
0.583 0.388 0.583 setrgbcolor
0.62223 0.65952 moveto
0.61296 0.6629 lineto
0.61966 0.6597 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.51476 0.69192 moveto
0.56089 0.6878 lineto
0.55813 0.68912 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.68996 0.67627 moveto
0.67925 0.68003 lineto
0.67449 0.67765 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.67482 0.68159 moveto
0.67449 0.67765 lineto
0.67925 0.68003 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.62601 0.63366 moveto
0.66138 0.66447 lineto
0.63022 0.6512 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.69762 0.68484 moveto
0.64829 0.64009 lineto
0.65364 0.63985 lineto
fill
0.647 0.498 0.666 setrgbcolor
0.61675 0.57697 moveto
0.73488 0.67039 lineto
0.60679 0.59194 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.68273 0.64033 moveto
0.63074 0.65335 lineto
0.66456 0.61627 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.62666 0.65437 moveto
0.62849 0.65253 lineto
0.63074 0.65335 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.66456 0.61627 moveto
0.63074 0.65335 lineto
0.62849 0.65253 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.67925 0.68003 moveto
0.63894 0.65632 lineto
0.66138 0.66447 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.63022 0.6512 moveto
0.66138 0.66447 lineto
0.63894 0.65632 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.63022 0.6512 moveto
0.67925 0.68003 lineto
0.67728 0.67905 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.63206 0.65886 moveto
0.6314 0.65609 lineto
0.69322 0.6922 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.63022 0.6512 moveto
0.65883 0.66982 lineto
0.6314 0.65609 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.69322 0.6922 moveto
0.6314 0.65609 lineto
0.65883 0.66982 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.67729 0.6774 moveto
0.67449 0.67765 lineto
0.66502 0.67291 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.51476 0.69192 moveto
0.60011 0.66571 lineto
0.60778 0.68361 lineto
fill
0.561 0.304 0.484 setrgbcolor
0.51476 0.69192 moveto
0.59979 0.6611 lineto
0.61966 0.6597 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.61687 0.66178 moveto
0.59299 0.64909 lineto
0.6306 0.67415 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.62808 0.64227 moveto
0.59971 0.61197 lineto
0.62601 0.63366 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.62601 0.63366 moveto
0.59971 0.61197 lineto
0.59953 0.61059 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.6195 0.64142 moveto
0.60343 0.61913 lineto
0.62808 0.64227 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.59347 0.60531 moveto
0.60494 0.61756 lineto
0.60343 0.61913 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.62808 0.64227 moveto
0.60343 0.61913 lineto
0.60494 0.61756 lineto
fill
0.582 0.388 0.584 setrgbcolor
0.59347 0.60531 moveto
0.62715 0.65204 lineto
0.57856 0.61748 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.62666 0.65437 moveto
0.62266 0.65354 lineto
0.62987 0.65114 lineto
fill
0.582 0.388 0.584 setrgbcolor
0.63206 0.65886 moveto
0.62442 0.65295 lineto
0.62715 0.65204 lineto
fill
0.582 0.388 0.584 setrgbcolor
0.57856 0.61748 moveto
0.62715 0.65204 lineto
0.62442 0.65295 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.62808 0.64227 moveto
0.63074 0.65335 lineto
0.6195 0.64142 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.63206 0.65886 moveto
0.62715 0.65204 lineto
0.63074 0.65335 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.6195 0.64142 moveto
0.63074 0.65335 lineto
0.62715 0.65204 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.62987 0.65114 moveto
0.62273 0.65044 lineto
0.66456 0.61627 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.59445 0.64766 moveto
0.60368 0.64353 lineto
0.62273 0.65044 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.66456 0.61627 moveto
0.62273 0.65044 lineto
0.60368 0.64353 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.59445 0.64766 moveto
0.62987 0.65114 lineto
0.62266 0.65354 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.64324 0.61145 moveto
0.58522 0.64283 lineto
0.58041 0.64261 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.64324 0.61145 moveto
0.64496 0.61184 lineto
0.62111 0.62342 lineto
fill
0.138 0 0 setrgbcolor
0.64324 0.61145 moveto
0.58901 0.63412 lineto
0.6265 0.62408 lineto
fill
0.138 0 0 setrgbcolor
0.58226 0.63694 moveto
0.58786 0.63531 lineto
0.58901 0.63412 lineto
fill
0.138 0 0 setrgbcolor
0.6265 0.62408 moveto
0.58901 0.63412 lineto
0.58786 0.63531 lineto
fill
0.512 0.285 0.507 setrgbcolor
0.58757 0.64548 moveto
0.57305 0.65151 lineto
0.58793 0.64572 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.52711 0.66904 moveto
0.66395 0.61613 lineto
0.59315 0.64369 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.59089 0.63836 moveto
0.59281 0.6484 lineto
0.61687 0.66178 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.59294 0.64906 moveto
0.61687 0.66178 lineto
0.59281 0.6484 lineto
fill
0.512 0.285 0.507 setrgbcolor
0.6306 0.67415 moveto
0.59294 0.64906 lineto
0.58101 0.65464 lineto
fill
0.512 0.285 0.507 setrgbcolor
0.58793 0.64572 moveto
0.58101 0.65464 lineto
0.59294 0.64906 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.60368 0.64353 moveto
0.59281 0.6484 lineto
0.60329 0.64043 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.5196 0.68118 moveto
0.59007 0.64687 lineto
0.59281 0.6484 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.60329 0.64043 moveto
0.59281 0.6484 lineto
0.59007 0.64687 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.59088 0.63832 moveto
0.61691 0.6618 lineto
0.62095 0.64803 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.6306 0.67415 moveto
0.6284 0.66819 lineto
0.61691 0.6618 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.62095 0.64803 moveto
0.61691 0.6618 lineto
0.6284 0.66819 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.6306 0.67415 moveto
0.59088 0.63832 lineto
0.59089 0.63836 lineto
fill
0.656 0.609 0.79 setrgbcolor
0.5196 0.68118 moveto
0.59281 0.6484 lineto
0.59521 0.6609 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.6292 0.63211 moveto
0.60368 0.64353 lineto
0.60329 0.64043 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.59347 0.60531 moveto
0.59953 0.61059 lineto
0.59971 0.61197 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.66456 0.61627 moveto
0.60322 0.63982 lineto
0.66395 0.61613 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.66395 0.61613 moveto
0.60322 0.63982 lineto
0.60314 0.63981 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.66395 0.61613 moveto
0.59669 0.64233 lineto
0.59663 0.64233 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.70089 0.68818 moveto
0.68376 0.67977 lineto
0.69762 0.68484 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.68157 0.67869 moveto
0.69762 0.68484 lineto
0.68376 0.67977 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.69082 0.68055 moveto
0.68664 0.68082 lineto
0.68996 0.67627 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.67482 0.68159 moveto
0.68192 0.67909 lineto
0.68664 0.68082 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.68996 0.67627 moveto
0.68664 0.68082 lineto
0.68192 0.67909 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.69762 0.68484 moveto
0.67835 0.66513 lineto
0.70331 0.68692 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.65364 0.63985 moveto
0.68087 0.66565 lineto
0.67835 0.66513 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.70331 0.68692 moveto
0.67835 0.66513 lineto
0.68087 0.66565 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.56092 0.65597 moveto
0.57974 0.64307 lineto
0.58522 0.64283 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.58041 0.64261 moveto
0.58522 0.64283 lineto
0.57974 0.64307 lineto
fill
0.277 0.336 0.744 setrgbcolor
0.56359 0.6295 moveto
0.58793 0.64572 lineto
0.59082 0.6383 lineto
fill
0.408 0.151 0.41 setrgbcolor
0.54959 0.64228 moveto
0.55853 0.65379 lineto
0.5776 0.64454 lineto
fill
0.138 0 0 setrgbcolor
0.53725 0.65576 moveto
0.57503 0.64235 lineto
0.58226 0.63694 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.62111 0.62342 moveto
0.59613 0.64235 lineto
0.59248 0.64251 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.62111 0.62342 moveto
0.58802 0.64549 lineto
0.59008 0.6402 lineto
fill
0.412 0.26 0.563 setrgbcolor
0.62095 0.64803 moveto
0.59971 0.63265 lineto
0.5776 0.64454 lineto
fill
0.138 0 0 setrgbcolor
0.58226 0.63694 moveto
0.57924 0.6392 lineto
0.6265 0.62408 lineto
fill
0.412 0.26 0.563 setrgbcolor
0.59739 0.63097 moveto
0.59076 0.63551 lineto
0.59971 0.63265 lineto
fill
0.412 0.26 0.563 setrgbcolor
0.5776 0.64454 moveto
0.59971 0.63265 lineto
0.59076 0.63551 lineto
fill
0.138 0 0 setrgbcolor
0.57503 0.64235 moveto
0.6265 0.62408 lineto
0.57924 0.6392 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.66395 0.61613 moveto
0.59613 0.64235 lineto
0.62111 0.62342 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.68996 0.67627 moveto
0.67729 0.6774 lineto
0.68273 0.64033 lineto
fill
0.617 0.351 0.493 setrgbcolor
0.68149 0.68115 moveto
0.67648 0.68177 lineto
0.67482 0.68159 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.69322 0.6922 moveto
0.65883 0.66982 lineto
0.67989 0.68059 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.63022 0.6512 moveto
0.67728 0.67905 lineto
0.65883 0.66982 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.67989 0.68059 moveto
0.65883 0.66982 lineto
0.67728 0.67905 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.67729 0.6774 moveto
0.66502 0.67291 lineto
0.68273 0.64033 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.62468 0.65816 moveto
0.6314 0.65609 lineto
0.66502 0.67291 lineto
fill
0.653 0.545 0.718 setrgbcolor
0.68273 0.64033 moveto
0.66502 0.67291 lineto
0.6314 0.65609 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.70089 0.68818 moveto
0.69762 0.68484 lineto
0.70331 0.68692 lineto
fill
0.659 0.509 0.669 setrgbcolor
0.68167 0.68164 moveto
0.68643 0.68108 lineto
0.68639 0.68444 lineto
fill
0.659 0.509 0.669 setrgbcolor
0.68639 0.68444 moveto
0.68643 0.68108 lineto
0.68886 0.68227 lineto
fill
0.617 0.351 0.493 setrgbcolor
0.68149 0.68115 moveto
0.68664 0.68082 lineto
0.68167 0.68164 lineto
fill
0.617 0.351 0.493 setrgbcolor
0.69082 0.68055 moveto
0.68643 0.68108 lineto
0.68664 0.68082 lineto
fill
0.617 0.351 0.493 setrgbcolor
0.68167 0.68164 moveto
0.68664 0.68082 lineto
0.68643 0.68108 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.69322 0.6922 moveto
0.68503 0.6827 lineto
0.70089 0.68818 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.68157 0.67869 moveto
0.68643 0.68108 lineto
0.68503 0.6827 lineto
fill
0.697 0.46 0.561 setrgbcolor
0.70089 0.68818 moveto
0.68503 0.6827 lineto
0.68643 0.68108 lineto
fill
0.659 0.509 0.669 setrgbcolor
0.69082 0.68055 moveto
0.68886 0.68227 lineto
0.68643 0.68108 lineto
fill
0.621 0.455 0.635 setrgbcolor
0.68192 0.68236 moveto
0.67989 0.68059 lineto
0.68503 0.6827 lineto
fill
0.621 0.455 0.635 setrgbcolor
0.68503 0.6827 moveto
0.67989 0.68059 lineto
0.68102 0.67932 lineto
fill
0.621 0.455 0.635 setrgbcolor
0.68503 0.6827 moveto
0.6811 0.67938 lineto
0.68192 0.67909 lineto
fill
0.621 0.455 0.635 setrgbcolor
0.69322 0.6922 moveto
0.68192 0.68236 lineto
0.68503 0.6827 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.63206 0.65886 moveto
0.68356 0.68694 lineto
0.65592 0.69197 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.69322 0.6922 moveto
0.68542 0.69215 lineto
0.68356 0.68694 lineto
fill
0.737 0.414 0.434 setrgbcolor
0.65592 0.69197 moveto
0.68356 0.68694 lineto
0.68542 0.69215 lineto
fill
0.561 0.304 0.484 setrgbcolor
0.68273 0.64033 moveto
0.6314 0.65609 lineto
0.63074 0.65335 lineto
fill
0.582 0.388 0.584 setrgbcolor
0.65592 0.69197 moveto
0.62223 0.65952 lineto
0.63206 0.65886 lineto
fill
0.561 0.304 0.484 setrgbcolor
0.5196 0.68118 moveto
0.59979 0.6611 lineto
0.51476 0.69192 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.56092 0.65597 moveto
0.59008 0.6402 lineto
0.58802 0.64549 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.66395 0.61613 moveto
0.62111 0.62342 lineto
0.64496 0.61184 lineto
fill
0.408 0.151 0.41 setrgbcolor
0.53725 0.65576 moveto
0.55853 0.65379 lineto
0.54959 0.64228 lineto
fill
0.408 0.151 0.41 setrgbcolor
0.62095 0.64803 moveto
0.5776 0.64454 lineto
0.55853 0.65379 lineto
fill
0.412 0.26 0.563 setrgbcolor
0.6265 0.62408 moveto
0.59739 0.63097 lineto
0.62095 0.64803 lineto
fill
0.412 0.26 0.563 setrgbcolor
0.54959 0.64228 moveto
0.5776 0.64454 lineto
0.59739 0.63097 lineto
fill
0.666 0.779 0.933 setrgbcolor
0.52711 0.66904 moveto
0.58041 0.64261 lineto
0.56092 0.65597 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.52711 0.66904 moveto
0.59315 0.64369 lineto
0.5196 0.68118 lineto
fill
0.49 0.239 0.46 setrgbcolor
0.66456 0.61627 moveto
0.6292 0.63211 lineto
0.59315 0.64369 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.58992 0.64553 moveto
0.62095 0.64803 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58073 0.64479 moveto
0.58992 0.64553 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54959 0.64228 moveto
0.56558 0.64357 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56558 0.64357 moveto
0.56628 0.64362 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.53725 0.65576 moveto
0.54959 0.64228 lineto
stroke
0 0 0 setrgbcolor
0.54959 0.64228 moveto
0.56359 0.6295 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60914 0.65985 moveto
0.6306 0.67415 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59499 0.65043 moveto
0.60914 0.65985 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56359 0.6295 moveto
0.57407 0.63649 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.56359 0.6295 moveto
0.57856 0.61748 lineto
stroke
0.344 0.077 0.357 setrgbcolor
0.53725 0.65576 moveto
0.52711 0.66904 lineto
0.6265 0.62408 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53725 0.65576 moveto
0.57503 0.64235 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59768 0.63431 moveto
0.6265 0.62408 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57503 0.64235 moveto
0.57867 0.64106 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57867 0.64106 moveto
0.59768 0.63431 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.52711 0.66904 moveto
0.53725 0.65576 lineto
stroke
0.669 0.525 0.679 setrgbcolor
0.62234 0.54531 moveto
0.7949 0.57594 lineto
0.622 0.56105 lineto
fill
0.665 0.541 0.703 setrgbcolor
0.62234 0.54531 moveto
0.80067 0.52147 lineto
0.7949 0.57594 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62234 0.54531 moveto
0.80067 0.52147 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.622 0.56105 moveto
0.62234 0.54531 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.67916 0.48082 moveto
0.71174 0.50446 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67461 0.47751 moveto
0.67916 0.48082 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61017 0.43074 moveto
0.64635 0.45701 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64635 0.45701 moveto
0.64748 0.45782 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.61017 0.43074 moveto
0.61594 0.41841 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.57856 0.61748 moveto
0.58549 0.62414 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58549 0.62414 moveto
0.58869 0.62723 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58869 0.62723 moveto
0.59353 0.63188 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62684 0.66396 moveto
0.65592 0.69197 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.57856 0.61748 moveto
0.59347 0.60531 lineto
stroke
0.664 0.521 0.679 setrgbcolor
0.622 0.56105 moveto
0.77148 0.62898 lineto
0.61675 0.57697 lineto
fill
0.669 0.514 0.665 setrgbcolor
0.622 0.56105 moveto
0.7949 0.57594 lineto
0.77148 0.62898 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.622 0.56105 moveto
0.7949 0.57594 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.61675 0.57697 moveto
0.622 0.56105 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.59347 0.60531 moveto
0.59359 0.60541 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59359 0.60541 moveto
0.59953 0.61059 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59953 0.61059 moveto
0.60612 0.61633 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60612 0.61633 moveto
0.61437 0.62352 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67989 0.68059 moveto
0.68192 0.68236 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67925 0.68003 moveto
0.67989 0.68059 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68192 0.68236 moveto
0.69322 0.6922 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.59347 0.60531 moveto
0.60679 0.59194 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60679 0.59194 moveto
0.60716 0.59216 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60716 0.59216 moveto
0.60872 0.59312 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60872 0.59312 moveto
0.62637 0.60393 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63073 0.6066 moveto
0.64051 0.61259 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62637 0.60393 moveto
0.63073 0.6066 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68009 0.63683 moveto
0.73488 0.67039 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.60679 0.59194 moveto
0.61675 0.57697 lineto
stroke
0.679 0.489 0.622 setrgbcolor
0.61675 0.57697 moveto
0.77148 0.62898 lineto
0.73488 0.67039 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.65157 0.58868 moveto
0.76771 0.62771 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62428 0.57951 moveto
0.65157 0.58868 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76771 0.62771 moveto
0.77148 0.62898 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61675 0.57697 moveto
0.62428 0.57951 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5196 0.68118 moveto
0.52711 0.66904 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.61594 0.41841 moveto
0.66321 0.44387 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66321 0.44387 moveto
0.67304 0.44917 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.69057 0.45861 moveto
0.74528 0.48809 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.61594 0.41841 moveto
0.62144 0.40579 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62411 0.63438 moveto
0.6292 0.63211 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5196 0.68118 moveto
0.52136 0.68039 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52136 0.68039 moveto
0.58654 0.65121 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6292 0.63211 moveto
0.66456 0.61627 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51476 0.69192 moveto
0.5196 0.68118 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62144 0.40579 moveto
0.6218 0.4059 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6218 0.4059 moveto
0.66739 0.41958 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.66739 0.41958 moveto
0.71997 0.43536 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76886 0.45002 moveto
0.77769 0.45268 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.76683 0.44942 moveto
0.76886 0.45002 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.62144 0.40579 moveto
0.62442 0.39273 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51476 0.69192 moveto
0.53361 0.68613 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6314 0.65609 moveto
0.68273 0.64033 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5887 0.66921 moveto
0.60011 0.66571 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60011 0.66571 moveto
0.60518 0.66415 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61231 0.66196 moveto
0.61231 0.66196 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.53361 0.68613 moveto
0.5887 0.66921 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5118 0.7019 moveto
0.51476 0.69192 lineto
stroke
0.668 0.534 0.691 setrgbcolor
0.62442 0.39273 moveto
0.80021 0.40371 lineto
0.77769 0.45268 lineto
fill
0.655 0.613 0.795 setrgbcolor
0.623 0.37989 moveto
0.80021 0.40371 lineto
0.62442 0.39273 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62442 0.39273 moveto
0.80021 0.40371 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.623 0.37989 moveto
0.62442 0.39273 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.5118 0.7019 moveto
0.56917 0.69506 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56917 0.69506 moveto
0.56963 0.695 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56963 0.695 moveto
0.64681 0.6858 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68643 0.68108 moveto
0.69082 0.68055 lineto
stroke
0.663 0.397 0.508 setrgbcolor
0.5118 0.7019 moveto
0.68429 0.73008 lineto
0.50889 0.71201 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.50889 0.71201 moveto
0.5118 0.7019 lineto
stroke
0.67 0.571 0.735 setrgbcolor
0.623 0.37989 moveto
0.80613 0.3509 lineto
0.80021 0.40371 lineto
fill
0.675 0.63 0.795 setrgbcolor
0.61639 0.36827 moveto
0.80613 0.3509 lineto
0.623 0.37989 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.64676 0.37613 moveto
0.80613 0.3509 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63672 0.37772 moveto
0.64353 0.37664 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.64355 0.37663 moveto
0.64676 0.37613 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.623 0.37989 moveto
0.63672 0.37772 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.61639 0.36827 moveto
0.623 0.37989 lineto
stroke
0.676 0.615 0.779 setrgbcolor
0.61639 0.36827 moveto
0.79255 0.30517 lineto
0.80613 0.3509 lineto
fill
0.679 0.628 0.79 setrgbcolor
0.60522 0.35845 moveto
0.79255 0.30517 lineto
0.61639 0.36827 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.61639 0.36827 moveto
0.62064 0.36675 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.72765 0.32842 moveto
0.79255 0.30517 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62495 0.36521 moveto
0.72765 0.32842 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62064 0.36675 moveto
0.62281 0.36598 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62288 0.36595 moveto
0.62495 0.36521 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.60522 0.35845 moveto
0.61639 0.36827 lineto
stroke
0.693 0.439 0.533 setrgbcolor
0.50889 0.71201 moveto
0.66157 0.7799 lineto
0.50371 0.72248 lineto
fill
0.669 0.484 0.626 setrgbcolor
0.50889 0.71201 moveto
0.68429 0.73008 lineto
0.66157 0.7799 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53846 0.71506 moveto
0.68429 0.73008 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51291 0.71243 moveto
0.53846 0.71506 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50889 0.71201 moveto
0.51291 0.71243 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.50371 0.72248 moveto
0.50889 0.71201 lineto
stroke
0.534 0 0 setrgbcolor
0.52369 0.31469 moveto
0.55455 0.3348 lineto
0.53423 0.31982 lineto
fill
0 0.333 0.811 setrgbcolor
0.52369 0.31469 moveto
0.6231 0.38401 lineto
0.55455 0.3348 lineto
fill
0.694 0.402 0.476 setrgbcolor
0.52082 0.31428 moveto
0.55455 0.3348 lineto
0.6231 0.38401 lineto
fill
0.694 0.402 0.476 setrgbcolor
0.63192 0.38187 moveto
0.6231 0.38401 lineto
0.55455 0.3348 lineto
fill
0 0.333 0.811 setrgbcolor
0.60957 0.37066 moveto
0.55455 0.3348 lineto
0.6231 0.38401 lineto
fill
0.534 0 0 setrgbcolor
0.60957 0.37066 moveto
0.57364 0.34642 lineto
0.55455 0.3348 lineto
fill
0.534 0 0 setrgbcolor
0.53423 0.31982 moveto
0.55455 0.3348 lineto
0.57364 0.34642 lineto
fill
0.667 0.621 0.793 setrgbcolor
0.76113 0.27554 moveto
0.60591 0.35809 lineto
0.59117 0.35009 lineto
fill
0.667 0.621 0.793 setrgbcolor
0.60522 0.35845 moveto
0.59336 0.3514 lineto
0.60591 0.35809 lineto
fill
0.667 0.621 0.793 setrgbcolor
0.59117 0.35009 moveto
0.60591 0.35809 lineto
0.59336 0.3514 lineto
fill
0.7 0.77 0.906 setrgbcolor
0.76113 0.27554 moveto
0.65636 0.32149 lineto
0.71793 0.26709 lineto
fill
0.7 0.77 0.906 setrgbcolor
0.59117 0.35009 moveto
0.63309 0.32264 lineto
0.65636 0.32149 lineto
fill
0.366 0.762 0.986 setrgbcolor
0.50575 0.30314 moveto
0.55402 0.30615 lineto
0.50917 0.30577 lineto
fill
0.7 0.77 0.906 setrgbcolor
0.65636 0.32149 moveto
0.64111 0.32225 lineto
0.71793 0.26709 lineto
fill
0.7 0.77 0.906 setrgbcolor
0.71793 0.26709 moveto
0.64111 0.32225 lineto
0.63532 0.32118 lineto
fill
0.686 0.673 0.832 setrgbcolor
0.79255 0.30517 moveto
0.60919 0.35732 lineto
0.76113 0.27554 lineto
fill
0.686 0.673 0.832 setrgbcolor
0.76113 0.27554 moveto
0.60919 0.35732 lineto
0.60824 0.35685 lineto
fill
0.644 0.621 0.812 setrgbcolor
0.57607 0.34228 moveto
0.71793 0.26709 lineto
0.59117 0.35009 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.61735 0.3204 moveto
0.58528 0.33739 lineto
0.61514 0.31691 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.57607 0.34228 moveto
0.58473 0.33665 lineto
0.58528 0.33739 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.61514 0.31691 moveto
0.58528 0.33739 lineto
0.58473 0.33665 lineto
fill
0.477 0.633 0.922 setrgbcolor
0.57607 0.34228 moveto
0.61337 0.32055 lineto
0.56115 0.33438 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.61735 0.3204 moveto
0.65686 0.2912 lineto
0.71793 0.26709 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.61514 0.31691 moveto
0.66229 0.28629 lineto
0.61735 0.3204 lineto
fill
0.671 0.593 0.759 setrgbcolor
0.50575 0.30314 moveto
0.69641 0.27088 lineto
0.61053 0.30966 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.67222 0.27984 moveto
0.66539 0.28489 lineto
0.66229 0.28629 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.61735 0.3204 moveto
0.66229 0.28629 lineto
0.66539 0.28489 lineto
fill
0.671 0.593 0.759 setrgbcolor
0.69654 0.26973 moveto
0.69641 0.27088 lineto
0.50575 0.30314 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.67222 0.27984 moveto
0.70399 0.27098 lineto
0.65686 0.2912 lineto
fill
0.658 0.937 0.966 setrgbcolor
0.71793 0.26709 moveto
0.65686 0.2912 lineto
0.70399 0.27098 lineto
fill
0.671 0.593 0.759 setrgbcolor
0.69641 0.27088 moveto
0.62054 0.31028 lineto
0.65148 0.29117 lineto
fill
0.07 0 0 setrgbcolor
0.67222 0.27984 moveto
0.66052 0.28558 lineto
0.63435 0.30832 lineto
fill
0.07 0 0 setrgbcolor
0.64583 0.2928 moveto
0.62229 0.30435 lineto
0.60678 0.31814 lineto
fill
0.07 0 0 setrgbcolor
0.56115 0.33438 moveto
0.59911 0.32087 lineto
0.62229 0.30435 lineto
fill
0.07 0 0 setrgbcolor
0.60678 0.31814 moveto
0.62229 0.30435 lineto
0.59911 0.32087 lineto
fill
0.686 0.673 0.832 setrgbcolor
0.60522 0.35845 moveto
0.60824 0.35685 lineto
0.60919 0.35732 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.64671 0.37827 moveto
0.57392 0.34058 lineto
0.67233 0.3537 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.67233 0.3537 moveto
0.57392 0.34058 lineto
0.5737 0.34 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.67233 0.3537 moveto
0.57812 0.34062 lineto
0.58685 0.3296 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.57248 0.33983 moveto
0.58149 0.33341 lineto
0.57812 0.34062 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.58685 0.3296 moveto
0.57812 0.34062 lineto
0.58149 0.33341 lineto
fill
0.148 0.601 0.929 setrgbcolor
0.67233 0.3537 moveto
0.58369 0.32871 lineto
0.58887 0.32918 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.61918 0.33198 moveto
0.5834 0.32932 lineto
0.61246 0.34245 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.54701 0.32661 moveto
0.58084 0.3348 lineto
0.5834 0.32932 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.61246 0.34245 moveto
0.5834 0.32932 lineto
0.58084 0.3348 lineto
fill
0.694 0.402 0.476 setrgbcolor
0.63192 0.38187 moveto
0.54234 0.32711 lineto
0.64671 0.37827 lineto
fill
0.694 0.402 0.476 setrgbcolor
0.64671 0.37827 moveto
0.54234 0.32711 lineto
0.54683 0.32689 lineto
fill
0.056 0.495 0.891 setrgbcolor
0.56156 0.33444 moveto
0.58974 0.33887 lineto
0.55146 0.32905 lineto
fill
0.056 0.495 0.891 setrgbcolor
0.61246 0.34245 moveto
0.58381 0.33616 lineto
0.58974 0.33887 lineto
fill
0.056 0.495 0.891 setrgbcolor
0.55146 0.32905 moveto
0.58974 0.33887 lineto
0.58381 0.33616 lineto
fill
0.056 0.495 0.891 setrgbcolor
0.54701 0.32661 moveto
0.55146 0.32905 lineto
0.61246 0.34245 lineto
fill
0.056 0.495 0.891 setrgbcolor
0.56115 0.33438 moveto
0.56156 0.33444 lineto
0.55146 0.32905 lineto
fill
0.425 0.358 0.678 setrgbcolor
0.57701 0.34868 moveto
0.57412 0.34109 lineto
0.53423 0.31982 lineto
fill
0.425 0.358 0.678 setrgbcolor
0.56995 0.33015 moveto
0.53423 0.31982 lineto
0.57412 0.34109 lineto
fill
0.371 0 0 setrgbcolor
0.5355 0.32079 moveto
0.55333 0.33001 lineto
0.52087 0.31354 lineto
fill
0.371 0 0 setrgbcolor
0.64671 0.37827 moveto
0.56544 0.33647 lineto
0.55333 0.33001 lineto
fill
0.371 0 0 setrgbcolor
0.52087 0.31354 moveto
0.55333 0.33001 lineto
0.56544 0.33647 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.51187 0.30845 moveto
0.54163 0.31684 lineto
0.57248 0.33983 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.59931 0.31566 moveto
0.58875 0.31787 lineto
0.58887 0.32918 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.5513 0.32572 moveto
0.58369 0.32871 lineto
0.58875 0.31787 lineto
fill
0.477 0.633 0.922 setrgbcolor
0.56115 0.33438 moveto
0.61337 0.32055 lineto
0.60678 0.31814 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.58887 0.32918 moveto
0.58875 0.31787 lineto
0.58369 0.32871 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.54701 0.32661 moveto
0.61918 0.33198 lineto
0.5513 0.32572 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.54163 0.31684 moveto
0.58369 0.32871 lineto
0.58005 0.33444 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.58685 0.3296 moveto
0.58149 0.33341 lineto
0.58369 0.32871 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.58005 0.33444 moveto
0.58369 0.32871 lineto
0.58149 0.33341 lineto
fill
0.665 0.488 0.635 setrgbcolor
0.57248 0.33983 moveto
0.54163 0.31684 lineto
0.58005 0.33444 lineto
fill
0.694 0.402 0.476 setrgbcolor
0.51625 0.31116 moveto
0.63192 0.38187 lineto
0.52082 0.31428 lineto
fill
0.371 0 0 setrgbcolor
0.52369 0.31469 moveto
0.5355 0.32079 lineto
0.51625 0.31116 lineto
fill
0.371 0 0 setrgbcolor
0.51625 0.31116 moveto
0.5355 0.32079 lineto
0.52087 0.31354 lineto
fill
0 0.304 0.702 setrgbcolor
0.51187 0.30845 moveto
0.57392 0.34058 lineto
0.51625 0.31116 lineto
fill
0 0.304 0.702 setrgbcolor
0.64671 0.37827 moveto
0.56544 0.33647 lineto
0.57392 0.34058 lineto
fill
0 0.304 0.702 setrgbcolor
0.51625 0.31116 moveto
0.57392 0.34058 lineto
0.56544 0.33647 lineto
fill
0.425 0.358 0.678 setrgbcolor
0.56995 0.33015 moveto
0.58577 0.34633 lineto
0.61246 0.34245 lineto
fill
0.425 0.358 0.678 setrgbcolor
0.60957 0.37066 moveto
0.61082 0.35848 lineto
0.58577 0.34633 lineto
fill
0.425 0.358 0.678 setrgbcolor
0.61246 0.34245 moveto
0.58577 0.34633 lineto
0.61082 0.35848 lineto
fill
0.425 0.358 0.678 setrgbcolor
0.60957 0.37066 moveto
0.56995 0.33015 lineto
0.57701 0.34868 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.61123 0.31076 moveto
0.61766 0.31108 lineto
0.59283 0.32406 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.69148 0.31469 moveto
0.59848 0.32352 lineto
0.61766 0.31108 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.59283 0.32406 moveto
0.61766 0.31108 lineto
0.59848 0.32352 lineto
fill
0.366 0.762 0.986 setrgbcolor
0.61053 0.30966 moveto
0.62054 0.31028 lineto
0.61123 0.31076 lineto
fill
0.366 0.762 0.986 setrgbcolor
0.69148 0.31469 moveto
0.61766 0.31108 lineto
0.62054 0.31028 lineto
fill
0.366 0.762 0.986 setrgbcolor
0.61123 0.31076 moveto
0.62054 0.31028 lineto
0.61766 0.31108 lineto
fill
0.07 0 0 setrgbcolor
0.64583 0.2928 moveto
0.61908 0.31069 lineto
0.66052 0.28558 lineto
fill
0.07 0 0 setrgbcolor
0.60926 0.31725 moveto
0.62054 0.31028 lineto
0.61908 0.31069 lineto
fill
0.07 0 0 setrgbcolor
0.66052 0.28558 moveto
0.61908 0.31069 lineto
0.62054 0.31028 lineto
fill
0.07 0 0 setrgbcolor
0.60926 0.31725 moveto
0.64583 0.2928 lineto
0.60678 0.31814 lineto
fill
0.671 0.593 0.759 setrgbcolor
0.69148 0.31469 moveto
0.62054 0.31028 lineto
0.69641 0.27088 lineto
fill
0.07 0 0 setrgbcolor
0.63435 0.30832 moveto
0.66052 0.28558 lineto
0.60926 0.31725 lineto
fill
0.671 0.593 0.759 setrgbcolor
0.61053 0.30966 moveto
0.65148 0.29117 lineto
0.62054 0.31028 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.57666 0.32559 moveto
0.59906 0.31599 lineto
0.59283 0.32406 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.61123 0.31076 moveto
0.59283 0.32406 lineto
0.59906 0.31599 lineto
fill
0.477 0.633 0.922 setrgbcolor
0.63435 0.30832 moveto
0.60678 0.31814 lineto
0.61337 0.32055 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.63435 0.30832 moveto
0.59931 0.31566 lineto
0.61918 0.33198 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.57666 0.32559 moveto
0.61676 0.32179 lineto
0.67233 0.3537 lineto
fill
0.396 0.191 0.481 setrgbcolor
0.61918 0.33198 moveto
0.59931 0.31566 lineto
0.58887 0.32918 lineto
fill
0.7 0.77 0.906 setrgbcolor
0.63309 0.32264 moveto
0.63532 0.32118 lineto
0.64111 0.32225 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.69148 0.31469 moveto
0.67715 0.34389 lineto
0.61676 0.32179 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.67233 0.3537 moveto
0.61676 0.32179 lineto
0.67715 0.34389 lineto
fill
0.148 0.601 0.929 setrgbcolor
0.57666 0.32559 moveto
0.58887 0.32918 lineto
0.57769 0.32701 lineto
fill
0.148 0.601 0.929 setrgbcolor
0.57769 0.32701 moveto
0.58887 0.32918 lineto
0.58369 0.32871 lineto
fill
0.148 0.601 0.929 setrgbcolor
0.50917 0.30577 moveto
0.57666 0.32559 lineto
0.51187 0.30845 lineto
fill
0.148 0.601 0.929 setrgbcolor
0.51187 0.30845 moveto
0.57666 0.32559 lineto
0.57769 0.32701 lineto
fill
0.664 0.541 0.705 setrgbcolor
0.50917 0.30577 moveto
0.61123 0.31076 lineto
0.57666 0.32559 lineto
fill
0.366 0.762 0.986 setrgbcolor
0.55402 0.30615 moveto
0.61053 0.30966 lineto
0.5674 0.30862 lineto
fill
0.366 0.762 0.986 setrgbcolor
0.5674 0.30862 moveto
0.61053 0.30966 lineto
0.61123 0.31076 lineto
fill
0.366 0.762 0.986 setrgbcolor
0.50917 0.30577 moveto
0.55402 0.30615 lineto
0.5674 0.30862 lineto
fill
0.694 0.402 0.476 setrgbcolor
0.51625 0.31116 moveto
0.54683 0.32689 lineto
0.54234 0.32711 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.69173 0.31245 moveto
0.76113 0.27554 lineto
stroke
1 0 0 setrgbcolor
0.77148 0.62898 moveto
0.7949 0.57594 lineto
stroke
1 0 0 setrgbcolor
0.7949 0.57594 moveto
0.80067 0.52147 lineto
stroke
1 0 0 setrgbcolor
0.7886 0.47514 moveto
0.80067 0.52147 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.69516 0.282 moveto
0.70874 0.27311 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.70874 0.27311 moveto
0.71793 0.26709 lineto
stroke
1 0 0 setrgbcolor
0.73488 0.67039 moveto
0.77148 0.62898 lineto
stroke
1 0 0 setrgbcolor
0.76253 0.44433 moveto
0.76681 0.44939 lineto
stroke
1 0 0 setrgbcolor
0.76681 0.44939 moveto
0.76733 0.45001 lineto
stroke
1 0 0 setrgbcolor
0.77348 0.45728 moveto
0.7886 0.47514 lineto
stroke
0.702 0.458 0.552 setrgbcolor
0.50371 0.72248 moveto
0.62463 0.82 lineto
0.49459 0.73247 lineto
fill
0.686 0.465 0.581 setrgbcolor
0.50371 0.72248 moveto
0.66157 0.7799 lineto
0.62463 0.82 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.50824 0.72413 moveto
0.52305 0.72952 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52305 0.72952 moveto
0.66157 0.7799 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50371 0.72248 moveto
0.50824 0.72413 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49459 0.73247 moveto
0.50371 0.72248 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.57701 0.34868 moveto
0.60957 0.37066 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57648 0.34833 moveto
0.57701 0.34868 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57364 0.34642 moveto
0.57648 0.34833 lineto
stroke
0.693 0.445 0.543 setrgbcolor
0.49459 0.73247 moveto
0.57964 0.84098 lineto
0.48123 0.74062 lineto
fill
0.714 0.446 0.518 setrgbcolor
0.49459 0.73247 moveto
0.62463 0.82 lineto
0.57964 0.84098 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.49459 0.73247 moveto
0.49829 0.73496 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49829 0.73496 moveto
0.50413 0.73889 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50413 0.73889 moveto
0.62463 0.82 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.48123 0.74062 moveto
0.49459 0.73247 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.72949 0.43305 moveto
0.76253 0.44433 lineto
stroke
1 0 0 setrgbcolor
0.74528 0.48809 moveto
0.77769 0.45268 lineto
stroke
1 0 0 setrgbcolor
0.77769 0.45268 moveto
0.80021 0.40371 lineto
stroke
1 0 0 setrgbcolor
0.69322 0.6922 moveto
0.73488 0.67039 lineto
stroke
1 0 0 setrgbcolor
0.80021 0.40371 moveto
0.80613 0.3509 lineto
stroke
0.67 0.393 0.491 setrgbcolor
0.48123 0.74062 moveto
0.53614 0.83721 lineto
0.46461 0.74614 lineto
fill
0.768 0.419 0.395 setrgbcolor
0.48123 0.74062 moveto
0.57964 0.84098 lineto
0.53614 0.83721 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.48123 0.74062 moveto
0.48446 0.74392 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.48446 0.74392 moveto
0.48502 0.74448 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.48502 0.74448 moveto
0.57964 0.84098 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.46461 0.74614 moveto
0.48123 0.74062 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.71174 0.50446 moveto
0.74528 0.48809 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51787 0.312 moveto
0.53521 0.32092 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51625 0.31116 moveto
0.51787 0.312 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56238 0.3349 moveto
0.56544 0.33647 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61069 0.35974 moveto
0.64671 0.37827 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54683 0.32689 moveto
0.56238 0.3349 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.53521 0.32092 moveto
0.54683 0.32689 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51187 0.30845 moveto
0.51625 0.31116 lineto
stroke
0.618 0.264 0.347 setrgbcolor
0.46461 0.74614 moveto
0.50397 0.81039 lineto
0.44608 0.74934 lineto
fill
0.641 0.717 0.903 setrgbcolor
0.29308 0.73328 moveto
0.36906 0.72756 lineto
0.30183 0.74056 lineto
fill
0.641 0.717 0.903 setrgbcolor
0.48152 0.71909 moveto
0.38867 0.73018 lineto
0.36906 0.72756 lineto
fill
0.641 0.717 0.903 setrgbcolor
0.30183 0.74056 moveto
0.36906 0.72756 lineto
0.38867 0.73018 lineto
fill
0.662 0.561 0.73 setrgbcolor
0.29308 0.73328 moveto
0.4799 0.69266 lineto
0.48152 0.71909 lineto
fill
0.576 0.671 0.903 setrgbcolor
0.28907 0.72484 moveto
0.37463 0.73839 lineto
0.29308 0.73328 lineto
fill
0.576 0.671 0.903 setrgbcolor
0.44019 0.74877 moveto
0.39808 0.74433 lineto
0.37463 0.73839 lineto
fill
0.576 0.671 0.903 setrgbcolor
0.29308 0.73328 moveto
0.37463 0.73839 lineto
0.39808 0.74433 lineto
fill
0.576 0.671 0.903 setrgbcolor
0.29534 0.73353 moveto
0.37847 0.74228 lineto
0.38058 0.74328 lineto
fill
0.576 0.671 0.903 setrgbcolor
0.44019 0.74877 moveto
0.29534 0.73353 lineto
0.29534 0.73351 lineto
fill
0.667 0.495 0.642 setrgbcolor
0.28907 0.72484 moveto
0.48152 0.71909 lineto
0.47054 0.75357 lineto
fill
0.492 0.585 0.876 setrgbcolor
0.2885 0.71612 moveto
0.28958 0.7166 lineto
0.28907 0.72484 lineto
fill
0 0.035 0.603 setrgbcolor
0.28576 0.68707 moveto
0.28684 0.68864 lineto
0.28071 0.67351 lineto
fill
0.492 0.585 0.876 setrgbcolor
0.29555 0.71923 moveto
0.33412 0.73618 lineto
0.29815 0.72835 lineto
fill
0.492 0.585 0.876 setrgbcolor
0.4472 0.7859 moveto
0.34389 0.74601 lineto
0.33412 0.73618 lineto
fill
0.492 0.585 0.876 setrgbcolor
0.29815 0.72835 moveto
0.33412 0.73618 lineto
0.34389 0.74601 lineto
fill
0.706 0.392 0.442 setrgbcolor
0.4472 0.7859 moveto
0.29003 0.7171 lineto
0.29026 0.717 lineto
fill
0.706 0.392 0.442 setrgbcolor
0.4472 0.7859 moveto
0.29026 0.717 lineto
0.2908 0.71714 lineto
fill
0.706 0.392 0.442 setrgbcolor
0.41467 0.8055 moveto
0.28961 0.71691 lineto
0.4472 0.7859 lineto
fill
0.576 0.671 0.903 setrgbcolor
0.44213 0.75032 moveto
0.38058 0.74328 lineto
0.44019 0.74877 lineto
fill
0.576 0.671 0.903 setrgbcolor
0.44019 0.74877 moveto
0.38058 0.74328 lineto
0.37847 0.74228 lineto
fill
0.576 0.671 0.903 setrgbcolor
0.47054 0.75357 moveto
0.44213 0.75032 lineto
0.44019 0.74877 lineto
fill
0.788 0.289 0 setrgbcolor
0.46461 0.74614 moveto
0.51195 0.80642 lineto
0.49144 0.78994 lineto
fill
0.031 0.185 0.691 setrgbcolor
0.44608 0.74934 moveto
0.50397 0.81039 lineto
0.48879 0.77036 lineto
fill
0.623 0.263 0.339 setrgbcolor
0.44608 0.74934 moveto
0.42675 0.75141 lineto
0.50397 0.81039 lineto
fill
0.688 0.456 0.565 setrgbcolor
0.2885 0.71612 moveto
0.47054 0.75357 lineto
0.4472 0.7859 lineto
fill
0.5 0.584 0.871 setrgbcolor
0.28908 0.70745 moveto
0.29118 0.70849 lineto
0.2885 0.71612 lineto
fill
0.5 0.584 0.871 setrgbcolor
0.4472 0.7859 moveto
0.29372 0.71842 lineto
0.29118 0.70849 lineto
fill
0.5 0.584 0.871 setrgbcolor
0.2885 0.71612 moveto
0.29118 0.70849 lineto
0.29372 0.71842 lineto
fill
0.157 0.288 0.749 setrgbcolor
0.37866 0.80365 moveto
0.2894 0.70779 lineto
0.28921 0.69891 lineto
fill
0.79 0.392 0.299 setrgbcolor
0.37866 0.80365 moveto
0.29033 0.70022 lineto
0.41467 0.8055 lineto
fill
0.79 0.392 0.299 setrgbcolor
0.41467 0.8055 moveto
0.29033 0.70022 lineto
0.29183 0.70093 lineto
fill
0.767 0.27 0 setrgbcolor
0.34697 0.77569 moveto
0.28684 0.68864 lineto
0.37866 0.80365 lineto
fill
0.767 0.27 0 setrgbcolor
0.37866 0.80365 moveto
0.28684 0.68864 lineto
0.28768 0.68948 lineto
fill
0 0.053 0.614 setrgbcolor
0.3283 0.72369 moveto
0.28276 0.67566 lineto
0.34697 0.77569 lineto
fill
0 0.053 0.614 setrgbcolor
0.28071 0.67351 moveto
0.28318 0.67732 lineto
0.28276 0.67566 lineto
fill
0 0.053 0.614 setrgbcolor
0.34697 0.77569 moveto
0.28276 0.67566 lineto
0.28318 0.67732 lineto
fill
0 0.035 0.603 setrgbcolor
0.34697 0.77569 moveto
0.28396 0.67852 lineto
0.28684 0.68864 lineto
fill
0 0.035 0.603 setrgbcolor
0.28071 0.67351 moveto
0.28684 0.68864 lineto
0.28396 0.67852 lineto
fill
0.492 0.585 0.876 setrgbcolor
0.28958 0.7166 moveto
0.29555 0.71923 lineto
0.28976 0.72511 lineto
fill
0.492 0.585 0.876 setrgbcolor
0.28976 0.72511 moveto
0.29555 0.71923 lineto
0.29815 0.72835 lineto
fill
0.492 0.585 0.876 setrgbcolor
0.28907 0.72484 moveto
0.28958 0.7166 lineto
0.28976 0.72511 lineto
fill
0.157 0.288 0.749 setrgbcolor
0.28857 0.69816 moveto
0.28921 0.69891 lineto
0.28908 0.70745 lineto
fill
0.157 0.288 0.749 setrgbcolor
0.28908 0.70745 moveto
0.28921 0.69891 lineto
0.2894 0.70779 lineto
fill
0.79 0.392 0.299 setrgbcolor
0.28857 0.69816 moveto
0.29183 0.70093 lineto
0.29033 0.70022 lineto
fill
0 0.061 0.618 setrgbcolor
0.28576 0.68707 moveto
0.28814 0.69052 lineto
0.28857 0.69816 lineto
fill
0 0.061 0.618 setrgbcolor
0.34697 0.77569 moveto
0.28966 0.69961 lineto
0.28814 0.69052 lineto
fill
0 0.061 0.618 setrgbcolor
0.28857 0.69816 moveto
0.28814 0.69052 lineto
0.28966 0.69961 lineto
fill
0.788 0.289 0 setrgbcolor
0.50397 0.81039 moveto
0.49144 0.78994 lineto
0.53614 0.83721 lineto
fill
0.788 0.289 0 setrgbcolor
0.53614 0.83721 moveto
0.49144 0.78994 lineto
0.51195 0.80642 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4705 0.75364 moveto
0.47991 0.76562 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.47991 0.76562 moveto
0.48038 0.76622 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49361 0.78306 moveto
0.53614 0.83721 lineto
stroke
1 0 0 setrgbcolor
0.69049 0.68307 moveto
0.69082 0.68055 lineto
stroke
1 0 0 setrgbcolor
0.68429 0.73008 moveto
0.68929 0.69218 lineto
stroke
1 0 0 setrgbcolor
0.68273 0.64033 moveto
0.68996 0.67627 lineto
stroke
1 0 0 setrgbcolor
0.68996 0.67627 moveto
0.69082 0.68055 lineto
stroke
1 0 0 setrgbcolor
0.79255 0.30517 moveto
0.80613 0.3509 lineto
stroke
1 0 0 setrgbcolor
0.66456 0.61627 moveto
0.68273 0.64033 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.47277 0.77749 moveto
0.50397 0.81039 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4617 0.76581 moveto
0.47277 0.77749 lineto
stroke
1 0 0 setrgbcolor
0.69842 0.44058 moveto
0.72949 0.43305 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46399 0.76278 moveto
0.48879 0.77036 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46391 0.76276 moveto
0.46399 0.76278 lineto
stroke
1 0 0 setrgbcolor
0.68558 0.50178 moveto
0.71174 0.50446 lineto
stroke
1 0 0 setrgbcolor
0.65592 0.69197 moveto
0.69322 0.6922 lineto
stroke
1 0 0 setrgbcolor
0.66157 0.7799 moveto
0.68429 0.73008 lineto
stroke
1 0 0 setrgbcolor
0.64324 0.61145 moveto
0.66456 0.61627 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51187 0.30845 moveto
0.52708 0.31274 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57769 0.32701 moveto
0.58369 0.32871 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61552 0.33768 moveto
0.67233 0.3537 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55251 0.31991 moveto
0.56768 0.32419 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56768 0.32419 moveto
0.57769 0.32701 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52708 0.31274 moveto
0.55251 0.31991 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.50917 0.30577 moveto
0.51187 0.30845 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.67784 0.46093 moveto
0.69842 0.44058 lineto
stroke
1 0 0 setrgbcolor
0.67323 0.48463 moveto
0.68558 0.50178 lineto
stroke
1 0 0 setrgbcolor
0.76113 0.27554 moveto
0.79255 0.30517 lineto
stroke
1 0 0 setrgbcolor
0.6265 0.62408 moveto
0.64324 0.61145 lineto
stroke
1 0 0 setrgbcolor
0.67323 0.48463 moveto
0.67784 0.46093 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50917 0.30577 moveto
0.52187 0.30639 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61123 0.31076 moveto
0.61766 0.31108 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63213 0.31179 moveto
0.69148 0.31469 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5674 0.30862 moveto
0.58284 0.30937 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58284 0.30937 moveto
0.60338 0.31038 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.60338 0.31038 moveto
0.61123 0.31076 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52187 0.30639 moveto
0.5674 0.30862 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.50575 0.30314 moveto
0.50917 0.30577 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.6306 0.67415 moveto
0.65592 0.69197 lineto
stroke
1 0 0 setrgbcolor
0.62463 0.82 moveto
0.66157 0.7799 lineto
stroke
1 0 0 setrgbcolor
0.62095 0.64803 moveto
0.6265 0.62408 lineto
stroke
1 0 0 setrgbcolor
0.62095 0.64803 moveto
0.6306 0.67415 lineto
stroke
0.51 0.864 0.989 setrgbcolor
0.49933 0.30156 moveto
0.69654 0.26973 lineto
0.50575 0.30314 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.58675 0.28896 moveto
0.61683 0.28369 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50575 0.30314 moveto
0.58675 0.28896 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68208 0.27226 moveto
0.69654 0.26973 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.61683 0.28369 moveto
0.68208 0.27226 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49933 0.30156 moveto
0.50575 0.30314 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.71793 0.26709 moveto
0.76113 0.27554 lineto
stroke
0.686 0.656 0.815 setrgbcolor
0.49933 0.30156 moveto
0.68279 0.23045 lineto
0.69654 0.26973 lineto
fill
0.638 0.919 0.977 setrgbcolor
0.48864 0.30221 moveto
0.68279 0.23045 lineto
0.49933 0.30156 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.52011 0.29351 moveto
0.68279 0.23045 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49933 0.30156 moveto
0.52011 0.29351 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.48864 0.30221 moveto
0.49933 0.30156 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.57964 0.84098 moveto
0.62463 0.82 lineto
stroke
0.708 0.745 0.88 setrgbcolor
0.48864 0.30221 moveto
0.65008 0.20849 lineto
0.68279 0.23045 lineto
fill
0.719 0.919 0.96 setrgbcolor
0.47373 0.30556 moveto
0.65008 0.20849 lineto
0.48864 0.30221 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.48864 0.30221 moveto
0.49261 0.29991 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5089 0.29045 moveto
0.65008 0.20849 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49261 0.29991 moveto
0.5089 0.29045 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47373 0.30556 moveto
0.48864 0.30221 lineto
stroke
0 0 0 setrgbcolor
0.29308 0.73328 moveto
0.29549 0.73528 lineto
stroke
0 0 0 setrgbcolor
0.29549 0.73528 moveto
0.29688 0.73643 lineto
stroke
0 0 0 setrgbcolor
0.29688 0.73643 moveto
0.29953 0.73864 lineto
stroke
0 0 0 setrgbcolor
0.29953 0.73864 moveto
0.30183 0.74056 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.64671 0.37827 moveto
0.67233 0.3537 lineto
stroke
1 0 0 setrgbcolor
0.67233 0.3537 moveto
0.69148 0.31469 lineto
stroke
1 0 0 setrgbcolor
0.67222 0.27984 moveto
0.68361 0.27666 lineto
stroke
1 0 0 setrgbcolor
0.69615 0.27317 moveto
0.70268 0.27135 lineto
stroke
1 0 0 setrgbcolor
0.70268 0.27135 moveto
0.71793 0.26709 lineto
stroke
0.73 0.88 0.95 setrgbcolor
0.47373 0.30556 moveto
0.60337 0.21135 lineto
0.65008 0.20849 lineto
fill
0.732 0.902 0.954 setrgbcolor
0.45565 0.31093 moveto
0.60337 0.21135 lineto
0.47373 0.30556 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.47373 0.30556 moveto
0.484 0.2981 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51797 0.27341 moveto
0.60337 0.21135 lineto
stroke
1 0 0 setrgbcolor
0.6231 0.38401 moveto
0.64671 0.37827 lineto
stroke
1 0 0 setrgbcolor
0.69148 0.31469 moveto
0.69641 0.27088 lineto
stroke
1 0 0 setrgbcolor
0.69641 0.27088 moveto
0.69654 0.26973 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.28958 0.72593 moveto
0.29308 0.73328 lineto
stroke
0.588 0.944 0.816 setrgbcolor
0.45565 0.31093 moveto
0.55159 0.23949 lineto
0.60337 0.21135 lineto
fill
0.376 0.841 0.824 setrgbcolor
0.43576 0.31703 moveto
0.45565 0.31093 lineto
0.50542 0.28608 lineto
fill
0 0 0 setrgbcolor
0.45565 0.31093 moveto
0.47373 0.30556 lineto
stroke
0 0 0 setrgbcolor
0.43576 0.31703 moveto
0.45565 0.31093 lineto
stroke
0.021 0 0 setrgbcolor
0.43576 0.31703 moveto
0.50542 0.28608 lineto
0.55159 0.23949 lineto
fill
0.305 0.105 0.435 setrgbcolor
0.41523 0.32303 moveto
0.46647 0.33711 lineto
0.50542 0.28608 lineto
fill
0.305 0.105 0.435 setrgbcolor
0.50542 0.28608 moveto
0.46647 0.33711 lineto
0.48396 0.32252 lineto
fill
0.339 0 0 setrgbcolor
0.46647 0.33711 moveto
0.43367 0.3281 lineto
0.46367 0.3379 lineto
fill
0.339 0 0 setrgbcolor
0.41523 0.32303 moveto
0.4333 0.32858 lineto
0.43367 0.3281 lineto
fill
0.339 0 0 setrgbcolor
0.46367 0.3379 moveto
0.43367 0.3281 lineto
0.4333 0.32858 lineto
fill
0.339 0 0 setrgbcolor
0.39491 0.32927 moveto
0.46015 0.33746 lineto
0.41523 0.32303 lineto
fill
0.339 0 0 setrgbcolor
0.41523 0.32303 moveto
0.46015 0.33746 lineto
0.46102 0.33709 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.43298 0.36098 moveto
0.44686 0.34897 lineto
0.39491 0.32927 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.46015 0.33746 moveto
0.4547 0.33677 lineto
0.44686 0.34897 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.39491 0.32927 moveto
0.44686 0.34897 lineto
0.4547 0.33677 lineto
fill
0.673 0.443 0.563 setrgbcolor
0.50915 0.41036 moveto
0.35027 0.3593 lineto
0.35925 0.34652 lineto
fill
0.673 0.443 0.563 setrgbcolor
0.34672 0.35817 moveto
0.35355 0.35182 lineto
0.35027 0.3593 lineto
fill
0.673 0.443 0.563 setrgbcolor
0.35925 0.34652 moveto
0.35027 0.3593 lineto
0.35355 0.35182 lineto
fill
0.678 0.418 0.522 setrgbcolor
0.44571 0.38997 moveto
0.42974 0.39035 lineto
0.34672 0.35817 lineto
fill
0.659 0.517 0.678 setrgbcolor
0.35675 0.37197 moveto
0.42958 0.39031 lineto
0.33879 0.37068 lineto
fill
0.659 0.517 0.678 setrgbcolor
0.50915 0.41036 moveto
0.43089 0.39213 lineto
0.42958 0.39031 lineto
fill
0.659 0.517 0.678 setrgbcolor
0.33879 0.37068 moveto
0.42958 0.39031 lineto
0.43089 0.39213 lineto
fill
0.678 0.418 0.522 setrgbcolor
0.34672 0.35817 moveto
0.42974 0.39035 lineto
0.40173 0.3833 lineto
fill
0.678 0.418 0.522 setrgbcolor
0.50915 0.41036 moveto
0.41779 0.39064 lineto
0.44571 0.38997 lineto
fill
0.67 0.436 0.558 setrgbcolor
0.37579 0.33682 moveto
0.44807 0.39221 lineto
0.35925 0.34652 lineto
fill
0.678 0.418 0.522 setrgbcolor
0.48772 0.42259 moveto
0.41779 0.39064 lineto
0.50915 0.41036 lineto
fill
0.67 0.436 0.558 setrgbcolor
0.48772 0.42259 moveto
0.4307 0.38883 lineto
0.44807 0.39221 lineto
fill
0.67 0.436 0.558 setrgbcolor
0.35925 0.34652 moveto
0.44807 0.39221 lineto
0.4307 0.38883 lineto
fill
0.659 0.517 0.678 setrgbcolor
0.43639 0.39203 moveto
0.44377 0.39137 lineto
0.50915 0.41036 lineto
fill
0.659 0.517 0.678 setrgbcolor
0.52549 0.38408 moveto
0.51263 0.40477 lineto
0.44377 0.39137 lineto
fill
0.659 0.517 0.678 setrgbcolor
0.50915 0.41036 moveto
0.44377 0.39137 lineto
0.51263 0.40477 lineto
fill
0.659 0.517 0.678 setrgbcolor
0.35675 0.37197 moveto
0.4072 0.37559 lineto
0.43639 0.39203 lineto
fill
0 0 0 setrgbcolor
0.4307 0.38883 moveto
0.40403 0.37366 lineto
0.40378 0.37351 lineto
fill
0.654 0.414 0.544 setrgbcolor
0.34672 0.35817 moveto
0.38844 0.36421 lineto
0.33879 0.37068 lineto
fill
0.567 0 0 setrgbcolor
0.39099 0.36531 moveto
0.4307 0.38883 lineto
0.39087 0.36617 lineto
fill
0.654 0.414 0.544 setrgbcolor
0.52549 0.38408 moveto
0.4072 0.37559 lineto
0.38844 0.36421 lineto
fill
0.654 0.414 0.544 setrgbcolor
0.33879 0.37068 moveto
0.38844 0.36421 lineto
0.4072 0.37559 lineto
fill
0.659 0.517 0.678 setrgbcolor
0.52549 0.38408 moveto
0.43639 0.39203 lineto
0.4072 0.37559 lineto
fill
0.609 0.36 0.514 setrgbcolor
0.39236 0.36547 moveto
0.41386 0.36337 lineto
0.38179 0.37549 lineto
fill
0.609 0.36 0.514 setrgbcolor
0.53004 0.35207 moveto
0.42165 0.36919 lineto
0.41386 0.36337 lineto
fill
0.609 0.36 0.514 setrgbcolor
0.38179 0.37549 moveto
0.41386 0.36337 lineto
0.42165 0.36919 lineto
fill
0.665 0.597 0.769 setrgbcolor
0.52549 0.38408 moveto
0.42749 0.3835 lineto
0.53004 0.35207 lineto
fill
0.567 0 0 setrgbcolor
0.43194 0.38956 moveto
0.42937 0.38834 lineto
0.39087 0.36617 lineto
fill
0.567 0 0 setrgbcolor
0.39087 0.36617 moveto
0.42937 0.38834 lineto
0.42476 0.38591 lineto
fill
0.665 0.597 0.769 setrgbcolor
0.42749 0.3835 moveto
0.4201 0.38346 lineto
0.42165 0.36919 lineto
fill
0.665 0.597 0.769 setrgbcolor
0.33452 0.38296 moveto
0.3996 0.37267 lineto
0.4201 0.38346 lineto
fill
0.567 0 0 setrgbcolor
0.39087 0.36617 moveto
0.41075 0.37775 lineto
0.40913 0.37752 lineto
fill
0.665 0.597 0.769 setrgbcolor
0.42165 0.36919 moveto
0.4201 0.38346 lineto
0.3996 0.37267 lineto
fill
0.665 0.597 0.769 setrgbcolor
0.53004 0.35207 moveto
0.42749 0.3835 lineto
0.42165 0.36919 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.42764 0.36599 moveto
0.41818 0.36067 lineto
0.42851 0.37669 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.40124 0.35114 moveto
0.42237 0.37093 lineto
0.41818 0.36067 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.42851 0.37669 moveto
0.41818 0.36067 lineto
0.42237 0.37093 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.42764 0.36599 moveto
0.44557 0.38705 lineto
0.46257 0.38564 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.4693 0.41492 moveto
0.46649 0.40267 lineto
0.44557 0.38705 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.46257 0.38564 moveto
0.44557 0.38705 lineto
0.46649 0.40267 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.43114 0.37341 moveto
0.42829 0.37403 lineto
0.44461 0.35246 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.41392 0.36867 moveto
0.42712 0.37969 lineto
0.40124 0.35114 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.40124 0.35114 moveto
0.42712 0.37969 lineto
0.42723 0.37936 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.42851 0.37669 moveto
0.42814 0.37635 lineto
0.42887 0.38115 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.40124 0.35114 moveto
0.42723 0.37936 lineto
0.42814 0.37635 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.42887 0.38115 moveto
0.42814 0.37635 lineto
0.42723 0.37936 lineto
fill
0.539 0.288 0.483 setrgbcolor
0.51816 0.32483 moveto
0.44461 0.35246 lineto
0.44113 0.34921 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.51816 0.32483 moveto
0.43114 0.37341 lineto
0.44461 0.35246 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.43298 0.36098 moveto
0.43849 0.36557 lineto
0.46015 0.33746 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.43114 0.37341 moveto
0.45232 0.36159 lineto
0.53004 0.35207 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.51816 0.32483 moveto
0.52828 0.34805 lineto
0.45232 0.36159 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.53004 0.35207 moveto
0.45232 0.36159 lineto
0.52828 0.34805 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.51816 0.32483 moveto
0.44769 0.35546 lineto
0.4925 0.31539 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.46257 0.38564 moveto
0.46036 0.34154 lineto
0.43849 0.36557 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.46015 0.33746 moveto
0.43849 0.36557 lineto
0.46036 0.34154 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.43248 0.36207 moveto
0.46392 0.33762 lineto
0.44094 0.35839 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.4925 0.31539 moveto
0.45785 0.34429 lineto
0.46392 0.33762 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.44094 0.35839 moveto
0.46392 0.33762 lineto
0.45785 0.34429 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.39394 0.3715 moveto
0.42707 0.35905 lineto
0.40833 0.37834 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.44461 0.35246 moveto
0.42753 0.36465 lineto
0.42707 0.35905 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.37579 0.33682 moveto
0.41392 0.36867 lineto
0.40124 0.35114 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.40833 0.37834 moveto
0.34306 0.39242 lineto
0.39394 0.3715 lineto
fill
0.576 0.256 0.39 setrgbcolor
0.37579 0.33682 moveto
0.42531 0.36468 lineto
0.39491 0.32927 lineto
fill
0.576 0.256 0.39 setrgbcolor
0.39491 0.32927 moveto
0.42531 0.36468 lineto
0.42612 0.36429 lineto
fill
0.576 0.256 0.39 setrgbcolor
0.39491 0.32927 moveto
0.42764 0.36599 lineto
0.43699 0.36432 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.43248 0.36207 moveto
0.3988 0.37671 lineto
0.43726 0.34633 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.3282 0.4074 moveto
0.36713 0.3856 lineto
0.3988 0.37671 lineto
fill
0.539 0.288 0.483 setrgbcolor
0.33175 0.39486 moveto
0.44113 0.34921 lineto
0.44461 0.35246 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.43726 0.34633 moveto
0.3988 0.37671 lineto
0.36713 0.3856 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.46015 0.33746 moveto
0.46036 0.34154 lineto
0.46367 0.3379 lineto
fill
0.339 0 0 setrgbcolor
0.46367 0.3379 moveto
0.46102 0.33709 lineto
0.46015 0.33746 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.4925 0.31539 moveto
0.43248 0.36207 lineto
0.43726 0.34633 lineto
fill
0.609 0.36 0.514 setrgbcolor
0.33452 0.38296 moveto
0.39236 0.36547 lineto
0.38179 0.37549 lineto
fill
0.539 0.288 0.483 setrgbcolor
0.33452 0.38296 moveto
0.3349 0.38283 lineto
0.33175 0.39486 lineto
fill
0.539 0.288 0.483 setrgbcolor
0.44113 0.34921 moveto
0.33175 0.39486 lineto
0.3349 0.38283 lineto
fill
0.296 0.065 0.384 setrgbcolor
0.3282 0.4074 moveto
0.32851 0.4072 lineto
0.32255 0.42177 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.43302 0.34657 moveto
0.43758 0.34528 lineto
0.3282 0.4074 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.3282 0.4074 moveto
0.43758 0.34528 lineto
0.43726 0.34633 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.33175 0.39486 moveto
0.33792 0.39254 lineto
0.34306 0.39242 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.39394 0.3715 moveto
0.34306 0.39242 lineto
0.33792 0.39254 lineto
fill
0.567 0 0 setrgbcolor
0.35925 0.34652 moveto
0.39099 0.36531 lineto
0.39087 0.36617 lineto
fill
0.609 0.36 0.514 setrgbcolor
0.33879 0.37068 moveto
0.39236 0.36547 lineto
0.33452 0.38296 lineto
fill
0.439 0.197 0.448 setrgbcolor
0.3282 0.4074 moveto
0.33175 0.39486 lineto
0.48897 0.31409 lineto
fill
0.296 0.065 0.384 setrgbcolor
0.44711 0.32933 moveto
0.3252 0.41981 lineto
0.32851 0.4072 lineto
fill
0.296 0.065 0.384 setrgbcolor
0.32255 0.42177 moveto
0.32851 0.4072 lineto
0.3252 0.41981 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.44073 0.34439 moveto
0.43726 0.34633 lineto
0.43758 0.34528 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.4693 0.41492 moveto
0.42851 0.37669 lineto
0.42887 0.38115 lineto
fill
0.576 0.256 0.39 setrgbcolor
0.42764 0.36599 moveto
0.42612 0.36429 lineto
0.42531 0.36468 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.40833 0.37834 moveto
0.42707 0.35905 lineto
0.42753 0.36465 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.40833 0.37834 moveto
0.42753 0.36465 lineto
0.42829 0.37403 lineto
fill
0.686 0.692 0.849 setrgbcolor
0.44461 0.35246 moveto
0.42829 0.37403 lineto
0.42753 0.36465 lineto
fill
0.309 0.39 0.784 setrgbcolor
0.4693 0.41492 moveto
0.42764 0.36599 lineto
0.42851 0.37669 lineto
fill
0.678 0.418 0.522 setrgbcolor
0.41779 0.39064 moveto
0.40173 0.3833 lineto
0.42974 0.39035 lineto
fill
0.09 0 0.234 setrgbcolor
0.40221 0.37258 moveto
0.30972 0.45173 lineto
0.3653 0.43602 lineto
fill
0.09 0 0.234 setrgbcolor
0.30449 0.45621 moveto
0.30831 0.45494 lineto
0.30972 0.45173 lineto
fill
0.09 0 0.234 setrgbcolor
0.3653 0.43602 moveto
0.30972 0.45173 lineto
0.30831 0.45494 lineto
fill
0.567 0 0 setrgbcolor
0.48772 0.42259 moveto
0.42695 0.38719 lineto
0.43194 0.38956 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.43868 0.34663 moveto
0.39426 0.37538 lineto
0.40358 0.36163 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.36826 0.39219 moveto
0.38864 0.37457 lineto
0.39426 0.37538 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.40358 0.36163 moveto
0.39426 0.37538 lineto
0.38864 0.37457 lineto
fill
0.567 0 0 setrgbcolor
0.4693 0.41492 moveto
0.40913 0.37752 lineto
0.48772 0.42259 lineto
fill
0.567 0 0 setrgbcolor
0.48772 0.42259 moveto
0.40913 0.37752 lineto
0.41075 0.37775 lineto
fill
0 0 0 setrgbcolor
0.4068 0.36247 moveto
0.38943 0.37676 lineto
0.3942 0.37859 lineto
fill
0 0 0 setrgbcolor
0.32175 0.4324 moveto
0.38861 0.38275 lineto
0.38943 0.37676 lineto
fill
0 0 0 setrgbcolor
0.3942 0.37859 moveto
0.38943 0.37676 lineto
0.38861 0.38275 lineto
fill
0 0 0 setrgbcolor
0.31454 0.43834 moveto
0.31912 0.4349 lineto
0.32175 0.4324 lineto
fill
0 0 0 setrgbcolor
0.3942 0.37859 moveto
0.32175 0.4324 lineto
0.31912 0.4349 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.32255 0.42177 moveto
0.35153 0.40027 lineto
0.36826 0.39219 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.40358 0.36163 moveto
0.36826 0.39219 lineto
0.35153 0.40027 lineto
fill
0.576 0.256 0.39 setrgbcolor
0.46257 0.38564 moveto
0.43699 0.36432 lineto
0.42764 0.36599 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.46036 0.34154 moveto
0.46171 0.36845 lineto
0.46367 0.3379 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.46257 0.38564 moveto
0.46294 0.3696 lineto
0.46171 0.36845 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.46367 0.3379 moveto
0.46171 0.36845 lineto
0.46294 0.3696 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.44094 0.35839 moveto
0.45785 0.34429 lineto
0.44769 0.35546 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.4925 0.31539 moveto
0.44769 0.35546 lineto
0.45785 0.34429 lineto
fill
0.376 0.289 0.628 setrgbcolor
0.47413 0.33921 moveto
0.46367 0.3379 lineto
0.46257 0.38564 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.48897 0.31409 moveto
0.44073 0.34439 lineto
0.43302 0.34657 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.44711 0.32933 moveto
0.4858 0.31525 lineto
0.43868 0.34663 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.48897 0.31409 moveto
0.4817 0.3188 lineto
0.4858 0.31525 lineto
fill
0.718 0.828 0.932 setrgbcolor
0.4925 0.31539 moveto
0.44073 0.34439 lineto
0.48897 0.31409 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.43868 0.34663 moveto
0.4858 0.31525 lineto
0.4817 0.3188 lineto
fill
0.687 0.973 0.916 setrgbcolor
0.44711 0.32933 moveto
0.43868 0.34663 lineto
0.40358 0.36163 lineto
fill
0 0 0 setrgbcolor
0.44711 0.32933 moveto
0.4068 0.36247 lineto
0.40221 0.37258 lineto
fill
0 0 0 setrgbcolor
0.40221 0.37258 moveto
0.4068 0.36247 lineto
0.3942 0.37859 lineto
fill
0.339 0 0 setrgbcolor
0.47413 0.33921 moveto
0.46647 0.33711 lineto
0.46367 0.3379 lineto
fill
0.305 0.105 0.435 setrgbcolor
0.47413 0.33921 moveto
0.48396 0.32252 lineto
0.46647 0.33711 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.46647 0.33711 moveto
0.47413 0.33921 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44208 0.33041 moveto
0.44447 0.33106 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41599 0.32324 moveto
0.43367 0.3281 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43367 0.3281 moveto
0.44208 0.33041 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41523 0.32303 moveto
0.41599 0.32324 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.39491 0.32927 moveto
0.41523 0.32303 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.60957 0.37066 moveto
0.6231 0.38401 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39491 0.32927 moveto
0.41402 0.34519 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41402 0.34519 moveto
0.41796 0.34847 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43849 0.36557 moveto
0.46257 0.38564 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43699 0.36432 moveto
0.43849 0.36557 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.37579 0.33682 moveto
0.39491 0.32927 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.53614 0.83721 moveto
0.57964 0.84098 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37937 0.33982 moveto
0.40204 0.35875 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37579 0.33682 moveto
0.37937 0.33982 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42887 0.38115 moveto
0.4693 0.41492 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42712 0.37969 moveto
0.42887 0.38115 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42533 0.37819 moveto
0.42712 0.37969 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.35925 0.34652 moveto
0.37579 0.33682 lineto
stroke
0 0 0 setrgbcolor
0.2885 0.71612 moveto
0.28907 0.72484 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.63435 0.30832 moveto
0.67222 0.27984 lineto
stroke
1 0 0 setrgbcolor
0.68279 0.23045 moveto
0.69654 0.26973 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4307 0.38883 moveto
0.456 0.40381 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46844 0.41117 moveto
0.48772 0.42259 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35925 0.34652 moveto
0.38936 0.36435 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.34672 0.35817 moveto
0.35925 0.34652 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.60957 0.37066 moveto
0.61246 0.34245 lineto
stroke
1 0 0 setrgbcolor
0.61246 0.34245 moveto
0.63435 0.30832 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.33879 0.37068 moveto
0.34672 0.35817 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.2908 0.71714 moveto
0.29298 0.7181 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29298 0.7181 moveto
0.29372 0.71842 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29372 0.71842 moveto
0.29555 0.71923 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29555 0.71923 moveto
0.30316 0.72257 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37976 0.75625 moveto
0.4472 0.7859 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33412 0.73618 moveto
0.37976 0.75625 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33253 0.73549 moveto
0.33412 0.73618 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29059 0.71705 moveto
0.2908 0.71714 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2885 0.71612 moveto
0.28958 0.7166 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28958 0.7166 moveto
0.29059 0.71705 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.2885 0.71612 moveto
0.28908 0.70745 lineto
stroke
0 0 0 setrgbcolor
0.33452 0.38296 moveto
0.33596 0.3788 lineto
stroke
0 0 0 setrgbcolor
0.33596 0.3788 moveto
0.33879 0.37068 lineto
stroke
0 0 0 setrgbcolor
0.28858 0.69838 moveto
0.28908 0.70745 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.50397 0.81039 moveto
0.53614 0.83721 lineto
stroke
1 0 0 setrgbcolor
0.65008 0.20849 moveto
0.68279 0.23045 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.33175 0.39486 moveto
0.33452 0.38296 lineto
stroke
0 0 0 setrgbcolor
0.28576 0.68707 moveto
0.28857 0.69816 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.47054 0.75357 moveto
0.47475 0.74037 lineto
stroke
1 0 0 setrgbcolor
0.47475 0.74037 moveto
0.48152 0.71909 lineto
stroke
1 0 0 setrgbcolor
0.4799 0.69266 moveto
0.48152 0.71909 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.3282 0.4074 moveto
0.33175 0.39486 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.48879 0.77036 moveto
0.50397 0.81039 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28747 0.68955 moveto
0.34697 0.77569 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28684 0.68864 moveto
0.28747 0.68955 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28576 0.68707 moveto
0.28684 0.68864 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.28071 0.67351 moveto
0.28576 0.68707 lineto
stroke
0.656 0.54 0.71 setrgbcolor
0.23713 0.57642 moveto
0.43126 0.55518 lineto
0.24191 0.59372 lineto
fill
0.639 0.524 0.707 setrgbcolor
0.24191 0.59372 moveto
0.24891 0.59151 lineto
0.24969 0.60985 lineto
fill
0.656 0.533 0.703 setrgbcolor
0.42348 0.5812 moveto
0.30931 0.57827 lineto
0.43126 0.55518 lineto
fill
0.656 0.533 0.703 setrgbcolor
0.43126 0.55518 moveto
0.30931 0.57827 lineto
0.31633 0.57455 lineto
fill
0.656 0.533 0.703 setrgbcolor
0.43126 0.55518 moveto
0.29621 0.57794 lineto
0.3386 0.56578 lineto
fill
0.656 0.533 0.703 setrgbcolor
0.24396 0.5766 moveto
0.3386 0.56578 lineto
0.29621 0.57794 lineto
fill
0.656 0.533 0.703 setrgbcolor
0.43126 0.55518 moveto
0.24396 0.5766 lineto
0.24366 0.57571 lineto
fill
0.657 0.543 0.714 setrgbcolor
0.23713 0.57642 moveto
0.23724 0.55811 lineto
0.43126 0.55518 lineto
fill
0.655 0.542 0.713 setrgbcolor
0.24288 0.53977 moveto
0.34593 0.56341 lineto
0.23724 0.55811 lineto
fill
0.655 0.542 0.713 setrgbcolor
0.42348 0.5812 moveto
0.31229 0.56741 lineto
0.34593 0.56341 lineto
fill
0.655 0.542 0.713 setrgbcolor
0.23724 0.55811 moveto
0.34593 0.56341 lineto
0.31229 0.56741 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.31953 0.56741 moveto
0.32429 0.56599 lineto
0.43126 0.55518 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.42538 0.53578 moveto
0.43069 0.55331 lineto
0.32429 0.56599 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.43126 0.55518 moveto
0.32429 0.56599 lineto
0.43069 0.55331 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.27866 0.56745 moveto
0.31938 0.56741 lineto
0.23713 0.57642 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.23713 0.57642 moveto
0.31938 0.56741 lineto
0.3194 0.56742 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.23724 0.55811 moveto
0.31229 0.56741 lineto
0.27144 0.56746 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.27866 0.56745 moveto
0.30241 0.56233 lineto
0.31953 0.56741 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.32299 0.56637 moveto
0.30431 0.5627 lineto
0.42538 0.53578 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.42538 0.53578 moveto
0.30431 0.5627 lineto
0.30403 0.56198 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.27144 0.56746 moveto
0.31555 0.57145 lineto
0.29902 0.57501 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.29718 0.5613 moveto
0.31711 0.56921 lineto
0.27484 0.55691 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.27484 0.55691 moveto
0.31711 0.56921 lineto
0.31012 0.56969 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.24421 0.59286 moveto
0.28202 0.57867 lineto
0.24891 0.59151 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.32625 0.56914 moveto
0.28266 0.56781 lineto
0.31229 0.56741 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.27144 0.56746 moveto
0.28123 0.56745 lineto
0.28266 0.56781 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.31229 0.56741 moveto
0.28266 0.56781 lineto
0.28123 0.56745 lineto
fill
0.639 0.524 0.707 setrgbcolor
0.24891 0.59151 moveto
0.30573 0.57356 lineto
0.25435 0.60789 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.42348 0.5812 moveto
0.32172 0.57201 lineto
0.32656 0.56918 lineto
fill
0.656 0.533 0.703 setrgbcolor
0.29621 0.57794 moveto
0.31633 0.57455 lineto
0.30931 0.57827 lineto
fill
0.639 0.524 0.707 setrgbcolor
0.25435 0.60789 moveto
0.30573 0.57356 lineto
0.3246 0.57827 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.40447 0.60385 moveto
0.31125 0.57835 lineto
0.42348 0.5812 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.42348 0.5812 moveto
0.31125 0.57835 lineto
0.3113 0.57829 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.42348 0.5812 moveto
0.31098 0.57828 lineto
0.31521 0.57581 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.42348 0.5812 moveto
0.29902 0.57501 lineto
0.31555 0.57145 lineto
fill
0.639 0.524 0.707 setrgbcolor
0.42538 0.53578 moveto
0.3246 0.57827 lineto
0.30573 0.57356 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.37941 0.61301 moveto
0.31884 0.58052 lineto
0.40447 0.60385 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.29902 0.57501 moveto
0.31521 0.57581 lineto
0.31098 0.57828 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.29996 0.57039 moveto
0.31932 0.57659 lineto
0.31884 0.58052 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.40447 0.60385 moveto
0.31884 0.58052 lineto
0.31932 0.57659 lineto
fill
0.234 0 0.261 setrgbcolor
0.33105 0.58028 moveto
0.31787 0.5885 lineto
0.34558 0.59605 lineto
fill
0.234 0 0.261 setrgbcolor
0.29505 0.60271 moveto
0.31647 0.59988 lineto
0.31787 0.5885 lineto
fill
0.234 0 0.261 setrgbcolor
0.34558 0.59605 moveto
0.31787 0.5885 lineto
0.31647 0.59988 lineto
fill
0.58 0.013 0 setrgbcolor
0.35588 0.60054 moveto
0.3353 0.58489 lineto
0.37941 0.61301 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.30573 0.57356 moveto
0.30589 0.56998 lineto
0.30985 0.56971 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.27144 0.56746 moveto
0.32656 0.56918 lineto
0.32172 0.57201 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.30573 0.57356 moveto
0.31205 0.56765 lineto
0.3109 0.57143 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.31012 0.56969 moveto
0.32103 0.57364 lineto
0.29996 0.57039 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.40447 0.60385 moveto
0.31773 0.57608 lineto
0.32103 0.57364 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.29996 0.57039 moveto
0.32103 0.57364 lineto
0.31773 0.57608 lineto
fill
0 0 0 setrgbcolor
0.28315 0.59454 moveto
0.30834 0.58302 lineto
0.28349 0.59434 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.31711 0.56921 moveto
0.32357 0.57177 lineto
0.31012 0.56969 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.40447 0.60385 moveto
0.32103 0.57364 lineto
0.32357 0.57177 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.30573 0.57356 moveto
0.31611 0.56928 lineto
0.3202 0.56899 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.31012 0.56969 moveto
0.32357 0.57177 lineto
0.32103 0.57364 lineto
fill
0.662 0.441 0.572 setrgbcolor
0.27144 0.56746 moveto
0.32625 0.56914 lineto
0.32613 0.56917 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.28202 0.57867 moveto
0.31213 0.56737 lineto
0.28404 0.57823 lineto
fill
0.637 0.519 0.702 setrgbcolor
0.25312 0.52242 moveto
0.33159 0.56464 lineto
0.24288 0.53977 lineto
fill
0.637 0.519 0.702 setrgbcolor
0.40447 0.60385 moveto
0.31711 0.56921 lineto
0.33159 0.56464 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.30241 0.56233 moveto
0.30403 0.56198 lineto
0.30431 0.5627 lineto
fill
0.658 0.657 0.837 setrgbcolor
0.31953 0.56741 moveto
0.30241 0.56233 lineto
0.32299 0.56637 lineto
fill
0.637 0.519 0.702 setrgbcolor
0.24288 0.53977 moveto
0.33159 0.56464 lineto
0.31711 0.56921 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.3202 0.56899 moveto
0.32689 0.56612 lineto
0.42538 0.53578 lineto
fill
0.604 0.472 0.674 setrgbcolor
0.26607 0.50626 moveto
0.32477 0.56155 lineto
0.25312 0.52242 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.32689 0.56612 moveto
0.39578 0.53655 lineto
0.42392 0.5355 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.42538 0.53578 moveto
0.32689 0.56612 lineto
0.42392 0.5355 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.4061 0.53212 moveto
0.40757 0.5324 lineto
0.39578 0.53655 lineto
fill
0 0 0 setrgbcolor
0.4061 0.53212 moveto
0.38088 0.54465 lineto
0.3774 0.55142 lineto
fill
0 0 0 setrgbcolor
0.3242 0.57282 moveto
0.33064 0.57023 lineto
0.38088 0.54465 lineto
fill
0 0 0 setrgbcolor
0.3774 0.55142 moveto
0.38088 0.54465 lineto
0.33064 0.57023 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.4061 0.53212 moveto
0.31891 0.56812 lineto
0.31522 0.56646 lineto
fill
0.604 0.472 0.674 setrgbcolor
0.32477 0.56155 moveto
0.33281 0.56913 lineto
0.3133 0.56559 lineto
fill
0.604 0.472 0.674 setrgbcolor
0.37941 0.61301 moveto
0.32428 0.57347 lineto
0.33281 0.56913 lineto
fill
0.604 0.472 0.674 setrgbcolor
0.3133 0.56559 moveto
0.33281 0.56913 lineto
0.32428 0.57347 lineto
fill
0.604 0.472 0.674 setrgbcolor
0.25312 0.52242 moveto
0.32477 0.56155 lineto
0.3133 0.56559 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.42392 0.5355 moveto
0.39578 0.53655 lineto
0.40757 0.5324 lineto
fill
0.58 0.013 0 setrgbcolor
0.29188 0.55023 moveto
0.3133 0.56559 lineto
0.27961 0.54255 lineto
fill
0 0 0 setrgbcolor
0.31381 0.57898 moveto
0.32439 0.57439 lineto
0.3179 0.57595 lineto
fill
0 0 0 setrgbcolor
0.3774 0.55142 moveto
0.32427 0.57333 lineto
0.32439 0.57439 lineto
fill
0 0 0 setrgbcolor
0.3179 0.57595 moveto
0.32439 0.57439 lineto
0.32427 0.57333 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.3109 0.57143 moveto
0.31522 0.56646 lineto
0.31891 0.56812 lineto
fill
0.58 0.013 0 setrgbcolor
0.3133 0.56559 moveto
0.32428 0.57347 lineto
0.31034 0.56425 lineto
fill
0.58 0.013 0 setrgbcolor
0.37941 0.61301 moveto
0.32436 0.57415 lineto
0.32428 0.57347 lineto
fill
0.58 0.013 0 setrgbcolor
0.31034 0.56425 moveto
0.32428 0.57347 lineto
0.32436 0.57415 lineto
fill
0.58 0.013 0 setrgbcolor
0.27961 0.54255 moveto
0.3133 0.56559 lineto
0.31034 0.56425 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.4061 0.53212 moveto
0.31522 0.56646 lineto
0.31493 0.56632 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.28404 0.57823 moveto
0.31213 0.56737 lineto
0.31205 0.56765 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.2936 0.53517 moveto
0.31507 0.5577 lineto
0.28906 0.52349 lineto
fill
0 0 0 setrgbcolor
0.3774 0.55142 moveto
0.3242 0.57282 lineto
0.32427 0.57333 lineto
fill
0 0 0 setrgbcolor
0.3774 0.55142 moveto
0.32685 0.57452 lineto
0.32693 0.57451 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.31507 0.5577 moveto
0.33055 0.57395 lineto
0.31602 0.55457 lineto
fill
0.58 0.013 0 setrgbcolor
0.37941 0.61301 moveto
0.35454 0.59716 lineto
0.32975 0.57887 lineto
fill
0.58 0.013 0 setrgbcolor
0.3353 0.58489 moveto
0.33105 0.58028 lineto
0.35454 0.59716 lineto
fill
0.58 0.013 0 setrgbcolor
0.32975 0.57887 moveto
0.35454 0.59716 lineto
0.33105 0.58028 lineto
fill
0.545 0.48 0.733 setrgbcolor
0.25836 0.62556 moveto
0.33105 0.58028 lineto
0.24969 0.60985 lineto
fill
0.545 0.48 0.733 setrgbcolor
0.3774 0.55142 moveto
0.32454 0.5756 lineto
0.33105 0.58028 lineto
fill
0.545 0.48 0.733 setrgbcolor
0.24969 0.60985 moveto
0.33105 0.58028 lineto
0.32454 0.5756 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.35588 0.60054 moveto
0.34047 0.58277 lineto
0.33844 0.58223 lineto
fill
0.58 0.013 0 setrgbcolor
0.37941 0.61301 moveto
0.3245 0.57526 lineto
0.32436 0.57415 lineto
fill
0.234 0 0.261 setrgbcolor
0.3479 0.59574 moveto
0.35412 0.5864 lineto
0.33105 0.58028 lineto
fill
0.234 0 0.261 setrgbcolor
0.3774 0.55142 moveto
0.33107 0.58027 lineto
0.35412 0.5864 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.33055 0.57395 moveto
0.33844 0.58223 lineto
0.33255 0.57364 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.33255 0.57364 moveto
0.33844 0.58223 lineto
0.34047 0.58277 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.31602 0.55457 moveto
0.33055 0.57395 lineto
0.33255 0.57364 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.28906 0.52349 moveto
0.31507 0.5577 lineto
0.31602 0.55457 lineto
fill
0.58 0.013 0 setrgbcolor
0.31034 0.56425 moveto
0.32436 0.57415 lineto
0.30494 0.56181 lineto
fill
0.58 0.013 0 setrgbcolor
0.30494 0.56181 moveto
0.32436 0.57415 lineto
0.3245 0.57526 lineto
fill
0 0 0 setrgbcolor
0.3179 0.57595 moveto
0.32427 0.57333 lineto
0.3242 0.57282 lineto
fill
0 0 0 setrgbcolor
0.29827 0.58571 moveto
0.31381 0.57898 lineto
0.3179 0.57595 lineto
fill
0 0 0 setrgbcolor
0.28349 0.59434 moveto
0.32454 0.5756 lineto
0.32454 0.57558 lineto
fill
0.58 0.013 0 setrgbcolor
0.3353 0.58489 moveto
0.32469 0.57682 lineto
0.32975 0.57887 lineto
fill
0.58 0.013 0 setrgbcolor
0.30494 0.56181 moveto
0.3245 0.57526 lineto
0.32469 0.57682 lineto
fill
0.58 0.013 0 setrgbcolor
0.32975 0.57887 moveto
0.32469 0.57682 lineto
0.3245 0.57526 lineto
fill
0.234 0 0.261 setrgbcolor
0.3479 0.59574 moveto
0.33105 0.58028 lineto
0.34558 0.59605 lineto
fill
0.234 0 0.261 setrgbcolor
0.25836 0.62556 moveto
0.28596 0.61637 lineto
0.29505 0.60271 lineto
fill
0.234 0 0.261 setrgbcolor
0.3479 0.59574 moveto
0.29505 0.60271 lineto
0.28596 0.61637 lineto
fill
0 0 0 setrgbcolor
0.25038 0.60954 moveto
0.28315 0.59454 lineto
0.2512 0.6091 lineto
fill
0 0 0 setrgbcolor
0.2512 0.6091 moveto
0.28315 0.59454 lineto
0.28349 0.59434 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.24891 0.59151 moveto
0.28202 0.57867 lineto
0.28404 0.57823 lineto
fill
0 0 0 setrgbcolor
0.2512 0.6091 moveto
0.28349 0.59434 lineto
0.29827 0.58571 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.4061 0.53212 moveto
0.3202 0.56899 lineto
0.31611 0.56928 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.31871 0.5457 moveto
0.33716 0.57293 lineto
0.34208 0.5632 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.35588 0.60054 moveto
0.34521 0.57168 lineto
0.33716 0.57293 lineto
fill
0 0 0 setrgbcolor
0.3774 0.55142 moveto
0.32255 0.57519 lineto
0.32685 0.57452 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.34208 0.5632 moveto
0.33716 0.57293 lineto
0.34521 0.57168 lineto
fill
0 0 0 setrgbcolor
0.28349 0.59434 moveto
0.32685 0.57452 lineto
0.29827 0.58571 lineto
fill
0 0 0 setrgbcolor
0.29827 0.58571 moveto
0.32685 0.57452 lineto
0.32255 0.57519 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.31205 0.56765 moveto
0.31522 0.56646 lineto
0.3109 0.57143 lineto
fill
0.58 0.013 0 setrgbcolor
0.27961 0.54255 moveto
0.31034 0.56425 lineto
0.30494 0.56181 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.28404 0.57823 moveto
0.30589 0.56998 lineto
0.30573 0.57356 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.31205 0.56765 moveto
0.30985 0.56971 lineto
0.30589 0.56998 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.28906 0.52349 moveto
0.31602 0.55457 lineto
0.31871 0.5457 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.35588 0.60054 moveto
0.31871 0.5457 lineto
0.31602 0.55457 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.27484 0.55691 moveto
0.31012 0.56969 lineto
0.29996 0.57039 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.24891 0.59151 moveto
0.28404 0.57823 lineto
0.30573 0.57356 lineto
fill
0.069 0.271 0.76 setrgbcolor
0.26607 0.50626 moveto
0.2936 0.53517 lineto
0.28906 0.52349 lineto
fill
0.696 0.333 0.354 setrgbcolor
0.24288 0.53977 moveto
0.29718 0.5613 lineto
0.27484 0.55691 lineto
fill
0.58 0.013 0 setrgbcolor
0.25312 0.52242 moveto
0.29188 0.55023 lineto
0.27961 0.54255 lineto
fill
0.628 0.881 0.987 setrgbcolor
0.24191 0.59372 moveto
0.24421 0.59286 lineto
0.24891 0.59151 lineto
fill
0.639 0.524 0.707 setrgbcolor
0.24969 0.60985 moveto
0.24891 0.59151 lineto
0.25435 0.60789 lineto
fill
0.656 0.533 0.703 setrgbcolor
0.23713 0.57642 moveto
0.24366 0.57571 lineto
0.24396 0.5766 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.37047 0.56183 moveto
0.43126 0.55518 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.23713 0.57642 moveto
0.24366 0.57571 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.24366 0.57571 moveto
0.28503 0.57118 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.23713 0.57642 moveto
0.23724 0.55811 lineto
stroke
0 0 0 setrgbcolor
0.23713 0.57642 moveto
0.24191 0.59372 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.4472 0.7859 moveto
0.47054 0.75357 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.34212 0.56207 moveto
0.35229 0.55886 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37876 0.5505 moveto
0.42538 0.53578 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30573 0.57356 moveto
0.30582 0.57354 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.24891 0.59151 moveto
0.30017 0.57532 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.24191 0.59372 moveto
0.24891 0.59151 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.24191 0.59372 moveto
0.24969 0.60985 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.3626 0.57365 moveto
0.42348 0.5812 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.23724 0.55811 moveto
0.28904 0.56453 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.23724 0.55811 moveto
0.24288 0.53977 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.29718 0.5613 moveto
0.312 0.56718 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35544 0.58441 moveto
0.40447 0.60385 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.24288 0.53977 moveto
0.28864 0.55791 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28864 0.55791 moveto
0.29718 0.5613 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.24288 0.53977 moveto
0.25312 0.52242 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.38088 0.54465 moveto
0.4061 0.53212 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3179 0.57595 moveto
0.31804 0.57588 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31804 0.57588 moveto
0.32131 0.57426 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.34231 0.56382 moveto
0.38088 0.54465 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29827 0.58571 moveto
0.31397 0.57791 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2512 0.6091 moveto
0.29827 0.58571 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.24969 0.60985 moveto
0.2512 0.6091 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.32255 0.42177 moveto
0.3282 0.4074 lineto
stroke
0 0.05 0.614 setrgbcolor
0.27415 0.65794 moveto
0.28071 0.67351 lineto
0.3283 0.72369 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.28071 0.67351 moveto
0.28276 0.67566 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.28276 0.67566 moveto
0.3283 0.72369 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.27415 0.65794 moveto
0.28071 0.67351 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.33105 0.58028 moveto
0.33107 0.58027 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33107 0.58027 moveto
0.33452 0.57812 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.34515 0.57151 moveto
0.3774 0.55142 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31787 0.5885 moveto
0.33005 0.5809 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29505 0.60271 moveto
0.30159 0.59863 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30159 0.59863 moveto
0.31787 0.5885 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.25836 0.62556 moveto
0.29505 0.60271 lineto
stroke
0.426 0.424 0.753 setrgbcolor
0.25836 0.62556 moveto
0.26664 0.64162 lineto
0.3479 0.59574 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.24969 0.60985 moveto
0.25836 0.62556 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.3133 0.56559 moveto
0.32428 0.57347 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29188 0.55023 moveto
0.29274 0.55084 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29274 0.55084 moveto
0.31126 0.56413 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31126 0.56413 moveto
0.3133 0.56559 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.32618 0.57483 moveto
0.3262 0.57484 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35366 0.59454 moveto
0.37941 0.61301 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.25312 0.52242 moveto
0.29188 0.55023 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.25312 0.52242 moveto
0.26607 0.50626 lineto
stroke
0.267 0.109 0.472 setrgbcolor
0.26664 0.64162 moveto
0.32881 0.6582 lineto
0.3479 0.59574 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.26664 0.64162 moveto
0.26708 0.64137 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.26708 0.64137 moveto
0.29531 0.62543 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29531 0.62543 moveto
0.32137 0.61072 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.32137 0.61072 moveto
0.34626 0.59667 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.34626 0.59667 moveto
0.3479 0.59574 lineto
stroke
0.165 0.282 0.738 setrgbcolor
0.26664 0.64162 moveto
0.27415 0.65794 lineto
0.32881 0.6582 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.25836 0.62556 moveto
0.26664 0.64162 lineto
stroke
0 0 0 setrgbcolor
0.26664 0.64162 moveto
0.27415 0.65794 lineto
stroke
0.172 0.149 0.589 setrgbcolor
0.27415 0.65794 moveto
0.3283 0.72369 lineto
0.32881 0.6582 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.27415 0.65794 moveto
0.32881 0.6582 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31507 0.5577 moveto
0.33055 0.57395 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33055 0.57395 moveto
0.33844 0.58223 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2936 0.53517 moveto
0.29971 0.54158 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29971 0.54158 moveto
0.31507 0.5577 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3493 0.59363 moveto
0.35588 0.60054 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.26607 0.50626 moveto
0.2936 0.53517 lineto
stroke
0.451 0.263 0.533 setrgbcolor
0.26607 0.50626 moveto
0.34208 0.5632 lineto
0.27974 0.49047 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.26607 0.50626 moveto
0.27974 0.49047 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.60337 0.21135 moveto
0.65008 0.20849 lineto
stroke
0.317 0.097 0.413 setrgbcolor
0.31454 0.43834 moveto
0.44711 0.32933 lineto
0.32255 0.42177 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.32255 0.42177 moveto
0.32456 0.42028 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33111 0.41542 moveto
0.35153 0.40027 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.32456 0.42028 moveto
0.33111 0.41542 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35153 0.40027 moveto
0.40358 0.36163 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40358 0.36163 moveto
0.44711 0.32933 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.31454 0.43834 moveto
0.32255 0.42177 lineto
stroke
0.278 0.056 0.385 setrgbcolor
0.27974 0.49047 moveto
0.34437 0.50475 lineto
0.29277 0.47389 lineto
fill
0.224 0.216 0.639 setrgbcolor
0.27974 0.49047 moveto
0.34208 0.5632 lineto
0.34437 0.50475 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.27974 0.49047 moveto
0.29414 0.50727 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29414 0.50727 moveto
0.30111 0.5154 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30111 0.5154 moveto
0.32466 0.54288 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.32466 0.54288 moveto
0.34208 0.5632 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.27974 0.49047 moveto
0.29277 0.47389 lineto
stroke
0.135 0 0.293 setrgbcolor
0.30449 0.45621 moveto
0.40221 0.37258 lineto
0.31454 0.43834 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.31454 0.43834 moveto
0.3146 0.43829 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.3146 0.43829 moveto
0.31689 0.43657 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31689 0.43657 moveto
0.31968 0.43448 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.31968 0.43448 moveto
0.40221 0.37258 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.30449 0.45621 moveto
0.31454 0.43834 lineto
stroke
0.095 0 0.248 setrgbcolor
0.29277 0.47389 moveto
0.3653 0.43602 lineto
0.30449 0.45621 lineto
fill
0.213 0.089 0.485 setrgbcolor
0.29277 0.47389 moveto
0.34437 0.50475 lineto
0.3653 0.43602 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.29277 0.47389 moveto
0.34437 0.50475 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.29277 0.47389 moveto
0.30449 0.45621 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.30616 0.45565 moveto
0.3653 0.43602 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30449 0.45621 moveto
0.30616 0.45565 lineto
stroke
1 0 0 setrgbcolor
0.41467 0.8055 moveto
0.4472 0.7859 lineto
stroke
1 0 0 setrgbcolor
0.48772 0.42259 moveto
0.50915 0.41036 lineto
stroke
1 0 0 setrgbcolor
0.50915 0.41036 moveto
0.52549 0.38408 lineto
stroke
1 0 0 setrgbcolor
0.52549 0.38408 moveto
0.53004 0.35207 lineto
stroke
1 0 0 setrgbcolor
0.4693 0.41492 moveto
0.48772 0.42259 lineto
stroke
1 0 0 setrgbcolor
0.51816 0.32483 moveto
0.53004 0.35207 lineto
stroke
1 0 0 setrgbcolor
0.55159 0.23949 moveto
0.60337 0.21135 lineto
stroke
1 0 0 setrgbcolor
0.46257 0.38564 moveto
0.4693 0.41492 lineto
stroke
1 0 0 setrgbcolor
0.40447 0.60385 moveto
0.42348 0.5812 lineto
stroke
1 0 0 setrgbcolor
0.42348 0.5812 moveto
0.43126 0.55518 lineto
stroke
1 0 0 setrgbcolor
0.42538 0.53578 moveto
0.43126 0.55518 lineto
stroke
1 0 0 setrgbcolor
0.37866 0.80365 moveto
0.41467 0.8055 lineto
stroke
1 0 0 setrgbcolor
0.48897 0.31409 moveto
0.4925 0.31539 lineto
stroke
1 0 0 setrgbcolor
0.4925 0.31539 moveto
0.51816 0.32483 lineto
stroke
1 0 0 setrgbcolor
0.37941 0.61301 moveto
0.40447 0.60385 lineto
stroke
1 0 0 setrgbcolor
0.4061 0.53212 moveto
0.42538 0.53578 lineto
stroke
1 0 0 setrgbcolor
0.46257 0.38564 moveto
0.47413 0.33921 lineto
stroke
1 0 0 setrgbcolor
0.50542 0.28608 moveto
0.55159 0.23949 lineto
stroke
1 0 0 setrgbcolor
0.47413 0.33921 moveto
0.48396 0.32252 lineto
stroke
1 0 0 setrgbcolor
0.50411 0.28829 moveto
0.50542 0.28608 lineto
stroke
1 0 0 setrgbcolor
0.48891 0.31412 moveto
0.50411 0.28829 lineto
stroke
1 0 0 setrgbcolor
0.35588 0.60054 moveto
0.37941 0.61301 lineto
stroke
1 0 0 setrgbcolor
0.3774 0.55142 moveto
0.4061 0.53212 lineto
stroke
1 0 0 setrgbcolor
0.34697 0.77569 moveto
0.37866 0.80365 lineto
stroke
1 0 0 setrgbcolor
0.44711 0.32933 moveto
0.48897 0.31409 lineto
stroke
1 0 0 setrgbcolor
0.34208 0.5632 moveto
0.35027 0.58538 lineto
stroke
1 0 0 setrgbcolor
0.35189 0.58975 moveto
0.35588 0.60054 lineto
stroke
1 0 0 setrgbcolor
0.3479 0.59574 moveto
0.35412 0.5864 lineto
stroke
1 0 0 setrgbcolor
0.35412 0.5864 moveto
0.3774 0.55142 lineto
stroke
1 0 0 setrgbcolor
0.3283 0.72369 moveto
0.34697 0.77569 lineto
stroke
1 0 0 setrgbcolor
0.40221 0.37258 moveto
0.44711 0.32933 lineto
stroke
1 0 0 setrgbcolor
0.32881 0.6582 moveto
0.3479 0.59574 lineto
stroke
1 0 0 setrgbcolor
0.34208 0.5632 moveto
0.34437 0.50475 lineto
stroke
1 0 0 setrgbcolor
0.3283 0.72369 moveto
0.32881 0.6582 lineto
stroke
1 0 0 setrgbcolor
0.3653 0.43602 moveto
0.40221 0.37258 lineto
stroke
1 0 0 setrgbcolor
0.34437 0.50475 moveto
0.3653 0.43602 lineto
stroke
0 setgray
0.002 setlinewidth
0.15373 0.23881 moveto
0.67491 0.02381 lineto
stroke
0.15373 0.23881 moveto
0.05551 0.72566 lineto
stroke
0.7189 0.53256 moveto
0.05551 0.72566 lineto
stroke
0.7189 0.53256 moveto
0.67491 0.02381 lineto
stroke
0.86852 0.40728 moveto
0.94449 0.86754 lineto
stroke
0.86852 0.40728 moveto
0.67491 0.02381 lineto
stroke
0.7189 0.53256 moveto
0.67491 0.02381 lineto
stroke
0.7189 0.53256 moveto
0.94449 0.86754 lineto
stroke
0.41005 0.97619 moveto
0.05551 0.72566 lineto
stroke
0.41005 0.97619 moveto
0.94449 0.86754 lineto
stroke
0.7189 0.53256 moveto
0.94449 0.86754 lineto
stroke
0.7189 0.53256 moveto
0.05551 0.72566 lineto
stroke
% End of Graphics
Mpend % End of picture
:[inactive; output; font = output; ]
Graphics3D[{{{Thickness[0.006], Line[{{0., 0., 0.}, {0.451604, 0., 0.}, 
                  {0.890357, 0.106967, 0.}, {1.30548, 0.284573, 0.00852737}, 
                  {1.70999, 0.484669, 0.0252664}, 
                  {2.12481, 0.663198, 0.0264437}, 
                  {2.55407, 0.792018, -0.0290916}, 
                  {2.97593, 0.860737, -0.174895}, 
                  {3.35779, 0.869915, -0.415813}, 
                  {3.68133, 0.824641, -0.727616}, {3.95711, 0.736209, -1.07413}, 
                  {4.21787, 0.630519, -1.42737}, {4.4933, 0.551645, -1.77646}, 
                  {4.78615, 0.549195, -2.12023}, {5.072, 0.655612, -2.45326}, 
                  {5.32187, 0.872571, -2.76058}, {5.52597, 1.17528, -3.02639}, 
                  {5.69957, 1.52693, -3.25034}, {5.86696, 1.89129, -3.45812}, 
                  {6.03593, 2.23758, -3.69364}, {6.18621, 2.53982, -3.99366}, 
                  {6.28424, 2.77644, -4.36562}, {6.30998, 2.93337, -4.78829}, 
                  {6.27179, 3.01013, -5.23168}, {6.19952, 3.02653, -5.67717}, 
                  {6.12189, 3.02458, -6.12204}, {6.04533, 3.05803, -6.56585}, 
                  {5.95283, 3.1703, -6.99339}, {5.82357, 3.3765, -7.37381}, 
                  {5.65374, 3.66408, -7.67778}, {5.45993, 4.00745, -7.89796}, 
                  {5.26389, 4.38144, -8.05812}, {5.07127, 4.76306, -8.20375}, 
                  {4.86304, 5.12437, -8.37707}, {4.61003, 5.42954, -8.59342}, 
                  {4.29774, 5.64416, -8.8391}, {3.93792, 5.75027, -9.09052}, 
                  {3.55834, 5.75622, -9.33512}, {3.18112, 5.69686, -9.57623}, 
                  {2.80718, 5.62355, -9.81858}, {2.42018, 5.58583, -10.0483}, 
                  {2.00733, 5.61328, -10.2292}, {1.57638, 5.71026, -10.3231}, 
                  {1.1524, 5.86555, -10.3143}, {0.758389, 6.06481, -10.2194}, 
                  {0.395667, 6.29364, -10.078}, {0.0401177, 6.52944, -9.92986}, 
                  {-0.33974, 6.73392, -9.7963}, {-0.75628, 6.86076, -9.67649}, 
                  {-1.19276, 6.87586, -9.5616}, {-1.6183, 6.77345, -9.45036}, 
                  {-2.01275, 6.57696, -9.35161}, {-2.38097, 6.3281, -9.27146}, 
                  {-2.74529, 6.07203, -9.1963}, {-3.12081, 5.84506, -9.08948}, 
                  {-3.49618, 5.66915, -8.9103}, {-3.83913, 5.55404, -8.63996}, 
                  {-4.12119, 5.50214, -8.29112}, {-4.3394, 5.50926, -7.8958}, 
                  {-4.51905, 5.55861, -7.48441}, {-4.69495, 5.61405, -7.07218}, 
                  {-4.88426, 5.62488, -6.66232}, {-5.07416, 5.54596, -6.26026}, 
                  {-5.23599, 5.35834, -5.88269}, {-5.35109, 5.07359, -5.5516}, 
                  {-5.42535, 4.72196, -5.27813}, {-5.48188, 4.33744, -5.04815}, 
                  {-5.53797, 3.95043, -4.82226}, {-5.58555, 3.58902, -4.55567}, 
                  {-5.59485, 3.28118, -4.22539}, {-5.53858, 3.05132, -3.84075}, 
                  {-5.41349, 2.91228, -3.4297}, {-5.24197, 2.85711, -3.01559}, 
                  {-5.05448, 2.85473, -2.60475}, {-4.86688, 2.85474, -2.19396}, 
                  {-4.67092, 2.80495, -1.79014}, {-4.447, 2.6733, -1.42072}, 
                  {-4.18616, 2.45735, -1.12193}, {-3.90014, 2.17521, -0.915677}, 
                  {-3.61167, 1.84994, -0.793483}, {-3.33396, 1.5019, -0.718069}}]
              }}, {{Thickness[0.003], RGBColor[1, 0, 0], 
              Line[{{0., 4, 0.}, {-0.489646, 3.86078, 0.456539}, 
                  {-0.625144, 3.58887, 1.25682}, {-0.253885, 3.25468, 2.18725}, 
                  {0.64114, 2.94863, 2.98946}, {1.93835, 2.75275, 3.43218}, 
                  {3.41165, 2.72789, 3.36457}, {4.77483, 2.90609, 2.75435}, 
                  {5.74563, 3.27105, 1.71322}, {6.1372, 3.74075, 0.482759}, 
                  {5.93901, 4.1838, -0.642614}, {5.32141, 4.47528, -1.4254}, 
                  {4.55309, 4.55113, -1.75403}, {3.90326, 4.42098, -1.64085}, 
                  {3.58866, 4.14988, -1.1924}, {3.74753, 3.84043, -0.589569}, 
                  {4.40603, 3.61614, -0.0619404}, {5.45385, 3.58923, 0.168216}, 
                  {6.66812, 3.82042, -0.0468733}, {7.77728, 4.30122, -0.742524}, 
                  {8.52345, 4.9644, -1.83526}, {8.71869, 5.70064, -3.13171}, 
                  {8.30716, 6.37312, -4.3648}, {7.40882, 6.84488, -5.27496}, 
                  {6.29406, 7.02527, -5.7112}, {5.27945, 6.91022, -5.6838}, 
                  {4.61301, 6.58257, -5.33049}, {4.42257, 6.17662, -4.8439}, 
                  {4.71717, 5.84107, -4.42393}, {5.39306, 5.71334, -4.25249}, 
                  {6.24135, 5.89078, -4.45667}, {6.99166, 6.39571, -5.0652}, 
                  {7.39165, 7.15934, -5.99611}, {7.27471, 8.04135, -7.08283}, 
                  {6.59357, 8.86927, -8.10985}, {5.43846, 9.47803, -8.85359}, 
                  {4.03703, 9.74865, -9.14704}, {2.70309, 9.64515, -8.95461}, 
                  {1.72669, 9.23314, -8.40177}, {1.26535, 8.65922, -7.71918}, 
                  {1.31283, 8.09991, -7.14082}, {1.74062, 7.71401, -6.83574}, 
                  {2.34615, 7.61602, -6.89159}, {2.88364, 7.85841, -7.30906}, 
                  {3.10862, 8.41289, -7.99166}, {2.84882, 9.16537, -8.76067}, 
                  {2.0605, 9.94212, -9.40871}, {0.83585, 10.5571, -9.7564}, 
                  {-0.620347, 10.8584, -9.68571}, {-2.02667, 10.7681, -9.16825}, 
                  {-3.09055, 10.309, -8.29607}, {-3.60801, 9.60446, -7.28053}, 
                  {-3.54999, 8.83852, -6.38508}, {-3.06569, 8.19157, -5.81919}, 
                  {-2.40096, 7.79184, -5.67014}, {-1.80954, 7.70067, -5.9056}, 
                  {-1.50764, 7.91288, -6.40389}, {-1.64572, 8.35568, -6.97607}, 
                  {-2.26835, 8.89488, -7.39752}, {-3.28655, 9.36397, -7.47028}, 
                  {-4.50015, 9.60927, -7.08779}, {-5.65403, 9.52938, -6.25942}, 
                  {-6.49231, 9.10197, -5.10111}, {-6.81499, 8.39817, -3.8172}, 
                  {-6.54804, 7.57101, -2.66539}, {-5.79456, 6.8062, -1.88408}, 
                  {-4.81079, 6.25226, -1.60097}, {-3.90083, 5.97486, -1.78557}, 
                  {-3.30584, 5.9611, -2.28056}, {-3.15666, 6.14751, -2.86916}, 
                  {-3.47288, 6.43746, -3.32406}, {-4.16235, 6.71156, -3.44176}, 
                  {-5.02623, 6.85058, -3.09086}, {-5.80464, 6.7688, -2.26229}, 
                  {-6.25459, 6.43674, -1.07883}, {-6.21125, 5.88695, 0.241759}, 
                  {-5.61944, 5.21307, 1.43847}, {-4.55681, 4.55612, 2.263}, 
                  {-3.23998, 4.06222, 2.54891}, {-1.97552, 3.82117, 2.27853}, 
                  {-1.04948, 3.82714, 1.60021}}]}}, 
        {{RGBColor[1, 1, 0], EdgeForm[], 
              {Polygon[{{0., 0., 0.}, {0., 4, 0.}, 
                     {-0.489646, 3.86078, 0.456539}, {0.451604, 0., 0.}}], 
                 Polygon[{{0.451604, 0., 0.}, {-0.489646, 3.86078, 0.456539}, 
                     {-0.625144, 3.58887, 1.25682}, {0.890357, 0.106967, 0.}}], 
                 Polygon[{{0.890357, 0.106967, 0.}, 
                     {-0.625144, 3.58887, 1.25682}, 
                     {-0.253885, 3.25468, 2.18725}, 
                     {1.30548, 0.284573, 0.00852737}}], 
                 Polygon[{{1.30548, 0.284573, 0.00852737}, 
                     {-0.253885, 3.25468, 2.18725}, {0.64114, 2.94863, 2.98946}, 
                     {1.70999, 0.484669, 0.0252664}}], 
                 Polygon[{{1.70999, 0.484669, 0.0252664}, 
                     {0.64114, 2.94863, 2.98946}, {1.93835, 2.75275, 3.43218}, 
                     {2.12481, 0.663198, 0.0264437}}], 
                 Polygon[{{2.12481, 0.663198, 0.0264437}, 
                     {1.93835, 2.75275, 3.43218}, {3.41165, 2.72789, 3.36457}, 
                     {2.55407, 0.792018, -0.0290916}}], 
                 Polygon[{{2.55407, 0.792018, -0.0290916}, 
                     {3.41165, 2.72789, 3.36457}, {4.77483, 2.90609, 2.75435}, 
                     {2.97593, 0.860737, -0.174895}}], 
                 Polygon[{{2.97593, 0.860737, -0.174895}, 
                     {4.77483, 2.90609, 2.75435}, {5.74563, 3.27105, 1.71322}, 
                     {3.35779, 0.869915, -0.415813}}], 
                 Polygon[{{3.35779, 0.869915, -0.415813}, 
                     {5.74563, 3.27105, 1.71322}, {6.1372, 3.74075, 0.482759}, 
                     {3.68133, 0.824641, -0.727616}}], 
                 Polygon[{{3.68133, 0.824641, -0.727616}, 
                     {6.1372, 3.74075, 0.482759}, {5.93901, 4.1838, -0.642614}, 
                     {3.95711, 0.736209, -1.07413}}], 
                 Polygon[{{3.95711, 0.736209, -1.07413}, 
                     {5.93901, 4.1838, -0.642614}, {5.32141, 4.47528, -1.4254}, 
                     {4.21787, 0.630519, -1.42737}}], 
                 Polygon[{{4.21787, 0.630519, -1.42737}, 
                     {5.32141, 4.47528, -1.4254}, {4.55309, 4.55113, -1.75403}, 
                     {4.4933, 0.551645, -1.77646}}], 
                 Polygon[{{4.4933, 0.551645, -1.77646}, 
                     {4.55309, 4.55113, -1.75403}, {3.90326, 4.42098, -1.64085}, 
                     {4.78615, 0.549195, -2.12023}}], 
                 Polygon[{{4.78615, 0.549195, -2.12023}, 
                     {3.90326, 4.42098, -1.64085}, {3.58866, 4.14988, -1.1924}, 
                     {5.072, 0.655612, -2.45326}}], 
                 Polygon[{{5.072, 0.655612, -2.45326}, 
                     {3.58866, 4.14988, -1.1924}, {3.74753, 3.84043, -0.589569}, 
                     {5.32187, 0.872571, -2.76058}}], 
                 Polygon[{{5.32187, 0.872571, -2.76058}, 
                     {3.74753, 3.84043, -0.589569}, 
                     {4.40603, 3.61614, -0.0619404}, 
                     {5.52597, 1.17528, -3.02639}}], 
                 Polygon[{{5.52597, 1.17528, -3.02639}, 
                     {4.40603, 3.61614, -0.0619404}, 
                     {5.45385, 3.58923, 0.168216}, {5.69957, 1.52693, -3.25034}}]\
                 , Polygon[{{5.69957, 1.52693, -3.25034}, 
                     {5.45385, 3.58923, 0.168216}, 
                     {6.66812, 3.82042, -0.0468733}, 
                     {5.86696, 1.89129, -3.45812}}], 
                 Polygon[{{5.86696, 1.89129, -3.45812}, 
                     {6.66812, 3.82042, -0.0468733}, 
                     {7.77728, 4.30122, -0.742524}, {6.03593, 2.23758, -3.69364}}
                    ], Polygon[{{6.03593, 2.23758, -3.69364}, 
                     {7.77728, 4.30122, -0.742524}, {8.52345, 4.9644, -1.83526}, 
                     {6.18621, 2.53982, -3.99366}}], 
                 Polygon[{{6.18621, 2.53982, -3.99366}, 
                     {8.52345, 4.9644, -1.83526}, {8.71869, 5.70064, -3.13171}, 
                     {6.28424, 2.77644, -4.36562}}], 
                 Polygon[{{6.28424, 2.77644, -4.36562}, 
                     {8.71869, 5.70064, -3.13171}, {8.30716, 6.37312, -4.3648}, 
                     {6.30998, 2.93337, -4.78829}}], 
                 Polygon[{{6.30998, 2.93337, -4.78829}, 
                     {8.30716, 6.37312, -4.3648}, {7.40882, 6.84488, -5.27496}, 
                     {6.27179, 3.01013, -5.23168}}], 
                 Polygon[{{6.27179, 3.01013, -5.23168}, 
                     {7.40882, 6.84488, -5.27496}, {6.29406, 7.02527, -5.7112}, 
                     {6.19952, 3.02653, -5.67717}}], 
                 Polygon[{{6.19952, 3.02653, -5.67717}, 
                     {6.29406, 7.02527, -5.7112}, {5.27945, 6.91022, -5.6838}, 
                     {6.12189, 3.02458, -6.12204}}], 
                 Polygon[{{6.12189, 3.02458, -6.12204}, 
                     {5.27945, 6.91022, -5.6838}, {4.61301, 6.58257, -5.33049}, 
                     {6.04533, 3.05803, -6.56585}}], 
                 Polygon[{{6.04533, 3.05803, -6.56585}, 
                     {4.61301, 6.58257, -5.33049}, {4.42257, 6.17662, -4.8439}, 
                     {5.95283, 3.1703, -6.99339}}], 
                 Polygon[{{5.95283, 3.1703, -6.99339}, 
                     {4.42257, 6.17662, -4.8439}, {4.71717, 5.84107, -4.42393}, 
                     {5.82357, 3.3765, -7.37381}}], 
                 Polygon[{{5.82357, 3.3765, -7.37381}, 
                     {4.71717, 5.84107, -4.42393}, {5.39306, 5.71334, -4.25249}, 
                     {5.65374, 3.66408, -7.67778}}], 
                 Polygon[{{5.65374, 3.66408, -7.67778}, 
                     {5.39306, 5.71334, -4.25249}, {6.24135, 5.89078, -4.45667}, 
                     {5.45993, 4.00745, -7.89796}}], 
                 Polygon[{{5.45993, 4.00745, -7.89796}, 
                     {6.24135, 5.89078, -4.45667}, {6.99166, 6.39571, -5.0652}, 
                     {5.26389, 4.38144, -8.05812}}], 
                 Polygon[{{5.26389, 4.38144, -8.05812}, 
                     {6.99166, 6.39571, -5.0652}, {7.39165, 7.15934, -5.99611}, 
                     {5.07127, 4.76306, -8.20375}}], 
                 Polygon[{{5.07127, 4.76306, -8.20375}, 
                     {7.39165, 7.15934, -5.99611}, {7.27471, 8.04135, -7.08283}, 
                     {4.86304, 5.12437, -8.37707}}], 
                 Polygon[{{4.86304, 5.12437, -8.37707}, 
                     {7.27471, 8.04135, -7.08283}, {6.59357, 8.86927, -8.10985}, 
                     {4.61003, 5.42954, -8.59342}}], 
                 Polygon[{{4.61003, 5.42954, -8.59342}, 
                     {6.59357, 8.86927, -8.10985}, {5.43846, 9.47803, -8.85359}, 
                     {4.29774, 5.64416, -8.8391}}], 
                 Polygon[{{4.29774, 5.64416, -8.8391}, 
                     {5.43846, 9.47803, -8.85359}, {4.03703, 9.74865, -9.14704}, 
                     {3.93792, 5.75027, -9.09052}}], 
                 Polygon[{{3.93792, 5.75027, -9.09052}, 
                     {4.03703, 9.74865, -9.14704}, {2.70309, 9.64515, -8.95461}, 
                     {3.55834, 5.75622, -9.33512}}], 
                 Polygon[{{3.55834, 5.75622, -9.33512}, 
                     {2.70309, 9.64515, -8.95461}, {1.72669, 9.23314, -8.40177}, 
                     {3.18112, 5.69686, -9.57623}}], 
                 Polygon[{{3.18112, 5.69686, -9.57623}, 
                     {1.72669, 9.23314, -8.40177}, {1.26535, 8.65922, -7.71918}, 
                     {2.80718, 5.62355, -9.81858}}], 
                 Polygon[{{2.80718, 5.62355, -9.81858}, 
                     {1.26535, 8.65922, -7.71918}, {1.31283, 8.09991, -7.14082}, 
                     {2.42018, 5.58583, -10.0483}}], 
                 Polygon[{{2.42018, 5.58583, -10.0483}, 
                     {1.31283, 8.09991, -7.14082}, {1.74062, 7.71401, -6.83574}, 
                     {2.00733, 5.61328, -10.2292}}], 
                 Polygon[{{2.00733, 5.61328, -10.2292}, 
                     {1.74062, 7.71401, -6.83574}, {2.34615, 7.61602, -6.89159}, 
                     {1.57638, 5.71026, -10.3231}}], 
                 Polygon[{{1.57638, 5.71026, -10.3231}, 
                     {2.34615, 7.61602, -6.89159}, {2.88364, 7.85841, -7.30906}, 
                     {1.1524, 5.86555, -10.3143}}], 
                 Polygon[{{1.1524, 5.86555, -10.3143}, 
                     {2.88364, 7.85841, -7.30906}, {3.10862, 8.41289, -7.99166}, 
                     {0.758389, 6.06481, -10.2194}}], 
                 Polygon[{{0.758389, 6.06481, -10.2194}, 
                     {3.10862, 8.41289, -7.99166}, {2.84882, 9.16537, -8.76067}, 
                     {0.395667, 6.29364, -10.078}}], 
                 Polygon[{{0.395667, 6.29364, -10.078}, 
                     {2.84882, 9.16537, -8.76067}, {2.0605, 9.94212, -9.40871}, 
                     {0.0401177, 6.52944, -9.92986}}], 
                 Polygon[{{0.0401177, 6.52944, -9.92986}, 
                     {2.0605, 9.94212, -9.40871}, {0.83585, 10.5571, -9.7564}, 
                     {-0.33974, 6.73392, -9.7963}}], 
                 Polygon[{{-0.33974, 6.73392, -9.7963}, 
                     {0.83585, 10.5571, -9.7564}, 
                     {-0.620347, 10.8584, -9.68571}, 
                     {-0.75628, 6.86076, -9.67649}}], 
                 Polygon[{{-0.75628, 6.86076, -9.67649}, 
                     {-0.620347, 10.8584, -9.68571}, 
                     {-2.02667, 10.7681, -9.16825}, {-1.19276, 6.87586, -9.5616}}
                    ], Polygon[{{-1.19276, 6.87586, -9.5616}, 
                     {-2.02667, 10.7681, -9.16825}, 
                     {-3.09055, 10.309, -8.29607}, {-1.6183, 6.77345, -9.45036}}]\
                 , Polygon[{{-1.6183, 6.77345, -9.45036}, 
                     {-3.09055, 10.309, -8.29607}, 
                     {-3.60801, 9.60446, -7.28053}, 
                     {-2.01275, 6.57696, -9.35161}}], 
                 Polygon[{{-2.01275, 6.57696, -9.35161}, 
                     {-3.60801, 9.60446, -7.28053}, 
                     {-3.54999, 8.83852, -6.38508}, {-2.38097, 6.3281, -9.27146}}
                    ], Polygon[{{-2.38097, 6.3281, -9.27146}, 
                     {-3.54999, 8.83852, -6.38508}, 
                     {-3.06569, 8.19157, -5.81919}, {-2.74529, 6.07203, -9.1963}}
                    ], Polygon[{{-2.74529, 6.07203, -9.1963}, 
                     {-3.06569, 8.19157, -5.81919}, 
                     {-2.40096, 7.79184, -5.67014}, 
                     {-3.12081, 5.84506, -9.08948}}], 
                 Polygon[{{-3.12081, 5.84506, -9.08948}, 
                     {-2.40096, 7.79184, -5.67014}, 
                     {-1.80954, 7.70067, -5.9056}, {-3.49618, 5.66915, -8.9103}}]\
                 , Polygon[{{-3.49618, 5.66915, -8.9103}, 
                     {-1.80954, 7.70067, -5.9056}, 
                     {-1.50764, 7.91288, -6.40389}, 
                     {-3.83913, 5.55404, -8.63996}}], 
                 Polygon[{{-3.83913, 5.55404, -8.63996}, 
                     {-1.50764, 7.91288, -6.40389}, 
                     {-1.64572, 8.35568, -6.97607}, 
                     {-4.12119, 5.50214, -8.29112}}], 
                 Polygon[{{-4.12119, 5.50214, -8.29112}, 
                     {-1.64572, 8.35568, -6.97607}, 
                     {-2.26835, 8.89488, -7.39752}, {-4.3394, 5.50926, -7.8958}}]\
                 , Polygon[{{-4.3394, 5.50926, -7.8958}, 
                     {-2.26835, 8.89488, -7.39752}, 
                     {-3.28655, 9.36397, -7.47028}, 
                     {-4.51905, 5.55861, -7.48441}}], 
                 Polygon[{{-4.51905, 5.55861, -7.48441}, 
                     {-3.28655, 9.36397, -7.47028}, 
                     {-4.50015, 9.60927, -7.08779}, 
                     {-4.69495, 5.61405, -7.07218}}], 
                 Polygon[{{-4.69495, 5.61405, -7.07218}, 
                     {-4.50015, 9.60927, -7.08779}, 
                     {-5.65403, 9.52938, -6.25942}, 
                     {-4.88426, 5.62488, -6.66232}}], 
                 Polygon[{{-4.88426, 5.62488, -6.66232}, 
                     {-5.65403, 9.52938, -6.25942}, 
                     {-6.49231, 9.10197, -5.10111}, 
                     {-5.07416, 5.54596, -6.26026}}], 
                 Polygon[{{-5.07416, 5.54596, -6.26026}, 
                     {-6.49231, 9.10197, -5.10111}, 
                     {-6.81499, 8.39817, -3.8172}, {-5.23599, 5.35834, -5.88269}}
                    ], Polygon[{{-5.23599, 5.35834, -5.88269}, 
                     {-6.81499, 8.39817, -3.8172}, 
                     {-6.54804, 7.57101, -2.66539}, {-5.35109, 5.07359, -5.5516}}
                    ], Polygon[{{-5.35109, 5.07359, -5.5516}, 
                     {-6.54804, 7.57101, -2.66539}, 
                     {-5.79456, 6.8062, -1.88408}, {-5.42535, 4.72196, -5.27813}}
                    ], Polygon[{{-5.42535, 4.72196, -5.27813}, 
                     {-5.79456, 6.8062, -1.88408}, 
                     {-4.81079, 6.25226, -1.60097}, 
                     {-5.48188, 4.33744, -5.04815}}], 
                 Polygon[{{-5.48188, 4.33744, -5.04815}, 
                     {-4.81079, 6.25226, -1.60097}, 
                     {-3.90083, 5.97486, -1.78557}, 
                     {-5.53797, 3.95043, -4.82226}}], 
                 Polygon[{{-5.53797, 3.95043, -4.82226}, 
                     {-3.90083, 5.97486, -1.78557}, 
                     {-3.30584, 5.9611, -2.28056}, {-5.58555, 3.58902, -4.55567}}
                    ], Polygon[{{-5.58555, 3.58902, -4.55567}, 
                     {-3.30584, 5.9611, -2.28056}, 
                     {-3.15666, 6.14751, -2.86916}, 
                     {-5.59485, 3.28118, -4.22539}}], 
                 Polygon[{{-5.59485, 3.28118, -4.22539}, 
                     {-3.15666, 6.14751, -2.86916}, 
                     {-3.47288, 6.43746, -3.32406}, 
                     {-5.53858, 3.05132, -3.84075}}], 
                 Polygon[{{-5.53858, 3.05132, -3.84075}, 
                     {-3.47288, 6.43746, -3.32406}, 
                     {-4.16235, 6.71156, -3.44176}, {-5.41349, 2.91228, -3.4297}}
                    ], Polygon[{{-5.41349, 2.91228, -3.4297}, 
                     {-4.16235, 6.71156, -3.44176}, 
                     {-5.02623, 6.85058, -3.09086}, 
                     {-5.24197, 2.85711, -3.01559}}], 
                 Polygon[{{-5.24197, 2.85711, -3.01559}, 
                     {-5.02623, 6.85058, -3.09086}, 
                     {-5.80464, 6.7688, -2.26229}, {-5.05448, 2.85473, -2.60475}}
                    ], Polygon[{{-5.05448, 2.85473, -2.60475}, 
                     {-5.80464, 6.7688, -2.26229}, 
                     {-6.25459, 6.43674, -1.07883}, 
                     {-4.86688, 2.85474, -2.19396}}], 
                 Polygon[{{-4.86688, 2.85474, -2.19396}, 
                     {-6.25459, 6.43674, -1.07883}, 
                     {-6.21125, 5.88695, 0.241759}, 
                     {-4.67092, 2.80495, -1.79014}}], 
                 Polygon[{{-4.67092, 2.80495, -1.79014}, 
                     {-6.21125, 5.88695, 0.241759}, 
                     {-5.61944, 5.21307, 1.43847}, {-4.447, 2.6733, -1.42072}}], 
                 Polygon[{{-4.447, 2.6733, -1.42072}, 
                     {-5.61944, 5.21307, 1.43847}, {-4.55681, 4.55612, 2.263}, 
                     {-4.18616, 2.45735, -1.12193}}], 
                 Polygon[{{-4.18616, 2.45735, -1.12193}, 
                     {-4.55681, 4.55612, 2.263}, {-3.23998, 4.06222, 2.54891}, 
                     {-3.90014, 2.17521, -0.915677}}], 
                 Polygon[{{-3.90014, 2.17521, -0.915677}, 
                     {-3.23998, 4.06222, 2.54891}, {-1.97552, 3.82117, 2.27853}, 
                     {-3.61167, 1.84994, -0.793483}}], 
                 Polygon[{{-3.61167, 1.84994, -0.793483}, 
                     {-1.97552, 3.82117, 2.27853}, {-1.04948, 3.82714, 1.60021}, 
                     {-3.33396, 1.5019, -0.718069}}]}}}, 
        {{GrayLevel[0.25], {Line[{{0., 0., 0.}, {0., 4, 0.}}], 
               Line[{{0.451604, 0., 0.}, {-0.489646, 3.86078, 0.456539}}], 
               Line[{{0.890357, 0.106967, 0.}, {-0.625144, 3.58887, 1.25682}}], 
                 Line[{{1.30548, 0.284573, 0.00852737}, 
                     {-0.253885, 3.25468, 2.18725}}], 
                 Line[{{1.70999, 0.484669, 0.0252664}, 
                     {0.64114, 2.94863, 2.98946}}], 
                 Line[{{2.12481, 0.663198, 0.0264437}, 
                     {1.93835, 2.75275, 3.43218}}], 
                 Line[{{2.55407, 0.792018, -0.0290916}, 
                     {3.41165, 2.72789, 3.36457}}], 
                 Line[{{2.97593, 0.860737, -0.174895}, 
                     {4.77483, 2.90609, 2.75435}}], 
                 Line[{{3.35779, 0.869915, -0.415813}, 
                     {5.74563, 3.27105, 1.71322}}], 
                 Line[{{3.68133, 0.824641, -0.727616}, 
                     {6.1372, 3.74075, 0.482759}}], 
                 Line[{{3.95711, 0.736209, -1.07413}, 
                     {5.93901, 4.1838, -0.642614}}], 
               Line[{{4.21787, 0.630519, -1.42737}, {5.32141, 4.47528, -1.4254}}]\
                 , Line[{{4.4933, 0.551645, -1.77646}, 
                     {4.55309, 4.55113, -1.75403}}], 
                 Line[{{4.78615, 0.549195, -2.12023}, 
                     {3.90326, 4.42098, -1.64085}}], 
               Line[{{5.072, 0.655612, -2.45326}, {3.58866, 4.14988, -1.1924}}], 
                 Line[{{5.32187, 0.872571, -2.76058}, 
                     {3.74753, 3.84043, -0.589569}}], 
                 Line[{{5.52597, 1.17528, -3.02639}, 
                     {4.40603, 3.61614, -0.0619404}}], 
               Line[{{5.69957, 1.52693, -3.25034}, {5.45385, 3.58923, 0.168216}}]\
                 , Line[{{5.86696, 1.89129, -3.45812}, 
                     {6.66812, 3.82042, -0.0468733}}], 
                 Line[{{6.03593, 2.23758, -3.69364}, 
                     {7.77728, 4.30122, -0.742524}}], 
               Line[{{6.18621, 2.53982, -3.99366}, {8.52345, 4.9644, -1.83526}}],\
                    Line[{{6.28424, 2.77644, -4.36562}, 
                     {8.71869, 5.70064, -3.13171}}], 
               Line[{{6.30998, 2.93337, -4.78829}, {8.30716, 6.37312, -4.3648}}],\
                    Line[{{6.27179, 3.01013, -5.23168}, 
                     {7.40882, 6.84488, -5.27496}}], 
               Line[{{6.19952, 3.02653, -5.67717}, {6.29406, 7.02527, -5.7112}}],\
                    Line[{{6.12189, 3.02458, -6.12204}, 
                     {5.27945, 6.91022, -5.6838}}], 
               Line[{{6.04533, 3.05803, -6.56585}, {4.61301, 6.58257, -5.33049}}]\
                 , Line[{{5.95283, 3.1703, -6.99339}, 
                     {4.42257, 6.17662, -4.8439}}], 
               Line[{{5.82357, 3.3765, -7.37381}, {4.71717, 5.84107, -4.42393}}],\
                    Line[{{5.65374, 3.66408, -7.67778}, 
                     {5.39306, 5.71334, -4.25249}}], 
               Line[{{5.45993, 4.00745, -7.89796}, {6.24135, 5.89078, -4.45667}}]\
                 , Line[{{5.26389, 4.38144, -8.05812}, 
                     {6.99166, 6.39571, -5.0652}}], 
               Line[{{5.07127, 4.76306, -8.20375}, {7.39165, 7.15934, -5.99611}}]\
                 , Line[{{4.86304, 5.12437, -8.37707}, 
                     {7.27471, 8.04135, -7.08283}}], 
               Line[{{4.61003, 5.42954, -8.59342}, {6.59357, 8.86927, -8.10985}}]\
                 , Line[{{4.29774, 5.64416, -8.8391}, 
                     {5.43846, 9.47803, -8.85359}}], 
               Line[{{3.93792, 5.75027, -9.09052}, {4.03703, 9.74865, -9.14704}}]\
                 , Line[{{3.55834, 5.75622, -9.33512}, 
                     {2.70309, 9.64515, -8.95461}}], 
               Line[{{3.18112, 5.69686, -9.57623}, {1.72669, 9.23314, -8.40177}}]\
                 , Line[{{2.80718, 5.62355, -9.81858}, 
                     {1.26535, 8.65922, -7.71918}}], 
               Line[{{2.42018, 5.58583, -10.0483}, {1.31283, 8.09991, -7.14082}}]\
                 , Line[{{2.00733, 5.61328, -10.2292}, 
                     {1.74062, 7.71401, -6.83574}}], 
               Line[{{1.57638, 5.71026, -10.3231}, {2.34615, 7.61602, -6.89159}}]\
                 , Line[{{1.1524, 5.86555, -10.3143}, 
                     {2.88364, 7.85841, -7.30906}}], 
                 Line[{{0.758389, 6.06481, -10.2194}, 
                     {3.10862, 8.41289, -7.99166}}], 
               Line[{{0.395667, 6.29364, -10.078}, {2.84882, 9.16537, -8.76067}}]\
                 , Line[{{0.0401177, 6.52944, -9.92986}, 
                     {2.0605, 9.94212, -9.40871}}], 
               Line[{{-0.33974, 6.73392, -9.7963}, {0.83585, 10.5571, -9.7564}}],\
                    Line[{{-0.75628, 6.86076, -9.67649}, 
                     {-0.620347, 10.8584, -9.68571}}], 
                 Line[{{-1.19276, 6.87586, -9.5616}, 
                     {-2.02667, 10.7681, -9.16825}}], 
               Line[{{-1.6183, 6.77345, -9.45036}, {-3.09055, 10.309, -8.29607}}]\
                 , Line[{{-2.01275, 6.57696, -9.35161}, 
                     {-3.60801, 9.60446, -7.28053}}], 
                 Line[{{-2.38097, 6.3281, -9.27146}, 
                     {-3.54999, 8.83852, -6.38508}}], 
                 Line[{{-2.74529, 6.07203, -9.1963}, 
                     {-3.06569, 8.19157, -5.81919}}], 
                 Line[{{-3.12081, 5.84506, -9.08948}, 
                     {-2.40096, 7.79184, -5.67014}}], 
               Line[{{-3.49618, 5.66915, -8.9103}, {-1.80954, 7.70067, -5.9056}}]\
                 , Line[{{-3.83913, 5.55404, -8.63996}, 
                     {-1.50764, 7.91288, -6.40389}}], 
                 Line[{{-4.12119, 5.50214, -8.29112}, 
                     {-1.64572, 8.35568, -6.97607}}], 
               Line[{{-4.3394, 5.50926, -7.8958}, {-2.26835, 8.89488, -7.39752}}]\
                 , Line[{{-4.51905, 5.55861, -7.48441}, 
                     {-3.28655, 9.36397, -7.47028}}], 
                 Line[{{-4.69495, 5.61405, -7.07218}, 
                     {-4.50015, 9.60927, -7.08779}}], 
                 Line[{{-4.88426, 5.62488, -6.66232}, 
                     {-5.65403, 9.52938, -6.25942}}], 
                 Line[{{-5.07416, 5.54596, -6.26026}, 
                     {-6.49231, 9.10197, -5.10111}}], 
                 Line[{{-5.23599, 5.35834, -5.88269}, 
                     {-6.81499, 8.39817, -3.8172}}], 
                 Line[{{-5.35109, 5.07359, -5.5516}, 
                     {-6.54804, 7.57101, -2.66539}}], 
                 Line[{{-5.42535, 4.72196, -5.27813}, 
                     {-5.79456, 6.8062, -1.88408}}], 
                 Line[{{-5.48188, 4.33744, -5.04815}, 
                     {-4.81079, 6.25226, -1.60097}}], 
                 Line[{{-5.53797, 3.95043, -4.82226}, 
                     {-3.90083, 5.97486, -1.78557}}], 
                 Line[{{-5.58555, 3.58902, -4.55567}, 
                     {-3.30584, 5.9611, -2.28056}}], 
                 Line[{{-5.59485, 3.28118, -4.22539}, 
                     {-3.15666, 6.14751, -2.86916}}], 
                 Line[{{-5.53858, 3.05132, -3.84075}, 
                     {-3.47288, 6.43746, -3.32406}}], 
                 Line[{{-5.41349, 2.91228, -3.4297}, 
                     {-4.16235, 6.71156, -3.44176}}], 
                 Line[{{-5.24197, 2.85711, -3.01559}, 
                     {-5.02623, 6.85058, -3.09086}}], 
                 Line[{{-5.05448, 2.85473, -2.60475}, 
                     {-5.80464, 6.7688, -2.26229}}], 
                 Line[{{-4.86688, 2.85474, -2.19396}, 
                     {-6.25459, 6.43674, -1.07883}}], 
                 Line[{{-4.67092, 2.80495, -1.79014}, 
                     {-6.21125, 5.88695, 0.241759}}], 
               Line[{{-4.447, 2.6733, -1.42072}, {-5.61944, 5.21307, 1.43847}}], 
               Line[{{-4.18616, 2.45735, -1.12193}, {-4.55681, 4.55612, 2.263}}],\
                    Line[{{-3.90014, 2.17521, -0.915677}, 
                     {-3.23998, 4.06222, 2.54891}}], 
                 Line[{{-3.61167, 1.84994, -0.793483}, 
                     {-1.97552, 3.82117, 2.27853}}], 
                 Line[{{-3.33396, 1.5019, -0.718069}, 
                     {-1.04948, 3.82714, 1.60021}}]}}}}, BoxRatios -> {1, 1, 1}, 
   ViewPoint -> {2, 1, 1.7}]
;[o]
-Graphics3D-
:[font = input; ]
clear;top=80;kappa[s_]:=10 Sin[s];tau[s_]:=3.0;ds:=0.1;
width=.5;pribbonfrenet
:[inactive; PostScript; output; pictureLeft = 43; pictureWidth = 293; pictureHeight = 262; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.06132 0.72899 lineto
stroke
0.41259 0.97619 moveto
0.42805 0.53407 lineto
stroke
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.42805 0.53407 moveto
0.41259 0.97619 lineto
stroke
0.42805 0.53407 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.13892 0.23925 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.42805 0.53407 lineto
stroke
0.87475 0.38789 moveto
0.65131 0.02381 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
grestore
0.704 0.674 0.818 setrgbcolor
0.70624 0.35489 moveto
0.71724 0.44346 lineto
0.67004 0.44749 lineto
fill
0.678 0.672 0.837 setrgbcolor
0.70848 0.37057 moveto
0.67004 0.44749 lineto
0.62719 0.43755 lineto
fill
0.822 0.619 0.066 setrgbcolor
0.70524 0.34106 moveto
0.71724 0.44346 lineto
0.70624 0.35489 lineto
fill
0 0 0.15 setrgbcolor
0.70624 0.35489 moveto
0.70848 0.37057 lineto
0.71724 0.44346 lineto
fill
0.407 0.348 0.679 setrgbcolor
0.70848 0.37057 moveto
0.71116 0.38969 lineto
0.67004 0.44749 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.70767 0.3722 moveto
0.70848 0.37057 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67521 0.43715 moveto
0.67783 0.43189 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68022 0.42712 moveto
0.68332 0.42092 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6974 0.39275 moveto
0.70767 0.3722 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.67004 0.44749 moveto
0.67521 0.43715 lineto
stroke
1 0 0 setrgbcolor
0.62719 0.43755 moveto
0.67004 0.44749 lineto
stroke
1 0 0 setrgbcolor
0.67004 0.44749 moveto
0.71724 0.44346 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.70624 0.35489 moveto
0.70821 0.37079 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.71121 0.3949 moveto
0.71724 0.44346 lineto
stroke
0.721 0.666 0.795 setrgbcolor
0.70524 0.34106 moveto
0.76418 0.42541 lineto
0.71724 0.44346 lineto
fill
1 0 0 setrgbcolor
0.71724 0.44346 moveto
0.76418 0.42541 lineto
stroke
0.647 0.659 0.848 setrgbcolor
0.71116 0.38969 moveto
0.62719 0.43755 lineto
0.59524 0.41544 lineto
fill
0.572 0.483 0.714 setrgbcolor
0.71116 0.38969 moveto
0.71138 0.41261 lineto
0.62719 0.43755 lineto
fill
0.576 0.616 0.855 setrgbcolor
0.58275 0.38718 moveto
0.70514 0.43733 lineto
0.59524 0.41544 lineto
fill
0.655 0.575 0.753 setrgbcolor
0.58275 0.38718 moveto
0.70514 0.43733 lineto
0.68928 0.4594 lineto
fill
0.66 0.571 0.743 setrgbcolor
0.58275 0.38718 moveto
0.71138 0.41261 lineto
0.70514 0.43733 lineto
fill
0.589 0.612 0.842 setrgbcolor
0.58275 0.38718 moveto
0.59706 0.365 lineto
0.70514 0.43733 lineto
fill
0.666 0.602 0.774 setrgbcolor
0.59706 0.365 moveto
0.68928 0.4594 lineto
0.66378 0.47325 lineto
fill
0.572 0.585 0.827 setrgbcolor
0.59706 0.365 moveto
0.63696 0.36539 lineto
0.68928 0.4594 lineto
fill
0.664 0.624 0.798 setrgbcolor
0.63696 0.36539 moveto
0.66378 0.47325 lineto
0.63304 0.47486 lineto
fill
0.571 0.563 0.805 setrgbcolor
0.63696 0.36539 moveto
0.68493 0.39952 lineto
0.66378 0.47325 lineto
fill
0.591 0.658 0.883 setrgbcolor
0.60509 0.46434 moveto
0.68064 0.46083 lineto
0.63304 0.47486 lineto
fill
0.609 0.566 0.781 setrgbcolor
0.60509 0.46434 moveto
0.68493 0.39952 lineto
0.71058 0.45943 lineto
fill
0.63 0.574 0.772 setrgbcolor
0.63087 0.54176 moveto
0.59169 0.4539 lineto
0.69127 0.5168 lineto
fill
0.591 0.658 0.883 setrgbcolor
0.71058 0.45943 moveto
0.69713 0.46211 lineto
0.68064 0.46083 lineto
fill
0.591 0.658 0.883 setrgbcolor
0.63304 0.47486 moveto
0.68064 0.46083 lineto
0.69713 0.46211 lineto
fill
0.623 0.575 0.779 setrgbcolor
0.58867 0.44714 moveto
0.71058 0.45943 lineto
0.69127 0.5168 lineto
fill
0.643 0.591 0.78 setrgbcolor
0.55655 0.52233 moveto
0.58639 0.43985 lineto
0.63087 0.54176 lineto
fill
0.545 0.578 0.838 setrgbcolor
0.58867 0.44714 moveto
0.58889 0.43296 lineto
0.69127 0.5168 lineto
fill
0.643 0.591 0.78 setrgbcolor
0.58889 0.43296 moveto
0.59368 0.44537 lineto
0.58639 0.43985 lineto
fill
0.417 0.563 0.892 setrgbcolor
0.58867 0.44714 moveto
0.65746 0.49385 lineto
0.60509 0.46434 lineto
fill
0.417 0.563 0.892 setrgbcolor
0.60509 0.46434 moveto
0.65746 0.49385 lineto
0.65794 0.49424 lineto
fill
0.63 0.574 0.772 setrgbcolor
0.58867 0.44714 moveto
0.59953 0.45451 lineto
0.59169 0.4539 lineto
fill
0.417 0.563 0.892 setrgbcolor
0.69127 0.5168 moveto
0.67392 0.50624 lineto
0.6586 0.49462 lineto
fill
0.63 0.574 0.772 setrgbcolor
0.69127 0.5168 moveto
0.59169 0.4539 lineto
0.59953 0.45451 lineto
fill
0.643 0.591 0.78 setrgbcolor
0.63087 0.54176 moveto
0.58639 0.43985 lineto
0.59368 0.44537 lineto
fill
0.646 0.606 0.794 setrgbcolor
0.50296 0.46889 moveto
0.58913 0.43662 lineto
0.55655 0.52233 lineto
fill
0.417 0.563 0.892 setrgbcolor
0.60509 0.46434 moveto
0.6586 0.49462 lineto
0.67392 0.50624 lineto
fill
0.547 0.537 0.795 setrgbcolor
0.58889 0.43296 moveto
0.60289 0.43147 lineto
0.63087 0.54176 lineto
fill
0.646 0.606 0.794 setrgbcolor
0.60289 0.43147 moveto
0.59693 0.44316 lineto
0.58913 0.43662 lineto
fill
0.646 0.606 0.794 setrgbcolor
0.55655 0.52233 moveto
0.58913 0.43662 lineto
0.59693 0.44316 lineto
fill
0.593 0.542 0.766 setrgbcolor
0.60289 0.43147 moveto
0.61925 0.446 lineto
0.55655 0.52233 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55655 0.52233 moveto
0.55791 0.51967 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55919 0.51716 moveto
0.56085 0.51389 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57194 0.49215 moveto
0.58354 0.46942 lineto
stroke
1 0 0 setrgbcolor
0.50296 0.46889 moveto
0.50472 0.47063 lineto
stroke
1 0 0 setrgbcolor
0.52902 0.49488 moveto
0.55655 0.52233 lineto
stroke
1 0 0 setrgbcolor
0.56083 0.52345 moveto
0.63087 0.54176 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.70524 0.34106 moveto
0.76418 0.42541 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.70927 0.39076 moveto
0.71116 0.38969 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.68669 0.40363 moveto
0.70927 0.39076 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.62719 0.43755 moveto
0.63452 0.43337 lineto
stroke
1 0 0 setrgbcolor
0.59524 0.41544 moveto
0.62719 0.43755 lineto
stroke
0.625 0.606 0.811 setrgbcolor
0.4979 0.41023 moveto
0.62402 0.46969 lineto
0.50296 0.46889 lineto
fill
0.644 0.592 0.781 setrgbcolor
0.49908 0.53867 moveto
0.5388 0.45977 lineto
0.57135 0.56365 lineto
fill
0.627 0.571 0.772 setrgbcolor
0.57135 0.56365 moveto
0.54279 0.47423 lineto
0.63584 0.54426 lineto
fill
0.627 0.571 0.772 setrgbcolor
0.54026 0.46631 moveto
0.55144 0.47543 lineto
0.54279 0.47423 lineto
fill
0.651 0.594 0.778 setrgbcolor
0.4979 0.41023 moveto
0.62402 0.46969 lineto
0.61042 0.4894 lineto
fill
0.662 0.588 0.761 setrgbcolor
0.62402 0.46969 moveto
0.54934 0.43448 lineto
0.61925 0.446 lineto
fill
0.662 0.588 0.761 setrgbcolor
0.61925 0.446 moveto
0.54934 0.43448 lineto
0.53505 0.42307 lineto
fill
0.662 0.588 0.761 setrgbcolor
0.61925 0.446 moveto
0.51156 0.41668 lineto
0.5091 0.41354 lineto
fill
0.612 0.61 0.824 setrgbcolor
0.62402 0.46969 moveto
0.54934 0.43448 lineto
0.54653 0.38429 lineto
fill
0.662 0.588 0.761 setrgbcolor
0.51156 0.41668 moveto
0.53505 0.42307 lineto
0.54934 0.43448 lineto
fill
0.662 0.588 0.761 setrgbcolor
0.4979 0.41023 moveto
0.5091 0.41354 lineto
0.51156 0.41668 lineto
fill
0.612 0.61 0.824 setrgbcolor
0.4979 0.41023 moveto
0.54653 0.38429 lineto
0.54934 0.43448 lineto
fill
0.583 0.587 0.822 setrgbcolor
0.61711 0.41448 moveto
0.61093 0.48368 lineto
0.54653 0.38429 lineto
fill
0.583 0.587 0.822 setrgbcolor
0.61042 0.4894 moveto
0.60318 0.47749 lineto
0.61093 0.48368 lineto
fill
0.583 0.587 0.822 setrgbcolor
0.54653 0.38429 moveto
0.61093 0.48368 lineto
0.60318 0.47749 lineto
fill
0.653 0.616 0.8 setrgbcolor
0.58342 0.49474 moveto
0.55613 0.41302 lineto
0.61042 0.4894 lineto
fill
0.653 0.616 0.8 setrgbcolor
0.54653 0.38429 moveto
0.55618 0.40017 lineto
0.55613 0.41302 lineto
fill
0.653 0.616 0.8 setrgbcolor
0.61042 0.4894 moveto
0.55613 0.41302 lineto
0.55618 0.40017 lineto
fill
0.597 0.57 0.794 setrgbcolor
0.65634 0.48331 moveto
0.56457 0.48432 lineto
0.61711 0.41448 lineto
fill
0.597 0.57 0.794 setrgbcolor
0.55582 0.48442 moveto
0.56048 0.4791 lineto
0.56457 0.48432 lineto
fill
0.597 0.57 0.794 setrgbcolor
0.61711 0.41448 moveto
0.56457 0.48432 lineto
0.56048 0.4791 lineto
fill
0.574 0.652 0.888 setrgbcolor
0.55582 0.48442 moveto
0.61195 0.4838 lineto
0.58342 0.49474 lineto
fill
0.363 0.525 0.883 setrgbcolor
0.54026 0.46631 moveto
0.59264 0.50902 lineto
0.55582 0.48442 lineto
fill
0.363 0.525 0.883 setrgbcolor
0.55582 0.48442 moveto
0.59264 0.50902 lineto
0.59353 0.50994 lineto
fill
0.363 0.525 0.883 setrgbcolor
0.63584 0.54426 moveto
0.61186 0.52632 lineto
0.59485 0.51083 lineto
fill
0.363 0.525 0.883 setrgbcolor
0.55582 0.48442 moveto
0.59485 0.51083 lineto
0.61186 0.52632 lineto
fill
0.627 0.571 0.772 setrgbcolor
0.63584 0.54426 moveto
0.54279 0.47423 lineto
0.55144 0.47543 lineto
fill
0.574 0.652 0.888 setrgbcolor
0.58342 0.49474 moveto
0.61195 0.4838 lineto
0.63388 0.48683 lineto
fill
0.574 0.652 0.888 setrgbcolor
0.65634 0.48331 moveto
0.63388 0.48683 lineto
0.61195 0.4838 lineto
fill
0.613 0.571 0.783 setrgbcolor
0.54026 0.46631 moveto
0.65634 0.48331 lineto
0.63584 0.54426 lineto
fill
0.536 0.565 0.831 setrgbcolor
0.63584 0.54426 moveto
0.59485 0.51083 lineto
0.54234 0.45276 lineto
fill
0.536 0.565 0.831 setrgbcolor
0.54026 0.46631 moveto
0.54234 0.45276 lineto
0.59485 0.51083 lineto
fill
0.644 0.592 0.781 setrgbcolor
0.57135 0.56365 moveto
0.5388 0.45977 lineto
0.54585 0.46619 lineto
fill
0.649 0.612 0.798 setrgbcolor
0.45088 0.48812 moveto
0.54283 0.45825 lineto
0.49908 0.53867 lineto
fill
0.547 0.529 0.787 setrgbcolor
0.54234 0.45276 moveto
0.55726 0.45356 lineto
0.57135 0.56365 lineto
fill
0.649 0.612 0.798 setrgbcolor
0.55726 0.45356 moveto
0.54945 0.465 lineto
0.54283 0.45825 lineto
fill
0.644 0.592 0.781 setrgbcolor
0.54234 0.45276 moveto
0.54585 0.46619 lineto
0.5388 0.45977 lineto
fill
0.649 0.612 0.798 setrgbcolor
0.49908 0.53867 moveto
0.54283 0.45825 lineto
0.54945 0.465 lineto
fill
0.597 0.54 0.761 setrgbcolor
0.55726 0.45356 moveto
0.5725 0.46993 lineto
0.49908 0.53867 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55175 0.46163 moveto
0.55726 0.45356 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49908 0.53867 moveto
0.50381 0.53175 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54974 0.46457 moveto
0.55175 0.46163 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50381 0.53175 moveto
0.50822 0.5253 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50822 0.5253 moveto
0.51084 0.52147 lineto
stroke
1 0 0 setrgbcolor
0.45088 0.48812 moveto
0.49908 0.53867 lineto
stroke
1 0 0 setrgbcolor
0.49908 0.53867 moveto
0.57135 0.56365 lineto
stroke
1 0 0 setrgbcolor
0.4979 0.41023 moveto
0.50116 0.44802 lineto
stroke
1 0 0 setrgbcolor
0.58275 0.38718 moveto
0.58962 0.40273 lineto
stroke
1 0 0 setrgbcolor
0.63762 0.53897 moveto
0.69127 0.5168 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55937 0.51785 moveto
0.57135 0.56365 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55439 0.49883 moveto
0.55937 0.51785 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54234 0.45276 moveto
0.5437 0.45797 lineto
stroke
1 0 0 setrgbcolor
0.57135 0.56365 moveto
0.63584 0.54426 lineto
stroke
0.623 0.615 0.822 setrgbcolor
0.44334 0.4395 moveto
0.57578 0.49393 lineto
0.45088 0.48812 lineto
fill
1 0 0 setrgbcolor
0.44334 0.4395 moveto
0.44743 0.46593 lineto
stroke
1 0 0 setrgbcolor
0.44743 0.46593 moveto
0.45088 0.48812 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63757 0.36786 moveto
0.65208 0.42619 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.63696 0.36539 moveto
0.63757 0.36786 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5936 0.39163 moveto
0.62018 0.40252 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.70026 0.43533 moveto
0.70514 0.43733 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58275 0.38718 moveto
0.5936 0.39163 lineto
stroke
1 0 0 setrgbcolor
0.58275 0.38718 moveto
0.59706 0.365 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6586 0.49462 moveto
0.69127 0.5168 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.65366 0.49127 moveto
0.6586 0.49462 lineto
stroke
0.656 0.596 0.775 setrgbcolor
0.44334 0.4395 moveto
0.57578 0.49393 lineto
0.56247 0.51447 lineto
fill
0.665 0.589 0.76 setrgbcolor
0.57578 0.49393 moveto
0.50093 0.46317 lineto
0.5725 0.46993 lineto
fill
0.665 0.589 0.76 setrgbcolor
0.44334 0.4395 moveto
0.49309 0.45122 lineto
0.50093 0.46317 lineto
fill
0.665 0.589 0.76 setrgbcolor
0.5725 0.46993 moveto
0.50093 0.46317 lineto
0.49309 0.45122 lineto
fill
0.601 0.624 0.846 setrgbcolor
0.47298 0.41748 moveto
0.50014 0.43767 lineto
0.44334 0.4395 lineto
fill
0.601 0.624 0.846 setrgbcolor
0.57578 0.49393 moveto
0.50093 0.46317 lineto
0.50014 0.43767 lineto
fill
0.601 0.624 0.846 setrgbcolor
0.44334 0.4395 moveto
0.50014 0.43767 lineto
0.50093 0.46317 lineto
fill
0.663 0.622 0.797 setrgbcolor
0.47298 0.41748 moveto
0.50807 0.45551 lineto
0.53639 0.5241 lineto
fill
0.663 0.622 0.797 setrgbcolor
0.56247 0.51447 moveto
0.53639 0.5241 lineto
0.50807 0.45551 lineto
fill
0.527 0.586 0.857 setrgbcolor
0.47298 0.41748 moveto
0.51786 0.43181 lineto
0.56247 0.51447 lineto
fill
0.456 0.505 0.82 setrgbcolor
0.551 0.47253 moveto
0.53775 0.5193 lineto
0.51786 0.43181 lineto
fill
0.456 0.505 0.82 setrgbcolor
0.53639 0.5241 moveto
0.5344 0.5142 lineto
0.53775 0.5193 lineto
fill
0.456 0.505 0.82 setrgbcolor
0.51786 0.43181 moveto
0.53775 0.5193 lineto
0.5344 0.5142 lineto
fill
0.654 0.644 0.828 setrgbcolor
0.51786 0.43181 moveto
0.53639 0.5241 lineto
0.50549 0.52168 lineto
fill
0.417 0.67 0.966 setrgbcolor
0.47706 0.51072 moveto
0.55708 0.51968 lineto
0.50549 0.52168 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.47706 0.51072 moveto
0.50549 0.52168 lineto
stroke
0 0 0 setrgbcolor
0.50549 0.52168 moveto
0.53639 0.5241 lineto
stroke
0.561 0.515 0.762 setrgbcolor
0.47706 0.51072 moveto
0.551 0.47253 lineto
0.55708 0.51968 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51786 0.43181 moveto
0.52113 0.44811 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52113 0.44811 moveto
0.52324 0.45859 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52324 0.45859 moveto
0.52838 0.48421 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.53567 0.52051 moveto
0.53639 0.5241 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.53639 0.5241 moveto
0.54736 0.52005 lineto
stroke
0 0 0 setrgbcolor
0.55669 0.5166 moveto
0.56247 0.51447 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.59485 0.51083 moveto
0.63584 0.54426 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.57521 0.49481 moveto
0.59485 0.51083 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.6089 0.37712 moveto
0.63556 0.40441 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.59706 0.365 moveto
0.6089 0.37712 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.70262 0.44084 moveto
0.70514 0.43733 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.5584 0.40382 moveto
0.56994 0.42281 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56994 0.42281 moveto
0.58627 0.44967 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54653 0.38429 moveto
0.5584 0.40382 lineto
stroke
1 0 0 setrgbcolor
0.69127 0.5168 moveto
0.71058 0.45943 lineto
stroke
0.607 0.529 0.74 setrgbcolor
0.45529 0.49657 moveto
0.55708 0.51968 lineto
0.53664 0.55776 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.45529 0.49657 moveto
0.46195 0.50158 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4979 0.41023 moveto
0.54934 0.43448 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54934 0.43448 moveto
0.56591 0.44229 lineto
stroke
1 0 0 setrgbcolor
0.4979 0.41023 moveto
0.54653 0.38429 lineto
stroke
0.72 0.65 0.778 setrgbcolor
0.42011 0.47125 moveto
0.4 0.59272 lineto
0.34775 0.58636 lineto
fill
0.95 0.873 0.725 setrgbcolor
0.42011 0.47125 moveto
0.42578 0.47168 lineto
0.4 0.59272 lineto
fill
0.704 0.618 0.758 setrgbcolor
0.42578 0.47168 moveto
0.45109 0.59175 lineto
0.4 0.59272 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4 0.59272 moveto
0.40844 0.5531 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40844 0.5531 moveto
0.42568 0.47217 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42568 0.47217 moveto
0.42578 0.47168 lineto
stroke
1 0 0 setrgbcolor
0.34775 0.58636 moveto
0.4 0.59272 lineto
stroke
1 0 0 setrgbcolor
0.4 0.59272 moveto
0.45109 0.59175 lineto
stroke
1 0 0 setrgbcolor
0.63584 0.54426 moveto
0.65634 0.48331 lineto
stroke
0.966 0.765 0.58 setrgbcolor
0.42578 0.47168 moveto
0.43193 0.47547 lineto
0.45109 0.59175 lineto
fill
0.68 0.587 0.744 setrgbcolor
0.43193 0.47547 moveto
0.49842 0.58128 lineto
0.45109 0.59175 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.43193 0.47547 moveto
0.45109 0.59175 lineto
stroke
1 0 0 setrgbcolor
0.45109 0.59175 moveto
0.49842 0.58128 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.70524 0.34106 moveto
0.70624 0.35489 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.47298 0.41748 moveto
0.50807 0.45551 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50807 0.45551 moveto
0.51375 0.46166 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55542 0.50683 moveto
0.56247 0.51447 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.56247 0.51447 moveto
0.57578 0.49393 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.44334 0.4395 moveto
0.49541 0.4609 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49541 0.4609 moveto
0.49991 0.46275 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55253 0.48438 moveto
0.57578 0.49393 lineto
stroke
1 0 0 setrgbcolor
0.44334 0.4395 moveto
0.47298 0.41748 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.71133 0.4128 moveto
0.71138 0.41261 lineto
stroke
0 0 0 setrgbcolor
0.70514 0.43733 moveto
0.71133 0.4128 lineto
stroke
0 0 0 setrgbcolor
0.70624 0.35489 moveto
0.70848 0.37057 lineto
stroke
0 0 0 setrgbcolor
0.54234 0.45276 moveto
0.55726 0.45356 lineto
stroke
0.736 0.672 0.787 setrgbcolor
0.42011 0.47125 moveto
0.34775 0.58636 lineto
0.29688 0.57205 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.34775 0.58636 moveto
0.35787 0.57026 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35787 0.57026 moveto
0.41923 0.47265 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41923 0.47265 moveto
0.42011 0.47125 lineto
stroke
1 0 0 setrgbcolor
0.29688 0.57205 moveto
0.34775 0.58636 lineto
stroke
0.929 0.549 0.239 setrgbcolor
0.43193 0.47547 moveto
0.44084 0.48392 lineto
0.49842 0.58128 lineto
fill
0.648 0.556 0.736 setrgbcolor
0.44084 0.48392 moveto
0.53664 0.55776 lineto
0.49842 0.58128 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.48748 0.56277 moveto
0.49842 0.58128 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44585 0.49239 moveto
0.48748 0.56277 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44084 0.48392 moveto
0.44585 0.49239 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.43193 0.47547 moveto
0.44084 0.48392 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.49842 0.58128 moveto
0.53664 0.55776 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.71116 0.38969 moveto
0.71138 0.41261 lineto
stroke
0 0 0 setrgbcolor
0.70848 0.37057 moveto
0.71116 0.38969 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.59706 0.365 moveto
0.63696 0.36539 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5725 0.46993 moveto
0.57578 0.49393 lineto
stroke
0 0 0 setrgbcolor
0.55726 0.45356 moveto
0.5725 0.46993 lineto
stroke
0 0 0 setrgbcolor
0.42578 0.47168 moveto
0.43193 0.47547 lineto
stroke
0.73 0.702 0.823 setrgbcolor
0.40878 0.47108 moveto
0.29688 0.57205 lineto
0.25309 0.54655 lineto
fill
0.806 0.972 0.903 setrgbcolor
0.40878 0.47108 moveto
0.41407 0.47187 lineto
0.29688 0.57205 lineto
fill
0.797 0.983 0.895 setrgbcolor
0.42011 0.47125 moveto
0.29688 0.57205 lineto
0.41407 0.47187 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.29688 0.57205 moveto
0.30744 0.56302 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30744 0.56302 moveto
0.30927 0.56145 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35488 0.52247 moveto
0.41024 0.47514 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41024 0.47514 moveto
0.41407 0.47187 lineto
stroke
1 0 0 setrgbcolor
0.25309 0.54655 moveto
0.29688 0.57205 lineto
stroke
0.717 0.72 0.852 setrgbcolor
0.52029 0.51358 moveto
0.48346 0.60071 lineto
0.34003 0.59557 lineto
fill
0.773 0.788 0.864 setrgbcolor
0.54738 0.49271 moveto
0.48346 0.60071 lineto
0.52029 0.51358 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.5033 0.55376 moveto
0.52029 0.51358 lineto
stroke
0.723 0.718 0.844 setrgbcolor
0.54738 0.49271 moveto
0.63406 0.54602 lineto
0.48346 0.60071 lineto
fill
1 0 0 setrgbcolor
0.34003 0.59557 moveto
0.39663 0.59759 lineto
stroke
1 0 0 setrgbcolor
0.48346 0.60071 moveto
0.56313 0.57177 lineto
stroke
1 0 0 setrgbcolor
0.60354 0.5571 moveto
0.63406 0.54602 lineto
stroke
1 0 0 setrgbcolor
0.68493 0.39952 moveto
0.70909 0.45595 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.42011 0.47125 moveto
0.42578 0.47168 lineto
stroke
0.712 0.726 0.86 setrgbcolor
0.53303 0.54784 moveto
0.47688 0.63246 lineto
0.33857 0.61877 lineto
fill
0.771 0.813 0.886 setrgbcolor
0.56225 0.52813 moveto
0.47688 0.63246 lineto
0.53303 0.54784 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.47688 0.63246 moveto
0.53303 0.54784 lineto
stroke
0.722 0.729 0.855 setrgbcolor
0.56225 0.52813 moveto
0.63874 0.58179 lineto
0.47688 0.63246 lineto
fill
1 0 0 setrgbcolor
0.33857 0.61877 moveto
0.47688 0.63246 lineto
stroke
1 0 0 setrgbcolor
0.62378 0.58648 moveto
0.63874 0.58179 lineto
stroke
1 0 0 setrgbcolor
0.47688 0.63246 moveto
0.58893 0.59738 lineto
stroke
1 0 0 setrgbcolor
0.47298 0.41748 moveto
0.51786 0.43181 lineto
stroke
1 0 0 setrgbcolor
0.63696 0.36539 moveto
0.68493 0.39952 lineto
stroke
1 0 0 setrgbcolor
0.54653 0.38429 moveto
0.61711 0.41448 lineto
stroke
1 0 0 setrgbcolor
0.61711 0.41448 moveto
0.64352 0.46082 lineto
stroke
0.687 0.797 0.932 setrgbcolor
0.42777 0.68528 moveto
0.54547 0.63117 lineto
0.50521 0.67901 lineto
fill
0.649 0.776 0.94 setrgbcolor
0.37057 0.67761 moveto
0.53087 0.64294 lineto
0.42777 0.68528 lineto
fill
0.649 0.776 0.94 setrgbcolor
0.42777 0.68528 moveto
0.53087 0.64294 lineto
0.53228 0.64289 lineto
fill
0.222 0 0.045 setrgbcolor
0.53361 0.64235 moveto
0.51106 0.65727 lineto
0.42777 0.68528 lineto
fill
0.555 0.267 0.432 setrgbcolor
0.49023 0.67154 moveto
0.3857 0.67684 lineto
0.51106 0.65727 lineto
fill
0.555 0.267 0.432 setrgbcolor
0.51106 0.65727 moveto
0.3857 0.67684 lineto
0.39577 0.67396 lineto
fill
0.619 0.728 0.924 setrgbcolor
0.51106 0.65727 moveto
0.37057 0.67761 lineto
0.33496 0.66016 lineto
fill
0.697 0.5 0.618 setrgbcolor
0.46866 0.68604 moveto
0.3599 0.6495 lineto
0.49023 0.67154 lineto
fill
0.697 0.5 0.618 setrgbcolor
0.32152 0.6366 moveto
0.38005 0.64872 lineto
0.3599 0.6495 lineto
fill
0.697 0.5 0.618 setrgbcolor
0.49023 0.67154 moveto
0.3599 0.6495 lineto
0.38005 0.64872 lineto
fill
0.555 0.267 0.432 setrgbcolor
0.37057 0.67761 moveto
0.39577 0.67396 lineto
0.3857 0.67684 lineto
fill
0.687 0.797 0.932 setrgbcolor
0.55842 0.62521 moveto
0.55531 0.62835 lineto
0.54547 0.63117 lineto
fill
0.687 0.797 0.932 setrgbcolor
0.50521 0.67901 moveto
0.54547 0.63117 lineto
0.55531 0.62835 lineto
fill
0.671 0.964 0.762 setrgbcolor
0.58322 0.6045 moveto
0.50521 0.67901 lineto
0.55842 0.62521 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.50521 0.67901 moveto
0.55531 0.62835 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55531 0.62835 moveto
0.55842 0.62521 lineto
stroke
0.718 0.792 0.909 setrgbcolor
0.58322 0.6045 moveto
0.59771 0.65416 lineto
0.50521 0.67901 lineto
fill
1 0 0 setrgbcolor
0.42777 0.68528 moveto
0.4589 0.68276 lineto
stroke
1 0 0 setrgbcolor
0.47555 0.68141 moveto
0.50521 0.67901 lineto
stroke
1 0 0 setrgbcolor
0.50521 0.67901 moveto
0.59771 0.65416 lineto
stroke
0.839 0.855 0.856 setrgbcolor
0.60276 0.58014 moveto
0.59771 0.65416 lineto
0.58322 0.6045 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.58322 0.6045 moveto
0.59771 0.65416 lineto
stroke
0.735 0.77 0.88 setrgbcolor
0.60276 0.58014 moveto
0.69241 0.60714 lineto
0.59771 0.65416 lineto
fill
1 0 0 setrgbcolor
0.59771 0.65416 moveto
0.69241 0.60714 lineto
stroke
0.758 0.71 0.807 setrgbcolor
0.55434 0.46745 moveto
0.63406 0.54602 lineto
0.54738 0.49271 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.54738 0.49271 moveto
0.5687 0.50582 lineto
stroke
0.724 0.707 0.833 setrgbcolor
0.55434 0.46745 moveto
0.72613 0.45468 lineto
0.63406 0.54602 lineto
fill
1 0 0 setrgbcolor
0.68979 0.49073 moveto
0.72613 0.45468 lineto
stroke
1 0 0 setrgbcolor
0.551 0.47253 moveto
0.55162 0.47733 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.41407 0.47187 moveto
0.42011 0.47125 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53174 0.64311 moveto
0.53361 0.64235 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42777 0.68528 moveto
0.44527 0.67818 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.49622 0.65752 moveto
0.53174 0.64311 lineto
stroke
1 0 0 setrgbcolor
0.37057 0.67761 moveto
0.42777 0.68528 lineto
stroke
0.762 0.725 0.817 setrgbcolor
0.56927 0.50382 moveto
0.63874 0.58179 lineto
0.56225 0.52813 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.56225 0.52813 moveto
0.60817 0.56034 lineto
stroke
0.726 0.719 0.843 setrgbcolor
0.56927 0.50382 moveto
0.74271 0.48498 lineto
0.63874 0.58179 lineto
fill
0.724 0.713 0.84 setrgbcolor
0.4073 0.46696 moveto
0.25309 0.54655 lineto
0.22827 0.50565 lineto
fill
0.717 0.936 0.958 setrgbcolor
0.4073 0.46696 moveto
0.40878 0.47108 lineto
0.25309 0.54655 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.25309 0.54655 moveto
0.28283 0.53213 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29531 0.52608 moveto
0.40878 0.47108 lineto
stroke
1 0 0 setrgbcolor
0.22827 0.50565 moveto
0.25309 0.54655 lineto
stroke
0.704 0.71 0.852 setrgbcolor
0.46838 0.51558 moveto
0.34003 0.59557 lineto
0.27831 0.52711 lineto
fill
0.721 0.764 0.886 setrgbcolor
0.46838 0.51558 moveto
0.48769 0.52201 lineto
0.34003 0.59557 lineto
fill
0.728 0.836 0.931 setrgbcolor
0.52029 0.51358 moveto
0.34003 0.59557 lineto
0.48769 0.52201 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4275 0.55199 moveto
0.48769 0.52201 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.34003 0.59557 moveto
0.37872 0.57629 lineto
stroke
1 0 0 setrgbcolor
0.29679 0.5476 moveto
0.29698 0.54782 lineto
stroke
1 0 0 setrgbcolor
0.29468 0.54526 moveto
0.29679 0.5476 lineto
stroke
1 0 0 setrgbcolor
0.27831 0.52711 moveto
0.29468 0.54526 lineto
stroke
1 0 0 setrgbcolor
0.51786 0.43181 moveto
0.551 0.47253 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.40878 0.47108 moveto
0.41407 0.47187 lineto
stroke
0.787 0.733 0.802 setrgbcolor
0.60981 0.55435 moveto
0.69241 0.60714 lineto
0.60276 0.58014 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60276 0.58014 moveto
0.69241 0.60714 lineto
stroke
0.738 0.743 0.855 setrgbcolor
0.60981 0.55435 moveto
0.76508 0.53893 lineto
0.69241 0.60714 lineto
fill
1 0 0 setrgbcolor
0.69241 0.60714 moveto
0.76508 0.53893 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39577 0.67396 moveto
0.40177 0.67309 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.45824 0.66492 moveto
0.51106 0.65727 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37057 0.67761 moveto
0.39577 0.67396 lineto
stroke
1 0 0 setrgbcolor
0.33496 0.66016 moveto
0.37057 0.67761 lineto
stroke
0.705 0.712 0.854 setrgbcolor
0.29292 0.54769 moveto
0.50048 0.55432 lineto
0.33857 0.61877 lineto
fill
0.706 0.849 0.95 setrgbcolor
0.53303 0.54784 moveto
0.33857 0.61877 lineto
0.50048 0.55432 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40045 0.59414 moveto
0.50048 0.55432 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37914 0.60262 moveto
0.40045 0.59414 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33857 0.61877 moveto
0.37914 0.60262 lineto
stroke
1 0 0 setrgbcolor
0.29292 0.54769 moveto
0.30274 0.56297 lineto
stroke
1 0 0 setrgbcolor
0.30274 0.56297 moveto
0.33512 0.6134 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4073 0.46696 moveto
0.40878 0.47108 lineto
stroke
0.55 0.638 0.89 setrgbcolor
0.32152 0.6366 moveto
0.46866 0.68604 lineto
0.33496 0.66016 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.32152 0.6366 moveto
0.33496 0.66016 lineto
stroke
0.723 0.72 0.846 setrgbcolor
0.24128 0.4479 moveto
0.4073 0.46696 lineto
0.22827 0.50565 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.22827 0.50565 moveto
0.4073 0.46696 lineto
stroke
0.634 0.789 0.956 setrgbcolor
0.24128 0.4479 moveto
0.41393 0.45891 lineto
0.4073 0.46696 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.4073 0.46696 moveto
0.41393 0.45891 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.22827 0.50565 moveto
0.24128 0.4479 lineto
stroke
0.73 0.663 0.783 setrgbcolor
0.53703 0.44712 moveto
0.72613 0.45468 lineto
0.55434 0.46745 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55434 0.46745 moveto
0.58506 0.46517 lineto
stroke
0.72 0.696 0.826 setrgbcolor
0.53703 0.44712 moveto
0.71522 0.36434 lineto
0.72613 0.45468 lineto
fill
1 0 0 setrgbcolor
0.71522 0.36434 moveto
0.72115 0.41345 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.48769 0.52201 moveto
0.52029 0.51358 lineto
stroke
0 0 0 setrgbcolor
0.52029 0.51358 moveto
0.54738 0.49271 lineto
stroke
0 0 0 setrgbcolor
0.46838 0.51558 moveto
0.48769 0.52201 lineto
stroke
0.665 0.77 0.928 setrgbcolor
0.24128 0.4479 moveto
0.43255 0.44846 lineto
0.41393 0.45891 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.24128 0.4479 moveto
0.33472 0.45386 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39595 0.45776 moveto
0.41393 0.45891 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.41393 0.45891 moveto
0.43255 0.44846 lineto
stroke
0 0 0 setrgbcolor
0.54738 0.49271 moveto
0.54862 0.48821 lineto
stroke
0 0 0 setrgbcolor
0.54918 0.48616 moveto
0.55434 0.46745 lineto
stroke
0.747 0.675 0.78 setrgbcolor
0.59821 0.53193 moveto
0.76508 0.53893 lineto
0.60981 0.55435 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60981 0.55435 moveto
0.76508 0.53893 lineto
stroke
0.731 0.67 0.789 setrgbcolor
0.54734 0.48724 moveto
0.74271 0.48498 lineto
0.56927 0.50382 lineto
fill
0.723 0.704 0.831 setrgbcolor
0.54734 0.48724 moveto
0.714 0.38973 lineto
0.74271 0.48498 lineto
fill
0.734 0.718 0.836 setrgbcolor
0.59821 0.53193 moveto
0.7802 0.46097 lineto
0.76508 0.53893 lineto
fill
1 0 0 setrgbcolor
0.76508 0.53893 moveto
0.7802 0.46097 lineto
stroke
0.695 0.504 0.625 setrgbcolor
0.32152 0.6366 moveto
0.46866 0.68604 lineto
0.44328 0.70029 lineto
fill
0.609 0.61 0.827 setrgbcolor
0.32152 0.6366 moveto
0.33131 0.61133 lineto
0.46866 0.68604 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4215 0.67019 moveto
0.46866 0.68604 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.32152 0.6366 moveto
0.37031 0.65299 lineto
stroke
1 0 0 setrgbcolor
0.32152 0.6366 moveto
0.33131 0.61133 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.50048 0.55432 moveto
0.53303 0.54784 lineto
stroke
0 0 0 setrgbcolor
0.53303 0.54784 moveto
0.56225 0.52813 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.56927 0.50382 moveto
0.70934 0.4886 lineto
stroke
1 0 0 setrgbcolor
0.714 0.38973 moveto
0.72134 0.41408 lineto
stroke
0.656 0.775 0.936 setrgbcolor
0.29292 0.54769 moveto
0.48418 0.54667 lineto
0.50048 0.55432 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.48418 0.54667 moveto
0.50048 0.55432 lineto
stroke
0.707 0.7 0.84 setrgbcolor
0.24128 0.4479 moveto
0.31224 0.38079 lineto
0.43255 0.44846 lineto
fill
0.707 0.699 0.84 setrgbcolor
0.35617 0.42601 moveto
0.46838 0.51558 lineto
0.27831 0.52711 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.27831 0.52711 moveto
0.46838 0.51558 lineto
stroke
0.665 0.696 0.868 setrgbcolor
0.35617 0.42601 moveto
0.47577 0.49984 lineto
0.46838 0.51558 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.46864 0.51503 moveto
0.47577 0.49984 lineto
stroke
0 0 0 setrgbcolor
0.56225 0.52813 moveto
0.56927 0.50382 lineto
stroke
0 0 0 setrgbcolor
0.53361 0.64235 moveto
0.55842 0.62521 lineto
stroke
0 0 0 setrgbcolor
0.55842 0.62521 moveto
0.58322 0.6045 lineto
stroke
0 0 0 setrgbcolor
0.53703 0.44712 moveto
0.55434 0.46745 lineto
stroke
0 0 0 setrgbcolor
0.51106 0.65727 moveto
0.53361 0.64235 lineto
stroke
0.668 0.705 0.875 setrgbcolor
0.31224 0.38079 moveto
0.46385 0.43958 lineto
0.43255 0.44846 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.31224 0.38079 moveto
0.37901 0.41835 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.43255 0.44846 moveto
0.46385 0.43958 lineto
stroke
0 0 0 setrgbcolor
0.58322 0.6045 moveto
0.60276 0.58014 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.27831 0.52711 moveto
0.35617 0.42601 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49023 0.67154 moveto
0.51106 0.65727 lineto
stroke
0 0 0 setrgbcolor
0.60276 0.58014 moveto
0.60981 0.55435 lineto
stroke
0.703 0.697 0.841 setrgbcolor
0.37426 0.45459 moveto
0.48418 0.54667 lineto
0.29292 0.54769 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.29292 0.54769 moveto
0.48418 0.54667 lineto
stroke
0.657 0.693 0.871 setrgbcolor
0.37426 0.45459 moveto
0.49449 0.53158 lineto
0.48418 0.54667 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.48418 0.54667 moveto
0.49449 0.53158 lineto
stroke
0 0 0 setrgbcolor
0.46866 0.68604 moveto
0.49023 0.67154 lineto
stroke
0.705 0.642 0.784 setrgbcolor
0.5025 0.43773 moveto
0.71522 0.36434 lineto
0.53703 0.44712 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.67458 0.38322 moveto
0.71522 0.36434 lineto
stroke
0.678 0.669 0.834 setrgbcolor
0.44472 0.32634 moveto
0.5025 0.43773 lineto
0.46385 0.43958 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.5025 0.43773 moveto
0.53703 0.44712 lineto
stroke
0.706 0.689 0.83 setrgbcolor
0.31224 0.38079 moveto
0.44472 0.32634 lineto
0.46385 0.43958 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.44472 0.32634 moveto
0.4559 0.39256 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.46385 0.43958 moveto
0.5025 0.43773 lineto
stroke
0 0 0 setrgbcolor
0.54734 0.48724 moveto
0.56927 0.50382 lineto
stroke
0.689 0.694 0.849 setrgbcolor
0.35617 0.42601 moveto
0.50827 0.48666 lineto
0.47577 0.49984 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.35617 0.42601 moveto
0.39217 0.44823 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47577 0.49984 moveto
0.50827 0.48666 lineto
stroke
0.717 0.561 0.676 setrgbcolor
0.33131 0.61133 moveto
0.44328 0.70029 lineto
0.41191 0.71216 lineto
fill
0.62 0.573 0.779 setrgbcolor
0.33131 0.61133 moveto
0.36428 0.59111 lineto
0.44328 0.70029 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.36375 0.63711 moveto
0.44068 0.69822 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33131 0.61133 moveto
0.36375 0.63711 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44068 0.69822 moveto
0.44328 0.70029 lineto
stroke
1 0 0 setrgbcolor
0.33131 0.61133 moveto
0.36428 0.59111 lineto
stroke
0.714 0.689 0.825 setrgbcolor
0.5025 0.43773 moveto
0.60267 0.31549 lineto
0.71522 0.36434 lineto
fill
0.71 0.684 0.822 setrgbcolor
0.44472 0.32634 moveto
0.60267 0.31549 lineto
0.5025 0.43773 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.56236 0.36469 moveto
0.60267 0.31549 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.44328 0.70029 moveto
0.46866 0.68604 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.24128 0.4479 moveto
0.31224 0.38079 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.59821 0.53193 moveto
0.60981 0.55435 lineto
stroke
0 0 0 setrgbcolor
0.41191 0.71216 moveto
0.44328 0.70029 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.29292 0.54769 moveto
0.37426 0.45459 lineto
stroke
0.703 0.648 0.791 setrgbcolor
0.50827 0.48666 moveto
0.714 0.38973 lineto
0.54734 0.48724 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.69583 0.40036 moveto
0.714 0.38973 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.50827 0.48666 moveto
0.54734 0.48724 lineto
stroke
0.716 0.693 0.826 setrgbcolor
0.50827 0.48666 moveto
0.54673 0.3621 lineto
0.714 0.38973 lineto
fill
0.709 0.685 0.824 setrgbcolor
0.35617 0.42601 moveto
0.54673 0.3621 lineto
0.50827 0.48666 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53589 0.39721 moveto
0.54673 0.3621 lineto
stroke
0.724 0.6 0.717 setrgbcolor
0.36428 0.59111 moveto
0.41191 0.71216 lineto
0.37504 0.71821 lineto
fill
0.632 0.553 0.747 setrgbcolor
0.36428 0.59111 moveto
0.41483 0.58552 lineto
0.41191 0.71216 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.36428 0.59111 moveto
0.38294 0.63854 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40139 0.68544 moveto
0.41191 0.71216 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.37504 0.71821 moveto
0.41191 0.71216 lineto
stroke
0.681 0.692 0.853 setrgbcolor
0.37426 0.45459 moveto
0.52744 0.51956 lineto
0.49449 0.53158 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.37426 0.45459 moveto
0.49449 0.53158 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49449 0.53158 moveto
0.52744 0.51956 lineto
stroke
0.713 0.647 0.781 setrgbcolor
0.33706 0.7148 moveto
0.46694 0.60394 lineto
0.37504 0.71821 lineto
fill
0 0 0 setrgbcolor
0.33706 0.7148 moveto
0.37504 0.71821 lineto
stroke
0.652 0.535 0.709 setrgbcolor
0.33706 0.7148 moveto
0.41483 0.58552 lineto
0.46694 0.60394 lineto
fill
0.689 0.642 0.797 setrgbcolor
0.30611 0.70015 moveto
0.47899 0.65285 lineto
0.33706 0.7148 lineto
fill
0.689 0.642 0.797 setrgbcolor
0.47899 0.65285 moveto
0.4868 0.65165 lineto
0.33706 0.7148 lineto
fill
0.689 0.642 0.797 setrgbcolor
0.33706 0.7148 moveto
0.4868 0.65165 lineto
0.48738 0.65162 lineto
fill
0.668 0.547 0.708 setrgbcolor
0.46694 0.60394 moveto
0.48311 0.62997 lineto
0.30611 0.70015 lineto
fill
0.668 0.547 0.708 setrgbcolor
0.30611 0.70015 moveto
0.48311 0.62997 lineto
0.47899 0.65285 lineto
fill
0.658 0.615 0.794 setrgbcolor
0.29159 0.67638 moveto
0.44381 0.7023 lineto
0.30611 0.70015 lineto
fill
0.658 0.615 0.794 setrgbcolor
0.47328 0.70732 moveto
0.45278 0.70644 lineto
0.44381 0.7023 lineto
fill
0.658 0.615 0.794 setrgbcolor
0.30611 0.70015 moveto
0.44381 0.7023 lineto
0.45278 0.70644 lineto
fill
0.68 0.559 0.711 setrgbcolor
0.29744 0.68071 moveto
0.46928 0.70671 lineto
0.3976 0.75487 lineto
fill
0.68 0.559 0.711 setrgbcolor
0.29159 0.67638 moveto
0.30775 0.67913 lineto
0.29744 0.68071 lineto
fill
0.68 0.559 0.711 setrgbcolor
0.47328 0.70732 moveto
0.29744 0.68071 lineto
0.30775 0.67913 lineto
fill
0.668 0.547 0.708 setrgbcolor
0.49466 0.64856 moveto
0.47899 0.65285 lineto
0.48311 0.62997 lineto
fill
0.689 0.642 0.797 setrgbcolor
0.49466 0.64856 moveto
0.4876 0.65153 lineto
0.47899 0.65285 lineto
fill
0.68 0.561 0.713 setrgbcolor
0.29159 0.67638 moveto
0.49466 0.64856 lineto
0.47328 0.70732 lineto
fill
0.664 0.603 0.776 setrgbcolor
0.29159 0.67638 moveto
0.29956 0.65048 lineto
0.47328 0.70732 lineto
fill
0.691 0.575 0.72 setrgbcolor
0.29249 0.76484 moveto
0.2989 0.66121 lineto
0.3976 0.75487 lineto
fill
0.691 0.575 0.72 setrgbcolor
0.29956 0.65048 moveto
0.30915 0.66069 lineto
0.2989 0.66121 lineto
fill
0.691 0.575 0.72 setrgbcolor
0.3976 0.75487 moveto
0.2989 0.66121 lineto
0.30915 0.66069 lineto
fill
0.65 0.57 0.752 setrgbcolor
0.29956 0.65048 moveto
0.32758 0.63268 lineto
0.3976 0.75487 lineto
fill
0.696 0.591 0.734 setrgbcolor
0.20502 0.72585 moveto
0.31449 0.64263 lineto
0.29249 0.76484 lineto
fill
0.696 0.591 0.734 setrgbcolor
0.32758 0.63268 moveto
0.3238 0.64693 lineto
0.31449 0.64263 lineto
fill
0.696 0.591 0.734 setrgbcolor
0.29249 0.76484 moveto
0.31449 0.64263 lineto
0.3238 0.64693 lineto
fill
0.68 0.559 0.711 setrgbcolor
0.47328 0.70732 moveto
0.46864 0.71023 lineto
0.46928 0.70671 lineto
fill
0.68 0.559 0.711 setrgbcolor
0.3976 0.75487 moveto
0.46928 0.70671 lineto
0.46864 0.71023 lineto
fill
0.718 0.648 0.778 setrgbcolor
0.56765 0.51902 moveto
0.7802 0.46097 lineto
0.59821 0.53193 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.59821 0.53193 moveto
0.72086 0.48411 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.72086 0.48411 moveto
0.7802 0.46097 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.56765 0.51902 moveto
0.59821 0.53193 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.36428 0.59111 moveto
0.41483 0.58552 lineto
stroke
0.694 0.639 0.79 setrgbcolor
0.52744 0.51956 moveto
0.70458 0.40072 lineto
0.56765 0.51902 lineto
fill
0.715 0.69 0.824 setrgbcolor
0.52744 0.51956 moveto
0.54428 0.39423 lineto
0.70458 0.40072 lineto
fill
0.706 0.681 0.823 setrgbcolor
0.37426 0.45459 moveto
0.54428 0.39423 lineto
0.52744 0.51956 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.52744 0.51956 moveto
0.54428 0.39423 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.52744 0.51956 moveto
0.56765 0.51902 lineto
stroke
0.725 0.699 0.825 setrgbcolor
0.56765 0.51902 moveto
0.70458 0.40072 lineto
0.7802 0.46097 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.56765 0.51902 moveto
0.70458 0.40072 lineto
stroke
1 0 0 setrgbcolor
0.60267 0.31549 moveto
0.71522 0.36434 lineto
stroke
1 0 0 setrgbcolor
0.70458 0.40072 moveto
0.7802 0.46097 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44313 0.70218 moveto
0.46929 0.70664 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35922 0.6879 moveto
0.44313 0.70218 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46929 0.70664 moveto
0.47328 0.70732 lineto
stroke
0.65 0.543 0.72 setrgbcolor
0.32758 0.63268 moveto
0.36239 0.63169 lineto
0.29249 0.76484 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.32682 0.63557 moveto
0.32758 0.63268 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29249 0.76484 moveto
0.30222 0.7282 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30222 0.7282 moveto
0.31547 0.67831 lineto
stroke
1 0 0 setrgbcolor
0.20502 0.72585 moveto
0.29249 0.76484 lineto
stroke
1 0 0 setrgbcolor
0.29249 0.76484 moveto
0.3976 0.75487 lineto
stroke
0.695 0.603 0.749 setrgbcolor
0.36239 0.63169 moveto
0.20502 0.72585 lineto
0.18217 0.65133 lineto
fill
0.667 0.54 0.701 setrgbcolor
0.36239 0.63169 moveto
0.38448 0.6486 lineto
0.20502 0.72585 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.20502 0.72585 moveto
0.21274 0.72123 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.21274 0.72123 moveto
0.30567 0.66563 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33907 0.64564 moveto
0.35101 0.6385 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35101 0.6385 moveto
0.36239 0.63169 lineto
stroke
1 0 0 setrgbcolor
0.18217 0.65133 moveto
0.20502 0.72585 lineto
stroke
1 0 0 setrgbcolor
0.41483 0.58552 moveto
0.46694 0.60394 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37515 0.73097 moveto
0.3976 0.75487 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.37473 0.73052 moveto
0.37515 0.73097 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.33353 0.68665 moveto
0.37473 0.73052 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.32401 0.63495 moveto
0.32758 0.63268 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.3976 0.75487 moveto
0.47328 0.70732 lineto
stroke
1 0 0 setrgbcolor
0.31224 0.38079 moveto
0.44472 0.32634 lineto
stroke
0.681 0.596 0.754 setrgbcolor
0.24396 0.57811 moveto
0.37921 0.67414 lineto
0.18217 0.65133 lineto
fill
1 0 0 setrgbcolor
0.18217 0.65133 moveto
0.24396 0.57811 lineto
stroke
1 0 0 setrgbcolor
0.54673 0.3621 moveto
0.714 0.38973 lineto
stroke
1 0 0 setrgbcolor
0.47328 0.70732 moveto
0.49466 0.64856 lineto
stroke
1 0 0 setrgbcolor
0.46694 0.60394 moveto
0.49466 0.64856 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.32758 0.63268 moveto
0.36239 0.63169 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.35617 0.42601 moveto
0.38932 0.41489 lineto
stroke
1 0 0 setrgbcolor
0.38932 0.41489 moveto
0.54673 0.3621 lineto
stroke
0.702 0.591 0.729 setrgbcolor
0.24396 0.57811 moveto
0.37921 0.67414 lineto
0.34733 0.69303 lineto
fill
0.715 0.587 0.711 setrgbcolor
0.37921 0.67414 moveto
0.2955 0.6147 lineto
0.38448 0.6486 lineto
fill
0.715 0.587 0.711 setrgbcolor
0.24396 0.57811 moveto
0.27934 0.59586 lineto
0.2955 0.6147 lineto
fill
0.715 0.587 0.711 setrgbcolor
0.38448 0.6486 moveto
0.2955 0.6147 lineto
0.27934 0.59586 lineto
fill
0.675 0.597 0.76 setrgbcolor
0.37921 0.67414 moveto
0.2955 0.6147 lineto
0.36173 0.55077 lineto
fill
0.675 0.597 0.76 setrgbcolor
0.24396 0.57811 moveto
0.36173 0.55077 lineto
0.2955 0.6147 lineto
fill
0.665 0.58 0.749 setrgbcolor
0.46226 0.5913 moveto
0.35605 0.68532 lineto
0.36173 0.55077 lineto
fill
0.665 0.58 0.749 setrgbcolor
0.34733 0.69303 moveto
0.34895 0.67704 lineto
0.35605 0.68532 lineto
fill
0.665 0.58 0.749 setrgbcolor
0.36173 0.55077 moveto
0.35605 0.68532 lineto
0.34895 0.67704 lineto
fill
0.701 0.612 0.754 setrgbcolor
0.34733 0.69303 moveto
0.30586 0.69336 lineto
0.36173 0.55077 lineto
fill
0.665 0.619 0.792 setrgbcolor
0.27806 0.67416 moveto
0.39089 0.67482 lineto
0.30586 0.69336 lineto
fill
0.665 0.619 0.792 setrgbcolor
0.30586 0.69336 moveto
0.39089 0.67482 lineto
0.42527 0.68066 lineto
fill
0.665 0.619 0.792 setrgbcolor
0.4756 0.67531 moveto
0.42527 0.68066 lineto
0.39089 0.67482 lineto
fill
0.671 0.557 0.717 setrgbcolor
0.27806 0.67416 moveto
0.4756 0.67531 lineto
0.39193 0.74693 lineto
fill
0.671 0.568 0.731 setrgbcolor
0.27806 0.67416 moveto
0.46226 0.5913 lineto
0.4756 0.67531 lineto
fill
0.668 0.599 0.768 setrgbcolor
0.27806 0.67416 moveto
0.27944 0.64629 lineto
0.4756 0.67531 lineto
fill
0.685 0.569 0.718 setrgbcolor
0.2658 0.76183 moveto
0.27833 0.65569 lineto
0.39193 0.74693 lineto
fill
0.685 0.569 0.718 setrgbcolor
0.27944 0.64629 moveto
0.29267 0.65813 lineto
0.27833 0.65569 lineto
fill
0.685 0.569 0.718 setrgbcolor
0.39193 0.74693 moveto
0.27833 0.65569 lineto
0.29267 0.65813 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.35994 0.56845 moveto
0.36173 0.55077 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35697 0.59775 moveto
0.35994 0.56845 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35566 0.61071 moveto
0.35697 0.59775 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.35264 0.64062 moveto
0.35566 0.61071 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.24396 0.57811 moveto
0.25232 0.58405 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.25232 0.58405 moveto
0.32772 0.63758 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39089 0.67482 moveto
0.4756 0.67531 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.34161 0.67453 moveto
0.39089 0.67482 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.26747 0.75648 moveto
0.30245 0.64421 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.30245 0.64421 moveto
0.30805 0.62624 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.2658 0.76183 moveto
0.26747 0.75648 lineto
stroke
1 0 0 setrgbcolor
0.2658 0.76183 moveto
0.39193 0.74693 lineto
stroke
1 0 0 setrgbcolor
0.44472 0.32634 moveto
0.60267 0.31549 lineto
stroke
1 0 0 setrgbcolor
0.37426 0.45459 moveto
0.54428 0.39423 lineto
stroke
1 0 0 setrgbcolor
0.24396 0.57811 moveto
0.36173 0.55077 lineto
stroke
0.654 0.569 0.747 setrgbcolor
0.27944 0.64629 moveto
0.30805 0.62624 lineto
0.39193 0.74693 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.27944 0.64629 moveto
0.29267 0.65813 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.29267 0.65813 moveto
0.39193 0.74693 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.27944 0.64629 moveto
0.30805 0.62624 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.54428 0.39423 moveto
0.70458 0.40072 lineto
stroke
1 0 0 setrgbcolor
0.39193 0.74693 moveto
0.4756 0.67531 lineto
stroke
1 0 0 setrgbcolor
0.36173 0.55077 moveto
0.46226 0.5913 lineto
stroke
1 0 0 setrgbcolor
0.46226 0.5913 moveto
0.4756 0.67531 lineto
stroke
0 setgray
0.002 setlinewidth
0.65131 0.02381 moveto
0.87475 0.38789 lineto
stroke
0.65131 0.02381 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
0.93868 0.85568 moveto
0.87475 0.38789 lineto
stroke
0.13892 0.23925 moveto
0.06132 0.72899 lineto
stroke
0.13892 0.23925 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.65131 0.02381 lineto
stroke
0.68112 0.53747 moveto
0.06132 0.72899 lineto
stroke
0.06132 0.72899 moveto
0.68112 0.53747 lineto
stroke
0.06132 0.72899 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.41259 0.97619 lineto
stroke
0.93868 0.85568 moveto
0.68112 0.53747 lineto
stroke
% End of Graphics
Mpend % End of picture
:[inactive; output; font = output; ]
Graphics3D[{{{Thickness[0.006], Line[{{0., 0., 0.}, {0., 0., 0.1}, 
                  {0., 0.00993396, 0.199505}, {-0.00557386, 0.038257, 0.295248}, 
                  {-0.0262128, 0.0880416, 0.379483}, 
                  {-0.0713694, 0.152996, 0.440653}, 
                  {-0.144469, 0.215742, 0.467475}, 
                  {-0.237138, 0.251502, 0.455914}, 
                  {-0.327824, 0.238608, 0.415792}, 
                  {-0.38853, 0.172472, 0.371738}, 
                  {-0.399034, 0.0745188, 0.354567}, 
                  {-0.361419, -0.0129743, 0.385064}, 
                  {-0.304149, -0.0478146, 0.459268}, 
                  {-0.269276, -0.0141581, 0.546739}, 
                  {-0.28783, 0.0639007, 0.606426}, 
                  {-0.359032, 0.133888, 0.612098}, 
                  {-0.448938, 0.146968, 0.570315}, 
                  {-0.511369, 0.0895088, 0.517393}, 
                  {-0.517517, -0.00807472, 0.496425}, 
                  {-0.473824, -0.0914802, 0.530107}, 
                  {-0.416442, -0.117091, 0.607898}, 
                  {-0.387636, -0.0771198, 0.694918}, 
                  {-0.411267, -0.000330114, 0.754458}, 
                  {-0.482621, 0.068385, 0.768123}, 
                  {-0.575893, 0.0933656, 0.742115}, 
                  {-0.660954, 0.0628868, 0.699272}, 
                  {-0.717781, -0.0119435, 0.66505}, 
                  {-0.741737, -0.108662, 0.656586}, 
                  {-0.740231, -0.20608, 0.679112}, 
                  {-0.725515, -0.291759, 0.728535}, 
                  {-0.708214, -0.363173, 0.796363}, 
                  {-0.693704, -0.424773, 0.87379}, 
                  {-0.681186, -0.483652, 0.953644}, 
                  {-0.664547, -0.545392, 1.03053}, 
                  {-0.634534, -0.61063, 1.10012}, 
                  {-0.582391, -0.672762, 1.15861}, 
                  {-0.504966, -0.717928, 1.20294}, 
                  {-0.409931, -0.728898, 1.23206}, 
                  {-0.317917, -0.693398, 1.24859}, 
                  {-0.257692, -0.614324, 1.25956}, 
                  {-0.253291, -0.515604, 1.27489}, 
                  {-0.307963, -0.436779, 1.30313}, 
                  {-0.395403, -0.41473, 1.34635}, 
                  {-0.467925, -0.460775, 1.39754}, 
                  {-0.481465, -0.548603, 1.4434}, 
                  {-0.423705, -0.625072, 1.47197}, 
                  {-0.325375, -0.641081, 1.48062}, 
                  {-0.243679, -0.583445, 1.47864}, 
                  {-0.226503, -0.484986, 1.48193}, 
                  {-0.281447, -0.404155, 1.50309}, 
                  {-0.371382, -0.387629, 1.54357}, 
                  {-0.43915, -0.441714, 1.59339}, 
                  {-0.443267, -0.531095, 1.63804}, 
                  {-0.380457, -0.603117, 1.6675}, 
                  {-0.282691, -0.618898, 1.68139}, 
                  {-0.194992, -0.571288, 1.68787}, 
                  {-0.151021, -0.48208, 1.69829}, 
                  {-0.160579, -0.385294, 1.72155}, 
                  {-0.212174, -0.309459, 1.76139}, 
                  {-0.284431, -0.268149, 1.81682}, 
                  {-0.357704, -0.260268, 1.88441}, 
                  {-0.420698, -0.276068, 1.96045}, 
                  {-0.471526, -0.303961, 2.04193}, 
                  {-0.515333, -0.335259, 2.1262}, 
                  {-0.560646, -0.366327, 2.20975}, 
                  {-0.61548, -0.398762, 2.28683}, 
                  {-0.683385, -0.438123, 2.3488}, 
                  {-0.75982, -0.491215, 2.38539}, 
                  {-0.830394, -0.561991, 2.38859}, 
                  {-0.87348, -0.647063, 2.35849}, 
                  {-0.868852, -0.733342, 2.30814}, 
                  {-0.810354, -0.80079, 2.2631}, 
                  {-0.715743, -0.831308, 2.25227}, 
                  {-0.624821, -0.820351, 2.29243}, 
                  {-0.581929, -0.783744, 2.37501}, 
                  {-0.609917, -0.752788, 2.46589}, 
                  {-0.692253, -0.757619, 2.52244}, 
                  {-0.7785, -0.808151, 2.51961}, {-0.813614, -0.886076, 2.4677}, 
                  {-0.773184, -0.955214, 2.40782}, 
                  {-0.679998, -0.984481, 2.38638}}]}}, 
        {{Thickness[0.003], RGBColor[1, 0, 0], 
              Line[{{0., 0.5, 0.}, {-0.143022, 0.476739, 0.0524056}, 
                  {-0.269819, 0.409059, 0.0657266}, 
                  {-0.362784, 0.294041, 0.0565528}, 
                  {-0.400722, 0.136324, 0.0517457}, 
                  {-0.366437, -0.038976, 0.0855734}, 
                  {-0.26249, -0.180849, 0.186785}, 
                  {-0.125786, -0.225936, 0.357663}, 
                  {-0.0255035, -0.133471, 0.557776}, 
                  {-0.0340017, 0.075058, 0.710588}, 
                  {-0.179685, 0.30356, 0.741124}, 
                  {-0.412913, 0.420746, 0.628446}, 
                  {-0.618806, 0.340032, 0.435481}, 
                  {-0.682337, 0.0883354, 0.284297}, 
                  {-0.567459, -0.194304, 0.282176}, 
                  {-0.35086, -0.33793, 0.446807}, 
                  {-0.177812, -0.256244, 0.688257}, 
                  {-0.166677, -0.00720789, 0.866439}, 
                  {-0.330953, 0.246314, 0.884343}, 
                  {-0.575264, 0.346415, 0.749099}, 
                  {-0.764111, 0.238969, 0.559436}, 
                  {-0.808964, -0.00553924, 0.435382}, 
                  {-0.712959, -0.25213, 0.4453}, 
                  {-0.552032, -0.38879, 0.577931}, 
                  {-0.418534, -0.380582, 0.766861}, 
                  {-0.37118, -0.266725, 0.938827}, 
                  {-0.418365, -0.119853, 1.05067}, 
                  {-0.53256, -0.0032841, 1.09833}, 
                  {-0.675996, 0.0499155, 1.10378}, 
                  {-0.819325, 0.0343232, 1.09578}, 
                  {-0.946509, -0.0420404, 1.09651}, 
                  {-1.04913, -0.17065, 1.11688}, {-1.11688, -0.347219, 1.15749}, 
                  {-1.13032, -0.567113, 1.21104}, 
                  {-1.06084, -0.813982, 1.26416}, 
                  {-0.881787, -1.04755, 1.29966}, 
                  {-0.590818, -1.20059, 1.30128}, 
                  {-0.234968, -1.19633, 1.26201}, 
                  {0.0810747, -0.989583, 1.19309}, 
                  {0.224369, -0.615209, 1.12683}, 
                  {0.103016, -0.208042, 1.10622}, 
                  {-0.257696, 0.0401103, 1.16153}, 
                  {-0.690978, -0.0159452, 1.2863}, 
                  {-0.95801, -0.367612, 1.43127}, 
                  {-0.889363, -0.825232, 1.52764}, 
                  {-0.508447, -1.11446, 1.52956}, 
                  {-0.0383156, -1.04912, 1.44742}, 
                  {0.231784, -0.661925, 1.34531}, {0.135514, -0.19151, 1.30078}, 
                  {-0.26082, 0.0727275, 1.35423}, 
                  {-0.707072, -0.0218941, 1.48399}, 
                  {-0.936781, -0.403672, 1.62365}, 
                  {-0.83008, -0.840433, 1.70649}, 
                  {-0.465011, -1.09454, 1.70433}, {-0.0425491, -1.0552, 1.637}, 
                  {0.242813, -0.771275, 1.55247}, {0.297002, -0.389358, 1.4966}, 
                  {0.141593, -0.0593791, 1.49248}, 
                  {-0.132322, 0.13048, 1.53761}, {-0.425205, 0.166435, 1.61354}, 
                  {-0.668661, 0.0842668, 1.69839}, 
                  {-0.834087, -0.0646562, 1.77494}, 
                  {-0.920913, -0.236656, 1.83331}, 
                  {-0.939721, -0.403341, 1.87074}, 
                  {-0.90058, -0.548223, 1.89138}, 
                  {-0.810528, -0.659546, 1.90743}, 
                  {-0.679708, -0.725424, 1.9396}, 
                  {-0.531994, -0.735243, 2.01317}, 
                  {-0.411747, -0.688208, 2.14609}, 
                  {-0.376019, -0.604607, 2.33145}, 
                  {-0.467028, -0.529764, 2.52515}, 
                  {-0.675112, -0.520401, 2.65437}, 
                  {-0.919272, -0.613194, 2.65352}, 
                  {-1.0728, -0.792464, 2.51273}, {-1.03449, -0.984059, 2.30387}, 
                  {-0.804639, -1.09112, 2.15346}, 
                  {-0.505643, -1.05625, 2.16748}, 
                  {-0.316582, -0.907201, 2.35584}, 
                  {-0.356699, -0.74707, 2.6157}, {-0.600686, -0.68925, 2.79448}, 
                  {-0.892267, -0.781784, 2.79117}}]}}, 
        {{RGBColor[1, 1, 0], EdgeForm[], 
              {Polygon[{{0., 0., 0.}, {0., 0.5, 0.}, 
                     {-0.143022, 0.476739, 0.0524056}, {0., 0., 0.1}}], 
                 Polygon[{{0., 0., 0.1}, {-0.143022, 0.476739, 0.0524056}, 
                     {-0.269819, 0.409059, 0.0657266}, 
                     {0., 0.00993396, 0.199505}}], 
                 Polygon[{{0., 0.00993396, 0.199505}, 
                     {-0.269819, 0.409059, 0.0657266}, 
                     {-0.362784, 0.294041, 0.0565528}, 
                     {-0.00557386, 0.038257, 0.295248}}], 
                 Polygon[{{-0.00557386, 0.038257, 0.295248}, 
                     {-0.362784, 0.294041, 0.0565528}, 
                     {-0.400722, 0.136324, 0.0517457}, 
                     {-0.0262128, 0.0880416, 0.379483}}], 
                 Polygon[{{-0.0262128, 0.0880416, 0.379483}, 
                     {-0.400722, 0.136324, 0.0517457}, 
                     {-0.366437, -0.038976, 0.0855734}, 
                     {-0.0713694, 0.152996, 0.440653}}], 
                 Polygon[{{-0.0713694, 0.152996, 0.440653}, 
                     {-0.366437, -0.038976, 0.0855734}, 
                     {-0.26249, -0.180849, 0.186785}, 
                     {-0.144469, 0.215742, 0.467475}}], 
                 Polygon[{{-0.144469, 0.215742, 0.467475}, 
                     {-0.26249, -0.180849, 0.186785}, 
                     {-0.125786, -0.225936, 0.357663}, 
                     {-0.237138, 0.251502, 0.455914}}], 
                 Polygon[{{-0.237138, 0.251502, 0.455914}, 
                     {-0.125786, -0.225936, 0.357663}, 
                     {-0.0255035, -0.133471, 0.557776}, 
                     {-0.327824, 0.238608, 0.415792}}], 
                 Polygon[{{-0.327824, 0.238608, 0.415792}, 
                     {-0.0255035, -0.133471, 0.557776}, 
                     {-0.0340017, 0.075058, 0.710588}, 
                     {-0.38853, 0.172472, 0.371738}}], 
                 Polygon[{{-0.38853, 0.172472, 0.371738}, 
                     {-0.0340017, 0.075058, 0.710588}, 
                     {-0.179685, 0.30356, 0.741124}, 
                     {-0.399034, 0.0745188, 0.354567}}], 
                 Polygon[{{-0.399034, 0.0745188, 0.354567}, 
                     {-0.179685, 0.30356, 0.741124}, 
                     {-0.412913, 0.420746, 0.628446}, 
                     {-0.361419, -0.0129743, 0.385064}}], 
                 Polygon[{{-0.361419, -0.0129743, 0.385064}, 
                     {-0.412913, 0.420746, 0.628446}, 
                     {-0.618806, 0.340032, 0.435481}, 
                     {-0.304149, -0.0478146, 0.459268}}], 
                 Polygon[{{-0.304149, -0.0478146, 0.459268}, 
                     {-0.618806, 0.340032, 0.435481}, 
                     {-0.682337, 0.0883354, 0.284297}, 
                     {-0.269276, -0.0141581, 0.546739}}], 
                 Polygon[{{-0.269276, -0.0141581, 0.546739}, 
                     {-0.682337, 0.0883354, 0.284297}, 
                     {-0.567459, -0.194304, 0.282176}, 
                     {-0.28783, 0.0639007, 0.606426}}], 
                 Polygon[{{-0.28783, 0.0639007, 0.606426}, 
                     {-0.567459, -0.194304, 0.282176}, 
                     {-0.35086, -0.33793, 0.446807}, 
                     {-0.359032, 0.133888, 0.612098}}], 
                 Polygon[{{-0.359032, 0.133888, 0.612098}, 
                     {-0.35086, -0.33793, 0.446807}, 
                     {-0.177812, -0.256244, 0.688257}, 
                     {-0.448938, 0.146968, 0.570315}}], 
                 Polygon[{{-0.448938, 0.146968, 0.570315}, 
                     {-0.177812, -0.256244, 0.688257}, 
                     {-0.166677, -0.00720789, 0.866439}, 
                     {-0.511369, 0.0895088, 0.517393}}], 
                 Polygon[{{-0.511369, 0.0895088, 0.517393}, 
                     {-0.166677, -0.00720789, 0.866439}, 
                     {-0.330953, 0.246314, 0.884343}, 
                     {-0.517517, -0.00807472, 0.496425}}], 
                 Polygon[{{-0.517517, -0.00807472, 0.496425}, 
                     {-0.330953, 0.246314, 0.884343}, 
                     {-0.575264, 0.346415, 0.749099}, 
                     {-0.473824, -0.0914802, 0.530107}}], 
                 Polygon[{{-0.473824, -0.0914802, 0.530107}, 
                     {-0.575264, 0.346415, 0.749099}, 
                     {-0.764111, 0.238969, 0.559436}, 
                     {-0.416442, -0.117091, 0.607898}}], 
                 Polygon[{{-0.416442, -0.117091, 0.607898}, 
                     {-0.764111, 0.238969, 0.559436}, 
                     {-0.808964, -0.00553924, 0.435382}, 
                     {-0.387636, -0.0771198, 0.694918}}], 
                 Polygon[{{-0.387636, -0.0771198, 0.694918}, 
                     {-0.808964, -0.00553924, 0.435382}, 
                     {-0.712959, -0.25213, 0.4453}, 
                     {-0.411267, -0.000330114, 0.754458}}], 
                 Polygon[{{-0.411267, -0.000330114, 0.754458}, 
                     {-0.712959, -0.25213, 0.4453}, 
                     {-0.552032, -0.38879, 0.577931}, 
                     {-0.482621, 0.068385, 0.768123}}], 
                 Polygon[{{-0.482621, 0.068385, 0.768123}, 
                     {-0.552032, -0.38879, 0.577931}, 
                     {-0.418534, -0.380582, 0.766861}, 
                     {-0.575893, 0.0933656, 0.742115}}], 
                 Polygon[{{-0.575893, 0.0933656, 0.742115}, 
                     {-0.418534, -0.380582, 0.766861}, 
                     {-0.37118, -0.266725, 0.938827}, 
                     {-0.660954, 0.0628868, 0.699272}}], 
                 Polygon[{{-0.660954, 0.0628868, 0.699272}, 
                     {-0.37118, -0.266725, 0.938827}, 
                     {-0.418365, -0.119853, 1.05067}, 
                     {-0.717781, -0.0119435, 0.66505}}], 
                 Polygon[{{-0.717781, -0.0119435, 0.66505}, 
                     {-0.418365, -0.119853, 1.05067}, 
                     {-0.53256, -0.0032841, 1.09833}, 
                     {-0.741737, -0.108662, 0.656586}}], 
                 Polygon[{{-0.741737, -0.108662, 0.656586}, 
                     {-0.53256, -0.0032841, 1.09833}, 
                     {-0.675996, 0.0499155, 1.10378}, 
                     {-0.740231, -0.20608, 0.679112}}], 
                 Polygon[{{-0.740231, -0.20608, 0.679112}, 
                     {-0.675996, 0.0499155, 1.10378}, 
                     {-0.819325, 0.0343232, 1.09578}, 
                     {-0.725515, -0.291759, 0.728535}}], 
                 Polygon[{{-0.725515, -0.291759, 0.728535}, 
                     {-0.819325, 0.0343232, 1.09578}, 
                     {-0.946509, -0.0420404, 1.09651}, 
                     {-0.708214, -0.363173, 0.796363}}], 
                 Polygon[{{-0.708214, -0.363173, 0.796363}, 
                     {-0.946509, -0.0420404, 1.09651}, 
                     {-1.04913, -0.17065, 1.11688}, 
                     {-0.693704, -0.424773, 0.87379}}], 
                 Polygon[{{-0.693704, -0.424773, 0.87379}, 
                     {-1.04913, -0.17065, 1.11688}, 
                     {-1.11688, -0.347219, 1.15749}, 
                     {-0.681186, -0.483652, 0.953644}}], 
                 Polygon[{{-0.681186, -0.483652, 0.953644}, 
                     {-1.11688, -0.347219, 1.15749}, 
                     {-1.13032, -0.567113, 1.21104}, 
                     {-0.664547, -0.545392, 1.03053}}], 
                 Polygon[{{-0.664547, -0.545392, 1.03053}, 
                     {-1.13032, -0.567113, 1.21104}, 
                     {-1.06084, -0.813982, 1.26416}, 
                     {-0.634534, -0.61063, 1.10012}}], 
                 Polygon[{{-0.634534, -0.61063, 1.10012}, 
                     {-1.06084, -0.813982, 1.26416}, 
                     {-0.881787, -1.04755, 1.29966}, 
                     {-0.582391, -0.672762, 1.15861}}], 
                 Polygon[{{-0.582391, -0.672762, 1.15861}, 
                     {-0.881787, -1.04755, 1.29966}, 
                     {-0.590818, -1.20059, 1.30128}, 
                     {-0.504966, -0.717928, 1.20294}}], 
                 Polygon[{{-0.504966, -0.717928, 1.20294}, 
                     {-0.590818, -1.20059, 1.30128}, 
                     {-0.234968, -1.19633, 1.26201}, 
                     {-0.409931, -0.728898, 1.23206}}], 
                 Polygon[{{-0.409931, -0.728898, 1.23206}, 
                     {-0.234968, -1.19633, 1.26201}, 
                     {0.0810747, -0.989583, 1.19309}, 
                     {-0.317917, -0.693398, 1.24859}}], 
                 Polygon[{{-0.317917, -0.693398, 1.24859}, 
                     {0.0810747, -0.989583, 1.19309}, 
                     {0.224369, -0.615209, 1.12683}, 
                     {-0.257692, -0.614324, 1.25956}}], 
                 Polygon[{{-0.257692, -0.614324, 1.25956}, 
                     {0.224369, -0.615209, 1.12683}, 
                     {0.103016, -0.208042, 1.10622}, 
                     {-0.253291, -0.515604, 1.27489}}], 
                 Polygon[{{-0.253291, -0.515604, 1.27489}, 
                     {0.103016, -0.208042, 1.10622}, 
                     {-0.257696, 0.0401103, 1.16153}, 
                     {-0.307963, -0.436779, 1.30313}}], 
                 Polygon[{{-0.307963, -0.436779, 1.30313}, 
                     {-0.257696, 0.0401103, 1.16153}, 
                     {-0.690978, -0.0159452, 1.2863}, 
                     {-0.395403, -0.41473, 1.34635}}], 
                 Polygon[{{-0.395403, -0.41473, 1.34635}, 
                     {-0.690978, -0.0159452, 1.2863}, 
                     {-0.95801, -0.367612, 1.43127}, 
                     {-0.467925, -0.460775, 1.39754}}], 
                 Polygon[{{-0.467925, -0.460775, 1.39754}, 
                     {-0.95801, -0.367612, 1.43127}, 
                     {-0.889363, -0.825232, 1.52764}, 
                     {-0.481465, -0.548603, 1.4434}}], 
                 Polygon[{{-0.481465, -0.548603, 1.4434}, 
                     {-0.889363, -0.825232, 1.52764}, 
                     {-0.508447, -1.11446, 1.52956}, 
                     {-0.423705, -0.625072, 1.47197}}], 
                 Polygon[{{-0.423705, -0.625072, 1.47197}, 
                     {-0.508447, -1.11446, 1.52956}, 
                     {-0.0383156, -1.04912, 1.44742}, 
                     {-0.325375, -0.641081, 1.48062}}], 
                 Polygon[{{-0.325375, -0.641081, 1.48062}, 
                     {-0.0383156, -1.04912, 1.44742}, 
                     {0.231784, -0.661925, 1.34531}, 
                     {-0.243679, -0.583445, 1.47864}}], 
                 Polygon[{{-0.243679, -0.583445, 1.47864}, 
                     {0.231784, -0.661925, 1.34531}, 
                     {0.135514, -0.19151, 1.30078}, 
                     {-0.226503, -0.484986, 1.48193}}], 
                 Polygon[{{-0.226503, -0.484986, 1.48193}, 
                     {0.135514, -0.19151, 1.30078}, 
                     {-0.26082, 0.0727275, 1.35423}, 
                     {-0.281447, -0.404155, 1.50309}}], 
                 Polygon[{{-0.281447, -0.404155, 1.50309}, 
                     {-0.26082, 0.0727275, 1.35423}, 
                     {-0.707072, -0.0218941, 1.48399}, 
                     {-0.371382, -0.387629, 1.54357}}], 
                 Polygon[{{-0.371382, -0.387629, 1.54357}, 
                     {-0.707072, -0.0218941, 1.48399}, 
                     {-0.936781, -0.403672, 1.62365}, 
                     {-0.43915, -0.441714, 1.59339}}], 
                 Polygon[{{-0.43915, -0.441714, 1.59339}, 
                     {-0.936781, -0.403672, 1.62365}, 
                     {-0.83008, -0.840433, 1.70649}, 
                     {-0.443267, -0.531095, 1.63804}}], 
                 Polygon[{{-0.443267, -0.531095, 1.63804}, 
                     {-0.83008, -0.840433, 1.70649}, 
                     {-0.465011, -1.09454, 1.70433}, 
                     {-0.380457, -0.603117, 1.6675}}], 
                 Polygon[{{-0.380457, -0.603117, 1.6675}, 
                     {-0.465011, -1.09454, 1.70433}, 
                     {-0.0425491, -1.0552, 1.637}, 
                     {-0.282691, -0.618898, 1.68139}}], 
                 Polygon[{{-0.282691, -0.618898, 1.68139}, 
                     {-0.0425491, -1.0552, 1.637}, 
                     {0.242813, -0.771275, 1.55247}, 
                     {-0.194992, -0.571288, 1.68787}}], 
                 Polygon[{{-0.194992, -0.571288, 1.68787}, 
                     {0.242813, -0.771275, 1.55247}, 
                     {0.297002, -0.389358, 1.4966}, 
                     {-0.151021, -0.48208, 1.69829}}], 
                 Polygon[{{-0.151021, -0.48208, 1.69829}, 
                     {0.297002, -0.389358, 1.4966}, 
                     {0.141593, -0.0593791, 1.49248}, 
                     {-0.160579, -0.385294, 1.72155}}], 
                 Polygon[{{-0.160579, -0.385294, 1.72155}, 
                     {0.141593, -0.0593791, 1.49248}, 
                     {-0.132322, 0.13048, 1.53761}, 
                     {-0.212174, -0.309459, 1.76139}}], 
                 Polygon[{{-0.212174, -0.309459, 1.76139}, 
                     {-0.132322, 0.13048, 1.53761}, 
                     {-0.425205, 0.166435, 1.61354}, 
                     {-0.284431, -0.268149, 1.81682}}], 
                 Polygon[{{-0.284431, -0.268149, 1.81682}, 
                     {-0.425205, 0.166435, 1.61354}, 
                     {-0.668661, 0.0842668, 1.69839}, 
                     {-0.357704, -0.260268, 1.88441}}], 
                 Polygon[{{-0.357704, -0.260268, 1.88441}, 
                     {-0.668661, 0.0842668, 1.69839}, 
                     {-0.834087, -0.0646562, 1.77494}, 
                     {-0.420698, -0.276068, 1.96045}}], 
                 Polygon[{{-0.420698, -0.276068, 1.96045}, 
                     {-0.834087, -0.0646562, 1.77494}, 
                     {-0.920913, -0.236656, 1.83331}, 
                     {-0.471526, -0.303961, 2.04193}}], 
                 Polygon[{{-0.471526, -0.303961, 2.04193}, 
                     {-0.920913, -0.236656, 1.83331}, 
                     {-0.939721, -0.403341, 1.87074}, 
                     {-0.515333, -0.335259, 2.1262}}], 
                 Polygon[{{-0.515333, -0.335259, 2.1262}, 
                     {-0.939721, -0.403341, 1.87074}, 
                     {-0.90058, -0.548223, 1.89138}, 
                     {-0.560646, -0.366327, 2.20975}}], 
                 Polygon[{{-0.560646, -0.366327, 2.20975}, 
                     {-0.90058, -0.548223, 1.89138}, 
                     {-0.810528, -0.659546, 1.90743}, 
                     {-0.61548, -0.398762, 2.28683}}], 
                 Polygon[{{-0.61548, -0.398762, 2.28683}, 
                     {-0.810528, -0.659546, 1.90743}, 
                     {-0.679708, -0.725424, 1.9396}, 
                     {-0.683385, -0.438123, 2.3488}}], 
                 Polygon[{{-0.683385, -0.438123, 2.3488}, 
                     {-0.679708, -0.725424, 1.9396}, 
                     {-0.531994, -0.735243, 2.01317}, 
                     {-0.75982, -0.491215, 2.38539}}], 
                 Polygon[{{-0.75982, -0.491215, 2.38539}, 
                     {-0.531994, -0.735243, 2.01317}, 
                     {-0.411747, -0.688208, 2.14609}, 
                     {-0.830394, -0.561991, 2.38859}}], 
                 Polygon[{{-0.830394, -0.561991, 2.38859}, 
                     {-0.411747, -0.688208, 2.14609}, 
                     {-0.376019, -0.604607, 2.33145}, 
                     {-0.87348, -0.647063, 2.35849}}], 
                 Polygon[{{-0.87348, -0.647063, 2.35849}, 
                     {-0.376019, -0.604607, 2.33145}, 
                     {-0.467028, -0.529764, 2.52515}, 
                     {-0.868852, -0.733342, 2.30814}}], 
                 Polygon[{{-0.868852, -0.733342, 2.30814}, 
                     {-0.467028, -0.529764, 2.52515}, 
                     {-0.675112, -0.520401, 2.65437}, 
                     {-0.810354, -0.80079, 2.2631}}], 
                 Polygon[{{-0.810354, -0.80079, 2.2631}, 
                     {-0.675112, -0.520401, 2.65437}, 
                     {-0.919272, -0.613194, 2.65352}, 
                     {-0.715743, -0.831308, 2.25227}}], 
                 Polygon[{{-0.715743, -0.831308, 2.25227}, 
                     {-0.919272, -0.613194, 2.65352}, 
                     {-1.0728, -0.792464, 2.51273}, 
                     {-0.624821, -0.820351, 2.29243}}], 
                 Polygon[{{-0.624821, -0.820351, 2.29243}, 
                     {-1.0728, -0.792464, 2.51273}, 
                     {-1.03449, -0.984059, 2.30387}, 
                     {-0.581929, -0.783744, 2.37501}}], 
                 Polygon[{{-0.581929, -0.783744, 2.37501}, 
                     {-1.03449, -0.984059, 2.30387}, 
                     {-0.804639, -1.09112, 2.15346}, 
                     {-0.609917, -0.752788, 2.46589}}], 
                 Polygon[{{-0.609917, -0.752788, 2.46589}, 
                     {-0.804639, -1.09112, 2.15346}, 
                     {-0.505643, -1.05625, 2.16748}, 
                     {-0.692253, -0.757619, 2.52244}}], 
                 Polygon[{{-0.692253, -0.757619, 2.52244}, 
                     {-0.505643, -1.05625, 2.16748}, 
                     {-0.316582, -0.907201, 2.35584}, 
                     {-0.7785, -0.808151, 2.51961}}], 
                 Polygon[{{-0.7785, -0.808151, 2.51961}, 
                     {-0.316582, -0.907201, 2.35584}, 
                     {-0.356699, -0.74707, 2.6157}, 
                     {-0.813614, -0.886076, 2.4677}}], 
                 Polygon[{{-0.813614, -0.886076, 2.4677}, 
                     {-0.356699, -0.74707, 2.6157}, 
                     {-0.600686, -0.68925, 2.79448}, 
                     {-0.773184, -0.955214, 2.40782}}], 
                 Polygon[{{-0.773184, -0.955214, 2.40782}, 
                     {-0.600686, -0.68925, 2.79448}, 
                     {-0.892267, -0.781784, 2.79117}, 
                     {-0.679998, -0.984481, 2.38638}}]}}}, 
        {{GrayLevel[0.25], {Line[{{0., 0., 0.}, {0., 0.5, 0.}}], 
               Line[{{0., 0., 0.1}, {-0.143022, 0.476739, 0.0524056}}], 
                 Line[{{0., 0.00993396, 0.199505}, 
                     {-0.269819, 0.409059, 0.0657266}}], 
                 Line[{{-0.00557386, 0.038257, 0.295248}, 
                     {-0.362784, 0.294041, 0.0565528}}], 
                 Line[{{-0.0262128, 0.0880416, 0.379483}, 
                     {-0.400722, 0.136324, 0.0517457}}], 
                 Line[{{-0.0713694, 0.152996, 0.440653}, 
                     {-0.366437, -0.038976, 0.0855734}}], 
                 Line[{{-0.144469, 0.215742, 0.467475}, 
                     {-0.26249, -0.180849, 0.186785}}], 
                 Line[{{-0.237138, 0.251502, 0.455914}, 
                     {-0.125786, -0.225936, 0.357663}}], 
                 Line[{{-0.327824, 0.238608, 0.415792}, 
                     {-0.0255035, -0.133471, 0.557776}}], 
                 Line[{{-0.38853, 0.172472, 0.371738}, 
                     {-0.0340017, 0.075058, 0.710588}}], 
                 Line[{{-0.399034, 0.0745188, 0.354567}, 
                     {-0.179685, 0.30356, 0.741124}}], 
                 Line[{{-0.361419, -0.0129743, 0.385064}, 
                     {-0.412913, 0.420746, 0.628446}}], 
                 Line[{{-0.304149, -0.0478146, 0.459268}, 
                     {-0.618806, 0.340032, 0.435481}}], 
                 Line[{{-0.269276, -0.0141581, 0.546739}, 
                     {-0.682337, 0.0883354, 0.284297}}], 
                 Line[{{-0.28783, 0.0639007, 0.606426}, 
                     {-0.567459, -0.194304, 0.282176}}], 
                 Line[{{-0.359032, 0.133888, 0.612098}, 
                     {-0.35086, -0.33793, 0.446807}}], 
                 Line[{{-0.448938, 0.146968, 0.570315}, 
                     {-0.177812, -0.256244, 0.688257}}], 
                 Line[{{-0.511369, 0.0895088, 0.517393}, 
                     {-0.166677, -0.00720789, 0.866439}}], 
                 Line[{{-0.517517, -0.00807472, 0.496425}, 
                     {-0.330953, 0.246314, 0.884343}}], 
                 Line[{{-0.473824, -0.0914802, 0.530107}, 
                     {-0.575264, 0.346415, 0.749099}}], 
                 Line[{{-0.416442, -0.117091, 0.607898}, 
                     {-0.764111, 0.238969, 0.559436}}], 
                 Line[{{-0.387636, -0.0771198, 0.694918}, 
                     {-0.808964, -0.00553924, 0.435382}}], 
                 Line[{{-0.411267, -0.000330114, 0.754458}, 
                     {-0.712959, -0.25213, 0.4453}}], 
                 Line[{{-0.482621, 0.068385, 0.768123}, 
                     {-0.552032, -0.38879, 0.577931}}], 
                 Line[{{-0.575893, 0.0933656, 0.742115}, 
                     {-0.418534, -0.380582, 0.766861}}], 
                 Line[{{-0.660954, 0.0628868, 0.699272}, 
                     {-0.37118, -0.266725, 0.938827}}], 
                 Line[{{-0.717781, -0.0119435, 0.66505}, 
                     {-0.418365, -0.119853, 1.05067}}], 
                 Line[{{-0.741737, -0.108662, 0.656586}, 
                     {-0.53256, -0.0032841, 1.09833}}], 
                 Line[{{-0.740231, -0.20608, 0.679112}, 
                     {-0.675996, 0.0499155, 1.10378}}], 
                 Line[{{-0.725515, -0.291759, 0.728535}, 
                     {-0.819325, 0.0343232, 1.09578}}], 
                 Line[{{-0.708214, -0.363173, 0.796363}, 
                     {-0.946509, -0.0420404, 1.09651}}], 
                 Line[{{-0.693704, -0.424773, 0.87379}, 
                     {-1.04913, -0.17065, 1.11688}}], 
                 Line[{{-0.681186, -0.483652, 0.953644}, 
                     {-1.11688, -0.347219, 1.15749}}], 
                 Line[{{-0.664547, -0.545392, 1.03053}, 
                     {-1.13032, -0.567113, 1.21104}}], 
                 Line[{{-0.634534, -0.61063, 1.10012}, 
                     {-1.06084, -0.813982, 1.26416}}], 
                 Line[{{-0.582391, -0.672762, 1.15861}, 
                     {-0.881787, -1.04755, 1.29966}}], 
                 Line[{{-0.504966, -0.717928, 1.20294}, 
                     {-0.590818, -1.20059, 1.30128}}], 
                 Line[{{-0.409931, -0.728898, 1.23206}, 
                     {-0.234968, -1.19633, 1.26201}}], 
                 Line[{{-0.317917, -0.693398, 1.24859}, 
                     {0.0810747, -0.989583, 1.19309}}], 
                 Line[{{-0.257692, -0.614324, 1.25956}, 
                     {0.224369, -0.615209, 1.12683}}], 
                 Line[{{-0.253291, -0.515604, 1.27489}, 
                     {0.103016, -0.208042, 1.10622}}], 
                 Line[{{-0.307963, -0.436779, 1.30313}, 
                     {-0.257696, 0.0401103, 1.16153}}], 
                 Line[{{-0.395403, -0.41473, 1.34635}, 
                     {-0.690978, -0.0159452, 1.2863}}], 
                 Line[{{-0.467925, -0.460775, 1.39754}, 
                     {-0.95801, -0.367612, 1.43127}}], 
                 Line[{{-0.481465, -0.548603, 1.4434}, 
                     {-0.889363, -0.825232, 1.52764}}], 
                 Line[{{-0.423705, -0.625072, 1.47197}, 
                     {-0.508447, -1.11446, 1.52956}}], 
                 Line[{{-0.325375, -0.641081, 1.48062}, 
                     {-0.0383156, -1.04912, 1.44742}}], 
                 Line[{{-0.243679, -0.583445, 1.47864}, 
                     {0.231784, -0.661925, 1.34531}}], 
                 Line[{{-0.226503, -0.484986, 1.48193}, 
                     {0.135514, -0.19151, 1.30078}}], 
                 Line[{{-0.281447, -0.404155, 1.50309}, 
                     {-0.26082, 0.0727275, 1.35423}}], 
                 Line[{{-0.371382, -0.387629, 1.54357}, 
                     {-0.707072, -0.0218941, 1.48399}}], 
                 Line[{{-0.43915, -0.441714, 1.59339}, 
                     {-0.936781, -0.403672, 1.62365}}], 
                 Line[{{-0.443267, -0.531095, 1.63804}, 
                     {-0.83008, -0.840433, 1.70649}}], 
                 Line[{{-0.380457, -0.603117, 1.6675}, 
                     {-0.465011, -1.09454, 1.70433}}], 
                 Line[{{-0.282691, -0.618898, 1.68139}, 
                     {-0.0425491, -1.0552, 1.637}}], 
                 Line[{{-0.194992, -0.571288, 1.68787}, 
                     {0.242813, -0.771275, 1.55247}}], 
                 Line[{{-0.151021, -0.48208, 1.69829}, 
                     {0.297002, -0.389358, 1.4966}}], 
                 Line[{{-0.160579, -0.385294, 1.72155}, 
                     {0.141593, -0.0593791, 1.49248}}], 
                 Line[{{-0.212174, -0.309459, 1.76139}, 
                     {-0.132322, 0.13048, 1.53761}}], 
                 Line[{{-0.284431, -0.268149, 1.81682}, 
                     {-0.425205, 0.166435, 1.61354}}], 
                 Line[{{-0.357704, -0.260268, 1.88441}, 
                     {-0.668661, 0.0842668, 1.69839}}], 
                 Line[{{-0.420698, -0.276068, 1.96045}, 
                     {-0.834087, -0.0646562, 1.77494}}], 
                 Line[{{-0.471526, -0.303961, 2.04193}, 
                     {-0.920913, -0.236656, 1.83331}}], 
                 Line[{{-0.515333, -0.335259, 2.1262}, 
                     {-0.939721, -0.403341, 1.87074}}], 
                 Line[{{-0.560646, -0.366327, 2.20975}, 
                     {-0.90058, -0.548223, 1.89138}}], 
                 Line[{{-0.61548, -0.398762, 2.28683}, 
                     {-0.810528, -0.659546, 1.90743}}], 
                 Line[{{-0.683385, -0.438123, 2.3488}, 
                     {-0.679708, -0.725424, 1.9396}}], 
                 Line[{{-0.75982, -0.491215, 2.38539}, 
                     {-0.531994, -0.735243, 2.01317}}], 
                 Line[{{-0.830394, -0.561991, 2.38859}, 
                     {-0.411747, -0.688208, 2.14609}}], 
                 Line[{{-0.87348, -0.647063, 2.35849}, 
                     {-0.376019, -0.604607, 2.33145}}], 
                 Line[{{-0.868852, -0.733342, 2.30814}, 
                     {-0.467028, -0.529764, 2.52515}}], 
                 Line[{{-0.810354, -0.80079, 2.2631}, 
                     {-0.675112, -0.520401, 2.65437}}], 
                 Line[{{-0.715743, -0.831308, 2.25227}, 
                     {-0.919272, -0.613194, 2.65352}}], 
                 Line[{{-0.624821, -0.820351, 2.29243}, 
                     {-1.0728, -0.792464, 2.51273}}], 
                 Line[{{-0.581929, -0.783744, 2.37501}, 
                     {-1.03449, -0.984059, 2.30387}}], 
                 Line[{{-0.609917, -0.752788, 2.46589}, 
                     {-0.804639, -1.09112, 2.15346}}], 
                 Line[{{-0.692253, -0.757619, 2.52244}, 
                     {-0.505643, -1.05625, 2.16748}}], 
                 Line[{{-0.7785, -0.808151, 2.51961}, 
                     {-0.316582, -0.907201, 2.35584}}], 
                 Line[{{-0.813614, -0.886076, 2.4677}, 
                     {-0.356699, -0.74707, 2.6157}}], 
                 Line[{{-0.773184, -0.955214, 2.40782}, 
                     {-0.600686, -0.68925, 2.79448}}], 
                 Line[{{-0.679998, -0.984481, 2.38638}, 
                     {-0.892267, -0.781784, 2.79117}}]}}}}, 
   BoxRatios -> {1, 1, 1}, BoxRatios -> {3, 1, 1}]
;[o]
-Graphics3D-
:[font = input; ]
clear;top=100;kappa[s_]:=10 Sin[s];tau[s_]:=3.0;ds:=0.1;
width=.2;pribbonfrenet;Show[picture,BoxRatios->{1,1,4}]
:[inactive; PostScript; output; pictureWidth = 549; pictureHeight = 383; preserveAspect; font = postscript; ]

%%Creator: Mathematica
Mpstart % Start of picture
% Scaling calculations
[
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] Mscale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 moveto
1 0 lineto
1 1 lineto
0 1 lineto
closepath
clip
newpath
%%Object: Graphics3D
gsave
0.002 setlinewidth
0.35359 0.09755 moveto
0.46015 0.22394 lineto
stroke
0.35359 0.09755 moveto
0.32475 0.86905 lineto
stroke
0.45242 0.97619 moveto
0.32475 0.86905 lineto
stroke
0.45242 0.97619 moveto
0.46015 0.22394 lineto
stroke
0.54772 0.02381 moveto
0.64777 0.15698 lineto
stroke
0.54772 0.02381 moveto
0.55681 0.80565 lineto
stroke
0.67525 0.91967 moveto
0.55681 0.80565 lineto
stroke
0.67525 0.91967 moveto
0.64777 0.15698 lineto
stroke
0.35359 0.09755 moveto
0.32475 0.86905 lineto
stroke
0.35359 0.09755 moveto
0.54772 0.02381 lineto
stroke
0.55681 0.80565 moveto
0.54772 0.02381 lineto
stroke
0.55681 0.80565 moveto
0.32475 0.86905 lineto
stroke
0.46015 0.22394 moveto
0.45242 0.97619 lineto
stroke
0.46015 0.22394 moveto
0.64777 0.15698 lineto
stroke
0.67525 0.91967 moveto
0.64777 0.15698 lineto
stroke
0.67525 0.91967 moveto
0.45242 0.97619 lineto
stroke
0.35359 0.09755 moveto
0.54772 0.02381 lineto
stroke
0.35359 0.09755 moveto
0.46015 0.22394 lineto
stroke
0.64777 0.15698 moveto
0.46015 0.22394 lineto
stroke
0.64777 0.15698 moveto
0.54772 0.02381 lineto
stroke
0.32475 0.86905 moveto
0.55681 0.80565 lineto
stroke
0.32475 0.86905 moveto
0.45242 0.97619 lineto
stroke
0.67525 0.91967 moveto
0.45242 0.97619 lineto
stroke
0.67525 0.91967 moveto
0.55681 0.80565 lineto
stroke
grestore
0.767 0.643 0.723 setrgbcolor
0.62185 0.15476 moveto
0.63287 0.16926 lineto
0.62113 0.1869 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.62185 0.15476 moveto
0.63287 0.16926 lineto
stroke
1 0 0 setrgbcolor
0.62113 0.1869 moveto
0.63287 0.16926 lineto
stroke
0.153 0 0.152 setrgbcolor
0.62345 0.19064 moveto
0.60993 0.20049 lineto
0.60027 0.21085 lineto
fill
0.539 0.414 0.659 setrgbcolor
0.62237 0.17231 moveto
0.62345 0.19064 lineto
0.60993 0.20049 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.60993 0.20049 moveto
0.62345 0.19064 lineto
stroke
1 0 0 setrgbcolor
0.60027 0.21085 moveto
0.60993 0.20049 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.62185 0.15476 moveto
0.62237 0.17231 lineto
stroke
0.221 0.56 0.935 setrgbcolor
0.55376 0.26086 moveto
0.5809 0.27258 lineto
0.57 0.26913 lineto
fill
0.664 0.575 0.745 setrgbcolor
0.58756 0.24712 moveto
0.57 0.26913 lineto
0.5894 0.27088 lineto
fill
0.637 0.506 0.685 setrgbcolor
0.55376 0.26086 moveto
0.58649 0.26035 lineto
0.5809 0.27258 lineto
fill
0.605 0.393 0.566 setrgbcolor
0.62439 0.21019 moveto
0.60027 0.21085 lineto
0.59297 0.21909 lineto
fill
0.618 0.483 0.675 setrgbcolor
0.62345 0.19064 moveto
0.60027 0.21085 lineto
0.62439 0.21019 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60027 0.21085 moveto
0.62439 0.21019 lineto
stroke
1 0 0 setrgbcolor
0.59297 0.21909 moveto
0.60027 0.21085 lineto
stroke
0.669 0.536 0.693 setrgbcolor
0.54596 0.25165 moveto
0.5695 0.27979 lineto
0.55464 0.27952 lineto
fill
0.66 0.534 0.7 setrgbcolor
0.54596 0.25165 moveto
0.5809 0.27258 lineto
0.5695 0.27979 lineto
fill
0.497 0.494 0.783 setrgbcolor
0.54596 0.25165 moveto
0.54862 0.24827 lineto
0.5695 0.27979 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.56823 0.27827 moveto
0.5695 0.27979 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54596 0.25165 moveto
0.55222 0.25914 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.54596 0.25165 moveto
0.54862 0.24827 lineto
stroke
0.646 0.517 0.691 setrgbcolor
0.59297 0.21909 moveto
0.61795 0.24936 lineto
0.62335 0.23041 lineto
fill
0.706 0.525 0.641 setrgbcolor
0.59297 0.21909 moveto
0.58866 0.22679 lineto
0.61795 0.24936 lineto
fill
0.648 0.514 0.685 setrgbcolor
0.62439 0.21019 moveto
0.59297 0.21909 lineto
0.62335 0.23041 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.59297 0.21909 moveto
0.62335 0.23041 lineto
stroke
1 0 0 setrgbcolor
0.58866 0.22679 moveto
0.59297 0.21909 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.62237 0.17231 moveto
0.62345 0.19064 lineto
stroke
0.682 0.566 0.717 setrgbcolor
0.54862 0.24827 moveto
0.55464 0.27952 lineto
0.54173 0.27327 lineto
fill
0.683 0.61 0.767 setrgbcolor
0.55851 0.25512 moveto
0.54173 0.27327 lineto
0.53613 0.2665 lineto
fill
0.566 0.487 0.725 setrgbcolor
0.54862 0.24827 moveto
0.55851 0.25512 lineto
0.55464 0.27952 lineto
fill
0.617 0.508 0.706 setrgbcolor
0.55851 0.25512 moveto
0.56788 0.27095 lineto
0.54173 0.27327 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.54173 0.27327 moveto
0.54341 0.27146 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54738 0.26716 moveto
0.55511 0.2588 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55511 0.2588 moveto
0.55851 0.25512 lineto
stroke
1 0 0 setrgbcolor
0.53613 0.2665 moveto
0.54173 0.27327 lineto
stroke
1 0 0 setrgbcolor
0.54173 0.27327 moveto
0.55464 0.27952 lineto
stroke
0.661 0.537 0.703 setrgbcolor
0.58866 0.22679 moveto
0.6065 0.26389 lineto
0.61795 0.24936 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.61288 0.24546 moveto
0.61795 0.24936 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.58866 0.22679 moveto
0.61288 0.24546 lineto
stroke
0.76 0.579 0.651 setrgbcolor
0.58866 0.22679 moveto
0.58732 0.23574 lineto
0.6065 0.26389 lineto
fill
1 0 0 setrgbcolor
0.58732 0.23574 moveto
0.58866 0.22679 lineto
stroke
0 0 0.531 setrgbcolor
0.51726 0.27981 moveto
0.53864 0.31002 lineto
0.52424 0.29 lineto
fill
0.182 0.521 0.918 setrgbcolor
0.52424 0.29 moveto
0.55042 0.30315 lineto
0.54037 0.29926 lineto
fill
0.654 0.565 0.742 setrgbcolor
0.54767 0.27409 moveto
0.54037 0.29926 lineto
0.55812 0.29968 lineto
fill
0.626 0.509 0.7 setrgbcolor
0.52424 0.29 moveto
0.55334 0.28897 lineto
0.55042 0.30315 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55331 0.27259 moveto
0.55464 0.27952 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55039 0.25744 moveto
0.55071 0.25909 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55324 0.27225 moveto
0.55331 0.27259 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54862 0.24827 moveto
0.55039 0.25744 lineto
stroke
1 0 0 setrgbcolor
0.55464 0.27952 moveto
0.55526 0.27953 lineto
stroke
1 0 0 setrgbcolor
0.5683 0.27977 moveto
0.5695 0.27979 lineto
stroke
0.667 0.556 0.719 setrgbcolor
0.58732 0.23574 moveto
0.5894 0.27088 lineto
0.6065 0.26389 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.58198 0.27021 moveto
0.5894 0.27088 lineto
stroke
0.95 0.75 0.289 setrgbcolor
0.58732 0.23574 moveto
0.58756 0.24712 lineto
0.5894 0.27088 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.58756 0.24712 moveto
0.5894 0.27088 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5894 0.27088 moveto
0.6065 0.26389 lineto
stroke
0.643 0.528 0.708 setrgbcolor
0.53613 0.2665 moveto
0.56788 0.27095 lineto
0.56873 0.28871 lineto
fill
0.477 0.707 0.97 setrgbcolor
0.53613 0.2665 moveto
0.53944 0.2657 lineto
0.56788 0.27095 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53613 0.2665 moveto
0.54019 0.26707 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5414 0.26724 moveto
0.56788 0.27095 lineto
stroke
1 0 0 setrgbcolor
0.53613 0.2665 moveto
0.53944 0.2657 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.54862 0.24827 moveto
0.55851 0.25512 lineto
stroke
0.668 0.537 0.695 setrgbcolor
0.51726 0.27981 moveto
0.53864 0.31002 lineto
0.52338 0.3081 lineto
fill
0.652 0.532 0.705 setrgbcolor
0.51726 0.27981 moveto
0.55042 0.30315 lineto
0.53864 0.31002 lineto
fill
0.518 0.489 0.763 setrgbcolor
0.51726 0.27981 moveto
0.52128 0.277 lineto
0.53864 0.31002 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.52352 0.28866 moveto
0.5238 0.28905 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51726 0.27981 moveto
0.52352 0.28866 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51726 0.27981 moveto
0.52128 0.277 lineto
stroke
0 0 0 setrgbcolor
0.62345 0.19064 moveto
0.62439 0.21019 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.58732 0.23574 moveto
0.6065 0.26389 lineto
stroke
1 0 0 setrgbcolor
0.58732 0.23574 moveto
0.58756 0.24712 lineto
stroke
1 0 0 setrgbcolor
0.5695 0.27979 moveto
0.5809 0.27258 lineto
stroke
0.751 0.244 0.002 setrgbcolor
0.46568 0.31777 moveto
0.47634 0.32434 lineto
0.49809 0.3416 lineto
fill
0.644 0.487 0.655 setrgbcolor
0.47634 0.32434 moveto
0.50815 0.33243 lineto
0.49809 0.3416 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.49505 0.33919 moveto
0.49809 0.3416 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.47634 0.32434 moveto
0.49505 0.33919 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.46568 0.31777 moveto
0.47634 0.32434 lineto
stroke
0.686 0.571 0.72 setrgbcolor
0.52128 0.277 moveto
0.52338 0.3081 lineto
0.51154 0.30158 lineto
fill
0.578 0.489 0.717 setrgbcolor
0.52128 0.277 moveto
0.53163 0.28535 lineto
0.52338 0.3081 lineto
fill
0.695 0.641 0.792 setrgbcolor
0.53163 0.28535 moveto
0.51154 0.30158 lineto
0.50704 0.29696 lineto
fill
0.623 0.509 0.703 setrgbcolor
0.53163 0.28535 moveto
0.54006 0.30217 lineto
0.51154 0.30158 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51154 0.30158 moveto
0.51248 0.30083 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51559 0.29831 moveto
0.52521 0.29054 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52521 0.29054 moveto
0.52711 0.28901 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52711 0.28901 moveto
0.53163 0.28535 lineto
stroke
1 0 0 setrgbcolor
0.50891 0.29888 moveto
0.51154 0.30158 lineto
stroke
1 0 0 setrgbcolor
0.51154 0.30158 moveto
0.52338 0.3081 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52295 0.30182 moveto
0.52338 0.3081 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.5219 0.2861 moveto
0.52215 0.28983 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.52128 0.277 moveto
0.5219 0.2861 lineto
stroke
0.65 0.598 0.783 setrgbcolor
0.49232 0.33185 moveto
0.51147 0.33597 lineto
0.51312 0.32026 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.6065 0.26389 moveto
0.61795 0.24936 lineto
stroke
0.656 0.547 0.719 setrgbcolor
0.53944 0.2657 moveto
0.55812 0.29968 lineto
0.56873 0.28871 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53944 0.2657 moveto
0.56873 0.28871 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.55116 0.29952 moveto
0.55812 0.29968 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.53944 0.2657 moveto
0.54767 0.27409 lineto
stroke
0.854 0.548 0.47 setrgbcolor
0.46005 0.31506 moveto
0.46568 0.31777 lineto
0.48507 0.3476 lineto
fill
0.677 0.522 0.668 setrgbcolor
0.46568 0.31777 moveto
0.49809 0.3416 lineto
0.48507 0.3476 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.48021 0.34013 moveto
0.48507 0.3476 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46568 0.31777 moveto
0.48021 0.34013 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.46005 0.31506 moveto
0.46568 0.31777 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.58649 0.26035 moveto
0.58756 0.24712 lineto
stroke
1 0 0 setrgbcolor
0.5809 0.27258 moveto
0.58649 0.26035 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.62335 0.23041 moveto
0.62439 0.21019 lineto
stroke
0.648 0.529 0.705 setrgbcolor
0.50704 0.29696 moveto
0.5398 0.32026 lineto
0.54006 0.30217 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53275 0.30102 moveto
0.54006 0.30217 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50964 0.29737 moveto
0.53275 0.30102 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50704 0.29696 moveto
0.50964 0.29737 lineto
stroke
0.686 0.14 0 setrgbcolor
0.50704 0.29696 moveto
0.50888 0.29886 lineto
0.5398 0.32026 lineto
fill
1 0 0 setrgbcolor
0.50704 0.29696 moveto
0.50888 0.29886 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.52128 0.277 moveto
0.53163 0.28535 lineto
stroke
0 0 0 setrgbcolor
0.55851 0.25512 moveto
0.56788 0.27095 lineto
stroke
0 0 0 setrgbcolor
0.61795 0.24936 moveto
0.62335 0.23041 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.54767 0.27409 moveto
0.54782 0.27445 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.54782 0.27445 moveto
0.55812 0.29968 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.55812 0.29968 moveto
0.56873 0.28871 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.53996 0.30925 moveto
0.55042 0.30315 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.51147 0.33597 moveto
0.51312 0.32026 lineto
stroke
0.664 0.57 0.739 setrgbcolor
0.51253 0.30769 moveto
0.51147 0.33597 lineto
0.52915 0.33258 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.50564 0.33471 moveto
0.51147 0.33597 lineto
stroke
0.961 0.778 0.61 setrgbcolor
0.46005 0.31506 moveto
0.45775 0.35623 lineto
0.45773 0.31719 lineto
fill
0.716 0.56 0.676 setrgbcolor
0.46005 0.31506 moveto
0.47123 0.35189 lineto
0.45775 0.35623 lineto
fill
0.7 0.551 0.681 setrgbcolor
0.46005 0.31506 moveto
0.48507 0.3476 lineto
0.47123 0.35189 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.46005 0.31506 moveto
0.47123 0.35189 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.45773 0.31719 moveto
0.46005 0.31506 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.55245 0.28663 moveto
0.55334 0.28897 lineto
stroke
1 0 0 setrgbcolor
0.54767 0.27409 moveto
0.55245 0.28663 lineto
stroke
0.661 0.549 0.717 setrgbcolor
0.50888 0.29886 moveto
0.52915 0.33258 lineto
0.5398 0.32026 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.50888 0.29886 moveto
0.5398 0.32026 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51147 0.33597 moveto
0.52915 0.33258 lineto
stroke
0.907 0.587 0.429 setrgbcolor
0.50888 0.29886 moveto
0.51253 0.30769 lineto
0.52915 0.33258 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.50888 0.29886 moveto
0.51253 0.30769 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.56788 0.27095 moveto
0.56873 0.28871 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.55042 0.30315 moveto
0.55334 0.28897 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.53163 0.28535 moveto
0.54006 0.30217 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51253 0.30769 moveto
0.52915 0.33258 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.52915 0.33258 moveto
0.5398 0.32026 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.51253 0.30769 moveto
0.51312 0.32026 lineto
stroke
0.742 0.598 0.697 setrgbcolor
0.45773 0.31719 moveto
0.45775 0.35623 lineto
0.44486 0.36168 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.45773 0.31719 moveto
0.45775 0.35623 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.45676 0.3236 moveto
0.45773 0.31719 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.47123 0.35189 moveto
0.48507 0.3476 lineto
stroke
1 0 0 setrgbcolor
0.48507 0.3476 moveto
0.49809 0.3416 lineto
stroke
1 0 0 setrgbcolor
0.45775 0.35623 moveto
0.47123 0.35189 lineto
stroke
1 0 0 setrgbcolor
0.49809 0.3416 moveto
0.50815 0.33243 lineto
stroke
1 0 0 setrgbcolor
0.50815 0.33243 moveto
0.51312 0.32026 lineto
stroke
1 0 0 setrgbcolor
0.44486 0.36168 moveto
0.45775 0.35623 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.5398 0.32026 moveto
0.54006 0.30217 lineto
stroke
0.778 0.658 0.73 setrgbcolor
0.45676 0.3236 moveto
0.44486 0.36168 lineto
0.43259 0.36814 lineto
fill
0.097 0 0.403 setrgbcolor
0.45676 0.3236 moveto
0.45579 0.33277 lineto
0.44486 0.36168 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.44486 0.36168 moveto
0.45676 0.3236 lineto
stroke
1 0 0 setrgbcolor
0.43259 0.36814 moveto
0.44486 0.36168 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.45579 0.33277 moveto
0.45676 0.3236 lineto
stroke
0.834 0.774 0.794 setrgbcolor
0.45579 0.33277 moveto
0.43259 0.36814 lineto
0.42171 0.37436 lineto
fill
0.454 0.269 0.539 setrgbcolor
0.45579 0.33277 moveto
0.45456 0.34283 lineto
0.43259 0.36814 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43259 0.36814 moveto
0.45579 0.33277 lineto
stroke
1 0 0 setrgbcolor
0.42171 0.37436 moveto
0.43259 0.36814 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.45456 0.34283 moveto
0.45579 0.33277 lineto
stroke
0.846 0.974 0.873 setrgbcolor
0.45456 0.34283 moveto
0.42171 0.37436 lineto
0.41449 0.37829 lineto
fill
0.549 0.347 0.56 setrgbcolor
0.45456 0.34283 moveto
0.454 0.35195 lineto
0.42171 0.37436 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42171 0.37436 moveto
0.45456 0.34283 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.454 0.35195 moveto
0.45456 0.34283 lineto
stroke
0.49 0.876 0.685 setrgbcolor
0.454 0.35195 moveto
0.41449 0.37829 lineto
0.41496 0.37759 lineto
fill
0.588 0.37 0.552 setrgbcolor
0.454 0.35195 moveto
0.45604 0.35857 lineto
0.41449 0.37829 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.41449 0.37829 moveto
0.454 0.35195 lineto
stroke
1 0 0 setrgbcolor
0.41449 0.37829 moveto
0.41496 0.37759 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.454 0.35195 moveto
0.45604 0.35857 lineto
stroke
0.505 0.909 0.831 setrgbcolor
0.45604 0.35857 moveto
0.41496 0.37759 lineto
0.428 0.37064 lineto
fill
0.601 0.348 0.506 setrgbcolor
0.45604 0.35857 moveto
0.463 0.36176 lineto
0.41496 0.37759 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.41496 0.37759 moveto
0.45604 0.35857 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.45604 0.35857 moveto
0.463 0.36176 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.41496 0.37759 moveto
0.428 0.37064 lineto
stroke
0.767 0.808 0.885 setrgbcolor
0.51884 0.40338 moveto
0.50348 0.41806 lineto
0.46102 0.43434 lineto
fill
0.551 0.87 0.585 setrgbcolor
0.53622 0.38711 moveto
0.50348 0.41806 lineto
0.51884 0.40338 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.50348 0.41806 moveto
0.51884 0.40338 lineto
stroke
0.767 0.748 0.835 setrgbcolor
0.53622 0.38711 moveto
0.55206 0.38804 lineto
0.50348 0.41806 lineto
fill
1 0 0 setrgbcolor
0.46102 0.43434 moveto
0.50348 0.41806 lineto
stroke
1 0 0 setrgbcolor
0.50348 0.41806 moveto
0.55206 0.38804 lineto
stroke
0.784 0.7 0.77 setrgbcolor
0.54311 0.37205 moveto
0.55206 0.38804 lineto
0.53622 0.38711 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.53622 0.38711 moveto
0.55206 0.38804 lineto
stroke
0.748 0.687 0.793 setrgbcolor
0.54311 0.37205 moveto
0.58123 0.35738 lineto
0.55206 0.38804 lineto
fill
1 0 0 setrgbcolor
0.55206 0.38804 moveto
0.58123 0.35738 lineto
stroke
0.745 0.792 0.89 setrgbcolor
0.50045 0.41538 moveto
0.46102 0.43434 lineto
0.44996 0.42974 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.46102 0.43434 moveto
0.50045 0.41538 lineto
stroke
1 0 0 setrgbcolor
0.44996 0.42974 moveto
0.46102 0.43434 lineto
stroke
0.707 0.73 0.868 setrgbcolor
0.45685 0.35795 moveto
0.47652 0.36162 lineto
0.428 0.37064 lineto
fill
1 0 0 setrgbcolor
0.428 0.37064 moveto
0.45685 0.35795 lineto
stroke
0.617 0.776 0.956 setrgbcolor
0.45685 0.35795 moveto
0.49612 0.35968 lineto
0.47652 0.36162 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.45685 0.35795 moveto
0.47652 0.36162 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47652 0.36162 moveto
0.49612 0.35968 lineto
stroke
0.759 0.839 0.912 setrgbcolor
0.52588 0.4428 moveto
0.50606 0.45749 lineto
0.46597 0.47113 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51666 0.44963 moveto
0.52588 0.4428 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.50606 0.45749 moveto
0.51666 0.44963 lineto
stroke
0.773 0.787 0.864 setrgbcolor
0.54431 0.42719 moveto
0.55767 0.42808 lineto
0.50606 0.45749 lineto
fill
1 0 0 setrgbcolor
0.46597 0.47113 moveto
0.50606 0.45749 lineto
stroke
1 0 0 setrgbcolor
0.50606 0.45749 moveto
0.55767 0.42808 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.50045 0.41538 moveto
0.51884 0.40338 lineto
stroke
0 0 0 setrgbcolor
0.51884 0.40338 moveto
0.53622 0.38711 lineto
stroke
0 0 0 setrgbcolor
0.53622 0.38711 moveto
0.54311 0.37205 lineto
stroke
0.728 0.615 0.731 setrgbcolor
0.53606 0.36229 moveto
0.58123 0.35738 lineto
0.54311 0.37205 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.54311 0.37205 moveto
0.58123 0.35738 lineto
stroke
0.73 0.655 0.775 setrgbcolor
0.53606 0.36229 moveto
0.57778 0.33782 lineto
0.58123 0.35738 lineto
fill
1 0 0 setrgbcolor
0.57778 0.33782 moveto
0.58123 0.35738 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49202 0.41928 moveto
0.50045 0.41538 lineto
stroke
0.801 0.733 0.788 setrgbcolor
0.55125 0.41335 moveto
0.55767 0.42808 lineto
0.54431 0.42719 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.54431 0.42719 moveto
0.55767 0.42808 lineto
stroke
0.757 0.714 0.812 setrgbcolor
0.55125 0.41335 moveto
0.58984 0.39688 lineto
0.55767 0.42808 lineto
fill
1 0 0 setrgbcolor
0.55767 0.42808 moveto
0.58984 0.39688 lineto
stroke
0.685 0.588 0.74 setrgbcolor
0.49612 0.35968 moveto
0.54536 0.3342 lineto
0.51814 0.35881 lineto
fill
0.713 0.663 0.799 setrgbcolor
0.49612 0.35968 moveto
0.49942 0.34342 lineto
0.54536 0.3342 lineto
fill
0.705 0.656 0.798 setrgbcolor
0.45685 0.35795 moveto
0.49942 0.34342 lineto
0.49612 0.35968 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.49612 0.35968 moveto
0.49942 0.34342 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49612 0.35968 moveto
0.51814 0.35881 lineto
stroke
0 0 0 setrgbcolor
0.53606 0.36229 moveto
0.54311 0.37205 lineto
stroke
0.734 0.792 0.898 setrgbcolor
0.50786 0.4538 moveto
0.46597 0.47113 lineto
0.45985 0.46468 lineto
fill
0 0 0 setrgbcolor
0.50786 0.4538 moveto
0.50133 0.45689 lineto
0.46597 0.47113 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4744 0.46764 moveto
0.50786 0.4538 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.46597 0.47113 moveto
0.4744 0.46764 lineto
stroke
1 0 0 setrgbcolor
0.45985 0.46468 moveto
0.46597 0.47113 lineto
stroke
1 0 0 setrgbcolor
0.45685 0.35795 moveto
0.49942 0.34342 lineto
stroke
0.727 0.721 0.844 setrgbcolor
0.47983 0.40864 moveto
0.49202 0.41928 lineto
0.44996 0.42974 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.44996 0.42974 moveto
0.49202 0.41928 lineto
stroke
1 0 0 setrgbcolor
0.44996 0.42974 moveto
0.47983 0.40864 lineto
stroke
0.651 0.71 0.89 setrgbcolor
0.47983 0.40864 moveto
0.49964 0.4155 lineto
0.49202 0.41928 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.49202 0.41928 moveto
0.49964 0.4155 lineto
stroke
0.703 0.59 0.726 setrgbcolor
0.51814 0.35881 moveto
0.57778 0.33782 lineto
0.53606 0.36229 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53606 0.36229 moveto
0.57778 0.33782 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51814 0.35881 moveto
0.53606 0.36229 lineto
stroke
0.718 0.647 0.777 setrgbcolor
0.51814 0.35881 moveto
0.54536 0.3342 lineto
0.57778 0.33782 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51814 0.35881 moveto
0.54536 0.3342 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.50786 0.4538 moveto
0.52588 0.4428 lineto
stroke
0 0 0 setrgbcolor
0.52588 0.4428 moveto
0.54431 0.42719 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.54536 0.3342 moveto
0.57778 0.33782 lineto
stroke
0 0 0.011 setrgbcolor
0.55102 0.49967 moveto
0.53729 0.52007 lineto
0.55277 0.50053 lineto
fill
0.525 0.268 0.467 setrgbcolor
0.55102 0.49967 moveto
0.51869 0.52261 lineto
0.53729 0.52007 lineto
fill
0 0 0.055 setrgbcolor
0.56597 0.48127 moveto
0.55277 0.50053 lineto
0.55102 0.49967 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55102 0.49967 moveto
0.55277 0.50053 lineto
stroke
1 0 0 setrgbcolor
0.51869 0.52261 moveto
0.55102 0.49967 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.54431 0.42719 moveto
0.55125 0.41335 lineto
stroke
0.508 0.222 0.414 setrgbcolor
0.53729 0.52007 moveto
0.51869 0.52261 lineto
0.49183 0.54066 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51869 0.52261 moveto
0.53729 0.52007 lineto
stroke
1 0 0 setrgbcolor
0.49183 0.54066 moveto
0.51869 0.52261 lineto
stroke
0.731 0.621 0.735 setrgbcolor
0.54139 0.40693 moveto
0.58984 0.39688 lineto
0.55125 0.41335 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.55125 0.41335 moveto
0.58984 0.39688 lineto
stroke
0.737 0.671 0.786 setrgbcolor
0.54139 0.40693 moveto
0.58106 0.38027 lineto
0.58984 0.39688 lineto
fill
1 0 0 setrgbcolor
0.58106 0.38027 moveto
0.58984 0.39688 lineto
stroke
0.701 0.687 0.833 setrgbcolor
0.47983 0.40864 moveto
0.51997 0.40908 lineto
0.49964 0.4155 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.47983 0.40864 moveto
0.49964 0.4155 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49964 0.4155 moveto
0.51997 0.40908 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.49942 0.34342 moveto
0.54536 0.3342 lineto
stroke
0.606 0.359 0.517 setrgbcolor
0.52255 0.53909 moveto
0.49183 0.54066 lineto
0.47217 0.55426 lineto
fill
0.625 0.445 0.619 setrgbcolor
0.53729 0.52007 moveto
0.49183 0.54066 lineto
0.52255 0.53909 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.49183 0.54066 moveto
0.52255 0.53909 lineto
stroke
1 0 0 setrgbcolor
0.47217 0.55426 moveto
0.49183 0.54066 lineto
stroke
0.826 0.761 0.789 setrgbcolor
0.56597 0.48127 moveto
0.58348 0.47297 lineto
0.55277 0.50053 lineto
fill
0.818 0.726 0.762 setrgbcolor
0.57256 0.46419 moveto
0.58348 0.47297 lineto
0.56597 0.48127 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.56597 0.48127 moveto
0.58348 0.47297 lineto
stroke
0.779 0.733 0.81 setrgbcolor
0.57256 0.46419 moveto
0.60688 0.44614 lineto
0.58348 0.47297 lineto
fill
1 0 0 setrgbcolor
0.58348 0.47297 moveto
0.60688 0.44614 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.54139 0.40693 moveto
0.55125 0.41335 lineto
stroke
0.703 0.595 0.732 setrgbcolor
0.51997 0.40908 moveto
0.58106 0.38027 lineto
0.54139 0.40693 lineto
fill
0.725 0.658 0.783 setrgbcolor
0.51997 0.40908 moveto
0.53483 0.38642 lineto
0.58106 0.38027 lineto
fill
0.712 0.64 0.775 setrgbcolor
0.47983 0.40864 moveto
0.53483 0.38642 lineto
0.51997 0.40908 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.51997 0.40908 moveto
0.53483 0.38642 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51997 0.40908 moveto
0.54139 0.40693 lineto
stroke
0.72 0.71 0.84 setrgbcolor
0.49049 0.44495 moveto
0.50133 0.45689 lineto
0.45985 0.46468 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.45985 0.46468 moveto
0.50133 0.45689 lineto
stroke
0.642 0.691 0.88 setrgbcolor
0.49049 0.44495 moveto
0.51046 0.45341 lineto
0.50133 0.45689 lineto
fill
0 0 0 setrgbcolor
0.006 setlinewidth
0.50133 0.45689 moveto
0.51046 0.45341 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.54139 0.40693 moveto
0.58106 0.38027 lineto
stroke
1 0 0 setrgbcolor
0.45985 0.46468 moveto
0.49049 0.44495 lineto
stroke
0.655 0.479 0.634 setrgbcolor
0.47217 0.55426 moveto
0.49801 0.5763 lineto
0.50966 0.55769 lineto
fill
0.685 0.472 0.592 setrgbcolor
0.47217 0.55426 moveto
0.4592 0.56446 lineto
0.49801 0.5763 lineto
fill
0.655 0.48 0.636 setrgbcolor
0.52255 0.53909 moveto
0.47217 0.55426 lineto
0.50966 0.55769 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.47217 0.55426 moveto
0.50966 0.55769 lineto
stroke
1 0 0 setrgbcolor
0.4592 0.56446 moveto
0.47217 0.55426 lineto
stroke
1 0 0 setrgbcolor
0.47983 0.40864 moveto
0.53483 0.38642 lineto
stroke
0.743 0.624 0.727 setrgbcolor
0.56861 0.45195 moveto
0.60688 0.44614 lineto
0.57256 0.46419 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.57256 0.46419 moveto
0.60688 0.44614 lineto
stroke
0.747 0.671 0.776 setrgbcolor
0.56861 0.45195 moveto
0.61038 0.42533 lineto
0.60688 0.44614 lineto
fill
1 0 0 setrgbcolor
0.60688 0.44614 moveto
0.61038 0.42533 lineto
stroke
1 0 0 setrgbcolor
0.53483 0.38642 moveto
0.58106 0.38027 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.53729 0.52007 moveto
0.55277 0.50053 lineto
stroke
0 0 0 setrgbcolor
0.55277 0.50053 moveto
0.56597 0.48127 lineto
stroke
0.689 0.674 0.83 setrgbcolor
0.49049 0.44495 moveto
0.53093 0.4482 lineto
0.51046 0.45341 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.49049 0.44495 moveto
0.51046 0.45341 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.51046 0.45341 moveto
0.53093 0.4482 lineto
stroke
0.674 0.504 0.647 setrgbcolor
0.4592 0.56446 moveto
0.48595 0.595 lineto
0.49801 0.5763 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4592 0.56446 moveto
0.49801 0.5763 lineto
stroke
0.719 0.506 0.601 setrgbcolor
0.4592 0.56446 moveto
0.45156 0.57235 lineto
0.48595 0.595 lineto
fill
1 0 0 setrgbcolor
0.45156 0.57235 moveto
0.4592 0.56446 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.52255 0.53909 moveto
0.53729 0.52007 lineto
stroke
0 0 0 setrgbcolor
0.56597 0.48127 moveto
0.57256 0.46419 lineto
stroke
0 0 0 setrgbcolor
0.56861 0.45195 moveto
0.57256 0.46419 lineto
stroke
0 0 0 setrgbcolor
0.50966 0.55769 moveto
0.52255 0.53909 lineto
stroke
0.694 0.584 0.727 setrgbcolor
0.53093 0.4482 moveto
0.58708 0.41728 lineto
0.55329 0.44665 lineto
fill
0.718 0.643 0.773 setrgbcolor
0.53093 0.4482 moveto
0.54113 0.42525 lineto
0.58708 0.41728 lineto
fill
0.706 0.629 0.768 setrgbcolor
0.49049 0.44495 moveto
0.54113 0.42525 lineto
0.53093 0.4482 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.53093 0.4482 moveto
0.54113 0.42525 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.53093 0.4482 moveto
0.55329 0.44665 lineto
stroke
0.713 0.593 0.72 setrgbcolor
0.55329 0.44665 moveto
0.61038 0.42533 lineto
0.56861 0.45195 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.60361 0.42964 moveto
0.61038 0.42533 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.56861 0.45195 moveto
0.60361 0.42964 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.55329 0.44665 moveto
0.56861 0.45195 lineto
stroke
0.689 0.525 0.659 setrgbcolor
0.45156 0.57235 moveto
0.47163 0.613 lineto
0.48595 0.595 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.45664 0.57569 moveto
0.48595 0.595 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.45156 0.57235 moveto
0.45664 0.57569 lineto
stroke
0.774 0.557 0.605 setrgbcolor
0.45156 0.57235 moveto
0.44791 0.57895 lineto
0.47163 0.613 lineto
fill
1 0 0 setrgbcolor
0.44791 0.57895 moveto
0.45156 0.57235 lineto
stroke
0.728 0.646 0.767 setrgbcolor
0.55329 0.44665 moveto
0.58708 0.41728 lineto
0.61038 0.42533 lineto
fill
1 0 0 setrgbcolor
0.58708 0.41728 moveto
0.61038 0.42533 lineto
stroke
1 0 0 setrgbcolor
0.49049 0.44495 moveto
0.54113 0.42525 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.55329 0.44665 moveto
0.58708 0.41728 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.49801 0.5763 moveto
0.50966 0.55769 lineto
stroke
0 0 0 setrgbcolor
0.48595 0.595 moveto
0.49801 0.5763 lineto
stroke
0.7 0.544 0.672 setrgbcolor
0.44791 0.57895 moveto
0.4539 0.62825 lineto
0.47163 0.613 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.45039 0.58252 moveto
0.47163 0.613 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44791 0.57895 moveto
0.45039 0.58252 lineto
stroke
0.95 0.718 0.552 setrgbcolor
0.44791 0.57895 moveto
0.44702 0.58542 lineto
0.4539 0.62825 lineto
fill
1 0 0 setrgbcolor
0.44702 0.58542 moveto
0.44791 0.57895 lineto
stroke
1 0 0 setrgbcolor
0.54113 0.42525 moveto
0.58708 0.41728 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47163 0.613 moveto
0.48595 0.595 lineto
stroke
0.707 0.561 0.686 setrgbcolor
0.44702 0.58542 moveto
0.43338 0.63773 lineto
0.4539 0.62825 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4475 0.58841 moveto
0.4539 0.62825 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44702 0.58542 moveto
0.4475 0.58841 lineto
stroke
1 0 0 setrgbcolor
0.44702 0.58542 moveto
0.44742 0.59308 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4539 0.62825 moveto
0.47163 0.613 lineto
stroke
0.432 0.288 0.584 setrgbcolor
0.43338 0.63773 moveto
0.44742 0.59308 lineto
0.44697 0.60292 lineto
fill
0.708 0.573 0.701 setrgbcolor
0.43338 0.63773 moveto
0.41306 0.63844 lineto
0.44742 0.59308 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.44688 0.59481 moveto
0.44742 0.59308 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43338 0.63773 moveto
0.43984 0.61719 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44037 0.61549 moveto
0.44688 0.59481 lineto
stroke
1 0 0 setrgbcolor
0.44697 0.60292 moveto
0.44742 0.59308 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.43338 0.63773 moveto
0.4539 0.62825 lineto
stroke
0.668 0.557 0.72 setrgbcolor
0.39335 0.61227 moveto
0.42739 0.6235 lineto
0.39795 0.62917 lineto
fill
0.69 0.581 0.728 setrgbcolor
0.39795 0.62917 moveto
0.43749 0.61642 lineto
0.41306 0.63844 lineto
fill
0.69 0.581 0.728 setrgbcolor
0.44308 0.61462 moveto
0.43965 0.61734 lineto
0.43749 0.61642 lineto
fill
0.69 0.581 0.728 setrgbcolor
0.41306 0.63844 moveto
0.43749 0.61642 lineto
0.43965 0.61734 lineto
fill
0.668 0.557 0.72 setrgbcolor
0.39795 0.62917 moveto
0.42739 0.6235 lineto
0.42761 0.62409 lineto
fill
0.668 0.557 0.72 setrgbcolor
0.434 0.62567 moveto
0.43087 0.62598 lineto
0.42865 0.62391 lineto
fill
0.668 0.557 0.72 setrgbcolor
0.39795 0.62917 moveto
0.42865 0.62391 lineto
0.43087 0.62598 lineto
fill
0.659 0.486 0.638 setrgbcolor
0.39795 0.62917 moveto
0.44697 0.60292 lineto
0.44308 0.61462 lineto
fill
0.69 0.516 0.647 setrgbcolor
0.39335 0.61227 moveto
0.434 0.62567 lineto
0.42073 0.63182 lineto
fill
0.714 0.554 0.67 setrgbcolor
0.40791 0.62938 moveto
0.40318 0.60193 lineto
0.42073 0.63182 lineto
fill
0.688 0.522 0.656 setrgbcolor
0.39335 0.61227 moveto
0.44308 0.61462 lineto
0.434 0.62567 lineto
fill
0.672 0.551 0.709 setrgbcolor
0.39335 0.61227 moveto
0.40183 0.59411 lineto
0.434 0.62567 lineto
fill
0.714 0.554 0.67 setrgbcolor
0.40284 0.59995 moveto
0.40419 0.60235 lineto
0.40318 0.60193 lineto
fill
0.714 0.554 0.67 setrgbcolor
0.42073 0.63182 moveto
0.40318 0.60193 lineto
0.40419 0.60235 lineto
fill
0.714 0.554 0.67 setrgbcolor
0.42073 0.63182 moveto
0.40284 0.59995 lineto
0.40643 0.60328 lineto
fill
0.725 0.587 0.7 setrgbcolor
0.40209 0.61848 moveto
0.41607 0.59202 lineto
0.40791 0.62938 lineto
fill
0.664 0.534 0.695 setrgbcolor
0.40183 0.59411 moveto
0.42069 0.58327 lineto
0.42073 0.63182 lineto
fill
0.725 0.587 0.7 setrgbcolor
0.42069 0.58327 moveto
0.41731 0.59547 lineto
0.41607 0.59202 lineto
fill
0.725 0.587 0.7 setrgbcolor
0.40791 0.62938 moveto
0.41607 0.59202 lineto
0.41731 0.59547 lineto
fill
0.714 0.554 0.67 setrgbcolor
0.40183 0.59411 moveto
0.40643 0.60328 lineto
0.40284 0.59995 lineto
fill
0 0 0 setrgbcolor
0.39335 0.61227 moveto
0.39795 0.62917 lineto
stroke
0 0 0 setrgbcolor
0.39795 0.62917 moveto
0.41306 0.63844 lineto
stroke
0 0 0 setrgbcolor
0.41306 0.63844 moveto
0.43338 0.63773 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42865 0.62391 moveto
0.434 0.62567 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40251 0.6153 moveto
0.40359 0.61565 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42739 0.6235 moveto
0.42865 0.62391 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42072 0.6213 moveto
0.42739 0.6235 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39335 0.61227 moveto
0.40251 0.6153 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.39335 0.61227 moveto
0.40183 0.59411 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4177 0.62578 moveto
0.42073 0.63182 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40644 0.6033 moveto
0.40823 0.60687 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41498 0.62035 moveto
0.4177 0.62578 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40643 0.60328 moveto
0.40644 0.6033 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40183 0.59411 moveto
0.40643 0.60328 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.40183 0.59411 moveto
0.42069 0.58327 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.44308 0.61462 moveto
0.44697 0.60292 lineto
stroke
1 0 0 setrgbcolor
0.434 0.62567 moveto
0.44308 0.61462 lineto
stroke
0.666 0.525 0.683 setrgbcolor
0.42069 0.58327 moveto
0.4415 0.58644 lineto
0.40791 0.62938 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.41731 0.59547 moveto
0.42069 0.58327 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40791 0.62938 moveto
0.41731 0.59547 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.42069 0.58327 moveto
0.4415 0.58644 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.42073 0.63182 moveto
0.434 0.62567 lineto
stroke
1 0 0 setrgbcolor
0.40791 0.62938 moveto
0.42073 0.63182 lineto
stroke
1 0 0 setrgbcolor
0.40209 0.61848 moveto
0.40791 0.62938 lineto
stroke
0.717 0.604 0.729 setrgbcolor
0.4415 0.58644 moveto
0.40209 0.61848 lineto
0.40761 0.60464 lineto
fill
0.674 0.528 0.677 setrgbcolor
0.4415 0.58644 moveto
0.45334 0.6039 lineto
0.40209 0.61848 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40209 0.61848 moveto
0.41443 0.60845 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42524 0.59966 moveto
0.4415 0.58644 lineto
stroke
1 0 0 setrgbcolor
0.40209 0.61848 moveto
0.40761 0.60464 lineto
stroke
0.669 0.548 0.708 setrgbcolor
0.4227 0.59664 moveto
0.44892 0.62776 lineto
0.40761 0.60464 lineto
fill
1 0 0 setrgbcolor
0.40761 0.60464 moveto
0.4227 0.59664 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4415 0.58644 moveto
0.45334 0.6039 lineto
stroke
0.694 0.552 0.689 setrgbcolor
0.4227 0.59664 moveto
0.44892 0.62776 lineto
0.42993 0.64544 lineto
fill
0.7 0.552 0.683 setrgbcolor
0.44892 0.62776 moveto
0.42898 0.60409 lineto
0.45334 0.6039 lineto
fill
0.7 0.552 0.683 setrgbcolor
0.4227 0.59664 moveto
0.42821 0.59794 lineto
0.42898 0.60409 lineto
fill
0.7 0.552 0.683 setrgbcolor
0.45334 0.6039 moveto
0.42898 0.60409 lineto
0.42821 0.59794 lineto
fill
0.644 0.512 0.687 setrgbcolor
0.44616 0.61765 moveto
0.43341 0.63947 lineto
0.43901 0.60117 lineto
fill
0.644 0.512 0.687 setrgbcolor
0.42993 0.64544 moveto
0.43256 0.63264 lineto
0.43341 0.63947 lineto
fill
0.644 0.512 0.687 setrgbcolor
0.43901 0.60117 moveto
0.43341 0.63947 lineto
0.43256 0.63264 lineto
fill
0.654 0.545 0.719 setrgbcolor
0.4227 0.59664 moveto
0.43901 0.60117 lineto
0.44892 0.62776 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4227 0.59664 moveto
0.42898 0.60409 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42898 0.60409 moveto
0.43657 0.6131 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.44438 0.62238 moveto
0.44892 0.62776 lineto
stroke
1 0 0 setrgbcolor
0.4227 0.59664 moveto
0.43901 0.60117 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.44892 0.62776 moveto
0.45334 0.6039 lineto
stroke
0.673 0.559 0.718 setrgbcolor
0.39423 0.63298 moveto
0.42671 0.63619 lineto
0.40718 0.64724 lineto
fill
0.673 0.559 0.718 setrgbcolor
0.43875 0.63738 moveto
0.43211 0.63946 lineto
0.42671 0.63619 lineto
fill
0.695 0.562 0.7 setrgbcolor
0.42993 0.64544 moveto
0.40718 0.64724 lineto
0.43901 0.60117 lineto
fill
0.673 0.559 0.718 setrgbcolor
0.40718 0.64724 moveto
0.42671 0.63619 lineto
0.43211 0.63946 lineto
fill
0.677 0.518 0.662 setrgbcolor
0.39423 0.63298 moveto
0.43875 0.63738 lineto
0.42085 0.64898 lineto
fill
0.7 0.545 0.673 setrgbcolor
0.4035 0.64628 moveto
0.39981 0.61992 lineto
0.42085 0.64898 lineto
fill
0.677 0.528 0.675 setrgbcolor
0.39423 0.63298 moveto
0.44616 0.61765 lineto
0.43875 0.63738 lineto
fill
0.675 0.549 0.704 setrgbcolor
0.39423 0.63298 moveto
0.39876 0.61248 lineto
0.43875 0.63738 lineto
fill
0.7 0.545 0.673 setrgbcolor
0.39876 0.61248 moveto
0.40526 0.62321 lineto
0.39981 0.61992 lineto
fill
0.7 0.545 0.673 setrgbcolor
0.42085 0.64898 moveto
0.39981 0.61992 lineto
0.40526 0.62321 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42671 0.63619 moveto
0.43875 0.63738 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39423 0.63298 moveto
0.40174 0.63373 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41999 0.63553 moveto
0.42671 0.63619 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.39423 0.63298 moveto
0.39876 0.61248 lineto
stroke
0 0 0 setrgbcolor
0.39423 0.63298 moveto
0.40299 0.64263 lineto
stroke
0 0 0 setrgbcolor
0.40677 0.64679 moveto
0.40718 0.64724 lineto
stroke
0.667 0.534 0.693 setrgbcolor
0.39876 0.61248 moveto
0.41767 0.59942 lineto
0.42085 0.64898 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.39876 0.61248 moveto
0.40526 0.62321 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41477 0.63894 moveto
0.42085 0.64898 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41254 0.63525 moveto
0.41477 0.63894 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.39876 0.61248 moveto
0.41767 0.59942 lineto
stroke
0 0 0 setrgbcolor
0.40718 0.64724 moveto
0.40882 0.64711 lineto
stroke
0 0 0 setrgbcolor
0.42582 0.64576 moveto
0.42993 0.64544 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.43495 0.62096 moveto
0.43901 0.60117 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42993 0.64544 moveto
0.43049 0.64274 lineto
stroke
1 0 0 setrgbcolor
0.43901 0.60117 moveto
0.44616 0.61765 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.42993 0.64544 moveto
0.4382 0.63774 lineto
stroke
0 0 0 setrgbcolor
0.43884 0.63714 moveto
0.44892 0.62776 lineto
stroke
0.716 0.577 0.697 setrgbcolor
0.41767 0.59942 moveto
0.4035 0.64628 lineto
0.39712 0.63255 lineto
fill
0.668 0.527 0.682 setrgbcolor
0.41767 0.59942 moveto
0.43902 0.60289 lineto
0.4035 0.64628 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4035 0.64628 moveto
0.40743 0.63331 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40743 0.63331 moveto
0.41052 0.62307 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41306 0.61468 moveto
0.41767 0.59942 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.41767 0.59942 moveto
0.43902 0.60289 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.43875 0.63738 moveto
0.44418 0.6229 lineto
stroke
1 0 0 setrgbcolor
0.44505 0.6206 moveto
0.44616 0.61765 lineto
stroke
0.714 0.601 0.729 setrgbcolor
0.43902 0.60289 moveto
0.39712 0.63255 lineto
0.40457 0.61785 lineto
fill
0.677 0.53 0.678 setrgbcolor
0.43902 0.60289 moveto
0.44953 0.62181 lineto
0.39712 0.63255 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.39712 0.63255 moveto
0.4111 0.62265 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42419 0.61339 moveto
0.43902 0.60289 lineto
stroke
1 0 0 setrgbcolor
0.39712 0.63255 moveto
0.40457 0.61785 lineto
stroke
1 0 0 setrgbcolor
0.39712 0.63255 moveto
0.4035 0.64628 lineto
stroke
1 0 0 setrgbcolor
0.4035 0.64628 moveto
0.42085 0.64898 lineto
stroke
1 0 0 setrgbcolor
0.42085 0.64898 moveto
0.43875 0.63738 lineto
stroke
0.688 0.541 0.681 setrgbcolor
0.40457 0.61785 moveto
0.44953 0.62181 lineto
0.44276 0.6459 lineto
fill
0.681 0.591 0.748 setrgbcolor
0.40457 0.61785 moveto
0.41999 0.612 lineto
0.44953 0.62181 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40457 0.61785 moveto
0.42036 0.61924 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43412 0.62045 moveto
0.44953 0.62181 lineto
stroke
1 0 0 setrgbcolor
0.40457 0.61785 moveto
0.41999 0.612 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.43902 0.60289 moveto
0.44953 0.62181 lineto
stroke
0.696 0.555 0.691 setrgbcolor
0.41999 0.612 moveto
0.44276 0.6459 lineto
0.42257 0.66247 lineto
fill
0.635 0.537 0.726 setrgbcolor
0.41999 0.612 moveto
0.43345 0.61848 lineto
0.44276 0.6459 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.41999 0.612 moveto
0.42176 0.61463 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42176 0.61463 moveto
0.43489 0.63418 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43628 0.63626 moveto
0.44276 0.6459 lineto
stroke
1 0 0 setrgbcolor
0.41999 0.612 moveto
0.43345 0.61848 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.44276 0.6459 moveto
0.44953 0.62181 lineto
stroke
0.675 0.568 0.727 setrgbcolor
0.3855 0.65148 moveto
0.41916 0.64924 lineto
0.39984 0.66399 lineto
fill
0.697 0.566 0.703 setrgbcolor
0.42257 0.66247 moveto
0.39984 0.66399 lineto
0.43345 0.61848 lineto
fill
0.675 0.568 0.727 setrgbcolor
0.43128 0.64844 moveto
0.42488 0.6516 lineto
0.41916 0.64924 lineto
fill
0.675 0.568 0.727 setrgbcolor
0.39984 0.66399 moveto
0.41916 0.64924 lineto
0.42488 0.6516 lineto
fill
0.616 0.485 0.679 setrgbcolor
0.42257 0.66247 moveto
0.43345 0.61848 lineto
0.43752 0.63326 lineto
fill
0.669 0.51 0.66 setrgbcolor
0.3855 0.65148 moveto
0.43752 0.63326 lineto
0.43128 0.64844 lineto
fill
0.652 0.538 0.711 setrgbcolor
0.38503 0.63232 moveto
0.41953 0.65765 lineto
0.3855 0.65148 lineto
fill
0.713 0.517 0.623 setrgbcolor
0.40873 0.6592 moveto
0.38896 0.63678 lineto
0.41953 0.65765 lineto
fill
0.713 0.517 0.623 setrgbcolor
0.38503 0.63232 moveto
0.39386 0.6388 lineto
0.38896 0.63678 lineto
fill
0.713 0.517 0.623 setrgbcolor
0.41953 0.65765 moveto
0.38896 0.63678 lineto
0.39386 0.6388 lineto
fill
0 0 0 setrgbcolor
0.38503 0.63232 moveto
0.3855 0.65148 lineto
stroke
0 0 0 setrgbcolor
0.3855 0.65148 moveto
0.39984 0.66399 lineto
stroke
0.691 0.526 0.658 setrgbcolor
0.38503 0.63232 moveto
0.43128 0.64844 lineto
0.41953 0.65765 lineto
fill
0.66 0.536 0.702 setrgbcolor
0.38503 0.63232 moveto
0.39723 0.61544 lineto
0.41953 0.65765 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.38503 0.63232 moveto
0.39386 0.6388 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.4105 0.65102 moveto
0.41953 0.65765 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39386 0.6388 moveto
0.40156 0.64446 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41002 0.65066 moveto
0.4105 0.65102 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.38503 0.63232 moveto
0.39723 0.61544 lineto
stroke
0 0 0 setrgbcolor
0.39984 0.66399 moveto
0.42257 0.66247 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.42257 0.66247 moveto
0.42478 0.65354 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43256 0.62207 moveto
0.43345 0.61848 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.43206 0.62409 moveto
0.43256 0.62207 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.42906 0.63622 moveto
0.43206 0.62409 lineto
stroke
1 0 0 setrgbcolor
0.43345 0.61848 moveto
0.43752 0.63326 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.42257 0.66247 moveto
0.44276 0.6459 lineto
stroke
0.8 0.605 0.638 setrgbcolor
0.39723 0.61544 moveto
0.40873 0.6592 lineto
0.40324 0.65568 lineto
fill
0.653 0.518 0.686 setrgbcolor
0.39723 0.61544 moveto
0.41655 0.60712 lineto
0.40873 0.6592 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.40659 0.65104 moveto
0.40873 0.6592 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.40031 0.62716 moveto
0.40538 0.64643 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.39723 0.61544 moveto
0.40031 0.62716 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.39723 0.61544 moveto
0.41655 0.60712 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.43128 0.64844 moveto
0.43752 0.63326 lineto
stroke
0.914 0.879 0.454 setrgbcolor
0.41655 0.60712 moveto
0.40324 0.65568 lineto
0.40397 0.65137 lineto
fill
0.654 0.507 0.672 setrgbcolor
0.41655 0.60712 moveto
0.4366 0.60943 lineto
0.40324 0.65568 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40324 0.65568 moveto
0.41318 0.61941 lineto
stroke
0.25 0.25 0.25 setrgbcolor
0.41318 0.61941 moveto
0.41655 0.60712 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.41655 0.60712 moveto
0.4366 0.60943 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.41953 0.65765 moveto
0.43128 0.64844 lineto
stroke
1 0 0 setrgbcolor
0.40873 0.6592 moveto
0.41953 0.65765 lineto
stroke
1 0 0 setrgbcolor
0.40324 0.65568 moveto
0.40873 0.6592 lineto
stroke
1 0 0 setrgbcolor
0.40324 0.65568 moveto
0.40397 0.65137 lineto
stroke
0.67 0.502 0.649 setrgbcolor
0.4366 0.60943 moveto
0.40941 0.64984 lineto
0.4528 0.6209 lineto
fill
0.467 0.25 0.5 setrgbcolor
0.4366 0.60943 moveto
0.40397 0.65137 lineto
0.40941 0.64984 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40397 0.65137 moveto
0.4366 0.60943 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4366 0.60943 moveto
0.4528 0.6209 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.40397 0.65137 moveto
0.40941 0.64984 lineto
stroke
0.686 0.513 0.646 setrgbcolor
0.4528 0.6209 moveto
0.41748 0.65289 lineto
0.46341 0.63839 lineto
fill
0.603 0.384 0.556 setrgbcolor
0.4528 0.6209 moveto
0.40941 0.64984 lineto
0.41748 0.65289 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.40941 0.64984 moveto
0.4528 0.6209 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4528 0.6209 moveto
0.46341 0.63839 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.40941 0.64984 moveto
0.41748 0.65289 lineto
stroke
0.706 0.528 0.645 setrgbcolor
0.46341 0.63839 moveto
0.42699 0.66091 lineto
0.46912 0.65884 lineto
fill
0.656 0.435 0.572 setrgbcolor
0.46341 0.63839 moveto
0.41748 0.65289 lineto
0.42699 0.66091 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.41748 0.65289 moveto
0.46341 0.63839 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.46341 0.63839 moveto
0.46912 0.65884 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.41748 0.65289 moveto
0.42699 0.66091 lineto
stroke
0.733 0.549 0.643 setrgbcolor
0.46912 0.65884 moveto
0.43823 0.67378 lineto
0.47197 0.68027 lineto
fill
0.694 0.467 0.573 setrgbcolor
0.46912 0.65884 moveto
0.42699 0.66091 lineto
0.43823 0.67378 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.42699 0.66091 moveto
0.46912 0.65884 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.46912 0.65884 moveto
0.47197 0.68027 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.42699 0.66091 moveto
0.43823 0.67378 lineto
stroke
0.733 0.549 0.644 setrgbcolor
0.43823 0.67378 moveto
0.47433 0.70197 lineto
0.47197 0.68027 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.43823 0.67378 moveto
0.47197 0.68027 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47197 0.68027 moveto
0.47433 0.70197 lineto
stroke
0.808 0.482 0.438 setrgbcolor
0.43823 0.67378 moveto
0.45249 0.69167 lineto
0.47433 0.70197 lineto
fill
1 0 0 setrgbcolor
0.003 setlinewidth
0.43823 0.67378 moveto
0.45249 0.69167 lineto
stroke
0.785 0.584 0.629 setrgbcolor
0.45249 0.69167 moveto
0.47799 0.7241 lineto
0.47433 0.70197 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.45249 0.69167 moveto
0.47433 0.70197 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.47433 0.70197 moveto
0.47799 0.7241 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.45249 0.69167 moveto
0.47103 0.71516 lineto
stroke
0.58 0.122 0 setrgbcolor
0.47103 0.71516 moveto
0.49348 0.7445 lineto
0.47799 0.7241 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.47103 0.71516 moveto
0.47799 0.7241 lineto
stroke
0.591 0.477 0.692 setrgbcolor
0.48351 0.747 moveto
0.51624 0.77823 lineto
0.4898 0.77045 lineto
fill
0.448 0.458 0.776 setrgbcolor
0.48351 0.747 moveto
0.49348 0.7445 lineto
0.51624 0.77823 lineto
fill
0.448 0.454 0.773 setrgbcolor
0.47103 0.71516 moveto
0.48351 0.747 lineto
0.49348 0.7445 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.48351 0.747 moveto
0.49348 0.7445 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.48351 0.747 moveto
0.4898 0.77045 lineto
stroke
1 0 0 setrgbcolor
0.003 setlinewidth
0.47103 0.71516 moveto
0.49348 0.7445 lineto
stroke
0.635 0.517 0.701 setrgbcolor
0.4898 0.77045 moveto
0.53193 0.81172 lineto
0.49401 0.79297 lineto
fill
0.568 0.51 0.75 setrgbcolor
0.4898 0.77045 moveto
0.51624 0.77823 lineto
0.53193 0.81172 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.4898 0.77045 moveto
0.51624 0.77823 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4898 0.77045 moveto
0.49401 0.79297 lineto
stroke
0.657 0.546 0.717 setrgbcolor
0.49401 0.79297 moveto
0.5315 0.83734 lineto
0.4924 0.81179 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.4924 0.81179 moveto
0.5315 0.83734 lineto
stroke
0 0 0 setrgbcolor
0.006 setlinewidth
0.4924 0.81179 moveto
0.49401 0.79297 lineto
stroke
0.604 0.535 0.75 setrgbcolor
0.49401 0.79297 moveto
0.53193 0.81172 lineto
0.5315 0.83734 lineto
fill
0.25 0.25 0.25 setrgbcolor
0.003 setlinewidth
0.49401 0.79297 moveto
0.53193 0.81172 lineto
stroke
1 0 0 setrgbcolor
0.5315 0.83734 moveto
0.53193 0.81172 lineto
stroke
1 0 0 setrgbcolor
0.49348 0.7445 moveto
0.51624 0.77823 lineto
stroke
1 0 0 setrgbcolor
0.51624 0.77823 moveto
0.53193 0.81172 lineto
stroke
0 setgray
0.002 setlinewidth
0.54772 0.02381 moveto
0.64777 0.15698 lineto
stroke
0.54772 0.02381 moveto
0.55681 0.80565 lineto
stroke
0.67525 0.91967 moveto
0.55681 0.80565 lineto
stroke
0.67525 0.91967 moveto
0.64777 0.15698 lineto
stroke
0.35359 0.09755 moveto
0.32475 0.86905 lineto
stroke
0.35359 0.09755 moveto
0.54772 0.02381 lineto
stroke
0.55681 0.80565 moveto
0.54772 0.02381 lineto
stroke
0.55681 0.80565 moveto
0.32475 0.86905 lineto
stroke
0.32475 0.86905 moveto
0.55681 0.80565 lineto
stroke
0.32475 0.86905 moveto
0.45242 0.97619 lineto
stroke
0.67525 0.91967 moveto
0.45242 0.97619 lineto
stroke
0.67525 0.91967 moveto
0.55681 0.80565 lineto
stroke
% End of Graphics
Mpend % End of picture
:[inactive; output; font = output; ]
Graphics3D[{{{Thickness[0.006], Line[{{0., 0., 0.}, {0., 0., 0.1}, 
                  {0., 0.00993396, 0.199505}, {-0.00557386, 0.038257, 0.295248}, 
                  {-0.0262128, 0.0880416, 0.379483}, 
                  {-0.0713694, 0.152996, 0.440653}, 
                  {-0.144469, 0.215742, 0.467475}, 
                  {-0.237138, 0.251502, 0.455914}, 
                  {-0.327824, 0.238608, 0.415792}, 
                  {-0.38853, 0.172472, 0.371738}, 
                  {-0.399034, 0.0745188, 0.354567}, 
                  {-0.361419, -0.0129743, 0.385064}, 
                  {-0.304149, -0.0478146, 0.459268}, 
                  {-0.269276, -0.0141581, 0.546739}, 
                  {-0.28783, 0.0639007, 0.606426}, 
                  {-0.359032, 0.133888, 0.612098}, 
                  {-0.448938, 0.146968, 0.570315}, 
                  {-0.511369, 0.0895088, 0.517393}, 
                  {-0.517517, -0.00807472, 0.496425}, 
                  {-0.473824, -0.0914802, 0.530107}, 
                  {-0.416442, -0.117091, 0.607898}, 
                  {-0.387636, -0.0771198, 0.694918}, 
                  {-0.411267, -0.000330114, 0.754458}, 
                  {-0.482621, 0.068385, 0.768123}, 
                  {-0.575893, 0.0933656, 0.742115}, 
                  {-0.660954, 0.0628868, 0.699272}, 
                  {-0.717781, -0.0119435, 0.66505}, 
                  {-0.741737, -0.108662, 0.656586}, 
                  {-0.740231, -0.20608, 0.679112}, 
                  {-0.725515, -0.291759, 0.728535}, 
                  {-0.708214, -0.363173, 0.796363}, 
                  {-0.693704, -0.424773, 0.87379}, 
                  {-0.681186, -0.483652, 0.953644}, 
                  {-0.664547, -0.545392, 1.03053}, 
                  {-0.634534, -0.61063, 1.10012}, 
                  {-0.582391, -0.672762, 1.15861}, 
                  {-0.504966, -0.717928, 1.20294}, 
                  {-0.409931, -0.728898, 1.23206}, 
                  {-0.317917, -0.693398, 1.24859}, 
                  {-0.257692, -0.614324, 1.25956}, 
                  {-0.253291, -0.515604, 1.27489}, 
                  {-0.307963, -0.436779, 1.30313}, 
                  {-0.395403, -0.41473, 1.34635}, 
                  {-0.467925, -0.460775, 1.39754}, 
                  {-0.481465, -0.548603, 1.4434}, 
                  {-0.423705, -0.625072, 1.47197}, 
                  {-0.325375, -0.641081, 1.48062}, 
                  {-0.243679, -0.583445, 1.47864}, 
                  {-0.226503, -0.484986, 1.48193}, 
                  {-0.281447, -0.404155, 1.50309}, 
                  {-0.371382, -0.387629, 1.54357}, 
                  {-0.43915, -0.441714, 1.59339}, 
                  {-0.443267, -0.531095, 1.63804}, 
                  {-0.380457, -0.603117, 1.6675}, 
                  {-0.282691, -0.618898, 1.68139}, 
                  {-0.194992, -0.571288, 1.68787}, 
                  {-0.151021, -0.48208, 1.69829}, 
                  {-0.160579, -0.385294, 1.72155}, 
                  {-0.212174, -0.309459, 1.76139}, 
                  {-0.284431, -0.268149, 1.81682}, 
                  {-0.357704, -0.260268, 1.88441}, 
                  {-0.420698, -0.276068, 1.96045}, 
                  {-0.471526, -0.303961, 2.04193}, 
                  {-0.515333, -0.335259, 2.1262}, 
                  {-0.560646, -0.366327, 2.20975}, 
                  {-0.61548, -0.398762, 2.28683}, 
                  {-0.683385, -0.438123, 2.3488}, 
                  {-0.75982, -0.491215, 2.38539}, 
                  {-0.830394, -0.561991, 2.38859}, 
                  {-0.87348, -0.647063, 2.35849}, 
                  {-0.868852, -0.733342, 2.30814}, 
                  {-0.810354, -0.80079, 2.2631}, 
                  {-0.715743, -0.831308, 2.25227}, 
                  {-0.624821, -0.820351, 2.29243}, 
                  {-0.581929, -0.783744, 2.37501}, 
                  {-0.609917, -0.752788, 2.46589}, 
                  {-0.692253, -0.757619, 2.52244}, 
                  {-0.7785, -0.808151, 2.51961}, {-0.813614, -0.886076, 2.4677}, 
                  {-0.773184, -0.955214, 2.40782}, 
                  {-0.679998, -0.984481, 2.38638}, 
                  {-0.589489, -0.967874, 2.42552}, 
                  {-0.554077, -0.92773, 2.50999}, 
                  {-0.591255, -0.899708, 2.59849}, 
                  {-0.676069, -0.910846, 2.65028}, 
                  {-0.759827, -0.965436, 2.64816}, 
                  {-0.799395, -1.04618, 2.6044}, {-0.777684, -1.12686, 2.54945}, 
                  {-0.705822, -1.18671, 2.51404}, 
                  {-0.610901, -1.21811, 2.51599}, {-0.520118, -1.22586, 2.5572}, 
                  {-0.450303, -1.22113, 2.62864}, 
                  {-0.405556, -1.21502, 2.71786}, {-0.380617, -1.21425, 2.8147}, 
                  {-0.366151, -1.21978, 2.91349}, {-0.353374, -1.22712, 3.0124}, 
                  {-0.337274, -1.22774, 3.11109}, {-0.31857, -1.21141, 3.20796}, 
                  {-0.304348, -1.16997, 3.29785}, 
                  {-0.306565, -1.10232, 3.37147}, {-0.337487, -1.01921, 3.41769}}
                 ]}}, {{Thickness[0.003], RGBColor[1, 0, 0], 
              Line[{{0., 0.2, 0.}, {-0.0572086, 0.190695, 0.0809622}, 
                  {-0.107928, 0.169584, 0.145994}, 
                  {-0.148458, 0.140571, 0.19977}, 
                  {-0.176016, 0.107355, 0.248388}, 
                  {-0.189396, 0.0762074, 0.298621}, 
                  {-0.191678, 0.0571059, 0.355199}, 
                  {-0.192597, 0.0605268, 0.416613}, 
                  {-0.206896, 0.0897764, 0.472586}, 
                  {-0.246719, 0.133506, 0.507278}, 
                  {-0.311295, 0.166135, 0.50919}, 
                  {-0.382017, 0.160514, 0.482417}, 
                  {-0.430012, 0.107324, 0.449754}, 
                  {-0.434501, 0.0268393, 0.441762}, 
                  {-0.399682, -0.0393811, 0.476726}, 
                  {-0.355763, -0.0548394, 0.545982}, 
                  {-0.340487, -0.0143167, 0.617492}, 
                  {-0.373492, 0.0508221, 0.657011}, 
                  {-0.442891, 0.0936808, 0.651592}, 
                  {-0.5144, 0.083678, 0.617704}, {-0.55551, 0.025333, 0.588513}, 
                  {-0.556168, -0.0484876, 0.591104}, 
                  {-0.531943, -0.10105, 0.630795}, 
                  {-0.510385, -0.114485, 0.692046}, 
                  {-0.512949, -0.0962132, 0.752013}, 
                  {-0.545044, -0.0689579, 0.795094}, 
                  {-0.598015, -0.0551072, 0.8193}, 
                  {-0.658066, -0.0665109, 0.833285}, 
                  {-0.714537, -0.103682, 0.848978}, 
                  {-0.763039, -0.161326, 0.875433}, 
                  {-0.803532, -0.23472, 0.916423}, 
                  {-0.835875, -0.323124, 0.971025}, 
                  {-0.855465, -0.429078, 1.03518}, 
                  {-0.850856, -0.55408, 1.10273}, 
                  {-0.805057, -0.691971, 1.16574}, 
                  {-0.70215, -0.822677, 1.21503}, 
                  {-0.539307, -0.910991, 1.24228}, 
                  {-0.339946, -0.915871, 1.24404}, 
                  {-0.15832, -0.811872, 1.22639}, 
                  {-0.0648679, -0.614678, 1.20647}, 
                  {-0.110768, -0.392579, 1.20742}, 
                  {-0.287856, -0.246023, 1.24649}, 
                  {-0.513633, -0.255216, 1.32233}, 
                  {-0.663959, -0.42351, 1.41103}, 
                  {-0.644624, -0.659255, 1.47709}, 
                  {-0.457602, -0.820828, 1.495}, 
                  {-0.210551, -0.804296, 1.46734}, 
                  {-0.0534938, -0.614837, 1.42531}, 
                  {-0.0816964, -0.367596, 1.40947}, 
                  {-0.273196, -0.213402, 1.44354}, 
                  {-0.505658, -0.241335, 1.51973}, 
                  {-0.638202, -0.426497, 1.6055}, 
                  {-0.597992, -0.65483, 1.66542}, 
                  {-0.414279, -0.799685, 1.68223}, 
                  {-0.186634, -0.79342, 1.66363}, 
                  {-0.0198699, -0.651283, 1.63371}, 
                  {0.0281884, -0.444991, 1.61761}, 
                  {-0.0397099, -0.254928, 1.62992}, 
                  {-0.180233, -0.133483, 1.67187}, 
                  {-0.34074, -0.0943152, 1.73551}, {-0.482087, -0.122454, 1.81}, 
                  {-0.586053, -0.191503, 1.88625}, 
                  {-0.651281, -0.277039, 1.95848}, 
                  {-0.685089, -0.362492, 2.02401}, 
                  {-0.69662, -0.439085, 2.0824}, 
                  {-0.693499, -0.503076, 2.13507}, 
                  {-0.681914, -0.553043, 2.18512}, 
                  {-0.66869, -0.588826, 2.2365}, 
                  {-0.662935, -0.612478, 2.29159}, 
                  {-0.674496, -0.63008, 2.34767}, 
                  {-0.708122, -0.651911, 2.39495}, 
                  {-0.756257, -0.688634, 2.41961}, 
                  {-0.797155, -0.744062, 2.41277}, 
                  {-0.804014, -0.809196, 2.38055}, 
                  {-0.762954, -0.86387, 2.34656}, 
                  {-0.687806, -0.888121, 2.34092}, 
                  {-0.617609, -0.877072, 2.38045}, 
                  {-0.593733, -0.847771, 2.4541}, 
                  {-0.630848, -0.830473, 2.5269}, 
                  {-0.704185, -0.848829, 2.56248}, 
                  {-0.764906, -0.903402, 2.54829}, 
                  {-0.773297, -0.971432, 2.50428}, 
                  {-0.724889, -1.0231, 2.46843}, {-0.650611, -1.0417, 2.47076}, 
                  {-0.593103, -1.0329, 2.51531}, {-0.578711, -1.01818, 2.58172}, 
                  {-0.604791, -1.0194, 2.64198}, {-0.647395, -1.04662, 2.67824}, 
                  {-0.679398, -1.09592, 2.69028}, 
                  {-0.685014, -1.15574, 2.69097}, 
                  {-0.663304, -1.21522, 2.69643}, 
                  {-0.622554, -1.26898, 2.71831}, 
                  {-0.572056, -1.31685, 2.76154}, {-0.516647, -1.3604, 2.82644}, 
                  {-0.455804, -1.39856, 2.91181}, 
                  {-0.386476, -1.42432, 3.01657}, 
                  {-0.308091, -1.42369, 3.13848}, 
                  {-0.228068, -1.37839, 3.27064}, 
                  {-0.165397, -1.27378, 3.39743}, 
                  {-0.148605, -1.11159, 3.49379}, {-0.204893, -0.92203, 3.5316}}]
              }}, {{RGBColor[1, 1, 0], EdgeForm[], 
              {Polygon[{{0., 0., 0.}, {0., 0.2, 0.}, 
                     {-0.0572086, 0.190695, 0.0809622}, {0., 0., 0.1}}], 
                 Polygon[{{0., 0., 0.1}, {-0.0572086, 0.190695, 0.0809622}, 
                     {-0.107928, 0.169584, 0.145994}, {0., 0.00993396, 0.199505}}
                    ], Polygon[{{0., 0.00993396, 0.199505}, 
                     {-0.107928, 0.169584, 0.145994}, 
                     {-0.148458, 0.140571, 0.19977}, 
                     {-0.00557386, 0.038257, 0.295248}}], 
                 Polygon[{{-0.00557386, 0.038257, 0.295248}, 
                     {-0.148458, 0.140571, 0.19977}, 
                     {-0.176016, 0.107355, 0.248388}, 
                     {-0.0262128, 0.0880416, 0.379483}}], 
                 Polygon[{{-0.0262128, 0.0880416, 0.379483}, 
                     {-0.176016, 0.107355, 0.248388}, 
                     {-0.189396, 0.0762074, 0.298621}, 
                     {-0.0713694, 0.152996, 0.440653}}], 
                 Polygon[{{-0.0713694, 0.152996, 0.440653}, 
                     {-0.189396, 0.0762074, 0.298621}, 
                     {-0.191678, 0.0571059, 0.355199}, 
                     {-0.144469, 0.215742, 0.467475}}], 
                 Polygon[{{-0.144469, 0.215742, 0.467475}, 
                     {-0.191678, 0.0571059, 0.355199}, 
                     {-0.192597, 0.0605268, 0.416613}, 
                     {-0.237138, 0.251502, 0.455914}}], 
                 Polygon[{{-0.237138, 0.251502, 0.455914}, 
                     {-0.192597, 0.0605268, 0.416613}, 
                     {-0.206896, 0.0897764, 0.472586}, 
                     {-0.327824, 0.238608, 0.415792}}], 
                 Polygon[{{-0.327824, 0.238608, 0.415792}, 
                     {-0.206896, 0.0897764, 0.472586}, 
                     {-0.246719, 0.133506, 0.507278}, 
                     {-0.38853, 0.172472, 0.371738}}], 
                 Polygon[{{-0.38853, 0.172472, 0.371738}, 
                     {-0.246719, 0.133506, 0.507278}, 
                     {-0.311295, 0.166135, 0.50919}, 
                     {-0.399034, 0.0745188, 0.354567}}], 
                 Polygon[{{-0.399034, 0.0745188, 0.354567}, 
                     {-0.311295, 0.166135, 0.50919}, 
                     {-0.382017, 0.160514, 0.482417}, 
                     {-0.361419, -0.0129743, 0.385064}}], 
                 Polygon[{{-0.361419, -0.0129743, 0.385064}, 
                     {-0.382017, 0.160514, 0.482417}, 
                     {-0.430012, 0.107324, 0.449754}, 
                     {-0.304149, -0.0478146, 0.459268}}], 
                 Polygon[{{-0.304149, -0.0478146, 0.459268}, 
                     {-0.430012, 0.107324, 0.449754}, 
                     {-0.434501, 0.0268393, 0.441762}, 
                     {-0.269276, -0.0141581, 0.546739}}], 
                 Polygon[{{-0.269276, -0.0141581, 0.546739}, 
                     {-0.434501, 0.0268393, 0.441762}, 
                     {-0.399682, -0.0393811, 0.476726}, 
                     {-0.28783, 0.0639007, 0.606426}}], 
                 Polygon[{{-0.28783, 0.0639007, 0.606426}, 
                     {-0.399682, -0.0393811, 0.476726}, 
                     {-0.355763, -0.0548394, 0.545982}, 
                     {-0.359032, 0.133888, 0.612098}}], 
                 Polygon[{{-0.359032, 0.133888, 0.612098}, 
                     {-0.355763, -0.0548394, 0.545982}, 
                     {-0.340487, -0.0143167, 0.617492}, 
                     {-0.448938, 0.146968, 0.570315}}], 
                 Polygon[{{-0.448938, 0.146968, 0.570315}, 
                     {-0.340487, -0.0143167, 0.617492}, 
                     {-0.373492, 0.0508221, 0.657011}, 
                     {-0.511369, 0.0895088, 0.517393}}], 
                 Polygon[{{-0.511369, 0.0895088, 0.517393}, 
                     {-0.373492, 0.0508221, 0.657011}, 
                     {-0.442891, 0.0936808, 0.651592}, 
                     {-0.517517, -0.00807472, 0.496425}}], 
                 Polygon[{{-0.517517, -0.00807472, 0.496425}, 
                     {-0.442891, 0.0936808, 0.651592}, 
                     {-0.5144, 0.083678, 0.617704}, 
                     {-0.473824, -0.0914802, 0.530107}}], 
                 Polygon[{{-0.473824, -0.0914802, 0.530107}, 
                     {-0.5144, 0.083678, 0.617704}, 
                     {-0.55551, 0.025333, 0.588513}, 
                     {-0.416442, -0.117091, 0.607898}}], 
                 Polygon[{{-0.416442, -0.117091, 0.607898}, 
                     {-0.55551, 0.025333, 0.588513}, 
                     {-0.556168, -0.0484876, 0.591104}, 
                     {-0.387636, -0.0771198, 0.694918}}], 
                 Polygon[{{-0.387636, -0.0771198, 0.694918}, 
                     {-0.556168, -0.0484876, 0.591104}, 
                     {-0.531943, -0.10105, 0.630795}, 
                     {-0.411267, -0.000330114, 0.754458}}], 
                 Polygon[{{-0.411267, -0.000330114, 0.754458}, 
                     {-0.531943, -0.10105, 0.630795}, 
                     {-0.510385, -0.114485, 0.692046}, 
                     {-0.482621, 0.068385, 0.768123}}], 
                 Polygon[{{-0.482621, 0.068385, 0.768123}, 
                     {-0.510385, -0.114485, 0.692046}, 
                     {-0.512949, -0.0962132, 0.752013}, 
                     {-0.575893, 0.0933656, 0.742115}}], 
                 Polygon[{{-0.575893, 0.0933656, 0.742115}, 
                     {-0.512949, -0.0962132, 0.752013}, 
                     {-0.545044, -0.0689579, 0.795094}, 
                     {-0.660954, 0.0628868, 0.699272}}], 
                 Polygon[{{-0.660954, 0.0628868, 0.699272}, 
                     {-0.545044, -0.0689579, 0.795094}, 
                     {-0.598015, -0.0551072, 0.8193}, 
                     {-0.717781, -0.0119435, 0.66505}}], 
                 Polygon[{{-0.717781, -0.0119435, 0.66505}, 
                     {-0.598015, -0.0551072, 0.8193}, 
                     {-0.658066, -0.0665109, 0.833285}, 
                     {-0.741737, -0.108662, 0.656586}}], 
                 Polygon[{{-0.741737, -0.108662, 0.656586}, 
                     {-0.658066, -0.0665109, 0.833285}, 
                     {-0.714537, -0.103682, 0.848978}, 
                     {-0.740231, -0.20608, 0.679112}}], 
                 Polygon[{{-0.740231, -0.20608, 0.679112}, 
                     {-0.714537, -0.103682, 0.848978}, 
                     {-0.763039, -0.161326, 0.875433}, 
                     {-0.725515, -0.291759, 0.728535}}], 
                 Polygon[{{-0.725515, -0.291759, 0.728535}, 
                     {-0.763039, -0.161326, 0.875433}, 
                     {-0.803532, -0.23472, 0.916423}, 
                     {-0.708214, -0.363173, 0.796363}}], 
                 Polygon[{{-0.708214, -0.363173, 0.796363}, 
                     {-0.803532, -0.23472, 0.916423}, 
                     {-0.835875, -0.323124, 0.971025}, 
                     {-0.693704, -0.424773, 0.87379}}], 
                 Polygon[{{-0.693704, -0.424773, 0.87379}, 
                     {-0.835875, -0.323124, 0.971025}, 
                     {-0.855465, -0.429078, 1.03518}, 
                     {-0.681186, -0.483652, 0.953644}}], 
                 Polygon[{{-0.681186, -0.483652, 0.953644}, 
                     {-0.855465, -0.429078, 1.03518}, 
                     {-0.850856, -0.55408, 1.10273}, 
                     {-0.664547, -0.545392, 1.03053}}], 
                 Polygon[{{-0.664547, -0.545392, 1.03053}, 
                     {-0.850856, -0.55408, 1.10273}, 
                     {-0.805057, -0.691971, 1.16574}, 
                     {-0.634534, -0.61063, 1.10012}}], 
                 Polygon[{{-0.634534, -0.61063, 1.10012}, 
                     {-0.805057, -0.691971, 1.16574}, 
                     {-0.70215, -0.822677, 1.21503}, 
                     {-0.582391, -0.672762, 1.15861}}], 
                 Polygon[{{-0.582391, -0.672762, 1.15861}, 
                     {-0.70215, -0.822677, 1.21503}, 
                     {-0.539307, -0.910991, 1.24228}, 
                     {-0.504966, -0.717928, 1.20294}}], 
                 Polygon[{{-0.504966, -0.717928, 1.20294}, 
                     {-0.539307, -0.910991, 1.24228}, 
                     {-0.339946, -0.915871, 1.24404}, 
                     {-0.409931, -0.728898, 1.23206}}], 
                 Polygon[{{-0.409931, -0.728898, 1.23206}, 
                     {-0.339946, -0.915871, 1.24404}, 
                     {-0.15832, -0.811872, 1.22639}, 
                     {-0.317917, -0.693398, 1.24859}}], 
                 Polygon[{{-0.317917, -0.693398, 1.24859}, 
                     {-0.15832, -0.811872, 1.22639}, 
                     {-0.0648679, -0.614678, 1.20647}, 
                     {-0.257692, -0.614324, 1.25956}}], 
                 Polygon[{{-0.257692, -0.614324, 1.25956}, 
                     {-0.0648679, -0.614678, 1.20647}, 
                     {-0.110768, -0.392579, 1.20742}, 
                     {-0.253291, -0.515604, 1.27489}}], 
                 Polygon[{{-0.253291, -0.515604, 1.27489}, 
                     {-0.110768, -0.392579, 1.20742}, 
                     {-0.287856, -0.246023, 1.24649}, 
                     {-0.307963, -0.436779, 1.30313}}], 
                 Polygon[{{-0.307963, -0.436779, 1.30313}, 
                     {-0.287856, -0.246023, 1.24649}, 
                     {-0.513633, -0.255216, 1.32233}, 
                     {-0.395403, -0.41473, 1.34635}}], 
                 Polygon[{{-0.395403, -0.41473, 1.34635}, 
                     {-0.513633, -0.255216, 1.32233}, 
                     {-0.663959, -0.42351, 1.41103}, 
                     {-0.467925, -0.460775, 1.39754}}], 
                 Polygon[{{-0.467925, -0.460775, 1.39754}, 
                     {-0.663959, -0.42351, 1.41103}, 
                     {-0.644624, -0.659255, 1.47709}, 
                     {-0.481465, -0.548603, 1.4434}}], 
                 Polygon[{{-0.481465, -0.548603, 1.4434}, 
                     {-0.644624, -0.659255, 1.47709}, 
                     {-0.457602, -0.820828, 1.495}, 
                     {-0.423705, -0.625072, 1.47197}}], 
                 Polygon[{{-0.423705, -0.625072, 1.47197}, 
                     {-0.457602, -0.820828, 1.495}, 
                     {-0.210551, -0.804296, 1.46734}, 
                     {-0.325375, -0.641081, 1.48062}}], 
                 Polygon[{{-0.325375, -0.641081, 1.48062}, 
                     {-0.210551, -0.804296, 1.46734}, 
                     {-0.0534938, -0.614837, 1.42531}, 
                     {-0.243679, -0.583445, 1.47864}}], 
                 Polygon[{{-0.243679, -0.583445, 1.47864}, 
                     {-0.0534938, -0.614837, 1.42531}, 
                     {-0.0816964, -0.367596, 1.40947}, 
                     {-0.226503, -0.484986, 1.48193}}], 
                 Polygon[{{-0.226503, -0.484986, 1.48193}, 
                     {-0.0816964, -0.367596, 1.40947}, 
                     {-0.273196, -0.213402, 1.44354}, 
                     {-0.281447, -0.404155, 1.50309}}], 
                 Polygon[{{-0.281447, -0.404155, 1.50309}, 
                     {-0.273196, -0.213402, 1.44354}, 
                     {-0.505658, -0.241335, 1.51973}, 
                     {-0.371382, -0.387629, 1.54357}}], 
                 Polygon[{{-0.371382, -0.387629, 1.54357}, 
                     {-0.505658, -0.241335, 1.51973}, 
                     {-0.638202, -0.426497, 1.6055}, 
                     {-0.43915, -0.441714, 1.59339}}], 
                 Polygon[{{-0.43915, -0.441714, 1.59339}, 
                     {-0.638202, -0.426497, 1.6055}, 
                     {-0.597992, -0.65483, 1.66542}, 
                     {-0.443267, -0.531095, 1.63804}}], 
                 Polygon[{{-0.443267, -0.531095, 1.63804}, 
                     {-0.597992, -0.65483, 1.66542}, 
                     {-0.414279, -0.799685, 1.68223}, 
                     {-0.380457, -0.603117, 1.6675}}], 
                 Polygon[{{-0.380457, -0.603117, 1.6675}, 
                     {-0.414279, -0.799685, 1.68223}, 
                     {-0.186634, -0.79342, 1.66363}, 
                     {-0.282691, -0.618898, 1.68139}}], 
                 Polygon[{{-0.282691, -0.618898, 1.68139}, 
                     {-0.186634, -0.79342, 1.66363}, 
                     {-0.0198699, -0.651283, 1.63371}, 
                     {-0.194992, -0.571288, 1.68787}}], 
                 Polygon[{{-0.194992, -0.571288, 1.68787}, 
                     {-0.0198699, -0.651283, 1.63371}, 
                     {0.0281884, -0.444991, 1.61761}, 
                     {-0.151021, -0.48208, 1.69829}}], 
                 Polygon[{{-0.151021, -0.48208, 1.69829}, 
                     {0.0281884, -0.444991, 1.61761}, 
                     {-0.0397099, -0.254928, 1.62992}, 
                     {-0.160579, -0.385294, 1.72155}}], 
                 Polygon[{{-0.160579, -0.385294, 1.72155}, 
                     {-0.0397099, -0.254928, 1.62992}, 
                     {-0.180233, -0.133483, 1.67187}, 
                     {-0.212174, -0.309459, 1.76139}}], 
                 Polygon[{{-0.212174, -0.309459, 1.76139}, 
                     {-0.180233, -0.133483, 1.67187}, 
                     {-0.34074, -0.0943152, 1.73551}, 
                     {-0.284431, -0.268149, 1.81682}}], 
                 Polygon[{{-0.284431, -0.268149, 1.81682}, 
                     {-0.34074, -0.0943152, 1.73551}, 
                     {-0.482087, -0.122454, 1.81}, 
                     {-0.357704, -0.260268, 1.88441}}], 
                 Polygon[{{-0.357704, -0.260268, 1.88441}, 
                     {-0.482087, -0.122454, 1.81}, 
                     {-0.586053, -0.191503, 1.88625}, 
                     {-0.420698, -0.276068, 1.96045}}], 
                 Polygon[{{-0.420698, -0.276068, 1.96045}, 
                     {-0.586053, -0.191503, 1.88625}, 
                     {-0.651281, -0.277039, 1.95848}, 
                     {-0.471526, -0.303961, 2.04193}}], 
                 Polygon[{{-0.471526, -0.303961, 2.04193}, 
                     {-0.651281, -0.277039, 1.95848}, 
                     {-0.685089, -0.362492, 2.02401}, 
                     {-0.515333, -0.335259, 2.1262}}], 
                 Polygon[{{-0.515333, -0.335259, 2.1262}, 
                     {-0.685089, -0.362492, 2.02401}, 
                     {-0.69662, -0.439085, 2.0824}, 
                     {-0.560646, -0.366327, 2.20975}}], 
                 Polygon[{{-0.560646, -0.366327, 2.20975}, 
                     {-0.69662, -0.439085, 2.0824}, 
                     {-0.693499, -0.503076, 2.13507}, 
                     {-0.61548, -0.398762, 2.28683}}], 
                 Polygon[{{-0.61548, -0.398762, 2.28683}, 
                     {-0.693499, -0.503076, 2.13507}, 
                     {-0.681914, -0.553043, 2.18512}, 
                     {-0.683385, -0.438123, 2.3488}}], 
                 Polygon[{{-0.683385, -0.438123, 2.3488}, 
                     {-0.681914, -0.553043, 2.18512}, 
                     {-0.66869, -0.588826, 2.2365}, 
                     {-0.75982, -0.491215, 2.38539}}], 
                 Polygon[{{-0.75982, -0.491215, 2.38539}, 
                     {-0.66869, -0.588826, 2.2365}, 
                     {-0.662935, -0.612478, 2.29159}, 
                     {-0.830394, -0.561991, 2.38859}}], 
                 Polygon[{{-0.830394, -0.561991, 2.38859}, 
                     {-0.662935, -0.612478, 2.29159}, 
                     {-0.674496, -0.63008, 2.34767}, 
                     {-0.87348, -0.647063, 2.35849}}], 
                 Polygon[{{-0.87348, -0.647063, 2.35849}, 
                     {-0.674496, -0.63008, 2.34767}, 
                     {-0.708122, -0.651911, 2.39495}, 
                     {-0.868852, -0.733342, 2.30814}}], 
                 Polygon[{{-0.868852, -0.733342, 2.30814}, 
                     {-0.708122, -0.651911, 2.39495}, 
                     {-0.756257, -0.688634, 2.41961}, 
                     {-0.810354, -0.80079, 2.2631}}], 
                 Polygon[{{-0.810354, -0.80079, 2.2631}, 
                     {-0.756257, -0.688634, 2.41961}, 
                     {-0.797155, -0.744062, 2.41277}, 
                     {-0.715743, -0.831308, 2.25227}}], 
                 Polygon[{{-0.715743, -0.831308, 2.25227}, 
                     {-0.797155, -0.744062, 2.41277}, 
                     {-0.804014, -0.809196, 2.38055}, 
                     {-0.624821, -0.820351, 2.29243}}], 
                 Polygon[{{-0.624821, -0.820351, 2.29243}, 
                     {-0.804014, -0.809196, 2.38055}, 
                     {-0.762954, -0.86387, 2.34656}, 
                     {-0.581929, -0.783744, 2.37501}}], 
                 Polygon[{{-0.581929, -0.783744, 2.37501}, 
                     {-0.762954, -0.86387, 2.34656}, 
                     {-0.687806, -0.888121, 2.34092}, 
                     {-0.609917, -0.752788, 2.46589}}], 
                 Polygon[{{-0.609917, -0.752788, 2.46589}, 
                     {-0.687806, -0.888121, 2.34092}, 
                     {-0.617609, -0.877072, 2.38045}, 
                     {-0.692253, -0.757619, 2.52244}}], 
                 Polygon[{{-0.692253, -0.757619, 2.52244}, 
                     {-0.617609, -0.877072, 2.38045}, 
                     {-0.593733, -0.847771, 2.4541}, 
                     {-0.7785, -0.808151, 2.51961}}], 
                 Polygon[{{-0.7785, -0.808151, 2.51961}, 
                     {-0.593733, -0.847771, 2.4541}, 
                     {-0.630848, -0.830473, 2.5269}, 
                     {-0.813614, -0.886076, 2.4677}}], 
                 Polygon[{{-0.813614, -0.886076, 2.4677}, 
                     {-0.630848, -0.830473, 2.5269}, 
                     {-0.704185, -0.848829, 2.56248}, 
                     {-0.773184, -0.955214, 2.40782}}], 
                 Polygon[{{-0.773184, -0.955214, 2.40782}, 
                     {-0.704185, -0.848829, 2.56248}, 
                     {-0.764906, -0.903402, 2.54829}, 
                     {-0.679998, -0.984481, 2.38638}}], 
                 Polygon[{{-0.679998, -0.984481, 2.38638}, 
                     {-0.764906, -0.903402, 2.54829}, 
                     {-0.773297, -0.971432, 2.50428}, 
                     {-0.589489, -0.967874, 2.42552}}], 
                 Polygon[{{-0.589489, -0.967874, 2.42552}, 
                     {-0.773297, -0.971432, 2.50428}, 
                     {-0.724889, -1.0231, 2.46843}, 
                     {-0.554077, -0.92773, 2.50999}}], 
                 Polygon[{{-0.554077, -0.92773, 2.50999}, 
                     {-0.724889, -1.0231, 2.46843}, 
                     {-0.650611, -1.0417, 2.47076}, 
                     {-0.591255, -0.899708, 2.59849}}], 
                 Polygon[{{-0.591255, -0.899708, 2.59849}, 
                     {-0.650611, -1.0417, 2.47076}, 
                     {-0.593103, -1.0329, 2.51531}, 
                     {-0.676069, -0.910846, 2.65028}}], 
                 Polygon[{{-0.676069, -0.910846, 2.65028}, 
                     {-0.593103, -1.0329, 2.51531}, 
                     {-0.578711, -1.01818, 2.58172}, 
                     {-0.759827, -0.965436, 2.64816}}], 
                 Polygon[{{-0.759827, -0.965436, 2.64816}, 
                     {-0.578711, -1.01818, 2.58172}, 
                     {-0.604791, -1.0194, 2.64198}, 
                     {-0.799395, -1.04618, 2.6044}}], 
                 Polygon[{{-0.799395, -1.04618, 2.6044}, 
                     {-0.604791, -1.0194, 2.64198}, 
                     {-0.647395, -1.04662, 2.67824}, 
                     {-0.777684, -1.12686, 2.54945}}], 
                 Polygon[{{-0.777684, -1.12686, 2.54945}, 
                     {-0.647395, -1.04662, 2.67824}, 
                     {-0.679398, -1.09592, 2.69028}, 
                     {-0.705822, -1.18671, 2.51404}}], 
                 Polygon[{{-0.705822, -1.18671, 2.51404}, 
                     {-0.679398, -1.09592, 2.69028}, 
                     {-0.685014, -1.15574, 2.69097}, 
                     {-0.610901, -1.21811, 2.51599}}], 
                 Polygon[{{-0.610901, -1.21811, 2.51599}, 
                     {-0.685014, -1.15574, 2.69097}, 
                     {-0.663304, -1.21522, 2.69643}, 
                     {-0.520118, -1.22586, 2.5572}}], 
                 Polygon[{{-0.520118, -1.22586, 2.5572}, 
                     {-0.663304, -1.21522, 2.69643}, 
                     {-0.622554, -1.26898, 2.71831}, 
                     {-0.450303, -1.22113, 2.62864}}], 
                 Polygon[{{-0.450303, -1.22113, 2.62864}, 
                     {-0.622554, -1.26898, 2.71831}, 
                     {-0.572056, -1.31685, 2.76154}, 
                     {-0.405556, -1.21502, 2.71786}}], 
                 Polygon[{{-0.405556, -1.21502, 2.71786}, 
                     {-0.572056, -1.31685, 2.76154}, 
                     {-0.516647, -1.3604, 2.82644}, 
                     {-0.380617, -1.21425, 2.8147}}], 
                 Polygon[{{-0.380617, -1.21425, 2.8147}, 
                     {-0.516647, -1.3604, 2.82644}, 
                     {-0.455804, -1.39856, 2.91181}, 
                     {-0.366151, -1.21978, 2.91349}}], 
                 Polygon[{{-0.366151, -1.21978, 2.91349}, 
                     {-0.455804, -1.39856, 2.91181}, 
                     {-0.386476, -1.42432, 3.01657}, 
                     {-0.353374, -1.22712, 3.0124}}], 
                 Polygon[{{-0.353374, -1.22712, 3.0124}, 
                     {-0.386476, -1.42432, 3.01657}, 
                     {-0.308091, -1.42369, 3.13848}, 
                     {-0.337274, -1.22774, 3.11109}}], 
                 Polygon[{{-0.337274, -1.22774, 3.11109}, 
                     {-0.308091, -1.42369, 3.13848}, 
                     {-0.228068, -1.37839, 3.27064}, 
                     {-0.31857, -1.21141, 3.20796}}], 
                 Polygon[{{-0.31857, -1.21141, 3.20796}, 
                     {-0.228068, -1.37839, 3.27064}, 
                     {-0.165397, -1.27378, 3.39743}, 
                     {-0.304348, -1.16997, 3.29785}}], 
                 Polygon[{{-0.304348, -1.16997, 3.29785}, 
                     {-0.165397, -1.27378, 3.39743}, 
                     {-0.148605, -1.11159, 3.49379}, 
                     {-0.306565, -1.10232, 3.37147}}], 
                 Polygon[{{-0.306565, -1.10232, 3.37147}, 
                     {-0.148605, -1.11159, 3.49379}, 
                     {-0.204893, -0.92203, 3.5316}, 
                     {-0.337487, -1.01921, 3.41769}}]}}}, 
        {{GrayLevel[0.25], {Line[{{0., 0., 0.}, {0., 0.2, 0.}}], 
               Line[{{0., 0., 0.1}, {-0.0572086, 0.190695, 0.0809622}}], 
                 Line[{{0., 0.00993396, 0.199505}, 
                     {-0.107928, 0.169584, 0.145994}}], 
                 Line[{{-0.00557386, 0.038257, 0.295248}, 
                     {-0.148458, 0.140571, 0.19977}}], 
                 Line[{{-0.0262128, 0.0880416, 0.379483}, 
                     {-0.176016, 0.107355, 0.248388}}], 
                 Line[{{-0.0713694, 0.152996, 0.440653}, 
                     {-0.189396, 0.0762074, 0.298621}}], 
                 Line[{{-0.144469, 0.215742, 0.467475}, 
                     {-0.191678, 0.0571059, 0.355199}}], 
                 Line[{{-0.237138, 0.251502, 0.455914}, 
                     {-0.192597, 0.0605268, 0.416613}}], 
                 Line[{{-0.327824, 0.238608, 0.415792}, 
                     {-0.206896, 0.0897764, 0.472586}}], 
                 Line[{{-0.38853, 0.172472, 0.371738}, 
                     {-0.246719, 0.133506, 0.507278}}], 
                 Line[{{-0.399034, 0.0745188, 0.354567}, 
                     {-0.311295, 0.166135, 0.50919}}], 
                 Line[{{-0.361419, -0.0129743, 0.385064}, 
                     {-0.382017, 0.160514, 0.482417}}], 
                 Line[{{-0.304149, -0.0478146, 0.459268}, 
                     {-0.430012, 0.107324, 0.449754}}], 
                 Line[{{-0.269276, -0.0141581, 0.546739}, 
                     {-0.434501, 0.0268393, 0.441762}}], 
                 Line[{{-0.28783, 0.0639007, 0.606426}, 
                     {-0.399682, -0.0393811, 0.476726}}], 
                 Line[{{-0.359032, 0.133888, 0.612098}, 
                     {-0.355763, -0.0548394, 0.545982}}], 
                 Line[{{-0.448938, 0.146968, 0.570315}, 
                     {-0.340487, -0.0143167, 0.617492}}], 
                 Line[{{-0.511369, 0.0895088, 0.517393}, 
                     {-0.373492, 0.0508221, 0.657011}}], 
                 Line[{{-0.517517, -0.00807472, 0.496425}, 
                     {-0.442891, 0.0936808, 0.651592}}], 
                 Line[{{-0.473824, -0.0914802, 0.530107}, 
                     {-0.5144, 0.083678, 0.617704}}], 
                 Line[{{-0.416442, -0.117091, 0.607898}, 
                     {-0.55551, 0.025333, 0.588513}}], 
                 Line[{{-0.387636, -0.0771198, 0.694918}, 
                     {-0.556168, -0.0484876, 0.591104}}], 
                 Line[{{-0.411267, -0.000330114, 0.754458}, 
                     {-0.531943, -0.10105, 0.630795}}], 
                 Line[{{-0.482621, 0.068385, 0.768123}, 
                     {-0.510385, -0.114485, 0.692046}}], 
                 Line[{{-0.575893, 0.0933656, 0.742115}, 
                     {-0.512949, -0.0962132, 0.752013}}], 
                 Line[{{-0.660954, 0.0628868, 0.699272}, 
                     {-0.545044, -0.0689579, 0.795094}}], 
                 Line[{{-0.717781, -0.0119435, 0.66505}, 
                     {-0.598015, -0.0551072, 0.8193}}], 
                 Line[{{-0.741737, -0.108662, 0.656586}, 
                     {-0.658066, -0.0665109, 0.833285}}], 
                 Line[{{-0.740231, -0.20608, 0.679112}, 
                     {-0.714537, -0.103682, 0.848978}}], 
                 Line[{{-0.725515, -0.291759, 0.728535}, 
                     {-0.763039, -0.161326, 0.875433}}], 
                 Line[{{-0.708214, -0.363173, 0.796363}, 
                     {-0.803532, -0.23472, 0.916423}}], 
                 Line[{{-0.693704, -0.424773, 0.87379}, 
                     {-0.835875, -0.323124, 0.971025}}], 
                 Line[{{-0.681186, -0.483652, 0.953644}, 
                     {-0.855465, -0.429078, 1.03518}}], 
                 Line[{{-0.664547, -0.545392, 1.03053}, 
                     {-0.850856, -0.55408, 1.10273}}], 
                 Line[{{-0.634534, -0.61063, 1.10012}, 
                     {-0.805057, -0.691971, 1.16574}}], 
                 Line[{{-0.582391, -0.672762, 1.15861}, 
                     {-0.70215, -0.822677, 1.21503}}], 
                 Line[{{-0.504966, -0.717928, 1.20294}, 
                     {-0.539307, -0.910991, 1.24228}}], 
                 Line[{{-0.409931, -0.728898, 1.23206}, 
                     {-0.339946, -0.915871, 1.24404}}], 
                 Line[{{-0.317917, -0.693398, 1.24859}, 
                     {-0.15832, -0.811872, 1.22639}}], 
                 Line[{{-0.257692, -0.614324, 1.25956}, 
                     {-0.0648679, -0.614678, 1.20647}}], 
                 Line[{{-0.253291, -0.515604, 1.27489}, 
                     {-0.110768, -0.392579, 1.20742}}], 
                 Line[{{-0.307963, -0.436779, 1.30313}, 
                     {-0.287856, -0.246023, 1.24649}}], 
                 Line[{{-0.395403, -0.41473, 1.34635}, 
                     {-0.513633, -0.255216, 1.32233}}], 
                 Line[{{-0.467925, -0.460775, 1.39754}, 
                     {-0.663959, -0.42351, 1.41103}}], 
                 Line[{{-0.481465, -0.548603, 1.4434}, 
                     {-0.644624, -0.659255, 1.47709}}], 
                 Line[{{-0.423705, -0.625072, 1.47197}, 
                     {-0.457602, -0.820828, 1.495}}], 
                 Line[{{-0.325375, -0.641081, 1.48062}, 
                     {-0.210551, -0.804296, 1.46734}}], 
                 Line[{{-0.243679, -0.583445, 1.47864}, 
                     {-0.0534938, -0.614837, 1.42531}}], 
                 Line[{{-0.226503, -0.484986, 1.48193}, 
                     {-0.0816964, -0.367596, 1.40947}}], 
                 Line[{{-0.281447, -0.404155, 1.50309}, 
                     {-0.273196, -0.213402, 1.44354}}], 
                 Line[{{-0.371382, -0.387629, 1.54357}, 
                     {-0.505658, -0.241335, 1.51973}}], 
                 Line[{{-0.43915, -0.441714, 1.59339}, 
                     {-0.638202, -0.426497, 1.6055}}], 
                 Line[{{-0.443267, -0.531095, 1.63804}, 
                     {-0.597992, -0.65483, 1.66542}}], 
                 Line[{{-0.380457, -0.603117, 1.6675}, 
                     {-0.414279, -0.799685, 1.68223}}], 
                 Line[{{-0.282691, -0.618898, 1.68139}, 
                     {-0.186634, -0.79342, 1.66363}}], 
                 Line[{{-0.194992, -0.571288, 1.68787}, 
                     {-0.0198699, -0.651283, 1.63371}}], 
                 Line[{{-0.151021, -0.48208, 1.69829}, 
                     {0.0281884, -0.444991, 1.61761}}], 
                 Line[{{-0.160579, -0.385294, 1.72155}, 
                     {-0.0397099, -0.254928, 1.62992}}], 
                 Line[{{-0.212174, -0.309459, 1.76139}, 
                     {-0.180233, -0.133483, 1.67187}}], 
                 Line[{{-0.284431, -0.268149, 1.81682}, 
                     {-0.34074, -0.0943152, 1.73551}}], 
                 Line[{{-0.357704, -0.260268, 1.88441}, 
                     {-0.482087, -0.122454, 1.81}}], 
                 Line[{{-0.420698, -0.276068, 1.96045}, 
                     {-0.586053, -0.191503, 1.88625}}], 
                 Line[{{-0.471526, -0.303961, 2.04193}, 
                     {-0.651281, -0.277039, 1.95848}}], 
                 Line[{{-0.515333, -0.335259, 2.1262}, 
                     {-0.685089, -0.362492, 2.02401}}], 
                 Line[{{-0.560646, -0.366327, 2.20975}, 
                     {-0.69662, -0.439085, 2.0824}}], 
                 Line[{{-0.61548, -0.398762, 2.28683}, 
                     {-0.693499, -0.503076, 2.13507}}], 
                 Line[{{-0.683385, -0.438123, 2.3488}, 
                     {-0.681914, -0.553043, 2.18512}}], 
                 Line[{{-0.75982, -0.491215, 2.38539}, 
                     {-0.66869, -0.588826, 2.2365}}], 
                 Line[{{-0.830394, -0.561991, 2.38859}, 
                     {-0.662935, -0.612478, 2.29159}}], 
                 Line[{{-0.87348, -0.647063, 2.35849}, 
                     {-0.674496, -0.63008, 2.34767}}], 
                 Line[{{-0.868852, -0.733342, 2.30814}, 
                     {-0.708122, -0.651911, 2.39495}}], 
                 Line[{{-0.810354, -0.80079, 2.2631}, 
                     {-0.756257, -0.688634, 2.41961}}], 
                 Line[{{-0.715743, -0.831308, 2.25227}, 
                     {-0.797155, -0.744062, 2.41277}}], 
                 Line[{{-0.624821, -0.820351, 2.29243}, 
                     {-0.804014, -0.809196, 2.38055}}], 
                 Line[{{-0.581929, -0.783744, 2.37501}, 
                     {-0.762954, -0.86387, 2.34656}}], 
                 Line[{{-0.609917, -0.752788, 2.46589}, 
                     {-0.687806, -0.888121, 2.34092}}], 
                 Line[{{-0.692253, -0.757619, 2.52244}, 
                     {-0.617609, -0.877072, 2.38045}}], 
                 Line[{{-0.7785, -0.808151, 2.51961}, 
                     {-0.593733, -0.847771, 2.4541}}], 
                 Line[{{-0.813614, -0.886076, 2.4677}, 
                     {-0.630848, -0.830473, 2.5269}}], 
                 Line[{{-0.773184, -0.955214, 2.40782}, 
                     {-0.704185, -0.848829, 2.56248}}], 
                 Line[{{-0.679998, -0.984481, 2.38638}, 
                     {-0.764906, -0.903402, 2.54829}}], 
                 Line[{{-0.589489, -0.967874, 2.42552}, 
                     {-0.773297, -0.971432, 2.50428}}], 
                 Line[{{-0.554077, -0.92773, 2.50999}, 
                     {-0.724889, -1.0231, 2.46843}}], 
                 Line[{{-0.591255, -0.899708, 2.59849}, 
                     {-0.650611, -1.0417, 2.47076}}], 
                 Line[{{-0.676069, -0.910846, 2.65028}, 
                     {-0.593103, -1.0329, 2.51531}}], 
                 Line[{{-0.759827, -0.965436, 2.64816}, 
                     {-0.578711, -1.01818, 2.58172}}], 
                 Line[{{-0.799395, -1.04618, 2.6044}, 
                     {-0.604791, -1.0194, 2.64198}}], 
                 Line[{{-0.777684, -1.12686, 2.54945}, 
                     {-0.647395, -1.04662, 2.67824}}], 
                 Line[{{-0.705822, -1.18671, 2.51404}, 
                     {-0.679398, -1.09592, 2.69028}}], 
                 Line[{{-0.610901, -1.21811, 2.51599}, 
                     {-0.685014, -1.15574, 2.69097}}], 
                 Line[{{-0.520118, -1.22586, 2.5572}, 
                     {-0.663304, -1.21522, 2.69643}}], 
                 Line[{{-0.450303, -1.22113, 2.62864}, 
                     {-0.622554, -1.26898, 2.71831}}], 
                 Line[{{-0.405556, -1.21502, 2.71786}, 
                     {-0.572056, -1.31685, 2.76154}}], 
                 Line[{{-0.380617, -1.21425, 2.8147}, 
                     {-0.516647, -1.3604, 2.82644}}], 
                 Line[{{-0.366151, -1.21978, 2.91349}, 
                     {-0.455804, -1.39856, 2.91181}}], 
                 Line[{{-0.353374, -1.22712, 3.0124}, 
                     {-0.386476, -1.42432, 3.01657}}], 
                 Line[{{-0.337274, -1.22774, 3.11109}, 
                     {-0.308091, -1.42369, 3.13848}}], 
                 Line[{{-0.31857, -1.21141, 3.20796}, 
                     {-0.228068, -1.37839, 3.27064}}], 
                 Line[{{-0.304348, -1.16997, 3.29785}, 
                     {-0.165397, -1.27378, 3.39743}}], 
                 Line[{{-0.306565, -1.10232, 3.37147}, 
                     {-0.148605, -1.11159, 3.49379}}], 
                 Line[{{-0.337487, -1.01921, 3.41769}, 
                     {-0.204893, -0.92203, 3.5316}}]}}}}, BoxRatios -> {1, 1, 4}]
;[o]
-Graphics3D-
^*)