#include <Windows.h>
#include <winternl.h>

#include "GetNtdllProcAddressH.hpp"


UINT32 CRC32B(LPCSTR cString)
{

	UINT32      uMask = 0x00,
		uHash = 0xFFFFFFFF;
	INT         i = 0x00;

	while (cString[i] != 0) {

		uHash = uHash ^ (UINT32)cString[i];

		for (int ii = 0; ii < 8; ii++) {

			uMask = -1 * (uHash & 1);
			uHash = (uHash >> 1) ^ (0xEDB88320 & uMask);
		}

		i++;
	}

	return ~uHash;
}

FARPROC	GetNtdllProcAddressH(IN UINT uNtdllApiHash) {

	PPEB						pPeb					= NULL;
	PPEB_LDR_DATA				pLdr					= NULL;
	PLDR_DATA_TABLE_ENTRY		pDte					= NULL;
	HMODULE						hNtdll					= NULL;
	PBYTE						pBase					= NULL;
	PIMAGE_NT_HEADERS			pImgNtHdrs				= NULL;
	PIMAGE_EXPORT_DIRECTORY		pImgExportDir			= NULL;
	PDWORD						pdwFunctionNameArray	= NULL;
	PDWORD						pdwFunctionAddressArray = NULL;
	PWORD						pwFunctionOrdinalArray	= NULL;
	DWORD						dwImgExportDirSize		= 0x00;


	pPeb = (PPEB)__readgsqword(0x60);
	pLdr = (PPEB_LDR_DATA)(pPeb->Ldr);
	pDte = (PLDR_DATA_TABLE_ENTRY)(pLdr->InMemoryOrderModuleList.Flink);

	// Skip local exe image
	pDte	= *(PLDR_DATA_TABLE_ENTRY*)(pDte);
	
	// Fetch Ntdll's handle
	pBase = (PBYTE)(hNtdll = (HMODULE)pDte->Reserved2[0]);
	if (!pBase)
		return NULL;

	pImgNtHdrs = (PIMAGE_NT_HEADERS)(pBase + ((PIMAGE_DOS_HEADER)pBase)->e_lfanew);
	if (pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE)
		return NULL;

	pImgExportDir			= (PIMAGE_EXPORT_DIRECTORY)(pBase + pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].VirtualAddress);
	dwImgExportDirSize		= pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].Size;
	pdwFunctionNameArray	= (PDWORD)(pBase + pImgExportDir->AddressOfNames);
	pdwFunctionAddressArray = (PDWORD)(pBase + pImgExportDir->AddressOfFunctions);
	pwFunctionOrdinalArray	= (PWORD)(pBase + pImgExportDir->AddressOfNameOrdinals);

	for (DWORD i = 0; i < pImgExportDir->NumberOfFunctions; i++) {
		CHAR*	pFunctionName		= (CHAR*)(pBase + pdwFunctionNameArray[i]);
		PVOID	pFunctionAddress	= (PVOID)(pBase + pdwFunctionAddressArray[pwFunctionOrdinalArray[i]]);

		if (CRC32B(pFunctionName) == uNtdllApiHash) {
			/*
				No need to add forwarded-functions support bcz kdmapper only uses the following apis:
					* NtAddAtom
					* RtlAdjustPrivilege
					* NtLoadDriver
					* NtUnloadDriver
					
				Which are not forwarded functions
			*/
			return (FARPROC)pFunctionAddress;
		}
	}

	return NULL;
}


