// @NUL0x4C | @mrd0x : MalDevAcademy

#include <Windows.h>
#include <stdio.h>

#define     CRC_POLYNOMIAL      0xEDB88320
#define     STR                 "_CRC32"

CONST CHAR* g_StringsArray[] = {

    // Syscalls
    "NtOpenSection",
    "NtMapViewOfSection",
    "NtUnmapViewOfSection",
    "NtAllocateVirtualMemory",
    "NtProtectVirtualMemory",
    "NtFlushInstructionCache",

    // WinAPIs
    "LoadLibraryA",
    "AddVectoredExceptionHandler",
    "RemoveVectoredExceptionHandler",
    "SystemFunction032",
    "RtlAddFunctionTable",
    "VirtualProtect",
    "CreateTimerQueueTimer",
    "CreateTimerQueue",
    "InitializeCriticalSection",
    "EnterCriticalSection",
    "LeaveCriticalSection",
    NULL
};


UINT32 CRC32B(LPCSTR cString) {

    UINT32      uMask   = 0x00,
                uHash   = 0xFFFFEFFF;
    INT         i       = 0x00;

    while (cString[i] != 0) {

        uHash = uHash ^ (UINT32)cString[i];

        for (int ii = 0; ii < 8; ii++) {

            uMask = -1 * (uHash & 1);
            uHash = (uHash >> 1) ^ (CRC_POLYNOMIAL & uMask);
        }

        i++;
    }

    return ~uHash;
}


#define HASH(STR)    ( CRC32B( (LPCSTR)STR ) )


int main() {

    DWORD ii = 0;

    while (g_StringsArray[ii]) {
        printf("#define %s%s \t 0x%0.8X \n", g_StringsArray[ii], STR, HASH(g_StringsArray[ii]));
        ii++;
    }

    // Used in UnhookAllLoadedDlls
    printf("\n#define %s%s \t 0x%0.8X \n", "text", STR, HASH(".text"));

    // DLLs
    printf("#define %s%s \t 0x%0.8X \n", "win32udllA", STR, HASH("win32u.dll"));
    printf("#define %s%s \t 0x%0.8X \n", "win32udllW", STR, HASH(L"win32u.dll"));
    printf("#define %s%s \t 0x%0.8X \n", "ntdlldll", STR, HASH("ntdll.dll"));
    printf("#define %s%s \t 0x%0.8X \n", "advapi32dll", STR, HASH("advapi32.dll"));
    printf("\n#define %s%s \t 0x%0.8X \n", "kernel32dll", STR, HASH("kernel32.dll"));

}
